/* theme_button.c generated by valac 0.56.17, the Vala compiler
 * generated from theme_button.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_THEME_BUTTON (widgets_theme_button_get_type ())
#define WIDGETS_THEME_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_THEME_BUTTON, WidgetsThemeButton))
#define WIDGETS_THEME_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_THEME_BUTTON, WidgetsThemeButtonClass))
#define WIDGETS_IS_THEME_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_THEME_BUTTON))
#define WIDGETS_IS_THEME_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_THEME_BUTTON))
#define WIDGETS_THEME_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_THEME_BUTTON, WidgetsThemeButtonClass))

typedef struct _WidgetsThemeButton WidgetsThemeButton;
typedef struct _WidgetsThemeButtonClass WidgetsThemeButtonClass;
typedef struct _WidgetsThemeButtonPrivate WidgetsThemeButtonPrivate;
enum  {
	WIDGETS_THEME_BUTTON_0_PROPERTY,
	WIDGETS_THEME_BUTTON_NUM_PROPERTIES
};
static GParamSpec* widgets_theme_button_properties[WIDGETS_THEME_BUTTON_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define WIDGETS_TYPE_THEME_LIST (widgets_theme_list_get_type ())
#define WIDGETS_THEME_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_THEME_LIST, WidgetsThemeList))
#define WIDGETS_THEME_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_THEME_LIST, WidgetsThemeListClass))
#define WIDGETS_IS_THEME_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_THEME_LIST))
#define WIDGETS_IS_THEME_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_THEME_LIST))
#define WIDGETS_THEME_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_THEME_LIST, WidgetsThemeListClass))

typedef struct _WidgetsThemeList WidgetsThemeList;
typedef struct _WidgetsThemeListClass WidgetsThemeListClass;
typedef struct _WidgetsThemeListPrivate WidgetsThemeListPrivate;
enum  {
	WIDGETS_THEME_LIST_0_PROPERTY,
	WIDGETS_THEME_LIST_NUM_PROPERTIES
};
static GParamSpec* widgets_theme_list_properties[WIDGETS_THEME_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block47Data Block47Data;
enum  {
	WIDGETS_THEME_LIST_ACTIVE_THEME_SIGNAL,
	WIDGETS_THEME_LIST_NUM_SIGNALS
};
static guint widgets_theme_list_signals[WIDGETS_THEME_LIST_NUM_SIGNALS] = {0};

struct _WidgetsThemeButton {
	GtkEventBox parent_instance;
	WidgetsThemeButtonPrivate * priv;
	cairo_surface_t* active_theme_border_surface;
	cairo_surface_t* dark_theme_border_surface;
	cairo_surface_t* light_theme_border_surface;
	GdkRGBA background_color;
	GdkRGBA prompt_color_host;
	GdkRGBA prompt_color_path;
	GdkRGBA foreground_color;
	GKeyFile* theme_file;
	gboolean is_active;
	gboolean is_light_color;
	gint background_padding;
	gint border_padding;
	gint button_radius;
	gint content_font_size;
	gint content_padding_x;
	gint content_padding_y;
	gint title_font_size;
	gint title_padding_x;
	gint title_padding_y;
	gchar* theme_name;
};

struct _WidgetsThemeButtonClass {
	GtkEventBoxClass parent_class;
};

struct _WidgetsThemeList {
	GtkVBox parent_instance;
	WidgetsThemeListPrivate * priv;
	gint theme_button_padding;
	GeeHashMap* theme_button_map;
	WidgetsThemeButton* active_theme_button;
};

struct _WidgetsThemeListClass {
	GtkVBoxClass parent_class;
};

struct _Block47Data {
	int _ref_count_;
	WidgetsThemeList* self;
	gchar* theme_name;
};

static gpointer widgets_theme_button_parent_class = NULL;
VALA_EXTERN gint constant_THEME_BUTTON_WIDTH;
VALA_EXTERN gint constant_THEME_BUTTON_HEIGHT;
VALA_EXTERN gint constant_THEME_SLIDER_WIDTH;
static gpointer widgets_theme_list_parent_class = NULL;
VALA_EXTERN gint constant_THEME_BUTTON_PADDING;

VALA_EXTERN GType widgets_theme_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsThemeButton, g_object_unref)
VALA_EXTERN WidgetsThemeButton* widgets_theme_button_new (const gchar* name);
VALA_EXTERN WidgetsThemeButton* widgets_theme_button_construct (GType object_type,
                                                    const gchar* name);
VALA_EXTERN gchar* utils_get_theme_path (const gchar* theme_name);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN gboolean utils_is_light_color (const gchar* color_string);
VALA_EXTERN cairo_surface_t* utils_create_image_surface (const gchar* surface_path);
static gboolean widgets_theme_button_on_draw (WidgetsThemeButton* self,
                                       GtkWidget* widget,
                                       cairo_t* cr);
static gboolean _widgets_theme_button_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                        cairo_t* cr,
                                                        gpointer self);
VALA_EXTERN void widgets_theme_button_active (WidgetsThemeButton* self);
VALA_EXTERN void widgets_theme_button_inactive (WidgetsThemeButton* self);
VALA_EXTERN void draw_clip_rounded_rectangle (cairo_t* cr,
                                  gint x,
                                  gint y,
                                  gint width,
                                  gint height,
                                  gdouble r);
VALA_EXTERN void draw_fill_rounded_rectangle (cairo_t* cr,
                                  gint x,
                                  gint y,
                                  gint width,
                                  gint height,
                                  gdouble r);
VALA_EXTERN void draw_set_context_source_color (cairo_t* cr,
                                    GdkRGBA* rgba);
VALA_EXTERN void draw_draw_text (cairo_t* cr,
                     const gchar* text,
                     gint x,
                     gint y,
                     gint width,
                     gint height,
                     gint size,
                     PangoAlignment horizontal_alignment,
                     const gchar* vertical_align,
                     gint* wrap_width);
VALA_EXTERN gint draw_get_text_render_width (cairo_t* cr,
                                 const gchar* text,
                                 gint width,
                                 gint height,
                                 gint size,
                                 PangoAlignment horizontal_alignment,
                                 const gchar* vertical_align,
                                 gint* wrap_width);
VALA_EXTERN void draw_draw_surface (cairo_t* cr,
                        cairo_surface_t* surface,
                        gint x,
                        gint y,
                        gint width,
                        gint height);
static void widgets_theme_button_finalize (GObject * obj);
static GType widgets_theme_button_get_type_once (void);
VALA_EXTERN GType widgets_theme_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsThemeList, g_object_unref)
VALA_EXTERN WidgetsThemeList* widgets_theme_list_new (const gchar* default_theme);
VALA_EXTERN WidgetsThemeList* widgets_theme_list_construct (GType object_type,
                                                const gchar* default_theme);
VALA_EXTERN GeeArrayList* utils_list_files (const gchar* path);
VALA_EXTERN gchar* utils_get_theme_dir (void);
VALA_EXTERN gchar* utils_get_additional_theme_dir (void);
VALA_EXTERN gint widgets_theme_list_compare_color_brightness (const gchar* a,
                                                  const gchar* b);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
static gboolean ____lambda106_ (Block47Data* _data47_,
                         GtkWidget* w,
                         GdkEventButton* e);
VALA_EXTERN gboolean utils_is_left_button (GdkEventButton* event);
VALA_EXTERN void widgets_theme_list_active_button (WidgetsThemeList* self,
                                       const gchar* theme_name);
static gboolean _____lambda106__gtk_widget_button_press_event (GtkWidget* _sender,
                                                        GdkEventButton* event,
                                                        gpointer self);
VALA_EXTERN gdouble utils_get_color_brightness (const gchar* color_string);
static void widgets_theme_list_finalize (GObject * obj);
static GType widgets_theme_list_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
_widgets_theme_button_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                               cairo_t* cr,
                                               gpointer self)
{
	gboolean result;
	result = widgets_theme_button_on_draw ((WidgetsThemeButton*) self, _sender, cr);
	return result;
}

WidgetsThemeButton*
widgets_theme_button_construct (GType object_type,
                                const gchar* name)
{
	WidgetsThemeButton * self = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (WidgetsThemeButton*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->theme_name);
	self->theme_name = _tmp0_;
	{
		GKeyFile* _tmp1_;
		GKeyFile* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		GKeyFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GdkRGBA _tmp11_ = {0};
		gchar* _tmp12_ = NULL;
		GKeyFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		GKeyFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GdkRGBA _tmp22_ = {0};
		gchar* _tmp23_ = NULL;
		GKeyFile* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GdkRGBA _tmp28_ = {0};
		gchar* _tmp29_ = NULL;
		GKeyFile* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		GdkRGBA _tmp34_ = {0};
		cairo_surface_t* _tmp35_;
		cairo_surface_t* _tmp36_;
		cairo_surface_t* _tmp37_;
		_tmp1_ = g_key_file_new ();
		_g_key_file_unref0 (self->theme_file);
		self->theme_file = _tmp1_;
		_tmp2_ = self->theme_file;
		_tmp3_ = self->theme_name;
		_tmp4_ = utils_get_theme_path (_tmp3_);
		_tmp5_ = _tmp4_;
		g_key_file_load_from_file (_tmp2_, _tmp5_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->theme_file;
		_tmp8_ = g_key_file_get_string (_tmp7_, "theme", "background", &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = string_strip (_tmp6_);
		_tmp10_ = _tmp9_;
		utils_hex_to_rgba (_tmp10_, 1.0, &_tmp11_);
		self->background_color = _tmp11_;
		_g_free0 (_tmp10_);
		_tmp13_ = self->theme_file;
		_tmp14_ = g_key_file_get_string (_tmp13_, "theme", "background", &_inner_error0_);
		_tmp12_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp6_);
			goto __catch0_g_error;
		}
		_tmp15_ = string_strip (_tmp12_);
		_tmp16_ = _tmp15_;
		self->is_light_color = utils_is_light_color (_tmp16_);
		_g_free0 (_tmp16_);
		self->background_color.alpha = 0.8;
		_tmp18_ = self->theme_file;
		_tmp19_ = g_key_file_get_string (_tmp18_, "theme", "foreground", &_inner_error0_);
		_tmp17_ = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp12_);
			_g_free0 (_tmp6_);
			goto __catch0_g_error;
		}
		_tmp20_ = string_strip (_tmp17_);
		_tmp21_ = _tmp20_;
		utils_hex_to_rgba (_tmp21_, 1.0, &_tmp22_);
		self->foreground_color = _tmp22_;
		_g_free0 (_tmp21_);
		_tmp24_ = self->theme_file;
		_tmp25_ = g_key_file_get_string (_tmp24_, "theme", "color_11", &_inner_error0_);
		_tmp23_ = _tmp25_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp6_);
			goto __catch0_g_error;
		}
		_tmp26_ = string_strip (_tmp23_);
		_tmp27_ = _tmp26_;
		utils_hex_to_rgba (_tmp27_, 1.0, &_tmp28_);
		self->prompt_color_host = _tmp28_;
		_g_free0 (_tmp27_);
		_tmp30_ = self->theme_file;
		_tmp31_ = g_key_file_get_string (_tmp30_, "theme", "color_13", &_inner_error0_);
		_tmp29_ = _tmp31_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp23_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp6_);
			goto __catch0_g_error;
		}
		_tmp32_ = string_strip (_tmp29_);
		_tmp33_ = _tmp32_;
		utils_hex_to_rgba (_tmp33_, 1.0, &_tmp34_);
		self->prompt_color_path = _tmp34_;
		_g_free0 (_tmp33_);
		_tmp35_ = utils_create_image_surface ("dark_theme_border.svg");
		_cairo_surface_destroy0 (self->dark_theme_border_surface);
		self->dark_theme_border_surface = _tmp35_;
		_tmp36_ = utils_create_image_surface ("light_theme_border.svg");
		_cairo_surface_destroy0 (self->light_theme_border_surface);
		self->light_theme_border_surface = _tmp36_;
		_tmp37_ = utils_create_image_surface ("active_theme_border.svg");
		_cairo_surface_destroy0 (self->active_theme_border_surface);
		self->active_theme_border_surface = _tmp37_;
		_g_free0 (_tmp29_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_print ("ThemeButton: %s\n", _tmp39_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	gtk_widget_set_size_request ((GtkWidget*) self, constant_THEME_BUTTON_WIDTH, constant_THEME_BUTTON_HEIGHT);
	gtk_widget_set_margin_start ((GtkWidget*) self, (constant_THEME_SLIDER_WIDTH - constant_THEME_BUTTON_WIDTH) / 2);
	gtk_widget_set_margin_end ((GtkWidget*) self, (constant_THEME_SLIDER_WIDTH - constant_THEME_BUTTON_WIDTH) / 2);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_theme_button_on_draw_gtk_widget_draw, self, 0);
	return self;
}

WidgetsThemeButton*
widgets_theme_button_new (const gchar* name)
{
	return widgets_theme_button_construct (WIDGETS_TYPE_THEME_BUTTON, name);
}

void
widgets_theme_button_active (WidgetsThemeButton* self)
{
	g_return_if_fail (self != NULL);
	self->is_active = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

void
widgets_theme_button_inactive (WidgetsThemeButton* self)
{
	g_return_if_fail (self != NULL);
	self->is_active = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gboolean
widgets_theme_button_on_draw (WidgetsThemeButton* self,
                              GtkWidget* widget,
                              cairo_t* cr)
{
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	gint clip_width = 0;
	GtkAllocation _tmp1_;
	gint clip_height = 0;
	GtkAllocation _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	GdkRGBA _tmp6_;
	gchar* prompt_host = NULL;
	gchar* _tmp7_;
	gchar* prompt_path = NULL;
	gchar* _tmp8_;
	GdkRGBA _tmp9_;
	const gchar* _tmp10_;
	GtkAllocation _tmp11_;
	GtkAllocation _tmp12_;
	gint prompt_host_width = 0;
	const gchar* _tmp13_;
	GdkRGBA _tmp14_;
	const gchar* _tmp15_;
	GtkAllocation _tmp16_;
	GtkAllocation _tmp17_;
	gint prompt_host_n_path_width = 0;
	const gchar* _tmp18_;
	GdkRGBA _tmp19_;
	GtkAllocation _tmp20_;
	GtkAllocation _tmp21_;
	GdkRGBA _tmp22_;
	const gchar* _tmp23_;
	GtkAllocation _tmp24_;
	GtkAllocation _tmp25_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation (widget, &_tmp0_);
	rect = _tmp0_;
	_tmp1_ = rect;
	clip_width = _tmp1_.width - (self->background_padding * 2);
	_tmp2_ = rect;
	clip_height = _tmp2_.height - (self->background_padding * 2);
	cairo_save (cr);
	if (gtk_widget_get_scale_factor ((GtkWidget*) self) > 1) {
		draw_clip_rounded_rectangle (cr, self->background_padding, self->background_padding, clip_width, clip_height, (gdouble) ((self->button_radius / gtk_widget_get_scale_factor ((GtkWidget*) self)) + 1));
	}
	_tmp3_ = self->background_color;
	_tmp4_ = self->background_color;
	_tmp5_ = self->background_color;
	_tmp6_ = self->background_color;
	cairo_set_source_rgba (cr, _tmp3_.red, _tmp4_.green, _tmp5_.blue, _tmp6_.alpha);
	draw_fill_rounded_rectangle (cr, self->background_padding, self->background_padding, clip_width, clip_height, (gdouble) (self->button_radius / gtk_widget_get_scale_factor ((GtkWidget*) self)));
	cairo_restore (cr);
	_tmp7_ = g_strdup ("dde@linux:");
	prompt_host = _tmp7_;
	_tmp8_ = g_strdup ("~/Theme");
	prompt_path = _tmp8_;
	_tmp9_ = self->prompt_color_host;
	draw_set_context_source_color (cr, &_tmp9_);
	_tmp10_ = prompt_host;
	_tmp11_ = rect;
	_tmp12_ = rect;
	draw_draw_text (cr, _tmp10_, self->title_padding_x, self->title_padding_y, _tmp11_.width, _tmp12_.height, self->title_font_size, PANGO_ALIGN_LEFT, "top", NULL);
	_tmp13_ = prompt_host;
	prompt_host_width = draw_get_text_render_width (cr, _tmp13_, clip_width, clip_height, self->title_font_size, PANGO_ALIGN_LEFT, "middle", NULL);
	_tmp14_ = self->prompt_color_path;
	draw_set_context_source_color (cr, &_tmp14_);
	_tmp15_ = prompt_path;
	_tmp16_ = rect;
	_tmp17_ = rect;
	draw_draw_text (cr, _tmp15_, self->title_padding_x + prompt_host_width, self->title_padding_y, _tmp16_.width, _tmp17_.height, self->title_font_size, PANGO_ALIGN_LEFT, "top", NULL);
	_tmp18_ = prompt_path;
	prompt_host_n_path_width = draw_get_text_render_width (cr, _tmp18_, clip_width, clip_height, self->title_font_size, PANGO_ALIGN_LEFT, "middle", NULL) + prompt_host_width;
	_tmp19_ = self->foreground_color;
	draw_set_context_source_color (cr, &_tmp19_);
	_tmp20_ = rect;
	_tmp21_ = rect;
	draw_draw_text (cr, "$ _", self->title_padding_x + prompt_host_n_path_width, self->title_padding_y, _tmp20_.width, _tmp21_.height, self->title_font_size, PANGO_ALIGN_LEFT, "top", NULL);
	_tmp22_ = self->foreground_color;
	draw_set_context_source_color (cr, &_tmp22_);
	_tmp23_ = self->theme_name;
	_tmp24_ = rect;
	_tmp25_ = rect;
	draw_draw_text (cr, _tmp23_, self->content_padding_x, self->content_padding_y, _tmp24_.width, _tmp25_.height, self->content_font_size, PANGO_ALIGN_LEFT, "top", NULL);
	if (self->is_active) {
		cairo_surface_t* _tmp26_;
		_tmp26_ = self->active_theme_border_surface;
		draw_draw_surface (cr, _tmp26_, 0, 0, 0, 0);
	} else {
		if (self->is_light_color) {
			cairo_surface_t* _tmp27_;
			_tmp27_ = self->light_theme_border_surface;
			draw_draw_surface (cr, _tmp27_, self->border_padding, self->border_padding, 0, 0);
		} else {
			cairo_surface_t* _tmp28_;
			_tmp28_ = self->dark_theme_border_surface;
			draw_draw_surface (cr, _tmp28_, self->border_padding, self->border_padding, 0, 0);
		}
	}
	result = TRUE;
	_g_free0 (prompt_path);
	_g_free0 (prompt_host);
	return result;
}

static void
widgets_theme_button_class_init (WidgetsThemeButtonClass * klass,
                                 gpointer klass_data)
{
	widgets_theme_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_theme_button_finalize;
}

static void
widgets_theme_button_instance_init (WidgetsThemeButton * self,
                                    gpointer klass)
{
	self->is_active = FALSE;
	self->background_padding = 2;
	self->border_padding = 1;
	self->button_radius = 5;
	self->content_font_size = 11;
	self->content_padding_x = 14;
	self->content_padding_y = 25;
	self->title_font_size = 11;
	self->title_padding_x = 14;
	self->title_padding_y = 6;
}

static void
widgets_theme_button_finalize (GObject * obj)
{
	WidgetsThemeButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_THEME_BUTTON, WidgetsThemeButton);
	_cairo_surface_destroy0 (self->active_theme_border_surface);
	_cairo_surface_destroy0 (self->dark_theme_border_surface);
	_cairo_surface_destroy0 (self->light_theme_border_surface);
	_g_key_file_unref0 (self->theme_file);
	_g_free0 (self->theme_name);
	G_OBJECT_CLASS (widgets_theme_button_parent_class)->finalize (obj);
}

static GType
widgets_theme_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsThemeButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_theme_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsThemeButton), 0, (GInstanceInitFunc) widgets_theme_button_instance_init, NULL };
	GType widgets_theme_button_type_id;
	widgets_theme_button_type_id = g_type_register_static (gtk_event_box_get_type (), "WidgetsThemeButton", &g_define_type_info, 0);
	return widgets_theme_button_type_id;
}

GType
widgets_theme_button_get_type (void)
{
	static volatile gsize widgets_theme_button_type_id__once = 0;
	if (g_once_init_enter (&widgets_theme_button_type_id__once)) {
		GType widgets_theme_button_type_id;
		widgets_theme_button_type_id = widgets_theme_button_get_type_once ();
		g_once_init_leave (&widgets_theme_button_type_id__once, widgets_theme_button_type_id);
	}
	return widgets_theme_button_type_id__once;
}

static Block47Data*
block47_data_ref (Block47Data* _data47_)
{
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}

static void
block47_data_unref (void * _userdata_)
{
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		WidgetsThemeList* self;
		self = _data47_->self;
		_g_free0 (_data47_->theme_name);
		_g_object_unref0 (self);
		g_slice_free (Block47Data, _data47_);
	}
}

static gboolean
____lambda106_ (Block47Data* _data47_,
                GtkWidget* w,
                GdkEventButton* e)
{
	WidgetsThemeList* self;
	gboolean result;
	self = _data47_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (utils_is_left_button (e)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = _data47_->theme_name;
		widgets_theme_list_active_button (self, _tmp0_);
		_tmp1_ = _data47_->theme_name;
		g_signal_emit (self, widgets_theme_list_signals[WIDGETS_THEME_LIST_ACTIVE_THEME_SIGNAL], 0, _tmp1_);
	}
	result = FALSE;
	return result;
}

static gboolean
_____lambda106__gtk_widget_button_press_event (GtkWidget* _sender,
                                               GdkEventButton* event,
                                               gpointer self)
{
	gboolean result;
	result = ____lambda106_ (self, _sender, event);
	return result;
}

WidgetsThemeList*
widgets_theme_list_construct (GType object_type,
                              const gchar* default_theme)
{
	WidgetsThemeList * self = NULL;
	GeeHashMap* _tmp0_;
	GeeArrayList* theme_names = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* additional_theme_names = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	g_return_val_if_fail (default_theme != NULL, NULL);
	self = (WidgetsThemeList*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, WIDGETS_TYPE_THEME_BUTTON, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->theme_button_map);
	self->theme_button_map = _tmp0_;
	_tmp1_ = utils_get_theme_dir ();
	_tmp2_ = _tmp1_;
	_tmp3_ = utils_list_files (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	theme_names = _tmp4_;
	_tmp5_ = utils_get_additional_theme_dir ();
	_tmp6_ = _tmp5_;
	_tmp7_ = utils_list_files (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	additional_theme_names = _tmp8_;
	_tmp9_ = theme_names;
	_tmp10_ = additional_theme_names;
	gee_array_list_add_all (_tmp9_, (GeeCollection*) _tmp10_);
	_tmp11_ = theme_names;
	gee_list_sort ((GeeList*) _tmp11_, (GCompareDataFunc) widgets_theme_list_compare_color_brightness, NULL, NULL);
	{
		GeeArrayList* _theme_name_list = NULL;
		GeeArrayList* _tmp12_;
		gint _theme_name_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _theme_name_index = 0;
		_tmp12_ = theme_names;
		_theme_name_list = _tmp12_;
		_tmp13_ = _theme_name_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_theme_name_size = _tmp15_;
		_theme_name_index = -1;
		while (TRUE) {
			Block47Data* _data47_;
			gint _tmp16_;
			gint _tmp17_;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			WidgetsThemeButton* button = NULL;
			const gchar* _tmp20_;
			WidgetsThemeButton* _tmp21_;
			WidgetsThemeButton* _tmp22_;
			WidgetsThemeButton* _tmp23_;
			GeeHashMap* _tmp24_;
			const gchar* _tmp25_;
			WidgetsThemeButton* _tmp26_;
			_data47_ = g_slice_new0 (Block47Data);
			_data47_->_ref_count_ = 1;
			_data47_->self = g_object_ref (self);
			_theme_name_index = _theme_name_index + 1;
			_tmp16_ = _theme_name_index;
			_tmp17_ = _theme_name_size;
			if (!(_tmp16_ < _tmp17_)) {
				block47_data_unref (_data47_);
				_data47_ = NULL;
				break;
			}
			_tmp18_ = _theme_name_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _theme_name_index);
			_data47_->theme_name = (gchar*) _tmp19_;
			_tmp20_ = _data47_->theme_name;
			_tmp21_ = widgets_theme_button_new (_tmp20_);
			g_object_ref_sink (_tmp21_);
			button = _tmp21_;
			_tmp22_ = button;
			gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp22_, FALSE, FALSE, (guint) self->theme_button_padding);
			_tmp23_ = button;
			g_signal_connect_data ((GtkWidget*) _tmp23_, "button-press-event", (GCallback) _____lambda106__gtk_widget_button_press_event, block47_data_ref (_data47_), (GClosureNotify) block47_data_unref, 0);
			_tmp24_ = self->theme_button_map;
			_tmp25_ = _data47_->theme_name;
			_tmp26_ = button;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, _tmp25_, _tmp26_);
			_g_object_unref0 (button);
			block47_data_unref (_data47_);
			_data47_ = NULL;
		}
	}
	widgets_theme_list_active_button (self, default_theme);
	_g_object_unref0 (additional_theme_names);
	_g_object_unref0 (theme_names);
	return self;
}

WidgetsThemeList*
widgets_theme_list_new (const gchar* default_theme)
{
	return widgets_theme_list_construct (WIDGETS_TYPE_THEME_LIST, default_theme);
}

gint
widgets_theme_list_compare_color_brightness (const gchar* a,
                                             const gchar* b)
{
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	{
		GKeyFile* a_theme_file = NULL;
		GKeyFile* _tmp0_;
		GKeyFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		GKeyFile* _tmp5_;
		gchar* _tmp6_;
		gdouble a_background_color = 0.0;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gdouble _tmp9_;
		GKeyFile* b_theme_file = NULL;
		GKeyFile* _tmp10_;
		GKeyFile* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		GKeyFile* _tmp15_;
		gchar* _tmp16_;
		gdouble b_background_color = 0.0;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gdouble _tmp19_;
		_tmp0_ = g_key_file_new ();
		a_theme_file = _tmp0_;
		_tmp1_ = a_theme_file;
		_tmp2_ = utils_get_theme_path ((const gchar*) a);
		_tmp3_ = _tmp2_;
		g_key_file_load_from_file (_tmp1_, _tmp3_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (a_theme_file);
			goto __catch0_g_error;
		}
		_tmp5_ = a_theme_file;
		_tmp6_ = g_key_file_get_string (_tmp5_, "theme", "background", &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (a_theme_file);
			goto __catch0_g_error;
		}
		_tmp7_ = string_strip (_tmp4_);
		_tmp8_ = _tmp7_;
		_tmp9_ = utils_get_color_brightness (_tmp8_);
		_g_free0 (_tmp8_);
		a_background_color = _tmp9_;
		_tmp10_ = g_key_file_new ();
		b_theme_file = _tmp10_;
		_tmp11_ = b_theme_file;
		_tmp12_ = utils_get_theme_path ((const gchar*) b);
		_tmp13_ = _tmp12_;
		g_key_file_load_from_file (_tmp11_, _tmp13_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp13_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (b_theme_file);
			_g_free0 (_tmp4_);
			_g_key_file_unref0 (a_theme_file);
			goto __catch0_g_error;
		}
		_tmp15_ = b_theme_file;
		_tmp16_ = g_key_file_get_string (_tmp15_, "theme", "background", &_inner_error0_);
		_tmp14_ = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (b_theme_file);
			_g_free0 (_tmp4_);
			_g_key_file_unref0 (a_theme_file);
			goto __catch0_g_error;
		}
		_tmp17_ = string_strip (_tmp14_);
		_tmp18_ = _tmp17_;
		_tmp19_ = utils_get_color_brightness (_tmp18_);
		_g_free0 (_tmp18_);
		b_background_color = _tmp19_;
		if (a_background_color > b_background_color) {
			result = 1;
			_g_free0 (_tmp14_);
			_g_key_file_unref0 (b_theme_file);
			_g_free0 (_tmp4_);
			_g_key_file_unref0 (a_theme_file);
			return result;
		}
		if (a_background_color == b_background_color) {
			result = 0;
			_g_free0 (_tmp14_);
			_g_key_file_unref0 (b_theme_file);
			_g_free0 (_tmp4_);
			_g_key_file_unref0 (a_theme_file);
			return result;
		}
		_g_free0 (_tmp14_);
		_g_key_file_unref0 (b_theme_file);
		_g_free0 (_tmp4_);
		_g_key_file_unref0 (a_theme_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_print ("compare_color_brightness: %s\n", _tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp22_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp22_;
	}
	result = -1;
	return result;
}

void
widgets_theme_list_active_button (WidgetsThemeList* self,
                                  const gchar* theme_name)
{
	WidgetsThemeButton* _tmp0_;
	GeeHashMap* _tmp2_;
	WidgetsThemeButton* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme_name != NULL);
	_tmp0_ = self->active_theme_button;
	if (_tmp0_ != NULL) {
		WidgetsThemeButton* _tmp1_;
		_tmp1_ = self->active_theme_button;
		widgets_theme_button_inactive (_tmp1_);
	}
	_tmp2_ = self->theme_button_map;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, theme_name)) {
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->theme_button_map;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, theme_name);
		_g_object_unref0 (self->active_theme_button);
		self->active_theme_button = (WidgetsThemeButton*) _tmp4_;
	} else {
		GeeHashMap* _tmp5_;
		gpointer _tmp6_;
		_tmp5_ = self->theme_button_map;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, "deepin");
		_g_object_unref0 (self->active_theme_button);
		self->active_theme_button = (WidgetsThemeButton*) _tmp6_;
	}
	_tmp7_ = self->active_theme_button;
	widgets_theme_button_active (_tmp7_);
}

static void
widgets_theme_list_class_init (WidgetsThemeListClass * klass,
                               gpointer klass_data)
{
	widgets_theme_list_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_theme_list_finalize;
	widgets_theme_list_signals[WIDGETS_THEME_LIST_ACTIVE_THEME_SIGNAL] = g_signal_new ("active-theme", WIDGETS_TYPE_THEME_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
widgets_theme_list_instance_init (WidgetsThemeList * self,
                                  gpointer klass)
{
	self->theme_button_padding = constant_THEME_BUTTON_PADDING;
	self->active_theme_button = NULL;
}

static void
widgets_theme_list_finalize (GObject * obj)
{
	WidgetsThemeList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_THEME_LIST, WidgetsThemeList);
	_g_object_unref0 (self->theme_button_map);
	_g_object_unref0 (self->active_theme_button);
	G_OBJECT_CLASS (widgets_theme_list_parent_class)->finalize (obj);
}

static GType
widgets_theme_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsThemeListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_theme_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsThemeList), 0, (GInstanceInitFunc) widgets_theme_list_instance_init, NULL };
	GType widgets_theme_list_type_id;
	widgets_theme_list_type_id = g_type_register_static (gtk_vbox_get_type (), "WidgetsThemeList", &g_define_type_info, 0);
	return widgets_theme_list_type_id;
}

GType
widgets_theme_list_get_type (void)
{
	static volatile gsize widgets_theme_list_type_id__once = 0;
	if (g_once_init_enter (&widgets_theme_list_type_id__once)) {
		GType widgets_theme_list_type_id;
		widgets_theme_list_type_id = widgets_theme_list_get_type_once ();
		g_once_init_leave (&widgets_theme_list_type_id__once, widgets_theme_list_type_id);
	}
	return widgets_theme_list_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

