/* application.c generated by valac 0.56.18, the Vala compiler
 * generated from application.vala, do not modify */

#include "libdino.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <gio/gio.h>
#include "xmpp-vala.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _qlite_database_unref0(var) ((var == NULL) ? NULL : (var = (qlite_database_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _xmpp_jid_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_jid_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

VALA_EXTERN gchar* dino_application_print_xmpp;
gchar* dino_application_print_xmpp = NULL;

static void __lambda145_ (DinoApplication* self);
static void dino_application_restore (DinoApplication* self);
static void ___lambda145__g_application_startup (GApplication* _sender,
                                          gpointer self);
static void __lambda146_ (DinoApplication* self);
static void ___lambda146__g_application_shutdown (GApplication* _sender,
                                           gpointer self);
static void __lambda147_ (DinoApplication* self,
                   GFile** files,
                   gint files_length1,
                   const gchar* hint);
static void ___lambda147__g_application_open (GApplication* _sender,
                                       GFile** files,
                                       gint n_files,
                                       const gchar* hint,
                                       gpointer self);
static void __lambda144_ (DinoApplication* self,
                   GVariant* variant);
static void ___lambda144__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
static GType dino_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry DINO_APPLICATION_options[2] = {{"print-xmpp", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &dino_application_print_xmpp, "Print XMPP stanzas identified by DESC to stderr", "DESC"}, {NULL}};

gchar*
dino_get_version (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (DINO_VERSION);
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
dino_get_short_version (void)
{
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	if (!string_contains (DINO_VERSION, "~")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (DINO_VERSION);
		result = _tmp0_;
		return result;
	}
	_tmp2_ = _tmp1_ = g_strsplit (DINO_VERSION, "~", 0);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	_tmp4_ = _tmp3_[0];
	_tmp5_ = g_strconcat (_tmp4_, "+", NULL);
	_tmp6_ = _tmp5_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp6_;
	return result;
}

void
dino_application_handle_uri (DinoApplication* self,
                             const gchar* jid,
                             const gchar* query,
                             GeeMap* options)
{
	DinoApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DINO_APPLICATION_GET_INTERFACE (self);
	if (_iface_->handle_uri) {
		_iface_->handle_uri (self, jid, query, options);
	}
}

static void
__lambda145_ (DinoApplication* self)
{
	DinoStreamInteractor* _tmp0_;
	DinoStreamInteractor* _tmp1_;
	DinoConnectionManager* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = dino_application_get_stream_interactor (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->connection_manager;
	_tmp3_ = dino_application_print_xmpp;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_tmp2_->log_options);
	_tmp2_->log_options = _tmp4_;
	dino_application_restore (self);
}

static void
___lambda145__g_application_startup (GApplication* _sender,
                                     gpointer self)
{
	__lambda145_ ((DinoApplication*) self);
}

static void
__lambda146_ (DinoApplication* self)
{
	DinoStreamInteractor* _tmp0_;
	DinoStreamInteractor* _tmp1_;
	DinoConnectionManager* _tmp2_;
	_tmp0_ = dino_application_get_stream_interactor (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->connection_manager;
	dino_connection_manager_make_offline_all (_tmp2_);
}

static void
___lambda146__g_application_shutdown (GApplication* _sender,
                                      gpointer self)
{
	__lambda146_ ((DinoApplication*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
__lambda147_ (DinoApplication* self,
              GFile** files,
              gint files_length1,
              const gchar* hint)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* uri = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* r = NULL;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** m = NULL;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint m_length1;
	gint _m_size_;
	gchar* jid = NULL;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* query = NULL;
	gchar* _tmp30_;
	GeeMap* options = NULL;
	GeeHashMap* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	GeeMap* _tmp60_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (hint != NULL);
	if (files_length1 != 1) {
		g_warning ("application.vala:74: Can't handle more than one URI at once.");
		return;
	}
	_tmp0_ = files[0];
	_tmp1_ = _g_object_ref0 (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	if (!g_file_has_uri_scheme (_tmp2_, "xmpp")) {
		g_warning ("application.vala:79: xmpp:-URI expected");
		_g_object_unref0 (file);
		return;
	}
	_tmp3_ = file;
	_tmp4_ = g_file_get_uri (_tmp3_);
	uri = _tmp4_;
	_tmp5_ = uri;
	if (!string_contains (_tmp5_, ":")) {
		g_warning ("application.vala:84: Invalid URI");
		_g_free0 (uri);
		_g_object_unref0 (file);
		return;
	}
	_tmp6_ = uri;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ":", 2);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _vala_array_length (_tmp7_);
	_tmp10_ = _tmp9_[1];
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	r = _tmp12_;
	_tmp13_ = r;
	_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "?", 2);
	m = _tmp15_;
	m_length1 = _vala_array_length (_tmp14_);
	_m_size_ = m_length1;
	_tmp16_ = m;
	_tmp16__length1 = m_length1;
	_tmp17_ = _tmp16_[0];
	_tmp18_ = g_strdup (_tmp17_);
	jid = _tmp18_;
	while (TRUE) {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp19_ = jid;
		if (!(string_get (_tmp19_, (glong) 0) == '/')) {
			break;
		}
		_tmp20_ = jid;
		_tmp21_ = string_substring (_tmp20_, (glong) 1, (glong) -1);
		_g_free0 (jid);
		jid = _tmp21_;
	}
	_tmp22_ = jid;
	_tmp23_ = g_uri_unescape_string (_tmp22_, NULL);
	_g_free0 (jid);
	jid = _tmp23_;
	{
		XmppJid* _tmp24_ = NULL;
		const gchar* _tmp25_;
		XmppJid* _tmp26_;
		gchar* _tmp27_;
		_tmp25_ = jid;
		_tmp26_ = xmpp_jid_new (_tmp25_, &_inner_error0_);
		_tmp24_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
				goto __catch0_xmpp_invalid_jid_error;
			}
			_g_free0 (jid);
			m = (_vala_array_free (m, m_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (r);
			_g_free0 (uri);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp27_ = xmpp_jid_to_string (_tmp24_);
		_g_free0 (jid);
		jid = _tmp27_;
		_xmpp_jid_unref0 (_tmp24_);
	}
	goto __finally0;
	__catch0_xmpp_invalid_jid_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_warning ("application.vala:97: Received invalid jid in xmpp:-URI: %s", _tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (jid);
		m = (_vala_array_free (m, m_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (r);
		_g_free0 (uri);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp30_ = g_strdup ("message");
	query = _tmp30_;
	_tmp31_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	options = (GeeMap*) _tmp31_;
	_tmp32_ = m;
	_tmp32__length1 = m_length1;
	if (_tmp32__length1 == 2) {
		gchar** cmds = NULL;
		gchar** _tmp33_;
		gint _tmp33__length1;
		const gchar* _tmp34_;
		gchar** _tmp35_;
		gchar** _tmp36_;
		gint cmds_length1;
		gint _cmds_size_;
		gchar** _tmp37_;
		gint _tmp37__length1;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp33_ = m;
		_tmp33__length1 = m_length1;
		_tmp34_ = _tmp33_[1];
		_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, ";", 0);
		cmds = _tmp36_;
		cmds_length1 = _vala_array_length (_tmp35_);
		_cmds_size_ = cmds_length1;
		_tmp37_ = cmds;
		_tmp37__length1 = cmds_length1;
		_tmp38_ = _tmp37_[0];
		_tmp39_ = g_strdup (_tmp38_);
		_g_free0 (query);
		query = _tmp39_;
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp40_ = FALSE;
				_tmp40_ = TRUE;
				while (TRUE) {
					gchar** _tmp42_;
					gint _tmp42__length1;
					gchar** opt = NULL;
					gchar** _tmp43_;
					gint _tmp43__length1;
					const gchar* _tmp44_;
					gchar** _tmp45_;
					gchar** _tmp46_;
					gint opt_length1;
					gint _opt_size_;
					gchar* _tmp47_ = NULL;
					gchar** _tmp48_;
					gint _tmp48__length1;
					GeeMap* _tmp53_;
					gchar** _tmp54_;
					gint _tmp54__length1;
					const gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					if (!_tmp40_) {
						gint _tmp41_;
						i = i + 1;
						_tmp41_ = i;
					}
					_tmp40_ = FALSE;
					_tmp42_ = cmds;
					_tmp42__length1 = cmds_length1;
					if (!(i < _tmp42__length1)) {
						break;
					}
					_tmp43_ = cmds;
					_tmp43__length1 = cmds_length1;
					_tmp44_ = _tmp43_[i];
					_tmp46_ = _tmp45_ = g_strsplit (_tmp44_, "=", 2);
					opt = _tmp46_;
					opt_length1 = _vala_array_length (_tmp45_);
					_opt_size_ = opt_length1;
					_tmp48_ = opt;
					_tmp48__length1 = opt_length1;
					if (_tmp48__length1 == 2) {
						gchar** _tmp49_;
						gint _tmp49__length1;
						const gchar* _tmp50_;
						gchar* _tmp51_;
						_tmp49_ = opt;
						_tmp49__length1 = opt_length1;
						_tmp50_ = _tmp49_[1];
						_tmp51_ = g_uri_unescape_string (_tmp50_, NULL);
						_g_free0 (_tmp47_);
						_tmp47_ = _tmp51_;
					} else {
						gchar* _tmp52_;
						_tmp52_ = g_strdup ("");
						_g_free0 (_tmp47_);
						_tmp47_ = _tmp52_;
					}
					_tmp53_ = options;
					_tmp54_ = opt;
					_tmp54__length1 = opt_length1;
					_tmp55_ = _tmp54_[0];
					_tmp56_ = g_uri_unescape_string (_tmp55_, NULL);
					_tmp57_ = _tmp56_;
					gee_map_set (_tmp53_, _tmp57_, _tmp47_);
					_g_free0 (_tmp57_);
					_g_free0 (_tmp47_);
					opt = (_vala_array_free (opt, opt_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
		cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
	}
	g_application_activate ((GApplication*) self);
	_tmp58_ = jid;
	_tmp59_ = query;
	_tmp60_ = options;
	dino_application_handle_uri (self, _tmp58_, _tmp59_, _tmp60_);
	_g_object_unref0 (options);
	_g_free0 (query);
	_g_free0 (jid);
	m = (_vala_array_free (m, m_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (r);
	_g_free0 (uri);
	_g_object_unref0 (file);
}

static void
___lambda147__g_application_open (GApplication* _sender,
                                  GFile** files,
                                  gint n_files,
                                  const gchar* hint,
                                  gpointer self)
{
	__lambda147_ ((DinoApplication*) self, files, n_files, hint);
}

void
dino_application_init (DinoApplication* self,
                       GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	DinoDatabase* _tmp13_;
	DinoDatabase* _tmp14_;
	DinoDatabase* _tmp15_;
	DinoDatabase* _tmp16_;
	DinoEntitiesSettings* _tmp17_;
	DinoEntitiesSettings* _tmp18_;
	DinoDatabase* _tmp19_;
	DinoDatabase* _tmp20_;
	DinoStreamInteractor* _tmp21_;
	DinoStreamInteractor* _tmp22_;
	DinoStreamInteractor* _tmp23_;
	DinoStreamInteractor* _tmp24_;
	DinoDatabase* _tmp25_;
	DinoDatabase* _tmp26_;
	DinoStreamInteractor* _tmp27_;
	DinoStreamInteractor* _tmp28_;
	DinoDatabase* _tmp29_;
	DinoDatabase* _tmp30_;
	DinoStreamInteractor* _tmp31_;
	DinoStreamInteractor* _tmp32_;
	DinoStreamInteractor* _tmp33_;
	DinoStreamInteractor* _tmp34_;
	DinoStreamInteractor* _tmp35_;
	DinoStreamInteractor* _tmp36_;
	DinoStreamInteractor* _tmp37_;
	DinoStreamInteractor* _tmp38_;
	DinoDatabase* _tmp39_;
	DinoDatabase* _tmp40_;
	DinoStreamInteractor* _tmp41_;
	DinoStreamInteractor* _tmp42_;
	DinoDatabase* _tmp43_;
	DinoDatabase* _tmp44_;
	DinoStreamInteractor* _tmp45_;
	DinoStreamInteractor* _tmp46_;
	DinoStreamInteractor* _tmp47_;
	DinoStreamInteractor* _tmp48_;
	DinoDatabase* _tmp49_;
	DinoDatabase* _tmp50_;
	DinoStreamInteractor* _tmp51_;
	DinoStreamInteractor* _tmp52_;
	DinoDatabase* _tmp53_;
	DinoDatabase* _tmp54_;
	DinoStreamInteractor* _tmp55_;
	DinoStreamInteractor* _tmp56_;
	DinoDatabase* _tmp57_;
	DinoDatabase* _tmp58_;
	DinoStreamInteractor* _tmp59_;
	DinoStreamInteractor* _tmp60_;
	DinoDatabase* _tmp61_;
	DinoDatabase* _tmp62_;
	DinoStreamInteractor* _tmp63_;
	DinoStreamInteractor* _tmp64_;
	DinoDatabase* _tmp65_;
	DinoDatabase* _tmp66_;
	DinoStreamInteractor* _tmp67_;
	DinoStreamInteractor* _tmp68_;
	DinoStreamInteractor* _tmp69_;
	DinoStreamInteractor* _tmp70_;
	DinoStreamInteractor* _tmp71_;
	DinoStreamInteractor* _tmp72_;
	DinoDatabase* _tmp73_;
	DinoDatabase* _tmp74_;
	DinoStreamInteractor* _tmp75_;
	DinoStreamInteractor* _tmp76_;
	DinoDatabase* _tmp77_;
	DinoDatabase* _tmp78_;
	DinoStreamInteractor* _tmp79_;
	DinoStreamInteractor* _tmp80_;
	DinoDatabase* _tmp81_;
	DinoDatabase* _tmp82_;
	DinoStreamInteractor* _tmp83_;
	DinoStreamInteractor* _tmp84_;
	DinoDatabase* _tmp85_;
	DinoDatabase* _tmp86_;
	DinoStreamInteractor* _tmp87_;
	DinoStreamInteractor* _tmp88_;
	DinoDatabase* _tmp89_;
	DinoDatabase* _tmp90_;
	DinoStreamInteractor* _tmp91_;
	DinoStreamInteractor* _tmp92_;
	DinoDatabase* _tmp93_;
	DinoDatabase* _tmp94_;
	DinoStreamInteractor* _tmp95_;
	DinoStreamInteractor* _tmp96_;
	DinoDatabase* _tmp97_;
	DinoDatabase* _tmp98_;
	DinoStreamInteractor* _tmp99_;
	DinoStreamInteractor* _tmp100_;
	DinoDatabase* _tmp101_;
	DinoDatabase* _tmp102_;
	DinoStreamInteractor* _tmp103_;
	DinoStreamInteractor* _tmp104_;
	DinoStreamInteractor* _tmp105_;
	DinoStreamInteractor* _tmp106_;
	DinoDatabase* _tmp107_;
	DinoDatabase* _tmp108_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = dino_application_get_storage_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_mkdir_with_parents (_tmp1_, 0700) == -1;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp3_ = dino_application_get_storage_dir ();
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%i", g_file_error_from_errno (errno));
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new ((GQuark) -1, 0, "Could not create storage dir \"%s\": %s", _tmp4_, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_inner_error0_ = _tmp8_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp9_ = dino_application_get_storage_dir ();
	_tmp10_ = _tmp9_;
	_tmp11_ = g_build_filename (_tmp10_, "dino.db", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = dino_database_new (_tmp12_);
	_tmp14_ = _tmp13_;
	dino_application_set_db (self, _tmp14_);
	_qlite_database_unref0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp15_ = dino_application_get_db (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = dino_entities_settings_new_from_db (_tmp16_);
	_tmp18_ = _tmp17_;
	dino_application_set_settings (self, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = dino_application_get_db (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = dino_stream_interactor_new (_tmp20_);
	_tmp22_ = _tmp21_;
	dino_application_set_stream_interactor (self, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = dino_application_get_stream_interactor (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = dino_application_get_db (self);
	_tmp26_ = _tmp25_;
	dino_message_processor_start (_tmp24_, _tmp26_);
	_tmp27_ = dino_application_get_stream_interactor (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = dino_application_get_db (self);
	_tmp30_ = _tmp29_;
	dino_message_storage_start (_tmp28_, _tmp30_);
	_tmp31_ = dino_application_get_stream_interactor (self);
	_tmp32_ = _tmp31_;
	dino_presence_manager_start (_tmp32_);
	_tmp33_ = dino_application_get_stream_interactor (self);
	_tmp34_ = _tmp33_;
	dino_counterpart_interaction_manager_start (_tmp34_);
	_tmp35_ = dino_application_get_stream_interactor (self);
	_tmp36_ = _tmp35_;
	dino_blocking_manager_start (_tmp36_);
	_tmp37_ = dino_application_get_stream_interactor (self);
	_tmp38_ = _tmp37_;
	_tmp39_ = dino_application_get_db (self);
	_tmp40_ = _tmp39_;
	dino_calls_start (_tmp38_, _tmp40_);
	_tmp41_ = dino_application_get_stream_interactor (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = dino_application_get_db (self);
	_tmp44_ = _tmp43_;
	dino_conversation_manager_start (_tmp42_, _tmp44_);
	_tmp45_ = dino_application_get_stream_interactor (self);
	_tmp46_ = _tmp45_;
	dino_muc_manager_start (_tmp46_);
	_tmp47_ = dino_application_get_stream_interactor (self);
	_tmp48_ = _tmp47_;
	_tmp49_ = dino_application_get_db (self);
	_tmp50_ = _tmp49_;
	dino_avatar_manager_start (_tmp48_, _tmp50_);
	_tmp51_ = dino_application_get_stream_interactor (self);
	_tmp52_ = _tmp51_;
	_tmp53_ = dino_application_get_db (self);
	_tmp54_ = _tmp53_;
	dino_roster_manager_start (_tmp52_, _tmp54_);
	_tmp55_ = dino_application_get_stream_interactor (self);
	_tmp56_ = _tmp55_;
	_tmp57_ = dino_application_get_db (self);
	_tmp58_ = _tmp57_;
	dino_file_manager_start (_tmp56_, _tmp58_);
	_tmp59_ = dino_application_get_stream_interactor (self);
	_tmp60_ = _tmp59_;
	_tmp61_ = dino_application_get_db (self);
	_tmp62_ = _tmp61_;
	dino_call_store_start (_tmp60_, _tmp62_);
	_tmp63_ = dino_application_get_stream_interactor (self);
	_tmp64_ = _tmp63_;
	_tmp65_ = dino_application_get_db (self);
	_tmp66_ = _tmp65_;
	dino_content_item_store_start (_tmp64_, _tmp66_);
	_tmp67_ = dino_application_get_stream_interactor (self);
	_tmp68_ = _tmp67_;
	dino_chat_interaction_start (_tmp68_);
	_tmp69_ = dino_application_get_stream_interactor (self);
	_tmp70_ = _tmp69_;
	dino_notification_events_start (_tmp70_);
	_tmp71_ = dino_application_get_stream_interactor (self);
	_tmp72_ = _tmp71_;
	_tmp73_ = dino_application_get_db (self);
	_tmp74_ = _tmp73_;
	dino_search_processor_start (_tmp72_, _tmp74_);
	_tmp75_ = dino_application_get_stream_interactor (self);
	_tmp76_ = _tmp75_;
	_tmp77_ = dino_application_get_db (self);
	_tmp78_ = _tmp77_;
	dino_register_start (_tmp76_, _tmp78_);
	_tmp79_ = dino_application_get_stream_interactor (self);
	_tmp80_ = _tmp79_;
	_tmp81_ = dino_application_get_db (self);
	_tmp82_ = _tmp81_;
	dino_entity_info_start (_tmp80_, _tmp82_);
	_tmp83_ = dino_application_get_stream_interactor (self);
	_tmp84_ = _tmp83_;
	_tmp85_ = dino_application_get_db (self);
	_tmp86_ = _tmp85_;
	dino_message_correction_start (_tmp84_, _tmp86_);
	_tmp87_ = dino_application_get_stream_interactor (self);
	_tmp88_ = _tmp87_;
	_tmp89_ = dino_application_get_db (self);
	_tmp90_ = _tmp89_;
	dino_file_transfer_storage_start (_tmp88_, _tmp90_);
	_tmp91_ = dino_application_get_stream_interactor (self);
	_tmp92_ = _tmp91_;
	_tmp93_ = dino_application_get_db (self);
	_tmp94_ = _tmp93_;
	dino_reactions_start (_tmp92_, _tmp94_);
	_tmp95_ = dino_application_get_stream_interactor (self);
	_tmp96_ = _tmp95_;
	_tmp97_ = dino_application_get_db (self);
	_tmp98_ = _tmp97_;
	dino_replies_start (_tmp96_, _tmp98_);
	_tmp99_ = dino_application_get_stream_interactor (self);
	_tmp100_ = _tmp99_;
	_tmp101_ = dino_application_get_db (self);
	_tmp102_ = _tmp101_;
	dino_fallback_body_start (_tmp100_, _tmp102_);
	_tmp103_ = dino_application_get_stream_interactor (self);
	_tmp104_ = _tmp103_;
	dino_contact_models_start (_tmp104_);
	_tmp105_ = dino_application_get_stream_interactor (self);
	_tmp106_ = _tmp105_;
	_tmp107_ = dino_application_get_db (self);
	_tmp108_ = _tmp107_;
	dino_stateless_file_sharing_start (_tmp106_, _tmp108_);
	dino_application_create_actions (self);
	g_signal_connect_object ((GApplication*) self, "startup", (GCallback) ___lambda145__g_application_startup, self, 0);
	g_signal_connect_object ((GApplication*) self, "shutdown", (GCallback) ___lambda146__g_application_shutdown, self, 0);
	g_signal_connect_object ((GApplication*) self, "open", (GCallback) ___lambda147__g_application_open, self, 0);
	g_application_add_main_option_entries ((GApplication*) self, DINO_APPLICATION_options);
}

gchar*
dino_application_get_storage_dir (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "dino", NULL);
	result = _tmp1_;
	return result;
}

DinoApplication*
dino_application_get_default (void)
{
	GApplication* _tmp0_;
	DinoApplication* result;
	_tmp0_ = g_application_get_default ();
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, DINO_TYPE_APPLICATION, DinoApplication);
	return result;
}

static void
__lambda144_ (DinoApplication* self,
              GVariant* variant)
{
	DinoEntitiesConversation* conversation = NULL;
	DinoStreamInteractor* _tmp0_;
	DinoStreamInteractor* _tmp1_;
	DinoModuleIdentity* _tmp2_;
	gpointer _tmp3_;
	DinoConversationManager* _tmp4_;
	DinoEntitiesConversation* _tmp5_;
	DinoEntitiesConversation* _tmp6_;
	DinoEntitiesConversation* _tmp7_;
	DinoStreamInteractor* _tmp8_;
	DinoStreamInteractor* _tmp9_;
	DinoModuleIdentity* _tmp10_;
	gpointer _tmp11_;
	DinoPresenceManager* _tmp12_;
	DinoEntitiesConversation* _tmp13_;
	DinoEntitiesAccount* _tmp14_;
	DinoEntitiesAccount* _tmp15_;
	DinoEntitiesConversation* _tmp16_;
	XmppJid* _tmp17_;
	XmppJid* _tmp18_;
	DinoStreamInteractor* _tmp19_;
	DinoStreamInteractor* _tmp20_;
	DinoModuleIdentity* _tmp21_;
	gpointer _tmp22_;
	DinoPresenceManager* _tmp23_;
	DinoEntitiesConversation* _tmp24_;
	DinoEntitiesAccount* _tmp25_;
	DinoEntitiesAccount* _tmp26_;
	DinoEntitiesConversation* _tmp27_;
	XmppJid* _tmp28_;
	XmppJid* _tmp29_;
	_tmp0_ = dino_application_get_stream_interactor (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = dino_conversation_manager_IDENTITY;
	_tmp3_ = dino_stream_interactor_get_module (_tmp1_, DINO_TYPE_CONVERSATION_MANAGER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp2_);
	_tmp4_ = (DinoConversationManager*) _tmp3_;
	_tmp5_ = dino_conversation_manager_get_conversation_by_id (_tmp4_, (gint) g_variant_get_int32 (variant));
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	conversation = _tmp6_;
	_tmp7_ = conversation;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (conversation);
		return;
	}
	_tmp8_ = dino_application_get_stream_interactor (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = dino_presence_manager_IDENTITY;
	_tmp11_ = dino_stream_interactor_get_module (_tmp9_, DINO_TYPE_PRESENCE_MANAGER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp10_);
	_tmp12_ = (DinoPresenceManager*) _tmp11_;
	_tmp13_ = conversation;
	_tmp14_ = dino_entities_conversation_get_account (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = conversation;
	_tmp17_ = dino_entities_conversation_get_counterpart (_tmp16_);
	_tmp18_ = _tmp17_;
	dino_presence_manager_approve_subscription (_tmp12_, _tmp15_, _tmp18_);
	_g_object_unref0 (_tmp12_);
	_tmp19_ = dino_application_get_stream_interactor (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = dino_presence_manager_IDENTITY;
	_tmp22_ = dino_stream_interactor_get_module (_tmp20_, DINO_TYPE_PRESENCE_MANAGER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp21_);
	_tmp23_ = (DinoPresenceManager*) _tmp22_;
	_tmp24_ = conversation;
	_tmp25_ = dino_entities_conversation_get_account (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = conversation;
	_tmp28_ = dino_entities_conversation_get_counterpart (_tmp27_);
	_tmp29_ = _tmp28_;
	dino_presence_manager_request_subscription (_tmp23_, _tmp26_, _tmp29_);
	_g_object_unref0 (_tmp23_);
	_g_object_unref0 (conversation);
}

static void
___lambda144__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	__lambda144_ ((DinoApplication*) self, parameter);
}

void
dino_application_create_actions (DinoApplication* self)
{
	GSimpleAction* accept_subscription_action = NULL;
	const GVariantType* _tmp0_;
	GSimpleAction* _tmp1_;
	_tmp0_ = G_VARIANT_TYPE_INT32;
	_tmp1_ = g_simple_action_new ("accept-subscription", _tmp0_);
	accept_subscription_action = _tmp1_;
	g_signal_connect_object (accept_subscription_action, "activate", (GCallback) ___lambda144__g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) self, (GAction*) accept_subscription_action);
	_g_object_unref0 (accept_subscription_action);
}

void
dino_application_add_connection (DinoApplication* self,
                                 DinoEntitiesAccount* account)
{
	DinoStreamInteractor* _tmp0_;
	DinoStreamInteractor* _tmp1_;
	g_return_if_fail (account != NULL);
	if ((g_application_get_flags ((GApplication*) self) & G_APPLICATION_IS_SERVICE) == G_APPLICATION_IS_SERVICE) {
		g_application_hold ((GApplication*) self);
	}
	_tmp0_ = dino_application_get_stream_interactor (self);
	_tmp1_ = _tmp0_;
	dino_stream_interactor_connect_account (_tmp1_, account);
}

void
dino_application_remove_connection (DinoApplication* self,
                                    DinoEntitiesAccount* account)
{
	DinoStreamInteractor* _tmp0_;
	DinoStreamInteractor* _tmp1_;
	g_return_if_fail (account != NULL);
	if ((g_application_get_flags ((GApplication*) self) & G_APPLICATION_IS_SERVICE) == G_APPLICATION_IS_SERVICE) {
		g_application_release ((GApplication*) self);
	}
	_tmp0_ = dino_application_get_stream_interactor (self);
	_tmp1_ = _tmp0_;
	dino_stream_interactor_disconnect_account (_tmp1_, account, NULL, NULL);
}

static void
dino_application_restore (DinoApplication* self)
{
	{
		GeeArrayList* _account_list = NULL;
		DinoDatabase* _tmp0_;
		DinoDatabase* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _account_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _account_index = 0;
		_tmp0_ = dino_application_get_db (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = dino_database_get_accounts (_tmp1_);
		_account_list = _tmp2_;
		_tmp3_ = _account_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_account_size = _tmp5_;
		_account_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			DinoEntitiesAccount* account = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			DinoEntitiesAccount* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_account_index = _account_index + 1;
			_tmp6_ = _account_index;
			_tmp7_ = _account_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _account_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _account_index);
			account = (DinoEntitiesAccount*) _tmp9_;
			_tmp10_ = account;
			_tmp11_ = dino_entities_account_get_enabled (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_) {
				DinoEntitiesAccount* _tmp13_;
				_tmp13_ = account;
				dino_application_add_connection (self, _tmp13_);
			}
			_g_object_unref0 (account);
		}
		_g_object_unref0 (_account_list);
	}
}

DinoDatabase*
dino_application_get_db (DinoApplication* self)
{
	DinoApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DINO_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_db) {
		return _iface_->get_db (self);
	}
	return NULL;
}

void
dino_application_set_db (DinoApplication* self,
                         DinoDatabase* value)
{
	DinoApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DINO_APPLICATION_GET_INTERFACE (self);
	if (_iface_->set_db) {
		_iface_->set_db (self, value);
	}
}

DinoEntitiesSettings*
dino_application_get_settings (DinoApplication* self)
{
	DinoApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DINO_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_settings) {
		return _iface_->get_settings (self);
	}
	return NULL;
}

void
dino_application_set_settings (DinoApplication* self,
                               DinoEntitiesSettings* value)
{
	DinoApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DINO_APPLICATION_GET_INTERFACE (self);
	if (_iface_->set_settings) {
		_iface_->set_settings (self, value);
	}
}

DinoStreamInteractor*
dino_application_get_stream_interactor (DinoApplication* self)
{
	DinoApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DINO_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_stream_interactor) {
		return _iface_->get_stream_interactor (self);
	}
	return NULL;
}

void
dino_application_set_stream_interactor (DinoApplication* self,
                                        DinoStreamInteractor* value)
{
	DinoApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DINO_APPLICATION_GET_INTERFACE (self);
	if (_iface_->set_stream_interactor) {
		_iface_->set_stream_interactor (self, value);
	}
}

DinoPluginsRegistry*
dino_application_get_plugin_registry (DinoApplication* self)
{
	DinoApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DINO_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_plugin_registry) {
		return _iface_->get_plugin_registry (self);
	}
	return NULL;
}

void
dino_application_set_plugin_registry (DinoApplication* self,
                                      DinoPluginsRegistry* value)
{
	DinoApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DINO_APPLICATION_GET_INTERFACE (self);
	if (_iface_->set_plugin_registry) {
		_iface_->set_plugin_registry (self, value);
	}
}

DinoSearchPathGenerator*
dino_application_get_search_path_generator (DinoApplication* self)
{
	DinoApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DINO_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_search_path_generator) {
		return _iface_->get_search_path_generator (self);
	}
	return NULL;
}

void
dino_application_set_search_path_generator (DinoApplication* self,
                                            DinoSearchPathGenerator* value)
{
	DinoApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DINO_APPLICATION_GET_INTERFACE (self);
	if (_iface_->set_search_path_generator) {
		_iface_->set_search_path_generator (self, value);
	}
}

static void
dino_application_default_init (DinoApplicationIface * iface,
                               gpointer iface_data)
{
	g_object_interface_install_property (iface, qlite_param_spec_database ("db", "db", "db", DINO_TYPE_DATABASE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_object ("settings", "settings", "settings", DINO_ENTITIES_TYPE_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_object ("stream-interactor", "stream-interactor", "stream-interactor", DINO_TYPE_STREAM_INTERACTOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, dino_plugins_param_spec_registry ("plugin-registry", "plugin-registry", "plugin-registry", DINO_PLUGINS_TYPE_REGISTRY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, dino_param_spec_search_path_generator ("search-path-generator", "search-path-generator", "search-path-generator", DINO_TYPE_SEARCH_PATH_GENERATOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static GType
dino_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoApplicationIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_application_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType dino_application_type_id;
	dino_application_type_id = g_type_register_static (G_TYPE_INTERFACE, "DinoApplication", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (dino_application_type_id, g_application_get_type ());
	return dino_application_type_id;
}

GType
dino_application_get_type (void)
{
	static volatile gsize dino_application_type_id__once = 0;
	if (g_once_init_enter (&dino_application_type_id__once)) {
		GType dino_application_type_id;
		dino_application_type_id = dino_application_get_type_once ();
		g_once_init_leave (&dino_application_type_id__once, dino_application_type_id);
	}
	return dino_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

