/* encrypt.c generated by valac 0.56.18, the Vala compiler
 * generated from encrypt.vala, do not modify */

#include "omemo.h"
#include "libdino.h"
#include "xmpp-vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <omemo/signal_protocol_types.h>
#include <omemo/signal_protocol.h>
#include <native/helper.h>
#include <gee.h>
#include <omemo/session_cipher.h>
#include <omemo/protocol.h>

#define DINO_PLUGINS_OMEMO_NS_URI "eu.siacs.conversations.axolotl"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DINO_PLUGINS_OMEMO_OMEMO_ENCRYPTOR_0_PROPERTY,
	DINO_PLUGINS_OMEMO_OMEMO_ENCRYPTOR_OWN_DEVICE_ID_PROPERTY,
	DINO_PLUGINS_OMEMO_OMEMO_ENCRYPTOR_NUM_PROPERTIES
};
static GParamSpec* dino_plugins_omemo_omemo_encryptor_properties[DINO_PLUGINS_OMEMO_OMEMO_ENCRYPTOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dino_plugins_omemo_trust_manager_unref0(var) ((var == NULL) ? NULL : (var = (dino_plugins_omemo_trust_manager_unref (var), NULL)))
#define _omemo_context_unref0(var) ((var == NULL) ? NULL : (var = (omemo_context_unref (var), NULL)))
#define _signal_buffer_free0(var) ((var == NULL) ? NULL : (var = (signal_buffer_free (var), NULL)))
#define _xmpp_jid_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_jid_unref (var), NULL)))
#define _xmpp_xep_omemo_encryption_data_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_xep_omemo_encryption_data_unref (var), NULL)))
#define _xmpp_xep_omemo_encrypt_state_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_xep_omemo_encrypt_state_unref (var), NULL)))
#define _xmpp_stanza_entry_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_stanza_entry_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _xmpp_xep_omemo_encryption_result_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_xep_omemo_encryption_result_unref (var), NULL)))
#define _signal_protocol_address_free0(var) ((var == NULL) ? NULL : (var = (signal_protocol_address_free (var), NULL)))
#define _signal_type_unref_vapi0(var) ((var == NULL) ? NULL : (var = (signal_type_unref_vapi (var), NULL)))
#define _session_cipher_free0(var) ((var == NULL) ? NULL : (var = (session_cipher_free (var), NULL)))

struct _DinoPluginsOmemoOmemoEncryptorPrivate {
	DinoEntitiesAccount* account;
	OmemoStore* store;
	DinoPluginsOmemoTrustManager* trust_manager;
};

static gint DinoPluginsOmemoOmemoEncryptor_private_offset;
static gpointer dino_plugins_omemo_omemo_encryptor_parent_class = NULL;

static XmppXepOmemoEncryptionData* dino_plugins_omemo_omemo_encryptor_real_encrypt_plaintext (XmppXepOmemoOmemoEncryptor* base,
                                                                                       const gchar* plaintext,
                                                                                       GError** error);
static const char* _omemo_error_code_to_string (int value);
static guint8* _vala_array_dup19 (guint8* self,
                           gssize length);
static guint8* _vala_array_dup20 (guint8* self,
                           gssize length);
static guint8* _vala_array_dup21 (guint8* self,
                           gssize length);
static guint8* _vala_array_dup22 (guint8* self,
                           gssize length);
static guint8* _vala_array_dup23 (guint8* self,
                           gssize length);
static guint8* _vala_array_dup24 (guint8* self,
                           gssize length);
VALA_EXTERN XmppXepOmemoEncryptState* dino_plugins_omemo_omemo_encryptor_encrypt_key_to_recipients (DinoPluginsOmemoOmemoEncryptor* self,
                                                                                        XmppXepOmemoEncryptionData* enc_data,
                                                                                        XmppJid* self_jid,
                                                                                        GeeList* recipients,
                                                                                        XmppXmppStream* stream,
                                                                                        GError** error);
static XmppXepOmemoEncryptionResult* dino_plugins_omemo_omemo_encryptor_real_encrypt_key_to_recipient (XmppXepOmemoOmemoEncryptor* base,
                                                                                                XmppXmppStream* stream,
                                                                                                XmppXepOmemoEncryptionData* enc_data,
                                                                                                XmppJid* recipient,
                                                                                                GError** error);
static void dino_plugins_omemo_omemo_encryptor_real_encrypt_key (XmppXepOmemoOmemoEncryptor* base,
                                                          XmppXepOmemoEncryptionData* encryption_data,
                                                          XmppJid* jid,
                                                          gint32 device_id,
                                                          GError** error);
static void dino_plugins_omemo_omemo_encryptor_finalize (GObject * obj);
static GType dino_plugins_omemo_omemo_encryptor_get_type_once (void);
static void _vala_dino_plugins_omemo_omemo_encryptor_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
dino_plugins_omemo_omemo_encryptor_get_instance_private (DinoPluginsOmemoOmemoEncryptor* self)
{
	return G_STRUCT_MEMBER_P (self, DinoPluginsOmemoOmemoEncryptor_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_dino_plugins_omemo_trust_manager_ref0 (gpointer self)
{
	return self ? dino_plugins_omemo_trust_manager_ref (self) : NULL;
}

DinoPluginsOmemoOmemoEncryptor*
dino_plugins_omemo_omemo_encryptor_construct (GType object_type,
                                              DinoEntitiesAccount* account,
                                              DinoPluginsOmemoTrustManager* trust_manager,
                                              OmemoStore* store)
{
	DinoPluginsOmemoOmemoEncryptor * self = NULL;
	DinoEntitiesAccount* _tmp0_;
	DinoPluginsOmemoTrustManager* _tmp1_;
	OmemoStore* _tmp2_;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (trust_manager != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	self = (DinoPluginsOmemoOmemoEncryptor*) xmpp_xep_omemo_omemo_encryptor_construct (object_type);
	_tmp0_ = _g_object_ref0 (account);
	_g_object_unref0 (self->priv->account);
	self->priv->account = _tmp0_;
	_tmp1_ = _dino_plugins_omemo_trust_manager_ref0 (trust_manager);
	_dino_plugins_omemo_trust_manager_unref0 (self->priv->trust_manager);
	self->priv->trust_manager = _tmp1_;
	_tmp2_ = _g_object_ref0 (store);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp2_;
	return self;
}

DinoPluginsOmemoOmemoEncryptor*
dino_plugins_omemo_omemo_encryptor_new (DinoEntitiesAccount* account,
                                        DinoPluginsOmemoTrustManager* trust_manager,
                                        OmemoStore* store)
{
	return dino_plugins_omemo_omemo_encryptor_construct (DINO_PLUGINS_OMEMO_TYPE_OMEMO_ENCRYPTOR, account, trust_manager, store);
}

static const char*
_omemo_error_code_to_string (int value)
{
	switch (value) {
		case SG_SUCCESS:
		return "SG_SUCCESS";
		case SG_ERR_NOMEM:
		return "SG_ERR_NOMEM";
		case SG_ERR_INVAL:
		return "SG_ERR_INVAL";
		case SG_ERR_UNKNOWN:
		return "SG_ERR_UNKNOWN";
		case SG_ERR_DUPLICATE_MESSAGE:
		return "SG_ERR_DUPLICATE_MESSAGE";
		case SG_ERR_INVALID_KEY:
		return "SG_ERR_INVALID_KEY";
		case SG_ERR_INVALID_KEY_ID:
		return "SG_ERR_INVALID_KEY_ID";
		case SG_ERR_INVALID_MAC:
		return "SG_ERR_INVALID_MAC";
		case SG_ERR_INVALID_MESSAGE:
		return "SG_ERR_INVALID_MESSAGE";
		case SG_ERR_INVALID_VERSION:
		return "SG_ERR_INVALID_VERSION";
		case SG_ERR_LEGACY_MESSAGE:
		return "SG_ERR_LEGACY_MESSAGE";
		case SG_ERR_NO_SESSION:
		return "SG_ERR_NO_SESSION";
		case SG_ERR_STALE_KEY_EXCHANGE:
		return "SG_ERR_STALE_KEY_EXCHANGE";
		case SG_ERR_UNTRUSTED_IDENTITY:
		return "SG_ERR_UNTRUSTED_IDENTITY";
		case SG_ERR_VRF_SIG_VERIF_FAILED:
		return "SG_ERR_VRF_SIG_VERIF_FAILED";
		case SG_ERR_INVALID_PROTO_BUF:
		return "SG_ERR_INVALID_PROTO_BUF";
		case SG_ERR_FP_VERSION_MISMATCH:
		return "SG_ERR_FP_VERSION_MISMATCH";
		case SG_ERR_FP_IDENT_MISMATCH:
		return "SG_ERR_FP_IDENT_MISMATCH";
	}
	return NULL;
}

static gint
signal_throw_gerror_by_code_ (gint code,
                              const gchar* message,
                              GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gint result;
	if (code < 0) {
		_tmp0_ = code > SG_ERR_MINIMUM;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		GError* _tmp3_;
		gint _tmp4_ = -1;
		_tmp1_ = message;
		if (_tmp1_ == NULL) {
			_tmp1_ = "libomemo-c error";
		}
		_tmp2_ = _omemo_error_code_to_string ((int) code);
		_tmp3_ = g_error_new ((GQuark) -1, code, "%s: %s", _tmp1_, _tmp2_);
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	result = code;
	return result;
}

static guint8*
signal_buffer_get_data (signal_buffer* self,
                        gint* result_length1)
{
	guint8* result;
	gint x = 0;
	guint8* res = NULL;
	guint8* _tmp0_;
	gint res_length1;
	gint _res_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	x = (gint) signal_buffer_len (self);
	_tmp0_ = signal_buffer_data (self);
	res = _tmp0_;
	res_length1 = -1;
	_res_size_ = res_length1;
	res_length1 = x;
	_tmp1_ = res;
	_tmp1__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static guint8*
_vala_array_dup19 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
signal_vala_encrypt_ (gint cipher,
                      guint8* key,
                      gint key_length1,
                      guint8* iv,
                      gint iv_length1,
                      guint8* plaintext,
                      gint plaintext_length1,
                      gint* result_length1,
                      GError** error)
{
	signal_buffer* buf = NULL;
	signal_buffer* _tmp0_ = NULL;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	_tmp1_ = signal_vala_encrypt (&_tmp0_, cipher, key, (gint) key_length1, iv, (gint) iv_length1, plaintext, (gint) plaintext_length1, NULL);
	_signal_buffer_free0 (buf);
	buf = _tmp0_;
	signal_throw_gerror_by_code_ (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_buffer_free0 (buf);
		return NULL;
	}
	_tmp2_ = signal_buffer_get_data (buf, &_tmp3_);
	_tmp2__length1 = _tmp3_;
	_tmp4_ = _tmp2_;
	_tmp4__length1 = _tmp2__length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup19 (_tmp4_, _tmp4__length1) : _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	_signal_buffer_free0 (buf);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup20 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
_vala_array_dup21 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
_vala_array_dup22 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
_vala_array_dup23 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
_vala_array_dup24 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static XmppXepOmemoEncryptionData*
dino_plugins_omemo_omemo_encryptor_real_encrypt_plaintext (XmppXepOmemoOmemoEncryptor* base,
                                                           const gchar* plaintext,
                                                           GError** error)
{
	DinoPluginsOmemoOmemoEncryptor * self;
	static const guint KEY_SIZE = (guint) 16;
	static const guint IV_SIZE = (guint) 12;
	guint8* key = NULL;
	guint8* _tmp0_;
	gint key_length1;
	gint _key_size_;
	OmemoContext* _tmp1_;
	OmemoContext* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* iv = NULL;
	guint8* _tmp4_;
	gint iv_length1;
	gint _iv_size_;
	OmemoContext* _tmp5_;
	OmemoContext* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	guint8* aes_encrypt_result = NULL;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_ = 0;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_ = 0;
	guint8* _tmp14_;
	gint aes_encrypt_result_length1;
	gint _aes_encrypt_result_size_;
	guint8* ciphertext = NULL;
	guint8* _tmp15_;
	gint _tmp15__length1;
	guint8* _tmp16_;
	gint _tmp16__length1;
	guint8* _tmp17_;
	gint _tmp17__length1;
	gint ciphertext_length1;
	gint _ciphertext_size_;
	guint8* tag = NULL;
	guint8* _tmp18_;
	gint _tmp18__length1;
	guint8* _tmp19_;
	gint _tmp19__length1;
	guint8* _tmp20_;
	gint _tmp20__length1;
	guint8* _tmp21_;
	gint _tmp21__length1;
	gint tag_length1;
	gint _tag_size_;
	guint8* keytag = NULL;
	guint8* _tmp22_;
	gint _tmp22__length1;
	guint8* _tmp23_;
	gint _tmp23__length1;
	guint8* _tmp24_;
	gint keytag_length1;
	gint _keytag_size_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	guint8* _tmp26_;
	gint _tmp26__length1;
	guint8* _tmp27_;
	gint _tmp27__length1;
	guint8* _tmp28_;
	gint _tmp28__length1;
	guint8* _tmp29_;
	gint _tmp29__length1;
	guint8* _tmp30_;
	gint _tmp30__length1;
	guint8* _tmp31_;
	gint _tmp31__length1;
	XmppXepOmemoEncryptionData* ret = NULL;
	guint32 _tmp32_;
	guint32 _tmp33_;
	XmppXepOmemoEncryptionData* _tmp34_;
	XmppXepOmemoEncryptionData* _tmp35_;
	guint8* _tmp36_;
	gint _tmp36__length1;
	guint8* _tmp37_;
	gint _tmp37__length1;
	XmppXepOmemoEncryptionData* _tmp38_;
	guint8* _tmp39_;
	gint _tmp39__length1;
	guint8* _tmp40_;
	gint _tmp40__length1;
	XmppXepOmemoEncryptionData* _tmp41_;
	guint8* _tmp42_;
	gint _tmp42__length1;
	guint8* _tmp43_;
	gint _tmp43__length1;
	GError* _inner_error0_ = NULL;
	XmppXepOmemoEncryptionData* result;
	self = (DinoPluginsOmemoOmemoEncryptor*) base;
	g_return_val_if_fail (plaintext != NULL, NULL);
	_tmp0_ = g_new0 (guint8, KEY_SIZE);
	key = _tmp0_;
	key_length1 = KEY_SIZE;
	_key_size_ = key_length1;
	_tmp1_ = dino_plugins_omemo_plugin_get_context ();
	_tmp2_ = _tmp1_;
	_tmp3_ = key;
	_tmp3__length1 = key_length1;
	omemo_context_randomize (_tmp2_, _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
	_omemo_context_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		key = (g_free (key), NULL);
		return NULL;
	}
	_tmp4_ = g_new0 (guint8, IV_SIZE);
	iv = _tmp4_;
	iv_length1 = IV_SIZE;
	_iv_size_ = iv_length1;
	_tmp5_ = dino_plugins_omemo_plugin_get_context ();
	_tmp6_ = _tmp5_;
	_tmp7_ = iv;
	_tmp7__length1 = iv_length1;
	omemo_context_randomize (_tmp6_, _tmp7_, (gint) _tmp7__length1, &_inner_error0_);
	_omemo_context_unref0 (_tmp6_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		iv = (g_free (iv), NULL);
		key = (g_free (key), NULL);
		return NULL;
	}
	_tmp8_ = key;
	_tmp8__length1 = key_length1;
	_tmp9_ = iv;
	_tmp9__length1 = iv_length1;
	_tmp10_ = string_get_data (plaintext, &_tmp11_);
	_tmp10__length1 = _tmp11_;
	_tmp12_ = _tmp10_;
	_tmp12__length1 = _tmp10__length1;
	_tmp14_ = signal_vala_encrypt_ ((gint) SG_CIPHER_AES_GCM_NOPADDING, _tmp8_, (gint) _tmp8__length1, _tmp9_, (gint) _tmp9__length1, _tmp12_, (gint) _tmp12__length1, &_tmp13_, &_inner_error0_);
	aes_encrypt_result = _tmp14_;
	aes_encrypt_result_length1 = _tmp13_;
	_aes_encrypt_result_size_ = aes_encrypt_result_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		iv = (g_free (iv), NULL);
		key = (g_free (key), NULL);
		return NULL;
	}
	_tmp15_ = aes_encrypt_result;
	_tmp15__length1 = aes_encrypt_result_length1;
	_tmp16_ = aes_encrypt_result;
	_tmp16__length1 = aes_encrypt_result_length1;
	_tmp17_ = (_tmp15_ != NULL) ? _vala_array_dup20 (_tmp15_ + 0, (_tmp16__length1 - 16) - 0) : _tmp15_;
	_tmp17__length1 = (_tmp16__length1 - 16) - 0;
	ciphertext = _tmp17_;
	ciphertext_length1 = _tmp17__length1;
	_ciphertext_size_ = ciphertext_length1;
	_tmp18_ = aes_encrypt_result;
	_tmp18__length1 = aes_encrypt_result_length1;
	_tmp19_ = aes_encrypt_result;
	_tmp19__length1 = aes_encrypt_result_length1;
	_tmp20_ = aes_encrypt_result;
	_tmp20__length1 = aes_encrypt_result_length1;
	_tmp21_ = (_tmp18_ != NULL) ? _vala_array_dup21 (_tmp18_ + (_tmp19__length1 - 16), _tmp20__length1 - (_tmp19__length1 - 16)) : _tmp18_;
	_tmp21__length1 = _tmp20__length1 - (_tmp19__length1 - 16);
	tag = _tmp21_;
	tag_length1 = _tmp21__length1;
	_tag_size_ = tag_length1;
	_tmp22_ = key;
	_tmp22__length1 = key_length1;
	_tmp23_ = tag;
	_tmp23__length1 = tag_length1;
	_tmp24_ = g_new0 (guint8, _tmp22__length1 + _tmp23__length1);
	keytag = _tmp24_;
	keytag_length1 = _tmp22__length1 + _tmp23__length1;
	_keytag_size_ = keytag_length1;
	_tmp25_ = keytag;
	_tmp25__length1 = keytag_length1;
	_tmp26_ = key;
	_tmp26__length1 = key_length1;
	_tmp27_ = key;
	_tmp27__length1 = key_length1;
	memcpy (_tmp25_, _tmp26_, (gsize) _tmp27__length1);
	_tmp28_ = keytag;
	_tmp28__length1 = keytag_length1;
	_tmp29_ = key;
	_tmp29__length1 = key_length1;
	_tmp30_ = tag;
	_tmp30__length1 = tag_length1;
	_tmp31_ = tag;
	_tmp31__length1 = tag_length1;
	memcpy (((guint8*) _tmp28_) + _tmp29__length1, _tmp30_, (gsize) _tmp31__length1);
	_tmp32_ = xmpp_xep_omemo_omemo_encryptor_get_own_device_id ((XmppXepOmemoOmemoEncryptor*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = xmpp_xep_omemo_encryption_data_new (_tmp33_);
	ret = _tmp34_;
	_tmp35_ = ret;
	_tmp36_ = ciphertext;
	_tmp36__length1 = ciphertext_length1;
	_tmp37_ = (_tmp36_ != NULL) ? _vala_array_dup22 (_tmp36_, _tmp36__length1) : _tmp36_;
	_tmp37__length1 = _tmp36__length1;
	_tmp35_->ciphertext = (g_free (_tmp35_->ciphertext), NULL);
	_tmp35_->ciphertext = _tmp37_;
	_tmp35_->ciphertext_length1 = _tmp37__length1;
	_tmp38_ = ret;
	_tmp39_ = keytag;
	_tmp39__length1 = keytag_length1;
	_tmp40_ = (_tmp39_ != NULL) ? _vala_array_dup23 (_tmp39_, _tmp39__length1) : _tmp39_;
	_tmp40__length1 = _tmp39__length1;
	_tmp38_->keytag = (g_free (_tmp38_->keytag), NULL);
	_tmp38_->keytag = _tmp40_;
	_tmp38_->keytag_length1 = _tmp40__length1;
	_tmp41_ = ret;
	_tmp42_ = iv;
	_tmp42__length1 = iv_length1;
	_tmp43_ = (_tmp42_ != NULL) ? _vala_array_dup24 (_tmp42_, _tmp42__length1) : _tmp42_;
	_tmp43__length1 = _tmp42__length1;
	_tmp41_->iv = (g_free (_tmp41_->iv), NULL);
	_tmp41_->iv = _tmp43_;
	_tmp41_->iv_length1 = _tmp43__length1;
	result = ret;
	keytag = (g_free (keytag), NULL);
	tag = (g_free (tag), NULL);
	ciphertext = (g_free (ciphertext), NULL);
	aes_encrypt_result = (g_free (aes_encrypt_result), NULL);
	iv = (g_free (iv), NULL);
	key = (g_free (key), NULL);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

XmppXepOmemoEncryptState*
dino_plugins_omemo_omemo_encryptor_encrypt (DinoPluginsOmemoOmemoEncryptor* self,
                                            XmppMessageStanza* message,
                                            XmppJid* self_jid,
                                            GeeList* recipients,
                                            XmppXmppStream* stream)
{
	XmppXepOmemoEncryptState* status = NULL;
	XmppXepOmemoEncryptState* _tmp0_;
	XmppJid* _tmp1_;
	XmppJid* _tmp2_;
	XmppJid* _tmp3_;
	gboolean _tmp4_;
	GError* _inner_error0_ = NULL;
	XmppXepOmemoEncryptState* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (self_jid != NULL, NULL);
	g_return_val_if_fail (recipients != NULL, NULL);
	g_return_val_if_fail (stream != NULL, NULL);
	_tmp0_ = xmpp_xep_omemo_encrypt_state_new ();
	status = _tmp0_;
	if (!dino_plugins_omemo_plugin_ensure_context ()) {
		result = status;
		return result;
	}
	_tmp1_ = xmpp_stanza_get_to ((XmppStanza*) message);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_xmpp_jid_unref0 (_tmp3_);
	if (_tmp4_) {
		result = status;
		return result;
	}
	{
		XmppXepOmemoEncryptionData* enc_data = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		XmppXepOmemoEncryptionData* _tmp7_;
		XmppXepOmemoEncryptState* _tmp8_ = NULL;
		XmppXepOmemoEncryptionData* _tmp9_;
		XmppXepOmemoEncryptState* _tmp10_;
		XmppXepOmemoEncryptState* _tmp11_;
		XmppStanzaNode* _tmp12_;
		XmppXepOmemoEncryptionData* _tmp13_;
		XmppStanzaNode* _tmp14_;
		XmppStanzaNode* _tmp15_;
		XmppStanzaNode* _tmp16_;
		XmppStanzaNode* _tmp17_;
		XmppXepOmemoEncryptState* _tmp18_;
		_tmp5_ = xmpp_message_stanza_get_body (message);
		_tmp6_ = _tmp5_;
		_tmp7_ = xmpp_xep_omemo_omemo_encryptor_encrypt_plaintext ((XmppXepOmemoOmemoEncryptor*) self, _tmp6_, &_inner_error0_);
		enc_data = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = enc_data;
		_tmp10_ = dino_plugins_omemo_omemo_encryptor_encrypt_key_to_recipients (self, _tmp9_, self_jid, recipients, stream, &_inner_error0_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_xmpp_xep_omemo_encryption_data_unref0 (enc_data);
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_xmpp_xep_omemo_encrypt_state_unref0 (status);
		status = _tmp11_;
		_tmp12_ = ((XmppStanza*) message)->stanza;
		_tmp13_ = enc_data;
		_tmp14_ = xmpp_xep_omemo_encryption_data_get_encrypted_node (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = xmpp_stanza_node_put_node (_tmp12_, _tmp15_);
		_tmp17_ = _tmp16_;
		_xmpp_stanza_entry_unref0 (_tmp17_);
		_xmpp_stanza_entry_unref0 (_tmp15_);
		xmpp_xep_explicit_encryption_add_encryption_tag_to_message (message, DINO_PLUGINS_OMEMO_NS_URI, "OMEMO");
		xmpp_message_stanza_set_body (message, "[This message is OMEMO encrypted]");
		_tmp18_ = status;
		xmpp_xep_omemo_encrypt_state_set_encrypted (_tmp18_, TRUE);
		_xmpp_xep_omemo_encrypt_state_unref0 (_tmp8_);
		_xmpp_xep_omemo_encryption_data_unref0 (enc_data);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		XmppXepOmemoEncryptState* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = g_strconcat ("error while encrypting message: ", _tmp21_, "\n", NULL);
		_tmp23_ = _tmp22_;
		g_warning ("encrypt.vala:62: %s", _tmp23_);
		_g_free0 (_tmp23_);
		xmpp_message_stanza_set_body (message, "[OMEMO encryption failed]");
		_tmp24_ = status;
		xmpp_xep_omemo_encrypt_state_set_encrypted (_tmp24_, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_xmpp_xep_omemo_encrypt_state_unref0 (status);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = status;
	return result;
}

XmppXepOmemoEncryptState*
dino_plugins_omemo_omemo_encryptor_encrypt_key_to_recipients (DinoPluginsOmemoOmemoEncryptor* self,
                                                              XmppXepOmemoEncryptionData* enc_data,
                                                              XmppJid* self_jid,
                                                              GeeList* recipients,
                                                              XmppXmppStream* stream,
                                                              GError** error)
{
	XmppXepOmemoEncryptState* status = NULL;
	XmppXepOmemoEncryptState* _tmp0_;
	DinoPluginsOmemoTrustManager* _tmp1_;
	DinoEntitiesAccount* _tmp2_;
	XmppXepOmemoEncryptState* _tmp3_;
	XmppXepOmemoEncryptState* _tmp4_;
	DinoPluginsOmemoTrustManager* _tmp5_;
	DinoEntitiesAccount* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	XmppXepOmemoEncryptState* _tmp11_;
	XmppXepOmemoEncryptState* _tmp12_;
	gboolean _tmp40_ = FALSE;
	XmppXepOmemoEncryptState* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	XmppXepOmemoEncryptionResult* enc_res = NULL;
	XmppXepOmemoEncryptionResult* _tmp58_;
	XmppXepOmemoEncryptState* _tmp59_;
	XmppXepOmemoEncryptionResult* _tmp60_;
	GError* _inner_error0_ = NULL;
	XmppXepOmemoEncryptState* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (enc_data != NULL, NULL);
	g_return_val_if_fail (self_jid != NULL, NULL);
	g_return_val_if_fail (recipients != NULL, NULL);
	g_return_val_if_fail (stream != NULL, NULL);
	_tmp0_ = xmpp_xep_omemo_encrypt_state_new ();
	status = _tmp0_;
	_tmp1_ = self->priv->trust_manager;
	_tmp2_ = self->priv->account;
	if (!dino_plugins_omemo_trust_manager_is_known_address (_tmp1_, _tmp2_, self_jid)) {
		result = status;
		return result;
	}
	_tmp3_ = status;
	xmpp_xep_omemo_encrypt_state_set_own_list (_tmp3_, TRUE);
	_tmp4_ = status;
	_tmp5_ = self->priv->trust_manager;
	_tmp6_ = self->priv->account;
	_tmp7_ = dino_plugins_omemo_trust_manager_get_trusted_devices (_tmp5_, _tmp6_, self_jid);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	xmpp_xep_omemo_encrypt_state_set_own_devices (_tmp4_, _tmp10_);
	_g_object_unref0 (_tmp8_);
	_tmp11_ = status;
	xmpp_xep_omemo_encrypt_state_set_other_waiting_lists (_tmp11_, 0);
	_tmp12_ = status;
	xmpp_xep_omemo_encrypt_state_set_other_devices (_tmp12_, 0);
	{
		GeeList* _recipient_list = NULL;
		gint _recipient_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _recipient_index = 0;
		_recipient_list = recipients;
		_tmp13_ = _recipient_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_recipient_size = _tmp15_;
		_recipient_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			XmppJid* recipient = NULL;
			GeeList* _tmp18_;
			gpointer _tmp19_;
			DinoPluginsOmemoTrustManager* _tmp20_;
			DinoEntitiesAccount* _tmp21_;
			XmppJid* _tmp22_;
			XmppXepOmemoEncryptState* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			XmppXepOmemoEncryptState* _tmp29_;
			XmppXepOmemoEncryptState* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			DinoPluginsOmemoTrustManager* _tmp33_;
			DinoEntitiesAccount* _tmp34_;
			XmppJid* _tmp35_;
			GeeList* _tmp36_;
			GeeList* _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			_recipient_index = _recipient_index + 1;
			_tmp16_ = _recipient_index;
			_tmp17_ = _recipient_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _recipient_list;
			_tmp19_ = gee_list_get (_tmp18_, _recipient_index);
			recipient = (XmppJid*) _tmp19_;
			_tmp20_ = self->priv->trust_manager;
			_tmp21_ = self->priv->account;
			_tmp22_ = recipient;
			if (!dino_plugins_omemo_trust_manager_is_known_address (_tmp20_, _tmp21_, _tmp22_)) {
				XmppXepOmemoEncryptState* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				_tmp23_ = status;
				_tmp24_ = xmpp_xep_omemo_encrypt_state_get_other_waiting_lists (_tmp23_);
				_tmp25_ = _tmp24_;
				xmpp_xep_omemo_encrypt_state_set_other_waiting_lists (_tmp23_, _tmp25_ + 1);
			}
			_tmp26_ = status;
			_tmp27_ = xmpp_xep_omemo_encrypt_state_get_other_waiting_lists (_tmp26_);
			_tmp28_ = _tmp27_;
			if (_tmp28_ > 0) {
				result = status;
				_xmpp_jid_unref0 (recipient);
				return result;
			}
			_tmp29_ = status;
			_tmp30_ = status;
			_tmp31_ = xmpp_xep_omemo_encrypt_state_get_other_devices (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = self->priv->trust_manager;
			_tmp34_ = self->priv->account;
			_tmp35_ = recipient;
			_tmp36_ = dino_plugins_omemo_trust_manager_get_trusted_devices (_tmp33_, _tmp34_, _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = gee_collection_get_size ((GeeCollection*) _tmp37_);
			_tmp39_ = _tmp38_;
			xmpp_xep_omemo_encrypt_state_set_other_devices (_tmp30_, _tmp32_ + _tmp39_);
			_g_object_unref0 (_tmp37_);
			_xmpp_jid_unref0 (recipient);
		}
	}
	_tmp41_ = status;
	_tmp42_ = xmpp_xep_omemo_encrypt_state_get_own_devices (_tmp41_);
	_tmp43_ = _tmp42_;
	if (_tmp43_ == 0) {
		_tmp40_ = TRUE;
	} else {
		XmppXepOmemoEncryptState* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		_tmp44_ = status;
		_tmp45_ = xmpp_xep_omemo_encrypt_state_get_other_devices (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp40_ = _tmp46_ == 0;
	}
	if (_tmp40_) {
		result = status;
		return result;
	}
	{
		GeeList* _recipient_list = NULL;
		gint _recipient_size = 0;
		GeeList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _recipient_index = 0;
		_recipient_list = recipients;
		_tmp47_ = _recipient_list;
		_tmp48_ = gee_collection_get_size ((GeeCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_recipient_size = _tmp49_;
		_recipient_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			XmppJid* recipient = NULL;
			GeeList* _tmp52_;
			gpointer _tmp53_;
			XmppXepOmemoEncryptionResult* enc_res = NULL;
			XmppJid* _tmp54_;
			XmppXepOmemoEncryptionResult* _tmp55_;
			XmppXepOmemoEncryptState* _tmp56_;
			XmppXepOmemoEncryptionResult* _tmp57_;
			_recipient_index = _recipient_index + 1;
			_tmp50_ = _recipient_index;
			_tmp51_ = _recipient_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _recipient_list;
			_tmp53_ = gee_list_get (_tmp52_, _recipient_index);
			recipient = (XmppJid*) _tmp53_;
			_tmp54_ = recipient;
			_tmp55_ = xmpp_xep_omemo_omemo_encryptor_encrypt_key_to_recipient ((XmppXepOmemoOmemoEncryptor*) self, stream, enc_data, _tmp54_, &_inner_error0_);
			enc_res = _tmp55_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_xmpp_jid_unref0 (recipient);
				_xmpp_xep_omemo_encrypt_state_unref0 (status);
				return NULL;
			}
			_tmp56_ = status;
			_tmp57_ = enc_res;
			xmpp_xep_omemo_encrypt_state_add_result (_tmp56_, _tmp57_, FALSE);
			_xmpp_xep_omemo_encryption_result_unref0 (enc_res);
			_xmpp_jid_unref0 (recipient);
		}
	}
	_tmp58_ = xmpp_xep_omemo_omemo_encryptor_encrypt_key_to_recipient ((XmppXepOmemoOmemoEncryptor*) self, stream, enc_data, self_jid, &_inner_error0_);
	enc_res = _tmp58_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_xmpp_xep_omemo_encrypt_state_unref0 (status);
		return NULL;
	}
	_tmp59_ = status;
	_tmp60_ = enc_res;
	xmpp_xep_omemo_encrypt_state_add_result (_tmp59_, _tmp60_, TRUE);
	result = status;
	_xmpp_xep_omemo_encryption_result_unref0 (enc_res);
	return result;
}

static XmppXepOmemoEncryptionResult*
dino_plugins_omemo_omemo_encryptor_real_encrypt_key_to_recipient (XmppXepOmemoOmemoEncryptor* base,
                                                                  XmppXmppStream* stream,
                                                                  XmppXepOmemoEncryptionData* enc_data,
                                                                  XmppJid* recipient,
                                                                  GError** error)
{
	DinoPluginsOmemoOmemoEncryptor * self;
	XmppXepOmemoEncryptionResult* _result_ = NULL;
	XmppXepOmemoEncryptionResult* _tmp0_;
	DinoPluginsOmemoStreamModule* module = NULL;
	XmppModuleIdentity* _tmp1_;
	gpointer _tmp2_;
	GError* _inner_error0_ = NULL;
	XmppXepOmemoEncryptionResult* result;
	self = (DinoPluginsOmemoOmemoEncryptor*) base;
	g_return_val_if_fail (stream != NULL, NULL);
	g_return_val_if_fail (enc_data != NULL, NULL);
	g_return_val_if_fail (recipient != NULL, NULL);
	_tmp0_ = xmpp_xep_omemo_encryption_result_new ();
	_result_ = _tmp0_;
	_tmp1_ = dino_plugins_omemo_stream_module_IDENTITY;
	_tmp2_ = xmpp_xmpp_stream_get_module (stream, DINO_PLUGINS_OMEMO_TYPE_STREAM_MODULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp1_);
	module = (DinoPluginsOmemoStreamModule*) _tmp2_;
	{
		GeeList* _device_id_list = NULL;
		DinoPluginsOmemoTrustManager* _tmp3_;
		DinoEntitiesAccount* _tmp4_;
		GeeList* _tmp5_;
		gint _device_id_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _device_id_index = 0;
		_tmp3_ = self->priv->trust_manager;
		_tmp4_ = self->priv->account;
		_tmp5_ = dino_plugins_omemo_trust_manager_get_trusted_devices (_tmp3_, _tmp4_, recipient);
		_device_id_list = _tmp5_;
		_tmp6_ = _device_id_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_device_id_size = _tmp8_;
		_device_id_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint32 device_id = 0;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			DinoPluginsOmemoStreamModule* _tmp13_;
			_device_id_index = _device_id_index + 1;
			_tmp9_ = _device_id_index;
			_tmp10_ = _device_id_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _device_id_list;
			_tmp12_ = gee_list_get (_tmp11_, _device_id_index);
			device_id = (gint32) ((gintptr) _tmp12_);
			_tmp13_ = module;
			if (dino_plugins_omemo_stream_module_is_ignored_device (_tmp13_, recipient, device_id)) {
				XmppXepOmemoEncryptionResult* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				_tmp14_ = _result_;
				_tmp15_ = xmpp_xep_omemo_encryption_result_get_lost (_tmp14_);
				_tmp16_ = _tmp15_;
				xmpp_xep_omemo_encryption_result_set_lost (_tmp14_, _tmp16_ + 1);
				continue;
			}
			{
				XmppXepOmemoEncryptionResult* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				xmpp_xep_omemo_omemo_encryptor_encrypt_key ((XmppXepOmemoOmemoEncryptor*) self, enc_data, recipient, device_id, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp17_ = _result_;
				_tmp18_ = xmpp_xep_omemo_encryption_result_get_success (_tmp17_);
				_tmp19_ = _tmp18_;
				xmpp_xep_omemo_encryption_result_set_success (_tmp17_, _tmp19_ + 1);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp20_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp20_ = e;
				if (_tmp20_->code == ((gint) SG_ERR_UNKNOWN)) {
					XmppXepOmemoEncryptionResult* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					_tmp21_ = _result_;
					_tmp22_ = xmpp_xep_omemo_encryption_result_get_unknown (_tmp21_);
					_tmp23_ = _tmp22_;
					xmpp_xep_omemo_encryption_result_set_unknown (_tmp21_, _tmp23_ + 1);
				} else {
					XmppXepOmemoEncryptionResult* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					_tmp24_ = _result_;
					_tmp25_ = xmpp_xep_omemo_encryption_result_get_failure (_tmp24_);
					_tmp26_ = _tmp25_;
					xmpp_xep_omemo_encryption_result_set_failure (_tmp24_, _tmp26_ + 1);
				}
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_device_id_list);
				_g_object_unref0 (module);
				_xmpp_xep_omemo_encryption_result_unref0 (_result_);
				return NULL;
			}
		}
		_g_object_unref0 (_device_id_list);
	}
	result = _result_;
	_g_object_unref0 (module);
	return result;
}

static ciphertext_message*
session_cipher_encrypt_ (session_cipher* self,
                         guint8* padded_message,
                         gint padded_message_length1,
                         GError** error)
{
	ciphertext_message* res = NULL;
	ciphertext_message* _tmp0_ = NULL;
	gint _tmp1_;
	GError* _inner_error0_ = NULL;
	ciphertext_message* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = session_cipher_encrypt (self, padded_message, (gint) padded_message_length1, &_tmp0_);
	_signal_type_unref_vapi0 (res);
	res = _tmp0_;
	signal_throw_gerror_by_code_ (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (res);
		return NULL;
	}
	result = res;
	return result;
}

static guint8*
ciphertext_message_get_serialized_ (ciphertext_message* self,
                                    gint* result_length1)
{
	guint8* result;
	signal_buffer* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ciphertext_message_get_serialized (self);
	_tmp1_ = signal_buffer_get_data (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static void
dino_plugins_omemo_omemo_encryptor_real_encrypt_key (XmppXepOmemoOmemoEncryptor* base,
                                                     XmppXepOmemoEncryptionData* encryption_data,
                                                     XmppJid* jid,
                                                     gint32 device_id,
                                                     GError** error)
{
	DinoPluginsOmemoOmemoEncryptor * self;
	signal_protocol_address* address = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	signal_protocol_address* _tmp2_;
	signal_protocol_address* _tmp3_;
	session_cipher* cipher = NULL;
	OmemoStore* _tmp4_;
	signal_protocol_address* _tmp5_;
	session_cipher* _tmp6_;
	ciphertext_message* device_key = NULL;
	session_cipher* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	ciphertext_message* _tmp9_;
	signal_protocol_address* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	ciphertext_message* _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_ = 0;
	guint8* _tmp16_;
	gint _tmp16__length1;
	ciphertext_message* _tmp17_;
	int _tmp18_;
	int _tmp19_;
	GError* _inner_error0_ = NULL;
	self = (DinoPluginsOmemoOmemoEncryptor*) base;
	g_return_if_fail (encryption_data != NULL);
	g_return_if_fail (jid != NULL);
	_tmp0_ = xmpp_jid_to_string (jid);
	_tmp1_ = _tmp0_;
	_tmp2_ = signal_protocol_address_new (_tmp1_, device_id);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	address = _tmp3_;
	_tmp4_ = self->priv->store;
	_tmp5_ = address;
	_tmp6_ = omemo_store_create_session_cipher (_tmp4_, _tmp5_, &_inner_error0_);
	cipher = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_protocol_address_free0 (address);
		return;
	}
	_tmp7_ = cipher;
	_tmp8_ = encryption_data->keytag;
	_tmp8__length1 = encryption_data->keytag_length1;
	_tmp9_ = session_cipher_encrypt_ (_tmp7_, _tmp8_, (gint) _tmp8__length1, &_inner_error0_);
	device_key = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_session_cipher_free0 (cipher);
		_signal_protocol_address_free0 (address);
		return;
	}
	_tmp10_ = address;
	signal_protocol_address_set_device_id (_tmp10_, (gint32) 0);
	_tmp11_ = xmpp_jid_to_string (jid);
	_tmp12_ = _tmp11_;
	g_debug ("encrypt.vala:126: Created encrypted key for %s/%d", _tmp12_, (gint) device_id);
	_g_free0 (_tmp12_);
	_tmp13_ = device_key;
	_tmp14_ = ciphertext_message_get_serialized_ (_tmp13_, &_tmp15_);
	_tmp14__length1 = _tmp15_;
	_tmp16_ = _tmp14_;
	_tmp16__length1 = _tmp14__length1;
	_tmp17_ = device_key;
	_tmp18_ = ciphertext_message_get_type (_tmp17_);
	_tmp19_ = _tmp18_;
	xmpp_xep_omemo_encryption_data_add_device_key (encryption_data, (gint) device_id, _tmp16_, (gint) _tmp16__length1, _tmp19_ == CIPHERTEXT_PREKEY_TYPE);
	_signal_type_unref_vapi0 (device_key);
	_session_cipher_free0 (cipher);
	_signal_protocol_address_free0 (address);
}

static guint32
dino_plugins_omemo_omemo_encryptor_real_get_own_device_id (XmppXepOmemoOmemoEncryptor* base)
{
	guint32 result;
	DinoPluginsOmemoOmemoEncryptor* self;
	OmemoStore* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	self = (DinoPluginsOmemoOmemoEncryptor*) base;
	_tmp0_ = self->priv->store;
	_tmp1_ = omemo_store_get_local_registration_id (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
dino_plugins_omemo_omemo_encryptor_class_init (DinoPluginsOmemoOmemoEncryptorClass * klass,
                                               gpointer klass_data)
{
	dino_plugins_omemo_omemo_encryptor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DinoPluginsOmemoOmemoEncryptor_private_offset);
	((XmppXepOmemoOmemoEncryptorClass *) klass)->encrypt_plaintext = (XmppXepOmemoEncryptionData* (*) (XmppXepOmemoOmemoEncryptor*, const gchar*, GError**)) dino_plugins_omemo_omemo_encryptor_real_encrypt_plaintext;
	((XmppXepOmemoOmemoEncryptorClass *) klass)->encrypt_key_to_recipient = (XmppXepOmemoEncryptionResult* (*) (XmppXepOmemoOmemoEncryptor*, XmppXmppStream*, XmppXepOmemoEncryptionData*, XmppJid*, GError**)) dino_plugins_omemo_omemo_encryptor_real_encrypt_key_to_recipient;
	((XmppXepOmemoOmemoEncryptorClass *) klass)->encrypt_key = (void (*) (XmppXepOmemoOmemoEncryptor*, XmppXepOmemoEncryptionData*, XmppJid*, gint32, GError**)) dino_plugins_omemo_omemo_encryptor_real_encrypt_key;
	XMPP_XEP_OMEMO_OMEMO_ENCRYPTOR_CLASS (klass)->get_own_device_id = (guint32 (*) (XmppXepOmemoOmemoEncryptor*)) dino_plugins_omemo_omemo_encryptor_real_get_own_device_id;
	G_OBJECT_CLASS (klass)->get_property = _vala_dino_plugins_omemo_omemo_encryptor_get_property;
	G_OBJECT_CLASS (klass)->finalize = dino_plugins_omemo_omemo_encryptor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_PLUGINS_OMEMO_OMEMO_ENCRYPTOR_OWN_DEVICE_ID_PROPERTY, dino_plugins_omemo_omemo_encryptor_properties[DINO_PLUGINS_OMEMO_OMEMO_ENCRYPTOR_OWN_DEVICE_ID_PROPERTY] = g_param_spec_uint ("own-device-id", "own-device-id", "own-device-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
dino_plugins_omemo_omemo_encryptor_instance_init (DinoPluginsOmemoOmemoEncryptor * self,
                                                  gpointer klass)
{
	self->priv = dino_plugins_omemo_omemo_encryptor_get_instance_private (self);
}

static void
dino_plugins_omemo_omemo_encryptor_finalize (GObject * obj)
{
	DinoPluginsOmemoOmemoEncryptor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_OMEMO_TYPE_OMEMO_ENCRYPTOR, DinoPluginsOmemoOmemoEncryptor);
	_g_object_unref0 (self->priv->account);
	_g_object_unref0 (self->priv->store);
	_dino_plugins_omemo_trust_manager_unref0 (self->priv->trust_manager);
	G_OBJECT_CLASS (dino_plugins_omemo_omemo_encryptor_parent_class)->finalize (obj);
}

static GType
dino_plugins_omemo_omemo_encryptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoPluginsOmemoOmemoEncryptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_plugins_omemo_omemo_encryptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoPluginsOmemoOmemoEncryptor), 0, (GInstanceInitFunc) dino_plugins_omemo_omemo_encryptor_instance_init, NULL };
	GType dino_plugins_omemo_omemo_encryptor_type_id;
	dino_plugins_omemo_omemo_encryptor_type_id = g_type_register_static (XMPP_XEP_OMEMO_TYPE_OMEMO_ENCRYPTOR, "DinoPluginsOmemoOmemoEncryptor", &g_define_type_info, 0);
	DinoPluginsOmemoOmemoEncryptor_private_offset = g_type_add_instance_private (dino_plugins_omemo_omemo_encryptor_type_id, sizeof (DinoPluginsOmemoOmemoEncryptorPrivate));
	return dino_plugins_omemo_omemo_encryptor_type_id;
}

GType
dino_plugins_omemo_omemo_encryptor_get_type (void)
{
	static volatile gsize dino_plugins_omemo_omemo_encryptor_type_id__once = 0;
	if (g_once_init_enter (&dino_plugins_omemo_omemo_encryptor_type_id__once)) {
		GType dino_plugins_omemo_omemo_encryptor_type_id;
		dino_plugins_omemo_omemo_encryptor_type_id = dino_plugins_omemo_omemo_encryptor_get_type_once ();
		g_once_init_leave (&dino_plugins_omemo_omemo_encryptor_type_id__once, dino_plugins_omemo_omemo_encryptor_type_id);
	}
	return dino_plugins_omemo_omemo_encryptor_type_id__once;
}

static void
_vala_dino_plugins_omemo_omemo_encryptor_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	DinoPluginsOmemoOmemoEncryptor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DINO_PLUGINS_OMEMO_TYPE_OMEMO_ENCRYPTOR, DinoPluginsOmemoOmemoEncryptor);
	switch (property_id) {
		case DINO_PLUGINS_OMEMO_OMEMO_ENCRYPTOR_OWN_DEVICE_ID_PROPERTY:
		g_value_set_uint (value, xmpp_xep_omemo_omemo_encryptor_get_own_device_id ((XmppXepOmemoOmemoEncryptor*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

