/* stream_module.c generated by valac 0.56.18, the Vala compiler
 * generated from stream_module.vala, do not modify */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "openpgp.h"
#include <gpgme.h>
#include <gpgme_fix.h>
#include "xmpp-vala.h"
#include <glib-object.h>
#include <gio/gio.h>

#define DINO_PLUGINS_OPEN_PGP_NS_URI "jabber:x"
#define DINO_PLUGINS_OPEN_PGP_NS_URI_ENCRYPTED DINO_PLUGINS_OPEN_PGP_NS_URI ":encrypted"
#define DINO_PLUGINS_OPEN_PGP_NS_URI_SIGNED DINO_PLUGINS_OPEN_PGP_NS_URI ":signed"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DINO_PLUGINS_OPEN_PGP_MODULE_0_PROPERTY,
	DINO_PLUGINS_OPEN_PGP_MODULE_NUM_PROPERTIES
};
static GParamSpec* dino_plugins_open_pgp_module_properties[DINO_PLUGINS_OPEN_PGP_MODULE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gpgme_key_unref_vapi0(var) ((var == NULL) ? NULL : (var = (gpgme_key_unref_vapi (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _xmpp_stanza_entry_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_stanza_entry_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _xmpp_jid_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_jid_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
enum  {
	DINO_PLUGINS_OPEN_PGP_MODULE_RECEIVED_JID_KEY_ID_SIGNAL,
	DINO_PLUGINS_OPEN_PGP_MODULE_NUM_SIGNALS
};
static guint dino_plugins_open_pgp_module_signals[DINO_PLUGINS_OPEN_PGP_MODULE_NUM_SIGNALS] = {0};
enum  {
	DINO_PLUGINS_OPEN_PGP_MESSAGE_FLAG_0_PROPERTY,
	DINO_PLUGINS_OPEN_PGP_MESSAGE_FLAG_NUM_PROPERTIES
};
static GParamSpec* dino_plugins_open_pgp_message_flag_properties[DINO_PLUGINS_OPEN_PGP_MESSAGE_FLAG_NUM_PROPERTIES];
enum  {
	DINO_PLUGINS_OPEN_PGP_RECEIVED_PIPELINE_DECRYPT_LISTENER_0_PROPERTY,
	DINO_PLUGINS_OPEN_PGP_RECEIVED_PIPELINE_DECRYPT_LISTENER_ACTION_GROUP_PROPERTY,
	DINO_PLUGINS_OPEN_PGP_RECEIVED_PIPELINE_DECRYPT_LISTENER_AFTER_ACTIONS_PROPERTY,
	DINO_PLUGINS_OPEN_PGP_RECEIVED_PIPELINE_DECRYPT_LISTENER_NUM_PROPERTIES
};
static GParamSpec* dino_plugins_open_pgp_received_pipeline_decrypt_listener_properties[DINO_PLUGINS_OPEN_PGP_RECEIVED_PIPELINE_DECRYPT_LISTENER_NUM_PROPERTIES];
typedef struct _DinoPluginsOpenPgpReceivedPipelineDecryptListenerRunData DinoPluginsOpenPgpReceivedPipelineDecryptListenerRunData;
typedef struct _Block6Data Block6Data;
typedef struct _DinoPluginsOpenPgpReceivedPipelineDecryptListenerGpgDecryptData DinoPluginsOpenPgpReceivedPipelineDecryptListenerGpgDecryptData;

struct _DinoPluginsOpenPgpModulePrivate {
	gchar* signed_status;
	struct _gpgme_key* own_key;
	DinoPluginsOpenPgpReceivedPipelineDecryptListener* received_pipeline_decrypt_listener;
};

struct _Block4Data {
	int _ref_count_;
	DinoPluginsOpenPgpModule* self;
	gchar* sig;
	XmppXmppStream* stream;
	XmppPresenceStanza* presence;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	gchar* key_id;
};

struct _DinoPluginsOpenPgpReceivedPipelineDecryptListenerPrivate {
	gchar** after_actions_const;
	gint after_actions_const_length1;
	gint _after_actions_const_size_;
};

struct _DinoPluginsOpenPgpReceivedPipelineDecryptListenerRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DinoPluginsOpenPgpReceivedPipelineDecryptListener* self;
	XmppXmppStream* stream;
	XmppMessageStanza* message;
	gboolean result;
	gchar* encrypted;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	DinoPluginsOpenPgpMessageFlag* flag;
	DinoPluginsOpenPgpMessageFlag* _tmp2_;
	DinoPluginsOpenPgpMessageFlag* _tmp3_;
	gchar* decrypted;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	DinoPluginsOpenPgpMessageFlag* _tmp7_;
	const gchar* _tmp8_;
};

struct _Block6Data {
	int _ref_count_;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gchar* res;
	gchar* enc;
	gpointer _async_data_;
};

struct _DinoPluginsOpenPgpReceivedPipelineDecryptListenerGpgDecryptData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* enc;
	gchar* result;
	Block6Data* _data6_;
	GThread* _tmp0_;
	GThread* _tmp1_;
	gchar* _tmp2_;
};

static gint DinoPluginsOpenPgpModule_private_offset;
static gpointer dino_plugins_open_pgp_module_parent_class = NULL;
XmppModuleIdentity* dino_plugins_open_pgp_module_IDENTITY = NULL;
static gpointer dino_plugins_open_pgp_message_flag_parent_class = NULL;
static gint DinoPluginsOpenPgpReceivedPipelineDecryptListener_private_offset;
static gpointer dino_plugins_open_pgp_received_pipeline_decrypt_listener_parent_class = NULL;

static gchar* dino_plugins_open_pgp_module_gpg_sign (const gchar* str,
                                              struct _gpgme_key* key);
static gchar* dino_plugins_open_pgp_module_gpg_encrypt (const gchar* plain,
                                                 struct _gpgme_key** keys,
                                                 gint keys_length1);
static void dino_plugins_open_pgp_module_real_attach (XmppXmppStreamModule* base,
                                               XmppXmppStream* stream);
static void dino_plugins_open_pgp_module_on_received_presence (DinoPluginsOpenPgpModule* self,
                                                        XmppXmppStream* stream,
                                                        XmppPresenceStanza* presence);
static void _dino_plugins_open_pgp_module_on_received_presence_xmpp_presence_module_received_presence (XmppPresenceModule* _sender,
                                                                                                XmppXmppStream* stream,
                                                                                                XmppPresenceStanza* presence,
                                                                                                gpointer self);
static void dino_plugins_open_pgp_module_on_pre_send_presence_stanza (DinoPluginsOpenPgpModule* self,
                                                               XmppXmppStream* stream,
                                                               XmppPresenceStanza* presence);
static void _dino_plugins_open_pgp_module_on_pre_send_presence_stanza_xmpp_presence_module_pre_send_presence_stanza (XmppPresenceModule* _sender,
                                                                                                              XmppXmppStream* stream,
                                                                                                              XmppPresenceStanza* presence,
                                                                                                              gpointer self);
static void dino_plugins_open_pgp_module_real_detach (XmppXmppStreamModule* base,
                                               XmppXmppStream* stream);
static gchar* dino_plugins_open_pgp_module_real_get_ns (XmppXmppStreamModule* base);
static gchar* dino_plugins_open_pgp_module_real_get_id (XmppXmppStreamModule* base);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void* __lambda5_ (Block4Data* _data4_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gchar* dino_plugins_open_pgp_module_get_sign_key (const gchar* sig,
                                                  const gchar* signed_text);
static gboolean ___lambda6_ (Block5Data* _data5_);
static gboolean ____lambda6__gsource_func (gpointer self);
static gpointer ___lambda5__gthread_func (gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_XMPP_JID_STRING (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data);
static void dino_plugins_open_pgp_module_finalize (GObject * obj);
static GType dino_plugins_open_pgp_module_get_type_once (void);
static gchar* dino_plugins_open_pgp_message_flag_real_get_ns (XmppMessageFlag* base);
static gchar* dino_plugins_open_pgp_message_flag_real_get_id (XmppMessageFlag* base);
static void dino_plugins_open_pgp_message_flag_finalize (GObject * obj);
static GType dino_plugins_open_pgp_message_flag_get_type_once (void);
static void dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_run_data_free (gpointer _data);
static void dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_run (XmppStanzaListener* base,
                                                                        XmppXmppStream* stream,
                                                                        XmppMessageStanza* message,
                                                                        GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_);
static gboolean dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_run_co (DinoPluginsOpenPgpReceivedPipelineDecryptListenerRunData* _data_);
static gchar* dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_cyphertext (DinoPluginsOpenPgpReceivedPipelineDecryptListener* self,
                                                                                XmppMessageStanza* message);
static void dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt (const gchar* enc,
                                                                           GAsyncReadyCallback _callback_,
                                                                           gpointer _user_data_);
static gchar* dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_finish (GAsyncResult* _res_);
static void dino_plugins_open_pgp_received_pipeline_decrypt_listener_run_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_);
static void dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_data_free (gpointer _data);
static gboolean dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_co (DinoPluginsOpenPgpReceivedPipelineDecryptListenerGpgDecryptData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean _dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_co_gsource_func (gpointer self);
static void* __lambda4_ (Block6Data* _data6_);
static gpointer ___lambda4__gthread_func (gpointer self);
static void dino_plugins_open_pgp_received_pipeline_decrypt_listener_finalize (GObject * obj);
static GType dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_type_once (void);
static void _vala_dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_property (GObject * object,
                                                                                  guint property_id,
                                                                                  GValue * value,
                                                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
dino_plugins_open_pgp_module_get_instance_private (DinoPluginsOpenPgpModule* self)
{
	return G_STRUCT_MEMBER_P (self, DinoPluginsOpenPgpModule_private_offset);
}

DinoPluginsOpenPgpModule*
dino_plugins_open_pgp_module_construct (GType object_type,
                                        const gchar* own_key_id)
{
	DinoPluginsOpenPgpModule * self = NULL;
	self = (DinoPluginsOpenPgpModule*) xmpp_xmpp_stream_module_construct (object_type);
	dino_plugins_open_pgp_module_set_private_key_id (self, own_key_id);
	return self;
}

DinoPluginsOpenPgpModule*
dino_plugins_open_pgp_module_new (const gchar* own_key_id)
{
	return dino_plugins_open_pgp_module_construct (DINO_PLUGINS_OPEN_PGP_TYPE_MODULE, own_key_id);
}

void
dino_plugins_open_pgp_module_set_private_key_id (DinoPluginsOpenPgpModule* self,
                                                 const gchar* own_key_id)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (own_key_id != NULL) {
		struct _gpgme_key* _tmp4_;
		{
			struct _gpgme_key* _tmp0_ = NULL;
			struct _gpgme_key* _tmp1_;
			struct _gpgme_key* _tmp2_;
			struct _gpgme_key* _tmp3_;
			_tmp1_ = gpg_helper_get_private_key (own_key_id, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_gpgme_key_unref_vapi0 (self->priv->own_key);
			self->priv->own_key = _tmp2_;
			_tmp3_ = self->priv->own_key;
			if (_tmp3_ == NULL) {
				g_warning ("stream_module.vala:27: Can't get PGP private key");
			}
			_gpgme_key_unref_vapi0 (_tmp0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = self->priv->own_key;
		if (_tmp4_ != NULL) {
			struct _gpgme_key* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = self->priv->own_key;
			_tmp6_ = dino_plugins_open_pgp_module_gpg_sign ("", _tmp5_);
			_g_free0 (self->priv->signed_status);
			self->priv->signed_status = _tmp6_;
		}
	}
}

gboolean
dino_plugins_open_pgp_module_encrypt (DinoPluginsOpenPgpModule* self,
                                      XmppMessageStanza* message,
                                      struct _gpgme_key** keys,
                                      gint keys_length1)
{
	gchar* enc_body = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = xmpp_message_stanza_get_body (message);
	_tmp1_ = _tmp0_;
	_tmp2_ = dino_plugins_open_pgp_module_gpg_encrypt (_tmp1_, keys, (gint) keys_length1);
	enc_body = _tmp2_;
	_tmp3_ = enc_body;
	if (_tmp3_ != NULL) {
		XmppStanzaNode* _tmp4_;
		XmppStanzaNode* _tmp5_;
		XmppStanzaNode* _tmp6_;
		XmppStanzaNode* _tmp7_;
		XmppStanzaNode* _tmp8_;
		const gchar* _tmp9_;
		XmppStanzaNode* _tmp10_;
		XmppStanzaNode* _tmp11_;
		XmppStanzaNode* _tmp12_;
		XmppStanzaNode* _tmp13_;
		XmppStanzaNode* _tmp14_;
		XmppStanzaNode* _tmp15_;
		_tmp4_ = ((XmppStanza*) message)->stanza;
		_tmp5_ = xmpp_stanza_node_new_build ("x", DINO_PLUGINS_OPEN_PGP_NS_URI_ENCRYPTED, NULL, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = xmpp_stanza_node_add_self_xmlns (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = enc_body;
		_tmp10_ = xmpp_stanza_node_new_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = xmpp_stanza_node_put_node (_tmp8_, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = xmpp_stanza_node_put_node (_tmp4_, _tmp13_);
		_tmp15_ = _tmp14_;
		_xmpp_stanza_entry_unref0 (_tmp15_);
		_xmpp_stanza_entry_unref0 (_tmp13_);
		_xmpp_stanza_entry_unref0 (_tmp11_);
		_xmpp_stanza_entry_unref0 (_tmp8_);
		_xmpp_stanza_entry_unref0 (_tmp6_);
		xmpp_message_stanza_set_body (message, "[This message is OpenPGP encrypted (see XEP-0027)]");
		xmpp_xep_explicit_encryption_add_encryption_tag_to_message (message, DINO_PLUGINS_OPEN_PGP_NS_URI_ENCRYPTED, NULL);
		result = TRUE;
		_g_free0 (enc_body);
		return result;
	}
	result = FALSE;
	_g_free0 (enc_body);
	return result;
}

static void
_dino_plugins_open_pgp_module_on_received_presence_xmpp_presence_module_received_presence (XmppPresenceModule* _sender,
                                                                                           XmppXmppStream* stream,
                                                                                           XmppPresenceStanza* presence,
                                                                                           gpointer self)
{
	dino_plugins_open_pgp_module_on_received_presence ((DinoPluginsOpenPgpModule*) self, stream, presence);
}

static void
_dino_plugins_open_pgp_module_on_pre_send_presence_stanza_xmpp_presence_module_pre_send_presence_stanza (XmppPresenceModule* _sender,
                                                                                                         XmppXmppStream* stream,
                                                                                                         XmppPresenceStanza* presence,
                                                                                                         gpointer self)
{
	dino_plugins_open_pgp_module_on_pre_send_presence_stanza ((DinoPluginsOpenPgpModule*) self, stream, presence);
}

static void
dino_plugins_open_pgp_module_real_attach (XmppXmppStreamModule* base,
                                          XmppXmppStream* stream)
{
	DinoPluginsOpenPgpModule * self;
	XmppModuleIdentity* _tmp0_;
	gpointer _tmp1_;
	XmppPresenceModule* _tmp2_;
	XmppModuleIdentity* _tmp3_;
	gpointer _tmp4_;
	XmppPresenceModule* _tmp5_;
	XmppModuleIdentity* _tmp6_;
	gpointer _tmp7_;
	XmppMessageModule* _tmp8_;
	XmppStanzaListenerHolder* _tmp9_;
	DinoPluginsOpenPgpReceivedPipelineDecryptListener* _tmp10_;
	DinoPluginsOpenPgpFlag* _tmp11_;
	DinoPluginsOpenPgpFlag* _tmp12_;
	self = (DinoPluginsOpenPgpModule*) base;
	g_return_if_fail (stream != NULL);
	_tmp0_ = xmpp_presence_module_IDENTITY;
	_tmp1_ = xmpp_xmpp_stream_get_module (stream, XMPP_PRESENCE_TYPE_MODULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	_tmp2_ = (XmppPresenceModule*) _tmp1_;
	g_signal_connect_object (_tmp2_, "received-presence", (GCallback) _dino_plugins_open_pgp_module_on_received_presence_xmpp_presence_module_received_presence, self, 0);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = xmpp_presence_module_IDENTITY;
	_tmp4_ = xmpp_xmpp_stream_get_module (stream, XMPP_PRESENCE_TYPE_MODULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_);
	_tmp5_ = (XmppPresenceModule*) _tmp4_;
	g_signal_connect_object (_tmp5_, "pre-send-presence-stanza", (GCallback) _dino_plugins_open_pgp_module_on_pre_send_presence_stanza_xmpp_presence_module_pre_send_presence_stanza, self, 0);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = xmpp_message_module_IDENTITY;
	_tmp7_ = xmpp_xmpp_stream_get_module (stream, XMPP_TYPE_MESSAGE_MODULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp6_);
	_tmp8_ = (XmppMessageModule*) _tmp7_;
	_tmp9_ = _tmp8_->received_pipeline;
	_tmp10_ = self->priv->received_pipeline_decrypt_listener;
	xmpp_listener_holder_connect ((XmppListenerHolder*) _tmp9_, (XmppOrderedListener*) _tmp10_);
	_g_object_unref0 (_tmp8_);
	_tmp11_ = dino_plugins_open_pgp_flag_new ();
	_tmp12_ = _tmp11_;
	xmpp_xmpp_stream_add_flag (stream, (XmppXmppStreamFlag*) _tmp12_);
	_g_object_unref0 (_tmp12_);
}

static void
dino_plugins_open_pgp_module_real_detach (XmppXmppStreamModule* base,
                                          XmppXmppStream* stream)
{
	DinoPluginsOpenPgpModule * self;
	XmppModuleIdentity* _tmp0_;
	gpointer _tmp1_;
	XmppPresenceModule* _tmp2_;
	guint _tmp3_;
	XmppModuleIdentity* _tmp4_;
	gpointer _tmp5_;
	XmppPresenceModule* _tmp6_;
	guint _tmp7_;
	XmppModuleIdentity* _tmp8_;
	gpointer _tmp9_;
	XmppMessageModule* _tmp10_;
	XmppStanzaListenerHolder* _tmp11_;
	DinoPluginsOpenPgpReceivedPipelineDecryptListener* _tmp12_;
	self = (DinoPluginsOpenPgpModule*) base;
	g_return_if_fail (stream != NULL);
	_tmp0_ = xmpp_presence_module_IDENTITY;
	_tmp1_ = xmpp_xmpp_stream_get_module (stream, XMPP_PRESENCE_TYPE_MODULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	_tmp2_ = (XmppPresenceModule*) _tmp1_;
	g_signal_parse_name ("received-presence", XMPP_PRESENCE_TYPE_MODULE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _dino_plugins_open_pgp_module_on_received_presence_xmpp_presence_module_received_presence, self);
	_g_object_unref0 (_tmp2_);
	_tmp4_ = xmpp_presence_module_IDENTITY;
	_tmp5_ = xmpp_xmpp_stream_get_module (stream, XMPP_PRESENCE_TYPE_MODULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp4_);
	_tmp6_ = (XmppPresenceModule*) _tmp5_;
	g_signal_parse_name ("pre-send-presence-stanza", XMPP_PRESENCE_TYPE_MODULE, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _dino_plugins_open_pgp_module_on_pre_send_presence_stanza_xmpp_presence_module_pre_send_presence_stanza, self);
	_g_object_unref0 (_tmp6_);
	_tmp8_ = xmpp_message_module_IDENTITY;
	_tmp9_ = xmpp_xmpp_stream_get_module (stream, XMPP_TYPE_MESSAGE_MODULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp8_);
	_tmp10_ = (XmppMessageModule*) _tmp9_;
	_tmp11_ = _tmp10_->received_pipeline;
	_tmp12_ = self->priv->received_pipeline_decrypt_listener;
	xmpp_listener_holder_disconnect ((XmppListenerHolder*) _tmp11_, (XmppOrderedListener*) _tmp12_);
	_g_object_unref0 (_tmp10_);
}

void
dino_plugins_open_pgp_module_require (XmppXmppStream* stream)
{
	XmppModuleIdentity* _tmp0_;
	gpointer _tmp1_;
	DinoPluginsOpenPgpModule* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (stream != NULL);
	_tmp0_ = dino_plugins_open_pgp_module_IDENTITY;
	_tmp1_ = xmpp_xmpp_stream_get_module (stream, DINO_PLUGINS_OPEN_PGP_TYPE_MODULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	_tmp2_ = (DinoPluginsOpenPgpModule*) _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		DinoPluginsOpenPgpModule* _tmp4_;
		DinoPluginsOpenPgpModule* _tmp5_;
		XmppXmppStream* _tmp6_;
		XmppXmppStream* _tmp7_;
		_tmp4_ = dino_plugins_open_pgp_module_new (NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = xmpp_xmpp_stream_add_module (stream, (XmppXmppStreamModule*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp5_);
	}
}

static gchar*
dino_plugins_open_pgp_module_real_get_ns (XmppXmppStreamModule* base)
{
	DinoPluginsOpenPgpModule * self;
	gchar* _tmp0_;
	gchar* result;
	self = (DinoPluginsOpenPgpModule*) base;
	_tmp0_ = g_strdup (DINO_PLUGINS_OPEN_PGP_NS_URI);
	result = _tmp0_;
	return result;
}

static gchar*
dino_plugins_open_pgp_module_real_get_id (XmppXmppStreamModule* base)
{
	DinoPluginsOpenPgpModule * self;
	XmppModuleIdentity* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = (DinoPluginsOpenPgpModule*) base;
	_tmp0_ = dino_plugins_open_pgp_module_IDENTITY;
	_tmp1_ = xmpp_module_identity_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		DinoPluginsOpenPgpModule* self;
		self = _data4_->self;
		_g_free0 (_data4_->sig);
		_g_object_unref0 (_data4_->stream);
		_g_object_unref0 (_data4_->presence);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		DinoPluginsOpenPgpModule* self;
		self = _data5_->_data4_->self;
		_g_free0 (_data5_->key_id);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
___lambda6_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	DinoPluginsOpenPgpModule* self;
	XmppJid* _tmp0_;
	XmppJid* _tmp1_;
	XmppJid* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	_tmp0_ = xmpp_stanza_get_from ((XmppStanza*) _data4_->presence);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _data5_->key_id;
	g_signal_emit (self, dino_plugins_open_pgp_module_signals[DINO_PLUGINS_OPEN_PGP_MODULE_RECEIVED_JID_KEY_ID_SIGNAL], 0, _data4_->stream, _tmp2_, _tmp3_);
	_xmpp_jid_unref0 (_tmp2_);
	result = FALSE;
	return result;
}

static gboolean
____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda6_ (self);
	return result;
}

static void*
__lambda5_ (Block4Data* _data4_)
{
	DinoPluginsOpenPgpModule* self;
	Block5Data* _data5_;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* signed_data = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	void* result;
	self = _data4_->self;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->_data4_ = block4_data_ref (_data4_);
	_tmp1_ = xmpp_presence_stanza_get_status (_data4_->presence);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = "";
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = xmpp_presence_stanza_get_status (_data4_->presence);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp0_);
	signed_data = _tmp5_;
	_tmp6_ = _data4_->sig;
	_tmp7_ = signed_data;
	_tmp8_ = dino_plugins_open_pgp_module_get_sign_key (_tmp6_, _tmp7_);
	_data5_->key_id = _tmp8_;
	_tmp9_ = _data5_->key_id;
	if (_tmp9_ != NULL) {
		XmppFlagIdentity* _tmp10_;
		gpointer _tmp11_;
		DinoPluginsOpenPgpFlag* _tmp12_;
		XmppJid* _tmp13_;
		XmppJid* _tmp14_;
		XmppJid* _tmp15_;
		const gchar* _tmp16_;
		_tmp10_ = dino_plugins_open_pgp_flag_IDENTITY;
		_tmp11_ = xmpp_xmpp_stream_get_flag (_data4_->stream, DINO_PLUGINS_OPEN_PGP_TYPE_FLAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp10_);
		_tmp12_ = (DinoPluginsOpenPgpFlag*) _tmp11_;
		_tmp13_ = xmpp_stanza_get_from ((XmppStanza*) _data4_->presence);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = _data5_->key_id;
		dino_plugins_open_pgp_flag_set_key_id (_tmp12_, _tmp15_, _tmp16_);
		_xmpp_jid_unref0 (_tmp15_);
		_g_object_unref0 (_tmp12_);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda6__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	}
	result = NULL;
	_g_free0 (signed_data);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

static gpointer
___lambda5__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda5_ (self);
	block4_data_unref (self);
	return result;
}

static void
dino_plugins_open_pgp_module_on_received_presence (DinoPluginsOpenPgpModule* self,
                                                   XmppXmppStream* stream,
                                                   XmppPresenceStanza* presence)
{
	Block4Data* _data4_;
	XmppXmppStream* _tmp0_;
	XmppPresenceStanza* _tmp1_;
	XmppStanzaNode* x_node = NULL;
	XmppStanzaNode* _tmp2_;
	XmppStanzaNode* _tmp3_;
	XmppStanzaNode* _tmp4_;
	XmppStanzaNode* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GThread* _tmp9_;
	GThread* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stream != NULL);
	g_return_if_fail (presence != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (stream);
	_g_object_unref0 (_data4_->stream);
	_data4_->stream = _tmp0_;
	_tmp1_ = _g_object_ref0 (presence);
	_g_object_unref0 (_data4_->presence);
	_data4_->presence = _tmp1_;
	_tmp2_ = ((XmppStanza*) _data4_->presence)->stanza;
	_tmp3_ = xmpp_stanza_node_get_subnode (_tmp2_, "x", DINO_PLUGINS_OPEN_PGP_NS_URI_SIGNED, FALSE);
	x_node = _tmp3_;
	_tmp4_ = x_node;
	if (_tmp4_ == NULL) {
		_xmpp_stanza_entry_unref0 (x_node);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp5_ = x_node;
	_tmp6_ = xmpp_stanza_entry_get_string_content ((XmppStanzaEntry*) _tmp5_);
	_tmp7_ = g_strdup (_tmp6_);
	_data4_->sig = _tmp7_;
	_tmp8_ = _data4_->sig;
	if (_tmp8_ == NULL) {
		_xmpp_stanza_entry_unref0 (x_node);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp9_ = g_thread_new (NULL, ___lambda5__gthread_func, block4_data_ref (_data4_));
	_tmp10_ = _tmp9_;
	_g_thread_unref0 (_tmp10_);
	_xmpp_stanza_entry_unref0 (x_node);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
dino_plugins_open_pgp_module_on_pre_send_presence_stanza (DinoPluginsOpenPgpModule* self,
                                                          XmppXmppStream* stream,
                                                          XmppPresenceStanza* presence)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stream != NULL);
	g_return_if_fail (presence != NULL);
	_tmp1_ = xmpp_stanza_get_type_ ((XmppStanza*) presence);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, XMPP_PRESENCE_STANZA_TYPE_AVAILABLE) == 0) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->signed_status;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		XmppStanzaNode* _tmp4_;
		XmppStanzaNode* _tmp5_;
		XmppStanzaNode* _tmp6_;
		XmppStanzaNode* _tmp7_;
		XmppStanzaNode* _tmp8_;
		const gchar* _tmp9_;
		XmppStanzaNode* _tmp10_;
		XmppStanzaNode* _tmp11_;
		XmppStanzaNode* _tmp12_;
		XmppStanzaNode* _tmp13_;
		XmppStanzaNode* _tmp14_;
		XmppStanzaNode* _tmp15_;
		_tmp4_ = ((XmppStanza*) presence)->stanza;
		_tmp5_ = xmpp_stanza_node_new_build ("x", DINO_PLUGINS_OPEN_PGP_NS_URI_SIGNED, NULL, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = xmpp_stanza_node_add_self_xmlns (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->signed_status;
		_tmp10_ = xmpp_stanza_node_new_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = xmpp_stanza_node_put_node (_tmp8_, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = xmpp_stanza_node_put_node (_tmp4_, _tmp13_);
		_tmp15_ = _tmp14_;
		_xmpp_stanza_entry_unref0 (_tmp15_);
		_xmpp_stanza_entry_unref0 (_tmp13_);
		_xmpp_stanza_entry_unref0 (_tmp11_);
		_xmpp_stanza_entry_unref0 (_tmp8_);
		_xmpp_stanza_entry_unref0 (_tmp6_);
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
dino_plugins_open_pgp_module_gpg_encrypt (const gchar* plain,
                                          struct _gpgme_key** keys,
                                          gint keys_length1)
{
	gchar* encr = NULL;
	gint encryption_start = 0;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (plain != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = gpg_helper_encrypt_armor (plain, keys, (gint) keys_length1, GPGME_ENCRYPT_ALWAYS_TRUST, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (encr);
		encr = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_free0 (encr);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (encr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp3_ = encr;
	encryption_start = string_index_of (_tmp3_, "\n\n", 0) + 2;
	_tmp4_ = encr;
	_tmp5_ = encr;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = strlen ("\n-----END PGP MESSAGE-----");
	_tmp9_ = _tmp8_;
	_tmp10_ = string_substring (_tmp4_, (glong) encryption_start, (glong) ((_tmp7_ - _tmp9_) - encryption_start));
	result = _tmp10_;
	_g_free0 (encr);
	return result;
}

static gchar*
dino_plugins_open_pgp_module_get_sign_key (const gchar* sig,
                                           const gchar* signed_text)
{
	gchar* armor = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* sign_key = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (signed_text != NULL, NULL);
	_tmp0_ = g_strconcat ("-----BEGIN PGP MESSAGE-----\n\n", sig, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\n-----END PGP MESSAGE-----", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	armor = _tmp3_;
	sign_key = NULL;
	{
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = gpg_helper_get_sign_key (armor, signed_text, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_free0 (sign_key);
		sign_key = _tmp6_;
		_g_free0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (sign_key);
		_g_free0 (armor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = sign_key;
	_g_free0 (armor);
	return result;
}

static gchar*
dino_plugins_open_pgp_module_gpg_sign (const gchar* str,
                                       struct _gpgme_key* key)
{
	gchar* _signed_ = NULL;
	gint signature_start = 0;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = gpg_helper_sign (str, GPGME_SIG_MODE_CLEAR, key, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (_signed_);
		_signed_ = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_free0 (_signed_);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_signed_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp3_ = _signed_;
	signature_start = string_index_of (_tmp3_, "-----BEGIN PGP SIGNATURE-----", 0);
	_tmp4_ = _signed_;
	signature_start = string_index_of (_tmp4_, "\n\n", signature_start) + 2;
	_tmp5_ = _signed_;
	_tmp6_ = _signed_;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = strlen ("\n-----END PGP SIGNATURE-----");
	_tmp10_ = _tmp9_;
	_tmp11_ = string_substring (_tmp5_, (glong) signature_start, (glong) ((_tmp8_ - _tmp10_) - signature_start));
	result = _tmp11_;
	_g_free0 (_signed_);
	return result;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_XMPP_JID_STRING (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_XMPP_JID_STRING) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_XMPP_JID_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_XMPP_JID_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), xmpp_value_get_jid (param_values + 2), g_value_get_string (param_values + 3), data2);
}

static void
dino_plugins_open_pgp_module_class_init (DinoPluginsOpenPgpModuleClass * klass,
                                         gpointer klass_data)
{
	XmppModuleIdentity* _tmp0_;
	dino_plugins_open_pgp_module_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DinoPluginsOpenPgpModule_private_offset);
	((XmppXmppStreamModuleClass *) klass)->attach = (void (*) (XmppXmppStreamModule*, XmppXmppStream*)) dino_plugins_open_pgp_module_real_attach;
	((XmppXmppStreamModuleClass *) klass)->detach = (void (*) (XmppXmppStreamModule*, XmppXmppStream*)) dino_plugins_open_pgp_module_real_detach;
	((XmppXmppStreamModuleClass *) klass)->get_ns = (gchar* (*) (XmppXmppStreamModule*)) dino_plugins_open_pgp_module_real_get_ns;
	((XmppXmppStreamModuleClass *) klass)->get_id = (gchar* (*) (XmppXmppStreamModule*)) dino_plugins_open_pgp_module_real_get_id;
	G_OBJECT_CLASS (klass)->finalize = dino_plugins_open_pgp_module_finalize;
	dino_plugins_open_pgp_module_signals[DINO_PLUGINS_OPEN_PGP_MODULE_RECEIVED_JID_KEY_ID_SIGNAL] = g_signal_new ("received-jid-key-id", DINO_PLUGINS_OPEN_PGP_TYPE_MODULE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_XMPP_JID_STRING, G_TYPE_NONE, 3, XMPP_TYPE_XMPP_STREAM, XMPP_TYPE_JID, G_TYPE_STRING);
	_tmp0_ = xmpp_module_identity_new (DINO_PLUGINS_OPEN_PGP_TYPE_MODULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, DINO_PLUGINS_OPEN_PGP_NS_URI, "0027_current_pgp_usage");
	dino_plugins_open_pgp_module_IDENTITY = _tmp0_;
}

static void
dino_plugins_open_pgp_module_instance_init (DinoPluginsOpenPgpModule * self,
                                            gpointer klass)
{
	DinoPluginsOpenPgpReceivedPipelineDecryptListener* _tmp0_;
	self->priv = dino_plugins_open_pgp_module_get_instance_private (self);
	self->priv->signed_status = NULL;
	self->priv->own_key = NULL;
	_tmp0_ = dino_plugins_open_pgp_received_pipeline_decrypt_listener_new ();
	self->priv->received_pipeline_decrypt_listener = _tmp0_;
}

static void
dino_plugins_open_pgp_module_finalize (GObject * obj)
{
	DinoPluginsOpenPgpModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_OPEN_PGP_TYPE_MODULE, DinoPluginsOpenPgpModule);
	_g_free0 (self->priv->signed_status);
	_gpgme_key_unref_vapi0 (self->priv->own_key);
	_g_object_unref0 (self->priv->received_pipeline_decrypt_listener);
	G_OBJECT_CLASS (dino_plugins_open_pgp_module_parent_class)->finalize (obj);
}

static GType
dino_plugins_open_pgp_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoPluginsOpenPgpModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_plugins_open_pgp_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoPluginsOpenPgpModule), 0, (GInstanceInitFunc) dino_plugins_open_pgp_module_instance_init, NULL };
	GType dino_plugins_open_pgp_module_type_id;
	dino_plugins_open_pgp_module_type_id = g_type_register_static (XMPP_TYPE_XMPP_STREAM_MODULE, "DinoPluginsOpenPgpModule", &g_define_type_info, 0);
	DinoPluginsOpenPgpModule_private_offset = g_type_add_instance_private (dino_plugins_open_pgp_module_type_id, sizeof (DinoPluginsOpenPgpModulePrivate));
	return dino_plugins_open_pgp_module_type_id;
}

GType
dino_plugins_open_pgp_module_get_type (void)
{
	static volatile gsize dino_plugins_open_pgp_module_type_id__once = 0;
	if (g_once_init_enter (&dino_plugins_open_pgp_module_type_id__once)) {
		GType dino_plugins_open_pgp_module_type_id;
		dino_plugins_open_pgp_module_type_id = dino_plugins_open_pgp_module_get_type_once ();
		g_once_init_leave (&dino_plugins_open_pgp_module_type_id__once, dino_plugins_open_pgp_module_type_id);
	}
	return dino_plugins_open_pgp_module_type_id__once;
}

DinoPluginsOpenPgpMessageFlag*
dino_plugins_open_pgp_message_flag_get_flag (XmppMessageStanza* message)
{
	XmppMessageFlag* _tmp0_;
	DinoPluginsOpenPgpMessageFlag* result;
	g_return_val_if_fail (message != NULL, NULL);
	_tmp0_ = xmpp_message_stanza_get_flag (message, DINO_PLUGINS_OPEN_PGP_NS_URI, DINO_PLUGINS_OPEN_PGP_MESSAGE_FLAG_id);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, DINO_PLUGINS_OPEN_PGP_TYPE_MESSAGE_FLAG, DinoPluginsOpenPgpMessageFlag);
	return result;
}

static gchar*
dino_plugins_open_pgp_message_flag_real_get_ns (XmppMessageFlag* base)
{
	DinoPluginsOpenPgpMessageFlag * self;
	gchar* _tmp0_;
	gchar* result;
	self = (DinoPluginsOpenPgpMessageFlag*) base;
	_tmp0_ = g_strdup (DINO_PLUGINS_OPEN_PGP_NS_URI);
	result = _tmp0_;
	return result;
}

static gchar*
dino_plugins_open_pgp_message_flag_real_get_id (XmppMessageFlag* base)
{
	DinoPluginsOpenPgpMessageFlag * self;
	gchar* _tmp0_;
	gchar* result;
	self = (DinoPluginsOpenPgpMessageFlag*) base;
	_tmp0_ = g_strdup (DINO_PLUGINS_OPEN_PGP_MESSAGE_FLAG_id);
	result = _tmp0_;
	return result;
}

DinoPluginsOpenPgpMessageFlag*
dino_plugins_open_pgp_message_flag_construct (GType object_type)
{
	DinoPluginsOpenPgpMessageFlag * self = NULL;
	self = (DinoPluginsOpenPgpMessageFlag*) xmpp_message_flag_construct (object_type);
	return self;
}

DinoPluginsOpenPgpMessageFlag*
dino_plugins_open_pgp_message_flag_new (void)
{
	return dino_plugins_open_pgp_message_flag_construct (DINO_PLUGINS_OPEN_PGP_TYPE_MESSAGE_FLAG);
}

static void
dino_plugins_open_pgp_message_flag_class_init (DinoPluginsOpenPgpMessageFlagClass * klass,
                                               gpointer klass_data)
{
	dino_plugins_open_pgp_message_flag_parent_class = g_type_class_peek_parent (klass);
	((XmppMessageFlagClass *) klass)->get_ns = (gchar* (*) (XmppMessageFlag*)) dino_plugins_open_pgp_message_flag_real_get_ns;
	((XmppMessageFlagClass *) klass)->get_id = (gchar* (*) (XmppMessageFlag*)) dino_plugins_open_pgp_message_flag_real_get_id;
	G_OBJECT_CLASS (klass)->finalize = dino_plugins_open_pgp_message_flag_finalize;
}

static void
dino_plugins_open_pgp_message_flag_instance_init (DinoPluginsOpenPgpMessageFlag * self,
                                                  gpointer klass)
{
	self->decrypted = FALSE;
}

static void
dino_plugins_open_pgp_message_flag_finalize (GObject * obj)
{
	DinoPluginsOpenPgpMessageFlag * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_OPEN_PGP_TYPE_MESSAGE_FLAG, DinoPluginsOpenPgpMessageFlag);
	G_OBJECT_CLASS (dino_plugins_open_pgp_message_flag_parent_class)->finalize (obj);
}

static GType
dino_plugins_open_pgp_message_flag_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoPluginsOpenPgpMessageFlagClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_plugins_open_pgp_message_flag_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoPluginsOpenPgpMessageFlag), 0, (GInstanceInitFunc) dino_plugins_open_pgp_message_flag_instance_init, NULL };
	GType dino_plugins_open_pgp_message_flag_type_id;
	dino_plugins_open_pgp_message_flag_type_id = g_type_register_static (XMPP_TYPE_MESSAGE_FLAG, "DinoPluginsOpenPgpMessageFlag", &g_define_type_info, 0);
	return dino_plugins_open_pgp_message_flag_type_id;
}

GType
dino_plugins_open_pgp_message_flag_get_type (void)
{
	static volatile gsize dino_plugins_open_pgp_message_flag_type_id__once = 0;
	if (g_once_init_enter (&dino_plugins_open_pgp_message_flag_type_id__once)) {
		GType dino_plugins_open_pgp_message_flag_type_id;
		dino_plugins_open_pgp_message_flag_type_id = dino_plugins_open_pgp_message_flag_get_type_once ();
		g_once_init_leave (&dino_plugins_open_pgp_message_flag_type_id__once, dino_plugins_open_pgp_message_flag_type_id);
	}
	return dino_plugins_open_pgp_message_flag_type_id__once;
}

static inline gpointer
dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_instance_private (DinoPluginsOpenPgpReceivedPipelineDecryptListener* self)
{
	return G_STRUCT_MEMBER_P (self, DinoPluginsOpenPgpReceivedPipelineDecryptListener_private_offset);
}

static void
dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_run_data_free (gpointer _data)
{
	DinoPluginsOpenPgpReceivedPipelineDecryptListenerRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->stream);
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->self);
	g_slice_free (DinoPluginsOpenPgpReceivedPipelineDecryptListenerRunData, _data_);
}

static void
dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_run (XmppStanzaListener* base,
                                                                   XmppXmppStream* stream,
                                                                   XmppMessageStanza* message,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_)
{
	DinoPluginsOpenPgpReceivedPipelineDecryptListener * self;
	DinoPluginsOpenPgpReceivedPipelineDecryptListenerRunData* _data_;
	DinoPluginsOpenPgpReceivedPipelineDecryptListener* _tmp0_;
	XmppXmppStream* _tmp1_;
	XmppMessageStanza* _tmp2_;
	g_return_if_fail (stream != NULL);
	g_return_if_fail (message != NULL);
	self = (DinoPluginsOpenPgpReceivedPipelineDecryptListener*) base;
	_data_ = g_slice_new0 (DinoPluginsOpenPgpReceivedPipelineDecryptListenerRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (stream);
	_g_object_unref0 (_data_->stream);
	_data_->stream = _tmp1_;
	_tmp2_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp2_;
	dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_run_co (_data_);
}

static gboolean
dino_plugins_open_pgp_received_pipeline_decrypt_listener_run_finish (XmppStanzaListener* base,
                                                                     GAsyncResult* _res_)
{
	gboolean result;
	DinoPluginsOpenPgpReceivedPipelineDecryptListenerRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
dino_plugins_open_pgp_received_pipeline_decrypt_listener_run_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_)
{
	DinoPluginsOpenPgpReceivedPipelineDecryptListenerRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_run_co (_data_);
}

static gboolean
dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_run_co (DinoPluginsOpenPgpReceivedPipelineDecryptListenerRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_cyphertext (_data_->self, _data_->message);
	_data_->encrypted = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->encrypted;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = dino_plugins_open_pgp_message_flag_new ();
		_data_->flag = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->flag;
		xmpp_message_stanza_add_flag (_data_->message, (XmppMessageFlag*) _data_->_tmp3_);
		_data_->_tmp4_ = _data_->encrypted;
		_data_->_state_ = 1;
		dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt (_data_->_tmp4_, dino_plugins_open_pgp_received_pipeline_decrypt_listener_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_finish (_data_->_res_);
		_data_->decrypted = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->decrypted;
		if (_data_->_tmp6_ != NULL) {
			_data_->_tmp7_ = _data_->flag;
			_data_->_tmp7_->decrypted = TRUE;
			_data_->_tmp8_ = _data_->decrypted;
			xmpp_message_stanza_set_body (_data_->message, _data_->_tmp8_);
		}
		_g_free0 (_data_->decrypted);
		_g_object_unref0 (_data_->flag);
	}
	_data_->result = FALSE;
	_g_free0 (_data_->encrypted);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_data_free (gpointer _data)
{
	DinoPluginsOpenPgpReceivedPipelineDecryptListenerGpgDecryptData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	g_slice_free (DinoPluginsOpenPgpReceivedPipelineDecryptListenerGpgDecryptData, _data_);
}

static void
dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt (const gchar* enc,
                                                                      GAsyncReadyCallback _callback_,
                                                                      gpointer _user_data_)
{
	DinoPluginsOpenPgpReceivedPipelineDecryptListenerGpgDecryptData* _data_;
	gchar* _tmp0_;
	g_return_if_fail (enc != NULL);
	_data_ = g_slice_new0 (DinoPluginsOpenPgpReceivedPipelineDecryptListenerGpgDecryptData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_data_free);
	_tmp0_ = g_strdup (enc);
	_g_free0 (_data_->enc);
	_data_->enc = _tmp0_;
	dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_co (_data_);
}

static gchar*
dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_finish (GAsyncResult* _res_)
{
	gchar* result;
	DinoPluginsOpenPgpReceivedPipelineDecryptListenerGpgDecryptData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_free0 (_data6_->res);
		(_data6_->callback_target_destroy_notify == NULL) ? NULL : (_data6_->callback_target_destroy_notify (_data6_->callback_target), NULL);
		_data6_->callback = NULL;
		_data6_->callback_target = NULL;
		_data6_->callback_target_destroy_notify = NULL;
		_g_free0 (_data6_->enc);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
_dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_co_gsource_func (gpointer self)
{
	gboolean result;
	result = dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_co (self);
	return result;
}

static void*
__lambda4_ (Block6Data* _data6_)
{
	gchar* armor = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GSourceFunc _tmp7_;
	gpointer _tmp7__target;
	GDestroyNotify _tmp7__target_destroy_notify;
	GError* _inner_error0_ = NULL;
	void* result;
	_tmp0_ = g_strconcat ("-----BEGIN PGP MESSAGE-----\n\n", _data6_->enc, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\n-----END PGP MESSAGE-----", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	armor = _tmp3_;
	{
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = gpg_helper_decrypt (armor, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_free0 (_data6_->res);
		_data6_->res = _tmp6_;
		_g_free0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_free0 (_data6_->res);
		_data6_->res = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (armor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp7_ = _data6_->callback;
	_tmp7__target = _data6_->callback_target;
	_tmp7__target_destroy_notify = _data6_->callback_target_destroy_notify;
	_data6_->callback = NULL;
	_data6_->callback_target = NULL;
	_data6_->callback_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp7_, _tmp7__target, _tmp7__target_destroy_notify);
	result = NULL;
	_g_free0 (armor);
	return result;
}

static gpointer
___lambda4__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda4_ (self);
	block6_data_unref (self);
	return result;
}

static gboolean
dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_co (DinoPluginsOpenPgpReceivedPipelineDecryptListenerGpgDecryptData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_g_free0 (_data_->_data6_->enc);
	_data_->_data6_->enc = _data_->enc;
	_data_->_data6_->_async_data_ = _data_;
	_data_->_data6_->callback = _dino_plugins_open_pgp_received_pipeline_decrypt_listener_gpg_decrypt_co_gsource_func;
	_data_->_data6_->callback_target = _data_;
	_data_->_data6_->callback_target_destroy_notify = NULL;
	_data_->_data6_->res = NULL;
	_data_->_tmp0_ = g_thread_new (NULL, ___lambda4__gthread_func, block6_data_ref (_data_->_data6_));
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_thread_unref0 (_data_->_tmp1_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp2_ = g_strdup (_data_->_data6_->res);
	_data_->result = _data_->_tmp2_;
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_cyphertext (DinoPluginsOpenPgpReceivedPipelineDecryptListener* self,
                                                                         XmppMessageStanza* message)
{
	XmppStanzaNode* x_node = NULL;
	XmppStanzaNode* _tmp0_;
	XmppStanzaNode* _tmp1_;
	const gchar* _tmp2_ = NULL;
	XmppStanzaNode* _tmp3_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	_tmp0_ = ((XmppStanza*) message)->stanza;
	_tmp1_ = xmpp_stanza_node_get_subnode (_tmp0_, "x", DINO_PLUGINS_OPEN_PGP_NS_URI_ENCRYPTED, FALSE);
	x_node = _tmp1_;
	_tmp3_ = x_node;
	if (_tmp3_ == NULL) {
		_tmp2_ = NULL;
	} else {
		XmppStanzaNode* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = x_node;
		_tmp5_ = xmpp_stanza_entry_get_string_content ((XmppStanzaEntry*) _tmp4_);
		_tmp2_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp2_);
	result = _tmp6_;
	_xmpp_stanza_entry_unref0 (x_node);
	return result;
}

DinoPluginsOpenPgpReceivedPipelineDecryptListener*
dino_plugins_open_pgp_received_pipeline_decrypt_listener_construct (GType object_type)
{
	DinoPluginsOpenPgpReceivedPipelineDecryptListener * self = NULL;
	self = (DinoPluginsOpenPgpReceivedPipelineDecryptListener*) xmpp_stanza_listener_construct (object_type, XMPP_TYPE_MESSAGE_STANZA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
	return self;
}

DinoPluginsOpenPgpReceivedPipelineDecryptListener*
dino_plugins_open_pgp_received_pipeline_decrypt_listener_new (void)
{
	return dino_plugins_open_pgp_received_pipeline_decrypt_listener_construct (DINO_PLUGINS_OPEN_PGP_TYPE_RECEIVED_PIPELINE_DECRYPT_LISTENER);
}

static const gchar*
dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_get_action_group (XmppOrderedListener* base)
{
	const gchar* result;
	DinoPluginsOpenPgpReceivedPipelineDecryptListener* self;
	self = (DinoPluginsOpenPgpReceivedPipelineDecryptListener*) base;
	result = "ENCRYPT_BODY";
	return result;
}

static gchar**
dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_get_after_actions (XmppOrderedListener* base,
                                                                                 gint* result_length1)
{
	gchar** result;
	DinoPluginsOpenPgpReceivedPipelineDecryptListener* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (DinoPluginsOpenPgpReceivedPipelineDecryptListener*) base;
	_tmp0_ = self->priv->after_actions_const;
	_tmp0__length1 = self->priv->after_actions_const_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static void
dino_plugins_open_pgp_received_pipeline_decrypt_listener_class_init (DinoPluginsOpenPgpReceivedPipelineDecryptListenerClass * klass,
                                                                     gpointer klass_data)
{
	dino_plugins_open_pgp_received_pipeline_decrypt_listener_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DinoPluginsOpenPgpReceivedPipelineDecryptListener_private_offset);
	((XmppStanzaListenerClass *) klass)->run = (void (*) (XmppStanzaListener*, XmppXmppStream*, gconstpointer, GAsyncReadyCallback, gpointer)) dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_run;
	((XmppStanzaListenerClass *) klass)->run_finish = (gboolean (*) (XmppStanzaListener*, GAsyncResult*)) dino_plugins_open_pgp_received_pipeline_decrypt_listener_run_finish;
	XMPP_ORDERED_LISTENER_CLASS (klass)->get_action_group = (const gchar* (*) (XmppOrderedListener*)) dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_get_action_group;
	XMPP_ORDERED_LISTENER_CLASS (klass)->get_after_actions = (gchar** (*) (XmppOrderedListener*, gint*)) dino_plugins_open_pgp_received_pipeline_decrypt_listener_real_get_after_actions;
	G_OBJECT_CLASS (klass)->get_property = _vala_dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_property;
	G_OBJECT_CLASS (klass)->finalize = dino_plugins_open_pgp_received_pipeline_decrypt_listener_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_PLUGINS_OPEN_PGP_RECEIVED_PIPELINE_DECRYPT_LISTENER_ACTION_GROUP_PROPERTY, dino_plugins_open_pgp_received_pipeline_decrypt_listener_properties[DINO_PLUGINS_OPEN_PGP_RECEIVED_PIPELINE_DECRYPT_LISTENER_ACTION_GROUP_PROPERTY] = g_param_spec_string ("action-group", "action-group", "action-group", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_PLUGINS_OPEN_PGP_RECEIVED_PIPELINE_DECRYPT_LISTENER_AFTER_ACTIONS_PROPERTY, dino_plugins_open_pgp_received_pipeline_decrypt_listener_properties[DINO_PLUGINS_OPEN_PGP_RECEIVED_PIPELINE_DECRYPT_LISTENER_AFTER_ACTIONS_PROPERTY] = g_param_spec_boxed ("after-actions", "after-actions", "after-actions", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
dino_plugins_open_pgp_received_pipeline_decrypt_listener_instance_init (DinoPluginsOpenPgpReceivedPipelineDecryptListener * self,
                                                                        gpointer klass)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	self->priv = dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_instance_private (self);
	_tmp0_ = g_strdup ("MODIFY_BODY");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	self->priv->after_actions_const = _tmp1_;
	self->priv->after_actions_const_length1 = 1;
	self->priv->_after_actions_const_size_ = self->priv->after_actions_const_length1;
}

static void
dino_plugins_open_pgp_received_pipeline_decrypt_listener_finalize (GObject * obj)
{
	DinoPluginsOpenPgpReceivedPipelineDecryptListener * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_OPEN_PGP_TYPE_RECEIVED_PIPELINE_DECRYPT_LISTENER, DinoPluginsOpenPgpReceivedPipelineDecryptListener);
	self->priv->after_actions_const = (_vala_array_free (self->priv->after_actions_const, self->priv->after_actions_const_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (dino_plugins_open_pgp_received_pipeline_decrypt_listener_parent_class)->finalize (obj);
}

static GType
dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoPluginsOpenPgpReceivedPipelineDecryptListenerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_plugins_open_pgp_received_pipeline_decrypt_listener_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoPluginsOpenPgpReceivedPipelineDecryptListener), 0, (GInstanceInitFunc) dino_plugins_open_pgp_received_pipeline_decrypt_listener_instance_init, NULL };
	GType dino_plugins_open_pgp_received_pipeline_decrypt_listener_type_id;
	dino_plugins_open_pgp_received_pipeline_decrypt_listener_type_id = g_type_register_static (XMPP_TYPE_STANZA_LISTENER, "DinoPluginsOpenPgpReceivedPipelineDecryptListener", &g_define_type_info, 0);
	DinoPluginsOpenPgpReceivedPipelineDecryptListener_private_offset = g_type_add_instance_private (dino_plugins_open_pgp_received_pipeline_decrypt_listener_type_id, sizeof (DinoPluginsOpenPgpReceivedPipelineDecryptListenerPrivate));
	return dino_plugins_open_pgp_received_pipeline_decrypt_listener_type_id;
}

GType
dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_type (void)
{
	static volatile gsize dino_plugins_open_pgp_received_pipeline_decrypt_listener_type_id__once = 0;
	if (g_once_init_enter (&dino_plugins_open_pgp_received_pipeline_decrypt_listener_type_id__once)) {
		GType dino_plugins_open_pgp_received_pipeline_decrypt_listener_type_id;
		dino_plugins_open_pgp_received_pipeline_decrypt_listener_type_id = dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_type_once ();
		g_once_init_leave (&dino_plugins_open_pgp_received_pipeline_decrypt_listener_type_id__once, dino_plugins_open_pgp_received_pipeline_decrypt_listener_type_id);
	}
	return dino_plugins_open_pgp_received_pipeline_decrypt_listener_type_id__once;
}

static void
_vala_dino_plugins_open_pgp_received_pipeline_decrypt_listener_get_property (GObject * object,
                                                                             guint property_id,
                                                                             GValue * value,
                                                                             GParamSpec * pspec)
{
	DinoPluginsOpenPgpReceivedPipelineDecryptListener * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DINO_PLUGINS_OPEN_PGP_TYPE_RECEIVED_PIPELINE_DECRYPT_LISTENER, DinoPluginsOpenPgpReceivedPipelineDecryptListener);
	switch (property_id) {
		case DINO_PLUGINS_OPEN_PGP_RECEIVED_PIPELINE_DECRYPT_LISTENER_ACTION_GROUP_PROPERTY:
		g_value_set_string (value, xmpp_ordered_listener_get_action_group ((XmppOrderedListener*) self));
		break;
		case DINO_PLUGINS_OPEN_PGP_RECEIVED_PIPELINE_DECRYPT_LISTENER_AFTER_ACTIONS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, xmpp_ordered_listener_get_after_actions ((XmppOrderedListener*) self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

