/* database.c generated by valac 0.56.18, the Vala compiler
 * generated from database.vala, do not modify */

#include "qlite.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sqlite3.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _qlite_column_unref0(var) ((var == NULL) ? NULL : (var = (qlite_column_unref (var), NULL)))
#define _qlite_table_unref0(var) ((var == NULL) ? NULL : (var = (qlite_table_unref (var), NULL)))
#define _qlite_row_option_unref0(var) ((var == NULL) ? NULL : (var = (qlite_row_option_unref (var), NULL)))
#define _qlite_statement_builder_unref0(var) ((var == NULL) ? NULL : (var = (qlite_statement_builder_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
typedef struct _QliteParamSpecDatabase QliteParamSpecDatabase;

struct _QliteDatabasePrivate {
	gchar* file_name;
	sqlite3* db;
	glong expected_version;
	QliteTable** tables;
	gint tables_length1;
	gint _tables_size_;
	QliteColumn* meta_name;
	QliteColumn* meta_int_val;
	QliteColumn* meta_text_val;
	QliteTable* meta_table;
};

struct _QliteParamSpecDatabase {
	GParamSpec parent_instance;
};

static gint QliteDatabase_private_offset;
static gpointer qlite_database_parent_class = NULL;

static QliteTable** _vala_array_dup1 (QliteTable** self,
                               gssize length);
static void ___lambda4_ (QliteDatabase* self,
                  const gchar* message);
static void ____lambda4__sqlite_trace_callback (gpointer self,
                                         const gchar* message);
static void qlite_database_start_migration (QliteDatabase* self);
VALA_EXTERN void qlite_table_post (QliteTable* self);
VALA_EXTERN gint qlite_database_errcode (QliteDatabase* self);
VALA_EXTERN gchar* qlite_database_errmsg (QliteDatabase* self);
VALA_EXTERN gint64 qlite_database_last_insert_rowid (QliteDatabase* self);
static void qlite_database_real_migrate (QliteDatabase* self,
                                  glong old_version);
VALA_EXTERN QliteQueryBuilder* qlite_query_builder_new (QliteDatabase* db);
VALA_EXTERN QliteQueryBuilder* qlite_query_builder_construct (GType object_type,
                                                  QliteDatabase* db);
VALA_EXTERN QliteMatchQueryBuilder* qlite_database_match_query (QliteDatabase* self,
                                                    QliteTable* table);
VALA_EXTERN QliteMatchQueryBuilder* qlite_match_query_builder_new (QliteDatabase* db,
                                                       QliteTable* table);
VALA_EXTERN QliteMatchQueryBuilder* qlite_match_query_builder_construct (GType object_type,
                                                             QliteDatabase* db,
                                                             QliteTable* table);
VALA_EXTERN QliteInsertBuilder* qlite_insert_builder_new (QliteDatabase* db);
VALA_EXTERN QliteInsertBuilder* qlite_insert_builder_construct (GType object_type,
                                                    QliteDatabase* db);
VALA_EXTERN QliteUpdateBuilder* qlite_update_builder_new (QliteDatabase* db,
                                              QliteTable* table);
VALA_EXTERN QliteUpdateBuilder* qlite_update_builder_construct (GType object_type,
                                                    QliteDatabase* db,
                                                    QliteTable* table);
VALA_EXTERN QliteUpsertBuilder* qlite_upsert_builder_new (QliteDatabase* db,
                                              QliteTable* table);
VALA_EXTERN QliteUpsertBuilder* qlite_upsert_builder_construct (GType object_type,
                                                    QliteDatabase* db,
                                                    QliteTable* table);
VALA_EXTERN QliteUpdateBuilder* qlite_update_builder_new_for_name (QliteDatabase* db,
                                                       const gchar* table);
VALA_EXTERN QliteUpdateBuilder* qlite_update_builder_construct_for_name (GType object_type,
                                                             QliteDatabase* db,
                                                             const gchar* table);
VALA_EXTERN QliteDeleteBuilder* qlite_delete_builder_new (QliteDatabase* db);
VALA_EXTERN QliteDeleteBuilder* qlite_delete_builder_construct (GType object_type,
                                                    QliteDatabase* db);
VALA_EXTERN sqlite3_stmt* qlite_database_prepare (QliteDatabase* self,
                                      const gchar* sql);
static void qlite_database_finalize (QliteDatabase * obj);
static GType qlite_database_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
qlite_database_get_instance_private (QliteDatabase* self)
{
	return G_STRUCT_MEMBER_P (self, QliteDatabase_private_offset);
}

static gpointer
_qlite_column_ref0 (gpointer self)
{
	return self ? qlite_column_ref (self) : NULL;
}

QliteDatabase*
qlite_database_construct (GType object_type,
                          const gchar* file_name,
                          glong expected_version)
{
	QliteDatabase* self = NULL;
	gchar* _tmp0_;
	QliteTable* _tmp1_;
	QliteTable* _tmp2_;
	QliteColumn* _tmp3_;
	QliteColumn* _tmp4_;
	QliteColumn* _tmp5_;
	QliteColumn* _tmp6_;
	QliteColumn* _tmp7_;
	QliteColumn* _tmp8_;
	QliteColumn** _tmp9_;
	QliteColumn** _tmp10_;
	gint _tmp10__length1;
	g_return_val_if_fail (file_name != NULL, NULL);
	self = (QliteDatabase*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (file_name);
	_g_free0 (self->priv->file_name);
	self->priv->file_name = _tmp0_;
	self->priv->expected_version = expected_version;
	_tmp1_ = qlite_table_new (self, "_meta");
	_qlite_table_unref0 (self->priv->meta_table);
	self->priv->meta_table = _tmp1_;
	_tmp2_ = self->priv->meta_table;
	_tmp3_ = self->priv->meta_name;
	_tmp4_ = _qlite_column_ref0 (_tmp3_);
	_tmp5_ = self->priv->meta_int_val;
	_tmp6_ = _qlite_column_ref0 (_tmp5_);
	_tmp7_ = self->priv->meta_text_val;
	_tmp8_ = _qlite_column_ref0 (_tmp7_);
	_tmp9_ = g_new0 (QliteColumn*, 3 + 1);
	_tmp9_[0] = _tmp4_;
	_tmp9_[1] = _tmp6_;
	_tmp9_[2] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 3;
	qlite_table_init (_tmp2_, _tmp10_, (gint) 3, "");
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) qlite_column_unref), NULL);
	return self;
}

QliteDatabase*
qlite_database_new (const gchar* file_name,
                    glong expected_version)
{
	return qlite_database_construct (QLITE_TYPE_DATABASE, file_name, expected_version);
}

static gpointer
_qlite_table_ref0 (gpointer self)
{
	return self ? qlite_table_ref (self) : NULL;
}

static QliteTable**
_vala_array_dup1 (QliteTable** self,
                  gssize length)
{
	if (length >= 0) {
		QliteTable** result;
		gssize i;
		result = g_new0 (QliteTable*, length + 1);
		for (i = 0; i < length; i++) {
			QliteTable* _tmp0_;
			_tmp0_ = _qlite_table_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
___lambda4_ (QliteDatabase* self,
             const gchar* message)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (message != NULL);
	_tmp0_ = string_to_string (message);
	_tmp1_ = g_strconcat ("Qlite trace: ", _tmp0_, "\n", NULL);
	_tmp2_ = _tmp1_;
	g_print ("%s", _tmp2_);
	_g_free0 (_tmp2_);
}

static void
____lambda4__sqlite_trace_callback (gpointer self,
                                    const gchar* message)
{
	___lambda4_ ((QliteDatabase*) self, message);
}

void
qlite_database_init (QliteDatabase* self,
                     QliteTable** tables,
                     gint tables_length1)
{
	gint ec = 0;
	const gchar* _tmp0_;
	sqlite3* _tmp1_ = NULL;
	gint _tmp2_;
	QliteTable** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	sqlite3_config (SQLITE_CONFIG_SERIALIZED);
	_tmp0_ = self->priv->file_name;
	_tmp2_ = sqlite3_open_v2 (_tmp0_, &_tmp1_, (SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE) | 0x00010000, NULL);
	_sqlite3_close0 (self->priv->db);
	self->priv->db = _tmp1_;
	ec = _tmp2_;
	if (ec != SQLITE_OK) {
		sqlite3* _tmp3_;
		sqlite3* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = self->priv->db;
		_tmp4_ = self->priv->db;
		_tmp5_ = sqlite3_errmsg (_tmp4_);
		g_error ("database.vala:29: SQLite error: %d - %s", sqlite3_errcode (_tmp3_), _tmp5_);
	}
	_tmp6_ = (tables != NULL) ? _vala_array_dup1 (tables, tables_length1) : tables;
	_tmp6__length1 = tables_length1;
	self->priv->tables = (_vala_array_free (self->priv->tables, self->priv->tables_length1, (GDestroyNotify) qlite_table_unref), NULL);
	self->priv->tables = _tmp6_;
	self->priv->tables_length1 = _tmp6__length1;
	self->priv->_tables_size_ = self->priv->tables_length1;
	if (self->debug) {
		sqlite3* _tmp7_;
		_tmp7_ = self->priv->db;
		sqlite3_trace (_tmp7_, ____lambda4__sqlite_trace_callback, self);
	}
	qlite_database_start_migration (self);
}

void
qlite_database_ensure_init (QliteDatabase* self)
{
	QliteTable** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tables;
	_tmp0__length1 = self->priv->tables_length1;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->priv->file_name;
		_tmp2_ = string_to_string (_tmp1_);
		_tmp3_ = g_strconcat ("Database ", _tmp2_, " was not initialized, call init()", NULL);
		_tmp4_ = _tmp3_;
		g_error ("database.vala:37: %s", _tmp4_);
		_g_free0 (_tmp4_);
	}
}

static void
qlite_database_start_migration (QliteDatabase* self)
{
	QliteTable* _tmp3_;
	glong old_version = 0L;
	QliteTable* _tmp4_;
	QliteColumn* _tmp5_;
	QliteRowOption* _tmp6_;
	QliteRowOption* _tmp7_;
	QliteColumn* _tmp8_;
	gpointer _tmp9_;
	QliteTable** _tmp49_;
	gint _tmp49__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		qlite_database_exec (self, "BEGIN TRANSACTION", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		sqlite3* _tmp0_;
		sqlite3* _tmp1_;
		const gchar* _tmp2_;
		g_clear_error (&_inner_error0_);
		_tmp0_ = self->priv->db;
		_tmp1_ = self->priv->db;
		_tmp2_ = sqlite3_errmsg (_tmp1_);
		g_error ("database.vala:44: SQLite error: %d - %s", sqlite3_errcode (_tmp0_), _tmp2_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->meta_table;
	qlite_table_create_table_at_version (_tmp3_, self->priv->expected_version);
	old_version = (glong) 0;
	_tmp4_ = self->priv->meta_table;
	_tmp5_ = self->priv->meta_name;
	_tmp6_ = qlite_table_row_with (_tmp4_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp5_, "version");
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->meta_int_val;
	_tmp9_ = qlite_row_option_get (_tmp7_, G_TYPE_LONG, NULL, NULL, _tmp8_, (gpointer) ((gintptr) -1));
	old_version = (glong) ((gintptr) _tmp9_);
	_qlite_row_option_unref0 (_tmp7_);
	if (old_version == ((glong) -1)) {
		QliteTable** _tmp10_;
		gint _tmp10__length1;
		QliteTable* _tmp13_;
		QliteInsertBuilder* _tmp14_;
		QliteInsertBuilder* _tmp15_;
		QliteColumn* _tmp16_;
		QliteInsertBuilder* _tmp17_;
		QliteInsertBuilder* _tmp18_;
		QliteColumn* _tmp19_;
		QliteInsertBuilder* _tmp20_;
		QliteInsertBuilder* _tmp21_;
		_tmp10_ = self->priv->tables;
		_tmp10__length1 = self->priv->tables_length1;
		{
			QliteTable** t_collection = NULL;
			gint t_collection_length1 = 0;
			gint _t_collection_size_ = 0;
			gint t_it = 0;
			t_collection = _tmp10_;
			t_collection_length1 = _tmp10__length1;
			for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
				QliteTable* _tmp11_;
				QliteTable* t = NULL;
				_tmp11_ = _qlite_table_ref0 (t_collection[t_it]);
				t = _tmp11_;
				{
					QliteTable* _tmp12_;
					_tmp12_ = t;
					qlite_table_create_table_at_version (_tmp12_, self->priv->expected_version);
					_qlite_table_unref0 (t);
				}
			}
		}
		_tmp13_ = self->priv->meta_table;
		_tmp14_ = qlite_table_insert (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->meta_name;
		_tmp17_ = qlite_insert_builder_value (_tmp15_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp16_, "version");
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->meta_int_val;
		_tmp20_ = qlite_insert_builder_value (_tmp18_, G_TYPE_LONG, NULL, NULL, _tmp19_, (gpointer) ((gintptr) self->priv->expected_version));
		_tmp21_ = _tmp20_;
		qlite_insert_builder_perform (_tmp21_);
		_qlite_statement_builder_unref0 (_tmp21_);
		_qlite_statement_builder_unref0 (_tmp18_);
		_qlite_statement_builder_unref0 (_tmp15_);
	} else {
		if (self->priv->expected_version != old_version) {
			QliteTable** _tmp22_;
			gint _tmp22__length1;
			QliteTable** _tmp25_;
			gint _tmp25__length1;
			QliteTable** _tmp28_;
			gint _tmp28__length1;
			_tmp22_ = self->priv->tables;
			_tmp22__length1 = self->priv->tables_length1;
			{
				QliteTable** t_collection = NULL;
				gint t_collection_length1 = 0;
				gint _t_collection_size_ = 0;
				gint t_it = 0;
				t_collection = _tmp22_;
				t_collection_length1 = _tmp22__length1;
				for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
					QliteTable* _tmp23_;
					QliteTable* t = NULL;
					_tmp23_ = _qlite_table_ref0 (t_collection[t_it]);
					t = _tmp23_;
					{
						QliteTable* _tmp24_;
						_tmp24_ = t;
						qlite_table_create_table_at_version (_tmp24_, old_version);
						_qlite_table_unref0 (t);
					}
				}
			}
			_tmp25_ = self->priv->tables;
			_tmp25__length1 = self->priv->tables_length1;
			{
				QliteTable** t_collection = NULL;
				gint t_collection_length1 = 0;
				gint _t_collection_size_ = 0;
				gint t_it = 0;
				t_collection = _tmp25_;
				t_collection_length1 = _tmp25__length1;
				for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
					QliteTable* _tmp26_;
					QliteTable* t = NULL;
					_tmp26_ = _qlite_table_ref0 (t_collection[t_it]);
					t = _tmp26_;
					{
						QliteTable* _tmp27_;
						_tmp27_ = t;
						qlite_table_add_columns_for_version (_tmp27_, old_version, self->priv->expected_version);
						_qlite_table_unref0 (t);
					}
				}
			}
			qlite_database_migrate (self, old_version);
			_tmp28_ = self->priv->tables;
			_tmp28__length1 = self->priv->tables_length1;
			{
				QliteTable** t_collection = NULL;
				gint t_collection_length1 = 0;
				gint _t_collection_size_ = 0;
				gint t_it = 0;
				t_collection = _tmp28_;
				t_collection_length1 = _tmp28__length1;
				for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
					QliteTable* _tmp29_;
					QliteTable* t = NULL;
					_tmp29_ = _qlite_table_ref0 (t_collection[t_it]);
					t = _tmp29_;
					{
						QliteTable* _tmp30_;
						_tmp30_ = t;
						qlite_table_delete_columns_for_version (_tmp30_, old_version, self->priv->expected_version);
						_qlite_table_unref0 (t);
					}
				}
			}
			if (old_version == ((glong) -1)) {
				QliteTable* _tmp31_;
				QliteInsertBuilder* _tmp32_;
				QliteInsertBuilder* _tmp33_;
				QliteColumn* _tmp34_;
				QliteInsertBuilder* _tmp35_;
				QliteInsertBuilder* _tmp36_;
				QliteColumn* _tmp37_;
				QliteInsertBuilder* _tmp38_;
				QliteInsertBuilder* _tmp39_;
				_tmp31_ = self->priv->meta_table;
				_tmp32_ = qlite_table_insert (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = self->priv->meta_name;
				_tmp35_ = qlite_insert_builder_value (_tmp33_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp34_, "version");
				_tmp36_ = _tmp35_;
				_tmp37_ = self->priv->meta_int_val;
				_tmp38_ = qlite_insert_builder_value (_tmp36_, G_TYPE_LONG, NULL, NULL, _tmp37_, (gpointer) ((gintptr) self->priv->expected_version));
				_tmp39_ = _tmp38_;
				qlite_insert_builder_perform (_tmp39_);
				_qlite_statement_builder_unref0 (_tmp39_);
				_qlite_statement_builder_unref0 (_tmp36_);
				_qlite_statement_builder_unref0 (_tmp33_);
			} else {
				QliteTable* _tmp40_;
				QliteUpdateBuilder* _tmp41_;
				QliteUpdateBuilder* _tmp42_;
				QliteColumn* _tmp43_;
				QliteUpdateBuilder* _tmp44_;
				QliteUpdateBuilder* _tmp45_;
				QliteColumn* _tmp46_;
				QliteUpdateBuilder* _tmp47_;
				QliteUpdateBuilder* _tmp48_;
				_tmp40_ = self->priv->meta_table;
				_tmp41_ = qlite_table_update (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = self->priv->meta_name;
				_tmp44_ = qlite_update_builder_with (_tmp42_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp43_, "=", "version");
				_tmp45_ = _tmp44_;
				_tmp46_ = self->priv->meta_int_val;
				_tmp47_ = qlite_update_builder_set (_tmp45_, G_TYPE_LONG, NULL, NULL, _tmp46_, (gpointer) ((gintptr) self->priv->expected_version));
				_tmp48_ = _tmp47_;
				qlite_update_builder_perform (_tmp48_);
				_qlite_statement_builder_unref0 (_tmp48_);
				_qlite_statement_builder_unref0 (_tmp45_);
				_qlite_statement_builder_unref0 (_tmp42_);
			}
		}
	}
	_tmp49_ = self->priv->tables;
	_tmp49__length1 = self->priv->tables_length1;
	{
		QliteTable** t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = _tmp49_;
		t_collection_length1 = _tmp49__length1;
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
			QliteTable* _tmp50_;
			QliteTable* t = NULL;
			_tmp50_ = _qlite_table_ref0 (t_collection[t_it]);
			t = _tmp50_;
			{
				QliteTable* _tmp51_;
				_tmp51_ = t;
				qlite_table_post (_tmp51_);
				_qlite_table_unref0 (t);
			}
		}
	}
	{
		qlite_database_exec (self, "END TRANSACTION", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		sqlite3* _tmp52_;
		sqlite3* _tmp53_;
		const gchar* _tmp54_;
		g_clear_error (&_inner_error0_);
		_tmp52_ = self->priv->db;
		_tmp53_ = self->priv->db;
		_tmp54_ = sqlite3_errmsg (_tmp53_);
		g_error ("database.vala:77: SQLite error: %d - %s", sqlite3_errcode (_tmp52_), _tmp54_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gint
qlite_database_errcode (QliteDatabase* self)
{
	sqlite3* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->db;
	result = sqlite3_errcode (_tmp0_);
	return result;
}

gchar*
qlite_database_errmsg (QliteDatabase* self)
{
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = sqlite3_errmsg (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gint64
qlite_database_last_insert_rowid (QliteDatabase* self)
{
	sqlite3* _tmp0_;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->db;
	result = sqlite3_last_insert_rowid (_tmp0_);
	return result;
}

static void
qlite_database_real_migrate (QliteDatabase* self,
                             glong old_version)
{
}

void
qlite_database_migrate (QliteDatabase* self,
                        glong old_version)
{
	QliteDatabaseClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = QLITE_DATABASE_GET_CLASS (self);
	if (_klass_->migrate) {
		_klass_->migrate (self, old_version);
	}
}

QliteQueryBuilder*
qlite_database_select (QliteDatabase* self,
                       QliteColumn** columns,
                       gint columns_length1)
{
	QliteQueryBuilder* _tmp0_;
	QliteQueryBuilder* _tmp1_;
	QliteQueryBuilder* _tmp2_;
	QliteQueryBuilder* _tmp3_;
	QliteQueryBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	qlite_database_ensure_init (self);
	_tmp0_ = qlite_query_builder_new (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = qlite_query_builder_select (_tmp1_, columns, (gint) columns_length1);
	_tmp3_ = _tmp2_;
	_qlite_statement_builder_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

QliteMatchQueryBuilder*
qlite_database_match_query (QliteDatabase* self,
                            QliteTable* table)
{
	QliteMatchQueryBuilder* _tmp0_;
	QliteMatchQueryBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (table != NULL, NULL);
	qlite_database_ensure_init (self);
	_tmp0_ = qlite_match_query_builder_new (self, table);
	result = _tmp0_;
	return result;
}

QliteInsertBuilder*
qlite_database_insert (QliteDatabase* self)
{
	QliteInsertBuilder* _tmp0_;
	QliteInsertBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	qlite_database_ensure_init (self);
	_tmp0_ = qlite_insert_builder_new (self);
	result = _tmp0_;
	return result;
}

QliteUpdateBuilder*
qlite_database_update (QliteDatabase* self,
                       QliteTable* table)
{
	QliteUpdateBuilder* _tmp0_;
	QliteUpdateBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (table != NULL, NULL);
	qlite_database_ensure_init (self);
	_tmp0_ = qlite_update_builder_new (self, table);
	result = _tmp0_;
	return result;
}

QliteUpsertBuilder*
qlite_database_upsert (QliteDatabase* self,
                       QliteTable* table)
{
	QliteUpsertBuilder* _tmp0_;
	QliteUpsertBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (table != NULL, NULL);
	qlite_database_ensure_init (self);
	_tmp0_ = qlite_upsert_builder_new (self, table);
	result = _tmp0_;
	return result;
}

QliteUpdateBuilder*
qlite_database_update_named (QliteDatabase* self,
                             const gchar* table)
{
	QliteUpdateBuilder* _tmp0_;
	QliteUpdateBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (table != NULL, NULL);
	qlite_database_ensure_init (self);
	_tmp0_ = qlite_update_builder_new_for_name (self, table);
	result = _tmp0_;
	return result;
}

QliteDeleteBuilder*
qlite_database_delete (QliteDatabase* self)
{
	QliteDeleteBuilder* _tmp0_;
	QliteDeleteBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	qlite_database_ensure_init (self);
	_tmp0_ = qlite_delete_builder_new (self);
	result = _tmp0_;
	return result;
}

QliteRowIterator*
qlite_database_query_sql (QliteDatabase* self,
                          const gchar* sql,
                          gchar** args,
                          gint args_length1)
{
	QliteRowIterator* _tmp0_;
	QliteRowIterator* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	qlite_database_ensure_init (self);
	_tmp0_ = qlite_row_iterator_new (self, sql, args, args_length1);
	result = _tmp0_;
	return result;
}

sqlite3_stmt*
qlite_database_prepare (QliteDatabase* self,
                        const gchar* sql)
{
	sqlite3_stmt* statement = NULL;
	sqlite3* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	sqlite3_stmt* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	qlite_database_ensure_init (self);
	_tmp0_ = self->priv->db;
	_tmp1_ = strlen (sql);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, sql, _tmp2_, &_tmp3_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp3_;
	if (_tmp4_ != SQLITE_OK) {
		sqlite3* _tmp5_;
		sqlite3* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->db;
		_tmp6_ = self->priv->db;
		_tmp7_ = sqlite3_errmsg (_tmp6_);
		g_error ("database.vala:142: SQLite error: %d - %s: %s", sqlite3_errcode (_tmp5_), _tmp7_, sql);
	}
	result = statement;
	return result;
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

void
qlite_database_exec (QliteDatabase* self,
                     const gchar* sql,
                     GError** error)
{
	sqlite3* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	qlite_database_ensure_init (self);
	_tmp0_ = self->priv->db;
	if (_sqlite3_exec (_tmp0_, sql, NULL, NULL, NULL) != SQLITE_OK) {
		sqlite3* _tmp1_;
		sqlite3* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = self->priv->db;
		_tmp2_ = self->priv->db;
		_tmp3_ = sqlite3_errmsg (_tmp2_);
		_tmp4_ = g_error_new ((GQuark) -1, 0, "SQLite error: %d - %s", sqlite3_errcode (_tmp1_), _tmp3_);
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

gboolean
qlite_database_is_known_column (QliteDatabase* self,
                                const gchar* table,
                                const gchar* field)
{
	QliteTable** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (table != NULL, FALSE);
	g_return_val_if_fail (field != NULL, FALSE);
	qlite_database_ensure_init (self);
	_tmp0_ = self->priv->tables;
	_tmp0__length1 = self->priv->tables_length1;
	{
		QliteTable** t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = _tmp0_;
		t_collection_length1 = _tmp0__length1;
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
			QliteTable* _tmp1_;
			QliteTable* t = NULL;
			_tmp1_ = _qlite_table_ref0 (t_collection[t_it]);
			t = _tmp1_;
			{
				QliteTable* _tmp2_;
				_tmp2_ = t;
				if (qlite_table_is_known_column (_tmp2_, field)) {
					result = TRUE;
					_qlite_table_unref0 (t);
					return result;
				}
				_qlite_table_unref0 (t);
			}
		}
	}
	result = FALSE;
	return result;
}

static void
qlite_value_database_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
qlite_value_database_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		qlite_database_unref (value->data[0].v_pointer);
	}
}

static void
qlite_value_database_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = qlite_database_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
qlite_value_database_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
qlite_value_database_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		QliteDatabase * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = qlite_database_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
qlite_value_database_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	QliteDatabase ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = qlite_database_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
qlite_param_spec_database (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	QliteParamSpecDatabase* spec;
	g_return_val_if_fail (g_type_is_a (object_type, QLITE_TYPE_DATABASE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
qlite_value_get_database (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, QLITE_TYPE_DATABASE), NULL);
	return value->data[0].v_pointer;
}

void
qlite_value_set_database (GValue* value,
                          gpointer v_object)
{
	QliteDatabase * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, QLITE_TYPE_DATABASE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, QLITE_TYPE_DATABASE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		qlite_database_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		qlite_database_unref (old);
	}
}

void
qlite_value_take_database (GValue* value,
                           gpointer v_object)
{
	QliteDatabase * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, QLITE_TYPE_DATABASE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, QLITE_TYPE_DATABASE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		qlite_database_unref (old);
	}
}

static void
qlite_database_class_init (QliteDatabaseClass * klass,
                           gpointer klass_data)
{
	qlite_database_parent_class = g_type_class_peek_parent (klass);
	((QliteDatabaseClass *) klass)->finalize = qlite_database_finalize;
	g_type_class_adjust_private_offset (klass, &QliteDatabase_private_offset);
	((QliteDatabaseClass *) klass)->migrate = (void (*) (QliteDatabase*, glong)) qlite_database_real_migrate;
}

static void
qlite_database_instance_init (QliteDatabase * self,
                              gpointer klass)
{
	QliteColumnText* _tmp0_ = NULL;
	QliteColumnLong* _tmp1_;
	QliteColumnText* _tmp2_;
	self->priv = qlite_database_get_instance_private (self);
	_tmp0_ = qlite_column_text_new ("name");
	qlite_column_set_primary_key ((QliteColumn*) _tmp0_, TRUE);
	self->priv->meta_name = (QliteColumn*) _tmp0_;
	_tmp1_ = qlite_column_long_new ("int_val");
	self->priv->meta_int_val = (QliteColumn*) _tmp1_;
	_tmp2_ = qlite_column_text_new ("text_val");
	self->priv->meta_text_val = (QliteColumn*) _tmp2_;
	self->debug = FALSE;
	self->ref_count = 1;
}

static void
qlite_database_finalize (QliteDatabase * obj)
{
	QliteDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, QLITE_TYPE_DATABASE, QliteDatabase);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->file_name);
	_sqlite3_close0 (self->priv->db);
	self->priv->tables = (_vala_array_free (self->priv->tables, self->priv->tables_length1, (GDestroyNotify) qlite_table_unref), NULL);
	_qlite_column_unref0 (self->priv->meta_name);
	_qlite_column_unref0 (self->priv->meta_int_val);
	_qlite_column_unref0 (self->priv->meta_text_val);
	_qlite_table_unref0 (self->priv->meta_table);
}

static GType
qlite_database_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { qlite_value_database_init, qlite_value_database_free_value, qlite_value_database_copy_value, qlite_value_database_peek_pointer, "p", qlite_value_database_collect_value, "p", qlite_value_database_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (QliteDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) qlite_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QliteDatabase), 0, (GInstanceInitFunc) qlite_database_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType qlite_database_type_id;
	qlite_database_type_id = g_type_register_fundamental (g_type_fundamental_next (), "QliteDatabase", &g_define_type_info, &g_define_type_fundamental_info, 0);
	QliteDatabase_private_offset = g_type_add_instance_private (qlite_database_type_id, sizeof (QliteDatabasePrivate));
	return qlite_database_type_id;
}

GType
qlite_database_get_type (void)
{
	static volatile gsize qlite_database_type_id__once = 0;
	if (g_once_init_enter (&qlite_database_type_id__once)) {
		GType qlite_database_type_id;
		qlite_database_type_id = qlite_database_get_type_once ();
		g_once_init_leave (&qlite_database_type_id__once, qlite_database_type_id);
	}
	return qlite_database_type_id__once;
}

gpointer
qlite_database_ref (gpointer instance)
{
	QliteDatabase * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
qlite_database_unref (gpointer instance)
{
	QliteDatabase * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		QLITE_DATABASE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

