/* table.c generated by valac 0.56.18, the Vala compiler
 * generated from table.vala, do not modify */

#include "qlite.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _qlite_database_unref0(var) ((var == NULL) ? NULL : (var = (qlite_database_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _qlite_column_unref0(var) ((var == NULL) ? NULL : (var = (qlite_column_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _qlite_statement_builder_unref0(var) ((var == NULL) ? NULL : (var = (qlite_statement_builder_unref (var), NULL)))
typedef struct _QliteParamSpecTable QliteParamSpecTable;

struct _QliteTablePrivate {
	gchar* _name;
	gchar* constraints;
	gchar** post_statements;
	gint post_statements_length1;
	gint _post_statements_size_;
	gchar** create_statements;
	gint create_statements_length1;
	gint _create_statements_size_;
};

struct _QliteParamSpecTable {
	GParamSpec parent_instance;
};

static gint QliteTable_private_offset;
static gpointer qlite_table_parent_class = NULL;

static void qlite_table_set_name (QliteTable* self,
                           const gchar* value);
static QliteColumn** _vala_array_dup3 (QliteColumn** self,
                                gssize length);
VALA_EXTERN void qlite_column_set_table (QliteColumn* self,
                             QliteTable* value);
static QliteColumn** _vala_array_dup4 (QliteColumn** self,
                                gssize length);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void qlite_table_ensure_init (QliteTable* self);
static QliteMatchQueryBuilder* qlite_table_match_query (QliteTable* self);
VALA_EXTERN QliteMatchQueryBuilder* qlite_database_match_query (QliteDatabase* self,
                                                    QliteTable* table);
VALA_EXTERN void qlite_table_post (QliteTable* self);
static void qlite_table_finalize (QliteTable * obj);
static GType qlite_table_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
qlite_table_get_instance_private (QliteTable* self)
{
	return G_STRUCT_MEMBER_P (self, QliteTable_private_offset);
}

static gpointer
_qlite_database_ref0 (gpointer self)
{
	return self ? qlite_database_ref (self) : NULL;
}

QliteTable*
qlite_table_construct (GType object_type,
                       QliteDatabase* db,
                       const gchar* name)
{
	QliteTable* self = NULL;
	QliteDatabase* _tmp0_;
	g_return_val_if_fail (db != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (QliteTable*) g_type_create_instance (object_type);
	_tmp0_ = _qlite_database_ref0 (db);
	_qlite_database_unref0 (self->db);
	self->db = _tmp0_;
	qlite_table_set_name (self, name);
	return self;
}

QliteTable*
qlite_table_new (QliteDatabase* db,
                 const gchar* name)
{
	return qlite_table_construct (QLITE_TYPE_TABLE, db, name);
}

static gpointer
_qlite_column_ref0 (gpointer self)
{
	return self ? qlite_column_ref (self) : NULL;
}

static QliteColumn**
_vala_array_dup3 (QliteColumn** self,
                  gssize length)
{
	if (length >= 0) {
		QliteColumn** result;
		gssize i;
		result = g_new0 (QliteColumn*, length + 1);
		for (i = 0; i < length; i++) {
			QliteColumn* _tmp0_;
			_tmp0_ = _qlite_column_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
qlite_table_init (QliteTable* self,
                  QliteColumn** columns,
                  gint columns_length1,
                  const gchar* constraints)
{
	QliteColumn** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (constraints != NULL);
	_tmp0_ = (columns != NULL) ? _vala_array_dup3 (columns, columns_length1) : columns;
	_tmp0__length1 = columns_length1;
	self->columns = (_vala_array_free (self->columns, self->columns_length1, (GDestroyNotify) qlite_column_unref), NULL);
	self->columns = _tmp0_;
	self->columns_length1 = _tmp0__length1;
	_tmp1_ = g_strdup (constraints);
	_g_free0 (self->priv->constraints);
	self->priv->constraints = _tmp1_;
	{
		QliteColumn** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = columns;
		c_collection_length1 = columns_length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			QliteColumn* _tmp2_;
			QliteColumn* c = NULL;
			_tmp2_ = _qlite_column_ref0 (c_collection[c_it]);
			c = _tmp2_;
			{
				QliteColumn* _tmp3_;
				_tmp3_ = c;
				qlite_column_set_table (_tmp3_, self);
				_qlite_column_unref0 (c);
			}
		}
	}
}

static QliteColumn**
_vala_array_dup4 (QliteColumn** self,
                  gssize length)
{
	if (length >= 0) {
		QliteColumn** result;
		gssize i;
		result = g_new0 (QliteColumn*, length + 1);
		for (i = 0; i < length; i++) {
			QliteColumn* _tmp0_;
			_tmp0_ = _qlite_column_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
qlite_table_fts (QliteTable* self,
                 QliteColumn** columns,
                 gint columns_length1)
{
	QliteColumn** _tmp0_;
	gint _tmp0__length1;
	QliteColumn** _tmp1_;
	gint _tmp1__length1;
	gchar* cs = NULL;
	gchar* _tmp2_;
	gchar* cnames = NULL;
	gchar* _tmp3_;
	gchar* cnews = NULL;
	gchar* _tmp4_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	const gchar* _tmp72_;
	const gchar* _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->fts_columns;
	_tmp0__length1 = self->fts_columns_length1;
	if (_tmp0_ != NULL) {
		g_error ("table.vala:29: Only one FTS index may be used per table.");
	}
	_tmp1_ = (columns != NULL) ? _vala_array_dup4 (columns, columns_length1) : columns;
	_tmp1__length1 = columns_length1;
	self->fts_columns = (_vala_array_free (self->fts_columns, self->fts_columns_length1, (GDestroyNotify) qlite_column_unref), NULL);
	self->fts_columns = _tmp1_;
	self->fts_columns_length1 = _tmp1__length1;
	self->_fts_columns_size_ = self->fts_columns_length1;
	_tmp2_ = g_strdup ("");
	cs = _tmp2_;
	_tmp3_ = g_strdup ("");
	cnames = _tmp3_;
	_tmp4_ = g_strdup ("");
	cnews = _tmp4_;
	{
		QliteColumn** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = columns;
		c_collection_length1 = columns_length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			QliteColumn* _tmp5_;
			QliteColumn* c = NULL;
			_tmp5_ = _qlite_column_ref0 (c_collection[c_it]);
			c = _tmp5_;
			{
				const gchar* _tmp6_;
				QliteColumn* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				QliteColumn* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				const gchar* _tmp22_;
				QliteColumn* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp6_ = cs;
				_tmp7_ = c;
				_tmp8_ = qlite_column_to_column_definition (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = string_to_string (_tmp9_);
				_tmp11_ = g_strconcat (", ", _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp6_, _tmp12_, NULL);
				_g_free0 (cs);
				cs = _tmp13_;
				_g_free0 (_tmp12_);
				_g_free0 (_tmp9_);
				_tmp14_ = cnames;
				_tmp15_ = c;
				_tmp16_ = qlite_column_get_name (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = string_to_string (_tmp17_);
				_tmp19_ = g_strconcat (", ", _tmp18_, NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strconcat (_tmp14_, _tmp20_, NULL);
				_g_free0 (cnames);
				cnames = _tmp21_;
				_g_free0 (_tmp20_);
				_tmp22_ = cnews;
				_tmp23_ = c;
				_tmp24_ = qlite_column_get_name (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = string_to_string (_tmp25_);
				_tmp27_ = g_strconcat (", new.", _tmp26_, NULL);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp22_, _tmp28_, NULL);
				_g_free0 (cnews);
				cnews = _tmp29_;
				_g_free0 (_tmp28_);
				_qlite_column_unref0 (c);
			}
		}
	}
	_tmp30_ = self->priv->_name;
	_tmp31_ = string_to_string (_tmp30_);
	_tmp32_ = self->priv->_name;
	_tmp33_ = string_to_string (_tmp32_);
	_tmp34_ = cs;
	_tmp35_ = string_to_string (_tmp34_);
	_tmp36_ = g_strconcat ("CREATE VIRTUAL TABLE IF NOT EXISTS _fts_", _tmp31_, " USING fts4(tokenize=unicode61, content=\"", _tmp33_, "\"", _tmp35_, ")", NULL);
	_tmp37_ = _tmp36_;
	qlite_table_add_create_statement (self, _tmp37_);
	_g_free0 (_tmp37_);
	_tmp38_ = self->priv->_name;
	_tmp39_ = string_to_string (_tmp38_);
	_tmp40_ = self->priv->_name;
	_tmp41_ = string_to_string (_tmp40_);
	_tmp42_ = self->priv->_name;
	_tmp43_ = string_to_string (_tmp42_);
	_tmp44_ = g_strconcat ("CREATE TRIGGER IF NOT EXISTS _fts_bu_", _tmp39_, " BEFORE UPDATE ON ", _tmp41_, " BEGIN DELETE FROM _fts_", _tmp43_, " WHERE docid=old.rowid; END", NULL);
	_tmp45_ = _tmp44_;
	qlite_table_add_post_statement (self, _tmp45_);
	_g_free0 (_tmp45_);
	_tmp46_ = self->priv->_name;
	_tmp47_ = string_to_string (_tmp46_);
	_tmp48_ = self->priv->_name;
	_tmp49_ = string_to_string (_tmp48_);
	_tmp50_ = self->priv->_name;
	_tmp51_ = string_to_string (_tmp50_);
	_tmp52_ = g_strconcat ("CREATE TRIGGER IF NOT EXISTS _fts_bd_", _tmp47_, " BEFORE DELETE ON ", _tmp49_, " BEGIN DELETE FROM _fts_", _tmp51_, " WHERE docid=old.rowid; END", NULL);
	_tmp53_ = _tmp52_;
	qlite_table_add_post_statement (self, _tmp53_);
	_g_free0 (_tmp53_);
	_tmp54_ = self->priv->_name;
	_tmp55_ = string_to_string (_tmp54_);
	_tmp56_ = self->priv->_name;
	_tmp57_ = string_to_string (_tmp56_);
	_tmp58_ = self->priv->_name;
	_tmp59_ = string_to_string (_tmp58_);
	_tmp60_ = cnames;
	_tmp61_ = string_to_string (_tmp60_);
	_tmp62_ = cnews;
	_tmp63_ = string_to_string (_tmp62_);
	_tmp64_ = g_strconcat ("CREATE TRIGGER IF NOT EXISTS _fts_au_", _tmp55_, " AFTER UPDATE ON ", _tmp57_, " BEGIN INSERT INTO _fts_", _tmp59_, "(docid", _tmp61_, ") VALUES(new.rowid", _tmp63_, "); END", NULL);
	_tmp65_ = _tmp64_;
	qlite_table_add_post_statement (self, _tmp65_);
	_g_free0 (_tmp65_);
	_tmp66_ = self->priv->_name;
	_tmp67_ = string_to_string (_tmp66_);
	_tmp68_ = self->priv->_name;
	_tmp69_ = string_to_string (_tmp68_);
	_tmp70_ = self->priv->_name;
	_tmp71_ = string_to_string (_tmp70_);
	_tmp72_ = cnames;
	_tmp73_ = string_to_string (_tmp72_);
	_tmp74_ = cnews;
	_tmp75_ = string_to_string (_tmp74_);
	_tmp76_ = g_strconcat ("CREATE TRIGGER IF NOT EXISTS _fts_ai_", _tmp67_, " AFTER INSERT ON ", _tmp69_, " BEGIN INSERT INTO _fts_", _tmp71_, "(docid", _tmp73_, ") VALUES(new.rowid", _tmp75_, "); END", NULL);
	_tmp77_ = _tmp76_;
	qlite_table_add_post_statement (self, _tmp77_);
	_g_free0 (_tmp77_);
	_g_free0 (cnews);
	_g_free0 (cnames);
	_g_free0 (cs);
}

void
qlite_table_fts_rebuild (QliteTable* self)
{
	QliteColumn** _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->fts_columns;
	_tmp0__length1 = self->fts_columns_length1;
	if (_tmp0_ == NULL) {
		g_error ("table.vala:47: FTS not available on this table.");
	}
	{
		QliteDatabase* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = self->db;
		_tmp2_ = self->priv->_name;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = self->priv->_name;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("INSERT INTO _fts_", _tmp3_, "(_fts_", _tmp5_, ") VALUES('rebuild');", NULL);
		_tmp7_ = _tmp6_;
		qlite_database_exec (_tmp1_, _tmp7_, &_inner_error0_);
		_g_free0 (_tmp7_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("Qlite Error: Rebuilding FTS index: ", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		g_critical ("table.vala:51: %s", _tmp12_);
		_g_free0 (_tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
qlite_table_unique (QliteTable* self,
                    QliteColumn** columns,
                    gint columns_length1,
                    const gchar* on_conflict)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean first = FALSE;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->constraints;
	_tmp1_ = g_strconcat (_tmp0_, ", UNIQUE (", NULL);
	_g_free0 (self->priv->constraints);
	self->priv->constraints = _tmp1_;
	first = TRUE;
	{
		QliteColumn** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = columns;
		c_collection_length1 = columns_length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			QliteColumn* _tmp2_;
			QliteColumn* c = NULL;
			_tmp2_ = _qlite_column_ref0 (c_collection[c_it]);
			c = _tmp2_;
			{
				const gchar* _tmp5_;
				QliteColumn* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				if (!first) {
					const gchar* _tmp3_;
					gchar* _tmp4_;
					_tmp3_ = self->priv->constraints;
					_tmp4_ = g_strconcat (_tmp3_, ", ", NULL);
					_g_free0 (self->priv->constraints);
					self->priv->constraints = _tmp4_;
				}
				_tmp5_ = self->priv->constraints;
				_tmp6_ = c;
				_tmp7_ = qlite_column_get_name (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
				_g_free0 (self->priv->constraints);
				self->priv->constraints = _tmp9_;
				first = FALSE;
				_qlite_column_unref0 (c);
			}
		}
	}
	_tmp10_ = self->priv->constraints;
	_tmp11_ = g_strconcat (_tmp10_, ")", NULL);
	_g_free0 (self->priv->constraints);
	self->priv->constraints = _tmp11_;
	if (on_conflict != NULL) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = self->priv->constraints;
		_tmp13_ = g_strconcat (" ON CONFLICT ", (const gchar*) on_conflict, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
		_g_free0 (self->priv->constraints);
		self->priv->constraints = _tmp15_;
		_g_free0 (_tmp14_);
	}
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
qlite_table_add_post_statement (QliteTable* self,
                                const gchar* stmt)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	_tmp0_ = g_strdup (stmt);
	_vala_array_add10 (&self->priv->post_statements, &self->priv->post_statements_length1, &self->priv->_post_statements_size_, _tmp0_);
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
qlite_table_add_create_statement (QliteTable* self,
                                  const gchar* stmt)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	_tmp0_ = g_strdup (stmt);
	_vala_array_add11 (&self->priv->create_statements, &self->priv->create_statements_length1, &self->priv->_create_statements_size_, _tmp0_);
}

void
qlite_table_index (QliteTable* self,
                   const gchar* index_name,
                   QliteColumn** columns,
                   gint columns_length1,
                   gboolean unique)
{
	const gchar* _tmp0_ = NULL;
	gchar* stmt = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (index_name != NULL);
	if (unique) {
		_tmp0_ = "UNIQUE";
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = string_to_string (index_name);
	_tmp3_ = self->priv->_name;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat ("CREATE ", _tmp1_, " INDEX IF NOT EXISTS ", _tmp2_, " ON ", _tmp4_, " (", NULL);
	stmt = _tmp5_;
	first = TRUE;
	{
		QliteColumn** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = columns;
		c_collection_length1 = columns_length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			QliteColumn* _tmp6_;
			QliteColumn* c = NULL;
			_tmp6_ = _qlite_column_ref0 (c_collection[c_it]);
			c = _tmp6_;
			{
				const gchar* _tmp9_;
				QliteColumn* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				if (!first) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = stmt;
					_tmp8_ = g_strconcat (_tmp7_, ", ", NULL);
					_g_free0 (stmt);
					stmt = _tmp8_;
				}
				_tmp9_ = stmt;
				_tmp10_ = c;
				_tmp11_ = qlite_column_get_name (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
				_g_free0 (stmt);
				stmt = _tmp13_;
				first = FALSE;
				_qlite_column_unref0 (c);
			}
		}
	}
	_tmp14_ = stmt;
	_tmp15_ = g_strconcat (_tmp14_, ")", NULL);
	_g_free0 (stmt);
	stmt = _tmp15_;
	_tmp16_ = stmt;
	qlite_table_add_post_statement (self, _tmp16_);
	_g_free0 (stmt);
}

static void
qlite_table_ensure_init (QliteTable* self)
{
	QliteColumn** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->columns;
	_tmp0__length1 = self->columns_length1;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_name;
		g_error ("table.vala:90: Table %s was not initialized, call init()", _tmp1_);
	}
}

QliteQueryBuilder*
qlite_table_select (QliteTable* self,
                    QliteColumn** columns,
                    gint columns_length1)
{
	QliteDatabase* _tmp0_;
	QliteQueryBuilder* _tmp1_;
	QliteQueryBuilder* _tmp2_;
	QliteQueryBuilder* _tmp3_;
	QliteQueryBuilder* _tmp4_;
	QliteQueryBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	qlite_table_ensure_init (self);
	_tmp0_ = self->db;
	_tmp1_ = qlite_database_select (_tmp0_, columns, (gint) columns_length1);
	_tmp2_ = _tmp1_;
	_tmp3_ = qlite_query_builder_from (_tmp2_, self);
	_tmp4_ = _tmp3_;
	_qlite_statement_builder_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static QliteMatchQueryBuilder*
qlite_table_match_query (QliteTable* self)
{
	QliteDatabase* _tmp0_;
	QliteMatchQueryBuilder* _tmp1_;
	QliteMatchQueryBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	qlite_table_ensure_init (self);
	_tmp0_ = self->db;
	_tmp1_ = qlite_database_match_query (_tmp0_, self);
	result = _tmp1_;
	return result;
}

QliteMatchQueryBuilder*
qlite_table_match (QliteTable* self,
                   QliteColumn* column,
                   const gchar* query)
{
	QliteMatchQueryBuilder* _tmp0_;
	QliteMatchQueryBuilder* _tmp1_;
	QliteMatchQueryBuilder* _tmp2_;
	QliteMatchQueryBuilder* _tmp3_;
	QliteMatchQueryBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (column != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = qlite_table_match_query (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = qlite_match_query_builder_match (_tmp1_, column, query);
	_tmp3_ = _tmp2_;
	_qlite_statement_builder_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

QliteInsertBuilder*
qlite_table_insert (QliteTable* self)
{
	QliteDatabase* _tmp0_;
	QliteInsertBuilder* _tmp1_;
	QliteInsertBuilder* _tmp2_;
	QliteInsertBuilder* _tmp3_;
	QliteInsertBuilder* _tmp4_;
	QliteInsertBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	qlite_table_ensure_init (self);
	_tmp0_ = self->db;
	_tmp1_ = qlite_database_insert (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = qlite_insert_builder_into (_tmp2_, self);
	_tmp4_ = _tmp3_;
	_qlite_statement_builder_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

QliteUpdateBuilder*
qlite_table_update (QliteTable* self)
{
	QliteDatabase* _tmp0_;
	QliteUpdateBuilder* _tmp1_;
	QliteUpdateBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	qlite_table_ensure_init (self);
	_tmp0_ = self->db;
	_tmp1_ = qlite_database_update (_tmp0_, self);
	result = _tmp1_;
	return result;
}

QliteUpsertBuilder*
qlite_table_upsert (QliteTable* self)
{
	QliteDatabase* _tmp0_;
	QliteUpsertBuilder* _tmp1_;
	QliteUpsertBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	qlite_table_ensure_init (self);
	_tmp0_ = self->db;
	_tmp1_ = qlite_database_upsert (_tmp0_, self);
	result = _tmp1_;
	return result;
}

QliteDeleteBuilder*
qlite_table_delete (QliteTable* self)
{
	QliteDatabase* _tmp0_;
	QliteDeleteBuilder* _tmp1_;
	QliteDeleteBuilder* _tmp2_;
	QliteDeleteBuilder* _tmp3_;
	QliteDeleteBuilder* _tmp4_;
	QliteDeleteBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	qlite_table_ensure_init (self);
	_tmp0_ = self->db;
	_tmp1_ = qlite_database_delete (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = qlite_delete_builder_from (_tmp2_, self);
	_tmp4_ = _tmp3_;
	_qlite_statement_builder_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

QliteRowOption*
qlite_table_row_with (QliteTable* self,
                      GType t_type,
                      GBoxedCopyFunc t_dup_func,
                      GDestroyNotify t_destroy_func,
                      QliteColumn* column,
                      gconstpointer value)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	QliteQueryBuilder* _tmp7_;
	QliteQueryBuilder* _tmp8_;
	QliteQueryBuilder* _tmp9_;
	QliteQueryBuilder* _tmp10_;
	QliteRowOption* _tmp11_;
	QliteRowOption* _tmp12_;
	QliteRowOption* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (column != NULL, NULL);
	qlite_table_ensure_init (self);
	_tmp1_ = qlite_column_get_unique (column);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = qlite_column_get_primary_key (column);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = qlite_column_get_name (column);
		_tmp6_ = _tmp5_;
		g_error ("table.vala:129: %s is not suited to identify a row, but used with row_" \
"with()", _tmp6_);
	}
	_tmp7_ = qlite_table_select (self, NULL, (gint) 0);
	_tmp8_ = _tmp7_;
	_tmp9_ = qlite_query_builder_with (_tmp8_, t_type, (GBoxedCopyFunc) t_dup_func, (GDestroyNotify) t_destroy_func, column, "=", value);
	_tmp10_ = _tmp9_;
	_tmp11_ = qlite_query_builder_row (_tmp10_);
	_tmp12_ = _tmp11_;
	_qlite_statement_builder_unref0 (_tmp10_);
	_qlite_statement_builder_unref0 (_tmp8_);
	result = _tmp12_;
	return result;
}

gboolean
qlite_table_is_known_column (QliteTable* self,
                             const gchar* column)
{
	QliteColumn** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (column != NULL, FALSE);
	qlite_table_ensure_init (self);
	_tmp0_ = self->columns;
	_tmp0__length1 = self->columns_length1;
	{
		QliteColumn** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp0_;
		c_collection_length1 = _tmp0__length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			QliteColumn* _tmp1_;
			QliteColumn* c = NULL;
			_tmp1_ = _qlite_column_ref0 (c_collection[c_it]);
			c = _tmp1_;
			{
				QliteColumn* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = c;
				_tmp3_ = qlite_column_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (_tmp4_, column) == 0) {
					result = TRUE;
					_qlite_column_unref0 (c);
					return result;
				}
				_qlite_column_unref0 (c);
			}
		}
	}
	result = FALSE;
	return result;
}

void
qlite_table_create_table_at_version (QliteTable* self,
                                     glong version)
{
	gchar* sql = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean first = FALSE;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	qlite_table_ensure_init (self);
	_tmp0_ = self->priv->_name;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("CREATE TABLE IF NOT EXISTS ", _tmp1_, " (", NULL);
	sql = _tmp2_;
	first = TRUE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				QliteColumn** _tmp5_;
				gint _tmp5__length1;
				QliteColumn* c = NULL;
				QliteColumn** _tmp6_;
				gint _tmp6__length1;
				QliteColumn* _tmp7_;
				QliteColumn* _tmp8_;
				gboolean _tmp9_ = FALSE;
				QliteColumn* _tmp10_;
				glong _tmp11_;
				glong _tmp12_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->columns;
				_tmp5__length1 = self->columns_length1;
				if (!(i < _tmp5__length1)) {
					break;
				}
				_tmp6_ = self->columns;
				_tmp6__length1 = self->columns_length1;
				_tmp7_ = _tmp6_[i];
				_tmp8_ = _qlite_column_ref0 (_tmp7_);
				c = _tmp8_;
				_tmp10_ = c;
				_tmp11_ = qlite_column_get_min_version (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ <= version) {
					QliteColumn* _tmp13_;
					glong _tmp14_;
					glong _tmp15_;
					_tmp13_ = c;
					_tmp14_ = qlite_column_get_max_version (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp9_ = _tmp15_ >= version;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					QliteColumn* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					if (!first) {
						_tmp16_ = ",";
					} else {
						_tmp16_ = "";
					}
					_tmp17_ = sql;
					_tmp18_ = string_to_string (_tmp16_);
					_tmp19_ = c;
					_tmp20_ = qlite_column_to_column_definition (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = string_to_string (_tmp21_);
					_tmp23_ = g_strconcat (_tmp18_, " ", _tmp22_, NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp17_, _tmp24_, NULL);
					_g_free0 (sql);
					sql = _tmp25_;
					_g_free0 (_tmp24_);
					_g_free0 (_tmp21_);
					first = FALSE;
				}
				_qlite_column_unref0 (c);
			}
		}
	}
	_tmp26_ = sql;
	_tmp27_ = self->priv->constraints;
	_tmp28_ = string_to_string (_tmp27_);
	_tmp29_ = g_strconcat (_tmp28_, ")", NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp26_, _tmp30_, NULL);
	_g_free0 (sql);
	sql = _tmp31_;
	_g_free0 (_tmp30_);
	{
		QliteDatabase* _tmp32_;
		const gchar* _tmp33_;
		_tmp32_ = self->db;
		_tmp33_ = sql;
		qlite_database_exec (_tmp32_, _tmp33_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = e->message;
		_tmp35_ = string_to_string (_tmp34_);
		_tmp36_ = g_strconcat ("Qlite Error: Create table at version: ", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		g_error ("table.vala:156: %s", _tmp37_);
		_g_free0 (_tmp37_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (sql);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp38_ = self->priv->create_statements;
	_tmp38__length1 = self->priv->create_statements_length1;
	{
		gchar** stmt_collection = NULL;
		gint stmt_collection_length1 = 0;
		gint _stmt_collection_size_ = 0;
		gint stmt_it = 0;
		stmt_collection = _tmp38_;
		stmt_collection_length1 = _tmp38__length1;
		for (stmt_it = 0; stmt_it < stmt_collection_length1; stmt_it = stmt_it + 1) {
			gchar* _tmp39_;
			gchar* stmt = NULL;
			_tmp39_ = g_strdup (stmt_collection[stmt_it]);
			stmt = _tmp39_;
			{
				{
					QliteDatabase* _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = self->db;
					_tmp41_ = stmt;
					qlite_database_exec (_tmp40_, _tmp41_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp42_ = e->message;
					_tmp43_ = string_to_string (_tmp42_);
					_tmp44_ = g_strconcat ("Qlite Error: Create table at version: ", _tmp43_, NULL);
					_tmp45_ = _tmp44_;
					g_error ("table.vala:162: %s", _tmp45_);
					_g_free0 (_tmp45_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (stmt);
					_g_free0 (sql);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (stmt);
			}
		}
	}
	_g_free0 (sql);
}

void
qlite_table_add_columns_for_version (QliteTable* self,
                                     glong old_version,
                                     glong new_version)
{
	QliteColumn** _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	qlite_table_ensure_init (self);
	_tmp0_ = self->columns;
	_tmp0__length1 = self->columns_length1;
	{
		QliteColumn** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp0_;
		c_collection_length1 = _tmp0__length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			QliteColumn* _tmp1_;
			QliteColumn* c = NULL;
			_tmp1_ = _qlite_column_ref0 (c_collection[c_it]);
			c = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				QliteColumn* _tmp4_;
				glong _tmp5_;
				glong _tmp6_;
				_tmp4_ = c;
				_tmp5_ = qlite_column_get_min_version (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ <= new_version) {
					QliteColumn* _tmp7_;
					glong _tmp8_;
					glong _tmp9_;
					_tmp7_ = c;
					_tmp8_ = qlite_column_get_max_version (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp3_ = _tmp9_ >= new_version;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					QliteColumn* _tmp10_;
					glong _tmp11_;
					glong _tmp12_;
					_tmp10_ = c;
					_tmp11_ = qlite_column_get_min_version (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp2_ = _tmp12_ > old_version;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					{
						QliteDatabase* _tmp13_;
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						QliteColumn* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						const gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp13_ = self->db;
						_tmp14_ = self->priv->_name;
						_tmp15_ = string_to_string (_tmp14_);
						_tmp16_ = c;
						_tmp17_ = qlite_column_to_column_definition (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp19_ = string_to_string (_tmp18_);
						_tmp20_ = g_strconcat ("ALTER TABLE ", _tmp15_, " ADD COLUMN ", _tmp19_, NULL);
						_tmp21_ = _tmp20_;
						qlite_database_exec (_tmp13_, _tmp21_, &_inner_error0_);
						_g_free0 (_tmp21_);
						_g_free0 (_tmp18_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						GError* _tmp22_;
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp22_ = e;
						_tmp23_ = _tmp22_->message;
						_tmp24_ = string_to_string (_tmp23_);
						_tmp25_ = g_strconcat ("Qlite Error: Add columns for version: ", _tmp24_, NULL);
						_tmp26_ = _tmp25_;
						g_critical ("table.vala:174: %s", _tmp26_);
						_g_free0 (_tmp26_);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_qlite_column_unref0 (c);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_qlite_column_unref0 (c);
			}
		}
	}
}

void
qlite_table_delete_columns_for_version (QliteTable* self,
                                        glong old_version,
                                        glong new_version)
{
	gboolean column_deletion_required = FALSE;
	gchar* column_list = NULL;
	gchar* _tmp0_;
	QliteColumn** _tmp1_;
	gint _tmp1__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	column_deletion_required = FALSE;
	_tmp0_ = g_strdup ("");
	column_list = _tmp0_;
	_tmp1_ = self->columns;
	_tmp1__length1 = self->columns_length1;
	{
		QliteColumn** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp1_;
		c_collection_length1 = _tmp1__length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			QliteColumn* _tmp2_;
			QliteColumn* c = NULL;
			_tmp2_ = _qlite_column_ref0 (c_collection[c_it]);
			c = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				QliteColumn* _tmp4_;
				glong _tmp5_;
				glong _tmp6_;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				QliteColumn* _tmp25_;
				glong _tmp26_;
				glong _tmp27_;
				_tmp4_ = c;
				_tmp5_ = qlite_column_get_min_version (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ <= new_version) {
					QliteColumn* _tmp7_;
					glong _tmp8_;
					glong _tmp9_;
					_tmp7_ = c;
					_tmp8_ = qlite_column_get_max_version (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp3_ = _tmp9_ >= new_version;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					const gchar* _tmp10_;
					_tmp10_ = column_list;
					if (g_strcmp0 (_tmp10_, "") == 0) {
						QliteColumn* _tmp11_;
						const gchar* _tmp12_;
						const gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp11_ = c;
						_tmp12_ = qlite_column_get_name (_tmp11_);
						_tmp13_ = _tmp12_;
						_tmp14_ = g_strdup (_tmp13_);
						_g_free0 (column_list);
						column_list = _tmp14_;
					} else {
						const gchar* _tmp15_;
						QliteColumn* _tmp16_;
						const gchar* _tmp17_;
						const gchar* _tmp18_;
						gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp15_ = column_list;
						_tmp16_ = c;
						_tmp17_ = qlite_column_get_name (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp19_ = g_strconcat (", ", _tmp18_, NULL);
						_tmp20_ = _tmp19_;
						_tmp21_ = g_strconcat (_tmp15_, _tmp20_, NULL);
						_g_free0 (column_list);
						column_list = _tmp21_;
						_g_free0 (_tmp20_);
					}
				}
				_tmp25_ = c;
				_tmp26_ = qlite_column_get_min_version (_tmp25_);
				_tmp27_ = _tmp26_;
				if (_tmp27_ <= new_version) {
					QliteColumn* _tmp28_;
					glong _tmp29_;
					glong _tmp30_;
					_tmp28_ = c;
					_tmp29_ = qlite_column_get_max_version (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp24_ = _tmp30_ >= new_version;
				} else {
					_tmp24_ = FALSE;
				}
				if (!_tmp24_) {
					QliteColumn* _tmp31_;
					glong _tmp32_;
					glong _tmp33_;
					_tmp31_ = c;
					_tmp32_ = qlite_column_get_min_version (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp23_ = _tmp33_ <= old_version;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					QliteColumn* _tmp34_;
					glong _tmp35_;
					glong _tmp36_;
					_tmp34_ = c;
					_tmp35_ = qlite_column_get_max_version (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp22_ = _tmp36_ >= old_version;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					column_deletion_required = TRUE;
				}
				_qlite_column_unref0 (c);
			}
		}
	}
	if (column_deletion_required) {
		{
			QliteDatabase* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			QliteDatabase* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			const gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			QliteDatabase* _tmp59_;
			const gchar* _tmp60_;
			const gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			_tmp37_ = self->db;
			_tmp38_ = self->priv->_name;
			_tmp39_ = string_to_string (_tmp38_);
			_tmp40_ = self->priv->_name;
			_tmp41_ = string_to_string (_tmp40_);
			_tmp42_ = g_strdup_printf ("%li", old_version);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat ("ALTER TABLE ", _tmp39_, " RENAME TO _", _tmp41_, "_", _tmp43_, NULL);
			_tmp45_ = _tmp44_;
			qlite_database_exec (_tmp37_, _tmp45_, &_inner_error0_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			qlite_table_create_table_at_version (self, new_version);
			_tmp46_ = self->db;
			_tmp47_ = self->priv->_name;
			_tmp48_ = string_to_string (_tmp47_);
			_tmp49_ = column_list;
			_tmp50_ = string_to_string (_tmp49_);
			_tmp51_ = column_list;
			_tmp52_ = string_to_string (_tmp51_);
			_tmp53_ = self->priv->_name;
			_tmp54_ = string_to_string (_tmp53_);
			_tmp55_ = g_strdup_printf ("%li", old_version);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strconcat ("INSERT INTO ", _tmp48_, " (", _tmp50_, ") SELECT ", _tmp52_, " FROM _", _tmp54_, "_", _tmp56_, NULL);
			_tmp58_ = _tmp57_;
			qlite_database_exec (_tmp46_, _tmp58_, &_inner_error0_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp59_ = self->db;
			_tmp60_ = self->priv->_name;
			_tmp61_ = string_to_string (_tmp60_);
			_tmp62_ = g_strdup_printf ("%li", old_version);
			_tmp63_ = _tmp62_;
			_tmp64_ = g_strconcat ("DROP TABLE _", _tmp61_, "_", _tmp63_, NULL);
			_tmp65_ = _tmp64_;
			qlite_database_exec (_tmp59_, _tmp65_, &_inner_error0_);
			_g_free0 (_tmp65_);
			_g_free0 (_tmp63_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp66_ = e->message;
			_tmp67_ = string_to_string (_tmp66_);
			_tmp68_ = g_strconcat ("Qlite Error: Delete columns for version change: ", _tmp67_, NULL);
			_tmp69_ = _tmp68_;
			g_error ("table.vala:202: %s", _tmp69_);
			_g_free0 (_tmp69_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (column_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (column_list);
}

void
qlite_table_post (QliteTable* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->post_statements;
	_tmp0__length1 = self->priv->post_statements_length1;
	{
		gchar** stmt_collection = NULL;
		gint stmt_collection_length1 = 0;
		gint _stmt_collection_size_ = 0;
		gint stmt_it = 0;
		stmt_collection = _tmp0_;
		stmt_collection_length1 = _tmp0__length1;
		for (stmt_it = 0; stmt_it < stmt_collection_length1; stmt_it = stmt_it + 1) {
			gchar* _tmp1_;
			gchar* stmt = NULL;
			_tmp1_ = g_strdup (stmt_collection[stmt_it]);
			stmt = _tmp1_;
			{
				{
					QliteDatabase* _tmp2_;
					const gchar* _tmp3_;
					_tmp2_ = self->db;
					_tmp3_ = stmt;
					qlite_database_exec (_tmp2_, _tmp3_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp4_ = e->message;
					_tmp5_ = string_to_string (_tmp4_);
					_tmp6_ = g_strconcat ("Qlite Error: Post: ", _tmp5_, NULL);
					_tmp7_ = _tmp6_;
					g_error ("table.vala:212: %s", _tmp7_);
					_g_free0 (_tmp7_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (stmt);
			}
		}
	}
}

const gchar*
qlite_table_get_name (QliteTable* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
qlite_table_set_name (QliteTable* self,
                      const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

static void
qlite_value_table_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
qlite_value_table_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		qlite_table_unref (value->data[0].v_pointer);
	}
}

static void
qlite_value_table_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = qlite_table_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
qlite_value_table_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
qlite_value_table_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		QliteTable * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = qlite_table_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
qlite_value_table_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	QliteTable ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = qlite_table_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
qlite_param_spec_table (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	QliteParamSpecTable* spec;
	g_return_val_if_fail (g_type_is_a (object_type, QLITE_TYPE_TABLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
qlite_value_get_table (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, QLITE_TYPE_TABLE), NULL);
	return value->data[0].v_pointer;
}

void
qlite_value_set_table (GValue* value,
                       gpointer v_object)
{
	QliteTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, QLITE_TYPE_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, QLITE_TYPE_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		qlite_table_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		qlite_table_unref (old);
	}
}

void
qlite_value_take_table (GValue* value,
                        gpointer v_object)
{
	QliteTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, QLITE_TYPE_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, QLITE_TYPE_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		qlite_table_unref (old);
	}
}

static void
qlite_table_class_init (QliteTableClass * klass,
                        gpointer klass_data)
{
	qlite_table_parent_class = g_type_class_peek_parent (klass);
	((QliteTableClass *) klass)->finalize = qlite_table_finalize;
	g_type_class_adjust_private_offset (klass, &QliteTable_private_offset);
}

static void
qlite_table_instance_init (QliteTable * self,
                           gpointer klass)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	self->priv = qlite_table_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->constraints = _tmp0_;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	self->priv->post_statements = _tmp1_;
	self->priv->post_statements_length1 = 0;
	self->priv->_post_statements_size_ = self->priv->post_statements_length1;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	self->priv->create_statements = _tmp2_;
	self->priv->create_statements_length1 = 0;
	self->priv->_create_statements_size_ = self->priv->create_statements_length1;
	self->ref_count = 1;
}

static void
qlite_table_finalize (QliteTable * obj)
{
	QliteTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, QLITE_TYPE_TABLE, QliteTable);
	g_signal_handlers_destroy (self);
	_qlite_database_unref0 (self->db);
	_g_free0 (self->priv->_name);
	self->columns = (_vala_array_free (self->columns, self->columns_length1, (GDestroyNotify) qlite_column_unref), NULL);
	_g_free0 (self->priv->constraints);
	self->priv->post_statements = (_vala_array_free (self->priv->post_statements, self->priv->post_statements_length1, (GDestroyNotify) g_free), NULL);
	self->priv->create_statements = (_vala_array_free (self->priv->create_statements, self->priv->create_statements_length1, (GDestroyNotify) g_free), NULL);
	self->fts_columns = (_vala_array_free (self->fts_columns, self->fts_columns_length1, (GDestroyNotify) qlite_column_unref), NULL);
}

static GType
qlite_table_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { qlite_value_table_init, qlite_value_table_free_value, qlite_value_table_copy_value, qlite_value_table_peek_pointer, "p", qlite_value_table_collect_value, "p", qlite_value_table_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (QliteTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) qlite_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QliteTable), 0, (GInstanceInitFunc) qlite_table_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType qlite_table_type_id;
	qlite_table_type_id = g_type_register_fundamental (g_type_fundamental_next (), "QliteTable", &g_define_type_info, &g_define_type_fundamental_info, 0);
	QliteTable_private_offset = g_type_add_instance_private (qlite_table_type_id, sizeof (QliteTablePrivate));
	return qlite_table_type_id;
}

GType
qlite_table_get_type (void)
{
	static volatile gsize qlite_table_type_id__once = 0;
	if (g_once_init_enter (&qlite_table_type_id__once)) {
		GType qlite_table_type_id;
		qlite_table_type_id = qlite_table_get_type_once ();
		g_once_init_leave (&qlite_table_type_id__once, qlite_table_type_id);
	}
	return qlite_table_type_id__once;
}

gpointer
qlite_table_ref (gpointer instance)
{
	QliteTable * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
qlite_table_unref (gpointer instance)
{
	QliteTable * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		QLITE_TABLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

