// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/******************************************************************

DO NOT MODIFY. AUTOGENERATED FILE.
This file is generated using the logic from <root>/src/scripts/genEventPipe.py

******************************************************************/

#include <common.h>
#include "eventpipeadapter.h"

#if defined(TARGET_UNIX)
#define wcslen PAL_wcslen
#endif

bool ResizeBuffer(BYTE *&buffer, size_t& size, size_t currLen, size_t newSize, bool &fixedBuffer);
bool WriteToBuffer(PCWSTR str, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const char *str, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const BYTE *src, size_t len, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);

template <typename T>
bool WriteToBuffer(const T &value, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer)
{
    if (sizeof(T) + offset > size)
    {
        if (!ResizeBuffer(buffer, size, offset, size + sizeof(T), fixedBuffer))
            return false;
    }

    memcpy(buffer + offset, (char *)&value, sizeof(T));
    offset += sizeof(T);
    return true;
}

const WCHAR* DotNETRuntimeRundownName = W("Microsoft-Windows-DotNETRuntimeRundown");
EventPipeProvider *EventPipeProviderDotNETRuntimeRundown = nullptr;
EventPipeEvent *EventPipeEventCLRStackWalkDCStart = nullptr;
EventPipeEvent *EventPipeEventGCSettingsRundown = nullptr;
EventPipeEvent *EventPipeEventMethodDCStart = nullptr;
EventPipeEvent *EventPipeEventMethodDCStart_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodDCStart_V2 = nullptr;
EventPipeEvent *EventPipeEventMethodDCEnd = nullptr;
EventPipeEvent *EventPipeEventMethodDCEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodDCEnd_V2 = nullptr;
EventPipeEvent *EventPipeEventMethodDCStartVerbose = nullptr;
EventPipeEvent *EventPipeEventMethodDCStartVerbose_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodDCStartVerbose_V2 = nullptr;
EventPipeEvent *EventPipeEventMethodDCEndVerbose = nullptr;
EventPipeEvent *EventPipeEventMethodDCEndVerbose_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodDCEndVerbose_V2 = nullptr;
EventPipeEvent *EventPipeEventDCStartComplete = nullptr;
EventPipeEvent *EventPipeEventDCStartComplete_V1 = nullptr;
EventPipeEvent *EventPipeEventDCEndComplete = nullptr;
EventPipeEvent *EventPipeEventDCEndComplete_V1 = nullptr;
EventPipeEvent *EventPipeEventDCStartInit = nullptr;
EventPipeEvent *EventPipeEventDCStartInit_V1 = nullptr;
EventPipeEvent *EventPipeEventDCEndInit = nullptr;
EventPipeEvent *EventPipeEventDCEndInit_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodDCStartILToNativeMap = nullptr;
EventPipeEvent *EventPipeEventMethodDCStartILToNativeMap_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodDCEndILToNativeMap = nullptr;
EventPipeEvent *EventPipeEventMethodDCEndILToNativeMap_V1 = nullptr;
EventPipeEvent *EventPipeEventDomainModuleDCStart = nullptr;
EventPipeEvent *EventPipeEventDomainModuleDCStart_V1 = nullptr;
EventPipeEvent *EventPipeEventDomainModuleDCEnd = nullptr;
EventPipeEvent *EventPipeEventDomainModuleDCEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventModuleDCStart = nullptr;
EventPipeEvent *EventPipeEventModuleDCStart_V1 = nullptr;
EventPipeEvent *EventPipeEventModuleDCStart_V2 = nullptr;
EventPipeEvent *EventPipeEventModuleDCEnd = nullptr;
EventPipeEvent *EventPipeEventModuleDCEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventModuleDCEnd_V2 = nullptr;
EventPipeEvent *EventPipeEventAssemblyDCStart = nullptr;
EventPipeEvent *EventPipeEventAssemblyDCStart_V1 = nullptr;
EventPipeEvent *EventPipeEventAssemblyDCEnd = nullptr;
EventPipeEvent *EventPipeEventAssemblyDCEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventAppDomainDCStart = nullptr;
EventPipeEvent *EventPipeEventAppDomainDCStart_V1 = nullptr;
EventPipeEvent *EventPipeEventAppDomainDCEnd = nullptr;
EventPipeEvent *EventPipeEventAppDomainDCEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventThreadDC = nullptr;
EventPipeEvent *EventPipeEventModuleRangeDCStart = nullptr;
EventPipeEvent *EventPipeEventModuleRangeDCEnd = nullptr;
EventPipeEvent *EventPipeEventRuntimeInformationDCStart = nullptr;
EventPipeEvent *EventPipeEventTieredCompilationSettingsDCStart = nullptr;
EventPipeEvent *EventPipeEventExecutionCheckpointDCEnd = nullptr;

BOOL EventPipeEventEnabledCLRStackWalkDCStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventCLRStackWalkDCStart);
}

extern "C" ULONG EventPipeWriteEventCLRStackWalkDCStart(
    const unsigned short ClrInstanceID,
    const unsigned char Reserved1,
    const unsigned char Reserved2,
    const unsigned int FrameCount,
    const void** Stack,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledCLRStackWalkDCStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FrameCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Stack, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventCLRStackWalkDCStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCSettingsRundown(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCSettingsRundown);
}

extern "C" ULONG EventPipeWriteEventGCSettingsRundown(
    const unsigned __int64 HardLimit,
    const unsigned __int64 LOHThreshold,
    const unsigned __int64 PhysicalMemoryConfig,
    const unsigned __int64 Gen0MinBudgetConfig,
    const unsigned __int64 Gen0MaxBudgetConfig,
    const unsigned int HighMemPercentConfig,
    const unsigned int BitSettings,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCSettingsRundown())
        return ERROR_SUCCESS;

    size_t size = 50;
    BYTE stackBuffer[50];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HardLimit, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LOHThreshold, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PhysicalMemoryConfig, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Gen0MinBudgetConfig, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Gen0MaxBudgetConfig, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(HighMemPercentConfig, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BitSettings, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCSettingsRundown, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCStart);
}

extern "C" ULONG EventPipeWriteEventMethodDCStart(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCStart())
        return ERROR_SUCCESS;

    size_t size = 36;
    BYTE stackBuffer[36];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCStart_V1);
}

extern "C" ULONG EventPipeWriteEventMethodDCStart_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCStart_V1())
        return ERROR_SUCCESS;

    size_t size = 38;
    BYTE stackBuffer[38];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCStart_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCStart_V2);
}

extern "C" ULONG EventPipeWriteEventMethodDCStart_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCStart_V2())
        return ERROR_SUCCESS;

    size_t size = 46;
    BYTE stackBuffer[46];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCStart_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCEnd);
}

extern "C" ULONG EventPipeWriteEventMethodDCEnd(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCEnd())
        return ERROR_SUCCESS;

    size_t size = 36;
    BYTE stackBuffer[36];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCEnd_V1);
}

extern "C" ULONG EventPipeWriteEventMethodDCEnd_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 38;
    BYTE stackBuffer[38];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCEnd_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCEnd_V2);
}

extern "C" ULONG EventPipeWriteEventMethodDCEnd_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCEnd_V2())
        return ERROR_SUCCESS;

    size_t size = 46;
    BYTE stackBuffer[46];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCEnd_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCStartVerbose(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCStartVerbose);
}

extern "C" ULONG EventPipeWriteEventMethodDCStartVerbose(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCStartVerbose())
        return ERROR_SUCCESS;

    size_t size = 228;
    BYTE stackBuffer[228];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCStartVerbose, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCStartVerbose_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCStartVerbose_V1);
}

extern "C" ULONG EventPipeWriteEventMethodDCStartVerbose_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCStartVerbose_V1())
        return ERROR_SUCCESS;

    size_t size = 230;
    BYTE stackBuffer[230];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCStartVerbose_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCStartVerbose_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCStartVerbose_V2);
}

extern "C" ULONG EventPipeWriteEventMethodDCStartVerbose_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCStartVerbose_V2())
        return ERROR_SUCCESS;

    size_t size = 238;
    BYTE stackBuffer[238];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCStartVerbose_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCEndVerbose(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCEndVerbose);
}

extern "C" ULONG EventPipeWriteEventMethodDCEndVerbose(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCEndVerbose())
        return ERROR_SUCCESS;

    size_t size = 228;
    BYTE stackBuffer[228];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCEndVerbose, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCEndVerbose_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCEndVerbose_V1);
}

extern "C" ULONG EventPipeWriteEventMethodDCEndVerbose_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCEndVerbose_V1())
        return ERROR_SUCCESS;

    size_t size = 230;
    BYTE stackBuffer[230];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCEndVerbose_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCEndVerbose_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCEndVerbose_V2);
}

extern "C" ULONG EventPipeWriteEventMethodDCEndVerbose_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCEndVerbose_V2())
        return ERROR_SUCCESS;

    size_t size = 238;
    BYTE stackBuffer[238];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCEndVerbose_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDCStartComplete(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDCStartComplete);
}

extern "C" ULONG EventPipeWriteEventDCStartComplete(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDCStartComplete())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventDCStartComplete, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDCStartComplete_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDCStartComplete_V1);
}

extern "C" ULONG EventPipeWriteEventDCStartComplete_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDCStartComplete_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDCStartComplete_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDCEndComplete(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDCEndComplete);
}

extern "C" ULONG EventPipeWriteEventDCEndComplete(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDCEndComplete())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventDCEndComplete, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDCEndComplete_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDCEndComplete_V1);
}

extern "C" ULONG EventPipeWriteEventDCEndComplete_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDCEndComplete_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDCEndComplete_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDCStartInit(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDCStartInit);
}

extern "C" ULONG EventPipeWriteEventDCStartInit(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDCStartInit())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventDCStartInit, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDCStartInit_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDCStartInit_V1);
}

extern "C" ULONG EventPipeWriteEventDCStartInit_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDCStartInit_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDCStartInit_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDCEndInit(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDCEndInit);
}

extern "C" ULONG EventPipeWriteEventDCEndInit(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDCEndInit())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventDCEndInit, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDCEndInit_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDCEndInit_V1);
}

extern "C" ULONG EventPipeWriteEventDCEndInit_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDCEndInit_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDCEndInit_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCStartILToNativeMap(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCStartILToNativeMap);
}

extern "C" ULONG EventPipeWriteEventMethodDCStartILToNativeMap(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCStartILToNativeMap())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCStartILToNativeMap, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCStartILToNativeMap_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCStartILToNativeMap_V1);
}

extern "C" ULONG EventPipeWriteEventMethodDCStartILToNativeMap_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ILVersionID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCStartILToNativeMap_V1())
        return ERROR_SUCCESS;

    size_t size = 37;
    BYTE stackBuffer[37];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ILVersionID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCStartILToNativeMap_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCEndILToNativeMap(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCEndILToNativeMap);
}

extern "C" ULONG EventPipeWriteEventMethodDCEndILToNativeMap(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCEndILToNativeMap())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCEndILToNativeMap, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCEndILToNativeMap_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCEndILToNativeMap_V1);
}

extern "C" ULONG EventPipeWriteEventMethodDCEndILToNativeMap_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ILVersionID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCEndILToNativeMap_V1())
        return ERROR_SUCCESS;

    size_t size = 37;
    BYTE stackBuffer[37];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ILVersionID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCEndILToNativeMap_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDomainModuleDCStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDomainModuleDCStart);
}

extern "C" ULONG EventPipeWriteEventDomainModuleDCStart(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDomainModuleDCStart())
        return ERROR_SUCCESS;

    size_t size = 160;
    BYTE stackBuffer[160];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDomainModuleDCStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDomainModuleDCStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDomainModuleDCStart_V1);
}

extern "C" ULONG EventPipeWriteEventDomainModuleDCStart_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDomainModuleDCStart_V1())
        return ERROR_SUCCESS;

    size_t size = 162;
    BYTE stackBuffer[162];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDomainModuleDCStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDomainModuleDCEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDomainModuleDCEnd);
}

extern "C" ULONG EventPipeWriteEventDomainModuleDCEnd(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDomainModuleDCEnd())
        return ERROR_SUCCESS;

    size_t size = 160;
    BYTE stackBuffer[160];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDomainModuleDCEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDomainModuleDCEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDomainModuleDCEnd_V1);
}

extern "C" ULONG EventPipeWriteEventDomainModuleDCEnd_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDomainModuleDCEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 162;
    BYTE stackBuffer[162];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDomainModuleDCEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleDCStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleDCStart);
}

extern "C" ULONG EventPipeWriteEventModuleDCStart(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleDCStart())
        return ERROR_SUCCESS;

    size_t size = 152;
    BYTE stackBuffer[152];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleDCStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleDCStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleDCStart_V1);
}

extern "C" ULONG EventPipeWriteEventModuleDCStart_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleDCStart_V1())
        return ERROR_SUCCESS;

    size_t size = 154;
    BYTE stackBuffer[154];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleDCStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleDCStart_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleDCStart_V2);
}

extern "C" ULONG EventPipeWriteEventModuleDCStart_V2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int ManagedPdbAge,
    PCWSTR ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int NativePdbAge,
    PCWSTR NativePdbBuildPath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleDCStart_V2())
        return ERROR_SUCCESS;

    size_t size = 290;
    BYTE stackBuffer[290];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    if (!ManagedPdbBuildPath) { ManagedPdbBuildPath = W("NULL"); }
    if (!NativePdbBuildPath) { NativePdbBuildPath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ManagedPdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbBuildPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*NativePdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbBuildPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleDCStart_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleDCEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleDCEnd);
}

extern "C" ULONG EventPipeWriteEventModuleDCEnd(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleDCEnd())
        return ERROR_SUCCESS;

    size_t size = 152;
    BYTE stackBuffer[152];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleDCEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleDCEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleDCEnd_V1);
}

extern "C" ULONG EventPipeWriteEventModuleDCEnd_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleDCEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 154;
    BYTE stackBuffer[154];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleDCEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleDCEnd_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleDCEnd_V2);
}

extern "C" ULONG EventPipeWriteEventModuleDCEnd_V2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int ManagedPdbAge,
    PCWSTR ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int NativePdbAge,
    PCWSTR NativePdbBuildPath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleDCEnd_V2())
        return ERROR_SUCCESS;

    size_t size = 290;
    BYTE stackBuffer[290];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    if (!ManagedPdbBuildPath) { ManagedPdbBuildPath = W("NULL"); }
    if (!NativePdbBuildPath) { NativePdbBuildPath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ManagedPdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbBuildPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*NativePdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbBuildPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleDCEnd_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyDCStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyDCStart);
}

extern "C" ULONG EventPipeWriteEventAssemblyDCStart(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyDCStart())
        return ERROR_SUCCESS;

    size_t size = 84;
    BYTE stackBuffer[84];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyDCStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyDCStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyDCStart_V1);
}

extern "C" ULONG EventPipeWriteEventAssemblyDCStart_V1(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned __int64 BindingID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyDCStart_V1())
        return ERROR_SUCCESS;

    size_t size = 94;
    BYTE stackBuffer[94];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BindingID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyDCStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyDCEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyDCEnd);
}

extern "C" ULONG EventPipeWriteEventAssemblyDCEnd(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyDCEnd())
        return ERROR_SUCCESS;

    size_t size = 84;
    BYTE stackBuffer[84];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyDCEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyDCEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyDCEnd_V1);
}

extern "C" ULONG EventPipeWriteEventAssemblyDCEnd_V1(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned __int64 BindingID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyDCEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 94;
    BYTE stackBuffer[94];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BindingID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyDCEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAppDomainDCStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAppDomainDCStart);
}

extern "C" ULONG EventPipeWriteEventAppDomainDCStart(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAppDomainDCStart())
        return ERROR_SUCCESS;

    size_t size = 76;
    BYTE stackBuffer[76];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AppDomainName) { AppDomainName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAppDomainDCStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAppDomainDCStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAppDomainDCStart_V1);
}

extern "C" ULONG EventPipeWriteEventAppDomainDCStart_V1(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    const unsigned int AppDomainIndex,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAppDomainDCStart_V1())
        return ERROR_SUCCESS;

    size_t size = 82;
    BYTE stackBuffer[82];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AppDomainName) { AppDomainName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainIndex, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAppDomainDCStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAppDomainDCEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAppDomainDCEnd);
}

extern "C" ULONG EventPipeWriteEventAppDomainDCEnd(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAppDomainDCEnd())
        return ERROR_SUCCESS;

    size_t size = 76;
    BYTE stackBuffer[76];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AppDomainName) { AppDomainName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAppDomainDCEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAppDomainDCEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAppDomainDCEnd_V1);
}

extern "C" ULONG EventPipeWriteEventAppDomainDCEnd_V1(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    const unsigned int AppDomainIndex,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAppDomainDCEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 82;
    BYTE stackBuffer[82];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AppDomainName) { AppDomainName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainIndex, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAppDomainDCEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadDC(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadDC);
}

extern "C" ULONG EventPipeWriteEventThreadDC(
    const unsigned __int64 ManagedThreadID,
    const unsigned __int64 AppDomainID,
    const unsigned int Flags,
    const unsigned int ManagedThreadIndex,
    const unsigned int OSThreadID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadDC())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ManagedThreadID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Flags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedThreadIndex, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(OSThreadID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadDC, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleRangeDCStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleRangeDCStart);
}

extern "C" ULONG EventPipeWriteEventModuleRangeDCStart(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned int RangeBegin,
    const unsigned int RangeSize,
    const unsigned char RangeType,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleRangeDCStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeBegin, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeType, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleRangeDCStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleRangeDCEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleRangeDCEnd);
}

extern "C" ULONG EventPipeWriteEventModuleRangeDCEnd(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned int RangeBegin,
    const unsigned int RangeSize,
    const unsigned char RangeType,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleRangeDCEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeBegin, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeType, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleRangeDCEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledRuntimeInformationDCStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventRuntimeInformationDCStart);
}

extern "C" ULONG EventPipeWriteEventRuntimeInformationDCStart(
    const unsigned short ClrInstanceID,
    const unsigned short Sku,
    const unsigned short BclMajorVersion,
    const unsigned short BclMinorVersion,
    const unsigned short BclBuildNumber,
    const unsigned short BclQfeNumber,
    const unsigned short VMMajorVersion,
    const unsigned short VMMinorVersion,
    const unsigned short VMBuildNumber,
    const unsigned short VMQfeNumber,
    const unsigned int StartupFlags,
    const unsigned char StartupMode,
    PCWSTR CommandLine,
    const GUID* ComObjectGuid,
    PCWSTR RuntimeDllPath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledRuntimeInformationDCStart())
        return ERROR_SUCCESS;

    size_t size = 153;
    BYTE stackBuffer[153];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!CommandLine) { CommandLine = W("NULL"); }
    if (!RuntimeDllPath) { RuntimeDllPath = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Sku, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclMajorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclMinorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclBuildNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclQfeNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMMajorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMMinorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMBuildNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMQfeNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StartupFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StartupMode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CommandLine, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ComObjectGuid, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RuntimeDllPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventRuntimeInformationDCStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTieredCompilationSettingsDCStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTieredCompilationSettingsDCStart);
}

extern "C" ULONG EventPipeWriteEventTieredCompilationSettingsDCStart(
    const unsigned short ClrInstanceID,
    const unsigned int Flags,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTieredCompilationSettingsDCStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Flags, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTieredCompilationSettingsDCStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExecutionCheckpointDCEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExecutionCheckpointDCEnd);
}

extern "C" ULONG EventPipeWriteEventExecutionCheckpointDCEnd(
    const unsigned short ClrInstanceID,
    PCWSTR Name,
    const __int64 Timestamp,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExecutionCheckpointDCEnd())
        return ERROR_SUCCESS;

    size_t size = 74;
    BYTE stackBuffer[74];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Name) { Name = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Name, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Timestamp, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventExecutionCheckpointDCEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

extern "C" void InitDotNETRuntimeRundown(void);

extern "C" void InitDotNETRuntimeRundown(void)
{
    EventPipeProviderDotNETRuntimeRundown = EventPipeAdapter::CreateProvider(SL(DotNETRuntimeRundownName), reinterpret_cast<EventPipeCallback>(EventPipeEtwCallbackDotNETRuntimeRundown));
    EventPipeEventCLRStackWalkDCStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,0,1073741824,0,EP_EVENT_LEVEL_LOGALWAYS,true);
    EventPipeEventGCSettingsRundown = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,10,0,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,141,48,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,141,48,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCStart_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,141,48,2,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,142,48,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,142,48,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCEnd_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,142,48,2,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCStartVerbose = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,143,48,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCStartVerbose_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,143,48,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCStartVerbose_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,143,48,2,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCEndVerbose = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,144,48,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCEndVerbose_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,144,48,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCEndVerbose_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,144,48,2,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDCStartComplete = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,145,131128,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDCStartComplete_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,145,131128,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDCEndComplete = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,146,131128,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDCEndComplete_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,146,131128,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDCStartInit = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,147,131128,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDCStartInit_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,147,131128,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDCEndInit = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,148,131128,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDCEndInit_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,148,131128,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCStartILToNativeMap = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,149,131072,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventMethodDCStartILToNativeMap_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,149,131072,1,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventMethodDCEndILToNativeMap = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,150,131072,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventMethodDCEndILToNativeMap_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,150,131072,1,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventDomainModuleDCStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,151,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDomainModuleDCStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,151,8,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDomainModuleDCEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,152,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDomainModuleDCEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,152,8,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleDCStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,153,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleDCStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,153,536870920,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleDCStart_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,153,536870920,2,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleDCEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,154,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleDCEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,154,536870920,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleDCEnd_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,154,536870920,2,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAssemblyDCStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,155,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAssemblyDCStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,155,8,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAssemblyDCEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,156,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAssemblyDCEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,156,8,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAppDomainDCStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,157,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAppDomainDCStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,157,8,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAppDomainDCEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,158,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAppDomainDCEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,158,8,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventThreadDC = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,159,67584,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleRangeDCStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,160,536870912,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventModuleRangeDCEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,161,536870912,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventRuntimeInformationDCStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,187,0,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventTieredCompilationSettingsDCStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,280,68719476736,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventExecutionCheckpointDCEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeRundown,300,0,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
}
