/* Generated by wayland-scanner 1.23.0 */

#ifndef FAKE_INPUT_SERVER_PROTOCOL_H
#define FAKE_INPUT_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_fake_input The fake_input protocol
 * @section page_ifaces_fake_input Interfaces
 * - @subpage page_iface_org_kde_kwin_fake_input - Fake input manager
 * @section page_copyright_fake_input Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2015 Martin Gräßlin
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_fake_input;

#ifndef ORG_KDE_KWIN_FAKE_INPUT_INTERFACE
#define ORG_KDE_KWIN_FAKE_INPUT_INTERFACE
/**
 * @page page_iface_org_kde_kwin_fake_input org_kde_kwin_fake_input
 * @section page_iface_org_kde_kwin_fake_input_desc Description
 *
 * This interface allows other processes to provide fake input events.
 * Purpose is on the one hand side to provide testing facilities like XTest on X11.
 * But also to support use case like kdeconnect's mouse pad interface.
 *
 * A compositor should not trust the input received from this interface.
 * Clients should not expect that the compositor honors the requests from this
 * interface.
 * @section page_iface_org_kde_kwin_fake_input_api API
 * See @ref iface_org_kde_kwin_fake_input.
 */
/**
 * @defgroup iface_org_kde_kwin_fake_input The org_kde_kwin_fake_input interface
 *
 * This interface allows other processes to provide fake input events.
 * Purpose is on the one hand side to provide testing facilities like XTest on X11.
 * But also to support use case like kdeconnect's mouse pad interface.
 *
 * A compositor should not trust the input received from this interface.
 * Clients should not expect that the compositor honors the requests from this
 * interface.
 */
extern const struct wl_interface org_kde_kwin_fake_input_interface;
#endif

/**
 * @ingroup iface_org_kde_kwin_fake_input
 * @struct org_kde_kwin_fake_input_interface
 */
struct org_kde_kwin_fake_input_interface {
	/**
	 * Information why the client wants to use the interface
	 *
	 * A client should use this request to tell the compositor why it
	 * wants to use this interface. The compositor might use the
	 * information to decide whether it wants to grant the request. The
	 * data might also be passed to the user to decide whether the
	 * application should get granted access to this very privileged
	 * interface.
	 * @param application user visible name of the application
	 * @param reason reason why the application wants to use this interface
	 */
	void (*authenticate)(struct wl_client *client,
			     struct wl_resource *resource,
			     const char *application,
			     const char *reason);
	/**
	 */
	void (*pointer_motion)(struct wl_client *client,
			       struct wl_resource *resource,
			       wl_fixed_t delta_x,
			       wl_fixed_t delta_y);
	/**
	 */
	void (*button)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t button,
		       uint32_t state);
	/**
	 */
	void (*axis)(struct wl_client *client,
		     struct wl_resource *resource,
		     uint32_t axis,
		     wl_fixed_t value);
	/**
	 */
	void (*axis_for_capture)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t axis,
				 wl_fixed_t value);
	/**
	 * touch down event
	 *
	 * A client should use this request to send touch down event at
	 * specific coordinates.
	 * @param id unique id for touch down event
	 * @param x x coordinate for touch down event
	 * @param y y coordinate for touch down event
	 * @since 2
	 */
	void (*touch_down)(struct wl_client *client,
			   struct wl_resource *resource,
			   uint32_t id,
			   wl_fixed_t x,
			   wl_fixed_t y);
	/**
	 * touch motion event
	 *
	 * A client should use this request to send touch motion to
	 * specific position.
	 * @param id unique id for touch motion event
	 * @param x x coordinate for touch motion event
	 * @param y y coordinate for touch motion event
	 * @since 2
	 */
	void (*touch_motion)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t id,
			     wl_fixed_t x,
			     wl_fixed_t y);
	/**
	 * touch up event
	 *
	 * A client should use this request to send touch up event.
	 * @param id unique id for touch up event
	 * @since 2
	 */
	void (*touch_up)(struct wl_client *client,
			 struct wl_resource *resource,
			 uint32_t id);
	/**
	 * touch cancel event
	 *
	 * A client should use this request to cancel the current touch
	 * event.
	 * @since 2
	 */
	void (*touch_cancel)(struct wl_client *client,
			     struct wl_resource *resource);
	/**
	 * touch frame event
	 *
	 * A client should use this request to send touch frame event.
	 * @since 2
	 */
	void (*touch_frame)(struct wl_client *client,
			    struct wl_resource *resource);
	/**
	 * @since 3
	 */
	void (*pointer_motion_absolute)(struct wl_client *client,
					struct wl_resource *resource,
					wl_fixed_t x,
					wl_fixed_t y);
	/**
	 * @since 4
	 */
	void (*keyboard_key)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t button,
			     uint32_t state);
};


/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_AUTHENTICATE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_POINTER_MOTION_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_BUTTON_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_AXIS_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_AXIS_FOR_CAPTURE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_TOUCH_DOWN_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_TOUCH_MOTION_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_TOUCH_UP_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_TOUCH_CANCEL_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_TOUCH_FRAME_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_POINTER_MOTION_ABSOLUTE_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_kwin_fake_input
 */
#define ORG_KDE_KWIN_FAKE_INPUT_KEYBOARD_KEY_SINCE_VERSION 4

#ifdef  __cplusplus
}
#endif

#endif
