#ifndef _ECTOR_RENDERER_SHAPE_EO_H_
#define _ECTOR_RENDERER_SHAPE_EO_H_

#ifndef _ECTOR_RENDERER_SHAPE_EO_CLASS_TYPE
#define _ECTOR_RENDERER_SHAPE_EO_CLASS_TYPE

typedef Eo Ector_Renderer_Shape;

#endif

#ifndef _ECTOR_RENDERER_SHAPE_EO_TYPES
#define _ECTOR_RENDERER_SHAPE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Ector shape renderer mixin
 *
 * @ingroup Ector_Renderer_Shape
 */
#define ECTOR_RENDERER_SHAPE_MIXIN ector_renderer_shape_mixin_get()

ECTOR_API ECTOR_API_WEAK const Efl_Class *ector_renderer_shape_mixin_get(void) EINA_CONST;

/**
 * @brief Fill property
 *
 * @param[in] obj The object.
 * @param[in] r Ector fill renderer
 *
 * @ingroup Ector_Renderer_Shape
 */
ECTOR_API ECTOR_API_WEAK void ector_renderer_shape_fill_set(Eo *obj, const Ector_Renderer *r);

/**
 * @brief Fill property
 *
 * @param[in] obj The object.
 *
 * @return Ector fill renderer
 *
 * @ingroup Ector_Renderer_Shape
 */
ECTOR_API ECTOR_API_WEAK const Ector_Renderer *ector_renderer_shape_fill_get(const Eo *obj);

/**
 * @brief Stroke fill property
 *
 * @param[in] obj The object.
 * @param[in] r Ector stroke fill renderer
 *
 * @ingroup Ector_Renderer_Shape
 */
ECTOR_API ECTOR_API_WEAK void ector_renderer_shape_stroke_fill_set(Eo *obj, const Ector_Renderer *r);

/**
 * @brief Stroke fill property
 *
 * @param[in] obj The object.
 *
 * @return Ector stroke fill renderer
 *
 * @ingroup Ector_Renderer_Shape
 */
ECTOR_API ECTOR_API_WEAK const Ector_Renderer *ector_renderer_shape_stroke_fill_get(const Eo *obj);

/**
 * @brief Stroke marker property
 *
 * @param[in] obj The object.
 * @param[in] r Ector stroke marker renderer
 *
 * @ingroup Ector_Renderer_Shape
 */
ECTOR_API ECTOR_API_WEAK void ector_renderer_shape_stroke_marker_set(Eo *obj, const Ector_Renderer *r);

/**
 * @brief Stroke marker property
 *
 * @param[in] obj The object.
 *
 * @return Ector stroke marker renderer
 *
 * @ingroup Ector_Renderer_Shape
 */
ECTOR_API ECTOR_API_WEAK const Ector_Renderer *ector_renderer_shape_stroke_marker_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
