#ifndef _EFL_DATETIME_MANAGER_EO_H_
#define _EFL_DATETIME_MANAGER_EO_H_

#ifndef _EFL_DATETIME_MANAGER_EO_CLASS_TYPE
#define _EFL_DATETIME_MANAGER_EO_CLASS_TYPE

typedef Eo Efl_Datetime_Manager;

#endif

#ifndef _EFL_DATETIME_MANAGER_EO_TYPES
#define _EFL_DATETIME_MANAGER_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl datetime manager class for Datepicker and Timepicker
 *
 * @ingroup Efl_Datetime_Manager
 */
#define EFL_DATETIME_MANAGER_CLASS efl_datetime_manager_class_get()

EAPI EAPI_WEAK const Efl_Class *efl_datetime_manager_class_get(void) EINA_CONST;

/**
 * @brief The value of a date, time for Datepicker or Timepicker.
 *
 * The value for Datepicker contains year, month, and day. (tm_year, tm_mon,
 * and tm_mday in Efl_Time) The value for Timepicker contains hour, and min.
 * (tm_hour, and tm_min in Efl_Time)
 *
 * @param[in] obj The object.
 * @param[in] newtime Time structure containing date or time value.
 *
 * @ingroup Efl_Datetime_Manager
 */
EAPI EAPI_WEAK void efl_datetime_manager_value_set(Eo *obj, Efl_Time newtime);

/**
 * @brief The value of a date, time for Datepicker or Timepicker.
 *
 * The value for Datepicker contains year, month, and day. (tm_year, tm_mon,
 * and tm_mday in Efl_Time) The value for Timepicker contains hour, and min.
 * (tm_hour, and tm_min in Efl_Time)
 *
 * @param[in] obj The object.
 *
 * @return Time structure containing date or time value.
 *
 * @ingroup Efl_Datetime_Manager
 */
EAPI EAPI_WEAK Efl_Time efl_datetime_manager_value_get(const Eo *obj);

/**
 * @brief The format of date or time.
 *
 * Default format is taken as per the system locale settings.
 *
 * @param[in] obj The object.
 * @param[in] fmt The format string
 *
 * @ingroup Efl_Datetime_Manager
 */
EAPI EAPI_WEAK void efl_datetime_manager_format_set(Eo *obj, const char *fmt);

/**
 * @brief The format of date or time.
 *
 * Default format is taken as per the system locale settings.
 *
 * @param[in] obj The object.
 *
 * @return The format string
 *
 * @ingroup Efl_Datetime_Manager
 */
EAPI EAPI_WEAK const char *efl_datetime_manager_format_get(const Eo *obj);

/**
 * @brief Get the string that matches with the format.
 *
 * @param[in] obj The object.
 * @param[in] fmt The format string
 *
 * @return The string that matches with the format
 *
 * @ingroup Efl_Datetime_Manager
 */
EAPI EAPI_WEAK const char *efl_datetime_manager_string_get(const Eo *obj, const char *fmt);
#endif /* EFL_BETA_API_SUPPORT */

#endif
