// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Describes one or more secondary networks.
func (c *Client) DescribeSecondaryNetworks(ctx context.Context, params *DescribeSecondaryNetworksInput, optFns ...func(*Options)) (*DescribeSecondaryNetworksOutput, error) {
	if params == nil {
		params = &DescribeSecondaryNetworksInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSecondaryNetworks", params, optFns, c.addOperationDescribeSecondaryNetworksMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSecondaryNetworksOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSecondaryNetworksInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The filters. The following are the possible values:
	//
	//   - ipv4-cidr-block-association.association-id - The association ID for an IPv4
	//   CIDR block associated with the secondary network.
	//
	//   - ipv4-cidr-block-association.cidr-block - An IPv4 CIDR block associated with
	//   the secondary network.
	//
	//   - ipv4-cidr-block-association.state - The state of an IPv4 CIDR block
	//   associated with the secondary network.
	//
	//   - owner-id - The ID of the Amazon Web Services account that owns the secondary
	//   network.
	//
	//   - secondary-network-id - The ID of the secondary network.
	//
	//   - secondary-network-arn - The ARN of the secondary network.
	//
	//   - state - The state of the secondary network ( create-in-progress |
	//   create-complete | create-failed | delete-in-progress | delete-complete |
	//   delete-failed ).
	//
	//   - tag : - The key/value combination of a tag assigned to the resource. Use the
	//   tag key in the filter name and the tag value as the filter value. For example,
	//   to find all resources that have a tag with the key Owner and the value TeamA ,
	//   specify tag:Owner for the filter name and TeamA for the filter value.
	//
	//   - tag-key - The key of a tag assigned to the resource. Use this filter to find
	//   all resources assigned a tag with a specific key, regardless of the tag value.
	//
	//   - type - The type of the secondary network ( rdma ).
	Filters []types.Filter

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The IDs of the secondary networks.
	SecondaryNetworkIds []string

	noSmithyDocumentSerde
}

type DescribeSecondaryNetworksOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Information about the secondary networks.
	SecondaryNetworks []types.SecondaryNetwork

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSecondaryNetworksMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeSecondaryNetworks{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeSecondaryNetworks{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeSecondaryNetworks"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSecondaryNetworks(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// SecondaryNetworkCreateCompleteWaiterOptions are waiter options for
// SecondaryNetworkCreateCompleteWaiter
type SecondaryNetworkCreateCompleteWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// SecondaryNetworkCreateCompleteWaiter will use default minimum delay of 10
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, SecondaryNetworkCreateCompleteWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeSecondaryNetworksInput, *DescribeSecondaryNetworksOutput, error) (bool, error)
}

// SecondaryNetworkCreateCompleteWaiter defines the waiters for
// SecondaryNetworkCreateComplete
type SecondaryNetworkCreateCompleteWaiter struct {
	client DescribeSecondaryNetworksAPIClient

	options SecondaryNetworkCreateCompleteWaiterOptions
}

// NewSecondaryNetworkCreateCompleteWaiter constructs a
// SecondaryNetworkCreateCompleteWaiter.
func NewSecondaryNetworkCreateCompleteWaiter(client DescribeSecondaryNetworksAPIClient, optFns ...func(*SecondaryNetworkCreateCompleteWaiterOptions)) *SecondaryNetworkCreateCompleteWaiter {
	options := SecondaryNetworkCreateCompleteWaiterOptions{}
	options.MinDelay = 10 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = secondaryNetworkCreateCompleteStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &SecondaryNetworkCreateCompleteWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for SecondaryNetworkCreateComplete waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *SecondaryNetworkCreateCompleteWaiter) Wait(ctx context.Context, params *DescribeSecondaryNetworksInput, maxWaitDur time.Duration, optFns ...func(*SecondaryNetworkCreateCompleteWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for SecondaryNetworkCreateComplete
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *SecondaryNetworkCreateCompleteWaiter) WaitForOutput(ctx context.Context, params *DescribeSecondaryNetworksInput, maxWaitDur time.Duration, optFns ...func(*SecondaryNetworkCreateCompleteWaiterOptions)) (*DescribeSecondaryNetworksOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeSecondaryNetworks(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for SecondaryNetworkCreateComplete waiter")
}

func secondaryNetworkCreateCompleteStateRetryable(ctx context.Context, input *DescribeSecondaryNetworksInput, output *DescribeSecondaryNetworksOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.SecondaryNetworks
		var v2 []types.SecondaryNetworkState
		for _, v := range v1 {
			v3 := v.State
			v2 = append(v2, v3)
		}
		expectedValue := "create-complete"
		match := len(v2) > 0
		for _, v := range v2 {
			if string(v) != expectedValue {
				match = false
				break
			}
		}

		if match {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.SecondaryNetworks
		var v2 []types.SecondaryNetworkState
		for _, v := range v1 {
			v3 := v.State
			v2 = append(v2, v3)
		}
		expectedValue := "create-failed"
		var match bool
		for _, v := range v2 {
			if string(v) == expectedValue {
				match = true
				break
			}
		}

		if match {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "InvalidSecondaryNetworkId.NotFound" == apiErr.ErrorCode() {
			return true, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// SecondaryNetworkDeleteCompleteWaiterOptions are waiter options for
// SecondaryNetworkDeleteCompleteWaiter
type SecondaryNetworkDeleteCompleteWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// SecondaryNetworkDeleteCompleteWaiter will use default minimum delay of 10
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, SecondaryNetworkDeleteCompleteWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeSecondaryNetworksInput, *DescribeSecondaryNetworksOutput, error) (bool, error)
}

// SecondaryNetworkDeleteCompleteWaiter defines the waiters for
// SecondaryNetworkDeleteComplete
type SecondaryNetworkDeleteCompleteWaiter struct {
	client DescribeSecondaryNetworksAPIClient

	options SecondaryNetworkDeleteCompleteWaiterOptions
}

// NewSecondaryNetworkDeleteCompleteWaiter constructs a
// SecondaryNetworkDeleteCompleteWaiter.
func NewSecondaryNetworkDeleteCompleteWaiter(client DescribeSecondaryNetworksAPIClient, optFns ...func(*SecondaryNetworkDeleteCompleteWaiterOptions)) *SecondaryNetworkDeleteCompleteWaiter {
	options := SecondaryNetworkDeleteCompleteWaiterOptions{}
	options.MinDelay = 10 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = secondaryNetworkDeleteCompleteStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &SecondaryNetworkDeleteCompleteWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for SecondaryNetworkDeleteComplete waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *SecondaryNetworkDeleteCompleteWaiter) Wait(ctx context.Context, params *DescribeSecondaryNetworksInput, maxWaitDur time.Duration, optFns ...func(*SecondaryNetworkDeleteCompleteWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for SecondaryNetworkDeleteComplete
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *SecondaryNetworkDeleteCompleteWaiter) WaitForOutput(ctx context.Context, params *DescribeSecondaryNetworksInput, maxWaitDur time.Duration, optFns ...func(*SecondaryNetworkDeleteCompleteWaiterOptions)) (*DescribeSecondaryNetworksOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeSecondaryNetworks(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for SecondaryNetworkDeleteComplete waiter")
}

func secondaryNetworkDeleteCompleteStateRetryable(ctx context.Context, input *DescribeSecondaryNetworksInput, output *DescribeSecondaryNetworksOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.SecondaryNetworks
		var v2 []types.SecondaryNetworkState
		for _, v := range v1 {
			v3 := v.State
			v2 = append(v2, v3)
		}
		expectedValue := "delete-complete"
		match := len(v2) > 0
		for _, v := range v2 {
			if string(v) != expectedValue {
				match = false
				break
			}
		}

		if match {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.SecondaryNetworks
		var v2 []types.SecondaryNetworkState
		for _, v := range v1 {
			v3 := v.State
			v2 = append(v2, v3)
		}
		expectedValue := "delete-failed"
		var match bool
		for _, v := range v2 {
			if string(v) == expectedValue {
				match = true
				break
			}
		}

		if match {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// DescribeSecondaryNetworksPaginatorOptions is the paginator options for
// DescribeSecondaryNetworks
type DescribeSecondaryNetworksPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeSecondaryNetworksPaginator is a paginator for DescribeSecondaryNetworks
type DescribeSecondaryNetworksPaginator struct {
	options   DescribeSecondaryNetworksPaginatorOptions
	client    DescribeSecondaryNetworksAPIClient
	params    *DescribeSecondaryNetworksInput
	nextToken *string
	firstPage bool
}

// NewDescribeSecondaryNetworksPaginator returns a new
// DescribeSecondaryNetworksPaginator
func NewDescribeSecondaryNetworksPaginator(client DescribeSecondaryNetworksAPIClient, params *DescribeSecondaryNetworksInput, optFns ...func(*DescribeSecondaryNetworksPaginatorOptions)) *DescribeSecondaryNetworksPaginator {
	if params == nil {
		params = &DescribeSecondaryNetworksInput{}
	}

	options := DescribeSecondaryNetworksPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeSecondaryNetworksPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeSecondaryNetworksPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeSecondaryNetworks page.
func (p *DescribeSecondaryNetworksPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeSecondaryNetworksOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeSecondaryNetworks(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeSecondaryNetworksAPIClient is a client that implements the
// DescribeSecondaryNetworks operation.
type DescribeSecondaryNetworksAPIClient interface {
	DescribeSecondaryNetworks(context.Context, *DescribeSecondaryNetworksInput, ...func(*Options)) (*DescribeSecondaryNetworksOutput, error)
}

var _ DescribeSecondaryNetworksAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeSecondaryNetworks(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeSecondaryNetworks",
	}
}
