/* transforms-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from transforms-view.vala, do not modify */

/* This file is part of Elastic. License: GPL-3.0+.*/

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gsk/gsk.h>
#include <graphene-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ELASTIC_TYPE_TRANSFORMS_VIEW (elastic_transforms_view_get_type ())
#define ELASTIC_TRANSFORMS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_TRANSFORMS_VIEW, ElasticTransformsView))
#define ELASTIC_TRANSFORMS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_TRANSFORMS_VIEW, ElasticTransformsViewClass))
#define ELASTIC_IS_TRANSFORMS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_TRANSFORMS_VIEW))
#define ELASTIC_IS_TRANSFORMS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_TRANSFORMS_VIEW))
#define ELASTIC_TRANSFORMS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_TRANSFORMS_VIEW, ElasticTransformsViewClass))

typedef struct _ElasticTransformsView ElasticTransformsView;
typedef struct _ElasticTransformsViewClass ElasticTransformsViewClass;
typedef struct _ElasticTransformsViewPrivate ElasticTransformsViewPrivate;

#define ELASTIC_TYPE_SPRING_PARAMS (elastic_spring_params_get_type ())
#define ELASTIC_SPRING_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParams))
#define ELASTIC_SPRING_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParamsClass))
#define ELASTIC_IS_SPRING_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_SPRING_PARAMS))
#define ELASTIC_IS_SPRING_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_SPRING_PARAMS))
#define ELASTIC_SPRING_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParamsClass))

typedef struct _ElasticSpringParams ElasticSpringParams;
typedef struct _ElasticSpringParamsClass ElasticSpringParamsClass;

#define ELASTIC_TYPE_TRANSFORM_BIN (elastic_transform_bin_get_type ())
#define ELASTIC_TRANSFORM_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_TRANSFORM_BIN, ElasticTransformBin))
#define ELASTIC_TRANSFORM_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_TRANSFORM_BIN, ElasticTransformBinClass))
#define ELASTIC_IS_TRANSFORM_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_TRANSFORM_BIN))
#define ELASTIC_IS_TRANSFORM_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_TRANSFORM_BIN))
#define ELASTIC_TRANSFORM_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_TRANSFORM_BIN, ElasticTransformBinClass))

typedef struct _ElasticTransformBin ElasticTransformBin;
typedef struct _ElasticTransformBinClass ElasticTransformBinClass;
enum  {
	ELASTIC_TRANSFORMS_VIEW_0_PROPERTY,
	ELASTIC_TRANSFORMS_VIEW_SPRING_PROPERTY,
	ELASTIC_TRANSFORMS_VIEW_COMPACT_PROPERTY,
	ELASTIC_TRANSFORMS_VIEW_NUM_PROPERTIES
};
static GParamSpec* elastic_transforms_view_properties[ELASTIC_TRANSFORMS_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gsk_transform_unref0(var) ((var == NULL) ? NULL : (var = (gsk_transform_unref (var), NULL)))

struct _ElasticTransformsView {
	AdwBin parent_instance;
	ElasticTransformsViewPrivate * priv;
};

struct _ElasticTransformsViewClass {
	AdwBinClass parent_class;
};

struct _ElasticTransformsViewPrivate {
	ElasticSpringParams* _spring;
	gboolean _compact;
	AdwMultiLayoutView* multi_layout_view;
	ElasticTransformBin* scale_bin;
	ElasticTransformBin* htranslate_bin;
	ElasticTransformBin* rotate_bin;
	ElasticTransformBin* vtranslate_bin;
	AdwSpringAnimation* animation;
	gboolean invert;
};

static gint ElasticTransformsView_private_offset;
static gpointer elastic_transforms_view_parent_class = NULL;

VALA_EXTERN GType elastic_transforms_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticTransformsView, g_object_unref)
VALA_EXTERN GType elastic_spring_params_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticSpringParams, g_object_unref)
VALA_EXTERN GType elastic_transform_bin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticTransformBin, g_object_unref)
VALA_EXTERN void elastic_transforms_view_run_animation (ElasticTransformsView* self);
VALA_EXTERN ElasticSpringParams* elastic_transforms_view_get_spring (ElasticTransformsView* self);
VALA_EXTERN void elastic_spring_params_apply (ElasticSpringParams* self,
                                  AdwSpringAnimation* animation);
static void elastic_transforms_view_set_value (ElasticTransformsView* self,
                                        gdouble value);
VALA_EXTERN void elastic_transform_bin_set_transform (ElasticTransformBin* self,
                                          GskTransform* value);
VALA_EXTERN void elastic_transforms_view_reset (ElasticTransformsView* self);
VALA_EXTERN ElasticTransformsView* elastic_transforms_view_new (void);
VALA_EXTERN ElasticTransformsView* elastic_transforms_view_construct (GType object_type);
VALA_EXTERN void elastic_transforms_view_set_spring (ElasticTransformsView* self,
                                         ElasticSpringParams* value);
static void _elastic_transforms_view_reset_elastic_spring_params_changed (ElasticSpringParams* _sender,
                                                                   gpointer self);
VALA_EXTERN gboolean elastic_transforms_view_get_compact (ElasticTransformsView* self);
VALA_EXTERN void elastic_transforms_view_set_compact (ElasticTransformsView* self,
                                          gboolean value);
static GObject * elastic_transforms_view_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _elastic_transforms_view_set_value_adw_animation_target_func (gdouble value,
                                                                   gpointer self);
static void elastic_transforms_view_finalize (GObject * obj);
static GType elastic_transforms_view_get_type_once (void);
static void _vala_elastic_transforms_view_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_elastic_transforms_view_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
elastic_transforms_view_get_instance_private (ElasticTransformsView* self)
{
	return G_STRUCT_MEMBER_P (self, ElasticTransformsView_private_offset);
}

void
elastic_transforms_view_run_animation (ElasticTransformsView* self)
{
	ElasticSpringParams* _tmp0_;
	ElasticSpringParams* _tmp1_;
	AdwSpringAnimation* _tmp2_;
	AdwSpringAnimation* _tmp3_;
	AdwSpringAnimation* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gint _tmp7_ = 0;
	AdwSpringAnimation* _tmp8_;
	AdwSpringAnimation* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_transforms_view_get_spring (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->animation;
	elastic_spring_params_apply (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->animation;
	_tmp4_ = self->priv->animation;
	_tmp5_ = adw_animation_get_value ((AdwAnimation*) _tmp4_);
	_tmp6_ = _tmp5_;
	adw_spring_animation_set_value_from (_tmp3_, _tmp6_);
	if (self->priv->invert) {
		_tmp7_ = 0;
	} else {
		_tmp7_ = 1;
	}
	_tmp8_ = self->priv->animation;
	adw_spring_animation_set_value_to (_tmp8_, (gdouble) _tmp7_);
	_tmp9_ = self->priv->animation;
	adw_animation_play ((AdwAnimation*) _tmp9_);
	self->priv->invert = !self->priv->invert;
}

static void
elastic_transforms_view_set_value (ElasticTransformsView* self,
                                   gdouble value)
{
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat s = 0.0F;
	gfloat r = 0.0F;
	ElasticTransformBin* _tmp0_;
	GskTransform* _tmp1_;
	graphene_point_t _tmp2_ = {0};
	GskTransform* _tmp3_;
	GskTransform* _tmp4_;
	ElasticTransformBin* _tmp5_;
	GskTransform* _tmp6_;
	graphene_point_t _tmp7_ = {0};
	GskTransform* _tmp8_;
	GskTransform* _tmp9_;
	ElasticTransformBin* _tmp10_;
	GskTransform* _tmp11_;
	GskTransform* _tmp12_;
	GskTransform* _tmp13_;
	ElasticTransformBin* _tmp14_;
	GskTransform* _tmp15_;
	GskTransform* _tmp16_;
	GskTransform* _tmp17_;
	g_return_if_fail (self != NULL);
	x = (gfloat) adw_lerp ((gdouble) -30, (gdouble) 30, value);
	y = (gfloat) adw_lerp ((gdouble) 30, (gdouble) -30, value);
	s = MAX ((gfloat) 0, (gfloat) adw_lerp ((gdouble) 3, (gdouble) 1, value));
	r = (gfloat) adw_lerp ((gdouble) 0, (gdouble) 90, value);
	_tmp0_ = self->priv->htranslate_bin;
	_tmp1_ = gsk_transform_new ();
	_tmp2_.x = x;
	_tmp2_.y = (gfloat) 0;
	_tmp3_ = gsk_transform_translate (_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	elastic_transform_bin_set_transform (_tmp0_, _tmp4_);
	_gsk_transform_unref0 (_tmp4_);
	_tmp5_ = self->priv->vtranslate_bin;
	_tmp6_ = gsk_transform_new ();
	_tmp7_.x = (gfloat) 0;
	_tmp7_.y = y;
	_tmp8_ = gsk_transform_translate (_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_;
	elastic_transform_bin_set_transform (_tmp5_, _tmp9_);
	_gsk_transform_unref0 (_tmp9_);
	_tmp10_ = self->priv->scale_bin;
	_tmp11_ = gsk_transform_new ();
	_tmp12_ = gsk_transform_scale (_tmp11_, s, s);
	_tmp13_ = _tmp12_;
	elastic_transform_bin_set_transform (_tmp10_, _tmp13_);
	_gsk_transform_unref0 (_tmp13_);
	_tmp14_ = self->priv->rotate_bin;
	_tmp15_ = gsk_transform_new ();
	_tmp16_ = gsk_transform_rotate (_tmp15_, r);
	_tmp17_ = _tmp16_;
	elastic_transform_bin_set_transform (_tmp14_, _tmp17_);
	_gsk_transform_unref0 (_tmp17_);
}

void
elastic_transforms_view_reset (ElasticTransformsView* self)
{
	gint _tmp0_ = 0;
	AdwSpringAnimation* _tmp1_;
	AdwSpringAnimation* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->invert) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp1_ = self->priv->animation;
	adw_spring_animation_set_value_from (_tmp1_, (gdouble) _tmp0_);
	_tmp2_ = self->priv->animation;
	adw_animation_reset ((AdwAnimation*) _tmp2_);
}

ElasticTransformsView*
elastic_transforms_view_construct (GType object_type)
{
	ElasticTransformsView * self = NULL;
	self = (ElasticTransformsView*) g_object_new (object_type, NULL);
	return self;
}

ElasticTransformsView*
elastic_transforms_view_new (void)
{
	return elastic_transforms_view_construct (ELASTIC_TYPE_TRANSFORMS_VIEW);
}

ElasticSpringParams*
elastic_transforms_view_get_spring (ElasticTransformsView* self)
{
	ElasticSpringParams* result;
	ElasticSpringParams* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_spring;
	result = _tmp0_;
	return result;
}

static void
_elastic_transforms_view_reset_elastic_spring_params_changed (ElasticSpringParams* _sender,
                                                              gpointer self)
{
	elastic_transforms_view_reset ((ElasticTransformsView*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
elastic_transforms_view_set_spring (ElasticTransformsView* self,
                                    ElasticSpringParams* value)
{
	ElasticSpringParams* _tmp0_;
	ElasticSpringParams* _tmp1_;
	ElasticSpringParams* _tmp2_;
	ElasticSpringParams* _tmp3_;
	ElasticSpringParams* _tmp7_;
	ElasticSpringParams* _tmp8_;
	ElasticSpringParams* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_transforms_view_get_spring (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	_tmp2_ = elastic_transforms_view_get_spring (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ElasticSpringParams* _tmp4_;
		ElasticSpringParams* _tmp5_;
		guint _tmp6_;
		_tmp4_ = elastic_transforms_view_get_spring (self);
		_tmp5_ = _tmp4_;
		g_signal_parse_name ("changed", ELASTIC_TYPE_SPRING_PARAMS, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _elastic_transforms_view_reset_elastic_spring_params_changed, self);
	}
	_tmp7_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_spring);
	self->priv->_spring = _tmp7_;
	_tmp8_ = elastic_transforms_view_get_spring (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ElasticSpringParams* _tmp10_;
		ElasticSpringParams* _tmp11_;
		_tmp10_ = elastic_transforms_view_get_spring (self);
		_tmp11_ = _tmp10_;
		g_signal_connect_object (_tmp11_, "changed", (GCallback) _elastic_transforms_view_reset_elastic_spring_params_changed, self, 0);
	}
	elastic_transforms_view_reset (self);
	g_object_notify_by_pspec ((GObject *) self, elastic_transforms_view_properties[ELASTIC_TRANSFORMS_VIEW_SPRING_PROPERTY]);
}

gboolean
elastic_transforms_view_get_compact (ElasticTransformsView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_compact;
	return result;
}

void
elastic_transforms_view_set_compact (ElasticTransformsView* self,
                                     gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	gboolean _tmp4_;
	AdwMultiLayoutView* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_transforms_view_get_compact (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	self->priv->_compact = value;
	_tmp3_ = elastic_transforms_view_get_compact (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp2_ = "narrow";
	} else {
		_tmp2_ = "wide";
	}
	_tmp5_ = self->priv->multi_layout_view;
	adw_multi_layout_view_set_layout_name (_tmp5_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, elastic_transforms_view_properties[ELASTIC_TRANSFORMS_VIEW_COMPACT_PROPERTY]);
}

static void
_elastic_transforms_view_set_value_adw_animation_target_func (gdouble value,
                                                              gpointer self)
{
	elastic_transforms_view_set_value ((ElasticTransformsView*) self, value);
}

static GObject *
elastic_transforms_view_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ElasticTransformsView * self;
	AdwSpringParams* _tmp0_;
	AdwCallbackAnimationTarget* _tmp1_;
	AdwSpringAnimation* _tmp2_;
	AdwSpringAnimation* _tmp3_;
	parent_class = G_OBJECT_CLASS (elastic_transforms_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ELASTIC_TYPE_TRANSFORMS_VIEW, ElasticTransformsView);
	_tmp0_ = adw_spring_params_new_full ((gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp1_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (_elastic_transforms_view_set_value_adw_animation_target_func, g_object_ref (self), g_object_unref);
	_tmp2_ = (AdwSpringAnimation*) adw_spring_animation_new ((GtkWidget*) self, (gdouble) 0, (gdouble) 1, _tmp0_, (AdwAnimationTarget*) _tmp1_);
	_g_object_unref0 (self->priv->animation);
	self->priv->animation = _tmp2_;
	_tmp3_ = self->priv->animation;
	adw_animation_set_follow_enable_animations_setting ((AdwAnimation*) _tmp3_, FALSE);
	elastic_transforms_view_set_value (self, (gdouble) 0);
	return obj;
}

static void
elastic_transforms_view_class_init (ElasticTransformsViewClass * klass,
                                    gpointer klass_data)
{
	elastic_transforms_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ElasticTransformsView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_elastic_transforms_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_elastic_transforms_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = elastic_transforms_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = elastic_transforms_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_TRANSFORMS_VIEW_SPRING_PROPERTY, elastic_transforms_view_properties[ELASTIC_TRANSFORMS_VIEW_SPRING_PROPERTY] = g_param_spec_object ("spring", "spring", "spring", ELASTIC_TYPE_SPRING_PARAMS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_TRANSFORMS_VIEW_COMPACT_PROPERTY, elastic_transforms_view_properties[ELASTIC_TRANSFORMS_VIEW_COMPACT_PROPERTY] = g_param_spec_boolean ("compact", "compact", "compact", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/app/drey/Elastic/transforms-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "multi_layout_view", FALSE, ElasticTransformsView_private_offset + G_STRUCT_OFFSET (ElasticTransformsViewPrivate, multi_layout_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scale_bin", FALSE, ElasticTransformsView_private_offset + G_STRUCT_OFFSET (ElasticTransformsViewPrivate, scale_bin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "htranslate_bin", FALSE, ElasticTransformsView_private_offset + G_STRUCT_OFFSET (ElasticTransformsViewPrivate, htranslate_bin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rotate_bin", FALSE, ElasticTransformsView_private_offset + G_STRUCT_OFFSET (ElasticTransformsViewPrivate, rotate_bin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "vtranslate_bin", FALSE, ElasticTransformsView_private_offset + G_STRUCT_OFFSET (ElasticTransformsViewPrivate, vtranslate_bin));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "transforms-view");
}

static void
elastic_transforms_view_instance_init (ElasticTransformsView * self,
                                       gpointer klass)
{
	self->priv = elastic_transforms_view_get_instance_private (self);
	g_type_ensure (ELASTIC_TYPE_TRANSFORM_BIN);
	g_type_ensure (ELASTIC_TYPE_TRANSFORM_BIN);
	g_type_ensure (ELASTIC_TYPE_TRANSFORM_BIN);
	g_type_ensure (ELASTIC_TYPE_TRANSFORM_BIN);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
elastic_transforms_view_finalize (GObject * obj)
{
	ElasticTransformsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ELASTIC_TYPE_TRANSFORMS_VIEW, ElasticTransformsView);
	_g_object_unref0 (self->priv->_spring);
	_g_object_unref0 (self->priv->animation);
	G_OBJECT_CLASS (elastic_transforms_view_parent_class)->finalize (obj);
}

static GType
elastic_transforms_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ElasticTransformsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) elastic_transforms_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ElasticTransformsView), 0, (GInstanceInitFunc) elastic_transforms_view_instance_init, NULL };
	GType elastic_transforms_view_type_id;
	elastic_transforms_view_type_id = g_type_register_static (adw_bin_get_type (), "ElasticTransformsView", &g_define_type_info, 0);
	ElasticTransformsView_private_offset = g_type_add_instance_private (elastic_transforms_view_type_id, sizeof (ElasticTransformsViewPrivate));
	return elastic_transforms_view_type_id;
}

GType
elastic_transforms_view_get_type (void)
{
	static volatile gsize elastic_transforms_view_type_id__once = 0;
	if (g_once_init_enter (&elastic_transforms_view_type_id__once)) {
		GType elastic_transforms_view_type_id;
		elastic_transforms_view_type_id = elastic_transforms_view_get_type_once ();
		g_once_init_leave (&elastic_transforms_view_type_id__once, elastic_transforms_view_type_id);
	}
	return elastic_transforms_view_type_id__once;
}

static void
_vala_elastic_transforms_view_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ElasticTransformsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ELASTIC_TYPE_TRANSFORMS_VIEW, ElasticTransformsView);
	switch (property_id) {
		case ELASTIC_TRANSFORMS_VIEW_SPRING_PROPERTY:
		g_value_set_object (value, elastic_transforms_view_get_spring (self));
		break;
		case ELASTIC_TRANSFORMS_VIEW_COMPACT_PROPERTY:
		g_value_set_boolean (value, elastic_transforms_view_get_compact (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_elastic_transforms_view_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ElasticTransformsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ELASTIC_TYPE_TRANSFORMS_VIEW, ElasticTransformsView);
	switch (property_id) {
		case ELASTIC_TRANSFORMS_VIEW_SPRING_PROPERTY:
		elastic_transforms_view_set_spring (self, g_value_get_object (value));
		break;
		case ELASTIC_TRANSFORMS_VIEW_COMPACT_PROPERTY:
		elastic_transforms_view_set_compact (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

