/* composite.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from composite.vala, do not modify */

/* libenchant: Composite dictionaries
 * Copyright (C) 2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
typedef struct _EnchantDictPrivate EnchantDictPrivate;

#define TYPE_ENCHANT_SESSION (enchant_session_get_type ())
#define ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_SESSION, EnchantSession))
#define ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_SESSION, EnchantSessionClass))
#define IS_ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_SESSION))
#define IS_ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_SESSION))
#define ENCHANT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_SESSION, EnchantSessionClass))

typedef struct _EnchantSession EnchantSession;
typedef struct _EnchantSessionClass EnchantSessionClass;
typedef gint (*DictCheck) (EnchantDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantDict* me);
typedef gint (*DictIsWordCharacter) (EnchantDict* me, guint32 uc_in, size_t n);

#define TYPE_ENCHANT_COMPOSITE_DICT (enchant_composite_dict_get_type ())
#define ENCHANT_COMPOSITE_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict))
#define ENCHANT_COMPOSITE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDictClass))
#define IS_ENCHANT_COMPOSITE_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_COMPOSITE_DICT))
#define IS_ENCHANT_COMPOSITE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_COMPOSITE_DICT))
#define ENCHANT_COMPOSITE_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDictClass))

typedef struct _EnchantCompositeDict EnchantCompositeDict;
typedef struct _EnchantCompositeDictClass EnchantCompositeDictClass;
typedef struct _EnchantCompositeDictPrivate EnchantCompositeDictPrivate;
typedef struct _EnchantBroker EnchantBroker;

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _enchant_dict_unref0(var) ((var == NULL) ? NULL : (var = (enchant_dict_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EnchantDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantDictPrivate * priv;
	void* user_data;
	EnchantSession* session;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantDict *self);
};

struct _EnchantCompositeDict {
	EnchantDict parent_instance;
	EnchantCompositeDictPrivate * priv;
	GSList* dict_list;
};

struct _EnchantCompositeDictClass {
	EnchantDictClass parent_class;
};

struct _EnchantCompositeDictPrivate {
	EnchantBroker* broker;
};

static gint EnchantCompositeDict_private_offset;
static gpointer enchant_composite_dict_parent_class = NULL;

VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
VALA_EXTERN gpointer enchant_session_ref (gpointer instance);
VALA_EXTERN void enchant_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_session (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_enchant_session (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_enchant_session (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_session (const GValue* value);
VALA_EXTERN GType enchant_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantSession, enchant_session_unref)
VALA_EXTERN GType enchant_composite_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantCompositeDict, enchant_dict_unref)
VALA_EXTERN void enchant_broker_free (EnchantBroker * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantBroker, enchant_broker_free)
VALA_EXTERN EnchantCompositeDict* enchant_composite_dict_new (EnchantBroker* broker,
                                                  GSList* dict_list,
                                                  const gchar* tag);
VALA_EXTERN EnchantCompositeDict* enchant_composite_dict_construct (GType object_type,
                                                        EnchantBroker* broker,
                                                        GSList* dict_list,
                                                        const gchar* tag);
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN EnchantDict* enchant_dict_new (EnchantProvider* provider,
                               const gchar* tag);
VALA_EXTERN EnchantDict* enchant_dict_construct (GType object_type,
                                     EnchantProvider* provider,
                                     const gchar* tag);
VALA_EXTERN gint composite_dict_check (EnchantDict* _self_,
                           const gchar* word_buf,
                           size_t len);
static gint _composite_dict_check_dict_check (EnchantDict* me,
                                       const gchar* word,
                                       size_t len);
VALA_EXTERN gchar** composite_dict_suggest (EnchantDict* me,
                                const gchar* word,
                                size_t len,
                                size_t* result_length1);
static gchar** _composite_dict_suggest_dict_suggest (EnchantDict* me,
                                              const gchar* word,
                                              size_t len,
                                              size_t* result_length1);
VALA_EXTERN void composite_dict_add_to_session (EnchantDict* me,
                                    const gchar* word,
                                    size_t len);
static void _composite_dict_add_to_session_dict_add_to_session (EnchantDict* me,
                                                         const gchar* word,
                                                         size_t len);
VALA_EXTERN void composite_dict_remove_from_session (EnchantDict* me,
                                         const gchar* word,
                                         size_t len);
static void _composite_dict_remove_from_session_dict_remove_from_session (EnchantDict* me,
                                                                   const gchar* word,
                                                                   size_t len);
static void enchant_composite_dict_finalize (EnchantDict * obj);
static GType enchant_composite_dict_get_type_once (void);
VALA_EXTERN gchar* buf_to_utf8_string (const gchar* str_buf,
                           gssize len);
VALA_EXTERN gint enchant_dict_check (EnchantDict* _self_,
                         const gchar* word_buf,
                         ssize_t len);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
VALA_EXTERN gchar** enchant_dict_suggest (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len,
                              size_t* result_length1);
VALA_EXTERN void enchant_dict_add_to_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len);
VALA_EXTERN void enchant_dict_remove_from_session (EnchantDict* self,
                                       const gchar* word_buf,
                                       ssize_t len);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
enchant_composite_dict_get_instance_private (EnchantCompositeDict* self)
{
	return G_STRUCT_MEMBER_P (self, EnchantCompositeDict_private_offset);
}

static gint
_composite_dict_check_dict_check (EnchantDict* me,
                                  const gchar* word,
                                  size_t len)
{
	gint result;
	result = composite_dict_check (me, word, len);
#line 38 "composite.vala"
	return result;
#line 274 "composite.c"
}

static gchar**
_composite_dict_suggest_dict_suggest (EnchantDict* me,
                                      const gchar* word,
                                      size_t len,
                                      size_t* result_length1)
{
	gchar** result;
	result = composite_dict_suggest (me, word, len, result_length1);
#line 39 "composite.vala"
	return result;
#line 287 "composite.c"
}

static void
_composite_dict_add_to_session_dict_add_to_session (EnchantDict* me,
                                                    const gchar* word,
                                                    size_t len)
{
#line 40 "composite.vala"
	composite_dict_add_to_session (me, word, len);
#line 297 "composite.c"
}

static void
_composite_dict_remove_from_session_dict_remove_from_session (EnchantDict* me,
                                                              const gchar* word,
                                                              size_t len)
{
#line 41 "composite.vala"
	composite_dict_remove_from_session (me, word, len);
#line 307 "composite.c"
}

EnchantCompositeDict*
enchant_composite_dict_construct (GType object_type,
                                  EnchantBroker* broker,
                                  GSList* dict_list,
                                  const gchar* tag)
{
	EnchantCompositeDict* self = NULL;
	GSList* _tmp0_;
#line 34 "composite.vala"
	g_return_val_if_fail (broker != NULL, NULL);
#line 34 "composite.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 35 "composite.vala"
	self = (EnchantCompositeDict*) enchant_dict_construct (object_type, NULL, tag);
#line 36 "composite.vala"
	self->priv->broker = broker;
#line 37 "composite.vala"
	_tmp0_ = dict_list;
#line 37 "composite.vala"
	dict_list = NULL;
#line 37 "composite.vala"
	(self->dict_list == NULL) ? NULL : (self->dict_list = (g_slist_free (self->dict_list), NULL));
#line 37 "composite.vala"
	self->dict_list = _tmp0_;
#line 38 "composite.vala"
	((EnchantDict*) self)->check_method = _composite_dict_check_dict_check;
#line 39 "composite.vala"
	((EnchantDict*) self)->suggest_method = _composite_dict_suggest_dict_suggest;
#line 40 "composite.vala"
	((EnchantDict*) self)->add_to_session_method = _composite_dict_add_to_session_dict_add_to_session;
#line 41 "composite.vala"
	((EnchantDict*) self)->remove_from_session_method = _composite_dict_remove_from_session_dict_remove_from_session;
#line 34 "composite.vala"
	(dict_list == NULL) ? NULL : (dict_list = (g_slist_free (dict_list), NULL));
#line 34 "composite.vala"
	return self;
#line 346 "composite.c"
}

EnchantCompositeDict*
enchant_composite_dict_new (EnchantBroker* broker,
                            GSList* dict_list,
                            const gchar* tag)
{
#line 34 "composite.vala"
	return enchant_composite_dict_construct (TYPE_ENCHANT_COMPOSITE_DICT, broker, dict_list, tag);
#line 356 "composite.c"
}

static void
enchant_composite_dict_class_init (EnchantCompositeDictClass * klass,
                                   gpointer klass_data)
{
#line 30 "composite.vala"
	enchant_composite_dict_parent_class = g_type_class_peek_parent (klass);
#line 30 "composite.vala"
	((EnchantDictClass *) klass)->finalize = enchant_composite_dict_finalize;
#line 30 "composite.vala"
	g_type_class_adjust_private_offset (klass, &EnchantCompositeDict_private_offset);
#line 369 "composite.c"
}

static void
enchant_composite_dict_instance_init (EnchantCompositeDict * self,
                                      gpointer klass)
{
#line 30 "composite.vala"
	self->priv = enchant_composite_dict_get_instance_private (self);
#line 378 "composite.c"
}

static void
enchant_composite_dict_finalize (EnchantDict * obj)
{
	EnchantCompositeDict * self;
#line 30 "composite.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict);
#line 32 "composite.vala"
	(self->dict_list == NULL) ? NULL : (self->dict_list = (g_slist_free (self->dict_list), NULL));
#line 30 "composite.vala"
	ENCHANT_DICT_CLASS (enchant_composite_dict_parent_class)->finalize (obj);
#line 391 "composite.c"
}

static GType
enchant_composite_dict_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EnchantCompositeDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_composite_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantCompositeDict), 0, (GInstanceInitFunc) enchant_composite_dict_instance_init, NULL };
	GType enchant_composite_dict_type_id;
	enchant_composite_dict_type_id = g_type_register_static (TYPE_ENCHANT_DICT, "EnchantCompositeDict", &g_define_type_info, 0);
	EnchantCompositeDict_private_offset = g_type_add_instance_private (enchant_composite_dict_type_id, sizeof (EnchantCompositeDictPrivate));
	return enchant_composite_dict_type_id;
}

GType
enchant_composite_dict_get_type (void)
{
	static volatile gsize enchant_composite_dict_type_id__once = 0;
	if (g_once_init_enter (&enchant_composite_dict_type_id__once)) {
		GType enchant_composite_dict_type_id;
		enchant_composite_dict_type_id = enchant_composite_dict_get_type_once ();
		g_once_init_leave (&enchant_composite_dict_type_id__once, enchant_composite_dict_type_id);
	}
	return enchant_composite_dict_type_id__once;
}

static gpointer
_enchant_dict_ref0 (gpointer self)
{
#line 54 "composite.vala"
	return self ? enchant_dict_ref (self) : NULL;
#line 421 "composite.c"
}

gint
composite_dict_check (EnchantDict* _self_,
                      const gchar* word_buf,
                      size_t len)
{
	gboolean _tmp0_ = FALSE;
	gchar* word = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	EnchantCompositeDict* cdict = NULL;
	EnchantCompositeDict* _tmp3_;
	gint err = 0;
	EnchantCompositeDict* _tmp4_;
	GSList* _tmp5_;
	gint result;
#line 45 "composite.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 46 "composite.vala"
	if (_self_ == NULL) {
#line 46 "composite.vala"
		_tmp0_ = TRUE;
#line 445 "composite.c"
	} else {
#line 46 "composite.vala"
		_tmp0_ = word_buf == NULL;
#line 449 "composite.c"
	}
#line 46 "composite.vala"
	if (_tmp0_) {
#line 47 "composite.vala"
		result = -1;
#line 47 "composite.vala"
		return result;
#line 457 "composite.c"
	}
#line 48 "composite.vala"
	_tmp1_ = buf_to_utf8_string (word_buf, (gssize) ((ssize_t) len));
#line 48 "composite.vala"
	word = _tmp1_;
#line 49 "composite.vala"
	_tmp2_ = word;
#line 49 "composite.vala"
	if (_tmp2_ == NULL) {
#line 50 "composite.vala"
		result = -1;
#line 50 "composite.vala"
		_g_free0 (word);
#line 50 "composite.vala"
		return result;
#line 473 "composite.c"
	}
#line 54 "composite.vala"
	_tmp3_ = _enchant_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_self_, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 54 "composite.vala"
	cdict = _tmp3_;
#line 55 "composite.vala"
	err = -1;
#line 56 "composite.vala"
	_tmp4_ = cdict;
#line 56 "composite.vala"
	_tmp5_ = _tmp4_->dict_list;
#line 485 "composite.c"
	{
		GSList* dict_collection = NULL;
		GSList* dict_it = NULL;
#line 56 "composite.vala"
		dict_collection = _tmp5_;
#line 56 "composite.vala"
		for (dict_it = dict_collection; dict_it != NULL; dict_it = dict_it->next) {
#line 493 "composite.c"
			EnchantDict* _tmp6_;
			EnchantDict* dict = NULL;
#line 56 "composite.vala"
			_tmp6_ = _enchant_dict_ref0 ((EnchantDict*) dict_it->data);
#line 56 "composite.vala"
			dict = _tmp6_;
#line 500 "composite.c"
			{
				gint found = 0;
				EnchantDict* _tmp7_;
				const gchar* _tmp8_;
#line 57 "composite.vala"
				_tmp7_ = dict;
#line 57 "composite.vala"
				_tmp8_ = word;
#line 57 "composite.vala"
				found = enchant_dict_check (_tmp7_, _tmp8_, (ssize_t) len);
#line 58 "composite.vala"
				if (found == 0) {
#line 59 "composite.vala"
					result = 0;
#line 59 "composite.vala"
					_enchant_dict_unref0 (dict);
#line 59 "composite.vala"
					_enchant_dict_unref0 (cdict);
#line 59 "composite.vala"
					_g_free0 (word);
#line 59 "composite.vala"
					return result;
#line 523 "composite.c"
				}
#line 60 "composite.vala"
				if (found == 1) {
#line 61 "composite.vala"
					err = 1;
#line 529 "composite.c"
				}
#line 56 "composite.vala"
				_enchant_dict_unref0 (dict);
#line 533 "composite.c"
			}
		}
	}
#line 63 "composite.vala"
	result = err;
#line 63 "composite.vala"
	_enchant_dict_unref0 (cdict);
#line 63 "composite.vala"
	_g_free0 (word);
#line 63 "composite.vala"
	return result;
#line 545 "composite.c"
}

static void
_g_free0_ (gpointer var)
{
#line 70 "composite.vala"
	var = (g_free (var), NULL);
#line 553 "composite.c"
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
#line 70 "composite.vala"
	self = *((gchar**) data);
#line 70 "composite.vala"
	_g_free0_ (self);
#line 564 "composite.c"
}

gchar**
composite_dict_suggest (EnchantDict* me,
                        const gchar* word,
                        size_t len,
                        size_t* result_length1)
{
	EnchantCompositeDict* cdict = NULL;
	EnchantCompositeDict* _tmp0_;
	gboolean _error_ = FALSE;
	GArray* res = NULL;
	GArray* _tmp1_;
	EnchantCompositeDict* _tmp2_;
	GSList* _tmp3_;
	GArray* _tmp18_;
	gsize _tmp19_ = 0;
	gpointer* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar** result;
#line 67 "composite.vala"
	g_return_val_if_fail (me != NULL, NULL);
#line 67 "composite.vala"
	g_return_val_if_fail (word != NULL, NULL);
#line 68 "composite.vala"
	_tmp0_ = _enchant_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (me, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 68 "composite.vala"
	cdict = _tmp0_;
#line 69 "composite.vala"
	_error_ = TRUE;
#line 70 "composite.vala"
	_tmp1_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
#line 70 "composite.vala"
	g_array_set_clear_func (_tmp1_, (GDestroyNotify) _vala_gchar_free_function_content_of);
#line 70 "composite.vala"
	res = _tmp1_;
#line 71 "composite.vala"
	_tmp2_ = cdict;
#line 71 "composite.vala"
	_tmp3_ = _tmp2_->dict_list;
#line 606 "composite.c"
	{
		GSList* dict_collection = NULL;
		GSList* dict_it = NULL;
#line 71 "composite.vala"
		dict_collection = _tmp3_;
#line 71 "composite.vala"
		for (dict_it = dict_collection; dict_it != NULL; dict_it = dict_it->next) {
#line 614 "composite.c"
			EnchantDict* _tmp4_;
			EnchantDict* dict = NULL;
#line 71 "composite.vala"
			_tmp4_ = _enchant_dict_ref0 ((EnchantDict*) dict_it->data);
#line 71 "composite.vala"
			dict = _tmp4_;
#line 621 "composite.c"
			{
				gchar** suggs = NULL;
				EnchantDict* _tmp5_;
				size_t _tmp6_ = 0;
				gchar** _tmp7_;
				gint suggs_length1;
				gint _suggs_size_;
				gchar** _tmp8_;
				gint _tmp8__length1;
#line 72 "composite.vala"
				_tmp5_ = dict;
#line 72 "composite.vala"
				_tmp7_ = enchant_dict_suggest (_tmp5_, word, (ssize_t) len, &_tmp6_);
#line 72 "composite.vala"
				suggs = _tmp7_;
#line 72 "composite.vala"
				suggs_length1 = _tmp6_;
#line 72 "composite.vala"
				_suggs_size_ = suggs_length1;
#line 73 "composite.vala"
				_tmp8_ = suggs;
#line 73 "composite.vala"
				_tmp8__length1 = suggs_length1;
#line 73 "composite.vala"
				if (_tmp8_ != NULL) {
#line 647 "composite.c"
					gchar** _tmp9_;
					gint _tmp9__length1;
#line 74 "composite.vala"
					_error_ = FALSE;
#line 75 "composite.vala"
					_tmp9_ = suggs;
#line 75 "composite.vala"
					_tmp9__length1 = suggs_length1;
#line 75 "composite.vala"
					if (_tmp9__length1 > 0) {
#line 658 "composite.c"
						{
							size_t i = 0UL;
#line 76 "composite.vala"
							i = (size_t) 0;
#line 663 "composite.c"
							{
								gboolean _tmp10_ = FALSE;
#line 76 "composite.vala"
								_tmp10_ = TRUE;
#line 76 "composite.vala"
								while (TRUE) {
#line 670 "composite.c"
									gchar** _tmp12_;
									gint _tmp12__length1;
									GArray* _tmp13_;
									gchar** _tmp14_;
									gint _tmp14__length1;
									const gchar* _tmp15_;
									gchar* _tmp16_;
#line 76 "composite.vala"
									if (!_tmp10_) {
#line 680 "composite.c"
										size_t _tmp11_;
#line 76 "composite.vala"
										_tmp11_ = i;
#line 76 "composite.vala"
										i = _tmp11_ + 1;
#line 686 "composite.c"
									}
#line 76 "composite.vala"
									_tmp10_ = FALSE;
#line 76 "composite.vala"
									_tmp12_ = suggs;
#line 76 "composite.vala"
									_tmp12__length1 = suggs_length1;
#line 76 "composite.vala"
									if (!(i < ((size_t) _tmp12__length1))) {
#line 76 "composite.vala"
										break;
#line 698 "composite.c"
									}
#line 77 "composite.vala"
									_tmp13_ = res;
#line 77 "composite.vala"
									_tmp14_ = suggs;
#line 77 "composite.vala"
									_tmp14__length1 = suggs_length1;
#line 77 "composite.vala"
									_tmp15_ = _tmp14_[i];
#line 77 "composite.vala"
									_tmp16_ = g_strdup (_tmp15_);
#line 77 "composite.vala"
									g_array_append_val (_tmp13_, _tmp16_);
#line 712 "composite.c"
								}
							}
						}
					}
				}
#line 71 "composite.vala"
				suggs = (_vala_array_free (suggs, suggs_length1, (GDestroyNotify) g_free), NULL);
#line 71 "composite.vala"
				_enchant_dict_unref0 (dict);
#line 722 "composite.c"
			}
		}
	}
#line 80 "composite.vala"
	if (_error_ == TRUE) {
#line 728 "composite.c"
		gchar** _tmp17_;
		gint _tmp17__length1;
#line 81 "composite.vala"
		_tmp17_ = NULL;
#line 81 "composite.vala"
		_tmp17__length1 = 0;
#line 81 "composite.vala"
		if (result_length1) {
#line 81 "composite.vala"
			*result_length1 = _tmp17__length1;
#line 739 "composite.c"
		}
#line 81 "composite.vala"
		result = _tmp17_;
#line 81 "composite.vala"
		_g_array_unref0 (res);
#line 81 "composite.vala"
		_enchant_dict_unref0 (cdict);
#line 81 "composite.vala"
		return result;
#line 749 "composite.c"
	}
#line 82 "composite.vala"
	_tmp18_ = res;
#line 82 "composite.vala"
	_tmp20_ = g_array_steal (_tmp18_, &_tmp19_);
#line 82 "composite.vala"
	_tmp21_ = _tmp20_;
#line 82 "composite.vala"
	_tmp21__length1 = _tmp19_;
#line 82 "composite.vala"
	if (result_length1) {
#line 82 "composite.vala"
		*result_length1 = _tmp21__length1;
#line 763 "composite.c"
	}
#line 82 "composite.vala"
	result = _tmp21_;
#line 82 "composite.vala"
	_g_array_unref0 (res);
#line 82 "composite.vala"
	_enchant_dict_unref0 (cdict);
#line 82 "composite.vala"
	return result;
#line 773 "composite.c"
}

void
composite_dict_add_to_session (EnchantDict* me,
                               const gchar* word,
                               size_t len)
{
	EnchantCompositeDict* cdict = NULL;
	EnchantCompositeDict* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp2_;
	gconstpointer _tmp3_;
#line 85 "composite.vala"
	g_return_if_fail (me != NULL);
#line 85 "composite.vala"
	g_return_if_fail (word != NULL);
#line 86 "composite.vala"
	_tmp0_ = _enchant_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (me, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 86 "composite.vala"
	cdict = _tmp0_;
#line 87 "composite.vala"
	_tmp1_ = cdict->dict_list;
#line 87 "composite.vala"
	_vala_assert (g_slist_length (_tmp1_) > ((guint) 0), "cdict.dict_list.length() > 0");
#line 88 "composite.vala"
	_tmp2_ = cdict->dict_list;
#line 88 "composite.vala"
	_tmp3_ = _tmp2_->data;
#line 88 "composite.vala"
	enchant_dict_add_to_session ((EnchantDict*) _tmp3_, word, (ssize_t) len);
#line 85 "composite.vala"
	_enchant_dict_unref0 (cdict);
#line 806 "composite.c"
}

void
composite_dict_remove_from_session (EnchantDict* me,
                                    const gchar* word,
                                    size_t len)
{
	EnchantCompositeDict* cdict = NULL;
	EnchantCompositeDict* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp2_;
	gconstpointer _tmp3_;
#line 91 "composite.vala"
	g_return_if_fail (me != NULL);
#line 91 "composite.vala"
	g_return_if_fail (word != NULL);
#line 92 "composite.vala"
	_tmp0_ = _enchant_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (me, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 92 "composite.vala"
	cdict = _tmp0_;
#line 93 "composite.vala"
	_tmp1_ = cdict->dict_list;
#line 93 "composite.vala"
	_vala_assert (g_slist_length (_tmp1_) > ((guint) 0), "cdict.dict_list.length() > 0");
#line 94 "composite.vala"
	_tmp2_ = cdict->dict_list;
#line 94 "composite.vala"
	_tmp3_ = _tmp2_->data;
#line 94 "composite.vala"
	enchant_dict_remove_from_session ((EnchantDict*) _tmp3_, word, (ssize_t) len);
#line 91 "composite.vala"
	_enchant_dict_unref0 (cdict);
#line 839 "composite.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

