
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "squeezelabelv1_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"
#include "squeezelabelv2_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_SqueezeLabelV1_Type = nullptr;
static PyTypeObject *Sbk_SqueezeLabelV1_TypeF(void)
{
    return _Sbk_SqueezeLabelV1_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void SqueezeLabelV1Wrapper::pysideInitQtMetaTypes()
{
}

void SqueezeLabelV1Wrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

SqueezeLabelV1Wrapper::SqueezeLabelV1Wrapper(::QWidget * parent) : SqueezeLabelV1(parent)
{
}

void SqueezeLabelV1Wrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::changeEvent(arg__1);
    }
    WebViewWrapper::sbk_o_changeEvent("SqueezeLabelV1", funcName, gil, pyOverride, arg__1);
}

void SqueezeLabelV1Wrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SqueezeLabelV1", funcName, gil, pyOverride, signal);
}

void SqueezeLabelV1Wrapper::contextMenuEvent(::QContextMenuEvent * ev)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::contextMenuEvent(ev);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("SqueezeLabelV1", funcName, gil, pyOverride, ev);
}

void SqueezeLabelV1Wrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

int SqueezeLabelV1Wrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("SqueezeLabelV1", funcName, gil, pyOverride);
}

void SqueezeLabelV1Wrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SqueezeLabelV1", funcName, gil, pyOverride, signal);
}

void SqueezeLabelV1Wrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

bool SqueezeLabelV1Wrapper::event(::QEvent * e)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::event(e);
    }
    return WebViewWrapper::sbk_o_event("SqueezeLabelV1", funcName, gil, pyOverride, e);
}

bool SqueezeLabelV1Wrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("SqueezeLabelV1", funcName, gil, pyOverride, watched, event);
}

void SqueezeLabelV1Wrapper::focusInEvent(::QFocusEvent * ev)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusInEvent(ev);
    }
    WebViewWrapper::sbk_o_focusInEvent("SqueezeLabelV1", funcName, gil, pyOverride, ev);
}

bool SqueezeLabelV1Wrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("SqueezeLabelV1", funcName, gil, pyOverride, next);
}

void SqueezeLabelV1Wrapper::focusOutEvent(::QFocusEvent * ev)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusOutEvent(ev);
    }
    WebViewWrapper::sbk_o_focusOutEvent("SqueezeLabelV1", funcName, gil, pyOverride, ev);
}

bool SqueezeLabelV1Wrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("SqueezeLabelV1", funcName, gil, pyOverride);
}

int SqueezeLabelV1Wrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("SqueezeLabelV1", funcName, gil, pyOverride, arg__1);
}

void SqueezeLabelV1Wrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("SqueezeLabelV1", funcName, gil, pyOverride, painter);
}

void SqueezeLabelV1Wrapper::initStyleOption(::QStyleOptionFrame * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFrame::initStyleOption(option);
    }
    SqueezeLabelV2Wrapper::sbk_o_initStyleOption("SqueezeLabelV1", funcName, gil, pyOverride, option);
}

void SqueezeLabelV1Wrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

::QVariant SqueezeLabelV1Wrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("SqueezeLabelV1", funcName, gil, pyOverride, arg__1);
}

void SqueezeLabelV1Wrapper::keyPressEvent(::QKeyEvent * ev)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::keyPressEvent(ev);
    }
    WebViewWrapper::sbk_o_keyPressEvent("SqueezeLabelV1", funcName, gil, pyOverride, ev);
}

void SqueezeLabelV1Wrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

int SqueezeLabelV1Wrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("SqueezeLabelV1", funcName, gil, pyOverride, arg__1);
}

::QSize SqueezeLabelV1Wrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("SqueezeLabelV1", funcName, gil, pyOverride);
}

void SqueezeLabelV1Wrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::mouseMoveEvent(::QMouseEvent * ev)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::mouseMoveEvent(ev);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("SqueezeLabelV1", funcName, gil, pyOverride, ev);
}

void SqueezeLabelV1Wrapper::mousePressEvent(::QMouseEvent * ev)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::mousePressEvent(ev);
    }
    WebViewWrapper::sbk_o_mousePressEvent("SqueezeLabelV1", funcName, gil, pyOverride, ev);
}

void SqueezeLabelV1Wrapper::mouseReleaseEvent(::QMouseEvent * ev)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::mouseReleaseEvent(ev);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("SqueezeLabelV1", funcName, gil, pyOverride, ev);
}

void SqueezeLabelV1Wrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

bool SqueezeLabelV1Wrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("SqueezeLabelV1", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * SqueezeLabelV1Wrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("SqueezeLabelV1", funcName, gil, pyOverride);
}

void SqueezeLabelV1Wrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::SqueezeLabelV1::paintEvent(event);
    }
    WebViewWrapper::sbk_o_paintEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

::QPaintDevice * SqueezeLabelV1Wrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("SqueezeLabelV1", funcName, gil, pyOverride, offset);
}

void SqueezeLabelV1Wrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("SqueezeLabelV1", funcName, gil, pyOverride, visible);
}

::QPainter * SqueezeLabelV1Wrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("SqueezeLabelV1", funcName, gil, pyOverride);
}

void SqueezeLabelV1Wrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

::QSize SqueezeLabelV1Wrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("SqueezeLabelV1", funcName, gil, pyOverride);
}

void SqueezeLabelV1Wrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

void SqueezeLabelV1Wrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqueezeLabelV1_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("SqueezeLabelV1", funcName, gil, pyOverride, event);
}

const QMetaObject *SqueezeLabelV1Wrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return SqueezeLabelV1::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int SqueezeLabelV1Wrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = SqueezeLabelV1::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *SqueezeLabelV1Wrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< SqueezeLabelV1Wrapper *>(this));
    }
    return SqueezeLabelV1::qt_metacast(_clname);
}

SqueezeLabelV1Wrapper::~SqueezeLabelV1Wrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_SqueezeLabelV1_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_SqueezeLabelV1_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::SqueezeLabelV1 >()))
        return -1;

    SqueezeLabelV1Wrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:SqueezeLabelV1", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: SqueezeLabelV1::SqueezeLabelV1(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // SqueezeLabelV1(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // SqueezeLabelV1(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // SqueezeLabelV1(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) SqueezeLabelV1Wrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new SqueezeLabelV1Wrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< SqueezeLabelV1 >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX]);
    };


    return 1;
}

static PyObject *Sbk_SqueezeLabelV1Func_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SqueezeLabelV1Wrapper *>(reinterpret_cast< ::SqueezeLabelV1 *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            static_cast<SqueezeLabelV1Wrapper *>(cppSelf)->SqueezeLabelV1Wrapper::paintEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_SqueezeLabelV1_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_SqueezeLabelV1_methods[] = {
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_SqueezeLabelV1Func_paintEvent), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_SqueezeLabelV1_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::SqueezeLabelV1 *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<SqueezeLabelV1Wrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_SqueezeLabelV1_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_SqueezeLabelV1_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_SqueezeLabelV1SpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::SqueezeLabelV1 *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX]))
        return static_cast< ::QLabel *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX]))
        return static_cast< ::QFrame *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_SqueezeLabelV1_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_SqueezeLabelV1_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_SqueezeLabelV1_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_SqueezeLabelV1_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_SqueezeLabelV1_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_SqueezeLabelV1_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_SqueezeLabelV1_spec = {
    "1:PyFalkon.SqueezeLabelV1",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_SqueezeLabelV1_slots
};

} //extern "C"

static void *Sbk_SqueezeLabelV1_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::SqueezeLabelV1 *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::SqueezeLabelV1 *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::SqueezeLabelV1 *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void SqueezeLabelV1_PythonToCpp_SqueezeLabelV1_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_SqueezeLabelV1_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_SqueezeLabelV1_PythonToCpp_SqueezeLabelV1_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_SqueezeLabelV1_TypeF()))
        return SqueezeLabelV1_PythonToCpp_SqueezeLabelV1_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *SqueezeLabelV1_PTR_CppToPython_SqueezeLabelV1(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::SqueezeLabelV1 *>(const_cast<void *>(cppIn)), Sbk_SqueezeLabelV1_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *SqueezeLabelV1_SignatureStrings[] = {
    "PyFalkon.SqueezeLabelV1(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "PyFalkon.SqueezeLabelV1.paintEvent(self,event:PySide6.QtGui.QPaintEvent)",
    nullptr}; // Sentinel
#else
static constexpr size_t SqueezeLabelV1_SignatureByteSize = 104;
static constexpr uint8_t SqueezeLabelV1_SignatureBytes[104] = {
    0x78, 0xda, 0x0b, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0x2e, 0x2c, 0x4d, 0x4d,
    0xad, 0x4a, 0xf5, 0x49, 0x4c, 0x4a, 0xcd, 0x09, 0x33, 0xd4, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0x29,
    0x48, 0x2c, 0x4a, 0xcd, 0x2b, 0xb1, 0x0a, 0xa8, 0x0c, 0xce, 0x4c, 0x49, 0x35, 0xd3, 0x0b, 0x2c,
    0x09, 0xcf, 0x4c, 0x49, 0x4f, 0x2d, 0x29, 0xd6, 0x0b, 0x84, 0x30, 0x6c, 0xf3, 0x4a, 0x73, 0x72,
    0x0a, 0x4a, 0x8a, 0x34, 0xb9, 0x02, 0xb0, 0x1b, 0xa3, 0x57, 0x90, 0x98, 0x99, 0x57, 0xe2, 0x5a,
    0x06, 0x34, 0x05, 0x62, 0x62, 0x6a, 0x19, 0xaa, 0x81, 0xee, 0xa5, 0x99, 0x7a, 0x81, 0x01, 0x70,
    0x45, 0x9a, 0x5c, 0x00, 0x0f, 0xdd, 0x34, 0x9d
};
#endif

PyTypeObject *init_SqueezeLabelV1(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX].type;

    Shiboken::AutoDecRef Sbk_SqueezeLabelV1_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX]))));

    _Sbk_SqueezeLabelV1_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "SqueezeLabelV1",
        "SqueezeLabelV1*",
        &Sbk_SqueezeLabelV1_spec,
        &Shiboken::callCppDestructor< SqueezeLabelV1 >,
        Sbk_SqueezeLabelV1_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_SqueezeLabelV1_Type; // references _Sbk_SqueezeLabelV1_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, SqueezeLabelV1_SignatureStrings);
#else
    InitSignatureBytes(pyType, SqueezeLabelV1_SignatureBytes, SqueezeLabelV1_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_SqueezeLabelV1_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_SqueezeLabelV1_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        SqueezeLabelV1_PythonToCpp_SqueezeLabelV1_PTR,
        is_SqueezeLabelV1_PythonToCpp_SqueezeLabelV1_PTR_Convertible,
        SqueezeLabelV1_PTR_CppToPython_SqueezeLabelV1);

    Shiboken::Conversions::registerConverterName(converter, "SqueezeLabelV1");
    Shiboken::Conversions::registerConverterName(converter, "SqueezeLabelV1*");
    Shiboken::Conversions::registerConverterName(converter, "SqueezeLabelV1&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::SqueezeLabelV1).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(SqueezeLabelV1Wrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_SqueezeLabelV1_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_SqueezeLabelV1_TypeF(), &Sbk_SqueezeLabelV1SpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_SqueezeLabelV1_TypeF(), &Sbk_SqueezeLabelV1_typeDiscovery);

    SqueezeLabelV1Wrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::SqueezeLabelV1::staticMetaObject, sizeof(SqueezeLabelV1Wrapper));

    return pyType;
}
