/* InternalUtils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from InternalUtils.vala, do not modify */

/*
 * Copyright 2012 Tom Beckmann
 * Copyright 2012 Rico Tzschichholz
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <meta/display.h>
#include <glib.h>
#include <meta/util.h>
#include <X11/Xlib.h>
#include <meta/meta-x11-display.h>
#include <X11/extensions/Xfixes.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <meta/window.h>
#include <meta/meta-window-actor.h>
#include <meta/compositor-mutter.h>
#include <meta/workspace.h>
#include <gdk/gdk.h>
#include <mtk/mtk.h>
#include <clutter/clutter.h>
#include <math.h>
#include <float.h>
#include <string.h>
#include <meta/meta-workspace-manager.h>
#include <meta/prefs.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GALA_INPUT_AREA_NONE,
	GALA_INPUT_AREA_FULLSCREEN,
	GALA_INPUT_AREA_DEFAULT
} GalaInputArea;

#define GALA_TYPE_INPUT_AREA (gala_input_area_get_type ())

#define GALA_TYPE_INTERNAL_UTILS (gala_internal_utils_get_type ())
#define GALA_INTERNAL_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_INTERNAL_UTILS, GalaInternalUtils))
#define GALA_INTERNAL_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_INTERNAL_UTILS, GalaInternalUtilsClass))
#define GALA_IS_INTERNAL_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_INTERNAL_UTILS))
#define GALA_IS_INTERNAL_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_INTERNAL_UTILS))
#define GALA_INTERNAL_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_INTERNAL_UTILS, GalaInternalUtilsClass))

typedef struct _GalaInternalUtils GalaInternalUtils;
typedef struct _GalaInternalUtilsClass GalaInternalUtilsClass;
typedef struct _GalaInternalUtilsPrivate GalaInternalUtilsPrivate;

#define GALA_TYPE_PLUGIN_MANAGER (gala_plugin_manager_get_type ())
#define GALA_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManager))
#define GALA_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManagerClass))
#define GALA_IS_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PLUGIN_MANAGER))
#define GALA_IS_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PLUGIN_MANAGER))
#define GALA_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManagerClass))

typedef struct _GalaPluginManager GalaPluginManager;
typedef struct _GalaPluginManagerClass GalaPluginManagerClass;

#define GALA_TYPE_WORKSPACE_MANAGER (gala_workspace_manager_get_type ())
#define GALA_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager))
#define GALA_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))
#define GALA_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))

typedef struct _GalaWorkspaceManager GalaWorkspaceManager;
typedef struct _GalaWorkspaceManagerClass GalaWorkspaceManagerClass;

#define GALA_INTERNAL_UTILS_TYPE_TILABLE_WINDOW (gala_internal_utils_tilable_window_get_type ())
typedef struct _GalaInternalUtilsTilableWindow GalaInternalUtilsTilableWindow;

#define GALA_TYPE_ACTOR_TARGET (gala_actor_target_get_type ())
#define GALA_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTarget))
#define GALA_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))
#define GALA_IS_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACTOR_TARGET))
#define GALA_IS_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ACTOR_TARGET))
#define GALA_ACTOR_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))

typedef struct _GalaActorTarget GalaActorTarget;
typedef struct _GalaActorTargetClass GalaActorTargetClass;

#define GALA_TYPE_WINDOW_CLONE (gala_window_clone_get_type ())
#define GALA_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowClone))
#define GALA_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))
#define GALA_IS_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE))
#define GALA_IS_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE))
#define GALA_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))

typedef struct _GalaWindowClone GalaWindowClone;
typedef struct _GalaWindowCloneClass GalaWindowCloneClass;
#define _gala_internal_utils_tilable_window_free0(var) ((var == NULL) ? NULL : (var = (gala_internal_utils_tilable_window_free (var), NULL)))
typedef void (*GalaInternalUtilsWindowActorReadyCallback) (MetaWindowActor* window_actor, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _GalaParamSpecInternalUtils GalaParamSpecInternalUtils;

struct _GalaInternalUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaInternalUtilsPrivate * priv;
};

struct _GalaInternalUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (GalaInternalUtils *self);
};

struct _GalaInternalUtilsTilableWindow {
	MtkRectangle rect;
	GalaWindowClone* id;
};

struct _Block2Data {
	int _ref_count_;
	MetaWindowActor* window_actor;
	MetaWindow* window;
	GalaInternalUtilsWindowActorReadyCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _Block3Data {
	int _ref_count_;
	GalaInternalUtilsWindowActorReadyCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	MetaWindowActor* window_actor;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	gulong show_handler;
};

struct _GalaParamSpecInternalUtils {
	GParamSpec parent_instance;
};

static gpointer gala_internal_utils_parent_class = NULL;

VALA_EXTERN GType gala_input_area_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer gala_internal_utils_ref (gpointer instance);
VALA_EXTERN void gala_internal_utils_unref (gpointer instance);
VALA_EXTERN GParamSpec* gala_param_spec_internal_utils (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void gala_value_set_internal_utils (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void gala_value_take_internal_utils (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer gala_value_get_internal_utils (const GValue* value);
VALA_EXTERN GType gala_internal_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaInternalUtils, gala_internal_utils_unref)
VALA_EXTERN void gala_internal_utils_set_input_area (MetaDisplay* display,
                                         GalaInputArea area);
VALA_EXTERN GType gala_plugin_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPluginManager, g_object_unref)
VALA_EXTERN GalaPluginManager* gala_plugin_manager_get_default (void);
VALA_EXTERN XRectangle* gala_plugin_manager_get_regions (GalaPluginManager* self,
                                             gint* result_length1);
static void _vala_array_add5 (XRectangle* * array,
                       gint* length,
                       gint* size,
                       XRectangle value);
VALA_EXTERN void gala_internal_utils_insert_workspace_with_window (gint index,
                                                       MetaWindow* new_window);
VALA_EXTERN GType gala_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceManager, g_object_unref)
VALA_EXTERN GalaWorkspaceManager* gala_workspace_manager_get_default (void);
VALA_EXTERN void gala_workspace_manager_freeze_remove (GalaWorkspaceManager* self);
VALA_EXTERN void gala_workspace_manager_thaw_remove (GalaWorkspaceManager* self);
static gint gala_internal_utils_squared_distance (GdkPoint* a,
                                           GdkPoint* b);
static void gala_internal_utils_rect_adjusted (MtkRectangle* rect,
                                        gint dx1,
                                        gint dy1,
                                        gint dx2,
                                        gint dy2,
                                        MtkRectangle* result);
static void gala_internal_utils_rect_center (MtkRectangle* rect,
                                      GdkPoint* result);
VALA_EXTERN GType gala_internal_utils_tilable_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_actor_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaActorTarget, g_object_unref)
VALA_EXTERN GType gala_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowClone, g_object_unref)
VALA_EXTERN GalaInternalUtilsTilableWindow* gala_internal_utils_tilable_window_dup (const GalaInternalUtilsTilableWindow* self);
VALA_EXTERN void gala_internal_utils_tilable_window_free (GalaInternalUtilsTilableWindow* self);
VALA_EXTERN GList* gala_internal_utils_calculate_grid_placement (MtkRectangle* area,
                                                     GList* windows);
static gboolean _mtk_rectangle_equal (const MtkRectangle * s1,
                               const MtkRectangle * s2);
static gboolean _gala_internal_utils_tilable_window_equal (const GalaInternalUtilsTilableWindow * s1,
                                                    const GalaInternalUtilsTilableWindow * s2);
VALA_EXTERN GSList* gala_internal_utils_sort_windows (MetaDisplay* display,
                                          GList* windows);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
VALA_EXTERN gboolean gala_internal_utils_get_window_is_normal (MetaWindow* window);
VALA_EXTERN void gala_internal_utils_get_workspaces_geometry (MetaDisplay* display,
                                                  MtkRectangle* result);
VALA_EXTERN void gala_internal_utils_actor_box_from_rect (gfloat x,
                                              gfloat y,
                                              gfloat width,
                                              gfloat height,
                                              ClutterActorBox* result);
VALA_EXTERN void gala_internal_utils_wait_for_window_actor (MetaWindow* window,
                                                GalaInternalUtilsWindowActorReadyCallback callback,
                                                gpointer callback_target,
                                                GDestroyNotify callback_target_destroy_notify);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda15_ (Block2Data* _data2_);
static gboolean ___lambda15__gsource_func (gpointer self);
VALA_EXTERN void gala_internal_utils_wait_for_window_actor_visible (MetaWindow* window,
                                                        GalaInternalUtilsWindowActorReadyCallback callback,
                                                        gpointer callback_target,
                                                        GDestroyNotify callback_target_destroy_notify);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda16_ (Block3Data* _data3_,
                  MetaWindowActor* window_actor);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda17_ (Block5Data* _data5_);
static void ____lambda17__clutter_actor_show (ClutterActor* _sender,
                                       gpointer self);
static void ___lambda16__gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                   gpointer self);
VALA_EXTERN void gala_internal_utils_clutter_actor_reparent (ClutterActor* actor,
                                                 ClutterActor* new_parent);
VALA_EXTERN void gala_internal_utils_bell_notify (MetaDisplay* display);
VALA_EXTERN gboolean gala_internal_utils_get_x11_in_fullscreen (MetaDisplay* display);
VALA_EXTERN GalaInternalUtils* gala_internal_utils_new (void);
VALA_EXTERN GalaInternalUtils* gala_internal_utils_construct (GType object_type);
static void gala_internal_utils_finalize (GalaInternalUtils * obj);
static GType gala_internal_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

 G_GNUC_NO_INLINE static GType
gala_input_area_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_INPUT_AREA_NONE, "GALA_INPUT_AREA_NONE", "none"}, {GALA_INPUT_AREA_FULLSCREEN, "GALA_INPUT_AREA_FULLSCREEN", "fullscreen"}, {GALA_INPUT_AREA_DEFAULT, "GALA_INPUT_AREA_DEFAULT", "default"}, {0, NULL, NULL}};
	GType gala_input_area_type_id;
	gala_input_area_type_id = g_enum_register_static ("GalaInputArea", values);
	return gala_input_area_type_id;
}

GType
gala_input_area_get_type (void)
{
	static gsize gala_input_area_type_id__once = 0;
	if (g_once_init_enter (&gala_input_area_type_id__once)) {
		GType gala_input_area_type_id;
		gala_input_area_type_id = gala_input_area_get_type_once ();
		g_once_init_leave (&gala_input_area_type_id__once, gala_input_area_type_id);
	}
	return gala_input_area_type_id__once;
}

/**
         * set the area where clutter can receive events
         **/
static void
_vala_array_add5 (XRectangle* * array,
                  gint* length,
                  gint* size,
                  XRectangle value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (XRectangle, *array, *size);
	}
	(*array)[(*length)++] = value;
}

void
gala_internal_utils_set_input_area (MetaDisplay* display,
                                    GalaInputArea area)
{
	XRectangle* rects = NULL;
	XRectangle* _tmp0_;
	gint rects_length1;
	gint _rects_size_;
	MetaX11Display* x11display = NULL;
	MetaX11Display* _tmp9_;
	XserverRegion xregion = {0};
	MetaX11Display* _tmp10_;
	Display* _tmp11_;
	XRectangle* _tmp12_;
	gint _tmp12__length1;
	MetaX11Display* _tmp13_;
	g_return_if_fail (display != NULL);
	if (meta_is_wayland_compositor ()) {
		return;
	}
	_tmp0_ = g_new0 (XRectangle, 0);
	rects = _tmp0_;
	rects_length1 = 0;
	_rects_size_ = rects_length1;
	switch (area) {
		case GALA_INPUT_AREA_FULLSCREEN:
		{
			gint width = 0;
			gint height = 0;
			gint _tmp1_ = 0;
			gint _tmp2_ = 0;
			XRectangle rect = {0};
			XRectangle _tmp3_ = {0};
			XRectangle* _tmp4_;
			meta_display_get_size (display, &_tmp1_, &_tmp2_);
			width = _tmp1_;
			height = _tmp2_;
			_tmp3_.x = (gshort) 0;
			_tmp3_.y = (gshort) 0;
			_tmp3_.width = (gushort) width;
			_tmp3_.height = (gushort) height;
			rect = _tmp3_;
			_tmp4_ = g_new0 (XRectangle, 1);
			_tmp4_[0] = rect;
			rects = (g_free (rects), NULL);
			rects = _tmp4_;
			rects_length1 = 1;
			_rects_size_ = rects_length1;
			break;
		}
		case GALA_INPUT_AREA_DEFAULT:
		{
			GalaPluginManager* _tmp5_;
			gint _tmp6_ = 0;
			XRectangle* _tmp7_;
			_tmp5_ = gala_plugin_manager_get_default ();
			_tmp7_ = gala_plugin_manager_get_regions (_tmp5_, &_tmp6_);
			{
				XRectangle* rect_collection = NULL;
				gint rect_collection_length1 = 0;
				gint _rect_collection_size_ = 0;
				gint rect_it = 0;
				rect_collection = _tmp7_;
				rect_collection_length1 = _tmp6_;
				for (rect_it = 0; rect_it < rect_collection_length1; rect_it = rect_it + 1) {
					XRectangle rect = {0};
					rect = rect_collection[rect_it];
					{
						_vala_array_add5 (&rects, &rects_length1, &_rects_size_, rect);
					}
				}
			}
			break;
		}
		default:
		case GALA_INPUT_AREA_NONE:
		{
			XRectangle* _tmp8_;
			_tmp8_ = g_new0 (XRectangle, 0);
			rects = (g_free (rects), NULL);
			rects = _tmp8_;
			rects_length1 = 0;
			_rects_size_ = rects_length1;
			break;
		}
	}
	_tmp9_ = meta_display_get_x11_display (display);
	x11display = _tmp9_;
	_tmp10_ = x11display;
	_tmp11_ = meta_x11_display_get_xdisplay (_tmp10_);
	_tmp12_ = rects;
	_tmp12__length1 = rects_length1;
	xregion = XFixesCreateRegion (_tmp11_, _tmp12_, (gint) _tmp12__length1);
	_tmp13_ = x11display;
	meta_x11_display_set_stage_input_region (_tmp13_, xregion);
	rects = (g_free (rects), NULL);
}

/**
         * Inserts a workspace at the given index. To ensure the workspace is not immediately
         * removed again when in dynamic workspaces, the window is first placed on it.
         *
         * @param index  The index at which to insert the workspace
         * @param new_window A window that should be moved to the new workspace
         */
void
gala_internal_utils_insert_workspace_with_window (gint index,
                                                  MetaWindow* new_window)
{
	GalaWorkspaceManager* workspace_manager = NULL;
	GalaWorkspaceManager* _tmp0_;
	GalaWorkspaceManager* _tmp1_;
	GList* actors = NULL;
	MetaDisplay* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GalaWorkspaceManager* _tmp16_;
	g_return_if_fail (new_window != NULL);
	_tmp0_ = gala_workspace_manager_get_default ();
	workspace_manager = _tmp0_;
	_tmp1_ = workspace_manager;
	gala_workspace_manager_freeze_remove (_tmp1_);
	meta_window_change_workspace_by_index (new_window, index, FALSE);
	_tmp2_ = meta_window_get_display (new_window);
	_tmp3_ = meta_get_window_actors (_tmp2_);
	actors = _tmp3_;
	_tmp4_ = actors;
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp4_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			MetaWindowActor* actor = NULL;
			actor = (MetaWindowActor*) actor_it->data;
			{
				MetaWindowActor* _tmp5_;
				MetaWindow* window = NULL;
				MetaWindowActor* _tmp6_;
				MetaWindow* _tmp7_;
				MetaWindow* _tmp8_;
				gint current_index = 0;
				MetaWindow* _tmp9_;
				MetaWorkspace* _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp5_ = actor;
				if (meta_window_actor_is_destroyed (_tmp5_)) {
					continue;
				}
				_tmp6_ = actor;
				_tmp7_ = meta_window_actor_get_meta_window (_tmp6_);
				window = _tmp7_;
				_tmp8_ = window;
				if (_tmp8_ == new_window) {
					continue;
				}
				_tmp9_ = window;
				_tmp10_ = meta_window_get_workspace (_tmp9_);
				current_index = meta_workspace_index (_tmp10_);
				if (current_index >= index) {
					MetaWindow* _tmp12_;
					gboolean _tmp13_;
					gboolean _tmp14_;
					_tmp12_ = window;
					g_object_get (_tmp12_, "on-all-workspaces", &_tmp13_, NULL);
					_tmp14_ = _tmp13_;
					_tmp11_ = !_tmp14_;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					MetaWindow* _tmp15_;
					_tmp15_ = window;
					meta_window_change_workspace_by_index (_tmp15_, current_index + 1, TRUE);
				}
			}
		}
	}
	_tmp16_ = workspace_manager;
	gala_workspace_manager_thaw_remove (_tmp16_);
}

static gint
gala_internal_utils_squared_distance (GdkPoint* a,
                                      GdkPoint* b)
{
	gint k1 = 0;
	GdkPoint _tmp0_;
	GdkPoint _tmp1_;
	gint k2 = 0;
	GdkPoint _tmp2_;
	GdkPoint _tmp3_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = *b;
	_tmp1_ = *a;
	k1 = _tmp0_.x - _tmp1_.x;
	_tmp2_ = *b;
	_tmp3_ = *a;
	k2 = _tmp2_.y - _tmp3_.y;
	result = (k1 * k1) + (k2 * k2);
	return result;
}

static void
gala_internal_utils_rect_adjusted (MtkRectangle* rect,
                                   gint dx1,
                                   gint dy1,
                                   gint dx2,
                                   gint dy2,
                                   MtkRectangle* result)
{
	MtkRectangle _tmp0_;
	MtkRectangle _tmp1_;
	MtkRectangle _tmp2_;
	MtkRectangle _tmp3_;
	MtkRectangle _tmp4_ = {0};
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	_tmp1_ = *rect;
	_tmp2_ = *rect;
	_tmp3_ = *rect;
	_tmp4_.x = _tmp0_.x + dx1;
	_tmp4_.y = _tmp1_.y + dy1;
	_tmp4_.width = _tmp2_.width + ((-dx1) + dx2);
	_tmp4_.height = _tmp3_.height + ((-dy1) + dy2);
	*result = _tmp4_;
	return;
}

static void
gala_internal_utils_rect_center (MtkRectangle* rect,
                                 GdkPoint* result)
{
	MtkRectangle _tmp0_;
	MtkRectangle _tmp1_;
	MtkRectangle _tmp2_;
	MtkRectangle _tmp3_;
	GdkPoint _tmp4_ = {0};
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	_tmp1_ = *rect;
	_tmp2_ = *rect;
	_tmp3_ = *rect;
	_tmp4_.x = _tmp0_.x + (_tmp1_.width / 2);
	_tmp4_.y = _tmp2_.y + (_tmp3_.height / 2);
	*result = _tmp4_;
	return;
}

/**
         * Careful: List<TilableWindow?> windows will be modified in place and shouldn't be used afterwards.
         */
static gpointer
_gala_internal_utils_tilable_window_dup0 (gpointer self)
{
	return self ? gala_internal_utils_tilable_window_dup (self) : NULL;
}

static gboolean
_mtk_rectangle_equal (const MtkRectangle * s1,
                      const MtkRectangle * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static gboolean
_gala_internal_utils_tilable_window_equal (const GalaInternalUtilsTilableWindow * s1,
                                           const GalaInternalUtilsTilableWindow * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (!_mtk_rectangle_equal (&s1->rect, &s2->rect)) {
		return FALSE;
	}
	if (s1->id != s2->id) {
		return FALSE;
	}
	return TRUE;
}

GList*
gala_internal_utils_calculate_grid_placement (MtkRectangle* area,
                                              GList* windows)
{
	guint window_count = 0U;
	gint columns = 0;
	gint rows = 0;
	gint slot_width = 0;
	MtkRectangle _tmp0_;
	gint slot_height = 0;
	MtkRectangle _tmp1_;
	GalaInternalUtilsTilableWindow** taken_slots = NULL;
	GalaInternalUtilsTilableWindow** _tmp2_;
	gint taken_slots_length1;
	gint _taken_slots_size_;
	gint _tmp3_;
	GdkPoint* slot_centers = NULL;
	GdkPoint* _tmp4_;
	gint slot_centers_length1;
	gint _slot_centers_size_;
	gint _tmp5_;
	GList* _result_ = NULL;
	gint left_over = 0;
	GList* result;
	g_return_val_if_fail (area != NULL, NULL);
	window_count = g_list_length (windows);
	columns = (gint) ceil (sqrt ((gdouble) window_count));
	rows = (gint) ceil (window_count / ((gdouble) columns));
	_tmp0_ = *area;
	slot_width = _tmp0_.width / columns;
	_tmp1_ = *area;
	slot_height = _tmp1_.height / rows;
	_tmp2_ = g_new0 (GalaInternalUtilsTilableWindow*, 0);
	taken_slots = _tmp2_;
	taken_slots_length1 = 0;
	_taken_slots_size_ = taken_slots_length1;
	_tmp3_ = rows * columns;
	taken_slots = g_renew (GalaInternalUtilsTilableWindow*, taken_slots, rows * columns);
	(_tmp3_ > taken_slots_length1) ? memset (taken_slots + taken_slots_length1, 0, sizeof (GalaInternalUtilsTilableWindow*) * (_tmp3_ - taken_slots_length1)) : NULL;
	taken_slots_length1 = _tmp3_;
	_taken_slots_size_ = _tmp3_;
	_tmp4_ = g_new0 (GdkPoint, 0);
	slot_centers = _tmp4_;
	slot_centers_length1 = 0;
	_slot_centers_size_ = slot_centers_length1;
	_tmp5_ = rows * columns;
	slot_centers = g_renew (GdkPoint, slot_centers, rows * columns);
	(_tmp5_ > slot_centers_length1) ? memset (slot_centers + slot_centers_length1, 0, sizeof (GdkPoint) * (_tmp5_ - slot_centers_length1)) : NULL;
	slot_centers_length1 = _tmp5_;
	_slot_centers_size_ = _tmp5_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = x;
					x = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(x < columns)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							GdkPoint* _tmp10_;
							gint _tmp10__length1;
							MtkRectangle _tmp11_;
							MtkRectangle _tmp12_;
							GdkPoint _tmp13_ = {0};
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = y;
								y = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							if (!(y < rows)) {
								break;
							}
							_tmp10_ = slot_centers;
							_tmp10__length1 = slot_centers_length1;
							_tmp11_ = *area;
							_tmp12_ = *area;
							_tmp13_.x = (_tmp11_.x + (slot_width * x)) + (slot_width / 2);
							_tmp13_.y = (_tmp12_.y + (slot_height * y)) + (slot_height / 2);
							_tmp10_[x + (y * columns)] = _tmp13_;
						}
					}
				}
			}
		}
	}
	while (TRUE) {
		GList* link = NULL;
		GList* _tmp14_;
		GalaInternalUtilsTilableWindow* window = NULL;
		GList* _tmp15_;
		gconstpointer _tmp16_;
		GalaInternalUtilsTilableWindow* _tmp17_;
		MtkRectangle rect = {0};
		GalaInternalUtilsTilableWindow* _tmp18_;
		MtkRectangle _tmp19_;
		gint slot_candidate = 0;
		gint slot_candidate_distance = 0;
		GdkPoint pos = {0};
		MtkRectangle _tmp20_;
		GdkPoint _tmp21_ = {0};
		GalaInternalUtilsTilableWindow** _tmp39_;
		gint _tmp39__length1;
		GalaInternalUtilsTilableWindow* _tmp40_;
		GList* _tmp44_;
		GalaInternalUtilsTilableWindow** _tmp45_;
		gint _tmp45__length1;
		GalaInternalUtilsTilableWindow* _tmp46_;
		GalaInternalUtilsTilableWindow* _tmp47_;
		if (!(g_list_length (windows) > ((guint) 0))) {
			break;
		}
		_tmp14_ = g_list_nth (windows, (guint) 0);
		link = _tmp14_;
		_tmp15_ = link;
		_tmp16_ = _tmp15_->data;
		_tmp17_ = _gala_internal_utils_tilable_window_dup0 ((GalaInternalUtilsTilableWindow*) _tmp16_);
		window = _tmp17_;
		_tmp18_ = window;
		_tmp19_ = (*_tmp18_).rect;
		rect = _tmp19_;
		slot_candidate = -1;
		slot_candidate_distance = G_MAXINT;
		_tmp20_ = rect;
		gala_internal_utils_rect_center (&_tmp20_, &_tmp21_);
		pos = _tmp21_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp22_ = FALSE;
				_tmp22_ = TRUE;
				while (TRUE) {
					gint dist = 0;
					GdkPoint _tmp24_;
					GdkPoint* _tmp25_;
					gint _tmp25__length1;
					GdkPoint _tmp26_;
					if (!_tmp22_) {
						gint _tmp23_;
						_tmp23_ = i;
						i = _tmp23_ + 1;
					}
					_tmp22_ = FALSE;
					if (!(i < (columns * rows))) {
						break;
					}
					if (((guint) i) > (window_count - 1)) {
						break;
					}
					_tmp24_ = pos;
					_tmp25_ = slot_centers;
					_tmp25__length1 = slot_centers_length1;
					_tmp26_ = _tmp25_[i];
					dist = gala_internal_utils_squared_distance (&_tmp24_, &_tmp26_);
					if (dist < slot_candidate_distance) {
						GalaInternalUtilsTilableWindow* occupier = NULL;
						GalaInternalUtilsTilableWindow** _tmp27_;
						gint _tmp27__length1;
						GalaInternalUtilsTilableWindow* _tmp28_;
						GalaInternalUtilsTilableWindow* _tmp29_;
						GalaInternalUtilsTilableWindow* _tmp30_;
						GalaInternalUtilsTilableWindow* _tmp31_;
						gboolean _tmp32_ = FALSE;
						GalaInternalUtilsTilableWindow* _tmp33_;
						_tmp27_ = taken_slots;
						_tmp27__length1 = taken_slots_length1;
						_tmp28_ = _tmp27_[i];
						_tmp29_ = _gala_internal_utils_tilable_window_dup0 (_tmp28_);
						occupier = _tmp29_;
						_tmp30_ = occupier;
						_tmp31_ = window;
						if (_gala_internal_utils_tilable_window_equal (_tmp30_, _tmp31_) == TRUE) {
							_gala_internal_utils_tilable_window_free0 (occupier);
							continue;
						}
						_tmp33_ = occupier;
						if (_tmp33_ == NULL) {
							_tmp32_ = TRUE;
						} else {
							GalaInternalUtilsTilableWindow* _tmp34_;
							MtkRectangle _tmp35_;
							GdkPoint _tmp36_ = {0};
							GdkPoint* _tmp37_;
							gint _tmp37__length1;
							GdkPoint _tmp38_;
							_tmp34_ = occupier;
							_tmp35_ = (*_tmp34_).rect;
							gala_internal_utils_rect_center (&_tmp35_, &_tmp36_);
							_tmp37_ = slot_centers;
							_tmp37__length1 = slot_centers_length1;
							_tmp38_ = _tmp37_[i];
							_tmp32_ = dist < gala_internal_utils_squared_distance (&_tmp36_, &_tmp38_);
						}
						if (_tmp32_) {
							slot_candidate = i;
							slot_candidate_distance = dist;
						}
						_gala_internal_utils_tilable_window_free0 (occupier);
					}
				}
			}
		}
		if (slot_candidate == -1) {
			_gala_internal_utils_tilable_window_free0 (window);
			continue;
		}
		_tmp39_ = taken_slots;
		_tmp39__length1 = taken_slots_length1;
		_tmp40_ = _tmp39_[slot_candidate];
		if (_tmp40_ != NULL) {
			GalaInternalUtilsTilableWindow** _tmp41_;
			gint _tmp41__length1;
			GalaInternalUtilsTilableWindow* _tmp42_;
			GalaInternalUtilsTilableWindow* _tmp43_;
			_tmp41_ = taken_slots;
			_tmp41__length1 = taken_slots_length1;
			_tmp42_ = _tmp41_[slot_candidate];
			_tmp43_ = _gala_internal_utils_tilable_window_dup0 (_tmp42_);
			windows = g_list_prepend (windows, _tmp43_);
		}
		_tmp44_ = link;
		windows = g_list_remove_link (windows, _tmp44_);
		_tmp45_ = taken_slots;
		_tmp45__length1 = taken_slots_length1;
		_tmp46_ = window;
		_tmp47_ = _gala_internal_utils_tilable_window_dup0 (_tmp46_);
		_gala_internal_utils_tilable_window_free0 (_tmp45_[slot_candidate]);
		_tmp45_[slot_candidate] = _tmp47_;
		_gala_internal_utils_tilable_window_free0 (window);
	}
	_result_ = NULL;
	left_over = ((gint) window_count) - (columns * (rows - 1));
	{
		gint slot = 0;
		slot = 0;
		{
			gboolean _tmp48_ = FALSE;
			_tmp48_ = TRUE;
			while (TRUE) {
				GalaInternalUtilsTilableWindow* window = NULL;
				GalaInternalUtilsTilableWindow** _tmp50_;
				gint _tmp50__length1;
				GalaInternalUtilsTilableWindow* _tmp51_;
				GalaInternalUtilsTilableWindow* _tmp52_;
				GalaInternalUtilsTilableWindow* _tmp53_;
				MtkRectangle rect = {0};
				GalaInternalUtilsTilableWindow* _tmp54_;
				MtkRectangle _tmp55_;
				MtkRectangle target = {0};
				MtkRectangle _tmp56_;
				MtkRectangle _tmp57_;
				MtkRectangle _tmp58_ = {0};
				MtkRectangle _tmp59_;
				MtkRectangle _tmp60_ = {0};
				gfloat scale = 0.0F;
				MtkRectangle _tmp61_;
				MtkRectangle _tmp62_;
				MtkRectangle _tmp63_;
				MtkRectangle _tmp64_;
				gboolean _tmp84_ = FALSE;
				MtkRectangle _tmp85_;
				GalaInternalUtilsTilableWindow* _tmp86_;
				GalaWindowClone* _tmp87_;
				GalaInternalUtilsTilableWindow _tmp88_ = {0};
				GalaInternalUtilsTilableWindow* _tmp89_;
				if (!_tmp48_) {
					gint _tmp49_;
					_tmp49_ = slot;
					slot = _tmp49_ + 1;
				}
				_tmp48_ = FALSE;
				if (!(slot < (columns * rows))) {
					break;
				}
				_tmp50_ = taken_slots;
				_tmp50__length1 = taken_slots_length1;
				_tmp51_ = _tmp50_[slot];
				_tmp52_ = _gala_internal_utils_tilable_window_dup0 (_tmp51_);
				window = _tmp52_;
				_tmp53_ = window;
				if (_tmp53_ == NULL) {
					_gala_internal_utils_tilable_window_free0 (window);
					continue;
				}
				_tmp54_ = window;
				_tmp55_ = (*_tmp54_).rect;
				rect = _tmp55_;
				_tmp56_ = *area;
				_tmp57_ = *area;
				_tmp58_.x = _tmp56_.x + ((slot % columns) * slot_width);
				_tmp58_.y = _tmp57_.y + ((slot / columns) * slot_height);
				_tmp58_.width = slot_width;
				_tmp58_.height = slot_height;
				target = _tmp58_;
				_tmp59_ = target;
				gala_internal_utils_rect_adjusted (&_tmp59_, 10, 10, -10, -10, &_tmp60_);
				target = _tmp60_;
				_tmp61_ = target;
				_tmp62_ = rect;
				_tmp63_ = target;
				_tmp64_ = rect;
				if ((_tmp61_.width / ((gdouble) _tmp62_.width)) < (_tmp63_.height / ((gdouble) _tmp64_.height))) {
					MtkRectangle _tmp65_;
					MtkRectangle _tmp66_;
					MtkRectangle _tmp67_;
					MtkRectangle _tmp68_;
					MtkRectangle _tmp69_;
					_tmp65_ = target;
					_tmp66_ = rect;
					scale = _tmp65_.width / ((gfloat) _tmp66_.width);
					_tmp67_ = target;
					_tmp68_ = rect;
					target.y = target.y + ((_tmp67_.height - ((gint) (_tmp68_.height * scale))) / 2);
					_tmp69_ = rect;
					target.height = (gint) floorf (_tmp69_.height * scale);
				} else {
					MtkRectangle _tmp70_;
					MtkRectangle _tmp71_;
					MtkRectangle _tmp72_;
					MtkRectangle _tmp73_;
					MtkRectangle _tmp74_;
					_tmp70_ = target;
					_tmp71_ = rect;
					scale = _tmp70_.height / ((gfloat) _tmp71_.height);
					_tmp72_ = target;
					_tmp73_ = rect;
					target.x = target.x + ((_tmp72_.width - ((gint) (_tmp73_.width * scale))) / 2);
					_tmp74_ = rect;
					target.width = (gint) floorf (_tmp74_.width * scale);
				}
				if (((gdouble) scale) > 1.0) {
					MtkRectangle _tmp75_;
					GdkPoint _tmp76_ = {0};
					MtkRectangle _tmp77_;
					MtkRectangle _tmp78_;
					GdkPoint _tmp79_ = {0};
					MtkRectangle _tmp80_;
					MtkRectangle _tmp81_;
					MtkRectangle _tmp82_;
					MtkRectangle _tmp83_ = {0};
					scale = 1.0f;
					_tmp75_ = target;
					gala_internal_utils_rect_center (&_tmp75_, &_tmp76_);
					_tmp77_ = rect;
					_tmp78_ = target;
					gala_internal_utils_rect_center (&_tmp78_, &_tmp79_);
					_tmp80_ = rect;
					_tmp81_ = rect;
					_tmp82_ = rect;
					_tmp83_.x = _tmp76_.x - (((gint) floorf (_tmp77_.width * scale)) / 2);
					_tmp83_.y = _tmp79_.y - (((gint) floorf (_tmp80_.height * scale)) / 2);
					_tmp83_.width = (gint) floorf (scale * _tmp81_.width);
					_tmp83_.height = (gint) floorf (scale * _tmp82_.height);
					target = _tmp83_;
				}
				if (left_over != columns) {
					_tmp84_ = slot >= (columns * (rows - 1));
				} else {
					_tmp84_ = FALSE;
				}
				if (_tmp84_) {
					target.x = target.x + (((columns - left_over) * slot_width) / 2);
				}
				_tmp85_ = target;
				_tmp86_ = window;
				_tmp87_ = (*_tmp86_).id;
				_tmp88_.rect = _tmp85_;
				_tmp88_.id = _tmp87_;
				_tmp89_ = _gala_internal_utils_tilable_window_dup0 (&_tmp88_);
				_result_ = g_list_prepend (_result_, _tmp89_);
				_gala_internal_utils_tilable_window_free0 (window);
			}
		}
	}
	_result_ = g_list_reverse (_result_);
	result = _result_;
	slot_centers = (g_free (slot_centers), NULL);
	taken_slots = (_vala_array_free (taken_slots, taken_slots_length1, (GDestroyNotify) gala_internal_utils_tilable_window_free), NULL);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GSList*
gala_internal_utils_sort_windows (MetaDisplay* display,
                                  GList* windows)
{
	GSList* windows_on_active_workspace = NULL;
	GSList* windows_on_other_workspaces = NULL;
	MetaWorkspace* active_workspace = NULL;
	MetaWorkspaceManager* _tmp0_;
	MetaWorkspace* _tmp1_;
	GSList* sorted_windows = NULL;
	GSList* windows_on_active_workspace_sorted = NULL;
	GSList* _tmp9_;
	GSList* _tmp10_;
	GSList* windows_on_other_workspaces_sorted = NULL;
	GSList* _tmp11_;
	GSList* _tmp12_;
	GSList* _tmp13_;
	GSList* _tmp14_;
	GSList* result;
	g_return_val_if_fail (display != NULL, NULL);
	windows_on_active_workspace = NULL;
	windows_on_other_workspaces = NULL;
	_tmp0_ = meta_display_get_workspace_manager (display);
	_tmp1_ = meta_workspace_manager_get_active_workspace (_tmp0_);
	active_workspace = _tmp1_;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = windows;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp2_;
				MetaWorkspace* _tmp3_;
				MetaWorkspace* _tmp4_;
				_tmp2_ = window;
				_tmp3_ = meta_window_get_workspace (_tmp2_);
				_tmp4_ = active_workspace;
				if (_tmp3_ == _tmp4_) {
					MetaWindow* _tmp5_;
					MetaWindow* _tmp6_;
					_tmp5_ = window;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					windows_on_active_workspace = g_slist_append (windows_on_active_workspace, _tmp6_);
				} else {
					MetaWindow* _tmp7_;
					MetaWindow* _tmp8_;
					_tmp7_ = window;
					_tmp8_ = _g_object_ref0 (_tmp7_);
					windows_on_other_workspaces = g_slist_append (windows_on_other_workspaces, _tmp8_);
				}
			}
		}
	}
	sorted_windows = NULL;
	_tmp9_ = windows_on_active_workspace;
	_tmp10_ = meta_display_sort_windows_by_stacking (display, _tmp9_);
	windows_on_active_workspace_sorted = _tmp10_;
	windows_on_active_workspace_sorted = g_slist_reverse (windows_on_active_workspace_sorted);
	_tmp11_ = windows_on_other_workspaces;
	_tmp12_ = meta_display_sort_windows_by_stacking (display, _tmp11_);
	windows_on_other_workspaces_sorted = _tmp12_;
	windows_on_other_workspaces_sorted = g_slist_reverse (windows_on_other_workspaces_sorted);
	_tmp13_ = windows_on_active_workspace_sorted;
	windows_on_active_workspace_sorted = NULL;
	sorted_windows = g_slist_concat (sorted_windows, _tmp13_);
	_tmp14_ = windows_on_other_workspaces_sorted;
	windows_on_other_workspaces_sorted = NULL;
	sorted_windows = g_slist_concat (sorted_windows, _tmp14_);
	result = sorted_windows;
	(windows_on_other_workspaces_sorted == NULL) ? NULL : (windows_on_other_workspaces_sorted = (g_slist_free (windows_on_other_workspaces_sorted), NULL));
	(windows_on_active_workspace_sorted == NULL) ? NULL : (windows_on_active_workspace_sorted = (g_slist_free (windows_on_active_workspace_sorted), NULL));
	(windows_on_other_workspaces == NULL) ? NULL : (windows_on_other_workspaces = (_g_slist_free__g_object_unref0_ (windows_on_other_workspaces), NULL));
	(windows_on_active_workspace == NULL) ? NULL : (windows_on_active_workspace = (_g_slist_free__g_object_unref0_ (windows_on_active_workspace), NULL));
	return result;
}

inline gboolean
gala_internal_utils_get_window_is_normal (MetaWindow* window)
{
	MetaWindowType _tmp0_;
	MetaWindowType _tmp1_;
	gboolean result;
	g_return_val_if_fail (window != NULL, FALSE);
	_tmp0_ = meta_window_get_window_type (window);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case META_WINDOW_NORMAL:
		case META_WINDOW_DIALOG:
		case META_WINDOW_MODAL_DIALOG:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

/**
         * Returns the workspaces geometry following the only_on_primary settings.
         */
void
gala_internal_utils_get_workspaces_geometry (MetaDisplay* display,
                                             MtkRectangle* result)
{
	g_return_if_fail (display != NULL);
	if (meta_prefs_get_workspaces_only_on_primary ()) {
		MtkRectangle _tmp0_ = {0};
		meta_display_get_monitor_geometry (display, meta_display_get_primary_monitor (display), &_tmp0_);
		*result = _tmp0_;
		return;
	} else {
		gfloat screen_width = 0.0F;
		gfloat screen_height = 0.0F;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		MtkRectangle _tmp3_ = {0};
		meta_display_get_size (display, &_tmp1_, &_tmp2_);
		screen_width = (gfloat) _tmp1_;
		screen_height = (gfloat) _tmp2_;
		_tmp3_.x = 0;
		_tmp3_.y = 0;
		_tmp3_.width = (gint) screen_width;
		_tmp3_.height = (gint) screen_height;
		*result = _tmp3_;
		return;
	}
}

void
gala_internal_utils_actor_box_from_rect (gfloat x,
                                         gfloat y,
                                         gfloat width,
                                         gfloat height,
                                         ClutterActorBox* result)
{
	ClutterActorBox actor_box = {0};
	memset (&actor_box, 0, sizeof (ClutterActorBox));
	clutter_actor_box_init_rect (&actor_box, x, y, width, height);
	clutter_actor_box_clamp_to_pixel (&actor_box);
	*result = actor_box;
	return;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->window);
		(_data2_->callback_target_destroy_notify == NULL) ? NULL : (_data2_->callback_target_destroy_notify (_data2_->callback_target), NULL);
		_data2_->callback = NULL;
		_data2_->callback_target = NULL;
		_data2_->callback_target_destroy_notify = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda15_ (Block2Data* _data2_)
{
	GObject* _tmp0_;
	MetaWindowActor* _tmp1_;
	gboolean result;
	_tmp0_ = meta_window_get_compositor_private (_data2_->window);
	_data2_->window_actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, meta_window_actor_get_type (), MetaWindowActor);
	_tmp1_ = _data2_->window_actor;
	if (_tmp1_ != NULL) {
		MetaWindowActor* _tmp2_;
		_tmp2_ = _data2_->window_actor;
		_data2_->callback (_tmp2_, _data2_->callback_target);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda15_ (self);
	return result;
}

void
gala_internal_utils_wait_for_window_actor (MetaWindow* window,
                                           GalaInternalUtilsWindowActorReadyCallback callback,
                                           gpointer callback_target,
                                           GDestroyNotify callback_target_destroy_notify)
{
	Block2Data* _data2_;
	MetaWindow* _tmp0_;
	GObject* _tmp1_;
	MetaWindowActor* _tmp2_;
	g_return_if_fail (window != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data2_->window);
	_data2_->window = _tmp0_;
	(_data2_->callback_target_destroy_notify == NULL) ? NULL : (_data2_->callback_target_destroy_notify (_data2_->callback_target), NULL);
	_data2_->callback = NULL;
	_data2_->callback_target = NULL;
	_data2_->callback_target_destroy_notify = NULL;
	_data2_->callback = callback;
	_data2_->callback_target = callback_target;
	_data2_->callback_target_destroy_notify = callback_target_destroy_notify;
	_tmp1_ = meta_window_get_compositor_private (_data2_->window);
	_data2_->window_actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, meta_window_actor_get_type (), MetaWindowActor);
	_tmp2_ = _data2_->window_actor;
	if (_tmp2_ != NULL) {
		MetaWindowActor* _tmp3_;
		_tmp3_ = _data2_->window_actor;
		_data2_->callback (_tmp3_, _data2_->callback_target);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda15__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		(_data3_->callback_target_destroy_notify == NULL) ? NULL : (_data3_->callback_target_destroy_notify (_data3_->callback_target), NULL);
		_data3_->callback = NULL;
		_data3_->callback_target = NULL;
		_data3_->callback_target_destroy_notify = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->window_actor);
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda17_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	Block3Data* _data3_;
	_data4_ = _data5_->_data4_;
	_data3_ = _data4_->_data3_;
	g_signal_handler_disconnect ((GObject*) _data4_->window_actor, _data5_->show_handler);
	_data3_->callback (_data4_->window_actor, _data3_->callback_target);
}

static void
____lambda17__clutter_actor_show (ClutterActor* _sender,
                                  gpointer self)
{
	___lambda17_ (self);
}

static void
__lambda16_ (Block3Data* _data3_,
             MetaWindowActor* window_actor)
{
	Block4Data* _data4_;
	MetaWindowActor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (window_actor != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->_data3_ = block3_data_ref (_data3_);
	_tmp0_ = _g_object_ref0 (window_actor);
	_g_object_unref0 (_data4_->window_actor);
	_data4_->window_actor = _tmp0_;
	g_object_get ((ClutterActor*) _data4_->window_actor, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_data3_->callback (_data4_->window_actor, _data3_->callback_target);
	} else {
		Block5Data* _data5_;
		gulong _tmp3_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data4_ = block4_data_ref (_data4_);
		_data5_->show_handler = (gulong) 0;
		_tmp3_ = g_signal_connect_data ((ClutterActor*) _data4_->window_actor, "show", (GCallback) ____lambda17__clutter_actor_show, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		_data5_->show_handler = _tmp3_;
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
___lambda16__gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                              gpointer self)
{
	__lambda16_ (self, window_actor);
}

void
gala_internal_utils_wait_for_window_actor_visible (MetaWindow* window,
                                                   GalaInternalUtilsWindowActorReadyCallback callback,
                                                   gpointer callback_target,
                                                   GDestroyNotify callback_target_destroy_notify)
{
	Block3Data* _data3_;
	g_return_if_fail (window != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	(_data3_->callback_target_destroy_notify == NULL) ? NULL : (_data3_->callback_target_destroy_notify (_data3_->callback_target), NULL);
	_data3_->callback = NULL;
	_data3_->callback_target = NULL;
	_data3_->callback_target_destroy_notify = NULL;
	_data3_->callback = callback;
	_data3_->callback_target = callback_target;
	_data3_->callback_target_destroy_notify = callback_target_destroy_notify;
	gala_internal_utils_wait_for_window_actor (window, ___lambda16__gala_internal_utils_window_actor_ready_callback, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

void
gala_internal_utils_clutter_actor_reparent (ClutterActor* actor,
                                            ClutterActor* new_parent)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (actor != NULL);
	g_return_if_fail (new_parent != NULL);
	if (actor == new_parent) {
		return;
	}
	g_object_ref ((GObject*) actor);
	_tmp0_ = clutter_actor_get_parent (actor);
	clutter_actor_remove_child (_tmp0_, actor);
	clutter_actor_add_child (new_parent, actor);
	g_object_unref ((GObject*) actor);
}

void
gala_internal_utils_bell_notify (MetaDisplay* display)
{
	ClutterBackend* _tmp0_;
	ClutterSeat* _tmp1_;
	g_return_if_fail (display != NULL);
	_tmp0_ = clutter_get_default_backend ();
	_tmp1_ = clutter_backend_get_default_seat (_tmp0_);
	clutter_seat_bell_notify (_tmp1_);
}

gboolean
gala_internal_utils_get_x11_in_fullscreen (MetaDisplay* display)
{
	gint primary_monitor = 0;
	gboolean is_in_fullscreen = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (display != NULL, FALSE);
	primary_monitor = meta_display_get_primary_monitor (display);
	is_in_fullscreen = meta_display_get_monitor_in_fullscreen (display, primary_monitor);
	if (!meta_is_wayland_compositor ()) {
		_tmp0_ = is_in_fullscreen;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

GalaInternalUtils*
gala_internal_utils_construct (GType object_type)
{
	GalaInternalUtils* self = NULL;
	self = (GalaInternalUtils*) g_type_create_instance (object_type);
	return self;
}

GalaInternalUtils*
gala_internal_utils_new (void)
{
	return gala_internal_utils_construct (GALA_TYPE_INTERNAL_UTILS);
}

GalaInternalUtilsTilableWindow*
gala_internal_utils_tilable_window_dup (const GalaInternalUtilsTilableWindow* self)
{
	GalaInternalUtilsTilableWindow* dup;
	dup = g_new0 (GalaInternalUtilsTilableWindow, 1);
	memcpy (dup, self, sizeof (GalaInternalUtilsTilableWindow));
	return dup;
}

void
gala_internal_utils_tilable_window_free (GalaInternalUtilsTilableWindow* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gala_internal_utils_tilable_window_get_type_once (void)
{
	GType gala_internal_utils_tilable_window_type_id;
	gala_internal_utils_tilable_window_type_id = g_boxed_type_register_static ("GalaInternalUtilsTilableWindow", (GBoxedCopyFunc) gala_internal_utils_tilable_window_dup, (GBoxedFreeFunc) gala_internal_utils_tilable_window_free);
	return gala_internal_utils_tilable_window_type_id;
}

GType
gala_internal_utils_tilable_window_get_type (void)
{
	static gsize gala_internal_utils_tilable_window_type_id__once = 0;
	if (g_once_init_enter (&gala_internal_utils_tilable_window_type_id__once)) {
		GType gala_internal_utils_tilable_window_type_id;
		gala_internal_utils_tilable_window_type_id = gala_internal_utils_tilable_window_get_type_once ();
		g_once_init_leave (&gala_internal_utils_tilable_window_type_id__once, gala_internal_utils_tilable_window_type_id);
	}
	return gala_internal_utils_tilable_window_type_id__once;
}

static void
gala_value_internal_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gala_value_internal_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gala_internal_utils_unref (value->data[0].v_pointer);
	}
}

static void
gala_value_internal_utils_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gala_internal_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gala_value_internal_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gala_value_internal_utils_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GalaInternalUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gala_internal_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gala_value_internal_utils_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	GalaInternalUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gala_internal_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gala_param_spec_internal_utils (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	GalaParamSpecInternalUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GALA_TYPE_INTERNAL_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gala_value_get_internal_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_INTERNAL_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
gala_value_set_internal_utils (GValue* value,
                               gpointer v_object)
{
	GalaInternalUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_INTERNAL_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_INTERNAL_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gala_internal_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_internal_utils_unref (old);
	}
}

void
gala_value_take_internal_utils (GValue* value,
                                gpointer v_object)
{
	GalaInternalUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_INTERNAL_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_INTERNAL_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_internal_utils_unref (old);
	}
}

static void
gala_internal_utils_class_init (GalaInternalUtilsClass * klass,
                                gpointer klass_data)
{
	gala_internal_utils_parent_class = g_type_class_peek_parent (klass);
	((GalaInternalUtilsClass *) klass)->finalize = gala_internal_utils_finalize;
}

static void
gala_internal_utils_instance_init (GalaInternalUtils * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
gala_internal_utils_finalize (GalaInternalUtils * obj)
{
	GalaInternalUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_INTERNAL_UTILS, GalaInternalUtils);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
gala_internal_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gala_value_internal_utils_init, gala_value_internal_utils_free_value, gala_value_internal_utils_copy_value, gala_value_internal_utils_peek_pointer, "p", gala_value_internal_utils_collect_value, "p", gala_value_internal_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GalaInternalUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_internal_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaInternalUtils), 0, (GInstanceInitFunc) gala_internal_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gala_internal_utils_type_id;
	gala_internal_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GalaInternalUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gala_internal_utils_type_id;
}

GType
gala_internal_utils_get_type (void)
{
	static gsize gala_internal_utils_type_id__once = 0;
	if (g_once_init_enter (&gala_internal_utils_type_id__once)) {
		GType gala_internal_utils_type_id;
		gala_internal_utils_type_id = gala_internal_utils_get_type_once ();
		g_once_init_leave (&gala_internal_utils_type_id__once, gala_internal_utils_type_id);
	}
	return gala_internal_utils_type_id__once;
}

gpointer
gala_internal_utils_ref (gpointer instance)
{
	GalaInternalUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gala_internal_utils_unref (gpointer instance)
{
	GalaInternalUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GALA_INTERNAL_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

