/* WorkspaceClone.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WorkspaceClone.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <meta/meta-background-group.h>
#include "gala.h"
#include <glib-object.h>
#include <cogl/cogl.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <clutter/clutter.h>
#include <meta/display.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <meta/workspace.h>
#include <meta/window.h>
#include <mtk/mtk.h>
#include <meta/common.h>
#include <meta/meta-monitor-manager.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#define GALA_WORKSPACE_CLONE_BOTTOM_OFFSET 100
#define GALA_WORKSPACE_CLONE_TOP_OFFSET 20
#define GALA_WORKSPACE_CLONE_HOVER_ACTIVATE_DELAY 400
#define GALA_WORKSPACE_ROW_WORKSPACE_GAP 24
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;
typedef struct _GalaBackgroundManagerPrivate GalaBackgroundManagerPrivate;

#define GALA_TYPE_FRAMED_BACKGROUND (gala_framed_background_get_type ())
#define GALA_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground))
#define GALA_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))
#define GALA_IS_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_IS_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_FRAMED_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))

typedef struct _GalaFramedBackground GalaFramedBackground;
typedef struct _GalaFramedBackgroundClass GalaFramedBackgroundClass;
typedef struct _GalaFramedBackgroundPrivate GalaFramedBackgroundPrivate;
enum  {
	GALA_FRAMED_BACKGROUND_0_PROPERTY,
	GALA_FRAMED_BACKGROUND_NUM_PROPERTIES
};
static GParamSpec* gala_framed_background_properties[GALA_FRAMED_BACKGROUND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GALA_TYPE_GESTURE_TARGET (gala_gesture_target_get_type ())
#define GALA_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTarget))
#define GALA_IS_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TARGET))
#define GALA_GESTURE_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTargetIface))

typedef struct _GalaGestureTarget GalaGestureTarget;
typedef struct _GalaGestureTargetIface GalaGestureTargetIface;
typedef enum  {
	GALA_GESTURE_TARGET_UPDATE_TYPE_START,
	GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE,
	GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT,
	GALA_GESTURE_TARGET_UPDATE_TYPE_END
} GalaGestureTargetUpdateType;

#define GALA_GESTURE_TARGET_TYPE_UPDATE_TYPE (gala_gesture_target_update_type_get_type ())

#define GALA_TYPE_ACTOR_TARGET (gala_actor_target_get_type ())
#define GALA_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTarget))
#define GALA_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))
#define GALA_IS_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACTOR_TARGET))
#define GALA_IS_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ACTOR_TARGET))
#define GALA_ACTOR_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))

typedef struct _GalaActorTarget GalaActorTarget;
typedef struct _GalaActorTargetClass GalaActorTargetClass;
typedef struct _GalaActorTargetPrivate GalaActorTargetPrivate;

#define GALA_TYPE_WORKSPACE_CLONE (gala_workspace_clone_get_type ())
#define GALA_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone))
#define GALA_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))
#define GALA_IS_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_IS_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_WORKSPACE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))

typedef struct _GalaWorkspaceClone GalaWorkspaceClone;
typedef struct _GalaWorkspaceCloneClass GalaWorkspaceCloneClass;
typedef struct _GalaWorkspaceClonePrivate GalaWorkspaceClonePrivate;

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;
enum  {
	GALA_WORKSPACE_CLONE_0_PROPERTY,
	GALA_WORKSPACE_CLONE_WM_PROPERTY,
	GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY,
	GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY,
	GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY,
	GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY,
	GALA_WORKSPACE_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_NUM_PROPERTIES];

#define GALA_TYPE_STATIC_WINDOW_CONTAINER (gala_static_window_container_get_type ())
#define GALA_STATIC_WINDOW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_STATIC_WINDOW_CONTAINER, GalaStaticWindowContainer))
#define GALA_STATIC_WINDOW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_STATIC_WINDOW_CONTAINER, GalaStaticWindowContainerClass))
#define GALA_IS_STATIC_WINDOW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_STATIC_WINDOW_CONTAINER))
#define GALA_IS_STATIC_WINDOW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_STATIC_WINDOW_CONTAINER))
#define GALA_STATIC_WINDOW_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_STATIC_WINDOW_CONTAINER, GalaStaticWindowContainerClass))

typedef struct _GalaStaticWindowContainer GalaStaticWindowContainer;
typedef struct _GalaStaticWindowContainerClass GalaStaticWindowContainerClass;

#define GALA_TYPE_WINDOW_CLONE (gala_window_clone_get_type ())
#define GALA_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowClone))
#define GALA_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))
#define GALA_IS_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE))
#define GALA_IS_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE))
#define GALA_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))

typedef struct _GalaWindowClone GalaWindowClone;
typedef struct _GalaWindowCloneClass GalaWindowCloneClass;

#define GALA_TYPE_PROPERTY_TARGET (gala_property_target_get_type ())
#define GALA_PROPERTY_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PROPERTY_TARGET, GalaPropertyTarget))
#define GALA_PROPERTY_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PROPERTY_TARGET, GalaPropertyTargetClass))
#define GALA_IS_PROPERTY_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PROPERTY_TARGET))
#define GALA_IS_PROPERTY_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PROPERTY_TARGET))
#define GALA_PROPERTY_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PROPERTY_TARGET, GalaPropertyTargetClass))

typedef struct _GalaPropertyTarget GalaPropertyTarget;
typedef struct _GalaPropertyTargetClass GalaPropertyTargetClass;
enum  {
	GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL,
	GALA_WORKSPACE_CLONE_NUM_SIGNALS
};
static guint gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_NUM_SIGNALS] = {0};

struct _GalaBackgroundManager {
	MetaBackgroundGroup parent_instance;
	GalaBackgroundManagerPrivate * priv;
};

struct _GalaBackgroundManagerClass {
	MetaBackgroundGroupClass parent_class;
};

struct _GalaFramedBackground {
	GalaBackgroundManager parent_instance;
	GalaFramedBackgroundPrivate * priv;
};

struct _GalaFramedBackgroundClass {
	GalaBackgroundManagerClass parent_class;
};

struct _GalaFramedBackgroundPrivate {
	CoglPipeline* pipeline;
	cairo_surface_t* cached_surface;
	cairo_t* cached_context;
	CoglTexture2D* cached_texture;
	gint last_width;
	gint last_height;
};

struct _GalaGestureTargetIface {
	GTypeInterface parent_iface;
	void (*propagate) (GalaGestureTarget* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	ClutterActor* (*get_actor) (GalaGestureTarget* self);
};

struct _GalaActorTarget {
	ClutterActor parent_instance;
	GalaActorTargetPrivate * priv;
};

struct _GalaActorTargetClass {
	ClutterActorClass parent_class;
	void (*start_progress) (GalaActorTarget* self, GalaGestureAction action);
	void (*update_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble progress);
	void (*commit_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble to);
	void (*end_progress) (GalaActorTarget* self, GalaGestureAction action);
};

struct _GalaWorkspaceClone {
	GalaActorTarget parent_instance;
	GalaWorkspaceClonePrivate * priv;
};

struct _GalaWorkspaceCloneClass {
	GalaActorTargetClass parent_class;
};

struct _GalaWorkspaceClonePrivate {
	GalaWindowManager* _wm;
	MetaWorkspace* _workspace;
	gfloat _monitor_scale;
	GalaIconGroup* _icon_group;
	GalaWindowCloneContainer* _window_container;
	GalaBackgroundManager* background;
	gboolean opened;
	guint hover_activate_timeout;
};

static gint GalaFramedBackground_private_offset;
static gpointer gala_framed_background_parent_class = NULL;
static gint GalaWorkspaceClone_private_offset;
static gpointer gala_workspace_clone_parent_class = NULL;

VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
 G_GNUC_INTERNAL GType gala_framed_background_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaFramedBackground, g_object_unref)
 G_GNUC_INTERNAL GalaFramedBackground* gala_framed_background_new (MetaDisplay* display);
 G_GNUC_INTERNAL GalaFramedBackground* gala_framed_background_construct (GType object_type,
                                                        MetaDisplay* display);
static void gala_framed_background_real_paint (ClutterActor* base,
                                        ClutterPaintContext* context);
static GObject * gala_framed_background_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN MetaDisplay* gala_background_manager_get_display (GalaBackgroundManager* self);
static void gala_framed_background_finalize (GObject * obj);
static GType gala_framed_background_get_type_once (void);
VALA_EXTERN GType gala_gesture_target_update_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_gesture_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTarget, g_object_unref)
VALA_EXTERN GType gala_actor_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaActorTarget, g_object_unref)
VALA_EXTERN GType gala_workspace_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceClone, g_object_unref)
VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
VALA_EXTERN void gala_actor_target_update_progress (GalaActorTarget* self,
                                        GalaGestureAction action,
                                        gdouble progress);
VALA_EXTERN MetaWorkspace* gala_workspace_clone_get_workspace (GalaWorkspaceClone* self);
static void gala_workspace_clone_window_entered_monitor (GalaWorkspaceClone* self,
                                                  MetaDisplay* display,
                                                  gint monitor,
                                                  MetaWindow* window);
static void _gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                       gint object,
                                                                                       MetaWindow* p0,
                                                                                       gpointer self);
static void gala_workspace_clone_window_left_monitor (GalaWorkspaceClone* self,
                                               MetaDisplay* display,
                                               gint monitor,
                                               MetaWindow* window);
static void _gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                                 gint object,
                                                                                 MetaWindow* p0,
                                                                                 gpointer self);
static void gala_workspace_clone_add_window (GalaWorkspaceClone* self,
                                      MetaWindow* window);
static void _gala_workspace_clone_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self);
static void gala_workspace_clone_remove_window (GalaWorkspaceClone* self,
                                         MetaWindow* window);
static void _gala_workspace_clone_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                        MetaWindow* object,
                                                                        gpointer self);
VALA_EXTERN GalaWindowCloneContainer* gala_workspace_clone_get_window_container (GalaWorkspaceClone* self);
VALA_EXTERN GalaIconGroup* gala_workspace_clone_get_icon_group (GalaWorkspaceClone* self);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_new (GalaWindowManager* wm,
                                              MetaWorkspace* workspace,
                                              gfloat monitor_scale);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_construct (GType object_type,
                                                    GalaWindowManager* wm,
                                                    MetaWorkspace* workspace,
                                                    gfloat monitor_scale);
VALA_EXTERN GType gala_static_window_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaStaticWindowContainer, g_object_unref)
VALA_EXTERN GalaStaticWindowContainer* gala_static_window_container_get_instance (MetaDisplay* display);
VALA_EXTERN gboolean gala_static_window_container_is_static (GalaStaticWindowContainer* self,
                                                 MetaWindow* window);
VALA_EXTERN GType gala_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowClone, g_object_unref)
VALA_EXTERN MetaWindow* gala_window_clone_get_window (GalaWindowClone* self);
VALA_EXTERN void gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                             MetaWindow* window);
VALA_EXTERN void gala_icon_group_add_window (GalaIconGroup* self,
                                 MetaWindow* window,
                                 gboolean no_redraw,
                                 gboolean temporary);
VALA_EXTERN void gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                                MetaWindow* window);
VALA_EXTERN void gala_icon_group_remove_window (GalaIconGroup* self,
                                    MetaWindow* window,
                                    gboolean animate);
static void gala_workspace_clone_on_window_static_changed (GalaWorkspaceClone* self,
                                                    MetaWindow* window,
                                                    gboolean is_static);
VALA_EXTERN void gala_workspace_clone_update_size (GalaWorkspaceClone* self,
                                       MtkRectangle* monitor_geometry);
VALA_EXTERN void gala_background_manager_set_size (GalaBackgroundManager* self,
                                       gfloat width,
                                       gfloat height);
static void gala_workspace_clone_update_targets (GalaWorkspaceClone* self);
VALA_EXTERN void gala_actor_target_remove_all_targets (GalaActorTarget* self);
VALA_EXTERN gfloat gala_workspace_clone_get_monitor_scale (GalaWorkspaceClone* self);
VALA_EXTERN void gala_actor_target_add_target (GalaActorTarget* self,
                                   GalaGestureTarget* target);
VALA_EXTERN GalaPropertyTarget* gala_property_target_new (GalaGestureAction action,
                                              ClutterActor* actor,
                                              const gchar* property,
                                              GType value_type,
                                              GValue* from_value,
                                              GValue* to_value);
VALA_EXTERN GalaPropertyTarget* gala_property_target_construct (GType object_type,
                                                    GalaGestureAction action,
                                                    ClutterActor* actor,
                                                    const gchar* property,
                                                    GType value_type,
                                                    GValue* from_value,
                                                    GValue* to_value);
VALA_EXTERN GType gala_property_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPropertyTarget, g_object_unref)
VALA_EXTERN void gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                                  gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                                    gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                                   gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                     gint value);
static void gala_workspace_clone_real_update_progress (GalaActorTarget* base,
                                                GalaGestureAction action,
                                                gdouble progress);
VALA_EXTERN void gala_icon_group_set_backdrop_opacity (GalaIconGroup* self,
                                           gfloat value);
static void gala_workspace_clone_activate (GalaWorkspaceClone* self,
                                    gboolean close_view);
VALA_EXTERN GalaWindowManager* gala_workspace_clone_get_wm (GalaWorkspaceClone* self);
static void gala_workspace_clone_set_wm (GalaWorkspaceClone* self,
                                  GalaWindowManager* value);
static void gala_workspace_clone_set_workspace (GalaWorkspaceClone* self,
                                         MetaWorkspace* value);
VALA_EXTERN void gala_workspace_clone_set_monitor_scale (GalaWorkspaceClone* self,
                                             gfloat value);
static void gala_workspace_clone_set_icon_group (GalaWorkspaceClone* self,
                                          GalaIconGroup* value);
static void gala_workspace_clone_set_window_container (GalaWorkspaceClone* self,
                                                GalaWindowCloneContainer* value);
static GObject * gala_workspace_clone_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _gala_workspace_clone___lambda68_ (GalaWorkspaceClone* self);
static void __gala_workspace_clone___lambda68__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                      ClutterActor* actor,
                                                                      gpointer self);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           gfloat monitor_scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 gfloat monitor_scale,
                                                                 gboolean overview_mode);
static void _gala_workspace_clone___lambda69_ (GalaWorkspaceClone* self,
                                        MetaWindow* w);
static void __gala_workspace_clone___lambda69__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                     MetaWindow* window,
                                                                                     gpointer self);
static void _gala_workspace_clone___lambda70_ (GalaWorkspaceClone* self);
static void __gala_workspace_clone___lambda70__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                                                     gpointer self);
VALA_EXTERN GalaIconGroup* gala_icon_group_new (MetaDisplay* display,
                                    MetaWorkspace* workspace,
                                    gfloat scale);
VALA_EXTERN GalaIconGroup* gala_icon_group_construct (GType object_type,
                                          MetaDisplay* display,
                                          MetaWorkspace* workspace,
                                          gfloat scale);
static void _gala_workspace_clone___lambda71_ (GalaWorkspaceClone* self);
static void __gala_workspace_clone___lambda71__gala_icon_group_selected (GalaIconGroup* _sender,
                                                                  gpointer self);
static void _gala_workspace_clone___lambda72_ (GalaWorkspaceClone* self,
                                        ClutterActor* target,
                                        gboolean hovered);
static gboolean ___lambda73_ (GalaWorkspaceClone* self);
static gboolean ____lambda73__gsource_func (gpointer self);
static void __gala_workspace_clone___lambda72__gala_drag_drop_action_crossed (GalaDragDropAction* _sender,
                                                                       ClutterActor* target,
                                                                       gboolean hovered,
                                                                       gpointer self);
static void _gala_workspace_clone_on_window_static_changed_gala_static_window_container_window_changed (GalaStaticWindowContainer* _sender,
                                                                                                 MetaWindow* window,
                                                                                                 gboolean is_static,
                                                                                                 gpointer self);
static void _gala_workspace_clone_update_targets_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                 gpointer self);
static void _gala_workspace_clone_update_targets_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void gala_workspace_clone_finalize (GObject * obj);
static GType gala_workspace_clone_get_type_once (void);
static void _vala_gala_workspace_clone_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_workspace_clone_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
gala_framed_background_get_instance_private (GalaFramedBackground* self)
{
	return G_STRUCT_MEMBER_P (self, GalaFramedBackground_private_offset);
}

 G_GNUC_INTERNAL GalaFramedBackground*
gala_framed_background_construct (GType object_type,
                                  MetaDisplay* display)
{
	GalaFramedBackground * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaFramedBackground*) g_object_new (object_type, "display", display, "monitor-index", meta_display_get_primary_monitor (display), "control-position", FALSE, "rounded-corners", TRUE, NULL);
	return self;
}

 G_GNUC_INTERNAL GalaFramedBackground*
gala_framed_background_new (MetaDisplay* display)
{
	return gala_framed_background_construct (GALA_TYPE_FRAMED_BACKGROUND, display);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_framed_background_real_paint (ClutterActor* base,
                                   ClutterPaintContext* context)
{
	GalaFramedBackground * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp18_;
	cairo_surface_t* _tmp19_;
	cairo_t* ctx = NULL;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	gfloat _tmp24_;
	gfloat _tmp25_;
	gfloat _tmp26_;
	gfloat _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	CoglColor color = {0};
	CoglPipeline* _tmp49_;
	CoglColor _tmp50_;
	CoglFramebuffer* fb = NULL;
	CoglFramebuffer* _tmp51_;
	CoglPipeline* _tmp52_;
	gfloat _tmp53_;
	gfloat _tmp54_;
	gfloat _tmp55_;
	gfloat _tmp56_;
	GError* _inner_error0_ = NULL;
	self = (GalaFramedBackground*) base;
	g_return_if_fail (context != NULL);
	CLUTTER_ACTOR_CLASS (gala_framed_background_parent_class)->paint ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager), context);
	_tmp2_ = self->priv->cached_surface;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		gfloat _tmp3_;
		gfloat _tmp4_;
		_tmp3_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp4_ = _tmp3_;
		_tmp1_ = self->priv->last_width != ((gint) _tmp4_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gfloat _tmp5_;
		gfloat _tmp6_;
		_tmp5_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp6_ = _tmp5_;
		_tmp0_ = self->priv->last_height != ((gint) _tmp6_);
	}
	if (_tmp0_) {
		gfloat _tmp7_;
		gfloat _tmp8_;
		gfloat _tmp9_;
		gfloat _tmp10_;
		cairo_surface_t* _tmp11_;
		cairo_surface_t* _tmp12_;
		cairo_t* _tmp13_;
		gfloat _tmp14_;
		gfloat _tmp15_;
		gfloat _tmp16_;
		gfloat _tmp17_;
		_g_object_unref0 (self->priv->cached_texture);
		self->priv->cached_texture = NULL;
		_tmp7_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) _tmp8_, (gint) _tmp10_);
		_cairo_surface_destroy0 (self->priv->cached_surface);
		self->priv->cached_surface = _tmp11_;
		_tmp12_ = self->priv->cached_surface;
		_tmp13_ = cairo_create (_tmp12_);
		_cairo_destroy0 (self->priv->cached_context);
		self->priv->cached_context = _tmp13_;
		_tmp14_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp15_ = _tmp14_;
		self->priv->last_width = (gint) _tmp15_;
		_tmp16_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp17_ = _tmp16_;
		self->priv->last_height = (gint) _tmp17_;
	}
	_tmp18_ = self->priv->cached_surface;
	_tmp19_ = _cairo_surface_reference0 (_tmp18_);
	surface = _tmp19_;
	_tmp20_ = self->priv->cached_context;
	_tmp21_ = _cairo_reference0 (_tmp20_);
	ctx = _tmp21_;
	_tmp22_ = ctx;
	cairo_set_source_rgba (_tmp22_, (gdouble) 255, (gdouble) 255, (gdouble) 255, (gdouble) 255);
	_tmp23_ = ctx;
	_tmp24_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp27_ = _tmp26_;
	gala_drawing_utilities_cairo_rounded_rectangle (_tmp23_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp25_, (gdouble) _tmp27_, (gdouble) 9);
	_tmp28_ = ctx;
	cairo_set_operator (_tmp28_, CAIRO_OPERATOR_SOURCE);
	_tmp29_ = ctx;
	cairo_stroke (_tmp29_);
	_tmp30_ = ctx;
	cairo_restore (_tmp30_);
	_tmp31_ = ctx;
	cairo_paint (_tmp31_);
	{
		CoglTexture2D* _tmp32_;
		_tmp32_ = self->priv->cached_texture;
		if (_tmp32_ == NULL) {
			CoglTexture2D* texture = NULL;
			CoglFramebuffer* _tmp33_;
			CoglContext* _tmp34_;
			gfloat _tmp35_;
			gfloat _tmp36_;
			gfloat _tmp37_;
			gfloat _tmp38_;
			cairo_surface_t* _tmp39_;
			cairo_surface_t* _tmp40_;
			guchar* _tmp41_;
			CoglTexture2D* _tmp42_;
			CoglPipeline* _tmp43_;
			CoglTexture2D* _tmp44_;
			CoglTexture2D* _tmp45_;
			CoglTexture2D* _tmp46_;
			_tmp33_ = clutter_paint_context_get_framebuffer (context);
			_tmp34_ = cogl_framebuffer_get_context (_tmp33_);
			_tmp35_ = clutter_actor_get_width ((ClutterActor*) self);
			_tmp36_ = _tmp35_;
			_tmp37_ = clutter_actor_get_height ((ClutterActor*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = surface;
			_tmp40_ = surface;
			_tmp41_ = cairo_image_surface_get_data (_tmp40_);
			_tmp42_ = (CoglTexture2D*) cogl_texture_2d_new_from_data (_tmp34_, (gint) _tmp36_, (gint) _tmp38_, COGL_PIXEL_FORMAT_BGRA_8888_PRE, cairo_image_surface_get_stride (_tmp39_), _tmp41_, &_inner_error0_);
			texture = _tmp42_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp43_ = self->priv->pipeline;
			_tmp44_ = texture;
			cogl_pipeline_set_layer_texture (_tmp43_, 0, (CoglTexture*) _tmp44_);
			_tmp45_ = texture;
			_tmp46_ = _g_object_ref0 (_tmp45_);
			_g_object_unref0 (self->priv->cached_texture);
			self->priv->cached_texture = _tmp46_;
			_g_object_unref0 (texture);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp47_;
		const gchar* _tmp48_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		g_debug ("WorkspaceClone.vala:86: %s", _tmp48_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cairo_destroy0 (ctx);
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	cogl_color_init_from_4f (&color, 1.0f, 1.0f, 1.0f, 25.0f / 255.0f);
	cogl_color_premultiply (&color);
	_tmp49_ = self->priv->pipeline;
	_tmp50_ = color;
	cogl_pipeline_set_color (_tmp49_, &_tmp50_);
	_tmp51_ = clutter_paint_context_get_framebuffer (context);
	fb = _tmp51_;
	_tmp52_ = self->priv->pipeline;
	_tmp53_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp56_ = _tmp55_;
	cogl_framebuffer_draw_rectangle (fb, _tmp52_, (gfloat) 0, (gfloat) 0, _tmp54_, _tmp56_);
	_cairo_destroy0 (ctx);
	_cairo_surface_destroy0 (surface);
}

static GObject *
gala_framed_background_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaFramedBackground * self;
	CoglContext* ctx = NULL;
	ClutterBackend* _tmp0_;
	CoglContext* _tmp1_;
	CoglContext* _tmp2_;
	CoglPipeline* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaDisplay* _tmp5_;
	MetaDisplay* _tmp6_;
	MetaDisplay* _tmp7_;
	GalaShadowEffect* _tmp8_;
	GalaShadowEffect* _tmp9_;
	parent_class = G_OBJECT_CLASS (gala_framed_background_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground);
	_tmp0_ = clutter_get_default_backend ();
	_tmp1_ = clutter_backend_get_cogl_context (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = ctx;
	_tmp3_ = cogl_pipeline_new (_tmp2_);
	_g_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp3_;
	_tmp4_ = gala_background_manager_get_display ((GalaBackgroundManager*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gala_background_manager_get_display ((GalaBackgroundManager*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = gala_shadow_effect_new ("workspace", meta_display_get_monitor_scale (_tmp5_, meta_display_get_primary_monitor (_tmp7_)));
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	return obj;
}

static void
gala_framed_background_class_init (GalaFramedBackgroundClass * klass,
                                   gpointer klass_data)
{
	gala_framed_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaFramedBackground_private_offset);
	((ClutterActorClass *) klass)->paint = (void (*) (ClutterActor*, ClutterPaintContext*)) gala_framed_background_real_paint;
	G_OBJECT_CLASS (klass)->constructor = gala_framed_background_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_framed_background_finalize;
}

static void
gala_framed_background_instance_init (GalaFramedBackground * self,
                                      gpointer klass)
{
	self->priv = gala_framed_background_get_instance_private (self);
}

static void
gala_framed_background_finalize (GObject * obj)
{
	GalaFramedBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground);
	_g_object_unref0 (self->priv->pipeline);
	_cairo_surface_destroy0 (self->priv->cached_surface);
	_cairo_destroy0 (self->priv->cached_context);
	_g_object_unref0 (self->priv->cached_texture);
	G_OBJECT_CLASS (gala_framed_background_parent_class)->finalize (obj);
}

/**
 * Utility class which adds a border and a shadow to a Background
 */
 G_GNUC_NO_INLINE static GType
gala_framed_background_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaFramedBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_framed_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaFramedBackground), 0, (GInstanceInitFunc) gala_framed_background_instance_init, NULL };
	GType gala_framed_background_type_id;
	gala_framed_background_type_id = g_type_register_static (GALA_TYPE_BACKGROUND_MANAGER, "GalaFramedBackground", &g_define_type_info, 0);
	GalaFramedBackground_private_offset = g_type_add_instance_private (gala_framed_background_type_id, sizeof (GalaFramedBackgroundPrivate));
	return gala_framed_background_type_id;
}

 G_GNUC_INTERNAL GType
gala_framed_background_get_type (void)
{
	static gsize gala_framed_background_type_id__once = 0;
	if (g_once_init_enter (&gala_framed_background_type_id__once)) {
		GType gala_framed_background_type_id;
		gala_framed_background_type_id = gala_framed_background_get_type_once ();
		g_once_init_leave (&gala_framed_background_type_id__once, gala_framed_background_type_id);
	}
	return gala_framed_background_type_id__once;
}

static inline gpointer
gala_workspace_clone_get_instance_private (GalaWorkspaceClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWorkspaceClone_private_offset);
}

static void
_gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                  gint object,
                                                                                  MetaWindow* p0,
                                                                                  gpointer self)
{
	gala_workspace_clone_window_entered_monitor ((GalaWorkspaceClone*) self, _sender, object, p0);
}

static void
_gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                            gint object,
                                                                            MetaWindow* p0,
                                                                            gpointer self)
{
	gala_workspace_clone_window_left_monitor ((GalaWorkspaceClone*) self, _sender, object, p0);
}

static void
_gala_workspace_clone_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                              MetaWindow* object,
                                                              gpointer self)
{
	gala_workspace_clone_add_window ((GalaWorkspaceClone*) self, object);
}

static void
_gala_workspace_clone_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self)
{
	gala_workspace_clone_remove_window ((GalaWorkspaceClone*) self, object);
}

GalaWorkspaceClone*
gala_workspace_clone_construct (GType object_type,
                                GalaWindowManager* wm,
                                MetaWorkspace* workspace,
                                gfloat monitor_scale)
{
	GalaWorkspaceClone * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (workspace != NULL, NULL);
	self = (GalaWorkspaceClone*) g_object_new (object_type, "wm", wm, "workspace", workspace, "monitor-scale", monitor_scale, NULL);
	return self;
}

GalaWorkspaceClone*
gala_workspace_clone_new (GalaWindowManager* wm,
                          MetaWorkspace* workspace,
                          gfloat monitor_scale)
{
	return gala_workspace_clone_construct (GALA_TYPE_WORKSPACE_CLONE, wm, workspace, monitor_scale);
}

/**
     * Add a window to the WindowCloneContainer and the IconGroup if it really
     * belongs to this workspace and this monitor.
     */
static void
gala_workspace_clone_add_window (GalaWorkspaceClone* self,
                                 MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	MetaWindowType _tmp3_;
	MetaWindowType _tmp4_;
	GalaWindowCloneContainer* _tmp11_;
	GList* _tmp12_;
	GalaWindowCloneContainer* _tmp16_;
	GalaIconGroup* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp3_ = meta_window_get_window_type (window);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != META_WINDOW_NORMAL) {
		_tmp2_ = TRUE;
	} else {
		MetaWorkspace* _tmp5_;
		MetaWorkspace* _tmp6_;
		_tmp5_ = meta_window_get_workspace (window);
		_tmp6_ = self->priv->_workspace;
		_tmp2_ = _tmp5_ != _tmp6_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		MetaWorkspace* _tmp7_;
		MetaDisplay* _tmp8_;
		GalaStaticWindowContainer* _tmp9_;
		GalaStaticWindowContainer* _tmp10_;
		_tmp7_ = self->priv->_workspace;
		_tmp8_ = meta_workspace_get_display (_tmp7_);
		_tmp9_ = gala_static_window_container_get_instance (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp1_ = gala_static_window_container_is_static (_tmp10_, window);
		_g_object_unref0 (_tmp10_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !meta_window_is_on_primary_monitor (window);
	}
	if (_tmp0_) {
		return;
	}
	_tmp11_ = self->priv->_window_container;
	_tmp12_ = clutter_actor_get_children ((ClutterActor*) _tmp11_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp12_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp13_;
				MetaWindow* _tmp14_;
				MetaWindow* _tmp15_;
				_tmp13_ = child;
				_tmp14_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
				_tmp15_ = _tmp14_;
				if (_tmp15_ == window) {
					(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
					return;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp16_ = self->priv->_window_container;
	gala_window_clone_container_add_window (_tmp16_, window);
	_tmp17_ = self->priv->_icon_group;
	gala_icon_group_add_window (_tmp17_, window, FALSE, FALSE);
}

/**
     * Remove a window from the WindowCloneContainer and the IconGroup
     */
static void
gala_workspace_clone_remove_window (GalaWorkspaceClone* self,
                                    MetaWindow* window)
{
	GalaWindowCloneContainer* _tmp0_;
	GalaIconGroup* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_window_container;
	gala_window_clone_container_remove_window (_tmp0_, window);
	_tmp1_ = self->priv->_icon_group;
	gala_icon_group_remove_window (_tmp1_, window, self->priv->opened);
}

static void
gala_workspace_clone_window_entered_monitor (GalaWorkspaceClone* self,
                                             MetaDisplay* display,
                                             gint monitor,
                                             MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (window != NULL);
	gala_workspace_clone_add_window (self, window);
}

static void
gala_workspace_clone_window_left_monitor (GalaWorkspaceClone* self,
                                          MetaDisplay* display,
                                          gint monitor,
                                          MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (window != NULL);
	if (monitor == meta_display_get_primary_monitor (display)) {
		gala_workspace_clone_remove_window (self, window);
	}
}

static void
gala_workspace_clone_on_window_static_changed (GalaWorkspaceClone* self,
                                               MetaWindow* window,
                                               gboolean is_static)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (is_static) {
		gala_workspace_clone_remove_window (self, window);
	} else {
		gala_workspace_clone_add_window (self, window);
	}
}

void
gala_workspace_clone_update_size (GalaWorkspaceClone* self,
                                  MtkRectangle* monitor_geometry)
{
	gboolean _tmp0_ = FALSE;
	GalaWindowCloneContainer* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	MtkRectangle _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor_geometry != NULL);
	_tmp1_ = self->priv->_window_container;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = *monitor_geometry;
	if (_tmp3_ != ((gfloat) _tmp4_.width)) {
		_tmp0_ = TRUE;
	} else {
		GalaWindowCloneContainer* _tmp5_;
		gfloat _tmp6_;
		gfloat _tmp7_;
		MtkRectangle _tmp8_;
		_tmp5_ = self->priv->_window_container;
		_tmp6_ = clutter_actor_get_height ((ClutterActor*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = *monitor_geometry;
		_tmp0_ = _tmp7_ != ((gfloat) _tmp8_.height);
	}
	if (_tmp0_) {
		GalaWindowCloneContainer* _tmp9_;
		MtkRectangle _tmp10_;
		MtkRectangle _tmp11_;
		GalaBackgroundManager* _tmp12_;
		GalaWindowCloneContainer* _tmp13_;
		gfloat _tmp14_;
		gfloat _tmp15_;
		GalaWindowCloneContainer* _tmp16_;
		gfloat _tmp17_;
		gfloat _tmp18_;
		_tmp9_ = self->priv->_window_container;
		_tmp10_ = *monitor_geometry;
		_tmp11_ = *monitor_geometry;
		clutter_actor_set_size ((ClutterActor*) _tmp9_, (gfloat) _tmp10_.width, (gfloat) _tmp11_.height);
		_tmp12_ = self->priv->background;
		_tmp13_ = self->priv->_window_container;
		_tmp14_ = clutter_actor_get_width ((ClutterActor*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->_window_container;
		_tmp17_ = clutter_actor_get_height ((ClutterActor*) _tmp16_);
		_tmp18_ = _tmp17_;
		gala_background_manager_set_size (_tmp12_, _tmp15_, _tmp18_);
	}
}

static void
gala_workspace_clone_update_targets (GalaWorkspaceClone* self)
{
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MtkRectangle monitor = {0};
	MtkRectangle _tmp2_ = {0};
	gfloat scale = 0.0F;
	MtkRectangle _tmp3_;
	gfloat _tmp4_;
	MtkRectangle _tmp5_;
	gfloat pivot_y = 0.0F;
	gfloat _tmp6_;
	MtkRectangle _tmp7_;
	MtkRectangle _tmp8_;
	GalaBackgroundManager* _tmp9_;
	gint initial_width = 0;
	MtkRectangle _tmp10_;
	gfloat target_width = 0.0F;
	MtkRectangle _tmp11_;
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	GalaPropertyTarget* _tmp14_;
	GalaPropertyTarget* _tmp15_;
	GalaBackgroundManager* _tmp16_;
	GValue _tmp17_ = {0};
	GValue _tmp18_ = {0};
	GalaPropertyTarget* _tmp19_;
	GalaPropertyTarget* _tmp20_;
	GalaBackgroundManager* _tmp21_;
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	GalaPropertyTarget* _tmp24_;
	GalaPropertyTarget* _tmp25_;
	GalaWindowCloneContainer* _tmp26_;
	gfloat _tmp27_;
	GalaWindowCloneContainer* _tmp28_;
	GalaWindowCloneContainer* _tmp29_;
	MtkRectangle _tmp30_;
	MtkRectangle _tmp31_;
	GalaWindowCloneContainer* _tmp32_;
	gfloat _tmp33_;
	g_return_if_fail (self != NULL);
	gala_actor_target_remove_all_targets ((GalaActorTarget*) self);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	display = _tmp1_;
	meta_display_get_monitor_geometry (display, meta_display_get_primary_monitor (display), &_tmp2_);
	monitor = _tmp2_;
	_tmp3_ = monitor;
	_tmp4_ = self->priv->_monitor_scale;
	_tmp5_ = monitor;
	scale = ((gfloat) (_tmp3_.height - gala_utils_scale_to_int (GALA_WORKSPACE_CLONE_TOP_OFFSET + GALA_WORKSPACE_CLONE_BOTTOM_OFFSET, _tmp4_))) / _tmp5_.height;
	_tmp6_ = self->priv->_monitor_scale;
	_tmp7_ = monitor;
	_tmp8_ = monitor;
	pivot_y = gala_utils_scale_to_int (GALA_WORKSPACE_CLONE_TOP_OFFSET, _tmp6_) / (_tmp7_.height - (_tmp8_.height * scale));
	_tmp9_ = self->priv->background;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp9_, 0.5f, pivot_y);
	_tmp10_ = monitor;
	initial_width = _tmp10_.width;
	_tmp11_ = monitor;
	target_width = (_tmp11_.width * scale) + (GALA_WORKSPACE_ROW_WORKSPACE_GAP * 2);
	g_value_init (&_tmp12_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp12_, (gfloat) initial_width);
	g_value_init (&_tmp13_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp13_, (gfloat) target_width);
	_tmp14_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (ClutterActor*) self, "width", G_TYPE_FLOAT, &_tmp12_, &_tmp13_);
	_tmp15_ = _tmp14_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	G_IS_VALUE (&_tmp13_) ? (g_value_unset (&_tmp13_), NULL) : NULL;
	G_IS_VALUE (&_tmp12_) ? (g_value_unset (&_tmp12_), NULL) : NULL;
	_tmp16_ = self->priv->background;
	g_value_init (&_tmp17_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp17_, 1.);
	g_value_init (&_tmp18_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp18_, (gdouble) scale);
	_tmp19_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (ClutterActor*) _tmp16_, "scale-x", G_TYPE_DOUBLE, &_tmp17_, &_tmp18_);
	_tmp20_ = _tmp19_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp20_);
	_g_object_unref0 (_tmp20_);
	G_IS_VALUE (&_tmp18_) ? (g_value_unset (&_tmp18_), NULL) : NULL;
	G_IS_VALUE (&_tmp17_) ? (g_value_unset (&_tmp17_), NULL) : NULL;
	_tmp21_ = self->priv->background;
	g_value_init (&_tmp22_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp22_, 1.);
	g_value_init (&_tmp23_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp23_, (gdouble) scale);
	_tmp24_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (ClutterActor*) _tmp21_, "scale-y", G_TYPE_DOUBLE, &_tmp22_, &_tmp23_);
	_tmp25_ = _tmp24_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp25_);
	_g_object_unref0 (_tmp25_);
	G_IS_VALUE (&_tmp23_) ? (g_value_unset (&_tmp23_), NULL) : NULL;
	G_IS_VALUE (&_tmp22_) ? (g_value_unset (&_tmp22_), NULL) : NULL;
	_tmp26_ = self->priv->_window_container;
	_tmp27_ = self->priv->_monitor_scale;
	gala_window_clone_container_set_padding_top (_tmp26_, gala_utils_scale_to_int (GALA_WORKSPACE_CLONE_TOP_OFFSET, _tmp27_));
	_tmp28_ = self->priv->_window_container;
	_tmp29_ = self->priv->_window_container;
	_tmp30_ = monitor;
	_tmp31_ = monitor;
	gala_window_clone_container_set_padding_right (_tmp29_, ((gint) (_tmp30_.width - (_tmp31_.width * scale))) / 2);
	gala_window_clone_container_set_padding_left (_tmp28_, ((gint) (_tmp30_.width - (_tmp31_.width * scale))) / 2);
	_tmp32_ = self->priv->_window_container;
	_tmp33_ = self->priv->_monitor_scale;
	gala_window_clone_container_set_padding_bottom (_tmp32_, gala_utils_scale_to_int (GALA_WORKSPACE_CLONE_BOTTOM_OFFSET, _tmp33_));
}

static void
gala_workspace_clone_real_update_progress (GalaActorTarget* base,
                                           GalaGestureAction action,
                                           gdouble progress)
{
	GalaWorkspaceClone * self;
	self = (GalaWorkspaceClone*) base;
	if (action == GALA_GESTURE_ACTION_SWITCH_WORKSPACE) {
		GalaIconGroup* _tmp0_;
		MetaWorkspace* _tmp1_;
		_tmp0_ = self->priv->_icon_group;
		_tmp1_ = self->priv->_workspace;
		gala_icon_group_set_backdrop_opacity (_tmp0_, 1 - ((gfloat) CLAMP (fabs (meta_workspace_index (_tmp1_) + progress), (gdouble) 0, (gdouble) 1)));
	}
}

static void
gala_workspace_clone_activate (GalaWorkspaceClone* self,
                               gboolean close_view)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (close_view) {
		MetaWorkspace* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->_workspace;
		g_object_get (_tmp1_, "active", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GalaWindowManager* _tmp4_;
		_tmp4_ = self->priv->_wm;
		gala_window_manager_perform_action (_tmp4_, GALA_ACTION_TYPE_SHOW_MULTITASKING_VIEW);
	} else {
		MetaWorkspace* _tmp5_;
		_tmp5_ = self->priv->_workspace;
		meta_workspace_activate (_tmp5_, (guint32) META_CURRENT_TIME);
	}
}

GalaWindowManager*
gala_workspace_clone_get_wm (GalaWorkspaceClone* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_wm (GalaWorkspaceClone* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WM_PROPERTY]);
	}
}

MetaWorkspace*
gala_workspace_clone_get_workspace (GalaWorkspaceClone* self)
{
	MetaWorkspace* result;
	MetaWorkspace* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_workspace;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_workspace (GalaWorkspaceClone* self,
                                    MetaWorkspace* value)
{
	MetaWorkspace* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_workspace (self);
	if (old_value != value) {
		MetaWorkspace* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_workspace);
		self->priv->_workspace = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY]);
	}
}

gfloat
gala_workspace_clone_get_monitor_scale (GalaWorkspaceClone* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
gala_workspace_clone_set_monitor_scale (GalaWorkspaceClone* self,
                                        gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY]);
	}
}

GalaIconGroup*
gala_workspace_clone_get_icon_group (GalaWorkspaceClone* self)
{
	GalaIconGroup* result;
	GalaIconGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_group;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_icon_group (GalaWorkspaceClone* self,
                                     GalaIconGroup* value)
{
	GalaIconGroup* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_icon_group (self);
	if (old_value != value) {
		GalaIconGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon_group);
		self->priv->_icon_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY]);
	}
}

GalaWindowCloneContainer*
gala_workspace_clone_get_window_container (GalaWorkspaceClone* self)
{
	GalaWindowCloneContainer* result;
	GalaWindowCloneContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window_container;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_window_container (GalaWorkspaceClone* self,
                                           GalaWindowCloneContainer* value)
{
	GalaWindowCloneContainer* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_window_container (self);
	if (old_value != value) {
		GalaWindowCloneContainer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window_container);
		self->priv->_window_container = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY]);
	}
}

static void
_gala_workspace_clone___lambda68_ (GalaWorkspaceClone* self)
{
	gala_workspace_clone_activate (self, TRUE);
}

static void
__gala_workspace_clone___lambda68__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                 ClutterActor* actor,
                                                                 gpointer self)
{
	_gala_workspace_clone___lambda68_ ((GalaWorkspaceClone*) self);
}

static void
_gala_workspace_clone___lambda69_ (GalaWorkspaceClone* self,
                                   MetaWindow* w)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL], 0, w);
}

static void
__gala_workspace_clone___lambda69__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                MetaWindow* window,
                                                                                gpointer self)
{
	_gala_workspace_clone___lambda69_ ((GalaWorkspaceClone*) self, window);
}

static void
_gala_workspace_clone___lambda70_ (GalaWorkspaceClone* self)
{
	gala_workspace_clone_activate (self, TRUE);
}

static void
__gala_workspace_clone___lambda70__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                                                gpointer self)
{
	_gala_workspace_clone___lambda70_ ((GalaWorkspaceClone*) self);
}

static void
_gala_workspace_clone___lambda71_ (GalaWorkspaceClone* self)
{
	gala_workspace_clone_activate (self, TRUE);
}

static void
__gala_workspace_clone___lambda71__gala_icon_group_selected (GalaIconGroup* _sender,
                                                             gpointer self)
{
	_gala_workspace_clone___lambda71_ ((GalaWorkspaceClone*) self);
}

static gboolean
___lambda73_ (GalaWorkspaceClone* self)
{
	gboolean result;
	gala_workspace_clone_activate (self, FALSE);
	self->priv->hover_activate_timeout = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
____lambda73__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda73_ ((GalaWorkspaceClone*) self);
	return result;
}

static void
_gala_workspace_clone___lambda72_ (GalaWorkspaceClone* self,
                                   ClutterActor* target,
                                   gboolean hovered)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	if (!hovered) {
		_tmp0_ = self->priv->hover_activate_timeout != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_source_remove (self->priv->hover_activate_timeout);
		self->priv->hover_activate_timeout = (guint) 0;
		return;
	}
	if (hovered) {
		_tmp1_ = self->priv->hover_activate_timeout == ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->hover_activate_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GALA_WORKSPACE_CLONE_HOVER_ACTIVATE_DELAY, ____lambda73__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
__gala_workspace_clone___lambda72__gala_drag_drop_action_crossed (GalaDragDropAction* _sender,
                                                                  ClutterActor* target,
                                                                  gboolean hovered,
                                                                  gpointer self)
{
	_gala_workspace_clone___lambda72_ ((GalaWorkspaceClone*) self, target, hovered);
}

static void
_gala_workspace_clone_on_window_static_changed_gala_static_window_container_window_changed (GalaStaticWindowContainer* _sender,
                                                                                            MetaWindow* window,
                                                                                            gboolean is_static,
                                                                                            gpointer self)
{
	gala_workspace_clone_on_window_static_changed ((GalaWorkspaceClone*) self, window, is_static);
}

static void
_gala_workspace_clone_update_targets_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                            gpointer self)
{
	gala_workspace_clone_update_targets ((GalaWorkspaceClone*) self);
}

static void
_gala_workspace_clone_update_targets_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	gala_workspace_clone_update_targets ((GalaWorkspaceClone*) self);
}

static GObject *
gala_workspace_clone_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWorkspaceClone * self;
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	gint primary_monitor = 0;
	MetaDisplay* _tmp2_;
	MtkRectangle monitor_geometry = {0};
	MetaDisplay* _tmp3_;
	MtkRectangle _tmp4_ = {0};
	ClutterClickAction* background_click_action = NULL;
	ClutterClickAction* _tmp5_;
	ClutterClickAction* _tmp6_;
	MetaDisplay* _tmp7_;
	GalaFramedBackground* _tmp8_;
	GalaBackgroundManager* _tmp9_;
	ClutterClickAction* _tmp10_;
	GalaWindowManager* _tmp11_;
	gfloat _tmp12_;
	MtkRectangle _tmp13_;
	MtkRectangle _tmp14_;
	GalaWindowCloneContainer* _tmp15_ = NULL;
	GalaWindowCloneContainer* _tmp16_;
	GalaWindowCloneContainer* _tmp17_;
	GalaWindowCloneContainer* _tmp18_;
	GalaWindowCloneContainer* _tmp19_;
	MetaDisplay* _tmp20_;
	MetaWorkspace* _tmp21_;
	gfloat _tmp22_;
	GalaIconGroup* _tmp23_;
	GalaIconGroup* _tmp24_;
	GalaIconGroup* _tmp25_;
	GalaIconGroup* _tmp26_;
	GalaDragDropAction* icons_drop_action = NULL;
	GalaDragDropAction* _tmp27_;
	GalaIconGroup* _tmp28_;
	GalaDragDropAction* _tmp29_;
	GalaDragDropAction* background_drop_action = NULL;
	GalaDragDropAction* _tmp30_;
	GalaBackgroundManager* _tmp31_;
	GalaDragDropAction* _tmp32_;
	GalaDragDropAction* _tmp33_;
	MetaDisplay* _tmp34_;
	MetaDisplay* _tmp35_;
	MetaWorkspace* _tmp36_;
	MetaWorkspace* _tmp37_;
	GalaBackgroundManager* _tmp38_;
	GalaWindowCloneContainer* _tmp39_;
	GList* windows = NULL;
	MetaWorkspace* _tmp40_;
	GList* _tmp41_;
	GList* _tmp42_;
	GalaStaticWindowContainer* static_windows = NULL;
	MetaDisplay* _tmp56_;
	GalaStaticWindowContainer* _tmp57_;
	GalaStaticWindowContainer* _tmp58_;
	MetaMonitorManager* monitor_manager = NULL;
	MetaDisplay* _tmp59_;
	MetaContext* _tmp60_;
	MetaBackend* _tmp61_;
	MetaMonitorManager* _tmp62_;
	MetaMonitorManager* _tmp63_;
	parent_class = G_OBJECT_CLASS (gala_workspace_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	self->priv->opened = FALSE;
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	primary_monitor = meta_display_get_primary_monitor (_tmp2_);
	_tmp3_ = display;
	meta_display_get_monitor_geometry (_tmp3_, primary_monitor, &_tmp4_);
	monitor_geometry = _tmp4_;
	_tmp5_ = (ClutterClickAction*) clutter_click_action_new ();
	g_object_ref_sink (_tmp5_);
	background_click_action = _tmp5_;
	_tmp6_ = background_click_action;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) __gala_workspace_clone___lambda68__clutter_click_action_clicked, self, 0);
	_tmp7_ = display;
	_tmp8_ = gala_framed_background_new (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = (GalaBackgroundManager*) _tmp8_;
	_tmp9_ = self->priv->background;
	_tmp10_ = background_click_action;
	clutter_actor_add_action ((ClutterActor*) _tmp9_, (ClutterAction*) _tmp10_);
	_tmp11_ = self->priv->_wm;
	_tmp12_ = self->priv->_monitor_scale;
	_tmp13_ = monitor_geometry;
	_tmp14_ = monitor_geometry;
	_tmp15_ = gala_window_clone_container_new (_tmp11_, _tmp12_, FALSE);
	clutter_actor_set_width ((ClutterActor*) _tmp15_, (gfloat) _tmp13_.width);
	clutter_actor_set_height ((ClutterActor*) _tmp15_, (gfloat) _tmp14_.height);
	g_object_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	gala_workspace_clone_set_window_container (self, _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = self->priv->_window_container;
	g_signal_connect_object (_tmp17_, "window-selected", (GCallback) __gala_workspace_clone___lambda69__gala_window_clone_container_window_selected, self, 0);
	_tmp18_ = self->priv->_window_container;
	g_signal_connect_object (_tmp18_, "requested-close", (GCallback) __gala_workspace_clone___lambda70__gala_window_clone_container_requested_close, self, 0);
	_tmp19_ = self->priv->_window_container;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp19_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp20_ = display;
	_tmp21_ = self->priv->_workspace;
	_tmp22_ = self->priv->_monitor_scale;
	_tmp23_ = gala_icon_group_new (_tmp20_, _tmp21_, _tmp22_);
	g_object_ref_sink (_tmp23_);
	_tmp24_ = _tmp23_;
	gala_workspace_clone_set_icon_group (self, _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = self->priv->_icon_group;
	g_signal_connect_object (_tmp25_, "selected", (GCallback) __gala_workspace_clone___lambda71__gala_icon_group_selected, self, 0);
	_tmp26_ = self->priv->_icon_group;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp26_, "scale-factor", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp27_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp27_);
	icons_drop_action = _tmp27_;
	_tmp28_ = self->priv->_icon_group;
	_tmp29_ = icons_drop_action;
	clutter_actor_add_action ((ClutterActor*) _tmp28_, (ClutterAction*) _tmp29_);
	_tmp30_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp30_);
	background_drop_action = _tmp30_;
	_tmp31_ = self->priv->background;
	_tmp32_ = background_drop_action;
	clutter_actor_add_action ((ClutterActor*) _tmp31_, (ClutterAction*) _tmp32_);
	_tmp33_ = background_drop_action;
	g_signal_connect_object (_tmp33_, "crossed", (GCallback) __gala_workspace_clone___lambda72__gala_drag_drop_action_crossed, self, 0);
	_tmp34_ = display;
	g_signal_connect_object (_tmp34_, "window-entered-monitor", (GCallback) _gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor, self, 0);
	_tmp35_ = display;
	g_signal_connect_object (_tmp35_, "window-left-monitor", (GCallback) _gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor, self, 0);
	_tmp36_ = self->priv->_workspace;
	g_signal_connect_object (_tmp36_, "window-added", (GCallback) _gala_workspace_clone_add_window_meta_workspace_window_added, self, 0);
	_tmp37_ = self->priv->_workspace;
	g_signal_connect_object (_tmp37_, "window-removed", (GCallback) _gala_workspace_clone_remove_window_meta_workspace_window_removed, self, 0);
	_tmp38_ = self->priv->background;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp38_);
	_tmp39_ = self->priv->_window_container;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp39_);
	_tmp40_ = self->priv->_workspace;
	_tmp41_ = meta_workspace_list_windows (_tmp40_);
	windows = _tmp41_;
	_tmp42_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp42_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				gboolean _tmp43_ = FALSE;
				gboolean _tmp44_ = FALSE;
				MetaWindow* _tmp45_;
				MetaWindowType _tmp46_;
				MetaWindowType _tmp47_;
				_tmp45_ = window;
				_tmp46_ = meta_window_get_window_type (_tmp45_);
				_tmp47_ = _tmp46_;
				if (_tmp47_ == META_WINDOW_NORMAL) {
					MetaWindow* _tmp48_;
					gboolean _tmp49_;
					gboolean _tmp50_;
					_tmp48_ = window;
					g_object_get (_tmp48_, "on-all-workspaces", &_tmp49_, NULL);
					_tmp50_ = _tmp49_;
					_tmp44_ = !_tmp50_;
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					MetaWindow* _tmp51_;
					_tmp51_ = window;
					_tmp43_ = meta_window_is_on_primary_monitor (_tmp51_);
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					GalaWindowCloneContainer* _tmp52_;
					MetaWindow* _tmp53_;
					GalaIconGroup* _tmp54_;
					MetaWindow* _tmp55_;
					_tmp52_ = self->priv->_window_container;
					_tmp53_ = window;
					gala_window_clone_container_add_window (_tmp52_, _tmp53_);
					_tmp54_ = self->priv->_icon_group;
					_tmp55_ = window;
					gala_icon_group_add_window (_tmp54_, _tmp55_, TRUE, FALSE);
				}
			}
		}
	}
	_tmp56_ = display;
	_tmp57_ = gala_static_window_container_get_instance (_tmp56_);
	static_windows = _tmp57_;
	_tmp58_ = static_windows;
	g_signal_connect_object (_tmp58_, "window-changed", (GCallback) _gala_workspace_clone_on_window_static_changed_gala_static_window_container_window_changed, self, 0);
	_tmp59_ = display;
	_tmp60_ = meta_display_get_context (_tmp59_);
	_tmp61_ = meta_context_get_backend (_tmp60_);
	_tmp62_ = meta_backend_get_monitor_manager (_tmp61_);
	monitor_manager = _tmp62_;
	_tmp63_ = monitor_manager;
	g_signal_connect_object (_tmp63_, "monitors-changed", (GCallback) _gala_workspace_clone_update_targets_meta_monitor_manager_monitors_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::monitor-scale", (GCallback) _gala_workspace_clone_update_targets_g_object_notify, self, 0);
	gala_workspace_clone_update_targets (self);
	_g_object_unref0 (static_windows);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	_g_object_unref0 (background_drop_action);
	_g_object_unref0 (icons_drop_action);
	_g_object_unref0 (background_click_action);
	return obj;
}

static void
gala_workspace_clone_class_init (GalaWorkspaceCloneClass * klass,
                                 gpointer klass_data)
{
	gala_workspace_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWorkspaceClone_private_offset);
	((GalaActorTargetClass *) klass)->update_progress = (void (*) (GalaActorTarget*, GalaGestureAction, gdouble)) gala_workspace_clone_real_update_progress;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_workspace_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_workspace_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_workspace_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_workspace_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_WM_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY] = g_param_spec_object ("workspace", "workspace", "workspace", meta_workspace_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY] = g_param_spec_object ("icon-group", "icon-group", "icon-group", GALA_TYPE_ICON_GROUP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY] = g_param_spec_object ("window-container", "window-container", "window-container", GALA_TYPE_WINDOW_CLONE_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * A window has been selected, the MultitaskingView should consider activating
	     * and closing the view.
	     */
	gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL] = g_signal_new ("window-selected", GALA_TYPE_WORKSPACE_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
}

static void
gala_workspace_clone_instance_init (GalaWorkspaceClone * self,
                                    gpointer klass)
{
	self->priv = gala_workspace_clone_get_instance_private (self);
	self->priv->hover_activate_timeout = (guint) 0;
}

static void
gala_workspace_clone_finalize (GObject * obj)
{
	GalaWorkspaceClone * self;
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	guint _tmp3_;
	MetaDisplay* _tmp4_;
	guint _tmp5_;
	MetaWorkspace* _tmp6_;
	guint _tmp7_;
	MetaWorkspace* _tmp8_;
	guint _tmp9_;
	GalaBackgroundManager* _tmp10_;
	GalaWindowCloneContainer* _tmp11_;
	GalaIconGroup* _tmp12_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	g_signal_parse_name ("window-entered-monitor", meta_display_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor, self);
	_tmp4_ = display;
	g_signal_parse_name ("window-left-monitor", meta_display_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor, self);
	_tmp6_ = self->priv->_workspace;
	g_signal_parse_name ("window-added", meta_workspace_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gala_workspace_clone_add_window_meta_workspace_window_added, self);
	_tmp8_ = self->priv->_workspace;
	g_signal_parse_name ("window-removed", meta_workspace_get_type (), &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _gala_workspace_clone_remove_window_meta_workspace_window_removed, self);
	_tmp10_ = self->priv->background;
	clutter_actor_destroy ((ClutterActor*) _tmp10_);
	_tmp11_ = self->priv->_window_container;
	clutter_actor_destroy ((ClutterActor*) _tmp11_);
	_tmp12_ = self->priv->_icon_group;
	clutter_actor_destroy ((ClutterActor*) _tmp12_);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_workspace);
	_g_object_unref0 (self->priv->_icon_group);
	_g_object_unref0 (self->priv->_window_container);
	_g_object_unref0 (self->priv->background);
	G_OBJECT_CLASS (gala_workspace_clone_parent_class)->finalize (obj);
}

/**
 * This is the container which manages a clone of the background which will
 * be scaled and animated inwards, a WindowCloneContainer for the windows on
 * this workspace and also holds the instance for this workspace's IconGroup.
 * The latter is not added to the WorkspaceClone itself though but to a container
 * of the MultitaskingView.
 */
 G_GNUC_NO_INLINE static GType
gala_workspace_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWorkspaceCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_workspace_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWorkspaceClone), 0, (GInstanceInitFunc) gala_workspace_clone_instance_init, NULL };
	GType gala_workspace_clone_type_id;
	gala_workspace_clone_type_id = g_type_register_static (GALA_TYPE_ACTOR_TARGET, "GalaWorkspaceClone", &g_define_type_info, 0);
	GalaWorkspaceClone_private_offset = g_type_add_instance_private (gala_workspace_clone_type_id, sizeof (GalaWorkspaceClonePrivate));
	return gala_workspace_clone_type_id;
}

GType
gala_workspace_clone_get_type (void)
{
	static gsize gala_workspace_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_workspace_clone_type_id__once)) {
		GType gala_workspace_clone_type_id;
		gala_workspace_clone_type_id = gala_workspace_clone_get_type_once ();
		g_once_init_leave (&gala_workspace_clone_type_id__once, gala_workspace_clone_type_id);
	}
	return gala_workspace_clone_type_id__once;
}

static void
_vala_gala_workspace_clone_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWorkspaceClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	switch (property_id) {
		case GALA_WORKSPACE_CLONE_WM_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_wm (self));
		break;
		case GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_workspace (self));
		break;
		case GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_workspace_clone_get_monitor_scale (self));
		break;
		case GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_icon_group (self));
		break;
		case GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_window_container (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_workspace_clone_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWorkspaceClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	switch (property_id) {
		case GALA_WORKSPACE_CLONE_WM_PROPERTY:
		gala_workspace_clone_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY:
		gala_workspace_clone_set_workspace (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY:
		gala_workspace_clone_set_monitor_scale (self, g_value_get_float (value));
		break;
		case GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY:
		gala_workspace_clone_set_icon_group (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY:
		gala_workspace_clone_set_window_container (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

