/* application-certificate-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application-certificate-manager.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* All of the code below basically exists since cert pinning using GCR*/
/* stopped working (GNOME/gcr#10) after gnome-keyring stopped*/
/* advertising its PKCS11 module (GNOME/gnome-keyring#20). To work*/
/* around, this piggy-backs off of the GIO infrastructure and adds a*/
/* custom pinned cert store.*/

#include "geary-client-46.0.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <glib.h>
#include "geary-engine.h"
#include <gcr/gcr-base.h>
#include <stdlib.h>
#include <string.h>
#include <gck/gck.h>
#include <gtk/gtk.h>
#include <gee.h>

#define APPLICATION_CERTIFICATE_MANAGER_CKF_WRITE_PROTECTED (1UL << 1)
#define APPLICATION_TLS_DATABASE_TRUST_CONTEXT_IO_PRIO G_PRIORITY_HIGH
#define APPLICATION_TLS_DATABASE_TRUST_CONTEXT_ID_TYPE G_CHECKSUM_SHA384
#define APPLICATION_TLS_DATABASE_TRUST_CONTEXT_FILENAME_FORMAT "%s.pem"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define APPLICATION_TYPE_TLS_DATABASE (application_tls_database_get_type ())
#define APPLICATION_TLS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase))
#define APPLICATION_TLS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabaseClass))
#define APPLICATION_IS_TLS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_TLS_DATABASE))
#define APPLICATION_IS_TLS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_TLS_DATABASE))
#define APPLICATION_TLS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabaseClass))

typedef struct _ApplicationTlsDatabase ApplicationTlsDatabase;
typedef struct _ApplicationTlsDatabaseClass ApplicationTlsDatabaseClass;
enum  {
	APPLICATION_CERTIFICATE_MANAGER_0_PROPERTY,
	APPLICATION_CERTIFICATE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* application_certificate_manager_properties[APPLICATION_CERTIFICATE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ApplicationCertificateManagerIsGcrEnabledData ApplicationCertificateManagerIsGcrEnabledData;
typedef struct _ApplicationCertificateManagerNewData ApplicationCertificateManagerNewData;
#define _certificate_warning_dialog_unref0(var) ((var == NULL) ? NULL : (var = (certificate_warning_dialog_unref (var), NULL)))
typedef struct _ApplicationCertificateManagerPromptPinCertificateData ApplicationCertificateManagerPromptPinCertificateData;
typedef struct _ApplicationTlsDatabasePrivate ApplicationTlsDatabasePrivate;

#define APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT (application_tls_database_trust_context_get_type ())
#define APPLICATION_TLS_DATABASE_TRUST_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT, ApplicationTlsDatabaseTrustContext))
#define APPLICATION_TLS_DATABASE_TRUST_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT, ApplicationTlsDatabaseTrustContextClass))
#define APPLICATION_TLS_DATABASE_IS_TRUST_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT))
#define APPLICATION_TLS_DATABASE_IS_TRUST_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT))
#define APPLICATION_TLS_DATABASE_TRUST_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT, ApplicationTlsDatabaseTrustContextClass))

typedef struct _ApplicationTlsDatabaseTrustContext ApplicationTlsDatabaseTrustContext;
typedef struct _ApplicationTlsDatabaseTrustContextClass ApplicationTlsDatabaseTrustContextClass;
enum  {
	APPLICATION_TLS_DATABASE_0_PROPERTY,
	APPLICATION_TLS_DATABASE_NUM_PROPERTIES
};
static GParamSpec* application_tls_database_properties[APPLICATION_TLS_DATABASE_NUM_PROPERTIES];
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
typedef struct _ApplicationTlsDatabasePinCertificateData ApplicationTlsDatabasePinCertificateData;
typedef struct _ApplicationTlsDatabaseTrustContextPrivate ApplicationTlsDatabaseTrustContextPrivate;
typedef struct _ApplicationTlsDatabaseLookupCertificateForHandleAsyncData ApplicationTlsDatabaseLookupCertificateForHandleAsyncData;
typedef struct _ApplicationTlsDatabaseLookupCertificateIssuerAsyncData ApplicationTlsDatabaseLookupCertificateIssuerAsyncData;
typedef struct _ApplicationTlsDatabaseLookupCertificatesIssuedByAsyncData ApplicationTlsDatabaseLookupCertificatesIssuedByAsyncData;
typedef struct _ApplicationTlsDatabaseVerifyChainAsyncData ApplicationTlsDatabaseVerifyChainAsyncData;
typedef struct _Block2Data Block2Data;
typedef struct _ApplicationTlsDatabaseIsPinnedAsyncData ApplicationTlsDatabaseIsPinnedAsyncData;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
enum  {
	APPLICATION_TLS_DATABASE_TRUST_CONTEXT_0_PROPERTY,
	APPLICATION_TLS_DATABASE_TRUST_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* application_tls_database_trust_context_properties[APPLICATION_TLS_DATABASE_TRUST_CONTEXT_NUM_PROPERTIES];
typedef struct _ApplicationTlsDatabaseTrustContextSaveData ApplicationTlsDatabaseTrustContextSaveData;

/** Errors thrown by {@link CertificateManager}. */
struct _ApplicationCertificateManagerPrivate {
	ApplicationTlsDatabase* pinning_database;
};

struct _ApplicationCertificateManagerIsGcrEnabledData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GCancellable* cancellable;
	gboolean result;
	gboolean init_okay;
	gboolean _tmp0_;
	GError* err;
	GError* _tmp1_;
	const gchar* _tmp2_;
	gboolean has_uris;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean has_rw_store;
	GckSlot* store;
	GckSlot* _tmp9_;
	GckSlot* _tmp10_;
	GckSlot* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _inner_error0_;
};

struct _ApplicationCertificateManagerNewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GType object_type;
	ApplicationCertificateManager* self;
	GFile* store_dir;
	GCancellable* cancellable;
	gboolean use_gcr;
	GTlsBackend* _tmp0_;
	GTlsDatabase* _tmp1_;
	GTlsDatabase* _tmp2_;
	ApplicationTlsDatabase* _tmp3_;
	ApplicationTlsDatabase* _tmp4_;
	GTlsDatabase* _tmp5_;
};

struct _ApplicationCertificateManagerPromptPinCertificateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationCertificateManager* self;
	GtkWindow* parent;
	GearyAccountInformation* account;
	GearyServiceInformation* service;
	GearyEndpoint* endpoint;
	gboolean is_validation;
	GCancellable* cancellable;
	CertificateWarningDialog* dialog;
	CertificateWarningDialog* _tmp0_;
	gboolean save;
	CertificateWarningDialog* _tmp1_;
	GError* _tmp2_;
	GSocketConnectable* _tmp3_;
	GSocketConnectable* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ApplicationTlsDatabase* _tmp7_;
	GTlsCertificate* _tmp8_;
	GTlsCertificate* _tmp9_;
	GSocketConnectable* _tmp10_;
	GSocketConnectable* _tmp11_;
	GError* err;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	GError* _inner_error0_;
};

struct _ApplicationTlsDatabase {
	GTlsDatabase parent_instance;
	ApplicationTlsDatabasePrivate * priv;
};

struct _ApplicationTlsDatabaseClass {
	GTlsDatabaseClass parent_class;
};

struct _ApplicationTlsDatabasePrivate {
	GTlsDatabase* _parent;
	GFile* store_dir;
	gboolean use_gcr;
	GeeMap* pinned_certs;
	GRecMutex __lock_pinned_certs;
};

struct _ApplicationTlsDatabasePinCertificateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationTlsDatabase* self;
	GTlsCertificate* certificate;
	GSocketConnectable* identity;
	gboolean save;
	GCancellable* cancellable;
	gchar* id;
	gchar* _tmp0_;
	ApplicationTlsDatabaseTrustContext* context;
	ApplicationTlsDatabaseTrustContext* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	const gchar* _tmp4_;
	ApplicationTlsDatabaseTrustContext* _tmp5_;
	GeeMap* _tmp6_;
	GByteArray* _tmp7_;
	GByteArray* _tmp8_;
	GByteArray* _tmp9_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GcrSimpleCertificate* _tmp11_;
	GcrSimpleCertificate* _tmp12_;
	const gchar* _tmp13_;
	ApplicationTlsDatabaseTrustContext* _tmp14_;
	GFile* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _inner_error0_;
};

struct _ApplicationTlsDatabaseTrustContext {
	GearyBaseObject parent_instance;
	gchar* id;
	GTlsCertificate* certificate;
	ApplicationTlsDatabaseTrustContextPrivate * priv;
};

struct _ApplicationTlsDatabaseTrustContextClass {
	GearyBaseObjectClass parent_class;
};

struct _ApplicationTlsDatabaseLookupCertificateForHandleAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationTlsDatabase* self;
	gchar* handle;
	GTlsInteraction* interaction;
	GTlsDatabaseLookupFlags flags;
	GCancellable* cancellable;
	GTlsCertificate* result;
	ApplicationTlsDatabaseTrustContext* context;
	ApplicationTlsDatabaseTrustContext* _tmp0_;
	GTlsCertificate* _tmp1_;
	ApplicationTlsDatabaseTrustContext* _tmp2_;
	ApplicationTlsDatabaseTrustContext* _tmp3_;
	GTlsCertificate* _tmp4_;
	GTlsCertificate* _tmp5_;
	GTlsDatabase* _tmp6_;
	GTlsCertificate* _tmp7_;
	GError* _inner_error0_;
};

struct _ApplicationTlsDatabaseLookupCertificateIssuerAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationTlsDatabase* self;
	GTlsCertificate* certificate;
	GTlsInteraction* interaction;
	GTlsDatabaseLookupFlags flags;
	GCancellable* cancellable;
	GTlsCertificate* result;
	GTlsCertificate* _tmp0_;
	GTlsDatabase* _tmp1_;
	GTlsCertificate* _tmp2_;
	GTlsCertificate* _tmp3_;
	GError* _inner_error0_;
};

struct _ApplicationTlsDatabaseLookupCertificatesIssuedByAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationTlsDatabase* self;
	GByteArray* issuer_raw_dn;
	GTlsInteraction* interaction;
	GTlsDatabaseLookupFlags flags;
	GCancellable* cancellable;
	GList* result;
	GList* _tmp0_;
	GTlsDatabase* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GError* _inner_error0_;
};

struct _ApplicationTlsDatabaseVerifyChainAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationTlsDatabase* self;
	GTlsCertificate* chain;
	gchar* purpose;
	GSocketConnectable* identity;
	GTlsInteraction* interaction;
	GTlsDatabaseVerifyFlags flags;
	GCancellable* cancellable;
	GTlsCertificateFlags result;
	GTlsCertificateFlags ret;
	GTlsDatabase* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	ApplicationTlsDatabase* self;
	gboolean pinned;
	GTlsCertificate* chain;
	GSocketConnectable* identity;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _ApplicationTlsDatabaseIsPinnedAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationTlsDatabase* self;
	GTlsCertificate* chain;
	GSocketConnectable* identity;
	GCancellable* cancellable;
	gboolean result;
	Block2Data* _data2_;
	GearyNonblockingConcurrent* _tmp0_;
	GearyNonblockingConcurrent* _tmp1_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	ApplicationTlsDatabase* self;
	gchar* id;
};

struct _Block4Data {
	int _ref_count_;
	ApplicationTlsDatabase* self;
	GTlsCertificate* cert;
};

struct _ApplicationTlsDatabaseTrustContextSaveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationTlsDatabaseTrustContext* self;
	GFile* dir;
	gchar* identity;
	GCancellable* cancellable;
	GFile* storage;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFileOutputStream* f_out;
	GFile* _tmp4_;
	GFileOutputStream* _tmp5_;
	GBufferedOutputStream* buf;
	GFileOutputStream* _tmp6_;
	GBufferedOutputStream* _tmp7_;
	gsize written;
	GBufferedOutputStream* _tmp8_;
	GTlsCertificate* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_;
	guint8* _tmp15_;
	gint _tmp15__length1;
	gsize _tmp16_;
	GBufferedOutputStream* _tmp17_;
	GError* _inner_error0_;
};

static gint ApplicationCertificateManager_private_offset;
static gpointer application_certificate_manager_parent_class = NULL;
static gint ApplicationTlsDatabase_private_offset;
static gpointer application_tls_database_parent_class = NULL;
static gpointer application_tls_database_trust_context_parent_class = NULL;

VALA_EXTERN GType application_tls_database_get_type (void) G_GNUC_CONST ;
static void application_certificate_manager_is_gcr_enabled_data_free (gpointer _data);
static void application_certificate_manager_is_gcr_enabled (GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean application_certificate_manager_is_gcr_enabled_finish (GAsyncResult* _res_);
static gboolean application_certificate_manager_is_gcr_enabled_co (ApplicationCertificateManagerIsGcrEnabledData* _data_);
static void application_certificate_manager_is_gcr_enabled_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void application_certificate_manager_construct_data_free (gpointer _data);
static gboolean application_certificate_manager_construct_co (ApplicationCertificateManagerNewData* _data_);
static void application_certificate_manager_new_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
VALA_EXTERN ApplicationTlsDatabase* application_tls_database_new (GTlsDatabase* parent,
                                                      GFile* store_dir,
                                                      gboolean use_gcr);
VALA_EXTERN ApplicationTlsDatabase* application_tls_database_construct (GType object_type,
                                                            GTlsDatabase* parent,
                                                            GFile* store_dir,
                                                            gboolean use_gcr);
static void application_certificate_manager_prompt_pin_certificate_data_free (gpointer _data);
static gboolean application_certificate_manager_prompt_pin_certificate_co (ApplicationCertificateManagerPromptPinCertificateData* _data_);
VALA_EXTERN void application_tls_database_pin_certificate (ApplicationTlsDatabase* self,
                                               GTlsCertificate* certificate,
                                               GSocketConnectable* identity,
                                               gboolean save,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void application_tls_database_pin_certificate_finish (ApplicationTlsDatabase* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void application_certificate_manager_prompt_pin_certificate_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void application_certificate_manager_finalize (GObject * obj);
static GType application_certificate_manager_get_type_once (void);
static GType application_tls_database_trust_context_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gchar* application_tls_database_to_name (GSocketConnectable* id);
static GTlsDatabase* application_tls_database_get_parent (ApplicationTlsDatabase* self);
static void application_tls_database_set_parent (ApplicationTlsDatabase* self,
                                          GTlsDatabase* value);
static void application_tls_database_pin_certificate_data_free (gpointer _data);
static gboolean application_tls_database_pin_certificate_co (ApplicationTlsDatabasePinCertificateData* _data_);
static ApplicationTlsDatabaseTrustContext* application_tls_database_trust_context_new (GTlsCertificate* certificate);
static ApplicationTlsDatabaseTrustContext* application_tls_database_trust_context_construct (GType object_type,
                                                                                      GTlsCertificate* certificate);
static void application_tls_database_pin_certificate_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void application_tls_database_trust_context_save (ApplicationTlsDatabaseTrustContext* self,
                                                  GFile* dir,
                                                  const gchar* identity,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void application_tls_database_trust_context_save_finish (ApplicationTlsDatabaseTrustContext* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static gchar* application_tls_database_real_create_certificate_handle (GTlsDatabase* base,
                                                                GTlsCertificate* certificate);
static ApplicationTlsDatabaseTrustContext* application_tls_database_lookup_tls_certificate (ApplicationTlsDatabase* self,
                                                                                     GTlsCertificate* cert);
static GTlsCertificate* application_tls_database_real_lookup_certificate_for_handle (GTlsDatabase* base,
                                                                              const gchar* handle,
                                                                              GTlsInteraction* interaction,
                                                                              GTlsDatabaseLookupFlags flags,
                                                                              GCancellable* cancellable,
                                                                              GError** error);
static ApplicationTlsDatabaseTrustContext* application_tls_database_lookup_id (ApplicationTlsDatabase* self,
                                                                        const gchar* id);
static void application_tls_database_real_lookup_certificate_for_handle_async_data_free (gpointer _data);
static void application_tls_database_real_lookup_certificate_for_handle_async (GTlsDatabase* base,
                                                                        const gchar* handle,
                                                                        GTlsInteraction* interaction,
                                                                        GTlsDatabaseLookupFlags flags,
                                                                        GCancellable* cancellable,
                                                                        GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_);
static gboolean application_tls_database_real_lookup_certificate_for_handle_async_co (ApplicationTlsDatabaseLookupCertificateForHandleAsyncData* _data_);
static void application_tls_database_lookup_certificate_for_handle_async_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_);
static GTlsCertificate* application_tls_database_real_lookup_certificate_issuer (GTlsDatabase* base,
                                                                          GTlsCertificate* certificate,
                                                                          GTlsInteraction* interaction,
                                                                          GTlsDatabaseLookupFlags flags,
                                                                          GCancellable* cancellable,
                                                                          GError** error);
static void application_tls_database_real_lookup_certificate_issuer_async_data_free (gpointer _data);
static void application_tls_database_real_lookup_certificate_issuer_async (GTlsDatabase* base,
                                                                    GTlsCertificate* certificate,
                                                                    GTlsInteraction* interaction,
                                                                    GTlsDatabaseLookupFlags flags,
                                                                    GCancellable* cancellable,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_);
static gboolean application_tls_database_real_lookup_certificate_issuer_async_co (ApplicationTlsDatabaseLookupCertificateIssuerAsyncData* _data_);
static void application_tls_database_lookup_certificate_issuer_async_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static GList* application_tls_database_real_lookup_certificates_issued_by (GTlsDatabase* base,
                                                                    GByteArray* issuer_raw_dn,
                                                                    GTlsInteraction* interaction,
                                                                    GTlsDatabaseLookupFlags flags,
                                                                    GCancellable* cancellable,
                                                                    GError** error);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void application_tls_database_real_lookup_certificates_issued_by_async_data_free (gpointer _data);
static void application_tls_database_real_lookup_certificates_issued_by_async (GTlsDatabase* base,
                                                                        GByteArray* issuer_raw_dn,
                                                                        GTlsInteraction* interaction,
                                                                        GTlsDatabaseLookupFlags flags,
                                                                        GCancellable* cancellable,
                                                                        GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_);
static gboolean application_tls_database_real_lookup_certificates_issued_by_async_co (ApplicationTlsDatabaseLookupCertificatesIssuedByAsyncData* _data_);
static void application_tls_database_lookup_certificates_issued_by_async_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_);
static GTlsCertificateFlags application_tls_database_real_verify_chain (GTlsDatabase* base,
                                                                 GTlsCertificate* chain,
                                                                 const gchar* purpose,
                                                                 GSocketConnectable* identity,
                                                                 GTlsInteraction* interaction,
                                                                 GTlsDatabaseVerifyFlags flags,
                                                                 GCancellable* cancellable,
                                                                 GError** error);
static inline gboolean application_tls_database_check_pinned (ApplicationTlsDatabase* self,
                                                GTlsCertificateFlags parent_ret,
                                                const gchar* purpose,
                                                GSocketConnectable* identity);
static gboolean application_tls_database_is_pinned (ApplicationTlsDatabase* self,
                                             GTlsCertificate* chain,
                                             GSocketConnectable* identity,
                                             GCancellable* cancellable,
                                             GError** error);
static void application_tls_database_real_verify_chain_async_data_free (gpointer _data);
static void application_tls_database_real_verify_chain_async (GTlsDatabase* base,
                                                       GTlsCertificate* chain,
                                                       const gchar* purpose,
                                                       GSocketConnectable* identity,
                                                       GTlsInteraction* interaction,
                                                       GTlsDatabaseVerifyFlags flags,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean application_tls_database_real_verify_chain_async_co (ApplicationTlsDatabaseVerifyChainAsyncData* _data_);
static void application_tls_database_verify_chain_async_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void application_tls_database_is_pinned_async (ApplicationTlsDatabase* self,
                                               GTlsCertificate* chain,
                                               GSocketConnectable* identity,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean application_tls_database_is_pinned_finish (ApplicationTlsDatabase* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static ApplicationTlsDatabaseTrustContext* application_tls_database_trust_context_new_lookup (GFile* dir,
                                                                                       const gchar* identity,
                                                                                       GCancellable* cancellable,
                                                                                       GError** error);
static ApplicationTlsDatabaseTrustContext* application_tls_database_trust_context_construct_lookup (GType object_type,
                                                                                             GFile* dir,
                                                                                             const gchar* identity,
                                                                                             GCancellable* cancellable,
                                                                                             GError** error);
static void application_tls_database_is_pinned_async_data_free (gpointer _data);
static gboolean application_tls_database_is_pinned_async_co (ApplicationTlsDatabaseIsPinnedAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda52_ (Block2Data* _data2_,
                  GError** error);
static void ___lambda52__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void application_tls_database_is_pinned_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean ___lambda51_ (Block3Data* _data3_,
                       ApplicationTlsDatabaseTrustContext* ctx);
static gboolean ____lambda51__gee_predicate (gconstpointer g,
                                      gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean ___lambda50_ (Block4Data* _data4_,
                       ApplicationTlsDatabaseTrustContext* ctx);
static gboolean ____lambda50__gee_predicate (gconstpointer g,
                                      gpointer self);
static void application_tls_database_trust_context_save_data_free (gpointer _data);
static gboolean application_tls_database_trust_context_save_co (ApplicationTlsDatabaseTrustContextSaveData* _data_);
static void application_tls_database_trust_context_save_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void application_tls_database_trust_context_finalize (GObject * obj);
static GType application_tls_database_trust_context_get_type_once (void);
static void application_tls_database_finalize (GObject * obj);
static GType application_tls_database_get_type_once (void);
static void _vala_application_tls_database_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_application_tls_database_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

GQuark
application_certificate_manager_error_quark (void)
{
	return g_quark_from_static_string ("application-certificate-manager-error-quark");
}

static GType
application_certificate_manager_error_get_type_once (void)
{
	static const GEnumValue values[] = {{APPLICATION_CERTIFICATE_MANAGER_ERROR_UNTRUSTED, "APPLICATION_CERTIFICATE_MANAGER_ERROR_UNTRUSTED", "untrusted"}, {APPLICATION_CERTIFICATE_MANAGER_ERROR_STORE_FAILED, "APPLICATION_CERTIFICATE_MANAGER_ERROR_STORE_FAILED", "store-failed"}, {0, NULL, NULL}};
	GType application_certificate_manager_error_type_id;
	application_certificate_manager_error_type_id = g_enum_register_static ("ApplicationCertificateManagerError", values);
	return application_certificate_manager_error_type_id;
}

GType
application_certificate_manager_error_get_type (void)
{
	static volatile gsize application_certificate_manager_error_type_id__once = 0;
	if (g_once_init_enter (&application_certificate_manager_error_type_id__once)) {
		GType application_certificate_manager_error_type_id;
		application_certificate_manager_error_type_id = application_certificate_manager_error_get_type_once ();
		g_once_init_leave (&application_certificate_manager_error_type_id__once, application_certificate_manager_error_type_id);
	}
	return application_certificate_manager_error_type_id__once;
}

static inline gpointer
application_certificate_manager_get_instance_private (ApplicationCertificateManager* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationCertificateManager_private_offset);
}

static void
application_certificate_manager_is_gcr_enabled_data_free (gpointer _data)
{
	ApplicationCertificateManagerIsGcrEnabledData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	g_slice_free (ApplicationCertificateManagerIsGcrEnabledData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
application_certificate_manager_is_gcr_enabled (GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	ApplicationCertificateManagerIsGcrEnabledData* _data_;
	GCancellable* _tmp0_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationCertificateManagerIsGcrEnabledData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_certificate_manager_is_gcr_enabled_data_free);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp0_;
	application_certificate_manager_is_gcr_enabled_co (_data_);
}

static gboolean
application_certificate_manager_is_gcr_enabled_finish (GAsyncResult* _res_)
{
	gboolean result;
	ApplicationCertificateManagerIsGcrEnabledData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
application_certificate_manager_is_gcr_enabled_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	ApplicationCertificateManagerIsGcrEnabledData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_certificate_manager_is_gcr_enabled_co (_data_);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static gboolean
application_certificate_manager_is_gcr_enabled_co (ApplicationCertificateManagerIsGcrEnabledData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->init_okay = FALSE;
	{
		_data_->_state_ = 1;
		gcr_pkcs11_initialize_async (_data_->cancellable, application_certificate_manager_is_gcr_enabled_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = gcr_pkcs11_initialize_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->init_okay = _data_->_tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp1_ = _data_->err;
		_data_->_tmp2_ = _data_->_tmp1_->message;
		g_warning ("application-certificate-manager.vala:46: Failed to initialise GCR PCKS" \
"#11 modules: %s", _data_->_tmp2_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->has_uris = FALSE;
	if (_data_->init_okay) {
		_data_->_tmp4_ = gcr_pkcs11_get_trust_store_uri ();
		if (!geary_string_is_empty (_data_->_tmp4_)) {
			_data_->_tmp6_ = _data_->_tmp5_ = gcr_pkcs11_get_trust_lookup_uris ();
			_data_->_tmp3_ = _vala_array_length (_data_->_tmp5_) > 0;
		} else {
			_data_->_tmp3_ = FALSE;
		}
		_data_->has_uris = _data_->_tmp3_;
		if (_data_->has_uris) {
			_data_->_tmp7_ = bool_to_string (_data_->has_uris);
			_data_->_tmp8_ = _data_->_tmp7_;
			g_debug ("application-certificate-manager.vala:56: GCR slot URIs found: %s", _data_->_tmp8_);
			_g_free0 (_data_->_tmp8_);
		} else {
			g_warning ("application-certificate-manager.vala:58: No GCR slot URIs found, GCR c" \
"ertificate pinning unavailable");
		}
	}
	_data_->has_rw_store = FALSE;
	if (_data_->has_uris) {
		_data_->_tmp9_ = gcr_pkcs11_get_trust_store_slot ();
		_data_->store = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->store;
		if (_data_->_tmp10_ != NULL) {
			_data_->_tmp11_ = _data_->store;
			_data_->has_rw_store = !gck_slot_has_flags (_data_->_tmp11_, APPLICATION_CERTIFICATE_MANAGER_CKF_WRITE_PROTECTED);
			_data_->_tmp12_ = bool_to_string (_data_->has_rw_store);
			_data_->_tmp13_ = _data_->_tmp12_;
			g_debug ("application-certificate-manager.vala:69: GCR store is R/W: %s", _data_->_tmp13_);
			_g_free0 (_data_->_tmp13_);
		} else {
			g_warning ("application-certificate-manager.vala:71: No GCR store found, GCR certi" \
"ficate pinning unavailable");
		}
		if (!_data_->has_rw_store) {
			g_warning ("application-certificate-manager.vala:75: GCR store is not RW, GCR cert" \
"ificate pinning unavailable");
		}
		_g_object_unref0 (_data_->store);
	}
	_data_->result = _data_->has_rw_store;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_certificate_manager_construct_data_free (gpointer _data)
{
	ApplicationCertificateManagerNewData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->store_dir);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationCertificateManagerNewData, _data_);
}

void
application_certificate_manager_construct (GType object_type,
                                           GFile* store_dir,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	ApplicationCertificateManagerNewData* _data_;
	GFile* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (store_dir, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationCertificateManagerNewData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_certificate_manager_construct_data_free);
	_data_->object_type = object_type;
	_tmp0_ = _g_object_ref0 (store_dir);
	_g_object_unref0 (_data_->store_dir);
	_data_->store_dir = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_certificate_manager_construct_co (_data_);
}

ApplicationCertificateManager*
application_certificate_manager_construct_finish (GAsyncResult* _res_)
{
	ApplicationCertificateManager* result;
	ApplicationCertificateManagerNewData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->self;
	_data_->self = NULL;
	return result;
}

/**
     * Constructs a new instance, globally installing the pinning database.
     */
static void
application_certificate_manager_new_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ApplicationCertificateManagerNewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_certificate_manager_construct_co (_data_);
}

static gboolean
application_certificate_manager_construct_co (ApplicationCertificateManagerNewData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self = (ApplicationCertificateManager*) g_object_new (_data_->object_type, NULL);
	_data_->_state_ = 1;
	application_certificate_manager_is_gcr_enabled (_data_->cancellable, application_certificate_manager_new_ready, _data_);
	return FALSE;
	_state_1:
	_data_->use_gcr = application_certificate_manager_is_gcr_enabled_finish (_data_->_res_);
	_data_->_tmp0_ = g_tls_backend_get_default ();
	_data_->_tmp1_ = g_tls_backend_get_default_database (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = application_tls_database_new (_data_->_tmp2_, _data_->store_dir, _data_->use_gcr);
	_g_object_unref0 (_data_->self->priv->pinning_database);
	_data_->self->priv->pinning_database = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->self->priv->pinning_database;
	_data_->_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, g_tls_database_get_type (), GTlsDatabase));
	_g_object_unref0 (geary_endpoint_default_tls_database);
	geary_endpoint_default_tls_database = _data_->_tmp5_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
application_certificate_manager_new (GFile* store_dir,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	application_certificate_manager_construct (APPLICATION_TYPE_CERTIFICATE_MANAGER, store_dir, cancellable, _callback_, _user_data_);
}

ApplicationCertificateManager*
application_certificate_manager_new_finish (GAsyncResult* _res_)
{
	return application_certificate_manager_construct_finish (_res_);
}

static void
application_certificate_manager_prompt_pin_certificate_data_free (gpointer _data)
{
	ApplicationCertificateManagerPromptPinCertificateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->parent);
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->service);
	_g_object_unref0 (_data_->endpoint);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationCertificateManagerPromptPinCertificateData, _data_);
}

void
application_certificate_manager_prompt_pin_certificate (ApplicationCertificateManager* self,
                                                        GtkWindow* parent,
                                                        GearyAccountInformation* account,
                                                        GearyServiceInformation* service,
                                                        GearyEndpoint* endpoint,
                                                        gboolean is_validation,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	ApplicationCertificateManagerPromptPinCertificateData* _data_;
	ApplicationCertificateManager* _tmp0_;
	GtkWindow* _tmp1_;
	GearyAccountInformation* _tmp2_;
	GearyServiceInformation* _tmp3_;
	GearyEndpoint* _tmp4_;
	GCancellable* _tmp5_;
	g_return_if_fail (APPLICATION_IS_CERTIFICATE_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (parent, gtk_window_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (endpoint, GEARY_TYPE_ENDPOINT));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationCertificateManagerPromptPinCertificateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_certificate_manager_prompt_pin_certificate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (parent);
	_g_object_unref0 (_data_->parent);
	_data_->parent = _tmp1_;
	_tmp2_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp2_;
	_tmp3_ = _g_object_ref0 (service);
	_g_object_unref0 (_data_->service);
	_data_->service = _tmp3_;
	_tmp4_ = _g_object_ref0 (endpoint);
	_g_object_unref0 (_data_->endpoint);
	_data_->endpoint = _tmp4_;
	_data_->is_validation = is_validation;
	_tmp5_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp5_;
	application_certificate_manager_prompt_pin_certificate_co (_data_);
}

void
application_certificate_manager_prompt_pin_certificate_finish (ApplicationCertificateManager* self,
                                                               GAsyncResult* _res_,
                                                               GError** error)
{
	ApplicationCertificateManagerPromptPinCertificateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Prompts the user to trust the certificate for a service.
     *
     * Returns true if the user accepted the certificate.
     */
static void
application_certificate_manager_prompt_pin_certificate_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	ApplicationCertificateManagerPromptPinCertificateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_certificate_manager_prompt_pin_certificate_co (_data_);
}

static gboolean
application_certificate_manager_prompt_pin_certificate_co (ApplicationCertificateManagerPromptPinCertificateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = certificate_warning_dialog_new (_data_->parent, _data_->account, _data_->service, _data_->endpoint, _data_->is_validation);
	_data_->dialog = _data_->_tmp0_;
	_data_->save = FALSE;
	_data_->_tmp1_ = _data_->dialog;
	switch (certificate_warning_dialog_run (_data_->_tmp1_)) {
		case CERTIFICATE_WARNING_DIALOG_RESULT_TRUST:
		{
			break;
		}
		case CERTIFICATE_WARNING_DIALOG_RESULT_ALWAYS_TRUST:
		{
			_data_->save = TRUE;
			break;
		}
		default:
		{
			_data_->_tmp2_ = g_error_new_literal (APPLICATION_CERTIFICATE_MANAGER_ERROR, APPLICATION_CERTIFICATE_MANAGER_ERROR_UNTRUSTED, "User declined");
			_data_->_inner_error0_ = _data_->_tmp2_;
			if (_data_->_inner_error0_->domain == APPLICATION_CERTIFICATE_MANAGER_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_certificate_warning_dialog_unref0 (_data_->dialog);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_certificate_warning_dialog_unref0 (_data_->dialog);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->_tmp3_ = geary_endpoint_get_remote (_data_->endpoint);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_socket_connectable_to_string (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	g_debug ("application-certificate-manager.vala:138: Pinning certificate for %s.." \
".", _data_->_tmp6_);
	_g_free0 (_data_->_tmp6_);
	{
		_data_->_tmp7_ = _data_->self->priv->pinning_database;
		_data_->_tmp8_ = geary_endpoint_get_untrusted_certificate (_data_->endpoint);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = geary_endpoint_get_remote (_data_->endpoint);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_state_ = 1;
		application_tls_database_pin_certificate (_data_->_tmp7_, _data_->_tmp9_, _data_->_tmp11_, _data_->save, _data_->cancellable, application_certificate_manager_prompt_pin_certificate_ready, _data_);
		return FALSE;
		_state_1:
		application_tls_database_pin_certificate_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->err;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		_data_->_tmp14_ = g_error_new_literal (APPLICATION_CERTIFICATE_MANAGER_ERROR, APPLICATION_CERTIFICATE_MANAGER_ERROR_STORE_FAILED, _data_->_tmp13_);
		_data_->_inner_error0_ = _data_->_tmp14_;
		_g_error_free0 (_data_->err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == APPLICATION_CERTIFICATE_MANAGER_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_certificate_warning_dialog_unref0 (_data_->dialog);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_certificate_warning_dialog_unref0 (_data_->dialog);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_certificate_warning_dialog_unref0 (_data_->dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_certificate_manager_class_init (ApplicationCertificateManagerClass * klass,
                                            gpointer klass_data)
{
	application_certificate_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationCertificateManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = application_certificate_manager_finalize;
}

static void
application_certificate_manager_instance_init (ApplicationCertificateManager * self,
                                               gpointer klass)
{
	self->priv = application_certificate_manager_get_instance_private (self);
}

static void
application_certificate_manager_finalize (GObject * obj)
{
	ApplicationCertificateManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_CERTIFICATE_MANAGER, ApplicationCertificateManager);
	_g_object_unref0 (geary_endpoint_default_tls_database);
	geary_endpoint_default_tls_database = NULL;
	_g_object_unref0 (self->priv->pinning_database);
	G_OBJECT_CLASS (application_certificate_manager_parent_class)->finalize (obj);
}

/**
 * Managing TLS certificate prompting and storage.
 */
static GType
application_certificate_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationCertificateManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_certificate_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationCertificateManager), 0, (GInstanceInitFunc) application_certificate_manager_instance_init, NULL };
	GType application_certificate_manager_type_id;
	application_certificate_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ApplicationCertificateManager", &g_define_type_info, 0);
	ApplicationCertificateManager_private_offset = g_type_add_instance_private (application_certificate_manager_type_id, sizeof (ApplicationCertificateManagerPrivate));
	return application_certificate_manager_type_id;
}

GType
application_certificate_manager_get_type (void)
{
	static volatile gsize application_certificate_manager_type_id__once = 0;
	if (g_once_init_enter (&application_certificate_manager_type_id__once)) {
		GType application_certificate_manager_type_id;
		application_certificate_manager_type_id = application_certificate_manager_get_type_once ();
		g_once_init_leave (&application_certificate_manager_type_id__once, application_certificate_manager_type_id);
	}
	return application_certificate_manager_type_id__once;
}

static inline gpointer
application_tls_database_get_instance_private (ApplicationTlsDatabase* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationTlsDatabase_private_offset);
}

static gchar*
application_tls_database_to_name (GSocketConnectable* id)
{
	GNetworkAddress* name = NULL;
	GNetworkAddress* _tmp0_;
	GNetworkAddress* _tmp1_;
	GNetworkService* service = NULL;
	GNetworkService* _tmp6_;
	GNetworkService* _tmp7_;
	GInetSocketAddress* inet = NULL;
	GInetSocketAddress* _tmp12_;
	GInetSocketAddress* _tmp13_;
	gchar* _tmp18_;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (id, g_socket_connectable_get_type ()), NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (id, g_network_address_get_type ()) ? ((GNetworkAddress*) id) : NULL);
	name = _tmp0_;
	_tmp1_ = name;
	if (_tmp1_ != NULL) {
		GNetworkAddress* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = name;
		_tmp3_ = g_network_address_get_hostname (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (name);
		return result;
	}
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (id, g_network_service_get_type ()) ? ((GNetworkService*) id) : NULL);
	service = _tmp6_;
	_tmp7_ = service;
	if (_tmp7_ != NULL) {
		GNetworkService* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = service;
		_tmp9_ = g_network_service_get_domain (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		_g_object_unref0 (service);
		_g_object_unref0 (name);
		return result;
	}
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (id, g_inet_socket_address_get_type ()) ? ((GInetSocketAddress*) id) : NULL);
	inet = _tmp12_;
	_tmp13_ = inet;
	if (_tmp13_ != NULL) {
		GInetSocketAddress* _tmp14_;
		GInetAddress* _tmp15_;
		GInetAddress* _tmp16_;
		gchar* _tmp17_;
		_tmp14_ = inet;
		_tmp15_ = g_inet_socket_address_get_address (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_inet_address_to_string (_tmp16_);
		result = _tmp17_;
		_g_object_unref0 (inet);
		_g_object_unref0 (service);
		_g_object_unref0 (name);
		return result;
	}
	_tmp18_ = g_socket_connectable_to_string (id);
	result = _tmp18_;
	_g_object_unref0 (inet);
	_g_object_unref0 (service);
	_g_object_unref0 (name);
	return result;
}

static GTlsDatabase*
application_tls_database_get_parent (ApplicationTlsDatabase* self)
{
	GTlsDatabase* result;
	GTlsDatabase* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_TLS_DATABASE (self), NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}

static void
application_tls_database_set_parent (ApplicationTlsDatabase* self,
                                     GTlsDatabase* value)
{
	GTlsDatabase* _tmp0_;
	g_return_if_fail (APPLICATION_IS_TLS_DATABASE (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_parent);
	self->priv->_parent = _tmp0_;
}

ApplicationTlsDatabase*
application_tls_database_construct (GType object_type,
                                    GTlsDatabase* parent,
                                    GFile* store_dir,
                                    gboolean use_gcr)
{
	ApplicationTlsDatabase * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (parent, g_tls_database_get_type ()), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (store_dir, g_file_get_type ()), NULL);
	self = (ApplicationTlsDatabase*) g_object_new (object_type, NULL);
	application_tls_database_set_parent (self, parent);
	_tmp0_ = _g_object_ref0 (store_dir);
	_g_object_unref0 (self->priv->store_dir);
	self->priv->store_dir = _tmp0_;
	self->priv->use_gcr = use_gcr;
	return self;
}

ApplicationTlsDatabase*
application_tls_database_new (GTlsDatabase* parent,
                              GFile* store_dir,
                              gboolean use_gcr)
{
	return application_tls_database_construct (APPLICATION_TYPE_TLS_DATABASE, parent, store_dir, use_gcr);
}

static void
application_tls_database_pin_certificate_data_free (gpointer _data)
{
	ApplicationTlsDatabasePinCertificateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->certificate);
	_g_object_unref0 (_data_->identity);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationTlsDatabasePinCertificateData, _data_);
}

void
application_tls_database_pin_certificate (ApplicationTlsDatabase* self,
                                          GTlsCertificate* certificate,
                                          GSocketConnectable* identity,
                                          gboolean save,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	ApplicationTlsDatabasePinCertificateData* _data_;
	ApplicationTlsDatabase* _tmp0_;
	GTlsCertificate* _tmp1_;
	GSocketConnectable* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (APPLICATION_IS_TLS_DATABASE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (certificate, g_tls_certificate_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (identity, g_socket_connectable_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationTlsDatabasePinCertificateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_tls_database_pin_certificate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (certificate);
	_g_object_unref0 (_data_->certificate);
	_data_->certificate = _tmp1_;
	_tmp2_ = _g_object_ref0 (identity);
	_g_object_unref0 (_data_->identity);
	_data_->identity = _tmp2_;
	_data_->save = save;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_tls_database_pin_certificate_co (_data_);
}

void
application_tls_database_pin_certificate_finish (ApplicationTlsDatabase* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	ApplicationTlsDatabasePinCertificateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
application_tls_database_pin_certificate_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	ApplicationTlsDatabasePinCertificateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_tls_database_pin_certificate_co (_data_);
}

static gboolean
application_tls_database_pin_certificate_co (ApplicationTlsDatabasePinCertificateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = application_tls_database_to_name (_data_->identity);
	_data_->id = _data_->_tmp0_;
	_data_->_tmp1_ = application_tls_database_trust_context_new (_data_->certificate);
	_data_->context = _data_->_tmp1_;
	{
		_data_->_tmp2_ = _data_->self->priv->pinned_certs;
		g_rec_mutex_lock (&_data_->self->priv->__lock_pinned_certs);
		{
			_data_->_tmp3_ = _data_->self->priv->pinned_certs;
			_data_->_tmp4_ = _data_->id;
			_data_->_tmp5_ = _data_->context;
			gee_map_set (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_);
		}
		__finally0:
		{
			_data_->_tmp6_ = _data_->self->priv->pinned_certs;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_pinned_certs);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->context);
			_g_free0 (_data_->id);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->save) {
		if (_data_->self->priv->use_gcr) {
			g_object_get (_data_->certificate, "certificate", &_data_->_tmp7_, NULL);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = _data_->_tmp9_->data;
			_data_->_tmp10__length1 = _data_->_tmp9_->len;
			_data_->_tmp11_ = (GcrSimpleCertificate*) gcr_simple_certificate_new (_data_->_tmp10_, _data_->_tmp10__length1);
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp13_ = _data_->id;
			_data_->_state_ = 1;
			gcr_trust_add_pinned_certificate_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, gcr_certificate_get_type (), GcrCertificate), G_TLS_DATABASE_PURPOSE_AUTHENTICATE_SERVER, _data_->_tmp13_, _data_->cancellable, application_tls_database_pin_certificate_ready, _data_);
			return FALSE;
			_state_1:
			gcr_trust_add_pinned_certificate_finish (_data_->_res_, &_data_->_inner_error0_);
			_g_object_unref0 (_data_->_tmp12_);
			_g_byte_array_unref0 (_data_->_tmp9_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->context);
				_g_free0 (_data_->id);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		} else {
			_data_->_tmp14_ = _data_->context;
			_data_->_tmp15_ = _data_->self->priv->store_dir;
			_data_->_tmp16_ = application_tls_database_to_name (_data_->identity);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_state_ = 2;
			application_tls_database_trust_context_save (_data_->_tmp14_, _data_->_tmp15_, _data_->_tmp17_, _data_->cancellable, application_tls_database_pin_certificate_ready, _data_);
			return FALSE;
			_state_2:
			application_tls_database_trust_context_save_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
			_g_free0 (_data_->_tmp17_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->context);
				_g_free0 (_data_->id);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_g_object_unref0 (_data_->context);
	_g_free0 (_data_->id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
application_tls_database_real_create_certificate_handle (GTlsDatabase* base,
                                                         GTlsCertificate* certificate)
{
	ApplicationTlsDatabase * self;
	ApplicationTlsDatabaseTrustContext* context = NULL;
	ApplicationTlsDatabaseTrustContext* _tmp0_;
	gchar* _tmp1_ = NULL;
	ApplicationTlsDatabaseTrustContext* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (certificate, g_tls_certificate_get_type ()), NULL);
	_tmp0_ = application_tls_database_lookup_tls_certificate (self, certificate);
	context = _tmp0_;
	_tmp2_ = context;
	if (_tmp2_ != NULL) {
		ApplicationTlsDatabaseTrustContext* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = context;
		_tmp4_ = _tmp3_->id;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp5_;
	} else {
		GTlsDatabase* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = self->priv->_parent;
		_tmp7_ = g_tls_database_create_certificate_handle (_tmp6_, certificate);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp7_;
	}
	result = _tmp1_;
	_g_object_unref0 (context);
	return result;
}

static GTlsCertificate*
application_tls_database_real_lookup_certificate_for_handle (GTlsDatabase* base,
                                                             const gchar* handle,
                                                             GTlsInteraction* interaction,
                                                             GTlsDatabaseLookupFlags flags,
                                                             GCancellable* cancellable,
                                                             GError** error)
{
	ApplicationTlsDatabase * self;
	ApplicationTlsDatabaseTrustContext* context = NULL;
	ApplicationTlsDatabaseTrustContext* _tmp0_;
	GTlsCertificate* _tmp1_ = NULL;
	ApplicationTlsDatabaseTrustContext* _tmp2_;
	GError* _inner_error0_ = NULL;
	GTlsCertificate* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	g_return_val_if_fail (handle != NULL, NULL);
	g_return_val_if_fail ((interaction == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (interaction, g_tls_interaction_get_type ()), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = application_tls_database_lookup_id (self, handle);
	context = _tmp0_;
	_tmp2_ = context;
	if (_tmp2_ != NULL) {
		ApplicationTlsDatabaseTrustContext* _tmp3_;
		GTlsCertificate* _tmp4_;
		GTlsCertificate* _tmp5_;
		_tmp3_ = context;
		_tmp4_ = _tmp3_->certificate;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp5_;
	} else {
		GTlsDatabase* _tmp6_;
		GTlsCertificate* _tmp7_;
		_tmp6_ = self->priv->_parent;
		_tmp7_ = g_tls_database_lookup_certificate_for_handle (_tmp6_, handle, interaction, flags, cancellable, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (context);
			return NULL;
		}
	}
	result = _tmp1_;
	_g_object_unref0 (context);
	return result;
}

static void
application_tls_database_real_lookup_certificate_for_handle_async_data_free (gpointer _data)
{
	ApplicationTlsDatabaseLookupCertificateForHandleAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->handle);
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationTlsDatabaseLookupCertificateForHandleAsyncData, _data_);
}

static void
application_tls_database_real_lookup_certificate_for_handle_async (GTlsDatabase* base,
                                                                   const gchar* handle,
                                                                   GTlsInteraction* interaction,
                                                                   GTlsDatabaseLookupFlags flags,
                                                                   GCancellable* cancellable,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_)
{
	ApplicationTlsDatabase * self;
	ApplicationTlsDatabaseLookupCertificateForHandleAsyncData* _data_;
	ApplicationTlsDatabase* _tmp0_;
	gchar* _tmp1_;
	GTlsInteraction* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (handle != NULL);
	g_return_if_fail ((interaction == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (interaction, g_tls_interaction_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	_data_ = g_slice_new0 (ApplicationTlsDatabaseLookupCertificateForHandleAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_tls_database_real_lookup_certificate_for_handle_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (handle);
	_g_free0 (_data_->handle);
	_data_->handle = _tmp1_;
	_tmp2_ = _g_object_ref0 (interaction);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp2_;
	_data_->flags = flags;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_tls_database_real_lookup_certificate_for_handle_async_co (_data_);
}

static GTlsCertificate*
application_tls_database_lookup_certificate_for_handle_finish (GTlsDatabase* base,
                                                               GAsyncResult* _res_,
                                                               GError** error)
{
	GTlsCertificate* result;
	ApplicationTlsDatabaseLookupCertificateForHandleAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_tls_database_lookup_certificate_for_handle_async_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_)
{
	ApplicationTlsDatabaseLookupCertificateForHandleAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_tls_database_real_lookup_certificate_for_handle_async_co (_data_);
}

static gboolean
application_tls_database_real_lookup_certificate_for_handle_async_co (ApplicationTlsDatabaseLookupCertificateForHandleAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = application_tls_database_lookup_id (_data_->self, _data_->handle);
	_data_->context = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->context;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->context;
		_data_->_tmp4_ = _data_->_tmp3_->certificate;
		_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
		_g_object_unref0 (_data_->_tmp1_);
		_data_->_tmp1_ = _data_->_tmp5_;
	} else {
		_data_->_tmp6_ = _data_->self->priv->_parent;
		_data_->_state_ = 1;
		g_tls_database_lookup_certificate_for_handle_async (_data_->_tmp6_, _data_->handle, _data_->interaction, _data_->flags, _data_->cancellable, application_tls_database_lookup_certificate_for_handle_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = g_tls_database_lookup_certificate_for_handle_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp1_);
		_data_->_tmp1_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->_tmp1_);
			_g_object_unref0 (_data_->context);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->_tmp1_;
	_g_object_unref0 (_data_->context);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GTlsCertificate*
application_tls_database_real_lookup_certificate_issuer (GTlsDatabase* base,
                                                         GTlsCertificate* certificate,
                                                         GTlsInteraction* interaction,
                                                         GTlsDatabaseLookupFlags flags,
                                                         GCancellable* cancellable,
                                                         GError** error)
{
	ApplicationTlsDatabase * self;
	GTlsCertificate* _tmp0_ = NULL;
	GTlsDatabase* _tmp1_;
	GTlsCertificate* _tmp2_;
	GTlsCertificate* _tmp3_;
	GError* _inner_error0_ = NULL;
	GTlsCertificate* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (certificate, g_tls_certificate_get_type ()), NULL);
	g_return_val_if_fail ((interaction == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (interaction, g_tls_interaction_get_type ()), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp1_ = self->priv->_parent;
	_tmp2_ = g_tls_database_lookup_certificate_issuer (_tmp1_, certificate, interaction, flags, cancellable, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
application_tls_database_real_lookup_certificate_issuer_async_data_free (gpointer _data)
{
	ApplicationTlsDatabaseLookupCertificateIssuerAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->certificate);
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationTlsDatabaseLookupCertificateIssuerAsyncData, _data_);
}

static void
application_tls_database_real_lookup_certificate_issuer_async (GTlsDatabase* base,
                                                               GTlsCertificate* certificate,
                                                               GTlsInteraction* interaction,
                                                               GTlsDatabaseLookupFlags flags,
                                                               GCancellable* cancellable,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_)
{
	ApplicationTlsDatabase * self;
	ApplicationTlsDatabaseLookupCertificateIssuerAsyncData* _data_;
	ApplicationTlsDatabase* _tmp0_;
	GTlsCertificate* _tmp1_;
	GTlsInteraction* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (certificate, g_tls_certificate_get_type ()));
	g_return_if_fail ((interaction == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (interaction, g_tls_interaction_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	_data_ = g_slice_new0 (ApplicationTlsDatabaseLookupCertificateIssuerAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_tls_database_real_lookup_certificate_issuer_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (certificate);
	_g_object_unref0 (_data_->certificate);
	_data_->certificate = _tmp1_;
	_tmp2_ = _g_object_ref0 (interaction);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp2_;
	_data_->flags = flags;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_tls_database_real_lookup_certificate_issuer_async_co (_data_);
}

static GTlsCertificate*
application_tls_database_lookup_certificate_issuer_finish (GTlsDatabase* base,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	GTlsCertificate* result;
	ApplicationTlsDatabaseLookupCertificateIssuerAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_tls_database_lookup_certificate_issuer_async_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	ApplicationTlsDatabaseLookupCertificateIssuerAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_tls_database_real_lookup_certificate_issuer_async_co (_data_);
}

static gboolean
application_tls_database_real_lookup_certificate_issuer_async_co (ApplicationTlsDatabaseLookupCertificateIssuerAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_parent;
	_data_->_state_ = 1;
	g_tls_database_lookup_certificate_issuer_async (_data_->_tmp1_, _data_->certificate, _data_->interaction, _data_->flags, _data_->cancellable, application_tls_database_lookup_certificate_issuer_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = g_tls_database_lookup_certificate_issuer_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static GList*
application_tls_database_real_lookup_certificates_issued_by (GTlsDatabase* base,
                                                             GByteArray* issuer_raw_dn,
                                                             GTlsInteraction* interaction,
                                                             GTlsDatabaseLookupFlags flags,
                                                             GCancellable* cancellable,
                                                             GError** error)
{
	ApplicationTlsDatabase * self;
	GList* _tmp0_ = NULL;
	GTlsDatabase* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GError* _inner_error0_ = NULL;
	GList* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	g_return_val_if_fail (issuer_raw_dn != NULL, NULL);
	g_return_val_if_fail ((interaction == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (interaction, g_tls_interaction_get_type ()), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp1_ = self->priv->_parent;
	_tmp2_ = g_tls_database_lookup_certificates_issued_by (_tmp1_, issuer_raw_dn, interaction, flags, cancellable, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (_g_list_free__g_object_unref0_ (_tmp0_), NULL));
	return result;
}

static void
application_tls_database_real_lookup_certificates_issued_by_async_data_free (gpointer _data)
{
	ApplicationTlsDatabaseLookupCertificatesIssuedByAsyncData* _data_;
	_data_ = _data;
	_g_byte_array_unref0 (_data_->issuer_raw_dn);
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	(_data_->result == NULL) ? NULL : (_data_->result = (_g_list_free__g_object_unref0_ (_data_->result), NULL));
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationTlsDatabaseLookupCertificatesIssuedByAsyncData, _data_);
}

static gpointer
_g_byte_array_ref0 (gpointer self)
{
	return self ? g_byte_array_ref (self) : NULL;
}

static void
application_tls_database_real_lookup_certificates_issued_by_async (GTlsDatabase* base,
                                                                   GByteArray* issuer_raw_dn,
                                                                   GTlsInteraction* interaction,
                                                                   GTlsDatabaseLookupFlags flags,
                                                                   GCancellable* cancellable,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_)
{
	ApplicationTlsDatabase * self;
	ApplicationTlsDatabaseLookupCertificatesIssuedByAsyncData* _data_;
	ApplicationTlsDatabase* _tmp0_;
	GByteArray* _tmp1_;
	GTlsInteraction* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (issuer_raw_dn != NULL);
	g_return_if_fail ((interaction == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (interaction, g_tls_interaction_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	_data_ = g_slice_new0 (ApplicationTlsDatabaseLookupCertificatesIssuedByAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_tls_database_real_lookup_certificates_issued_by_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_byte_array_ref0 (issuer_raw_dn);
	_g_byte_array_unref0 (_data_->issuer_raw_dn);
	_data_->issuer_raw_dn = _tmp1_;
	_tmp2_ = _g_object_ref0 (interaction);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp2_;
	_data_->flags = flags;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_tls_database_real_lookup_certificates_issued_by_async_co (_data_);
}

static GList*
application_tls_database_lookup_certificates_issued_by_finish (GTlsDatabase* base,
                                                               GAsyncResult* _res_,
                                                               GError** error)
{
	GList* result;
	ApplicationTlsDatabaseLookupCertificatesIssuedByAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_tls_database_lookup_certificates_issued_by_async_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_)
{
	ApplicationTlsDatabaseLookupCertificatesIssuedByAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_tls_database_real_lookup_certificates_issued_by_async_co (_data_);
}

static gboolean
application_tls_database_real_lookup_certificates_issued_by_async_co (ApplicationTlsDatabaseLookupCertificatesIssuedByAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_parent;
	_data_->_state_ = 1;
	g_tls_database_lookup_certificates_issued_by_async (_data_->_tmp1_, _data_->issuer_raw_dn, _data_->interaction, _data_->flags, _data_->cancellable, application_tls_database_lookup_certificates_issued_by_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = g_tls_database_lookup_certificates_issued_by_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp3_;
	(_data_->_tmp0_ == NULL) ? NULL : (_data_->_tmp0_ = (_g_list_free__g_object_unref0_ (_data_->_tmp0_), NULL));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GTlsCertificateFlags
application_tls_database_real_verify_chain (GTlsDatabase* base,
                                            GTlsCertificate* chain,
                                            const gchar* purpose,
                                            GSocketConnectable* identity,
                                            GTlsInteraction* interaction,
                                            GTlsDatabaseVerifyFlags flags,
                                            GCancellable* cancellable,
                                            GError** error)
{
	ApplicationTlsDatabase * self;
	GTlsCertificateFlags ret = 0U;
	GTlsDatabase* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	GTlsCertificateFlags result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chain, g_tls_certificate_get_type ()), 0U);
	g_return_val_if_fail (purpose != NULL, 0U);
	g_return_val_if_fail ((identity == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (identity, g_socket_connectable_get_type ()), 0U);
	g_return_val_if_fail ((interaction == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (interaction, g_tls_interaction_get_type ()), 0U);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), 0U);
	_tmp0_ = self->priv->_parent;
	ret = g_tls_database_verify_chain (_tmp0_, chain, purpose, identity, interaction, flags, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0U;
	}
	if (application_tls_database_check_pinned (self, ret, purpose, identity)) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = application_tls_database_is_pinned (self, chain, identity, cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return 0U;
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ret = 0;
	}
	result = ret;
	return result;
}

static void
application_tls_database_real_verify_chain_async_data_free (gpointer _data)
{
	ApplicationTlsDatabaseVerifyChainAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->chain);
	_g_free0 (_data_->purpose);
	_g_object_unref0 (_data_->identity);
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationTlsDatabaseVerifyChainAsyncData, _data_);
}

static void
application_tls_database_real_verify_chain_async (GTlsDatabase* base,
                                                  GTlsCertificate* chain,
                                                  const gchar* purpose,
                                                  GSocketConnectable* identity,
                                                  GTlsInteraction* interaction,
                                                  GTlsDatabaseVerifyFlags flags,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	ApplicationTlsDatabase * self;
	ApplicationTlsDatabaseVerifyChainAsyncData* _data_;
	ApplicationTlsDatabase* _tmp0_;
	GTlsCertificate* _tmp1_;
	gchar* _tmp2_;
	GSocketConnectable* _tmp3_;
	GTlsInteraction* _tmp4_;
	GCancellable* _tmp5_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chain, g_tls_certificate_get_type ()));
	g_return_if_fail (purpose != NULL);
	g_return_if_fail ((identity == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (identity, g_socket_connectable_get_type ()));
	g_return_if_fail ((interaction == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (interaction, g_tls_interaction_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	_data_ = g_slice_new0 (ApplicationTlsDatabaseVerifyChainAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_tls_database_real_verify_chain_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (chain);
	_g_object_unref0 (_data_->chain);
	_data_->chain = _tmp1_;
	_tmp2_ = g_strdup (purpose);
	_g_free0 (_data_->purpose);
	_data_->purpose = _tmp2_;
	_tmp3_ = _g_object_ref0 (identity);
	_g_object_unref0 (_data_->identity);
	_data_->identity = _tmp3_;
	_tmp4_ = _g_object_ref0 (interaction);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp4_;
	_data_->flags = flags;
	_tmp5_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp5_;
	application_tls_database_real_verify_chain_async_co (_data_);
}

static GTlsCertificateFlags
application_tls_database_verify_chain_finish (GTlsDatabase* base,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GTlsCertificateFlags result;
	ApplicationTlsDatabaseVerifyChainAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return 0U;
	}
	result = _data_->result;
	return result;
}

static void
application_tls_database_verify_chain_async_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	ApplicationTlsDatabaseVerifyChainAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_tls_database_real_verify_chain_async_co (_data_);
}

static gboolean
application_tls_database_real_verify_chain_async_co (ApplicationTlsDatabaseVerifyChainAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_parent;
	_data_->_state_ = 1;
	g_tls_database_verify_chain_async (_data_->_tmp0_, _data_->chain, _data_->purpose, _data_->identity, _data_->interaction, _data_->flags, _data_->cancellable, application_tls_database_verify_chain_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->ret = g_tls_database_verify_chain_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (application_tls_database_check_pinned (_data_->self, _data_->ret, _data_->purpose, _data_->identity)) {
		_data_->_state_ = 2;
		application_tls_database_is_pinned_async (_data_->self, _data_->chain, _data_->identity, _data_->cancellable, application_tls_database_verify_chain_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp2_ = application_tls_database_is_pinned_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp1_ = _data_->_tmp2_;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		_data_->ret = 0;
	}
	_data_->result = _data_->ret;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static inline gboolean
application_tls_database_check_pinned (ApplicationTlsDatabase* self,
                                       GTlsCertificateFlags parent_ret,
                                       const gchar* purpose,
                                       GSocketConnectable* identity)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_TLS_DATABASE (self), FALSE);
	g_return_val_if_fail (purpose != NULL, FALSE);
	g_return_val_if_fail ((identity == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (identity, g_socket_connectable_get_type ()), FALSE);
	if (parent_ret != 0) {
		_tmp2_ = !((parent_ret & G_TLS_CERTIFICATE_REVOKED) == G_TLS_CERTIFICATE_REVOKED);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_strcmp0 (purpose, G_TLS_DATABASE_PURPOSE_AUTHENTICATE_SERVER) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = identity != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
application_tls_database_is_pinned (ApplicationTlsDatabase* self,
                                    GTlsCertificate* chain,
                                    GSocketConnectable* identity,
                                    GCancellable* cancellable,
                                    GError** error)
{
	gboolean is_pinned = FALSE;
	gchar* id = NULL;
	gchar* _tmp0_;
	ApplicationTlsDatabaseTrustContext* context = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_TLS_DATABASE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chain, g_tls_certificate_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (identity, g_socket_connectable_get_type ()), FALSE);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), FALSE);
	is_pinned = FALSE;
	_tmp0_ = application_tls_database_to_name (identity);
	id = _tmp0_;
	context = NULL;
	{
		GeeMap* _tmp1_;
		_tmp1_ = self->priv->pinned_certs;
		g_rec_mutex_lock (&self->priv->__lock_pinned_certs);
		{
			GeeMap* _tmp2_;
			const gchar* _tmp3_;
			gpointer _tmp4_;
			ApplicationTlsDatabaseTrustContext* _tmp5_;
			_tmp2_ = self->priv->pinned_certs;
			_tmp3_ = id;
			_tmp4_ = gee_map_get (_tmp2_, _tmp3_);
			_g_object_unref0 (context);
			context = (ApplicationTlsDatabaseTrustContext*) _tmp4_;
			_tmp5_ = context;
			if (_tmp5_ != NULL) {
				ApplicationTlsDatabaseTrustContext* _tmp6_;
				GTlsCertificate* _tmp7_;
				_tmp6_ = context;
				_tmp7_ = _tmp6_->certificate;
				is_pinned = g_tls_certificate_is_same (_tmp7_, chain);
			} else {
				if (self->priv->use_gcr) {
					gboolean _tmp8_ = FALSE;
					GByteArray* _tmp9_;
					GByteArray* _tmp10_;
					GByteArray* _tmp11_;
					guint8* _tmp12_;
					gint _tmp12__length1;
					GcrSimpleCertificate* _tmp13_;
					GcrSimpleCertificate* _tmp14_;
					const gchar* _tmp15_;
					gboolean _tmp16_;
					g_object_get (chain, "certificate", &_tmp9_, NULL);
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_;
					_tmp12_ = _tmp11_->data;
					_tmp12__length1 = _tmp11_->len;
					_tmp13_ = (GcrSimpleCertificate*) gcr_simple_certificate_new (_tmp12_, _tmp12__length1);
					_tmp14_ = _tmp13_;
					_tmp15_ = id;
					_tmp16_ = gcr_trust_is_certificate_pinned (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gcr_certificate_get_type (), GcrCertificate), G_TLS_DATABASE_PURPOSE_AUTHENTICATE_SERVER, _tmp15_, cancellable, &_inner_error0_);
					_g_object_unref0 (_tmp14_);
					_g_byte_array_unref0 (_tmp11_);
					_tmp8_ = _tmp16_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					is_pinned = _tmp8_;
				}
				if (!is_pinned) {
					{
						ApplicationTlsDatabaseTrustContext* _tmp17_ = NULL;
						GFile* _tmp18_;
						const gchar* _tmp19_;
						ApplicationTlsDatabaseTrustContext* _tmp20_;
						ApplicationTlsDatabaseTrustContext* _tmp21_;
						GeeMap* _tmp22_;
						const gchar* _tmp23_;
						ApplicationTlsDatabaseTrustContext* _tmp24_;
						ApplicationTlsDatabaseTrustContext* _tmp25_;
						GTlsCertificate* _tmp26_;
						_tmp18_ = self->priv->store_dir;
						_tmp19_ = id;
						_tmp20_ = application_tls_database_trust_context_new_lookup (_tmp18_, _tmp19_, cancellable, &_inner_error0_);
						_tmp17_ = _tmp20_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
								goto __catch1_g_io_error_not_found;
							}
							goto __catch1_g_error;
						}
						_tmp21_ = _tmp17_;
						_tmp17_ = NULL;
						_g_object_unref0 (context);
						context = _tmp21_;
						_tmp22_ = self->priv->pinned_certs;
						_tmp23_ = id;
						_tmp24_ = context;
						gee_map_set (_tmp22_, _tmp23_, _tmp24_);
						_tmp25_ = context;
						_tmp26_ = _tmp25_->certificate;
						is_pinned = g_tls_certificate_is_same (_tmp26_, chain);
						_g_object_unref0 (_tmp17_);
					}
					goto __finally1;
					__catch1_g_io_error_not_found:
					{
						g_clear_error (&_inner_error0_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* err = NULL;
						GearyErrorContext* err_context = NULL;
						GError* _tmp27_;
						GearyErrorContext* _tmp28_;
						GearyErrorContext* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						err = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp27_ = err;
						_tmp28_ = geary_error_context_new (_tmp27_);
						err_context = _tmp28_;
						_tmp29_ = err_context;
						_tmp30_ = geary_error_context_format_full_error (_tmp29_);
						_tmp31_ = _tmp30_;
						g_debug ("application-certificate-manager.vala:465: Error loading pinned certifi" \
"cate: %s", _tmp31_);
						_g_free0 (_tmp31_);
						_g_object_unref0 (err_context);
						_g_error_free0 (err);
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _lock_error_ = NULL;
			GError* _tmp32_;
			_lock_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp32_ = _lock_error_;
			_lock_error_ = NULL;
			_inner_error0_ = _tmp32_;
			_g_error_free0 (_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			GeeMap* _tmp33_;
			_tmp33_ = self->priv->pinned_certs;
			g_rec_mutex_unlock (&self->priv->__lock_pinned_certs);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp34_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (context);
			_g_free0 (id);
			return _tmp34_;
		}
	}
	result = is_pinned;
	_g_object_unref0 (context);
	_g_free0 (id);
	return result;
}

static void
application_tls_database_is_pinned_async_data_free (gpointer _data)
{
	ApplicationTlsDatabaseIsPinnedAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationTlsDatabaseIsPinnedAsyncData, _data_);
}

static void
application_tls_database_is_pinned_async (ApplicationTlsDatabase* self,
                                          GTlsCertificate* chain,
                                          GSocketConnectable* identity,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	ApplicationTlsDatabaseIsPinnedAsyncData* _data_;
	ApplicationTlsDatabase* _tmp0_;
	GTlsCertificate* _tmp1_;
	GSocketConnectable* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (APPLICATION_IS_TLS_DATABASE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chain, g_tls_certificate_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (identity, g_socket_connectable_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationTlsDatabaseIsPinnedAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_tls_database_is_pinned_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (chain);
	_g_object_unref0 (_data_->chain);
	_data_->chain = _tmp1_;
	_tmp2_ = _g_object_ref0 (identity);
	_g_object_unref0 (_data_->identity);
	_data_->identity = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_tls_database_is_pinned_async_co (_data_);
}

static gboolean
application_tls_database_is_pinned_finish (ApplicationTlsDatabase* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	gboolean result;
	ApplicationTlsDatabaseIsPinnedAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ApplicationTlsDatabase* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->chain);
		_g_object_unref0 (_data2_->identity);
		_g_object_unref0 (_data2_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda52_ (Block2Data* _data2_,
             GError** error)
{
	ApplicationTlsDatabase* self;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	_tmp0_ = application_tls_database_is_pinned (self, _data2_->chain, _data2_->identity, _data2_->cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_data2_->pinned = _tmp0_;
}

static void
___lambda52__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                               gpointer self,
                                                               GError** error)
{
	__lambda52_ (self, error);
}

static void
application_tls_database_is_pinned_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	ApplicationTlsDatabaseIsPinnedAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_tls_database_is_pinned_async_co (_data_);
}

static gboolean
application_tls_database_is_pinned_async_co (ApplicationTlsDatabaseIsPinnedAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data2_->chain);
	_data_->_data2_->chain = _data_->chain;
	_g_object_unref0 (_data_->_data2_->identity);
	_data_->_data2_->identity = _data_->identity;
	_g_object_unref0 (_data_->_data2_->cancellable);
	_data_->_data2_->cancellable = _data_->cancellable;
	_data_->_data2_->_async_data_ = _data_;
	_data_->_data2_->pinned = FALSE;
	_data_->_tmp0_ = geary_nonblocking_concurrent_get_global ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	geary_nonblocking_concurrent_schedule_async (_data_->_tmp1_, ___lambda52__geary_nonblocking_concurrent_concurrent_callback, _data_->_data2_, _data_->_data2_->cancellable, application_tls_database_is_pinned_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_concurrent_schedule_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_data2_->pinned;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ApplicationTlsDatabase* self;
		self = _data3_->self;
		_g_free0 (_data3_->id);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
___lambda51_ (Block3Data* _data3_,
              ApplicationTlsDatabaseTrustContext* ctx)
{
	ApplicationTlsDatabase* self;
	const gchar* _tmp0_;
	gboolean result;
	self = _data3_->self;
	g_return_val_if_fail (APPLICATION_TLS_DATABASE_IS_TRUST_CONTEXT (ctx), FALSE);
	_tmp0_ = ctx->id;
	result = g_strcmp0 (_tmp0_, _data3_->id) == 0;
	return result;
}

static gboolean
____lambda51__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = ___lambda51_ (self, (ApplicationTlsDatabaseTrustContext*) g);
	return result;
}

static ApplicationTlsDatabaseTrustContext*
application_tls_database_lookup_id (ApplicationTlsDatabase* self,
                                    const gchar* id)
{
	Block3Data* _data3_;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	ApplicationTlsDatabaseTrustContext* result;
	g_return_val_if_fail (APPLICATION_IS_TLS_DATABASE (self), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_strdup (id);
	_g_free0 (_data3_->id);
	_data3_->id = _tmp0_;
	{
		GeeMap* _tmp1_;
		_tmp1_ = self->priv->pinned_certs;
		g_rec_mutex_lock (&self->priv->__lock_pinned_certs);
		{
			GeeMap* _tmp2_;
			GeeCollection* _tmp3_;
			GeeCollection* _tmp4_;
			GeeCollection* _tmp5_;
			GearyIterable* _tmp6_;
			GearyIterable* _tmp7_;
			gpointer _tmp8_;
			ApplicationTlsDatabaseTrustContext* _tmp9_;
			_tmp2_ = self->priv->pinned_certs;
			_tmp3_ = gee_map_get_values (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = geary_traverse (APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp7_ = _tmp6_;
			_tmp8_ = geary_iterable_first_matching (_tmp7_, ____lambda51__gee_predicate, block3_data_ref (_data3_), block3_data_unref);
			_tmp9_ = (ApplicationTlsDatabaseTrustContext*) _tmp8_;
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (_tmp5_);
			result = _tmp9_;
			{
				GeeMap* _tmp10_;
				_tmp10_ = self->priv->pinned_certs;
				g_rec_mutex_unlock (&self->priv->__lock_pinned_certs);
			}
			block3_data_unref (_data3_);
			_data3_ = NULL;
			return result;
		}
		__finally0:
		{
			GeeMap* _tmp11_;
			_tmp11_ = self->priv->pinned_certs;
			g_rec_mutex_unlock (&self->priv->__lock_pinned_certs);
		}
		block3_data_unref (_data3_);
		_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ApplicationTlsDatabase* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->cert);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
___lambda50_ (Block4Data* _data4_,
              ApplicationTlsDatabaseTrustContext* ctx)
{
	ApplicationTlsDatabase* self;
	GTlsCertificate* _tmp0_;
	gboolean result;
	self = _data4_->self;
	g_return_val_if_fail (APPLICATION_TLS_DATABASE_IS_TRUST_CONTEXT (ctx), FALSE);
	_tmp0_ = ctx->certificate;
	result = g_tls_certificate_is_same (_tmp0_, _data4_->cert);
	return result;
}

static gboolean
____lambda50__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = ___lambda50_ (self, (ApplicationTlsDatabaseTrustContext*) g);
	return result;
}

static ApplicationTlsDatabaseTrustContext*
application_tls_database_lookup_tls_certificate (ApplicationTlsDatabase* self,
                                                 GTlsCertificate* cert)
{
	Block4Data* _data4_;
	GTlsCertificate* _tmp0_;
	GError* _inner_error0_ = NULL;
	ApplicationTlsDatabaseTrustContext* result;
	g_return_val_if_fail (APPLICATION_IS_TLS_DATABASE (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cert, g_tls_certificate_get_type ()), NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (cert);
	_g_object_unref0 (_data4_->cert);
	_data4_->cert = _tmp0_;
	{
		GeeMap* _tmp1_;
		_tmp1_ = self->priv->pinned_certs;
		g_rec_mutex_lock (&self->priv->__lock_pinned_certs);
		{
			GeeMap* _tmp2_;
			GeeCollection* _tmp3_;
			GeeCollection* _tmp4_;
			GeeCollection* _tmp5_;
			GearyIterable* _tmp6_;
			GearyIterable* _tmp7_;
			gpointer _tmp8_;
			ApplicationTlsDatabaseTrustContext* _tmp9_;
			_tmp2_ = self->priv->pinned_certs;
			_tmp3_ = gee_map_get_values (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = geary_traverse (APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp7_ = _tmp6_;
			_tmp8_ = geary_iterable_first_matching (_tmp7_, ____lambda50__gee_predicate, block4_data_ref (_data4_), block4_data_unref);
			_tmp9_ = (ApplicationTlsDatabaseTrustContext*) _tmp8_;
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (_tmp5_);
			result = _tmp9_;
			{
				GeeMap* _tmp10_;
				_tmp10_ = self->priv->pinned_certs;
				g_rec_mutex_unlock (&self->priv->__lock_pinned_certs);
			}
			block4_data_unref (_data4_);
			_data4_ = NULL;
			return result;
		}
		__finally0:
		{
			GeeMap* _tmp11_;
			_tmp11_ = self->priv->pinned_certs;
			g_rec_mutex_unlock (&self->priv->__lock_pinned_certs);
		}
		block4_data_unref (_data4_);
		_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static ApplicationTlsDatabaseTrustContext*
application_tls_database_trust_context_construct (GType object_type,
                                                  GTlsCertificate* certificate)
{
	ApplicationTlsDatabaseTrustContext * self = NULL;
	GByteArray* _tmp0_;
	GByteArray* _tmp1_;
	GByteArray* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	GTlsCertificate* _tmp5_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (certificate, g_tls_certificate_get_type ()), NULL);
	self = (ApplicationTlsDatabaseTrustContext*) geary_base_object_construct (object_type);
	g_object_get (certificate, "certificate", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->data;
	_tmp3__length1 = _tmp2_->len;
	_tmp4_ = g_compute_checksum_for_data (APPLICATION_TLS_DATABASE_TRUST_CONTEXT_ID_TYPE, _tmp3_, (gint) _tmp3__length1);
	_g_free0 (self->id);
	self->id = _tmp4_;
	_g_byte_array_unref0 (_tmp2_);
	_tmp5_ = _g_object_ref0 (certificate);
	_g_object_unref0 (self->certificate);
	self->certificate = _tmp5_;
	return self;
}

static ApplicationTlsDatabaseTrustContext*
application_tls_database_trust_context_new (GTlsCertificate* certificate)
{
	return application_tls_database_trust_context_construct (APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT, certificate);
}

static ApplicationTlsDatabaseTrustContext*
application_tls_database_trust_context_construct_lookup (GType object_type,
                                                         GFile* dir,
                                                         const gchar* identity,
                                                         GCancellable* cancellable,
                                                         GError** error)
{
	ApplicationTlsDatabaseTrustContext * self = NULL;
	GFile* storage = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFileInputStream* f_in = NULL;
	GFile* _tmp4_;
	GFileInputStream* _tmp5_;
	GBufferedInputStream* buf = NULL;
	GFileInputStream* _tmp6_;
	GBufferedInputStream* _tmp7_;
	GByteArray* cert_pem = NULL;
	GBufferedInputStream* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	GByteArray* _tmp11_;
	gboolean eof = FALSE;
	GBufferedInputStream* _tmp18_;
	GTlsCertificate* _tmp19_ = NULL;
	GByteArray* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	GTlsCertificate* _tmp22_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()), NULL);
	g_return_val_if_fail (identity != NULL, NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = g_strdup_printf (APPLICATION_TLS_DATABASE_TRUST_CONTEXT_FILENAME_FORMAT, identity);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (dir, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	storage = _tmp3_;
	_tmp4_ = storage;
	_tmp5_ = g_file_read (_tmp4_, cancellable, &_inner_error0_);
	f_in = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (storage);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp6_ = f_in;
	_tmp7_ = (GBufferedInputStream*) g_buffered_input_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_input_stream_get_type (), GInputStream));
	buf = _tmp7_;
	_tmp8_ = buf;
	_tmp9_ = g_buffered_input_stream_get_buffer_size (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_byte_array_sized_new (_tmp10_);
	cert_pem = _tmp11_;
	eof = FALSE;
	while (TRUE) {
		gsize filled = 0UL;
		GBufferedInputStream* _tmp12_;
		if (!(!eof)) {
			break;
		}
		_tmp12_ = buf;
		filled = (gsize) g_buffered_input_stream_fill (_tmp12_, (gssize) -1, cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_byte_array_unref0 (cert_pem);
			_g_object_unref0 (buf);
			_g_object_unref0 (f_in);
			_g_object_unref0 (storage);
			_g_object_unref0 (self);
			return NULL;
		}
		if (filled > ((gsize) 0)) {
			GByteArray* _tmp13_;
			GBufferedInputStream* _tmp14_;
			gsize _tmp15_ = 0;
			guint8* _tmp16_;
			GBufferedInputStream* _tmp17_;
			_tmp13_ = cert_pem;
			_tmp14_ = buf;
			_tmp16_ = g_buffered_input_stream_peek_buffer (_tmp14_, &_tmp15_);
			g_byte_array_append (_tmp13_, _tmp16_, (gint) _tmp15_);
			_tmp17_ = buf;
			g_input_stream_skip (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, g_input_stream_get_type (), GInputStream), filled, cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_byte_array_unref0 (cert_pem);
				_g_object_unref0 (buf);
				_g_object_unref0 (f_in);
				_g_object_unref0 (storage);
				_g_object_unref0 (self);
				return NULL;
			}
		} else {
			eof = TRUE;
		}
	}
	_tmp18_ = buf;
	g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, g_input_stream_get_type (), GInputStream), cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_byte_array_unref0 (cert_pem);
		_g_object_unref0 (buf);
		_g_object_unref0 (f_in);
		_g_object_unref0 (storage);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp20_ = cert_pem;
	_tmp21_ = _tmp20_->data;
	_tmp21__length1 = _tmp20_->len;
	_tmp22_ = g_tls_certificate_new_from_pem ((const gchar*) _tmp21_, (gssize) -1, &_inner_error0_);
	_tmp19_ = _tmp22_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_byte_array_unref0 (cert_pem);
		_g_object_unref0 (buf);
		_g_object_unref0 (f_in);
		_g_object_unref0 (storage);
		_g_object_unref0 (self);
		return NULL;
	}
	self = (ApplicationTlsDatabaseTrustContext*) application_tls_database_trust_context_construct (object_type, _tmp19_);
	_g_object_unref0 (_tmp19_);
	_g_byte_array_unref0 (cert_pem);
	_g_object_unref0 (buf);
	_g_object_unref0 (f_in);
	_g_object_unref0 (storage);
	return self;
}

static ApplicationTlsDatabaseTrustContext*
application_tls_database_trust_context_new_lookup (GFile* dir,
                                                   const gchar* identity,
                                                   GCancellable* cancellable,
                                                   GError** error)
{
	return application_tls_database_trust_context_construct_lookup (APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT, dir, identity, cancellable, error);
}

static void
application_tls_database_trust_context_save_data_free (gpointer _data)
{
	ApplicationTlsDatabaseTrustContextSaveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->dir);
	_g_free0 (_data_->identity);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationTlsDatabaseTrustContextSaveData, _data_);
}

static void
application_tls_database_trust_context_save (ApplicationTlsDatabaseTrustContext* self,
                                             GFile* dir,
                                             const gchar* identity,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	ApplicationTlsDatabaseTrustContextSaveData* _data_;
	ApplicationTlsDatabaseTrustContext* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (APPLICATION_TLS_DATABASE_IS_TRUST_CONTEXT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail (identity != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationTlsDatabaseTrustContextSaveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_tls_database_trust_context_save_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (dir);
	_g_object_unref0 (_data_->dir);
	_data_->dir = _tmp1_;
	_tmp2_ = g_strdup (identity);
	_g_free0 (_data_->identity);
	_data_->identity = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_tls_database_trust_context_save_co (_data_);
}

static void
application_tls_database_trust_context_save_finish (ApplicationTlsDatabaseTrustContext* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	ApplicationTlsDatabaseTrustContextSaveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
application_tls_database_trust_context_save_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	ApplicationTlsDatabaseTrustContextSaveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_tls_database_trust_context_save_co (_data_);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gboolean
application_tls_database_trust_context_save_co (ApplicationTlsDatabaseTrustContextSaveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_files_make_directory_with_parents (_data_->dir, _data_->cancellable, application_tls_database_trust_context_save_ready, _data_);
	return FALSE;
	_state_1:
	geary_files_make_directory_with_parents_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = g_strdup_printf (APPLICATION_TLS_DATABASE_TRUST_CONTEXT_FILENAME_FORMAT, _data_->identity);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_file_get_child (_data_->dir, _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_free0 (_data_->_tmp1_);
	_data_->storage = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->storage;
	_data_->_state_ = 2;
	g_file_replace_async (_data_->_tmp4_, NULL, FALSE, G_FILE_CREATE_NONE, APPLICATION_TLS_DATABASE_TRUST_CONTEXT_IO_PRIO, _data_->cancellable, application_tls_database_trust_context_save_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp5_ = g_file_replace_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
	_data_->f_out = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->storage);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->f_out;
	_data_->_tmp7_ = (GBufferedOutputStream*) g_buffered_output_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, g_output_stream_get_type (), GOutputStream));
	_data_->buf = _data_->_tmp7_;
	_data_->written = (gsize) 0;
	_data_->_tmp8_ = _data_->buf;
	_data_->_tmp9_ = _data_->self->certificate;
	g_object_get (_data_->_tmp9_, "certificate-pem", &_data_->_tmp10_, NULL);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp14_ = 0;
	_data_->_tmp13_ = string_get_data (_data_->_tmp12_, &_data_->_tmp14_);
	_data_->_tmp13__length1 = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->_tmp13_;
	_data_->_tmp15__length1 = _data_->_tmp13__length1;
	_data_->_tmp16_ = 0UL;
	_data_->_state_ = 3;
	g_output_stream_write_all_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, g_output_stream_get_type (), GOutputStream), _data_->_tmp15_, (gsize) _data_->_tmp15__length1, APPLICATION_TLS_DATABASE_TRUST_CONTEXT_IO_PRIO, _data_->cancellable, application_tls_database_trust_context_save_ready, _data_);
	return FALSE;
	_state_3:
	g_output_stream_write_all_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, g_output_stream_get_type (), GOutputStream), _data_->_res_, &_data_->_tmp16_, &_data_->_inner_error0_);
	_data_->written = _data_->_tmp16_;
	_g_free0 (_data_->_tmp12_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->buf);
		_g_object_unref0 (_data_->f_out);
		_g_object_unref0 (_data_->storage);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->buf;
	_data_->_state_ = 4;
	g_output_stream_close_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, g_output_stream_get_type (), GOutputStream), APPLICATION_TLS_DATABASE_TRUST_CONTEXT_IO_PRIO, _data_->cancellable, application_tls_database_trust_context_save_ready, _data_);
	return FALSE;
	_state_4:
	g_output_stream_close_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, g_output_stream_get_type (), GOutputStream), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->buf);
		_g_object_unref0 (_data_->f_out);
		_g_object_unref0 (_data_->storage);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->buf);
	_g_object_unref0 (_data_->f_out);
	_g_object_unref0 (_data_->storage);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_tls_database_trust_context_class_init (ApplicationTlsDatabaseTrustContextClass * klass,
                                                   gpointer klass_data)
{
	application_tls_database_trust_context_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = application_tls_database_trust_context_finalize;
}

static void
application_tls_database_trust_context_instance_init (ApplicationTlsDatabaseTrustContext * self,
                                                      gpointer klass)
{
}

static void
application_tls_database_trust_context_finalize (GObject * obj)
{
	ApplicationTlsDatabaseTrustContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT, ApplicationTlsDatabaseTrustContext);
	_g_free0 (self->id);
	_g_object_unref0 (self->certificate);
	G_OBJECT_CLASS (application_tls_database_trust_context_parent_class)->finalize (obj);
}

/** A certificate and the identities it is trusted for. */
static GType
application_tls_database_trust_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationTlsDatabaseTrustContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_tls_database_trust_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationTlsDatabaseTrustContext), 0, (GInstanceInitFunc) application_tls_database_trust_context_instance_init, NULL };
	GType application_tls_database_trust_context_type_id;
	application_tls_database_trust_context_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationTlsDatabaseTrustContext", &g_define_type_info, 0);
	return application_tls_database_trust_context_type_id;
}

static GType
application_tls_database_trust_context_get_type (void)
{
	static volatile gsize application_tls_database_trust_context_type_id__once = 0;
	if (g_once_init_enter (&application_tls_database_trust_context_type_id__once)) {
		GType application_tls_database_trust_context_type_id;
		application_tls_database_trust_context_type_id = application_tls_database_trust_context_get_type_once ();
		g_once_init_leave (&application_tls_database_trust_context_type_id__once, application_tls_database_trust_context_type_id);
	}
	return application_tls_database_trust_context_type_id__once;
}

static void
application_tls_database_class_init (ApplicationTlsDatabaseClass * klass,
                                     gpointer klass_data)
{
	application_tls_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationTlsDatabase_private_offset);
	((GTlsDatabaseClass *) klass)->create_certificate_handle = (gchar* (*) (GTlsDatabase*, GTlsCertificate*)) application_tls_database_real_create_certificate_handle;
	((GTlsDatabaseClass *) klass)->lookup_certificate_for_handle = (GTlsCertificate* (*) (GTlsDatabase*, const gchar*, GTlsInteraction*, GTlsDatabaseLookupFlags, GCancellable*, GError**)) application_tls_database_real_lookup_certificate_for_handle;
	((GTlsDatabaseClass *) klass)->lookup_certificate_for_handle_async = (void (*) (GTlsDatabase*, const gchar*, GTlsInteraction*, GTlsDatabaseLookupFlags, GCancellable*, GAsyncReadyCallback, gpointer)) application_tls_database_real_lookup_certificate_for_handle_async;
	((GTlsDatabaseClass *) klass)->lookup_certificate_for_handle_finish = (GTlsCertificate* (*) (GTlsDatabase*, GAsyncResult*, GError**)) application_tls_database_lookup_certificate_for_handle_finish;
	((GTlsDatabaseClass *) klass)->lookup_certificate_issuer = (GTlsCertificate* (*) (GTlsDatabase*, GTlsCertificate*, GTlsInteraction*, GTlsDatabaseLookupFlags, GCancellable*, GError**)) application_tls_database_real_lookup_certificate_issuer;
	((GTlsDatabaseClass *) klass)->lookup_certificate_issuer_async = (void (*) (GTlsDatabase*, GTlsCertificate*, GTlsInteraction*, GTlsDatabaseLookupFlags, GCancellable*, GAsyncReadyCallback, gpointer)) application_tls_database_real_lookup_certificate_issuer_async;
	((GTlsDatabaseClass *) klass)->lookup_certificate_issuer_finish = (GTlsCertificate* (*) (GTlsDatabase*, GAsyncResult*, GError**)) application_tls_database_lookup_certificate_issuer_finish;
	((GTlsDatabaseClass *) klass)->lookup_certificates_issued_by = (GList* (*) (GTlsDatabase*, GByteArray*, GTlsInteraction*, GTlsDatabaseLookupFlags, GCancellable*, GError**)) application_tls_database_real_lookup_certificates_issued_by;
	((GTlsDatabaseClass *) klass)->lookup_certificates_issued_by_async = (void (*) (GTlsDatabase*, GByteArray*, GTlsInteraction*, GTlsDatabaseLookupFlags, GCancellable*, GAsyncReadyCallback, gpointer)) application_tls_database_real_lookup_certificates_issued_by_async;
	((GTlsDatabaseClass *) klass)->lookup_certificates_issued_by_finish = (GList* (*) (GTlsDatabase*, GAsyncResult*, GError**)) application_tls_database_lookup_certificates_issued_by_finish;
	((GTlsDatabaseClass *) klass)->verify_chain = (GTlsCertificateFlags (*) (GTlsDatabase*, GTlsCertificate*, const gchar*, GSocketConnectable*, GTlsInteraction*, GTlsDatabaseVerifyFlags, GCancellable*, GError**)) application_tls_database_real_verify_chain;
	((GTlsDatabaseClass *) klass)->verify_chain_async = (void (*) (GTlsDatabase*, GTlsCertificate*, const gchar*, GSocketConnectable*, GTlsInteraction*, GTlsDatabaseVerifyFlags, GCancellable*, GAsyncReadyCallback, gpointer)) application_tls_database_real_verify_chain_async;
	((GTlsDatabaseClass *) klass)->verify_chain_finish = (GTlsCertificateFlags (*) (GTlsDatabase*, GAsyncResult*, GError**)) application_tls_database_verify_chain_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_application_tls_database_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_tls_database_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_tls_database_finalize;
}

static void
application_tls_database_instance_init (ApplicationTlsDatabase * self,
                                        gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = application_tls_database_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_pinned_certs);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, APPLICATION_TLS_DATABASE_TYPE_TRUST_CONTEXT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->pinned_certs = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
}

static void
application_tls_database_finalize (GObject * obj)
{
	ApplicationTlsDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	_g_object_unref0 (self->priv->_parent);
	_g_object_unref0 (self->priv->store_dir);
	g_rec_mutex_clear (&self->priv->__lock_pinned_certs);
	_g_object_unref0 (self->priv->pinned_certs);
	G_OBJECT_CLASS (application_tls_database_parent_class)->finalize (obj);
}

/**
 * TLS database that observes locally pinned certs.
 *
 * An instance of this is managed by {@link CertificateManager}, the
 * application should simply construct an instance of that.
 */
static GType
application_tls_database_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationTlsDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_tls_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationTlsDatabase), 0, (GInstanceInitFunc) application_tls_database_instance_init, NULL };
	GType application_tls_database_type_id;
	application_tls_database_type_id = g_type_register_static (g_tls_database_get_type (), "ApplicationTlsDatabase", &g_define_type_info, 0);
	ApplicationTlsDatabase_private_offset = g_type_add_instance_private (application_tls_database_type_id, sizeof (ApplicationTlsDatabasePrivate));
	return application_tls_database_type_id;
}

GType
application_tls_database_get_type (void)
{
	static volatile gsize application_tls_database_type_id__once = 0;
	if (g_once_init_enter (&application_tls_database_type_id__once)) {
		GType application_tls_database_type_id;
		application_tls_database_type_id = application_tls_database_get_type_once ();
		g_once_init_leave (&application_tls_database_type_id__once, application_tls_database_type_id);
	}
	return application_tls_database_type_id__once;
}

static void
_vala_application_tls_database_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ApplicationTlsDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_tls_database_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ApplicationTlsDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_TLS_DATABASE, ApplicationTlsDatabase);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

