/* imap-client-service.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-client-service.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2017-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_IMAP_CLIENT_SERVICE_DEFAULT_MIN_POOL_SIZE 1
#define GEARY_IMAP_CLIENT_SERVICE_DEFAULT_MAX_FREE_SIZE 1
#define GEARY_IMAP_CLIENT_SERVICE_CHECK_NOOP_THRESHOLD_SEC 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_CLIENT_SERVICE_0_PROPERTY,
	GEARY_IMAP_CLIENT_SERVICE_UNSELECTED_KEEPALIVE_SEC_PROPERTY,
	GEARY_IMAP_CLIENT_SERVICE_SELECTED_KEEPALIVE_SEC_PROPERTY,
	GEARY_IMAP_CLIENT_SERVICE_SELECTED_WITH_IDLE_KEEPALIVE_SEC_PROPERTY,
	GEARY_IMAP_CLIENT_SERVICE_MIN_POOL_SIZE_PROPERTY,
	GEARY_IMAP_CLIENT_SERVICE_MAX_FREE_SIZE_PROPERTY,
	GEARY_IMAP_CLIENT_SERVICE_LOGGING_DOMAIN_PROPERTY,
	GEARY_IMAP_CLIENT_SERVICE_NUM_PROPERTIES
};
static GParamSpec* geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearyImapClientServiceStartData GearyImapClientServiceStartData;
typedef struct _GearyImapClientServiceStopData GearyImapClientServiceStopData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyImapClientServiceClaimAuthorizedSessionAsyncData GearyImapClientServiceClaimAuthorizedSessionAsyncData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyImapClientServiceReleaseSessionAsyncData GearyImapClientServiceReleaseSessionAsyncData;
typedef struct _GearyImapClientServiceCheckPoolData GearyImapClientServiceCheckPoolData;
typedef struct _Block25Data Block25Data;
typedef struct _GearyImapClientServiceAddPoolSessionData GearyImapClientServiceAddPoolSessionData;
typedef struct _GearyImapClientServiceCheckSessionData GearyImapClientServiceCheckSessionData;
typedef struct _GearyImapClientServiceCreateNewAuthorizedSessionData GearyImapClientServiceCreateNewAuthorizedSessionData;
typedef struct _Block26Data Block26Data;
typedef struct _GearyImapClientServiceClosePoolData GearyImapClientServiceClosePoolData;
typedef struct _GearyImapClientServiceDisconnectSessionData GearyImapClientServiceDisconnectSessionData;
typedef struct _GearyImapClientServiceForceDisconnectSessionData GearyImapClientServiceForceDisconnectSessionData;
typedef struct _Block27Data Block27Data;
typedef struct _GearyImapClientServiceRemoveSessionAsyncData GearyImapClientServiceRemoveSessionAsyncData;

struct _GearyImapClientServicePrivate {
	guint _unselected_keepalive_sec;
	guint _selected_keepalive_sec;
	guint _selected_with_idle_keepalive_sec;
	gint _min_pool_size;
	gint _max_free_size;
	GearyImapQuirks* quirks;
	GearyNonblockingMutex* sessions_mutex;
	GeeSet* all_sessions;
	GearyNonblockingQueue* free_queue;
	GCancellable* pool_cancellable;
	GCancellable* close_cancellable;
};

struct _GearyImapClientServiceStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	GError* _inner_error0_;
};

struct _GearyImapClientServiceStopData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GCancellable* _tmp2_;
	gint attempts;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GeeSet* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GCancellable* _tmp10_;
};

struct _GearyImapClientServiceClaimAuthorizedSessionAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	GCancellable* cancellable;
	GearyImapClientSession* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError* _tmp2_;
	GearyNonblockingQueue* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GearyClientServiceStatus _tmp9_;
	GearyClientServiceStatus _tmp10_;
	GError* _tmp11_;
	GearyClientServiceStatus _tmp12_;
	GearyClientServiceStatus _tmp13_;
	GearyEndpoint* _tmp14_;
	GearyEndpoint* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GearyImapClientSession* claimed;
	GearyImapClientSession* _tmp20_;
	GearyNonblockingQueue* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GearyImapClientSession* _tmp24_;
	GearyNonblockingQueue* _tmp25_;
	gpointer _tmp26_;
	GearyImapClientSession* _tmp27_;
	GearyImapClientSession* _tmp28_;
	GError* _inner_error0_;
};

struct _GearyImapClientServiceReleaseSessionAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	GearyImapClientSession* session;
	GearyNonblockingQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	GearyNonblockingQueue* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GeeSet* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gboolean too_many_free;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean disconnect;
	GearyImapClientSessionProtocolState proto;
	GearyImapClientSessionProtocolState _tmp20_;
	GearyImapClientSessionProtocolState _tmp21_;
	gboolean _tmp22_;
	GCancellable* _tmp23_;
	GearyImapStatusResponse* _tmp24_;
	GearyImapStatusResponse* _tmp25_;
	GError* imap_error;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GearyImapClientSessionProtocolState _tmp30_;
	GearyImapClientSessionProtocolState _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GearyNonblockingQueue* _tmp34_;
	GError* _inner_error0_;
};

struct _GearyImapClientServiceCheckPoolData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	gboolean is_claiming;
	GearyNonblockingQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean loaded;
	GearyAccountInformation* _tmp6_;
	GearyAccountInformation* _tmp7_;
	GCancellable* _tmp8_;
	GError* err;
	GError* _tmp9_;
	GearyErrorContext* _tmp10_;
	GearyErrorContext* _tmp11_;
	gint needed;
	gint _tmp12_;
	GeeSet* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gboolean _tmp16_;
	gint _tmp17_;
	GError* _inner_error0_;
};

struct _Block25Data {
	int _ref_count_;
	GearyImapClientService* self;
	GearyImapClientSession* new_session;
	gpointer _async_data_;
};

struct _GearyImapClientServiceAddPoolSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	Block25Data* _data25_;
	GearyImapClientSession* _tmp0_;
	GCancellable* _tmp1_;
	GearyImapClientSession* _tmp2_;
	GearyImapClientSession* _tmp3_;
	GError* err;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _vala1_err;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _vala2_err;
	GearyErrorContext* context;
	GError* _tmp8_;
	GearyErrorContext* _tmp9_;
	GearyErrorContext* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GearyErrorContext* _tmp13_;
	GearyImapClientSession* _tmp14_;
	GearyImapQuirks* _tmp15_;
	GearyImapClientSession* _tmp16_;
	GearyNonblockingMutex* _tmp17_;
	GearyNonblockingQueue* _tmp18_;
	GearyImapClientSession* _tmp19_;
	GError* _vala3_err;
	GearyErrorContext* _vala1_context;
	GError* _tmp20_;
	GearyErrorContext* _tmp21_;
	GearyErrorContext* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GearyErrorContext* _tmp25_;
	GearyImapClientSession* _tmp26_;
	GError* _inner_error0_;
};

struct _GearyImapClientServiceCheckSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	GearyImapClientSession* target;
	gboolean claiming;
	gboolean result;
	gboolean valid;
	GearyImapClientSessionProtocolState _tmp0_;
	GearyImapClientSessionProtocolState _tmp1_;
	gboolean _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	GCancellable* _tmp5_;
	GearyImapNoopCommand* _tmp6_;
	GearyImapNoopCommand* _tmp7_;
	GearyImapStatusResponse* _tmp8_;
	GearyImapStatusResponse* _tmp9_;
	GError* err;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _GearyImapClientServiceCreateNewAuthorizedSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	GCancellable* cancellable;
	GearyImapClientSession* result;
	GearyCredentials* login;
	GearyServiceInformation* _tmp0_;
	GearyServiceInformation* _tmp1_;
	GearyCredentials* _tmp2_;
	GearyCredentials* _tmp3_;
	GearyCredentials* _tmp4_;
	gboolean _tmp5_;
	GearyCredentials* _tmp6_;
	GearyCredentials* _tmp7_;
	GError* _tmp8_;
	GearyImapClientSession* new_session;
	GearyEndpoint* _tmp9_;
	GearyEndpoint* _tmp10_;
	GearyImapQuirks* _tmp11_;
	GearyImapClientSession* _tmp12_;
	GearyImapClientSession* _tmp13_;
	GearyImapClientSession* _tmp14_;
	GearyImapClientSession* _tmp15_;
	GearyCredentials* _tmp16_;
	GError* err;
	GearyImapClientSession* _tmp17_;
	GError* disconnect_err;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	GError* _tmp21_;
	GearyImapClientSession* _tmp22_;
	GearyImapClientSession* _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	guint _tmp26_;
	GError* _inner_error0_;
};

struct _Block26Data {
	int _ref_count_;
	GearyImapClientService* self;
	GearyImapClientSession** to_close;
	gint to_close_length1;
	gint _to_close_size_;
	gpointer _async_data_;
};

struct _GearyImapClientServiceClosePoolData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	gboolean clean_disconnect;
	Block26Data* _data26_;
	GeeSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GearyNonblockingMutex* _tmp3_;
	GError* err;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GearyImapClientSession** session_collection;
	gint session_collection_length1;
	gint _session_collection_size_;
	gint session_it;
	GearyImapClientSession* _tmp6_;
	GearyImapClientSession* session;
	GearyImapClientSession* _tmp7_;
	GearyImapClientSession* _tmp8_;
	GError* _inner_error0_;
};

struct _GearyImapClientServiceDisconnectSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	GearyImapClientSession* session;
	GearyImapClientSessionProtocolState _tmp0_;
	GearyImapClientSessionProtocolState _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GCancellable* _tmp4_;
	GError* err;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

struct _GearyImapClientServiceForceDisconnectSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	GearyImapClientSession* session;
	gchar* _tmp0_;
	gchar* _tmp1_;
};

struct _Block27Data {
	int _ref_count_;
	GearyImapClientService* self;
	gboolean removed;
	GearyImapClientSession* session;
	gpointer _async_data_;
};

struct _GearyImapClientServiceRemoveSessionAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapClientService* self;
	GearyImapClientSession* session;
	gboolean result;
	Block27Data* _data27_;
	GearyNonblockingQueue* _tmp0_;
	GearyNonblockingMutex* _tmp1_;
	GError* err;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_;
};

static gint GearyImapClientService_private_offset;
static gpointer geary_imap_client_service_parent_class = NULL;

static void geary_imap_client_service_real_start_data_free (gpointer _data);
static void geary_imap_client_service_real_start (GearyClientService* base,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean geary_imap_client_service_real_start_co (GearyImapClientServiceStartData* _data_);
static void geary_imap_client_service_real_stop_data_free (gpointer _data);
static void geary_imap_client_service_real_stop (GearyClientService* base,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean geary_imap_client_service_real_stop_co (GearyImapClientServiceStopData* _data_);
static void geary_imap_client_service_close_pool (GearyImapClientService* self,
                                           gboolean clean_disconnect,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void geary_imap_client_service_close_pool_finish (GearyImapClientService* self,
                                                  GAsyncResult* _res_);
static void geary_imap_client_service_stop_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static gboolean _geary_imap_client_service_real_stop_co_gsource_func (gpointer self);
static void geary_imap_client_service_claim_authorized_session_async_data_free (gpointer _data);
static gboolean geary_imap_client_service_claim_authorized_session_async_co (GearyImapClientServiceClaimAuthorizedSessionAsyncData* _data_);
static void geary_imap_client_service_check_pool (GearyImapClientService* self,
                                           gboolean is_claiming,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void geary_imap_client_service_check_pool_finish (GearyImapClientService* self,
                                                  GAsyncResult* _res_);
static void geary_imap_client_service_claim_authorized_session_async_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void geary_imap_client_service_check_session (GearyImapClientService* self,
                                              GearyImapClientSession* target,
                                              gboolean claiming,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean geary_imap_client_service_check_session_finish (GearyImapClientService* self,
                                                         GAsyncResult* _res_);
static void geary_imap_client_service_release_session_async_data_free (gpointer _data);
static gboolean geary_imap_client_service_release_session_async_co (GearyImapClientServiceReleaseSessionAsyncData* _data_);
static void geary_imap_client_service_release_session_async_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void geary_imap_client_service_disconnect_session (GearyImapClientService* self,
                                                   GearyImapClientSession* session,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void geary_imap_client_service_disconnect_session_finish (GearyImapClientService* self,
                                                          GAsyncResult* _res_);
static void geary_imap_client_service_real_became_reachable (GearyClientService* base);
static void geary_imap_client_service_real_became_unreachable (GearyClientService* base);
static void geary_imap_client_service_check_pool_data_free (gpointer _data);
static gboolean geary_imap_client_service_check_pool_co (GearyImapClientServiceCheckPoolData* _data_);
static void geary_imap_client_service_check_pool_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void geary_imap_client_service_add_pool_session (GearyImapClientService* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void geary_imap_client_service_add_pool_session_finish (GearyImapClientService* self,
                                                        GAsyncResult* _res_);
static void geary_imap_client_service_add_pool_session_data_free (gpointer _data);
static gboolean geary_imap_client_service_add_pool_session_co (GearyImapClientServiceAddPoolSessionData* _data_);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void geary_imap_client_service_create_new_authorized_session (GearyImapClientService* self,
                                                              GCancellable* cancellable,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static GearyImapClientSession* geary_imap_client_service_create_new_authorized_session_finish (GearyImapClientService* self,
                                                                                        GAsyncResult* _res_,
                                                                                        GError** error);
static void geary_imap_client_service_add_pool_session_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void ____lambda108_ (Block25Data* _data25_,
                     GError** error);
static void _____lambda108__geary_nonblocking_mutex_critical_section (gpointer self,
                                                               GError** error);
static void geary_imap_client_service_check_session_data_free (gpointer _data);
static gboolean geary_imap_client_service_check_session_co (GearyImapClientServiceCheckSessionData* _data_);
static void geary_imap_client_service_check_session_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
VALA_EXTERN gint64 geary_imap_client_session_get_last_seen (GearyImapClientSession* self);
static void geary_imap_client_service_create_new_authorized_session_data_free (gpointer _data);
static gboolean geary_imap_client_service_create_new_authorized_session_co (GearyImapClientServiceCreateNewAuthorizedSessionData* _data_);
VALA_EXTERN void geary_imap_client_session_set_logging_parent (GearyImapClientSession* self,
                                                   GearyLoggingSource* parent);
static void geary_imap_client_service_create_new_authorized_session_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
static void geary_imap_client_service_on_session_disconnected (GearyImapClientService* self,
                                                        GObject* source,
                                                        GParamSpec* param);
static void _geary_imap_client_service_on_session_disconnected_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self);
static void geary_imap_client_service_close_pool_data_free (gpointer _data);
static gboolean geary_imap_client_service_close_pool_co (GearyImapClientServiceClosePoolData* _data_);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static void ___lambda107_ (Block26Data* _data26_,
                    GError** error);
static void ____lambda107__geary_nonblocking_mutex_critical_section (gpointer self,
                                                              GError** error);
static void geary_imap_client_service_close_pool_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void geary_imap_client_service_force_disconnect_session (GearyImapClientService* self,
                                                         GearyImapClientSession* session,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static void geary_imap_client_service_force_disconnect_session_finish (GearyImapClientService* self,
                                                                GAsyncResult* _res_);
static void geary_imap_client_service_disconnect_session_data_free (gpointer _data);
static gboolean geary_imap_client_service_disconnect_session_co (GearyImapClientServiceDisconnectSessionData* _data_);
static void geary_imap_client_service_disconnect_session_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void geary_imap_client_service_remove_session_async (GearyImapClientService* self,
                                                     GearyImapClientSession* session,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean geary_imap_client_service_remove_session_finish (GearyImapClientService* self,
                                                          GAsyncResult* _res_);
static void geary_imap_client_service_force_disconnect_session_data_free (gpointer _data);
static gboolean geary_imap_client_service_force_disconnect_session_co (GearyImapClientServiceForceDisconnectSessionData* _data_);
static void geary_imap_client_service_force_disconnect_session_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static void geary_imap_client_service_remove_session_async_data_free (gpointer _data);
static gboolean geary_imap_client_service_remove_session_async_co (GearyImapClientServiceRemoveSessionAsyncData* _data_);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static void ___lambda105_ (Block27Data* _data27_,
                    GError** error);
static void ____lambda105__geary_nonblocking_mutex_critical_section (gpointer self,
                                                              GError** error);
static void geary_imap_client_service_remove_session_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void ___lambda106_ (GearyImapClientService* self,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda106__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void geary_imap_client_service_finalize (GObject * obj);
static GType geary_imap_client_service_get_type_once (void);
static void _vala_geary_imap_client_service_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_geary_imap_client_service_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_imap_client_service_get_instance_private (GearyImapClientService* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapClientService_private_offset);
}

guint
geary_imap_client_service_get_unselected_keepalive_sec (GearyImapClientService* self)
{
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self), 0U);
	result = self->priv->_unselected_keepalive_sec;
	return result;
}

void
geary_imap_client_service_set_unselected_keepalive_sec (GearyImapClientService* self,
                                                        guint value)
{
	guint old_value;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	old_value = geary_imap_client_service_get_unselected_keepalive_sec (self);
	if (old_value != value) {
		self->priv->_unselected_keepalive_sec = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_UNSELECTED_KEEPALIVE_SEC_PROPERTY]);
	}
}

guint
geary_imap_client_service_get_selected_keepalive_sec (GearyImapClientService* self)
{
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self), 0U);
	result = self->priv->_selected_keepalive_sec;
	return result;
}

void
geary_imap_client_service_set_selected_keepalive_sec (GearyImapClientService* self,
                                                      guint value)
{
	guint old_value;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	old_value = geary_imap_client_service_get_selected_keepalive_sec (self);
	if (old_value != value) {
		self->priv->_selected_keepalive_sec = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_SELECTED_KEEPALIVE_SEC_PROPERTY]);
	}
}

guint
geary_imap_client_service_get_selected_with_idle_keepalive_sec (GearyImapClientService* self)
{
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self), 0U);
	result = self->priv->_selected_with_idle_keepalive_sec;
	return result;
}

void
geary_imap_client_service_set_selected_with_idle_keepalive_sec (GearyImapClientService* self,
                                                                guint value)
{
	guint old_value;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	old_value = geary_imap_client_service_get_selected_with_idle_keepalive_sec (self);
	if (old_value != value) {
		self->priv->_selected_with_idle_keepalive_sec = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_SELECTED_WITH_IDLE_KEEPALIVE_SEC_PROPERTY]);
	}
}

gint
geary_imap_client_service_get_min_pool_size (GearyImapClientService* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self), 0);
	result = self->priv->_min_pool_size;
	return result;
}

void
geary_imap_client_service_set_min_pool_size (GearyImapClientService* self,
                                             gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	old_value = geary_imap_client_service_get_min_pool_size (self);
	if (old_value != value) {
		self->priv->_min_pool_size = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_MIN_POOL_SIZE_PROPERTY]);
	}
}

gint
geary_imap_client_service_get_max_free_size (GearyImapClientService* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self), 0);
	result = self->priv->_max_free_size;
	return result;
}

void
geary_imap_client_service_set_max_free_size (GearyImapClientService* self,
                                             gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	old_value = geary_imap_client_service_get_max_free_size (self);
	if (old_value != value) {
		self->priv->_max_free_size = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_MAX_FREE_SIZE_PROPERTY]);
	}
}

static const gchar*
geary_imap_client_service_real_get_logging_domain (GearyClientService* base)
{
	const gchar* result;
	GearyImapClientService* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_CLIENT_SERVICE, GearyImapClientService);
	result = GEARY_IMAP_CLIENT_SERVICE_LOGGING_DOMAIN;
	return result;
}

GearyImapClientService*
geary_imap_client_service_construct (GType object_type,
                                     GearyAccountInformation* account,
                                     GearyServiceInformation* configuration,
                                     GearyEndpoint* remote)
{
	GearyImapClientService * self = NULL;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (account), NULL);
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (configuration), NULL);
	g_return_val_if_fail (GEARY_IS_ENDPOINT (remote), NULL);
	self = (GearyImapClientService*) geary_client_service_construct (object_type, account, configuration, remote);
	return self;
}

GearyImapClientService*
geary_imap_client_service_new (GearyAccountInformation* account,
                               GearyServiceInformation* configuration,
                               GearyEndpoint* remote)
{
	return geary_imap_client_service_construct (GEARY_IMAP_TYPE_CLIENT_SERVICE, account, configuration, remote);
}

static void
geary_imap_client_service_real_start_data_free (gpointer _data)
{
	GearyImapClientServiceStartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceStartData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_client_service_real_start (GearyClientService* base,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GearyImapClientService * self;
	GearyImapClientServiceStartData* _data_;
	GearyImapClientService* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_CLIENT_SERVICE, GearyImapClientService);
	_data_ = g_slice_new0 (GearyImapClientServiceStartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_real_start_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_client_service_real_start_co (_data_);
}

static void
geary_imap_client_service_start_finish (GearyClientService* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GearyImapClientServiceStartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Starts the manager opening IMAP client sessions.
     */
static gboolean
geary_imap_client_service_real_start_co (GearyImapClientServiceStartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_client_service_get_is_running (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_ALREADY_OPEN, "IMAP client service already open");
		_data_->_inner_error0_ = _data_->_tmp2_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->pool_cancellable);
	_data_->self->priv->pool_cancellable = _data_->_tmp3_;
	_data_->_tmp4_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->close_cancellable);
	_data_->self->priv->close_cancellable = _data_->_tmp4_;
	geary_client_service_notify_started (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_service_real_stop_data_free (gpointer _data)
{
	GearyImapClientServiceStopData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceStopData, _data_);
}

static void
geary_imap_client_service_real_stop (GearyClientService* base,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GearyImapClientService * self;
	GearyImapClientServiceStopData* _data_;
	GearyImapClientService* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_CLIENT_SERVICE, GearyImapClientService);
	_data_ = g_slice_new0 (GearyImapClientServiceStopData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_real_stop_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_client_service_real_stop_co (_data_);
}

static void
geary_imap_client_service_stop_finish (GearyClientService* base,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GearyImapClientServiceStopData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Stops the manager running, closing any existing sessions.
     */
static void
geary_imap_client_service_stop_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GearyImapClientServiceStopData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_service_real_stop_co (_data_);
}

static gboolean
_geary_imap_client_service_real_stop_co_gsource_func (gpointer self)
{
	gboolean result;
	result = geary_imap_client_service_real_stop_co (self);
	return result;
}

static gboolean
geary_imap_client_service_real_stop_co (GearyImapClientServiceStopData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_client_service_get_is_running (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp1_ = _data_->_tmp0_;
	if (!_data_->_tmp1_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_client_service_notify_stopped (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp2_ = _data_->self->priv->pool_cancellable;
	g_cancellable_cancel (_data_->_tmp2_);
	_data_->_state_ = 1;
	geary_imap_client_service_close_pool (_data_->self, TRUE, geary_imap_client_service_stop_ready, _data_);
	return FALSE;
	_state_1:
	geary_imap_client_service_close_pool_finish (_data_->self, _data_->_res_);
	_data_->attempts = 0;
	while (TRUE) {
		_data_->_tmp3_ = _data_->self->priv->all_sessions;
		_data_->_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp5_ = _data_->_tmp4_;
		if (!(_data_->_tmp5_ > 0)) {
			break;
		}
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Waiting for client sessions to disconnect...");
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _geary_imap_client_service_real_stop_co_gsource_func, _data_, NULL);
		_data_->_state_ = 2;
		return FALSE;
		_state_2:
		;
		_data_->attempts = _data_->attempts + 1;
		_data_->_tmp6_ = _data_->attempts;
		if (_data_->_tmp6_ > 12) {
			break;
		}
	}
	_data_->_tmp7_ = _data_->self->priv->all_sessions;
	_data_->_tmp8_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp9_ = _data_->_tmp8_;
	if (_data_->_tmp9_ > 0) {
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Cancelling remaining client sessions...");
		_data_->_tmp10_ = _data_->self->priv->close_cancellable;
		g_cancellable_cancel (_data_->_tmp10_);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_service_claim_authorized_session_async_data_free (gpointer _data)
{
	GearyImapClientServiceClaimAuthorizedSessionAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceClaimAuthorizedSessionAsyncData, _data_);
}

void
geary_imap_client_service_claim_authorized_session_async (GearyImapClientService* self,
                                                          GCancellable* cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	GearyImapClientServiceClaimAuthorizedSessionAsyncData* _data_;
	GearyImapClientService* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapClientServiceClaimAuthorizedSessionAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_claim_authorized_session_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_client_service_claim_authorized_session_async_co (_data_);
}

GearyImapClientSession*
geary_imap_client_service_claim_authorized_session_finish (GearyImapClientService* self,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	GearyImapClientSession* result;
	GearyImapClientServiceClaimAuthorizedSessionAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Claims a free session, blocking until one becomes available.
     *
     * This call will fail fast if the pool is known to not in the
     * right state (bad authorisation credentials, host not ready,
     * etc), but then will block while attempting to obtain a
     * connection if the free queue is empty. If an error occurs when
     * this connection is in progress, then the call will block until
     * another becomes available (host becomes reachable again, user
     * enters password, etc). If this is undesirable, then the caller
     * may cancel the call.
     *
     * @throws ImapError.UNAUTHENTICATED if the stored credentials are
     * invalid.
     * @throws ImapError.UNAVAILABLE if the IMAP endpoint is not
     * trusted or is not reachable.
     */
static void
geary_imap_client_service_claim_authorized_session_async_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	GearyImapClientServiceClaimAuthorizedSessionAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_service_claim_authorized_session_async_co (_data_);
}

static gboolean
geary_imap_client_service_claim_authorized_session_async_co (GearyImapClientServiceClaimAuthorizedSessionAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_client_service_get_is_running (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp1_ = _data_->_tmp0_;
	if (!_data_->_tmp1_) {
		_data_->_tmp2_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_OPEN_REQUIRED, "IMAP client service is not running");
		_data_->_inner_error0_ = _data_->_tmp2_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->free_queue;
	_data_->_tmp4_ = geary_nonblocking_queue_get_size (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->self->priv->all_sessions;
	_data_->_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp8_ = _data_->_tmp7_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Claiming session with %d of %d free", _data_->_tmp5_, _data_->_tmp8_);
	_data_->_tmp9_ = geary_client_service_get_current_status (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp10_ = _data_->_tmp9_;
	if (_data_->_tmp10_ == GEARY_CLIENT_SERVICE_STATUS_AUTHENTICATION_FAILED) {
		_data_->_tmp11_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_UNAUTHENTICATED, "Invalid credentials");
		_data_->_inner_error0_ = _data_->_tmp11_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = geary_client_service_get_current_status (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp13_ = _data_->_tmp12_;
	if (_data_->_tmp13_ == GEARY_CLIENT_SERVICE_STATUS_TLS_VALIDATION_FAILED) {
		_data_->_tmp14_ = geary_client_service_get_remote (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = geary_endpoint_to_string (_data_->_tmp15_);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_UNAVAILABLE, "Untrusted host %s", _data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_g_free0 (_data_->_tmp17_);
		_data_->_inner_error0_ = _data_->_tmp19_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->claimed = NULL;
	while (TRUE) {
		_data_->_tmp20_ = _data_->claimed;
		if (!(_data_->_tmp20_ == NULL)) {
			break;
		}
		_data_->_tmp21_ = _data_->self->priv->free_queue;
		_data_->_tmp22_ = geary_nonblocking_queue_get_size (_data_->_tmp21_);
		_data_->_tmp23_ = _data_->_tmp22_;
		if (_data_->_tmp23_ == 0) {
			geary_imap_client_service_check_pool (_data_->self, TRUE, NULL, NULL);
		}
		_data_->_tmp25_ = _data_->self->priv->free_queue;
		_data_->_state_ = 1;
		geary_nonblocking_queue_receive (_data_->_tmp25_, _data_->cancellable, geary_imap_client_service_claim_authorized_session_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp26_ = geary_nonblocking_queue_receive_finish (_data_->_tmp25_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp24_ = (GearyImapClientSession*) _data_->_tmp26_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->claimed);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp27_ = _data_->_tmp24_;
		_data_->_tmp24_ = NULL;
		_g_object_unref0 (_data_->claimed);
		_data_->claimed = _data_->_tmp27_;
		_data_->_tmp28_ = _data_->claimed;
		_data_->_state_ = 2;
		geary_imap_client_service_check_session (_data_->self, _data_->_tmp28_, TRUE, geary_imap_client_service_claim_authorized_session_async_ready, _data_);
		return FALSE;
		_state_2:
		if (!geary_imap_client_service_check_session_finish (_data_->self, _data_->_res_)) {
			_g_object_unref0 (_data_->claimed);
			_data_->claimed = NULL;
		}
		_g_object_unref0 (_data_->_tmp24_);
	}
	_data_->result = _data_->claimed;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_service_release_session_async_data_free (gpointer _data)
{
	GearyImapClientServiceReleaseSessionAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceReleaseSessionAsyncData, _data_);
}

void
geary_imap_client_service_release_session_async (GearyImapClientService* self,
                                                 GearyImapClientSession* session,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	GearyImapClientServiceReleaseSessionAsyncData* _data_;
	GearyImapClientService* _tmp0_;
	GearyImapClientSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SESSION (session));
	_data_ = g_slice_new0 (GearyImapClientServiceReleaseSessionAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_release_session_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (session);
	_g_object_unref0 (_data_->session);
	_data_->session = _tmp1_;
	geary_imap_client_service_release_session_async_co (_data_);
}

void
geary_imap_client_service_release_session_finish (GearyImapClientService* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GearyImapClientServiceReleaseSessionAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_client_service_release_session_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	GearyImapClientServiceReleaseSessionAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_service_release_session_async_co (_data_);
}

static gboolean
geary_imap_client_service_release_session_async_co (GearyImapClientServiceReleaseSessionAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->free_queue;
	_data_->_tmp1_ = geary_nonblocking_queue_get_size (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->self->priv->all_sessions;
	_data_->_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp5_ = _data_->_tmp4_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Returning session with %d of %d free", _data_->_tmp2_, _data_->_tmp5_);
	_data_->_tmp7_ = _data_->self->priv->free_queue;
	_data_->_tmp8_ = geary_nonblocking_queue_get_size (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->self->priv->_max_free_size;
	if (_data_->_tmp9_ >= _data_->_tmp10_) {
		_data_->_tmp11_ = _data_->self->priv->all_sessions;
		_data_->_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = _data_->self->priv->_min_pool_size;
		_data_->_tmp6_ = _data_->_tmp13_ > _data_->_tmp14_;
	} else {
		_data_->_tmp6_ = FALSE;
	}
	_data_->too_many_free = _data_->_tmp6_;
	if (_data_->too_many_free) {
		_data_->_tmp17_ = TRUE;
	} else {
		_data_->_tmp17_ = _data_->self->discard_returned_sessions;
	}
	if (_data_->_tmp17_) {
		_data_->_tmp16_ = TRUE;
	} else {
		_data_->_tmp18_ = geary_client_service_get_is_running (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp16_ = !_data_->_tmp19_;
	}
	if (_data_->_tmp16_) {
		_data_->_tmp15_ = TRUE;
	} else {
		_data_->_state_ = 1;
		geary_imap_client_service_check_session (_data_->self, _data_->session, FALSE, geary_imap_client_service_release_session_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp15_ = !geary_imap_client_service_check_session_finish (_data_->self, _data_->_res_);
	}
	_data_->disconnect = _data_->_tmp15_;
	if (!_data_->disconnect) {
		_data_->_tmp20_ = geary_imap_client_session_get_protocol_state (_data_->session);
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->proto = _data_->_tmp21_;
		if (_data_->proto == GEARY_IMAP_CLIENT_SESSION_PROTOCOL_STATE_SELECTED) {
			_data_->_tmp22_ = TRUE;
		} else {
			_data_->_tmp22_ = _data_->proto == GEARY_IMAP_CLIENT_SESSION_PROTOCOL_STATE_SELECTING;
		}
		if (_data_->_tmp22_) {
			{
				_data_->_tmp23_ = _data_->self->priv->close_cancellable;
				_data_->_state_ = 2;
				geary_imap_client_session_close_mailbox_async (_data_->session, _data_->_tmp23_, geary_imap_client_service_release_session_async_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp24_ = geary_imap_client_session_close_mailbox_finish (_data_->session, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp25_ = _data_->_tmp24_;
				_g_object_unref0 (_data_->_tmp25_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if (_data_->_inner_error0_->domain == GEARY_IMAP_ERROR) {
						goto __catch0_geary_imap_error;
					}
					goto __finally0;
				}
			}
			goto __finally0;
			__catch0_geary_imap_error:
			{
				_data_->imap_error = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp26_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->session, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
				_data_->_tmp27_ = _data_->_tmp26_;
				_data_->_tmp28_ = _data_->imap_error;
				_data_->_tmp29_ = _data_->_tmp28_->message;
				geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error attempting to close released session %s: %s", _data_->_tmp27_, _data_->_tmp29_);
				_g_free0 (_data_->_tmp27_);
				_data_->disconnect = TRUE;
				_g_error_free0 (_data_->imap_error);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp30_ = geary_imap_client_session_get_protocol_state (_data_->session);
			_data_->_tmp31_ = _data_->_tmp30_;
			if (_data_->_tmp31_ != GEARY_IMAP_CLIENT_SESSION_PROTOCOL_STATE_AUTHORIZED) {
				_data_->disconnect = TRUE;
			}
		}
		if (!_data_->disconnect) {
			_data_->_tmp32_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->session, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
			_data_->_tmp33_ = _data_->_tmp32_;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Unreserving session %s", _data_->_tmp33_);
			_g_free0 (_data_->_tmp33_);
			_data_->_tmp34_ = _data_->self->priv->free_queue;
			geary_nonblocking_queue_send (_data_->_tmp34_, _data_->session);
		} else {
			_data_->_state_ = 3;
			geary_imap_client_service_disconnect_session (_data_->self, _data_->session, geary_imap_client_service_release_session_async_ready, _data_);
			return FALSE;
			_state_3:
			geary_imap_client_service_disconnect_session_finish (_data_->self, _data_->_res_);
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/** Restarts the client session pool. */
static void
geary_imap_client_service_real_became_reachable (GearyClientService* base)
{
	GearyImapClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_CLIENT_SERVICE, GearyImapClientService);
	geary_imap_client_service_check_pool (self, FALSE, NULL, NULL);
}

/** Closes the client session pool. */
static void
geary_imap_client_service_real_became_unreachable (GearyClientService* base)
{
	GearyImapClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_CLIENT_SERVICE, GearyImapClientService);
	geary_imap_client_service_close_pool (self, FALSE, NULL, NULL);
}

static void
geary_imap_client_service_check_pool_data_free (gpointer _data)
{
	GearyImapClientServiceCheckPoolData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceCheckPoolData, _data_);
}

static void
geary_imap_client_service_check_pool (GearyImapClientService* self,
                                      gboolean is_claiming,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GearyImapClientServiceCheckPoolData* _data_;
	GearyImapClientService* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	_data_ = g_slice_new0 (GearyImapClientServiceCheckPoolData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_check_pool_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->is_claiming = is_claiming;
	geary_imap_client_service_check_pool_co (_data_);
}

static void
geary_imap_client_service_check_pool_finish (GearyImapClientService* self,
                                             GAsyncResult* _res_)
{
	GearyImapClientServiceCheckPoolData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
geary_imap_client_service_check_pool_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	GearyImapClientServiceCheckPoolData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_service_check_pool_co (_data_);
}

static gboolean
geary_imap_client_service_check_pool_co (GearyImapClientServiceCheckPoolData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->free_queue;
	_data_->_tmp1_ = geary_nonblocking_queue_get_size (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->self->priv->all_sessions;
	_data_->_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp5_ = _data_->_tmp4_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Checking session pool with %d of %d free", _data_->_tmp2_, _data_->_tmp5_);
	if (!_data_->is_claiming) {
		{
			_data_->_tmp6_ = geary_client_service_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = _data_->self->priv->pool_cancellable;
			_data_->_state_ = 1;
			geary_account_information_load_incoming_credentials (_data_->_tmp7_, _data_->_tmp8_, geary_imap_client_service_check_pool_ready, _data_);
			return FALSE;
			_state_1:
			_data_->loaded = geary_account_information_load_incoming_credentials_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (!_data_->loaded) {
				geary_client_service_notify_authentication_failed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp9_ = _data_->err;
			_data_->_tmp10_ = geary_error_context_new (_data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			geary_client_service_notify_connection_failed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService), _data_->_tmp11_);
			_g_object_unref0 (_data_->_tmp11_);
			_g_error_free0 (_data_->err);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp12_ = _data_->self->priv->_min_pool_size;
	_data_->_tmp13_ = _data_->self->priv->all_sessions;
	_data_->_tmp14_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->needed = _data_->_tmp12_ - _data_->_tmp15_;
	if (_data_->needed <= 0) {
		_data_->_tmp16_ = _data_->is_claiming;
	} else {
		_data_->_tmp16_ = FALSE;
	}
	if (_data_->_tmp16_) {
		_data_->needed = 1;
	}
	while (TRUE) {
		if (!(_data_->needed > 0)) {
			break;
		}
		geary_imap_client_service_add_pool_session (_data_->self, NULL, NULL);
		_data_->_tmp17_ = _data_->needed;
		_data_->needed = _data_->_tmp17_ - 1;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_service_add_pool_session_data_free (gpointer _data)
{
	GearyImapClientServiceAddPoolSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceAddPoolSessionData, _data_);
}

static void
geary_imap_client_service_add_pool_session (GearyImapClientService* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearyImapClientServiceAddPoolSessionData* _data_;
	GearyImapClientService* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	_data_ = g_slice_new0 (GearyImapClientServiceAddPoolSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_add_pool_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_client_service_add_pool_session_co (_data_);
}

static void
geary_imap_client_service_add_pool_session_finish (GearyImapClientService* self,
                                                   GAsyncResult* _res_)
{
	GearyImapClientServiceAddPoolSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		GearyImapClientService* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->new_session);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static void
geary_imap_client_service_add_pool_session_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	GearyImapClientServiceAddPoolSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_service_add_pool_session_co (_data_);
}

static void
____lambda108_ (Block25Data* _data25_,
                GError** error)
{
	GearyImapClientService* self;
	GeeSet* _tmp0_;
	GearyImapClientSession* _tmp1_;
	self = _data25_->self;
	_tmp0_ = self->priv->all_sessions;
	_tmp1_ = _data25_->new_session;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
}

static void
_____lambda108__geary_nonblocking_mutex_critical_section (gpointer self,
                                                          GError** error)
{
	____lambda108_ (self, error);
}

static gboolean
geary_imap_client_service_add_pool_session_co (GearyImapClientServiceAddPoolSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data25_ = g_slice_new0 (Block25Data);
	_data_->_data25_->_ref_count_ = 1;
	_data_->_data25_->self = g_object_ref (_data_->self);
	_data_->_data25_->_async_data_ = _data_;
	_data_->_data25_->new_session = NULL;
	{
		_data_->_tmp1_ = _data_->self->priv->pool_cancellable;
		_data_->_state_ = 1;
		geary_imap_client_service_create_new_authorized_session (_data_->self, _data_->_tmp1_, geary_imap_client_service_add_pool_session_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = geary_imap_client_service_create_new_authorized_session_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_UNAUTHENTICATED)) {
				goto __catch0_geary_imap_error_unauthenticated;
			}
			if (g_error_matches (_data_->_inner_error0_, G_TLS_ERROR, G_TLS_ERROR_BAD_CERTIFICATE)) {
				goto __catch0_g_tls_error_bad_certificate;
			}
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->_data25_->new_session);
		_data_->_data25_->new_session = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_geary_imap_error_unauthenticated:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Auth error adding new session to the pool: %s", _data_->_tmp5_);
		geary_client_service_notify_authentication_failed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
		_g_error_free0 (_data_->err);
	}
	goto __finally0;
	__catch0_g_tls_error_bad_certificate:
	{
		_data_->_vala1_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->_vala1_err;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "TLS validation error adding new session to the pool: %s", _data_->_tmp7_);
		_g_error_free0 (_data_->_vala1_err);
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_vala2_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->_vala2_err;
		_data_->_tmp9_ = geary_error_context_new (_data_->_tmp8_);
		_data_->context = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->context;
		_data_->_tmp11_ = geary_error_context_format_full_error (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error creating new session for the pool: %s", _data_->_tmp12_);
		_g_free0 (_data_->_tmp12_);
		_data_->_tmp13_ = _data_->context;
		geary_client_service_notify_connection_failed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService), _data_->_tmp13_);
		_g_object_unref0 (_data_->context);
		_g_error_free0 (_data_->_vala2_err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block25_data_unref (_data_->_data25_);
		_data_->_data25_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->_data25_->new_session;
	if (_data_->_tmp14_ == NULL) {
		geary_imap_client_service_close_pool (_data_->self, TRUE, NULL, NULL);
	} else {
		_data_->_tmp15_ = _data_->self->priv->quirks;
		_data_->_tmp16_ = _data_->_data25_->new_session;
		geary_imap_quirks_update_for_server (_data_->_tmp15_, _data_->_tmp16_);
		{
			_data_->_tmp17_ = _data_->self->priv->sessions_mutex;
			_data_->_state_ = 2;
			geary_nonblocking_mutex_execute_locked (_data_->_tmp17_, _____lambda108__geary_nonblocking_mutex_critical_section, _data_->_data25_, NULL, geary_imap_client_service_add_pool_session_ready, _data_);
			return FALSE;
			_state_2:
			geary_nonblocking_mutex_execute_locked_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp18_ = _data_->self->priv->free_queue;
			_data_->_tmp19_ = _data_->_data25_->new_session;
			geary_nonblocking_queue_send (_data_->_tmp18_, _data_->_tmp19_);
			geary_client_service_notify_connected (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala3_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp20_ = _data_->_vala3_err;
			_data_->_tmp21_ = geary_error_context_new (_data_->_tmp20_);
			_data_->_vala1_context = _data_->_tmp21_;
			_data_->_tmp22_ = _data_->_vala1_context;
			_data_->_tmp23_ = geary_error_context_format_full_error (_data_->_tmp22_);
			_data_->_tmp24_ = _data_->_tmp23_;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error adding new session to the pool: %s", _data_->_tmp24_);
			_g_free0 (_data_->_tmp24_);
			_data_->_tmp25_ = _data_->_vala1_context;
			geary_client_service_notify_connection_failed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService), _data_->_tmp25_);
			_data_->_tmp26_ = _data_->_data25_->new_session;
			geary_imap_client_session_disconnect_async (_data_->_tmp26_, NULL, NULL, NULL);
			geary_imap_client_service_close_pool (_data_->self, TRUE, NULL, NULL);
			_g_object_unref0 (_data_->_vala1_context);
			_g_error_free0 (_data_->_vala3_err);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			block25_data_unref (_data_->_data25_);
			_data_->_data25_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	block25_data_unref (_data_->_data25_);
	_data_->_data25_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_service_check_session_data_free (gpointer _data)
{
	GearyImapClientServiceCheckSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->target);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceCheckSessionData, _data_);
}

static void
geary_imap_client_service_check_session (GearyImapClientService* self,
                                         GearyImapClientSession* target,
                                         gboolean claiming,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GearyImapClientServiceCheckSessionData* _data_;
	GearyImapClientService* _tmp0_;
	GearyImapClientSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SESSION (target));
	_data_ = g_slice_new0 (GearyImapClientServiceCheckSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_check_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (target);
	_g_object_unref0 (_data_->target);
	_data_->target = _tmp1_;
	_data_->claiming = claiming;
	geary_imap_client_service_check_session_co (_data_);
}

static gboolean
geary_imap_client_service_check_session_finish (GearyImapClientService* self,
                                                GAsyncResult* _res_)
{
	gboolean result;
	GearyImapClientServiceCheckSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

/** Determines if a session is valid, disposing of it if not. */
static void
geary_imap_client_service_check_session_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GearyImapClientServiceCheckSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_service_check_session_co (_data_);
}

static gboolean
geary_imap_client_service_check_session_co (GearyImapClientServiceCheckSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->valid = FALSE;
	_data_->_tmp0_ = geary_imap_client_session_get_protocol_state (_data_->target);
	_data_->_tmp1_ = _data_->_tmp0_;
	switch (_data_->_tmp1_) {
		case GEARY_IMAP_CLIENT_SESSION_PROTOCOL_STATE_AUTHORIZED:
		case GEARY_IMAP_CLIENT_SESSION_PROTOCOL_STATE_CLOSING_MAILBOX:
		{
			_data_->valid = TRUE;
			break;
		}
		case GEARY_IMAP_CLIENT_SESSION_PROTOCOL_STATE_SELECTED:
		case GEARY_IMAP_CLIENT_SESSION_PROTOCOL_STATE_SELECTING:
		{
			if (_data_->claiming) {
				_data_->_state_ = 1;
				geary_imap_client_service_disconnect_session (_data_->self, _data_->target, geary_imap_client_service_check_session_ready, _data_);
				return FALSE;
				_state_1:
				geary_imap_client_service_disconnect_session_finish (_data_->self, _data_->_res_);
			} else {
				_data_->valid = TRUE;
			}
			break;
		}
		default:
		{
			_data_->_state_ = 2;
			geary_imap_client_service_disconnect_session (_data_->self, _data_->target, geary_imap_client_service_check_session_ready, _data_);
			return FALSE;
			_state_2:
			geary_imap_client_service_disconnect_session_finish (_data_->self, _data_->_res_);
			break;
		}
	}
	if (_data_->claiming) {
		_data_->_tmp3_ = geary_imap_client_session_get_last_seen (_data_->target);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp2_ = (_data_->_tmp4_ + (GEARY_IMAP_CLIENT_SERVICE_CHECK_NOOP_THRESHOLD_SEC * 1000000)) < g_get_real_time ();
	} else {
		_data_->_tmp2_ = FALSE;
	}
	if (_data_->_tmp2_) {
		{
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Sending NOOP when claiming a session");
			_data_->_tmp5_ = _data_->self->priv->close_cancellable;
			_data_->_tmp6_ = geary_imap_noop_command_new (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_state_ = 3;
			geary_imap_client_session_send_command_async (_data_->target, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), geary_imap_client_service_check_session_ready, _data_);
			return FALSE;
			_state_3:
			_data_->_tmp8_ = geary_imap_client_session_send_command_finish (_data_->target, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_g_object_unref0 (_data_->_tmp9_);
			_g_object_unref0 (_data_->_tmp7_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp10_ = _data_->err;
			_data_->_tmp11_ = _data_->_tmp10_->message;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error sending NOOP: %s", _data_->_tmp11_);
			_data_->valid = FALSE;
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->valid;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_service_create_new_authorized_session_data_free (gpointer _data)
{
	GearyImapClientServiceCreateNewAuthorizedSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceCreateNewAuthorizedSessionData, _data_);
}

static void
geary_imap_client_service_create_new_authorized_session (GearyImapClientService* self,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GearyImapClientServiceCreateNewAuthorizedSessionData* _data_;
	GearyImapClientService* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapClientServiceCreateNewAuthorizedSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_create_new_authorized_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_client_service_create_new_authorized_session_co (_data_);
}

static GearyImapClientSession*
geary_imap_client_service_create_new_authorized_session_finish (GearyImapClientService* self,
                                                                GAsyncResult* _res_,
                                                                GError** error)
{
	GearyImapClientSession* result;
	GearyImapClientServiceCreateNewAuthorizedSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_imap_client_service_create_new_authorized_session_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	GearyImapClientServiceCreateNewAuthorizedSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_service_create_new_authorized_session_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
_geary_imap_client_service_on_session_disconnected_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self)
{
	geary_imap_client_service_on_session_disconnected ((GearyImapClientService*) self, _sender, pspec);
}

static gboolean
geary_imap_client_service_create_new_authorized_session_co (GearyImapClientServiceCreateNewAuthorizedSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Opening new session");
	_data_->_tmp0_ = geary_client_service_get_configuration (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = geary_service_information_get_credentials (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->login = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->login;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->login;
		_data_->_tmp5_ = !geary_credentials_is_complete (_data_->_tmp7_);
	} else {
		_data_->_tmp5_ = FALSE;
	}
	if (_data_->_tmp5_) {
		_data_->_tmp8_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_UNAUTHENTICATED, "Token not loaded");
		_data_->_inner_error0_ = _data_->_tmp8_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->login);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = geary_client_service_get_remote (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->self->priv->quirks;
	_data_->_tmp12_ = geary_imap_client_session_new (_data_->_tmp10_, _data_->_tmp11_);
	_data_->new_session = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->new_session;
	geary_imap_client_session_set_logging_parent (_data_->_tmp13_, G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp14_ = _data_->new_session;
	_data_->_state_ = 1;
	geary_imap_client_session_connect_async (_data_->_tmp14_, GEARY_IMAP_CLIENT_SESSION_DEFAULT_GREETING_TIMEOUT_SEC, _data_->cancellable, geary_imap_client_service_create_new_authorized_session_ready, _data_);
	return FALSE;
	_state_1:
	geary_imap_client_session_connect_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->new_session);
		_g_object_unref0 (_data_->login);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp15_ = _data_->new_session;
		_data_->_tmp16_ = _data_->login;
		_data_->_state_ = 2;
		geary_imap_client_session_initiate_session_async (_data_->_tmp15_, _data_->_tmp16_, _data_->cancellable, geary_imap_client_service_create_new_authorized_session_ready, _data_);
		return FALSE;
		_state_2:
		geary_imap_client_session_initiate_session_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		{
			_data_->_tmp17_ = _data_->new_session;
			_data_->_state_ = 3;
			geary_imap_client_session_disconnect_async (_data_->_tmp17_, NULL, geary_imap_client_service_create_new_authorized_session_ready, _data_);
			return FALSE;
			_state_3:
			geary_imap_client_session_disconnect_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->disconnect_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp18_ = _data_->disconnect_err;
			_data_->_tmp19_ = _data_->_tmp18_->message;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error disconnecting due to session initiation failure, ignored: %s", _data_->_tmp19_);
			_g_error_free0 (_data_->disconnect_err);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_error_free0 (_data_->err);
			_g_object_unref0 (_data_->new_session);
			_g_object_unref0 (_data_->login);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp20_ = _data_->err;
		_data_->_tmp21_ = _g_error_copy0 (_data_->_tmp20_);
		_data_->_inner_error0_ = _data_->_tmp21_;
		_g_error_free0 (_data_->err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->new_session);
		_g_object_unref0 (_data_->login);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp22_ = _data_->new_session;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, G_TYPE_OBJECT, GObject), "notify::disconnected", (GCallback) _geary_imap_client_service_on_session_disconnected_g_object_notify, _data_->self, 0);
	_data_->_tmp23_ = _data_->new_session;
	_data_->_tmp24_ = _data_->self->priv->_selected_keepalive_sec;
	_data_->_tmp25_ = _data_->self->priv->_unselected_keepalive_sec;
	_data_->_tmp26_ = _data_->self->priv->_selected_with_idle_keepalive_sec;
	geary_imap_client_session_enable_keepalives (_data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_, _data_->_tmp26_);
	_data_->result = _data_->new_session;
	_g_object_unref0 (_data_->login);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_service_close_pool_data_free (gpointer _data)
{
	GearyImapClientServiceClosePoolData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceClosePoolData, _data_);
}

static void
geary_imap_client_service_close_pool (GearyImapClientService* self,
                                      gboolean clean_disconnect,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GearyImapClientServiceClosePoolData* _data_;
	GearyImapClientService* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	_data_ = g_slice_new0 (GearyImapClientServiceClosePoolData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_close_pool_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->clean_disconnect = clean_disconnect;
	geary_imap_client_service_close_pool_co (_data_);
}

static void
geary_imap_client_service_close_pool_finish (GearyImapClientService* self,
                                             GAsyncResult* _res_)
{
	GearyImapClientServiceClosePoolData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		GearyImapClientService* self;
		self = _data26_->self;
		_data26_->to_close = (_vala_array_free (_data26_->to_close, _data26_->to_close_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static void
___lambda107_ (Block26Data* _data26_,
               GError** error)
{
	GearyImapClientService* self;
	GeeSet* _tmp0_;
	gint _tmp1_ = 0;
	gpointer* _tmp2_;
	self = _data26_->self;
	_tmp0_ = self->priv->all_sessions;
	_tmp2_ = gee_collection_to_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), &_tmp1_);
	_data26_->to_close = (_vala_array_free (_data26_->to_close, _data26_->to_close_length1, (GDestroyNotify) g_object_unref), NULL);
	_data26_->to_close = _tmp2_;
	_data26_->to_close_length1 = _tmp1_;
	_data26_->_to_close_size_ = _data26_->to_close_length1;
}

static void
____lambda107__geary_nonblocking_mutex_critical_section (gpointer self,
                                                         GError** error)
{
	___lambda107_ (self, error);
}

static void
geary_imap_client_service_close_pool_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	GearyImapClientServiceClosePoolData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_service_close_pool_co (_data_);
}

static gboolean
geary_imap_client_service_close_pool_co (GearyImapClientServiceClosePoolData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data26_ = g_slice_new0 (Block26Data);
	_data_->_data26_->_ref_count_ = 1;
	_data_->_data26_->self = g_object_ref (_data_->self);
	_data_->_data26_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->all_sessions;
	_data_->_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp2_ = _data_->_tmp1_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Closing the pool, disconnecting %d sessions", _data_->_tmp2_);
	_data_->_data26_->to_close = NULL;
	_data_->_data26_->to_close_length1 = 0;
	_data_->_data26_->_to_close_size_ = _data_->_data26_->to_close_length1;
	{
		_data_->_tmp3_ = _data_->self->priv->sessions_mutex;
		_data_->_state_ = 1;
		geary_nonblocking_mutex_execute_locked (_data_->_tmp3_, ____lambda107__geary_nonblocking_mutex_critical_section, _data_->_data26_, NULL, geary_imap_client_service_close_pool_ready, _data_);
		return FALSE;
		_state_1:
		geary_nonblocking_mutex_execute_locked_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error occurred copying sessions: %s", _data_->_tmp5_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block26_data_unref (_data_->_data26_);
		_data_->_data26_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->session_collection_length1 = 0;
		_data_->_session_collection_size_ = 0;
		_data_->session_collection = _data_->_data26_->to_close;
		_data_->session_collection_length1 = _data_->_data26_->to_close_length1;
		for (_data_->session_it = 0; _data_->session_it < _data_->session_collection_length1; _data_->session_it = _data_->session_it + 1) {
			_data_->_tmp6_ = _g_object_ref0 (_data_->session_collection[_data_->session_it]);
			_data_->session = _data_->_tmp6_;
			{
				if (_data_->clean_disconnect) {
					_data_->_tmp7_ = _data_->session;
					geary_imap_client_service_disconnect_session (_data_->self, _data_->_tmp7_, NULL, NULL);
				} else {
					_data_->_tmp8_ = _data_->session;
					geary_imap_client_service_force_disconnect_session (_data_->self, _data_->_tmp8_, NULL, NULL);
				}
				_g_object_unref0 (_data_->session);
			}
		}
	}
	block26_data_unref (_data_->_data26_);
	_data_->_data26_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_service_disconnect_session_data_free (gpointer _data)
{
	GearyImapClientServiceDisconnectSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceDisconnectSessionData, _data_);
}

static void
geary_imap_client_service_disconnect_session (GearyImapClientService* self,
                                              GearyImapClientSession* session,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GearyImapClientServiceDisconnectSessionData* _data_;
	GearyImapClientService* _tmp0_;
	GearyImapClientSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SESSION (session));
	_data_ = g_slice_new0 (GearyImapClientServiceDisconnectSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_disconnect_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (session);
	_g_object_unref0 (_data_->session);
	_data_->session = _tmp1_;
	geary_imap_client_service_disconnect_session_co (_data_);
}

static void
geary_imap_client_service_disconnect_session_finish (GearyImapClientService* self,
                                                     GAsyncResult* _res_)
{
	GearyImapClientServiceDisconnectSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
geary_imap_client_service_disconnect_session_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GearyImapClientServiceDisconnectSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_service_disconnect_session_co (_data_);
}

static gboolean
geary_imap_client_service_disconnect_session_co (GearyImapClientServiceDisconnectSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_imap_client_session_get_protocol_state (_data_->session);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ != GEARY_IMAP_CLIENT_SESSION_PROTOCOL_STATE_NOT_CONNECTED) {
		_data_->_tmp2_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->session, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp3_ = _data_->_tmp2_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Logging out session: %s", _data_->_tmp3_);
		_g_free0 (_data_->_tmp3_);
		{
			_data_->_tmp4_ = _data_->self->priv->close_cancellable;
			_data_->_state_ = 1;
			geary_imap_client_session_logout_async (_data_->session, _data_->_tmp4_, geary_imap_client_service_disconnect_session_ready, _data_);
			return FALSE;
			_state_1:
			geary_imap_client_session_logout_finish (_data_->session, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp5_ = _data_->err;
			_data_->_tmp6_ = _data_->_tmp5_->message;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error logging out of session: %s", _data_->_tmp6_);
			_data_->_state_ = 2;
			geary_imap_client_service_force_disconnect_session (_data_->self, _data_->session, geary_imap_client_service_disconnect_session_ready, _data_);
			return FALSE;
			_state_2:
			geary_imap_client_service_force_disconnect_session_finish (_data_->self, _data_->_res_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_state_ = 3;
		geary_imap_client_service_remove_session_async (_data_->self, _data_->session, geary_imap_client_service_disconnect_session_ready, _data_);
		return FALSE;
		_state_3:
		geary_imap_client_service_remove_session_finish (_data_->self, _data_->_res_);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_service_force_disconnect_session_data_free (gpointer _data)
{
	GearyImapClientServiceForceDisconnectSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceForceDisconnectSessionData, _data_);
}

static void
geary_imap_client_service_force_disconnect_session (GearyImapClientService* self,
                                                    GearyImapClientSession* session,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	GearyImapClientServiceForceDisconnectSessionData* _data_;
	GearyImapClientService* _tmp0_;
	GearyImapClientSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SESSION (session));
	_data_ = g_slice_new0 (GearyImapClientServiceForceDisconnectSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_force_disconnect_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (session);
	_g_object_unref0 (_data_->session);
	_data_->session = _tmp1_;
	geary_imap_client_service_force_disconnect_session_co (_data_);
}

static void
geary_imap_client_service_force_disconnect_session_finish (GearyImapClientService* self,
                                                           GAsyncResult* _res_)
{
	GearyImapClientServiceForceDisconnectSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
geary_imap_client_service_force_disconnect_session_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	GearyImapClientServiceForceDisconnectSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_service_force_disconnect_session_co (_data_);
}

static gboolean
geary_imap_client_service_force_disconnect_session_co (GearyImapClientServiceForceDisconnectSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->session, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp1_ = _data_->_tmp0_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Dropping session: %s", _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	_data_->_state_ = 1;
	geary_imap_client_service_remove_session_async (_data_->self, _data_->session, geary_imap_client_service_force_disconnect_session_ready, _data_);
	return FALSE;
	_state_1:
	geary_imap_client_service_remove_session_finish (_data_->self, _data_->_res_);
	geary_imap_client_session_disconnect_async (_data_->session, NULL, NULL, NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_client_service_remove_session_async_data_free (gpointer _data)
{
	GearyImapClientServiceRemoveSessionAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapClientServiceRemoveSessionAsyncData, _data_);
}

static void
geary_imap_client_service_remove_session_async (GearyImapClientService* self,
                                                GearyImapClientSession* session,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GearyImapClientServiceRemoveSessionAsyncData* _data_;
	GearyImapClientService* _tmp0_;
	GearyImapClientSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SESSION (session));
	_data_ = g_slice_new0 (GearyImapClientServiceRemoveSessionAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_client_service_remove_session_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (session);
	_g_object_unref0 (_data_->session);
	_data_->session = _tmp1_;
	geary_imap_client_service_remove_session_async_co (_data_);
}

static gboolean
geary_imap_client_service_remove_session_finish (GearyImapClientService* self,
                                                 GAsyncResult* _res_)
{
	gboolean result;
	GearyImapClientServiceRemoveSessionAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		GearyImapClientService* self;
		self = _data27_->self;
		_g_object_unref0 (_data27_->session);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}

static void
___lambda105_ (Block27Data* _data27_,
               GError** error)
{
	GearyImapClientService* self;
	GeeSet* _tmp0_;
	self = _data27_->self;
	_tmp0_ = self->priv->all_sessions;
	_data27_->removed = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _data27_->session);
}

static void
____lambda105__geary_nonblocking_mutex_critical_section (gpointer self,
                                                         GError** error)
{
	___lambda105_ (self, error);
}

static void
geary_imap_client_service_remove_session_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	GearyImapClientServiceRemoveSessionAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_client_service_remove_session_async_co (_data_);
}

static gboolean
geary_imap_client_service_remove_session_async_co (GearyImapClientServiceRemoveSessionAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data27_ = g_slice_new0 (Block27Data);
	_data_->_data27_->_ref_count_ = 1;
	_data_->_data27_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data27_->session);
	_data_->_data27_->session = _data_->session;
	_data_->_data27_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->free_queue;
	geary_nonblocking_queue_revoke (_data_->_tmp0_, _data_->_data27_->session);
	_data_->_data27_->removed = FALSE;
	{
		_data_->_tmp1_ = _data_->self->priv->sessions_mutex;
		_data_->_state_ = 1;
		geary_nonblocking_mutex_execute_locked (_data_->_tmp1_, ____lambda105__geary_nonblocking_mutex_critical_section, _data_->_data27_, NULL, geary_imap_client_service_remove_session_async_ready, _data_);
		return FALSE;
		_state_1:
		geary_nonblocking_mutex_execute_locked_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->err;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error removing session: %s", _data_->_tmp3_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block27_data_unref (_data_->_data27_);
		_data_->_data27_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_data27_->removed) {
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_data_->_data27_->session, G_TYPE_OBJECT, GObject), "notify::disconnected", (GCallback) _geary_imap_client_service_on_session_disconnected_g_object_notify, _data_->self, 0);
	}
	_data_->result = _data_->_data27_->removed;
	block27_data_unref (_data_->_data27_);
	_data_->_data27_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
___lambda106_ (GearyImapClientService* self,
               GObject* obj,
               GAsyncResult* res)
{
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	geary_imap_client_service_remove_session_finish (self, res);
}

static void
____lambda106__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda106_ ((GearyImapClientService*) self, source_object, res);
	g_object_unref (self);
}

static void
geary_imap_client_service_on_session_disconnected (GearyImapClientService* self,
                                                   GObject* source,
                                                   GParamSpec* param)
{
	GearyImapClientSession* session = NULL;
	GearyImapClientSession* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GearyImapClientSession* _tmp3_;
	g_return_if_fail (GEARY_IMAP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (source, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (param, G_TYPE_PARAM));
	_tmp0_ = _g_object_ref0 (GEARY_IMAP_IS_CLIENT_SESSION (source) ? ((GearyImapClientSession*) source) : NULL);
	session = _tmp0_;
	_tmp3_ = session;
	if (_tmp3_ != NULL) {
		GearyImapClientSession* _tmp4_;
		GearyImapClientSessionProtocolState _tmp5_;
		GearyImapClientSessionProtocolState _tmp6_;
		_tmp4_ = session;
		_tmp5_ = geary_imap_client_session_get_protocol_state (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == GEARY_IMAP_CLIENT_SESSION_PROTOCOL_STATE_NOT_CONNECTED;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GearyImapClientSession* _tmp7_;
		GearyImapClientSessionDisconnectReason _tmp8_;
		GearyImapClientSessionDisconnectReason _tmp9_;
		_tmp7_ = session;
		_tmp8_ = geary_imap_client_session_get_disconnected (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp1_ = _tmp9_ != GEARY_IMAP_CLIENT_SESSION_DISCONNECT_REASON_NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GearyImapClientSession* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GearyImapClientSession* _tmp13_;
		GearyImapClientSessionDisconnectReason _tmp14_;
		GearyImapClientSessionDisconnectReason _tmp15_;
		gchar* _tmp16_;
		GearyImapClientSession* _tmp17_;
		GearyImapClientSession* _tmp18_;
		GearyImapClientSessionDisconnectReason _tmp19_;
		GearyImapClientSessionDisconnectReason _tmp20_;
		_tmp10_ = session;
		_tmp11_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_tmp12_ = _tmp11_;
		_tmp13_ = session;
		_tmp14_ = geary_imap_client_session_get_disconnected (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_enum_to_string (GEARY_IMAP_CLIENT_SESSION_TYPE_DISCONNECT_REASON, _tmp15_);
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Session disconnected: %s: %s", _tmp12_, _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp12_);
		_tmp17_ = session;
		geary_imap_client_service_remove_session_async (self, _tmp17_, ____lambda106__gasync_ready_callback, g_object_ref (self));
		_tmp18_ = session;
		_tmp19_ = geary_imap_client_session_get_disconnected (_tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_ == GEARY_IMAP_CLIENT_SESSION_DISCONNECT_REASON_REMOTE_ERROR) {
			GearyErrorContext* context = NULL;
			GError* _tmp21_;
			GError* _tmp22_;
			GearyErrorContext* _tmp23_;
			GearyErrorContext* _tmp24_;
			GearyErrorContext* _tmp25_;
			_tmp21_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_CONNECTED, "Session disconnected, remote error");
			_tmp22_ = _tmp21_;
			_tmp23_ = geary_error_context_new (_tmp22_);
			_tmp24_ = _tmp23_;
			_g_error_free0 (_tmp22_);
			context = _tmp24_;
			_tmp25_ = context;
			geary_client_service_notify_connection_failed (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService), _tmp25_);
			_g_object_unref0 (context);
		}
	}
	_g_object_unref0 (session);
}

static void
geary_imap_client_service_class_init (GearyImapClientServiceClass * klass,
                                      gpointer klass_data)
{
	geary_imap_client_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapClientService_private_offset);
	((GearyClientServiceClass *) klass)->start = (void (*) (GearyClientService*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_client_service_real_start;
	((GearyClientServiceClass *) klass)->start_finish = (void (*) (GearyClientService*, GAsyncResult*, GError**)) geary_imap_client_service_start_finish;
	((GearyClientServiceClass *) klass)->stop = (void (*) (GearyClientService*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_client_service_real_stop;
	((GearyClientServiceClass *) klass)->stop_finish = (void (*) (GearyClientService*, GAsyncResult*, GError**)) geary_imap_client_service_stop_finish;
	((GearyClientServiceClass *) klass)->became_reachable = (void (*) (GearyClientService*)) geary_imap_client_service_real_became_reachable;
	((GearyClientServiceClass *) klass)->became_unreachable = (void (*) (GearyClientService*)) geary_imap_client_service_real_became_unreachable;
	GEARY_CLIENT_SERVICE_CLASS (klass)->get_logging_domain = (const gchar* (*) (GearyClientService*)) geary_imap_client_service_real_get_logging_domain;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_client_service_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_client_service_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_client_service_finalize;
	/**
	     * Set to zero or negative value if keepalives should be disabled when a connection has not
	     * selected a mailbox.  (This is not recommended.)
	     *
	     * This only affects newly created sessions or sessions leaving the selected/examined state
	     * and returning to an authorized state.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_CLIENT_SERVICE_UNSELECTED_KEEPALIVE_SEC_PROPERTY, geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_UNSELECTED_KEEPALIVE_SEC_PROPERTY] = g_param_spec_uint ("unselected-keepalive-sec", "unselected-keepalive-sec", "unselected-keepalive-sec", 0, G_MAXUINT, GEARY_IMAP_CLIENT_SESSION_DEFAULT_UNSELECTED_KEEPALIVE_SEC, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Set to zero or negative value if keepalives should be disabled when a mailbox is selected
	     * or examined.  (This is not recommended.)
	     *
	     * This only affects newly selected/examined sessions.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_CLIENT_SERVICE_SELECTED_KEEPALIVE_SEC_PROPERTY, geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_SELECTED_KEEPALIVE_SEC_PROPERTY] = g_param_spec_uint ("selected-keepalive-sec", "selected-keepalive-sec", "selected-keepalive-sec", 0, G_MAXUINT, GEARY_IMAP_CLIENT_SESSION_DEFAULT_SELECTED_KEEPALIVE_SEC, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Set to zero or negative value if keepalives should be disabled when a mailbox is selected
	     * or examined and IDLE is supported.  (This is not recommended.)
	     *
	     * This only affects newly selected/examined sessions.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_CLIENT_SERVICE_SELECTED_WITH_IDLE_KEEPALIVE_SEC_PROPERTY, geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_SELECTED_WITH_IDLE_KEEPALIVE_SEC_PROPERTY] = g_param_spec_uint ("selected-with-idle-keepalive-sec", "selected-with-idle-keepalive-sec", "selected-with-idle-keepalive-sec", 0, G_MAXUINT, GEARY_IMAP_CLIENT_SESSION_DEFAULT_SELECTED_WITH_IDLE_KEEPALIVE_SEC, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Specifies the minimum number of sessions to keep open.
	     *
	     * The manager will attempt to keep at least this number of
	     * connections open at all times.
	     *
	     * Setting this does not immediately adjust the pool size in
	     * either direction.  Adjustment will happen as connections are
	     * needed or closed.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_CLIENT_SERVICE_MIN_POOL_SIZE_PROPERTY, geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_MIN_POOL_SIZE_PROPERTY] = g_param_spec_int ("min-pool-size", "min-pool-size", "min-pool-size", G_MININT, G_MAXINT, GEARY_IMAP_CLIENT_SERVICE_DEFAULT_MIN_POOL_SIZE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Specifies the maximum number of free sessions to keep open.
	     *
	     * If there are already this number of free sessions available,
	     * the manager will close any additional sessions that are
	     * released, instead of keeping them for re-use. However it will
	     * not close sessions if doing so would reduce the size of the
	     * pool below {@link min_pool_size}.
	     *
	     * Setting this does not immediately adjust the pool size in
	     * either direction.  Adjustment will happen as connections are
	     * needed or closed.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_CLIENT_SERVICE_MAX_FREE_SIZE_PROPERTY, geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_MAX_FREE_SIZE_PROPERTY] = g_param_spec_int ("max-free-size", "max-free-size", "max-free-size", G_MININT, G_MAXINT, GEARY_IMAP_CLIENT_SERVICE_DEFAULT_MAX_FREE_SIZE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_CLIENT_SERVICE_LOGGING_DOMAIN_PROPERTY, geary_imap_client_service_properties[GEARY_IMAP_CLIENT_SERVICE_LOGGING_DOMAIN_PROPERTY] = g_param_spec_string ("logging-domain", "logging-domain", "logging-domain", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_client_service_instance_init (GearyImapClientService * self,
                                         gpointer klass)
{
	GearyImapQuirks* _tmp0_;
	GearyNonblockingMutex* _tmp1_;
	GeeHashSet* _tmp2_;
	GearyNonblockingQueue* _tmp3_;
	self->priv = geary_imap_client_service_get_instance_private (self);
	self->priv->_unselected_keepalive_sec = GEARY_IMAP_CLIENT_SESSION_DEFAULT_UNSELECTED_KEEPALIVE_SEC;
	self->priv->_selected_keepalive_sec = GEARY_IMAP_CLIENT_SESSION_DEFAULT_SELECTED_KEEPALIVE_SEC;
	self->priv->_selected_with_idle_keepalive_sec = GEARY_IMAP_CLIENT_SESSION_DEFAULT_SELECTED_WITH_IDLE_KEEPALIVE_SEC;
	self->priv->_min_pool_size = GEARY_IMAP_CLIENT_SERVICE_DEFAULT_MIN_POOL_SIZE;
	self->priv->_max_free_size = GEARY_IMAP_CLIENT_SERVICE_DEFAULT_MAX_FREE_SIZE;
	self->discard_returned_sessions = FALSE;
	_tmp0_ = geary_imap_quirks_new ();
	self->priv->quirks = _tmp0_;
	_tmp1_ = geary_nonblocking_mutex_new ();
	self->priv->sessions_mutex = _tmp1_;
	_tmp2_ = gee_hash_set_new (GEARY_IMAP_TYPE_CLIENT_SESSION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->all_sessions = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_SET, GeeSet);
	_tmp3_ = geary_nonblocking_queue_new_fifo (GEARY_IMAP_TYPE_CLIENT_SESSION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->free_queue = _tmp3_;
	self->priv->pool_cancellable = NULL;
	self->priv->close_cancellable = NULL;
}

static void
geary_imap_client_service_finalize (GObject * obj)
{
	GearyImapClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_CLIENT_SERVICE, GearyImapClientService);
	_g_object_unref0 (self->priv->quirks);
	_g_object_unref0 (self->priv->sessions_mutex);
	_g_object_unref0 (self->priv->all_sessions);
	_g_object_unref0 (self->priv->free_queue);
	_g_object_unref0 (self->priv->pool_cancellable);
	_g_object_unref0 (self->priv->close_cancellable);
	G_OBJECT_CLASS (geary_imap_client_service_parent_class)->finalize (obj);
}

/**
 * Manages a pool of IMAP client sessions.
 *
 * When started and when the remote host is reachable, the manager
 * will establish a pool of {@link ClientSession} instances that are
 * connected to the service's endpoint, ensuring there are at least
 * {@link min_pool_size} available. A connected, authorised client
 * session can be obtained from the connection pool by calling {@link
 * claim_authorized_session_async}, and when finished with returned by
 * calling {@link release_session_async}.
 *
 * This class is not thread-safe.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_client_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapClientServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_client_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapClientService), 0, (GInstanceInitFunc) geary_imap_client_service_instance_init, NULL };
	GType geary_imap_client_service_type_id;
	geary_imap_client_service_type_id = g_type_register_static (GEARY_TYPE_CLIENT_SERVICE, "GearyImapClientService", &g_define_type_info, 0);
	GearyImapClientService_private_offset = g_type_add_instance_private (geary_imap_client_service_type_id, sizeof (GearyImapClientServicePrivate));
	return geary_imap_client_service_type_id;
}

GType
geary_imap_client_service_get_type (void)
{
	static gsize geary_imap_client_service_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_client_service_type_id__once)) {
		GType geary_imap_client_service_type_id;
		geary_imap_client_service_type_id = geary_imap_client_service_get_type_once ();
		g_once_init_leave (&geary_imap_client_service_type_id__once, geary_imap_client_service_type_id);
	}
	return geary_imap_client_service_type_id__once;
}

static void
_vala_geary_imap_client_service_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GearyImapClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_CLIENT_SERVICE, GearyImapClientService);
	switch (property_id) {
		case GEARY_IMAP_CLIENT_SERVICE_UNSELECTED_KEEPALIVE_SEC_PROPERTY:
		g_value_set_uint (value, geary_imap_client_service_get_unselected_keepalive_sec (self));
		break;
		case GEARY_IMAP_CLIENT_SERVICE_SELECTED_KEEPALIVE_SEC_PROPERTY:
		g_value_set_uint (value, geary_imap_client_service_get_selected_keepalive_sec (self));
		break;
		case GEARY_IMAP_CLIENT_SERVICE_SELECTED_WITH_IDLE_KEEPALIVE_SEC_PROPERTY:
		g_value_set_uint (value, geary_imap_client_service_get_selected_with_idle_keepalive_sec (self));
		break;
		case GEARY_IMAP_CLIENT_SERVICE_MIN_POOL_SIZE_PROPERTY:
		g_value_set_int (value, geary_imap_client_service_get_min_pool_size (self));
		break;
		case GEARY_IMAP_CLIENT_SERVICE_MAX_FREE_SIZE_PROPERTY:
		g_value_set_int (value, geary_imap_client_service_get_max_free_size (self));
		break;
		case GEARY_IMAP_CLIENT_SERVICE_LOGGING_DOMAIN_PROPERTY:
		g_value_set_string (value, geary_client_service_get_logging_domain (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_client_service_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	GearyImapClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_CLIENT_SERVICE, GearyImapClientService);
	switch (property_id) {
		case GEARY_IMAP_CLIENT_SERVICE_UNSELECTED_KEEPALIVE_SEC_PROPERTY:
		geary_imap_client_service_set_unselected_keepalive_sec (self, g_value_get_uint (value));
		break;
		case GEARY_IMAP_CLIENT_SERVICE_SELECTED_KEEPALIVE_SEC_PROPERTY:
		geary_imap_client_service_set_selected_keepalive_sec (self, g_value_get_uint (value));
		break;
		case GEARY_IMAP_CLIENT_SERVICE_SELECTED_WITH_IDLE_KEEPALIVE_SEC_PROPERTY:
		geary_imap_client_service_set_selected_with_idle_keepalive_sec (self, g_value_get_uint (value));
		break;
		case GEARY_IMAP_CLIENT_SERVICE_MIN_POOL_SIZE_PROPERTY:
		geary_imap_client_service_set_min_pool_size (self, g_value_get_int (value));
		break;
		case GEARY_IMAP_CLIENT_SERVICE_MAX_FREE_SIZE_PROPERTY:
		geary_imap_client_service_set_max_free_size (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

