/* rfc822-mailbox-addresses.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rfc822-mailbox-addresses.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gmime/gmime.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_RF_C822_MAILBOX_ADDRESSES_0_PROPERTY,
	GEARY_RF_C822_MAILBOX_ADDRESSES_SIZE_PROPERTY,
	GEARY_RF_C822_MAILBOX_ADDRESSES_IS_EMPTY_PROPERTY,
	GEARY_RF_C822_MAILBOX_ADDRESSES_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_mailbox_addresses_properties[GEARY_RF_C822_MAILBOX_ADDRESSES_NUM_PROPERTIES];
typedef gchar* (*GearyRFC822MailboxAddressesListToStringDelegate) (GearyRFC822MailboxAddress* address, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __vala_GMimeParserOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMimeParserOptions_free (var), NULL)))

struct _GearyRFC822MailboxAddressesPrivate {
	GeeList* addrs;
	gboolean hash_cached;
	guint hash_value;
};

static gint GearyRFC822MailboxAddresses_private_offset;
static gpointer geary_rf_c822_mailbox_addresses_parent_class = NULL;
static GearyMessageDataSearchableMessageDataIface * geary_rf_c822_mailbox_addresses_geary_message_data_searchable_message_data_parent_iface = NULL;
static GeeHashableIface * geary_rf_c822_mailbox_addresses_gee_hashable_parent_iface = NULL;
static GearyRFC822DecodedMessageDataIface * geary_rf_c822_mailbox_addresses_geary_rf_c822_decoded_message_data_parent_iface = NULL;

static gchar* geary_rf_c822_mailbox_addresses_list_to_string (GeeList* addrs,
                                                       GearyRFC822MailboxAddressesListToStringDelegate to_s,
                                                       gpointer to_s_target);
static void _vala_GMimeParserOptions_free (GMimeParserOptions* self);
static gchar* __lambda5_ (GearyRFC822MailboxAddresses* self,
                   GearyRFC822MailboxAddress* a);
static gchar* ___lambda5__geary_rf_c822_mailbox_addresses_list_to_string_delegate (GearyRFC822MailboxAddress* address,
                                                                            gpointer self);
static gchar* geary_rf_c822_mailbox_addresses_real_to_rfc822_string (GearyRFC822DecodedMessageData* base);
static gchar* __lambda6_ (GearyRFC822MailboxAddresses* self,
                   GearyRFC822MailboxAddress* a);
static gchar* ___lambda6__geary_rf_c822_mailbox_addresses_list_to_string_delegate (GearyRFC822MailboxAddress* address,
                                                                            gpointer self);
static guint geary_rf_c822_mailbox_addresses_real_hash (GeeHashable* base);
static gchar* ___lambda10_ (GearyRFC822MailboxAddresses* self,
                     GearyRFC822MailboxAddress* m);
static gpointer ____lambda10__gee_map_func (gpointer g,
                                     gpointer self);
static gint _geary_string_stri_cmp_gcompare_data_func (gconstpointer a,
                                                gconstpointer b,
                                                gpointer self);
static gboolean geary_rf_c822_mailbox_addresses_real_equal_to (GeeHashable* base,
                                                        GearyRFC822MailboxAddresses* other);
static gchar* geary_rf_c822_mailbox_addresses_real_to_searchable_string (GearyMessageDataSearchableMessageData* base);
static gchar* __lambda11_ (GearyRFC822MailboxAddresses* self,
                    GearyRFC822MailboxAddress* a);
static gchar* ___lambda11__geary_rf_c822_mailbox_addresses_list_to_string_delegate (GearyRFC822MailboxAddress* address,
                                                                             gpointer self);
static gchar* geary_rf_c822_mailbox_addresses_real_to_string (GearyMessageDataAbstractMessageData* base);
static gchar* ___lambda12_ (GearyRFC822MailboxAddresses* self,
                     GearyRFC822MailboxAddress* a);
static gchar* ____lambda12__geary_rf_c822_mailbox_addresses_list_to_string_delegate (GearyRFC822MailboxAddress* address,
                                                                              gpointer self);
static void geary_rf_c822_mailbox_addresses_finalize (GObject * obj);
static GType geary_rf_c822_mailbox_addresses_get_type_once (void);
static void _vala_geary_rf_c822_mailbox_addresses_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);

static inline gpointer
geary_rf_c822_mailbox_addresses_get_instance_private (GearyRFC822MailboxAddresses* self)
{
	return G_STRUCT_MEMBER_P (self, GearyRFC822MailboxAddresses_private_offset);
}

/**
     * Converts a list of mailbox addresses to a string.
     *
     * The delegate //to_s// is used for converting addresses in the
     * given list. If the list is empty, the given empty string is
     * returned.
     */
static gchar*
geary_rf_c822_mailbox_addresses_list_to_string (GeeList* addrs,
                                                GearyRFC822MailboxAddressesListToStringDelegate to_s,
                                                gpointer to_s_target)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (addrs, GEE_TYPE_LIST), NULL);
	_tmp0_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (addrs, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case 0:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("");
			result = _tmp2_;
			return result;
		}
		case 1:
		{
			gpointer _tmp3_;
			GearyRFC822MailboxAddress* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp3_ = gee_list_get (addrs, 0);
			_tmp4_ = (GearyRFC822MailboxAddress*) _tmp3_;
			_tmp5_ = to_s (_tmp4_, to_s_target);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp4_);
			result = _tmp6_;
			return result;
		}
		default:
		{
			GString* builder = NULL;
			GString* _tmp7_;
			GString* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp7_ = g_string_new ("");
			builder = _tmp7_;
			{
				GeeList* _addr_list = NULL;
				gint _addr_size = 0;
				GeeList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint _addr_index = 0;
				_addr_list = addrs;
				_tmp8_ = _addr_list;
				_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp10_ = _tmp9_;
				_addr_size = _tmp10_;
				_addr_index = -1;
				while (TRUE) {
					gint _tmp11_;
					gint _tmp12_;
					GearyRFC822MailboxAddress* addr = NULL;
					GeeList* _tmp13_;
					gpointer _tmp14_;
					GString* _tmp15_;
					const gchar* _tmp16_;
					GString* _tmp18_;
					GearyRFC822MailboxAddress* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_addr_index = _addr_index + 1;
					_tmp11_ = _addr_index;
					_tmp12_ = _addr_size;
					if (!(_tmp11_ < _tmp12_)) {
						break;
					}
					_tmp13_ = _addr_list;
					_tmp14_ = gee_list_get (_tmp13_, _addr_index);
					addr = (GearyRFC822MailboxAddress*) _tmp14_;
					_tmp15_ = builder;
					_tmp16_ = _tmp15_->str;
					if (!geary_string_is_empty (_tmp16_)) {
						GString* _tmp17_;
						_tmp17_ = builder;
						g_string_append (_tmp17_, ", ");
					}
					_tmp18_ = builder;
					_tmp19_ = addr;
					_tmp20_ = to_s (_tmp19_, to_s_target);
					_tmp21_ = _tmp20_;
					g_string_append (_tmp18_, _tmp21_);
					_g_free0 (_tmp21_);
					_g_object_unref0 (addr);
				}
			}
			_tmp22_ = builder;
			_tmp23_ = _tmp22_->str;
			_tmp24_ = g_strdup (_tmp23_);
			result = _tmp24_;
			_g_string_free0 (builder);
			return result;
		}
	}
}

gint
geary_rf_c822_mailbox_addresses_get_size (GearyRFC822MailboxAddresses* self)
{
	gint result;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), 0);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
geary_rf_c822_mailbox_addresses_get_is_empty (GearyRFC822MailboxAddresses* self)
{
	gboolean result;
	GeeList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), FALSE);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
     * Constructs a new mailbox list.
     *
     * If the optional collection of addresses is not given, the list
     * is created empty. Otherwise the collection's addresses are
     * added to the list by iterating over it in natural order.
     */
GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_construct (GType object_type,
                                           GeeCollection* addrs)
{
	GearyRFC822MailboxAddresses * self = NULL;
	g_return_val_if_fail ((addrs == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (addrs, GEE_TYPE_COLLECTION), NULL);
	self = (GearyRFC822MailboxAddresses*) geary_message_data_abstract_message_data_construct (object_type);
	if (addrs != NULL) {
		GeeList* _tmp0_;
		_tmp0_ = self->priv->addrs;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), addrs);
	}
	return self;
}

GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_new (GeeCollection* addrs)
{
	return geary_rf_c822_mailbox_addresses_construct (GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, addrs);
}

/** Constructs a new mailbox list with a single address. */
GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_construct_single (GType object_type,
                                                  GearyRFC822MailboxAddress* addr)
{
	GearyRFC822MailboxAddresses * self = NULL;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (addr), NULL);
	self = (GearyRFC822MailboxAddresses*) geary_message_data_abstract_message_data_construct (object_type);
	_tmp0_ = self->priv->addrs;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), addr);
	return self;
}

GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_new_single (GearyRFC822MailboxAddress* addr)
{
	return geary_rf_c822_mailbox_addresses_construct_single (GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, addr);
}

/** Constructs a new mailbox list by parsing a RFC822 string. */
static void
_vala_GMimeParserOptions_free (GMimeParserOptions* self)
{
	g_boxed_free (g_mime_parser_options_get_type (), self);
}

GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_construct_from_rfc822_string (GType object_type,
                                                              const gchar* rfc822,
                                                              GError** error)
{
	GearyRFC822MailboxAddresses * self = NULL;
	InternetAddressList* list = NULL;
	GMimeParserOptions* _tmp0_;
	GMimeParserOptions* _tmp1_;
	InternetAddressList* _tmp2_;
	InternetAddressList* _tmp3_;
	InternetAddressList* _tmp4_;
	InternetAddressList* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (rfc822 != NULL, NULL);
	_tmp0_ = geary_rf_c822_get_parser_options ();
	_tmp1_ = _tmp0_;
	_tmp2_ = internet_address_list_parse (_tmp1_, rfc822);
	_tmp3_ = _tmp2_;
	__vala_GMimeParserOptions_free0 (_tmp1_);
	list = _tmp3_;
	_tmp4_ = list;
	if (_tmp4_ == NULL) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Not a RFC822 mailbox address list");
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (list);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = list;
	self = (GearyRFC822MailboxAddresses*) geary_rf_c822_mailbox_addresses_construct_from_gmime (object_type, _tmp6_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (list);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_object_unref0 (list);
	return self;
}

GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_new_from_rfc822_string (const gchar* rfc822,
                                                        GError** error)
{
	return geary_rf_c822_mailbox_addresses_construct_from_rfc822_string (GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, rfc822, error);
}

/** Constructs a new mailbox from a GMime list. */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_construct_from_gmime (GType object_type,
                                                      InternetAddressList* list,
                                                      GError** error)
{
	GearyRFC822MailboxAddresses * self = NULL;
	gint length = 0;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (list, internet_address_list_get_type ()), NULL);
	self = (GearyRFC822MailboxAddresses*) geary_message_data_abstract_message_data_construct (object_type);
	length = internet_address_list_length (list);
	if (length == 0) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "No addresses in list");
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				InternetAddress* addr = NULL;
				InternetAddress* _tmp3_;
				InternetAddress* _tmp4_;
				InternetAddressMailbox* mbox_addr = NULL;
				InternetAddress* _tmp5_;
				InternetAddressMailbox* _tmp6_;
				InternetAddressMailbox* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = internet_address_list_get_address (list, i);
				_tmp4_ = _g_object_ref0 (_tmp3_);
				addr = _tmp4_;
				_tmp5_ = addr;
				_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, internet_address_mailbox_get_type ()) ? ((InternetAddressMailbox*) _tmp5_) : NULL);
				mbox_addr = _tmp6_;
				_tmp7_ = mbox_addr;
				if (_tmp7_ != NULL) {
					GeeList* _tmp8_;
					InternetAddressMailbox* _tmp9_;
					GearyRFC822MailboxAddress* _tmp10_;
					GearyRFC822MailboxAddress* _tmp11_;
					_tmp8_ = self->priv->addrs;
					_tmp9_ = mbox_addr;
					_tmp10_ = geary_rf_c822_mailbox_address_new_from_gmime (_tmp9_);
					_tmp11_ = _tmp10_;
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection), _tmp11_);
					_g_object_unref0 (_tmp11_);
				} else {
					InternetAddressGroup* mbox_group = NULL;
					InternetAddress* _tmp12_;
					InternetAddressGroup* _tmp13_;
					InternetAddressGroup* _tmp14_;
					_tmp12_ = addr;
					_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, internet_address_group_get_type ()) ? ((InternetAddressGroup*) _tmp12_) : NULL);
					mbox_group = _tmp13_;
					_tmp14_ = mbox_group;
					if (_tmp14_ != NULL) {
						InternetAddressList* group_list = NULL;
						InternetAddressGroup* _tmp15_;
						InternetAddressList* _tmp16_;
						InternetAddressList* _tmp17_;
						_tmp15_ = mbox_group;
						_tmp16_ = internet_address_group_get_members (_tmp15_);
						_tmp17_ = _g_object_ref0 (_tmp16_);
						group_list = _tmp17_;
						{
							gint j = 0;
							j = 0;
							{
								gboolean _tmp18_ = FALSE;
								_tmp18_ = TRUE;
								while (TRUE) {
									InternetAddressList* _tmp20_;
									InternetAddressMailbox* group_addr = NULL;
									InternetAddressList* _tmp21_;
									InternetAddress* _tmp22_;
									InternetAddressMailbox* _tmp23_;
									InternetAddressMailbox* _tmp24_;
									if (!_tmp18_) {
										gint _tmp19_;
										_tmp19_ = j;
										j = _tmp19_ + 1;
									}
									_tmp18_ = FALSE;
									_tmp20_ = group_list;
									if (!(j < internet_address_list_length (_tmp20_))) {
										break;
									}
									_tmp21_ = group_list;
									_tmp22_ = internet_address_list_get_address (_tmp21_, j);
									_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, internet_address_mailbox_get_type ()) ? ((InternetAddressMailbox*) _tmp22_) : NULL);
									group_addr = _tmp23_;
									_tmp24_ = group_addr;
									if (_tmp24_ != NULL) {
										GeeList* _tmp25_;
										InternetAddressMailbox* _tmp26_;
										GearyRFC822MailboxAddress* _tmp27_;
										GearyRFC822MailboxAddress* _tmp28_;
										_tmp25_ = self->priv->addrs;
										_tmp26_ = group_addr;
										_tmp27_ = geary_rf_c822_mailbox_address_new_from_gmime (_tmp26_);
										_tmp28_ = _tmp27_;
										gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection), _tmp28_);
										_g_object_unref0 (_tmp28_);
									}
									_g_object_unref0 (group_addr);
								}
							}
						}
						_g_object_unref0 (group_list);
					}
					_g_object_unref0 (mbox_group);
				}
				_g_object_unref0 (mbox_addr);
				_g_object_unref0 (addr);
			}
		}
	}
	return self;
}

GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_new_from_gmime (InternetAddressList* list,
                                                GError** error)
{
	return geary_rf_c822_mailbox_addresses_construct_from_gmime (GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, list, error);
}

/** Returns the address at the given index, if it exists. */
GearyRFC822MailboxAddress*
geary_rf_c822_mailbox_addresses_get (GearyRFC822MailboxAddresses* self,
                                     gint index)
{
	GeeList* _tmp0_;
	gpointer _tmp1_;
	GearyRFC822MailboxAddress* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), NULL);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = gee_list_get (_tmp0_, index);
	result = (GearyRFC822MailboxAddress*) _tmp1_;
	return result;
}

/** Returns a read-only iterator of the addresses in this list. */
GeeIterator*
geary_rf_c822_mailbox_addresses_iterator (GearyRFC822MailboxAddresses* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), NULL);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

/** Returns a read-only collection of the addresses in this list. */
GeeList*
geary_rf_c822_mailbox_addresses_get_all (GearyRFC822MailboxAddresses* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), NULL);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
geary_rf_c822_mailbox_addresses_contains_normalized (GearyRFC822MailboxAddresses* self,
                                                     const gchar* address)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* normalized_address = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), FALSE);
	g_return_val_if_fail (address != NULL, FALSE);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 1) {
		result = FALSE;
		return result;
	}
	_tmp3_ = g_utf8_normalize (address, (gssize) -1, G_NORMALIZE_DEFAULT);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_casefold (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	normalized_address = _tmp6_;
	{
		GeeList* _mailbox_address_list = NULL;
		GeeList* _tmp7_;
		gint _mailbox_address_size = 0;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _mailbox_address_index = 0;
		_tmp7_ = self->priv->addrs;
		_mailbox_address_list = _tmp7_;
		_tmp8_ = _mailbox_address_list;
		_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp10_ = _tmp9_;
		_mailbox_address_size = _tmp10_;
		_mailbox_address_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			GearyRFC822MailboxAddress* mailbox_address = NULL;
			GeeList* _tmp13_;
			gpointer _tmp14_;
			GearyRFC822MailboxAddress* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			const gchar* _tmp22_;
			gboolean _tmp23_;
			_mailbox_address_index = _mailbox_address_index + 1;
			_tmp11_ = _mailbox_address_index;
			_tmp12_ = _mailbox_address_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _mailbox_address_list;
			_tmp14_ = gee_list_get (_tmp13_, _mailbox_address_index);
			mailbox_address = (GearyRFC822MailboxAddress*) _tmp14_;
			_tmp15_ = mailbox_address;
			_tmp16_ = geary_rf_c822_mailbox_address_get_address (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_utf8_normalize (_tmp17_, (gssize) -1, G_NORMALIZE_DEFAULT);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_utf8_casefold (_tmp19_, (gssize) -1);
			_tmp21_ = _tmp20_;
			_tmp22_ = normalized_address;
			_tmp23_ = g_strcmp0 (_tmp21_, _tmp22_) == 0;
			_g_free0 (_tmp21_);
			_g_free0 (_tmp19_);
			if (_tmp23_) {
				result = TRUE;
				_g_object_unref0 (mailbox_address);
				_g_free0 (normalized_address);
				return result;
			}
			_g_object_unref0 (mailbox_address);
		}
	}
	result = FALSE;
	_g_free0 (normalized_address);
	return result;
}

gboolean
geary_rf_c822_mailbox_addresses_contains (GearyRFC822MailboxAddresses* self,
                                          const gchar* address)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), FALSE);
	g_return_val_if_fail (address != NULL, FALSE);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 1) {
		result = FALSE;
		return result;
	}
	{
		GeeList* _a_list = NULL;
		GeeList* _tmp3_;
		gint _a_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _a_index = 0;
		_tmp3_ = self->priv->addrs;
		_a_list = _tmp3_;
		_tmp4_ = _a_list;
		_tmp5_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp6_ = _tmp5_;
		_a_size = _tmp6_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			GearyRFC822MailboxAddress* a = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			GearyRFC822MailboxAddress* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_a_index = _a_index + 1;
			_tmp7_ = _a_index;
			_tmp8_ = _a_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _a_list;
			_tmp10_ = gee_list_get (_tmp9_, _a_index);
			a = (GearyRFC822MailboxAddress*) _tmp10_;
			_tmp11_ = a;
			_tmp12_ = geary_rf_c822_mailbox_address_get_address (_tmp11_);
			_tmp13_ = _tmp12_;
			if (g_strcmp0 (_tmp13_, address) == 0) {
				result = TRUE;
				_g_object_unref0 (a);
				return result;
			}
			_g_object_unref0 (a);
		}
	}
	result = FALSE;
	return result;
}

/**
     * Returns a list with the given mailbox appended if not already present.
     *
     * This list is returned if the given mailbox is already present,
     * otherwise the result of a call to {@link concatenate_mailbox} is
     * returned.
     */
GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_merge_mailbox (GearyRFC822MailboxAddresses* self,
                                               GearyRFC822MailboxAddress* other)
{
	GearyRFC822MailboxAddresses* _tmp0_ = NULL;
	GeeList* _tmp1_;
	GearyRFC822MailboxAddresses* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (other), NULL);
	_tmp1_ = self->priv->addrs;
	if (gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), other)) {
		GearyRFC822MailboxAddresses* _tmp2_;
		_tmp2_ = _g_object_ref0 (self);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		GearyRFC822MailboxAddresses* _tmp3_;
		_tmp3_ = geary_rf_c822_mailbox_addresses_concatenate_mailbox (self, other);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns a list with the given mailboxes appended if not already present.
     *
     * This list is returned if all given mailboxes are already
     * present, otherwise the result of a call to {@link
     * concatenate_mailbox} for each not present is returned.
     */
GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_merge_list (GearyRFC822MailboxAddresses* self,
                                            GearyRFC822MailboxAddresses* other)
{
	GearyRFC822MailboxAddresses* list = NULL;
	GearyRFC822MailboxAddresses* _tmp0_;
	GearyRFC822MailboxAddresses* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (other), NULL);
	_tmp0_ = _g_object_ref0 (self);
	list = _tmp0_;
	{
		GearyRFC822MailboxAddresses* _addr_list = NULL;
		gint _addr_size = 0;
		GearyRFC822MailboxAddresses* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _addr_index = 0;
		_addr_list = other;
		_tmp1_ = _addr_list;
		_tmp2_ = geary_rf_c822_mailbox_addresses_get_size (_tmp1_);
		_tmp3_ = _tmp2_;
		_addr_size = _tmp3_;
		_addr_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GearyRFC822MailboxAddress* addr = NULL;
			GearyRFC822MailboxAddresses* _tmp6_;
			GearyRFC822MailboxAddress* _tmp7_;
			GeeList* _tmp8_;
			GearyRFC822MailboxAddress* _tmp9_;
			_addr_index = _addr_index + 1;
			_tmp4_ = _addr_index;
			_tmp5_ = _addr_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _addr_list;
			_tmp7_ = geary_rf_c822_mailbox_addresses_get (_tmp6_, _addr_index);
			addr = _tmp7_;
			_tmp8_ = self->priv->addrs;
			_tmp9_ = addr;
			if (!gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection), _tmp9_)) {
				GearyRFC822MailboxAddresses* _tmp10_;
				GearyRFC822MailboxAddress* _tmp11_;
				GearyRFC822MailboxAddresses* _tmp12_;
				_tmp10_ = list;
				_tmp11_ = addr;
				_tmp12_ = geary_rf_c822_mailbox_addresses_concatenate_mailbox (_tmp10_, _tmp11_);
				_g_object_unref0 (list);
				list = _tmp12_;
			}
			_g_object_unref0 (addr);
		}
	}
	result = list;
	return result;
}

/**
     * Returns a new list with the given address appended to this list's.
     */
GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_concatenate_mailbox (GearyRFC822MailboxAddresses* self,
                                                     GearyRFC822MailboxAddress* other)
{
	GearyRFC822MailboxAddresses* new_addrs = NULL;
	GeeList* _tmp0_;
	GearyRFC822MailboxAddresses* _tmp1_;
	GeeList* _tmp2_;
	GearyRFC822MailboxAddresses* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (other), NULL);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = geary_rf_c822_mailbox_addresses_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	new_addrs = _tmp1_;
	_tmp2_ = new_addrs->priv->addrs;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), other);
	result = new_addrs;
	return result;
}

/**
     * Returns a new list with the given addresses appended to this list's.
     */
GearyRFC822MailboxAddresses*
geary_rf_c822_mailbox_addresses_concatenate_list (GearyRFC822MailboxAddresses* self,
                                                  GearyRFC822MailboxAddresses* others)
{
	GearyRFC822MailboxAddresses* new_addrs = NULL;
	GeeList* _tmp0_;
	GearyRFC822MailboxAddresses* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GearyRFC822MailboxAddresses* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (others), NULL);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = geary_rf_c822_mailbox_addresses_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	new_addrs = _tmp1_;
	_tmp2_ = new_addrs->priv->addrs;
	_tmp3_ = others->priv->addrs;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
	result = new_addrs;
	return result;
}

/**
     * Returns the addresses suitable for display to a human.
     *
     * @return a string containing each message in the list,
     * serialised by a call to {@link MailboxAddress.to_full_display}
     * for each, separated by commas.
     */
static gchar*
__lambda5_ (GearyRFC822MailboxAddresses* self,
            GearyRFC822MailboxAddress* a)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (a), NULL);
	_tmp0_ = geary_rf_c822_mailbox_address_to_full_display (a, "<", ">");
	result = _tmp0_;
	return result;
}

static gchar*
___lambda5__geary_rf_c822_mailbox_addresses_list_to_string_delegate (GearyRFC822MailboxAddress* address,
                                                                     gpointer self)
{
	gchar* result;
	result = __lambda5_ ((GearyRFC822MailboxAddresses*) self, address);
	return result;
}

gchar*
geary_rf_c822_mailbox_addresses_to_full_display (GearyRFC822MailboxAddresses* self)
{
	GeeList* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), NULL);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = geary_rf_c822_mailbox_addresses_list_to_string (_tmp0_, ___lambda5__geary_rf_c822_mailbox_addresses_list_to_string_delegate, self);
	result = _tmp1_;
	return result;
}

/**
     * Returns the addresses suitable for insertion into an RFC822 message.
     *
     * RFC822 quoting is performed if required.
     *
     * @see MailboxAddress.to_rfc822_string
     */
static gchar*
__lambda6_ (GearyRFC822MailboxAddresses* self,
            GearyRFC822MailboxAddress* a)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (a), NULL);
	_tmp0_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (a, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
	result = _tmp0_;
	return result;
}

static gchar*
___lambda6__geary_rf_c822_mailbox_addresses_list_to_string_delegate (GearyRFC822MailboxAddress* address,
                                                                     gpointer self)
{
	gchar* result;
	result = __lambda6_ ((GearyRFC822MailboxAddresses*) self, address);
	return result;
}

static gchar*
geary_rf_c822_mailbox_addresses_real_to_rfc822_string (GearyRFC822DecodedMessageData* base)
{
	GearyRFC822MailboxAddresses * self;
	GeeList* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, GearyRFC822MailboxAddresses);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = geary_rf_c822_mailbox_addresses_list_to_string (_tmp0_, ___lambda6__geary_rf_c822_mailbox_addresses_list_to_string_delegate, self);
	result = _tmp1_;
	return result;
}

static gchar*
___lambda10_ (GearyRFC822MailboxAddresses* self,
              GearyRFC822MailboxAddress* m)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (m), NULL);
	_tmp0_ = geary_rf_c822_mailbox_address_get_address (m);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	_g_object_unref0 (m);
	return result;
}

static gpointer
____lambda10__gee_map_func (gpointer g,
                            gpointer self)
{
	gpointer result;
	result = ___lambda10_ ((GearyRFC822MailboxAddresses*) self, (GearyRFC822MailboxAddress*) g);
	return result;
}

static gint
_geary_string_stri_cmp_gcompare_data_func (gconstpointer a,
                                           gconstpointer b,
                                           gpointer self)
{
	gint result;
	result = geary_string_stri_cmp ((const gchar*) a, (const gchar*) b);
	return result;
}

static guint
geary_rf_c822_mailbox_addresses_real_hash (GeeHashable* base)
{
	GearyRFC822MailboxAddresses * self;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, GearyRFC822MailboxAddresses);
	if (!self->priv->hash_cached) {
		GeeArrayList* sorted_addresses = NULL;
		GeeList* _tmp0_;
		GearyIterable* _tmp1_;
		GearyIterable* _tmp2_;
		GearyIterable* _tmp3_;
		GearyIterable* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		guint xor = 0U;
		_tmp0_ = self->priv->addrs;
		_tmp1_ = geary_traverse (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_iterable_map (_tmp2_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ____lambda10__gee_map_func, self);
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_iterable_to_sorted_list (_tmp4_, _geary_string_stri_cmp_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
		sorted_addresses = _tmp6_;
		xor = (guint) 0;
		{
			GeeArrayList* _address_list = NULL;
			GeeArrayList* _tmp7_;
			gint _address_size = 0;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _address_index = 0;
			_tmp7_ = sorted_addresses;
			_address_list = _tmp7_;
			_tmp8_ = _address_list;
			_tmp9_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp10_ = _tmp9_;
			_address_size = _tmp10_;
			_address_index = -1;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				gchar* address = NULL;
				GeeArrayList* _tmp13_;
				gpointer _tmp14_;
				const gchar* _tmp15_;
				_address_index = _address_index + 1;
				_tmp11_ = _address_index;
				_tmp12_ = _address_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _address_list;
				_tmp14_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _address_index);
				address = (gchar*) _tmp14_;
				_tmp15_ = address;
				xor ^= g_str_hash (_tmp15_);
				_g_free0 (address);
			}
		}
		self->priv->hash_value = xor;
		self->priv->hash_cached = TRUE;
		_g_object_unref0 (sorted_addresses);
	}
	result = self->priv->hash_value;
	return result;
}

/** Determines if this list contains all of the other's, in any order. */
gboolean
geary_rf_c822_mailbox_addresses_contains_all (GearyRFC822MailboxAddresses* self,
                                              GearyRFC822MailboxAddresses* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (self), FALSE);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (other), FALSE);
	if (self == other) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp2_ = self->priv->addrs;
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_tmp5_ = other->priv->addrs;
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp7_ = _tmp6_;
		if (_tmp4_ == _tmp7_) {
			GeeList* _tmp8_;
			GeeList* _tmp9_;
			_tmp8_ = self->priv->addrs;
			_tmp9_ = other->priv->addrs;
			_tmp1_ = gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection));
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}

/** Determines if this list contains all of the other's, in order. */
static gboolean
geary_rf_c822_mailbox_addresses_real_equal_to (GeeHashable* base,
                                               GearyRFC822MailboxAddresses* other)
{
	GearyRFC822MailboxAddresses * self;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, GearyRFC822MailboxAddresses);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (other), FALSE);
	if (self == other) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->addrs;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	_tmp3_ = other->priv->addrs;
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp5_ = _tmp4_;
	if (_tmp2_ != _tmp5_) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GeeList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				GeeList* _tmp11_;
				gpointer _tmp12_;
				GearyRFC822MailboxAddress* _tmp13_;
				GeeList* _tmp14_;
				gpointer _tmp15_;
				GearyRFC822MailboxAddress* _tmp16_;
				gboolean _tmp17_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = self->priv->addrs;
				_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp10_ = _tmp9_;
				if (!(i < _tmp10_)) {
					break;
				}
				_tmp11_ = self->priv->addrs;
				_tmp12_ = gee_list_get (_tmp11_, i);
				_tmp13_ = (GearyRFC822MailboxAddress*) _tmp12_;
				_tmp14_ = other->priv->addrs;
				_tmp15_ = gee_list_get (_tmp14_, i);
				_tmp16_ = (GearyRFC822MailboxAddress*) _tmp15_;
				_tmp17_ = !gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_HASHABLE, GeeHashable), _tmp16_);
				_g_object_unref0 (_tmp16_);
				_g_object_unref0 (_tmp13_);
				if (_tmp17_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

/**
     * See Geary.MessageData.SearchableMessageData.
     */
static gchar*
__lambda11_ (GearyRFC822MailboxAddresses* self,
             GearyRFC822MailboxAddress* a)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (a), NULL);
	_tmp0_ = geary_message_data_searchable_message_data_to_searchable_string (G_TYPE_CHECK_INSTANCE_CAST (a, GEARY_MESSAGE_DATA_TYPE_SEARCHABLE_MESSAGE_DATA, GearyMessageDataSearchableMessageData));
	result = _tmp0_;
	return result;
}

static gchar*
___lambda11__geary_rf_c822_mailbox_addresses_list_to_string_delegate (GearyRFC822MailboxAddress* address,
                                                                      gpointer self)
{
	gchar* result;
	result = __lambda11_ ((GearyRFC822MailboxAddresses*) self, address);
	return result;
}

static gchar*
geary_rf_c822_mailbox_addresses_real_to_searchable_string (GearyMessageDataSearchableMessageData* base)
{
	GearyRFC822MailboxAddresses * self;
	GeeList* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, GearyRFC822MailboxAddresses);
	_tmp0_ = self->priv->addrs;
	_tmp1_ = geary_rf_c822_mailbox_addresses_list_to_string (_tmp0_, ___lambda11__geary_rf_c822_mailbox_addresses_list_to_string_delegate, self);
	result = _tmp1_;
	return result;
}

static gchar*
___lambda12_ (GearyRFC822MailboxAddresses* self,
              GearyRFC822MailboxAddress* a)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (a), NULL);
	_tmp0_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (a, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
	result = _tmp0_;
	return result;
}

static gchar*
____lambda12__geary_rf_c822_mailbox_addresses_list_to_string_delegate (GearyRFC822MailboxAddress* address,
                                                                       gpointer self)
{
	gchar* result;
	result = ___lambda12_ ((GearyRFC822MailboxAddresses*) self, address);
	return result;
}

static gchar*
geary_rf_c822_mailbox_addresses_real_to_string (GearyMessageDataAbstractMessageData* base)
{
	GearyRFC822MailboxAddresses * self;
	gchar* _tmp0_ = NULL;
	gint _tmp1_;
	gint _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, GearyRFC822MailboxAddresses);
	_tmp1_ = geary_rf_c822_mailbox_addresses_get_size (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		GeeList* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->addrs;
		_tmp4_ = geary_rf_c822_mailbox_addresses_list_to_string (_tmp3_, ____lambda12__geary_rf_c822_mailbox_addresses_list_to_string_delegate, self);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("(no addresses)");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

static void
geary_rf_c822_mailbox_addresses_class_init (GearyRFC822MailboxAddressesClass * klass,
                                            gpointer klass_data)
{
	geary_rf_c822_mailbox_addresses_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyRFC822MailboxAddresses_private_offset);
	((GearyMessageDataAbstractMessageDataClass *) klass)->to_string = (gchar* (*) (GearyMessageDataAbstractMessageData*)) geary_rf_c822_mailbox_addresses_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_rf_c822_mailbox_addresses_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_rf_c822_mailbox_addresses_finalize;
	/** Returns the number of addresses in this list. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MAILBOX_ADDRESSES_SIZE_PROPERTY, geary_rf_c822_mailbox_addresses_properties[GEARY_RF_C822_MAILBOX_ADDRESSES_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if there are no addresses in the list. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MAILBOX_ADDRESSES_IS_EMPTY_PROPERTY, geary_rf_c822_mailbox_addresses_properties[GEARY_RF_C822_MAILBOX_ADDRESSES_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_rf_c822_mailbox_addresses_geary_message_data_searchable_message_data_interface_init (GearyMessageDataSearchableMessageDataIface * iface,
                                                                                           gpointer iface_data)
{
	geary_rf_c822_mailbox_addresses_geary_message_data_searchable_message_data_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_searchable_string = (gchar* (*) (GearyMessageDataSearchableMessageData*)) geary_rf_c822_mailbox_addresses_real_to_searchable_string;
}

static void
geary_rf_c822_mailbox_addresses_gee_hashable_interface_init (GeeHashableIface * iface,
                                                             gpointer iface_data)
{
	geary_rf_c822_mailbox_addresses_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->hash = (guint (*) (GeeHashable*)) geary_rf_c822_mailbox_addresses_real_hash;
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_rf_c822_mailbox_addresses_real_equal_to;
}

static void
geary_rf_c822_mailbox_addresses_geary_rf_c822_decoded_message_data_interface_init (GearyRFC822DecodedMessageDataIface * iface,
                                                                                   gpointer iface_data)
{
	geary_rf_c822_mailbox_addresses_geary_rf_c822_decoded_message_data_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_rfc822_string = (gchar* (*) (GearyRFC822DecodedMessageData*)) geary_rf_c822_mailbox_addresses_real_to_rfc822_string;
}

static void
geary_rf_c822_mailbox_addresses_instance_init (GearyRFC822MailboxAddresses * self,
                                               gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = geary_rf_c822_mailbox_addresses_get_instance_private (self);
	_tmp0_ = gee_array_list_new (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->addrs = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	self->priv->hash_cached = FALSE;
	self->priv->hash_value = (guint) 0;
}

static void
geary_rf_c822_mailbox_addresses_finalize (GObject * obj)
{
	GearyRFC822MailboxAddresses * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, GearyRFC822MailboxAddresses);
	_g_object_unref0 (self->priv->addrs);
	G_OBJECT_CLASS (geary_rf_c822_mailbox_addresses_parent_class)->finalize (obj);
}

/**
 * An immutable representation an RFC 822 address list.
 *
 * This would typically be found as the value of the To, CC, BCC and
 * other headers fields.
 *
 * See [[https://tools.ietf.org/html/rfc5322#section-3.4]]
 */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_mailbox_addresses_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822MailboxAddressesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_mailbox_addresses_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822MailboxAddresses), 0, (GInstanceInitFunc) geary_rf_c822_mailbox_addresses_instance_init, NULL };
	static const GInterfaceInfo geary_message_data_searchable_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_mailbox_addresses_geary_message_data_searchable_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_rf_c822_mailbox_addresses_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo geary_rf_c822_decoded_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_mailbox_addresses_geary_rf_c822_decoded_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_rf_c822_mailbox_addresses_type_id;
	geary_rf_c822_mailbox_addresses_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, "GearyRFC822MailboxAddresses", &g_define_type_info, 0);
	g_type_add_interface_static (geary_rf_c822_mailbox_addresses_type_id, GEARY_MESSAGE_DATA_TYPE_SEARCHABLE_MESSAGE_DATA, &geary_message_data_searchable_message_data_info);
	g_type_add_interface_static (geary_rf_c822_mailbox_addresses_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	g_type_add_interface_static (geary_rf_c822_mailbox_addresses_type_id, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, &geary_rf_c822_decoded_message_data_info);
	GearyRFC822MailboxAddresses_private_offset = g_type_add_instance_private (geary_rf_c822_mailbox_addresses_type_id, sizeof (GearyRFC822MailboxAddressesPrivate));
	return geary_rf_c822_mailbox_addresses_type_id;
}

GType
geary_rf_c822_mailbox_addresses_get_type (void)
{
	static gsize geary_rf_c822_mailbox_addresses_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_mailbox_addresses_type_id__once)) {
		GType geary_rf_c822_mailbox_addresses_type_id;
		geary_rf_c822_mailbox_addresses_type_id = geary_rf_c822_mailbox_addresses_get_type_once ();
		g_once_init_leave (&geary_rf_c822_mailbox_addresses_type_id__once, geary_rf_c822_mailbox_addresses_type_id);
	}
	return geary_rf_c822_mailbox_addresses_type_id__once;
}

static void
_vala_geary_rf_c822_mailbox_addresses_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	GearyRFC822MailboxAddresses * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, GearyRFC822MailboxAddresses);
	switch (property_id) {
		case GEARY_RF_C822_MAILBOX_ADDRESSES_SIZE_PROPERTY:
		g_value_set_int (value, geary_rf_c822_mailbox_addresses_get_size (self));
		break;
		case GEARY_RF_C822_MAILBOX_ADDRESSES_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, geary_rf_c822_mailbox_addresses_get_is_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

