/* components-conversation-actions.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from components-conversation-actions.vala, do not modify */

/*
 * Copyright © 2017 Software Freedom Conservancy Inc.
 * Copyright © 2021 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <glib.h>
#include "geary-engine.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	COMPONENTS_CONVERSATION_ACTIONS_0_PROPERTY,
	COMPONENTS_CONVERSATION_ACTIONS_SHOW_CONVERSATION_ACTIONS_PROPERTY,
	COMPONENTS_CONVERSATION_ACTIONS_SHOW_RESPONSE_ACTIONS_PROPERTY,
	COMPONENTS_CONVERSATION_ACTIONS_PACK_JUSTIFIED_PROPERTY,
	COMPONENTS_CONVERSATION_ACTIONS_COPY_MOVE_POPOVER_PROPERTY,
	COMPONENTS_CONVERSATION_ACTIONS_SELECTED_CONVERSATIONS_PROPERTY,
	COMPONENTS_CONVERSATION_ACTIONS_ACCOUNT_PROPERTY,
	COMPONENTS_CONVERSATION_ACTIONS_NUM_PROPERTIES
};
static GParamSpec* components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	COMPONENTS_CONVERSATION_ACTIONS_MARK_MESSAGE_BUTTON_TOGGLED_SIGNAL,
	COMPONENTS_CONVERSATION_ACTIONS_NUM_SIGNALS
};
static guint components_conversation_actions_signals[COMPONENTS_CONVERSATION_ACTIONS_NUM_SIGNALS] = {0};

struct _ComponentsConversationActionsPrivate {
	gboolean _show_conversation_actions;
	gboolean _show_response_actions;
	gboolean _pack_justified;
	gint _selected_conversations;
	GearyAccount* _account;
	GtkBox* _response_buttons;
	GtkMenuButton* _mark_message_button;
	GtkMenuButton* _copy_message_button;
	GtkBox* _action_buttons;
	GtkButton* archive_button;
	GtkButton* trash_delete_button;
	gboolean show_trash_button;
	GtkImage* trash_image;
	GtkImage* delete_image;
};

static gint ComponentsConversationActions_private_offset;
static gpointer components_conversation_actions_parent_class = NULL;

static GtkMenuButton* components_conversation_actions_get_copy_message_button (ComponentsConversationActions* self);
static void components_conversation_actions_update_conversation_buttons (ComponentsConversationActions* self);
static GtkBox* components_conversation_actions_get_response_buttons (ComponentsConversationActions* self);
static GtkMenuButton* components_conversation_actions_get_mark_message_button (ComponentsConversationActions* self);
static GtkBox* components_conversation_actions_get_action_buttons (ComponentsConversationActions* self);
static GObject * components_conversation_actions_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void _components_conversation_actions___lambda133_ (ComponentsConversationActions* self);
static void __components_conversation_actions___lambda133__g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void _components_conversation_actions___lambda134_ (ComponentsConversationActions* self);
static void __components_conversation_actions___lambda134__g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void _components_conversation_actions___lambda135_ (ComponentsConversationActions* self,
                                                    GtkToggleButton* button);
static void __components_conversation_actions___lambda135__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                               gpointer self);
static void components_conversation_actions_finalize (GObject * obj);
static GType components_conversation_actions_get_type_once (void);
static void _vala_components_conversation_actions_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_components_conversation_actions_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);

static inline gpointer
components_conversation_actions_get_instance_private (ComponentsConversationActions* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsConversationActions_private_offset);
}

gboolean
components_conversation_actions_get_show_conversation_actions (ComponentsConversationActions* self)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self), FALSE);
	result = self->priv->_show_conversation_actions;
	return result;
}

static void
components_conversation_actions_set_show_conversation_actions (ComponentsConversationActions* self,
                                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	old_value = components_conversation_actions_get_show_conversation_actions (self);
	if (old_value != value) {
		self->priv->_show_conversation_actions = value;
		g_object_notify_by_pspec ((GObject *) self, components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_SHOW_CONVERSATION_ACTIONS_PROPERTY]);
	}
}

gboolean
components_conversation_actions_get_show_response_actions (ComponentsConversationActions* self)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self), FALSE);
	result = self->priv->_show_response_actions;
	return result;
}

static void
components_conversation_actions_set_show_response_actions (ComponentsConversationActions* self,
                                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	old_value = components_conversation_actions_get_show_response_actions (self);
	if (old_value != value) {
		self->priv->_show_response_actions = value;
		g_object_notify_by_pspec ((GObject *) self, components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_SHOW_RESPONSE_ACTIONS_PROPERTY]);
	}
}

gboolean
components_conversation_actions_get_pack_justified (ComponentsConversationActions* self)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self), FALSE);
	result = self->priv->_pack_justified;
	return result;
}

static void
components_conversation_actions_set_pack_justified (ComponentsConversationActions* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	old_value = components_conversation_actions_get_pack_justified (self);
	if (old_value != value) {
		self->priv->_pack_justified = value;
		g_object_notify_by_pspec ((GObject *) self, components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_PACK_JUSTIFIED_PROPERTY]);
	}
}

FolderPopover*
components_conversation_actions_get_copy_move_popover (ComponentsConversationActions* self)
{
	FolderPopover* result;
	FolderPopover* popover = NULL;
	GtkMenuButton* _tmp0_;
	GtkPopover* _tmp1_;
	GtkPopover* _tmp2_;
	g_return_val_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self), NULL);
	_tmp0_ = self->priv->_copy_message_button;
	_tmp1_ = gtk_menu_button_get_popover (_tmp0_);
	_tmp2_ = _tmp1_;
	popover = IS_FOLDER_POPOVER (_tmp2_) ? ((FolderPopover*) _tmp2_) : NULL;
	result = popover;
	return result;
}

gint
components_conversation_actions_get_selected_conversations (ComponentsConversationActions* self)
{
	gint result;
	g_return_val_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self), 0);
	result = self->priv->_selected_conversations;
	return result;
}

void
components_conversation_actions_set_selected_conversations (ComponentsConversationActions* self,
                                                            gint value)
{
	gint old_value;
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	old_value = components_conversation_actions_get_selected_conversations (self);
	if (old_value != value) {
		self->priv->_selected_conversations = value;
		g_object_notify_by_pspec ((GObject *) self, components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_SELECTED_CONVERSATIONS_PROPERTY]);
	}
}

GearyAccount*
components_conversation_actions_get_account (ComponentsConversationActions* self)
{
	GearyAccount* result;
	GearyAccount* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
components_conversation_actions_set_account (ComponentsConversationActions* self,
                                             GearyAccount* value)
{
	GearyAccount* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_account);
	self->priv->_account = _tmp0_;
	components_conversation_actions_update_conversation_buttons (self);
	g_object_notify_by_pspec ((GObject *) self, components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_ACCOUNT_PROPERTY]);
}

static GtkBox*
components_conversation_actions_get_response_buttons (ComponentsConversationActions* self)
{
	GtkBox* result;
	GtkBox* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self), NULL);
	_tmp0_ = self->priv->_response_buttons;
	result = _tmp0_;
	return result;
}

static GtkMenuButton*
components_conversation_actions_get_mark_message_button (ComponentsConversationActions* self)
{
	GtkMenuButton* result;
	GtkMenuButton* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self), NULL);
	_tmp0_ = self->priv->_mark_message_button;
	result = _tmp0_;
	return result;
}

static GtkMenuButton*
components_conversation_actions_get_copy_message_button (ComponentsConversationActions* self)
{
	GtkMenuButton* result;
	GtkMenuButton* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self), NULL);
	_tmp0_ = self->priv->_copy_message_button;
	result = _tmp0_;
	return result;
}

static GtkBox*
components_conversation_actions_get_action_buttons (ComponentsConversationActions* self)
{
	GtkBox* result;
	GtkBox* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self), NULL);
	_tmp0_ = self->priv->_action_buttons;
	result = _tmp0_;
	return result;
}

void
components_conversation_actions_init (ComponentsConversationActions* self,
                                      ApplicationConfiguration* config)
{
	GtkMenuButton* _tmp0_;
	FolderPopover* _tmp1_;
	FolderPopover* _tmp2_;
	GtkMenuButton* _tmp3_;
	GtkPopover* _tmp4_;
	GtkPopover* _tmp5_;
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (config));
	_tmp0_ = self->priv->_copy_message_button;
	_tmp1_ = folder_popover_new (config);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_menu_button_set_popover (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_popover_get_type (), GtkPopover));
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_copy_message_button;
	_tmp4_ = gtk_menu_button_get_popover (_tmp3_);
	_tmp5_ = _tmp4_;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "account", G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject), "account", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
}

void
components_conversation_actions_set_copy_sensitive (ComponentsConversationActions* self,
                                                    gboolean is_sensitive)
{
	GtkMenuButton* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	_tmp0_ = self->priv->_copy_message_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), is_sensitive);
}

void
components_conversation_actions_set_mark_sensitive (ComponentsConversationActions* self,
                                                    gboolean is_sensitive)
{
	GtkMenuButton* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	_tmp0_ = self->priv->_mark_message_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), is_sensitive);
}

void
components_conversation_actions_show_copy_menu (ComponentsConversationActions* self)
{
	GtkMenuButton* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	_tmp0_ = self->priv->_copy_message_button;
	gtk_button_clicked (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_button_get_type (), GtkButton));
}

void
components_conversation_actions_set_mark_inverted (ComponentsConversationActions* self)
{
	GtkImage* image = NULL;
	GtkImage* _tmp0_;
	GtkMenuButton* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-up-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	_tmp1_ = self->priv->_mark_message_button;
	gtk_button_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_button_get_type (), GtkButton), G_TYPE_CHECK_INSTANCE_CAST (image, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (image);
}

void
components_conversation_actions_update_trash_button (ComponentsConversationActions* self,
                                                     gboolean show_trash)
{
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	self->priv->show_trash_button = show_trash;
	components_conversation_actions_update_conversation_buttons (self);
}

/** Updates tooltip text depending on number of conversations selected. */
static void
components_conversation_actions_update_conversation_buttons (ComponentsConversationActions* self)
{
	GtkMenuButton* _tmp0_;
	gint _tmp1_;
	GtkButton* _tmp2_;
	gint _tmp3_;
	GearyAccount* _tmp4_;
	GearyAccount* _tmp5_;
	g_return_if_fail (COMPONENTS_IS_CONVERSATION_ACTIONS (self));
	_tmp0_ = self->priv->_mark_message_button;
	_tmp1_ = self->priv->_selected_conversations;
	gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), ngettext ("Mark conversation", "Mark conversations", (gulong) _tmp1_));
	_tmp2_ = self->priv->archive_button;
	_tmp3_ = self->priv->_selected_conversations;
	gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), ngettext ("Archive conversation", "Archive conversations", (gulong) _tmp3_));
	_tmp4_ = components_conversation_actions_get_account (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		GearyAccount* _tmp6_;
		GearyAccount* _tmp7_;
		GearyAccountInformation* _tmp8_;
		GearyAccountInformation* _tmp9_;
		GearyServiceProvider _tmp10_;
		GearyServiceProvider _tmp11_;
		_tmp6_ = components_conversation_actions_get_account (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_account_get_information (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = geary_account_information_get_service_provider (_tmp9_);
		_tmp11_ = _tmp10_;
		switch (_tmp11_) {
			case GEARY_SERVICE_PROVIDER_GMAIL:
			{
				GtkMenuButton* _tmp12_;
				gint _tmp13_;
				GtkMenuButton* _tmp14_;
				GtkImage* _tmp15_;
				GtkImage* _tmp16_;
				_tmp12_ = self->priv->_copy_message_button;
				_tmp13_ = self->priv->_selected_conversations;
				gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), ngettext ("Add label to conversation", "Add label to conversations", (gulong) _tmp13_));
				_tmp14_ = self->priv->_copy_message_button;
				_tmp15_ = (GtkImage*) gtk_image_new_from_icon_name ("tag-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
				g_object_ref_sink (_tmp15_);
				_tmp16_ = _tmp15_;
				gtk_button_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_button_get_type (), GtkButton), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (_tmp16_);
				break;
			}
			default:
			{
				GtkMenuButton* _tmp17_;
				gint _tmp18_;
				GtkMenuButton* _tmp19_;
				GtkImage* _tmp20_;
				GtkImage* _tmp21_;
				_tmp17_ = self->priv->_copy_message_button;
				_tmp18_ = self->priv->_selected_conversations;
				gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), ngettext ("Copy conversation", "Copy conversations", (gulong) _tmp18_));
				_tmp19_ = self->priv->_copy_message_button;
				_tmp20_ = (GtkImage*) gtk_image_new_from_icon_name ("folder-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
				g_object_ref_sink (_tmp20_);
				_tmp21_ = _tmp20_;
				gtk_button_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_button_get_type (), GtkButton), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (_tmp21_);
				break;
			}
		}
	}
	if (self->priv->show_trash_button) {
		GtkButton* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GtkButton* _tmp25_;
		GtkImage* _tmp26_;
		GtkButton* _tmp27_;
		gint _tmp28_;
		_tmp22_ = self->priv->trash_delete_button;
		_tmp23_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_TRASH_CONVERSATION);
		_tmp24_ = _tmp23_;
		gtk_actionable_set_action_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_actionable_get_type (), GtkActionable), _tmp24_);
		_g_free0 (_tmp24_);
		_tmp25_ = self->priv->trash_delete_button;
		_tmp26_ = self->priv->trash_image;
		gtk_button_set_image (_tmp25_, G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget));
		_tmp27_ = self->priv->trash_delete_button;
		_tmp28_ = self->priv->_selected_conversations;
		gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), ngettext ("Move conversation to Trash", "Move conversations to Trash", (gulong) _tmp28_));
	} else {
		GtkButton* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		GtkButton* _tmp32_;
		GtkImage* _tmp33_;
		GtkButton* _tmp34_;
		gint _tmp35_;
		_tmp29_ = self->priv->trash_delete_button;
		_tmp30_ = action_window_prefix (APPLICATION_MAIN_WINDOW_ACTION_DELETE_CONVERSATION);
		_tmp31_ = _tmp30_;
		gtk_actionable_set_action_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_actionable_get_type (), GtkActionable), _tmp31_);
		_g_free0 (_tmp31_);
		_tmp32_ = self->priv->trash_delete_button;
		_tmp33_ = self->priv->delete_image;
		gtk_button_set_image (_tmp32_, G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget));
		_tmp34_ = self->priv->trash_delete_button;
		_tmp35_ = self->priv->_selected_conversations;
		gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget), ngettext ("Delete conversation", "Delete conversations", (gulong) _tmp35_));
	}
}

ComponentsConversationActions*
components_conversation_actions_construct (GType object_type)
{
	ComponentsConversationActions * self = NULL;
	self = (ComponentsConversationActions*) g_object_new (object_type, NULL);
	return self;
}

ComponentsConversationActions*
components_conversation_actions_new (void)
{
	return components_conversation_actions_construct (COMPONENTS_TYPE_CONVERSATION_ACTIONS);
}

static void
_components_conversation_actions___lambda133_ (ComponentsConversationActions* self)
{
	components_conversation_actions_update_conversation_buttons (self);
}

static void
__components_conversation_actions___lambda133__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	_components_conversation_actions___lambda133_ ((ComponentsConversationActions*) self);
}

static void
_components_conversation_actions___lambda134_ (ComponentsConversationActions* self)
{
	components_conversation_actions_update_conversation_buttons (self);
}

static void
__components_conversation_actions___lambda134__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	_components_conversation_actions___lambda134_ ((ComponentsConversationActions*) self);
}

static void
_components_conversation_actions___lambda135_ (ComponentsConversationActions* self,
                                               GtkToggleButton* button)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (button, gtk_toggle_button_get_type ()));
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_signal_emit (self, components_conversation_actions_signals[COMPONENTS_CONVERSATION_ACTIONS_MARK_MESSAGE_BUTTON_TOGGLED_SIGNAL], 0);
	}
}

static void
__components_conversation_actions___lambda135__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                          gpointer self)
{
	_components_conversation_actions___lambda135_ ((ComponentsConversationActions*) self, _sender);
}

static GObject *
components_conversation_actions_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ComponentsConversationActions * self;
	GtkBuilder* menu_builder = NULL;
	GtkBuilder* _tmp0_;
	GMenuModel* mark_menu = NULL;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GMenuModel* _tmp3_;
	GtkMenuButton* _tmp4_;
	GMenuModel* _tmp5_;
	GtkPopover* _tmp6_;
	GtkPopover* _tmp7_;
	GtkMenuButton* _tmp8_;
	GtkBox* _tmp9_;
	gboolean _tmp10_;
	GtkBox* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	parent_class = G_OBJECT_CLASS (components_conversation_actions_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_CONVERSATION_ACTIONS, ComponentsConversationActions);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/Geary/components-menu-conversation.ui");
	menu_builder = _tmp0_;
	_tmp1_ = menu_builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "mark_message_menu");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_menu_model_get_type (), GMenuModel));
	mark_menu = _tmp3_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::selected-conversations", (GCallback) __components_conversation_actions___lambda133__g_object_notify, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::service-provider", (GCallback) __components_conversation_actions___lambda134__g_object_notify, self, 0);
	_tmp4_ = self->priv->_mark_message_button;
	_tmp5_ = mark_menu;
	_tmp6_ = (GtkPopover*) gtk_popover_new_from_model (NULL, _tmp5_);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	gtk_menu_button_set_popover (_tmp4_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->_mark_message_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) __components_conversation_actions___lambda135__gtk_toggle_button_toggled, self, 0);
	_tmp9_ = self->priv->_response_buttons;
	_tmp10_ = self->priv->_show_response_actions;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), _tmp10_);
	_tmp11_ = self->priv->_action_buttons;
	_tmp12_ = self->priv->_show_conversation_actions;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), _tmp12_);
	_tmp13_ = self->priv->_pack_justified;
	if (_tmp13_) {
		GtkBox* _tmp14_;
		GtkBox* _tmp15_;
		_tmp14_ = self->priv->_action_buttons;
		gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp15_ = self->priv->_action_buttons;
		gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_END);
	}
	_g_object_unref0 (mark_menu);
	_g_object_unref0 (menu_builder);
	return obj;
}

static void
components_conversation_actions_class_init (ComponentsConversationActionsClass * klass,
                                            gpointer klass_data)
{
	components_conversation_actions_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsConversationActions_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_components_conversation_actions_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_components_conversation_actions_set_property;
	G_OBJECT_CLASS (klass)->constructor = components_conversation_actions_constructor;
	G_OBJECT_CLASS (klass)->finalize = components_conversation_actions_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_CONVERSATION_ACTIONS_SHOW_CONVERSATION_ACTIONS_PROPERTY, components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_SHOW_CONVERSATION_ACTIONS_PROPERTY] = g_param_spec_boolean ("show-conversation-actions", "show-conversation-actions", "show-conversation-actions", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_CONVERSATION_ACTIONS_SHOW_RESPONSE_ACTIONS_PROPERTY, components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_SHOW_RESPONSE_ACTIONS_PROPERTY] = g_param_spec_boolean ("show-response-actions", "show-response-actions", "show-response-actions", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_CONVERSATION_ACTIONS_PACK_JUSTIFIED_PROPERTY, components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_PACK_JUSTIFIED_PROPERTY] = g_param_spec_boolean ("pack-justified", "pack-justified", "pack-justified", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_CONVERSATION_ACTIONS_COPY_MOVE_POPOVER_PROPERTY, components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_COPY_MOVE_POPOVER_PROPERTY] = g_param_spec_object ("copy-move-popover", "copy-move-popover", "copy-move-popover", TYPE_FOLDER_POPOVER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_CONVERSATION_ACTIONS_SELECTED_CONVERSATIONS_PROPERTY, components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_SELECTED_CONVERSATIONS_PROPERTY] = g_param_spec_int ("selected-conversations", "selected-conversations", "selected-conversations", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_CONVERSATION_ACTIONS_ACCOUNT_PROPERTY, components_conversation_actions_properties[COMPONENTS_CONVERSATION_ACTIONS_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/components-conversation-actions.ui");
	/** Fired when the user toggles the mark message button. */
	components_conversation_actions_signals[COMPONENTS_CONVERSATION_ACTIONS_MARK_MESSAGE_BUTTON_TOGGLED_SIGNAL] = g_signal_new ("mark-message-button-toggled", COMPONENTS_TYPE_CONVERSATION_ACTIONS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "response_buttons", FALSE, ComponentsConversationActions_private_offset + G_STRUCT_OFFSET (ComponentsConversationActionsPrivate, _response_buttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mark_message_button", FALSE, ComponentsConversationActions_private_offset + G_STRUCT_OFFSET (ComponentsConversationActionsPrivate, _mark_message_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "copy_message_button", FALSE, ComponentsConversationActions_private_offset + G_STRUCT_OFFSET (ComponentsConversationActionsPrivate, _copy_message_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_buttons", FALSE, ComponentsConversationActions_private_offset + G_STRUCT_OFFSET (ComponentsConversationActionsPrivate, _action_buttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "archive_button", FALSE, ComponentsConversationActions_private_offset + G_STRUCT_OFFSET (ComponentsConversationActionsPrivate, archive_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "trash_delete_button", FALSE, ComponentsConversationActions_private_offset + G_STRUCT_OFFSET (ComponentsConversationActionsPrivate, trash_delete_button));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "components-conversation-actions");
}

static void
components_conversation_actions_instance_init (ComponentsConversationActions * self,
                                               gpointer klass)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	self->priv = components_conversation_actions_get_instance_private (self);
	self->priv->show_trash_button = TRUE;
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("user-trash-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	self->priv->trash_image = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	self->priv->delete_image = _tmp1_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
components_conversation_actions_finalize (GObject * obj)
{
	ComponentsConversationActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_CONVERSATION_ACTIONS, ComponentsConversationActions);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->priv->trash_image);
	_g_object_unref0 (self->priv->delete_image);
	G_OBJECT_CLASS (components_conversation_actions_parent_class)->finalize (obj);
}

/**
 * A container of conversation-related actions.
 */
static GType
components_conversation_actions_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsConversationActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_conversation_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsConversationActions), 0, (GInstanceInitFunc) components_conversation_actions_instance_init, NULL };
	GType components_conversation_actions_type_id;
	components_conversation_actions_type_id = g_type_register_static (gtk_box_get_type (), "ComponentsConversationActions", &g_define_type_info, 0);
	ComponentsConversationActions_private_offset = g_type_add_instance_private (components_conversation_actions_type_id, sizeof (ComponentsConversationActionsPrivate));
	return components_conversation_actions_type_id;
}

GType
components_conversation_actions_get_type (void)
{
	static volatile gsize components_conversation_actions_type_id__once = 0;
	if (g_once_init_enter (&components_conversation_actions_type_id__once)) {
		GType components_conversation_actions_type_id;
		components_conversation_actions_type_id = components_conversation_actions_get_type_once ();
		g_once_init_leave (&components_conversation_actions_type_id__once, components_conversation_actions_type_id);
	}
	return components_conversation_actions_type_id__once;
}

static void
_vala_components_conversation_actions_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	ComponentsConversationActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_CONVERSATION_ACTIONS, ComponentsConversationActions);
	switch (property_id) {
		case COMPONENTS_CONVERSATION_ACTIONS_SHOW_CONVERSATION_ACTIONS_PROPERTY:
		g_value_set_boolean (value, components_conversation_actions_get_show_conversation_actions (self));
		break;
		case COMPONENTS_CONVERSATION_ACTIONS_SHOW_RESPONSE_ACTIONS_PROPERTY:
		g_value_set_boolean (value, components_conversation_actions_get_show_response_actions (self));
		break;
		case COMPONENTS_CONVERSATION_ACTIONS_PACK_JUSTIFIED_PROPERTY:
		g_value_set_boolean (value, components_conversation_actions_get_pack_justified (self));
		break;
		case COMPONENTS_CONVERSATION_ACTIONS_COPY_MOVE_POPOVER_PROPERTY:
		g_value_set_object (value, components_conversation_actions_get_copy_move_popover (self));
		break;
		case COMPONENTS_CONVERSATION_ACTIONS_SELECTED_CONVERSATIONS_PROPERTY:
		g_value_set_int (value, components_conversation_actions_get_selected_conversations (self));
		break;
		case COMPONENTS_CONVERSATION_ACTIONS_ACCOUNT_PROPERTY:
		g_value_set_object (value, components_conversation_actions_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_components_conversation_actions_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	ComponentsConversationActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_CONVERSATION_ACTIONS, ComponentsConversationActions);
	switch (property_id) {
		case COMPONENTS_CONVERSATION_ACTIONS_SHOW_CONVERSATION_ACTIONS_PROPERTY:
		components_conversation_actions_set_show_conversation_actions (self, g_value_get_boolean (value));
		break;
		case COMPONENTS_CONVERSATION_ACTIONS_SHOW_RESPONSE_ACTIONS_PROPERTY:
		components_conversation_actions_set_show_response_actions (self, g_value_get_boolean (value));
		break;
		case COMPONENTS_CONVERSATION_ACTIONS_PACK_JUSTIFIED_PROPERTY:
		components_conversation_actions_set_pack_justified (self, g_value_get_boolean (value));
		break;
		case COMPONENTS_CONVERSATION_ACTIONS_SELECTED_CONVERSATIONS_PROPERTY:
		components_conversation_actions_set_selected_conversations (self, g_value_get_int (value));
		break;
		case COMPONENTS_CONVERSATION_ACTIONS_ACCOUNT_PROPERTY:
		components_conversation_actions_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

