static const char* boxblur_1d_cl_source =
"__kernel void box_blur_hor (__global const float4     *in,                    \n"
"                            __global       float4     *out,                   \n"
"                                     const int         radius)                \n"
"{                                                                             \n"
"  const int size          = 2 * radius + 1;                                   \n"
"  const int gidx          = get_global_id (0);                                \n"
"  const int gidy          = get_global_id (1);                                \n"
"  const int src_rowstride = get_global_size (0) + size - 1;                   \n"
"  const int dst_rowstride = get_global_size (0);                              \n"
"                                                                              \n"
"  const int src_offset    = gidx + gidy * src_rowstride + radius;             \n"
"  const int dst_offset    = gidx + gidy * dst_rowstride;                      \n"
"                                                                              \n"
"  const int src_start_ind = src_offset - radius;                              \n"
"                                                                              \n"
"  float4 mean = 0.0f;                                                         \n"
"                                                                              \n"
"  for (int i = 0; i < size; i++)                                              \n"
"    {                                                                         \n"
"      mean += in[src_start_ind + i];                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  out[dst_offset] = mean / (float)(size);                                     \n"
"}                                                                             \n"
"                                                                              \n"
"__kernel void box_blur_ver (__global const float4     *in,                    \n"
"                            __global       float4     *out,                   \n"
"                                     const int         radius)                \n"
"{                                                                             \n"
"  const int size          = 2 * radius + 1;                                   \n"
"  const int gidx          = get_global_id (0);                                \n"
"  const int gidy          = get_global_id (1);                                \n"
"  const int src_rowstride = get_global_size (0);                              \n"
"  const int dst_rowstride = get_global_size (0);                              \n"
"                                                                              \n"
"  const int src_offset    = gidx + (gidy + radius) * src_rowstride;           \n"
"  const int dst_offset    = gidx +  gidy           * dst_rowstride;           \n"
"                                                                              \n"
"  const int src_start_ind = src_offset - radius * src_rowstride;              \n"
"                                                                              \n"
"  float4 mean = 0.0f;                                                         \n"
"                                                                              \n"
"  for (int i = 0; i < size; i++)                                              \n"
"    {                                                                         \n"
"      mean += in[src_start_ind + i * src_rowstride];                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  out[dst_offset] = mean / (float)(size);                                     \n"
"}                                                                             \n"
;
