/*
 * nUFRaw - Unidentified Flying Raw converter for digital camera images
 *
 * uf_gtk.h - gtk compatibility header
 * Copyright 2004-2016 by Udi Fuchs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef _UF_GTK_H
#define _UF_GTK_H

#include <gtk/gtk.h>
#include <ufobject.h>

#ifdef __MINGW32__
#ifdef __MINGW64__
#define uf_long gint64
#else
#define uf_long gint32
#endif
#else
#define uf_long long
#endif

#ifdef __cplusplus
extern "C" {
#endif

void uf_label_set_background(GtkLabel *label, float r, float g, float b, float max);

void ufnumber_adjustment_scale(UFObject *obj
	                        ,GtkTable *table
	                        ,int x
	                        ,int y
	                        ,const char *label
	                        ,const char *tip);

GtkWidget *uf_stock_image_button(const gchar *stock_id
	                              ,GtkIconSize size
	                              ,const char *tip
	                              ,GCallback callback
	                              ,void *data);

GtkWidget *uf_stock_icon_button(const gchar *stock_id
	                      ,const char *tip
	                      ,GCallback callback
	                      ,void *data);

GtkWidget *uf_reset_button(const char *tip, GCallback callback, void *data);

GtkAdjustment *uf_adjustment_spin(GtkTable *table
	                            ,int x
	                            ,int y
	                            ,const char *label
	                            ,double value
	                            ,void *valuep
	                            ,double min
	                            ,double max
	                            ,double step
	                            ,double jump
	                            ,uf_long accuracy
	                            ,const gboolean wrap_spinner
	                            ,const char *tip
	                            ,GCallback callback
	                            ,GtkWidget **resetButton
	                            ,const char *resetTip
	                            ,GCallback resetCallback);

GtkAdjustment *uf_adjustment_scale(GtkTable *table
	                            ,int x
	                            ,int y
	                            ,const char *label
	                            ,double value
	                            ,void *valuep
	                            ,double min
	                            ,double max
	                            ,double step
	                            ,double jump
	                            ,uf_long accuracy
	                            ,const gboolean wrap_spinner
	                            ,const char *tip
	                            ,GCallback callback
	                            ,GtkWidget **resetButton
	                            ,const char *resetTip
	                            ,GCallback resetCallback);

GtkWidget *uf_table_with_frame(GtkWidget *box);
GtkWidget *uf_hbox_with_frame(GtkWidget *box);
GtkWidget *uf_vbox_with_frame(GtkWidget *box, gboolean expand);

GtkTable *uf_expander_with_frame(GtkWidget *box, 
                                 char *label, 
                                 gboolean expanderstate, 
                                 GCallback expand_callback, 
                                 gboolean expand);

GtkWidget *uf_notebook_page_new(GtkNotebook *notebook, char *text, char *icon);

// Create a new ComboBox text with small width.
// The widget must be added with GTK_EXPAND|GTK_FILL.
GtkWidget *uf_combo_box_new_text();

// Append text with data to combo box
void uf_combo_box_append_text(GtkComboBox *combo, const char *text, void *data);

// activate combo box according to data or index, if there is no data - TODO: unused
void uf_combo_box_set_active(GtkComboBox *combo, int value);

// remove combo box entry according to data or index, if there is no data - TODO: unused
void uf_combo_box_remove_text(GtkComboBox *combo, int value);

// Set combo box data and keep it up to date- TODO: unused
void uf_combo_box_set_data(GtkComboBox *combo, int *valuep);

// Get the display ICC profile of the monitor associated with the widget.
void uf_get_display_profile(GtkWidget *widget,
                            guint8 **buffer, gint *buffer_size);

/*
 * The following functions create GtkWidgets for UFObjects.
 * These widgets are already created with callbacks, so that changes
 * in the widget value are applied to the UFObjects and vice-versa.
 */
GtkWidget *ufnumber_hscale_new(UFObject *object);
GtkWidget *ufnumber_spin_button_new(UFObject *object);
GtkWidget *ufnumber_array_hscale_new(UFObject *object, int index);
GtkWidget *ufnumber_array_spin_button_new(UFObject *object, int index);
GtkWidget *ufobject_reset_button_new(const char *tip);
void ufobject_reset_button_add(GtkWidget *button, UFObject *object);
GtkWidget *ufstring_entry_new(UFObject *object);
GtkWidget *ufarray_combo_box_new(UFObject *object);
GtkWidget *ufarray_combo_box_entry_new(UFObject *object);

void ufobject_reset_clicked(GtkWidget *widget);
#ifdef __cplusplus
}
#endif

#endif /*_UF_GTK_H*/
