/* Application.c generated by valac 0.56.17, the Vala compiler
 * generated from Application.vala, do not modify */

/* Application.vala
 *
 * Copyright 2020-2021 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "common.h"
#include <glib-object.h>
#include "config.h"
#include <gtk/gtk.h>
#include <gio/gdesktopappinfo.h>
#include <json-glib/json-glib.h>

#define BREAK_TIMER_DAEMON_APPLICATION_app_name _ ("GNOME Break Timer")
#define BREAK_TIMER_DAEMON_APPLICATION_DATA_VERSION 0
#define BREAK_TIMER_DAEMON_APPLICATION_ACTIVITY_TIMEOUT_MS (60 * BREAK_TIMER_COMMON_TIME_UNIT_MILLISECONDS_IN_SECONDS)
#define BREAK_TIMER_DAEMON_APPLICATION_SAVE_STATE_EXPIRY_MS (10 * BREAK_TIMER_COMMON_TIME_UNIT_MILLISECONDS_IN_SECONDS)
#define BREAK_TIMER_DAEMON_APPLICATION_SAVE_STATE_INTERVAL_SECONDS (60 * 5)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_APPLICATION_0_PROPERTY,
	BREAK_TIMER_DAEMON_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_application_properties[BREAK_TIMER_DAEMON_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _BreakTimerDaemonApplicationSaveStateData BreakTimerDaemonApplicationSaveStateData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BreakTimerDaemonApplicationPrivate {
	BreakTimerDaemonBreakManager* break_manager;
	BreakTimerDaemonSessionStatus* session_status;
	BreakTimerDaemonActivityActivityMonitorBackend* activity_monitor_backend;
	BreakTimerDaemonActivityActivityMonitor* activity_monitor;
	BreakTimerDaemonUIManager* ui_manager;
	guint save_state_timeout_id;
	gchar* cache_path;
	gint64 state_saved_time_ms;
	gboolean is_activated;
};

struct _BreakTimerDaemonApplicationSaveStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BreakTimerDaemonApplication* self;
	gint64 now;
	GFile* state_file;
	GFile* _tmp0_;
	JsonGenerator* generator;
	JsonGenerator* _tmp1_;
	JsonNode* root;
	JsonNode* _tmp2_;
	JsonObject* root_object;
	JsonObject* _tmp3_;
	JsonNode* _tmp4_;
	JsonObject* _tmp5_;
	JsonGenerator* _tmp6_;
	JsonNode* _tmp7_;
	JsonObject* _tmp8_;
	BreakTimerDaemonBreakManager* _tmp9_;
	JsonObject* _tmp10_;
	JsonObject* _tmp11_;
	BreakTimerDaemonActivityActivityMonitorBackend* _tmp12_;
	JsonObject* _tmp13_;
	JsonObject* _tmp14_;
	BreakTimerDaemonActivityActivityMonitor* _tmp15_;
	JsonObject* _tmp16_;
	GOutputStream* state_stream;
	GFile* _tmp17_;
	GFileOutputStream* _tmp18_;
	JsonGenerator* _tmp19_;
	GOutputStream* _tmp20_;
	GError* e;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError* _inner_error0_;
};

static gint BreakTimerDaemonApplication_private_offset;
static gpointer break_timer_daemon_application_parent_class = NULL;

static void _break_timer_daemon_application_on_query_end_cb_gtk_application_query_end (GtkApplication* _sender,
                                                                                gpointer self);
static void break_timer_daemon_application_real_startup (GApplication* base);
static void break_timer_daemon_application_on_dismiss_break_activate_cb (BreakTimerDaemonApplication* self,
                                                                  GSimpleAction* action,
                                                                  GVariant* parameter);
static void _break_timer_daemon_application_on_dismiss_break_activate_cb_g_simple_action_activate (GSimpleAction* _sender,
                                                                                            GVariant* parameter,
                                                                                            gpointer self);
static void break_timer_daemon_application_on_show_break_info_activate_cb (BreakTimerDaemonApplication* self,
                                                                    GSimpleAction* action,
                                                                    GVariant* parameter);
static void _break_timer_daemon_application_on_show_break_info_activate_cb_g_simple_action_activate (GSimpleAction* _sender,
                                                                                              GVariant* parameter,
                                                                                              gpointer self);
static void break_timer_daemon_application_restore_state (BreakTimerDaemonApplication* self);
static void break_timer_daemon_application_start_save_state_timeout (BreakTimerDaemonApplication* self);
static void break_timer_daemon_application_real_activate (GApplication* base);
static void break_timer_daemon_application_show_break_info (BreakTimerDaemonApplication* self);
static gboolean break_timer_daemon_application_save_state_timeout_cb (BreakTimerDaemonApplication* self);
static gboolean _break_timer_daemon_application_save_state_timeout_cb_gsource_func (gpointer self);
static void break_timer_daemon_application_save_state (BreakTimerDaemonApplication* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void break_timer_daemon_application_save_state_finish (BreakTimerDaemonApplication* self,
                                                       GAsyncResult* _res_);
static gboolean __lambda17_ (BreakTimerDaemonApplication* self);
static gboolean ___lambda17__gsource_func (gpointer self);
static gboolean __lambda16_ (BreakTimerDaemonApplication* self);
static gboolean ___lambda16__gsource_func (gpointer self);
static GFile* break_timer_daemon_application_get_state_file (BreakTimerDaemonApplication* self);
static void break_timer_daemon_application_save_state_data_free (gpointer _data);
static gboolean break_timer_daemon_application_save_state_co (BreakTimerDaemonApplicationSaveStateData* _data_);
static void break_timer_daemon_application_save_state_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void break_timer_daemon_application_finalize (GObject * obj);
static GType break_timer_daemon_application_get_type_once (void);

static inline gpointer
break_timer_daemon_application_get_instance_private (BreakTimerDaemonApplication* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonApplication_private_offset);
}

static void
_break_timer_daemon_application_on_query_end_cb_gtk_application_query_end (GtkApplication* _sender,
                                                                           gpointer self)
{
	break_timer_daemon_application_on_query_end_cb ((BreakTimerDaemonApplication*) self);
}

BreakTimerDaemonApplication*
break_timer_daemon_application_construct (GType object_type)
{
	BreakTimerDaemonApplication * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (BreakTimerDaemonApplication*) g_object_new (object_type, "application-id", DAEMON_APPLICATION_ID, "flags", G_APPLICATION_FLAGS_NONE, "inactivity-timeout", BREAK_TIMER_DAEMON_APPLICATION_ACTIVITY_TIMEOUT_MS, "register-session", TRUE, NULL);
	g_set_application_name (BREAK_TIMER_DAEMON_APPLICATION_app_name);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-break-timer", NULL);
	_g_free0 (self->priv->cache_path);
	self->priv->cache_path = _tmp1_;
	self->priv->state_saved_time_ms = (gint64) 0;
	g_signal_connect_object ((GtkApplication*) self, "query-end", (GCallback) _break_timer_daemon_application_on_query_end_cb_gtk_application_query_end, self, 0);
	return self;
}

BreakTimerDaemonApplication*
break_timer_daemon_application_new (void)
{
	return break_timer_daemon_application_construct (BREAK_TIMER_DAEMON_TYPE_APPLICATION);
}

static void
_break_timer_daemon_application_on_dismiss_break_activate_cb_g_simple_action_activate (GSimpleAction* _sender,
                                                                                       GVariant* parameter,
                                                                                       gpointer self)
{
	break_timer_daemon_application_on_dismiss_break_activate_cb ((BreakTimerDaemonApplication*) self, _sender, parameter);
}

static void
_break_timer_daemon_application_on_show_break_info_activate_cb_g_simple_action_activate (GSimpleAction* _sender,
                                                                                         GVariant* parameter,
                                                                                         gpointer self)
{
	break_timer_daemon_application_on_show_break_info_activate_cb ((BreakTimerDaemonApplication*) self, _sender, parameter);
}

static void
break_timer_daemon_application_real_startup (GApplication* base)
{
	BreakTimerDaemonApplication * self;
	GSimpleAction* dismiss_break_action = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* show_break_info_action = NULL;
	GSimpleAction* _tmp4_;
	BreakTimerDaemonSessionStatus* _tmp5_;
	BreakTimerDaemonActivityMutterActivityMonitorBackend* _tmp8_;
	BreakTimerDaemonSessionStatus* _tmp11_;
	BreakTimerDaemonActivityActivityMonitorBackend* _tmp12_;
	BreakTimerDaemonActivityActivityMonitor* _tmp13_;
	BreakTimerDaemonSessionStatus* _tmp16_;
	BreakTimerDaemonUIManager* _tmp17_;
	BreakTimerDaemonUIManager* _tmp20_;
	BreakTimerDaemonActivityActivityMonitor* _tmp21_;
	BreakTimerDaemonBreakManager* _tmp22_;
	BreakTimerDaemonActivityActivityMonitor* _tmp25_;
	GError* _inner_error0_ = NULL;
	self = (BreakTimerDaemonApplication*) base;
	G_APPLICATION_CLASS (break_timer_daemon_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	self->priv->is_activated = FALSE;
	_tmp0_ = g_variant_type_new ("s");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_simple_action_new ("dismiss-break", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	dismiss_break_action = _tmp3_;
	g_action_map_add_action ((GActionMap*) self, (GAction*) dismiss_break_action);
	g_signal_connect_object (dismiss_break_action, "activate", (GCallback) _break_timer_daemon_application_on_dismiss_break_activate_cb_g_simple_action_activate, self, 0);
	_tmp4_ = g_simple_action_new ("show-break-info", NULL);
	show_break_info_action = _tmp4_;
	g_action_map_add_action ((GActionMap*) self, (GAction*) show_break_info_action);
	g_signal_connect_object (show_break_info_action, "activate", (GCallback) _break_timer_daemon_application_on_show_break_info_activate_cb_g_simple_action_activate, self, 0);
	_tmp5_ = break_timer_daemon_session_status_new ();
	_g_object_unref0 (self->priv->session_status);
	self->priv->session_status = _tmp5_;
	{
		BreakTimerDaemonSessionStatus* _tmp6_;
		_tmp6_ = self->priv->session_status;
		g_initable_init ((GInitable*) _tmp6_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp7_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = _error_->message;
		g_error ("Application.vala:89: Error initializing session_status: %s", _tmp7_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (show_break_info_action);
		_g_object_unref0 (dismiss_break_action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = break_timer_daemon_activity_mutter_activity_monitor_backend_new ();
	_g_object_unref0 (self->priv->activity_monitor_backend);
	self->priv->activity_monitor_backend = (BreakTimerDaemonActivityActivityMonitorBackend*) _tmp8_;
	{
		BreakTimerDaemonActivityActivityMonitorBackend* _tmp9_;
		_tmp9_ = self->priv->activity_monitor_backend;
		break_timer_daemon_activity_activity_monitor_backend_init (_tmp9_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp10_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_->message;
		g_error ("Application.vala:96: Error initializing activity_monitor_backend: %s", _tmp10_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (show_break_info_action);
		_g_object_unref0 (dismiss_break_action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp11_ = self->priv->session_status;
	_tmp12_ = self->priv->activity_monitor_backend;
	_tmp13_ = break_timer_daemon_activity_activity_monitor_new ((BreakTimerCommonISessionStatus*) _tmp11_, _tmp12_);
	_g_object_unref0 (self->priv->activity_monitor);
	self->priv->activity_monitor = _tmp13_;
	{
		BreakTimerDaemonActivityActivityMonitor* _tmp14_;
		_tmp14_ = self->priv->activity_monitor;
		g_initable_init ((GInitable*) _tmp14_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp15_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = _error_->message;
		g_error ("Application.vala:103: Error initializing activity_monitor: %s", _tmp15_);
		_g_error_free0 (_error_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (show_break_info_action);
		_g_object_unref0 (dismiss_break_action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp16_ = self->priv->session_status;
	_tmp17_ = break_timer_daemon_ui_manager_new ((GtkApplication*) self, (BreakTimerCommonISessionStatus*) _tmp16_);
	_g_object_unref0 (self->priv->ui_manager);
	self->priv->ui_manager = _tmp17_;
	{
		BreakTimerDaemonUIManager* _tmp18_;
		_tmp18_ = self->priv->ui_manager;
		g_initable_init ((GInitable*) _tmp18_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp19_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = _error_->message;
		g_error ("Application.vala:110: Error initializing ui_manager: %s", _tmp19_);
		_g_error_free0 (_error_);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (show_break_info_action);
		_g_object_unref0 (dismiss_break_action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp20_ = self->priv->ui_manager;
	_tmp21_ = self->priv->activity_monitor;
	_tmp22_ = break_timer_daemon_break_manager_new (_tmp20_, _tmp21_);
	_g_object_unref0 (self->priv->break_manager);
	self->priv->break_manager = _tmp22_;
	{
		BreakTimerDaemonBreakManager* _tmp23_;
		_tmp23_ = self->priv->break_manager;
		g_initable_init ((GInitable*) _tmp23_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp24_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = _error_->message;
		g_error ("Application.vala:117: Error initializing break_manager: %s", _tmp24_);
		_g_error_free0 (_error_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (show_break_info_action);
		_g_object_unref0 (dismiss_break_action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	break_timer_daemon_application_restore_state (self);
	break_timer_daemon_application_start_save_state_timeout (self);
	_tmp25_ = self->priv->activity_monitor;
	break_timer_daemon_activity_activity_monitor_start (_tmp25_);
	_g_object_unref0 (show_break_info_action);
	_g_object_unref0 (dismiss_break_action);
}

/**
     * Open the settings app when activated, for example when the the user
     * chooses Break Timer from the Background Apps section in GNOME Shell.
     * Unfortunately, we are unable to tell the difference between that type of
     * activation, D-Bus activation during session start, and the GApplication
     * activate signal firing when the app starts normally. We will work around
     * that by always ignoring the first call to activate, and by not using
     * D-Bus activation in the daemon's autostart file.
     */
static void
break_timer_daemon_application_real_activate (GApplication* base)
{
	BreakTimerDaemonApplication * self;
	BreakTimerDaemonBreakManager* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (BreakTimerDaemonApplication*) base;
	G_APPLICATION_CLASS (break_timer_daemon_application_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	if (!self->priv->is_activated) {
		self->priv->is_activated = TRUE;
		return;
	}
	_tmp0_ = self->priv->break_manager;
	_tmp1_ = break_timer_daemon_break_manager_get_autostart_version (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 1) {
		break_timer_daemon_application_show_break_info (self);
	}
}

static gboolean
_break_timer_daemon_application_save_state_timeout_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = break_timer_daemon_application_save_state_timeout_cb ((BreakTimerDaemonApplication*) self);
	return result;
}

static void
break_timer_daemon_application_start_save_state_timeout (BreakTimerDaemonApplication* self)
{
	g_return_if_fail (self != NULL);
	_vala_assert (self->priv->save_state_timeout_id == ((guint) 0), "this.save_state_timeout_id == 0");
	self->priv->save_state_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) BREAK_TIMER_DAEMON_APPLICATION_SAVE_STATE_INTERVAL_SECONDS, _break_timer_daemon_application_save_state_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
break_timer_daemon_application_save_state_timeout_cb (BreakTimerDaemonApplication* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	break_timer_daemon_application_save_state (self, NULL, NULL);
	result = G_SOURCE_CONTINUE;
	return result;
}

static void
break_timer_daemon_application_on_dismiss_break_activate_cb (BreakTimerDaemonApplication* self,
                                                             GSimpleAction* action,
                                                             GVariant* parameter)
{
	BreakTimerDaemonBreakBreakType* break_type = NULL;
	BreakTimerDaemonBreakManager* _tmp0_;
	const gchar* _tmp1_;
	BreakTimerDaemonBreakBreakType* _tmp2_;
	BreakTimerDaemonBreakBreakType* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->break_manager;
	_tmp1_ = g_variant_get_string (parameter, NULL);
	_tmp2_ = break_timer_daemon_break_manager_get_break_type_for_name (_tmp0_, _tmp1_);
	break_type = _tmp2_;
	_tmp3_ = break_type;
	if (_tmp3_ != NULL) {
		BreakTimerDaemonBreakBreakType* _tmp4_;
		BreakTimerDaemonBreakBreakView* _tmp5_;
		BreakTimerDaemonBreakBreakView* _tmp6_;
		_tmp4_ = break_type;
		_tmp5_ = break_timer_daemon_break_break_type_get_break_view (_tmp4_);
		_tmp6_ = _tmp5_;
		break_timer_daemon_break_break_view_dismiss_break (_tmp6_);
	}
	_g_object_unref0 (break_type);
}

static gboolean
__lambda17_ (BreakTimerDaemonApplication* self)
{
	gboolean result;
	break_timer_daemon_application_show_break_info (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda17_ ((BreakTimerDaemonApplication*) self);
	return result;
}

static void
break_timer_daemon_application_on_show_break_info_activate_cb (BreakTimerDaemonApplication* self,
                                                               GSimpleAction* action,
                                                               GVariant* parameter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_idle_add_full (G_PRIORITY_HIGH_IDLE, ___lambda17__gsource_func, g_object_ref (self), g_object_unref);
}

static void
break_timer_daemon_application_show_break_info (BreakTimerDaemonApplication* self)
{
	GAppInfo* settings_app_info = NULL;
	GDesktopAppInfo* _tmp0_;
	GAppLaunchContext* app_launch_context = NULL;
	GAppLaunchContext* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_desktop_app_info_new (SETTINGS_APPLICATION_ID ".desktop");
	settings_app_info = (GAppInfo*) _tmp0_;
	_tmp1_ = g_app_launch_context_new ();
	app_launch_context = _tmp1_;
	{
		g_app_info_launch (settings_app_info, NULL, app_launch_context, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_warning ("Application.vala:190: Error launching settings application: %s", _tmp3_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (app_launch_context);
		_g_object_unref0 (settings_app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (app_launch_context);
	_g_object_unref0 (settings_app_info);
}

static gboolean
__lambda16_ (BreakTimerDaemonApplication* self)
{
	gboolean result;
	break_timer_daemon_application_save_state (self, NULL, NULL);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda16__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda16_ ((BreakTimerDaemonApplication*) self);
	return result;
}

void
break_timer_daemon_application_on_query_end_cb (BreakTimerDaemonApplication* self)
{
	g_return_if_fail (self != NULL);
	g_idle_add_full (G_PRIORITY_HIGH_IDLE, ___lambda16__gsource_func, g_object_ref (self), g_object_unref);
}

static GFile*
break_timer_daemon_application_get_state_file (BreakTimerDaemonApplication* self)
{
	GFile* cache_dir = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gchar* state_file_name = NULL;
	gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cache_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	cache_dir = _tmp1_;
	{
		GFile* _tmp2_;
		_tmp2_ = cache_dir;
		if (!g_file_query_exists (_tmp2_, NULL)) {
			GFile* _tmp3_;
			_tmp3_ = cache_dir;
			g_file_make_directory_with_parents (_tmp3_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("Application.vala:211: Error creating cache directory: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (cache_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = g_strdup_printf ("last-state-%d.json", BREAK_TIMER_DAEMON_APPLICATION_DATA_VERSION);
	state_file_name = _tmp6_;
	_tmp7_ = cache_dir;
	_tmp8_ = g_file_get_child (_tmp7_, state_file_name);
	result = _tmp8_;
	_g_free0 (state_file_name);
	_g_object_unref0 (cache_dir);
	return result;
}

static void
break_timer_daemon_application_save_state_data_free (gpointer _data)
{
	BreakTimerDaemonApplicationSaveStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BreakTimerDaemonApplicationSaveStateData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
break_timer_daemon_application_save_state (BreakTimerDaemonApplication* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	BreakTimerDaemonApplicationSaveStateData* _data_;
	BreakTimerDaemonApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BreakTimerDaemonApplicationSaveStateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, break_timer_daemon_application_save_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	break_timer_daemon_application_save_state_co (_data_);
}

static void
break_timer_daemon_application_save_state_finish (BreakTimerDaemonApplication* self,
                                                  GAsyncResult* _res_)
{
	BreakTimerDaemonApplicationSaveStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
break_timer_daemon_application_save_state_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	BreakTimerDaemonApplicationSaveStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	break_timer_daemon_application_save_state_co (_data_);
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static gboolean
break_timer_daemon_application_save_state_co (BreakTimerDaemonApplicationSaveStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->now = break_timer_common_time_unit_get_monotonic_time_ms ();
	if ((_data_->now - _data_->self->priv->state_saved_time_ms) < ((gint64) BREAK_TIMER_DAEMON_APPLICATION_SAVE_STATE_EXPIRY_MS)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->self->priv->state_saved_time_ms = _data_->now;
	}
	_data_->_tmp0_ = break_timer_daemon_application_get_state_file (_data_->self);
	_data_->state_file = _data_->_tmp0_;
	_data_->_tmp1_ = json_generator_new ();
	_data_->generator = _data_->_tmp1_;
	_data_->_tmp2_ = json_node_new (JSON_NODE_OBJECT);
	_data_->root = _data_->_tmp2_;
	_data_->_tmp3_ = json_object_new ();
	_data_->root_object = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->root;
	_data_->_tmp5_ = _data_->root_object;
	json_node_set_object (_data_->_tmp4_, _data_->_tmp5_);
	_data_->_tmp6_ = _data_->generator;
	_data_->_tmp7_ = _data_->root;
	json_generator_set_root (_data_->_tmp6_, _data_->_tmp7_);
	_data_->_tmp8_ = _data_->root_object;
	_data_->_tmp9_ = _data_->self->priv->break_manager;
	_data_->_tmp10_ = break_timer_daemon_break_manager_serialize (_data_->_tmp9_);
	json_object_set_object_member (_data_->_tmp8_, "break_manager", _data_->_tmp10_);
	_data_->_tmp11_ = _data_->root_object;
	_data_->_tmp12_ = _data_->self->priv->activity_monitor_backend;
	_data_->_tmp13_ = break_timer_daemon_activity_activity_monitor_backend_serialize (_data_->_tmp12_);
	json_object_set_object_member (_data_->_tmp11_, "activity_monitor_backend", _data_->_tmp13_);
	_data_->_tmp14_ = _data_->root_object;
	_data_->_tmp15_ = _data_->self->priv->activity_monitor;
	_data_->_tmp16_ = break_timer_daemon_activity_activity_monitor_serialize (_data_->_tmp15_);
	json_object_set_object_member (_data_->_tmp14_, "activity_monitor", _data_->_tmp16_);
	{
		_data_->_tmp17_ = _data_->state_file;
		_data_->_state_ = 1;
		g_file_replace_async (_data_->_tmp17_, NULL, FALSE, G_FILE_CREATE_NONE, G_PRIORITY_DEFAULT, NULL, break_timer_daemon_application_save_state_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp18_ = g_file_replace_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
		_data_->state_stream = (GOutputStream*) _data_->_tmp18_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp19_ = _data_->generator;
		_data_->_tmp20_ = _data_->state_stream;
		json_generator_to_stream (_data_->_tmp19_, _data_->_tmp20_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->state_stream);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->state_stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp21_ = _data_->e;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_warning ("Application.vala:242: Error writing to state file: %s", _data_->_tmp22_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_json_object_unref0 (_data_->root_object);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->generator);
		_g_object_unref0 (_data_->state_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_json_object_unref0 (_data_->root_object);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->generator);
	_g_object_unref0 (_data_->state_file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
break_timer_daemon_application_restore_state (BreakTimerDaemonApplication* self)
{
	GFile* state_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = break_timer_daemon_application_get_state_file (self);
	state_file = _tmp0_;
	_tmp1_ = state_file;
	if (g_file_query_exists (_tmp1_, NULL)) {
		JsonParser* parser = NULL;
		JsonParser* _tmp2_;
		JsonNode* root = NULL;
		JsonParser* _tmp9_;
		JsonNode* _tmp10_;
		JsonNode* _tmp11_;
		JsonNode* _tmp12_;
		_tmp2_ = json_parser_new ();
		parser = _tmp2_;
		{
			GInputStream* state_stream = NULL;
			GFile* _tmp3_;
			GFileInputStream* _tmp4_;
			JsonParser* _tmp5_;
			GInputStream* _tmp6_;
			_tmp3_ = state_file;
			_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error0_);
			state_stream = (GInputStream*) _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = parser;
			_tmp6_ = state_stream;
			json_parser_load_from_stream (_tmp5_, _tmp6_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (state_stream);
				goto __catch0_g_error;
			}
			_g_object_unref0 (state_stream);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning ("Application.vala:255: Error reading state file: %s", _tmp8_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parser);
			_g_object_unref0 (state_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp9_ = parser;
		_tmp10_ = json_parser_get_root (_tmp9_);
		_tmp11_ = __vala_JsonNode_copy0 (_tmp10_);
		root = _tmp11_;
		_tmp12_ = root;
		if (_tmp12_ != NULL) {
			JsonObject* root_object = NULL;
			JsonNode* _tmp13_;
			JsonObject* _tmp14_;
			JsonObject* _tmp15_;
			JsonObject* break_manager_json = NULL;
			JsonObject* _tmp16_;
			JsonObject* _tmp17_;
			JsonObject* _tmp18_;
			BreakTimerDaemonBreakManager* _tmp19_;
			JsonObject* activity_monitor_backend_json = NULL;
			JsonObject* _tmp20_;
			JsonObject* _tmp21_;
			JsonObject* _tmp22_;
			BreakTimerDaemonActivityActivityMonitorBackend* _tmp23_;
			JsonObject* activity_monitor_json = NULL;
			JsonObject* _tmp24_;
			JsonObject* _tmp25_;
			JsonObject* _tmp26_;
			BreakTimerDaemonActivityActivityMonitor* _tmp27_;
			BreakTimerDaemonActivityActivityMonitor* _tmp28_;
			_tmp13_ = root;
			_tmp14_ = json_node_get_object (_tmp13_);
			_tmp15_ = _json_object_ref0 (_tmp14_);
			root_object = _tmp15_;
			_tmp16_ = root_object;
			_tmp17_ = json_object_get_object_member (_tmp16_, "break_manager");
			_tmp18_ = _json_object_ref0 (_tmp17_);
			break_manager_json = _tmp18_;
			_tmp19_ = self->priv->break_manager;
			break_timer_daemon_break_manager_deserialize (_tmp19_, &break_manager_json);
			_tmp20_ = root_object;
			_tmp21_ = json_object_get_object_member (_tmp20_, "activity_monitor_backend");
			_tmp22_ = _json_object_ref0 (_tmp21_);
			activity_monitor_backend_json = _tmp22_;
			_tmp23_ = self->priv->activity_monitor_backend;
			break_timer_daemon_activity_activity_monitor_backend_deserialize (_tmp23_, &activity_monitor_backend_json);
			_tmp24_ = root_object;
			_tmp25_ = json_object_get_object_member (_tmp24_, "activity_monitor");
			_tmp26_ = _json_object_ref0 (_tmp25_);
			activity_monitor_json = _tmp26_;
			_tmp27_ = self->priv->activity_monitor;
			break_timer_daemon_activity_activity_monitor_deserialize (_tmp27_, &activity_monitor_json);
			_tmp28_ = self->priv->activity_monitor;
			break_timer_daemon_activity_activity_monitor_poll_activity (_tmp28_);
			_json_object_unref0 (activity_monitor_json);
			_json_object_unref0 (activity_monitor_backend_json);
			_json_object_unref0 (break_manager_json);
			_json_object_unref0 (root_object);
		}
		__vala_JsonNode_free0 (root);
		_g_object_unref0 (parser);
	}
	_g_object_unref0 (state_file);
}

static void
break_timer_daemon_application_class_init (BreakTimerDaemonApplicationClass * klass,
                                           gpointer klass_data)
{
	break_timer_daemon_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonApplication_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) break_timer_daemon_application_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) break_timer_daemon_application_real_activate;
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_application_finalize;
}

static void
break_timer_daemon_application_instance_init (BreakTimerDaemonApplication * self,
                                              gpointer klass)
{
	self->priv = break_timer_daemon_application_get_instance_private (self);
}

static void
break_timer_daemon_application_finalize (GObject * obj)
{
	BreakTimerDaemonApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_TYPE_APPLICATION, BreakTimerDaemonApplication);
	_g_object_unref0 (self->priv->break_manager);
	_g_object_unref0 (self->priv->session_status);
	_g_object_unref0 (self->priv->activity_monitor_backend);
	_g_object_unref0 (self->priv->activity_monitor);
	_g_object_unref0 (self->priv->ui_manager);
	_g_free0 (self->priv->cache_path);
	G_OBJECT_CLASS (break_timer_daemon_application_parent_class)->finalize (obj);
}

static GType
break_timer_daemon_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonApplication), 0, (GInstanceInitFunc) break_timer_daemon_application_instance_init, NULL };
	GType break_timer_daemon_application_type_id;
	break_timer_daemon_application_type_id = g_type_register_static (gtk_application_get_type (), "BreakTimerDaemonApplication", &g_define_type_info, 0);
	BreakTimerDaemonApplication_private_offset = g_type_add_instance_private (break_timer_daemon_application_type_id, sizeof (BreakTimerDaemonApplicationPrivate));
	return break_timer_daemon_application_type_id;
}

GType
break_timer_daemon_application_get_type (void)
{
	static volatile gsize break_timer_daemon_application_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_application_type_id__once)) {
		GType break_timer_daemon_application_type_id;
		break_timer_daemon_application_type_id = break_timer_daemon_application_get_type_once ();
		g_once_init_leave (&break_timer_daemon_application_type_id__once, break_timer_daemon_application_type_id);
	}
	return break_timer_daemon_application_type_id__once;
}

