/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gs-epiphany-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_url,
        const gchar *arg_name,
        const gchar *arg_install_token,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_desktop_file_id,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Epiphany.WebAppProvider
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GsEphyWebAppProvider
 * @title: GsEphyWebAppProvider
 * @short_description: Generated C code for the org.gnome.Epiphany.WebAppProvider D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Epiphany-WebAppProvider.top_of_page">org.gnome.Epiphany.WebAppProvider</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Epiphany.WebAppProvider ---- */

static const _ExtendedGDBusArgInfo _gs_ephy_web_app_provider_method_info_get_installed_apps_OUT_ARG_webapps =
{
  {
    -1,
    (gchar *) "webapps",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gs_ephy_web_app_provider_method_info_get_installed_apps_OUT_ARG_pointers[] =
{
  &_gs_ephy_web_app_provider_method_info_get_installed_apps_OUT_ARG_webapps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gs_ephy_web_app_provider_method_info_get_installed_apps =
{
  {
    -1,
    (gchar *) "GetInstalledApps",
    NULL,
    (GDBusArgInfo **) &_gs_ephy_web_app_provider_method_info_get_installed_apps_OUT_ARG_pointers,
    NULL
  },
  "handle-get-installed-apps",
  FALSE
};

static const _ExtendedGDBusArgInfo _gs_ephy_web_app_provider_method_info_install_IN_ARG_url =
{
  {
    -1,
    (gchar *) "url",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gs_ephy_web_app_provider_method_info_install_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gs_ephy_web_app_provider_method_info_install_IN_ARG_install_token =
{
  {
    -1,
    (gchar *) "install_token",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gs_ephy_web_app_provider_method_info_install_IN_ARG_pointers[] =
{
  &_gs_ephy_web_app_provider_method_info_install_IN_ARG_url.parent_struct,
  &_gs_ephy_web_app_provider_method_info_install_IN_ARG_name.parent_struct,
  &_gs_ephy_web_app_provider_method_info_install_IN_ARG_install_token.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gs_ephy_web_app_provider_method_info_install_OUT_ARG_desktop_file_id =
{
  {
    -1,
    (gchar *) "desktop_file_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gs_ephy_web_app_provider_method_info_install_OUT_ARG_pointers[] =
{
  &_gs_ephy_web_app_provider_method_info_install_OUT_ARG_desktop_file_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gs_ephy_web_app_provider_method_info_install =
{
  {
    -1,
    (gchar *) "Install",
    (GDBusArgInfo **) &_gs_ephy_web_app_provider_method_info_install_IN_ARG_pointers,
    (GDBusArgInfo **) &_gs_ephy_web_app_provider_method_info_install_OUT_ARG_pointers,
    NULL
  },
  "handle-install",
  FALSE
};

static const _ExtendedGDBusArgInfo _gs_ephy_web_app_provider_method_info_uninstall_IN_ARG_desktop_file_id =
{
  {
    -1,
    (gchar *) "desktop_file_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gs_ephy_web_app_provider_method_info_uninstall_IN_ARG_pointers[] =
{
  &_gs_ephy_web_app_provider_method_info_uninstall_IN_ARG_desktop_file_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gs_ephy_web_app_provider_method_info_uninstall =
{
  {
    -1,
    (gchar *) "Uninstall",
    (GDBusArgInfo **) &_gs_ephy_web_app_provider_method_info_uninstall_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-uninstall",
  FALSE
};

static const GDBusMethodInfo * const _gs_ephy_web_app_provider_method_info_pointers[] =
{
  &_gs_ephy_web_app_provider_method_info_get_installed_apps.parent_struct,
  &_gs_ephy_web_app_provider_method_info_install.parent_struct,
  &_gs_ephy_web_app_provider_method_info_uninstall.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _gs_ephy_web_app_provider_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _gs_ephy_web_app_provider_property_info_pointers[] =
{
  &_gs_ephy_web_app_provider_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gs_ephy_web_app_provider_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Epiphany.WebAppProvider",
    (GDBusMethodInfo **) &_gs_ephy_web_app_provider_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_gs_ephy_web_app_provider_property_info_pointers,
    NULL
  },
  "web-app-provider",
};


/**
 * gs_ephy_web_app_provider_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Epiphany-WebAppProvider.top_of_page">org.gnome.Epiphany.WebAppProvider</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gs_ephy_web_app_provider_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gs_ephy_web_app_provider_interface_info.parent_struct;
}

/**
 * gs_ephy_web_app_provider_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GsEphyWebAppProvider interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gs_ephy_web_app_provider_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}


inline static void
gs_ephy_web_app_provider_method_marshal_get_installed_apps (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gs_ephy_web_app_provider_method_marshal_install (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gs_ephy_web_app_provider_method_marshal_uninstall (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GsEphyWebAppProvider:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Epiphany-WebAppProvider.top_of_page">org.gnome.Epiphany.WebAppProvider</link>.
 */

/**
 * GsEphyWebAppProviderIface:
 * @parent_iface: The parent interface.
 * @handle_get_installed_apps: Handler for the #GsEphyWebAppProvider::handle-get-installed-apps signal.
 * @handle_install: Handler for the #GsEphyWebAppProvider::handle-install signal.
 * @handle_uninstall: Handler for the #GsEphyWebAppProvider::handle-uninstall signal.
 * @get_version: Getter for the #GsEphyWebAppProvider:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Epiphany-WebAppProvider.top_of_page">org.gnome.Epiphany.WebAppProvider</link>.
 */

typedef GsEphyWebAppProviderIface GsEphyWebAppProviderInterface;
G_DEFINE_INTERFACE (GsEphyWebAppProvider, gs_ephy_web_app_provider, G_TYPE_OBJECT)

static void
gs_ephy_web_app_provider_default_init (GsEphyWebAppProviderIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GsEphyWebAppProvider::handle-get-installed-apps:
   * @object: A #GsEphyWebAppProvider.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.GetInstalledApps">GetInstalledApps()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gs_ephy_web_app_provider_complete_get_installed_apps() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-installed-apps",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsEphyWebAppProviderIface, handle_get_installed_apps),
    g_signal_accumulator_true_handled,
    NULL,
      gs_ephy_web_app_provider_method_marshal_get_installed_apps,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GsEphyWebAppProvider::handle-install:
   * @object: A #GsEphyWebAppProvider.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_url: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   * @arg_install_token: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.Install">Install()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gs_ephy_web_app_provider_complete_install() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-install",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsEphyWebAppProviderIface, handle_install),
    g_signal_accumulator_true_handled,
    NULL,
      gs_ephy_web_app_provider_method_marshal_install,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GsEphyWebAppProvider::handle-uninstall:
   * @object: A #GsEphyWebAppProvider.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_desktop_file_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.Uninstall">Uninstall()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gs_ephy_web_app_provider_complete_uninstall() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-uninstall",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GsEphyWebAppProviderIface, handle_uninstall),
    g_signal_accumulator_true_handled,
    NULL,
      gs_ephy_web_app_provider_method_marshal_uninstall,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * GsEphyWebAppProvider:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Epiphany-WebAppProvider.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "Version", "Version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gs_ephy_web_app_provider_get_version: (skip)
 * @object: A #GsEphyWebAppProvider.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Epiphany-WebAppProvider.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
gs_ephy_web_app_provider_get_version (GsEphyWebAppProvider *object)
{
  g_return_val_if_fail (GS_EPHY_IS_WEB_APP_PROVIDER (object), 0);

  return GS_EPHY_WEB_APP_PROVIDER_GET_IFACE (object)->get_version (object);
}

/**
 * gs_ephy_web_app_provider_set_version: (skip)
 * @object: A #GsEphyWebAppProvider.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Epiphany-WebAppProvider.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gs_ephy_web_app_provider_set_version (GsEphyWebAppProvider *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * gs_ephy_web_app_provider_call_get_installed_apps:
 * @proxy: A #GsEphyWebAppProviderProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.GetInstalledApps">GetInstalledApps()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gs_ephy_web_app_provider_call_get_installed_apps_finish() to get the result of the operation.
 *
 * See gs_ephy_web_app_provider_call_get_installed_apps_sync() for the synchronous, blocking version of this method.
 */
void
gs_ephy_web_app_provider_call_get_installed_apps (
    GsEphyWebAppProvider *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetInstalledApps",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * gs_ephy_web_app_provider_call_get_installed_apps_finish:
 * @proxy: A #GsEphyWebAppProviderProxy.
 * @out_webapps: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gs_ephy_web_app_provider_call_get_installed_apps().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gs_ephy_web_app_provider_call_get_installed_apps().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gs_ephy_web_app_provider_call_get_installed_apps_finish (
    GsEphyWebAppProvider *proxy,
    gchar *** out_webapps,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_webapps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gs_ephy_web_app_provider_call_get_installed_apps_sync:
 * @proxy: A #GsEphyWebAppProviderProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @out_webapps: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.GetInstalledApps">GetInstalledApps()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gs_ephy_web_app_provider_call_get_installed_apps() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gs_ephy_web_app_provider_call_get_installed_apps_sync (
    GsEphyWebAppProvider *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    gchar *** out_webapps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetInstalledApps",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_webapps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gs_ephy_web_app_provider_call_install:
 * @proxy: A #GsEphyWebAppProviderProxy.
 * @arg_url: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_install_token: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.Install">Install()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gs_ephy_web_app_provider_call_install_finish() to get the result of the operation.
 *
 * See gs_ephy_web_app_provider_call_install_sync() for the synchronous, blocking version of this method.
 */
void
gs_ephy_web_app_provider_call_install (
    GsEphyWebAppProvider *proxy,
    const gchar *arg_url,
    const gchar *arg_name,
    const gchar *arg_install_token,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Install",
    g_variant_new ("(sss)",
                   arg_url,
                   arg_name,
                   arg_install_token),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * gs_ephy_web_app_provider_call_install_finish:
 * @proxy: A #GsEphyWebAppProviderProxy.
 * @out_desktop_file_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gs_ephy_web_app_provider_call_install().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gs_ephy_web_app_provider_call_install().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gs_ephy_web_app_provider_call_install_finish (
    GsEphyWebAppProvider *proxy,
    gchar ** out_desktop_file_id,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_desktop_file_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gs_ephy_web_app_provider_call_install_sync:
 * @proxy: A #GsEphyWebAppProviderProxy.
 * @arg_url: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_install_token: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @out_desktop_file_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.Install">Install()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gs_ephy_web_app_provider_call_install() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gs_ephy_web_app_provider_call_install_sync (
    GsEphyWebAppProvider *proxy,
    const gchar *arg_url,
    const gchar *arg_name,
    const gchar *arg_install_token,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    gchar ** out_desktop_file_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Install",
    g_variant_new ("(sss)",
                   arg_url,
                   arg_name,
                   arg_install_token),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_desktop_file_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gs_ephy_web_app_provider_call_uninstall:
 * @proxy: A #GsEphyWebAppProviderProxy.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.Uninstall">Uninstall()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gs_ephy_web_app_provider_call_uninstall_finish() to get the result of the operation.
 *
 * See gs_ephy_web_app_provider_call_uninstall_sync() for the synchronous, blocking version of this method.
 */
void
gs_ephy_web_app_provider_call_uninstall (
    GsEphyWebAppProvider *proxy,
    const gchar *arg_desktop_file_id,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Uninstall",
    g_variant_new ("(s)",
                   arg_desktop_file_id),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * gs_ephy_web_app_provider_call_uninstall_finish:
 * @proxy: A #GsEphyWebAppProviderProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gs_ephy_web_app_provider_call_uninstall().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gs_ephy_web_app_provider_call_uninstall().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gs_ephy_web_app_provider_call_uninstall_finish (
    GsEphyWebAppProvider *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gs_ephy_web_app_provider_call_uninstall_sync:
 * @proxy: A #GsEphyWebAppProviderProxy.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.Uninstall">Uninstall()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gs_ephy_web_app_provider_call_uninstall() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gs_ephy_web_app_provider_call_uninstall_sync (
    GsEphyWebAppProvider *proxy,
    const gchar *arg_desktop_file_id,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Uninstall",
    g_variant_new ("(s)",
                   arg_desktop_file_id),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gs_ephy_web_app_provider_complete_get_installed_apps:
 * @object: A #GsEphyWebAppProvider.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @webapps: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.GetInstalledApps">GetInstalledApps()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gs_ephy_web_app_provider_complete_get_installed_apps (
    GsEphyWebAppProvider *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *webapps)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   webapps));
}

/**
 * gs_ephy_web_app_provider_complete_install:
 * @object: A #GsEphyWebAppProvider.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @desktop_file_id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.Install">Install()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gs_ephy_web_app_provider_complete_install (
    GsEphyWebAppProvider *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *desktop_file_id)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   desktop_file_id));
}

/**
 * gs_ephy_web_app_provider_complete_uninstall:
 * @object: A #GsEphyWebAppProvider.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Epiphany-WebAppProvider.Uninstall">Uninstall()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gs_ephy_web_app_provider_complete_uninstall (
    GsEphyWebAppProvider *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GsEphyWebAppProviderProxy:
 *
 * The #GsEphyWebAppProviderProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsEphyWebAppProviderProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsEphyWebAppProviderProxy.
 */

struct _GsEphyWebAppProviderProxyPrivate
{
  GData *qdata;
};

static void gs_ephy_web_app_provider_proxy_iface_init (GsEphyWebAppProviderIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsEphyWebAppProviderProxy, gs_ephy_web_app_provider_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GsEphyWebAppProviderProxy)
                         G_IMPLEMENT_INTERFACE (GS_EPHY_TYPE_WEB_APP_PROVIDER, gs_ephy_web_app_provider_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsEphyWebAppProviderProxy, gs_ephy_web_app_provider_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GS_EPHY_TYPE_WEB_APP_PROVIDER, gs_ephy_web_app_provider_proxy_iface_init))

#endif
static void
gs_ephy_web_app_provider_proxy_finalize (GObject *object)
{
  GsEphyWebAppProviderProxy *proxy = GS_EPHY_WEB_APP_PROVIDER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gs_ephy_web_app_provider_proxy_parent_class)->finalize (object);
}

static void
gs_ephy_web_app_provider_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _gs_ephy_web_app_provider_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gs_ephy_web_app_provider_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Epiphany.WebAppProvider: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gs_ephy_web_app_provider_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _gs_ephy_web_app_provider_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Epiphany.WebAppProvider", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gs_ephy_web_app_provider_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gs_ephy_web_app_provider_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gs_ephy_web_app_provider_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GS_EPHY_TYPE_WEB_APP_PROVIDER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GS_EPHY_TYPE_WEB_APP_PROVIDER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gs_ephy_web_app_provider_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GsEphyWebAppProviderProxy *proxy = GS_EPHY_WEB_APP_PROVIDER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gs_ephy_web_app_provider_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gs_ephy_web_app_provider_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
gs_ephy_web_app_provider_proxy_get_version (GsEphyWebAppProvider *object)
{
  GsEphyWebAppProviderProxy *proxy = GS_EPHY_WEB_APP_PROVIDER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
gs_ephy_web_app_provider_proxy_init (GsEphyWebAppProviderProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gs_ephy_web_app_provider_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GS_EPHY_TYPE_WEB_APP_PROVIDER_PROXY, GsEphyWebAppProviderProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gs_ephy_web_app_provider_interface_info ());
}

static void
gs_ephy_web_app_provider_proxy_class_init (GsEphyWebAppProviderProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gs_ephy_web_app_provider_proxy_finalize;
  gobject_class->get_property = gs_ephy_web_app_provider_proxy_get_property;
  gobject_class->set_property = gs_ephy_web_app_provider_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gs_ephy_web_app_provider_proxy_g_signal;
  proxy_class->g_properties_changed = gs_ephy_web_app_provider_proxy_g_properties_changed;

  gs_ephy_web_app_provider_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsEphyWebAppProviderProxyPrivate));
#endif
}

static void
gs_ephy_web_app_provider_proxy_iface_init (GsEphyWebAppProviderIface *iface)
{
  iface->get_version = gs_ephy_web_app_provider_proxy_get_version;
}

/**
 * gs_ephy_web_app_provider_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Epiphany-WebAppProvider.top_of_page">org.gnome.Epiphany.WebAppProvider</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gs_ephy_web_app_provider_proxy_new_finish() to get the result of the operation.
 *
 * See gs_ephy_web_app_provider_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gs_ephy_web_app_provider_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GS_EPHY_TYPE_WEB_APP_PROVIDER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Epiphany.WebAppProvider", NULL);
}

/**
 * gs_ephy_web_app_provider_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gs_ephy_web_app_provider_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gs_ephy_web_app_provider_proxy_new().
 *
 * Returns: (transfer full) (type GsEphyWebAppProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
GsEphyWebAppProvider *
gs_ephy_web_app_provider_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GS_EPHY_WEB_APP_PROVIDER (ret);
  else
    return NULL;
}

/**
 * gs_ephy_web_app_provider_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Epiphany-WebAppProvider.top_of_page">org.gnome.Epiphany.WebAppProvider</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gs_ephy_web_app_provider_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsEphyWebAppProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
GsEphyWebAppProvider *
gs_ephy_web_app_provider_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GS_EPHY_TYPE_WEB_APP_PROVIDER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Epiphany.WebAppProvider", NULL);
  if (ret != NULL)
    return GS_EPHY_WEB_APP_PROVIDER (ret);
  else
    return NULL;
}


/**
 * gs_ephy_web_app_provider_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gs_ephy_web_app_provider_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gs_ephy_web_app_provider_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gs_ephy_web_app_provider_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gs_ephy_web_app_provider_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GS_EPHY_TYPE_WEB_APP_PROVIDER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Epiphany.WebAppProvider", NULL);
}

/**
 * gs_ephy_web_app_provider_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gs_ephy_web_app_provider_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gs_ephy_web_app_provider_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GsEphyWebAppProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
GsEphyWebAppProvider *
gs_ephy_web_app_provider_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GS_EPHY_WEB_APP_PROVIDER (ret);
  else
    return NULL;
}

/**
 * gs_ephy_web_app_provider_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gs_ephy_web_app_provider_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gs_ephy_web_app_provider_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GsEphyWebAppProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
GsEphyWebAppProvider *
gs_ephy_web_app_provider_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GS_EPHY_TYPE_WEB_APP_PROVIDER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Epiphany.WebAppProvider", NULL);
  if (ret != NULL)
    return GS_EPHY_WEB_APP_PROVIDER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GsEphyWebAppProviderSkeleton:
 *
 * The #GsEphyWebAppProviderSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GsEphyWebAppProviderSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GsEphyWebAppProviderSkeleton.
 */

struct _GsEphyWebAppProviderSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gs_ephy_web_app_provider_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GsEphyWebAppProviderSkeleton *skeleton = GS_EPHY_WEB_APP_PROVIDER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GS_EPHY_TYPE_WEB_APP_PROVIDER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GS_EPHY_TYPE_WEB_APP_PROVIDER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gs_ephy_web_app_provider_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GsEphyWebAppProviderSkeleton *skeleton = GS_EPHY_WEB_APP_PROVIDER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gs_ephy_web_app_provider_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gs_ephy_web_app_provider_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GsEphyWebAppProviderSkeleton *skeleton = GS_EPHY_WEB_APP_PROVIDER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gs_ephy_web_app_provider_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gs_ephy_web_app_provider_skeleton_vtable =
{
  _gs_ephy_web_app_provider_skeleton_handle_method_call,
  _gs_ephy_web_app_provider_skeleton_handle_get_property,
  _gs_ephy_web_app_provider_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gs_ephy_web_app_provider_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gs_ephy_web_app_provider_interface_info ();
}

static GDBusInterfaceVTable *
gs_ephy_web_app_provider_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gs_ephy_web_app_provider_skeleton_vtable;
}

static GVariant *
gs_ephy_web_app_provider_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GsEphyWebAppProviderSkeleton *skeleton = GS_EPHY_WEB_APP_PROVIDER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gs_ephy_web_app_provider_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gs_ephy_web_app_provider_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gs_ephy_web_app_provider_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gs_ephy_web_app_provider_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Epiphany.WebAppProvider", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gs_ephy_web_app_provider_emit_changed (gpointer user_data);

static void
gs_ephy_web_app_provider_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GsEphyWebAppProviderSkeleton *skeleton = GS_EPHY_WEB_APP_PROVIDER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gs_ephy_web_app_provider_emit_changed (skeleton);
}

static void gs_ephy_web_app_provider_skeleton_iface_init (GsEphyWebAppProviderIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GsEphyWebAppProviderSkeleton, gs_ephy_web_app_provider_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GsEphyWebAppProviderSkeleton)
                         G_IMPLEMENT_INTERFACE (GS_EPHY_TYPE_WEB_APP_PROVIDER, gs_ephy_web_app_provider_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GsEphyWebAppProviderSkeleton, gs_ephy_web_app_provider_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GS_EPHY_TYPE_WEB_APP_PROVIDER, gs_ephy_web_app_provider_skeleton_iface_init))

#endif
static void
gs_ephy_web_app_provider_skeleton_finalize (GObject *object)
{
  GsEphyWebAppProviderSkeleton *skeleton = GS_EPHY_WEB_APP_PROVIDER_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  /* coverity[missing_lock : SUPPRESS] */
  g_clear_pointer (&skeleton->priv->changed_properties_idle_source, g_source_destroy);
#else
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
skeleton->priv->changed_properties_idle_source = NULL;
#endif
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gs_ephy_web_app_provider_skeleton_parent_class)->finalize (object);
}

static void
gs_ephy_web_app_provider_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GsEphyWebAppProviderSkeleton *skeleton = GS_EPHY_WEB_APP_PROVIDER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gs_ephy_web_app_provider_emit_changed (gpointer user_data)
{
  GsEphyWebAppProviderSkeleton *skeleton = GS_EPHY_WEB_APP_PROVIDER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Epiphany.WebAppProvider",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gs_ephy_web_app_provider_schedule_emit_changed (GsEphyWebAppProviderSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gs_ephy_web_app_provider_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GsEphyWebAppProviderSkeleton *skeleton = GS_EPHY_WEB_APP_PROVIDER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gs_ephy_web_app_provider_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gs_ephy_web_app_provider_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gs_ephy_web_app_provider_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GsEphyWebAppProviderSkeleton *skeleton = GS_EPHY_WEB_APP_PROVIDER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _gs_ephy_web_app_provider_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _gs_ephy_web_app_provider_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gs_ephy_web_app_provider_skeleton_init (GsEphyWebAppProviderSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gs_ephy_web_app_provider_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GS_EPHY_TYPE_WEB_APP_PROVIDER_SKELETON, GsEphyWebAppProviderSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
gs_ephy_web_app_provider_skeleton_get_version (GsEphyWebAppProvider *object)
{
  GsEphyWebAppProviderSkeleton *skeleton = GS_EPHY_WEB_APP_PROVIDER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gs_ephy_web_app_provider_skeleton_class_init (GsEphyWebAppProviderSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gs_ephy_web_app_provider_skeleton_finalize;
  gobject_class->get_property = gs_ephy_web_app_provider_skeleton_get_property;
  gobject_class->set_property = gs_ephy_web_app_provider_skeleton_set_property;
  gobject_class->notify       = gs_ephy_web_app_provider_skeleton_notify;


  gs_ephy_web_app_provider_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gs_ephy_web_app_provider_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gs_ephy_web_app_provider_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gs_ephy_web_app_provider_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gs_ephy_web_app_provider_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GsEphyWebAppProviderSkeletonPrivate));
#endif
}

static void
gs_ephy_web_app_provider_skeleton_iface_init (GsEphyWebAppProviderIface *iface)
{
  iface->get_version = gs_ephy_web_app_provider_skeleton_get_version;
}

/**
 * gs_ephy_web_app_provider_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Epiphany-WebAppProvider.top_of_page">org.gnome.Epiphany.WebAppProvider</link>.
 *
 * Returns: (transfer full) (type GsEphyWebAppProviderSkeleton): The skeleton object.
 */
GsEphyWebAppProvider *
gs_ephy_web_app_provider_skeleton_new (void)
{
  return GS_EPHY_WEB_APP_PROVIDER (g_object_new (GS_EPHY_TYPE_WEB_APP_PROVIDER_SKELETON, NULL));
}

