/* storage-view-item.c generated by valac 0.56.18, the Vala compiler
 * generated from storage-view-item.vala, do not modify */

/* storage-view-item.vala
 *
 * Copyright (C) 2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Felipe Borges <felipeborges@gnome.org>
 *          Petr Štětka <pstetka@redhat.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	USAGE_STORAGE_VIEW_TYPE_NONE,
	USAGE_STORAGE_VIEW_TYPE_OS,
	USAGE_STORAGE_VIEW_TYPE_UP_FOLDER,
	USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH,
	USAGE_STORAGE_VIEW_TYPE_ROOT_ITEM
} UsageStorageViewType;

#define USAGE_TYPE_STORAGE_VIEW_TYPE (usage_storage_view_type_get_type ())

#define USAGE_TYPE_STORAGE_VIEW_ITEM (usage_storage_view_item_get_type ())
#define USAGE_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItem))
#define USAGE_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))
#define USAGE_IS_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_IS_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_STORAGE_VIEW_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))

typedef struct _UsageStorageViewItem UsageStorageViewItem;
typedef struct _UsageStorageViewItemClass UsageStorageViewItemClass;
typedef struct _UsageStorageViewItemPrivate UsageStorageViewItemPrivate;
enum  {
	USAGE_STORAGE_VIEW_ITEM_0_PROPERTY,
	USAGE_STORAGE_VIEW_ITEM_PERCENTAGE_PROPERTY,
	USAGE_STORAGE_VIEW_ITEM_LOADED_PROPERTY,
	USAGE_STORAGE_VIEW_ITEM_COLOR_PROPERTY,
	USAGE_STORAGE_VIEW_ITEM_STYLE_CLASS_PROPERTY,
	USAGE_STORAGE_VIEW_ITEM_SHOW_CHECK_BUTTON_PROPERTY,
	USAGE_STORAGE_VIEW_ITEM_NUM_PROPERTIES
};
static GParamSpec* usage_storage_view_item_properties[USAGE_STORAGE_VIEW_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _UsageStorageViewItem {
	GObject parent_instance;
	UsageStorageViewItemPrivate * priv;
	gchar* uri;
	gchar* name;
	guint64 size;
	GFileType type;
	GUserDirectory* dir;
	gchar* ontology;
	UsageStorageViewType custom_type;
};

struct _UsageStorageViewItemClass {
	GObjectClass parent_class;
};

struct _UsageStorageViewItemPrivate {
	gdouble _percentage;
	gboolean _loaded;
	GdkRGBA _color;
	gchar* _style_class;
};

static gint UsageStorageViewItem_private_offset;
static gpointer usage_storage_view_item_parent_class = NULL;

VALA_EXTERN GType usage_storage_view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType usage_storage_view_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageViewItem, g_object_unref)
VALA_EXTERN UsageStorageViewItem* usage_storage_view_item_from_file (GFile* file);
VALA_EXTERN UsageStorageViewItem* usage_storage_view_item_new (void);
VALA_EXTERN UsageStorageViewItem* usage_storage_view_item_construct (GType object_type);
static void usage_storage_view_item_setup_tag_style (UsageStorageViewItem* self);
VALA_EXTERN void usage_storage_view_item_set_style_class (UsageStorageViewItem* self,
                                              const gchar* value);
static gboolean _usage_storage_view_item_show_check_button (UsageStorageViewItem* self);
VALA_EXTERN void usage_storage_view_item_get_base_color (UsageStorageViewItem* self,
                                             GdkRGBA* result);
VALA_EXTERN const gchar* usage_storage_view_item_get_style_class (UsageStorageViewItem* self);
VALA_EXTERN gdouble usage_storage_view_item_get_percentage (UsageStorageViewItem* self);
VALA_EXTERN void usage_storage_view_item_set_percentage (UsageStorageViewItem* self,
                                             gdouble value);
VALA_EXTERN gboolean usage_storage_view_item_get_loaded (UsageStorageViewItem* self);
VALA_EXTERN void usage_storage_view_item_set_loaded (UsageStorageViewItem* self,
                                         gboolean value);
VALA_EXTERN void usage_storage_view_item_get_color (UsageStorageViewItem* self,
                                        GdkRGBA * result);
VALA_EXTERN void usage_storage_view_item_set_color (UsageStorageViewItem* self,
                                        GdkRGBA * value);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
VALA_EXTERN gboolean usage_storage_view_item_get_show_check_button (UsageStorageViewItem* self);
static void usage_storage_view_item_finalize (GObject * obj);
static GType usage_storage_view_item_get_type_once (void);
static void _vala_usage_storage_view_item_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_usage_storage_view_item_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
usage_storage_view_type_get_type_once (void)
{
	static const GEnumValue values[] = {{USAGE_STORAGE_VIEW_TYPE_NONE, "USAGE_STORAGE_VIEW_TYPE_NONE", "none"}, {USAGE_STORAGE_VIEW_TYPE_OS, "USAGE_STORAGE_VIEW_TYPE_OS", "os"}, {USAGE_STORAGE_VIEW_TYPE_UP_FOLDER, "USAGE_STORAGE_VIEW_TYPE_UP_FOLDER", "up-folder"}, {USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH, "USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH", "available-graph"}, {USAGE_STORAGE_VIEW_TYPE_ROOT_ITEM, "USAGE_STORAGE_VIEW_TYPE_ROOT_ITEM", "root-item"}, {0, NULL, NULL}};
	GType usage_storage_view_type_type_id;
	usage_storage_view_type_type_id = g_enum_register_static ("UsageStorageViewType", values);
	return usage_storage_view_type_type_id;
}

GType
usage_storage_view_type_get_type (void)
{
	static volatile gsize usage_storage_view_type_type_id__once = 0;
	if (g_once_init_enter (&usage_storage_view_type_type_id__once)) {
		GType usage_storage_view_type_type_id;
		usage_storage_view_type_type_id = usage_storage_view_type_get_type_once ();
		g_once_init_leave (&usage_storage_view_type_type_id__once, usage_storage_view_type_type_id);
	}
	return usage_storage_view_type_type_id__once;
}

static inline gpointer
usage_storage_view_item_get_instance_private (UsageStorageViewItem* self)
{
	return G_STRUCT_MEMBER_P (self, UsageStorageViewItem_private_offset);
}

UsageStorageViewItem*
usage_storage_view_item_from_file (GFile* file)
{
	UsageStorageViewItem* item = NULL;
	UsageStorageViewItem* _tmp0_;
	UsageStorageViewItem* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	UsageStorageViewItem* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = usage_storage_view_item_new ();
	item = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = g_file_get_uri (file);
	_g_free0 (_tmp1_->uri);
	_tmp1_->uri = _tmp2_;
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp3_;
		UsageStorageViewItem* _tmp4_;
		GFileInfo* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		UsageStorageViewItem* _tmp8_;
		GFileInfo* _tmp9_;
		UsageStorageViewItem* _tmp10_;
		GFileInfo* _tmp11_;
		_tmp3_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_TRASH_ORIG_PATH, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		info = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = item;
		_tmp5_ = info;
		_tmp6_ = g_file_info_get_name (_tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (_tmp4_->name);
		_tmp4_->name = _tmp7_;
		_tmp8_ = item;
		_tmp9_ = info;
		_tmp8_->size = (guint64) g_file_info_get_size (_tmp9_);
		_tmp10_ = item;
		_tmp11_ = info;
		_tmp10_->type = g_file_info_get_file_type (_tmp11_);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_object_unref0 (item);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (item);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = item;
	return result;
}

static void
usage_storage_view_item_setup_tag_style (UsageStorageViewItem* self)
{
	GUserDirectory* _tmp0_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	static GQuark _tmp4_label3 = 0;
	static GQuark _tmp4_label4 = 0;
	static GQuark _tmp4_label5 = 0;
	static GQuark _tmp4_label6 = 0;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	if (self->type == G_FILE_TYPE_DIRECTORY) {
		usage_storage_view_item_set_style_class (self, "folders");
	}
	_tmp0_ = self->dir;
	if (_tmp0_ != NULL) {
		GUserDirectory* _tmp1_;
		_tmp1_ = self->dir;
		switch (*_tmp1_) {
			case G_USER_DIRECTORY_PICTURES:
			{
				usage_storage_view_item_set_style_class (self, "pictures");
				break;
			}
			case G_USER_DIRECTORY_VIDEOS:
			{
				usage_storage_view_item_set_style_class (self, "videos");
				break;
			}
			case G_USER_DIRECTORY_DOCUMENTS:
			{
				usage_storage_view_item_set_style_class (self, "documents");
				break;
			}
			case G_USER_DIRECTORY_MUSIC:
			{
				usage_storage_view_item_set_style_class (self, "music");
				break;
			}
			case G_USER_DIRECTORY_DOWNLOAD:
			{
				usage_storage_view_item_set_style_class (self, "downloads");
				break;
			}
			default:
			{
				break;
			}
		}
	}
	_tmp2_ = self->ontology;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("nmm#MusicPiece")))) {
		switch (0) {
			default:
			{
				usage_storage_view_item_set_style_class (self, "music");
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("nmm#Photo")))) {
		switch (0) {
			default:
			{
				usage_storage_view_item_set_style_class (self, "pictures");
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("nmm#Video")))) {
		switch (0) {
			default:
			{
				usage_storage_view_item_set_style_class (self, "videos");
				break;
			}
		}
	} else if ((((_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("nfo#PaginatedTextDocument")))) || (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("nfo#PlainTextDocument"))))) || (_tmp5_ == ((0 != _tmp4_label5) ? _tmp4_label5 : (_tmp4_label5 = g_quark_from_static_string ("nfo#FileDataObject"))))) || (_tmp5_ == ((0 != _tmp4_label6) ? _tmp4_label6 : (_tmp4_label6 = g_quark_from_static_string ("nfo#EBook"))))) {
		switch (0) {
			default:
			{
				usage_storage_view_item_set_style_class (self, "documents");
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	if (self->custom_type != USAGE_STORAGE_VIEW_TYPE_NONE) {
		switch (self->custom_type) {
			case USAGE_STORAGE_VIEW_TYPE_OS:
			{
				usage_storage_view_item_set_style_class (self, "os-tag");
				break;
			}
			case USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH:
			{
				usage_storage_view_item_set_style_class (self, "available-tag");
				break;
			}
			default:
			{
				break;
			}
		}
	}
	_tmp6_ = self->priv->_style_class;
	if (_tmp6_ == NULL) {
		usage_storage_view_item_set_style_class (self, "files");
	}
}

static gboolean
_usage_storage_view_item_show_check_button (UsageStorageViewItem* self)
{
	GUserDirectory* _tmp0_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	static GQuark _tmp4_label3 = 0;
	static GQuark _tmp4_label4 = 0;
	static GQuark _tmp4_label5 = 0;
	static GQuark _tmp4_label6 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->custom_type != USAGE_STORAGE_VIEW_TYPE_NONE) {
		switch (self->custom_type) {
			case USAGE_STORAGE_VIEW_TYPE_OS:
			case USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH:
			case USAGE_STORAGE_VIEW_TYPE_UP_FOLDER:
			{
				result = FALSE;
				return result;
			}
			default:
			{
				break;
			}
		}
	}
	_tmp0_ = self->dir;
	if (_tmp0_ != NULL) {
		GUserDirectory* _tmp1_;
		_tmp1_ = self->dir;
		switch (*_tmp1_) {
			case G_USER_DIRECTORY_PICTURES:
			case G_USER_DIRECTORY_VIDEOS:
			case G_USER_DIRECTORY_DOCUMENTS:
			case G_USER_DIRECTORY_MUSIC:
			case G_USER_DIRECTORY_DOWNLOAD:
			{
				result = TRUE;
				return result;
			}
			default:
			{
				break;
			}
		}
	}
	_tmp2_ = self->ontology;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (((((((_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("nmm#MusicPiece")))) || (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("nmm#Photo"))))) || (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("nmm#Video"))))) || (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("nfo#PaginatedTextDocument"))))) || (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("nfo#PlainTextDocument"))))) || (_tmp5_ == ((0 != _tmp4_label5) ? _tmp4_label5 : (_tmp4_label5 = g_quark_from_static_string ("nfo#FileDataObject"))))) || (_tmp5_ == ((0 != _tmp4_label6) ? _tmp4_label6 : (_tmp4_label6 = g_quark_from_static_string ("nfo#EBook"))))) {
		switch (0) {
			default:
			{
				result = TRUE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	result = FALSE;
	return result;
}

void
usage_storage_view_item_get_base_color (UsageStorageViewItem* self,
                                        GdkRGBA* result)
{
	GdkRGBA base_color = {0};
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	static GQuark _tmp3_label4 = 0;
	static GQuark _tmp3_label5 = 0;
	static GQuark _tmp3_label6 = 0;
	static GQuark _tmp3_label7 = 0;
	g_return_if_fail (self != NULL);
	memset (&base_color, 0, sizeof (GdkRGBA));
	_tmp0_ = usage_storage_view_item_get_style_class (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("available-tag")))) {
		switch (0) {
			default:
			{
				gdk_rgba_parse (&base_color, "#ffffff");
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("os-tag")))) {
		switch (0) {
			default:
			{
				gdk_rgba_parse (&base_color, "#000000");
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("folders")))) {
		switch (0) {
			default:
			{
				gdk_rgba_parse (&base_color, "#737373");
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("downloads")))) {
		switch (0) {
			default:
			{
				gdk_rgba_parse (&base_color, "#ffe451");
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("pictures")))) {
		switch (0) {
			default:
			{
				gdk_rgba_parse (&base_color, "#2493d3");
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label5) ? _tmp3_label5 : (_tmp3_label5 = g_quark_from_static_string ("videos")))) {
		switch (0) {
			default:
			{
				gdk_rgba_parse (&base_color, "#a77aa5");
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label6) ? _tmp3_label6 : (_tmp3_label6 = g_quark_from_static_string ("documents")))) {
		switch (0) {
			default:
			{
				gdk_rgba_parse (&base_color, "#7be95a");
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label7) ? _tmp3_label7 : (_tmp3_label7 = g_quark_from_static_string ("music")))) {
		switch (0) {
			default:
			{
				gdk_rgba_parse (&base_color, "#f9a14a");
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gdk_rgba_parse (&base_color, "#cdcdcd");
				break;
			}
		}
	}
	*result = base_color;
	return;
}

UsageStorageViewItem*
usage_storage_view_item_construct (GType object_type)
{
	UsageStorageViewItem * self = NULL;
	self = (UsageStorageViewItem*) g_object_new (object_type, NULL);
	return self;
}

UsageStorageViewItem*
usage_storage_view_item_new (void)
{
	return usage_storage_view_item_construct (USAGE_TYPE_STORAGE_VIEW_ITEM);
}

gdouble
usage_storage_view_item_get_percentage (UsageStorageViewItem* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_percentage;
	return result;
}

void
usage_storage_view_item_set_percentage (UsageStorageViewItem* self,
                                        gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_storage_view_item_get_percentage (self);
	if (old_value != value) {
		self->priv->_percentage = value;
		g_object_notify_by_pspec ((GObject *) self, usage_storage_view_item_properties[USAGE_STORAGE_VIEW_ITEM_PERCENTAGE_PROPERTY]);
	}
}

gboolean
usage_storage_view_item_get_loaded (UsageStorageViewItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_loaded;
	return result;
}

void
usage_storage_view_item_set_loaded (UsageStorageViewItem* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_storage_view_item_get_loaded (self);
	if (old_value != value) {
		self->priv->_loaded = value;
		g_object_notify_by_pspec ((GObject *) self, usage_storage_view_item_properties[USAGE_STORAGE_VIEW_ITEM_LOADED_PROPERTY]);
	}
}

void
usage_storage_view_item_get_color (UsageStorageViewItem* self,
                                   GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_color;
	*result = _tmp0_;
	return;
}

static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

void
usage_storage_view_item_set_color (UsageStorageViewItem* self,
                                   GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	usage_storage_view_item_get_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, usage_storage_view_item_properties[USAGE_STORAGE_VIEW_ITEM_COLOR_PROPERTY]);
	}
}

const gchar*
usage_storage_view_item_get_style_class (UsageStorageViewItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_style_class;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_style_class;
		result = _tmp1_;
		return result;
	}
	usage_storage_view_item_setup_tag_style (self);
	_tmp2_ = self->priv->_style_class;
	result = _tmp2_;
	return result;
}

void
usage_storage_view_item_set_style_class (UsageStorageViewItem* self,
                                         const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_style_class);
	self->priv->_style_class = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, usage_storage_view_item_properties[USAGE_STORAGE_VIEW_ITEM_STYLE_CLASS_PROPERTY]);
}

gboolean
usage_storage_view_item_get_show_check_button (UsageStorageViewItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = _usage_storage_view_item_show_check_button (self);
	return result;
}

static void
usage_storage_view_item_class_init (UsageStorageViewItemClass * klass,
                                    gpointer klass_data)
{
	usage_storage_view_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageStorageViewItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_storage_view_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_storage_view_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = usage_storage_view_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_STORAGE_VIEW_ITEM_PERCENTAGE_PROPERTY, usage_storage_view_item_properties[USAGE_STORAGE_VIEW_ITEM_PERCENTAGE_PROPERTY] = g_param_spec_double ("percentage", "percentage", "percentage", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_STORAGE_VIEW_ITEM_LOADED_PROPERTY, usage_storage_view_item_properties[USAGE_STORAGE_VIEW_ITEM_LOADED_PROPERTY] = g_param_spec_boolean ("loaded", "loaded", "loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_STORAGE_VIEW_ITEM_COLOR_PROPERTY, usage_storage_view_item_properties[USAGE_STORAGE_VIEW_ITEM_COLOR_PROPERTY] = g_param_spec_boxed ("color", "color", "color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_STORAGE_VIEW_ITEM_STYLE_CLASS_PROPERTY, usage_storage_view_item_properties[USAGE_STORAGE_VIEW_ITEM_STYLE_CLASS_PROPERTY] = g_param_spec_string ("style-class", "style-class", "style-class", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_STORAGE_VIEW_ITEM_SHOW_CHECK_BUTTON_PROPERTY, usage_storage_view_item_properties[USAGE_STORAGE_VIEW_ITEM_SHOW_CHECK_BUTTON_PROPERTY] = g_param_spec_boolean ("show-check-button", "show-check-button", "show-check-button", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
usage_storage_view_item_instance_init (UsageStorageViewItem * self,
                                       gpointer klass)
{
	self->priv = usage_storage_view_item_get_instance_private (self);
	self->priv->_loaded = FALSE;
	self->custom_type = USAGE_STORAGE_VIEW_TYPE_NONE;
	self->priv->_style_class = NULL;
}

static void
usage_storage_view_item_finalize (GObject * obj)
{
	UsageStorageViewItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItem);
	_g_free0 (self->uri);
	_g_free0 (self->name);
	_g_free0 (self->dir);
	_g_free0 (self->ontology);
	_g_free0 (self->priv->_style_class);
	G_OBJECT_CLASS (usage_storage_view_item_parent_class)->finalize (obj);
}

static GType
usage_storage_view_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageStorageViewItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_storage_view_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageStorageViewItem), 0, (GInstanceInitFunc) usage_storage_view_item_instance_init, NULL };
	GType usage_storage_view_item_type_id;
	usage_storage_view_item_type_id = g_type_register_static (G_TYPE_OBJECT, "UsageStorageViewItem", &g_define_type_info, 0);
	UsageStorageViewItem_private_offset = g_type_add_instance_private (usage_storage_view_item_type_id, sizeof (UsageStorageViewItemPrivate));
	return usage_storage_view_item_type_id;
}

GType
usage_storage_view_item_get_type (void)
{
	static volatile gsize usage_storage_view_item_type_id__once = 0;
	if (g_once_init_enter (&usage_storage_view_item_type_id__once)) {
		GType usage_storage_view_item_type_id;
		usage_storage_view_item_type_id = usage_storage_view_item_get_type_once ();
		g_once_init_leave (&usage_storage_view_item_type_id__once, usage_storage_view_item_type_id);
	}
	return usage_storage_view_item_type_id__once;
}

static void
_vala_usage_storage_view_item_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	UsageStorageViewItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItem);
	switch (property_id) {
		case USAGE_STORAGE_VIEW_ITEM_PERCENTAGE_PROPERTY:
		g_value_set_double (value, usage_storage_view_item_get_percentage (self));
		break;
		case USAGE_STORAGE_VIEW_ITEM_LOADED_PROPERTY:
		g_value_set_boolean (value, usage_storage_view_item_get_loaded (self));
		break;
		case USAGE_STORAGE_VIEW_ITEM_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			usage_storage_view_item_get_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case USAGE_STORAGE_VIEW_ITEM_STYLE_CLASS_PROPERTY:
		g_value_set_string (value, usage_storage_view_item_get_style_class (self));
		break;
		case USAGE_STORAGE_VIEW_ITEM_SHOW_CHECK_BUTTON_PROPERTY:
		g_value_set_boolean (value, usage_storage_view_item_get_show_check_button (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_usage_storage_view_item_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	UsageStorageViewItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItem);
	switch (property_id) {
		case USAGE_STORAGE_VIEW_ITEM_PERCENTAGE_PROPERTY:
		usage_storage_view_item_set_percentage (self, g_value_get_double (value));
		break;
		case USAGE_STORAGE_VIEW_ITEM_LOADED_PROPERTY:
		usage_storage_view_item_set_loaded (self, g_value_get_boolean (value));
		break;
		case USAGE_STORAGE_VIEW_ITEM_COLOR_PROPERTY:
		usage_storage_view_item_set_color (self, g_value_get_boxed (value));
		break;
		case USAGE_STORAGE_VIEW_ITEM_STYLE_CLASS_PROPERTY:
		usage_storage_view_item_set_style_class (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

