/* storage-view-row.c generated by valac 0.56.18, the Vala compiler
 * generated from storage-view-row.vala, do not modify */

/* storage-view-row.vala
 *
 * Copyright (C) 2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Felipe Borges <felipeborges@gnome.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_STORAGE_VIEW_ROW (usage_storage_view_row_get_type ())
#define USAGE_STORAGE_VIEW_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_VIEW_ROW, UsageStorageViewRow))
#define USAGE_STORAGE_VIEW_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_VIEW_ROW, UsageStorageViewRowClass))
#define USAGE_IS_STORAGE_VIEW_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_VIEW_ROW))
#define USAGE_IS_STORAGE_VIEW_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_VIEW_ROW))
#define USAGE_STORAGE_VIEW_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_VIEW_ROW, UsageStorageViewRowClass))

typedef struct _UsageStorageViewRow UsageStorageViewRow;
typedef struct _UsageStorageViewRowClass UsageStorageViewRowClass;
typedef struct _UsageStorageViewRowPrivate UsageStorageViewRowPrivate;

#define USAGE_TYPE_STORAGE_VIEW_ITEM (usage_storage_view_item_get_type ())
#define USAGE_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItem))
#define USAGE_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))
#define USAGE_IS_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_IS_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_STORAGE_VIEW_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))

typedef struct _UsageStorageViewItem UsageStorageViewItem;
typedef struct _UsageStorageViewItemClass UsageStorageViewItemClass;
enum  {
	USAGE_STORAGE_VIEW_ROW_0_PROPERTY,
	USAGE_STORAGE_VIEW_ROW_LABEL_PROPERTY,
	USAGE_STORAGE_VIEW_ROW_TAG_SIZE_PROPERTY,
	USAGE_STORAGE_VIEW_ROW_SELECTED_PROPERTY,
	USAGE_STORAGE_VIEW_ROW_NUM_PROPERTIES
};
static GParamSpec* usage_storage_view_row_properties[USAGE_STORAGE_VIEW_ROW_NUM_PROPERTIES];
typedef enum  {
	USAGE_STORAGE_VIEW_ROW_TAG_SIZE_SMALL,
	USAGE_STORAGE_VIEW_ROW_TAG_SIZE_BIG
} UsageStorageViewRowTagSize;

#define USAGE_STORAGE_VIEW_ROW_TYPE_TAG_SIZE (usage_storage_view_row_tag_size_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef struct _UsageStorageViewItemPrivate UsageStorageViewItemPrivate;
typedef enum  {
	USAGE_STORAGE_VIEW_TYPE_NONE,
	USAGE_STORAGE_VIEW_TYPE_OS,
	USAGE_STORAGE_VIEW_TYPE_UP_FOLDER,
	USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH,
	USAGE_STORAGE_VIEW_TYPE_ROOT_ITEM
} UsageStorageViewType;

#define USAGE_TYPE_STORAGE_VIEW_TYPE (usage_storage_view_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	USAGE_STORAGE_VIEW_ROW_CHECK_BUTTON_TOGGLED_SIGNAL,
	USAGE_STORAGE_VIEW_ROW_NUM_SIGNALS
};
static guint usage_storage_view_row_signals[USAGE_STORAGE_VIEW_ROW_NUM_SIGNALS] = {0};

struct _UsageStorageViewRow {
	GtkListBoxRow parent_instance;
	UsageStorageViewRowPrivate * priv;
	GtkCheckButton* check_button;
	GtkLabel* size_label;
	GtkSpinner* spinner;
	GtkBox* tag;
	UsageStorageViewItem* item;
};

struct _UsageStorageViewRowClass {
	GtkListBoxRowClass parent_class;
};

struct _UsageStorageViewRowPrivate {
	GtkLabel* title;
};

struct _Block12Data {
	int _ref_count_;
	UsageStorageViewRow* self;
	UsageStorageViewItem* item;
};

struct _UsageStorageViewItem {
	GObject parent_instance;
	UsageStorageViewItemPrivate * priv;
	gchar* uri;
	gchar* name;
	guint64 size;
	GFileType type;
	GUserDirectory* dir;
	gchar* ontology;
	UsageStorageViewType custom_type;
};

struct _UsageStorageViewItemClass {
	GObjectClass parent_class;
};

static gint UsageStorageViewRow_private_offset;
static gpointer usage_storage_view_row_parent_class = NULL;

VALA_EXTERN GType usage_storage_view_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageViewRow, g_object_unref)
VALA_EXTERN GType usage_storage_view_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageViewItem, g_object_unref)
VALA_EXTERN GType usage_storage_view_row_tag_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UsageStorageViewRow* usage_storage_view_row_new_from_item (UsageStorageViewItem* item);
VALA_EXTERN UsageStorageViewRow* usage_storage_view_row_construct_from_item (GType object_type,
                                                                 UsageStorageViewItem* item);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
VALA_EXTERN const gchar* usage_storage_view_item_get_style_class (UsageStorageViewItem* self);
VALA_EXTERN void usage_storage_view_item_get_base_color (UsageStorageViewItem* self,
                                             GdkRGBA* result);
VALA_EXTERN void usage_storage_view_item_set_color (UsageStorageViewItem* self,
                                        GdkRGBA * value);
VALA_EXTERN gboolean usage_storage_view_item_get_show_check_button (UsageStorageViewItem* self);
static void __lambda30_ (UsageStorageViewRow* self);
static void ___lambda30__gtk_check_button_toggled (GtkCheckButton* _sender,
                                            gpointer self);
static void __lambda31_ (UsageStorageViewRow* self);
static void usage_storage_view_row_set_up (UsageStorageViewRow* self);
static void ___lambda31__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN GType usage_storage_view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean usage_storage_view_item_get_loaded (UsageStorageViewItem* self);
static void ___lambda32_ (Block12Data* _data12_);
static void ____lambda32__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
VALA_EXTERN gchar* usage_utils_format_size_values (guint64 value,
                                       gulong** most_significant);
static void usage_storage_view_row_change_color (UsageStorageViewRow* self,
                                          GdkRGBA* color);
VALA_EXTERN void usage_storage_view_item_get_color (UsageStorageViewItem* self,
                                        GdkRGBA * result);
VALA_EXTERN UsageStorageViewRow* usage_storage_view_row_new (void);
VALA_EXTERN UsageStorageViewRow* usage_storage_view_row_construct (GType object_type);
VALA_EXTERN const gchar* usage_storage_view_row_get_label (UsageStorageViewRow* self);
VALA_EXTERN void usage_storage_view_row_set_label (UsageStorageViewRow* self,
                                       const gchar* value);
VALA_EXTERN UsageStorageViewRowTagSize usage_storage_view_row_get_tag_size (UsageStorageViewRow* self);
VALA_EXTERN void usage_storage_view_row_set_tag_size (UsageStorageViewRow* self,
                                          UsageStorageViewRowTagSize value);
VALA_EXTERN gboolean usage_storage_view_row_get_selected (UsageStorageViewRow* self);
static void usage_storage_view_row_finalize (GObject * obj);
static GType usage_storage_view_row_get_type_once (void);
static void _vala_usage_storage_view_row_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_usage_storage_view_row_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_storage_view_row_get_instance_private (UsageStorageViewRow* self)
{
	return G_STRUCT_MEMBER_P (self, UsageStorageViewRow_private_offset);
}

static GType
usage_storage_view_row_tag_size_get_type_once (void)
{
	static const GEnumValue values[] = {{USAGE_STORAGE_VIEW_ROW_TAG_SIZE_SMALL, "USAGE_STORAGE_VIEW_ROW_TAG_SIZE_SMALL", "small"}, {USAGE_STORAGE_VIEW_ROW_TAG_SIZE_BIG, "USAGE_STORAGE_VIEW_ROW_TAG_SIZE_BIG", "big"}, {0, NULL, NULL}};
	GType usage_storage_view_row_tag_size_type_id;
	usage_storage_view_row_tag_size_type_id = g_enum_register_static ("UsageStorageViewRowTagSize", values);
	return usage_storage_view_row_tag_size_type_id;
}

GType
usage_storage_view_row_tag_size_get_type (void)
{
	static volatile gsize usage_storage_view_row_tag_size_type_id__once = 0;
	if (g_once_init_enter (&usage_storage_view_row_tag_size_type_id__once)) {
		GType usage_storage_view_row_tag_size_type_id;
		usage_storage_view_row_tag_size_type_id = usage_storage_view_row_tag_size_get_type_once ();
		g_once_init_leave (&usage_storage_view_row_tag_size_type_id__once, usage_storage_view_row_tag_size_type_id);
	}
	return usage_storage_view_row_tag_size_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		UsageStorageViewRow* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->item);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
__lambda30_ (UsageStorageViewRow* self)
{
	g_signal_emit (self, usage_storage_view_row_signals[USAGE_STORAGE_VIEW_ROW_CHECK_BUTTON_TOGGLED_SIGNAL], 0);
}

static void
___lambda30__gtk_check_button_toggled (GtkCheckButton* _sender,
                                       gpointer self)
{
	__lambda30_ ((UsageStorageViewRow*) self);
}

static void
__lambda31_ (UsageStorageViewRow* self)
{
	usage_storage_view_row_set_up (self);
}

static void
___lambda31__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda31_ ((UsageStorageViewRow*) self);
}

static void
___lambda32_ (Block12Data* _data12_)
{
	UsageStorageViewRow* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data12_->self;
	_tmp0_ = usage_storage_view_item_get_loaded (_data12_->item);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkSpinner* _tmp2_;
		GtkSpinner* _tmp3_;
		GtkLabel* _tmp4_;
		_tmp2_ = self->spinner;
		gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
		_tmp3_ = self->spinner;
		gtk_spinner_stop (_tmp3_);
		_tmp4_ = self->size_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp4_, TRUE);
	}
}

static void
____lambda32__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda32_ (self);
}

UsageStorageViewRow*
usage_storage_view_row_construct_from_item (GType object_type,
                                            UsageStorageViewItem* item)
{
	UsageStorageViewRow * self = NULL;
	Block12Data* _data12_;
	UsageStorageViewItem* _tmp0_;
	UsageStorageViewItem* _tmp1_;
	GtkBox* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GdkRGBA _tmp5_ = {0};
	GtkCheckButton* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GtkCheckButton* _tmp9_;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (item != NULL, NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (_data12_->item);
	_data12_->item = _tmp0_;
	self = (UsageStorageViewRow*) g_object_new (object_type, NULL);
	_data12_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (_data12_->item);
	_g_object_unref0 (self->item);
	self->item = _tmp1_;
	_tmp2_ = self->tag;
	_tmp3_ = usage_storage_view_item_get_style_class (_data12_->item);
	_tmp4_ = _tmp3_;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, _tmp4_);
	usage_storage_view_item_get_base_color (_data12_->item, &_tmp5_);
	usage_storage_view_item_set_color (_data12_->item, &_tmp5_);
	_tmp6_ = self->check_button;
	_tmp7_ = usage_storage_view_item_get_show_check_button (_data12_->item);
	_tmp8_ = _tmp7_;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, _tmp8_);
	_tmp9_ = self->check_button;
	g_signal_connect_object (_tmp9_, "toggled", (GCallback) ___lambda30__gtk_check_button_toggled, self, 0);
	g_signal_connect_object ((GObject*) _data12_->item, "notify", (GCallback) ___lambda31__g_object_notify, self, 0);
	usage_storage_view_row_set_up (self);
	if (_data12_->item->type == G_FILE_TYPE_DIRECTORY) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = _data12_->item->custom_type != USAGE_STORAGE_VIEW_TYPE_NONE;
	}
	if (_tmp10_) {
		GtkBox* _tmp11_;
		GtkBox* _tmp12_;
		_tmp11_ = self->tag;
		_tmp12_ = self->tag;
		g_object_set ((GtkWidget*) _tmp12_, "height-request", 20, NULL);
		g_object_set ((GtkWidget*) _tmp11_, "width-request", 20, NULL);
	}
	if (_data12_->item->custom_type == USAGE_STORAGE_VIEW_TYPE_UP_FOLDER) {
		gboolean _tmp13_;
		gboolean _tmp14_;
		gtk_widget_add_css_class ((GtkWidget*) self, "up-folder");
		_tmp13_ = usage_storage_view_item_get_loaded (_data12_->item);
		_tmp14_ = _tmp13_;
		if (!_tmp14_) {
			GtkSpinner* _tmp15_;
			GtkSpinner* _tmp16_;
			GtkLabel* _tmp17_;
			_tmp15_ = self->spinner;
			gtk_widget_set_visible ((GtkWidget*) _tmp15_, TRUE);
			_tmp16_ = self->spinner;
			gtk_spinner_start (_tmp16_);
			_tmp17_ = self->size_label;
			gtk_widget_set_visible ((GtkWidget*) _tmp17_, FALSE);
		}
		g_signal_connect_data ((GObject*) _data12_->item, "notify::loaded", (GCallback) ____lambda32__g_object_notify, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	}
	block12_data_unref (_data12_);
	_data12_ = NULL;
	return self;
}

UsageStorageViewRow*
usage_storage_view_row_new_from_item (UsageStorageViewItem* item)
{
	return usage_storage_view_row_construct_from_item (USAGE_TYPE_STORAGE_VIEW_ROW, item);
}

static void
usage_storage_view_row_set_up (UsageStorageViewRow* self)
{
	GtkLabel* _tmp0_;
	UsageStorageViewItem* _tmp1_;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_;
	UsageStorageViewItem* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	UsageStorageViewItem* _tmp7_;
	GdkRGBA _tmp8_ = {0};
	GdkRGBA _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->title;
	_tmp1_ = self->item;
	_tmp2_ = _tmp1_->name;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_tmp3_ = self->size_label;
	_tmp4_ = self->item;
	_tmp5_ = usage_utils_format_size_values (_tmp4_->size, NULL);
	_tmp6_ = _tmp5_;
	gtk_label_set_label (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->item;
	usage_storage_view_item_get_color (_tmp7_, &_tmp8_);
	_tmp9_ = _tmp8_;
	usage_storage_view_row_change_color (self, &_tmp9_);
}

static void
usage_storage_view_row_change_color (UsageStorageViewRow* self,
                                     GdkRGBA* color)
{
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkBox* _tmp1_;
	GtkStyleContext* _tmp2_;
	gchar* css = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = gtk_css_provider_new ();
	css_provider = _tmp0_;
	_tmp1_ = self->tag;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_provider (_tmp2_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp3_ = gdk_rgba_to_string (color);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (".row-tag {\n            background: ", _tmp4_, ";\n        }", NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	css = _tmp6_;
	gtk_css_provider_load_from_string (css_provider, css);
	_g_free0 (css);
	_g_object_unref0 (css_provider);
}

UsageStorageViewRow*
usage_storage_view_row_construct (GType object_type)
{
	UsageStorageViewRow * self = NULL;
	self = (UsageStorageViewRow*) g_object_new (object_type, NULL);
	return self;
}

UsageStorageViewRow*
usage_storage_view_row_new (void)
{
	return usage_storage_view_row_construct (USAGE_TYPE_STORAGE_VIEW_ROW);
}

const gchar*
usage_storage_view_row_get_label (UsageStorageViewRow* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->title;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
usage_storage_view_row_set_label (UsageStorageViewRow* self,
                                  const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->title;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, usage_storage_view_row_properties[USAGE_STORAGE_VIEW_ROW_LABEL_PROPERTY]);
}

UsageStorageViewRowTagSize
usage_storage_view_row_get_tag_size (UsageStorageViewRow* self)
{
	UsageStorageViewRowTagSize result;
	UsageStorageViewRowTagSize _tmp0_ = 0;
	GtkBox* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->tag;
	g_object_get ((GtkWidget*) _tmp1_, "width-request", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 20) {
		_tmp0_ = USAGE_STORAGE_VIEW_ROW_TAG_SIZE_BIG;
	} else {
		_tmp0_ = USAGE_STORAGE_VIEW_ROW_TAG_SIZE_SMALL;
	}
	result = _tmp0_;
	return result;
}

void
usage_storage_view_row_set_tag_size (UsageStorageViewRow* self,
                                     UsageStorageViewRowTagSize value)
{
	g_return_if_fail (self != NULL);
	if (value == USAGE_STORAGE_VIEW_ROW_TAG_SIZE_BIG) {
		GtkBox* _tmp0_;
		GtkBox* _tmp1_;
		_tmp0_ = self->tag;
		_tmp1_ = self->tag;
		g_object_set ((GtkWidget*) _tmp1_, "height-request", 20, NULL);
		g_object_set ((GtkWidget*) _tmp0_, "width-request", 20, NULL);
	}
	g_object_notify_by_pspec ((GObject *) self, usage_storage_view_row_properties[USAGE_STORAGE_VIEW_ROW_TAG_SIZE_PROPERTY]);
}

gboolean
usage_storage_view_row_get_selected (UsageStorageViewRow* self)
{
	gboolean result;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->check_button;
	_tmp1_ = gtk_check_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
usage_storage_view_row_class_init (UsageStorageViewRowClass * klass,
                                   gpointer klass_data)
{
	usage_storage_view_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageStorageViewRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_storage_view_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_storage_view_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = usage_storage_view_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_STORAGE_VIEW_ROW_LABEL_PROPERTY, usage_storage_view_row_properties[USAGE_STORAGE_VIEW_ROW_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_STORAGE_VIEW_ROW_TAG_SIZE_PROPERTY, usage_storage_view_row_properties[USAGE_STORAGE_VIEW_ROW_TAG_SIZE_PROPERTY] = g_param_spec_enum ("tag-size", "tag-size", "tag-size", USAGE_STORAGE_VIEW_ROW_TYPE_TAG_SIZE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_STORAGE_VIEW_ROW_SELECTED_PROPERTY, usage_storage_view_row_properties[USAGE_STORAGE_VIEW_ROW_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Usage/ui/storage-view-row.ui");
	usage_storage_view_row_signals[USAGE_STORAGE_VIEW_ROW_CHECK_BUTTON_TOGGLED_SIGNAL] = g_signal_new ("check-button-toggled", USAGE_TYPE_STORAGE_VIEW_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title", FALSE, UsageStorageViewRow_private_offset + G_STRUCT_OFFSET (UsageStorageViewRowPrivate, title));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_button", FALSE, G_STRUCT_OFFSET (UsageStorageViewRow, check_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "size_label", FALSE, G_STRUCT_OFFSET (UsageStorageViewRow, size_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinner", FALSE, G_STRUCT_OFFSET (UsageStorageViewRow, spinner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tag", FALSE, G_STRUCT_OFFSET (UsageStorageViewRow, tag));
}

static void
usage_storage_view_row_instance_init (UsageStorageViewRow * self,
                                      gpointer klass)
{
	self->priv = usage_storage_view_row_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
usage_storage_view_row_finalize (GObject * obj)
{
	UsageStorageViewRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_STORAGE_VIEW_ROW, UsageStorageViewRow);
	_g_object_unref0 (self->item);
	G_OBJECT_CLASS (usage_storage_view_row_parent_class)->finalize (obj);
}

static GType
usage_storage_view_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageStorageViewRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_storage_view_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageStorageViewRow), 0, (GInstanceInitFunc) usage_storage_view_row_instance_init, NULL };
	GType usage_storage_view_row_type_id;
	usage_storage_view_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "UsageStorageViewRow", &g_define_type_info, 0);
	UsageStorageViewRow_private_offset = g_type_add_instance_private (usage_storage_view_row_type_id, sizeof (UsageStorageViewRowPrivate));
	return usage_storage_view_row_type_id;
}

GType
usage_storage_view_row_get_type (void)
{
	static volatile gsize usage_storage_view_row_type_id__once = 0;
	if (g_once_init_enter (&usage_storage_view_row_type_id__once)) {
		GType usage_storage_view_row_type_id;
		usage_storage_view_row_type_id = usage_storage_view_row_get_type_once ();
		g_once_init_leave (&usage_storage_view_row_type_id__once, usage_storage_view_row_type_id);
	}
	return usage_storage_view_row_type_id__once;
}

static void
_vala_usage_storage_view_row_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	UsageStorageViewRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_STORAGE_VIEW_ROW, UsageStorageViewRow);
	switch (property_id) {
		case USAGE_STORAGE_VIEW_ROW_LABEL_PROPERTY:
		g_value_set_string (value, usage_storage_view_row_get_label (self));
		break;
		case USAGE_STORAGE_VIEW_ROW_TAG_SIZE_PROPERTY:
		g_value_set_enum (value, usage_storage_view_row_get_tag_size (self));
		break;
		case USAGE_STORAGE_VIEW_ROW_SELECTED_PROPERTY:
		g_value_set_boolean (value, usage_storage_view_row_get_selected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_usage_storage_view_row_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	UsageStorageViewRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_STORAGE_VIEW_ROW, UsageStorageViewRow);
	switch (property_id) {
		case USAGE_STORAGE_VIEW_ROW_LABEL_PROPERTY:
		usage_storage_view_row_set_label (self, g_value_get_string (value));
		break;
		case USAGE_STORAGE_VIEW_ROW_TAG_SIZE_PROPERTY:
		usage_storage_view_row_set_tag_size (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

