/* tracker-controller.c generated by valac 0.56.18, the Vala compiler
 * generated from tracker-controller.vala, do not modify */

/* tracker-controller.vala
 *
 * Copyright (C) 2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Felipe Borges <felipeborges@gnome.org>
 */

#include <glib-object.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_TRACKER_CONTROLLER (usage_tracker_controller_get_type ())
#define USAGE_TRACKER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_TRACKER_CONTROLLER, UsageTrackerController))
#define USAGE_TRACKER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_TRACKER_CONTROLLER, UsageTrackerControllerClass))
#define USAGE_IS_TRACKER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_TRACKER_CONTROLLER))
#define USAGE_IS_TRACKER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_TRACKER_CONTROLLER))
#define USAGE_TRACKER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_TRACKER_CONTROLLER, UsageTrackerControllerClass))

typedef struct _UsageTrackerController UsageTrackerController;
typedef struct _UsageTrackerControllerClass UsageTrackerControllerClass;
typedef struct _UsageTrackerControllerPrivate UsageTrackerControllerPrivate;

#define USAGE_TYPE_STORAGE_QUERY_BUILDER (usage_storage_query_builder_get_type ())
#define USAGE_STORAGE_QUERY_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_QUERY_BUILDER, UsageStorageQueryBuilder))
#define USAGE_STORAGE_QUERY_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_QUERY_BUILDER, UsageStorageQueryBuilderClass))
#define USAGE_IS_STORAGE_QUERY_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_QUERY_BUILDER))
#define USAGE_IS_STORAGE_QUERY_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_QUERY_BUILDER))
#define USAGE_STORAGE_QUERY_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_QUERY_BUILDER, UsageStorageQueryBuilderClass))

typedef struct _UsageStorageQueryBuilder UsageStorageQueryBuilder;
typedef struct _UsageStorageQueryBuilderClass UsageStorageQueryBuilderClass;
enum  {
	USAGE_TRACKER_CONTROLLER_0_PROPERTY,
	USAGE_TRACKER_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* usage_tracker_controller_properties[USAGE_TRACKER_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _usage_storage_query_builder_unref0(var) ((var == NULL) ? NULL : (var = (usage_storage_query_builder_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define USAGE_TYPE_TRACKER_WORKER (usage_tracker_worker_get_type ())
#define USAGE_TRACKER_WORKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_TRACKER_WORKER, UsageTrackerWorker))
#define USAGE_TRACKER_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_TRACKER_WORKER, UsageTrackerWorkerClass))
#define USAGE_IS_TRACKER_WORKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_TRACKER_WORKER))
#define USAGE_IS_TRACKER_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_TRACKER_WORKER))
#define USAGE_TRACKER_WORKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_TRACKER_WORKER, UsageTrackerWorkerClass))

typedef struct _UsageTrackerWorker UsageTrackerWorker;
typedef struct _UsageTrackerWorkerClass UsageTrackerWorkerClass;
#define _usage_tracker_worker_unref0(var) ((var == NULL) ? NULL : (var = (usage_tracker_worker_unref (var), NULL)))

#define USAGE_TYPE_STORAGE_VIEW_ITEM (usage_storage_view_item_get_type ())
#define USAGE_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItem))
#define USAGE_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))
#define USAGE_IS_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_IS_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_STORAGE_VIEW_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))

typedef struct _UsageStorageViewItem UsageStorageViewItem;
typedef struct _UsageStorageViewItemClass UsageStorageViewItemClass;
typedef struct _UsageStorageViewItemPrivate UsageStorageViewItemPrivate;
typedef enum  {
	USAGE_STORAGE_VIEW_TYPE_NONE,
	USAGE_STORAGE_VIEW_TYPE_OS,
	USAGE_STORAGE_VIEW_TYPE_UP_FOLDER,
	USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH,
	USAGE_STORAGE_VIEW_TYPE_ROOT_ITEM
} UsageStorageViewType;

#define USAGE_TYPE_STORAGE_VIEW_TYPE (usage_storage_view_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UsageTrackerControllerEnumerateChildrenData UsageTrackerControllerEnumerateChildrenData;
typedef struct _UsageTrackerControllerGetFileSizeData UsageTrackerControllerGetFileSizeData;

struct _UsageTrackerController {
	GObject parent_instance;
	UsageTrackerControllerPrivate * priv;
};

struct _UsageTrackerControllerClass {
	GObjectClass parent_class;
};

struct _UsageTrackerControllerPrivate {
	TrackerSparqlConnection* connection;
	UsageStorageQueryBuilder* query_builder;
	GListStore* model;
};

struct _UsageStorageViewItem {
	GObject parent_instance;
	UsageStorageViewItemPrivate * priv;
	gchar* uri;
	gchar* name;
	guint64 size;
	GFileType type;
	GUserDirectory* dir;
	gchar* ontology;
	UsageStorageViewType custom_type;
};

struct _UsageStorageViewItemClass {
	GObjectClass parent_class;
};

struct _UsageTrackerControllerEnumerateChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UsageTrackerController* self;
	gchar* uri;
	GUserDirectory* dir;
	GCancellable* cancellable;
	guint64 result;
	gchar* query;
	UsageStorageQueryBuilder* _tmp0_;
	gchar* _tmp1_;
	guint64 uri_size;
	UsageTrackerWorker* worker;
	TrackerSparqlConnection* _tmp2_;
	const gchar* _tmp3_;
	UsageTrackerWorker* _tmp4_;
	gchar* n_uri;
	gchar* file_type;
	GFile* parent;
	GFile* _tmp5_;
	guint64 parent_size;
	GFile* _tmp6_;
	guint64 _tmp7_;
	gboolean _tmp8_;
	UsageTrackerWorker* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	GFile* file;
	const gchar* _tmp13_;
	GFile* _tmp14_;
	UsageStorageViewItem* item;
	GFile* _tmp15_;
	UsageStorageViewItem* _tmp16_;
	UsageStorageViewItem* _tmp17_;
	UsageStorageViewItem* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	UsageStorageViewItem* _tmp21_;
	GUserDirectory* _tmp22_;
	UsageStorageViewItem* _tmp23_;
	guint64 _tmp24_;
	const gchar* _tmp25_;
	UsageStorageViewItem* _tmp26_;
	UsageStorageViewItem* _tmp27_;
	UsageStorageViewItem* _tmp28_;
	UsageStorageViewItem* _tmp29_;
	GListStore* _tmp30_;
	UsageStorageViewItem* _tmp31_;
	GError* _error_;
	GError* _tmp32_;
	const gchar* _tmp33_;
	GError* _inner_error0_;
};

struct _UsageTrackerControllerGetFileSizeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UsageTrackerController* self;
	gchar* uri;
	guint64 result;
	guint64 total;
	gchar* query;
	UsageStorageQueryBuilder* _tmp0_;
	gchar* _tmp1_;
	UsageTrackerWorker* worker;
	TrackerSparqlConnection* _tmp2_;
	const gchar* _tmp3_;
	UsageTrackerWorker* _tmp4_;
	gchar* n_uri;
	gboolean _tmp5_;
	UsageTrackerWorker* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_;
};

static gint UsageTrackerController_private_offset;
static gpointer usage_tracker_controller_parent_class = NULL;

VALA_EXTERN GType usage_tracker_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageTrackerController, g_object_unref)
VALA_EXTERN gpointer usage_storage_query_builder_ref (gpointer instance);
VALA_EXTERN void usage_storage_query_builder_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_storage_query_builder (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void usage_value_set_storage_query_builder (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void usage_value_take_storage_query_builder (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer usage_value_get_storage_query_builder (const GValue* value);
VALA_EXTERN GType usage_storage_query_builder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageQueryBuilder, usage_storage_query_builder_unref)
VALA_EXTERN UsageTrackerController* usage_tracker_controller_new (TrackerSparqlConnection* connection);
VALA_EXTERN UsageTrackerController* usage_tracker_controller_construct (GType object_type,
                                                            TrackerSparqlConnection* connection);
VALA_EXTERN void usage_tracker_controller_set_model (UsageTrackerController* self,
                                         GListStore* model);
static void usage_tracker_controller_enumerate_children_data_free (gpointer _data);
static GUserDirectory* _g_user_directory_dup (GUserDirectory* self);
VALA_EXTERN void usage_tracker_controller_enumerate_children (UsageTrackerController* self,
                                                  const gchar* uri,
                                                  GUserDirectory* dir,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN guint64 usage_tracker_controller_enumerate_children_finish (UsageTrackerController* self,
                                                            GAsyncResult* _res_);
static gboolean usage_tracker_controller_enumerate_children_co (UsageTrackerControllerEnumerateChildrenData* _data_);
VALA_EXTERN gchar* usage_storage_query_builder_enumerate_children (UsageStorageQueryBuilder* self,
                                                       const gchar* uri,
                                                       gboolean recursive);
VALA_EXTERN gpointer usage_tracker_worker_ref (gpointer instance);
VALA_EXTERN void usage_tracker_worker_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_tracker_worker (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void usage_value_set_tracker_worker (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void usage_value_take_tracker_worker (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer usage_value_get_tracker_worker (const GValue* value);
VALA_EXTERN GType usage_tracker_worker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageTrackerWorker, usage_tracker_worker_unref)
VALA_EXTERN void usage_tracker_worker_new (TrackerSparqlConnection* connection,
                               const gchar* query,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN UsageTrackerWorker* usage_tracker_worker_new_finish (GAsyncResult* _res_,
                                                     GError** error);
VALA_EXTERN void usage_tracker_worker_construct (GType object_type,
                                     TrackerSparqlConnection* connection,
                                     const gchar* query,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN UsageTrackerWorker* usage_tracker_worker_construct_finish (GAsyncResult* _res_,
                                                           GError** error);
static void usage_tracker_controller_enumerate_children_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
VALA_EXTERN void usage_tracker_controller_get_file_size (UsageTrackerController* self,
                                             const gchar* uri,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN guint64 usage_tracker_controller_get_file_size_finish (UsageTrackerController* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
VALA_EXTERN void usage_tracker_worker_fetch_next (UsageTrackerWorker* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN gboolean usage_tracker_worker_fetch_next_finish (UsageTrackerWorker* self,
                                                 GAsyncResult* _res_,
                                                 gchar** uri,
                                                 gchar** file_type,
                                                 GError** error);
VALA_EXTERN GType usage_storage_view_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageViewItem, g_object_unref)
VALA_EXTERN UsageStorageViewItem* usage_storage_view_item_from_file (GFile* file);
VALA_EXTERN GType usage_storage_view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void usage_storage_view_item_set_percentage (UsageStorageViewItem* self,
                                             gdouble value);
static gint _____lambda37_ (UsageTrackerController* self,
                     GObject* a,
                     GObject* b);
static gint ______lambda37__gcompare_data_func (gconstpointer a,
                                         gconstpointer b,
                                         gpointer self);
static guint64 usage_tracker_controller_get_g_file_size (UsageTrackerController* self,
                                                  const gchar* uri);
static void usage_tracker_controller_get_file_size_data_free (gpointer _data);
static gboolean usage_tracker_controller_get_file_size_co (UsageTrackerControllerGetFileSizeData* _data_);
static void usage_tracker_controller_get_file_size_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static GObject * usage_tracker_controller_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
VALA_EXTERN UsageStorageQueryBuilder* usage_storage_query_builder_new (void);
VALA_EXTERN UsageStorageQueryBuilder* usage_storage_query_builder_construct (GType object_type);
static void usage_tracker_controller_finalize (GObject * obj);
static GType usage_tracker_controller_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_tracker_controller_get_instance_private (UsageTrackerController* self)
{
	return G_STRUCT_MEMBER_P (self, UsageTrackerController_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

UsageTrackerController*
usage_tracker_controller_construct (GType object_type,
                                    TrackerSparqlConnection* connection)
{
	UsageTrackerController * self = NULL;
	TrackerSparqlConnection* _tmp0_;
	g_return_val_if_fail (connection != NULL, NULL);
	self = (UsageTrackerController*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (connection);
	_g_object_unref0 (self->priv->connection);
	self->priv->connection = _tmp0_;
	return self;
}

UsageTrackerController*
usage_tracker_controller_new (TrackerSparqlConnection* connection)
{
	return usage_tracker_controller_construct (USAGE_TYPE_TRACKER_CONTROLLER, connection);
}

void
usage_tracker_controller_set_model (UsageTrackerController* self,
                                    GListStore* model)
{
	GListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = _g_object_ref0 (model);
	_g_object_unref0 (self->priv->model);
	self->priv->model = _tmp0_;
}

static void
usage_tracker_controller_enumerate_children_data_free (gpointer _data)
{
	UsageTrackerControllerEnumerateChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->dir);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (UsageTrackerControllerEnumerateChildrenData, _data_);
}

static GUserDirectory*
_g_user_directory_dup (GUserDirectory* self)
{
	GUserDirectory* dup;
	dup = g_new0 (GUserDirectory, 1);
	memcpy (dup, self, sizeof (GUserDirectory));
	return dup;
}

static gpointer
__g_user_directory_dup0 (gpointer self)
{
	return self ? _g_user_directory_dup (self) : NULL;
}

void
usage_tracker_controller_enumerate_children (UsageTrackerController* self,
                                             const gchar* uri,
                                             GUserDirectory* dir,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	UsageTrackerControllerEnumerateChildrenData* _data_;
	UsageTrackerController* _tmp0_;
	gchar* _tmp1_;
	GUserDirectory* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (UsageTrackerControllerEnumerateChildrenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, usage_tracker_controller_enumerate_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_tmp2_ = __g_user_directory_dup0 (dir);
	_g_free0 (_data_->dir);
	_data_->dir = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	usage_tracker_controller_enumerate_children_co (_data_);
}

guint64
usage_tracker_controller_enumerate_children_finish (UsageTrackerController* self,
                                                    GAsyncResult* _res_)
{
	guint64 result;
	UsageTrackerControllerEnumerateChildrenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		guint64 _tmp0_ = 0ULL;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
usage_tracker_controller_enumerate_children_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	UsageTrackerControllerEnumerateChildrenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	usage_tracker_controller_enumerate_children_co (_data_);
}

static gint
_____lambda37_ (UsageTrackerController* self,
                GObject* a,
                GObject* b)
{
	UsageStorageViewItem* item_a = NULL;
	UsageStorageViewItem* _tmp0_;
	UsageStorageViewItem* item_b = NULL;
	UsageStorageViewItem* _tmp1_;
	gboolean _tmp2_ = FALSE;
	UsageStorageViewItem* _tmp3_;
	gboolean _tmp6_ = FALSE;
	UsageStorageViewItem* _tmp7_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (USAGE_IS_STORAGE_VIEW_ITEM (a) ? ((UsageStorageViewItem*) a) : NULL);
	item_a = _tmp0_;
	_tmp1_ = _g_object_ref0 (USAGE_IS_STORAGE_VIEW_ITEM (b) ? ((UsageStorageViewItem*) b) : NULL);
	item_b = _tmp1_;
	_tmp3_ = item_a;
	if (_tmp3_->custom_type == USAGE_STORAGE_VIEW_TYPE_UP_FOLDER) {
		_tmp2_ = TRUE;
	} else {
		UsageStorageViewItem* _tmp4_;
		UsageStorageViewItem* _tmp5_;
		_tmp4_ = item_a;
		_tmp5_ = item_b;
		_tmp2_ = _tmp4_->size > _tmp5_->size;
	}
	if (_tmp2_) {
		result = -1;
		_g_object_unref0 (item_b);
		_g_object_unref0 (item_a);
		return result;
	}
	_tmp7_ = item_b;
	if (_tmp7_->custom_type == USAGE_STORAGE_VIEW_TYPE_UP_FOLDER) {
		_tmp6_ = TRUE;
	} else {
		UsageStorageViewItem* _tmp8_;
		UsageStorageViewItem* _tmp9_;
		_tmp8_ = item_b;
		_tmp9_ = item_a;
		_tmp6_ = _tmp8_->size > _tmp9_->size;
	}
	if (_tmp6_) {
		result = 1;
		_g_object_unref0 (item_b);
		_g_object_unref0 (item_a);
		return result;
	}
	result = 0;
	_g_object_unref0 (item_b);
	_g_object_unref0 (item_a);
	return result;
}

static gint
______lambda37__gcompare_data_func (gconstpointer a,
                                    gconstpointer b,
                                    gpointer self)
{
	gint result;
	result = _____lambda37_ ((UsageTrackerController*) self, (GObject*) a, (GObject*) b);
	return result;
}

static gboolean
usage_tracker_controller_enumerate_children_co (UsageTrackerControllerEnumerateChildrenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->query_builder;
	_data_->_tmp1_ = usage_storage_query_builder_enumerate_children (_data_->_tmp0_, _data_->uri, FALSE);
	_data_->query = _data_->_tmp1_;
	_data_->uri_size = (guint64) 0;
	{
		_data_->_tmp2_ = _data_->self->priv->connection;
		_data_->_tmp3_ = _data_->query;
		_data_->_state_ = 1;
		usage_tracker_worker_new (_data_->_tmp2_, _data_->_tmp3_, usage_tracker_controller_enumerate_children_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = usage_tracker_worker_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->worker = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->n_uri = NULL;
		_data_->file_type = NULL;
		_data_->_tmp5_ = g_file_new_for_uri (_data_->uri);
		_data_->parent = _data_->_tmp5_;
		_data_->parent_size = (guint64) 1;
		_data_->_tmp6_ = _data_->parent;
		if (_data_->_tmp6_ != NULL) {
			_data_->_state_ = 2;
			usage_tracker_controller_get_file_size (_data_->self, _data_->uri, usage_tracker_controller_enumerate_children_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp7_ = usage_tracker_controller_get_file_size_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->parent);
				_g_free0 (_data_->file_type);
				_g_free0 (_data_->n_uri);
				_usage_tracker_worker_unref0 (_data_->worker);
				goto __catch0_g_error;
			}
			_data_->parent_size = _data_->_tmp7_;
		}
		while (TRUE) {
			_data_->_tmp9_ = _data_->worker;
			_data_->_tmp10_ = NULL;
			_data_->_tmp11_ = NULL;
			_data_->_state_ = 3;
			usage_tracker_worker_fetch_next (_data_->_tmp9_, usage_tracker_controller_enumerate_children_ready, _data_);
			return FALSE;
			_state_3:
			_data_->_tmp12_ = usage_tracker_worker_fetch_next_finish (_data_->_tmp9_, _data_->_res_, &_data_->_tmp10_, &_data_->_tmp11_, &_data_->_inner_error0_);
			_g_free0 (_data_->n_uri);
			_data_->n_uri = _data_->_tmp10_;
			_g_free0 (_data_->file_type);
			_data_->file_type = _data_->_tmp11_;
			_data_->_tmp8_ = _data_->_tmp12_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->parent);
				_g_free0 (_data_->file_type);
				_g_free0 (_data_->n_uri);
				_usage_tracker_worker_unref0 (_data_->worker);
				goto __catch0_g_error;
			}
			if (!_data_->_tmp8_) {
				break;
			}
			if (!g_cancellable_is_cancelled (_data_->cancellable)) {
				_data_->_tmp13_ = _data_->n_uri;
				_data_->_tmp14_ = g_file_new_for_uri (_data_->_tmp13_);
				_data_->file = _data_->_tmp14_;
				_data_->_tmp15_ = _data_->file;
				_data_->_tmp16_ = usage_storage_view_item_from_file (_data_->_tmp15_);
				_data_->item = _data_->_tmp16_;
				_data_->_tmp17_ = _data_->item;
				if (_data_->_tmp17_ == NULL) {
					_g_object_unref0 (_data_->item);
					_g_object_unref0 (_data_->file);
					continue;
				}
				_data_->_tmp18_ = _data_->item;
				_data_->_tmp19_ = _data_->file_type;
				_data_->_tmp20_ = g_strdup (_data_->_tmp19_);
				_g_free0 (_data_->_tmp18_->ontology);
				_data_->_tmp18_->ontology = _data_->_tmp20_;
				_data_->_tmp21_ = _data_->item;
				_data_->_tmp22_ = __g_user_directory_dup0 (_data_->dir);
				_g_free0 (_data_->_tmp21_->dir);
				_data_->_tmp21_->dir = _data_->_tmp22_;
				_data_->_tmp23_ = _data_->item;
				if (_data_->_tmp23_->type == G_FILE_TYPE_DIRECTORY) {
					_data_->_tmp25_ = _data_->n_uri;
					_data_->_state_ = 4;
					usage_tracker_controller_get_file_size (_data_->self, _data_->_tmp25_, usage_tracker_controller_enumerate_children_ready, _data_);
					return FALSE;
					_state_4:
					_data_->_tmp24_ = usage_tracker_controller_get_file_size_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->item);
						_g_object_unref0 (_data_->file);
						_g_object_unref0 (_data_->parent);
						_g_free0 (_data_->file_type);
						_g_free0 (_data_->n_uri);
						_usage_tracker_worker_unref0 (_data_->worker);
						goto __catch0_g_error;
					}
					_data_->_tmp26_ = _data_->item;
					_data_->_tmp26_->size = _data_->_tmp24_;
				}
				_data_->_tmp27_ = _data_->item;
				_data_->_tmp28_ = _data_->item;
				usage_storage_view_item_set_percentage (_data_->_tmp27_, (_data_->_tmp28_->size * 100) / ((gdouble) _data_->parent_size));
				_data_->_tmp29_ = _data_->item;
				_data_->uri_size += _data_->_tmp29_->size;
				_data_->_tmp30_ = _data_->self->priv->model;
				_data_->_tmp31_ = _data_->item;
				g_list_store_insert_sorted (_data_->_tmp30_, (GObject*) _data_->_tmp31_, ______lambda37__gcompare_data_func, _data_->self);
				_g_object_unref0 (_data_->item);
				_g_object_unref0 (_data_->file);
			} else {
				_data_->result = _data_->uri_size;
				_g_object_unref0 (_data_->parent);
				_g_free0 (_data_->file_type);
				_g_free0 (_data_->n_uri);
				_usage_tracker_worker_unref0 (_data_->worker);
				_g_free0 (_data_->query);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (_data_->parent);
		_g_free0 (_data_->file_type);
		_g_free0 (_data_->n_uri);
		_usage_tracker_worker_unref0 (_data_->worker);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp32_ = _data_->_error_;
		_data_->_tmp33_ = _data_->_tmp32_->message;
		g_warning ("tracker-controller.vala:91: %s", _data_->_tmp33_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->uri_size;
	_g_free0 (_data_->query);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static guint64
usage_tracker_controller_get_g_file_size (UsageTrackerController* self,
                                          const gchar* uri)
{
	guint64 _tmp2_ = 0ULL;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	g_return_val_if_fail (uri != NULL, 0ULL);
	{
		GFile* file = NULL;
		GFile* _tmp0_;
		GFileInfo* info = NULL;
		GFileInfo* _tmp1_;
		_tmp0_ = g_file_new_for_uri (uri);
		file = _tmp0_;
		_tmp1_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		result = (guint64) g_file_info_get_size (info);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = (guint64) 0;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp2_;
}

static void
usage_tracker_controller_get_file_size_data_free (gpointer _data)
{
	UsageTrackerControllerGetFileSizeData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (UsageTrackerControllerGetFileSizeData, _data_);
}

void
usage_tracker_controller_get_file_size (UsageTrackerController* self,
                                        const gchar* uri,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	UsageTrackerControllerGetFileSizeData* _data_;
	UsageTrackerController* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (UsageTrackerControllerGetFileSizeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, usage_tracker_controller_get_file_size_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	usage_tracker_controller_get_file_size_co (_data_);
}

guint64
usage_tracker_controller_get_file_size_finish (UsageTrackerController* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	guint64 result;
	UsageTrackerControllerGetFileSizeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		guint64 _tmp0_ = 0ULL;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
usage_tracker_controller_get_file_size_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	UsageTrackerControllerGetFileSizeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	usage_tracker_controller_get_file_size_co (_data_);
}

static gboolean
usage_tracker_controller_get_file_size_co (UsageTrackerControllerGetFileSizeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->total = (guint64) 0;
	_data_->_tmp0_ = _data_->self->priv->query_builder;
	_data_->_tmp1_ = usage_storage_query_builder_enumerate_children (_data_->_tmp0_, _data_->uri, TRUE);
	_data_->query = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->connection;
	_data_->_tmp3_ = _data_->query;
	_data_->_state_ = 1;
	usage_tracker_worker_new (_data_->_tmp2_, _data_->_tmp3_, usage_tracker_controller_get_file_size_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = usage_tracker_worker_new_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->worker = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->query);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->n_uri = NULL;
	while (TRUE) {
		_data_->_tmp6_ = _data_->worker;
		_data_->_tmp7_ = NULL;
		_data_->_state_ = 2;
		usage_tracker_worker_fetch_next (_data_->_tmp6_, usage_tracker_controller_get_file_size_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = usage_tracker_worker_fetch_next_finish (_data_->_tmp6_, _data_->_res_, &_data_->_tmp7_, NULL, &_data_->_inner_error0_);
		_g_free0 (_data_->n_uri);
		_data_->n_uri = _data_->_tmp7_;
		_data_->_tmp5_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->n_uri);
			_usage_tracker_worker_unref0 (_data_->worker);
			_g_free0 (_data_->query);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (!_data_->_tmp5_) {
			break;
		}
		_data_->_tmp9_ = _data_->n_uri;
		_data_->total += usage_tracker_controller_get_g_file_size (_data_->self, _data_->_tmp9_);
	}
	_data_->result = _data_->total;
	_g_free0 (_data_->n_uri);
	_usage_tracker_worker_unref0 (_data_->worker);
	_g_free0 (_data_->query);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GObject *
usage_tracker_controller_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	UsageTrackerController * self;
	UsageStorageQueryBuilder* _tmp0_;
	parent_class = G_OBJECT_CLASS (usage_tracker_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_TRACKER_CONTROLLER, UsageTrackerController);
	_tmp0_ = usage_storage_query_builder_new ();
	_usage_storage_query_builder_unref0 (self->priv->query_builder);
	self->priv->query_builder = _tmp0_;
	return obj;
}

static void
usage_tracker_controller_class_init (UsageTrackerControllerClass * klass,
                                     gpointer klass_data)
{
	usage_tracker_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageTrackerController_private_offset);
	G_OBJECT_CLASS (klass)->constructor = usage_tracker_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = usage_tracker_controller_finalize;
}

static void
usage_tracker_controller_instance_init (UsageTrackerController * self,
                                        gpointer klass)
{
	self->priv = usage_tracker_controller_get_instance_private (self);
}

static void
usage_tracker_controller_finalize (GObject * obj)
{
	UsageTrackerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_TRACKER_CONTROLLER, UsageTrackerController);
	_g_object_unref0 (self->priv->connection);
	_usage_storage_query_builder_unref0 (self->priv->query_builder);
	_g_object_unref0 (self->priv->model);
	G_OBJECT_CLASS (usage_tracker_controller_parent_class)->finalize (obj);
}

static GType
usage_tracker_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageTrackerControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_tracker_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageTrackerController), 0, (GInstanceInitFunc) usage_tracker_controller_instance_init, NULL };
	GType usage_tracker_controller_type_id;
	usage_tracker_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "UsageTrackerController", &g_define_type_info, 0);
	UsageTrackerController_private_offset = g_type_add_instance_private (usage_tracker_controller_type_id, sizeof (UsageTrackerControllerPrivate));
	return usage_tracker_controller_type_id;
}

GType
usage_tracker_controller_get_type (void)
{
	static volatile gsize usage_tracker_controller_type_id__once = 0;
	if (g_once_init_enter (&usage_tracker_controller_type_id__once)) {
		GType usage_tracker_controller_type_id;
		usage_tracker_controller_type_id = usage_tracker_controller_get_type_once ();
		g_once_init_leave (&usage_tracker_controller_type_id__once, usage_tracker_controller_type_id);
	}
	return usage_tracker_controller_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

