/* system-monitor.c generated by valac 0.56.18, the Vala compiler
 * generated from system-monitor.vala, do not modify */

/* system-monitor.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glibtop.h>
#include <gio/gio.h>
#include <glibtop/proclist.h>
#include <glibtop/proctime.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_SYSTEM_MONITOR (usage_system_monitor_get_type ())
#define USAGE_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitor))
#define USAGE_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))
#define USAGE_IS_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_IS_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_SYSTEM_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))

typedef struct _UsageSystemMonitor UsageSystemMonitor;
typedef struct _UsageSystemMonitorClass UsageSystemMonitorClass;
typedef struct _UsageSystemMonitorPrivate UsageSystemMonitorPrivate;

#define USAGE_TYPE_BACKGROUND_MONITOR (usage_background_monitor_get_type ())
#define USAGE_BACKGROUND_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_BACKGROUND_MONITOR, UsageBackgroundMonitor))
#define USAGE_BACKGROUND_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_BACKGROUND_MONITOR, UsageBackgroundMonitorClass))
#define USAGE_IS_BACKGROUND_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_BACKGROUND_MONITOR))
#define USAGE_IS_BACKGROUND_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_BACKGROUND_MONITOR))
#define USAGE_BACKGROUND_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_BACKGROUND_MONITOR, UsageBackgroundMonitorClass))

typedef struct _UsageBackgroundMonitor UsageBackgroundMonitor;
typedef struct _UsageBackgroundMonitorClass UsageBackgroundMonitorClass;

#define USAGE_TYPE_CPU_MONITOR (usage_cpu_monitor_get_type ())
#define USAGE_CPU_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_CPU_MONITOR, UsageCpuMonitor))
#define USAGE_CPU_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_CPU_MONITOR, UsageCpuMonitorClass))
#define USAGE_IS_CPU_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_CPU_MONITOR))
#define USAGE_IS_CPU_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_CPU_MONITOR))
#define USAGE_CPU_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_CPU_MONITOR, UsageCpuMonitorClass))

typedef struct _UsageCpuMonitor UsageCpuMonitor;
typedef struct _UsageCpuMonitorClass UsageCpuMonitorClass;

#define USAGE_TYPE_MEMORY_MONITOR (usage_memory_monitor_get_type ())
#define USAGE_MEMORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_MEMORY_MONITOR, UsageMemoryMonitor))
#define USAGE_MEMORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_MEMORY_MONITOR, UsageMemoryMonitorClass))
#define USAGE_IS_MEMORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_MEMORY_MONITOR))
#define USAGE_IS_MEMORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_MEMORY_MONITOR))
#define USAGE_MEMORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_MEMORY_MONITOR, UsageMemoryMonitorClass))

typedef struct _UsageMemoryMonitor UsageMemoryMonitor;
typedef struct _UsageMemoryMonitorClass UsageMemoryMonitorClass;

#define GAME_MODE_TYPE_PID_LIST (game_mode_pid_list_get_type ())
#define GAME_MODE_PID_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_MODE_TYPE_PID_LIST, GameModePidList))
#define GAME_MODE_PID_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_MODE_TYPE_PID_LIST, GameModePidListClass))
#define GAME_MODE_IS_PID_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_MODE_TYPE_PID_LIST))
#define GAME_MODE_IS_PID_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_MODE_TYPE_PID_LIST))
#define GAME_MODE_PID_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_MODE_TYPE_PID_LIST, GameModePidListClass))

typedef struct _GameModePidList GameModePidList;
typedef struct _GameModePidListClass GameModePidListClass;

#define USAGE_TYPE_APP_ITEM (usage_app_item_get_type ())
#define USAGE_APP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_APP_ITEM, UsageAppItem))
#define USAGE_APP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_APP_ITEM, UsageAppItemClass))
#define USAGE_IS_APP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_APP_ITEM))
#define USAGE_IS_APP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_APP_ITEM))
#define USAGE_APP_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_APP_ITEM, UsageAppItemClass))

typedef struct _UsageAppItem UsageAppItem;
typedef struct _UsageAppItemClass UsageAppItemClass;

#define USAGE_TYPE_PROCESS (usage_process_get_type ())
#define USAGE_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PROCESS, UsageProcess))
#define USAGE_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PROCESS, UsageProcessClass))
#define USAGE_IS_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PROCESS))
#define USAGE_IS_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PROCESS))
#define USAGE_PROCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PROCESS, UsageProcessClass))

typedef struct _UsageProcess UsageProcess;
typedef struct _UsageProcessClass UsageProcessClass;
enum  {
	USAGE_SYSTEM_MONITOR_0_PROPERTY,
	USAGE_SYSTEM_MONITOR_PROCESS_LIST_READY_PROPERTY,
	USAGE_SYSTEM_MONITOR_CPU_LOAD_PROPERTY,
	USAGE_SYSTEM_MONITOR_RAM_USAGE_PROPERTY,
	USAGE_SYSTEM_MONITOR_RAM_TOTAL_PROPERTY,
	USAGE_SYSTEM_MONITOR_SWAP_USAGE_PROPERTY,
	USAGE_SYSTEM_MONITOR_SWAP_TOTAL_PROPERTY,
	USAGE_SYSTEM_MONITOR_GROUP_SYSTEM_APPS_PROPERTY,
	USAGE_SYSTEM_MONITOR_NUM_PROPERTIES
};
static GParamSpec* usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _usage_cpu_monitor_unref0(var) ((var == NULL) ? NULL : (var = (usage_cpu_monitor_unref (var), NULL)))
#define _usage_memory_monitor_unref0(var) ((var == NULL) ? NULL : (var = (usage_memory_monitor_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define USAGE_TYPE_SETTINGS (usage_settings_get_type ())
#define USAGE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SETTINGS, UsageSettings))
#define USAGE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SETTINGS, UsageSettingsClass))
#define USAGE_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SETTINGS))
#define USAGE_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SETTINGS))
#define USAGE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SETTINGS, UsageSettingsClass))

typedef struct _UsageSettings UsageSettings;
typedef struct _UsageSettingsClass UsageSettingsClass;
typedef struct _Block14Data Block14Data;

#define USAGE_TYPE_MONITOR (usage_monitor_get_type ())
#define USAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_MONITOR, UsageMonitor))
#define USAGE_IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_MONITOR))
#define USAGE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), USAGE_TYPE_MONITOR, UsageMonitorIface))

typedef struct _UsageMonitor UsageMonitor;
typedef struct _UsageMonitorIface UsageMonitorIface;

#define ORG_FREEDESKTOP_BACKGROUND_TYPE_BACKGROUND_APP (org_freedesktop_background_background_app_get_type ())
typedef struct _orgfreedesktopbackgroundBackgroundApp orgfreedesktopbackgroundBackgroundApp;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _UsageSystemMonitor {
	GObject parent_instance;
	UsageSystemMonitorPrivate * priv;
};

struct _UsageSystemMonitorClass {
	GObjectClass parent_class;
};

struct _UsageSystemMonitorPrivate {
	gboolean _process_list_ready;
	gdouble _cpu_load;
	gdouble* _x_cpu_load;
	gint _x_cpu_load_length1;
	gint __x_cpu_load_size_;
	guint64 _ram_usage;
	guint64 _ram_total;
	guint64 _swap_usage;
	guint64 _swap_total;
	gboolean _group_system_apps;
	UsageBackgroundMonitor* background_monitor;
	UsageCpuMonitor* cpu_monitor;
	UsageMemoryMonitor* memory_monitor;
	GameModePidList* gamemode_pids;
	GHashTable* app_table;
	GHashTable* process_table;
	gint process_mode;
};

struct _Block14Data {
	int _ref_count_;
	UsageSystemMonitor* self;
	gchar** background_app_ids;
	gint background_app_ids_length1;
	gint _background_app_ids_size_;
};

struct _UsageMonitorIface {
	GTypeInterface parent_iface;
	void (*update) (UsageMonitor* self);
	void (*update_process) (UsageMonitor* self, UsageProcess** process);
};

struct _orgfreedesktopbackgroundBackgroundApp {
	gchar* app_id;
	gchar* instance;
	gchar* message;
};

static gint UsageSystemMonitor_private_offset;
static gpointer usage_system_monitor_parent_class = NULL;
static UsageSystemMonitor* usage_system_monitor_system_monitor;
static UsageSystemMonitor* usage_system_monitor_system_monitor = NULL;

VALA_EXTERN GType usage_system_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSystemMonitor, g_object_unref)
VALA_EXTERN GType usage_background_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageBackgroundMonitor, g_object_unref)
VALA_EXTERN gpointer usage_cpu_monitor_ref (gpointer instance);
VALA_EXTERN void usage_cpu_monitor_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_cpu_monitor (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void usage_value_set_cpu_monitor (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void usage_value_take_cpu_monitor (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer usage_value_get_cpu_monitor (const GValue* value);
VALA_EXTERN GType usage_cpu_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageCpuMonitor, usage_cpu_monitor_unref)
VALA_EXTERN gpointer usage_memory_monitor_ref (gpointer instance);
VALA_EXTERN void usage_memory_monitor_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_memory_monitor (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void usage_value_set_memory_monitor (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void usage_value_take_memory_monitor (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer usage_value_get_memory_monitor (const GValue* value);
VALA_EXTERN GType usage_memory_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageMemoryMonitor, usage_memory_monitor_unref)
VALA_EXTERN GType game_mode_pid_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameModePidList, g_object_unref)
VALA_EXTERN GType usage_app_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageAppItem, g_object_unref)
VALA_EXTERN GType usage_process_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageProcess, g_object_unref)
VALA_EXTERN UsageSystemMonitor* usage_system_monitor_get_default (void);
VALA_EXTERN UsageSystemMonitor* usage_system_monitor_new (void);
VALA_EXTERN UsageSystemMonitor* usage_system_monitor_construct (GType object_type);
VALA_EXTERN GList* usage_system_monitor_get_apps (UsageSystemMonitor* self);
VALA_EXTERN UsageAppItem* usage_system_monitor_get_app_by_name (UsageSystemMonitor* self,
                                                    const gchar* name);
VALA_EXTERN void usage_app_item_init (void);
VALA_EXTERN UsageBackgroundMonitor* usage_background_monitor_new (void);
VALA_EXTERN UsageBackgroundMonitor* usage_background_monitor_construct (GType object_type);
VALA_EXTERN UsageCpuMonitor* usage_cpu_monitor_new (void);
VALA_EXTERN UsageCpuMonitor* usage_cpu_monitor_construct (GType object_type);
VALA_EXTERN UsageMemoryMonitor* usage_memory_monitor_new (void);
VALA_EXTERN UsageMemoryMonitor* usage_memory_monitor_construct (GType object_type);
VALA_EXTERN GameModePidList* game_mode_pid_list_new (void);
VALA_EXTERN GameModePidList* game_mode_pid_list_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN GType usage_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSettings, g_object_unref)
VALA_EXTERN UsageSettings* usage_settings_get_default (void);
static void usage_system_monitor_init (UsageSystemMonitor* self);
static void __lambda16_ (UsageSystemMonitor* self,
                  GObject* sender,
                  GParamSpec* property);
static void ___lambda16__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN guint usage_settings_get_data_update_interval (UsageSettings* self);
static gboolean usage_system_monitor_update_data (UsageSystemMonitor* self);
static gboolean _usage_system_monitor_update_data_gsource_func (gpointer self);
static void usage_system_monitor_set_process_list_ready (UsageSystemMonitor* self,
                                                  gboolean value);
VALA_EXTERN gboolean usage_system_monitor_get_group_system_apps (UsageSystemMonitor* self);
VALA_EXTERN UsageAppItem* usage_app_item_new_system (void);
VALA_EXTERN UsageAppItem* usage_app_item_construct_system (GType object_type);
static void usage_system_monitor_process_added (UsageSystemMonitor* self,
                                         UsageProcess* p);
static gboolean __lambda15_ (UsageSystemMonitor* self);
static gboolean ___lambda15__gsource_func (gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
VALA_EXTERN GType usage_monitor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void usage_monitor_update (UsageMonitor* self);
VALA_EXTERN gdouble usage_cpu_monitor_get_cpu_load (UsageCpuMonitor* self);
static void usage_system_monitor_set_cpu_load (UsageSystemMonitor* self,
                                        gdouble value);
VALA_EXTERN gdouble* usage_cpu_monitor_get_x_cpu_load (UsageCpuMonitor* self,
                                           gint* result_length1);
static void usage_system_monitor_set_x_cpu_load (UsageSystemMonitor* self,
                                          gdouble* value,
                                          gint value_length1);
VALA_EXTERN guint64 usage_memory_monitor_get_ram_usage (UsageMemoryMonitor* self);
static void usage_system_monitor_set_ram_usage (UsageSystemMonitor* self,
                                         guint64 value);
VALA_EXTERN guint64 usage_memory_monitor_get_ram_total (UsageMemoryMonitor* self);
static void usage_system_monitor_set_ram_total (UsageSystemMonitor* self,
                                         guint64 value);
VALA_EXTERN guint64 usage_memory_monitor_get_swap_usage (UsageMemoryMonitor* self);
static void usage_system_monitor_set_swap_usage (UsageSystemMonitor* self,
                                          guint64 value);
VALA_EXTERN guint64 usage_memory_monitor_get_swap_total (UsageMemoryMonitor* self);
static void usage_system_monitor_set_swap_total (UsageSystemMonitor* self,
                                          guint64 value);
VALA_EXTERN void usage_app_item_mark_as_not_updated (UsageAppItem* self);
VALA_EXTERN void usage_system_monitor_sort_pids (void* pids,
                                     gsize elm,
                                     gsize length);
static void usage_system_monitor_process_removed (UsageSystemMonitor* self,
                                           UsageProcess* p);
VALA_EXTERN UsageProcess* usage_process_new (GPid pid);
VALA_EXTERN UsageProcess* usage_process_construct (GType object_type,
                                       GPid pid);
static void usage_system_monitor_update_process (UsageSystemMonitor* self,
                                          UsageProcess** process);
VALA_EXTERN GPid usage_process_get_pid (UsageProcess* self);
VALA_EXTERN guint64 usage_process_get_start_time (UsageProcess* self);
VALA_EXTERN void usage_app_item_remove_processes (UsageAppItem* self);
VALA_EXTERN GType org_freedesktop_background_background_app_get_type (void) G_GNUC_CONST ;
VALA_EXTERN orgfreedesktopbackgroundBackgroundApp* org_freedesktop_background_background_app_dup (const orgfreedesktopbackgroundBackgroundApp* self);
VALA_EXTERN void org_freedesktop_background_background_app_free (orgfreedesktopbackgroundBackgroundApp* self);
VALA_EXTERN void org_freedesktop_background_background_app_copy (const orgfreedesktopbackgroundBackgroundApp* self,
                                                     orgfreedesktopbackgroundBackgroundApp* dest);
VALA_EXTERN void org_freedesktop_background_background_app_destroy (orgfreedesktopbackgroundBackgroundApp* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (orgfreedesktopbackgroundBackgroundApp, org_freedesktop_background_background_app_destroy)
VALA_EXTERN orgfreedesktopbackgroundBackgroundApp* usage_background_monitor_get_background_apps (UsageBackgroundMonitor* self,
                                                                                     gint* result_length1);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_orgfreedesktopbackgroundBackgroundApp_array_free (orgfreedesktopbackgroundBackgroundApp * array,
                                                             gssize array_length);
static void __lambda14_ (Block14Data* _data14_,
                  const gchar* app_id,
                  UsageAppItem* app);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN void usage_app_item_set_is_background (UsageAppItem* self,
                                       gboolean value);
static void ___lambda14__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static gchar* usage_system_monitor_get_app_id_for_process (UsageSystemMonitor* self,
                                                    UsageProcess* p);
VALA_EXTERN UsageAppItem* usage_app_item_new (UsageProcess* process);
VALA_EXTERN UsageAppItem* usage_app_item_construct (GType object_type,
                                        UsageProcess* process);
VALA_EXTERN gboolean usage_app_item_contains_process (UsageAppItem* self,
                                          GPid pid);
VALA_EXTERN void usage_app_item_insert_process (UsageAppItem* self,
                                    UsageProcess* process);
VALA_EXTERN void usage_app_item_remove_process (UsageAppItem* self,
                                    UsageProcess* process);
VALA_EXTERN GAppInfo* usage_app_item_app_info_for_process (UsageProcess* p);
VALA_EXTERN const gchar* usage_process_get_cmdline (UsageProcess* self);
VALA_EXTERN gchar* usage_process_read_cgroup (GPid pid);
VALA_EXTERN void usage_monitor_update_process (UsageMonitor* self,
                                   UsageProcess** process);
VALA_EXTERN void usage_process_update_status (UsageProcess* self);
VALA_EXTERN gboolean game_mode_pid_list_contains (GameModePidList* self,
                                      gint pid);
VALA_EXTERN void usage_process_set_gamemode (UsageProcess* self,
                                 gboolean value);
static gint __lambda13_ (void* a,
                  void* b);
static gint ___lambda13____compar_fn_t (void* key1,
                                 void* key2);
VALA_EXTERN gboolean usage_system_monitor_get_process_list_ready (UsageSystemMonitor* self);
VALA_EXTERN gdouble usage_system_monitor_get_cpu_load (UsageSystemMonitor* self);
VALA_EXTERN gdouble* usage_system_monitor_get_x_cpu_load (UsageSystemMonitor* self,
                                              gint* result_length1);
static gdouble* _vala_array_dup6 (gdouble* self,
                           gssize length);
VALA_EXTERN guint64 usage_system_monitor_get_ram_usage (UsageSystemMonitor* self);
VALA_EXTERN guint64 usage_system_monitor_get_ram_total (UsageSystemMonitor* self);
VALA_EXTERN guint64 usage_system_monitor_get_swap_usage (UsageSystemMonitor* self);
VALA_EXTERN guint64 usage_system_monitor_get_swap_total (UsageSystemMonitor* self);
VALA_EXTERN void usage_system_monitor_set_group_system_apps (UsageSystemMonitor* self,
                                                 gboolean value);
static void usage_system_monitor_finalize (GObject * obj);
static GType usage_system_monitor_get_type_once (void);
static void _vala_usage_system_monitor_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_usage_system_monitor_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_system_monitor_get_instance_private (UsageSystemMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, UsageSystemMonitor_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

UsageSystemMonitor*
usage_system_monitor_get_default (void)
{
	UsageSystemMonitor* _tmp0_;
	UsageSystemMonitor* _tmp2_;
	UsageSystemMonitor* _tmp3_;
	UsageSystemMonitor* result;
	_tmp0_ = usage_system_monitor_system_monitor;
	if (_tmp0_ == NULL) {
		UsageSystemMonitor* _tmp1_;
		_tmp1_ = usage_system_monitor_new ();
		_g_object_unref0 (usage_system_monitor_system_monitor);
		usage_system_monitor_system_monitor = _tmp1_;
	}
	_tmp2_ = usage_system_monitor_system_monitor;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

GList*
usage_system_monitor_get_apps (UsageSystemMonitor* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->app_table;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	result = _tmp1_;
	return result;
}

UsageAppItem*
usage_system_monitor_get_app_by_name (UsageSystemMonitor* self,
                                      const gchar* name)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	UsageAppItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->app_table;
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	result = (UsageAppItem*) _tmp1_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
__lambda16_ (UsageSystemMonitor* self,
             GObject* sender,
             GParamSpec* property)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (property != NULL);
	usage_system_monitor_init (self);
}

static void
___lambda16__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda16_ ((UsageSystemMonitor*) self, _sender, pspec);
}

static gboolean
_usage_system_monitor_update_data_gsource_func (gpointer self)
{
	gboolean result;
	result = usage_system_monitor_update_data ((UsageSystemMonitor*) self);
	return result;
}

UsageSystemMonitor*
usage_system_monitor_construct (GType object_type)
{
	UsageSystemMonitor * self = NULL;
	UsageBackgroundMonitor* _tmp0_;
	UsageCpuMonitor* _tmp1_;
	UsageMemoryMonitor* _tmp2_;
	GameModePidList* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	UsageSettings* settings = NULL;
	UsageSettings* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	self = (UsageSystemMonitor*) g_object_new (object_type, NULL);
	glibtop_init ();
	usage_app_item_init ();
	_tmp0_ = usage_background_monitor_new ();
	_g_object_unref0 (self->priv->background_monitor);
	self->priv->background_monitor = _tmp0_;
	_tmp1_ = usage_cpu_monitor_new ();
	_usage_cpu_monitor_unref0 (self->priv->cpu_monitor);
	self->priv->cpu_monitor = _tmp1_;
	_tmp2_ = usage_memory_monitor_new ();
	_usage_memory_monitor_unref0 (self->priv->memory_monitor);
	self->priv->memory_monitor = _tmp2_;
	_tmp3_ = game_mode_pid_list_new ();
	_g_object_unref0 (self->priv->gamemode_pids);
	self->priv->gamemode_pids = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->app_table);
	self->priv->app_table = _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->process_table);
	self->priv->process_table = _tmp9_;
	_tmp10_ = usage_settings_get_default ();
	settings = _tmp10_;
	usage_system_monitor_init (self);
	g_signal_connect_object ((GObject*) self, "notify::group-system-apps", (GCallback) ___lambda16__g_object_notify, self, 0);
	_tmp11_ = usage_settings_get_data_update_interval (settings);
	_tmp12_ = _tmp11_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp12_, _usage_system_monitor_update_data_gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (settings);
	return self;
}

UsageSystemMonitor*
usage_system_monitor_new (void)
{
	return usage_system_monitor_construct (USAGE_TYPE_SYSTEM_MONITOR);
}

static gboolean
__lambda15_ (UsageSystemMonitor* self)
{
	gboolean result;
	usage_system_monitor_set_process_list_ready (self, TRUE);
	result = FALSE;
	return result;
}

static gboolean
___lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda15_ ((UsageSystemMonitor*) self);
	return result;
}

static void
usage_system_monitor_init (UsageSystemMonitor* self)
{
	UsageSettings* settings = NULL;
	UsageSettings* _tmp0_;
	GHashTable* _tmp1_;
	gboolean _tmp2_;
	GHashTable* _tmp8_;
	GList* _tmp9_;
	UsageSettings* _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = usage_settings_get_default ();
	settings = _tmp0_;
	_tmp1_ = self->priv->app_table;
	g_hash_table_remove_all (_tmp1_);
	usage_system_monitor_set_process_list_ready (self, FALSE);
	_tmp2_ = self->priv->_group_system_apps;
	if (_tmp2_) {
		UsageAppItem* system = NULL;
		UsageAppItem* _tmp3_;
		GHashTable* _tmp4_;
		gchar* _tmp5_;
		UsageAppItem* _tmp6_;
		UsageAppItem* _tmp7_;
		_tmp3_ = usage_app_item_new_system ();
		system = _tmp3_;
		_tmp4_ = self->priv->app_table;
		_tmp5_ = g_strdup ("system");
		_tmp6_ = system;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
		_g_object_unref0 (system);
	}
	_tmp8_ = self->priv->process_table;
	_tmp9_ = g_hash_table_get_values (_tmp8_);
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp9_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			UsageProcess* p = NULL;
			p = (UsageProcess*) p_it->data;
			{
				UsageProcess* _tmp10_;
				_tmp10_ = p;
				usage_system_monitor_process_added (self, _tmp10_);
			}
		}
		(p_collection == NULL) ? NULL : (p_collection = (g_list_free (p_collection), NULL));
	}
	usage_system_monitor_update_data (self);
	_tmp11_ = settings;
	_tmp12_ = usage_settings_get_data_update_interval (_tmp11_);
	_tmp13_ = _tmp12_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp13_, ___lambda15__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (settings);
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		UsageSystemMonitor* self;
		self = _data14_->self;
		_data14_->background_app_ids = (_vala_array_free (_data14_->background_app_ids, _data14_->background_app_ids_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_orgfreedesktopbackgroundBackgroundApp_array_free (orgfreedesktopbackgroundBackgroundApp * array,
                                                        gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			org_freedesktop_background_background_app_destroy (&array[i]);
		}
	}
	g_free (array);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
__lambda14_ (Block14Data* _data14_,
             const gchar* app_id,
             UsageAppItem* app)
{
	UsageSystemMonitor* self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	self = _data14_->self;
	g_return_if_fail (app_id != NULL);
	g_return_if_fail (app != NULL);
	_tmp0_ = strlen (app_id);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (".desktop");
	_tmp3_ = _tmp2_;
	_tmp4_ = string_substring (app_id, (glong) 0, (glong) (_tmp1_ - _tmp3_));
	_tmp5_ = _tmp4_;
	_tmp6_ = _data14_->background_app_ids;
	_tmp6__length1 = _data14_->background_app_ids_length1;
	usage_app_item_set_is_background (app, _vala_string_array_contains (_tmp6_, _tmp6__length1, _tmp5_));
	_g_free0 (_tmp5_);
}

static void
___lambda14__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda14_ (self, (const gchar*) key, (UsageAppItem*) value);
}

static gboolean
usage_system_monitor_update_data (UsageSystemMonitor* self)
{
	Block14Data* _data14_;
	UsageCpuMonitor* _tmp0_;
	UsageMemoryMonitor* _tmp1_;
	UsageCpuMonitor* _tmp2_;
	UsageCpuMonitor* _tmp3_;
	gint _tmp4_ = 0;
	gdouble* _tmp5_;
	gdouble* _tmp6_;
	gint _tmp6__length1;
	UsageMemoryMonitor* _tmp7_;
	UsageMemoryMonitor* _tmp8_;
	UsageMemoryMonitor* _tmp9_;
	UsageMemoryMonitor* _tmp10_;
	GHashTable* _tmp11_;
	GList* _tmp12_;
	glibtop_proclist proclist = {0};
	GPid* pids = NULL;
	glibtop_proclist _tmp14_ = {0};
	GPid* _tmp15_;
	gint pids_length1;
	gint _pids_size_;
	gintptr* old = NULL;
	GHashTable* _tmp16_;
	guint _tmp17_ = 0;
	gconstpointer* _tmp18_;
	gint old_length1;
	gint _old_size_;
	gsize new_len = 0UL;
	glibtop_proclist _tmp19_;
	gsize old_len = 0UL;
	GHashTable* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	GPid* _tmp23_;
	gint _tmp23__length1;
	gintptr* _tmp24_;
	gint _tmp24__length1;
	guint removed = 0U;
	guint added = 0U;
	GHashTable* _tmp59_;
	GList* _tmp60_;
	gchar** _tmp62_;
	UsageBackgroundMonitor* _tmp63_;
	gint _tmp64_ = 0;
	orgfreedesktopbackgroundBackgroundApp* _tmp65_;
	GHashTable* _tmp71_;
	GHashTable* _tmp72_;
	guint _tmp73_;
	guint _tmp74_;
	GHashTable* _tmp75_;
	guint _tmp76_;
	guint _tmp77_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = self->priv->cpu_monitor;
	usage_monitor_update ((UsageMonitor*) _tmp0_);
	_tmp1_ = self->priv->memory_monitor;
	usage_monitor_update ((UsageMonitor*) _tmp1_);
	_tmp2_ = self->priv->cpu_monitor;
	usage_system_monitor_set_cpu_load (self, usage_cpu_monitor_get_cpu_load (_tmp2_));
	_tmp3_ = self->priv->cpu_monitor;
	_tmp5_ = usage_cpu_monitor_get_x_cpu_load (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	usage_system_monitor_set_x_cpu_load (self, _tmp6_, _tmp4_);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp7_ = self->priv->memory_monitor;
	usage_system_monitor_set_ram_usage (self, usage_memory_monitor_get_ram_usage (_tmp7_));
	_tmp8_ = self->priv->memory_monitor;
	usage_system_monitor_set_ram_total (self, usage_memory_monitor_get_ram_total (_tmp8_));
	_tmp9_ = self->priv->memory_monitor;
	usage_system_monitor_set_swap_usage (self, usage_memory_monitor_get_swap_usage (_tmp9_));
	_tmp10_ = self->priv->memory_monitor;
	usage_system_monitor_set_swap_total (self, usage_memory_monitor_get_swap_total (_tmp10_));
	_tmp11_ = self->priv->app_table;
	_tmp12_ = g_hash_table_get_values (_tmp11_);
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp12_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			UsageAppItem* app = NULL;
			app = (UsageAppItem*) app_it->data;
			{
				UsageAppItem* _tmp13_;
				_tmp13_ = app;
				usage_app_item_mark_as_not_updated (_tmp13_);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (g_list_free (app_collection), NULL));
	}
	_tmp15_ = glibtop_get_proclist (&_tmp14_, (guint64) self->priv->process_mode, (guint64) 0);
	proclist = _tmp14_;
	pids = _tmp15_;
	pids_length1 = -1;
	_pids_size_ = pids_length1;
	_tmp16_ = self->priv->process_table;
	_tmp18_ = g_hash_table_get_keys_as_array (_tmp16_, &_tmp17_);
	old = (gintptr*) _tmp18_;
	old_length1 = (_tmp17_ * sizeof (GPid)) / sizeof (gintptr);
	_old_size_ = old_length1;
	_tmp19_ = proclist;
	new_len = (gsize) _tmp19_.number;
	_tmp20_ = self->priv->process_table;
	_tmp21_ = g_hash_table_size (_tmp20_);
	_tmp22_ = _tmp21_;
	old_len = (gsize) _tmp22_;
	_tmp23_ = pids;
	_tmp23__length1 = pids_length1;
	usage_system_monitor_sort_pids (_tmp23_, (gsize) sizeof (GPid), new_len);
	_tmp24_ = old;
	_tmp24__length1 = old_length1;
	usage_system_monitor_sort_pids (_tmp24_, (gsize) sizeof (gintptr), old_len);
	g_debug ("system-monitor.vala:124: new_len: %lu, old_len: %lu\n", (gulong) new_len, (gulong) old_len);
	removed = (guint) 0;
	added = (guint) 0;
	{
		gsize i = 0UL;
		gsize j = 0UL;
		i = (gsize) 0;
		j = (gsize) 0;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				gboolean _tmp26_ = FALSE;
				guint32 _tmp27_ = 0U;
				guint32 n = 0U;
				guint32 _tmp30_ = 0U;
				guint32 o = 0U;
				if (!_tmp25_) {
				}
				_tmp25_ = FALSE;
				if (i < new_len) {
					_tmp26_ = TRUE;
				} else {
					_tmp26_ = j < old_len;
				}
				if (!_tmp26_) {
					break;
				}
				if (i < new_len) {
					GPid* _tmp28_;
					gint _tmp28__length1;
					GPid _tmp29_;
					_tmp28_ = pids;
					_tmp28__length1 = pids_length1;
					_tmp29_ = _tmp28_[i];
					_tmp27_ = (guint32) _tmp29_;
				} else {
					_tmp27_ = G_MAXUINT32;
				}
				n = _tmp27_;
				if (j < old_len) {
					gintptr* _tmp31_;
					gint _tmp31__length1;
					gintptr _tmp32_;
					_tmp31_ = old;
					_tmp31__length1 = old_length1;
					_tmp32_ = _tmp31_[j];
					_tmp30_ = (guint32) _tmp32_;
				} else {
					_tmp30_ = G_MAXUINT32;
				}
				o = _tmp30_;
				if (n > o) {
					UsageProcess* p = NULL;
					GHashTable* _tmp33_;
					gconstpointer _tmp34_;
					UsageProcess* _tmp35_;
					UsageProcess* _tmp36_;
					guint _tmp37_;
					gsize _tmp38_;
					_tmp33_ = self->priv->process_table;
					_tmp34_ = g_hash_table_lookup (_tmp33_, (gpointer) ((gintptr) o));
					_tmp35_ = _g_object_ref0 ((UsageProcess*) _tmp34_);
					p = _tmp35_;
					g_debug ("system-monitor.vala:145: process removed: %u\n", (guint) o);
					_tmp36_ = p;
					usage_system_monitor_process_removed (self, _tmp36_);
					_tmp37_ = removed;
					removed = _tmp37_ + 1;
					_tmp38_ = j;
					j = _tmp38_ + 1;
					_g_object_unref0 (p);
				} else {
					if (n < o) {
						UsageProcess* p = NULL;
						UsageProcess* _tmp39_;
						UsageProcess* _tmp40_;
						guint _tmp41_;
						gsize _tmp42_;
						_tmp39_ = usage_process_new ((GPid) n);
						p = _tmp39_;
						usage_system_monitor_update_process (self, &p);
						g_debug ("system-monitor.vala:156: process added: %u\n", (guint) n);
						_tmp40_ = p;
						usage_system_monitor_process_added (self, _tmp40_);
						_tmp41_ = added;
						added = _tmp41_ + 1;
						_tmp42_ = i;
						i = _tmp42_ + 1;
						_g_object_unref0 (p);
					} else {
						UsageProcess* p = NULL;
						GHashTable* _tmp43_;
						gconstpointer _tmp44_;
						UsageProcess* _tmp45_;
						glibtop_proc_time ptime = {0};
						UsageProcess* _tmp46_;
						GPid _tmp47_;
						GPid _tmp48_;
						glibtop_proc_time _tmp49_ = {0};
						glibtop_proc_time _tmp50_;
						UsageProcess* _tmp51_;
						guint64 _tmp52_;
						guint64 _tmp53_;
						gsize _tmp57_;
						gsize _tmp58_;
						_tmp43_ = self->priv->process_table;
						_tmp44_ = g_hash_table_lookup (_tmp43_, (gpointer) ((gintptr) n));
						_tmp45_ = _g_object_ref0 ((UsageProcess*) _tmp44_);
						p = _tmp45_;
						_tmp46_ = p;
						_tmp47_ = usage_process_get_pid (_tmp46_);
						_tmp48_ = _tmp47_;
						glibtop_get_proc_time (&_tmp49_, _tmp48_);
						ptime = _tmp49_;
						_tmp50_ = ptime;
						_tmp51_ = p;
						_tmp52_ = usage_process_get_start_time (_tmp51_);
						_tmp53_ = _tmp52_;
						if (_tmp50_.start_time != _tmp53_) {
							UsageProcess* _tmp54_;
							UsageProcess* _tmp55_;
							UsageProcess* _tmp56_;
							g_debug ("system-monitor.vala:172: start time mismtach: %u\n", (guint) n);
							_tmp54_ = p;
							usage_system_monitor_process_removed (self, _tmp54_);
							_tmp55_ = usage_process_new ((GPid) n);
							_g_object_unref0 (p);
							p = _tmp55_;
							_tmp56_ = p;
							usage_system_monitor_process_added (self, _tmp56_);
						}
						usage_system_monitor_update_process (self, &p);
						_tmp57_ = i;
						i = _tmp57_ + 1;
						_tmp58_ = j;
						j = _tmp58_ + 1;
						_g_object_unref0 (p);
					}
				}
			}
		}
	}
	_tmp59_ = self->priv->app_table;
	_tmp60_ = g_hash_table_get_values (_tmp59_);
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp60_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			UsageAppItem* app = NULL;
			app = (UsageAppItem*) app_it->data;
			{
				UsageAppItem* _tmp61_;
				_tmp61_ = app;
				usage_app_item_remove_processes (_tmp61_);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (g_list_free (app_collection), NULL));
	}
	_tmp62_ = g_new0 (gchar*, 0 + 1);
	_data14_->background_app_ids = _tmp62_;
	_data14_->background_app_ids_length1 = 0;
	_data14_->_background_app_ids_size_ = _data14_->background_app_ids_length1;
	_tmp63_ = self->priv->background_monitor;
	_tmp65_ = usage_background_monitor_get_background_apps (_tmp63_, &_tmp64_);
	{
		orgfreedesktopbackgroundBackgroundApp* background_app_collection = NULL;
		gint background_app_collection_length1 = 0;
		gint _background_app_collection_size_ = 0;
		gint background_app_it = 0;
		background_app_collection = _tmp65_;
		background_app_collection_length1 = _tmp64_;
		for (background_app_it = 0; background_app_it < background_app_collection_length1; background_app_it = background_app_it + 1) {
			orgfreedesktopbackgroundBackgroundApp _tmp66_;
			orgfreedesktopbackgroundBackgroundApp _tmp67_ = {0};
			orgfreedesktopbackgroundBackgroundApp background_app = {0};
			_tmp66_ = background_app_collection[background_app_it];
			org_freedesktop_background_background_app_copy (&_tmp66_, &_tmp67_);
			background_app = _tmp67_;
			{
				orgfreedesktopbackgroundBackgroundApp _tmp68_;
				const gchar* _tmp69_;
				gchar* _tmp70_;
				_tmp68_ = background_app;
				_tmp69_ = _tmp68_.app_id;
				_tmp70_ = g_strdup (_tmp69_);
				_vala_array_add2 (&_data14_->background_app_ids, &_data14_->background_app_ids_length1, &_data14_->_background_app_ids_size_, _tmp70_);
				org_freedesktop_background_background_app_destroy (&background_app);
			}
		}
		background_app_collection = (_vala_orgfreedesktopbackgroundBackgroundApp_array_free (background_app_collection, background_app_collection_length1), NULL);
	}
	_tmp71_ = self->priv->app_table;
	g_hash_table_foreach (_tmp71_, ___lambda14__gh_func, _data14_);
	g_debug ("system-monitor.vala:196: removed: %u, added: %u\n", removed, added);
	_tmp72_ = self->priv->app_table;
	_tmp73_ = g_hash_table_size (_tmp72_);
	_tmp74_ = _tmp73_;
	g_debug ("system-monitor.vala:197: app table size: %u\n", _tmp74_);
	_tmp75_ = self->priv->process_table;
	_tmp76_ = g_hash_table_size (_tmp75_);
	_tmp77_ = _tmp76_;
	g_debug ("system-monitor.vala:198: process table size: %u\n", _tmp77_);
	result = TRUE;
	old = (g_free (old), NULL);
	pids = (g_free (pids), NULL);
	block14_data_unref (_data14_);
	_data14_ = NULL;
	return result;
}

static void
usage_system_monitor_process_added (UsageSystemMonitor* self,
                                    UsageProcess* p)
{
	gchar* app_id = NULL;
	gchar* _tmp0_;
	UsageAppItem* item = NULL;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	UsageAppItem* _tmp4_;
	UsageAppItem* _tmp5_;
	GHashTable* _tmp16_;
	GPid _tmp17_;
	GPid _tmp18_;
	UsageProcess* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = usage_system_monitor_get_app_id_for_process (self, p);
	app_id = _tmp0_;
	_tmp1_ = self->priv->app_table;
	_tmp2_ = app_id;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((UsageAppItem*) _tmp3_);
	item = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ == NULL) {
		UsageAppItem* _tmp6_;
		GHashTable* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		UsageAppItem* _tmp10_;
		UsageAppItem* _tmp11_;
		_tmp6_ = usage_app_item_new (p);
		_g_object_unref0 (item);
		item = _tmp6_;
		_tmp7_ = self->priv->app_table;
		_tmp8_ = app_id;
		_tmp9_ = g_strdup (_tmp8_);
		_tmp10_ = item;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		g_hash_table_insert (_tmp7_, _tmp9_, _tmp11_);
	} else {
		UsageAppItem* _tmp12_;
		GPid _tmp13_;
		GPid _tmp14_;
		_tmp12_ = item;
		_tmp13_ = usage_process_get_pid (p);
		_tmp14_ = _tmp13_;
		if (!usage_app_item_contains_process (_tmp12_, _tmp14_)) {
			UsageAppItem* _tmp15_;
			_tmp15_ = item;
			usage_app_item_insert_process (_tmp15_, p);
		}
	}
	_tmp16_ = self->priv->process_table;
	_tmp17_ = usage_process_get_pid (p);
	_tmp18_ = _tmp17_;
	_tmp19_ = _g_object_ref0 (p);
	g_hash_table_insert (_tmp16_, (gpointer) ((gintptr) _tmp18_), _tmp19_);
	_g_object_unref0 (item);
	_g_free0 (app_id);
}

static void
usage_system_monitor_process_removed (UsageSystemMonitor* self,
                                      UsageProcess* p)
{
	gchar* app_id = NULL;
	gchar* _tmp0_;
	UsageAppItem* item = NULL;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	UsageAppItem* _tmp4_;
	UsageAppItem* _tmp5_;
	GHashTable* _tmp7_;
	GPid _tmp8_;
	GPid _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = usage_system_monitor_get_app_id_for_process (self, p);
	app_id = _tmp0_;
	_tmp1_ = self->priv->app_table;
	_tmp2_ = app_id;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((UsageAppItem*) _tmp3_);
	item = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ != NULL) {
		UsageAppItem* _tmp6_;
		_tmp6_ = item;
		usage_app_item_remove_process (_tmp6_, p);
	}
	_tmp7_ = self->priv->process_table;
	_tmp8_ = usage_process_get_pid (p);
	_tmp9_ = _tmp8_;
	g_hash_table_remove (_tmp7_, (gpointer) ((gintptr) _tmp9_));
	_g_object_unref0 (item);
	_g_free0 (app_id);
}

static gchar*
usage_system_monitor_get_app_id_for_process (UsageSystemMonitor* self,
                                             UsageProcess* p)
{
	GAppInfo* info = NULL;
	GAppInfo* _tmp0_;
	gchar* fallback = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	GAppInfo* _tmp12_ = NULL;
	GAppInfo* _tmp13_;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp18_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = usage_app_item_app_info_for_process (p);
	info = _tmp0_;
	_tmp1_ = usage_process_get_cmdline (p);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	fallback = _tmp3_;
	_tmp4_ = self->priv->_group_system_apps;
	if (_tmp4_) {
		gchar* _tmp5_;
		GPid _tmp6_;
		GPid _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = g_strdup ("system");
		_g_free0 (fallback);
		fallback = _tmp5_;
		_tmp6_ = usage_process_get_pid (p);
		_tmp7_ = _tmp6_;
		_tmp8_ = usage_process_read_cgroup (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "/lxc.payload.waydroid") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("system_waydroid");
			_g_free0 (fallback);
			fallback = _tmp11_;
		}
	}
	_tmp13_ = info;
	_tmp12_ = _tmp13_;
	_tmp14_ = NULL;
	if (_tmp12_ != NULL) {
		const gchar* _tmp15_;
		_tmp15_ = g_app_info_get_id (_tmp12_);
		_tmp14_ = _tmp15_;
	}
	_tmp16_ = _tmp14_;
	if (_tmp16_ == NULL) {
		const gchar* _tmp17_;
		_tmp17_ = fallback;
		_tmp16_ = _tmp17_;
	}
	_tmp18_ = g_strdup (_tmp16_);
	result = _tmp18_;
	_g_free0 (fallback);
	_g_object_unref0 (info);
	return result;
}

static void
usage_system_monitor_update_process (UsageSystemMonitor* self,
                                     UsageProcess** process)
{
	UsageCpuMonitor* _tmp0_;
	UsageMemoryMonitor* _tmp1_;
	GameModePidList* _tmp2_;
	GPid _tmp3_;
	GPid _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*process != NULL);
	_tmp0_ = self->priv->cpu_monitor;
	usage_monitor_update_process ((UsageMonitor*) _tmp0_, process);
	_tmp1_ = self->priv->memory_monitor;
	usage_monitor_update_process ((UsageMonitor*) _tmp1_, process);
	usage_process_update_status (*process);
	_tmp2_ = self->priv->gamemode_pids;
	_tmp3_ = usage_process_get_pid (*process);
	_tmp4_ = _tmp3_;
	usage_process_set_gamemode (*process, game_mode_pid_list_contains (_tmp2_, (gint) _tmp4_));
}

static gint
__lambda13_ (void* a,
             void* b)
{
	gint result;
	result = (gint) ((*((GPid*) a)) - (*((GPid*) b)));
	return result;
}

static gint
___lambda13____compar_fn_t (void* key1,
                            void* key2)
{
	gint result;
	result = __lambda13_ (key1, key2);
	return result;
}

void
usage_system_monitor_sort_pids (void* pids,
                                gsize elm,
                                gsize length)
{
	qsort (pids, length, elm, ___lambda13____compar_fn_t);
}

gboolean
usage_system_monitor_get_process_list_ready (UsageSystemMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_process_list_ready;
	return result;
}

static void
usage_system_monitor_set_process_list_ready (UsageSystemMonitor* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_system_monitor_get_process_list_ready (self);
	if (old_value != value) {
		self->priv->_process_list_ready = value;
		g_object_notify_by_pspec ((GObject *) self, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_PROCESS_LIST_READY_PROPERTY]);
	}
}

gdouble
usage_system_monitor_get_cpu_load (UsageSystemMonitor* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cpu_load;
	return result;
}

static void
usage_system_monitor_set_cpu_load (UsageSystemMonitor* self,
                                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_system_monitor_get_cpu_load (self);
	if (old_value != value) {
		self->priv->_cpu_load = value;
		g_object_notify_by_pspec ((GObject *) self, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_CPU_LOAD_PROPERTY]);
	}
}

gdouble*
usage_system_monitor_get_x_cpu_load (UsageSystemMonitor* self,
                                     gint* result_length1)
{
	gdouble* result;
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_x_cpu_load;
	_tmp0__length1 = self->priv->_x_cpu_load_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gdouble*
_vala_array_dup6 (gdouble* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gdouble));
	}
	return NULL;
}

static void
usage_system_monitor_set_x_cpu_load (UsageSystemMonitor* self,
                                     gdouble* value,
                                     gint value_length1)
{
	gdouble* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup6 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->_x_cpu_load = (g_free (self->priv->_x_cpu_load), NULL);
	self->priv->_x_cpu_load = _tmp0_;
	self->priv->_x_cpu_load_length1 = _tmp0__length1;
	self->priv->__x_cpu_load_size_ = self->priv->_x_cpu_load_length1;
}

guint64
usage_system_monitor_get_ram_usage (UsageSystemMonitor* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_ram_usage;
	return result;
}

static void
usage_system_monitor_set_ram_usage (UsageSystemMonitor* self,
                                    guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_system_monitor_get_ram_usage (self);
	if (old_value != value) {
		self->priv->_ram_usage = value;
		g_object_notify_by_pspec ((GObject *) self, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_RAM_USAGE_PROPERTY]);
	}
}

guint64
usage_system_monitor_get_ram_total (UsageSystemMonitor* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_ram_total;
	return result;
}

static void
usage_system_monitor_set_ram_total (UsageSystemMonitor* self,
                                    guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_system_monitor_get_ram_total (self);
	if (old_value != value) {
		self->priv->_ram_total = value;
		g_object_notify_by_pspec ((GObject *) self, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_RAM_TOTAL_PROPERTY]);
	}
}

guint64
usage_system_monitor_get_swap_usage (UsageSystemMonitor* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_swap_usage;
	return result;
}

static void
usage_system_monitor_set_swap_usage (UsageSystemMonitor* self,
                                     guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_system_monitor_get_swap_usage (self);
	if (old_value != value) {
		self->priv->_swap_usage = value;
		g_object_notify_by_pspec ((GObject *) self, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_SWAP_USAGE_PROPERTY]);
	}
}

guint64
usage_system_monitor_get_swap_total (UsageSystemMonitor* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_swap_total;
	return result;
}

static void
usage_system_monitor_set_swap_total (UsageSystemMonitor* self,
                                     guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_system_monitor_get_swap_total (self);
	if (old_value != value) {
		self->priv->_swap_total = value;
		g_object_notify_by_pspec ((GObject *) self, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_SWAP_TOTAL_PROPERTY]);
	}
}

gboolean
usage_system_monitor_get_group_system_apps (UsageSystemMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_group_system_apps;
	return result;
}

void
usage_system_monitor_set_group_system_apps (UsageSystemMonitor* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_system_monitor_get_group_system_apps (self);
	if (old_value != value) {
		self->priv->_group_system_apps = value;
		g_object_notify_by_pspec ((GObject *) self, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_GROUP_SYSTEM_APPS_PROPERTY]);
	}
}

static void
usage_system_monitor_class_init (UsageSystemMonitorClass * klass,
                                 gpointer klass_data)
{
	usage_system_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageSystemMonitor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_system_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_system_monitor_set_property;
	G_OBJECT_CLASS (klass)->finalize = usage_system_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SYSTEM_MONITOR_PROCESS_LIST_READY_PROPERTY, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_PROCESS_LIST_READY_PROPERTY] = g_param_spec_boolean ("process-list-ready", "process-list-ready", "process-list-ready", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SYSTEM_MONITOR_CPU_LOAD_PROPERTY, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_CPU_LOAD_PROPERTY] = g_param_spec_double ("cpu-load", "cpu-load", "cpu-load", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SYSTEM_MONITOR_RAM_USAGE_PROPERTY, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_RAM_USAGE_PROPERTY] = g_param_spec_uint64 ("ram-usage", "ram-usage", "ram-usage", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SYSTEM_MONITOR_RAM_TOTAL_PROPERTY, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_RAM_TOTAL_PROPERTY] = g_param_spec_uint64 ("ram-total", "ram-total", "ram-total", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SYSTEM_MONITOR_SWAP_USAGE_PROPERTY, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_SWAP_USAGE_PROPERTY] = g_param_spec_uint64 ("swap-usage", "swap-usage", "swap-usage", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SYSTEM_MONITOR_SWAP_TOTAL_PROPERTY, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_SWAP_TOTAL_PROPERTY] = g_param_spec_uint64 ("swap-total", "swap-total", "swap-total", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SYSTEM_MONITOR_GROUP_SYSTEM_APPS_PROPERTY, usage_system_monitor_properties[USAGE_SYSTEM_MONITOR_GROUP_SYSTEM_APPS_PROPERTY] = g_param_spec_boolean ("group-system-apps", "group-system-apps", "group-system-apps", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
usage_system_monitor_instance_init (UsageSystemMonitor * self,
                                    gpointer klass)
{
	self->priv = usage_system_monitor_get_instance_private (self);
	self->priv->_process_list_ready = FALSE;
	self->priv->_group_system_apps = TRUE;
	self->priv->process_mode = GLIBTOP_KERN_PROC_ALL;
}

static void
usage_system_monitor_finalize (GObject * obj)
{
	UsageSystemMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitor);
	self->priv->_x_cpu_load = (g_free (self->priv->_x_cpu_load), NULL);
	_g_object_unref0 (self->priv->background_monitor);
	_usage_cpu_monitor_unref0 (self->priv->cpu_monitor);
	_usage_memory_monitor_unref0 (self->priv->memory_monitor);
	_g_object_unref0 (self->priv->gamemode_pids);
	_g_hash_table_unref0 (self->priv->app_table);
	_g_hash_table_unref0 (self->priv->process_table);
	G_OBJECT_CLASS (usage_system_monitor_parent_class)->finalize (obj);
}

static GType
usage_system_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageSystemMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_system_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageSystemMonitor), 0, (GInstanceInitFunc) usage_system_monitor_instance_init, NULL };
	GType usage_system_monitor_type_id;
	usage_system_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "UsageSystemMonitor", &g_define_type_info, 0);
	UsageSystemMonitor_private_offset = g_type_add_instance_private (usage_system_monitor_type_id, sizeof (UsageSystemMonitorPrivate));
	return usage_system_monitor_type_id;
}

GType
usage_system_monitor_get_type (void)
{
	static volatile gsize usage_system_monitor_type_id__once = 0;
	if (g_once_init_enter (&usage_system_monitor_type_id__once)) {
		GType usage_system_monitor_type_id;
		usage_system_monitor_type_id = usage_system_monitor_get_type_once ();
		g_once_init_leave (&usage_system_monitor_type_id__once, usage_system_monitor_type_id);
	}
	return usage_system_monitor_type_id__once;
}

static void
_vala_usage_system_monitor_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	UsageSystemMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitor);
	switch (property_id) {
		case USAGE_SYSTEM_MONITOR_PROCESS_LIST_READY_PROPERTY:
		g_value_set_boolean (value, usage_system_monitor_get_process_list_ready (self));
		break;
		case USAGE_SYSTEM_MONITOR_CPU_LOAD_PROPERTY:
		g_value_set_double (value, usage_system_monitor_get_cpu_load (self));
		break;
		case USAGE_SYSTEM_MONITOR_RAM_USAGE_PROPERTY:
		g_value_set_uint64 (value, usage_system_monitor_get_ram_usage (self));
		break;
		case USAGE_SYSTEM_MONITOR_RAM_TOTAL_PROPERTY:
		g_value_set_uint64 (value, usage_system_monitor_get_ram_total (self));
		break;
		case USAGE_SYSTEM_MONITOR_SWAP_USAGE_PROPERTY:
		g_value_set_uint64 (value, usage_system_monitor_get_swap_usage (self));
		break;
		case USAGE_SYSTEM_MONITOR_SWAP_TOTAL_PROPERTY:
		g_value_set_uint64 (value, usage_system_monitor_get_swap_total (self));
		break;
		case USAGE_SYSTEM_MONITOR_GROUP_SYSTEM_APPS_PROPERTY:
		g_value_set_boolean (value, usage_system_monitor_get_group_system_apps (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_usage_system_monitor_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	UsageSystemMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitor);
	switch (property_id) {
		case USAGE_SYSTEM_MONITOR_PROCESS_LIST_READY_PROPERTY:
		usage_system_monitor_set_process_list_ready (self, g_value_get_boolean (value));
		break;
		case USAGE_SYSTEM_MONITOR_CPU_LOAD_PROPERTY:
		usage_system_monitor_set_cpu_load (self, g_value_get_double (value));
		break;
		case USAGE_SYSTEM_MONITOR_RAM_USAGE_PROPERTY:
		usage_system_monitor_set_ram_usage (self, g_value_get_uint64 (value));
		break;
		case USAGE_SYSTEM_MONITOR_RAM_TOTAL_PROPERTY:
		usage_system_monitor_set_ram_total (self, g_value_get_uint64 (value));
		break;
		case USAGE_SYSTEM_MONITOR_SWAP_USAGE_PROPERTY:
		usage_system_monitor_set_swap_usage (self, g_value_get_uint64 (value));
		break;
		case USAGE_SYSTEM_MONITOR_SWAP_TOTAL_PROPERTY:
		usage_system_monitor_set_swap_total (self, g_value_get_uint64 (value));
		break;
		case USAGE_SYSTEM_MONITOR_GROUP_SYSTEM_APPS_PROPERTY:
		usage_system_monitor_set_group_system_apps (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

