/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This is GNU Go, a Go program. Contact gnugo@gnu.org, or see       *
 * http://www.gnu.org/software/gnugo/ for more information.          *
 *                                                                   *
 * Copyright 1999, 2000, 2001, 2002, 2003, 2004, 2005 and 2006       *
 * by the Free Software Foundation.                                  *
 *                                                                   *
 * This program is free software; you can redistribute it and/or     *
 * modify it under the terms of the GNU General Public License as    *
 * published by the Free Software Foundation - version 3             *
 * or (at your option) any later version.                            *
 *                                                                   *
 * This program is distributed in the hope that it will be useful,   *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *
 * GNU General Public License in file COPYING for more details.      *
 *                                                                   *
 * You should have received a copy of the GNU General Public         *
 * License along with this program; if not, write to the Free        *
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,       *
 * Boston, MA 02111, USA.                                            *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h> /* for NULL */
#include "liberty.h"
#include "patterns.h"

struct fullboard_pattern fuseki13[] = {
  {{{0x0}},0,"F-H0-1",576,93},
  {{{0x0}},0,"F-H0-2",791,80},
  {{{0x0}},0,"F-H0-3",828,29},
  {{{0x0}},0,"F-H0-4",684,9},
  {{{0x0}},0,"F-H0-5",614,5},
  {{{0x0}},0,"F-H0-6",755,2},
  {{{0x0}},0,"F-H0-7",572,1},
  {{{0xe76a555f077b00e1}},1,"F-H0-8",576,27},
  {{{0xdbcabbdc5a7a2175}},1,"F-H0-9",829,15},
  {{{0x1326e0836721f2e9}},1,"F-H0-10",540,12},
  {{{0x251cb1de1eb2d6e2}},1,"F-H0-11",576,12},
  {{{0xdbcabbdc5a7a2175}},1,"F-H0-12",797,7},
  {{{0xdbcabbdc5a7a2175}},1,"F-H0-13",576,5},
  {{{0xe76a555f077b00e1}},1,"F-H0-14",532,4},
  {{{0x4a9897266f7f228a}},1,"F-H0-15",829,4},
  {{{0xe76a555f077b00e1}},1,"F-H0-16",835,4},
  {{{0xe76a555f077b00e1}},1,"F-H0-17",836,4},
  {{{0xf777bed32c3c3b8}},1,"F-H0-18",829,3},
  {{{0x1326e0836721f2e9}},1,"F-H0-19",684,3},
  {{{0xe76a555f077b00e1}},1,"F-H0-20",606,3},
  {{{0x251cb1de1eb2d6e2}},1,"F-H0-21",762,3},
  {{{0x1326e0836721f2e9}},1,"F-H0-22",797,2},
  {{{0x1326e0836721f2e9}},1,"F-H0-23",534,1},
  {{{0x1326e0836721f2e9}},1,"F-H0-24",799,1},
  {{{0xe76a555f077b00e1}},1,"F-H0-25",791,1},
  {{{0xe76a555f077b00e1}},1,"F-H0-26",834,1},
  {{{0xb6484d5445ebf616}},1,"F-H0-27",761,1},
  {{{0xa50e49922655ca9}},1,"F-H0-28",539,24},
  {{{0xa50e49922655ca9}},1,"F-H0-29",576,22},
  {{{0xe9b9224eee5dad9c}},1,"F-H0-30",792,14},
  {{{0xb81878cd963a4796}},1,"F-H0-31",799,13},
  {{{0xa50e49922655ca9}},1,"F-H0-32",540,7},
  {{{0x73ac93f866d24486}},1,"F-H0-33",539,4},
  {{{0xb81878cd963a4796}},1,"F-H0-34",755,3},
  {{{0xa50e49922655ca9}},1,"F-H0-35",831,3},
  {{{0xa50e49922655ca9}},1,"F-H0-36",614,3},
  {{{0x73ac93f866d24486}},1,"F-H0-37",828,2},
  {{{0xa50e49922655ca9}},1,"F-H0-38",829,1},
  {{{0xa50e49922655ca9}},1,"F-H0-39",571,1},
  {{{0xb81878cd963a4796}},1,"F-H0-40",571,1},
  {{{0xa50e49922655ca9}},1,"F-H0-41",684,1},
  {{{0xa50e49922655ca9}},1,"F-H0-42",828,1},
  {{{0xe0e0499b0c792a6}},2,"F-H0-43",799,15},
  {{{0x6d707b6daabd918c}},2,"F-H0-44",577,7},
  {{{0xf9ab750c0ea98cd8}},2,"F-H0-45",570,5},
  {{{0xe0e0499b0c792a6}},2,"F-H0-46",533,5},
  {{{0xe0e0499b0c792a6}},2,"F-H0-47",754,2},
  {{{0xe0e0499b0c792a6}},2,"F-H0-48",836,2},
  {{{0x429a9ef6c8e8942e}},2,"F-H0-49",570,2},
  {{{0x429a9ef6c8e8942e}},2,"F-H0-50",684,1},
  {{{0xca14dd759f53adbf}},2,"F-H0-51",836,1},
  {{{0xe0e0499b0c792a6}},2,"F-H0-52",651,1},
  {{{0x429a9ef6c8e8942e}},2,"F-H0-53",761,1},
  {{{0xa4b1231263ee32e7}},1,"F-H0-54",835,6},
  {{{0xa4b1231263ee32e7}},1,"F-H0-55",570,5},
  {{{0xa4b1231263ee32e7}},1,"F-H0-56",540,3},
  {{{0xa4b1231263ee32e7}},1,"F-H0-57",830,2},
  {{{0xa4b1231263ee32e7}},1,"F-H0-58",795,1},
  {{{0xa4b1231263ee32e7}},1,"F-H0-59",831,1},
  {{{0xa4b1231263ee32e7}},1,"F-H0-60",832,1},
  {{{0xa4b1231263ee32e7}},1,"F-H0-61",793,1},
  {{{0x709bebc071dab430}},2,"F-H0-62",799,14},
  {{{0xd299a0d5b3e7b91d}},2,"F-H0-63",576,13},
  {{{0x9771f380f98a0c99}},2,"F-H0-64",799,5},
  {{{0x709bebc071dab430}},2,"F-H0-65",762,2},
  {{{0x9771f380f98a0c99}},2,"F-H0-66",797,2},
  {{{0x709bebc071dab430}},2,"F-H0-67",795,1},
  {{{0xa7b956015d8a386c}},2,"F-H0-68",833,1},
  {{{0x9771f380f98a0c99}},2,"F-H0-69",828,1},
  {{{0x9771f380f98a0c99}},2,"F-H0-70",836,1},
  {{{0xa7b956015d8a386c}},2,"F-H0-71",684,1},
  {{{0xb133c38d3d6459dd}},2,"F-H0-72",614,4},
  {{{0xdeb7e5754ca9adb5}},2,"F-H0-73",761,3},
  {{{0x1cc101f455607bb6}},2,"F-H0-74",688,1},
  {{{0xe88db428353a89be}},2,"F-H0-75",799,1},
  {{{0x1cc101f455607bb6}},2,"F-H0-76",828,1},
  {{{0x1cc101f455607bb6}},2,"F-H0-77",836,1},
  {{{0xdeb7e5754ca9adb5}},2,"F-H0-78",688,1},
  {{{0xe88db428353a89be}},2,"F-H0-79",680,1},
  {{{0xe88db428353a89be}},2,"F-H0-80",836,1},
  {{{0xdeb7e5754ca9adb5}},2,"F-H0-81",829,1},
  {{{0xe88db428353a89be}},2,"F-H0-82",576,1},
  {{{0x1cc101f455607bb6}},2,"F-H0-83",791,1},
  {{{0xe88db428353a89be}},2,"F-H0-84",798,1},
  {{{0xc87b048820f43077}},1,"F-H0-85",533,6},
  {{{0xe3ac88bf2790f97f}},1,"F-H0-86",576,6},
  {{{0xc87b048820f43077}},1,"F-H0-87",829,5},
  {{{0xe3ac88bf2790f97f}},1,"F-H0-88",684,3},
  {{{0xd5ec0ad0366ccb47}},1,"F-H0-89",828,2},
  {{{0xe3ac88bf2790f97f}},1,"F-H0-90",792,2},
  {{{0xe3ac88bf2790f97f}},1,"F-H0-91",540,1},
  {{{0x75968051dedf9774}},1,"F-H0-92",834,1},
  {{{0xe3ac88bf2790f97f}},1,"F-H0-93",799,1},
  {{{0x75968051dedf9774}},1,"F-H0-94",755,1},
  {{{0x46ebacc581957145}},2,"F-H0-95",570,6},
  {{{0x4059f870af34066e}},2,"F-H0-96",539,5},
  {{{0xed9f22d3f9522544}},2,"F-H0-97",761,5},
  {{{0xc733257a5c798e03}},2,"F-H0-98",577,4},
  {{{0xc733257a5c798e03}},2,"F-H0-99",798,3},
  {{{0x2b695a4d9e04a626}},2,"F-H0-100",828,2},
  {{{0xc733257a5c798e03}},2,"F-H0-101",538,1},
  {{{0xdc4ad7c45ac11460}},2,"F-H0-102",577,1},
  {{{0x46ebacc581957145}},2,"F-H0-103",834,1},
  {{{0x4059f870af34066e}},2,"F-H0-104",762,1},
  {{{0xc7f4e8e0d523301e}},2,"F-H0-105",798,5},
  {{{0x821b042b889fd12c}},2,"F-H0-106",798,5},
  {{{0x821b042b889fd12c}},2,"F-H0-107",799,5},
  {{{0x821b042b889fd12c}},2,"F-H0-108",614,3},
  {{{0x8d68cfcf1851e297}},2,"F-H0-109",539,3},
  {{{0x821b042b889fd12c}},2,"F-H0-110",532,2},
  {{{0xc7f4e8e0d523301e}},2,"F-H0-111",835,2},
  {{{0xc7f4e8e0d523301e}},2,"F-H0-112",575,2},
  {{{0xf109742725eaaa08}},2,"F-H0-113",540,2},
  {{{0xc7f4e8e0d523301e}},2,"F-H0-114",534,2},
  {{{0x7a4b4246dc9450d1}},2,"F-H0-115",607,1},
  {{{0x4cbb485ca3f02dec}},3,"F-H0-116",569,3},
  {{{0x4cbb485ca3f02dec}},3,"F-H0-117",607,2},
  {{{0x4cbb485ca3f02dec}},3,"F-H0-118",532,2},
  {{{0x4cbb485ca3f02dec}},3,"F-H0-119",606,2},
  {{{0x55875a1e6f6862d2}},3,"F-H0-120",761,2},
  {{{0xed21c12732f51ae6}},3,"F-H0-121",614,1},
  {{{0x2139bed4bc61fa8f}},3,"F-H0-122",798,1},
  {{{0x1fa12ecccbb07ffa}},3,"F-H0-123",792,7},
  {{{0xe4dd60789f58481f}},3,"F-H0-124",569,4},
  {{{0xade9b2987fef64c5}},3,"F-H0-125",828,1},
  {{{0x33778381708f0b6}},3,"F-H0-126",833,1},
  {{{0x1b8e8230e74cd063}},2,"F-H0-127",569,7},
  {{{0x3ecc17296e2920f8}},2,"F-H0-128",539,5},
  {{{0x3ecc17296e2920f8}},2,"F-H0-129",577,2},
  {{{0x234ddc5a4c3adc5f}},2,"F-H0-130",836,2},
  {{{0x3ecc17296e2920f8}},2,"F-H0-131",798,2},
  {{{0x3ecc17296e2920f8}},2,"F-H0-132",754,1},
  {{{0x8541d69467bf72a1}},2,"F-H0-133",833,1},
  {{{0x3ecc17296e2920f8}},2,"F-H0-134",576,1},
  {{{0xf9627ec07a11c3c3}},3,"F-H0-135",613,3},
  {{{0xf291293b9440a519}},3,"F-H0-136",836,2},
  {{{0x71bca5b490c8c608}},3,"F-H0-137",798,2},
  {{{0xf291293b9440a519}},3,"F-H0-138",534,2},
  {{{0x71bca5b490c8c608}},3,"F-H0-139",575,1},
  {{{0xe8b52b7a66595d7e}},3,"F-H0-140",834,1},
  {{{0xfe7e0fca172969b0}},3,"F-H0-141",576,1},
  {{{0xe8b52b7a66595d7e}},3,"F-H0-142",614,1},
  {{{0xe8b52b7a66595d7e}},3,"F-H0-143",577,1},
  {{{0x5490bcb91215e1a8}},3,"F-H0-144",539,5},
  {{{0xa181f99a86ee71a4}},3,"F-H0-145",570,2},
  {{{0x384fbacef92554cf}},3,"F-H0-146",793,2},
  {{{0xe2e8593ecb91e6fc}},3,"F-H0-147",538,1},
  {{{0xac16f56c04b24e4}},3,"F-H0-148",835,1},
  {{{0xa181f99a86ee71a4}},3,"F-H0-149",532,1},
  {{{0x4547e9030e5d7f15}},3,"F-H0-150",613,1},
  {{{0xb3e8aa14dbe4b590}},2,"F-H0-151",569,5},
  {{{0x3cd121eed2da7b86}},2,"F-H0-152",762,4},
  {{{0xb3e8aa14dbe4b590}},2,"F-H0-153",533,2},
  {{{0x5faf5e1ac8a078ac}},2,"F-H0-154",762,1},
  {{{0x5faf5e1ac8a078ac}},2,"F-H0-155",540,1},
  {{{0xd1cd33b1b57fb943}},2,"F-H0-156",798,1},
  {{{0x3cd121eed2da7b86}},2,"F-H0-157",533,1},
  {{{0x892e75c33800973e}},2,"F-H0-158",796,1},
  {{{0x2e4dcaae3b7e9d82}},3,"F-H0-159",575,2},
  {{{0x2e4dcaae3b7e9d82}},3,"F-H0-160",762,2},
  {{{0xfdab6462da1ce65f}},3,"F-H0-161",570,2},
  {{{0x2e4dcaae3b7e9d82}},3,"F-H0-162",761,1},
  {{{0x58f9abc43470136}},3,"F-H0-163",577,1},
  {{{0x1a193c4fe1dbee0e}},4,"F-H0-164",831,4},
  {{{0xc361022664b45579}},4,"F-H0-165",540,2},
  {{{0xc361022664b45579}},4,"F-H0-166",534,2},
  {{{0xa8d2e2936f73e9cc}},4,"F-H0-167",755,1},
  {{{0x25a2522ad515e940}},4,"F-H0-168",681,1},
  {{{0xc361022664b45579}},4,"F-H0-169",688,1},
  {{{0xc361022664b45579}},4,"F-H0-170",650,1},
  {{{0x121276e5bc46d6cb}},2,"F-H0-171",792,2},
  {{{0xf1fbb032707e27fe}},2,"F-H0-172",688,1},
  {{{0xf1fbb032707e27fe}},2,"F-H0-173",680,1},
  {{{0x121276e5bc46d6cb}},2,"F-H0-174",799,1},
  {{{0xf1fbb032707e27fe}},2,"F-H0-175",791,1},
  {{{0xf1fbb032707e27fe}},2,"F-H0-176",576,1},
  {{{0xf1fbb032707e27fe}},2,"F-H0-177",831,1},
  {{{0xbb2f00f58132b720}},2,"F-H0-178",576,4},
  {{{0x7498355735b2fdac}},2,"F-H0-179",799,3},
  {{{0x213ab14309bd5e3a}},2,"F-H0-180",798,2},
  {{{0xde452160193d2043}},2,"F-H0-181",577,2},
  {{{0x213ab14309bd5e3a}},2,"F-H0-182",540,1},
  {{{0x7498355735b2fdac}},2,"F-H0-183",791,1},
  {{{0xe4ffec2f98d7152e}},4,"F-H0-184",754,3},
  {{{0xe4ffec2f98d7152e}},4,"F-H0-185",534,2},
  {{{0xe4ffec2f98d7152e}},4,"F-H0-186",571,1},
  {{{0x33122d704a00e886}},4,"F-H0-187",651,1},
  {{{0xacbccd3634d42e2b}},4,"F-H0-188",833,1},
  {{{0x780b2dd5e66c721f}},4,"F-H0-189",718,1},
  {{{0xe4ffec2f98d7152e}},4,"F-H0-190",614,1},
  {{{0xacbccd3634d42e2b}},4,"F-H0-191",796,1},
  {{{0xe6f733f60c154de9}},4,"F-H0-192",755,1},
  {{{0x33122d704a00e886}},4,"F-H0-193",795,1},
  {{{0xc380fc05f8224244}},2,"F-H0-194",533,2},
  {{{0xc380fc05f8224244}},2,"F-H0-195",754,2},
  {{{0xc380fc05f8224244}},2,"F-H0-196",799,1},
  {{{0x1057192a0b5c290e}},2,"F-H0-197",792,1},
  {{{0x8f14666a800d44cc}},2,"F-H0-198",836,1},
  {{{0xb7c7891b56a8b907}},2,"F-H0-199",576,1},
  {{{0x23e8b1539aa60869}},2,"F-H0-200",830,1},
  {{{0xc380fc05f8224244}},2,"F-H0-201",569,1},
  {{{0xc380fc05f8224244}},2,"F-H0-202",614,1},
  {{{0xa1ae4ff403b1cea2}},2,"F-H0-203",830,1},
  {{{0x1057192a0b5c290e}},2,"F-H0-204",570,1},
  {{{0xeecc884b6bd6dfc6}},2,"F-H0-205",577,3},
  {{{0xbd15135c393f64d2}},2,"F-H0-206",798,3},
  {{{0xbd15135c393f64d2}},2,"F-H0-207",533,2},
  {{{0xbd15135c393f64d2}},2,"F-H0-208",576,1},
  {{{0xeecc884b6bd6dfc6}},2,"F-H0-209",538,1},
  {{{0x7e8d9fa6fc7fa94f}},2,"F-H0-210",836,1},
  {{{0xb7c706e8f7181a09}},3,"F-H0-211",793,1},
  {{{0xb9aa0d7f370bbde0}},3,"F-H0-212",576,1},
  {{{0xfb5990be078ff6a1}},3,"F-H0-213",575,1},
  {{{0x67bed5d452930f45}},3,"F-H0-214",835,1},
  {{{0x5e33c5293d3ce15f}},2,"F-H0-215",830,3},
  {{{0x12a75f464513e7d7}},2,"F-H0-216",799,2},
  {{{0x5e33c5293d3ce15f}},2,"F-H0-217",835,2},
  {{{0x12a75f464513e7d7}},2,"F-H0-218",832,1},
  {{{0x5e33c5293d3ce15f}},2,"F-H0-219",836,1},
  {{{0x338ad94818a3984a}},3,"F-H0-220",791,3},
  {{{0x67209ff488d8cd25}},3,"F-H0-221",540,2},
  {{{0x8a07e6f4687bc85e}},3,"F-H0-222",533,2},
  {{{0x10293c1d67f2e6fa}},3,"F-H0-223",832,1},
  {{{0x67209ff488d8cd25}},3,"F-H0-224",538,1},
  {{{0x7da29761d615d620}},3,"F-H0-225",537,1},
  {{{0x9a6a037659ca33b8}},4,"F-H0-226",651,2},
  {{{0x9a6a037659ca33b8}},4,"F-H0-227",650,1},
  {{{0x9a6a037659ca33b8}},4,"F-H0-228",571,1},
  {{{0x9a6a037659ca33b8}},4,"F-H0-229",834,1},
  {{{0x5b37bd731408cfd6}},4,"F-H0-230",834,1},
  {{{0x9a6a037659ca33b8}},4,"F-H0-231",534,1},
  {{{0x9a6a037659ca33b8}},4,"F-H0-232",540,1},
  {{{0x9a6a037659ca33b8}},4,"F-H0-233",496,1},
  {{{0x32f3a63c9aa7c954}},4,"F-H0-234",572,1},
  {{{0x32f3a63c9aa7c954}},4,"F-H0-235",643,1},
  {{{0x32f3a63c9aa7c954}},4,"F-H0-236",717,1},
  {{{0x32f3a63c9aa7c954}},4,"F-H0-237",754,1},
  {{{0x57c705db7024bd28}},2,"F-H0-238",791,4},
  {{{0x242f665e7ef783a2}},2,"F-H0-239",532,3},
  {{{0x61c08a95234b6290}},2,"F-H0-240",613,1},
  {{{0x61c08a95234b6290}},2,"F-H0-241",761,1},
  {{{0x242f665e7ef783a2}},2,"F-H0-242",684,1},
  {{{0xf15fd9729a3fab64}},2,"F-H0-243",791,5},
  {{{0x81870b7447548b3f}},2,"F-H0-244",569,2},
  {{{0x63fa768410911e77}},2,"F-H0-245",576,2},
  {{{0x4c6649655bbaefc2}},4,"F-H0-246",575,1},
  {{{0xff0770be952d38ae}},4,"F-H0-247",537,1},
  {{{0x4c6649655bbaefc2}},4,"F-H0-248",538,1},
  {{{0x4c6649655bbaefc2}},4,"F-H0-249",833,1},
  {{{0xb393ead1ed023e26}},4,"F-H0-250",761,2},
  {{{0xf1d9e3c3520d8f0d}},4,"F-H0-251",832,1},
  {{{0xf1d9e3c3520d8f0d}},4,"F-H0-252",795,1},
  {{{0xb393ead1ed023e26}},4,"F-H0-253",831,1},
  {{{0xa0697f90476fa502}},3,"F-H0-254",791,2},
  {{{0x5575a5ff7e44df41}},3,"F-H0-255",540,2},
  {{{0x21a7f4f4662a38ef}},3,"F-H0-256",575,1},
  {{{0xa0697f90476fa502}},3,"F-H0-257",792,1},
  {{{0x5575a5ff7e44df41}},3,"F-H0-258",754,1},
  {{{0x23db9c395b79e774}},5,"F-H0-259",796,1},
  {{{0xd7c3895e04214d5a}},5,"F-H0-260",614,1},
  {{{0x23db9c395b79e774}},5,"F-H0-261",833,1},
  {{{0x23db9c395b79e774}},5,"F-H0-262",797,1},
  {{{0x72588d4616062670}},2,"F-H0-263",539,3},
  {{{0x930acd8a384f03d2}},2,"F-H0-264",569,2},
  {{{0x7af3abff44640c3c}},2,"F-H0-265",534,1},
  {{{0x9340657eda0e078c}},2,"F-H0-266",799,3},
  {{{0xaf95cc9c559aad03}},2,"F-H0-267",570,2},
  {{{0x9340657eda0e078c}},2,"F-H0-268",836,1},
  {{{0x9340657eda0e078c}},2,"F-H0-269",569,1},
  {{{0x38854395a7b5df57}},2,"F-H0-270",724,3},
  {{{0x24ebb906d47961ab}},2,"F-H0-271",830,2},
  {{{0x24ebb906d47961ab}},2,"F-H0-272",798,1},
  {{{0x1b528611d3827c78}},2,"F-H0-273",536,1},
  {{{0x44e1e55817054fc1}},3,"F-H0-274",577,1},
  {{{0x44e1e55817054fc1}},3,"F-H0-275",830,1},
  {{{0x6bcfc8a56176b663}},3,"F-H0-276",540,1},
  {{{0x93ff79580e6cd5a1}},3,"F-H0-277",607,1},
  {{{0xca75162738500483}},3,"F-H0-278",835,1},
  {{{0x6bcfc8a56176b663}},3,"F-H0-279",500,1},
  {{{0x4e818e9ab0445b8c}},3,"F-H0-280",798,1},
  {{{0x8222e93ed9fe15bd}},3,"F-H0-281",828,1},
  {{{0x4e818e9ab0445b8c}},3,"F-H0-282",835,1},
  {{{0x4e818e9ab0445b8c}},3,"F-H0-283",797,1},
  {{{0xeee86afde45cfc6d}},3,"F-H0-284",799,1},
  {{{0x4e818e9ab0445b8c}},3,"F-H0-285",576,1},
  {{{0xaeaf5315d2e06487}},3,"F-H0-286",577,1},
  {{{0x6f59417ac974c050}},3,"F-H0-287",832,1},
  {{{0xaae0add2177460c9}},3,"F-H0-288",718,1},
  {{{0xaae0add2177460c9}},3,"F-H0-289",793,1},
  {{{0xd56803a03c87d61a}},3,"F-H0-290",791,4},
  {{{0x10125742e0f42144}},3,"F-H0-291",797,1},
  {{{0xb9b84e8df981e939}},3,"F-H0-292",570,1},
  {{{0xb9b84e8df981e939}},3,"F-H0-293",532,1},
  {{{0x38d1f0ee236e96af}},3,"F-H0-294",539,2},
  {{{0x38d1f0ee236e96af}},3,"F-H0-295",540,1},
  {{{0x1c4cbf98824cbd9c}},3,"F-H0-296",835,1},
  {{{0xb84f14395b5a8309}},3,"F-H0-297",614,1},
  {{{0x45e853554a6db584}},4,"F-H0-298",831,4},
  {{{0x30c8a581a40034f5}},4,"F-H0-299",684,1},
  {{{0x291d38c36e5f80f6}},3,"F-H0-300",836,2},
  {{{0xf237a07e09117dff}},3,"F-H0-301",792,2},
  {{{0xffaa9a166d411f35}},3,"F-H0-302",537,1},
  {{{0x291d38c36e5f80f6}},3,"F-H0-303",834,1},
  {{{0xfcb2bf4727788f58}},5,"F-H0-304",687,2},
  {{{0x6d3aa42165e41e62}},5,"F-H0-305",569,1},
  {{{0x71c3072c0e9f607e}},5,"F-H0-306",649,1},
  {{{0x6d3aa42165e41e62}},5,"F-H0-307",605,1},
  {{{0x6d3aa42165e41e62}},5,"F-H0-308",836,1},
  {{{0x8fe93ea12fda72fd}},2,"F-H0-309",718,1},
  {{{0x8fe93ea12fda72fd}},2,"F-H0-310",532,1},
  {{{0x8fe93ea12fda72fd}},2,"F-H0-311",540,1},
  {{{0x4a9c272fcd72d289}},4,"F-H0-312",606,4},
  {{{0x31e1edcd9df13065}},4,"F-H0-313",799,1},
  {{{0x31e1edcd9df13065}},4,"F-H0-314",534,1},
  {{{0x86554a97de7c5cd0}},2,"F-H0-315",828,1},
  {{{0x86554a97de7c5cd0}},2,"F-H0-316",829,1},
  {{{0x86554a97de7c5cd0}},2,"F-H0-317",798,1},
  {{{0xf783c507853fac1}},2,"F-H0-318",680,1},
  {{{0x2d9f56d15beea5d9}},3,"F-H0-319",577,1},
  {{{0x2d9f56d15beea5d9}},3,"F-H0-320",614,1},
  {{{0x7e6d78dc0609e547}},2,"F-H0-321",576,2},
  {{{0x2f6eeceb68be18ff}},2,"F-H0-322",835,2},
  {{{0x17bd039abe1be534}},2,"F-H0-323",791,1},
  {{{0x7e6d78dc0609e547}},2,"F-H0-324",539,1},
  {{{0xb96107b9143e1688}},2,"F-H0-325",533,1},
  {{{0x1491c4ca2bb7d090}},2,"F-H0-326",754,1},
  {{{0x1491c4ca2bb7d090}},2,"F-H0-327",532,1},
  {{{0xb01a711d31adf132}},2,"F-H0-328",533,1},
  {{{0xd463ce9f252f8456}},2,"F-H0-329",834,1},
  {{{0xb96107b9143e1688}},2,"F-H0-330",798,1},
  {{{0x7b55c7a50f37756}},3,"F-H0-331",836,3},
  {{{0x7b55c7a50f37756}},3,"F-H0-332",835,2},
  {{{0x7b55c7a50f37756}},3,"F-H0-333",798,1},
  {{{0xcd9105f62b885f5c}},3,"F-H0-334",570,1},
  {{{0xcd9105f62b885f5c}},3,"F-H0-335",830,1},
  {{{0xc70bba280f1a5ac3}},3,"F-H0-336",569,1},
  {{{0xcd9105f62b885f5c}},3,"F-H0-337",576,1},
  {{{0xc70bba280f1a5ac3}},3,"F-H0-338",540,1},
  {{{0x2d050056fd33b796}},4,"F-H0-339",571,2},
  {{{0xf393b7ad0a77ad84}},4,"F-H0-340",614,1},
  {{{0xf393b7ad0a77ad84}},4,"F-H0-341",537,1},
  {{{0xf393b7ad0a77ad84}},4,"F-H0-342",613,1},
  {{{0xd5c4bf45eabdb3d3}},3,"F-H0-343",533,1},
  {{{0xfd138ddb42ecbab2}},3,"F-H0-344",833,1},
  {{{0xfd138ddb42ecbab2}},3,"F-H0-345",754,1},
  {{{0xdcb7c4d2101b5a3a}},3,"F-H0-346",717,1},
  {{{0xfd138ddb42ecbab2}},3,"F-H0-347",540,1},
  {{{0xdcda4d5e5a435e87}},4,"F-H0-348",570,1},
  {{{0xb26d425ee738da7b}},3,"F-H0-349",569,1},
  {{{0xb26d425ee738da7b}},3,"F-H0-350",570,1},
  {{{0x40d3035e5af1388d}},3,"F-H0-351",540,1},
  {{{0xab51501c2ba09545}},3,"F-H0-352",534,1},
  {{{0xa8ce2dec6f49fbd4}},3,"F-H0-353",575,1},
  {{{0x181bfc52232153e}},3,"F-H0-354",828,1},
  {{{0xe506acf53453018d}},3,"F-H0-355",539,3},
  {{{0xc42789054b41dcbe}},3,"F-H0-356",754,1},
  {{{0xc42789054b41dcbe}},3,"F-H0-357",836,1},
  {{{0x37dde50a997fd834}},5,"F-H0-358",538,1},
  {{{0x267c967311dc10c7}},5,"F-H0-359",681,1},
  {{{0x1a374c1ad6fcb09a}},5,"F-H0-360",687,1},
  {{{0x15f5aa627ef696cd}},5,"F-H0-361",761,1},
  {{{0x15f5aa627ef696cd}},5,"F-H0-362",688,1},
  {{{0x4eb05008b2769bc9}},5,"F-H0-363",569,1},
  {{{0x7af402727ad312a4}},3,"F-H0-364",798,2},
  {{{0x1f9e23e7e2dc85c7}},3,"F-H0-365",680,1},
  {{{0xda33fb06f6fe35d6}},2,"F-H0-366",792,2},
  {{{0xc5baefac402f91b6}},2,"F-H0-367",569,1},
  {{{0x6385afe50120a27c}},2,"F-H0-368",798,1},
  {{{0x133bc475b08f7e24}},2,"F-H0-369",762,1},
  {{{0xba6810b5d4d32ffe}},6,"F-H0-370",717,1},
  {{{0xfc1ce05c4b53a3fb}},6,"F-H0-371",538,1},
  {{{0xba6810b5d4d32ffe}},6,"F-H0-372",536,1},
  {{{0x272e6cb3ba4df1f7}},2,"F-H0-373",569,2},
  {{{0x32811477010bca06}},2,"F-H0-374",792,2},
  {{{0xf5f59dd66c111000}},2,"F-H0-375",799,1},
  {{{0xa38276ce04e0b5d2}},2,"F-H0-376",836,1},
  {{{0x1df7b1005308b57d}},2,"F-H0-377",798,1},
  {{{0xa38276ce04e0b5d2}},2,"F-H0-378",540,1},
  {{{0xe44ac6d528696f8}},2,"F-H0-379",577,1},
  {{{0x6e51dd032b44bdf}},2,"F-H0-380",576,1},
  {{{0x4fe338584b427ace}},3,"F-H0-381",835,2},
  {{{0x11de66a9c5298cca}},3,"F-H0-382",532,1},
  {{{0x62070080987e5234}},3,"F-H0-383",755,1},
  {{{0x50e14fa22ae898d9}},3,"F-H0-384",792,1},
  {{{0xca5a49eb0c38a776}},1,"F-H0-385",539,2},
  {{{0xf4d368fb2a488196}},1,"F-H0-386",569,2},
  {{{0x7dfe1e3c8c672787}},1,"F-H0-387",576,1},
  {{{0xbd3740c33457a5f1}},4,"F-H0-388",866,1},
  {{{0x5ef6f702c225171}},4,"F-H0-389",792,1},
  {{{0xcc030f12997fa6c7}},3,"F-H0-390",835,2},
  {{{0xa707b5f5962d07ce}},3,"F-H0-391",532,1},
  {{{0x55cd4c46e6b483ac}},3,"F-H0-392",607,1},
  {{{0x71b815bd32c5360b}},2,"F-H0-393",792,1},
  {{{0x134928d1bd9ad2d3}},2,"F-H0-394",576,1},
  {{{0x280662183a9be668}},2,"F-H0-395",829,1},
  {{{0x134928d1bd9ad2d3}},2,"F-H0-396",797,1},
  {{{0xb83da6c7c55d86d2}},2,"F-H0-397",762,1},
  {{{0x57a37a608b525afc}},4,"F-H0-398",537,2},
  {{{0xfb094a45ff436bec}},4,"F-H0-399",643,1},
  {{{0xfb094a45ff436bec}},4,"F-H0-400",833,1},
  {{{0x90033e237b0f2d33}},4,"F-H0-401",793,1},
  {{{0xa361f60ca1168f38}},3,"F-H0-402",534,2},
  {{{0xf7f25b9db629ab6d}},3,"F-H0-403",799,1},
  {{{0xa361f60ca1168f38}},3,"F-H0-404",681,1},
  {{{0x809d3b58318f98c1}},3,"F-H0-405",832,1},
  {{{0xcbe86268aa9af2b7}},2,"F-H0-406",680,1},
  {{{0xbed616da5843af7f}},2,"F-H0-407",760,1},
  {{{0xcbe86268aa9af2b7}},2,"F-H0-408",794,1},
  {{{0xcbe86268aa9af2b7}},2,"F-H0-409",799,1},
  {{{0x58a7bc1488ef80f9}},5,"F-H0-410",688,1},
  {{{0xc8e78e711d5b3051}},5,"F-H0-411",535,1},
  {{{0x1c5edcd31f720828}},3,"F-H0-412",832,1},
  {{{0x613f1fc8d9075c31}},3,"F-H0-413",835,1},
  {{{0x613f1fc8d9075c31}},3,"F-H0-414",832,1},
  {{{0xa93d76103d7461eb}},4,"F-H0-415",576,2},
  {{{0xde93e4acf4216214}},4,"F-H0-416",828,1},
  {{{0xde93e4acf4216214}},4,"F-H0-417",607,1},
  {{{0x859ca51c3e5e4d7a}},4,"F-H0-418",540,1},
  {{{0x859ca51c3e5e4d7a}},4,"F-H0-419",538,1},
  {{{0xec74ed10cd742e0d}},4,"F-H0-420",762,1},
  {{{0xc75c62db27720d37}},4,"F-H0-421",651,1},
  {{{0xc75c62db27720d37}},4,"F-H0-422",570,1},
  {{{0xec74ed10cd742e0d}},4,"F-H0-423",540,1},
  {{{0x7f86b71f322fee0e}},4,"F-H0-424",537,1},
  {{{0xa86b7640e0f813a6}},4,"F-H0-425",534,1},
  {{{0x7e673c53e288cfdc}},4,"F-H0-426",688,1},
  {{{0x7e673c53e288cfdc}},4,"F-H0-427",831,1},
  {{{0xcc0389a91682e241}},5,"F-H0-428",574,1},
  {{{0x7c3378e6807a59f8}},5,"F-H0-429",833,1},
  {{{0xc20b4951662a03eb}},5,"F-H0-430",796,1},
  {{{0xcc0389a91682e241}},5,"F-H0-431",535,1},
  {{{0xf016b5dbf60c99dd}},2,"F-H0-432",606,1},
  {{{0xe1a6b66a172403c8}},2,"F-H0-433",796,1},
  {{{0xe313918becc8f0a2}},2,"F-H0-434",570,1},
  {{{0xe313918becc8f0a2}},2,"F-H0-435",576,1},
  {{{0xeb7967010b4fc939}},3,"F-H0-436",540,2},
  {{{0xeb7967010b4fc939}},3,"F-H0-437",577,1},
  {{{0xd0631f9fd49b697f}},3,"F-H0-438",569,2},
  {{{0x6097578dd65d3aa2}},3,"F-H0-439",535,1},
  {{{0x6097578dd65d3aa2}},3,"F-H0-440",539,1},
  {{{0xb5aaacda29cca8f6}},5,"F-H0-441",834,1},
  {{{0xb5aaacda29cca8f6}},5,"F-H0-442",725,1},
  {{{0xb5aaacda29cca8f6}},5,"F-H0-443",797,1},
  {{{0x2635c8f060aa2ced}},2,"F-H0-444",799,2},
  {{{0x96f8eb304a8cf3d6}},2,"F-H0-445",828,1},
  {{{0xf9ccf824b15341b3}},5,"F-H0-446",832,2},
  {{{0x6b0616b0d76e786b}},5,"F-H0-447",725,1},
  {{{0x6b0616b0d76e786b}},5,"F-H0-448",537,1},
  {{{0x3f9776238426f66c}},3,"F-H0-449",754,1},
  {{{0x3f9776238426f66c}},3,"F-H0-450",830,1},
  {{{0xcde1ece668c866cf}},3,"F-H0-451",792,1},
  {{{0xcde1ece668c866cf}},3,"F-H0-452",680,1},
  {{{0x59139c16f7a2c523}},3,"F-H0-453",833,2},
  {{{0x805a9a14b797534c}},3,"F-H0-454",830,1},
  {{{0x8fc9e653db8f68d4}},3,"F-H0-455",577,2},
  {{{0xf8220a8fc0dc291c}},3,"F-H0-456",834,1},
  {{{0x89681ecfe9e50fbe}},3,"F-H0-457",570,3},
  {{{0x665d59ad8f0767d5}},3,"F-H0-458",537,1},
  {{{0x4b2e0f4fc2f0a0a0}},4,"F-H0-459",834,1},
  {{{0x98840c7248a1d86e}},4,"F-H0-460",570,1},
  {{{0xe7fd8e23bcdb3b64}},3,"F-H0-461",762,1},
  {{{0x17a75599716de9d4}},3,"F-H0-462",799,1},
  {{{0xbefd651da48e0c49}},3,"F-H0-463",532,1},
  {{{0x4c1c677b1cd5ceda}},4,"F-H0-464",576,1},
  {{{0x9487ca0db7428f17}},4,"F-H0-465",683,1},
  {{{0xf3e55069e42e4bd8}},4,"F-H0-466",830,1},
  {{{0x8293dcaf57493fad}},4,"F-H0-467",533,2},
  {{{0x8293dcaf57493fad}},4,"F-H0-468",651,1},
  {{{0xd223194249b1b9f2}},6,"F-H0-469",495,1},
  {{{0xd223194249b1b9f2}},6,"F-H0-470",608,1},
  {{{0x2bb4ce33686610c9}},3,"F-H0-471",538,2},
  {{{0x8a897d424b287be1}},3,"F-H0-472",569,1},
  {{{0x40721c5015336f90}},6,"F-H0-473",649,1},
  {{{0x40721c5015336f90}},6,"F-H0-474",537,1},
  {{{0x40721c5015336f90}},6,"F-H0-475",539,1},
  {{{0x173a8b1c138a4804}},6,"F-H0-476",538,1},
  {{{0x173a8b1c138a4804}},6,"F-H0-477",537,1},
  {{{0x173a8b1c138a4804}},6,"F-H0-478",651,1},
  {{{0xe62a788b1552fba7}},5,"F-H0-479",651,1},
  {{{0x9ae30ce2406ab5fe}},5,"F-H0-480",614,1},
  {{{0xd74b45ba7bb3ba5a}},6,"F-H0-481",717,1},
  {{{0x1305a340416910c4}},6,"F-H0-482",718,1},
  {{{0x462ceed2bbc7009f}},3,"F-H0-483",836,1},
  {{{0xdc395f643348e985}},3,"F-H0-484",570,1},
  {{{0xdc395f643348e985}},3,"F-H0-485",533,1},
  {{{0x11d405316e078890}},4,"F-H0-486",538,1},
  {{{0x68eaec9da08f56a4}},4,"F-H0-487",613,1},
  {{{0xb67c5b6657cb4cb6}},4,"F-H0-488",538,1},
  {{{0xc64fcc2ed4cf89cb}},5,"F-H0-489",536,2},
  {{{0x306b3cd92b1b2eb6}},3,"F-H0-490",834,1},
  {{{0x306b3cd92b1b2eb6}},3,"F-H0-491",799,1},
  {{{0x2261ced054d3adad}},3,"F-H0-492",569,1},
  {{{0x6da0068695f7cc46}},3,"F-H0-493",791,1},
  {{{0x2261ced054d3adad}},3,"F-H0-494",538,1},
  {{{0x9a1c6ad0c6dff881}},5,"F-H0-495",762,1},
  {{{0xa0d6c32b3935c7c6}},5,"F-H0-496",536,1},
  {{{0xa32eecc879e12334}},5,"F-H0-497",794,1},
  {{{0x6b36807a1d33fca}},5,"F-H0-498",532,1},
  {{{0xe159704729838763}},5,"F-H0-499",536,1},
  {{{0x73939ed34fbebebb}},5,"F-H0-500",688,1},
  {{{0x3fde816d73ebbc3d}},2,"F-H0-501",799,2},
  {{{0x202a848918ae5faf}},2,"F-H0-502",577,1},
  {{{0xa547247aa605883a}},3,"F-H0-503",569,3},
  {{{0x1807dc14758b8228}},2,"F-H0-504",688,1},
  {{{0x1807dc14758b8228}},2,"F-H0-505",680,1},
  {{{0x8e3dd4fa8cc4ec23}},2,"F-H0-506",762,1},
  {{{0x54d39008e509002c}},5,"F-H0-507",865,1},
  {{{0x29b25313237c5435}},5,"F-H0-508",829,1},
  {{{0x17a1ff0c2952635d}},4,"F-H0-509",835,1},
  {{{0x894b7b6365418b0c}},4,"F-H0-510",540,1},
  {{{0xa232980d1c35ad28}},4,"F-H0-511",606,2},
  {{{0xf0b08dfa09bb2eeb}},4,"F-H0-512",755,1},
  {{{0xfb5438069d8a3ad1}},3,"F-H0-513",832,1},
  {{{0xfb5438069d8a3ad1}},3,"F-H0-514",576,1},
  {{{0x555a1391fb1b6047}},2,"F-H0-515",829,2},
  {{{0xd88c0a247a2aedfe}},2,"F-H0-516",577,1},
  {{{0x37bbee985ba13135}},3,"F-H0-517",577,1},
  {{{0xc7122f6e20750e16}},3,"F-H0-518",576,1},
  {{{0xb808ab6650e9cda2}},4,"F-H0-519",614,1},
  {{{0x7622fd7c793fedf4}},4,"F-H0-520",761,1},
  {{{0x3d328a62ef18f67}},4,"F-H0-521",718,1},
  {{{0x294a9a7d8c5b1467}},4,"F-H0-522",537,1},
  {{{0xcae3ee1515215c64}},4,"F-H0-523",538,1},
  {{{0xc67500119033a2d1}},3,"F-H0-524",606,2},
  {{{0x1ff8d7a5a93f66f8}},3,"F-H0-525",835,1},
  {{{0xe00f75f490e53648}},6,"F-H0-526",762,1},
  {{{0x82a924af941c22de}},6,"F-H0-527",572,1},
  {{{0x82a924af941c22de}},6,"F-H0-528",611,1},
  {{{0x740e0106c04dd157}},4,"F-H0-529",570,1},
  {{{0x81d889bfddecff46}},4,"F-H0-530",681,1},
  {{{0x740e0106c04dd157}},4,"F-H0-531",571,1},
  {{{0x4866c51432f6c70f}},4,"F-H0-532",534,2},
  {{{0xcb88b996e3f23e72}},4,"F-H0-533",570,1},
  {{{0x1edd1cad90c57d4e}},5,"F-H0-534",538,1},
  {{{0xeea07ac6c5fc748f}},6,"F-H0-535",724,1},
  {{{0xeea07ac6c5fc748f}},6,"F-H0-536",832,1},
  {{{0xeea07ac6c5fc748f}},6,"F-H0-537",688,1},
  {{{0xcfb735a2b4804a8c}},4,"F-H0-538",643,2},
  {{{0xcfb735a2b4804a8c}},4,"F-H0-539",724,1},
  {{{0x5b3b61f6fafa37fb}},3,"F-H0-540",533,2},
  {{{0x32c3392bd817070a}},4,"F-H0-541",643,1},
  {{{0x32c3392bd817070a}},4,"F-H0-542",832,1},
  {{{0x6da62b06067dfe37}},4,"F-H0-543",576,1},
  {{{0xa60c0ace2b85aefe}},4,"F-H0-544",614,2},
  {{{0x254295198965f09b}},4,"F-H0-545",533,1},
  {{{0x7f14509ce32f33a8}},3,"F-H0-546",828,1},
  {{{0x36a06515eb8a7e30}},4,"F-H0-547",570,1},
  {{{0x36a06515eb8a7e30}},4,"F-H0-548",534,1},
  {{{0x36a06515eb8a7e30}},4,"F-H0-549",754,1},
  {{{0x2d9dae6ebd854d0}},2,"F-H0-550",540,1},
  {{{0x7a240b1f5228fe35}},2,"F-H0-551",798,1},
  {{{0x7a240b1f5228fe35}},2,"F-H0-552",762,1},
  {{{0xe8d5deb6093c0d39}},4,"F-H0-553",754,1},
  {{{0x7848cd125e9a94a7}},3,"F-H0-554",539,1},
  {{{0x4c7d8af65dcb6955}},3,"F-H0-555",614,1},
  {{{0x7848cd125e9a94a7}},3,"F-H0-556",540,1},
  {{{0x6155777b45e4b3fc}},3,"F-H0-557",762,2},
  {{{0x8e3f76ad7a60be17}},3,"F-H0-558",540,1},
  {{{0xd8228337be211855}},3,"F-H0-559",836,2},
  {{{0x394546c1cf197bbd}},3,"F-H0-560",836,1},
  {{{0x2cf577cd8d036b0f}},4,"F-H0-561",606,1},
  {{{0x8f4906a7c5d56a73}},4,"F-H0-562",576,1},
  {{{0x8f4906a7c5d56a73}},4,"F-H0-563",571,1},
  {{{0x4e949e936b0ac9}},3,"F-H0-564",575,1},
  {{{0x4e949e936b0ac9}},3,"F-H0-565",613,1},
  {{{0x4b0ced1ebb61814b}},3,"F-H0-566",835,1},
  {{{0x6d29735a4aa42236}},3,"F-H0-567",569,2},
  {{{0xf4e7300e356f075d}},3,"F-H0-568",798,1},
  {{{0x1b9a0e0392daf244}},3,"F-H0-569",799,1},
  {{{0x19dd81c810715b15}},3,"F-H0-570",836,1},
  {{{0x79b18dc8f21e8004}},4,"F-H0-571",651,1},
  {{{0x79b18dc8f21e8004}},4,"F-H0-572",534,1},
  {{{0x79b18dc8f21e8004}},4,"F-H0-573",834,1},
  {{{0x2cf23fd82515c60e}},5,"F-H0-574",725,1},
  {{{0x839debb2a52c9a40}},3,"F-H0-575",834,1},
  {{{0x839debb2a52c9a40}},3,"F-H0-576",755,1},
  {{{0x839debb2a52c9a40}},3,"F-H0-577",797,1},
  {{{0xad6ebc79e5299ff6}},3,"F-H0-578",570,1},
  {{{0xad6ebc79e5299ff6}},3,"F-H0-579",569,1},
  {{{0xc9554d3024b81acf}},3,"F-H0-580",830,1},
  {{{0xc9554d3024b81acf}},3,"F-H0-581",539,1},
  {{{0xc1ea244ba55cc7f8}},4,"F-H0-582",571,1},
  {{{0x7019a4659a9bf529}},4,"F-H0-583",798,1},
  {{{0xeb93b5dbba52381e}},3,"F-H0-584",569,1},
  {{{0xc5bb13fa3d30e249}},3,"F-H0-585",535,1},
  {{{0xabdb7e4af0e4c568}},2,"F-H0-586",688,1},
  {{{0xabdb7e4af0e4c568}},2,"F-H0-587",798,1},
  {{{0x208946ef4c63098d}},5,"F-H0-588",793,1},
  {{{0xf5d9c3dcf000dd88}},6,"F-H0-589",717,1},
  {{{0xf5d9c3dcf000dd88}},6,"F-H0-590",716,1},
  {{{0x30bf949d77975732}},8,"F-H0-591",614,1},
  {{{0x4aef5906d6693da5}},5,"F-H0-592",577,1},
  {{{0xaa80c16dbae6cc75}},5,"F-H0-593",577,1},
  {{{0x307ddc93216e8645}},4,"F-H0-594",538,1},
  {{{0x6cd78c60e3490eea}},4,"F-H0-595",687,1},
  {{{0x71e4ff528a134053}},7,"F-H0-596",652,1},
  {{{0x71e4ff528a134053}},7,"F-H0-597",573,1},
  {{{0x8fda96135959c3}},5,"F-H0-598",717,1},
  {{{0x8ebc970f1e1f1e07}},5,"F-H0-599",614,1},
  {{{0x99cf258d640ba268}},5,"F-H0-600",683,1},
  {{{0x99cf258d640ba268}},5,"F-H0-601",794,1},
  {{{0x231f4d96356f2d13}},5,"F-H0-602",794,1},
  {{{0xe47f3ecc843dacd1}},5,"F-H0-603",762,1},
  {{{0x3bdea41d6f2ec320}},4,"F-H0-604",607,1},
  {{{0x54c82346211c0fe}},4,"F-H0-605",534,1},
  {{{0x3f516366fce3d6cc}},3,"F-H0-606",834,2},
  {{{0xafa04b6db3765c04}},4,"F-H0-607",755,1},
  {{{0x48125d8076bb9d98}},4,"F-H0-608",538,1},
  {{{0xd08294b030531348}},3,"F-H0-609",577,1},
  {{{0xf89eab5562c221be}},5,"F-H0-610",539,1},
  {{{0x2691e62c89883441}},6,"F-H0-611",755,1},
  {{{0xb1e00e24fbe6fe8}},5,"F-H0-612",796,1},
  {{{0xcacd944172ec520e}},3,"F-H0-613",575,1},
  {{{0x673d57324d659416}},3,"F-H0-614",836,1},
  {{{0x203a792ac5fa1f89}},5,"F-H0-615",831,1},
  {{{0x2773250a76fff21a}},5,"F-H0-616",761,1},
  {{{0x18e6fb3c746206f8}},3,"F-H0-617",791,2},
  {{{0xe4b86da502aaac88}},4,"F-H0-618",574,1},
  {{{0x9b318e86eddf5ae8}},4,"F-H0-619",614,1},
  {{{0x8b50dc45d7a07e3c}},5,"F-H0-620",534,2},
  {{{0x622eb3f1fb938ce6}},4,"F-H0-621",535,1},
  {{{0x7447751eae8afb43}},4,"F-H0-622",754,1},
  {{{0xa2680be04157c2d8}},6,"F-H0-623",503,1},
  {{{0xc7f058e9772ec01d}},3,"F-H0-624",613,1},
  {{{0x166321782291aae9}},3,"F-H0-625",576,1},
  {{{0x81d0bb4ad36d080}},3,"F-H0-626",834,1},
  {{{0x81d0bb4ad36d080}},3,"F-H0-627",836,1},
  {{{0x30953ace88bc241f}},5,"F-H0-628",537,1},
  {{{0x404ab18ab38457bd}},5,"F-H0-629",577,1},
  {{{0xf5bdf74bb5d2f9a5}},6,"F-H0-630",608,2},
  {{{0xb9ce082b6ac9dd10}},6,"F-H0-631",725,1},
  {{{0xb9ce082b6ac9dd10}},6,"F-H0-632",834,1},
  {{{0x81c865ce16fd3d8c}},3,"F-H0-633",836,2},
  {{{0x65e58edca81dc344}},4,"F-H0-634",832,1},
  {{{0x65e58edca81dc344}},4,"F-H0-635",534,1},
  {{{0x820afb33b2868f1}},6,"F-H0-636",719,1},
  {{{0x820afb33b2868f1}},6,"F-H0-637",831,1},
  {{{0xca6933d5eeec32eb}},6,"F-H0-638",718,1},
  {{{0xca6933d5eeec32eb}},6,"F-H0-639",725,1},
  {{{0xd1daaf216315c3a}},6,"F-H0-640",870,1},
  {{{0xd1daaf216315c3a}},6,"F-H0-641",607,1},
  {{{0x85b055a86cf335a8}},5,"F-H0-642",614,1},
  {{{0xc59bd56cfde2c117}},9,"F-H0-643",535,1},
  {{{0x4c9a14703fb9148c}},5,"F-H0-644",538,1},
  {{{0xf3f50a4d9f9bc72a}},5,"F-H0-645",614,1},
  {{{0xb3ac79786cbd6d67}},6,"F-H0-646",613,1},
  {{{0x52e23adb1a897b0}},3,"F-H0-647",831,2},
  {{{0x6b254b52ea1772b}},4,"F-H0-648",797,1},
  {{{0x6b254b52ea1772b}},4,"F-H0-649",534,1},
  {{{0xcbe0bdd59baab04c}},4,"F-H0-650",537,2},
  {{{0x20cb7d1a79087e9b}},6,"F-H0-651",797,1},
  {{{0x6258a3e9f3227692}},9,"F-H0-652",722,1},
  {{{0x1ddd50c8e1c5b63c}},2,"F-H0-653",577,1},
  {{{0x2108f92a6e511cb3}},2,"F-H0-654",836,1},
  {{{0x8b3c0ff33736cb8c}},10,"F-H0-655",723,1},
  {{{0x8b3c0ff33736cb8c}},10,"F-H0-656",761,1},
  {{{0xd9a52f083237058d}},5,"F-H0-657",574,1},
  {{{0x1ea85f03c8c51c57}},5,"F-H0-658",606,1},
  {{{0x817d23478d26f7e2}},6,"F-H0-659",539,1},
  {{{0x817d23478d26f7e2}},6,"F-H0-660",538,1},
  {{{0xf34da22c9f6275a1}},4,"F-H0-661",833,1},
  {{{0x617d29cfa328dc5f}},4,"F-H0-662",614,1},
  {{{0x5a36b334e6250de1}},7,"F-H0-663",831,1},
  {{{0x5a36b334e6250de1}},7,"F-H0-664",832,1},
  {{{0xd1846a113700012b}},7,"F-H0-665",539,1},
  {{{0xd1846a113700012b}},7,"F-H0-666",501,1},
  {{{0x45ce00391e36602e}},5,"F-H0-667",571,2},
  {{{0xf6f6358d16867089}},4,"F-H0-668",614,1},
  {{{0xa2472f8ea6043118}},4,"F-H0-669",607,1},
  {{{0x283e8e8e76fd8b7a}},5,"F-H0-670",536,1},
  {{{0x541fe9feab6384bc}},5,"F-H0-671",832,1},
  {{{0xf5a8fd1b29c93ebf}},4,"F-H0-672",535,1},
  {{{0x463a4dbe6cf80c2f}},5,"F-H0-673",828,1},
  {{{0xf7edc4d11462451f}},5,"F-H0-674",725,1},
  {{{0x11026288f1e720d1}},3,"F-H0-675",538,2},
  {{{0x15f43717ce3e60d9}},4,"F-H0-676",535,1},
  {{{0xbe1797a8e5bbf2e0}},4,"F-H0-677",798,1},
  {{{0xef18dcf2855d57ed}},5,"F-H0-678",797,1},
  {{{0xef18dcf2855d57ed}},5,"F-H0-679",687,1},
  {{{0x681be07d1961f958}},3,"F-H0-680",688,1},
  {{{0xce820c0e138acece}},3,"F-H0-681",575,1},
  {{{0x6e888e694813ced1}},6,"F-H0-682",872,1},
  {{{0x28bd1567ffec22e8}},6,"F-H0-683",612,1},
  {{{0xa6960fa01e54c028}},5,"F-H0-684",835,1},
  {{{0x33f56b88c9e642e8}},3,"F-H0-685",539,1},
  {{{0x7f2b5db7ca43c995}},3,"F-H0-686",798,1},
  {{{0x37ade954ed371310}},7,"F-H0-687",614,1},
  {{{0x646c4be844648fe4}},6,"F-H0-688",535,1},
  {{{0x246f494621baa88a}},6,"F-H0-689",651,1},
  {{{0xf20f22a2df014a3}},3,"F-H0-690",537,1},
  {{{0x16132fb4dfff3508}},3,"F-H0-691",835,1},
  {{{0xf76c11bd6c62690d}},3,"F-H0-692",569,1},
  {{{0xf76c11bd6c62690d}},3,"F-H0-693",532,1},
  {{{0x159d657b5cc0f15e}},8,"F-H0-694",613,1},
  {{{0x59c36df119f2d0af}},8,"F-H0-695",501,1},
  {{{0x91b8fa3130fdb780}},4,"F-H0-696",797,1},
  {{{0xdc5561f214811783}},4,"F-H0-697",606,1},
  {{{0xf575fc97d428fa18}},4,"F-H0-698",606,1},
  {{{0x4fce9f149fbba08}},4,"F-H0-699",575,1},
  {{{0x6465a18d2a2a87b2}},5,"F-H0-700",614,1},
  {{{0x2f31f89743345fa3}},5,"F-H0-701",754,1},
  {{{0xaf9081ccf2d20224}},4,"F-H0-702",612,1},
  {{{0x9f87bf0a72a8a506}},4,"F-H0-703",571,1},
  {{{0xcc926f06854076ef}},4,"F-H0-704",797,2},
  {{{0x7454800f01560272}},3,"F-H0-705",799,1},
  {{{0xfce4d76fe037d082}},3,"F-H0-706",754,1},
  {{{0x427c3839101d1f08}},6,"F-H0-707",834,1},
  {{{0x5feb36610685e438}},6,"F-H0-708",832,1},
  {{{0x7a49fe74bffdcaeb}},3,"F-H0-709",829,1},
  {{{0xb23046cefc6060a6}},3,"F-H0-710",570,1},
  {{{0x7e3030bb86e51b17}},4,"F-H0-711",837,2},
  {{{0x73e863850ed33e8a}},4,"F-H0-712",606,1},
  {{{0x895a9675e50dc66}},4,"F-H0-713",571,1},
  {{{0x63ff478233623fdc}},7,"F-H0-714",830,1},
  {{{0x40828ff77111aeb1}},3,"F-H0-715",643,1},
  {{{0x9956b2d4264a1345}},7,"F-H0-716",794,1},
  {{{0x1dc81447ca526421}},7,"F-H0-717",680,1},
  {{{0xc9d35ad7821941e9}},5,"F-H0-718",834,1},
  {{{0x63b2ec7e78a99dac}},5,"F-H0-719",537,1},
  {{{0xceda112678070ceb}},4,"F-H0-720",533,1},
  {{{0xc867c393de198c77}},4,"F-H0-721",718,1},
  {{{0x609ff224df4a47f5}},6,"F-H0-722",832,1},
  {{{0x391f6a6c7ed41971}},3,"F-H0-723",836,1},
  {{{0x8e20c3046e2c8daa}},3,"F-H0-724",577,1},
  {{{0x1968fa1e508ddf90}},8,"F-H0-725",572,2},
  {{{0x61e12f8febec6753}},3,"F-H0-726",680,1},
  {{{0x61e12f8febec6753}},3,"F-H0-727",681,1},
  {{{0x454851fdd2833cc1}},4,"F-H0-728",799,1},
  {{{0x2e3a7d7340a7b08f}},4,"F-H0-729",799,1},
  {{{0x21fa158c8591feef}},4,"F-H0-730",576,1},
  {{{0xf38dfaf6ebe997e2}},7,"F-H0-731",531,1},
  {{{0xfa95e0720c41776}},7,"F-H0-732",688,1},
  {{{0x80e55619d51634a9}},3,"F-H0-733",829,1},
  {{{0xfb299e72fae16940}},3,"F-H0-734",754,1},
  {{{0x30bccda0f4860f69}},7,"F-H0-735",533,2},
  {{{0xd87b52fe3613462f}},5,"F-H0-736",650,1},
  {{{0xc43793be6a080c26}},5,"F-H0-737",832,1},
  {{{0xe40a7a6799ab04ad}},4,"F-H0-738",792,2},
  {{{0x6fb55b3e2ccb5f88}},2,"F-H0-739",571,1},
  {{{0x6fb55b3e2ccb5f88}},2,"F-H0-740",791,1},
  {{{0xd7a4144ca09dade4}},4,"F-H0-741",651,1},
  {{{0x5bad0818efa170bf}},5,"F-H0-742",535,1},
  {{{0xec11c362b1144178}},5,"F-H0-743",681,1},
  {{{0x977f233a2343841e}},4,"F-H0-744",754,1},
  {{{0x977f233a2343841e}},4,"F-H0-745",569,1},
  {{{0x78f196dd9dc5512f}},7,"F-H0-746",760,1},
  {{{0x7bd8571fa08d2001}},3,"F-H0-747",577,2},
  {{{0x9d3fd6e5130dcb99}},4,"F-H0-748",538,2},
  {{{0x3d1cc3f0d4a4df4f}},4,"F-H0-749",572,1},
  {{{0x2c9ca8cffb505372}},4,"F-H0-750",607,1},
  {{{0x79108b47bf21ce70}},5,"F-H0-751",829,1},
  {{{0x79108b47bf21ce70}},5,"F-H0-752",793,1},
  {{{0xe8a91784ff4eac09}},1,"F-H0-753",792,1},
  {{{0xa2ff9674a804ec0d}},1,"F-H0-754",829,1},
  {{{0x68923594d2800dbf}},5,"F-H0-755",865,1},
  {{{0x7904859a63085f1b}},5,"F-H0-756",501,1},
  {{{0x7904859a63085f1b}},5,"F-H0-757",539,1},
  {{{0x8a49127a9747bdec}},4,"F-H0-758",799,1},
  {{{0xbe7be6daf0ce232}},4,"F-H0-759",688,1},
  {{{0x21198ade828a753f}},4,"F-H0-760",539,2},
  {{{0x23c720ccd1c7abca}},8,"F-H0-761",759,1},
  {{{0x467e7ac29c748651}},7,"F-H0-762",799,1},
  {{{0xe5c2470d410f9906}},7,"F-H0-763",577,1},
  {{{0xa2cad72e0b6e5760}},4,"F-H0-764",792,1},
  {{{0x36f32a4df3ebe199}},4,"F-H0-765",614,1},
  {{{0x31c842c83944cca0}},4,"F-H0-766",830,1},
  {{{0x762883c7d0098bfa}},3,"F-H0-767",576,2},
  {{{0xd210c5e9aadedc9}},3,"F-H0-768",569,1},
  {{{0x54ac3112d762c94e}},3,"F-H0-769",650,1},
  {{{0x42ac6e556ee1fee8}},6,"F-H0-770",649,1},
  {{{0xcf4c1bf41ef93e2b}},9,"F-H0-771",538,1},
  {{{0xcf4c1bf41ef93e2b}},9,"F-H0-772",643,1},
  {{{0xa02c266599a37eaf}},2,"F-H0-773",570,1},
  {{{0xa02c266599a37eaf}},2,"F-H0-774",830,1},
  {{{0x297114b3d032c5cc}},4,"F-H0-775",536,1},
  {{{0x297114b3d032c5cc}},4,"F-H0-776",717,1},
  {{{0x2c8d911d9b1a216d}},4,"F-H0-777",533,1},
  {{{0x2c8d911d9b1a216d}},4,"F-H0-778",607,1},
  {{{0x62154d5b48a87fe7}},7,"F-H0-779",688,1},
  {{{0x1deb90addb6725bc}},4,"F-H0-780",651,2},
  {{{0xc84664ea66b1bea4}},8,"F-H0-781",651,1},
  {{{0x764fc0e6974b5bfb}},5,"F-H0-782",688,1},
  {{{0x764fc0e6974b5bfb}},5,"F-H0-783",717,1},
  {{{0x92be8810c834c813}},4,"F-H0-784",577,1},
  {{{0x92be8810c834c813}},4,"F-H0-785",793,1},
  {{{0xee1a15a72926c74d}},3,"F-H0-786",569,1},
  {{{0x2a352b9eb6ab1927}},3,"F-H0-787",570,1},
  {{{0x85f97ef56746c02a}},3,"F-H0-788",576,1},
  {{{0x85f97ef56746c02a}},3,"F-H0-789",539,1},
  {{{0xf0ff568453ac365d}},4,"F-H0-790",790,1},
  {{{0xf0ff568453ac365d}},4,"F-H0-791",569,1},
  {{{0x4191abcd06e04eb2}},4,"F-H0-792",797,1},
  {{{0xd887d0d202e9ef7d}},4,"F-H0-793",828,1},
  {{{0xe8148bc3bb4ec8ef}},4,"F-H0-794",829,2},
  {{{0xab6e5d3702cc6f78}},3,"F-H0-795",539,1},
  {{{0x2ab6d488df20903e}},3,"F-H0-796",798,1},
  {{{0xb202b3e1b1058be9}},4,"F-H0-797",570,1},
  {{{0x973e1b99dab3afaf}},4,"F-H0-798",571,1},
  {{{0x973e1b99dab3afaf}},4,"F-H0-799",836,1},
  {{{0x34bde537f037f114}},3,"F-H0-800",828,1},
  {{{0x5783f5a61825c724}},3,"F-H0-801",533,1},
  {{{0xd97e8efd69443d84}},7,"F-H0-802",540,1},
  {{{0x8c1d04c8f4b75d49}},4,"F-H0-803",836,1},
  {{{0x8c1d04c8f4b75d49}},4,"F-H0-804",798,1},
  {{{0xc9bfbf5a30f65117}},5,"F-H0-805",606,1},
  {{{0x18721683245498e2}},5,"F-H0-806",797,1},
  {{{0x58904c56d752fe1d}},5,"F-H0-807",835,2},
  {{{0x5b7857e07f1c3e68}},6,"F-H0-808",796,1},
  {{{0x2b0e664ae2625143}},6,"F-H0-809",831,1},
  {{{0x6c32b01f840ec141}},2,"F-H0-810",835,1},
  {{{0x6c32b01f840ec141}},2,"F-H0-811",533,1},
  {{{0xe13d776cbcce5fa4}},4,"F-H0-812",534,1},
  {{{0xf0d2e8bb52d42a7e}},4,"F-H0-813",533,1},
  {{{0xcc219b5134c145d3}},4,"F-H0-814",799,2},
  {{{0xb1b06fec31b760fd}},5,"F-H0-815",833,2},
  {{{0x58948da5d3e45d9a}},7,"F-H0-816",680,1},
  {{{0x58948da5d3e45d9a}},7,"F-H0-817",644,1},
  {{{0x16e3871e6b25b8a3}},6,"F-H0-818",535,1},
  {{{0x16e3871e6b25b8a3}},6,"F-H0-819",534,1},
  {{{0x2c3cbd057c348659}},6,"F-H0-820",577,2},
  {{{0x6e6fd039ff704975}},7,"F-H0-821",758,1},
  {{{0x13d0556ecdfce676}},7,"F-H0-822",606,1},
  {{{0x47eabca13534a94b}},4,"F-H0-823",762,2},
  {{{0x3e40e1157af9df08}},4,"F-H0-824",608,1},
  {{{0x6ad34c846dc6fb5d}},4,"F-H0-825",570,1},
  {{{0xbf039b420bca7789}},10,"F-H0-826",537,1},
  {{{0xbf039b420bca7789}},10,"F-H0-827",832,1},
  {{{0x2b9ce9b89b1d5903}},4,"F-H0-828",577,1},
  {{{0x2b9ce9b89b1d5903}},4,"F-H0-829",540,1},
  {{{0x593361b58a4e2964}},2,"F-H0-830",725,1},
  {{{0xf449d0c0033e58a9}},2,"F-H0-831",755,1},
  {{{0xb6d2855985841037}},6,"F-H0-832",577,1},
  {{{0x25a3c42e0ef36931}},6,"F-H0-833",792,1},
  {{{0x16e09c0f13a605ba}},6,"F-H0-834",763,1},
  {{{0xc5b68eb41458caed}},6,"F-H0-835",833,1},
  {{{0xc5b68eb41458caed}},6,"F-H0-836",796,1},
  {{{0x78e45714239b0241}},4,"F-H0-837",794,1},
  {{{0xc517a771cabf5c3b}},4,"F-H0-838",798,1},
  {{{0xca61a8efa9487e2e}},8,"F-H0-839",865,1},
  {{{0x236cb32570430eeb}},8,"F-H0-840",832,1},
  {{{0xd31a578712ec9834}},5,"F-H0-841",576,1},
  {{{0xd31a578712ec9834}},5,"F-H0-842",539,1},
  {{{0x9461cf74e2ac784c}},5,"F-H0-843",574,1},
  {{{0x831355cccd79b070}},5,"F-H0-844",536,1},
  {{{0xf4118b25998b1c4b}},3,"F-H0-845",569,2},
  {{{0x44d3933bda43dcd4}},5,"F-H0-846",536,1},
  {{{0x78a8cf319c39d121}},6,"F-H0-847",535,2},
  {{{0xb9fae5ea164aae50}},4,"F-H0-848",651,1},
  {{{0xb9fae5ea164aae50}},4,"F-H0-849",532,1},
  {{{0x83d597663342f4c9}},5,"F-H0-850",614,1},
  {{{0x1335f426491d9a93}},5,"F-H0-851",797,1},
  {{{0xb4c3ae991be76e88}},2,"F-H0-852",835,1},
  {{{0xfeb417637a588b5d}},2,"F-H0-853",798,1},
  {{{0xcac0276bf2c26ea5}},5,"F-H0-854",829,1},
  {{{0x26de4d1cc50a112c}},5,"F-H0-855",569,1},
  {{{0x26de4d1cc50a112c}},5,"F-H0-856",532,1},
  {{{0xb2ec9226667bb3d9}},3,"F-H0-857",532,1},
  {{{0xb2ec9226667bb3d9}},3,"F-H0-858",569,1},
  {{{0xb6e1ef1312836b58}},9,"F-H0-859",541,1},
  {{{0xb6e1ef1312836b58}},9,"F-H0-860",539,1},
  {{{0xdd8de5172965650d}},4,"F-H0-861",534,1},
  {{{0xdd8de5172965650d}},4,"F-H0-862",797,1},
  {{{0x93bfad16a7ef2e74}},3,"F-H0-863",791,1},
  {{{0x85c1d75f5c971c47}},3,"F-H0-864",577,1},
  {{{0x85c1d75f5c971c47}},-1,NULL,0,0},
};
