/* Color.c generated by valac 0.56.17, the Vala compiler
 * generated from Color.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * Copyright 2011–2013 Robert Dyer
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_DRAWING_COLOR_0_PROPERTY,
	GRANITE_DRAWING_COLOR_NUM_PROPERTIES
};
static GParamSpec* granite_drawing_color_properties[GRANITE_DRAWING_COLOR_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer granite_drawing_color_parent_class = NULL;
static GraniteServicesSettingsSerializableIface * granite_drawing_color_granite_services_settings_serializable_parent_iface = NULL;

static void granite_drawing_color_set_from_rgba (GraniteDrawingColor* self,
                                          GdkRGBA* color);
static void granite_drawing_color_rgb_to_hsv (GraniteDrawingColor* self,
                                       gdouble r,
                                       gdouble g,
                                       gdouble b,
                                       gdouble* h,
                                       gdouble* s,
                                       gdouble* v);
static void granite_drawing_color_hsv_to_rgb (GraniteDrawingColor* self,
                                       gdouble h,
                                       gdouble s,
                                       gdouble v,
                                       gdouble* r,
                                       gdouble* g,
                                       gdouble* b);
static gchar* granite_drawing_color_real_settings_serialize (GraniteServicesSettingsSerializable* base);
static void granite_drawing_color_real_settings_deserialize (GraniteServicesSettingsSerializable* base,
                                                      const gchar* s);
static void granite_drawing_color_finalize (GObject * obj);
static GType granite_drawing_color_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

/**
         * Extracts the alpha value from the integer value
         * serialized by {@link Granite.Drawing.Color.to_int}.
         *
         * @return the alpha channel value as a uint8 ranging from 0 - 255.
         */
guint8
granite_drawing_color_alpha_from_int (gint color)
{
	guint8 result;
	result = (guint8) ((color >> 24) & 0xFF);
	return result;
}

/**
         * Extracts the red value from the integer value
         * serialized by {@link Granite.Drawing.Color.to_int}.
         *
         * @return the red channel value as a uint8 ranging from 0 - 255.
         */
guint8
granite_drawing_color_red_from_int (gint color)
{
	guint8 result;
	result = (guint8) ((color >> 16) & 0xFF);
	return result;
}

/**
         * Extracts the green value from the integer value
         * serialized by {@link Granite.Drawing.Color.to_int}.
         *
         * @return the green channel value as a uint8 ranging from 0 - 255.
         */
guint8
granite_drawing_color_green_from_int (gint color)
{
	guint8 result;
	result = (guint8) ((color >> 8) & 0xFF);
	return result;
}

/**
         * Extracts the blue value from the integer value
         * serialized by {@link Granite.Drawing.Color.to_int}.
         *
         * @return the blue channel value as a uint8 ranging from 0 - 255.
         */
guint8
granite_drawing_color_blue_from_int (gint color)
{
	guint8 result;
	result = (guint8) (color & 0xFF);
	return result;
}

/**
         * Constructs a new {@link Granite.Drawing.Color} with the supplied values.
         *
         * @param R the value of the red channel as a double
         * @param G the value of the green channel as a double
         * @param B the value of the blue channel as a double
         * @param A the value of the alpha channel as a double
         */
GraniteDrawingColor*
granite_drawing_color_construct (GType object_type,
                                 gdouble R,
                                 gdouble G,
                                 gdouble B,
                                 gdouble A)
{
	GraniteDrawingColor * self = NULL;
	self = (GraniteDrawingColor*) g_object_new (object_type, NULL);
	self->R = R;
	self->G = G;
	self->B = B;
	self->A = A;
	return self;
}

GraniteDrawingColor*
granite_drawing_color_new (gdouble R,
                           gdouble G,
                           gdouble B,
                           gdouble A)
{
	return granite_drawing_color_construct (GRANITE_DRAWING_TYPE_COLOR, R, G, B, A);
}

/**
         * Constructs a new {@link Granite.Drawing.Color} from a {@link Gdk.Color}.
         *
         * @param color the {@link Gdk.Color}
         */
GraniteDrawingColor*
granite_drawing_color_construct_from_gdk (GType object_type,
                                          GdkColor* color)
{
	GraniteDrawingColor * self = NULL;
	GdkColor _tmp0_;
	GdkColor _tmp1_;
	GdkColor _tmp2_;
	g_return_val_if_fail (color != NULL, NULL);
	self = (GraniteDrawingColor*) g_object_new (object_type, NULL);
	_tmp0_ = *color;
	self->R = _tmp0_.red / ((gdouble) G_MAXUINT16);
	_tmp1_ = *color;
	self->G = _tmp1_.green / ((gdouble) G_MAXUINT16);
	_tmp2_ = *color;
	self->B = _tmp2_.blue / ((gdouble) G_MAXUINT16);
	self->A = 1.0;
	return self;
}

GraniteDrawingColor*
granite_drawing_color_new_from_gdk (GdkColor* color)
{
	return granite_drawing_color_construct_from_gdk (GRANITE_DRAWING_TYPE_COLOR, color);
}

/**
         * Constructs a new {@link Granite.Drawing.Color} from a {@link Gdk.RGBA}.
         *
         * @param color the {@link Gdk.RGBA}
         */
GraniteDrawingColor*
granite_drawing_color_construct_from_rgba (GType object_type,
                                           GdkRGBA* color)
{
	GraniteDrawingColor * self = NULL;
	GdkRGBA _tmp0_;
	g_return_val_if_fail (color != NULL, NULL);
	self = (GraniteDrawingColor*) g_object_new (object_type, NULL);
	_tmp0_ = *color;
	granite_drawing_color_set_from_rgba (self, &_tmp0_);
	return self;
}

GraniteDrawingColor*
granite_drawing_color_new_from_rgba (GdkRGBA* color)
{
	return granite_drawing_color_construct_from_rgba (GRANITE_DRAWING_TYPE_COLOR, color);
}

/**
         * Constructs a new {@link Granite.Drawing.Color} from a string.
         *
         * The string can be either one of:
         *
         * * A standard name (Taken from the X11 rgb.txt file).
         * * A hexadecimal value in the form “#rgb”, “#rrggbb”, “#rrrgggbbb” or ”#rrrrggggbbbb”
         * * A RGB color in the form “rgb(r,g,b)” (In this case the color will have full opacity)
         * * A RGBA color in the form “rgba(r,g,b,a)”
         *
         * For more details on formatting and how this function works see {@link Gdk.RGBA.parse}
         *
         * @param color the string specifying the color
         */
GraniteDrawingColor*
granite_drawing_color_construct_from_string (GType object_type,
                                             const gchar* color)
{
	GraniteDrawingColor * self = NULL;
	GdkRGBA rgba = {0};
	GdkRGBA _tmp0_;
	g_return_val_if_fail (color != NULL, NULL);
	self = (GraniteDrawingColor*) g_object_new (object_type, NULL);
	memset (&rgba, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&rgba, color);
	_tmp0_ = rgba;
	granite_drawing_color_set_from_rgba (self, &_tmp0_);
	return self;
}

GraniteDrawingColor*
granite_drawing_color_new_from_string (const gchar* color)
{
	return granite_drawing_color_construct_from_string (GRANITE_DRAWING_TYPE_COLOR, color);
}

/**
         * Constructs a new {@link Granite.Drawing.Color} from an integer.
         *
         * This constructor should be used when deserializing the previously serialized
         * color by {@link Granite.Drawing.Color.to_int}.
         *
         * For more details on what format the color integer representation has, see {@link Granite.Drawing.Color.to_int}.
         *
         * If you would like to deserialize the A, R, G and B values from the integer without
         * creating a new instance of {@link Granite.Drawing.Color}, you can use the available
         * //*_from_int// static method collection such as {@link Granite.Drawing.Color.alpha_from_int}.
         *
         * @param color the integer specyfying the color
         */
GraniteDrawingColor*
granite_drawing_color_construct_from_int (GType object_type,
                                          gint color)
{
	GraniteDrawingColor * self = NULL;
	self = (GraniteDrawingColor*) g_object_new (object_type, NULL);
	self->R = ((gdouble) granite_drawing_color_red_from_int (color)) / ((gdouble) G_MAXUINT8);
	self->G = ((gdouble) granite_drawing_color_green_from_int (color)) / ((gdouble) G_MAXUINT8);
	self->B = ((gdouble) granite_drawing_color_blue_from_int (color)) / ((gdouble) G_MAXUINT8);
	self->A = ((gdouble) granite_drawing_color_alpha_from_int (color)) / ((gdouble) G_MAXUINT8);
	return self;
}

GraniteDrawingColor*
granite_drawing_color_new_from_int (gint color)
{
	return granite_drawing_color_construct_from_int (GRANITE_DRAWING_TYPE_COLOR, color);
}

/**
         * Changes the hue of this color to the supplied one.
         *
         * @param hue the hue to change this color to
         *
         * @return the new {@link Granite.Drawing.Color}
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GraniteDrawingColor*
granite_drawing_color_set_hue (GraniteDrawingColor* self,
                               gdouble hue)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail ((hue >= ((gdouble) 0)) && (hue <= ((gdouble) 360)), "hue >= 0 && hue <= 360", NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	h = hue;
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

/**
         * Changes the saturation of this color to the supplied one.
         *
         * @param sat the saturation to change this color to
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_set_sat (GraniteDrawingColor* self,
                               gdouble sat)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail ((sat >= ((gdouble) 0)) && (sat <= ((gdouble) 1)), "sat >= 0 && sat <= 1", NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	s = sat;
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

/**
         * Changes the value of this color to the supplied one.
         *
         * @param val the value to change this color to
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_set_val (GraniteDrawingColor* self,
                               gdouble val)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail ((val >= ((gdouble) 0)) && (val <= ((gdouble) 1)), "val >= 0 && val <= 1", NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	v = val;
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

/**
         * Changes the value of the alpha channel.
         *
         * @param alpha the value of the alpha channel
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_set_alpha (GraniteDrawingColor* self,
                                 gdouble alpha)
{
	GraniteDrawingColor* _tmp0_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail ((alpha >= ((gdouble) 0)) && (alpha <= ((gdouble) 1)), "alpha >= 0 && alpha <= 1", NULL);
	self->A = alpha;
	_tmp0_ = _g_object_ref0 (self);
	result = _tmp0_;
	return result;
}

/**
         * Get the value.
         * @return the hue of this color, as a double value
         */
gdouble
granite_drawing_color_get_hue (GraniteDrawingColor* self)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	result = h;
	return result;
}

/**
         * Get the value.
         * @return the saturation of this color, as a double value
         */
gdouble
granite_drawing_color_get_sat (GraniteDrawingColor* self)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	result = s;
	return result;
}

/**
         * Get the value.
         *
         * @return the value of this color, as a double value
         */
gdouble
granite_drawing_color_get_val (GraniteDrawingColor* self)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	result = v;
	return result;
}

/**
         * Adds the supplied hue value to this color's hue value.
         *
         * @param val the hue to add to this color's hue
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_add_hue (GraniteDrawingColor* self,
                               gdouble val)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	h = fmod (fmod (h + val, 360) + 360, 360);
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

/**
         * Changes this color's saturation to the supplied saturation, if it is greater than this color's saturation.
         *
         * @param sat the saturation to change this color to
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_set_min_sat (GraniteDrawingColor* self,
                                   gdouble sat)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail ((sat >= ((gdouble) 0)) && (sat <= ((gdouble) 1)), "sat >= 0 && sat <= 1", NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	s = MAX (s, sat);
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

/**
         * Changes this color's value to the supplied value, if it is greater than this color's value.
         *
         * @param val the value to change this color to
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_set_min_value (GraniteDrawingColor* self,
                                     gdouble val)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail ((val >= ((gdouble) 0)) && (val <= ((gdouble) 1)), "val >= 0 && val <= 1", NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	v = MAX (v, val);
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

/**
         * Changes this color's saturation to the supplied saturation, if it is smaller than this color's saturation.
         *
         * @param sat the hue to change this color to
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_set_max_sat (GraniteDrawingColor* self,
                                   gdouble sat)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail ((sat >= ((gdouble) 0)) && (sat <= ((gdouble) 1)), "sat >= 0 && sat <= 1", NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	s = MIN (s, sat);
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

/**
         * Changes this color's value to the supplied value, if it is smaller than this color's value.
         *
         * @param val the value to change this color to
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_set_max_val (GraniteDrawingColor* self,
                                   gdouble val)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail ((val >= ((gdouble) 0)) && (val <= ((gdouble) 1)), "val >= 0 && val <= 1", NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	v = MIN (v, val);
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

/**
         * Multiplies this color's saturation by the supplied amount.
         *
         * @param amount the amount to multiply the saturation by
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_multiply_sat (GraniteDrawingColor* self,
                                    gdouble amount)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail (amount >= ((gdouble) 0), "amount >= 0", NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	s = MIN ((gdouble) 1, s * amount);
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

/**
         * Brightens this color's value by the supplied amount.
         *
         * @param amount the amount to brighten the value by
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_brighten_val (GraniteDrawingColor* self,
                                    gdouble amount)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail ((amount >= ((gdouble) 0)) && (amount <= ((gdouble) 1)), "amount >= 0 && amount <= 1", NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	v = MIN ((gdouble) 1, v + ((1 - v) * amount));
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

/**
         * Darkens this color's value by the supplied amount.
         *
         * @param amount the amount to darken the value by
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_darken_val (GraniteDrawingColor* self,
                                  gdouble amount)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail ((amount >= ((gdouble) 0)) && (amount <= ((gdouble) 1)), "amount >= 0 && amount <= 1", NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	v = MAX ((gdouble) 0, v - ((1 - v) * amount));
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

/**
         * Darkens this color's value by the supplied amount * color's saturation.
         *
         * @param amount the amount to darken the value by
         *
         * @return the new {@link Granite.Drawing.Color}
         */
GraniteDrawingColor*
granite_drawing_color_darken_by_sat (GraniteDrawingColor* self,
                                     gdouble amount)
{
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GraniteDrawingColor* _tmp6_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail ((amount >= ((gdouble) 0)) && (amount <= ((gdouble) 1)), "amount >= 0 && amount <= 1", NULL);
	granite_drawing_color_rgb_to_hsv (self, self->R, self->G, self->B, &_tmp0_, &_tmp1_, &_tmp2_);
	h = _tmp0_;
	s = _tmp1_;
	v = _tmp2_;
	v = MAX ((gdouble) 0, v - (amount * s));
	granite_drawing_color_hsv_to_rgb (self, h, s, v, &_tmp3_, &_tmp4_, &_tmp5_);
	self->R = _tmp3_;
	self->G = _tmp4_;
	self->B = _tmp5_;
	_tmp6_ = _g_object_ref0 (self);
	result = _tmp6_;
	return result;
}

static void
granite_drawing_color_rgb_to_hsv (GraniteDrawingColor* self,
                                  gdouble r,
                                  gdouble g,
                                  gdouble b,
                                  gdouble* h,
                                  gdouble* s,
                                  gdouble* v)
{
	gdouble _vala_h = 0.0;
	gdouble _vala_s = 0.0;
	gdouble _vala_v = 0.0;
	gdouble min = 0.0;
	gdouble max = 0.0;
	gdouble delta = 0.0;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail ((r >= ((gdouble) 0)) && (r <= ((gdouble) 1)), "r >= 0 && r <= 1");
	_vala_return_if_fail ((g >= ((gdouble) 0)) && (g <= ((gdouble) 1)), "g >= 0 && g <= 1");
	_vala_return_if_fail ((b >= ((gdouble) 0)) && (b <= ((gdouble) 1)), "b >= 0 && b <= 1");
	min = MIN (r, MIN (g, b));
	max = MAX (r, MAX (g, b));
	_vala_v = max;
	if (_vala_v == ((gdouble) 0)) {
		_vala_h = (gdouble) 0;
		_vala_s = (gdouble) 0;
		if (h) {
			*h = _vala_h;
		}
		if (s) {
			*s = _vala_s;
		}
		if (v) {
			*v = _vala_v;
		}
		return;
	}
	r = r / _vala_v;
	g = g / _vala_v;
	b = b / _vala_v;
	min = MIN (r, MIN (g, b));
	max = MAX (r, MAX (g, b));
	delta = max - min;
	_vala_s = delta;
	if (_vala_s == ((gdouble) 0)) {
		_vala_h = (gdouble) 0;
		if (h) {
			*h = _vala_h;
		}
		if (s) {
			*s = _vala_s;
		}
		if (v) {
			*v = _vala_v;
		}
		return;
	}
	r = (r - min) / delta;
	g = (g - min) / delta;
	b = (b - min) / delta;
	if (max == r) {
		_vala_h = 0 + (60 * (g - b));
		if (_vala_h < ((gdouble) 0)) {
			_vala_h = _vala_h + 360;
		}
	} else {
		if (max == g) {
			_vala_h = 120 + (60 * (b - r));
		} else {
			_vala_h = 240 + (60 * (r - g));
		}
	}
	if (h) {
		*h = _vala_h;
	}
	if (s) {
		*s = _vala_s;
	}
	if (v) {
		*v = _vala_v;
	}
}

static void
granite_drawing_color_hsv_to_rgb (GraniteDrawingColor* self,
                                  gdouble h,
                                  gdouble s,
                                  gdouble v,
                                  gdouble* r,
                                  gdouble* g,
                                  gdouble* b)
{
	gdouble _vala_r = 0.0;
	gdouble _vala_g = 0.0;
	gdouble _vala_b = 0.0;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail ((h >= ((gdouble) 0)) && (h <= ((gdouble) 360)), "h >= 0 && h <= 360");
	_vala_return_if_fail ((s >= ((gdouble) 0)) && (s <= ((gdouble) 1)), "s >= 0 && s <= 1");
	_vala_return_if_fail ((v >= ((gdouble) 0)) && (v <= ((gdouble) 1)), "v >= 0 && v <= 1");
	_vala_r = (gdouble) 0;
	_vala_g = (gdouble) 0;
	_vala_b = (gdouble) 0;
	if (s == ((gdouble) 0)) {
		_vala_r = v;
		_vala_g = v;
		_vala_b = v;
	} else {
		gint sec_num = 0;
		gdouble frac_sec = 0.0;
		gdouble p = 0.0;
		gdouble q = 0.0;
		gdouble t = 0.0;
		sec_num = (gint) floor (h / 60);
		frac_sec = (h / 60.0) - sec_num;
		p = v * (1 - s);
		q = v * (1 - (s * frac_sec));
		t = v * (1 - (s * (1 - frac_sec)));
		switch (sec_num) {
			case 0:
			{
				_vala_r = v;
				_vala_g = t;
				_vala_b = p;
				break;
			}
			case 1:
			{
				_vala_r = q;
				_vala_g = v;
				_vala_b = p;
				break;
			}
			case 2:
			{
				_vala_r = p;
				_vala_g = v;
				_vala_b = t;
				break;
			}
			case 3:
			{
				_vala_r = p;
				_vala_g = q;
				_vala_b = v;
				break;
			}
			case 4:
			{
				_vala_r = t;
				_vala_g = p;
				_vala_b = v;
				break;
			}
			case 5:
			{
				_vala_r = v;
				_vala_g = p;
				_vala_b = q;
				break;
			}
			default:
			break;
		}
	}
	if (r) {
		*r = _vala_r;
	}
	if (g) {
		*g = _vala_g;
	}
	if (b) {
		*b = _vala_b;
	}
}

/**
         * {@inheritDoc}
         */
static gchar*
granite_drawing_color_real_settings_serialize (GraniteServicesSettingsSerializable* base)
{
	GraniteDrawingColor * self;
	gchar* _tmp0_;
	gchar* result;
	self = (GraniteDrawingColor*) base;
	_tmp0_ = g_strdup_printf ("%d;;%d;;%d;;%d", (gint) (self->R * G_MAXUINT8), (gint) (self->G * G_MAXUINT8), (gint) (self->B * G_MAXUINT8), (gint) (self->A * G_MAXUINT8));
	result = _tmp0_;
	return result;
}

/**
         * {@inheritDoc}
         */
static void
granite_drawing_color_real_settings_deserialize (GraniteServicesSettingsSerializable* base,
                                                 const gchar* s)
{
	GraniteDrawingColor * self;
	gchar** parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint parts_length1;
	gint _parts_size_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	self = (GraniteDrawingColor*) base;
	g_return_if_fail (s != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (s, ";;", 0);
	parts = _tmp1_;
	parts_length1 = _vala_array_length (_tmp0_);
	_parts_size_ = parts_length1;
	_tmp2_ = parts[0];
	self->R = MIN ((gdouble) G_MAXUINT8, MAX ((gdouble) 0, (gdouble) atoi (_tmp2_))) / G_MAXUINT8;
	_tmp3_ = parts[1];
	self->G = MIN ((gdouble) G_MAXUINT8, MAX ((gdouble) 0, (gdouble) atoi (_tmp3_))) / G_MAXUINT8;
	_tmp4_ = parts[2];
	self->B = MIN ((gdouble) G_MAXUINT8, MAX ((gdouble) 0, (gdouble) atoi (_tmp4_))) / G_MAXUINT8;
	_tmp5_ = parts[3];
	self->A = MIN ((gdouble) G_MAXUINT8, MAX ((gdouble) 0, (gdouble) atoi (_tmp5_))) / G_MAXUINT8;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
}

/**
         * Returns a textual specification of this in the form `rgb (r, g, b)` or `rgba (r, g, b, a)`,
         * where “r”, “g”, “b” and “a” represent the red, green, blue and alpha values respectively.
         *
         * r, g, and b are represented as integers in the range 0 to 255, and a is represented as
         * floating point value in the range 0 to 1.
         *
         * Note: that this string representation may lose some precision, since r, g and b are represented
         * as 8-bit integers. If this is a concern, you should use a different representation.
         *
         * This returns the same string as a {@link Gdk.RGBA} would return in {@link Gdk.RGBA.to_string}
         *
         * @return the text string
         */
gchar*
granite_drawing_color_to_string (GraniteDrawingColor* self)
{
	GdkRGBA rgba = {0};
	GdkRGBA _tmp0_ = {0};
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_.red = self->R;
	_tmp0_.green = self->G;
	_tmp0_.blue = self->B;
	_tmp0_.alpha = self->A;
	rgba = _tmp0_;
	_tmp1_ = gdk_rgba_to_string (&rgba);
	result = _tmp1_;
	return result;
}

/**
         * Converts this to a 32 bit integer.
         *
         * This function can be useful for serializing the color so that it can be stored
         * and retrieved easily with hash tables and lists.
         *
         * The returned integer will contain the four channels
         * that define the {@link Granite.Drawing.Color} class: alpha, red, green and blue.
         *
         * Each channel is represented by 8 bits.
         * The first 8 bits of the integer conatin the alpha channel while all other 24 bits represent
         * red, green and blue channels respectively.
         *
         * The format written as a string would look like this:
         *
         * //AAAAAAAA RRRRRRRR GGGGGGGG BBBBBBBB//
         *
         * where //A// is one bit of alpha chnnel, //R// of red channel, //G// of green channel and //B// of blue channel.
         *
         * @return a 32 bit integer representing this
         */
gint
granite_drawing_color_to_int (GraniteDrawingColor* self)
{
	guint8 red = 0U;
	guint8 green = 0U;
	guint8 blue = 0U;
	guint8 alpha = 0U;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	red = (guint8) (self->R * G_MAXUINT8);
	green = (guint8) (self->G * G_MAXUINT8);
	blue = (guint8) (self->B * G_MAXUINT8);
	alpha = (guint8) (self->A * G_MAXUINT8);
	result = (((alpha << 24) | (red << 16)) | (green << 8)) | blue;
	return result;
}

static void
granite_drawing_color_set_from_rgba (GraniteDrawingColor* self,
                                     GdkRGBA* color)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = *color;
	self->R = _tmp0_.red;
	_tmp1_ = *color;
	self->G = _tmp1_.green;
	_tmp2_ = *color;
	self->B = _tmp2_.blue;
	_tmp3_ = *color;
	self->A = _tmp3_.alpha;
}

static void
granite_drawing_color_class_init (GraniteDrawingColorClass * klass,
                                  gpointer klass_data)
{
	granite_drawing_color_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = granite_drawing_color_finalize;
}

static void
granite_drawing_color_granite_services_settings_serializable_interface_init (GraniteServicesSettingsSerializableIface * iface,
                                                                             gpointer iface_data)
{
	granite_drawing_color_granite_services_settings_serializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->settings_serialize = (gchar* (*) (GraniteServicesSettingsSerializable*)) granite_drawing_color_real_settings_serialize;
	iface->settings_deserialize = (void (*) (GraniteServicesSettingsSerializable*, const gchar*)) granite_drawing_color_real_settings_deserialize;
}

static void
granite_drawing_color_instance_init (GraniteDrawingColor * self,
                                     gpointer klass)
{
}

static void
granite_drawing_color_finalize (GObject * obj)
{
	GraniteDrawingColor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_DRAWING_TYPE_COLOR, GraniteDrawingColor);
	G_OBJECT_CLASS (granite_drawing_color_parent_class)->finalize (obj);
}

/**
     * A class containing an RGBA color and methods for more powerful color manipulation.
     */
static GType
granite_drawing_color_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteDrawingColorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_drawing_color_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteDrawingColor), 0, (GInstanceInitFunc) granite_drawing_color_instance_init, NULL };
	static const GInterfaceInfo granite_services_settings_serializable_info = { (GInterfaceInitFunc) granite_drawing_color_granite_services_settings_serializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType granite_drawing_color_type_id;
	granite_drawing_color_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteDrawingColor", &g_define_type_info, 0);
	g_type_add_interface_static (granite_drawing_color_type_id, GRANITE_SERVICES_TYPE_SETTINGS_SERIALIZABLE, &granite_services_settings_serializable_info);
	return granite_drawing_color_type_id;
}

GType
granite_drawing_color_get_type (void)
{
	static volatile gsize granite_drawing_color_type_id__once = 0;
	if (g_once_init_enter (&granite_drawing_color_type_id__once)) {
		GType granite_drawing_color_type_id;
		granite_drawing_color_type_id = granite_drawing_color_get_type_once ();
		g_once_init_leave (&granite_drawing_color_type_id__once, granite_drawing_color_type_id);
	}
	return granite_drawing_color_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

