/* IconFactory.c generated by valac 0.56.17, the Vala compiler
 * generated from IconFactory.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * Copyright 2011-2013 ammonkey <am.monkeyd@gmail.com>
 * Copyright 2011-2013 Mario Guerriero <mario@elementaryos.org>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_SERVICES_ICON_FACTORY_0_PROPERTY,
	GRANITE_SERVICES_ICON_FACTORY_NUM_PROPERTIES
};
static GParamSpec* granite_services_icon_factory_properties[GRANITE_SERVICES_ICON_FACTORY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GraniteServicesIconFactoryPrivate {
	GtkIconTheme* icon_theme;
};

GraniteServicesIconFactory* granite_services_icon_factory = NULL;
static gint GraniteServicesIconFactory_private_offset;
static gpointer granite_services_icon_factory_parent_class = NULL;

static void granite_services_icon_factory_finalize (GObject * obj);
static GType granite_services_icon_factory_get_type_once (void);

static inline gpointer
granite_services_icon_factory_get_instance_private (GraniteServicesIconFactory* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteServicesIconFactory_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GraniteServicesIconFactory*
granite_services_icon_factory_construct (GType object_type)
{
	GraniteServicesIconFactory * self = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	self = (GraniteServicesIconFactory*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->icon_theme);
	self->priv->icon_theme = _tmp1_;
	return self;
}

GraniteServicesIconFactory*
granite_services_icon_factory_new (void)
{
	return granite_services_icon_factory_construct (GRANITE_SERVICES_TYPE_ICON_FACTORY);
}

GraniteServicesIconFactory*
granite_services_icon_factory_get_default (void)
{
	GraniteServicesIconFactory* _tmp0_;
	GraniteServicesIconFactory* _tmp3_;
	GraniteServicesIconFactory* _tmp4_;
	GraniteServicesIconFactory* _tmp5_;
	GraniteServicesIconFactory* result;
	_tmp0_ = granite_services_icon_factory;
	if (_tmp0_ != NULL) {
		GraniteServicesIconFactory* _tmp1_;
		GraniteServicesIconFactory* _tmp2_;
		_tmp1_ = granite_services_icon_factory;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = granite_services_icon_factory_new ();
	_g_object_unref0 (granite_services_icon_factory);
	granite_services_icon_factory = _tmp3_;
	_tmp4_ = granite_services_icon_factory;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}

/**
         * Attempts to load a symbolic icon for the given {@link GLib.Icon}
         * with graceful fallback on the non-symbolic variant if the symbolic one
         * does not exist.
         *
         * Note that the resulting pixbuf may not be exactly the requested size;
         * an icon theme may have icons that differ slightly from their nominal sizes,
         * and in addition GTK+ will avoid scaling icons that it considers sufficiently close
         * to the requested size or for which the source image would have to be scaled up too far
         * (this maintains sharpness).
         *
         * @return a {@link Gdk.Pixbuf} with the rendered icon; this may be a newly created icon
         * or a new reference to an internal icon, so you must not modify the icon.
         * Returns null if the icon was not found in the theme hierarchy.
         */
GdkPixbuf*
granite_services_icon_factory_load_symbolic_icon_from_gicon (GraniteServicesIconFactory* self,
                                                             GtkStyleContext* style,
                                                             GIcon* gicon,
                                                             gint size)
{
	GdkPixbuf* px = NULL;
	GtkIconInfo* icon_info = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconInfo* _tmp1_;
	GtkIconInfo* _tmp2_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (style != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	px = NULL;
	_tmp0_ = self->priv->icon_theme;
	_tmp1_ = gtk_icon_theme_lookup_by_gicon (_tmp0_, gicon, size, GTK_ICON_LOOKUP_GENERIC_FALLBACK);
	icon_info = _tmp1_;
	_tmp2_ = icon_info;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (icon_info);
		_g_object_unref0 (px);
		return result;
	}
	{
		GdkPixbuf* _tmp3_ = NULL;
		GtkIconInfo* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp4_ = icon_info;
		_tmp5_ = gtk_icon_info_load_symbolic_for_context (_tmp4_, style, NULL, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (px);
		px = _tmp6_;
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		FILE* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = err;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "Unable to load symbolic icon: %s", _tmp9_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (icon_info);
		_g_object_unref0 (px);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = px;
	_g_object_unref0 (icon_info);
	return result;
}

/**
         * Loads a symbolic icon for the given icon name with a better chance
         * for loading a symbolic icon in case of fallback than with {@link Gtk.IconTheme.load_icon}
         *
         * Note that the resulting pixbuf may not be exactly the requested size;
         * an icon theme may have icons that differ slightly from their nominal sizes,
         * and in addition GTK+ will avoid scaling icons that it considers sufficiently close
         * to the requested size or for which the source image would have to be scaled up too far
         * (this maintains sharpness).
         *
         * Due to the way {@link Gtk.IconLookupFlags.GENERIC_FALLBACK} works, Gtk readily
         * falls back to the non-symbolic icon if the exact match for the provided name is not found,
         * and only after that fails tries to look up alternative names of the icon itself.
         * This function uses the same mechanism, but looks up the symbolic icon for the
         * name chosen after all the fallbacks, and returns the symbolic one if it's present.
         * This gives a better chance of getting a symbolic icon in case of fallbacks than
         * when using {@link Gtk.IconTheme.load_icon}
         *
         * @return a {@link Gdk.Pixbuf} with the rendered icon; this may be a newly created icon
         * or a new reference to an internal icon, so you must not modify the icon.
         * Returns null if the icon was not found in the theme hierarchy.
         */
GdkPixbuf*
granite_services_icon_factory_load_symbolic_icon (GraniteServicesIconFactory* self,
                                                  GtkStyleContext* style,
                                                  const gchar* iconname,
                                                  gint size)
{
	GThemedIcon* themed_icon = NULL;
	GThemedIcon* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (style != NULL, NULL);
	g_return_val_if_fail (iconname != NULL, NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks (iconname);
	themed_icon = _tmp0_;
	_tmp1_ = granite_services_icon_factory_load_symbolic_icon_from_gicon (self, style, G_TYPE_CHECK_INSTANCE_CAST (themed_icon, g_icon_get_type (), GIcon), size);
	result = _tmp1_;
	_g_object_unref0 (themed_icon);
	return result;
}

static void
granite_services_icon_factory_class_init (GraniteServicesIconFactoryClass * klass,
                                          gpointer klass_data)
{
	granite_services_icon_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteServicesIconFactory_private_offset);
	G_OBJECT_CLASS (klass)->finalize = granite_services_icon_factory_finalize;
}

static void
granite_services_icon_factory_instance_init (GraniteServicesIconFactory * self,
                                             gpointer klass)
{
	self->priv = granite_services_icon_factory_get_instance_private (self);
}

static void
granite_services_icon_factory_finalize (GObject * obj)
{
	GraniteServicesIconFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_SERVICES_TYPE_ICON_FACTORY, GraniteServicesIconFactory);
	_g_object_unref0 (self->priv->icon_theme);
	G_OBJECT_CLASS (granite_services_icon_factory_parent_class)->finalize (obj);
}

/**
     * This class provides an easy way to access symbolic icons.
     */
static GType
granite_services_icon_factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteServicesIconFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_services_icon_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteServicesIconFactory), 0, (GInstanceInitFunc) granite_services_icon_factory_instance_init, NULL };
	GType granite_services_icon_factory_type_id;
	granite_services_icon_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteServicesIconFactory", &g_define_type_info, 0);
	GraniteServicesIconFactory_private_offset = g_type_add_instance_private (granite_services_icon_factory_type_id, sizeof (GraniteServicesIconFactoryPrivate));
	return granite_services_icon_factory_type_id;
}

GType
granite_services_icon_factory_get_type (void)
{
	static volatile gsize granite_services_icon_factory_type_id__once = 0;
	if (g_once_init_enter (&granite_services_icon_factory_type_id__once)) {
		GType granite_services_icon_factory_type_id;
		granite_services_icon_factory_type_id = granite_services_icon_factory_get_type_once ();
		g_once_init_leave (&granite_services_icon_factory_type_id__once, granite_services_icon_factory_type_id);
	}
	return granite_services_icon_factory_type_id__once;
}

