{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An event related to a broken windowing system grab.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.GrabBrokenEvent
    ( 

-- * Exported types
    GrabBrokenEvent(..)                     ,
    IsGrabBrokenEvent                       ,
    toGrabBrokenEvent                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gdk.Objects.Event#g:method:ref"), [triggersContextMenu]("GI.Gdk.Objects.Event#g:method:triggersContextMenu"), [unref]("GI.Gdk.Objects.Event#g:method:unref").
-- 
-- ==== Getters
-- [getAxes]("GI.Gdk.Objects.Event#g:method:getAxes"), [getAxis]("GI.Gdk.Objects.Event#g:method:getAxis"), [getDevice]("GI.Gdk.Objects.Event#g:method:getDevice"), [getDeviceTool]("GI.Gdk.Objects.Event#g:method:getDeviceTool"), [getDisplay]("GI.Gdk.Objects.Event#g:method:getDisplay"), [getEventSequence]("GI.Gdk.Objects.Event#g:method:getEventSequence"), [getEventType]("GI.Gdk.Objects.Event#g:method:getEventType"), [getGrabSurface]("GI.Gdk.Objects.GrabBrokenEvent#g:method:getGrabSurface"), [getHistory]("GI.Gdk.Objects.Event#g:method:getHistory"), [getImplicit]("GI.Gdk.Objects.GrabBrokenEvent#g:method:getImplicit"), [getModifierState]("GI.Gdk.Objects.Event#g:method:getModifierState"), [getPointerEmulated]("GI.Gdk.Objects.Event#g:method:getPointerEmulated"), [getPosition]("GI.Gdk.Objects.Event#g:method:getPosition"), [getSeat]("GI.Gdk.Objects.Event#g:method:getSeat"), [getSurface]("GI.Gdk.Objects.Event#g:method:getSurface"), [getTime]("GI.Gdk.Objects.Event#g:method:getTime").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveGrabBrokenEventMethod            ,
#endif

-- ** getGrabSurface #method:getGrabSurface#

#if defined(ENABLE_OVERLOADING)
    GrabBrokenEventGetGrabSurfaceMethodInfo ,
#endif
    grabBrokenEventGetGrabSurface           ,


-- ** getImplicit #method:getImplicit#

#if defined(ENABLE_OVERLOADING)
    GrabBrokenEventGetImplicitMethodInfo    ,
#endif
    grabBrokenEventGetImplicit              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface

#endif

-- | Memory-managed wrapper type.
newtype GrabBrokenEvent = GrabBrokenEvent (SP.ManagedPtr GrabBrokenEvent)
    deriving (Eq)

instance SP.ManagedPtrNewtype GrabBrokenEvent where
    toManagedPtr (GrabBrokenEvent p) = p

foreign import ccall "gdk_grab_broken_event_get_type"
    c_gdk_grab_broken_event_get_type :: IO B.Types.GType

instance B.Types.TypedObject GrabBrokenEvent where
    glibType = c_gdk_grab_broken_event_get_type

-- | Type class for types which can be safely cast to t'GrabBrokenEvent', for instance with `toGrabBrokenEvent`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf GrabBrokenEvent o) => IsGrabBrokenEvent o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf GrabBrokenEvent o) => IsGrabBrokenEvent o

instance O.HasParentTypes GrabBrokenEvent
type instance O.ParentTypes GrabBrokenEvent = '[Gdk.Event.Event]

-- | Cast to t'GrabBrokenEvent', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toGrabBrokenEvent :: (MIO.MonadIO m, IsGrabBrokenEvent o) => o -> m GrabBrokenEvent
toGrabBrokenEvent = MIO.liftIO . B.ManagedPtr.unsafeCastTo GrabBrokenEvent

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveGrabBrokenEventMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGrabBrokenEventMethod "ref" o = Gdk.Event.EventRefMethodInfo
    ResolveGrabBrokenEventMethod "triggersContextMenu" o = Gdk.Event.EventTriggersContextMenuMethodInfo
    ResolveGrabBrokenEventMethod "unref" o = Gdk.Event.EventUnrefMethodInfo
    ResolveGrabBrokenEventMethod "getAxes" o = Gdk.Event.EventGetAxesMethodInfo
    ResolveGrabBrokenEventMethod "getAxis" o = Gdk.Event.EventGetAxisMethodInfo
    ResolveGrabBrokenEventMethod "getDevice" o = Gdk.Event.EventGetDeviceMethodInfo
    ResolveGrabBrokenEventMethod "getDeviceTool" o = Gdk.Event.EventGetDeviceToolMethodInfo
    ResolveGrabBrokenEventMethod "getDisplay" o = Gdk.Event.EventGetDisplayMethodInfo
    ResolveGrabBrokenEventMethod "getEventSequence" o = Gdk.Event.EventGetEventSequenceMethodInfo
    ResolveGrabBrokenEventMethod "getEventType" o = Gdk.Event.EventGetEventTypeMethodInfo
    ResolveGrabBrokenEventMethod "getGrabSurface" o = GrabBrokenEventGetGrabSurfaceMethodInfo
    ResolveGrabBrokenEventMethod "getHistory" o = Gdk.Event.EventGetHistoryMethodInfo
    ResolveGrabBrokenEventMethod "getImplicit" o = GrabBrokenEventGetImplicitMethodInfo
    ResolveGrabBrokenEventMethod "getModifierState" o = Gdk.Event.EventGetModifierStateMethodInfo
    ResolveGrabBrokenEventMethod "getPointerEmulated" o = Gdk.Event.EventGetPointerEmulatedMethodInfo
    ResolveGrabBrokenEventMethod "getPosition" o = Gdk.Event.EventGetPositionMethodInfo
    ResolveGrabBrokenEventMethod "getSeat" o = Gdk.Event.EventGetSeatMethodInfo
    ResolveGrabBrokenEventMethod "getSurface" o = Gdk.Event.EventGetSurfaceMethodInfo
    ResolveGrabBrokenEventMethod "getTime" o = Gdk.Event.EventGetTimeMethodInfo
    ResolveGrabBrokenEventMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGrabBrokenEventMethod t GrabBrokenEvent, O.OverloadedMethod info GrabBrokenEvent p) => OL.IsLabel t (GrabBrokenEvent -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGrabBrokenEventMethod t GrabBrokenEvent, O.OverloadedMethod info GrabBrokenEvent p, R.HasField t GrabBrokenEvent p) => R.HasField t GrabBrokenEvent p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGrabBrokenEventMethod t GrabBrokenEvent, O.OverloadedMethodInfo info GrabBrokenEvent) => OL.IsLabel t (O.MethodProxy info GrabBrokenEvent) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr GrabBrokenEvent where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method GrabBrokenEvent::get_grab_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GrabBrokenEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a grab broken event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_grab_broken_event_get_grab_surface" gdk_grab_broken_event_get_grab_surface :: 
    Ptr GrabBrokenEvent ->                  -- event : TInterface (Name {namespace = "Gdk", name = "GrabBrokenEvent"})
    IO (Ptr Gdk.Surface.Surface)

-- | Extracts the grab surface from a grab broken event.
grabBrokenEventGetGrabSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrabBrokenEvent a) =>
    a
    -- ^ /@event@/: a grab broken event
    -> m Gdk.Surface.Surface
    -- ^ __Returns:__ the grab surface of /@event@/
grabBrokenEventGetGrabSurface event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_grab_broken_event_get_grab_surface event'
    checkUnexpectedReturnNULL "grabBrokenEventGetGrabSurface" result
    result' <- (newObject Gdk.Surface.Surface) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data GrabBrokenEventGetGrabSurfaceMethodInfo
instance (signature ~ (m Gdk.Surface.Surface), MonadIO m, IsGrabBrokenEvent a) => O.OverloadedMethod GrabBrokenEventGetGrabSurfaceMethodInfo a signature where
    overloadedMethod = grabBrokenEventGetGrabSurface

instance O.OverloadedMethodInfo GrabBrokenEventGetGrabSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GrabBrokenEvent.grabBrokenEventGetGrabSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GrabBrokenEvent.html#v:grabBrokenEventGetGrabSurface"
        })


#endif

-- method GrabBrokenEvent::get_implicit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GrabBrokenEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a grab broken event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_grab_broken_event_get_implicit" gdk_grab_broken_event_get_implicit :: 
    Ptr GrabBrokenEvent ->                  -- event : TInterface (Name {namespace = "Gdk", name = "GrabBrokenEvent"})
    IO CInt

-- | Checks whether the grab broken event is for an implicit grab.
grabBrokenEventGetImplicit ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrabBrokenEvent a) =>
    a
    -- ^ /@event@/: a grab broken event
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the an implicit grab was broken
grabBrokenEventGetImplicit event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_grab_broken_event_get_implicit event'
    let result' = (/= 0) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data GrabBrokenEventGetImplicitMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGrabBrokenEvent a) => O.OverloadedMethod GrabBrokenEventGetImplicitMethodInfo a signature where
    overloadedMethod = grabBrokenEventGetImplicit

instance O.OverloadedMethodInfo GrabBrokenEventGetImplicitMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GrabBrokenEvent.grabBrokenEventGetImplicit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GrabBrokenEvent.html#v:grabBrokenEventGetImplicit"
        })


#endif


