{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11Drag
    ( 

-- * Exported types
    X11Drag(..)                             ,
    IsX11Drag                               ,
    toX11Drag                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [dropDone]("GI.Gdk.Objects.Drag#g:method:dropDone"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActions]("GI.Gdk.Objects.Drag#g:method:getActions"), [getContent]("GI.Gdk.Objects.Drag#g:method:getContent"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDevice]("GI.Gdk.Objects.Drag#g:method:getDevice"), [getDisplay]("GI.Gdk.Objects.Drag#g:method:getDisplay"), [getDragSurface]("GI.Gdk.Objects.Drag#g:method:getDragSurface"), [getFormats]("GI.Gdk.Objects.Drag#g:method:getFormats"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSelectedAction]("GI.Gdk.Objects.Drag#g:method:getSelectedAction"), [getSurface]("GI.Gdk.Objects.Drag#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setHotspot]("GI.Gdk.Objects.Drag#g:method:setHotspot"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveX11DragMethod                    ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Drag as Gdk.Drag

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Drag as Gdk.Drag

#endif

-- | Memory-managed wrapper type.
newtype X11Drag = X11Drag (SP.ManagedPtr X11Drag)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11Drag where
    toManagedPtr (X11Drag p) = p

foreign import ccall "gdk_x11_drag_get_type"
    c_gdk_x11_drag_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11Drag where
    glibType = c_gdk_x11_drag_get_type

instance B.Types.GObject X11Drag

-- | Type class for types which can be safely cast to t'X11Drag', for instance with `toX11Drag`.
class (SP.GObject o, O.IsDescendantOf X11Drag o) => IsX11Drag o
instance (SP.GObject o, O.IsDescendantOf X11Drag o) => IsX11Drag o

instance O.HasParentTypes X11Drag
type instance O.ParentTypes X11Drag = '[Gdk.Drag.Drag, GObject.Object.Object]

-- | Cast to t'X11Drag', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toX11Drag :: (MIO.MonadIO m, IsX11Drag o) => o -> m X11Drag
toX11Drag = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11Drag

-- | Convert t'X11Drag' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11Drag) where
    gvalueGType_ = c_gdk_x11_drag_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11Drag)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11Drag)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11Drag ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11DragMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11DragMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11DragMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11DragMethod "dropDone" o = Gdk.Drag.DragDropDoneMethodInfo
    ResolveX11DragMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11DragMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11DragMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11DragMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11DragMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11DragMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11DragMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11DragMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11DragMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11DragMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11DragMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11DragMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11DragMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11DragMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11DragMethod "getActions" o = Gdk.Drag.DragGetActionsMethodInfo
    ResolveX11DragMethod "getContent" o = Gdk.Drag.DragGetContentMethodInfo
    ResolveX11DragMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11DragMethod "getDevice" o = Gdk.Drag.DragGetDeviceMethodInfo
    ResolveX11DragMethod "getDisplay" o = Gdk.Drag.DragGetDisplayMethodInfo
    ResolveX11DragMethod "getDragSurface" o = Gdk.Drag.DragGetDragSurfaceMethodInfo
    ResolveX11DragMethod "getFormats" o = Gdk.Drag.DragGetFormatsMethodInfo
    ResolveX11DragMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11DragMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11DragMethod "getSelectedAction" o = Gdk.Drag.DragGetSelectedActionMethodInfo
    ResolveX11DragMethod "getSurface" o = Gdk.Drag.DragGetSurfaceMethodInfo
    ResolveX11DragMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11DragMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11DragMethod "setHotspot" o = Gdk.Drag.DragSetHotspotMethodInfo
    ResolveX11DragMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11DragMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11DragMethod t X11Drag, O.OverloadedMethod info X11Drag p) => OL.IsLabel t (X11Drag -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11DragMethod t X11Drag, O.OverloadedMethod info X11Drag p, R.HasField t X11Drag p) => R.HasField t X11Drag p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11DragMethod t X11Drag, O.OverloadedMethodInfo info X11Drag) => OL.IsLabel t (O.MethodProxy info X11Drag) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11Drag
type instance O.AttributeList X11Drag = X11DragAttributeList
type X11DragAttributeList = ('[ '("actions", Gdk.Drag.DragActionsPropertyInfo), '("content", Gdk.Drag.DragContentPropertyInfo), '("device", Gdk.Drag.DragDevicePropertyInfo), '("display", Gdk.Drag.DragDisplayPropertyInfo), '("formats", Gdk.Drag.DragFormatsPropertyInfo), '("selectedAction", Gdk.Drag.DragSelectedActionPropertyInfo), '("surface", Gdk.Drag.DragSurfacePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11Drag = X11DragSignalList
type X11DragSignalList = ('[ '("cancel", Gdk.Drag.DragCancelSignalInfo), '("dndFinished", Gdk.Drag.DragDndFinishedSignalInfo), '("dropPerformed", Gdk.Drag.DragDropPerformedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


