{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node for a radial gradient.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.RadialGradientNode
    ( 

-- * Exported types
    RadialGradientNode(..)                  ,
    IsRadialGradientNode                    ,
    toRadialGradientNode                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getCenter]("GI.Gsk.Objects.RadialGradientNode#g:method:getCenter"), [getColorStops]("GI.Gsk.Objects.RadialGradientNode#g:method:getColorStops"), [getEnd]("GI.Gsk.Objects.RadialGradientNode#g:method:getEnd"), [getHradius]("GI.Gsk.Objects.RadialGradientNode#g:method:getHradius"), [getNColorStops]("GI.Gsk.Objects.RadialGradientNode#g:method:getNColorStops"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect"), [getStart]("GI.Gsk.Objects.RadialGradientNode#g:method:getStart"), [getVradius]("GI.Gsk.Objects.RadialGradientNode#g:method:getVradius").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveRadialGradientNodeMethod         ,
#endif

-- ** getCenter #method:getCenter#

#if defined(ENABLE_OVERLOADING)
    RadialGradientNodeGetCenterMethodInfo   ,
#endif
    radialGradientNodeGetCenter             ,


-- ** getColorStops #method:getColorStops#

#if defined(ENABLE_OVERLOADING)
    RadialGradientNodeGetColorStopsMethodInfo,
#endif
    radialGradientNodeGetColorStops         ,


-- ** getEnd #method:getEnd#

#if defined(ENABLE_OVERLOADING)
    RadialGradientNodeGetEndMethodInfo      ,
#endif
    radialGradientNodeGetEnd                ,


-- ** getHradius #method:getHradius#

#if defined(ENABLE_OVERLOADING)
    RadialGradientNodeGetHradiusMethodInfo  ,
#endif
    radialGradientNodeGetHradius            ,


-- ** getNColorStops #method:getNColorStops#

#if defined(ENABLE_OVERLOADING)
    RadialGradientNodeGetNColorStopsMethodInfo,
#endif
    radialGradientNodeGetNColorStops        ,


-- ** getStart #method:getStart#

#if defined(ENABLE_OVERLOADING)
    RadialGradientNodeGetStartMethodInfo    ,
#endif
    radialGradientNodeGetStart              ,


-- ** getVradius #method:getVradius#

#if defined(ENABLE_OVERLOADING)
    RadialGradientNodeGetVradiusMethodInfo  ,
#endif
    radialGradientNodeGetVradius            ,


-- ** new #method:new#

    radialGradientNodeNew                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop

#else
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop

#endif

-- | Memory-managed wrapper type.
newtype RadialGradientNode = RadialGradientNode (SP.ManagedPtr RadialGradientNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype RadialGradientNode where
    toManagedPtr (RadialGradientNode p) = p

foreign import ccall "gsk_radial_gradient_node_get_type"
    c_gsk_radial_gradient_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject RadialGradientNode where
    glibType = c_gsk_radial_gradient_node_get_type

-- | Type class for types which can be safely cast to t'RadialGradientNode', for instance with `toRadialGradientNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf RadialGradientNode o) => IsRadialGradientNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf RadialGradientNode o) => IsRadialGradientNode o

instance O.HasParentTypes RadialGradientNode
type instance O.ParentTypes RadialGradientNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'RadialGradientNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toRadialGradientNode :: (MIO.MonadIO m, IsRadialGradientNode o) => o -> m RadialGradientNode
toRadialGradientNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo RadialGradientNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveRadialGradientNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRadialGradientNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveRadialGradientNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveRadialGradientNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveRadialGradientNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveRadialGradientNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveRadialGradientNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveRadialGradientNodeMethod "getCenter" o = RadialGradientNodeGetCenterMethodInfo
    ResolveRadialGradientNodeMethod "getColorStops" o = RadialGradientNodeGetColorStopsMethodInfo
    ResolveRadialGradientNodeMethod "getEnd" o = RadialGradientNodeGetEndMethodInfo
    ResolveRadialGradientNodeMethod "getHradius" o = RadialGradientNodeGetHradiusMethodInfo
    ResolveRadialGradientNodeMethod "getNColorStops" o = RadialGradientNodeGetNColorStopsMethodInfo
    ResolveRadialGradientNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveRadialGradientNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveRadialGradientNodeMethod "getStart" o = RadialGradientNodeGetStartMethodInfo
    ResolveRadialGradientNodeMethod "getVradius" o = RadialGradientNodeGetVradiusMethodInfo
    ResolveRadialGradientNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRadialGradientNodeMethod t RadialGradientNode, O.OverloadedMethod info RadialGradientNode p) => OL.IsLabel t (RadialGradientNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRadialGradientNodeMethod t RadialGradientNode, O.OverloadedMethod info RadialGradientNode p, R.HasField t RadialGradientNode p) => R.HasField t RadialGradientNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRadialGradientNodeMethod t RadialGradientNode, O.OverloadedMethodInfo info RadialGradientNode) => OL.IsLabel t (O.MethodProxy info RadialGradientNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr RadialGradientNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method RadialGradientNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "bounds"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the bounds of the node"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "center"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the center of the gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hradius"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the horizontal radius"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vradius"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the vertical radius"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a percentage >= 0 that defines the start of the gradient around @center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a percentage >= 0 that defines the end of the gradient around @center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_stops"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 7
--                 (TInterface Name { namespace = "Gsk" , name = "ColorStop" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pointer to an array of\n  `GskColorStop` defining the gradient. The offsets of all color stops\n  must be increasing. The first stop's offset must be >= 0 and the last\n  stop's offset must be <= 1."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_color_stops"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of elements in @color_stops"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_color_stops"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of elements in @color_stops"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gsk" , name = "RadialGradientNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_radial_gradient_node_new" gsk_radial_gradient_node_new :: 
    Ptr Graphene.Rect.Rect ->               -- bounds : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Graphene.Point.Point ->             -- center : TInterface (Name {namespace = "Graphene", name = "Point"})
    CFloat ->                               -- hradius : TBasicType TFloat
    CFloat ->                               -- vradius : TBasicType TFloat
    CFloat ->                               -- start : TBasicType TFloat
    CFloat ->                               -- end : TBasicType TFloat
    Ptr Gsk.ColorStop.ColorStop ->          -- color_stops : TCArray False (-1) 7 (TInterface (Name {namespace = "Gsk", name = "ColorStop"}))
    FCT.CSize ->                            -- n_color_stops : TBasicType TSize
    IO (Ptr RadialGradientNode)

-- | Creates a @GskRenderNode@ that draws a radial gradient.
-- 
-- The radial gradient
-- starts around /@center@/. The size of the gradient is dictated by /@hradius@/
-- in horizontal orientation and by /@vradius@/ in vertical orientation.
radialGradientNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Graphene.Rect.Rect
    -- ^ /@bounds@/: the bounds of the node
    -> Graphene.Point.Point
    -- ^ /@center@/: the center of the gradient
    -> Float
    -- ^ /@hradius@/: the horizontal radius
    -> Float
    -- ^ /@vradius@/: the vertical radius
    -> Float
    -- ^ /@start@/: a percentage >= 0 that defines the start of the gradient around /@center@/
    -> Float
    -- ^ /@end@/: a percentage >= 0 that defines the end of the gradient around /@center@/
    -> [Gsk.ColorStop.ColorStop]
    -- ^ /@colorStops@/: a pointer to an array of
    --   @GskColorStop@ defining the gradient. The offsets of all color stops
    --   must be increasing. The first stop\'s offset must be >= 0 and the last
    --   stop\'s offset must be \<= 1.
    -> m RadialGradientNode
    -- ^ __Returns:__ A new @GskRenderNode@
radialGradientNodeNew bounds center hradius vradius start end colorStops = liftIO $ do
    let nColorStops = fromIntegral $ P.length colorStops
    bounds' <- unsafeManagedPtrGetPtr bounds
    center' <- unsafeManagedPtrGetPtr center
    let hradius' = realToFrac hradius
    let vradius' = realToFrac vradius
    let start' = realToFrac start
    let end' = realToFrac end
    colorStops' <- mapM unsafeManagedPtrGetPtr colorStops
    colorStops'' <- packBlockArray 20 colorStops'
    result <- gsk_radial_gradient_node_new bounds' center' hradius' vradius' start' end' colorStops'' nColorStops
    checkUnexpectedReturnNULL "radialGradientNodeNew" result
    result' <- (wrapPtr RadialGradientNode) result
    touchManagedPtr bounds
    touchManagedPtr center
    mapM_ touchManagedPtr colorStops
    freeMem colorStops''
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method RadialGradientNode::get_center
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RadialGradientNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a radial gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Point" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_radial_gradient_node_get_center" gsk_radial_gradient_node_get_center :: 
    Ptr RadialGradientNode ->               -- node : TInterface (Name {namespace = "Gsk", name = "RadialGradientNode"})
    IO (Ptr Graphene.Point.Point)

-- | Retrieves the center pointer for the gradient.
radialGradientNodeGetCenter ::
    (B.CallStack.HasCallStack, MonadIO m, IsRadialGradientNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a radial gradient
    -> m Graphene.Point.Point
    -- ^ __Returns:__ the center point for the gradient
radialGradientNodeGetCenter node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_radial_gradient_node_get_center node'
    checkUnexpectedReturnNULL "radialGradientNodeGetCenter" result
    result' <- (newBoxed Graphene.Point.Point) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data RadialGradientNodeGetCenterMethodInfo
instance (signature ~ (m Graphene.Point.Point), MonadIO m, IsRadialGradientNode a) => O.OverloadedMethod RadialGradientNodeGetCenterMethodInfo a signature where
    overloadedMethod = radialGradientNodeGetCenter

instance O.OverloadedMethodInfo RadialGradientNodeGetCenterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.RadialGradientNode.radialGradientNodeGetCenter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-RadialGradientNode.html#v:radialGradientNodeGetCenter"
        })


#endif

-- method RadialGradientNode::get_color_stops
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RadialGradientNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a radial gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_stops"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of color stops in the returned array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_stops"
--              , argType = TBasicType TSize
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "the number of color stops in the returned array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just
--               (TCArray
--                  False
--                  (-1)
--                  1
--                  (TInterface Name { namespace = "Gsk" , name = "ColorStop" }))
-- throws : False
-- Skip return : False

foreign import ccall "gsk_radial_gradient_node_get_color_stops" gsk_radial_gradient_node_get_color_stops :: 
    Ptr RadialGradientNode ->               -- node : TInterface (Name {namespace = "Gsk", name = "RadialGradientNode"})
    Ptr FCT.CSize ->                        -- n_stops : TBasicType TSize
    IO (Ptr Gsk.ColorStop.ColorStop)

-- | Retrieves the color stops in the gradient.
radialGradientNodeGetColorStops ::
    (B.CallStack.HasCallStack, MonadIO m, IsRadialGradientNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a radial gradient
    -> m [Gsk.ColorStop.ColorStop]
    -- ^ __Returns:__ the color stops in the gradient
radialGradientNodeGetColorStops node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    nStops <- allocMem :: IO (Ptr FCT.CSize)
    result <- gsk_radial_gradient_node_get_color_stops node' nStops
    nStops' <- peek nStops
    checkUnexpectedReturnNULL "radialGradientNodeGetColorStops" result
    result' <- (unpackBlockArrayWithLength 20 nStops') result
    result'' <- mapM (newPtr Gsk.ColorStop.ColorStop) result'
    touchManagedPtr node
    freeMem nStops
    return result''

#if defined(ENABLE_OVERLOADING)
data RadialGradientNodeGetColorStopsMethodInfo
instance (signature ~ (m [Gsk.ColorStop.ColorStop]), MonadIO m, IsRadialGradientNode a) => O.OverloadedMethod RadialGradientNodeGetColorStopsMethodInfo a signature where
    overloadedMethod = radialGradientNodeGetColorStops

instance O.OverloadedMethodInfo RadialGradientNodeGetColorStopsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.RadialGradientNode.radialGradientNodeGetColorStops",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-RadialGradientNode.html#v:radialGradientNodeGetColorStops"
        })


#endif

-- method RadialGradientNode::get_end
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RadialGradientNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a radial gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_radial_gradient_node_get_end" gsk_radial_gradient_node_get_end :: 
    Ptr RadialGradientNode ->               -- node : TInterface (Name {namespace = "Gsk", name = "RadialGradientNode"})
    IO CFloat

-- | Retrieves the end value for the gradient.
radialGradientNodeGetEnd ::
    (B.CallStack.HasCallStack, MonadIO m, IsRadialGradientNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a radial gradient
    -> m Float
    -- ^ __Returns:__ the end value for the gradient
radialGradientNodeGetEnd node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_radial_gradient_node_get_end node'
    let result' = realToFrac result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data RadialGradientNodeGetEndMethodInfo
instance (signature ~ (m Float), MonadIO m, IsRadialGradientNode a) => O.OverloadedMethod RadialGradientNodeGetEndMethodInfo a signature where
    overloadedMethod = radialGradientNodeGetEnd

instance O.OverloadedMethodInfo RadialGradientNodeGetEndMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.RadialGradientNode.radialGradientNodeGetEnd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-RadialGradientNode.html#v:radialGradientNodeGetEnd"
        })


#endif

-- method RadialGradientNode::get_hradius
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RadialGradientNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a radial gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_radial_gradient_node_get_hradius" gsk_radial_gradient_node_get_hradius :: 
    Ptr RadialGradientNode ->               -- node : TInterface (Name {namespace = "Gsk", name = "RadialGradientNode"})
    IO CFloat

-- | Retrieves the horizontal radius for the gradient.
radialGradientNodeGetHradius ::
    (B.CallStack.HasCallStack, MonadIO m, IsRadialGradientNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a radial gradient
    -> m Float
    -- ^ __Returns:__ the horizontal radius for the gradient
radialGradientNodeGetHradius node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_radial_gradient_node_get_hradius node'
    let result' = realToFrac result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data RadialGradientNodeGetHradiusMethodInfo
instance (signature ~ (m Float), MonadIO m, IsRadialGradientNode a) => O.OverloadedMethod RadialGradientNodeGetHradiusMethodInfo a signature where
    overloadedMethod = radialGradientNodeGetHradius

instance O.OverloadedMethodInfo RadialGradientNodeGetHradiusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.RadialGradientNode.radialGradientNodeGetHradius",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-RadialGradientNode.html#v:radialGradientNodeGetHradius"
        })


#endif

-- method RadialGradientNode::get_n_color_stops
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RadialGradientNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a radial gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_radial_gradient_node_get_n_color_stops" gsk_radial_gradient_node_get_n_color_stops :: 
    Ptr RadialGradientNode ->               -- node : TInterface (Name {namespace = "Gsk", name = "RadialGradientNode"})
    IO FCT.CSize

-- | Retrieves the number of color stops in the gradient.
radialGradientNodeGetNColorStops ::
    (B.CallStack.HasCallStack, MonadIO m, IsRadialGradientNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a radial gradient
    -> m FCT.CSize
    -- ^ __Returns:__ the number of color stops
radialGradientNodeGetNColorStops node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_radial_gradient_node_get_n_color_stops node'
    touchManagedPtr node
    return result

#if defined(ENABLE_OVERLOADING)
data RadialGradientNodeGetNColorStopsMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m, IsRadialGradientNode a) => O.OverloadedMethod RadialGradientNodeGetNColorStopsMethodInfo a signature where
    overloadedMethod = radialGradientNodeGetNColorStops

instance O.OverloadedMethodInfo RadialGradientNodeGetNColorStopsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.RadialGradientNode.radialGradientNodeGetNColorStops",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-RadialGradientNode.html#v:radialGradientNodeGetNColorStops"
        })


#endif

-- method RadialGradientNode::get_start
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RadialGradientNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a radial gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_radial_gradient_node_get_start" gsk_radial_gradient_node_get_start :: 
    Ptr RadialGradientNode ->               -- node : TInterface (Name {namespace = "Gsk", name = "RadialGradientNode"})
    IO CFloat

-- | Retrieves the start value for the gradient.
radialGradientNodeGetStart ::
    (B.CallStack.HasCallStack, MonadIO m, IsRadialGradientNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a radial gradient
    -> m Float
    -- ^ __Returns:__ the start value for the gradient
radialGradientNodeGetStart node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_radial_gradient_node_get_start node'
    let result' = realToFrac result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data RadialGradientNodeGetStartMethodInfo
instance (signature ~ (m Float), MonadIO m, IsRadialGradientNode a) => O.OverloadedMethod RadialGradientNodeGetStartMethodInfo a signature where
    overloadedMethod = radialGradientNodeGetStart

instance O.OverloadedMethodInfo RadialGradientNodeGetStartMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.RadialGradientNode.radialGradientNodeGetStart",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-RadialGradientNode.html#v:radialGradientNodeGetStart"
        })


#endif

-- method RadialGradientNode::get_vradius
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RadialGradientNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a radial gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_radial_gradient_node_get_vradius" gsk_radial_gradient_node_get_vradius :: 
    Ptr RadialGradientNode ->               -- node : TInterface (Name {namespace = "Gsk", name = "RadialGradientNode"})
    IO CFloat

-- | Retrieves the vertical radius for the gradient.
radialGradientNodeGetVradius ::
    (B.CallStack.HasCallStack, MonadIO m, IsRadialGradientNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a radial gradient
    -> m Float
    -- ^ __Returns:__ the vertical radius for the gradient
radialGradientNodeGetVradius node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_radial_gradient_node_get_vradius node'
    let result' = realToFrac result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data RadialGradientNodeGetVradiusMethodInfo
instance (signature ~ (m Float), MonadIO m, IsRadialGradientNode a) => O.OverloadedMethod RadialGradientNodeGetVradiusMethodInfo a signature where
    overloadedMethod = radialGradientNodeGetVradius

instance O.OverloadedMethodInfo RadialGradientNodeGetVradiusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.RadialGradientNode.radialGradientNodeGetVradius",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-RadialGradientNode.html#v:radialGradientNodeGetVradius"
        })


#endif


