{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An interface for accessible objects containing a numeric value.
-- 
-- @GtkAccessibleRange@ describes ranged controls for Assistive Technologies.
-- 
-- Ranged controls have a single value within an allowed range that can
-- optionally be changed by the user.
-- 
-- This interface is expected to be implemented by controls using the
-- following roles:
-- 
-- * @GTK_ACCESSIBLE_ROLE_METER@
-- * @GTK_ACCESSIBLE_ROLE_PROGRESS_BAR@
-- * @GTK_ACCESSIBLE_ROLE_SCROLLBAR@
-- * @GTK_ACCESSIBLE_ROLE_SLIDER@
-- * @GTK_ACCESSIBLE_ROLE_SPIN_BUTTON@
-- 
-- 
-- If that is not the case, a warning will be issued at run time.
-- 
-- In addition to this interface, its implementers are expected to provide the
-- correct values for the following properties:
-- 
-- * @GTK_ACCESSIBLE_PROPERTY_VALUE_MAX@
-- * @GTK_ACCESSIBLE_PROPERTY_VALUE_MIN@
-- * @GTK_ACCESSIBLE_PROPERTY_VALUE_NOW@
-- * @GTK_ACCESSIBLE_PROPERTY_VALUE_TEXT@
-- 
-- 
-- /Since: 4.10/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Interfaces.AccessibleRange
    ( 

-- * Exported types
    AccessibleRange(..)                     ,
    IsAccessibleRange                       ,
    toAccessibleRange                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveAccessibleRangeMethod            ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible

#endif

-- interface AccessibleRange 
-- | Memory-managed wrapper type.
newtype AccessibleRange = AccessibleRange (SP.ManagedPtr AccessibleRange)
    deriving (Eq)

instance SP.ManagedPtrNewtype AccessibleRange where
    toManagedPtr (AccessibleRange p) = p

foreign import ccall "gtk_accessible_range_get_type"
    c_gtk_accessible_range_get_type :: IO B.Types.GType

instance B.Types.TypedObject AccessibleRange where
    glibType = c_gtk_accessible_range_get_type

instance B.Types.GObject AccessibleRange

-- | Type class for types which can be safely cast to t'AccessibleRange', for instance with `toAccessibleRange`.
class (SP.GObject o, O.IsDescendantOf AccessibleRange o) => IsAccessibleRange o
instance (SP.GObject o, O.IsDescendantOf AccessibleRange o) => IsAccessibleRange o

instance O.HasParentTypes AccessibleRange
type instance O.ParentTypes AccessibleRange = '[Gtk.Accessible.Accessible, GObject.Object.Object]

-- | Cast to t'AccessibleRange', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toAccessibleRange :: (MIO.MonadIO m, IsAccessibleRange o) => o -> m AccessibleRange
toAccessibleRange = MIO.liftIO . B.ManagedPtr.unsafeCastTo AccessibleRange

-- | Convert t'AccessibleRange' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AccessibleRange) where
    gvalueGType_ = c_gtk_accessible_range_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AccessibleRange)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AccessibleRange)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AccessibleRange ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AccessibleRange
type instance O.AttributeList AccessibleRange = AccessibleRangeAttributeList
type AccessibleRangeAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAccessibleRangeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAccessibleRangeMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveAccessibleRangeMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAccessibleRangeMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAccessibleRangeMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAccessibleRangeMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAccessibleRangeMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAccessibleRangeMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAccessibleRangeMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAccessibleRangeMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAccessibleRangeMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAccessibleRangeMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAccessibleRangeMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveAccessibleRangeMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveAccessibleRangeMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveAccessibleRangeMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAccessibleRangeMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAccessibleRangeMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAccessibleRangeMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAccessibleRangeMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAccessibleRangeMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveAccessibleRangeMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveAccessibleRangeMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveAccessibleRangeMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveAccessibleRangeMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveAccessibleRangeMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAccessibleRangeMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveAccessibleRangeMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveAccessibleRangeMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveAccessibleRangeMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveAccessibleRangeMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAccessibleRangeMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveAccessibleRangeMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveAccessibleRangeMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveAccessibleRangeMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAccessibleRangeMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAccessibleRangeMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveAccessibleRangeMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAccessibleRangeMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAccessibleRangeMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAccessibleRangeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAccessibleRangeMethod t AccessibleRange, O.OverloadedMethod info AccessibleRange p) => OL.IsLabel t (AccessibleRange -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAccessibleRangeMethod t AccessibleRange, O.OverloadedMethod info AccessibleRange p, R.HasField t AccessibleRange p) => R.HasField t AccessibleRange p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAccessibleRangeMethod t AccessibleRange, O.OverloadedMethodInfo info AccessibleRange) => OL.IsLabel t (O.MethodProxy info AccessibleRange) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AccessibleRange = AccessibleRangeSignalList
type AccessibleRangeSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


