{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @GtkFontButton@ allows to open a font chooser dialog to change
-- the font.
-- 
-- \<picture>
--   \<source srcset=\"font-button-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkFontButton\" src=\"font-button.png\">
-- \<\/picture>
-- 
-- It is suitable widget for selecting a font in a preference dialog.
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >fontbutton
-- >╰── button.font
-- >    ╰── [content]
-- 
-- 
-- @GtkFontButton@ has a single CSS node with name fontbutton which
-- contains a button node with the .font style class.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.FontButton
    ( 

-- * Exported types
    FontButton(..)                          ,
    IsFontButton                            ,
    toFontButton                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFont]("GI.Gtk.Interfaces.FontChooser#g:method:getFont"), [getFontDesc]("GI.Gtk.Interfaces.FontChooser#g:method:getFontDesc"), [getFontFace]("GI.Gtk.Interfaces.FontChooser#g:method:getFontFace"), [getFontFamily]("GI.Gtk.Interfaces.FontChooser#g:method:getFontFamily"), [getFontFeatures]("GI.Gtk.Interfaces.FontChooser#g:method:getFontFeatures"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFontSize]("GI.Gtk.Interfaces.FontChooser#g:method:getFontSize"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLanguage]("GI.Gtk.Interfaces.FontChooser#g:method:getLanguage"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLevel]("GI.Gtk.Interfaces.FontChooser#g:method:getLevel"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getModal]("GI.Gtk.Objects.FontButton#g:method:getModal"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPreviewText]("GI.Gtk.Interfaces.FontChooser#g:method:getPreviewText"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowPreviewEntry]("GI.Gtk.Interfaces.FontChooser#g:method:getShowPreviewEntry"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTitle]("GI.Gtk.Objects.FontButton#g:method:getTitle"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getUseFont]("GI.Gtk.Objects.FontButton#g:method:getUseFont"), [getUseSize]("GI.Gtk.Objects.FontButton#g:method:getUseSize"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFilterFunc]("GI.Gtk.Interfaces.FontChooser#g:method:setFilterFunc"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFont]("GI.Gtk.Interfaces.FontChooser#g:method:setFont"), [setFontDesc]("GI.Gtk.Interfaces.FontChooser#g:method:setFontDesc"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLanguage]("GI.Gtk.Interfaces.FontChooser#g:method:setLanguage"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLevel]("GI.Gtk.Interfaces.FontChooser#g:method:setLevel"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setModal]("GI.Gtk.Objects.FontButton#g:method:setModal"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPreviewText]("GI.Gtk.Interfaces.FontChooser#g:method:setPreviewText"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowPreviewEntry]("GI.Gtk.Interfaces.FontChooser#g:method:setShowPreviewEntry"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTitle]("GI.Gtk.Objects.FontButton#g:method:setTitle"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setUseFont]("GI.Gtk.Objects.FontButton#g:method:setUseFont"), [setUseSize]("GI.Gtk.Objects.FontButton#g:method:setUseSize"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveFontButtonMethod                 ,
#endif

-- ** getModal #method:getModal#

#if defined(ENABLE_OVERLOADING)
    FontButtonGetModalMethodInfo            ,
#endif
    fontButtonGetModal                      ,


-- ** getTitle #method:getTitle#

#if defined(ENABLE_OVERLOADING)
    FontButtonGetTitleMethodInfo            ,
#endif
    fontButtonGetTitle                      ,


-- ** getUseFont #method:getUseFont#

#if defined(ENABLE_OVERLOADING)
    FontButtonGetUseFontMethodInfo          ,
#endif
    fontButtonGetUseFont                    ,


-- ** getUseSize #method:getUseSize#

#if defined(ENABLE_OVERLOADING)
    FontButtonGetUseSizeMethodInfo          ,
#endif
    fontButtonGetUseSize                    ,


-- ** new #method:new#

    fontButtonNew                           ,


-- ** newWithFont #method:newWithFont#

    fontButtonNewWithFont                   ,


-- ** setModal #method:setModal#

#if defined(ENABLE_OVERLOADING)
    FontButtonSetModalMethodInfo            ,
#endif
    fontButtonSetModal                      ,


-- ** setTitle #method:setTitle#

#if defined(ENABLE_OVERLOADING)
    FontButtonSetTitleMethodInfo            ,
#endif
    fontButtonSetTitle                      ,


-- ** setUseFont #method:setUseFont#

#if defined(ENABLE_OVERLOADING)
    FontButtonSetUseFontMethodInfo          ,
#endif
    fontButtonSetUseFont                    ,


-- ** setUseSize #method:setUseSize#

#if defined(ENABLE_OVERLOADING)
    FontButtonSetUseSizeMethodInfo          ,
#endif
    fontButtonSetUseSize                    ,




 -- * Properties


-- ** modal #attr:modal#
-- | Whether the font chooser dialog should be modal.

#if defined(ENABLE_OVERLOADING)
    FontButtonModalPropertyInfo             ,
#endif
    constructFontButtonModal                ,
#if defined(ENABLE_OVERLOADING)
    fontButtonModal                         ,
#endif
    getFontButtonModal                      ,
    setFontButtonModal                      ,


-- ** title #attr:title#
-- | The title of the font chooser dialog.

#if defined(ENABLE_OVERLOADING)
    FontButtonTitlePropertyInfo             ,
#endif
    constructFontButtonTitle                ,
#if defined(ENABLE_OVERLOADING)
    fontButtonTitle                         ,
#endif
    getFontButtonTitle                      ,
    setFontButtonTitle                      ,


-- ** useFont #attr:useFont#
-- | Whether the buttons label will be drawn in the selected font.

#if defined(ENABLE_OVERLOADING)
    FontButtonUseFontPropertyInfo           ,
#endif
    constructFontButtonUseFont              ,
#if defined(ENABLE_OVERLOADING)
    fontButtonUseFont                       ,
#endif
    getFontButtonUseFont                    ,
    setFontButtonUseFont                    ,


-- ** useSize #attr:useSize#
-- | Whether the buttons label will use the selected font size.

#if defined(ENABLE_OVERLOADING)
    FontButtonUseSizePropertyInfo           ,
#endif
    constructFontButtonUseSize              ,
#if defined(ENABLE_OVERLOADING)
    fontButtonUseSize                       ,
#endif
    getFontButtonUseSize                    ,
    setFontButtonUseSize                    ,




 -- * Signals


-- ** activate #signal:activate#

    FontButtonActivateCallback              ,
#if defined(ENABLE_OVERLOADING)
    FontButtonActivateSignalInfo            ,
#endif
    afterFontButtonActivate                 ,
    onFontButtonActivate                    ,


-- ** fontSet #signal:fontSet#

    FontButtonFontSetCallback               ,
#if defined(ENABLE_OVERLOADING)
    FontButtonFontSetSignalInfo             ,
#endif
    afterFontButtonFontSet                  ,
    onFontButtonFontSet                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.FontChooser as Gtk.FontChooser
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontFace as Pango.FontFace
import qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.FontDescription as Pango.FontDescription

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.FontChooser as Gtk.FontChooser
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype FontButton = FontButton (SP.ManagedPtr FontButton)
    deriving (Eq)

instance SP.ManagedPtrNewtype FontButton where
    toManagedPtr (FontButton p) = p

foreign import ccall "gtk_font_button_get_type"
    c_gtk_font_button_get_type :: IO B.Types.GType

instance B.Types.TypedObject FontButton where
    glibType = c_gtk_font_button_get_type

instance B.Types.GObject FontButton

-- | Type class for types which can be safely cast to t'FontButton', for instance with `toFontButton`.
class (SP.GObject o, O.IsDescendantOf FontButton o) => IsFontButton o
instance (SP.GObject o, O.IsDescendantOf FontButton o) => IsFontButton o

instance O.HasParentTypes FontButton
type instance O.ParentTypes FontButton = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.FontChooser.FontChooser]

-- | Cast to t'FontButton', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFontButton :: (MIO.MonadIO m, IsFontButton o) => o -> m FontButton
toFontButton = MIO.liftIO . B.ManagedPtr.unsafeCastTo FontButton

-- | Convert t'FontButton' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FontButton) where
    gvalueGType_ = c_gtk_font_button_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FontButton)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FontButton)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FontButton ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFontButtonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFontButtonMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveFontButtonMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveFontButtonMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveFontButtonMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveFontButtonMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveFontButtonMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveFontButtonMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveFontButtonMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveFontButtonMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveFontButtonMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveFontButtonMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFontButtonMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFontButtonMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveFontButtonMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveFontButtonMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveFontButtonMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveFontButtonMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveFontButtonMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveFontButtonMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveFontButtonMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveFontButtonMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveFontButtonMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveFontButtonMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveFontButtonMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFontButtonMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFontButtonMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFontButtonMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveFontButtonMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveFontButtonMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveFontButtonMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveFontButtonMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveFontButtonMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveFontButtonMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveFontButtonMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveFontButtonMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveFontButtonMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveFontButtonMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveFontButtonMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveFontButtonMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveFontButtonMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFontButtonMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveFontButtonMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveFontButtonMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveFontButtonMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveFontButtonMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveFontButtonMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveFontButtonMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveFontButtonMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveFontButtonMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFontButtonMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFontButtonMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveFontButtonMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveFontButtonMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveFontButtonMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveFontButtonMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveFontButtonMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveFontButtonMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveFontButtonMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFontButtonMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFontButtonMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveFontButtonMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveFontButtonMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveFontButtonMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveFontButtonMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveFontButtonMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveFontButtonMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveFontButtonMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFontButtonMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveFontButtonMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveFontButtonMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveFontButtonMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveFontButtonMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFontButtonMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFontButtonMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFontButtonMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveFontButtonMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveFontButtonMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveFontButtonMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveFontButtonMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveFontButtonMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFontButtonMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveFontButtonMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveFontButtonMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveFontButtonMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveFontButtonMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveFontButtonMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveFontButtonMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFontButtonMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveFontButtonMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveFontButtonMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveFontButtonMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveFontButtonMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveFontButtonMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveFontButtonMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveFontButtonMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveFontButtonMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveFontButtonMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveFontButtonMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveFontButtonMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveFontButtonMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveFontButtonMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveFontButtonMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveFontButtonMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveFontButtonMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveFontButtonMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveFontButtonMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveFontButtonMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFontButtonMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveFontButtonMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveFontButtonMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveFontButtonMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveFontButtonMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveFontButtonMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveFontButtonMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveFontButtonMethod "getFont" o = Gtk.FontChooser.FontChooserGetFontMethodInfo
    ResolveFontButtonMethod "getFontDesc" o = Gtk.FontChooser.FontChooserGetFontDescMethodInfo
    ResolveFontButtonMethod "getFontFace" o = Gtk.FontChooser.FontChooserGetFontFaceMethodInfo
    ResolveFontButtonMethod "getFontFamily" o = Gtk.FontChooser.FontChooserGetFontFamilyMethodInfo
    ResolveFontButtonMethod "getFontFeatures" o = Gtk.FontChooser.FontChooserGetFontFeaturesMethodInfo
    ResolveFontButtonMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveFontButtonMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveFontButtonMethod "getFontSize" o = Gtk.FontChooser.FontChooserGetFontSizeMethodInfo
    ResolveFontButtonMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveFontButtonMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveFontButtonMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveFontButtonMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveFontButtonMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveFontButtonMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveFontButtonMethod "getLanguage" o = Gtk.FontChooser.FontChooserGetLanguageMethodInfo
    ResolveFontButtonMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveFontButtonMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveFontButtonMethod "getLevel" o = Gtk.FontChooser.FontChooserGetLevelMethodInfo
    ResolveFontButtonMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveFontButtonMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveFontButtonMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveFontButtonMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveFontButtonMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveFontButtonMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveFontButtonMethod "getModal" o = FontButtonGetModalMethodInfo
    ResolveFontButtonMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveFontButtonMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveFontButtonMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveFontButtonMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveFontButtonMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveFontButtonMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveFontButtonMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveFontButtonMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveFontButtonMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveFontButtonMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveFontButtonMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveFontButtonMethod "getPreviewText" o = Gtk.FontChooser.FontChooserGetPreviewTextMethodInfo
    ResolveFontButtonMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveFontButtonMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFontButtonMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFontButtonMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveFontButtonMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveFontButtonMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveFontButtonMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveFontButtonMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveFontButtonMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveFontButtonMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveFontButtonMethod "getShowPreviewEntry" o = Gtk.FontChooser.FontChooserGetShowPreviewEntryMethodInfo
    ResolveFontButtonMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveFontButtonMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveFontButtonMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveFontButtonMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveFontButtonMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveFontButtonMethod "getTitle" o = FontButtonGetTitleMethodInfo
    ResolveFontButtonMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveFontButtonMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveFontButtonMethod "getUseFont" o = FontButtonGetUseFontMethodInfo
    ResolveFontButtonMethod "getUseSize" o = FontButtonGetUseSizeMethodInfo
    ResolveFontButtonMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveFontButtonMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveFontButtonMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveFontButtonMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveFontButtonMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveFontButtonMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveFontButtonMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveFontButtonMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveFontButtonMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveFontButtonMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveFontButtonMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveFontButtonMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveFontButtonMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFontButtonMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFontButtonMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveFontButtonMethod "setFilterFunc" o = Gtk.FontChooser.FontChooserSetFilterFuncMethodInfo
    ResolveFontButtonMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveFontButtonMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveFontButtonMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveFontButtonMethod "setFont" o = Gtk.FontChooser.FontChooserSetFontMethodInfo
    ResolveFontButtonMethod "setFontDesc" o = Gtk.FontChooser.FontChooserSetFontDescMethodInfo
    ResolveFontButtonMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveFontButtonMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveFontButtonMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveFontButtonMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveFontButtonMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveFontButtonMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveFontButtonMethod "setLanguage" o = Gtk.FontChooser.FontChooserSetLanguageMethodInfo
    ResolveFontButtonMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveFontButtonMethod "setLevel" o = Gtk.FontChooser.FontChooserSetLevelMethodInfo
    ResolveFontButtonMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveFontButtonMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveFontButtonMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveFontButtonMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveFontButtonMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveFontButtonMethod "setModal" o = FontButtonSetModalMethodInfo
    ResolveFontButtonMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveFontButtonMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveFontButtonMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveFontButtonMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveFontButtonMethod "setPreviewText" o = Gtk.FontChooser.FontChooserSetPreviewTextMethodInfo
    ResolveFontButtonMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFontButtonMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveFontButtonMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveFontButtonMethod "setShowPreviewEntry" o = Gtk.FontChooser.FontChooserSetShowPreviewEntryMethodInfo
    ResolveFontButtonMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveFontButtonMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveFontButtonMethod "setTitle" o = FontButtonSetTitleMethodInfo
    ResolveFontButtonMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveFontButtonMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveFontButtonMethod "setUseFont" o = FontButtonSetUseFontMethodInfo
    ResolveFontButtonMethod "setUseSize" o = FontButtonSetUseSizeMethodInfo
    ResolveFontButtonMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveFontButtonMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveFontButtonMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveFontButtonMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveFontButtonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFontButtonMethod t FontButton, O.OverloadedMethod info FontButton p) => OL.IsLabel t (FontButton -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFontButtonMethod t FontButton, O.OverloadedMethod info FontButton p, R.HasField t FontButton p) => R.HasField t FontButton p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFontButtonMethod t FontButton, O.OverloadedMethodInfo info FontButton) => OL.IsLabel t (O.MethodProxy info FontButton) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal FontButton::activate
-- | Emitted to when the font button is activated.
-- 
-- The @::activate@ signal on @GtkFontButton@ is an action signal and
-- emitting it causes the button to present its dialog.
-- 
-- /Since: 4.4/
type FontButtonActivateCallback =
    IO ()

type C_FontButtonActivateCallback =
    Ptr FontButton ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FontButtonActivateCallback`.
foreign import ccall "wrapper"
    mk_FontButtonActivateCallback :: C_FontButtonActivateCallback -> IO (FunPtr C_FontButtonActivateCallback)

wrap_FontButtonActivateCallback :: 
    GObject a => (a -> FontButtonActivateCallback) ->
    C_FontButtonActivateCallback
wrap_FontButtonActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fontButton #activate callback
-- @
-- 
-- 
onFontButtonActivate :: (IsFontButton a, MonadIO m) => a -> ((?self :: a) => FontButtonActivateCallback) -> m SignalHandlerId
onFontButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FontButtonActivateCallback wrapped
    wrapped'' <- mk_FontButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fontButton #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFontButtonActivate :: (IsFontButton a, MonadIO m) => a -> ((?self :: a) => FontButtonActivateCallback) -> m SignalHandlerId
afterFontButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FontButtonActivateCallback wrapped
    wrapped'' <- mk_FontButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FontButtonActivateSignalInfo
instance SignalInfo FontButtonActivateSignalInfo where
    type HaskellCallbackType FontButtonActivateSignalInfo = FontButtonActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FontButtonActivateCallback cb
        cb'' <- mk_FontButtonActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#g:signal:activate"})

#endif

-- signal FontButton::font-set
-- | Emitted when the user selects a font.
-- 
-- When handling this signal, use 'GI.Gtk.Interfaces.FontChooser.fontChooserGetFont'
-- to find out which font was just selected.
-- 
-- Note that this signal is only emitted when the user changes the font.
-- If you need to react to programmatic font changes as well, use
-- the notify[font](#g:signal:font) signal.
type FontButtonFontSetCallback =
    IO ()

type C_FontButtonFontSetCallback =
    Ptr FontButton ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FontButtonFontSetCallback`.
foreign import ccall "wrapper"
    mk_FontButtonFontSetCallback :: C_FontButtonFontSetCallback -> IO (FunPtr C_FontButtonFontSetCallback)

wrap_FontButtonFontSetCallback :: 
    GObject a => (a -> FontButtonFontSetCallback) ->
    C_FontButtonFontSetCallback
wrap_FontButtonFontSetCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [fontSet](#signal:fontSet) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fontButton #fontSet callback
-- @
-- 
-- 
onFontButtonFontSet :: (IsFontButton a, MonadIO m) => a -> ((?self :: a) => FontButtonFontSetCallback) -> m SignalHandlerId
onFontButtonFontSet obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FontButtonFontSetCallback wrapped
    wrapped'' <- mk_FontButtonFontSetCallback wrapped'
    connectSignalFunPtr obj "font-set" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [fontSet](#signal:fontSet) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fontButton #fontSet callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFontButtonFontSet :: (IsFontButton a, MonadIO m) => a -> ((?self :: a) => FontButtonFontSetCallback) -> m SignalHandlerId
afterFontButtonFontSet obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FontButtonFontSetCallback wrapped
    wrapped'' <- mk_FontButtonFontSetCallback wrapped'
    connectSignalFunPtr obj "font-set" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FontButtonFontSetSignalInfo
instance SignalInfo FontButtonFontSetSignalInfo where
    type HaskellCallbackType FontButtonFontSetSignalInfo = FontButtonFontSetCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FontButtonFontSetCallback cb
        cb'' <- mk_FontButtonFontSetCallback cb'
        connectSignalFunPtr obj "font-set" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton::font-set"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#g:signal:fontSet"})

#endif

-- VVV Prop "modal"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontButton #modal
-- @
getFontButtonModal :: (MonadIO m, IsFontButton o) => o -> m Bool
getFontButtonModal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "modal"

-- | Set the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontButton [ #modal 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontButtonModal :: (MonadIO m, IsFontButton o) => o -> Bool -> m ()
setFontButtonModal obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "modal" val

-- | Construct a t'GValueConstruct' with valid value for the “@modal@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFontButtonModal :: (IsFontButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructFontButtonModal val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "modal" val

#if defined(ENABLE_OVERLOADING)
data FontButtonModalPropertyInfo
instance AttrInfo FontButtonModalPropertyInfo where
    type AttrAllowedOps FontButtonModalPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FontButtonModalPropertyInfo = IsFontButton
    type AttrSetTypeConstraint FontButtonModalPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint FontButtonModalPropertyInfo = (~) Bool
    type AttrTransferType FontButtonModalPropertyInfo = Bool
    type AttrGetType FontButtonModalPropertyInfo = Bool
    type AttrLabel FontButtonModalPropertyInfo = "modal"
    type AttrOrigin FontButtonModalPropertyInfo = FontButton
    attrGet = getFontButtonModal
    attrSet = setFontButtonModal
    attrTransfer _ v = do
        return v
    attrConstruct = constructFontButtonModal
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.modal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#g:attr:modal"
        })
#endif

-- VVV Prop "title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontButton #title
-- @
getFontButtonTitle :: (MonadIO m, IsFontButton o) => o -> m T.Text
getFontButtonTitle obj = MIO.liftIO $ checkUnexpectedNothing "getFontButtonTitle" $ B.Properties.getObjectPropertyString obj "title"

-- | Set the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontButton [ #title 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontButtonTitle :: (MonadIO m, IsFontButton o) => o -> T.Text -> m ()
setFontButtonTitle obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "title" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@title@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFontButtonTitle :: (IsFontButton o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructFontButtonTitle val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "title" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data FontButtonTitlePropertyInfo
instance AttrInfo FontButtonTitlePropertyInfo where
    type AttrAllowedOps FontButtonTitlePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FontButtonTitlePropertyInfo = IsFontButton
    type AttrSetTypeConstraint FontButtonTitlePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint FontButtonTitlePropertyInfo = (~) T.Text
    type AttrTransferType FontButtonTitlePropertyInfo = T.Text
    type AttrGetType FontButtonTitlePropertyInfo = T.Text
    type AttrLabel FontButtonTitlePropertyInfo = "title"
    type AttrOrigin FontButtonTitlePropertyInfo = FontButton
    attrGet = getFontButtonTitle
    attrSet = setFontButtonTitle
    attrTransfer _ v = do
        return v
    attrConstruct = constructFontButtonTitle
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.title"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#g:attr:title"
        })
#endif

-- VVV Prop "use-font"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-font@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontButton #useFont
-- @
getFontButtonUseFont :: (MonadIO m, IsFontButton o) => o -> m Bool
getFontButtonUseFont obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-font"

-- | Set the value of the “@use-font@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontButton [ #useFont 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontButtonUseFont :: (MonadIO m, IsFontButton o) => o -> Bool -> m ()
setFontButtonUseFont obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-font" val

-- | Construct a t'GValueConstruct' with valid value for the “@use-font@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFontButtonUseFont :: (IsFontButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructFontButtonUseFont val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-font" val

#if defined(ENABLE_OVERLOADING)
data FontButtonUseFontPropertyInfo
instance AttrInfo FontButtonUseFontPropertyInfo where
    type AttrAllowedOps FontButtonUseFontPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FontButtonUseFontPropertyInfo = IsFontButton
    type AttrSetTypeConstraint FontButtonUseFontPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint FontButtonUseFontPropertyInfo = (~) Bool
    type AttrTransferType FontButtonUseFontPropertyInfo = Bool
    type AttrGetType FontButtonUseFontPropertyInfo = Bool
    type AttrLabel FontButtonUseFontPropertyInfo = "use-font"
    type AttrOrigin FontButtonUseFontPropertyInfo = FontButton
    attrGet = getFontButtonUseFont
    attrSet = setFontButtonUseFont
    attrTransfer _ v = do
        return v
    attrConstruct = constructFontButtonUseFont
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.useFont"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#g:attr:useFont"
        })
#endif

-- VVV Prop "use-size"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontButton #useSize
-- @
getFontButtonUseSize :: (MonadIO m, IsFontButton o) => o -> m Bool
getFontButtonUseSize obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-size"

-- | Set the value of the “@use-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontButton [ #useSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontButtonUseSize :: (MonadIO m, IsFontButton o) => o -> Bool -> m ()
setFontButtonUseSize obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-size" val

-- | Construct a t'GValueConstruct' with valid value for the “@use-size@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFontButtonUseSize :: (IsFontButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructFontButtonUseSize val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-size" val

#if defined(ENABLE_OVERLOADING)
data FontButtonUseSizePropertyInfo
instance AttrInfo FontButtonUseSizePropertyInfo where
    type AttrAllowedOps FontButtonUseSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FontButtonUseSizePropertyInfo = IsFontButton
    type AttrSetTypeConstraint FontButtonUseSizePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint FontButtonUseSizePropertyInfo = (~) Bool
    type AttrTransferType FontButtonUseSizePropertyInfo = Bool
    type AttrGetType FontButtonUseSizePropertyInfo = Bool
    type AttrLabel FontButtonUseSizePropertyInfo = "use-size"
    type AttrOrigin FontButtonUseSizePropertyInfo = FontButton
    attrGet = getFontButtonUseSize
    attrSet = setFontButtonUseSize
    attrTransfer _ v = do
        return v
    attrConstruct = constructFontButtonUseSize
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.useSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#g:attr:useSize"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FontButton
type instance O.AttributeList FontButton = FontButtonAttributeList
type FontButtonAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("font", Gtk.FontChooser.FontChooserFontPropertyInfo), '("fontDesc", Gtk.FontChooser.FontChooserFontDescPropertyInfo), '("fontFeatures", Gtk.FontChooser.FontChooserFontFeaturesPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("language", Gtk.FontChooser.FontChooserLanguagePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("level", Gtk.FontChooser.FontChooserLevelPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("modal", FontButtonModalPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("previewText", Gtk.FontChooser.FontChooserPreviewTextPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showPreviewEntry", Gtk.FontChooser.FontChooserShowPreviewEntryPropertyInfo), '("title", FontButtonTitlePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("useFont", FontButtonUseFontPropertyInfo), '("useSize", FontButtonUseSizePropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
fontButtonModal :: AttrLabelProxy "modal"
fontButtonModal = AttrLabelProxy

fontButtonTitle :: AttrLabelProxy "title"
fontButtonTitle = AttrLabelProxy

fontButtonUseFont :: AttrLabelProxy "useFont"
fontButtonUseFont = AttrLabelProxy

fontButtonUseSize :: AttrLabelProxy "useSize"
fontButtonUseSize = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FontButton = FontButtonSignalList
type FontButtonSignalList = ('[ '("activate", FontButtonActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("fontActivated", Gtk.FontChooser.FontChooserFontActivatedSignalInfo), '("fontSet", FontButtonFontSetSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FontButton::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "FontButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_button_new" gtk_font_button_new :: 
    IO (Ptr FontButton)

{-# DEPRECATED fontButtonNew ["(Since version 4.10)","Use t'GI.Gtk.Objects.FontDialogButton.FontDialogButton' instead"] #-}
-- | Creates a new font picker widget.
fontButtonNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m FontButton
    -- ^ __Returns:__ a new font picker widget.
fontButtonNew  = liftIO $ do
    result <- gtk_font_button_new
    checkUnexpectedReturnNULL "fontButtonNew" result
    result' <- (newObject FontButton) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FontButton::new_with_font
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "fontname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Name of font to display in font chooser dialog"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "FontButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_button_new_with_font" gtk_font_button_new_with_font :: 
    CString ->                              -- fontname : TBasicType TUTF8
    IO (Ptr FontButton)

{-# DEPRECATED fontButtonNewWithFont ["(Since version 4.10)","Use t'GI.Gtk.Objects.FontDialogButton.FontDialogButton' instead"] #-}
-- | Creates a new font picker widget showing the given font.
fontButtonNewWithFont ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@fontname@/: Name of font to display in font chooser dialog
    -> m FontButton
    -- ^ __Returns:__ a new font picker widget.
fontButtonNewWithFont fontname = liftIO $ do
    fontname' <- textToCString fontname
    result <- gtk_font_button_new_with_font fontname'
    checkUnexpectedReturnNULL "fontButtonNewWithFont" result
    result' <- (newObject FontButton) result
    freeMem fontname'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FontButton::get_modal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "font_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_button_get_modal" gtk_font_button_get_modal :: 
    Ptr FontButton ->                       -- font_button : TInterface (Name {namespace = "Gtk", name = "FontButton"})
    IO CInt

{-# DEPRECATED fontButtonGetModal ["(Since version 4.10)","Use t'GI.Gtk.Objects.FontDialogButton.FontDialogButton' instead"] #-}
-- | Gets whether the dialog is modal.
fontButtonGetModal ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontButton a) =>
    a
    -- ^ /@fontButton@/: a @GtkFontButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the dialog is modal
fontButtonGetModal fontButton = liftIO $ do
    fontButton' <- unsafeManagedPtrCastPtr fontButton
    result <- gtk_font_button_get_modal fontButton'
    let result' = (/= 0) result
    touchManagedPtr fontButton
    return result'

#if defined(ENABLE_OVERLOADING)
data FontButtonGetModalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFontButton a) => O.OverloadedMethod FontButtonGetModalMethodInfo a signature where
    overloadedMethod = fontButtonGetModal

instance O.OverloadedMethodInfo FontButtonGetModalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.fontButtonGetModal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#v:fontButtonGetModal"
        })


#endif

-- method FontButton::get_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "font_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_button_get_title" gtk_font_button_get_title :: 
    Ptr FontButton ->                       -- font_button : TInterface (Name {namespace = "Gtk", name = "FontButton"})
    IO CString

{-# DEPRECATED fontButtonGetTitle ["(Since version 4.10)","Use t'GI.Gtk.Objects.FontDialogButton.FontDialogButton' instead"] #-}
-- | Retrieves the title of the font chooser dialog.
fontButtonGetTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontButton a) =>
    a
    -- ^ /@fontButton@/: a @GtkFontButton@
    -> m T.Text
    -- ^ __Returns:__ an internal copy of the title string
    --   which must not be freed.
fontButtonGetTitle fontButton = liftIO $ do
    fontButton' <- unsafeManagedPtrCastPtr fontButton
    result <- gtk_font_button_get_title fontButton'
    checkUnexpectedReturnNULL "fontButtonGetTitle" result
    result' <- cstringToText result
    touchManagedPtr fontButton
    return result'

#if defined(ENABLE_OVERLOADING)
data FontButtonGetTitleMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsFontButton a) => O.OverloadedMethod FontButtonGetTitleMethodInfo a signature where
    overloadedMethod = fontButtonGetTitle

instance O.OverloadedMethodInfo FontButtonGetTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.fontButtonGetTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#v:fontButtonGetTitle"
        })


#endif

-- method FontButton::get_use_font
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "font_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_button_get_use_font" gtk_font_button_get_use_font :: 
    Ptr FontButton ->                       -- font_button : TInterface (Name {namespace = "Gtk", name = "FontButton"})
    IO CInt

{-# DEPRECATED fontButtonGetUseFont ["(Since version 4.10)","Use t'GI.Gtk.Objects.FontDialogButton.FontDialogButton' instead"] #-}
-- | Returns whether the selected font is used in the label.
fontButtonGetUseFont ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontButton a) =>
    a
    -- ^ /@fontButton@/: a @GtkFontButton@
    -> m Bool
    -- ^ __Returns:__ whether the selected font is used in the label.
fontButtonGetUseFont fontButton = liftIO $ do
    fontButton' <- unsafeManagedPtrCastPtr fontButton
    result <- gtk_font_button_get_use_font fontButton'
    let result' = (/= 0) result
    touchManagedPtr fontButton
    return result'

#if defined(ENABLE_OVERLOADING)
data FontButtonGetUseFontMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFontButton a) => O.OverloadedMethod FontButtonGetUseFontMethodInfo a signature where
    overloadedMethod = fontButtonGetUseFont

instance O.OverloadedMethodInfo FontButtonGetUseFontMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.fontButtonGetUseFont",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#v:fontButtonGetUseFont"
        })


#endif

-- method FontButton::get_use_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "font_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_button_get_use_size" gtk_font_button_get_use_size :: 
    Ptr FontButton ->                       -- font_button : TInterface (Name {namespace = "Gtk", name = "FontButton"})
    IO CInt

{-# DEPRECATED fontButtonGetUseSize ["(Since version 4.10)","Use t'GI.Gtk.Objects.FontDialogButton.FontDialogButton' instead"] #-}
-- | Returns whether the selected size is used in the label.
fontButtonGetUseSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontButton a) =>
    a
    -- ^ /@fontButton@/: a @GtkFontButton@
    -> m Bool
    -- ^ __Returns:__ whether the selected size is used in the label.
fontButtonGetUseSize fontButton = liftIO $ do
    fontButton' <- unsafeManagedPtrCastPtr fontButton
    result <- gtk_font_button_get_use_size fontButton'
    let result' = (/= 0) result
    touchManagedPtr fontButton
    return result'

#if defined(ENABLE_OVERLOADING)
data FontButtonGetUseSizeMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFontButton a) => O.OverloadedMethod FontButtonGetUseSizeMethodInfo a signature where
    overloadedMethod = fontButtonGetUseSize

instance O.OverloadedMethodInfo FontButtonGetUseSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.fontButtonGetUseSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#v:fontButtonGetUseSize"
        })


#endif

-- method FontButton::set_modal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "font_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modal"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to make the dialog modal"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_button_set_modal" gtk_font_button_set_modal :: 
    Ptr FontButton ->                       -- font_button : TInterface (Name {namespace = "Gtk", name = "FontButton"})
    CInt ->                                 -- modal : TBasicType TBoolean
    IO ()

{-# DEPRECATED fontButtonSetModal ["(Since version 4.10)","Use t'GI.Gtk.Objects.FontDialogButton.FontDialogButton' instead"] #-}
-- | Sets whether the dialog should be modal.
fontButtonSetModal ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontButton a) =>
    a
    -- ^ /@fontButton@/: a @GtkFontButton@
    -> Bool
    -- ^ /@modal@/: 'P.True' to make the dialog modal
    -> m ()
fontButtonSetModal fontButton modal = liftIO $ do
    fontButton' <- unsafeManagedPtrCastPtr fontButton
    let modal' = (P.fromIntegral . P.fromEnum) modal
    gtk_font_button_set_modal fontButton' modal'
    touchManagedPtr fontButton
    return ()

#if defined(ENABLE_OVERLOADING)
data FontButtonSetModalMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFontButton a) => O.OverloadedMethod FontButtonSetModalMethodInfo a signature where
    overloadedMethod = fontButtonSetModal

instance O.OverloadedMethodInfo FontButtonSetModalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.fontButtonSetModal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#v:fontButtonSetModal"
        })


#endif

-- method FontButton::set_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "font_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "title"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a string containing the font chooser dialog title"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_button_set_title" gtk_font_button_set_title :: 
    Ptr FontButton ->                       -- font_button : TInterface (Name {namespace = "Gtk", name = "FontButton"})
    CString ->                              -- title : TBasicType TUTF8
    IO ()

{-# DEPRECATED fontButtonSetTitle ["(Since version 4.10)","Use t'GI.Gtk.Objects.FontDialogButton.FontDialogButton' instead"] #-}
-- | Sets the title for the font chooser dialog.
fontButtonSetTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontButton a) =>
    a
    -- ^ /@fontButton@/: a @GtkFontButton@
    -> T.Text
    -- ^ /@title@/: a string containing the font chooser dialog title
    -> m ()
fontButtonSetTitle fontButton title = liftIO $ do
    fontButton' <- unsafeManagedPtrCastPtr fontButton
    title' <- textToCString title
    gtk_font_button_set_title fontButton' title'
    touchManagedPtr fontButton
    freeMem title'
    return ()

#if defined(ENABLE_OVERLOADING)
data FontButtonSetTitleMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsFontButton a) => O.OverloadedMethod FontButtonSetTitleMethodInfo a signature where
    overloadedMethod = fontButtonSetTitle

instance O.OverloadedMethodInfo FontButtonSetTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.fontButtonSetTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#v:fontButtonSetTitle"
        })


#endif

-- method FontButton::set_use_font
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "font_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_font"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "If %TRUE, font name will be written using font chosen."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_button_set_use_font" gtk_font_button_set_use_font :: 
    Ptr FontButton ->                       -- font_button : TInterface (Name {namespace = "Gtk", name = "FontButton"})
    CInt ->                                 -- use_font : TBasicType TBoolean
    IO ()

{-# DEPRECATED fontButtonSetUseFont ["(Since version 4.10)","Use t'GI.Gtk.Objects.FontDialogButton.FontDialogButton' instead"] #-}
-- | If /@useFont@/ is 'P.True', the font name will be written
-- using the selected font.
fontButtonSetUseFont ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontButton a) =>
    a
    -- ^ /@fontButton@/: a @GtkFontButton@
    -> Bool
    -- ^ /@useFont@/: If 'P.True', font name will be written using font chosen.
    -> m ()
fontButtonSetUseFont fontButton useFont = liftIO $ do
    fontButton' <- unsafeManagedPtrCastPtr fontButton
    let useFont' = (P.fromIntegral . P.fromEnum) useFont
    gtk_font_button_set_use_font fontButton' useFont'
    touchManagedPtr fontButton
    return ()

#if defined(ENABLE_OVERLOADING)
data FontButtonSetUseFontMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFontButton a) => O.OverloadedMethod FontButtonSetUseFontMethodInfo a signature where
    overloadedMethod = fontButtonSetUseFont

instance O.OverloadedMethodInfo FontButtonSetUseFontMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.fontButtonSetUseFont",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#v:fontButtonSetUseFont"
        })


#endif

-- method FontButton::set_use_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "font_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_size"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "If %TRUE, font name will be written using the\n  selected size."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_button_set_use_size" gtk_font_button_set_use_size :: 
    Ptr FontButton ->                       -- font_button : TInterface (Name {namespace = "Gtk", name = "FontButton"})
    CInt ->                                 -- use_size : TBasicType TBoolean
    IO ()

{-# DEPRECATED fontButtonSetUseSize ["(Since version 4.10)","Use t'GI.Gtk.Objects.FontDialogButton.FontDialogButton' instead"] #-}
-- | If /@useSize@/ is 'P.True', the font name will be written using
-- the selected size.
fontButtonSetUseSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontButton a) =>
    a
    -- ^ /@fontButton@/: a @GtkFontButton@
    -> Bool
    -- ^ /@useSize@/: If 'P.True', font name will be written using the
    --   selected size.
    -> m ()
fontButtonSetUseSize fontButton useSize = liftIO $ do
    fontButton' <- unsafeManagedPtrCastPtr fontButton
    let useSize' = (P.fromIntegral . P.fromEnum) useSize
    gtk_font_button_set_use_size fontButton' useSize'
    touchManagedPtr fontButton
    return ()

#if defined(ENABLE_OVERLOADING)
data FontButtonSetUseSizeMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFontButton a) => O.OverloadedMethod FontButtonSetUseSizeMethodInfo a signature where
    overloadedMethod = fontButtonSetUseSize

instance O.OverloadedMethodInfo FontButtonSetUseSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontButton.fontButtonSetUseSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FontButton.html#v:fontButtonSetUseSize"
        })


#endif


