{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A selection model that allows selecting multiple elements.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MultiSelection
    ( 

-- * Exported types
    MultiSelection(..)                      ,
    IsMultiSelection                        ,
    toMultiSelection                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isSelected]("GI.Gtk.Interfaces.SelectionModel#g:method:isSelected"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [sectionsChanged]("GI.Gtk.Interfaces.SectionModel#g:method:sectionsChanged"), [selectAll]("GI.Gtk.Interfaces.SelectionModel#g:method:selectAll"), [selectItem]("GI.Gtk.Interfaces.SelectionModel#g:method:selectItem"), [selectRange]("GI.Gtk.Interfaces.SelectionModel#g:method:selectRange"), [selectionChanged]("GI.Gtk.Interfaces.SelectionModel#g:method:selectionChanged"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unselectAll]("GI.Gtk.Interfaces.SelectionModel#g:method:unselectAll"), [unselectItem]("GI.Gtk.Interfaces.SelectionModel#g:method:unselectItem"), [unselectRange]("GI.Gtk.Interfaces.SelectionModel#g:method:unselectRange"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getModel]("GI.Gtk.Objects.MultiSelection#g:method:getModel"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSection]("GI.Gtk.Interfaces.SectionModel#g:method:getSection"), [getSelection]("GI.Gtk.Interfaces.SelectionModel#g:method:getSelection"), [getSelectionInRange]("GI.Gtk.Interfaces.SelectionModel#g:method:getSelectionInRange").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setModel]("GI.Gtk.Objects.MultiSelection#g:method:setModel"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSelection]("GI.Gtk.Interfaces.SelectionModel#g:method:setSelection").

#if defined(ENABLE_OVERLOADING)
    ResolveMultiSelectionMethod             ,
#endif

-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    MultiSelectionGetModelMethodInfo        ,
#endif
    multiSelectionGetModel                  ,


-- ** new #method:new#

    multiSelectionNew                       ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    MultiSelectionSetModelMethodInfo        ,
#endif
    multiSelectionSetModel                  ,




 -- * Properties


-- ** itemType #attr:itemType#
-- | The type of items. See 'GI.Gio.Interfaces.ListModel.listModelGetItemType'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    MultiSelectionItemTypePropertyInfo      ,
#endif
    getMultiSelectionItemType               ,
#if defined(ENABLE_OVERLOADING)
    multiSelectionItemType                  ,
#endif


-- ** model #attr:model#
-- | The list managed by this selection.

#if defined(ENABLE_OVERLOADING)
    MultiSelectionModelPropertyInfo         ,
#endif
    clearMultiSelectionModel                ,
    constructMultiSelectionModel            ,
    getMultiSelectionModel                  ,
#if defined(ENABLE_OVERLOADING)
    multiSelectionModel                     ,
#endif
    setMultiSelectionModel                  ,


-- ** nItems #attr:nItems#
-- | The number of items. See 'GI.Gio.Interfaces.ListModel.listModelGetNItems'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    MultiSelectionNItemsPropertyInfo        ,
#endif
    getMultiSelectionNItems                 ,
#if defined(ENABLE_OVERLOADING)
    multiSelectionNItems                    ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SectionModel as Gtk.SectionModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Structs.Bitset as Gtk.Bitset

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SectionModel as Gtk.SectionModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel

#endif

-- | Memory-managed wrapper type.
newtype MultiSelection = MultiSelection (SP.ManagedPtr MultiSelection)
    deriving (Eq)

instance SP.ManagedPtrNewtype MultiSelection where
    toManagedPtr (MultiSelection p) = p

foreign import ccall "gtk_multi_selection_get_type"
    c_gtk_multi_selection_get_type :: IO B.Types.GType

instance B.Types.TypedObject MultiSelection where
    glibType = c_gtk_multi_selection_get_type

instance B.Types.GObject MultiSelection

-- | Type class for types which can be safely cast to t'MultiSelection', for instance with `toMultiSelection`.
class (SP.GObject o, O.IsDescendantOf MultiSelection o) => IsMultiSelection o
instance (SP.GObject o, O.IsDescendantOf MultiSelection o) => IsMultiSelection o

instance O.HasParentTypes MultiSelection
type instance O.ParentTypes MultiSelection = '[GObject.Object.Object, Gio.ListModel.ListModel, Gtk.SectionModel.SectionModel, Gtk.SelectionModel.SelectionModel]

-- | Cast to t'MultiSelection', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMultiSelection :: (MIO.MonadIO m, IsMultiSelection o) => o -> m MultiSelection
toMultiSelection = MIO.liftIO . B.ManagedPtr.unsafeCastTo MultiSelection

-- | Convert t'MultiSelection' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MultiSelection) where
    gvalueGType_ = c_gtk_multi_selection_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MultiSelection)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MultiSelection)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MultiSelection ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMultiSelectionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMultiSelectionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMultiSelectionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMultiSelectionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMultiSelectionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMultiSelectionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMultiSelectionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMultiSelectionMethod "isSelected" o = Gtk.SelectionModel.SelectionModelIsSelectedMethodInfo
    ResolveMultiSelectionMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveMultiSelectionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMultiSelectionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMultiSelectionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMultiSelectionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMultiSelectionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMultiSelectionMethod "sectionsChanged" o = Gtk.SectionModel.SectionModelSectionsChangedMethodInfo
    ResolveMultiSelectionMethod "selectAll" o = Gtk.SelectionModel.SelectionModelSelectAllMethodInfo
    ResolveMultiSelectionMethod "selectItem" o = Gtk.SelectionModel.SelectionModelSelectItemMethodInfo
    ResolveMultiSelectionMethod "selectRange" o = Gtk.SelectionModel.SelectionModelSelectRangeMethodInfo
    ResolveMultiSelectionMethod "selectionChanged" o = Gtk.SelectionModel.SelectionModelSelectionChangedMethodInfo
    ResolveMultiSelectionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMultiSelectionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMultiSelectionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMultiSelectionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMultiSelectionMethod "unselectAll" o = Gtk.SelectionModel.SelectionModelUnselectAllMethodInfo
    ResolveMultiSelectionMethod "unselectItem" o = Gtk.SelectionModel.SelectionModelUnselectItemMethodInfo
    ResolveMultiSelectionMethod "unselectRange" o = Gtk.SelectionModel.SelectionModelUnselectRangeMethodInfo
    ResolveMultiSelectionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMultiSelectionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMultiSelectionMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveMultiSelectionMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveMultiSelectionMethod "getModel" o = MultiSelectionGetModelMethodInfo
    ResolveMultiSelectionMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveMultiSelectionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMultiSelectionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMultiSelectionMethod "getSection" o = Gtk.SectionModel.SectionModelGetSectionMethodInfo
    ResolveMultiSelectionMethod "getSelection" o = Gtk.SelectionModel.SelectionModelGetSelectionMethodInfo
    ResolveMultiSelectionMethod "getSelectionInRange" o = Gtk.SelectionModel.SelectionModelGetSelectionInRangeMethodInfo
    ResolveMultiSelectionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMultiSelectionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMultiSelectionMethod "setModel" o = MultiSelectionSetModelMethodInfo
    ResolveMultiSelectionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMultiSelectionMethod "setSelection" o = Gtk.SelectionModel.SelectionModelSetSelectionMethodInfo
    ResolveMultiSelectionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMultiSelectionMethod t MultiSelection, O.OverloadedMethod info MultiSelection p) => OL.IsLabel t (MultiSelection -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMultiSelectionMethod t MultiSelection, O.OverloadedMethod info MultiSelection p, R.HasField t MultiSelection p) => R.HasField t MultiSelection p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMultiSelectionMethod t MultiSelection, O.OverloadedMethodInfo info MultiSelection) => OL.IsLabel t (O.MethodProxy info MultiSelection) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' multiSelection #itemType
-- @
getMultiSelectionItemType :: (MonadIO m, IsMultiSelection o) => o -> m GType
getMultiSelectionItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data MultiSelectionItemTypePropertyInfo
instance AttrInfo MultiSelectionItemTypePropertyInfo where
    type AttrAllowedOps MultiSelectionItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MultiSelectionItemTypePropertyInfo = IsMultiSelection
    type AttrSetTypeConstraint MultiSelectionItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint MultiSelectionItemTypePropertyInfo = (~) ()
    type AttrTransferType MultiSelectionItemTypePropertyInfo = ()
    type AttrGetType MultiSelectionItemTypePropertyInfo = GType
    type AttrLabel MultiSelectionItemTypePropertyInfo = "item-type"
    type AttrOrigin MultiSelectionItemTypePropertyInfo = MultiSelection
    attrGet = getMultiSelectionItemType
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiSelection.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiSelection.html#g:attr:itemType"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' multiSelection #model
-- @
getMultiSelectionModel :: (MonadIO m, IsMultiSelection o) => o -> m (Maybe Gio.ListModel.ListModel)
getMultiSelectionModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gio.ListModel.ListModel

-- | Set the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' multiSelection [ #model 'Data.GI.Base.Attributes.:=' value ]
-- @
setMultiSelectionModel :: (MonadIO m, IsMultiSelection o, Gio.ListModel.IsListModel a) => o -> a -> m ()
setMultiSelectionModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "model" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMultiSelectionModel :: (IsMultiSelection o, MIO.MonadIO m, Gio.ListModel.IsListModel a) => a -> m (GValueConstruct o)
constructMultiSelectionModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

-- | Set the value of the “@model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #model
-- @
clearMultiSelectionModel :: (MonadIO m, IsMultiSelection o) => o -> m ()
clearMultiSelectionModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "model" (Nothing :: Maybe Gio.ListModel.ListModel)

#if defined(ENABLE_OVERLOADING)
data MultiSelectionModelPropertyInfo
instance AttrInfo MultiSelectionModelPropertyInfo where
    type AttrAllowedOps MultiSelectionModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MultiSelectionModelPropertyInfo = IsMultiSelection
    type AttrSetTypeConstraint MultiSelectionModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferTypeConstraint MultiSelectionModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferType MultiSelectionModelPropertyInfo = Gio.ListModel.ListModel
    type AttrGetType MultiSelectionModelPropertyInfo = (Maybe Gio.ListModel.ListModel)
    type AttrLabel MultiSelectionModelPropertyInfo = "model"
    type AttrOrigin MultiSelectionModelPropertyInfo = MultiSelection
    attrGet = getMultiSelectionModel
    attrSet = setMultiSelectionModel
    attrTransfer _ v = do
        unsafeCastTo Gio.ListModel.ListModel v
    attrConstruct = constructMultiSelectionModel
    attrClear = clearMultiSelectionModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiSelection.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiSelection.html#g:attr:model"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' multiSelection #nItems
-- @
getMultiSelectionNItems :: (MonadIO m, IsMultiSelection o) => o -> m Word32
getMultiSelectionNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data MultiSelectionNItemsPropertyInfo
instance AttrInfo MultiSelectionNItemsPropertyInfo where
    type AttrAllowedOps MultiSelectionNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MultiSelectionNItemsPropertyInfo = IsMultiSelection
    type AttrSetTypeConstraint MultiSelectionNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MultiSelectionNItemsPropertyInfo = (~) ()
    type AttrTransferType MultiSelectionNItemsPropertyInfo = ()
    type AttrGetType MultiSelectionNItemsPropertyInfo = Word32
    type AttrLabel MultiSelectionNItemsPropertyInfo = "n-items"
    type AttrOrigin MultiSelectionNItemsPropertyInfo = MultiSelection
    attrGet = getMultiSelectionNItems
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiSelection.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiSelection.html#g:attr:nItems"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MultiSelection
type instance O.AttributeList MultiSelection = MultiSelectionAttributeList
type MultiSelectionAttributeList = ('[ '("itemType", MultiSelectionItemTypePropertyInfo), '("model", MultiSelectionModelPropertyInfo), '("nItems", MultiSelectionNItemsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
multiSelectionItemType :: AttrLabelProxy "itemType"
multiSelectionItemType = AttrLabelProxy

multiSelectionModel :: AttrLabelProxy "model"
multiSelectionModel = AttrLabelProxy

multiSelectionNItems :: AttrLabelProxy "nItems"
multiSelectionNItems = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MultiSelection = MultiSelectionSignalList
type MultiSelectionSignalList = ('[ '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("sectionsChanged", Gtk.SectionModel.SectionModelSectionsChangedSignalInfo), '("selectionChanged", Gtk.SelectionModel.SelectionModelSelectionChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MultiSelection::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GListModel` to manage"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "MultiSelection" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_multi_selection_new" gtk_multi_selection_new :: 
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    IO (Ptr MultiSelection)

-- | Creates a new selection to handle /@model@/.
multiSelectionNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.ListModel.IsListModel a) =>
    Maybe (a)
    -- ^ /@model@/: the @GListModel@ to manage
    -> m MultiSelection
    -- ^ __Returns:__ a new @GtkMultiSelection@
multiSelectionNew model = liftIO $ do
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- B.ManagedPtr.disownObject jModel
            return jModel'
    result <- gtk_multi_selection_new maybeModel
    checkUnexpectedReturnNULL "multiSelectionNew" result
    result' <- (wrapObject MultiSelection) result
    whenJust model touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MultiSelection::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MultiSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMultiSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_multi_selection_get_model" gtk_multi_selection_get_model :: 
    Ptr MultiSelection ->                   -- self : TInterface (Name {namespace = "Gtk", name = "MultiSelection"})
    IO (Ptr Gio.ListModel.ListModel)

-- | Returns the underlying model of /@self@/.
multiSelectionGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsMultiSelection a) =>
    a
    -- ^ /@self@/: a @GtkMultiSelection@
    -> m (Maybe Gio.ListModel.ListModel)
    -- ^ __Returns:__ the underlying model
multiSelectionGetModel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_multi_selection_get_model self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.ListModel.ListModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MultiSelectionGetModelMethodInfo
instance (signature ~ (m (Maybe Gio.ListModel.ListModel)), MonadIO m, IsMultiSelection a) => O.OverloadedMethod MultiSelectionGetModelMethodInfo a signature where
    overloadedMethod = multiSelectionGetModel

instance O.OverloadedMethodInfo MultiSelectionGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiSelection.multiSelectionGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiSelection.html#v:multiSelectionGetModel"
        })


#endif

-- method MultiSelection::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MultiSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMultiSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GListModel` to wrap"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_multi_selection_set_model" gtk_multi_selection_set_model :: 
    Ptr MultiSelection ->                   -- self : TInterface (Name {namespace = "Gtk", name = "MultiSelection"})
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    IO ()

-- | Sets the model that /@self@/ should wrap.
-- 
-- If /@model@/ is 'P.Nothing', /@self@/ will be empty.
multiSelectionSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsMultiSelection a, Gio.ListModel.IsListModel b) =>
    a
    -- ^ /@self@/: a @GtkMultiSelection@
    -> Maybe (b)
    -- ^ /@model@/: A @GListModel@ to wrap
    -> m ()
multiSelectionSetModel self model = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_multi_selection_set_model self' maybeModel
    touchManagedPtr self
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MultiSelectionSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMultiSelection a, Gio.ListModel.IsListModel b) => O.OverloadedMethod MultiSelectionSetModelMethodInfo a signature where
    overloadedMethod = multiSelectionSetModel

instance O.OverloadedMethodInfo MultiSelectionSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiSelection.multiSelectionSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiSelection.html#v:multiSelectionSetModel"
        })


#endif


