{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Animates the transition of its child from invisible to visible.
-- 
-- The style of transition can be controlled with
-- 'GI.Gtk.Objects.Revealer.revealerSetTransitionType'.
-- 
-- These animations respect the [Settings:gtkEnableAnimations]("GI.Gtk.Objects.Settings#g:attr:gtkEnableAnimations")
-- setting.
-- 
-- = CSS nodes
-- 
-- @GtkRevealer@ has a single CSS node with name revealer.
-- When styling @GtkRevealer@ using CSS, remember that it only hides its contents,
-- not itself. That means applied margin, padding and borders will be visible even
-- when the [Revealer:revealChild]("GI.Gtk.Objects.Revealer#g:attr:revealChild") property is set to 'P.False'.
-- 
-- = Accessibility
-- 
-- @GtkRevealer@ uses the 'GI.Gtk.Enums.AccessibleRoleGroup' role.
-- 
-- The child of @GtkRevealer@, if set, is always available in the accessibility
-- tree, regardless of the state of the revealer widget.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Revealer
    ( 

-- * Exported types
    Revealer(..)                            ,
    IsRevealer                              ,
    toRevealer                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Revealer#g:method:getChild"), [getChildRevealed]("GI.Gtk.Objects.Revealer#g:method:getChildRevealed"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRevealChild]("GI.Gtk.Objects.Revealer#g:method:getRevealChild"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getTransitionDuration]("GI.Gtk.Objects.Revealer#g:method:getTransitionDuration"), [getTransitionType]("GI.Gtk.Objects.Revealer#g:method:getTransitionType"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Revealer#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setRevealChild]("GI.Gtk.Objects.Revealer#g:method:setRevealChild"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setTransitionDuration]("GI.Gtk.Objects.Revealer#g:method:setTransitionDuration"), [setTransitionType]("GI.Gtk.Objects.Revealer#g:method:setTransitionType"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveRevealerMethod                   ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    RevealerGetChildMethodInfo              ,
#endif
    revealerGetChild                        ,


-- ** getChildRevealed #method:getChildRevealed#

#if defined(ENABLE_OVERLOADING)
    RevealerGetChildRevealedMethodInfo      ,
#endif
    revealerGetChildRevealed                ,


-- ** getRevealChild #method:getRevealChild#

#if defined(ENABLE_OVERLOADING)
    RevealerGetRevealChildMethodInfo        ,
#endif
    revealerGetRevealChild                  ,


-- ** getTransitionDuration #method:getTransitionDuration#

#if defined(ENABLE_OVERLOADING)
    RevealerGetTransitionDurationMethodInfo ,
#endif
    revealerGetTransitionDuration           ,


-- ** getTransitionType #method:getTransitionType#

#if defined(ENABLE_OVERLOADING)
    RevealerGetTransitionTypeMethodInfo     ,
#endif
    revealerGetTransitionType               ,


-- ** new #method:new#

    revealerNew                             ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    RevealerSetChildMethodInfo              ,
#endif
    revealerSetChild                        ,


-- ** setRevealChild #method:setRevealChild#

#if defined(ENABLE_OVERLOADING)
    RevealerSetRevealChildMethodInfo        ,
#endif
    revealerSetRevealChild                  ,


-- ** setTransitionDuration #method:setTransitionDuration#

#if defined(ENABLE_OVERLOADING)
    RevealerSetTransitionDurationMethodInfo ,
#endif
    revealerSetTransitionDuration           ,


-- ** setTransitionType #method:setTransitionType#

#if defined(ENABLE_OVERLOADING)
    RevealerSetTransitionTypeMethodInfo     ,
#endif
    revealerSetTransitionType               ,




 -- * Properties


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    RevealerChildPropertyInfo               ,
#endif
    clearRevealerChild                      ,
    constructRevealerChild                  ,
    getRevealerChild                        ,
#if defined(ENABLE_OVERLOADING)
    revealerChild                           ,
#endif
    setRevealerChild                        ,


-- ** childRevealed #attr:childRevealed#
-- | Whether the child is revealed and the animation target reached.

#if defined(ENABLE_OVERLOADING)
    RevealerChildRevealedPropertyInfo       ,
#endif
    getRevealerChildRevealed                ,
#if defined(ENABLE_OVERLOADING)
    revealerChildRevealed                   ,
#endif


-- ** revealChild #attr:revealChild#
-- | Whether the revealer should reveal the child.

#if defined(ENABLE_OVERLOADING)
    RevealerRevealChildPropertyInfo         ,
#endif
    constructRevealerRevealChild            ,
    getRevealerRevealChild                  ,
#if defined(ENABLE_OVERLOADING)
    revealerRevealChild                     ,
#endif
    setRevealerRevealChild                  ,


-- ** transitionDuration #attr:transitionDuration#
-- | The animation duration, in milliseconds.

#if defined(ENABLE_OVERLOADING)
    RevealerTransitionDurationPropertyInfo  ,
#endif
    constructRevealerTransitionDuration     ,
    getRevealerTransitionDuration           ,
#if defined(ENABLE_OVERLOADING)
    revealerTransitionDuration              ,
#endif
    setRevealerTransitionDuration           ,


-- ** transitionType #attr:transitionType#
-- | The type of animation used to transition.

#if defined(ENABLE_OVERLOADING)
    RevealerTransitionTypePropertyInfo      ,
#endif
    constructRevealerTransitionType         ,
    getRevealerTransitionType               ,
#if defined(ENABLE_OVERLOADING)
    revealerTransitionType                  ,
#endif
    setRevealerTransitionType               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Revealer = Revealer (SP.ManagedPtr Revealer)
    deriving (Eq)

instance SP.ManagedPtrNewtype Revealer where
    toManagedPtr (Revealer p) = p

foreign import ccall "gtk_revealer_get_type"
    c_gtk_revealer_get_type :: IO B.Types.GType

instance B.Types.TypedObject Revealer where
    glibType = c_gtk_revealer_get_type

instance B.Types.GObject Revealer

-- | Type class for types which can be safely cast to t'Revealer', for instance with `toRevealer`.
class (SP.GObject o, O.IsDescendantOf Revealer o) => IsRevealer o
instance (SP.GObject o, O.IsDescendantOf Revealer o) => IsRevealer o

instance O.HasParentTypes Revealer
type instance O.ParentTypes Revealer = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'Revealer', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toRevealer :: (MIO.MonadIO m, IsRevealer o) => o -> m Revealer
toRevealer = MIO.liftIO . B.ManagedPtr.unsafeCastTo Revealer

-- | Convert t'Revealer' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Revealer) where
    gvalueGType_ = c_gtk_revealer_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Revealer)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Revealer)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Revealer ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveRevealerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRevealerMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveRevealerMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveRevealerMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveRevealerMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveRevealerMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveRevealerMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveRevealerMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveRevealerMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveRevealerMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveRevealerMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveRevealerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveRevealerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveRevealerMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveRevealerMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveRevealerMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveRevealerMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveRevealerMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveRevealerMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveRevealerMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveRevealerMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveRevealerMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveRevealerMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveRevealerMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveRevealerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveRevealerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveRevealerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveRevealerMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveRevealerMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveRevealerMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveRevealerMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveRevealerMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveRevealerMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveRevealerMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveRevealerMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveRevealerMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveRevealerMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveRevealerMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveRevealerMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveRevealerMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveRevealerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveRevealerMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveRevealerMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveRevealerMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveRevealerMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveRevealerMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveRevealerMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveRevealerMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveRevealerMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveRevealerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveRevealerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveRevealerMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveRevealerMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveRevealerMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveRevealerMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveRevealerMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveRevealerMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveRevealerMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveRevealerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveRevealerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveRevealerMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveRevealerMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveRevealerMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveRevealerMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveRevealerMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveRevealerMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveRevealerMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveRevealerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveRevealerMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveRevealerMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveRevealerMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveRevealerMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveRevealerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveRevealerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveRevealerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveRevealerMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveRevealerMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveRevealerMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveRevealerMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveRevealerMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveRevealerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveRevealerMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveRevealerMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveRevealerMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveRevealerMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveRevealerMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveRevealerMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveRevealerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveRevealerMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveRevealerMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveRevealerMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveRevealerMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveRevealerMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveRevealerMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveRevealerMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveRevealerMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveRevealerMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveRevealerMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveRevealerMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveRevealerMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveRevealerMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveRevealerMethod "getChild" o = RevealerGetChildMethodInfo
    ResolveRevealerMethod "getChildRevealed" o = RevealerGetChildRevealedMethodInfo
    ResolveRevealerMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveRevealerMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveRevealerMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveRevealerMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveRevealerMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveRevealerMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveRevealerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveRevealerMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveRevealerMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveRevealerMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveRevealerMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveRevealerMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveRevealerMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveRevealerMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveRevealerMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveRevealerMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveRevealerMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveRevealerMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveRevealerMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveRevealerMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveRevealerMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveRevealerMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveRevealerMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveRevealerMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveRevealerMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveRevealerMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveRevealerMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveRevealerMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveRevealerMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveRevealerMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveRevealerMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveRevealerMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveRevealerMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveRevealerMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveRevealerMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveRevealerMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveRevealerMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveRevealerMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveRevealerMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveRevealerMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveRevealerMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveRevealerMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveRevealerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveRevealerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveRevealerMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveRevealerMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveRevealerMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveRevealerMethod "getRevealChild" o = RevealerGetRevealChildMethodInfo
    ResolveRevealerMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveRevealerMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveRevealerMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveRevealerMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveRevealerMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveRevealerMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveRevealerMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveRevealerMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveRevealerMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveRevealerMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveRevealerMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveRevealerMethod "getTransitionDuration" o = RevealerGetTransitionDurationMethodInfo
    ResolveRevealerMethod "getTransitionType" o = RevealerGetTransitionTypeMethodInfo
    ResolveRevealerMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveRevealerMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveRevealerMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveRevealerMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveRevealerMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveRevealerMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveRevealerMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveRevealerMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveRevealerMethod "setChild" o = RevealerSetChildMethodInfo
    ResolveRevealerMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveRevealerMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveRevealerMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveRevealerMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveRevealerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveRevealerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveRevealerMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveRevealerMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveRevealerMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveRevealerMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveRevealerMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveRevealerMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveRevealerMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveRevealerMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveRevealerMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveRevealerMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveRevealerMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveRevealerMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveRevealerMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveRevealerMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveRevealerMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveRevealerMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveRevealerMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveRevealerMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveRevealerMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveRevealerMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveRevealerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveRevealerMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveRevealerMethod "setRevealChild" o = RevealerSetRevealChildMethodInfo
    ResolveRevealerMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveRevealerMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveRevealerMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveRevealerMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveRevealerMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveRevealerMethod "setTransitionDuration" o = RevealerSetTransitionDurationMethodInfo
    ResolveRevealerMethod "setTransitionType" o = RevealerSetTransitionTypeMethodInfo
    ResolveRevealerMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveRevealerMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveRevealerMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveRevealerMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveRevealerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRevealerMethod t Revealer, O.OverloadedMethod info Revealer p) => OL.IsLabel t (Revealer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRevealerMethod t Revealer, O.OverloadedMethod info Revealer p, R.HasField t Revealer p) => R.HasField t Revealer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRevealerMethod t Revealer, O.OverloadedMethodInfo info Revealer) => OL.IsLabel t (O.MethodProxy info Revealer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' revealer #child
-- @
getRevealerChild :: (MonadIO m, IsRevealer o) => o -> m (Maybe Gtk.Widget.Widget)
getRevealerChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' revealer [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setRevealerChild :: (MonadIO m, IsRevealer o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setRevealerChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructRevealerChild :: (IsRevealer o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructRevealerChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearRevealerChild :: (MonadIO m, IsRevealer o) => o -> m ()
clearRevealerChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data RevealerChildPropertyInfo
instance AttrInfo RevealerChildPropertyInfo where
    type AttrAllowedOps RevealerChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint RevealerChildPropertyInfo = IsRevealer
    type AttrSetTypeConstraint RevealerChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint RevealerChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType RevealerChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType RevealerChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel RevealerChildPropertyInfo = "child"
    type AttrOrigin RevealerChildPropertyInfo = Revealer
    attrGet = getRevealerChild
    attrSet = setRevealerChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructRevealerChild
    attrClear = clearRevealerChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#g:attr:child"
        })
#endif

-- VVV Prop "child-revealed"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@child-revealed@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' revealer #childRevealed
-- @
getRevealerChildRevealed :: (MonadIO m, IsRevealer o) => o -> m Bool
getRevealerChildRevealed obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "child-revealed"

#if defined(ENABLE_OVERLOADING)
data RevealerChildRevealedPropertyInfo
instance AttrInfo RevealerChildRevealedPropertyInfo where
    type AttrAllowedOps RevealerChildRevealedPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint RevealerChildRevealedPropertyInfo = IsRevealer
    type AttrSetTypeConstraint RevealerChildRevealedPropertyInfo = (~) ()
    type AttrTransferTypeConstraint RevealerChildRevealedPropertyInfo = (~) ()
    type AttrTransferType RevealerChildRevealedPropertyInfo = ()
    type AttrGetType RevealerChildRevealedPropertyInfo = Bool
    type AttrLabel RevealerChildRevealedPropertyInfo = "child-revealed"
    type AttrOrigin RevealerChildRevealedPropertyInfo = Revealer
    attrGet = getRevealerChildRevealed
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.childRevealed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#g:attr:childRevealed"
        })
#endif

-- VVV Prop "reveal-child"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@reveal-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' revealer #revealChild
-- @
getRevealerRevealChild :: (MonadIO m, IsRevealer o) => o -> m Bool
getRevealerRevealChild obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "reveal-child"

-- | Set the value of the “@reveal-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' revealer [ #revealChild 'Data.GI.Base.Attributes.:=' value ]
-- @
setRevealerRevealChild :: (MonadIO m, IsRevealer o) => o -> Bool -> m ()
setRevealerRevealChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "reveal-child" val

-- | Construct a t'GValueConstruct' with valid value for the “@reveal-child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructRevealerRevealChild :: (IsRevealer o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructRevealerRevealChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "reveal-child" val

#if defined(ENABLE_OVERLOADING)
data RevealerRevealChildPropertyInfo
instance AttrInfo RevealerRevealChildPropertyInfo where
    type AttrAllowedOps RevealerRevealChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint RevealerRevealChildPropertyInfo = IsRevealer
    type AttrSetTypeConstraint RevealerRevealChildPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint RevealerRevealChildPropertyInfo = (~) Bool
    type AttrTransferType RevealerRevealChildPropertyInfo = Bool
    type AttrGetType RevealerRevealChildPropertyInfo = Bool
    type AttrLabel RevealerRevealChildPropertyInfo = "reveal-child"
    type AttrOrigin RevealerRevealChildPropertyInfo = Revealer
    attrGet = getRevealerRevealChild
    attrSet = setRevealerRevealChild
    attrTransfer _ v = do
        return v
    attrConstruct = constructRevealerRevealChild
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.revealChild"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#g:attr:revealChild"
        })
#endif

-- VVV Prop "transition-duration"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@transition-duration@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' revealer #transitionDuration
-- @
getRevealerTransitionDuration :: (MonadIO m, IsRevealer o) => o -> m Word32
getRevealerTransitionDuration obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "transition-duration"

-- | Set the value of the “@transition-duration@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' revealer [ #transitionDuration 'Data.GI.Base.Attributes.:=' value ]
-- @
setRevealerTransitionDuration :: (MonadIO m, IsRevealer o) => o -> Word32 -> m ()
setRevealerTransitionDuration obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "transition-duration" val

-- | Construct a t'GValueConstruct' with valid value for the “@transition-duration@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructRevealerTransitionDuration :: (IsRevealer o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructRevealerTransitionDuration val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "transition-duration" val

#if defined(ENABLE_OVERLOADING)
data RevealerTransitionDurationPropertyInfo
instance AttrInfo RevealerTransitionDurationPropertyInfo where
    type AttrAllowedOps RevealerTransitionDurationPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint RevealerTransitionDurationPropertyInfo = IsRevealer
    type AttrSetTypeConstraint RevealerTransitionDurationPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint RevealerTransitionDurationPropertyInfo = (~) Word32
    type AttrTransferType RevealerTransitionDurationPropertyInfo = Word32
    type AttrGetType RevealerTransitionDurationPropertyInfo = Word32
    type AttrLabel RevealerTransitionDurationPropertyInfo = "transition-duration"
    type AttrOrigin RevealerTransitionDurationPropertyInfo = Revealer
    attrGet = getRevealerTransitionDuration
    attrSet = setRevealerTransitionDuration
    attrTransfer _ v = do
        return v
    attrConstruct = constructRevealerTransitionDuration
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.transitionDuration"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#g:attr:transitionDuration"
        })
#endif

-- VVV Prop "transition-type"
   -- Type: TInterface (Name {namespace = "Gtk", name = "RevealerTransitionType"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@transition-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' revealer #transitionType
-- @
getRevealerTransitionType :: (MonadIO m, IsRevealer o) => o -> m Gtk.Enums.RevealerTransitionType
getRevealerTransitionType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "transition-type"

-- | Set the value of the “@transition-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' revealer [ #transitionType 'Data.GI.Base.Attributes.:=' value ]
-- @
setRevealerTransitionType :: (MonadIO m, IsRevealer o) => o -> Gtk.Enums.RevealerTransitionType -> m ()
setRevealerTransitionType obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "transition-type" val

-- | Construct a t'GValueConstruct' with valid value for the “@transition-type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructRevealerTransitionType :: (IsRevealer o, MIO.MonadIO m) => Gtk.Enums.RevealerTransitionType -> m (GValueConstruct o)
constructRevealerTransitionType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "transition-type" val

#if defined(ENABLE_OVERLOADING)
data RevealerTransitionTypePropertyInfo
instance AttrInfo RevealerTransitionTypePropertyInfo where
    type AttrAllowedOps RevealerTransitionTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint RevealerTransitionTypePropertyInfo = IsRevealer
    type AttrSetTypeConstraint RevealerTransitionTypePropertyInfo = (~) Gtk.Enums.RevealerTransitionType
    type AttrTransferTypeConstraint RevealerTransitionTypePropertyInfo = (~) Gtk.Enums.RevealerTransitionType
    type AttrTransferType RevealerTransitionTypePropertyInfo = Gtk.Enums.RevealerTransitionType
    type AttrGetType RevealerTransitionTypePropertyInfo = Gtk.Enums.RevealerTransitionType
    type AttrLabel RevealerTransitionTypePropertyInfo = "transition-type"
    type AttrOrigin RevealerTransitionTypePropertyInfo = Revealer
    attrGet = getRevealerTransitionType
    attrSet = setRevealerTransitionType
    attrTransfer _ v = do
        return v
    attrConstruct = constructRevealerTransitionType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.transitionType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#g:attr:transitionType"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Revealer
type instance O.AttributeList Revealer = RevealerAttributeList
type RevealerAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", RevealerChildPropertyInfo), '("childRevealed", RevealerChildRevealedPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("revealChild", RevealerRevealChildPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("transitionDuration", RevealerTransitionDurationPropertyInfo), '("transitionType", RevealerTransitionTypePropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
revealerChild :: AttrLabelProxy "child"
revealerChild = AttrLabelProxy

revealerChildRevealed :: AttrLabelProxy "childRevealed"
revealerChildRevealed = AttrLabelProxy

revealerRevealChild :: AttrLabelProxy "revealChild"
revealerRevealChild = AttrLabelProxy

revealerTransitionDuration :: AttrLabelProxy "transitionDuration"
revealerTransitionDuration = AttrLabelProxy

revealerTransitionType :: AttrLabelProxy "transitionType"
revealerTransitionType = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Revealer = RevealerSignalList
type RevealerSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Revealer::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Revealer" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_revealer_new" gtk_revealer_new :: 
    IO (Ptr Revealer)

-- | Creates a new @GtkRevealer@.
revealerNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Revealer
    -- ^ __Returns:__ a newly created @GtkRevealer@
revealerNew  = liftIO $ do
    result <- gtk_revealer_new
    checkUnexpectedReturnNULL "revealerNew" result
    result' <- (newObject Revealer) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Revealer::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "revealer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Revealer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRevealer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_revealer_get_child" gtk_revealer_get_child :: 
    Ptr Revealer ->                         -- revealer : TInterface (Name {namespace = "Gtk", name = "Revealer"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@revealer@/.
revealerGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsRevealer a) =>
    a
    -- ^ /@revealer@/: a @GtkRevealer@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@revealer@/
revealerGetChild revealer = liftIO $ do
    revealer' <- unsafeManagedPtrCastPtr revealer
    result <- gtk_revealer_get_child revealer'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr revealer
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data RevealerGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsRevealer a) => O.OverloadedMethod RevealerGetChildMethodInfo a signature where
    overloadedMethod = revealerGetChild

instance O.OverloadedMethodInfo RevealerGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.revealerGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#v:revealerGetChild"
        })


#endif

-- method Revealer::get_child_revealed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "revealer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Revealer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRevealer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_revealer_get_child_revealed" gtk_revealer_get_child_revealed :: 
    Ptr Revealer ->                         -- revealer : TInterface (Name {namespace = "Gtk", name = "Revealer"})
    IO CInt

-- | Returns whether the child is fully revealed.
-- 
-- In other words, this returns whether the transition
-- to the revealed state is completed.
revealerGetChildRevealed ::
    (B.CallStack.HasCallStack, MonadIO m, IsRevealer a) =>
    a
    -- ^ /@revealer@/: a @GtkRevealer@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the child is fully revealed
revealerGetChildRevealed revealer = liftIO $ do
    revealer' <- unsafeManagedPtrCastPtr revealer
    result <- gtk_revealer_get_child_revealed revealer'
    let result' = (/= 0) result
    touchManagedPtr revealer
    return result'

#if defined(ENABLE_OVERLOADING)
data RevealerGetChildRevealedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsRevealer a) => O.OverloadedMethod RevealerGetChildRevealedMethodInfo a signature where
    overloadedMethod = revealerGetChildRevealed

instance O.OverloadedMethodInfo RevealerGetChildRevealedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.revealerGetChildRevealed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#v:revealerGetChildRevealed"
        })


#endif

-- method Revealer::get_reveal_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "revealer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Revealer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRevealer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_revealer_get_reveal_child" gtk_revealer_get_reveal_child :: 
    Ptr Revealer ->                         -- revealer : TInterface (Name {namespace = "Gtk", name = "Revealer"})
    IO CInt

-- | Returns whether the child is currently revealed.
-- 
-- This function returns 'P.True' as soon as the transition
-- is to the revealed state is started. To learn whether
-- the child is fully revealed (ie the transition is completed),
-- use 'GI.Gtk.Objects.Revealer.revealerGetChildRevealed'.
revealerGetRevealChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsRevealer a) =>
    a
    -- ^ /@revealer@/: a @GtkRevealer@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the child is revealed.
revealerGetRevealChild revealer = liftIO $ do
    revealer' <- unsafeManagedPtrCastPtr revealer
    result <- gtk_revealer_get_reveal_child revealer'
    let result' = (/= 0) result
    touchManagedPtr revealer
    return result'

#if defined(ENABLE_OVERLOADING)
data RevealerGetRevealChildMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsRevealer a) => O.OverloadedMethod RevealerGetRevealChildMethodInfo a signature where
    overloadedMethod = revealerGetRevealChild

instance O.OverloadedMethodInfo RevealerGetRevealChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.revealerGetRevealChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#v:revealerGetRevealChild"
        })


#endif

-- method Revealer::get_transition_duration
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "revealer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Revealer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRevealer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_revealer_get_transition_duration" gtk_revealer_get_transition_duration :: 
    Ptr Revealer ->                         -- revealer : TInterface (Name {namespace = "Gtk", name = "Revealer"})
    IO Word32

-- | Returns the amount of time (in milliseconds) that
-- transitions will take.
revealerGetTransitionDuration ::
    (B.CallStack.HasCallStack, MonadIO m, IsRevealer a) =>
    a
    -- ^ /@revealer@/: a @GtkRevealer@
    -> m Word32
    -- ^ __Returns:__ the transition duration
revealerGetTransitionDuration revealer = liftIO $ do
    revealer' <- unsafeManagedPtrCastPtr revealer
    result <- gtk_revealer_get_transition_duration revealer'
    touchManagedPtr revealer
    return result

#if defined(ENABLE_OVERLOADING)
data RevealerGetTransitionDurationMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsRevealer a) => O.OverloadedMethod RevealerGetTransitionDurationMethodInfo a signature where
    overloadedMethod = revealerGetTransitionDuration

instance O.OverloadedMethodInfo RevealerGetTransitionDurationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.revealerGetTransitionDuration",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#v:revealerGetTransitionDuration"
        })


#endif

-- method Revealer::get_transition_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "revealer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Revealer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRevealer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "RevealerTransitionType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_revealer_get_transition_type" gtk_revealer_get_transition_type :: 
    Ptr Revealer ->                         -- revealer : TInterface (Name {namespace = "Gtk", name = "Revealer"})
    IO CUInt

-- | Gets the type of animation that will be used
-- for transitions in /@revealer@/.
revealerGetTransitionType ::
    (B.CallStack.HasCallStack, MonadIO m, IsRevealer a) =>
    a
    -- ^ /@revealer@/: a @GtkRevealer@
    -> m Gtk.Enums.RevealerTransitionType
    -- ^ __Returns:__ the current transition type of /@revealer@/
revealerGetTransitionType revealer = liftIO $ do
    revealer' <- unsafeManagedPtrCastPtr revealer
    result <- gtk_revealer_get_transition_type revealer'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr revealer
    return result'

#if defined(ENABLE_OVERLOADING)
data RevealerGetTransitionTypeMethodInfo
instance (signature ~ (m Gtk.Enums.RevealerTransitionType), MonadIO m, IsRevealer a) => O.OverloadedMethod RevealerGetTransitionTypeMethodInfo a signature where
    overloadedMethod = revealerGetTransitionType

instance O.OverloadedMethodInfo RevealerGetTransitionTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.revealerGetTransitionType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#v:revealerGetTransitionType"
        })


#endif

-- method Revealer::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "revealer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Revealer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRevealer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_revealer_set_child" gtk_revealer_set_child :: 
    Ptr Revealer ->                         -- revealer : TInterface (Name {namespace = "Gtk", name = "Revealer"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@revealer@/.
revealerSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsRevealer a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@revealer@/: a @GtkRevealer@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
revealerSetChild revealer child = liftIO $ do
    revealer' <- unsafeManagedPtrCastPtr revealer
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_revealer_set_child revealer' maybeChild
    touchManagedPtr revealer
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data RevealerSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsRevealer a, Gtk.Widget.IsWidget b) => O.OverloadedMethod RevealerSetChildMethodInfo a signature where
    overloadedMethod = revealerSetChild

instance O.OverloadedMethodInfo RevealerSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.revealerSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#v:revealerSetChild"
        })


#endif

-- method Revealer::set_reveal_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "revealer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Revealer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRevealer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "reveal_child"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to reveal the child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_revealer_set_reveal_child" gtk_revealer_set_reveal_child :: 
    Ptr Revealer ->                         -- revealer : TInterface (Name {namespace = "Gtk", name = "Revealer"})
    CInt ->                                 -- reveal_child : TBasicType TBoolean
    IO ()

-- | Tells the @GtkRevealer@ to reveal or conceal its child.
-- 
-- The transition will be animated with the current
-- transition type of /@revealer@/.
revealerSetRevealChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsRevealer a) =>
    a
    -- ^ /@revealer@/: a @GtkRevealer@
    -> Bool
    -- ^ /@revealChild@/: 'P.True' to reveal the child
    -> m ()
revealerSetRevealChild revealer revealChild = liftIO $ do
    revealer' <- unsafeManagedPtrCastPtr revealer
    let revealChild' = (P.fromIntegral . P.fromEnum) revealChild
    gtk_revealer_set_reveal_child revealer' revealChild'
    touchManagedPtr revealer
    return ()

#if defined(ENABLE_OVERLOADING)
data RevealerSetRevealChildMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsRevealer a) => O.OverloadedMethod RevealerSetRevealChildMethodInfo a signature where
    overloadedMethod = revealerSetRevealChild

instance O.OverloadedMethodInfo RevealerSetRevealChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.revealerSetRevealChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#v:revealerSetRevealChild"
        })


#endif

-- method Revealer::set_transition_duration
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "revealer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Revealer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRevealer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "duration"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new duration, in milliseconds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_revealer_set_transition_duration" gtk_revealer_set_transition_duration :: 
    Ptr Revealer ->                         -- revealer : TInterface (Name {namespace = "Gtk", name = "Revealer"})
    Word32 ->                               -- duration : TBasicType TUInt
    IO ()

-- | Sets the duration that transitions will take.
revealerSetTransitionDuration ::
    (B.CallStack.HasCallStack, MonadIO m, IsRevealer a) =>
    a
    -- ^ /@revealer@/: a @GtkRevealer@
    -> Word32
    -- ^ /@duration@/: the new duration, in milliseconds
    -> m ()
revealerSetTransitionDuration revealer duration = liftIO $ do
    revealer' <- unsafeManagedPtrCastPtr revealer
    gtk_revealer_set_transition_duration revealer' duration
    touchManagedPtr revealer
    return ()

#if defined(ENABLE_OVERLOADING)
data RevealerSetTransitionDurationMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsRevealer a) => O.OverloadedMethod RevealerSetTransitionDurationMethodInfo a signature where
    overloadedMethod = revealerSetTransitionDuration

instance O.OverloadedMethodInfo RevealerSetTransitionDurationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.revealerSetTransitionDuration",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#v:revealerSetTransitionDuration"
        })


#endif

-- method Revealer::set_transition_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "revealer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Revealer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRevealer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "transition"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "RevealerTransitionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new transition type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_revealer_set_transition_type" gtk_revealer_set_transition_type :: 
    Ptr Revealer ->                         -- revealer : TInterface (Name {namespace = "Gtk", name = "Revealer"})
    CUInt ->                                -- transition : TInterface (Name {namespace = "Gtk", name = "RevealerTransitionType"})
    IO ()

-- | Sets the type of animation that will be used for
-- transitions in /@revealer@/.
-- 
-- Available types include various kinds of fades and slides.
revealerSetTransitionType ::
    (B.CallStack.HasCallStack, MonadIO m, IsRevealer a) =>
    a
    -- ^ /@revealer@/: a @GtkRevealer@
    -> Gtk.Enums.RevealerTransitionType
    -- ^ /@transition@/: the new transition type
    -> m ()
revealerSetTransitionType revealer transition = liftIO $ do
    revealer' <- unsafeManagedPtrCastPtr revealer
    let transition' = (fromIntegral . fromEnum) transition
    gtk_revealer_set_transition_type revealer' transition'
    touchManagedPtr revealer
    return ()

#if defined(ENABLE_OVERLOADING)
data RevealerSetTransitionTypeMethodInfo
instance (signature ~ (Gtk.Enums.RevealerTransitionType -> m ()), MonadIO m, IsRevealer a) => O.OverloadedMethod RevealerSetTransitionTypeMethodInfo a signature where
    overloadedMethod = revealerSetTransitionType

instance O.OverloadedMethodInfo RevealerSetTransitionTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Revealer.revealerSetTransitionType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Revealer.html#v:revealerSetTransitionType"
        })


#endif


