{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A list model that wraps an array of strings.
-- 
-- The objects in the model are of type t'GI.Gtk.Objects.StringObject.StringObject' and have
-- a \"string\" property that can be used inside expressions.
-- 
-- @GtkStringList@ is well-suited for any place where you would
-- typically use a @char*[]@, but need a list model.
-- 
-- == GtkStringList as GtkBuildable
-- 
-- The @GtkStringList@ implementation of the @GtkBuildable@ interface
-- supports adding items directly using the @\<items>@ element and
-- specifying @\<item>@ elements for each item. Each @\<item>@ element
-- supports the regular translation attributes “translatable”,
-- “context” and “comments”.
-- 
-- Here is a UI definition fragment specifying a @GtkStringList@
-- 
-- 
-- === /xml code/
-- ><object class="GtkStringList">
-- >  <items>
-- >    <item translatable="yes">Factory</item>
-- >    <item translatable="yes">Home</item>
-- >    <item translatable="yes">Subway</item>
-- >  </items>
-- ></object>
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.StringList
    ( 

-- * Exported types
    StringList(..)                          ,
    IsStringList                            ,
    toStringList                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [append]("GI.Gtk.Objects.StringList#g:method:append"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [find]("GI.Gtk.Objects.StringList#g:method:find"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.StringList#g:method:remove"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [splice]("GI.Gtk.Objects.StringList#g:method:splice"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [take]("GI.Gtk.Objects.StringList#g:method:take"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getString]("GI.Gtk.Objects.StringList#g:method:getString").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveStringListMethod                 ,
#endif

-- ** append #method:append#

#if defined(ENABLE_OVERLOADING)
    StringListAppendMethodInfo              ,
#endif
    stringListAppend                        ,


-- ** find #method:find#

#if defined(ENABLE_OVERLOADING)
    StringListFindMethodInfo                ,
#endif
    stringListFind                          ,


-- ** getString #method:getString#

#if defined(ENABLE_OVERLOADING)
    StringListGetStringMethodInfo           ,
#endif
    stringListGetString                     ,


-- ** new #method:new#

    stringListNew                           ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    StringListRemoveMethodInfo              ,
#endif
    stringListRemove                        ,


-- ** splice #method:splice#

#if defined(ENABLE_OVERLOADING)
    StringListSpliceMethodInfo              ,
#endif
    stringListSplice                        ,


-- ** take #method:take#

#if defined(ENABLE_OVERLOADING)
    StringListTakeMethodInfo                ,
#endif
    stringListTake                          ,




 -- * Properties


-- ** itemType #attr:itemType#
-- | The type of items. See 'GI.Gio.Interfaces.ListModel.listModelGetItemType'.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    StringListItemTypePropertyInfo          ,
#endif
    getStringListItemType                   ,
#if defined(ENABLE_OVERLOADING)
    stringListItemType                      ,
#endif


-- ** nItems #attr:nItems#
-- | The number of items. See 'GI.Gio.Interfaces.ListModel.listModelGetNItems'.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    StringListNItemsPropertyInfo            ,
#endif
    getStringListNItems                     ,
#if defined(ENABLE_OVERLOADING)
    stringListNItems                        ,
#endif


-- ** strings #attr:strings#
-- | The strings in the model.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    StringListStringsPropertyInfo           ,
#endif
    constructStringListStrings              ,
#if defined(ENABLE_OVERLOADING)
    stringListStrings                       ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable

#endif

-- | Memory-managed wrapper type.
newtype StringList = StringList (SP.ManagedPtr StringList)
    deriving (Eq)

instance SP.ManagedPtrNewtype StringList where
    toManagedPtr (StringList p) = p

foreign import ccall "gtk_string_list_get_type"
    c_gtk_string_list_get_type :: IO B.Types.GType

instance B.Types.TypedObject StringList where
    glibType = c_gtk_string_list_get_type

instance B.Types.GObject StringList

-- | Type class for types which can be safely cast to t'StringList', for instance with `toStringList`.
class (SP.GObject o, O.IsDescendantOf StringList o) => IsStringList o
instance (SP.GObject o, O.IsDescendantOf StringList o) => IsStringList o

instance O.HasParentTypes StringList
type instance O.ParentTypes StringList = '[GObject.Object.Object, Gio.ListModel.ListModel, Gtk.Buildable.Buildable]

-- | Cast to t'StringList', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toStringList :: (MIO.MonadIO m, IsStringList o) => o -> m StringList
toStringList = MIO.liftIO . B.ManagedPtr.unsafeCastTo StringList

-- | Convert t'StringList' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe StringList) where
    gvalueGType_ = c_gtk_string_list_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr StringList)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr StringList)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject StringList ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveStringListMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStringListMethod "append" o = StringListAppendMethodInfo
    ResolveStringListMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveStringListMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveStringListMethod "find" o = StringListFindMethodInfo
    ResolveStringListMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveStringListMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveStringListMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveStringListMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveStringListMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveStringListMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveStringListMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveStringListMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveStringListMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveStringListMethod "remove" o = StringListRemoveMethodInfo
    ResolveStringListMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveStringListMethod "splice" o = StringListSpliceMethodInfo
    ResolveStringListMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveStringListMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveStringListMethod "take" o = StringListTakeMethodInfo
    ResolveStringListMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveStringListMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveStringListMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveStringListMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveStringListMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveStringListMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveStringListMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveStringListMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveStringListMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveStringListMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveStringListMethod "getString" o = StringListGetStringMethodInfo
    ResolveStringListMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveStringListMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveStringListMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveStringListMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStringListMethod t StringList, O.OverloadedMethod info StringList p) => OL.IsLabel t (StringList -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStringListMethod t StringList, O.OverloadedMethod info StringList p, R.HasField t StringList p) => R.HasField t StringList p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStringListMethod t StringList, O.OverloadedMethodInfo info StringList) => OL.IsLabel t (O.MethodProxy info StringList) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stringList #itemType
-- @
getStringListItemType :: (MonadIO m, IsStringList o) => o -> m GType
getStringListItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data StringListItemTypePropertyInfo
instance AttrInfo StringListItemTypePropertyInfo where
    type AttrAllowedOps StringListItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint StringListItemTypePropertyInfo = IsStringList
    type AttrSetTypeConstraint StringListItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint StringListItemTypePropertyInfo = (~) ()
    type AttrTransferType StringListItemTypePropertyInfo = ()
    type AttrGetType StringListItemTypePropertyInfo = GType
    type AttrLabel StringListItemTypePropertyInfo = "item-type"
    type AttrOrigin StringListItemTypePropertyInfo = StringList
    attrGet = getStringListItemType
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringList.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringList.html#g:attr:itemType"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stringList #nItems
-- @
getStringListNItems :: (MonadIO m, IsStringList o) => o -> m Word32
getStringListNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data StringListNItemsPropertyInfo
instance AttrInfo StringListNItemsPropertyInfo where
    type AttrAllowedOps StringListNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint StringListNItemsPropertyInfo = IsStringList
    type AttrSetTypeConstraint StringListNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint StringListNItemsPropertyInfo = (~) ()
    type AttrTransferType StringListNItemsPropertyInfo = ()
    type AttrGetType StringListNItemsPropertyInfo = Word32
    type AttrLabel StringListNItemsPropertyInfo = "n-items"
    type AttrOrigin StringListNItemsPropertyInfo = StringList
    attrGet = getStringListNItems
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringList.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringList.html#g:attr:nItems"
        })
#endif

-- VVV Prop "strings"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Construct a t'GValueConstruct' with valid value for the “@strings@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStringListStrings :: (IsStringList o, MIO.MonadIO m) => [T.Text] -> m (GValueConstruct o)
constructStringListStrings val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyStringArray "strings" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data StringListStringsPropertyInfo
instance AttrInfo StringListStringsPropertyInfo where
    type AttrAllowedOps StringListStringsPropertyInfo = '[ 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint StringListStringsPropertyInfo = IsStringList
    type AttrSetTypeConstraint StringListStringsPropertyInfo = (~) [T.Text]
    type AttrTransferTypeConstraint StringListStringsPropertyInfo = (~) [T.Text]
    type AttrTransferType StringListStringsPropertyInfo = [T.Text]
    type AttrGetType StringListStringsPropertyInfo = ()
    type AttrLabel StringListStringsPropertyInfo = "strings"
    type AttrOrigin StringListStringsPropertyInfo = StringList
    attrGet = undefined
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructStringListStrings
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringList.strings"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringList.html#g:attr:strings"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList StringList
type instance O.AttributeList StringList = StringListAttributeList
type StringListAttributeList = ('[ '("itemType", StringListItemTypePropertyInfo), '("nItems", StringListNItemsPropertyInfo), '("strings", StringListStringsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
stringListItemType :: AttrLabelProxy "itemType"
stringListItemType = AttrLabelProxy

stringListNItems :: AttrLabelProxy "nItems"
stringListNItems = AttrLabelProxy

stringListStrings :: AttrLabelProxy "strings"
stringListStrings = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList StringList = StringListSignalList
type StringListSignalList = ('[ '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method StringList::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "strings"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The strings to put in the model"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "StringList" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_list_new" gtk_string_list_new :: 
    Ptr CString ->                          -- strings : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO (Ptr StringList)

-- | Creates a new @GtkStringList@ with the given /@strings@/.
stringListNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([T.Text])
    -- ^ /@strings@/: The strings to put in the model
    -> m StringList
    -- ^ __Returns:__ a new @GtkStringList@
stringListNew strings = liftIO $ do
    maybeStrings <- case strings of
        Nothing -> return FP.nullPtr
        Just jStrings -> do
            jStrings' <- packZeroTerminatedUTF8CArray jStrings
            return jStrings'
    result <- gtk_string_list_new maybeStrings
    checkUnexpectedReturnNULL "stringListNew" result
    result' <- (wrapObject StringList) result
    mapZeroTerminatedCArray freeMem maybeStrings
    freeMem maybeStrings
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method StringList::append
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringList`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to insert"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_list_append" gtk_string_list_append :: 
    Ptr StringList ->                       -- self : TInterface (Name {namespace = "Gtk", name = "StringList"})
    CString ->                              -- string : TBasicType TUTF8
    IO ()

-- | Appends /@string@/ to /@self@/.
-- 
-- The /@string@/ will be copied. See
-- 'GI.Gtk.Objects.StringList.stringListTake' for a way to avoid that.
stringListAppend ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringList a) =>
    a
    -- ^ /@self@/: a @GtkStringList@
    -> T.Text
    -- ^ /@string@/: the string to insert
    -> m ()
stringListAppend self string = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    string' <- textToCString string
    gtk_string_list_append self' string'
    touchManagedPtr self
    freeMem string'
    return ()

#if defined(ENABLE_OVERLOADING)
data StringListAppendMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsStringList a) => O.OverloadedMethod StringListAppendMethodInfo a signature where
    overloadedMethod = stringListAppend

instance O.OverloadedMethodInfo StringListAppendMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringList.stringListAppend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringList.html#v:stringListAppend"
        })


#endif

-- method StringList::find
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringList`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to find" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_list_find" gtk_string_list_find :: 
    Ptr StringList ->                       -- self : TInterface (Name {namespace = "Gtk", name = "StringList"})
    CString ->                              -- string : TBasicType TUTF8
    IO Word32

-- | Gets the position of the /@string@/ in /@self@/.
-- 
-- If /@self@/ does not contain /@string@/ item, @G_MAXUINT@ is returned.
-- 
-- /Since: 4.18/
stringListFind ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringList a) =>
    a
    -- ^ /@self@/: a @GtkStringList@
    -> T.Text
    -- ^ /@string@/: the string to find
    -> m Word32
    -- ^ __Returns:__ the position of the string
stringListFind self string = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    string' <- textToCString string
    result <- gtk_string_list_find self' string'
    touchManagedPtr self
    freeMem string'
    return result

#if defined(ENABLE_OVERLOADING)
data StringListFindMethodInfo
instance (signature ~ (T.Text -> m Word32), MonadIO m, IsStringList a) => O.OverloadedMethod StringListFindMethodInfo a signature where
    overloadedMethod = stringListFind

instance O.OverloadedMethodInfo StringListFindMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringList.stringListFind",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringList.html#v:stringListFind"
        })


#endif

-- method StringList::get_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringList`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position to get the string for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_list_get_string" gtk_string_list_get_string :: 
    Ptr StringList ->                       -- self : TInterface (Name {namespace = "Gtk", name = "StringList"})
    Word32 ->                               -- position : TBasicType TUInt
    IO CString

-- | Gets the string that is at /@position@/ in /@self@/.
-- 
-- If /@self@/ does not contain /@position@/ items, 'P.Nothing' is returned.
-- 
-- This function returns the const char *. To get the
-- object wrapping it, use @/g_list_model_get_item()/@.
stringListGetString ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringList a) =>
    a
    -- ^ /@self@/: a @GtkStringList@
    -> Word32
    -- ^ /@position@/: the position to get the string for
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the string at the given position
stringListGetString self position = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_string_list_get_string self' position
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StringListGetStringMethodInfo
instance (signature ~ (Word32 -> m (Maybe T.Text)), MonadIO m, IsStringList a) => O.OverloadedMethod StringListGetStringMethodInfo a signature where
    overloadedMethod = stringListGetString

instance O.OverloadedMethodInfo StringListGetStringMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringList.stringListGetString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringList.html#v:stringListGetString"
        })


#endif

-- method StringList::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringList`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the position of the string that is to be removed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_list_remove" gtk_string_list_remove :: 
    Ptr StringList ->                       -- self : TInterface (Name {namespace = "Gtk", name = "StringList"})
    Word32 ->                               -- position : TBasicType TUInt
    IO ()

-- | Removes the string at /@position@/ from /@self@/.
-- 
-- /@position@/ must be smaller than the current
-- length of the list.
stringListRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringList a) =>
    a
    -- ^ /@self@/: a @GtkStringList@
    -> Word32
    -- ^ /@position@/: the position of the string that is to be removed
    -> m ()
stringListRemove self position = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_string_list_remove self' position
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StringListRemoveMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsStringList a) => O.OverloadedMethod StringListRemoveMethodInfo a signature where
    overloadedMethod = stringListRemove

instance O.OverloadedMethodInfo StringListRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringList.stringListRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringList.html#v:stringListRemove"
        })


#endif

-- method StringList::splice
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringList`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position at which to make the change"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_removals"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of strings to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "additions"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The strings to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_list_splice" gtk_string_list_splice :: 
    Ptr StringList ->                       -- self : TInterface (Name {namespace = "Gtk", name = "StringList"})
    Word32 ->                               -- position : TBasicType TUInt
    Word32 ->                               -- n_removals : TBasicType TUInt
    Ptr CString ->                          -- additions : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Changes /@self@/ by removing /@nRemovals@/ strings and adding /@additions@/
-- to it.
-- 
-- This function is more efficient than 'GI.Gtk.Objects.StringList.stringListAppend'
-- and 'GI.Gtk.Objects.StringList.stringListRemove', because it only emits the
-- [itemsChanged](#g:signal:itemsChanged) signal once for the change.
-- 
-- This function copies the strings in /@additions@/.
-- 
-- The parameters /@position@/ and /@nRemovals@/ must be correct (ie:
-- /@position@/ + /@nRemovals@/ must be less than or equal to the length
-- of the list at the time this function is called).
stringListSplice ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringList a) =>
    a
    -- ^ /@self@/: a @GtkStringList@
    -> Word32
    -- ^ /@position@/: the position at which to make the change
    -> Word32
    -- ^ /@nRemovals@/: the number of strings to remove
    -> Maybe ([T.Text])
    -- ^ /@additions@/: The strings to add
    -> m ()
stringListSplice self position nRemovals additions = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeAdditions <- case additions of
        Nothing -> return FP.nullPtr
        Just jAdditions -> do
            jAdditions' <- packZeroTerminatedUTF8CArray jAdditions
            return jAdditions'
    gtk_string_list_splice self' position nRemovals maybeAdditions
    touchManagedPtr self
    mapZeroTerminatedCArray freeMem maybeAdditions
    freeMem maybeAdditions
    return ()

#if defined(ENABLE_OVERLOADING)
data StringListSpliceMethodInfo
instance (signature ~ (Word32 -> Word32 -> Maybe ([T.Text]) -> m ()), MonadIO m, IsStringList a) => O.OverloadedMethod StringListSpliceMethodInfo a signature where
    overloadedMethod = stringListSplice

instance O.OverloadedMethodInfo StringListSpliceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringList.stringListSplice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringList.html#v:stringListSplice"
        })


#endif

-- method StringList::take
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringList`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to insert"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_list_take" gtk_string_list_take :: 
    Ptr StringList ->                       -- self : TInterface (Name {namespace = "Gtk", name = "StringList"})
    CString ->                              -- string : TBasicType TUTF8
    IO ()

-- | Adds /@string@/ to self at the end, and takes
-- ownership of it.
-- 
-- This variant of 'GI.Gtk.Objects.StringList.stringListAppend'
-- is convenient for formatting strings:
-- 
-- 
-- === /c code/
-- >gtk_string_list_take (self, g_strdup_print ("%d dollars", lots));
stringListTake ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringList a) =>
    a
    -- ^ /@self@/: a @GtkStringList@
    -> T.Text
    -- ^ /@string@/: the string to insert
    -> m ()
stringListTake self string = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    string' <- textToCString string
    gtk_string_list_take self' string'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StringListTakeMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsStringList a) => O.OverloadedMethod StringListTakeMethodInfo a signature where
    overloadedMethod = stringListTake

instance O.OverloadedMethodInfo StringListTakeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringList.stringListTake",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringList.html#v:stringListTake"
        })


#endif


