{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A toplevel window which can contain other widgets.
-- 
-- \<picture>
--   \<source srcset=\"window-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkWindow\" src=\"window.png\">
-- \<\/picture>
-- 
-- Windows normally have decorations that are under the control
-- of the windowing system and allow the user to manipulate the window
-- (resize it, move it, close it,...).
-- 
-- = GtkWindow as GtkBuildable
-- 
-- The @GtkWindow@ implementation of the t'GI.Gtk.Interfaces.Buildable.Buildable' interface supports
-- setting a child as the titlebar by specifying “titlebar” as the “type”
-- attribute of a @\<child>@ element.
-- 
-- = Shortcuts and Gestures
-- 
-- @GtkWindow@ supports the following keyboard shortcuts:
-- 
-- * \<kbd>F10\<\/kbd> activates the menubar, if present.
-- * \<kbd>Alt\<\/kbd> makes the mnemonics visible while pressed.
-- 
-- 
-- The following signals have default keybindings:
-- 
-- * [Window::activateDefault]("GI.Gtk.Objects.Window#g:signal:activateDefault")
-- * [Window::activateFocus]("GI.Gtk.Objects.Window#g:signal:activateFocus")
-- * [Window::enableDebugging]("GI.Gtk.Objects.Window#g:signal:enableDebugging")
-- 
-- 
-- = Actions
-- 
-- @GtkWindow@ defines a set of built-in actions:
-- 
-- * @default.activate@ activates the default widget.
-- * @window.minimize@ minimizes the window.
-- * @window.toggle-maximized@ maximizes or restores the window.
-- * @window.close@ closes the window.
-- 
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >window.background [.csd / .solid-csd / .ssd] [.maximized / .fullscreen / .tiled]
-- >├── <child>
-- >╰── <titlebar child>.titlebar [.default-decoration]
-- 
-- 
-- @GtkWindow@ has a main CSS node with name window and style class .background.
-- 
-- Style classes that are typically used with the main CSS node are .csd (when
-- client-side decorations are in use), .solid-csd (for client-side decorations
-- without invisible borders), .ssd (used by mutter when rendering server-side
-- decorations). GtkWindow also represents window states with the following
-- style classes on the main node: .maximized, .fullscreen, .tiled (when supported,
-- also .tiled-top, .tiled-left, .tiled-right, .tiled-bottom).
-- 
-- @GtkWindow@ subclasses often add their own discriminating style classes,
-- such as .dialog, .popup or .tooltip.
-- 
-- Generally, some CSS properties don\'t make sense on the toplevel window node,
-- such as margins or padding. When client-side decorations without invisible
-- borders are in use (i.e. the .solid-csd style class is added to the
-- main window node), the CSS border of the toplevel window is used for
-- resize drags. In the .csd case, the shadow area outside of the window
-- can be used to resize it.
-- 
-- @GtkWindow@ adds the .titlebar and .default-decoration style classes to the
-- widget that is added as a titlebar child.
-- 
-- = Accessibility
-- 
-- @GtkWindow@ uses the 'GI.Gtk.Enums.AccessibleRoleWindow' role.
-- 
-- From GTK 4.12 to 4.18, it used the 'GI.Gtk.Enums.AccessibleRoleApplication' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Window
    ( 

-- * Exported types
    Window(..)                              ,
    IsWindow                                ,
    toWindow                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [close]("GI.Gtk.Objects.Window#g:method:close"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [destroy]("GI.Gtk.Objects.Window#g:method:destroy"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [fullscreen]("GI.Gtk.Objects.Window#g:method:fullscreen"), [fullscreenOnMonitor]("GI.Gtk.Objects.Window#g:method:fullscreenOnMonitor"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasGroup]("GI.Gtk.Objects.Window#g:method:hasGroup"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isActive]("GI.Gtk.Objects.Window#g:method:isActive"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isFullscreen]("GI.Gtk.Objects.Window#g:method:isFullscreen"), [isMaximized]("GI.Gtk.Objects.Window#g:method:isMaximized"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isSuspended]("GI.Gtk.Objects.Window#g:method:isSuspended"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [maximize]("GI.Gtk.Objects.Window#g:method:maximize"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [minimize]("GI.Gtk.Objects.Window#g:method:minimize"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [present]("GI.Gtk.Objects.Window#g:method:present"), [presentWithTime]("GI.Gtk.Objects.Window#g:method:presentWithTime"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unfullscreen]("GI.Gtk.Objects.Window#g:method:unfullscreen"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unmaximize]("GI.Gtk.Objects.Window#g:method:unmaximize"), [unminimize]("GI.Gtk.Objects.Window#g:method:unminimize"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getApplication]("GI.Gtk.Objects.Window#g:method:getApplication"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Window#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDecorated]("GI.Gtk.Objects.Window#g:method:getDecorated"), [getDefaultSize]("GI.Gtk.Objects.Window#g:method:getDefaultSize"), [getDefaultWidget]("GI.Gtk.Objects.Window#g:method:getDefaultWidget"), [getDeletable]("GI.Gtk.Objects.Window#g:method:getDeletable"), [getDestroyWithParent]("GI.Gtk.Objects.Window#g:method:getDestroyWithParent"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocus]("GI.Gtk.Objects.Window#g:method:getFocus"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusVisible]("GI.Gtk.Objects.Window#g:method:getFocusVisible"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getGravity]("GI.Gtk.Objects.Window#g:method:getGravity"), [getGroup]("GI.Gtk.Objects.Window#g:method:getGroup"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:getHandleMenubarAccel"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHideOnClose]("GI.Gtk.Objects.Window#g:method:getHideOnClose"), [getIconName]("GI.Gtk.Objects.Window#g:method:getIconName"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:getMnemonicsVisible"), [getModal]("GI.Gtk.Objects.Window#g:method:getModal"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getResizable]("GI.Gtk.Objects.Window#g:method:getResizable"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTitle]("GI.Gtk.Objects.Window#g:method:getTitle"), [getTitlebar]("GI.Gtk.Objects.Window#g:method:getTitlebar"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getTransientFor]("GI.Gtk.Objects.Window#g:method:getTransientFor"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setApplication]("GI.Gtk.Objects.Window#g:method:setApplication"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Window#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorated]("GI.Gtk.Objects.Window#g:method:setDecorated"), [setDefaultSize]("GI.Gtk.Objects.Window#g:method:setDefaultSize"), [setDefaultWidget]("GI.Gtk.Objects.Window#g:method:setDefaultWidget"), [setDeletable]("GI.Gtk.Objects.Window#g:method:setDeletable"), [setDestroyWithParent]("GI.Gtk.Objects.Window#g:method:setDestroyWithParent"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setDisplay]("GI.Gtk.Objects.Window#g:method:setDisplay"), [setFocus]("GI.Gtk.Objects.Window#g:method:setFocus"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusVisible]("GI.Gtk.Objects.Window#g:method:setFocusVisible"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setGravity]("GI.Gtk.Objects.Window#g:method:setGravity"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:setHandleMenubarAccel"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHideOnClose]("GI.Gtk.Objects.Window#g:method:setHideOnClose"), [setIconName]("GI.Gtk.Objects.Window#g:method:setIconName"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:setMnemonicsVisible"), [setModal]("GI.Gtk.Objects.Window#g:method:setModal"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResizable]("GI.Gtk.Objects.Window#g:method:setResizable"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStartupId]("GI.Gtk.Objects.Window#g:method:setStartupId"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTitle]("GI.Gtk.Objects.Window#g:method:setTitle"), [setTitlebar]("GI.Gtk.Objects.Window#g:method:setTitlebar"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setTransientFor]("GI.Gtk.Objects.Window#g:method:setTransientFor"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveWindowMethod                     ,
#endif

-- ** close #method:close#

#if defined(ENABLE_OVERLOADING)
    WindowCloseMethodInfo                   ,
#endif
    windowClose                             ,


-- ** destroy #method:destroy#

#if defined(ENABLE_OVERLOADING)
    WindowDestroyMethodInfo                 ,
#endif
    windowDestroy                           ,


-- ** fullscreen #method:fullscreen#

#if defined(ENABLE_OVERLOADING)
    WindowFullscreenMethodInfo              ,
#endif
    windowFullscreen                        ,


-- ** fullscreenOnMonitor #method:fullscreenOnMonitor#

#if defined(ENABLE_OVERLOADING)
    WindowFullscreenOnMonitorMethodInfo     ,
#endif
    windowFullscreenOnMonitor               ,


-- ** getApplication #method:getApplication#

#if defined(ENABLE_OVERLOADING)
    WindowGetApplicationMethodInfo          ,
#endif
    windowGetApplication                    ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    WindowGetChildMethodInfo                ,
#endif
    windowGetChild                          ,


-- ** getDecorated #method:getDecorated#

#if defined(ENABLE_OVERLOADING)
    WindowGetDecoratedMethodInfo            ,
#endif
    windowGetDecorated                      ,


-- ** getDefaultIconName #method:getDefaultIconName#

    windowGetDefaultIconName                ,


-- ** getDefaultSize #method:getDefaultSize#

#if defined(ENABLE_OVERLOADING)
    WindowGetDefaultSizeMethodInfo          ,
#endif
    windowGetDefaultSize                    ,


-- ** getDefaultWidget #method:getDefaultWidget#

#if defined(ENABLE_OVERLOADING)
    WindowGetDefaultWidgetMethodInfo        ,
#endif
    windowGetDefaultWidget                  ,


-- ** getDeletable #method:getDeletable#

#if defined(ENABLE_OVERLOADING)
    WindowGetDeletableMethodInfo            ,
#endif
    windowGetDeletable                      ,


-- ** getDestroyWithParent #method:getDestroyWithParent#

#if defined(ENABLE_OVERLOADING)
    WindowGetDestroyWithParentMethodInfo    ,
#endif
    windowGetDestroyWithParent              ,


-- ** getFocus #method:getFocus#

#if defined(ENABLE_OVERLOADING)
    WindowGetFocusMethodInfo                ,
#endif
    windowGetFocus                          ,


-- ** getFocusVisible #method:getFocusVisible#

#if defined(ENABLE_OVERLOADING)
    WindowGetFocusVisibleMethodInfo         ,
#endif
    windowGetFocusVisible                   ,


-- ** getGravity #method:getGravity#

#if defined(ENABLE_OVERLOADING)
    WindowGetGravityMethodInfo              ,
#endif
    windowGetGravity                        ,


-- ** getGroup #method:getGroup#

#if defined(ENABLE_OVERLOADING)
    WindowGetGroupMethodInfo                ,
#endif
    windowGetGroup                          ,


-- ** getHandleMenubarAccel #method:getHandleMenubarAccel#

#if defined(ENABLE_OVERLOADING)
    WindowGetHandleMenubarAccelMethodInfo   ,
#endif
    windowGetHandleMenubarAccel             ,


-- ** getHideOnClose #method:getHideOnClose#

#if defined(ENABLE_OVERLOADING)
    WindowGetHideOnCloseMethodInfo          ,
#endif
    windowGetHideOnClose                    ,


-- ** getIconName #method:getIconName#

#if defined(ENABLE_OVERLOADING)
    WindowGetIconNameMethodInfo             ,
#endif
    windowGetIconName                       ,


-- ** getMnemonicsVisible #method:getMnemonicsVisible#

#if defined(ENABLE_OVERLOADING)
    WindowGetMnemonicsVisibleMethodInfo     ,
#endif
    windowGetMnemonicsVisible               ,


-- ** getModal #method:getModal#

#if defined(ENABLE_OVERLOADING)
    WindowGetModalMethodInfo                ,
#endif
    windowGetModal                          ,


-- ** getResizable #method:getResizable#

#if defined(ENABLE_OVERLOADING)
    WindowGetResizableMethodInfo            ,
#endif
    windowGetResizable                      ,


-- ** getTitle #method:getTitle#

#if defined(ENABLE_OVERLOADING)
    WindowGetTitleMethodInfo                ,
#endif
    windowGetTitle                          ,


-- ** getTitlebar #method:getTitlebar#

#if defined(ENABLE_OVERLOADING)
    WindowGetTitlebarMethodInfo             ,
#endif
    windowGetTitlebar                       ,


-- ** getToplevels #method:getToplevels#

    windowGetToplevels                      ,


-- ** getTransientFor #method:getTransientFor#

#if defined(ENABLE_OVERLOADING)
    WindowGetTransientForMethodInfo         ,
#endif
    windowGetTransientFor                   ,


-- ** hasGroup #method:hasGroup#

#if defined(ENABLE_OVERLOADING)
    WindowHasGroupMethodInfo                ,
#endif
    windowHasGroup                          ,


-- ** isActive #method:isActive#

#if defined(ENABLE_OVERLOADING)
    WindowIsActiveMethodInfo                ,
#endif
    windowIsActive                          ,


-- ** isFullscreen #method:isFullscreen#

#if defined(ENABLE_OVERLOADING)
    WindowIsFullscreenMethodInfo            ,
#endif
    windowIsFullscreen                      ,


-- ** isMaximized #method:isMaximized#

#if defined(ENABLE_OVERLOADING)
    WindowIsMaximizedMethodInfo             ,
#endif
    windowIsMaximized                       ,


-- ** isSuspended #method:isSuspended#

#if defined(ENABLE_OVERLOADING)
    WindowIsSuspendedMethodInfo             ,
#endif
    windowIsSuspended                       ,


-- ** listToplevels #method:listToplevels#

    windowListToplevels                     ,


-- ** maximize #method:maximize#

#if defined(ENABLE_OVERLOADING)
    WindowMaximizeMethodInfo                ,
#endif
    windowMaximize                          ,


-- ** minimize #method:minimize#

#if defined(ENABLE_OVERLOADING)
    WindowMinimizeMethodInfo                ,
#endif
    windowMinimize                          ,


-- ** new #method:new#

    windowNew                               ,


-- ** present #method:present#

#if defined(ENABLE_OVERLOADING)
    WindowPresentMethodInfo                 ,
#endif
    windowPresent                           ,


-- ** presentWithTime #method:presentWithTime#

#if defined(ENABLE_OVERLOADING)
    WindowPresentWithTimeMethodInfo         ,
#endif
    windowPresentWithTime                   ,


-- ** setApplication #method:setApplication#

#if defined(ENABLE_OVERLOADING)
    WindowSetApplicationMethodInfo          ,
#endif
    windowSetApplication                    ,


-- ** setAutoStartupNotification #method:setAutoStartupNotification#

    windowSetAutoStartupNotification        ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    WindowSetChildMethodInfo                ,
#endif
    windowSetChild                          ,


-- ** setDecorated #method:setDecorated#

#if defined(ENABLE_OVERLOADING)
    WindowSetDecoratedMethodInfo            ,
#endif
    windowSetDecorated                      ,


-- ** setDefaultIconName #method:setDefaultIconName#

    windowSetDefaultIconName                ,


-- ** setDefaultSize #method:setDefaultSize#

#if defined(ENABLE_OVERLOADING)
    WindowSetDefaultSizeMethodInfo          ,
#endif
    windowSetDefaultSize                    ,


-- ** setDefaultWidget #method:setDefaultWidget#

#if defined(ENABLE_OVERLOADING)
    WindowSetDefaultWidgetMethodInfo        ,
#endif
    windowSetDefaultWidget                  ,


-- ** setDeletable #method:setDeletable#

#if defined(ENABLE_OVERLOADING)
    WindowSetDeletableMethodInfo            ,
#endif
    windowSetDeletable                      ,


-- ** setDestroyWithParent #method:setDestroyWithParent#

#if defined(ENABLE_OVERLOADING)
    WindowSetDestroyWithParentMethodInfo    ,
#endif
    windowSetDestroyWithParent              ,


-- ** setDisplay #method:setDisplay#

#if defined(ENABLE_OVERLOADING)
    WindowSetDisplayMethodInfo              ,
#endif
    windowSetDisplay                        ,


-- ** setFocus #method:setFocus#

#if defined(ENABLE_OVERLOADING)
    WindowSetFocusMethodInfo                ,
#endif
    windowSetFocus                          ,


-- ** setFocusVisible #method:setFocusVisible#

#if defined(ENABLE_OVERLOADING)
    WindowSetFocusVisibleMethodInfo         ,
#endif
    windowSetFocusVisible                   ,


-- ** setGravity #method:setGravity#

#if defined(ENABLE_OVERLOADING)
    WindowSetGravityMethodInfo              ,
#endif
    windowSetGravity                        ,


-- ** setHandleMenubarAccel #method:setHandleMenubarAccel#

#if defined(ENABLE_OVERLOADING)
    WindowSetHandleMenubarAccelMethodInfo   ,
#endif
    windowSetHandleMenubarAccel             ,


-- ** setHideOnClose #method:setHideOnClose#

#if defined(ENABLE_OVERLOADING)
    WindowSetHideOnCloseMethodInfo          ,
#endif
    windowSetHideOnClose                    ,


-- ** setIconName #method:setIconName#

#if defined(ENABLE_OVERLOADING)
    WindowSetIconNameMethodInfo             ,
#endif
    windowSetIconName                       ,


-- ** setInteractiveDebugging #method:setInteractiveDebugging#

    windowSetInteractiveDebugging           ,


-- ** setMnemonicsVisible #method:setMnemonicsVisible#

#if defined(ENABLE_OVERLOADING)
    WindowSetMnemonicsVisibleMethodInfo     ,
#endif
    windowSetMnemonicsVisible               ,


-- ** setModal #method:setModal#

#if defined(ENABLE_OVERLOADING)
    WindowSetModalMethodInfo                ,
#endif
    windowSetModal                          ,


-- ** setResizable #method:setResizable#

#if defined(ENABLE_OVERLOADING)
    WindowSetResizableMethodInfo            ,
#endif
    windowSetResizable                      ,


-- ** setStartupId #method:setStartupId#

#if defined(ENABLE_OVERLOADING)
    WindowSetStartupIdMethodInfo            ,
#endif
    windowSetStartupId                      ,


-- ** setTitle #method:setTitle#

#if defined(ENABLE_OVERLOADING)
    WindowSetTitleMethodInfo                ,
#endif
    windowSetTitle                          ,


-- ** setTitlebar #method:setTitlebar#

#if defined(ENABLE_OVERLOADING)
    WindowSetTitlebarMethodInfo             ,
#endif
    windowSetTitlebar                       ,


-- ** setTransientFor #method:setTransientFor#

#if defined(ENABLE_OVERLOADING)
    WindowSetTransientForMethodInfo         ,
#endif
    windowSetTransientFor                   ,


-- ** unfullscreen #method:unfullscreen#

#if defined(ENABLE_OVERLOADING)
    WindowUnfullscreenMethodInfo            ,
#endif
    windowUnfullscreen                      ,


-- ** unmaximize #method:unmaximize#

#if defined(ENABLE_OVERLOADING)
    WindowUnmaximizeMethodInfo              ,
#endif
    windowUnmaximize                        ,


-- ** unminimize #method:unminimize#

#if defined(ENABLE_OVERLOADING)
    WindowUnminimizeMethodInfo              ,
#endif
    windowUnminimize                        ,




 -- * Properties


-- ** application #attr:application#
-- | The @GtkApplication@ associated with the window.
-- 
-- The application will be kept alive for at least as long as it
-- has any windows associated with it (see 'GI.Gio.Objects.Application.applicationHold'
-- for a way to keep it alive without windows).
-- 
-- Normally, the connection between the application and the window
-- will remain until the window is destroyed, but you can explicitly
-- remove it by setting the this property to @NULL@.

#if defined(ENABLE_OVERLOADING)
    WindowApplicationPropertyInfo           ,
#endif
    clearWindowApplication                  ,
    constructWindowApplication              ,
    getWindowApplication                    ,
    setWindowApplication                    ,
#if defined(ENABLE_OVERLOADING)
    windowApplication                       ,
#endif


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    WindowChildPropertyInfo                 ,
#endif
    clearWindowChild                        ,
    constructWindowChild                    ,
    getWindowChild                          ,
    setWindowChild                          ,
#if defined(ENABLE_OVERLOADING)
    windowChild                             ,
#endif


-- ** decorated #attr:decorated#
-- | Whether the window should have a frame (also known as *decorations*).

#if defined(ENABLE_OVERLOADING)
    WindowDecoratedPropertyInfo             ,
#endif
    constructWindowDecorated                ,
    getWindowDecorated                      ,
    setWindowDecorated                      ,
#if defined(ENABLE_OVERLOADING)
    windowDecorated                         ,
#endif


-- ** defaultHeight #attr:defaultHeight#
-- | The default height of the window.

#if defined(ENABLE_OVERLOADING)
    WindowDefaultHeightPropertyInfo         ,
#endif
    constructWindowDefaultHeight            ,
    getWindowDefaultHeight                  ,
    setWindowDefaultHeight                  ,
#if defined(ENABLE_OVERLOADING)
    windowDefaultHeight                     ,
#endif


-- ** defaultWidget #attr:defaultWidget#
-- | The default widget.

#if defined(ENABLE_OVERLOADING)
    WindowDefaultWidgetPropertyInfo         ,
#endif
    clearWindowDefaultWidget                ,
    constructWindowDefaultWidget            ,
    getWindowDefaultWidget                  ,
    setWindowDefaultWidget                  ,
#if defined(ENABLE_OVERLOADING)
    windowDefaultWidget                     ,
#endif


-- ** defaultWidth #attr:defaultWidth#
-- | The default width of the window.

#if defined(ENABLE_OVERLOADING)
    WindowDefaultWidthPropertyInfo          ,
#endif
    constructWindowDefaultWidth             ,
    getWindowDefaultWidth                   ,
    setWindowDefaultWidth                   ,
#if defined(ENABLE_OVERLOADING)
    windowDefaultWidth                      ,
#endif


-- ** deletable #attr:deletable#
-- | Whether the window frame should have a close button.

#if defined(ENABLE_OVERLOADING)
    WindowDeletablePropertyInfo             ,
#endif
    constructWindowDeletable                ,
    getWindowDeletable                      ,
    setWindowDeletable                      ,
#if defined(ENABLE_OVERLOADING)
    windowDeletable                         ,
#endif


-- ** destroyWithParent #attr:destroyWithParent#
-- | If this window should be destroyed when the parent is destroyed.

#if defined(ENABLE_OVERLOADING)
    WindowDestroyWithParentPropertyInfo     ,
#endif
    constructWindowDestroyWithParent        ,
    getWindowDestroyWithParent              ,
    setWindowDestroyWithParent              ,
#if defined(ENABLE_OVERLOADING)
    windowDestroyWithParent                 ,
#endif


-- ** display #attr:display#
-- | The display that will display this window.

#if defined(ENABLE_OVERLOADING)
    WindowDisplayPropertyInfo               ,
#endif
    constructWindowDisplay                  ,
    getWindowDisplay                        ,
    setWindowDisplay                        ,
#if defined(ENABLE_OVERLOADING)
    windowDisplay                           ,
#endif


-- ** focusVisible #attr:focusVisible#
-- | Whether \'focus rectangles\' are currently visible in this window.
-- 
-- This property is maintained by GTK based on user input
-- and should not be set by applications.

#if defined(ENABLE_OVERLOADING)
    WindowFocusVisiblePropertyInfo          ,
#endif
    constructWindowFocusVisible             ,
    getWindowFocusVisible                   ,
    setWindowFocusVisible                   ,
#if defined(ENABLE_OVERLOADING)
    windowFocusVisible                      ,
#endif


-- ** focusWidget #attr:focusWidget#
-- | The focus widget.

#if defined(ENABLE_OVERLOADING)
    WindowFocusWidgetPropertyInfo           ,
#endif
    clearWindowFocusWidget                  ,
    constructWindowFocusWidget              ,
    getWindowFocusWidget                    ,
    setWindowFocusWidget                    ,
#if defined(ENABLE_OVERLOADING)
    windowFocusWidget                       ,
#endif


-- ** fullscreened #attr:fullscreened#
-- | Whether the window is fullscreen.
-- 
-- Setting this property is the equivalent of calling
-- 'GI.Gtk.Objects.Window.windowFullscreen' or 'GI.Gtk.Objects.Window.windowUnfullscreen';
-- either operation is asynchronous, which means you will need to
-- connect to the [notify](#g:signal:notify) signal in order to know whether the
-- operation was successful.

#if defined(ENABLE_OVERLOADING)
    WindowFullscreenedPropertyInfo          ,
#endif
    constructWindowFullscreened             ,
    getWindowFullscreened                   ,
    setWindowFullscreened                   ,
#if defined(ENABLE_OVERLOADING)
    windowFullscreened                      ,
#endif


-- ** gravity #attr:gravity#
-- | The gravity to use when resizing the window programmatically.
-- 
-- Gravity describes which point of the window we want to keep
-- fixed (meaning that the window will grow in the opposite direction).
-- For example, a gravity of @GTK_WINDOW_GRAVITY_TOP_RIGHT@ means that we
-- want the to fix top right corner of the window.
-- 
-- /Since: 4.20/

#if defined(ENABLE_OVERLOADING)
    WindowGravityPropertyInfo               ,
#endif
    constructWindowGravity                  ,
    getWindowGravity                        ,
    setWindowGravity                        ,
#if defined(ENABLE_OVERLOADING)
    windowGravity                           ,
#endif


-- ** handleMenubarAccel #attr:handleMenubarAccel#
-- | Whether the window frame should handle \<kbd>F10\<\/kbd> for activating
-- menubars.
-- 
-- /Since: 4.2/

#if defined(ENABLE_OVERLOADING)
    WindowHandleMenubarAccelPropertyInfo    ,
#endif
    constructWindowHandleMenubarAccel       ,
    getWindowHandleMenubarAccel             ,
    setWindowHandleMenubarAccel             ,
#if defined(ENABLE_OVERLOADING)
    windowHandleMenubarAccel                ,
#endif


-- ** hideOnClose #attr:hideOnClose#
-- | If this window should be hidden instead of destroyed when the user clicks
-- the close button.

#if defined(ENABLE_OVERLOADING)
    WindowHideOnClosePropertyInfo           ,
#endif
    constructWindowHideOnClose              ,
    getWindowHideOnClose                    ,
    setWindowHideOnClose                    ,
#if defined(ENABLE_OVERLOADING)
    windowHideOnClose                       ,
#endif


-- ** iconName #attr:iconName#
-- | Specifies the name of the themed icon to use as the window icon.
-- 
-- See t'GI.Gtk.Objects.IconTheme.IconTheme' for more details.

#if defined(ENABLE_OVERLOADING)
    WindowIconNamePropertyInfo              ,
#endif
    clearWindowIconName                     ,
    constructWindowIconName                 ,
    getWindowIconName                       ,
    setWindowIconName                       ,
#if defined(ENABLE_OVERLOADING)
    windowIconName                          ,
#endif


-- ** isActive #attr:isActive#
-- | Whether the toplevel is the currently active window.

#if defined(ENABLE_OVERLOADING)
    WindowIsActivePropertyInfo              ,
#endif
    getWindowIsActive                       ,


-- ** maximized #attr:maximized#
-- | Whether the window is maximized.
-- 
-- Setting this property is the equivalent of calling
-- 'GI.Gtk.Objects.Window.windowMaximize' or 'GI.Gtk.Objects.Window.windowUnmaximize';
-- either operation is asynchronous, which means you will need to
-- connect to the [notify](#g:signal:notify) signal in order to know whether the
-- operation was successful.

#if defined(ENABLE_OVERLOADING)
    WindowMaximizedPropertyInfo             ,
#endif
    constructWindowMaximized                ,
    getWindowMaximized                      ,
    setWindowMaximized                      ,
#if defined(ENABLE_OVERLOADING)
    windowMaximized                         ,
#endif


-- ** mnemonicsVisible #attr:mnemonicsVisible#
-- | Whether mnemonics are currently visible in this window.
-- 
-- This property is maintained by GTK based on user input,
-- and should not be set by applications.

#if defined(ENABLE_OVERLOADING)
    WindowMnemonicsVisiblePropertyInfo      ,
#endif
    constructWindowMnemonicsVisible         ,
    getWindowMnemonicsVisible               ,
    setWindowMnemonicsVisible               ,
#if defined(ENABLE_OVERLOADING)
    windowMnemonicsVisible                  ,
#endif


-- ** modal #attr:modal#
-- | If true, the window is modal.

#if defined(ENABLE_OVERLOADING)
    WindowModalPropertyInfo                 ,
#endif
    constructWindowModal                    ,
    getWindowModal                          ,
    setWindowModal                          ,
#if defined(ENABLE_OVERLOADING)
    windowModal                             ,
#endif


-- ** resizable #attr:resizable#
-- | If true, users can resize the window.

#if defined(ENABLE_OVERLOADING)
    WindowResizablePropertyInfo             ,
#endif
    constructWindowResizable                ,
    getWindowResizable                      ,
    setWindowResizable                      ,
#if defined(ENABLE_OVERLOADING)
    windowResizable                         ,
#endif


-- ** startupId #attr:startupId#
-- | A write-only property for setting window\'s startup notification identifier.

#if defined(ENABLE_OVERLOADING)
    WindowStartupIdPropertyInfo             ,
#endif
    constructWindowStartupId                ,
    setWindowStartupId                      ,
#if defined(ENABLE_OVERLOADING)
    windowStartupId                         ,
#endif


-- ** suspended #attr:suspended#
-- | Whether the window is suspended.
-- 
-- See 'GI.Gtk.Objects.Window.windowIsSuspended' for details about what suspended means.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    WindowSuspendedPropertyInfo             ,
#endif
    getWindowSuspended                      ,
#if defined(ENABLE_OVERLOADING)
    windowSuspended                         ,
#endif


-- ** title #attr:title#
-- | The title of the window.

#if defined(ENABLE_OVERLOADING)
    WindowTitlePropertyInfo                 ,
#endif
    clearWindowTitle                        ,
    constructWindowTitle                    ,
    getWindowTitle                          ,
    setWindowTitle                          ,
#if defined(ENABLE_OVERLOADING)
    windowTitle                             ,
#endif


-- ** titlebar #attr:titlebar#
-- | The titlebar widget.
-- 
-- /Since: 4.6/

#if defined(ENABLE_OVERLOADING)
    WindowTitlebarPropertyInfo              ,
#endif
    clearWindowTitlebar                     ,
    constructWindowTitlebar                 ,
    getWindowTitlebar                       ,
    setWindowTitlebar                       ,
#if defined(ENABLE_OVERLOADING)
    windowTitlebar                          ,
#endif


-- ** transientFor #attr:transientFor#
-- | The transient parent of the window.

#if defined(ENABLE_OVERLOADING)
    WindowTransientForPropertyInfo          ,
#endif
    clearWindowTransientFor                 ,
    constructWindowTransientFor             ,
    getWindowTransientFor                   ,
    setWindowTransientFor                   ,
#if defined(ENABLE_OVERLOADING)
    windowTransientFor                      ,
#endif




 -- * Signals


-- ** activateDefault #signal:activateDefault#

    WindowActivateDefaultCallback           ,
#if defined(ENABLE_OVERLOADING)
    WindowActivateDefaultSignalInfo         ,
#endif
    afterWindowActivateDefault              ,
    onWindowActivateDefault                 ,


-- ** activateFocus #signal:activateFocus#

    WindowActivateFocusCallback             ,
#if defined(ENABLE_OVERLOADING)
    WindowActivateFocusSignalInfo           ,
#endif
    afterWindowActivateFocus                ,
    onWindowActivateFocus                   ,


-- ** closeRequest #signal:closeRequest#

    WindowCloseRequestCallback              ,
#if defined(ENABLE_OVERLOADING)
    WindowCloseRequestSignalInfo            ,
#endif
    afterWindowCloseRequest                 ,
    onWindowCloseRequest                    ,


-- ** enableDebugging #signal:enableDebugging#

    WindowEnableDebuggingCallback           ,
#if defined(ENABLE_OVERLOADING)
    WindowEnableDebuggingSignalInfo         ,
#endif
    afterWindowEnableDebugging              ,
    onWindowEnableDebugging                 ,


-- ** keysChanged #signal:keysChanged#

    WindowKeysChangedCallback               ,
#if defined(ENABLE_OVERLOADING)
    WindowKeysChangedSignalInfo             ,
#endif
    afterWindowKeysChanged                  ,
    onWindowKeysChanged                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup

#endif

-- | Memory-managed wrapper type.
newtype Window = Window (SP.ManagedPtr Window)
    deriving (Eq)

instance SP.ManagedPtrNewtype Window where
    toManagedPtr (Window p) = p

foreign import ccall "gtk_window_get_type"
    c_gtk_window_get_type :: IO B.Types.GType

instance B.Types.TypedObject Window where
    glibType = c_gtk_window_get_type

instance B.Types.GObject Window

-- | Type class for types which can be safely cast to t'Window', for instance with `toWindow`.
class (SP.GObject o, O.IsDescendantOf Window o) => IsWindow o
instance (SP.GObject o, O.IsDescendantOf Window o) => IsWindow o

instance O.HasParentTypes Window
type instance O.ParentTypes Window = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Native.Native, Gtk.Root.Root, Gtk.ShortcutManager.ShortcutManager]

-- | Cast to t'Window', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toWindow :: (MIO.MonadIO m, IsWindow o) => o -> m Window
toWindow = MIO.liftIO . B.ManagedPtr.unsafeCastTo Window

-- | Convert t'Window' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Window) where
    gvalueGType_ = c_gtk_window_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Window)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Window)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Window ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveWindowMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveWindowMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveWindowMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveWindowMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveWindowMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveWindowMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveWindowMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveWindowMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveWindowMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveWindowMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveWindowMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveWindowMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveWindowMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveWindowMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveWindowMethod "close" o = WindowCloseMethodInfo
    ResolveWindowMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveWindowMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveWindowMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveWindowMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveWindowMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveWindowMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveWindowMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveWindowMethod "destroy" o = WindowDestroyMethodInfo
    ResolveWindowMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveWindowMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveWindowMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveWindowMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveWindowMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveWindowMethod "fullscreen" o = WindowFullscreenMethodInfo
    ResolveWindowMethod "fullscreenOnMonitor" o = WindowFullscreenOnMonitorMethodInfo
    ResolveWindowMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveWindowMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveWindowMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveWindowMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveWindowMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveWindowMethod "hasGroup" o = WindowHasGroupMethodInfo
    ResolveWindowMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveWindowMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveWindowMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveWindowMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveWindowMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveWindowMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveWindowMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveWindowMethod "isActive" o = WindowIsActiveMethodInfo
    ResolveWindowMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveWindowMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveWindowMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveWindowMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveWindowMethod "isFullscreen" o = WindowIsFullscreenMethodInfo
    ResolveWindowMethod "isMaximized" o = WindowIsMaximizedMethodInfo
    ResolveWindowMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveWindowMethod "isSuspended" o = WindowIsSuspendedMethodInfo
    ResolveWindowMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveWindowMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveWindowMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveWindowMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveWindowMethod "maximize" o = WindowMaximizeMethodInfo
    ResolveWindowMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveWindowMethod "minimize" o = WindowMinimizeMethodInfo
    ResolveWindowMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveWindowMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveWindowMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveWindowMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveWindowMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveWindowMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveWindowMethod "present" o = WindowPresentMethodInfo
    ResolveWindowMethod "presentWithTime" o = WindowPresentWithTimeMethodInfo
    ResolveWindowMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveWindowMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveWindowMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveWindowMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveWindowMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveWindowMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveWindowMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveWindowMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveWindowMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveWindowMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveWindowMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveWindowMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveWindowMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveWindowMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveWindowMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveWindowMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveWindowMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveWindowMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveWindowMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveWindowMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveWindowMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveWindowMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveWindowMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveWindowMethod "unfullscreen" o = WindowUnfullscreenMethodInfo
    ResolveWindowMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveWindowMethod "unmaximize" o = WindowUnmaximizeMethodInfo
    ResolveWindowMethod "unminimize" o = WindowUnminimizeMethodInfo
    ResolveWindowMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveWindowMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveWindowMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveWindowMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveWindowMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveWindowMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveWindowMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveWindowMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveWindowMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveWindowMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveWindowMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveWindowMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveWindowMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveWindowMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveWindowMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveWindowMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveWindowMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveWindowMethod "getApplication" o = WindowGetApplicationMethodInfo
    ResolveWindowMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveWindowMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveWindowMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveWindowMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveWindowMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveWindowMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveWindowMethod "getChild" o = WindowGetChildMethodInfo
    ResolveWindowMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveWindowMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveWindowMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveWindowMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveWindowMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveWindowMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveWindowMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveWindowMethod "getDecorated" o = WindowGetDecoratedMethodInfo
    ResolveWindowMethod "getDefaultSize" o = WindowGetDefaultSizeMethodInfo
    ResolveWindowMethod "getDefaultWidget" o = WindowGetDefaultWidgetMethodInfo
    ResolveWindowMethod "getDeletable" o = WindowGetDeletableMethodInfo
    ResolveWindowMethod "getDestroyWithParent" o = WindowGetDestroyWithParentMethodInfo
    ResolveWindowMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveWindowMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveWindowMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveWindowMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveWindowMethod "getFocus" o = WindowGetFocusMethodInfo
    ResolveWindowMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveWindowMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveWindowMethod "getFocusVisible" o = WindowGetFocusVisibleMethodInfo
    ResolveWindowMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveWindowMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveWindowMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveWindowMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveWindowMethod "getGravity" o = WindowGetGravityMethodInfo
    ResolveWindowMethod "getGroup" o = WindowGetGroupMethodInfo
    ResolveWindowMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveWindowMethod "getHandleMenubarAccel" o = WindowGetHandleMenubarAccelMethodInfo
    ResolveWindowMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveWindowMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveWindowMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveWindowMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveWindowMethod "getHideOnClose" o = WindowGetHideOnCloseMethodInfo
    ResolveWindowMethod "getIconName" o = WindowGetIconNameMethodInfo
    ResolveWindowMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveWindowMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveWindowMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveWindowMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveWindowMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveWindowMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveWindowMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveWindowMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveWindowMethod "getMnemonicsVisible" o = WindowGetMnemonicsVisibleMethodInfo
    ResolveWindowMethod "getModal" o = WindowGetModalMethodInfo
    ResolveWindowMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveWindowMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveWindowMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveWindowMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveWindowMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveWindowMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveWindowMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveWindowMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveWindowMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveWindowMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveWindowMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveWindowMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveWindowMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveWindowMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveWindowMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveWindowMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveWindowMethod "getRenderer" o = Gtk.Native.NativeGetRendererMethodInfo
    ResolveWindowMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveWindowMethod "getResizable" o = WindowGetResizableMethodInfo
    ResolveWindowMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveWindowMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveWindowMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveWindowMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveWindowMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveWindowMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveWindowMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveWindowMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveWindowMethod "getSurface" o = Gtk.Native.NativeGetSurfaceMethodInfo
    ResolveWindowMethod "getSurfaceTransform" o = Gtk.Native.NativeGetSurfaceTransformMethodInfo
    ResolveWindowMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveWindowMethod "getTitle" o = WindowGetTitleMethodInfo
    ResolveWindowMethod "getTitlebar" o = WindowGetTitlebarMethodInfo
    ResolveWindowMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveWindowMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveWindowMethod "getTransientFor" o = WindowGetTransientForMethodInfo
    ResolveWindowMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveWindowMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveWindowMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveWindowMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveWindowMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveWindowMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveWindowMethod "setApplication" o = WindowSetApplicationMethodInfo
    ResolveWindowMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveWindowMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveWindowMethod "setChild" o = WindowSetChildMethodInfo
    ResolveWindowMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveWindowMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveWindowMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveWindowMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveWindowMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveWindowMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveWindowMethod "setDecorated" o = WindowSetDecoratedMethodInfo
    ResolveWindowMethod "setDefaultSize" o = WindowSetDefaultSizeMethodInfo
    ResolveWindowMethod "setDefaultWidget" o = WindowSetDefaultWidgetMethodInfo
    ResolveWindowMethod "setDeletable" o = WindowSetDeletableMethodInfo
    ResolveWindowMethod "setDestroyWithParent" o = WindowSetDestroyWithParentMethodInfo
    ResolveWindowMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveWindowMethod "setDisplay" o = WindowSetDisplayMethodInfo
    ResolveWindowMethod "setFocus" o = WindowSetFocusMethodInfo
    ResolveWindowMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveWindowMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveWindowMethod "setFocusVisible" o = WindowSetFocusVisibleMethodInfo
    ResolveWindowMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveWindowMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveWindowMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveWindowMethod "setGravity" o = WindowSetGravityMethodInfo
    ResolveWindowMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveWindowMethod "setHandleMenubarAccel" o = WindowSetHandleMenubarAccelMethodInfo
    ResolveWindowMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveWindowMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveWindowMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveWindowMethod "setHideOnClose" o = WindowSetHideOnCloseMethodInfo
    ResolveWindowMethod "setIconName" o = WindowSetIconNameMethodInfo
    ResolveWindowMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveWindowMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveWindowMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveWindowMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveWindowMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveWindowMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveWindowMethod "setMnemonicsVisible" o = WindowSetMnemonicsVisibleMethodInfo
    ResolveWindowMethod "setModal" o = WindowSetModalMethodInfo
    ResolveWindowMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveWindowMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveWindowMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveWindowMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveWindowMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveWindowMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveWindowMethod "setResizable" o = WindowSetResizableMethodInfo
    ResolveWindowMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveWindowMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveWindowMethod "setStartupId" o = WindowSetStartupIdMethodInfo
    ResolveWindowMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveWindowMethod "setTitle" o = WindowSetTitleMethodInfo
    ResolveWindowMethod "setTitlebar" o = WindowSetTitlebarMethodInfo
    ResolveWindowMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveWindowMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveWindowMethod "setTransientFor" o = WindowSetTransientForMethodInfo
    ResolveWindowMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveWindowMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveWindowMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveWindowMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveWindowMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveWindowMethod t Window, O.OverloadedMethod info Window p) => OL.IsLabel t (Window -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveWindowMethod t Window, O.OverloadedMethod info Window p, R.HasField t Window p) => R.HasField t Window p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveWindowMethod t Window, O.OverloadedMethodInfo info Window) => OL.IsLabel t (O.MethodProxy info Window) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Window::activate-default
-- | Emitted when the user activates the default widget.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The keybindings for this signal are all forms of the \<kbd>Enter\<\/kbd> key.
type WindowActivateDefaultCallback =
    IO ()

type C_WindowActivateDefaultCallback =
    Ptr Window ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_WindowActivateDefaultCallback`.
foreign import ccall "wrapper"
    mk_WindowActivateDefaultCallback :: C_WindowActivateDefaultCallback -> IO (FunPtr C_WindowActivateDefaultCallback)

wrap_WindowActivateDefaultCallback :: 
    GObject a => (a -> WindowActivateDefaultCallback) ->
    C_WindowActivateDefaultCallback
wrap_WindowActivateDefaultCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activateDefault](#signal:activateDefault) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' window #activateDefault callback
-- @
-- 
-- 
onWindowActivateDefault :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowActivateDefaultCallback) -> m SignalHandlerId
onWindowActivateDefault obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowActivateDefaultCallback wrapped
    wrapped'' <- mk_WindowActivateDefaultCallback wrapped'
    connectSignalFunPtr obj "activate-default" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activateDefault](#signal:activateDefault) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' window #activateDefault callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterWindowActivateDefault :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowActivateDefaultCallback) -> m SignalHandlerId
afterWindowActivateDefault obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowActivateDefaultCallback wrapped
    wrapped'' <- mk_WindowActivateDefaultCallback wrapped'
    connectSignalFunPtr obj "activate-default" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data WindowActivateDefaultSignalInfo
instance SignalInfo WindowActivateDefaultSignalInfo where
    type HaskellCallbackType WindowActivateDefaultSignalInfo = WindowActivateDefaultCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_WindowActivateDefaultCallback cb
        cb'' <- mk_WindowActivateDefaultCallback cb'
        connectSignalFunPtr obj "activate-default" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window::activate-default"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:signal:activateDefault"})

#endif

-- signal Window::activate-focus
-- | Emitted when the user activates the currently focused
-- widget of /@window@/.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is \<kbd>␣\<\/kbd>.
type WindowActivateFocusCallback =
    IO ()

type C_WindowActivateFocusCallback =
    Ptr Window ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_WindowActivateFocusCallback`.
foreign import ccall "wrapper"
    mk_WindowActivateFocusCallback :: C_WindowActivateFocusCallback -> IO (FunPtr C_WindowActivateFocusCallback)

wrap_WindowActivateFocusCallback :: 
    GObject a => (a -> WindowActivateFocusCallback) ->
    C_WindowActivateFocusCallback
wrap_WindowActivateFocusCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activateFocus](#signal:activateFocus) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' window #activateFocus callback
-- @
-- 
-- 
onWindowActivateFocus :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowActivateFocusCallback) -> m SignalHandlerId
onWindowActivateFocus obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowActivateFocusCallback wrapped
    wrapped'' <- mk_WindowActivateFocusCallback wrapped'
    connectSignalFunPtr obj "activate-focus" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activateFocus](#signal:activateFocus) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' window #activateFocus callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterWindowActivateFocus :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowActivateFocusCallback) -> m SignalHandlerId
afterWindowActivateFocus obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowActivateFocusCallback wrapped
    wrapped'' <- mk_WindowActivateFocusCallback wrapped'
    connectSignalFunPtr obj "activate-focus" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data WindowActivateFocusSignalInfo
instance SignalInfo WindowActivateFocusSignalInfo where
    type HaskellCallbackType WindowActivateFocusSignalInfo = WindowActivateFocusCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_WindowActivateFocusCallback cb
        cb'' <- mk_WindowActivateFocusCallback cb'
        connectSignalFunPtr obj "activate-focus" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window::activate-focus"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:signal:activateFocus"})

#endif

-- signal Window::close-request
-- | Emitted when the user clicks on the close button of the window.
type WindowCloseRequestCallback =
    IO Bool
    -- ^ __Returns:__ true to stop other handlers from being invoked for the signal

type C_WindowCloseRequestCallback =
    Ptr Window ->                           -- object
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_WindowCloseRequestCallback`.
foreign import ccall "wrapper"
    mk_WindowCloseRequestCallback :: C_WindowCloseRequestCallback -> IO (FunPtr C_WindowCloseRequestCallback)

wrap_WindowCloseRequestCallback :: 
    GObject a => (a -> WindowCloseRequestCallback) ->
    C_WindowCloseRequestCallback
wrap_WindowCloseRequestCallback gi'cb gi'selfPtr _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [closeRequest](#signal:closeRequest) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' window #closeRequest callback
-- @
-- 
-- 
onWindowCloseRequest :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowCloseRequestCallback) -> m SignalHandlerId
onWindowCloseRequest obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowCloseRequestCallback wrapped
    wrapped'' <- mk_WindowCloseRequestCallback wrapped'
    connectSignalFunPtr obj "close-request" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [closeRequest](#signal:closeRequest) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' window #closeRequest callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterWindowCloseRequest :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowCloseRequestCallback) -> m SignalHandlerId
afterWindowCloseRequest obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowCloseRequestCallback wrapped
    wrapped'' <- mk_WindowCloseRequestCallback wrapped'
    connectSignalFunPtr obj "close-request" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data WindowCloseRequestSignalInfo
instance SignalInfo WindowCloseRequestSignalInfo where
    type HaskellCallbackType WindowCloseRequestSignalInfo = WindowCloseRequestCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_WindowCloseRequestCallback cb
        cb'' <- mk_WindowCloseRequestCallback cb'
        connectSignalFunPtr obj "close-request" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window::close-request"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:signal:closeRequest"})

#endif

-- signal Window::enable-debugging
-- | Emitted when the user enables or disables interactive debugging.
-- 
-- When /@toggle@/ is true, interactive debugging is toggled on or off,
-- when it is false, the debugger will be pointed at the widget
-- under the pointer.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default bindings for this signal are
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Shift\<\/kbd>+\<kbd>I\<\/kbd> and
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Shift\<\/kbd>+\<kbd>D\<\/kbd>.
type WindowEnableDebuggingCallback =
    Bool
    -- ^ /@toggle@/: toggle the debugger
    -> IO Bool
    -- ^ __Returns:__ true if the key binding was handled

type C_WindowEnableDebuggingCallback =
    Ptr Window ->                           -- object
    CInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_WindowEnableDebuggingCallback`.
foreign import ccall "wrapper"
    mk_WindowEnableDebuggingCallback :: C_WindowEnableDebuggingCallback -> IO (FunPtr C_WindowEnableDebuggingCallback)

wrap_WindowEnableDebuggingCallback :: 
    GObject a => (a -> WindowEnableDebuggingCallback) ->
    C_WindowEnableDebuggingCallback
wrap_WindowEnableDebuggingCallback gi'cb gi'selfPtr toggle _ = do
    let toggle' = (/= 0) toggle
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  toggle'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [enableDebugging](#signal:enableDebugging) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' window #enableDebugging callback
-- @
-- 
-- 
onWindowEnableDebugging :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowEnableDebuggingCallback) -> m SignalHandlerId
onWindowEnableDebugging obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowEnableDebuggingCallback wrapped
    wrapped'' <- mk_WindowEnableDebuggingCallback wrapped'
    connectSignalFunPtr obj "enable-debugging" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [enableDebugging](#signal:enableDebugging) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' window #enableDebugging callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterWindowEnableDebugging :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowEnableDebuggingCallback) -> m SignalHandlerId
afterWindowEnableDebugging obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowEnableDebuggingCallback wrapped
    wrapped'' <- mk_WindowEnableDebuggingCallback wrapped'
    connectSignalFunPtr obj "enable-debugging" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data WindowEnableDebuggingSignalInfo
instance SignalInfo WindowEnableDebuggingSignalInfo where
    type HaskellCallbackType WindowEnableDebuggingSignalInfo = WindowEnableDebuggingCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_WindowEnableDebuggingCallback cb
        cb'' <- mk_WindowEnableDebuggingCallback cb'
        connectSignalFunPtr obj "enable-debugging" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window::enable-debugging"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:signal:enableDebugging"})

#endif

-- signal Window::keys-changed
{-# DEPRECATED WindowKeysChangedCallback ["(Since version 4.10)","Use t'GI.Gtk.Objects.Shortcut.Shortcut' and t'GI.Gtk.Objects.EventController.EventController'","  to implement keyboard shortcuts"] #-}
-- | Emitted when the set of accelerators or mnemonics that
-- are associated with the window changes.
type WindowKeysChangedCallback =
    IO ()

type C_WindowKeysChangedCallback =
    Ptr Window ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_WindowKeysChangedCallback`.
foreign import ccall "wrapper"
    mk_WindowKeysChangedCallback :: C_WindowKeysChangedCallback -> IO (FunPtr C_WindowKeysChangedCallback)

wrap_WindowKeysChangedCallback :: 
    GObject a => (a -> WindowKeysChangedCallback) ->
    C_WindowKeysChangedCallback
wrap_WindowKeysChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [keysChanged](#signal:keysChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' window #keysChanged callback
-- @
-- 
-- 
onWindowKeysChanged :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowKeysChangedCallback) -> m SignalHandlerId
onWindowKeysChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowKeysChangedCallback wrapped
    wrapped'' <- mk_WindowKeysChangedCallback wrapped'
    connectSignalFunPtr obj "keys-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [keysChanged](#signal:keysChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' window #keysChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterWindowKeysChanged :: (IsWindow a, MonadIO m) => a -> ((?self :: a) => WindowKeysChangedCallback) -> m SignalHandlerId
afterWindowKeysChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_WindowKeysChangedCallback wrapped
    wrapped'' <- mk_WindowKeysChangedCallback wrapped'
    connectSignalFunPtr obj "keys-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data WindowKeysChangedSignalInfo
instance SignalInfo WindowKeysChangedSignalInfo where
    type HaskellCallbackType WindowKeysChangedSignalInfo = WindowKeysChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_WindowKeysChangedCallback cb
        cb'' <- mk_WindowKeysChangedCallback cb'
        connectSignalFunPtr obj "keys-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window::keys-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:signal:keysChanged"})

#endif

-- VVV Prop "application"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Application"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@application@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #application
-- @
getWindowApplication :: (MonadIO m, IsWindow o) => o -> m (Maybe Gtk.Application.Application)
getWindowApplication obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "application" Gtk.Application.Application

-- | Set the value of the “@application@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #application 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowApplication :: (MonadIO m, IsWindow o, Gtk.Application.IsApplication a) => o -> a -> m ()
setWindowApplication obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "application" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@application@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowApplication :: (IsWindow o, MIO.MonadIO m, Gtk.Application.IsApplication a) => a -> m (GValueConstruct o)
constructWindowApplication val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "application" (P.Just val)

-- | Set the value of the “@application@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #application
-- @
clearWindowApplication :: (MonadIO m, IsWindow o) => o -> m ()
clearWindowApplication obj = liftIO $ B.Properties.setObjectPropertyObject obj "application" (Nothing :: Maybe Gtk.Application.Application)

#if defined(ENABLE_OVERLOADING)
data WindowApplicationPropertyInfo
instance AttrInfo WindowApplicationPropertyInfo where
    type AttrAllowedOps WindowApplicationPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WindowApplicationPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowApplicationPropertyInfo = Gtk.Application.IsApplication
    type AttrTransferTypeConstraint WindowApplicationPropertyInfo = Gtk.Application.IsApplication
    type AttrTransferType WindowApplicationPropertyInfo = Gtk.Application.Application
    type AttrGetType WindowApplicationPropertyInfo = (Maybe Gtk.Application.Application)
    type AttrLabel WindowApplicationPropertyInfo = "application"
    type AttrOrigin WindowApplicationPropertyInfo = Window
    attrGet = getWindowApplication
    attrSet = setWindowApplication
    attrTransfer _ v = do
        unsafeCastTo Gtk.Application.Application v
    attrConstruct = constructWindowApplication
    attrClear = clearWindowApplication
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.application"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:application"
        })
#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #child
-- @
getWindowChild :: (MonadIO m, IsWindow o) => o -> m (Maybe Gtk.Widget.Widget)
getWindowChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowChild :: (MonadIO m, IsWindow o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setWindowChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowChild :: (IsWindow o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructWindowChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearWindowChild :: (MonadIO m, IsWindow o) => o -> m ()
clearWindowChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data WindowChildPropertyInfo
instance AttrInfo WindowChildPropertyInfo where
    type AttrAllowedOps WindowChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WindowChildPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint WindowChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType WindowChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType WindowChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel WindowChildPropertyInfo = "child"
    type AttrOrigin WindowChildPropertyInfo = Window
    attrGet = getWindowChild
    attrSet = setWindowChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructWindowChild
    attrClear = clearWindowChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:child"
        })
#endif

-- VVV Prop "decorated"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@decorated@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #decorated
-- @
getWindowDecorated :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowDecorated obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "decorated"

-- | Set the value of the “@decorated@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #decorated 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowDecorated :: (MonadIO m, IsWindow o) => o -> Bool -> m ()
setWindowDecorated obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "decorated" val

-- | Construct a t'GValueConstruct' with valid value for the “@decorated@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowDecorated :: (IsWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowDecorated val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "decorated" val

#if defined(ENABLE_OVERLOADING)
data WindowDecoratedPropertyInfo
instance AttrInfo WindowDecoratedPropertyInfo where
    type AttrAllowedOps WindowDecoratedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowDecoratedPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowDecoratedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowDecoratedPropertyInfo = (~) Bool
    type AttrTransferType WindowDecoratedPropertyInfo = Bool
    type AttrGetType WindowDecoratedPropertyInfo = Bool
    type AttrLabel WindowDecoratedPropertyInfo = "decorated"
    type AttrOrigin WindowDecoratedPropertyInfo = Window
    attrGet = getWindowDecorated
    attrSet = setWindowDecorated
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowDecorated
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.decorated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:decorated"
        })
#endif

-- VVV Prop "default-height"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@default-height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #defaultHeight
-- @
getWindowDefaultHeight :: (MonadIO m, IsWindow o) => o -> m Int32
getWindowDefaultHeight obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "default-height"

-- | Set the value of the “@default-height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #defaultHeight 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowDefaultHeight :: (MonadIO m, IsWindow o) => o -> Int32 -> m ()
setWindowDefaultHeight obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "default-height" val

-- | Construct a t'GValueConstruct' with valid value for the “@default-height@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowDefaultHeight :: (IsWindow o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructWindowDefaultHeight val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "default-height" val

#if defined(ENABLE_OVERLOADING)
data WindowDefaultHeightPropertyInfo
instance AttrInfo WindowDefaultHeightPropertyInfo where
    type AttrAllowedOps WindowDefaultHeightPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowDefaultHeightPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowDefaultHeightPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint WindowDefaultHeightPropertyInfo = (~) Int32
    type AttrTransferType WindowDefaultHeightPropertyInfo = Int32
    type AttrGetType WindowDefaultHeightPropertyInfo = Int32
    type AttrLabel WindowDefaultHeightPropertyInfo = "default-height"
    type AttrOrigin WindowDefaultHeightPropertyInfo = Window
    attrGet = getWindowDefaultHeight
    attrSet = setWindowDefaultHeight
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowDefaultHeight
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.defaultHeight"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:defaultHeight"
        })
#endif

-- VVV Prop "default-widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@default-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #defaultWidget
-- @
getWindowDefaultWidget :: (MonadIO m, IsWindow o) => o -> m (Maybe Gtk.Widget.Widget)
getWindowDefaultWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "default-widget" Gtk.Widget.Widget

-- | Set the value of the “@default-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #defaultWidget 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowDefaultWidget :: (MonadIO m, IsWindow o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setWindowDefaultWidget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "default-widget" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@default-widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowDefaultWidget :: (IsWindow o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructWindowDefaultWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "default-widget" (P.Just val)

-- | Set the value of the “@default-widget@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #defaultWidget
-- @
clearWindowDefaultWidget :: (MonadIO m, IsWindow o) => o -> m ()
clearWindowDefaultWidget obj = liftIO $ B.Properties.setObjectPropertyObject obj "default-widget" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data WindowDefaultWidgetPropertyInfo
instance AttrInfo WindowDefaultWidgetPropertyInfo where
    type AttrAllowedOps WindowDefaultWidgetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WindowDefaultWidgetPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowDefaultWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint WindowDefaultWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType WindowDefaultWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType WindowDefaultWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel WindowDefaultWidgetPropertyInfo = "default-widget"
    type AttrOrigin WindowDefaultWidgetPropertyInfo = Window
    attrGet = getWindowDefaultWidget
    attrSet = setWindowDefaultWidget
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructWindowDefaultWidget
    attrClear = clearWindowDefaultWidget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.defaultWidget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:defaultWidget"
        })
#endif

-- VVV Prop "default-width"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@default-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #defaultWidth
-- @
getWindowDefaultWidth :: (MonadIO m, IsWindow o) => o -> m Int32
getWindowDefaultWidth obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "default-width"

-- | Set the value of the “@default-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #defaultWidth 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowDefaultWidth :: (MonadIO m, IsWindow o) => o -> Int32 -> m ()
setWindowDefaultWidth obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "default-width" val

-- | Construct a t'GValueConstruct' with valid value for the “@default-width@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowDefaultWidth :: (IsWindow o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructWindowDefaultWidth val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "default-width" val

#if defined(ENABLE_OVERLOADING)
data WindowDefaultWidthPropertyInfo
instance AttrInfo WindowDefaultWidthPropertyInfo where
    type AttrAllowedOps WindowDefaultWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowDefaultWidthPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowDefaultWidthPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint WindowDefaultWidthPropertyInfo = (~) Int32
    type AttrTransferType WindowDefaultWidthPropertyInfo = Int32
    type AttrGetType WindowDefaultWidthPropertyInfo = Int32
    type AttrLabel WindowDefaultWidthPropertyInfo = "default-width"
    type AttrOrigin WindowDefaultWidthPropertyInfo = Window
    attrGet = getWindowDefaultWidth
    attrSet = setWindowDefaultWidth
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowDefaultWidth
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.defaultWidth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:defaultWidth"
        })
#endif

-- VVV Prop "deletable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@deletable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #deletable
-- @
getWindowDeletable :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowDeletable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "deletable"

-- | Set the value of the “@deletable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #deletable 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowDeletable :: (MonadIO m, IsWindow o) => o -> Bool -> m ()
setWindowDeletable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "deletable" val

-- | Construct a t'GValueConstruct' with valid value for the “@deletable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowDeletable :: (IsWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowDeletable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "deletable" val

#if defined(ENABLE_OVERLOADING)
data WindowDeletablePropertyInfo
instance AttrInfo WindowDeletablePropertyInfo where
    type AttrAllowedOps WindowDeletablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowDeletablePropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowDeletablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowDeletablePropertyInfo = (~) Bool
    type AttrTransferType WindowDeletablePropertyInfo = Bool
    type AttrGetType WindowDeletablePropertyInfo = Bool
    type AttrLabel WindowDeletablePropertyInfo = "deletable"
    type AttrOrigin WindowDeletablePropertyInfo = Window
    attrGet = getWindowDeletable
    attrSet = setWindowDeletable
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowDeletable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.deletable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:deletable"
        })
#endif

-- VVV Prop "destroy-with-parent"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@destroy-with-parent@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #destroyWithParent
-- @
getWindowDestroyWithParent :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowDestroyWithParent obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "destroy-with-parent"

-- | Set the value of the “@destroy-with-parent@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #destroyWithParent 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowDestroyWithParent :: (MonadIO m, IsWindow o) => o -> Bool -> m ()
setWindowDestroyWithParent obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "destroy-with-parent" val

-- | Construct a t'GValueConstruct' with valid value for the “@destroy-with-parent@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowDestroyWithParent :: (IsWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowDestroyWithParent val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "destroy-with-parent" val

#if defined(ENABLE_OVERLOADING)
data WindowDestroyWithParentPropertyInfo
instance AttrInfo WindowDestroyWithParentPropertyInfo where
    type AttrAllowedOps WindowDestroyWithParentPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowDestroyWithParentPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowDestroyWithParentPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowDestroyWithParentPropertyInfo = (~) Bool
    type AttrTransferType WindowDestroyWithParentPropertyInfo = Bool
    type AttrGetType WindowDestroyWithParentPropertyInfo = Bool
    type AttrLabel WindowDestroyWithParentPropertyInfo = "destroy-with-parent"
    type AttrOrigin WindowDestroyWithParentPropertyInfo = Window
    attrGet = getWindowDestroyWithParent
    attrSet = setWindowDestroyWithParent
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowDestroyWithParent
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.destroyWithParent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:destroyWithParent"
        })
#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #display
-- @
getWindowDisplay :: (MonadIO m, IsWindow o) => o -> m (Maybe Gdk.Display.Display)
getWindowDisplay obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Set the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #display 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowDisplay :: (MonadIO m, IsWindow o, Gdk.Display.IsDisplay a) => o -> a -> m ()
setWindowDisplay obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "display" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowDisplay :: (IsWindow o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructWindowDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data WindowDisplayPropertyInfo
instance AttrInfo WindowDisplayPropertyInfo where
    type AttrAllowedOps WindowDisplayPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowDisplayPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint WindowDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType WindowDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType WindowDisplayPropertyInfo = (Maybe Gdk.Display.Display)
    type AttrLabel WindowDisplayPropertyInfo = "display"
    type AttrOrigin WindowDisplayPropertyInfo = Window
    attrGet = getWindowDisplay
    attrSet = setWindowDisplay
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructWindowDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:display"
        })
#endif

-- VVV Prop "focus-visible"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@focus-visible@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #focusVisible
-- @
getWindowFocusVisible :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowFocusVisible obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "focus-visible"

-- | Set the value of the “@focus-visible@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #focusVisible 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowFocusVisible :: (MonadIO m, IsWindow o) => o -> Bool -> m ()
setWindowFocusVisible obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "focus-visible" val

-- | Construct a t'GValueConstruct' with valid value for the “@focus-visible@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowFocusVisible :: (IsWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowFocusVisible val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "focus-visible" val

#if defined(ENABLE_OVERLOADING)
data WindowFocusVisiblePropertyInfo
instance AttrInfo WindowFocusVisiblePropertyInfo where
    type AttrAllowedOps WindowFocusVisiblePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowFocusVisiblePropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowFocusVisiblePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowFocusVisiblePropertyInfo = (~) Bool
    type AttrTransferType WindowFocusVisiblePropertyInfo = Bool
    type AttrGetType WindowFocusVisiblePropertyInfo = Bool
    type AttrLabel WindowFocusVisiblePropertyInfo = "focus-visible"
    type AttrOrigin WindowFocusVisiblePropertyInfo = Window
    attrGet = getWindowFocusVisible
    attrSet = setWindowFocusVisible
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowFocusVisible
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.focusVisible"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:focusVisible"
        })
#endif

-- VVV Prop "focus-widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@focus-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #focusWidget
-- @
getWindowFocusWidget :: (MonadIO m, IsWindow o) => o -> m (Maybe Gtk.Widget.Widget)
getWindowFocusWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "focus-widget" Gtk.Widget.Widget

-- | Set the value of the “@focus-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #focusWidget 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowFocusWidget :: (MonadIO m, IsWindow o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setWindowFocusWidget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "focus-widget" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@focus-widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowFocusWidget :: (IsWindow o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructWindowFocusWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "focus-widget" (P.Just val)

-- | Set the value of the “@focus-widget@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #focusWidget
-- @
clearWindowFocusWidget :: (MonadIO m, IsWindow o) => o -> m ()
clearWindowFocusWidget obj = liftIO $ B.Properties.setObjectPropertyObject obj "focus-widget" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data WindowFocusWidgetPropertyInfo
instance AttrInfo WindowFocusWidgetPropertyInfo where
    type AttrAllowedOps WindowFocusWidgetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WindowFocusWidgetPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowFocusWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint WindowFocusWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType WindowFocusWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType WindowFocusWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel WindowFocusWidgetPropertyInfo = "focus-widget"
    type AttrOrigin WindowFocusWidgetPropertyInfo = Window
    attrGet = getWindowFocusWidget
    attrSet = setWindowFocusWidget
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructWindowFocusWidget
    attrClear = clearWindowFocusWidget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.focusWidget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:focusWidget"
        })
#endif

-- VVV Prop "fullscreened"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@fullscreened@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #fullscreened
-- @
getWindowFullscreened :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowFullscreened obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "fullscreened"

-- | Set the value of the “@fullscreened@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #fullscreened 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowFullscreened :: (MonadIO m, IsWindow o) => o -> Bool -> m ()
setWindowFullscreened obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "fullscreened" val

-- | Construct a t'GValueConstruct' with valid value for the “@fullscreened@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowFullscreened :: (IsWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowFullscreened val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "fullscreened" val

#if defined(ENABLE_OVERLOADING)
data WindowFullscreenedPropertyInfo
instance AttrInfo WindowFullscreenedPropertyInfo where
    type AttrAllowedOps WindowFullscreenedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowFullscreenedPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowFullscreenedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowFullscreenedPropertyInfo = (~) Bool
    type AttrTransferType WindowFullscreenedPropertyInfo = Bool
    type AttrGetType WindowFullscreenedPropertyInfo = Bool
    type AttrLabel WindowFullscreenedPropertyInfo = "fullscreened"
    type AttrOrigin WindowFullscreenedPropertyInfo = Window
    attrGet = getWindowFullscreened
    attrSet = setWindowFullscreened
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowFullscreened
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.fullscreened"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:fullscreened"
        })
#endif

-- VVV Prop "gravity"
   -- Type: TInterface (Name {namespace = "Gtk", name = "WindowGravity"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@gravity@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #gravity
-- @
getWindowGravity :: (MonadIO m, IsWindow o) => o -> m Gtk.Enums.WindowGravity
getWindowGravity obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "gravity"

-- | Set the value of the “@gravity@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #gravity 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowGravity :: (MonadIO m, IsWindow o) => o -> Gtk.Enums.WindowGravity -> m ()
setWindowGravity obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "gravity" val

-- | Construct a t'GValueConstruct' with valid value for the “@gravity@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowGravity :: (IsWindow o, MIO.MonadIO m) => Gtk.Enums.WindowGravity -> m (GValueConstruct o)
constructWindowGravity val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "gravity" val

#if defined(ENABLE_OVERLOADING)
data WindowGravityPropertyInfo
instance AttrInfo WindowGravityPropertyInfo where
    type AttrAllowedOps WindowGravityPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowGravityPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowGravityPropertyInfo = (~) Gtk.Enums.WindowGravity
    type AttrTransferTypeConstraint WindowGravityPropertyInfo = (~) Gtk.Enums.WindowGravity
    type AttrTransferType WindowGravityPropertyInfo = Gtk.Enums.WindowGravity
    type AttrGetType WindowGravityPropertyInfo = Gtk.Enums.WindowGravity
    type AttrLabel WindowGravityPropertyInfo = "gravity"
    type AttrOrigin WindowGravityPropertyInfo = Window
    attrGet = getWindowGravity
    attrSet = setWindowGravity
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowGravity
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.gravity"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:gravity"
        })
#endif

-- VVV Prop "handle-menubar-accel"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@handle-menubar-accel@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #handleMenubarAccel
-- @
getWindowHandleMenubarAccel :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowHandleMenubarAccel obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "handle-menubar-accel"

-- | Set the value of the “@handle-menubar-accel@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #handleMenubarAccel 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowHandleMenubarAccel :: (MonadIO m, IsWindow o) => o -> Bool -> m ()
setWindowHandleMenubarAccel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "handle-menubar-accel" val

-- | Construct a t'GValueConstruct' with valid value for the “@handle-menubar-accel@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowHandleMenubarAccel :: (IsWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowHandleMenubarAccel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "handle-menubar-accel" val

#if defined(ENABLE_OVERLOADING)
data WindowHandleMenubarAccelPropertyInfo
instance AttrInfo WindowHandleMenubarAccelPropertyInfo where
    type AttrAllowedOps WindowHandleMenubarAccelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowHandleMenubarAccelPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowHandleMenubarAccelPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowHandleMenubarAccelPropertyInfo = (~) Bool
    type AttrTransferType WindowHandleMenubarAccelPropertyInfo = Bool
    type AttrGetType WindowHandleMenubarAccelPropertyInfo = Bool
    type AttrLabel WindowHandleMenubarAccelPropertyInfo = "handle-menubar-accel"
    type AttrOrigin WindowHandleMenubarAccelPropertyInfo = Window
    attrGet = getWindowHandleMenubarAccel
    attrSet = setWindowHandleMenubarAccel
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowHandleMenubarAccel
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.handleMenubarAccel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:handleMenubarAccel"
        })
#endif

-- VVV Prop "hide-on-close"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@hide-on-close@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #hideOnClose
-- @
getWindowHideOnClose :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowHideOnClose obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "hide-on-close"

-- | Set the value of the “@hide-on-close@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #hideOnClose 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowHideOnClose :: (MonadIO m, IsWindow o) => o -> Bool -> m ()
setWindowHideOnClose obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "hide-on-close" val

-- | Construct a t'GValueConstruct' with valid value for the “@hide-on-close@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowHideOnClose :: (IsWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowHideOnClose val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "hide-on-close" val

#if defined(ENABLE_OVERLOADING)
data WindowHideOnClosePropertyInfo
instance AttrInfo WindowHideOnClosePropertyInfo where
    type AttrAllowedOps WindowHideOnClosePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowHideOnClosePropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowHideOnClosePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowHideOnClosePropertyInfo = (~) Bool
    type AttrTransferType WindowHideOnClosePropertyInfo = Bool
    type AttrGetType WindowHideOnClosePropertyInfo = Bool
    type AttrLabel WindowHideOnClosePropertyInfo = "hide-on-close"
    type AttrOrigin WindowHideOnClosePropertyInfo = Window
    attrGet = getWindowHideOnClose
    attrSet = setWindowHideOnClose
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowHideOnClose
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.hideOnClose"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:hideOnClose"
        })
#endif

-- VVV Prop "icon-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #iconName
-- @
getWindowIconName :: (MonadIO m, IsWindow o) => o -> m (Maybe T.Text)
getWindowIconName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "icon-name"

-- | Set the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #iconName 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowIconName :: (MonadIO m, IsWindow o) => o -> T.Text -> m ()
setWindowIconName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "icon-name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@icon-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowIconName :: (IsWindow o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructWindowIconName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "icon-name" (P.Just val)

-- | Set the value of the “@icon-name@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #iconName
-- @
clearWindowIconName :: (MonadIO m, IsWindow o) => o -> m ()
clearWindowIconName obj = liftIO $ B.Properties.setObjectPropertyString obj "icon-name" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data WindowIconNamePropertyInfo
instance AttrInfo WindowIconNamePropertyInfo where
    type AttrAllowedOps WindowIconNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WindowIconNamePropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowIconNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint WindowIconNamePropertyInfo = (~) T.Text
    type AttrTransferType WindowIconNamePropertyInfo = T.Text
    type AttrGetType WindowIconNamePropertyInfo = (Maybe T.Text)
    type AttrLabel WindowIconNamePropertyInfo = "icon-name"
    type AttrOrigin WindowIconNamePropertyInfo = Window
    attrGet = getWindowIconName
    attrSet = setWindowIconName
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowIconName
    attrClear = clearWindowIconName
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.iconName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:iconName"
        })
#endif

-- VVV Prop "is-active"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@is-active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #isActive
-- @
getWindowIsActive :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowIsActive obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-active"

#if defined(ENABLE_OVERLOADING)
data WindowIsActivePropertyInfo
instance AttrInfo WindowIsActivePropertyInfo where
    type AttrAllowedOps WindowIsActivePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint WindowIsActivePropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowIsActivePropertyInfo = (~) ()
    type AttrTransferTypeConstraint WindowIsActivePropertyInfo = (~) ()
    type AttrTransferType WindowIsActivePropertyInfo = ()
    type AttrGetType WindowIsActivePropertyInfo = Bool
    type AttrLabel WindowIsActivePropertyInfo = "is-active"
    type AttrOrigin WindowIsActivePropertyInfo = Window
    attrGet = getWindowIsActive
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.isActive"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:isActive"
        })
#endif

-- VVV Prop "maximized"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@maximized@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #maximized
-- @
getWindowMaximized :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowMaximized obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "maximized"

-- | Set the value of the “@maximized@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #maximized 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowMaximized :: (MonadIO m, IsWindow o) => o -> Bool -> m ()
setWindowMaximized obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "maximized" val

-- | Construct a t'GValueConstruct' with valid value for the “@maximized@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowMaximized :: (IsWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowMaximized val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "maximized" val

#if defined(ENABLE_OVERLOADING)
data WindowMaximizedPropertyInfo
instance AttrInfo WindowMaximizedPropertyInfo where
    type AttrAllowedOps WindowMaximizedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowMaximizedPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowMaximizedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowMaximizedPropertyInfo = (~) Bool
    type AttrTransferType WindowMaximizedPropertyInfo = Bool
    type AttrGetType WindowMaximizedPropertyInfo = Bool
    type AttrLabel WindowMaximizedPropertyInfo = "maximized"
    type AttrOrigin WindowMaximizedPropertyInfo = Window
    attrGet = getWindowMaximized
    attrSet = setWindowMaximized
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowMaximized
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.maximized"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:maximized"
        })
#endif

-- VVV Prop "mnemonics-visible"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@mnemonics-visible@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #mnemonicsVisible
-- @
getWindowMnemonicsVisible :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowMnemonicsVisible obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "mnemonics-visible"

-- | Set the value of the “@mnemonics-visible@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #mnemonicsVisible 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowMnemonicsVisible :: (MonadIO m, IsWindow o) => o -> Bool -> m ()
setWindowMnemonicsVisible obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "mnemonics-visible" val

-- | Construct a t'GValueConstruct' with valid value for the “@mnemonics-visible@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowMnemonicsVisible :: (IsWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowMnemonicsVisible val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "mnemonics-visible" val

#if defined(ENABLE_OVERLOADING)
data WindowMnemonicsVisiblePropertyInfo
instance AttrInfo WindowMnemonicsVisiblePropertyInfo where
    type AttrAllowedOps WindowMnemonicsVisiblePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowMnemonicsVisiblePropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowMnemonicsVisiblePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowMnemonicsVisiblePropertyInfo = (~) Bool
    type AttrTransferType WindowMnemonicsVisiblePropertyInfo = Bool
    type AttrGetType WindowMnemonicsVisiblePropertyInfo = Bool
    type AttrLabel WindowMnemonicsVisiblePropertyInfo = "mnemonics-visible"
    type AttrOrigin WindowMnemonicsVisiblePropertyInfo = Window
    attrGet = getWindowMnemonicsVisible
    attrSet = setWindowMnemonicsVisible
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowMnemonicsVisible
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.mnemonicsVisible"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:mnemonicsVisible"
        })
#endif

-- VVV Prop "modal"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #modal
-- @
getWindowModal :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowModal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "modal"

-- | Set the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #modal 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowModal :: (MonadIO m, IsWindow o) => o -> Bool -> m ()
setWindowModal obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "modal" val

-- | Construct a t'GValueConstruct' with valid value for the “@modal@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowModal :: (IsWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowModal val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "modal" val

#if defined(ENABLE_OVERLOADING)
data WindowModalPropertyInfo
instance AttrInfo WindowModalPropertyInfo where
    type AttrAllowedOps WindowModalPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowModalPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowModalPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowModalPropertyInfo = (~) Bool
    type AttrTransferType WindowModalPropertyInfo = Bool
    type AttrGetType WindowModalPropertyInfo = Bool
    type AttrLabel WindowModalPropertyInfo = "modal"
    type AttrOrigin WindowModalPropertyInfo = Window
    attrGet = getWindowModal
    attrSet = setWindowModal
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowModal
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.modal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:modal"
        })
#endif

-- VVV Prop "resizable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@resizable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #resizable
-- @
getWindowResizable :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowResizable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "resizable"

-- | Set the value of the “@resizable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #resizable 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowResizable :: (MonadIO m, IsWindow o) => o -> Bool -> m ()
setWindowResizable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "resizable" val

-- | Construct a t'GValueConstruct' with valid value for the “@resizable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowResizable :: (IsWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowResizable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "resizable" val

#if defined(ENABLE_OVERLOADING)
data WindowResizablePropertyInfo
instance AttrInfo WindowResizablePropertyInfo where
    type AttrAllowedOps WindowResizablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowResizablePropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowResizablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowResizablePropertyInfo = (~) Bool
    type AttrTransferType WindowResizablePropertyInfo = Bool
    type AttrGetType WindowResizablePropertyInfo = Bool
    type AttrLabel WindowResizablePropertyInfo = "resizable"
    type AttrOrigin WindowResizablePropertyInfo = Window
    attrGet = getWindowResizable
    attrSet = setWindowResizable
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowResizable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.resizable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:resizable"
        })
#endif

-- VVV Prop "startup-id"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Set the value of the “@startup-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #startupId 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowStartupId :: (MonadIO m, IsWindow o) => o -> T.Text -> m ()
setWindowStartupId obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "startup-id" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@startup-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowStartupId :: (IsWindow o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructWindowStartupId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "startup-id" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data WindowStartupIdPropertyInfo
instance AttrInfo WindowStartupIdPropertyInfo where
    type AttrAllowedOps WindowStartupIdPropertyInfo = '[ 'AttrSet, 'AttrConstruct]
    type AttrBaseTypeConstraint WindowStartupIdPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowStartupIdPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint WindowStartupIdPropertyInfo = (~) T.Text
    type AttrTransferType WindowStartupIdPropertyInfo = T.Text
    type AttrGetType WindowStartupIdPropertyInfo = ()
    type AttrLabel WindowStartupIdPropertyInfo = "startup-id"
    type AttrOrigin WindowStartupIdPropertyInfo = Window
    attrGet = undefined
    attrSet = setWindowStartupId
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowStartupId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.startupId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:startupId"
        })
#endif

-- VVV Prop "suspended"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@suspended@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #suspended
-- @
getWindowSuspended :: (MonadIO m, IsWindow o) => o -> m Bool
getWindowSuspended obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "suspended"

#if defined(ENABLE_OVERLOADING)
data WindowSuspendedPropertyInfo
instance AttrInfo WindowSuspendedPropertyInfo where
    type AttrAllowedOps WindowSuspendedPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint WindowSuspendedPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowSuspendedPropertyInfo = (~) ()
    type AttrTransferTypeConstraint WindowSuspendedPropertyInfo = (~) ()
    type AttrTransferType WindowSuspendedPropertyInfo = ()
    type AttrGetType WindowSuspendedPropertyInfo = Bool
    type AttrLabel WindowSuspendedPropertyInfo = "suspended"
    type AttrOrigin WindowSuspendedPropertyInfo = Window
    attrGet = getWindowSuspended
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.suspended"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:suspended"
        })
#endif

-- VVV Prop "title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #title
-- @
getWindowTitle :: (MonadIO m, IsWindow o) => o -> m (Maybe T.Text)
getWindowTitle obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "title"

-- | Set the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #title 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowTitle :: (MonadIO m, IsWindow o) => o -> T.Text -> m ()
setWindowTitle obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "title" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@title@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowTitle :: (IsWindow o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructWindowTitle val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "title" (P.Just val)

-- | Set the value of the “@title@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #title
-- @
clearWindowTitle :: (MonadIO m, IsWindow o) => o -> m ()
clearWindowTitle obj = liftIO $ B.Properties.setObjectPropertyString obj "title" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data WindowTitlePropertyInfo
instance AttrInfo WindowTitlePropertyInfo where
    type AttrAllowedOps WindowTitlePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WindowTitlePropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowTitlePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint WindowTitlePropertyInfo = (~) T.Text
    type AttrTransferType WindowTitlePropertyInfo = T.Text
    type AttrGetType WindowTitlePropertyInfo = (Maybe T.Text)
    type AttrLabel WindowTitlePropertyInfo = "title"
    type AttrOrigin WindowTitlePropertyInfo = Window
    attrGet = getWindowTitle
    attrSet = setWindowTitle
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowTitle
    attrClear = clearWindowTitle
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.title"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:title"
        })
#endif

-- VVV Prop "titlebar"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@titlebar@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #titlebar
-- @
getWindowTitlebar :: (MonadIO m, IsWindow o) => o -> m (Maybe Gtk.Widget.Widget)
getWindowTitlebar obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "titlebar" Gtk.Widget.Widget

-- | Set the value of the “@titlebar@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #titlebar 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowTitlebar :: (MonadIO m, IsWindow o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setWindowTitlebar obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "titlebar" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@titlebar@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowTitlebar :: (IsWindow o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructWindowTitlebar val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "titlebar" (P.Just val)

-- | Set the value of the “@titlebar@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #titlebar
-- @
clearWindowTitlebar :: (MonadIO m, IsWindow o) => o -> m ()
clearWindowTitlebar obj = liftIO $ B.Properties.setObjectPropertyObject obj "titlebar" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data WindowTitlebarPropertyInfo
instance AttrInfo WindowTitlebarPropertyInfo where
    type AttrAllowedOps WindowTitlebarPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WindowTitlebarPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowTitlebarPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint WindowTitlebarPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType WindowTitlebarPropertyInfo = Gtk.Widget.Widget
    type AttrGetType WindowTitlebarPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel WindowTitlebarPropertyInfo = "titlebar"
    type AttrOrigin WindowTitlebarPropertyInfo = Window
    attrGet = getWindowTitlebar
    attrSet = setWindowTitlebar
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructWindowTitlebar
    attrClear = clearWindowTitlebar
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.titlebar"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:titlebar"
        })
#endif

-- VVV Prop "transient-for"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Window"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@transient-for@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' window #transientFor
-- @
getWindowTransientFor :: (MonadIO m, IsWindow o) => o -> m (Maybe Window)
getWindowTransientFor obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "transient-for" Window

-- | Set the value of the “@transient-for@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' window [ #transientFor 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowTransientFor :: (MonadIO m, IsWindow o, IsWindow a) => o -> a -> m ()
setWindowTransientFor obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "transient-for" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@transient-for@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowTransientFor :: (IsWindow o, MIO.MonadIO m, IsWindow a) => a -> m (GValueConstruct o)
constructWindowTransientFor val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "transient-for" (P.Just val)

-- | Set the value of the “@transient-for@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #transientFor
-- @
clearWindowTransientFor :: (MonadIO m, IsWindow o) => o -> m ()
clearWindowTransientFor obj = liftIO $ B.Properties.setObjectPropertyObject obj "transient-for" (Nothing :: Maybe Window)

#if defined(ENABLE_OVERLOADING)
data WindowTransientForPropertyInfo
instance AttrInfo WindowTransientForPropertyInfo where
    type AttrAllowedOps WindowTransientForPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WindowTransientForPropertyInfo = IsWindow
    type AttrSetTypeConstraint WindowTransientForPropertyInfo = IsWindow
    type AttrTransferTypeConstraint WindowTransientForPropertyInfo = IsWindow
    type AttrTransferType WindowTransientForPropertyInfo = Window
    type AttrGetType WindowTransientForPropertyInfo = (Maybe Window)
    type AttrLabel WindowTransientForPropertyInfo = "transient-for"
    type AttrOrigin WindowTransientForPropertyInfo = Window
    attrGet = getWindowTransientFor
    attrSet = setWindowTransientFor
    attrTransfer _ v = do
        unsafeCastTo Window v
    attrConstruct = constructWindowTransientFor
    attrClear = clearWindowTransientFor
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.transientFor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#g:attr:transientFor"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Window
type instance O.AttributeList Window = WindowAttributeList
type WindowAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("application", WindowApplicationPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", WindowChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("decorated", WindowDecoratedPropertyInfo), '("defaultHeight", WindowDefaultHeightPropertyInfo), '("defaultWidget", WindowDefaultWidgetPropertyInfo), '("defaultWidth", WindowDefaultWidthPropertyInfo), '("deletable", WindowDeletablePropertyInfo), '("destroyWithParent", WindowDestroyWithParentPropertyInfo), '("display", WindowDisplayPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusVisible", WindowFocusVisiblePropertyInfo), '("focusWidget", WindowFocusWidgetPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("fullscreened", WindowFullscreenedPropertyInfo), '("gravity", WindowGravityPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("handleMenubarAccel", WindowHandleMenubarAccelPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hideOnClose", WindowHideOnClosePropertyInfo), '("iconName", WindowIconNamePropertyInfo), '("isActive", WindowIsActivePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maximized", WindowMaximizedPropertyInfo), '("mnemonicsVisible", WindowMnemonicsVisiblePropertyInfo), '("modal", WindowModalPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("resizable", WindowResizablePropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("startupId", WindowStartupIdPropertyInfo), '("suspended", WindowSuspendedPropertyInfo), '("title", WindowTitlePropertyInfo), '("titlebar", WindowTitlebarPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("transientFor", WindowTransientForPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
windowApplication :: AttrLabelProxy "application"
windowApplication = AttrLabelProxy

windowChild :: AttrLabelProxy "child"
windowChild = AttrLabelProxy

windowDecorated :: AttrLabelProxy "decorated"
windowDecorated = AttrLabelProxy

windowDefaultHeight :: AttrLabelProxy "defaultHeight"
windowDefaultHeight = AttrLabelProxy

windowDefaultWidget :: AttrLabelProxy "defaultWidget"
windowDefaultWidget = AttrLabelProxy

windowDefaultWidth :: AttrLabelProxy "defaultWidth"
windowDefaultWidth = AttrLabelProxy

windowDeletable :: AttrLabelProxy "deletable"
windowDeletable = AttrLabelProxy

windowDestroyWithParent :: AttrLabelProxy "destroyWithParent"
windowDestroyWithParent = AttrLabelProxy

windowDisplay :: AttrLabelProxy "display"
windowDisplay = AttrLabelProxy

windowFocusVisible :: AttrLabelProxy "focusVisible"
windowFocusVisible = AttrLabelProxy

windowFocusWidget :: AttrLabelProxy "focusWidget"
windowFocusWidget = AttrLabelProxy

windowFullscreened :: AttrLabelProxy "fullscreened"
windowFullscreened = AttrLabelProxy

windowGravity :: AttrLabelProxy "gravity"
windowGravity = AttrLabelProxy

windowHandleMenubarAccel :: AttrLabelProxy "handleMenubarAccel"
windowHandleMenubarAccel = AttrLabelProxy

windowHideOnClose :: AttrLabelProxy "hideOnClose"
windowHideOnClose = AttrLabelProxy

windowIconName :: AttrLabelProxy "iconName"
windowIconName = AttrLabelProxy

windowMaximized :: AttrLabelProxy "maximized"
windowMaximized = AttrLabelProxy

windowMnemonicsVisible :: AttrLabelProxy "mnemonicsVisible"
windowMnemonicsVisible = AttrLabelProxy

windowModal :: AttrLabelProxy "modal"
windowModal = AttrLabelProxy

windowResizable :: AttrLabelProxy "resizable"
windowResizable = AttrLabelProxy

windowStartupId :: AttrLabelProxy "startupId"
windowStartupId = AttrLabelProxy

windowSuspended :: AttrLabelProxy "suspended"
windowSuspended = AttrLabelProxy

windowTitle :: AttrLabelProxy "title"
windowTitle = AttrLabelProxy

windowTitlebar :: AttrLabelProxy "titlebar"
windowTitlebar = AttrLabelProxy

windowTransientFor :: AttrLabelProxy "transientFor"
windowTransientFor = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Window = WindowSignalList
type WindowSignalList = ('[ '("activateDefault", WindowActivateDefaultSignalInfo), '("activateFocus", WindowActivateFocusSignalInfo), '("closeRequest", WindowCloseRequestSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("enableDebugging", WindowEnableDebuggingSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("keysChanged", WindowKeysChangedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Window::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_new" gtk_window_new :: 
    IO (Ptr Window)

-- | Creates a new @GtkWindow@.
-- 
-- To get an undecorated window (without window borders),
-- use 'GI.Gtk.Objects.Window.windowSetDecorated'.
-- 
-- All top-level windows created by this function are stored
-- in an internal top-level window list. This list can be obtained
-- from 'GI.Gtk.Objects.Window.windowListToplevels'. Due to GTK keeping a
-- reference to the window internally, this function does not
-- return a reference to the caller.
-- 
-- To delete a @GtkWindow@, call 'GI.Gtk.Objects.Window.windowDestroy'.
windowNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Window
    -- ^ __Returns:__ a new @GtkWindow@
windowNew  = liftIO $ do
    result <- gtk_window_new
    checkUnexpectedReturnNULL "windowNew" result
    result' <- (newObject Window) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Window::close
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_close" gtk_window_close :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Requests that the window is closed.
-- 
-- This is similar to what happens when a window manager
-- close button is clicked.
-- 
-- This function can be used with close buttons in custom
-- titlebars.
windowClose ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m ()
windowClose window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gtk_window_close window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowCloseMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowCloseMethodInfo a signature where
    overloadedMethod = windowClose

instance O.OverloadedMethodInfo WindowCloseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowClose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowClose"
        })


#endif

-- method Window::destroy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the window to destroy"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_destroy" gtk_window_destroy :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Drops the internal reference GTK holds on toplevel windows.
windowDestroy ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: the window to destroy
    -> m ()
windowDestroy window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gtk_window_destroy window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowDestroyMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowDestroyMethodInfo a signature where
    overloadedMethod = windowDestroy

instance O.OverloadedMethodInfo WindowDestroyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowDestroy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowDestroy"
        })


#endif

-- method Window::fullscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_fullscreen" gtk_window_fullscreen :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Asks to place the window in the fullscreen state.
-- 
-- Note that you shouldn’t assume the window is definitely fullscreen
-- afterward, because other entities (e.g. the user or window manager)
-- unfullscreen it again, and not all window managers honor requests
-- to fullscreen windows.
-- 
-- If a window is not explicitly fullscreened or unfullscreened before
-- it is shown, the initial state is at the window managers discretion.
-- 
-- You can track the result of this operation via the
-- [Toplevel:state]("GI.Gdk.Interfaces.Toplevel#g:attr:state") property, or by listening to
-- notifications of the [Window:fullscreened]("GI.Gtk.Objects.Window#g:attr:fullscreened") property.
windowFullscreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m ()
windowFullscreen window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gtk_window_fullscreen window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowFullscreenMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowFullscreenMethodInfo a signature where
    overloadedMethod = windowFullscreen

instance O.OverloadedMethodInfo WindowFullscreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowFullscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowFullscreen"
        })


#endif

-- method Window::fullscreen_on_monitor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "which monitor to go fullscreen on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_fullscreen_on_monitor" gtk_window_fullscreen_on_monitor :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gdk.Monitor.Monitor ->              -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO ()

-- | Asks to place the window in the fullscreen state on the given monitor.
-- 
-- Note that you shouldn\'t assume the window is definitely fullscreen
-- afterward, or that the windowing system allows fullscreen windows on
-- any given monitor.
-- 
-- You can track the result of this operation via the
-- [Toplevel:state]("GI.Gdk.Interfaces.Toplevel#g:attr:state") property, or by listening to
-- notifications of the [Window:fullscreened]("GI.Gtk.Objects.Window#g:attr:fullscreened") property.
windowFullscreenOnMonitor ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.Monitor.IsMonitor b) =>
    a
    -- ^ /@window@/: a window
    -> b
    -- ^ /@monitor@/: which monitor to go fullscreen on
    -> m ()
windowFullscreenOnMonitor window monitor = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    monitor' <- unsafeManagedPtrCastPtr monitor
    gtk_window_fullscreen_on_monitor window' monitor'
    touchManagedPtr window
    touchManagedPtr monitor
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowFullscreenOnMonitorMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsWindow a, Gdk.Monitor.IsMonitor b) => O.OverloadedMethod WindowFullscreenOnMonitorMethodInfo a signature where
    overloadedMethod = windowFullscreenOnMonitor

instance O.OverloadedMethodInfo WindowFullscreenOnMonitorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowFullscreenOnMonitor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowFullscreenOnMonitor"
        })


#endif

-- method Window::get_application
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Application" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_application" gtk_window_get_application :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO (Ptr Gtk.Application.Application)

-- | Gets the application object associated with the window.
windowGetApplication ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m (Maybe Gtk.Application.Application)
    -- ^ __Returns:__ the application
windowGetApplication window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_application window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Application.Application) result'
        return result''
    touchManagedPtr window
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowGetApplicationMethodInfo
instance (signature ~ (m (Maybe Gtk.Application.Application)), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetApplicationMethodInfo a signature where
    overloadedMethod = windowGetApplication

instance O.OverloadedMethodInfo WindowGetApplicationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetApplication",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetApplication"
        })


#endif

-- method Window::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_child" gtk_window_get_child :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of the window.
windowGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@window@/
windowGetChild window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_child window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr window
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetChildMethodInfo a signature where
    overloadedMethod = windowGetChild

instance O.OverloadedMethodInfo WindowGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetChild"
        })


#endif

-- method Window::get_decorated
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_decorated" gtk_window_get_decorated :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Returns whether the window has been set to have decorations.
windowGetDecorated ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ true if the window has been set to have decorations
windowGetDecorated window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_decorated window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetDecoratedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetDecoratedMethodInfo a signature where
    overloadedMethod = windowGetDecorated

instance O.OverloadedMethodInfo WindowGetDecoratedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetDecorated",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetDecorated"
        })


#endif

-- method Window::get_default_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the default width"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the default height"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_default_size" gtk_window_get_default_size :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Int32 ->                            -- width : TBasicType TInt
    Ptr Int32 ->                            -- height : TBasicType TInt
    IO ()

-- | Gets the default size of the window.
-- 
-- A value of 0 for the width or height indicates that a default
-- size has not been explicitly set for that dimension, so the
-- “natural” size of the window will be used.
-- 
-- This function is the recommended way for <https://developer.gnome.org/documentation/tutorials/save-state.html saving window state
-- across restarts of applications>.
windowGetDefaultSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m ((Int32, Int32))
windowGetDefaultSize window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    width <- allocMem :: IO (Ptr Int32)
    height <- allocMem :: IO (Ptr Int32)
    gtk_window_get_default_size window' width height
    width' <- peek width
    height' <- peek height
    touchManagedPtr window
    freeMem width
    freeMem height
    return (width', height')

#if defined(ENABLE_OVERLOADING)
data WindowGetDefaultSizeMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetDefaultSizeMethodInfo a signature where
    overloadedMethod = windowGetDefaultSize

instance O.OverloadedMethodInfo WindowGetDefaultSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetDefaultSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetDefaultSize"
        })


#endif

-- method Window::get_default_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_default_widget" gtk_window_get_default_widget :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the default widget for /@window@/.
windowGetDefaultWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the default widget
windowGetDefaultWidget window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_default_widget window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr window
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowGetDefaultWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetDefaultWidgetMethodInfo a signature where
    overloadedMethod = windowGetDefaultWidget

instance O.OverloadedMethodInfo WindowGetDefaultWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetDefaultWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetDefaultWidget"
        })


#endif

-- method Window::get_deletable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_deletable" gtk_window_get_deletable :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Returns whether the window has been set to have a close button.
windowGetDeletable ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ true if the window has been set to have a close button
windowGetDeletable window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_deletable window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetDeletableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetDeletableMethodInfo a signature where
    overloadedMethod = windowGetDeletable

instance O.OverloadedMethodInfo WindowGetDeletableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetDeletable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetDeletable"
        })


#endif

-- method Window::get_destroy_with_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_destroy_with_parent" gtk_window_get_destroy_with_parent :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Returns whether the window will be destroyed with its transient parent.
windowGetDestroyWithParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ true if the window will be destroyed with its transient parent
windowGetDestroyWithParent window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_destroy_with_parent window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetDestroyWithParentMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetDestroyWithParentMethodInfo a signature where
    overloadedMethod = windowGetDestroyWithParent

instance O.OverloadedMethodInfo WindowGetDestroyWithParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetDestroyWithParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetDestroyWithParent"
        })


#endif

-- method Window::get_focus
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_focus" gtk_window_get_focus :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO (Ptr Gtk.Widget.Widget)

-- | Retrieves the current focused widget within the window.
-- 
-- Note that this is the widget that would have the focus
-- if the toplevel window focused; if the toplevel window
-- is not focused then @gtk_widget_has_focus (widget)@ will
-- not be false for the widget.
windowGetFocus ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the currently focused widget
windowGetFocus window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_focus window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr window
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowGetFocusMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetFocusMethodInfo a signature where
    overloadedMethod = windowGetFocus

instance O.OverloadedMethodInfo WindowGetFocusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetFocus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetFocus"
        })


#endif

-- method Window::get_focus_visible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_focus_visible" gtk_window_get_focus_visible :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Gets whether “focus rectangles” are supposed to be visible.
windowGetFocusVisible ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ true if “focus rectangles” are supposed to be visible
    --   in this window
windowGetFocusVisible window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_focus_visible window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetFocusVisibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetFocusVisibleMethodInfo a signature where
    overloadedMethod = windowGetFocusVisible

instance O.OverloadedMethodInfo WindowGetFocusVisibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetFocusVisible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetFocusVisible"
        })


#endif

-- method Window::get_gravity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "WindowGravity" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_gravity" gtk_window_get_gravity :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CUInt

-- | Returns the gravity that is used when changing the window size programmatically.
-- 
-- /Since: 4.20/
windowGetGravity ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Gtk.Enums.WindowGravity
    -- ^ __Returns:__ the gravity
windowGetGravity window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_gravity window'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetGravityMethodInfo
instance (signature ~ (m Gtk.Enums.WindowGravity), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetGravityMethodInfo a signature where
    overloadedMethod = windowGetGravity

instance O.OverloadedMethodInfo WindowGetGravityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetGravity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetGravity"
        })


#endif

-- method Window::get_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "WindowGroup" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_group" gtk_window_get_group :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO (Ptr Gtk.WindowGroup.WindowGroup)

-- | Returns the group for the window.
-- 
-- If the window has no group, then the default group is returned.
windowGetGroup ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    Maybe (a)
    -- ^ /@window@/: a window
    -> m Gtk.WindowGroup.WindowGroup
    -- ^ __Returns:__ the window group for /@window@/
    --   or the default group
windowGetGroup window = liftIO $ do
    maybeWindow <- case window of
        Nothing -> return FP.nullPtr
        Just jWindow -> do
            jWindow' <- unsafeManagedPtrCastPtr jWindow
            return jWindow'
    result <- gtk_window_get_group maybeWindow
    checkUnexpectedReturnNULL "windowGetGroup" result
    result' <- (newObject Gtk.WindowGroup.WindowGroup) result
    whenJust window touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetGroupMethodInfo
instance (signature ~ (m Gtk.WindowGroup.WindowGroup), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetGroupMethodInfo a signature where
    overloadedMethod i = windowGetGroup (Just i)

instance O.OverloadedMethodInfo WindowGetGroupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetGroup"
        })


#endif

-- method Window::get_handle_menubar_accel
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_handle_menubar_accel" gtk_window_get_handle_menubar_accel :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Returns whether this window reacts to \<kbd>F10\<\/kbd>
-- presses by activating a menubar it contains.
-- 
-- /Since: 4.2/
windowGetHandleMenubarAccel ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ true if the window handles \<kbd>F10\<\/kbd>
windowGetHandleMenubarAccel window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_handle_menubar_accel window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetHandleMenubarAccelMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetHandleMenubarAccelMethodInfo a signature where
    overloadedMethod = windowGetHandleMenubarAccel

instance O.OverloadedMethodInfo WindowGetHandleMenubarAccelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetHandleMenubarAccel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetHandleMenubarAccel"
        })


#endif

-- method Window::get_hide_on_close
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_hide_on_close" gtk_window_get_hide_on_close :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Returns whether the window will be hidden instead of destroyed when the close
-- button is clicked.
windowGetHideOnClose ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ true if the window will be hidden
windowGetHideOnClose window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_hide_on_close window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetHideOnCloseMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetHideOnCloseMethodInfo a signature where
    overloadedMethod = windowGetHideOnClose

instance O.OverloadedMethodInfo WindowGetHideOnCloseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetHideOnClose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetHideOnClose"
        })


#endif

-- method Window::get_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_icon_name" gtk_window_get_icon_name :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CString

-- | Returns the name of the themed icon for the window.
windowGetIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the icon name
windowGetIconName window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_icon_name window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr window
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowGetIconNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetIconNameMethodInfo a signature where
    overloadedMethod = windowGetIconName

instance O.OverloadedMethodInfo WindowGetIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetIconName"
        })


#endif

-- method Window::get_mnemonics_visible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_mnemonics_visible" gtk_window_get_mnemonics_visible :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Gets whether mnemonics are supposed to be visible.
windowGetMnemonicsVisible ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ true if mnemonics are supposed to be visible
    --   in this window
windowGetMnemonicsVisible window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_mnemonics_visible window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetMnemonicsVisibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetMnemonicsVisibleMethodInfo a signature where
    overloadedMethod = windowGetMnemonicsVisible

instance O.OverloadedMethodInfo WindowGetMnemonicsVisibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetMnemonicsVisible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetMnemonicsVisible"
        })


#endif

-- method Window::get_modal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_modal" gtk_window_get_modal :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Returns whether the window is modal.
windowGetModal ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ true if the window is set to be modal and
    --   establishes a grab when shown
windowGetModal window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_modal window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetModalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetModalMethodInfo a signature where
    overloadedMethod = windowGetModal

instance O.OverloadedMethodInfo WindowGetModalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetModal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetModal"
        })


#endif

-- method Window::get_resizable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_resizable" gtk_window_get_resizable :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Gets whether the user can resize the window.
windowGetResizable ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ true if the user can resize the window
windowGetResizable window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_resizable window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowGetResizableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetResizableMethodInfo a signature where
    overloadedMethod = windowGetResizable

instance O.OverloadedMethodInfo WindowGetResizableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetResizable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetResizable"
        })


#endif

-- method Window::get_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_title" gtk_window_get_title :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CString

-- | Retrieves the title of the window.
windowGetTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the title
windowGetTitle window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_title window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr window
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowGetTitleMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetTitleMethodInfo a signature where
    overloadedMethod = windowGetTitle

instance O.OverloadedMethodInfo WindowGetTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetTitle"
        })


#endif

-- method Window::get_titlebar
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_titlebar" gtk_window_get_titlebar :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the titlebar that has been set with
-- 'GI.Gtk.Objects.Window.windowSetTitlebar'.
windowGetTitlebar ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the titlebar
windowGetTitlebar window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_titlebar window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr window
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowGetTitlebarMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetTitlebarMethodInfo a signature where
    overloadedMethod = windowGetTitlebar

instance O.OverloadedMethodInfo WindowGetTitlebarMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetTitlebar",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetTitlebar"
        })


#endif

-- method Window::get_transient_for
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_transient_for" gtk_window_get_transient_for :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO (Ptr Window)

-- | Fetches the transient parent for this window.
windowGetTransientFor ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m (Maybe Window)
    -- ^ __Returns:__ the transient parent
windowGetTransientFor window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_get_transient_for window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Window) result'
        return result''
    touchManagedPtr window
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowGetTransientForMethodInfo
instance (signature ~ (m (Maybe Window)), MonadIO m, IsWindow a) => O.OverloadedMethod WindowGetTransientForMethodInfo a signature where
    overloadedMethod = windowGetTransientFor

instance O.OverloadedMethodInfo WindowGetTransientForMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowGetTransientFor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowGetTransientFor"
        })


#endif

-- method Window::has_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_has_group" gtk_window_has_group :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Returns whether the window has an explicit window group.
windowHasGroup ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ true if /@window@/ has an explicit window group
windowHasGroup window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_has_group window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowHasGroupMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowHasGroupMethodInfo a signature where
    overloadedMethod = windowHasGroup

instance O.OverloadedMethodInfo WindowHasGroupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowHasGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowHasGroup"
        })


#endif

-- method Window::is_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_is_active" gtk_window_is_active :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Returns whether the window is part of the current active toplevel.
-- 
-- The active toplevel is the window receiving keystrokes.
-- 
-- The return value is 'P.True' if the window is active toplevel itself.
-- You might use this function if you wanted to draw a widget
-- differently in an active window from a widget in an inactive window.
windowIsActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ true if the window part of the current active window.
windowIsActive window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_is_active window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowIsActiveMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowIsActiveMethodInfo a signature where
    overloadedMethod = windowIsActive

instance O.OverloadedMethodInfo WindowIsActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowIsActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowIsActive"
        })


#endif

-- method Window::is_fullscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_is_fullscreen" gtk_window_is_fullscreen :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Retrieves the current fullscreen state of the window.
-- 
-- Note that since fullscreening is ultimately handled by the window
-- manager and happens asynchronously to an application request, you
-- shouldn’t assume the return value of this function changing
-- immediately (or at all), as an effect of calling
-- 'GI.Gtk.Objects.Window.windowFullscreen' or 'GI.Gtk.Objects.Window.windowUnfullscreen'.
-- 
-- If the window isn\'t yet mapped, the value returned will whether the
-- initial requested state is fullscreen.
windowIsFullscreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ whether the window is fullscreen
windowIsFullscreen window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_is_fullscreen window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowIsFullscreenMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowIsFullscreenMethodInfo a signature where
    overloadedMethod = windowIsFullscreen

instance O.OverloadedMethodInfo WindowIsFullscreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowIsFullscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowIsFullscreen"
        })


#endif

-- method Window::is_maximized
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_is_maximized" gtk_window_is_maximized :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Retrieves the current maximized state of the window.
-- 
-- Note that since maximization is ultimately handled by the window
-- manager and happens asynchronously to an application request, you
-- shouldn’t assume the return value of this function changing
-- immediately (or at all), as an effect of calling
-- 'GI.Gtk.Objects.Window.windowMaximize' or 'GI.Gtk.Objects.Window.windowUnmaximize'.
-- 
-- If the window isn\'t yet mapped, the value returned will whether the
-- initial requested state is maximized.
windowIsMaximized ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ whether the window is maximized
windowIsMaximized window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_is_maximized window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowIsMaximizedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowIsMaximizedMethodInfo a signature where
    overloadedMethod = windowIsMaximized

instance O.OverloadedMethodInfo WindowIsMaximizedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowIsMaximized",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowIsMaximized"
        })


#endif

-- method Window::is_suspended
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_is_suspended" gtk_window_is_suspended :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO CInt

-- | Retrieves the current suspended state of the window.
-- 
-- A window being suspended means it\'s currently not visible
-- to the user, for example by being on a inactive workspace,
-- minimized, obstructed.
-- 
-- /Since: 4.12/
windowIsSuspended ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m Bool
    -- ^ __Returns:__ whether the window is suspended
windowIsSuspended window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_window_is_suspended window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowIsSuspendedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindow a) => O.OverloadedMethod WindowIsSuspendedMethodInfo a signature where
    overloadedMethod = windowIsSuspended

instance O.OverloadedMethodInfo WindowIsSuspendedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowIsSuspended",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowIsSuspended"
        })


#endif

-- method Window::maximize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_maximize" gtk_window_maximize :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Asks to maximize the window, so that it fills the screen.
-- 
-- Note that you shouldn’t assume the window is definitely maximized
-- afterward, because other entities (e.g. the user or window manager)
-- could unmaximize it again, and not all window managers support
-- maximization.
-- 
-- It’s permitted to call this function before showing a window,
-- in which case the window will be maximized when it appears onscreen
-- initially.
-- 
-- If a window is not explicitly maximized or unmaximized before it is
-- shown, the initial state is at the window managers discretion. For
-- example, it might decide to maximize a window that almost fills the
-- screen.
-- 
-- You can track the result of this operation via the
-- [Toplevel:state]("GI.Gdk.Interfaces.Toplevel#g:attr:state") property, or by listening to
-- notifications on the [Window:maximized]("GI.Gtk.Objects.Window#g:attr:maximized")
-- property.
windowMaximize ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m ()
windowMaximize window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gtk_window_maximize window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowMaximizeMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowMaximizeMethodInfo a signature where
    overloadedMethod = windowMaximize

instance O.OverloadedMethodInfo WindowMaximizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowMaximize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowMaximize"
        })


#endif

-- method Window::minimize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_minimize" gtk_window_minimize :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Asks to minimize the window.
-- 
-- Note that you shouldn’t assume the window is definitely minimized
-- afterward, because the windowing system might not support this
-- functionality; other entities (e.g. the user or the window manager)
-- could unminimize it again, or there may not be a window manager in
-- which case minimization isn’t possible, etc.
-- 
-- It’s permitted to call this function before showing a window,
-- in which case the window will be minimized before it ever appears
-- onscreen.
-- 
-- You can track result of this operation via the
-- [Toplevel:state]("GI.Gdk.Interfaces.Toplevel#g:attr:state") property.
windowMinimize ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m ()
windowMinimize window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gtk_window_minimize window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowMinimizeMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowMinimizeMethodInfo a signature where
    overloadedMethod = windowMinimize

instance O.OverloadedMethodInfo WindowMinimizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowMinimize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowMinimize"
        })


#endif

-- method Window::present
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_present" gtk_window_present :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Presents a window to the user.
-- 
-- This may mean raising the window in the stacking order,
-- unminimizing it, moving it to the current desktop and\/or
-- giving it the keyboard focus (possibly dependent on the user’s
-- platform, window manager and preferences).
-- 
-- If /@window@/ is hidden, this function also makes it visible.
windowPresent ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m ()
windowPresent window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gtk_window_present window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowPresentMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowPresentMethodInfo a signature where
    overloadedMethod = windowPresent

instance O.OverloadedMethodInfo WindowPresentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowPresent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowPresent"
        })


#endif

-- method Window::present_with_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the timestamp of the user interaction (typically a\n  button or key press event) which triggered this call"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_present_with_time" gtk_window_present_with_time :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    Word32 ->                               -- timestamp : TBasicType TUInt32
    IO ()

{-# DEPRECATED windowPresentWithTime ["(Since version 4.14)","Use 'GI.Gtk.Objects.Window.windowPresent'"] #-}
-- | Presents a window to the user in response to an user interaction.
-- 
-- See 'GI.Gtk.Objects.Window.windowPresent' for more details.
-- 
-- The timestamp should be gathered when the window was requested
-- to be shown (when clicking a link for example), rather than once
-- the window is ready to be shown.
windowPresentWithTime ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Word32
    -- ^ /@timestamp@/: the timestamp of the user interaction (typically a
    --   button or key press event) which triggered this call
    -> m ()
windowPresentWithTime window timestamp = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gtk_window_present_with_time window' timestamp
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowPresentWithTimeMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowPresentWithTimeMethodInfo a signature where
    overloadedMethod = windowPresentWithTime

instance O.OverloadedMethodInfo WindowPresentWithTimeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowPresentWithTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowPresentWithTime"
        })


#endif

-- method Window::set_application
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "application"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Application" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkApplication`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_application" gtk_window_set_application :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gtk.Application.Application ->      -- application : TInterface (Name {namespace = "Gtk", name = "Application"})
    IO ()

-- | Sets or unsets the application object associated with the window.
-- 
-- The application will be kept alive for at least as long as it has
-- any windows associated with it (see 'GI.Gio.Objects.Application.applicationHold'
-- for a way to keep it alive without windows).
-- 
-- Normally, the connection between the application and the window will
-- remain until the window is destroyed, but you can explicitly remove
-- it by setting the /@application@/ to 'P.Nothing'.
-- 
-- This is equivalent to calling 'GI.Gtk.Objects.Application.applicationRemoveWindow'
-- and\/or 'GI.Gtk.Objects.Application.applicationAddWindow' on the old\/new applications
-- as relevant.
windowSetApplication ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gtk.Application.IsApplication b) =>
    a
    -- ^ /@window@/: a window
    -> Maybe (b)
    -- ^ /@application@/: a @GtkApplication@
    -> m ()
windowSetApplication window application = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeApplication <- case application of
        Nothing -> return FP.nullPtr
        Just jApplication -> do
            jApplication' <- unsafeManagedPtrCastPtr jApplication
            return jApplication'
    gtk_window_set_application window' maybeApplication
    touchManagedPtr window
    whenJust application touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetApplicationMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsWindow a, Gtk.Application.IsApplication b) => O.OverloadedMethod WindowSetApplicationMethodInfo a signature where
    overloadedMethod = windowSetApplication

instance O.OverloadedMethodInfo WindowSetApplicationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetApplication",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetApplication"
        })


#endif

-- method Window::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_child" gtk_window_set_child :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of the window.
windowSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@window@/: a window
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
windowSetChild window child = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_window_set_child window' maybeChild
    touchManagedPtr window
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsWindow a, Gtk.Widget.IsWidget b) => O.OverloadedMethod WindowSetChildMethodInfo a signature where
    overloadedMethod = windowSetChild

instance O.OverloadedMethodInfo WindowSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetChild"
        })


#endif

-- method Window::set_decorated
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to decorate the window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_decorated" gtk_window_set_decorated :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether the window should be decorated.
-- 
-- By default, windows are decorated with a title bar, resize
-- controls, etc. Some window managers allow GTK to disable these
-- decorations, creating a borderless window. If you set the decorated
-- property to false using this function, GTK will do its best to
-- convince the window manager not to decorate the window. Depending on
-- the system, this function may not have any effect when called on a
-- window that is already visible, so you should call it before calling
-- 'GI.Gtk.Objects.Widget.widgetShow'.
-- 
-- On Windows, this function always works, since there’s no window manager
-- policy involved.
windowSetDecorated ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Bool
    -- ^ /@setting@/: true to decorate the window
    -> m ()
windowSetDecorated window setting = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_window_set_decorated window' setting'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetDecoratedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetDecoratedMethodInfo a signature where
    overloadedMethod = windowSetDecorated

instance O.OverloadedMethodInfo WindowSetDecoratedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetDecorated",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetDecorated"
        })


#endif

-- method Window::set_default_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "width in pixels, or -1 to unset the default width"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "height in pixels, or -1 to unset the default height"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_default_size" gtk_window_set_default_size :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | Sets the default size of a window.
-- 
-- The default size of a window is the size that will be used
-- if no other constraints apply.
-- 
-- The default size will be updated whenever the window is resized
-- to reflect the new size, unless the window is forced to a size,
-- like when it is maximized or fullscreened.
-- 
-- If the window’s minimum size request is larger than
-- the default, the default will be ignored.
-- 
-- Setting the default size to a value \<= 0 will cause it to be
-- ignored and the natural size request will be used instead. It
-- is possible to do this while the window is showing to \"reset\"
-- it to its initial size.
-- 
-- Unlike 'GI.Gtk.Objects.Widget.widgetSetSizeRequest', which sets a size
-- request for a widget and thus would keep users from shrinking
-- the window, this function only sets the initial size, just as
-- if the user had resized the window themselves. Users can still
-- shrink the window again as they normally would. Setting a default
-- size of -1 means to use the “natural” default size (the size request
-- of the window).
-- 
-- If you use this function to reestablish a previously saved window size,
-- note that the appropriate size to save is the one returned by
-- 'GI.Gtk.Objects.Window.windowGetDefaultSize'. Using the window allocation
-- directly will not work in all circumstances and can lead to growing
-- or shrinking windows.
windowSetDefaultSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Int32
    -- ^ /@width@/: width in pixels, or -1 to unset the default width
    -> Int32
    -- ^ /@height@/: height in pixels, or -1 to unset the default height
    -> m ()
windowSetDefaultSize window width height = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gtk_window_set_default_size window' width height
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetDefaultSizeMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetDefaultSizeMethodInfo a signature where
    overloadedMethod = windowSetDefaultSize

instance O.OverloadedMethodInfo WindowSetDefaultSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetDefaultSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetDefaultSize"
        })


#endif

-- method Window::set_default_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "widget to be the default"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_default_widget" gtk_window_set_default_widget :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gtk.Widget.Widget ->                -- default_widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the default widget.
-- 
-- The default widget is the widget that is activated
-- when the user presses \<kbd>Enter\<\/kbd> in a dialog
-- (for example).
windowSetDefaultWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@window@/: a window
    -> Maybe (b)
    -- ^ /@defaultWidget@/: widget to be the default
    -> m ()
windowSetDefaultWidget window defaultWidget = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeDefaultWidget <- case defaultWidget of
        Nothing -> return FP.nullPtr
        Just jDefaultWidget -> do
            jDefaultWidget' <- unsafeManagedPtrCastPtr jDefaultWidget
            return jDefaultWidget'
    gtk_window_set_default_widget window' maybeDefaultWidget
    touchManagedPtr window
    whenJust defaultWidget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetDefaultWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsWindow a, Gtk.Widget.IsWidget b) => O.OverloadedMethod WindowSetDefaultWidgetMethodInfo a signature where
    overloadedMethod = windowSetDefaultWidget

instance O.OverloadedMethodInfo WindowSetDefaultWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetDefaultWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetDefaultWidget"
        })


#endif

-- method Window::set_deletable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to decorate the window as deletable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_deletable" gtk_window_set_deletable :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether the window should be deletable.
-- 
-- By default, windows have a close button in the window frame.
-- Some  window managers allow GTK to disable this button. If you
-- set the deletable property to false using this function, GTK
-- will do its best to convince the window manager not to show a
-- close button. Depending on the system, this function may not
-- have any effect when called on a window that is already visible,
-- so you should call it before calling 'GI.Gtk.Objects.Widget.widgetShow'.
-- 
-- On Windows, this function always works, since there’s no window
-- manager policy involved.
windowSetDeletable ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Bool
    -- ^ /@setting@/: true to decorate the window as deletable
    -> m ()
windowSetDeletable window setting = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_window_set_deletable window' setting'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetDeletableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetDeletableMethodInfo a signature where
    overloadedMethod = windowSetDeletable

instance O.OverloadedMethodInfo WindowSetDeletableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetDeletable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetDeletable"
        })


#endif

-- method Window::set_destroy_with_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether to destroy the window with its transient parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_destroy_with_parent" gtk_window_set_destroy_with_parent :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether to destroy the window when the transient parent is destroyed.
-- 
-- This is useful for dialogs that shouldn’t persist beyond the lifetime
-- of the main window they are associated with, for example.
windowSetDestroyWithParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Bool
    -- ^ /@setting@/: whether to destroy the window with its transient parent
    -> m ()
windowSetDestroyWithParent window setting = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_window_set_destroy_with_parent window' setting'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetDestroyWithParentMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetDestroyWithParentMethodInfo a signature where
    overloadedMethod = windowSetDestroyWithParent

instance O.OverloadedMethodInfo WindowSetDestroyWithParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetDestroyWithParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetDestroyWithParent"
        })


#endif

-- method Window::set_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a display" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_display" gtk_window_set_display :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

-- | Sets the display where the window is displayed.
-- 
-- If the window is already mapped, it will be unmapped,
-- and then remapped on the new display.
windowSetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gdk.Display.IsDisplay b) =>
    a
    -- ^ /@window@/: a window
    -> b
    -- ^ /@display@/: a display
    -> m ()
windowSetDisplay window display = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    display' <- unsafeManagedPtrCastPtr display
    gtk_window_set_display window' display'
    touchManagedPtr window
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetDisplayMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsWindow a, Gdk.Display.IsDisplay b) => O.OverloadedMethod WindowSetDisplayMethodInfo a signature where
    overloadedMethod = windowSetDisplay

instance O.OverloadedMethodInfo WindowSetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetDisplay"
        })


#endif

-- method Window::set_focus
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "focus"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new focus widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_focus" gtk_window_set_focus :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gtk.Widget.Widget ->                -- focus : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the focus widget.
-- 
-- If /@focus@/ is not the current focus widget, and is focusable,
-- sets it as the focus widget for the window. If /@focus@/ is 'P.Nothing',
-- unsets the focus widget for this window. To set the focus to a
-- particular widget in the toplevel, it is usually more convenient
-- to use 'GI.Gtk.Objects.Widget.widgetGrabFocus' instead of this function.
windowSetFocus ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@window@/: a window
    -> Maybe (b)
    -- ^ /@focus@/: the new focus widget
    -> m ()
windowSetFocus window focus = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeFocus <- case focus of
        Nothing -> return FP.nullPtr
        Just jFocus -> do
            jFocus' <- unsafeManagedPtrCastPtr jFocus
            return jFocus'
    gtk_window_set_focus window' maybeFocus
    touchManagedPtr window
    whenJust focus touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetFocusMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsWindow a, Gtk.Widget.IsWidget b) => O.OverloadedMethod WindowSetFocusMethodInfo a signature where
    overloadedMethod = windowSetFocus

instance O.OverloadedMethodInfo WindowSetFocusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetFocus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetFocus"
        })


#endif

-- method Window::set_focus_visible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_focus_visible" gtk_window_set_focus_visible :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether “focus rectangles” are supposed to be visible.
-- 
-- This property is maintained by GTK based on user input,
-- and should not be set by applications.
windowSetFocusVisible ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Bool
    -- ^ /@setting@/: the new value
    -> m ()
windowSetFocusVisible window setting = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_window_set_focus_visible window' setting'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetFocusVisibleMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetFocusVisibleMethodInfo a signature where
    overloadedMethod = windowSetFocusVisible

instance O.OverloadedMethodInfo WindowSetFocusVisibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetFocusVisible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetFocusVisible"
        })


#endif

-- method Window::set_gravity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "gravity"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WindowGravity" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new gravity" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_gravity" gtk_window_set_gravity :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CUInt ->                                -- gravity : TInterface (Name {namespace = "Gtk", name = "WindowGravity"})
    IO ()

-- | Sets the gravity that is used when changing the window size programmatically.
-- 
-- /Since: 4.20/
windowSetGravity ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Gtk.Enums.WindowGravity
    -- ^ /@gravity@/: the new gravity
    -> m ()
windowSetGravity window gravity = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let gravity' = (fromIntegral . fromEnum) gravity
    gtk_window_set_gravity window' gravity'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetGravityMethodInfo
instance (signature ~ (Gtk.Enums.WindowGravity -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetGravityMethodInfo a signature where
    overloadedMethod = windowSetGravity

instance O.OverloadedMethodInfo WindowSetGravityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetGravity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetGravity"
        })


#endif

-- method Window::set_handle_menubar_accel
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handle_menubar_accel"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to make @window handle <kbd>F10</kbd>"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_handle_menubar_accel" gtk_window_set_handle_menubar_accel :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CInt ->                                 -- handle_menubar_accel : TBasicType TBoolean
    IO ()

-- | Sets whether this window should react to \<kbd>F10\<\/kbd>
-- presses by activating a menubar it contains.
-- 
-- /Since: 4.2/
windowSetHandleMenubarAccel ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Bool
    -- ^ /@handleMenubarAccel@/: true to make /@window@/ handle \<kbd>F10\<\/kbd>
    -> m ()
windowSetHandleMenubarAccel window handleMenubarAccel = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let handleMenubarAccel' = (P.fromIntegral . P.fromEnum) handleMenubarAccel
    gtk_window_set_handle_menubar_accel window' handleMenubarAccel'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetHandleMenubarAccelMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetHandleMenubarAccelMethodInfo a signature where
    overloadedMethod = windowSetHandleMenubarAccel

instance O.OverloadedMethodInfo WindowSetHandleMenubarAccelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetHandleMenubarAccel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetHandleMenubarAccel"
        })


#endif

-- method Window::set_hide_on_close
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to hide the window when it is closed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_hide_on_close" gtk_window_set_hide_on_close :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether clicking the close button will hide the window instead
-- of destroying it.
windowSetHideOnClose ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Bool
    -- ^ /@setting@/: whether to hide the window when it is closed
    -> m ()
windowSetHideOnClose window setting = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_window_set_hide_on_close window' setting'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetHideOnCloseMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetHideOnCloseMethodInfo a signature where
    overloadedMethod = windowSetHideOnClose

instance O.OverloadedMethodInfo WindowSetHideOnCloseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetHideOnClose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetHideOnClose"
        })


#endif

-- method Window::set_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the themed icon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_icon_name" gtk_window_set_icon_name :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Sets the icon for the window from a named themed icon.
-- 
-- See the docs for t'GI.Gtk.Objects.IconTheme.IconTheme' for more details.
-- On some platforms, the window icon is not used at all.
-- 
-- Note that this has nothing to do with the WM_ICON_NAME
-- property which is mentioned in the ICCCM.
windowSetIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Maybe (T.Text)
    -- ^ /@name@/: the name of the themed icon
    -> m ()
windowSetIconName window name = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeName <- case name of
        Nothing -> return FP.nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    gtk_window_set_icon_name window' maybeName
    touchManagedPtr window
    freeMem maybeName
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetIconNameMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetIconNameMethodInfo a signature where
    overloadedMethod = windowSetIconName

instance O.OverloadedMethodInfo WindowSetIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetIconName"
        })


#endif

-- method Window::set_mnemonics_visible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_mnemonics_visible" gtk_window_set_mnemonics_visible :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether mnemonics are supposed to be visible.
-- 
-- This property is maintained by GTK based on user input,
-- and should not be set by applications.
windowSetMnemonicsVisible ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Bool
    -- ^ /@setting@/: the new value
    -> m ()
windowSetMnemonicsVisible window setting = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_window_set_mnemonics_visible window' setting'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetMnemonicsVisibleMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetMnemonicsVisibleMethodInfo a signature where
    overloadedMethod = windowSetMnemonicsVisible

instance O.OverloadedMethodInfo WindowSetMnemonicsVisibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetMnemonicsVisible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetMnemonicsVisible"
        })


#endif

-- method Window::set_modal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modal"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the window is modal"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_modal" gtk_window_set_modal :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CInt ->                                 -- modal : TBasicType TBoolean
    IO ()

-- | Sets a window modal or non-modal.
-- 
-- Modal windows prevent interaction with other windows in the same
-- application. To keep modal dialogs on top of main application windows,
-- use 'GI.Gtk.Objects.Window.windowSetTransientFor' to make the dialog transient
-- for the parent; most window managers will then disallow lowering the
-- dialog below the parent.
windowSetModal ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Bool
    -- ^ /@modal@/: whether the window is modal
    -> m ()
windowSetModal window modal = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let modal' = (P.fromIntegral . P.fromEnum) modal
    gtk_window_set_modal window' modal'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetModalMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetModalMethodInfo a signature where
    overloadedMethod = windowSetModal

instance O.OverloadedMethodInfo WindowSetModalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetModal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetModal"
        })


#endif

-- method Window::set_resizable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resizable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true if the user can resize this window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_resizable" gtk_window_set_resizable :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CInt ->                                 -- resizable : TBasicType TBoolean
    IO ()

-- | Sets whether the user can resize a window.
-- 
-- Windows are user resizable by default.
windowSetResizable ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Bool
    -- ^ /@resizable@/: true if the user can resize this window
    -> m ()
windowSetResizable window resizable = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let resizable' = (P.fromIntegral . P.fromEnum) resizable
    gtk_window_set_resizable window' resizable'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetResizableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetResizableMethodInfo a signature where
    overloadedMethod = windowSetResizable

instance O.OverloadedMethodInfo WindowSetResizableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetResizable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetResizable"
        })


#endif

-- method Window::set_startup_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "startup_id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string with startup-notification identifier"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_startup_id" gtk_window_set_startup_id :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CString ->                              -- startup_id : TBasicType TUTF8
    IO ()

-- | Sets the startup notification ID.
-- 
-- Startup notification identifiers are used by desktop environment
-- to track application startup, to provide user feedback and other
-- features. This function changes the corresponding property on the
-- underlying @GdkSurface@.
-- 
-- Normally, startup identifier is managed automatically and you should
-- only use this function in special cases like transferring focus from
-- other processes. You should use this function before calling
-- 'GI.Gtk.Objects.Window.windowPresent' or any equivalent function generating
-- a window map event.
-- 
-- This function is only useful on Wayland or X11, not with other GDK
-- backends.
windowSetStartupId ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> T.Text
    -- ^ /@startupId@/: a string with startup-notification identifier
    -> m ()
windowSetStartupId window startupId = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    startupId' <- textToCString startupId
    gtk_window_set_startup_id window' startupId'
    touchManagedPtr window
    freeMem startupId'
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetStartupIdMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetStartupIdMethodInfo a signature where
    overloadedMethod = windowSetStartupId

instance O.OverloadedMethodInfo WindowSetStartupIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetStartupId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetStartupId"
        })


#endif

-- method Window::set_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "title"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "title of the window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_title" gtk_window_set_title :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    CString ->                              -- title : TBasicType TUTF8
    IO ()

-- | Sets the title of the window.
-- 
-- The title of a window will be displayed in its title bar; on the
-- X Window System, the title bar is rendered by the window manager
-- so exactly how the title appears to users may vary according to a
-- user’s exact configuration. The title should help a user distinguish
-- this window from other windows they may have open. A good title might
-- include the application name and current document filename, for example.
-- 
-- Passing @NULL@ does the same as setting the title to an empty string.
windowSetTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> Maybe (T.Text)
    -- ^ /@title@/: title of the window
    -> m ()
windowSetTitle window title = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeTitle <- case title of
        Nothing -> return FP.nullPtr
        Just jTitle -> do
            jTitle' <- textToCString jTitle
            return jTitle'
    gtk_window_set_title window' maybeTitle
    touchManagedPtr window
    freeMem maybeTitle
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetTitleMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowSetTitleMethodInfo a signature where
    overloadedMethod = windowSetTitle

instance O.OverloadedMethodInfo WindowSetTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetTitle"
        })


#endif

-- method Window::set_titlebar
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "titlebar"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to use as titlebar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_titlebar" gtk_window_set_titlebar :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gtk.Widget.Widget ->                -- titlebar : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets a custom titlebar for the window.
-- 
-- A typical widget used here is t'GI.Gtk.Objects.HeaderBar.HeaderBar', as it
-- provides various features expected of a titlebar while allowing
-- the addition of child widgets to it.
-- 
-- If you set a custom titlebar, GTK will do its best to convince
-- the window manager not to put its own titlebar on the window.
-- Depending on the system, this function may not work for a window
-- that is already visible, so you set the titlebar before calling
-- 'GI.Gtk.Objects.Widget.widgetShow'.
windowSetTitlebar ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@window@/: a window
    -> Maybe (b)
    -- ^ /@titlebar@/: the widget to use as titlebar
    -> m ()
windowSetTitlebar window titlebar = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeTitlebar <- case titlebar of
        Nothing -> return FP.nullPtr
        Just jTitlebar -> do
            jTitlebar' <- unsafeManagedPtrCastPtr jTitlebar
            return jTitlebar'
    gtk_window_set_titlebar window' maybeTitlebar
    touchManagedPtr window
    whenJust titlebar touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetTitlebarMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsWindow a, Gtk.Widget.IsWidget b) => O.OverloadedMethod WindowSetTitlebarMethodInfo a signature where
    overloadedMethod = windowSetTitlebar

instance O.OverloadedMethodInfo WindowSetTitlebarMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetTitlebar",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetTitlebar"
        })


#endif

-- method Window::set_transient_for
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "parent window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_transient_for" gtk_window_set_transient_for :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Window ->                           -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Sets a transient parent for the window.
-- 
-- Dialog windows should be set transient for the main application
-- window they were spawned from. This allows window managers to e.g.
-- keep the dialog on top of the main window, or center the dialog
-- over the main window. t'GI.Gtk.Objects.Dialog.Dialog'.@/new_with_buttons/@() and other
-- convenience functions in GTK will sometimes call this function on
-- your behalf.
-- 
-- Passing @NULL@ for /@parent@/ unsets the current transient window.
-- 
-- On Windows, this function puts the child window on top of the parent,
-- much as the window manager would have done on X.
windowSetTransientFor ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a, IsWindow b) =>
    a
    -- ^ /@window@/: a window
    -> Maybe (b)
    -- ^ /@parent@/: parent window
    -> m ()
windowSetTransientFor window parent = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    gtk_window_set_transient_for window' maybeParent
    touchManagedPtr window
    whenJust parent touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowSetTransientForMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsWindow a, IsWindow b) => O.OverloadedMethod WindowSetTransientForMethodInfo a signature where
    overloadedMethod = windowSetTransientFor

instance O.OverloadedMethodInfo WindowSetTransientForMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowSetTransientFor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowSetTransientFor"
        })


#endif

-- method Window::unfullscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_unfullscreen" gtk_window_unfullscreen :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Asks to remove the fullscreen state for the window, and return to
-- its previous state.
-- 
-- Note that you shouldn’t assume the window is definitely not
-- fullscreen afterward, because other entities (e.g. the user or
-- window manager) could fullscreen it again, and not all window
-- managers honor requests to unfullscreen windows; normally the
-- window will end up restored to its normal state. Just don’t
-- write code that crashes if not.
-- 
-- If a window is not explicitly fullscreened or unfullscreened before
-- it is shown, the initial state is at the window managers discretion.
-- 
-- You can track the result of this operation via the
-- [Toplevel:state]("GI.Gdk.Interfaces.Toplevel#g:attr:state") property, or by listening to
-- notifications of the [Window:fullscreened]("GI.Gtk.Objects.Window#g:attr:fullscreened") property.
windowUnfullscreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m ()
windowUnfullscreen window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gtk_window_unfullscreen window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowUnfullscreenMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowUnfullscreenMethodInfo a signature where
    overloadedMethod = windowUnfullscreen

instance O.OverloadedMethodInfo WindowUnfullscreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowUnfullscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowUnfullscreen"
        })


#endif

-- method Window::unmaximize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_unmaximize" gtk_window_unmaximize :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Asks to unmaximize the window.
-- 
-- Note that you shouldn’t assume the window is definitely unmaximized
-- afterward, because other entities (e.g. the user or window manager)
-- maximize it again, and not all window managers honor requests to
-- unmaximize.
-- 
-- If a window is not explicitly maximized or unmaximized before it is
-- shown, the initial state is at the window managers discretion. For
-- example, it might decide to maximize a window that almost fills the
-- screen.
-- 
-- You can track the result of this operation via the
-- [Toplevel:state]("GI.Gdk.Interfaces.Toplevel#g:attr:state") property, or by listening to
-- notifications on the [Window:maximized]("GI.Gtk.Objects.Window#g:attr:maximized") property.
windowUnmaximize ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m ()
windowUnmaximize window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gtk_window_unmaximize window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowUnmaximizeMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowUnmaximizeMethodInfo a signature where
    overloadedMethod = windowUnmaximize

instance O.OverloadedMethodInfo WindowUnmaximizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowUnmaximize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowUnmaximize"
        })


#endif

-- method Window::unminimize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_unminimize" gtk_window_unminimize :: 
    Ptr Window ->                           -- window : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Asks to unminimize the window.
-- 
-- Note that you shouldn’t assume the window is definitely unminimized
-- afterward, because the windowing system might not support this
-- functionality; other entities (e.g. the user or the window manager)
-- could minimize it again, or there may not be a window manager in
-- which case minimization isn’t possible, etc.
-- 
-- You can track result of this operation via the
-- [Toplevel:state]("GI.Gdk.Interfaces.Toplevel#g:attr:state") property.
windowUnminimize ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindow a) =>
    a
    -- ^ /@window@/: a window
    -> m ()
windowUnminimize window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gtk_window_unminimize window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowUnminimizeMethodInfo
instance (signature ~ (m ()), MonadIO m, IsWindow a) => O.OverloadedMethod WindowUnminimizeMethodInfo a signature where
    overloadedMethod = windowUnminimize

instance O.OverloadedMethodInfo WindowUnminimizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Window.windowUnminimize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Window.html#v:windowUnminimize"
        })


#endif

-- method Window::get_default_icon_name
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_default_icon_name" gtk_window_get_default_icon_name :: 
    IO CString

-- | Returns the fallback icon name for windows.
-- 
-- The returned string is owned by GTK and should not
-- be modified. It is only valid until the next call to
-- 'GI.Gtk.Objects.Window.windowSetDefaultIconName'.
windowGetDefaultIconName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe T.Text)
    -- ^ __Returns:__ the fallback icon name for windows
windowGetDefaultIconName  = liftIO $ do
    result <- gtk_window_get_default_icon_name
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Window::get_toplevels
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_get_toplevels" gtk_window_get_toplevels :: 
    IO (Ptr Gio.ListModel.ListModel)

-- | Returns the list of all existing toplevel windows.
-- 
-- If you want to iterate through the list and perform actions involving
-- callbacks that might destroy the widgets or add new ones, be aware that
-- the list of toplevels will change and emit the \"items-changed\" signal.
windowGetToplevels ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Gio.ListModel.ListModel
    -- ^ __Returns:__ the list
    --   of toplevel widgets
windowGetToplevels  = liftIO $ do
    result <- gtk_window_get_toplevels
    checkUnexpectedReturnNULL "windowGetToplevels" result
    result' <- (newObject Gio.ListModel.ListModel) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Window::list_toplevels
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gtk" , name = "Widget" }))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_list_toplevels" gtk_window_list_toplevels :: 
    IO (Ptr (GList (Ptr Gtk.Widget.Widget)))

-- | Returns the list of all existing toplevel windows.
-- 
-- The widgets in the list are not individually referenced.
-- If you want to iterate through the list and perform actions
-- involving callbacks that might destroy the widgets, you must
-- call @g_list_foreach (result, (GFunc)g_object_ref, NULL)@ first,
-- and then unref all the widgets afterwards.
windowListToplevels ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Gtk.Widget.Widget]
    -- ^ __Returns:__ list of
    --   toplevel widgets
windowListToplevels  = liftIO $ do
    result <- gtk_window_list_toplevels
    result' <- unpackGList result
    result'' <- mapM (newObject Gtk.Widget.Widget) result'
    g_list_free result
    return result''

#if defined(ENABLE_OVERLOADING)
#endif

-- method Window::set_auto_startup_notification
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to automatically do startup notification"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_auto_startup_notification" gtk_window_set_auto_startup_notification :: 
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether the window should request startup notification.
-- 
-- By default, after showing the first window, GTK calls
-- 'GI.Gdk.Interfaces.Toplevel.toplevelSetStartupId'. Call this function
-- to disable the automatic startup notification. You might do this
-- if your first window is a splash screen, and you want to delay
-- notification until after your real main window has been shown,
-- for example.
-- 
-- In that example, you would disable startup notification
-- temporarily, show your splash screen, then re-enable it so that
-- showing the main window would automatically result in notification.
windowSetAutoStartupNotification ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Bool
    -- ^ /@setting@/: true to automatically do startup notification
    -> m ()
windowSetAutoStartupNotification setting = liftIO $ do
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_window_set_auto_startup_notification setting'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Window::set_default_icon_name
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the themed icon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_default_icon_name" gtk_window_set_default_icon_name :: 
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Sets an icon to be used as fallback.
-- 
-- The fallback icon is used for windows that
-- haven\'t had 'GI.Gtk.Objects.Window.windowSetIconName'
-- called on them.
windowSetDefaultIconName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the name of the themed icon
    -> m ()
windowSetDefaultIconName name = liftIO $ do
    name' <- textToCString name
    gtk_window_set_default_icon_name name'
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Window::set_interactive_debugging
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "enable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to enable interactive debugging"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_set_interactive_debugging" gtk_window_set_interactive_debugging :: 
    CInt ->                                 -- enable : TBasicType TBoolean
    IO ()

-- | Opens or closes the <https://docs.gtk.org/gtk4/running.html#interactive-debugging interactive debugger>.
-- 
-- The debugger offers access to the widget hierarchy of the application
-- and to useful debugging tools.
-- 
-- This function allows applications that already use
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Shift\<\/kbd>+\<kbd>I\<\/kbd>
-- (or \<kbd>Ctrl\<\/kbd>+\<kbd>Shift\<\/kbd>+\<kbd>D\<\/kbd>)
-- for their own key shortcuts to add a different shortcut to open the Inspector.
-- 
-- If you are not overriding the default key shortcuts for the Inspector,
-- you should not use this function.
windowSetInteractiveDebugging ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Bool
    -- ^ /@enable@/: true to enable interactive debugging
    -> m ()
windowSetInteractiveDebugging enable = liftIO $ do
    let enable' = (P.fromIntegral . P.fromEnum) enable
    gtk_window_set_interactive_debugging enable'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif


