{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Pairs of glyph and color index.
-- 
-- A color index of 0xFFFF does not refer to a palette
-- color, but indicates that the foreground color should
-- be used.
-- 
-- /Since: 2.1.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.OtColorLayerT
    ( 

-- * Exported types
    OtColorLayerT(..)                       ,
    newZeroOtColorLayerT                    ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveOtColorLayerTMethod              ,
#endif



 -- * Properties


-- ** colorIndex #attr:colorIndex#
-- | the palette color index of the layer

    getOtColorLayerTColorIndex              ,
#if defined(ENABLE_OVERLOADING)
    otColorLayerT_colorIndex                ,
#endif
    setOtColorLayerTColorIndex              ,


-- ** glyph #attr:glyph#
-- | the glyph ID of the layer

    getOtColorLayerTGlyph                   ,
#if defined(ENABLE_OVERLOADING)
    otColorLayerT_glyph                     ,
#endif
    setOtColorLayerTGlyph                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype OtColorLayerT = OtColorLayerT (SP.ManagedPtr OtColorLayerT)
    deriving (Eq)

instance SP.ManagedPtrNewtype OtColorLayerT where
    toManagedPtr (OtColorLayerT p) = p

instance BoxedPtr OtColorLayerT where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 8 >=> B.ManagedPtr.wrapPtr OtColorLayerT)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr OtColorLayerT where
    boxedPtrCalloc = callocBytes 8


-- | Construct a t'OtColorLayerT' struct initialized to zero.
newZeroOtColorLayerT :: MonadIO m => m OtColorLayerT
newZeroOtColorLayerT = liftIO $ boxedPtrCalloc >>= wrapPtr OtColorLayerT

instance tag ~ 'AttrSet => Constructible OtColorLayerT tag where
    new _ attrs = do
        o <- newZeroOtColorLayerT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@glyph@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otColorLayerT #glyph
-- @
getOtColorLayerTGlyph :: MonadIO m => OtColorLayerT -> m Word32
getOtColorLayerTGlyph s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@glyph@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otColorLayerT [ #glyph 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtColorLayerTGlyph :: MonadIO m => OtColorLayerT -> Word32 -> m ()
setOtColorLayerTGlyph s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OtColorLayerTGlyphFieldInfo
instance AttrInfo OtColorLayerTGlyphFieldInfo where
    type AttrBaseTypeConstraint OtColorLayerTGlyphFieldInfo = (~) OtColorLayerT
    type AttrAllowedOps OtColorLayerTGlyphFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtColorLayerTGlyphFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OtColorLayerTGlyphFieldInfo = (~)Word32
    type AttrTransferType OtColorLayerTGlyphFieldInfo = Word32
    type AttrGetType OtColorLayerTGlyphFieldInfo = Word32
    type AttrLabel OtColorLayerTGlyphFieldInfo = "glyph"
    type AttrOrigin OtColorLayerTGlyphFieldInfo = OtColorLayerT
    attrGet = getOtColorLayerTGlyph
    attrSet = setOtColorLayerTGlyph
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtColorLayerT.glyph"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtColorLayerT.html#g:attr:glyph"
        })

otColorLayerT_glyph :: AttrLabelProxy "glyph"
otColorLayerT_glyph = AttrLabelProxy

#endif


-- | Get the value of the “@color_index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otColorLayerT #colorIndex
-- @
getOtColorLayerTColorIndex :: MonadIO m => OtColorLayerT -> m Word32
getOtColorLayerTColorIndex s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Word32
    return val

-- | Set the value of the “@color_index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otColorLayerT [ #colorIndex 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtColorLayerTColorIndex :: MonadIO m => OtColorLayerT -> Word32 -> m ()
setOtColorLayerTColorIndex s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OtColorLayerTColorIndexFieldInfo
instance AttrInfo OtColorLayerTColorIndexFieldInfo where
    type AttrBaseTypeConstraint OtColorLayerTColorIndexFieldInfo = (~) OtColorLayerT
    type AttrAllowedOps OtColorLayerTColorIndexFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtColorLayerTColorIndexFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OtColorLayerTColorIndexFieldInfo = (~)Word32
    type AttrTransferType OtColorLayerTColorIndexFieldInfo = Word32
    type AttrGetType OtColorLayerTColorIndexFieldInfo = Word32
    type AttrLabel OtColorLayerTColorIndexFieldInfo = "color_index"
    type AttrOrigin OtColorLayerTColorIndexFieldInfo = OtColorLayerT
    attrGet = getOtColorLayerTColorIndex
    attrSet = setOtColorLayerTColorIndex
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtColorLayerT.colorIndex"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtColorLayerT.html#g:attr:colorIndex"
        })

otColorLayerT_colorIndex :: AttrLabelProxy "colorIndex"
otColorLayerT_colorIndex = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OtColorLayerT
type instance O.AttributeList OtColorLayerT = OtColorLayerTAttributeList
type OtColorLayerTAttributeList = ('[ '("glyph", OtColorLayerTGlyphFieldInfo), '("colorIndex", OtColorLayerTColorIndexFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOtColorLayerTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOtColorLayerTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOtColorLayerTMethod t OtColorLayerT, O.OverloadedMethod info OtColorLayerT p) => OL.IsLabel t (OtColorLayerT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOtColorLayerTMethod t OtColorLayerT, O.OverloadedMethod info OtColorLayerT p, R.HasField t OtColorLayerT p) => R.HasField t OtColorLayerT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOtColorLayerTMethod t OtColorLayerT, O.OverloadedMethodInfo info OtColorLayerT) => OL.IsLabel t (O.MethodProxy info OtColorLayerT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


