{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Data type to hold information for a \"part\" component of a math-variant glyph.
-- Large variants for stretchable math glyphs (such as parentheses) can be constructed
-- on the fly from parts.
-- 
-- /Since: 1.3.3/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.OtMathGlyphPartT
    ( 

-- * Exported types
    OtMathGlyphPartT(..)                    ,
    newZeroOtMathGlyphPartT                 ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveOtMathGlyphPartTMethod           ,
#endif



 -- * Properties


-- ** endConnectorLength #attr:endConnectorLength#
-- | The length of the connector on the ending side of the variant part

    getOtMathGlyphPartTEndConnectorLength   ,
#if defined(ENABLE_OVERLOADING)
    otMathGlyphPartT_endConnectorLength     ,
#endif
    setOtMathGlyphPartTEndConnectorLength   ,


-- ** flags #attr:flags#
-- | t'GI.HarfBuzz.Flags.OtMathGlyphPartFlagsT' flags for the part

    getOtMathGlyphPartTFlags                ,
#if defined(ENABLE_OVERLOADING)
    otMathGlyphPartT_flags                  ,
#endif
    setOtMathGlyphPartTFlags                ,


-- ** fullAdvance #attr:fullAdvance#
-- | The total advance of the part

    getOtMathGlyphPartTFullAdvance          ,
#if defined(ENABLE_OVERLOADING)
    otMathGlyphPartT_fullAdvance            ,
#endif
    setOtMathGlyphPartTFullAdvance          ,


-- ** glyph #attr:glyph#
-- | The glyph index of the variant part

    getOtMathGlyphPartTGlyph                ,
#if defined(ENABLE_OVERLOADING)
    otMathGlyphPartT_glyph                  ,
#endif
    setOtMathGlyphPartTGlyph                ,


-- ** startConnectorLength #attr:startConnectorLength#
-- | The length of the connector on the starting side of the variant part

    getOtMathGlyphPartTStartConnectorLength ,
#if defined(ENABLE_OVERLOADING)
    otMathGlyphPartT_startConnectorLength   ,
#endif
    setOtMathGlyphPartTStartConnectorLength ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.HarfBuzz.Flags as HarfBuzz.Flags

#else
import {-# SOURCE #-} qualified GI.HarfBuzz.Flags as HarfBuzz.Flags

#endif

-- | Memory-managed wrapper type.
newtype OtMathGlyphPartT = OtMathGlyphPartT (SP.ManagedPtr OtMathGlyphPartT)
    deriving (Eq)

instance SP.ManagedPtrNewtype OtMathGlyphPartT where
    toManagedPtr (OtMathGlyphPartT p) = p

foreign import ccall "hb_gobject_ot_math_glyph_part_get_type" c_hb_gobject_ot_math_glyph_part_get_type :: 
    IO GType

type instance O.ParentTypes OtMathGlyphPartT = '[]
instance O.HasParentTypes OtMathGlyphPartT

instance B.Types.TypedObject OtMathGlyphPartT where
    glibType = c_hb_gobject_ot_math_glyph_part_get_type

instance B.Types.GBoxed OtMathGlyphPartT

-- | Convert t'OtMathGlyphPartT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe OtMathGlyphPartT) where
    gvalueGType_ = c_hb_gobject_ot_math_glyph_part_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr OtMathGlyphPartT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr OtMathGlyphPartT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed OtMathGlyphPartT ptr
        else return P.Nothing
        
    

-- | Construct a t'OtMathGlyphPartT' struct initialized to zero.
newZeroOtMathGlyphPartT :: MonadIO m => m OtMathGlyphPartT
newZeroOtMathGlyphPartT = liftIO $ callocBoxedBytes 20 >>= wrapBoxed OtMathGlyphPartT

instance tag ~ 'AttrSet => Constructible OtMathGlyphPartT tag where
    new _ attrs = do
        o <- newZeroOtMathGlyphPartT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@glyph@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otMathGlyphPartT #glyph
-- @
getOtMathGlyphPartTGlyph :: MonadIO m => OtMathGlyphPartT -> m Word32
getOtMathGlyphPartTGlyph s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@glyph@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otMathGlyphPartT [ #glyph 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtMathGlyphPartTGlyph :: MonadIO m => OtMathGlyphPartT -> Word32 -> m ()
setOtMathGlyphPartTGlyph s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OtMathGlyphPartTGlyphFieldInfo
instance AttrInfo OtMathGlyphPartTGlyphFieldInfo where
    type AttrBaseTypeConstraint OtMathGlyphPartTGlyphFieldInfo = (~) OtMathGlyphPartT
    type AttrAllowedOps OtMathGlyphPartTGlyphFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtMathGlyphPartTGlyphFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OtMathGlyphPartTGlyphFieldInfo = (~)Word32
    type AttrTransferType OtMathGlyphPartTGlyphFieldInfo = Word32
    type AttrGetType OtMathGlyphPartTGlyphFieldInfo = Word32
    type AttrLabel OtMathGlyphPartTGlyphFieldInfo = "glyph"
    type AttrOrigin OtMathGlyphPartTGlyphFieldInfo = OtMathGlyphPartT
    attrGet = getOtMathGlyphPartTGlyph
    attrSet = setOtMathGlyphPartTGlyph
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtMathGlyphPartT.glyph"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtMathGlyphPartT.html#g:attr:glyph"
        })

otMathGlyphPartT_glyph :: AttrLabelProxy "glyph"
otMathGlyphPartT_glyph = AttrLabelProxy

#endif


-- | Get the value of the “@start_connector_length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otMathGlyphPartT #startConnectorLength
-- @
getOtMathGlyphPartTStartConnectorLength :: MonadIO m => OtMathGlyphPartT -> m Int32
getOtMathGlyphPartTStartConnectorLength s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@start_connector_length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otMathGlyphPartT [ #startConnectorLength 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtMathGlyphPartTStartConnectorLength :: MonadIO m => OtMathGlyphPartT -> Int32 -> m ()
setOtMathGlyphPartTStartConnectorLength s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data OtMathGlyphPartTStartConnectorLengthFieldInfo
instance AttrInfo OtMathGlyphPartTStartConnectorLengthFieldInfo where
    type AttrBaseTypeConstraint OtMathGlyphPartTStartConnectorLengthFieldInfo = (~) OtMathGlyphPartT
    type AttrAllowedOps OtMathGlyphPartTStartConnectorLengthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtMathGlyphPartTStartConnectorLengthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint OtMathGlyphPartTStartConnectorLengthFieldInfo = (~)Int32
    type AttrTransferType OtMathGlyphPartTStartConnectorLengthFieldInfo = Int32
    type AttrGetType OtMathGlyphPartTStartConnectorLengthFieldInfo = Int32
    type AttrLabel OtMathGlyphPartTStartConnectorLengthFieldInfo = "start_connector_length"
    type AttrOrigin OtMathGlyphPartTStartConnectorLengthFieldInfo = OtMathGlyphPartT
    attrGet = getOtMathGlyphPartTStartConnectorLength
    attrSet = setOtMathGlyphPartTStartConnectorLength
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtMathGlyphPartT.startConnectorLength"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtMathGlyphPartT.html#g:attr:startConnectorLength"
        })

otMathGlyphPartT_startConnectorLength :: AttrLabelProxy "startConnectorLength"
otMathGlyphPartT_startConnectorLength = AttrLabelProxy

#endif


-- | Get the value of the “@end_connector_length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otMathGlyphPartT #endConnectorLength
-- @
getOtMathGlyphPartTEndConnectorLength :: MonadIO m => OtMathGlyphPartT -> m Int32
getOtMathGlyphPartTEndConnectorLength s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@end_connector_length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otMathGlyphPartT [ #endConnectorLength 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtMathGlyphPartTEndConnectorLength :: MonadIO m => OtMathGlyphPartT -> Int32 -> m ()
setOtMathGlyphPartTEndConnectorLength s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data OtMathGlyphPartTEndConnectorLengthFieldInfo
instance AttrInfo OtMathGlyphPartTEndConnectorLengthFieldInfo where
    type AttrBaseTypeConstraint OtMathGlyphPartTEndConnectorLengthFieldInfo = (~) OtMathGlyphPartT
    type AttrAllowedOps OtMathGlyphPartTEndConnectorLengthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtMathGlyphPartTEndConnectorLengthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint OtMathGlyphPartTEndConnectorLengthFieldInfo = (~)Int32
    type AttrTransferType OtMathGlyphPartTEndConnectorLengthFieldInfo = Int32
    type AttrGetType OtMathGlyphPartTEndConnectorLengthFieldInfo = Int32
    type AttrLabel OtMathGlyphPartTEndConnectorLengthFieldInfo = "end_connector_length"
    type AttrOrigin OtMathGlyphPartTEndConnectorLengthFieldInfo = OtMathGlyphPartT
    attrGet = getOtMathGlyphPartTEndConnectorLength
    attrSet = setOtMathGlyphPartTEndConnectorLength
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtMathGlyphPartT.endConnectorLength"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtMathGlyphPartT.html#g:attr:endConnectorLength"
        })

otMathGlyphPartT_endConnectorLength :: AttrLabelProxy "endConnectorLength"
otMathGlyphPartT_endConnectorLength = AttrLabelProxy

#endif


-- | Get the value of the “@full_advance@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otMathGlyphPartT #fullAdvance
-- @
getOtMathGlyphPartTFullAdvance :: MonadIO m => OtMathGlyphPartT -> m Int32
getOtMathGlyphPartTFullAdvance s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Int32
    return val

-- | Set the value of the “@full_advance@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otMathGlyphPartT [ #fullAdvance 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtMathGlyphPartTFullAdvance :: MonadIO m => OtMathGlyphPartT -> Int32 -> m ()
setOtMathGlyphPartTFullAdvance s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data OtMathGlyphPartTFullAdvanceFieldInfo
instance AttrInfo OtMathGlyphPartTFullAdvanceFieldInfo where
    type AttrBaseTypeConstraint OtMathGlyphPartTFullAdvanceFieldInfo = (~) OtMathGlyphPartT
    type AttrAllowedOps OtMathGlyphPartTFullAdvanceFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtMathGlyphPartTFullAdvanceFieldInfo = (~) Int32
    type AttrTransferTypeConstraint OtMathGlyphPartTFullAdvanceFieldInfo = (~)Int32
    type AttrTransferType OtMathGlyphPartTFullAdvanceFieldInfo = Int32
    type AttrGetType OtMathGlyphPartTFullAdvanceFieldInfo = Int32
    type AttrLabel OtMathGlyphPartTFullAdvanceFieldInfo = "full_advance"
    type AttrOrigin OtMathGlyphPartTFullAdvanceFieldInfo = OtMathGlyphPartT
    attrGet = getOtMathGlyphPartTFullAdvance
    attrSet = setOtMathGlyphPartTFullAdvance
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtMathGlyphPartT.fullAdvance"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtMathGlyphPartT.html#g:attr:fullAdvance"
        })

otMathGlyphPartT_fullAdvance :: AttrLabelProxy "fullAdvance"
otMathGlyphPartT_fullAdvance = AttrLabelProxy

#endif


-- | Get the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otMathGlyphPartT #flags
-- @
getOtMathGlyphPartTFlags :: MonadIO m => OtMathGlyphPartT -> m [HarfBuzz.Flags.OtMathGlyphPartFlagsT]
getOtMathGlyphPartTFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otMathGlyphPartT [ #flags 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtMathGlyphPartTFlags :: MonadIO m => OtMathGlyphPartT -> [HarfBuzz.Flags.OtMathGlyphPartFlagsT] -> m ()
setOtMathGlyphPartTFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 16) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data OtMathGlyphPartTFlagsFieldInfo
instance AttrInfo OtMathGlyphPartTFlagsFieldInfo where
    type AttrBaseTypeConstraint OtMathGlyphPartTFlagsFieldInfo = (~) OtMathGlyphPartT
    type AttrAllowedOps OtMathGlyphPartTFlagsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtMathGlyphPartTFlagsFieldInfo = (~) [HarfBuzz.Flags.OtMathGlyphPartFlagsT]
    type AttrTransferTypeConstraint OtMathGlyphPartTFlagsFieldInfo = (~)[HarfBuzz.Flags.OtMathGlyphPartFlagsT]
    type AttrTransferType OtMathGlyphPartTFlagsFieldInfo = [HarfBuzz.Flags.OtMathGlyphPartFlagsT]
    type AttrGetType OtMathGlyphPartTFlagsFieldInfo = [HarfBuzz.Flags.OtMathGlyphPartFlagsT]
    type AttrLabel OtMathGlyphPartTFlagsFieldInfo = "flags"
    type AttrOrigin OtMathGlyphPartTFlagsFieldInfo = OtMathGlyphPartT
    attrGet = getOtMathGlyphPartTFlags
    attrSet = setOtMathGlyphPartTFlags
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtMathGlyphPartT.flags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtMathGlyphPartT.html#g:attr:flags"
        })

otMathGlyphPartT_flags :: AttrLabelProxy "flags"
otMathGlyphPartT_flags = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OtMathGlyphPartT
type instance O.AttributeList OtMathGlyphPartT = OtMathGlyphPartTAttributeList
type OtMathGlyphPartTAttributeList = ('[ '("glyph", OtMathGlyphPartTGlyphFieldInfo), '("startConnectorLength", OtMathGlyphPartTStartConnectorLengthFieldInfo), '("endConnectorLength", OtMathGlyphPartTEndConnectorLengthFieldInfo), '("fullAdvance", OtMathGlyphPartTFullAdvanceFieldInfo), '("flags", OtMathGlyphPartTFlagsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOtMathGlyphPartTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOtMathGlyphPartTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOtMathGlyphPartTMethod t OtMathGlyphPartT, O.OverloadedMethod info OtMathGlyphPartT p) => OL.IsLabel t (OtMathGlyphPartT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOtMathGlyphPartTMethod t OtMathGlyphPartT, O.OverloadedMethod info OtMathGlyphPartT p, R.HasField t OtMathGlyphPartT p) => R.HasField t OtMathGlyphPartT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOtMathGlyphPartTMethod t OtMathGlyphPartT, O.OverloadedMethodInfo info OtMathGlyphPartT) => OL.IsLabel t (O.MethodProxy info OtMathGlyphPartT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


