{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAttrClass@ structure stores the type and operations for
-- a particular type of attribute.
-- 
-- The functions in this structure should not be called directly. Instead,
-- one should use the wrapper functions provided for @PangoAttribute@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.AttrClass
    ( 

-- * Exported types
    AttrClass(..)                           ,
    newZeroAttrClass                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAttrClassMethod                  ,
#endif



 -- * Properties


-- ** copy #attr:copy#
-- | function to duplicate an attribute of this type
--   (see 'GI.Pango.Structs.Attribute.attributeCopy')

#if defined(ENABLE_OVERLOADING)
    attrClass_copy                          ,
#endif
    clearAttrClassCopy                      ,
    getAttrClassCopy                        ,
    setAttrClassCopy                        ,


-- ** destroy #attr:destroy#
-- | function to free an attribute of this type
--   (see 'GI.Pango.Structs.Attribute.attributeDestroy')

#if defined(ENABLE_OVERLOADING)
    attrClass_destroy                       ,
#endif
    clearAttrClassDestroy                   ,
    getAttrClassDestroy                     ,
    setAttrClassDestroy                     ,


-- ** equal #attr:equal#
-- | function to check two attributes of this type for equality
--   (see 'GI.Pango.Structs.Attribute.attributeEqual')

#if defined(ENABLE_OVERLOADING)
    attrClass_equal                         ,
#endif
    clearAttrClassEqual                     ,
    getAttrClassEqual                       ,
    setAttrClassEqual                       ,


-- ** type #attr:type#
-- | the type ID for this attribute

#if defined(ENABLE_OVERLOADING)
    attrClass_type                          ,
#endif
    getAttrClassType                        ,
    setAttrClassType                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums

#endif

-- | Memory-managed wrapper type.
newtype AttrClass = AttrClass (SP.ManagedPtr AttrClass)
    deriving (Eq)

instance SP.ManagedPtrNewtype AttrClass where
    toManagedPtr (AttrClass p) = p

instance BoxedPtr AttrClass where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 32 >=> B.ManagedPtr.wrapPtr AttrClass)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr AttrClass where
    boxedPtrCalloc = callocBytes 32


-- | Construct a t'AttrClass' struct initialized to zero.
newZeroAttrClass :: MonadIO m => m AttrClass
newZeroAttrClass = liftIO $ boxedPtrCalloc >>= wrapPtr AttrClass

instance tag ~ 'AttrSet => Constructible AttrClass tag where
    new _ attrs = do
        o <- newZeroAttrClass
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrClass #type
-- @
getAttrClassType :: MonadIO m => AttrClass -> m Pango.Enums.AttrType
getAttrClassType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrClass [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrClassType :: MonadIO m => AttrClass -> Pango.Enums.AttrType -> m ()
setAttrClassType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data AttrClassTypeFieldInfo
instance AttrInfo AttrClassTypeFieldInfo where
    type AttrBaseTypeConstraint AttrClassTypeFieldInfo = (~) AttrClass
    type AttrAllowedOps AttrClassTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AttrClassTypeFieldInfo = (~) Pango.Enums.AttrType
    type AttrTransferTypeConstraint AttrClassTypeFieldInfo = (~)Pango.Enums.AttrType
    type AttrTransferType AttrClassTypeFieldInfo = Pango.Enums.AttrType
    type AttrGetType AttrClassTypeFieldInfo = Pango.Enums.AttrType
    type AttrLabel AttrClassTypeFieldInfo = "type"
    type AttrOrigin AttrClassTypeFieldInfo = AttrClass
    attrGet = getAttrClassType
    attrSet = setAttrClassType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrClass.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrClass.html#g:attr:type"
        })

attrClass_type :: AttrLabelProxy "type"
attrClass_type = AttrLabelProxy

#endif


-- | Get the value of the “@copy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrClass #copy
-- @
getAttrClassCopy :: MonadIO m => AttrClass -> m (Maybe Pango.Callbacks.AttrClassCopyFieldCallback)
getAttrClassCopy s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr Pango.Callbacks.C_AttrClassCopyFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Pango.Callbacks.dynamic_AttrClassCopyFieldCallback val'
        return val''
    return result

-- | Set the value of the “@copy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrClass [ #copy 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrClassCopy :: MonadIO m => AttrClass -> FunPtr Pango.Callbacks.C_AttrClassCopyFieldCallback -> m ()
setAttrClassCopy s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr Pango.Callbacks.C_AttrClassCopyFieldCallback)

-- | Set the value of the “@copy@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #copy
-- @
clearAttrClassCopy :: MonadIO m => AttrClass -> m ()
clearAttrClassCopy s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr Pango.Callbacks.C_AttrClassCopyFieldCallback)

#if defined(ENABLE_OVERLOADING)
data AttrClassCopyFieldInfo
instance AttrInfo AttrClassCopyFieldInfo where
    type AttrBaseTypeConstraint AttrClassCopyFieldInfo = (~) AttrClass
    type AttrAllowedOps AttrClassCopyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttrClassCopyFieldInfo = (~) (FunPtr Pango.Callbacks.C_AttrClassCopyFieldCallback)
    type AttrTransferTypeConstraint AttrClassCopyFieldInfo = (~)Pango.Callbacks.AttrClassCopyFieldCallback
    type AttrTransferType AttrClassCopyFieldInfo = (FunPtr Pango.Callbacks.C_AttrClassCopyFieldCallback)
    type AttrGetType AttrClassCopyFieldInfo = Maybe Pango.Callbacks.AttrClassCopyFieldCallback
    type AttrLabel AttrClassCopyFieldInfo = "copy"
    type AttrOrigin AttrClassCopyFieldInfo = AttrClass
    attrGet = getAttrClassCopy
    attrSet = setAttrClassCopy
    attrConstruct = undefined
    attrClear = clearAttrClassCopy
    attrTransfer _ v = do
        Pango.Callbacks.mk_AttrClassCopyFieldCallback (Pango.Callbacks.wrap_AttrClassCopyFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrClass.copy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrClass.html#g:attr:copy"
        })

attrClass_copy :: AttrLabelProxy "copy"
attrClass_copy = AttrLabelProxy

#endif


-- | Get the value of the “@destroy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrClass #destroy
-- @
getAttrClassDestroy :: MonadIO m => AttrClass -> m (Maybe Pango.Callbacks.AttrClassDestroyFieldCallback)
getAttrClassDestroy s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (FunPtr Pango.Callbacks.C_AttrClassDestroyFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Pango.Callbacks.dynamic_AttrClassDestroyFieldCallback val'
        return val''
    return result

-- | Set the value of the “@destroy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrClass [ #destroy 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrClassDestroy :: MonadIO m => AttrClass -> FunPtr Pango.Callbacks.C_AttrClassDestroyFieldCallback -> m ()
setAttrClassDestroy s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: FunPtr Pango.Callbacks.C_AttrClassDestroyFieldCallback)

-- | Set the value of the “@destroy@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #destroy
-- @
clearAttrClassDestroy :: MonadIO m => AttrClass -> m ()
clearAttrClassDestroy s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullFunPtr :: FunPtr Pango.Callbacks.C_AttrClassDestroyFieldCallback)

#if defined(ENABLE_OVERLOADING)
data AttrClassDestroyFieldInfo
instance AttrInfo AttrClassDestroyFieldInfo where
    type AttrBaseTypeConstraint AttrClassDestroyFieldInfo = (~) AttrClass
    type AttrAllowedOps AttrClassDestroyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttrClassDestroyFieldInfo = (~) (FunPtr Pango.Callbacks.C_AttrClassDestroyFieldCallback)
    type AttrTransferTypeConstraint AttrClassDestroyFieldInfo = (~)Pango.Callbacks.AttrClassDestroyFieldCallback
    type AttrTransferType AttrClassDestroyFieldInfo = (FunPtr Pango.Callbacks.C_AttrClassDestroyFieldCallback)
    type AttrGetType AttrClassDestroyFieldInfo = Maybe Pango.Callbacks.AttrClassDestroyFieldCallback
    type AttrLabel AttrClassDestroyFieldInfo = "destroy"
    type AttrOrigin AttrClassDestroyFieldInfo = AttrClass
    attrGet = getAttrClassDestroy
    attrSet = setAttrClassDestroy
    attrConstruct = undefined
    attrClear = clearAttrClassDestroy
    attrTransfer _ v = do
        Pango.Callbacks.mk_AttrClassDestroyFieldCallback (Pango.Callbacks.wrap_AttrClassDestroyFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrClass.destroy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrClass.html#g:attr:destroy"
        })

attrClass_destroy :: AttrLabelProxy "destroy"
attrClass_destroy = AttrLabelProxy

#endif


-- | Get the value of the “@equal@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrClass #equal
-- @
getAttrClassEqual :: MonadIO m => AttrClass -> m (Maybe Pango.Callbacks.AttrClassEqualFieldCallback)
getAttrClassEqual s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (FunPtr Pango.Callbacks.C_AttrClassEqualFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Pango.Callbacks.dynamic_AttrClassEqualFieldCallback val'
        return val''
    return result

-- | Set the value of the “@equal@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrClass [ #equal 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrClassEqual :: MonadIO m => AttrClass -> FunPtr Pango.Callbacks.C_AttrClassEqualFieldCallback -> m ()
setAttrClassEqual s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FunPtr Pango.Callbacks.C_AttrClassEqualFieldCallback)

-- | Set the value of the “@equal@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #equal
-- @
clearAttrClassEqual :: MonadIO m => AttrClass -> m ()
clearAttrClassEqual s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullFunPtr :: FunPtr Pango.Callbacks.C_AttrClassEqualFieldCallback)

#if defined(ENABLE_OVERLOADING)
data AttrClassEqualFieldInfo
instance AttrInfo AttrClassEqualFieldInfo where
    type AttrBaseTypeConstraint AttrClassEqualFieldInfo = (~) AttrClass
    type AttrAllowedOps AttrClassEqualFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttrClassEqualFieldInfo = (~) (FunPtr Pango.Callbacks.C_AttrClassEqualFieldCallback)
    type AttrTransferTypeConstraint AttrClassEqualFieldInfo = (~)Pango.Callbacks.AttrClassEqualFieldCallback
    type AttrTransferType AttrClassEqualFieldInfo = (FunPtr Pango.Callbacks.C_AttrClassEqualFieldCallback)
    type AttrGetType AttrClassEqualFieldInfo = Maybe Pango.Callbacks.AttrClassEqualFieldCallback
    type AttrLabel AttrClassEqualFieldInfo = "equal"
    type AttrOrigin AttrClassEqualFieldInfo = AttrClass
    attrGet = getAttrClassEqual
    attrSet = setAttrClassEqual
    attrConstruct = undefined
    attrClear = clearAttrClassEqual
    attrTransfer _ v = do
        Pango.Callbacks.mk_AttrClassEqualFieldCallback (Pango.Callbacks.wrap_AttrClassEqualFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrClass.equal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrClass.html#g:attr:equal"
        })

attrClass_equal :: AttrLabelProxy "equal"
attrClass_equal = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AttrClass
type instance O.AttributeList AttrClass = AttrClassAttributeList
type AttrClassAttributeList = ('[ '("type", AttrClassTypeFieldInfo), '("copy", AttrClassCopyFieldInfo), '("destroy", AttrClassDestroyFieldInfo), '("equal", AttrClassEqualFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttrClassMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttrClassMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttrClassMethod t AttrClass, O.OverloadedMethod info AttrClass p) => OL.IsLabel t (AttrClass -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttrClassMethod t AttrClass, O.OverloadedMethod info AttrClass p, R.HasField t AttrClass p) => R.HasField t AttrClass p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttrClassMethod t AttrClass, O.OverloadedMethodInfo info AttrClass) => OL.IsLabel t (O.MethodProxy info AttrClass) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


