#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 206
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 70
#define ALIAS_COUNT 4
#define TOKEN_COUNT 32
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 7

enum ts_symbol_identifiers {
  sym__ident = 1,
  anon_sym_module = 2,
  anon_sym_LBRACE = 3,
  anon_sym_RBRACE = 4,
  anon_sym_SEMI = 5,
  anon_sym_AT = 6,
  sym_doc_comment = 7,
  sym_comment = 8,
  anon_sym_DOT = 9,
  anon_sym_import = 10,
  anon_sym_DOT_STAR = 11,
  anon_sym_annotation = 12,
  anon_sym_COLON_COLON = 13,
  anon_sym_struct = 14,
  anon_sym_union = 15,
  anon_sym_type = 16,
  anon_sym_EQ = 17,
  anon_sym_newtype = 18,
  anon_sym_LT = 19,
  anon_sym_COMMA = 20,
  anon_sym_GT = 21,
  anon_sym_COLON = 22,
  anon_sym_LBRACK = 23,
  anon_sym_RBRACK = 24,
  anon_sym_DQUOTE = 25,
  aux_sym__string_content_token1 = 26,
  sym_escape_sequence = 27,
  sym_number = 28,
  sym_true = 29,
  sym_false = 30,
  sym_null = 31,
  sym_adl = 32,
  sym__aordc = 33,
  sym_annon = 34,
  sym_scoped_name = 35,
  sym__import = 36,
  sym_import_star = 37,
  sym_import = 38,
  sym__top = 39,
  sym__remote_annon = 40,
  sym_module_annon = 41,
  sym_decl_annon = 42,
  sym_field_annon = 43,
  sym__decl = 44,
  sym_struct = 45,
  sym_union = 46,
  sym_type_alias = 47,
  sym_newtype = 48,
  sym_type_param = 49,
  sym_type_expr_params = 50,
  sym_field = 51,
  sym_type_expr = 52,
  sym_default_val = 53,
  sym_json = 54,
  sym__value = 55,
  sym_object = 56,
  sym_pair = 57,
  sym_array = 58,
  sym_string = 59,
  aux_sym__string_content = 60,
  aux_sym_adl_repeat1 = 61,
  aux_sym_adl_repeat2 = 62,
  aux_sym_adl_repeat3 = 63,
  aux_sym_scoped_name_repeat1 = 64,
  aux_sym_struct_repeat1 = 65,
  aux_sym_type_param_repeat1 = 66,
  aux_sym_type_expr_params_repeat1 = 67,
  aux_sym_object_repeat1 = 68,
  aux_sym_array_repeat1 = 69,
  alias_sym_fname = 70,
  alias_sym_key = 71,
  alias_sym_name = 72,
  alias_sym_param = 73,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__ident] = "_ident",
  [anon_sym_module] = "module",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_SEMI] = ";",
  [anon_sym_AT] = "@",
  [sym_doc_comment] = "doc_comment",
  [sym_comment] = "comment",
  [anon_sym_DOT] = ".",
  [anon_sym_import] = "import",
  [anon_sym_DOT_STAR] = ".*",
  [anon_sym_annotation] = "annotation",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_struct] = "struct",
  [anon_sym_union] = "union",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_newtype] = "newtype",
  [anon_sym_LT] = "<",
  [anon_sym_COMMA] = ",",
  [anon_sym_GT] = ">",
  [anon_sym_COLON] = ":",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__string_content_token1] = "_string_content_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_number] = "number",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_adl] = "adl",
  [sym__aordc] = "_aordc",
  [sym_annon] = "annon",
  [sym_scoped_name] = "scoped_name",
  [sym__import] = "_import",
  [sym_import_star] = "import_star",
  [sym_import] = "import",
  [sym__top] = "_top",
  [sym__remote_annon] = "_remote_annon",
  [sym_module_annon] = "module_annon",
  [sym_decl_annon] = "decl_annon",
  [sym_field_annon] = "field_annon",
  [sym__decl] = "_decl",
  [sym_struct] = "struct",
  [sym_union] = "union",
  [sym_type_alias] = "type_alias",
  [sym_newtype] = "newtype",
  [sym_type_param] = "type_param",
  [sym_type_expr_params] = "type_expr_params",
  [sym_field] = "field",
  [sym_type_expr] = "type_expr",
  [sym_default_val] = "default_val",
  [sym_json] = "json",
  [sym__value] = "_value",
  [sym_object] = "object",
  [sym_pair] = "pair",
  [sym_array] = "array",
  [sym_string] = "string",
  [aux_sym__string_content] = "_string_content",
  [aux_sym_adl_repeat1] = "adl_repeat1",
  [aux_sym_adl_repeat2] = "adl_repeat2",
  [aux_sym_adl_repeat3] = "adl_repeat3",
  [aux_sym_scoped_name_repeat1] = "scoped_name_repeat1",
  [aux_sym_struct_repeat1] = "struct_repeat1",
  [aux_sym_type_param_repeat1] = "type_param_repeat1",
  [aux_sym_type_expr_params_repeat1] = "type_expr_params_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [alias_sym_fname] = "fname",
  [alias_sym_key] = "key",
  [alias_sym_name] = "name",
  [alias_sym_param] = "param",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__ident] = sym__ident,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_AT] = anon_sym_AT,
  [sym_doc_comment] = sym_doc_comment,
  [sym_comment] = sym_comment,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT_STAR] = anon_sym_DOT_STAR,
  [anon_sym_annotation] = anon_sym_annotation,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_newtype] = anon_sym_newtype,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__string_content_token1] = aux_sym__string_content_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_number] = sym_number,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_adl] = sym_adl,
  [sym__aordc] = sym__aordc,
  [sym_annon] = sym_annon,
  [sym_scoped_name] = sym_scoped_name,
  [sym__import] = sym__import,
  [sym_import_star] = sym_import_star,
  [sym_import] = sym_import,
  [sym__top] = sym__top,
  [sym__remote_annon] = sym__remote_annon,
  [sym_module_annon] = sym_module_annon,
  [sym_decl_annon] = sym_decl_annon,
  [sym_field_annon] = sym_field_annon,
  [sym__decl] = sym__decl,
  [sym_struct] = sym_struct,
  [sym_union] = sym_union,
  [sym_type_alias] = sym_type_alias,
  [sym_newtype] = sym_newtype,
  [sym_type_param] = sym_type_param,
  [sym_type_expr_params] = sym_type_expr_params,
  [sym_field] = sym_field,
  [sym_type_expr] = sym_type_expr,
  [sym_default_val] = sym_default_val,
  [sym_json] = sym_json,
  [sym__value] = sym__value,
  [sym_object] = sym_object,
  [sym_pair] = sym_pair,
  [sym_array] = sym_array,
  [sym_string] = sym_string,
  [aux_sym__string_content] = aux_sym__string_content,
  [aux_sym_adl_repeat1] = aux_sym_adl_repeat1,
  [aux_sym_adl_repeat2] = aux_sym_adl_repeat2,
  [aux_sym_adl_repeat3] = aux_sym_adl_repeat3,
  [aux_sym_scoped_name_repeat1] = aux_sym_scoped_name_repeat1,
  [aux_sym_struct_repeat1] = aux_sym_struct_repeat1,
  [aux_sym_type_param_repeat1] = aux_sym_type_param_repeat1,
  [aux_sym_type_expr_params_repeat1] = aux_sym_type_expr_params_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [alias_sym_fname] = alias_sym_fname,
  [alias_sym_key] = alias_sym_key,
  [alias_sym_name] = alias_sym_name,
  [alias_sym_param] = alias_sym_param,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__ident] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [sym_doc_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_annotation] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_newtype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_adl] = {
    .visible = true,
    .named = true,
  },
  [sym__aordc] = {
    .visible = false,
    .named = true,
  },
  [sym_annon] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_name] = {
    .visible = true,
    .named = true,
  },
  [sym__import] = {
    .visible = false,
    .named = true,
  },
  [sym_import_star] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym__top] = {
    .visible = false,
    .named = true,
  },
  [sym__remote_annon] = {
    .visible = false,
    .named = true,
  },
  [sym_module_annon] = {
    .visible = true,
    .named = true,
  },
  [sym_decl_annon] = {
    .visible = true,
    .named = true,
  },
  [sym_field_annon] = {
    .visible = true,
    .named = true,
  },
  [sym__decl] = {
    .visible = false,
    .named = true,
  },
  [sym_struct] = {
    .visible = true,
    .named = true,
  },
  [sym_union] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_newtype] = {
    .visible = true,
    .named = true,
  },
  [sym_type_param] = {
    .visible = true,
    .named = true,
  },
  [sym_type_expr_params] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_type_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_default_val] = {
    .visible = true,
    .named = true,
  },
  [sym_json] = {
    .visible = true,
    .named = true,
  },
  [sym__value] = {
    .visible = false,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__string_content] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_adl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_adl_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_adl_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_scoped_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_param_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_expr_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_fname] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_key] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_param] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_value = 1,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_value, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_key,
  },
  [2] = {
    [1] = alias_sym_name,
  },
  [3] = {
    [1] = alias_sym_fname,
  },
  [4] = {
    [2] = alias_sym_name,
  },
  [5] = {
    [1] = alias_sym_param,
  },
  [6] = {
    [2] = alias_sym_fname,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_type_expr, 2,
    sym_type_expr,
    alias_sym_param,
  sym_string, 2,
    sym_string,
    alias_sym_key,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(17);
      if (lookahead == '"') ADVANCE(37);
      if (lookahead == ',') ADVANCE(29);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(24);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(43);
      if (lookahead == ':') ADVANCE(34);
      if (lookahead == ';') ADVANCE(20);
      if (lookahead == '<') ADVANCE(28);
      if (lookahead == '=') ADVANCE(27);
      if (lookahead == '>') ADVANCE(30);
      if (lookahead == '@') ADVANCE(21);
      if (lookahead == '[') ADVANCE(35);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == ']') ADVANCE(36);
      if (lookahead == '{') ADVANCE(18);
      if (lookahead == '}') ADVANCE(19);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(44);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(31);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(23);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(22);
      if (lookahead != 0) ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(5)
      if (lookahead == '"') ADVANCE(37);
      if (lookahead == '/') ADVANCE(40);
      if (lookahead == '\\') ADVANCE(12);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(38);
      if (lookahead != 0) ADVANCE(41);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(37);
      if (lookahead == ',') ADVANCE(29);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(24);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(43);
      if (lookahead == ':') ADVANCE(11);
      if (lookahead == ';') ADVANCE(20);
      if (lookahead == '<') ADVANCE(28);
      if (lookahead == '=') ADVANCE(27);
      if (lookahead == '>') ADVANCE(30);
      if (lookahead == '@') ADVANCE(21);
      if (lookahead == '[') ADVANCE(35);
      if (lookahead == '{') ADVANCE(18);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(44);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(31);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(37);
      if (lookahead == '/') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == ',') ADVANCE(29);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ':') ADVANCE(33);
      if (lookahead == ';') ADVANCE(20);
      if (lookahead == '@') ADVANCE(21);
      if (lookahead == ']') ADVANCE(36);
      if (lookahead == '}') ADVANCE(19);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(31);
      END_STATE();
    case 7:
      if (lookahead == '-') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 8:
      if (lookahead == '/') ADVANCE(15);
      END_STATE();
    case 9:
      if (lookahead == '/') ADVANCE(14);
      END_STATE();
    case 10:
      if (lookahead == '0') ADVANCE(43);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(44);
      END_STATE();
    case 11:
      if (lookahead == ':') ADVANCE(26);
      END_STATE();
    case 12:
      if (lookahead == '"' ||
          lookahead == '/' ||
          lookahead == '\\' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't' ||
          lookahead == 'u') ADVANCE(42);
      END_STATE();
    case 13:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(1);
      END_STATE();
    case 15:
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(1);
      if (lookahead == '/') ADVANCE(2);
      END_STATE();
    case 16:
      if (eof) ADVANCE(17);
      if (lookahead == '"') ADVANCE(37);
      if (lookahead == ',') ADVANCE(29);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(24);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(43);
      if (lookahead == ':') ADVANCE(34);
      if (lookahead == ';') ADVANCE(20);
      if (lookahead == '<') ADVANCE(28);
      if (lookahead == '=') ADVANCE(27);
      if (lookahead == '>') ADVANCE(30);
      if (lookahead == '@') ADVANCE(21);
      if (lookahead == '[') ADVANCE(35);
      if (lookahead == ']') ADVANCE(36);
      if (lookahead == '{') ADVANCE(18);
      if (lookahead == '}') ADVANCE(19);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(44);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(31);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_doc_comment);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '*') ADVANCE(25);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_DOT_STAR);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(sym__ident);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(32);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(31);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(sym__ident);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(26);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(aux_sym__string_content_token1);
      if (lookahead == '/') ADVANCE(40);
      if (lookahead == '\t' ||
          (11 <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(38);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(41);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(aux_sym__string_content_token1);
      if (lookahead == '/') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(41);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(aux_sym__string_content_token1);
      if (lookahead == '/') ADVANCE(39);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(41);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym__string_content_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(41);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(45);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(7);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(45);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(7);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(44);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(7);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(45);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'f') ADVANCE(2);
      if (lookahead == 'i') ADVANCE(3);
      if (lookahead == 'm') ADVANCE(4);
      if (lookahead == 'n') ADVANCE(5);
      if (lookahead == 's') ADVANCE(6);
      if (lookahead == 't') ADVANCE(7);
      if (lookahead == 'u') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(9);
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(10);
      END_STATE();
    case 3:
      if (lookahead == 'm') ADVANCE(11);
      END_STATE();
    case 4:
      if (lookahead == 'o') ADVANCE(12);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'u') ADVANCE(14);
      END_STATE();
    case 6:
      if (lookahead == 't') ADVANCE(15);
      END_STATE();
    case 7:
      if (lookahead == 'r') ADVANCE(16);
      if (lookahead == 'y') ADVANCE(17);
      END_STATE();
    case 8:
      if (lookahead == 'n') ADVANCE(18);
      END_STATE();
    case 9:
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(20);
      END_STATE();
    case 11:
      if (lookahead == 'p') ADVANCE(21);
      END_STATE();
    case 12:
      if (lookahead == 'd') ADVANCE(22);
      END_STATE();
    case 13:
      if (lookahead == 'w') ADVANCE(23);
      END_STATE();
    case 14:
      if (lookahead == 'l') ADVANCE(24);
      END_STATE();
    case 15:
      if (lookahead == 'r') ADVANCE(25);
      END_STATE();
    case 16:
      if (lookahead == 'u') ADVANCE(26);
      END_STATE();
    case 17:
      if (lookahead == 'p') ADVANCE(27);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(28);
      END_STATE();
    case 19:
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(30);
      END_STATE();
    case 21:
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 22:
      if (lookahead == 'u') ADVANCE(32);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(33);
      END_STATE();
    case 24:
      if (lookahead == 'l') ADVANCE(34);
      END_STATE();
    case 25:
      if (lookahead == 'u') ADVANCE(35);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 28:
      if (lookahead == 'o') ADVANCE(38);
      END_STATE();
    case 29:
      if (lookahead == 't') ADVANCE(39);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 32:
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 33:
      if (lookahead == 'y') ADVANCE(43);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 35:
      if (lookahead == 'c') ADVANCE(44);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(45);
      END_STATE();
    case 39:
      if (lookahead == 'a') ADVANCE(46);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 41:
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 43:
      if (lookahead == 'p') ADVANCE(49);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(52);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 51:
      if (lookahead == 'i') ADVANCE(53);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_newtype);
      END_STATE();
    case 53:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_annotation);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 4},
  [7] = {.lex_state = 4},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 4},
  [14] = {.lex_state = 6},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 6},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
  [74] = {.lex_state = 0},
  [75] = {.lex_state = 0},
  [76] = {.lex_state = 0},
  [77] = {.lex_state = 0},
  [78] = {.lex_state = 0},
  [79] = {.lex_state = 0},
  [80] = {.lex_state = 0},
  [81] = {.lex_state = 0},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 3},
  [85] = {.lex_state = 0},
  [86] = {.lex_state = 0},
  [87] = {.lex_state = 0},
  [88] = {.lex_state = 0},
  [89] = {.lex_state = 0},
  [90] = {.lex_state = 0},
  [91] = {.lex_state = 0},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 0},
  [95] = {.lex_state = 0},
  [96] = {.lex_state = 3},
  [97] = {.lex_state = 0},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 3},
  [100] = {.lex_state = 0},
  [101] = {.lex_state = 0},
  [102] = {.lex_state = 0},
  [103] = {.lex_state = 0},
  [104] = {.lex_state = 0},
  [105] = {.lex_state = 0},
  [106] = {.lex_state = 0},
  [107] = {.lex_state = 0},
  [108] = {.lex_state = 0},
  [109] = {.lex_state = 0},
  [110] = {.lex_state = 0},
  [111] = {.lex_state = 0},
  [112] = {.lex_state = 0},
  [113] = {.lex_state = 0},
  [114] = {.lex_state = 0},
  [115] = {.lex_state = 0},
  [116] = {.lex_state = 0},
  [117] = {.lex_state = 0},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 0},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 0},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 0},
  [124] = {.lex_state = 0},
  [125] = {.lex_state = 0},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 0},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 0},
  [133] = {.lex_state = 0},
  [134] = {.lex_state = 0},
  [135] = {.lex_state = 0},
  [136] = {.lex_state = 0},
  [137] = {.lex_state = 0},
  [138] = {.lex_state = 0},
  [139] = {.lex_state = 0},
  [140] = {.lex_state = 0},
  [141] = {.lex_state = 0},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 0},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 0},
  [150] = {.lex_state = 0},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 0},
  [154] = {.lex_state = 0},
  [155] = {.lex_state = 0},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 0},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 0},
  [171] = {.lex_state = 0},
  [172] = {.lex_state = 0},
  [173] = {.lex_state = 0},
  [174] = {.lex_state = 0},
  [175] = {.lex_state = 0},
  [176] = {.lex_state = 0},
  [177] = {.lex_state = 0},
  [178] = {.lex_state = 0},
  [179] = {.lex_state = 6},
  [180] = {.lex_state = 0},
  [181] = {.lex_state = 0},
  [182] = {.lex_state = 0},
  [183] = {.lex_state = 0},
  [184] = {.lex_state = 0},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 0},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 0},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 0},
  [191] = {.lex_state = 0},
  [192] = {.lex_state = 0},
  [193] = {.lex_state = 0},
  [194] = {.lex_state = 0},
  [195] = {.lex_state = 0},
  [196] = {.lex_state = 0},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 0},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 0},
  [205] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__ident] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [sym_doc_comment] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT_STAR] = ACTIONS(1),
    [anon_sym_annotation] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_newtype] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
  },
  [1] = {
    [sym_adl] = STATE(204),
    [sym__aordc] = STATE(79),
    [sym_annon] = STATE(79),
    [aux_sym_adl_repeat1] = STATE(79),
    [anon_sym_module] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(7),
    [sym_doc_comment] = ACTIONS(9),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(11), 1,
      anon_sym_RBRACE,
    ACTIONS(13), 1,
      sym_doc_comment,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_annotation,
    ACTIONS(19), 1,
      anon_sym_struct,
    ACTIONS(21), 1,
      anon_sym_union,
    ACTIONS(23), 1,
      anon_sym_type,
    ACTIONS(25), 1,
      anon_sym_newtype,
    STATE(47), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
    STATE(15), 4,
      sym__import,
      sym_import_star,
      sym_import,
      aux_sym_adl_repeat2,
    STATE(11), 11,
      sym__top,
      sym__remote_annon,
      sym_module_annon,
      sym_decl_annon,
      sym_field_annon,
      sym__decl,
      sym_struct,
      sym_union,
      sym_type_alias,
      sym_newtype,
      aux_sym_adl_repeat3,
  [55] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(13), 1,
      sym_doc_comment,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_annotation,
    ACTIONS(19), 1,
      anon_sym_struct,
    ACTIONS(21), 1,
      anon_sym_union,
    ACTIONS(23), 1,
      anon_sym_type,
    ACTIONS(25), 1,
      anon_sym_newtype,
    ACTIONS(27), 1,
      anon_sym_RBRACE,
    STATE(47), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
    STATE(2), 4,
      sym__import,
      sym_import_star,
      sym_import,
      aux_sym_adl_repeat2,
    STATE(8), 11,
      sym__top,
      sym__remote_annon,
      sym_module_annon,
      sym_decl_annon,
      sym_field_annon,
      sym__decl,
      sym_struct,
      sym_union,
      sym_type_alias,
      sym_newtype,
      aux_sym_adl_repeat3,
  [110] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(13), 1,
      sym_doc_comment,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_annotation,
    ACTIONS(19), 1,
      anon_sym_struct,
    ACTIONS(21), 1,
      anon_sym_union,
    ACTIONS(23), 1,
      anon_sym_type,
    ACTIONS(25), 1,
      anon_sym_newtype,
    ACTIONS(27), 1,
      anon_sym_RBRACE,
    STATE(47), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
    STATE(15), 4,
      sym__import,
      sym_import_star,
      sym_import,
      aux_sym_adl_repeat2,
    STATE(8), 11,
      sym__top,
      sym__remote_annon,
      sym_module_annon,
      sym_decl_annon,
      sym_field_annon,
      sym__decl,
      sym_struct,
      sym_union,
      sym_type_alias,
      sym_newtype,
      aux_sym_adl_repeat3,
  [165] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(13), 1,
      sym_doc_comment,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_annotation,
    ACTIONS(19), 1,
      anon_sym_struct,
    ACTIONS(21), 1,
      anon_sym_union,
    ACTIONS(23), 1,
      anon_sym_type,
    ACTIONS(25), 1,
      anon_sym_newtype,
    ACTIONS(29), 1,
      anon_sym_RBRACE,
    STATE(47), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
    STATE(4), 4,
      sym__import,
      sym_import_star,
      sym_import,
      aux_sym_adl_repeat2,
    STATE(9), 11,
      sym__top,
      sym__remote_annon,
      sym_module_annon,
      sym_decl_annon,
      sym_field_annon,
      sym__decl,
      sym_struct,
      sym_union,
      sym_type_alias,
      sym_newtype,
      aux_sym_adl_repeat3,
  [220] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_DOT,
    ACTIONS(31), 9,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
      sym_true,
      sym_false,
      sym_null,
    ACTIONS(33), 13,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_DOT_STAR,
      anon_sym_COLON_COLON,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      sym_number,
  [253] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_DOT,
    ACTIONS(37), 9,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
      sym_true,
      sym_false,
      sym_null,
    ACTIONS(39), 13,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_DOT_STAR,
      anon_sym_COLON_COLON,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      sym_number,
  [286] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(11), 1,
      anon_sym_RBRACE,
    ACTIONS(13), 1,
      sym_doc_comment,
    ACTIONS(17), 1,
      anon_sym_annotation,
    ACTIONS(19), 1,
      anon_sym_struct,
    ACTIONS(21), 1,
      anon_sym_union,
    ACTIONS(23), 1,
      anon_sym_type,
    ACTIONS(25), 1,
      anon_sym_newtype,
    STATE(47), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
    STATE(10), 11,
      sym__top,
      sym__remote_annon,
      sym_module_annon,
      sym_decl_annon,
      sym_field_annon,
      sym__decl,
      sym_struct,
      sym_union,
      sym_type_alias,
      sym_newtype,
      aux_sym_adl_repeat3,
  [332] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(13), 1,
      sym_doc_comment,
    ACTIONS(17), 1,
      anon_sym_annotation,
    ACTIONS(19), 1,
      anon_sym_struct,
    ACTIONS(21), 1,
      anon_sym_union,
    ACTIONS(23), 1,
      anon_sym_type,
    ACTIONS(25), 1,
      anon_sym_newtype,
    ACTIONS(27), 1,
      anon_sym_RBRACE,
    STATE(47), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
    STATE(10), 11,
      sym__top,
      sym__remote_annon,
      sym_module_annon,
      sym_decl_annon,
      sym_field_annon,
      sym__decl,
      sym_struct,
      sym_union,
      sym_type_alias,
      sym_newtype,
      aux_sym_adl_repeat3,
  [378] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_RBRACE,
    ACTIONS(43), 1,
      anon_sym_AT,
    ACTIONS(46), 1,
      sym_doc_comment,
    ACTIONS(49), 1,
      anon_sym_annotation,
    ACTIONS(52), 1,
      anon_sym_struct,
    ACTIONS(55), 1,
      anon_sym_union,
    ACTIONS(58), 1,
      anon_sym_type,
    ACTIONS(61), 1,
      anon_sym_newtype,
    STATE(47), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
    STATE(10), 11,
      sym__top,
      sym__remote_annon,
      sym_module_annon,
      sym_decl_annon,
      sym_field_annon,
      sym__decl,
      sym_struct,
      sym_union,
      sym_type_alias,
      sym_newtype,
      aux_sym_adl_repeat3,
  [424] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(13), 1,
      sym_doc_comment,
    ACTIONS(17), 1,
      anon_sym_annotation,
    ACTIONS(19), 1,
      anon_sym_struct,
    ACTIONS(21), 1,
      anon_sym_union,
    ACTIONS(23), 1,
      anon_sym_type,
    ACTIONS(25), 1,
      anon_sym_newtype,
    ACTIONS(64), 1,
      anon_sym_RBRACE,
    STATE(47), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
    STATE(10), 11,
      sym__top,
      sym__remote_annon,
      sym_module_annon,
      sym_decl_annon,
      sym_field_annon,
      sym__decl,
      sym_struct,
      sym_union,
      sym_type_alias,
      sym_newtype,
      aux_sym_adl_repeat3,
  [470] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(68), 1,
      anon_sym_LBRACE,
    ACTIONS(72), 1,
      anon_sym_LBRACK,
    ACTIONS(74), 1,
      anon_sym_DQUOTE,
    ACTIONS(76), 1,
      sym_number,
    STATE(53), 1,
      sym_json,
    ACTIONS(70), 2,
      anon_sym_AT,
      sym_doc_comment,
    ACTIONS(78), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(48), 4,
      sym__value,
      sym_object,
      sym_array,
      sym_string,
    ACTIONS(66), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
  [512] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(68), 1,
      anon_sym_LBRACE,
    ACTIONS(72), 1,
      anon_sym_LBRACK,
    ACTIONS(74), 1,
      anon_sym_DQUOTE,
    ACTIONS(76), 1,
      sym_number,
    ACTIONS(80), 1,
      sym__ident,
    ACTIONS(82), 1,
      anon_sym_COLON_COLON,
    STATE(145), 1,
      sym_json,
    ACTIONS(78), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(48), 4,
      sym__value,
      sym_object,
      sym_array,
      sym_string,
  [548] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(84), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
    ACTIONS(86), 7,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [569] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(90), 1,
      anon_sym_import,
    STATE(15), 4,
      sym__import,
      sym_import_star,
      sym_import,
      aux_sym_adl_repeat2,
    ACTIONS(88), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [592] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
    ACTIONS(95), 7,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [613] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(99), 1,
      anon_sym_RBRACE,
    ACTIONS(101), 1,
      sym_doc_comment,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(42), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [647] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(103), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(38), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [681] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(68), 1,
      anon_sym_LBRACE,
    ACTIONS(72), 1,
      anon_sym_LBRACK,
    ACTIONS(74), 1,
      anon_sym_DQUOTE,
    STATE(168), 1,
      sym_json,
    ACTIONS(76), 4,
      sym_number,
      sym_true,
      sym_false,
      sym_null,
    STATE(48), 4,
      sym__value,
      sym_object,
      sym_array,
      sym_string,
  [709] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(68), 1,
      anon_sym_LBRACE,
    ACTIONS(72), 1,
      anon_sym_LBRACK,
    ACTIONS(74), 1,
      anon_sym_DQUOTE,
    ACTIONS(105), 1,
      anon_sym_RBRACK,
    ACTIONS(107), 4,
      sym_number,
      sym_true,
      sym_false,
      sym_null,
    STATE(122), 4,
      sym__value,
      sym_object,
      sym_array,
      sym_string,
  [737] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(109), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(34), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [771] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(99), 1,
      anon_sym_RBRACE,
    ACTIONS(101), 1,
      sym_doc_comment,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(40), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [805] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
    ACTIONS(113), 6,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [825] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(115), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(22), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [859] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(117), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(40), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [893] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(117), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(37), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [927] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
    ACTIONS(121), 6,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [947] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(123), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(40), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [981] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(125), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(25), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1015] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(68), 1,
      anon_sym_LBRACE,
    ACTIONS(72), 1,
      anon_sym_LBRACK,
    ACTIONS(74), 1,
      anon_sym_DQUOTE,
    STATE(202), 1,
      sym_json,
    ACTIONS(76), 4,
      sym_number,
      sym_true,
      sym_false,
      sym_null,
    STATE(48), 4,
      sym__value,
      sym_object,
      sym_array,
      sym_string,
  [1043] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(127), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(40), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1077] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(129), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(28), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1111] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
    ACTIONS(133), 6,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [1131] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(135), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(40), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1165] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
    ACTIONS(139), 6,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [1185] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(141), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
    ACTIONS(143), 6,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [1205] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(145), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(40), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1239] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(109), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(40), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1273] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(123), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(31), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1307] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(147), 1,
      sym__ident,
    ACTIONS(150), 1,
      anon_sym_RBRACE,
    ACTIONS(152), 1,
      anon_sym_AT,
    ACTIONS(155), 1,
      sym_doc_comment,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(40), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1341] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(68), 1,
      anon_sym_LBRACE,
    ACTIONS(72), 1,
      anon_sym_LBRACK,
    ACTIONS(74), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym_json,
    ACTIONS(76), 4,
      sym_number,
      sym_true,
      sym_false,
      sym_null,
    STATE(48), 4,
      sym__value,
      sym_object,
      sym_array,
      sym_string,
  [1369] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(101), 1,
      sym_doc_comment,
    ACTIONS(158), 1,
      anon_sym_RBRACE,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(154), 1,
      sym_type_expr,
    STATE(40), 2,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(51), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1403] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
    ACTIONS(162), 6,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [1423] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(68), 1,
      anon_sym_LBRACE,
    ACTIONS(72), 1,
      anon_sym_LBRACK,
    ACTIONS(74), 1,
      anon_sym_DQUOTE,
    ACTIONS(164), 4,
      sym_number,
      sym_true,
      sym_false,
      sym_null,
    STATE(140), 4,
      sym__value,
      sym_object,
      sym_array,
      sym_string,
  [1448] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(168), 1,
      anon_sym_AT,
    ACTIONS(171), 1,
      sym_doc_comment,
    STATE(45), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
    ACTIONS(166), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
  [1471] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(68), 1,
      anon_sym_LBRACE,
    ACTIONS(72), 1,
      anon_sym_LBRACK,
    ACTIONS(74), 1,
      anon_sym_DQUOTE,
    ACTIONS(174), 4,
      sym_number,
      sym_true,
      sym_false,
      sym_null,
    STATE(133), 4,
      sym__value,
      sym_object,
      sym_array,
      sym_string,
  [1496] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(176), 1,
      sym_doc_comment,
    ACTIONS(178), 1,
      anon_sym_struct,
    ACTIONS(180), 1,
      anon_sym_union,
    ACTIONS(182), 1,
      anon_sym_type,
    ACTIONS(184), 1,
      anon_sym_newtype,
    STATE(45), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1523] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(188), 3,
      anon_sym_SEMI,
      anon_sym_AT,
      sym_doc_comment,
    ACTIONS(186), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
  [1540] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(190), 9,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_import,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1555] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 9,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_import,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1570] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(97), 1,
      sym__ident,
    ACTIONS(176), 1,
      sym_doc_comment,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(144), 1,
      sym_type_expr,
    STATE(45), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1597] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(194), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1611] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(198), 2,
      anon_sym_AT,
      sym_doc_comment,
    ACTIONS(196), 6,
      anon_sym_module,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
      sym__ident,
  [1627] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1641] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(202), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1655] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1669] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(206), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1683] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(208), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1697] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(210), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1711] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(212), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1725] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(214), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1739] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(216), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1753] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(218), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1767] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(220), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1781] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1795] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(224), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1809] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1823] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1837] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1851] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(232), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1865] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1879] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1893] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1907] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(240), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1921] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(242), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1935] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1949] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(246), 8,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      anon_sym_annotation,
      anon_sym_struct,
      anon_sym_union,
      anon_sym_type,
      anon_sym_newtype,
  [1963] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 1,
      anon_sym_LT,
    STATE(80), 1,
      sym_type_expr_params,
    ACTIONS(248), 5,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_GT,
      sym__ident,
  [1980] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_AT,
    ACTIONS(176), 1,
      sym_doc_comment,
    ACTIONS(252), 1,
      anon_sym_module,
    STATE(45), 3,
      sym__aordc,
      sym_annon,
      aux_sym_adl_repeat1,
  [1998] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 5,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_GT,
      sym__ident,
  [2009] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 5,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_GT,
      sym__ident,
  [2020] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(258), 5,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_GT,
      sym__ident,
  [2031] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 4,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      sym__ident,
  [2041] = 4,
    ACTIONS(262), 1,
      sym_comment,
    ACTIONS(264), 1,
      anon_sym_DQUOTE,
    STATE(84), 1,
      aux_sym__string_content,
    ACTIONS(266), 2,
      aux_sym__string_content_token1,
      sym_escape_sequence,
  [2055] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(78), 1,
      sym_scoped_name,
    STATE(101), 1,
      sym_type_expr,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
  [2071] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(151), 1,
      sym_type_expr,
  [2087] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(78), 1,
      sym_scoped_name,
    STATE(114), 1,
      sym_type_expr,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
  [2103] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(78), 1,
      sym_scoped_name,
    STATE(110), 1,
      sym_type_expr,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
  [2119] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(201), 1,
      sym_type_expr,
  [2135] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(78), 1,
      sym_scoped_name,
    STATE(112), 1,
      sym_type_expr,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
  [2151] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 4,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      sym__ident,
  [2161] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(159), 1,
      sym_type_expr,
  [2177] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(178), 1,
      sym_type_expr,
  [2193] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(78), 1,
      sym_scoped_name,
    STATE(121), 1,
      sym_type_expr,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
  [2209] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(271), 4,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      sym__ident,
  [2219] = 4,
    ACTIONS(262), 1,
      sym_comment,
    ACTIONS(273), 1,
      anon_sym_DQUOTE,
    STATE(84), 1,
      aux_sym__string_content,
    ACTIONS(275), 2,
      aux_sym__string_content_token1,
      sym_escape_sequence,
  [2233] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(78), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(142), 1,
      sym_type_expr,
  [2249] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 4,
      anon_sym_RBRACE,
      anon_sym_AT,
      sym_doc_comment,
      sym__ident,
  [2259] = 4,
    ACTIONS(262), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_DQUOTE,
    STATE(96), 1,
      aux_sym__string_content,
    ACTIONS(281), 2,
      aux_sym__string_content_token1,
      sym_escape_sequence,
  [2273] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(74), 1,
      anon_sym_DQUOTE,
    ACTIONS(283), 1,
      anon_sym_RBRACE,
    STATE(120), 1,
      sym_pair,
    STATE(179), 1,
      sym_string,
  [2289] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 1,
      anon_sym_SEMI,
    ACTIONS(287), 1,
      anon_sym_EQ,
    STATE(180), 1,
      sym_default_val,
  [2302] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      anon_sym_RBRACE,
    ACTIONS(291), 1,
      anon_sym_COMMA,
    STATE(102), 1,
      aux_sym_object_repeat1,
  [2315] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    ACTIONS(296), 1,
      anon_sym_GT,
    STATE(132), 1,
      aux_sym_type_param_repeat1,
  [2328] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(203), 1,
      sym_scoped_name,
  [2341] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(12), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
  [2354] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(298), 1,
      anon_sym_RBRACE,
    ACTIONS(300), 1,
      anon_sym_COMMA,
    STATE(102), 1,
      aux_sym_object_repeat1,
  [2367] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_COMMA,
    ACTIONS(305), 1,
      anon_sym_GT,
    STATE(107), 1,
      aux_sym_type_expr_params_repeat1,
  [2380] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(194), 1,
      sym_scoped_name,
  [2393] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(307), 1,
      anon_sym_COMMA,
    ACTIONS(309), 1,
      anon_sym_RBRACK,
    STATE(111), 1,
      aux_sym_array_repeat1,
  [2406] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_EQ,
    ACTIONS(311), 1,
      anon_sym_SEMI,
    STATE(146), 1,
      sym_default_val,
  [2419] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 1,
      anon_sym_COMMA,
    ACTIONS(316), 1,
      anon_sym_RBRACK,
    STATE(111), 1,
      aux_sym_array_repeat1,
  [2432] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_EQ,
    ACTIONS(318), 1,
      anon_sym_SEMI,
    STATE(170), 1,
      sym_default_val,
  [2445] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(74), 1,
      anon_sym_DQUOTE,
    STATE(139), 1,
      sym_pair,
    STATE(179), 1,
      sym_string,
  [2458] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 1,
      anon_sym_COMMA,
    ACTIONS(322), 1,
      anon_sym_GT,
    STATE(119), 1,
      aux_sym_type_expr_params_repeat1,
  [2471] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
    STATE(138), 1,
      sym_scoped_name,
  [2484] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(324), 1,
      anon_sym_EQ,
    ACTIONS(326), 1,
      anon_sym_LT,
    STATE(169), 1,
      sym_type_param,
  [2497] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      sym__ident,
    STATE(13), 1,
      sym_scoped_name,
    STATE(135), 1,
      aux_sym_scoped_name_repeat1,
  [2510] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_EQ,
    ACTIONS(328), 1,
      anon_sym_SEMI,
    STATE(188), 1,
      sym_default_val,
  [2523] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 1,
      anon_sym_COMMA,
    ACTIONS(330), 1,
      anon_sym_GT,
    STATE(107), 1,
      aux_sym_type_expr_params_repeat1,
  [2536] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 1,
      anon_sym_COMMA,
    ACTIONS(332), 1,
      anon_sym_RBRACE,
    STATE(106), 1,
      aux_sym_object_repeat1,
  [2549] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_EQ,
    ACTIONS(334), 1,
      anon_sym_SEMI,
    STATE(198), 1,
      sym_default_val,
  [2562] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(307), 1,
      anon_sym_COMMA,
    ACTIONS(336), 1,
      anon_sym_RBRACK,
    STATE(109), 1,
      aux_sym_array_repeat1,
  [2575] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(338), 1,
      anon_sym_COMMA,
    ACTIONS(341), 1,
      anon_sym_GT,
    STATE(123), 1,
      aux_sym_type_param_repeat1,
  [2588] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 1,
      anon_sym_LT,
    ACTIONS(343), 1,
      anon_sym_EQ,
    STATE(190), 1,
      sym_type_param,
  [2601] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 1,
      anon_sym_LT,
    ACTIONS(345), 1,
      anon_sym_EQ,
    STATE(191), 1,
      sym_type_param,
  [2614] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 1,
      anon_sym_LT,
    ACTIONS(347), 1,
      anon_sym_LBRACE,
    STATE(196), 1,
      sym_type_param,
  [2627] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_EQ,
    ACTIONS(349), 1,
      anon_sym_SEMI,
    STATE(158), 1,
      sym_default_val,
  [2640] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 1,
      anon_sym_LT,
    ACTIONS(351), 1,
      anon_sym_LBRACE,
    STATE(161), 1,
      sym_type_param,
  [2653] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 1,
      anon_sym_LT,
    ACTIONS(353), 1,
      anon_sym_LBRACE,
    STATE(162), 1,
      sym_type_param,
  [2666] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 1,
      anon_sym_LT,
    ACTIONS(355), 1,
      anon_sym_LBRACE,
    STATE(199), 1,
      sym_type_param,
  [2679] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 1,
      anon_sym_LT,
    ACTIONS(357), 1,
      anon_sym_EQ,
    STATE(167), 1,
      sym_type_param,
  [2692] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    ACTIONS(359), 1,
      anon_sym_GT,
    STATE(123), 1,
      aux_sym_type_param_repeat1,
  [2705] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [2713] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 2,
      anon_sym_LBRACE,
      anon_sym_EQ,
  [2721] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(363), 1,
      sym__ident,
    STATE(141), 1,
      aux_sym_scoped_name_repeat1,
  [2731] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 2,
      anon_sym_LBRACE,
      anon_sym_EQ,
  [2739] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(341), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [2747] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(367), 1,
      anon_sym_SEMI,
    ACTIONS(369), 1,
      anon_sym_DOT_STAR,
  [2757] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [2765] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [2773] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 1,
      sym__ident,
    STATE(141), 1,
      aux_sym_scoped_name_repeat1,
  [2783] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(376), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [2791] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 1,
      ts_builtin_sym_end,
  [2798] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(380), 1,
      sym__ident,
  [2805] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      anon_sym_SEMI,
  [2812] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(318), 1,
      anon_sym_SEMI,
  [2819] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      anon_sym_SEMI,
  [2826] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 1,
      sym__ident,
  [2833] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      anon_sym_SEMI,
  [2840] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      anon_sym_SEMI,
  [2847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(392), 1,
      anon_sym_SEMI,
  [2854] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(394), 1,
      anon_sym_SEMI,
  [2861] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(396), 1,
      sym__ident,
  [2868] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      sym__ident,
  [2875] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(400), 1,
      anon_sym_SEMI,
  [2882] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      anon_sym_SEMI,
  [2889] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym__ident,
  [2896] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(406), 1,
      anon_sym_SEMI,
  [2903] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_SEMI,
  [2910] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 1,
      sym__ident,
  [2917] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 1,
      anon_sym_LBRACE,
  [2924] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
  [2931] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(416), 1,
      anon_sym_SEMI,
  [2938] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 1,
      anon_sym_SEMI,
  [2945] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(420), 1,
      sym__ident,
  [2952] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(422), 1,
      anon_sym_SEMI,
  [2959] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      anon_sym_EQ,
  [2966] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_SEMI,
  [2973] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(428), 1,
      anon_sym_EQ,
  [2980] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(430), 1,
      anon_sym_SEMI,
  [2987] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(432), 1,
      sym__ident,
  [2994] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(434), 1,
      anon_sym_SEMI,
  [3001] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(436), 1,
      anon_sym_SEMI,
  [3008] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(438), 1,
      sym__ident,
  [3015] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(440), 1,
      anon_sym_SEMI,
  [3022] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(442), 1,
      ts_builtin_sym_end,
  [3029] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(444), 1,
      ts_builtin_sym_end,
  [3036] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(446), 1,
      anon_sym_SEMI,
  [3043] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(448), 1,
      anon_sym_COLON,
  [3050] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(334), 1,
      anon_sym_SEMI,
  [3057] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(450), 1,
      anon_sym_SEMI,
  [3064] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(452), 1,
      anon_sym_SEMI,
  [3071] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(454), 1,
      anon_sym_DOT,
  [3078] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(456), 1,
      sym__ident,
  [3085] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(458), 1,
      ts_builtin_sym_end,
  [3092] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 1,
      sym__ident,
  [3099] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      sym__ident,
  [3106] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_SEMI,
  [3113] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(466), 1,
      sym__ident,
  [3120] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 1,
      anon_sym_EQ,
  [3127] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 1,
      anon_sym_EQ,
  [3134] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(472), 1,
      anon_sym_SEMI,
  [3141] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(474), 1,
      anon_sym_SEMI,
  [3148] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 1,
      anon_sym_LBRACE,
  [3155] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(478), 1,
      anon_sym_SEMI,
  [3162] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      anon_sym_LBRACE,
  [3169] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(482), 1,
      sym__ident,
  [3176] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 1,
      anon_sym_SEMI,
  [3183] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(486), 1,
      anon_sym_LBRACE,
  [3190] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 1,
      sym__ident,
  [3197] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(490), 1,
      anon_sym_SEMI,
  [3204] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(492), 1,
      anon_sym_SEMI,
  [3211] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 1,
      anon_sym_LBRACE,
  [3218] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(496), 1,
      ts_builtin_sym_end,
  [3225] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      anon_sym_SEMI,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 55,
  [SMALL_STATE(4)] = 110,
  [SMALL_STATE(5)] = 165,
  [SMALL_STATE(6)] = 220,
  [SMALL_STATE(7)] = 253,
  [SMALL_STATE(8)] = 286,
  [SMALL_STATE(9)] = 332,
  [SMALL_STATE(10)] = 378,
  [SMALL_STATE(11)] = 424,
  [SMALL_STATE(12)] = 470,
  [SMALL_STATE(13)] = 512,
  [SMALL_STATE(14)] = 548,
  [SMALL_STATE(15)] = 569,
  [SMALL_STATE(16)] = 592,
  [SMALL_STATE(17)] = 613,
  [SMALL_STATE(18)] = 647,
  [SMALL_STATE(19)] = 681,
  [SMALL_STATE(20)] = 709,
  [SMALL_STATE(21)] = 737,
  [SMALL_STATE(22)] = 771,
  [SMALL_STATE(23)] = 805,
  [SMALL_STATE(24)] = 825,
  [SMALL_STATE(25)] = 859,
  [SMALL_STATE(26)] = 893,
  [SMALL_STATE(27)] = 927,
  [SMALL_STATE(28)] = 947,
  [SMALL_STATE(29)] = 981,
  [SMALL_STATE(30)] = 1015,
  [SMALL_STATE(31)] = 1043,
  [SMALL_STATE(32)] = 1077,
  [SMALL_STATE(33)] = 1111,
  [SMALL_STATE(34)] = 1131,
  [SMALL_STATE(35)] = 1165,
  [SMALL_STATE(36)] = 1185,
  [SMALL_STATE(37)] = 1205,
  [SMALL_STATE(38)] = 1239,
  [SMALL_STATE(39)] = 1273,
  [SMALL_STATE(40)] = 1307,
  [SMALL_STATE(41)] = 1341,
  [SMALL_STATE(42)] = 1369,
  [SMALL_STATE(43)] = 1403,
  [SMALL_STATE(44)] = 1423,
  [SMALL_STATE(45)] = 1448,
  [SMALL_STATE(46)] = 1471,
  [SMALL_STATE(47)] = 1496,
  [SMALL_STATE(48)] = 1523,
  [SMALL_STATE(49)] = 1540,
  [SMALL_STATE(50)] = 1555,
  [SMALL_STATE(51)] = 1570,
  [SMALL_STATE(52)] = 1597,
  [SMALL_STATE(53)] = 1611,
  [SMALL_STATE(54)] = 1627,
  [SMALL_STATE(55)] = 1641,
  [SMALL_STATE(56)] = 1655,
  [SMALL_STATE(57)] = 1669,
  [SMALL_STATE(58)] = 1683,
  [SMALL_STATE(59)] = 1697,
  [SMALL_STATE(60)] = 1711,
  [SMALL_STATE(61)] = 1725,
  [SMALL_STATE(62)] = 1739,
  [SMALL_STATE(63)] = 1753,
  [SMALL_STATE(64)] = 1767,
  [SMALL_STATE(65)] = 1781,
  [SMALL_STATE(66)] = 1795,
  [SMALL_STATE(67)] = 1809,
  [SMALL_STATE(68)] = 1823,
  [SMALL_STATE(69)] = 1837,
  [SMALL_STATE(70)] = 1851,
  [SMALL_STATE(71)] = 1865,
  [SMALL_STATE(72)] = 1879,
  [SMALL_STATE(73)] = 1893,
  [SMALL_STATE(74)] = 1907,
  [SMALL_STATE(75)] = 1921,
  [SMALL_STATE(76)] = 1935,
  [SMALL_STATE(77)] = 1949,
  [SMALL_STATE(78)] = 1963,
  [SMALL_STATE(79)] = 1980,
  [SMALL_STATE(80)] = 1998,
  [SMALL_STATE(81)] = 2009,
  [SMALL_STATE(82)] = 2020,
  [SMALL_STATE(83)] = 2031,
  [SMALL_STATE(84)] = 2041,
  [SMALL_STATE(85)] = 2055,
  [SMALL_STATE(86)] = 2071,
  [SMALL_STATE(87)] = 2087,
  [SMALL_STATE(88)] = 2103,
  [SMALL_STATE(89)] = 2119,
  [SMALL_STATE(90)] = 2135,
  [SMALL_STATE(91)] = 2151,
  [SMALL_STATE(92)] = 2161,
  [SMALL_STATE(93)] = 2177,
  [SMALL_STATE(94)] = 2193,
  [SMALL_STATE(95)] = 2209,
  [SMALL_STATE(96)] = 2219,
  [SMALL_STATE(97)] = 2233,
  [SMALL_STATE(98)] = 2249,
  [SMALL_STATE(99)] = 2259,
  [SMALL_STATE(100)] = 2273,
  [SMALL_STATE(101)] = 2289,
  [SMALL_STATE(102)] = 2302,
  [SMALL_STATE(103)] = 2315,
  [SMALL_STATE(104)] = 2328,
  [SMALL_STATE(105)] = 2341,
  [SMALL_STATE(106)] = 2354,
  [SMALL_STATE(107)] = 2367,
  [SMALL_STATE(108)] = 2380,
  [SMALL_STATE(109)] = 2393,
  [SMALL_STATE(110)] = 2406,
  [SMALL_STATE(111)] = 2419,
  [SMALL_STATE(112)] = 2432,
  [SMALL_STATE(113)] = 2445,
  [SMALL_STATE(114)] = 2458,
  [SMALL_STATE(115)] = 2471,
  [SMALL_STATE(116)] = 2484,
  [SMALL_STATE(117)] = 2497,
  [SMALL_STATE(118)] = 2510,
  [SMALL_STATE(119)] = 2523,
  [SMALL_STATE(120)] = 2536,
  [SMALL_STATE(121)] = 2549,
  [SMALL_STATE(122)] = 2562,
  [SMALL_STATE(123)] = 2575,
  [SMALL_STATE(124)] = 2588,
  [SMALL_STATE(125)] = 2601,
  [SMALL_STATE(126)] = 2614,
  [SMALL_STATE(127)] = 2627,
  [SMALL_STATE(128)] = 2640,
  [SMALL_STATE(129)] = 2653,
  [SMALL_STATE(130)] = 2666,
  [SMALL_STATE(131)] = 2679,
  [SMALL_STATE(132)] = 2692,
  [SMALL_STATE(133)] = 2705,
  [SMALL_STATE(134)] = 2713,
  [SMALL_STATE(135)] = 2721,
  [SMALL_STATE(136)] = 2731,
  [SMALL_STATE(137)] = 2739,
  [SMALL_STATE(138)] = 2747,
  [SMALL_STATE(139)] = 2757,
  [SMALL_STATE(140)] = 2765,
  [SMALL_STATE(141)] = 2773,
  [SMALL_STATE(142)] = 2783,
  [SMALL_STATE(143)] = 2791,
  [SMALL_STATE(144)] = 2798,
  [SMALL_STATE(145)] = 2805,
  [SMALL_STATE(146)] = 2812,
  [SMALL_STATE(147)] = 2819,
  [SMALL_STATE(148)] = 2826,
  [SMALL_STATE(149)] = 2833,
  [SMALL_STATE(150)] = 2840,
  [SMALL_STATE(151)] = 2847,
  [SMALL_STATE(152)] = 2854,
  [SMALL_STATE(153)] = 2861,
  [SMALL_STATE(154)] = 2868,
  [SMALL_STATE(155)] = 2875,
  [SMALL_STATE(156)] = 2882,
  [SMALL_STATE(157)] = 2889,
  [SMALL_STATE(158)] = 2896,
  [SMALL_STATE(159)] = 2903,
  [SMALL_STATE(160)] = 2910,
  [SMALL_STATE(161)] = 2917,
  [SMALL_STATE(162)] = 2924,
  [SMALL_STATE(163)] = 2931,
  [SMALL_STATE(164)] = 2938,
  [SMALL_STATE(165)] = 2945,
  [SMALL_STATE(166)] = 2952,
  [SMALL_STATE(167)] = 2959,
  [SMALL_STATE(168)] = 2966,
  [SMALL_STATE(169)] = 2973,
  [SMALL_STATE(170)] = 2980,
  [SMALL_STATE(171)] = 2987,
  [SMALL_STATE(172)] = 2994,
  [SMALL_STATE(173)] = 3001,
  [SMALL_STATE(174)] = 3008,
  [SMALL_STATE(175)] = 3015,
  [SMALL_STATE(176)] = 3022,
  [SMALL_STATE(177)] = 3029,
  [SMALL_STATE(178)] = 3036,
  [SMALL_STATE(179)] = 3043,
  [SMALL_STATE(180)] = 3050,
  [SMALL_STATE(181)] = 3057,
  [SMALL_STATE(182)] = 3064,
  [SMALL_STATE(183)] = 3071,
  [SMALL_STATE(184)] = 3078,
  [SMALL_STATE(185)] = 3085,
  [SMALL_STATE(186)] = 3092,
  [SMALL_STATE(187)] = 3099,
  [SMALL_STATE(188)] = 3106,
  [SMALL_STATE(189)] = 3113,
  [SMALL_STATE(190)] = 3120,
  [SMALL_STATE(191)] = 3127,
  [SMALL_STATE(192)] = 3134,
  [SMALL_STATE(193)] = 3141,
  [SMALL_STATE(194)] = 3148,
  [SMALL_STATE(195)] = 3155,
  [SMALL_STATE(196)] = 3162,
  [SMALL_STATE(197)] = 3169,
  [SMALL_STATE(198)] = 3176,
  [SMALL_STATE(199)] = 3183,
  [SMALL_STATE(200)] = 3190,
  [SMALL_STATE(201)] = 3197,
  [SMALL_STATE(202)] = 3204,
  [SMALL_STATE(203)] = 3211,
  [SMALL_STATE(204)] = 3218,
  [SMALL_STATE(205)] = 3225,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [31] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scoped_name, 1),
  [33] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scoped_name, 1),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [37] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scoped_name, 2),
  [39] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scoped_name, 2),
  [41] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_adl_repeat3, 2),
  [43] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_adl_repeat3, 2), SHIFT_REPEAT(105),
  [46] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_adl_repeat3, 2), SHIFT_REPEAT(47),
  [49] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_adl_repeat3, 2), SHIFT_REPEAT(117),
  [52] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_adl_repeat3, 2), SHIFT_REPEAT(189),
  [55] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_adl_repeat3, 2), SHIFT_REPEAT(187),
  [58] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_adl_repeat3, 2), SHIFT_REPEAT(186),
  [61] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_adl_repeat3, 2), SHIFT_REPEAT(184),
  [64] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [66] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annon, 2),
  [68] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [70] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annon, 2),
  [72] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [74] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [76] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [78] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [80] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [82] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [84] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2),
  [86] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [88] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_adl_repeat2, 2),
  [90] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_adl_repeat2, 2), SHIFT_REPEAT(115),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [111] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 3),
  [113] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 3),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [119] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object, 3),
  [121] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object, 3),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [131] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object, 2),
  [133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object, 2),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 4),
  [139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 4),
  [141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 2),
  [143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 2),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [147] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_repeat1, 2), SHIFT_REPEAT(6),
  [150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_repeat1, 2),
  [152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_repeat1, 2), SHIFT_REPEAT(105),
  [155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_repeat1, 2), SHIFT_REPEAT(51),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [160] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object, 4),
  [162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object, 4),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_adl_repeat1, 2),
  [168] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_adl_repeat1, 2), SHIFT_REPEAT(105),
  [171] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_adl_repeat1, 2), SHIFT_REPEAT(45),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [186] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_json, 1),
  [188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_json, 1),
  [190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 3),
  [192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_star, 4),
  [194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_newtype, 7, .production_id = 2),
  [196] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annon, 3),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annon, 3),
  [200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union, 6, .production_id = 4),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias, 6, .production_id = 4),
  [204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_newtype, 6, .production_id = 4),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_annon, 7),
  [208] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union, 8, .production_id = 4),
  [210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_annon, 4),
  [212] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias, 6, .production_id = 2),
  [214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 7, .production_id = 2),
  [216] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union, 7, .production_id = 2),
  [218] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_newtype, 6, .production_id = 2),
  [220] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 7, .production_id = 4),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 6, .production_id = 4),
  [224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 6, .production_id = 2),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_newtype, 8, .production_id = 4),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 8, .production_id = 4),
  [230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_newtype, 5, .production_id = 2),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union, 7, .production_id = 4),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias, 5, .production_id = 2),
  [236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias, 7, .production_id = 4),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union, 6, .production_id = 2),
  [240] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union, 5, .production_id = 2),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_newtype, 7, .production_id = 4),
  [244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decl_annon, 5),
  [246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 5, .production_id = 2),
  [248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_expr, 1),
  [250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_expr, 2),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_expr_params, 4, .production_id = 5),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_expr_params, 3, .production_id = 5),
  [260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 4, .production_id = 6),
  [262] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__string_content, 2),
  [266] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__string_content, 2), SHIFT_REPEAT(84),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 5, .production_id = 6),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 3, .production_id = 3),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 4, .production_id = 3),
  [279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_object_repeat1, 2),
  [291] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_object_repeat1, 2), SHIFT_REPEAT(113),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [302] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_expr_params_repeat1, 2), SHIFT_REPEAT(97),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_expr_params_repeat1, 2),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [313] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(46),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [338] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_param_repeat1, 2), SHIFT_REPEAT(171),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_param_repeat1, 2),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_param, 3),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_param, 4),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pair, 3, .production_id = 1),
  [373] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_scoped_name_repeat1, 2), SHIFT_REPEAT(183),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_expr_params_repeat1, 2, .production_id = 5),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_adl, 8),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [426] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_default_val, 2),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [442] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_adl, 5),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_adl, 6),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [458] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_adl, 7),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_scoped_name_repeat1, 2),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [496] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_adl() {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym__ident,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
