#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2555
#define LARGE_STATE_COUNT 128
#define SYMBOL_COUNT 314
#define ALIAS_COUNT 4
#define TOKEN_COUNT 148
#define EXTERNAL_TOKEN_COUNT 13
#define FIELD_COUNT 27
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 101

enum ts_symbol_identifiers {
  aux_sym_recipe_token1 = 1,
  anon_sym_NULL = 2,
  anon_sym_EQ = 3,
  anon_sym_QMARK_EQ = 4,
  anon_sym_QMARK_QMARK_EQ = 5,
  anon_sym_COLON_EQ = 6,
  anon_sym_PLUS_EQ = 7,
  anon_sym_EQ_PLUS = 8,
  anon_sym_DOT_EQ = 9,
  anon_sym_EQ_DOT = 10,
  anon_sym_LBRACK = 11,
  anon_sym_noexec = 12,
  aux_sym_variable_flag_token1 = 13,
  anon_sym_RBRACK = 14,
  anon_sym_COLON = 15,
  anon_sym_append = 16,
  anon_sym_prepend = 17,
  anon_sym_remove = 18,
  anon_sym_unset = 19,
  anon_sym_inherit = 20,
  sym_inherit_path = 21,
  anon_sym_INHERIT = 22,
  anon_sym_DQUOTE = 23,
  anon_sym_include = 24,
  aux_sym_include_directive_token1 = 25,
  anon_sym_require = 26,
  anon_sym_export = 27,
  anon_sym_OVERRIDES = 28,
  anon_sym_EXPORT_FUNCTIONS = 29,
  anon_sym_addtask = 30,
  anon_sym_after = 31,
  anon_sym_before = 32,
  anon_sym_deltask = 33,
  anon_sym_addhandler = 34,
  anon_sym_fakeroot = 35,
  anon_sym_python = 36,
  anon_sym_LPAREN = 37,
  anon_sym_RPAREN = 38,
  anon_sym_LBRACE = 39,
  anon_sym_RBRACE = 40,
  aux_sym_string_token1 = 41,
  aux_sym_string_token2 = 42,
  anon_sym_DOLLARBB_ENV_PASSTHROUGH = 43,
  anon_sym_DOLLARBB_ENV_PASSTHROUGH_ADDITIONS = 44,
  anon_sym_DOLLAR = 45,
  anon_sym_SQUOTE = 46,
  aux_sym_string_token3 = 47,
  aux_sym_string_token4 = 48,
  anon_sym_DOLLAR_LBRACE_AT = 49,
  anon_sym_DOLLAR_LBRACE = 50,
  anon_sym_def = 51,
  anon_sym_DASH_GT = 52,
  anon_sym_SEMI = 53,
  anon_sym_import = 54,
  anon_sym_DOT = 55,
  anon_sym_from = 56,
  anon_sym___future__ = 57,
  anon_sym_COMMA = 58,
  anon_sym_as = 59,
  anon_sym_STAR = 60,
  anon_sym_print = 61,
  anon_sym_GT_GT = 62,
  anon_sym_assert = 63,
  anon_sym_return = 64,
  anon_sym_del = 65,
  anon_sym_raise = 66,
  anon_sym_pass = 67,
  anon_sym_break = 68,
  anon_sym_continue = 69,
  anon_sym_global = 70,
  anon_sym_nonlocal = 71,
  anon_sym_exec = 72,
  anon_sym_in = 73,
  anon_sym_if = 74,
  anon_sym_elif = 75,
  anon_sym_else = 76,
  anon_sym_async = 77,
  anon_sym_for = 78,
  anon_sym_while = 79,
  anon_sym_try = 80,
  anon_sym_except = 81,
  anon_sym_except_STAR = 82,
  anon_sym_finally = 83,
  anon_sym_with = 84,
  anon_sym_not = 85,
  anon_sym_and = 86,
  anon_sym_or = 87,
  anon_sym_PLUS = 88,
  anon_sym_DASH = 89,
  anon_sym_AT = 90,
  anon_sym_SLASH = 91,
  anon_sym_PERCENT = 92,
  anon_sym_SLASH_SLASH = 93,
  anon_sym_STAR_STAR = 94,
  anon_sym_PIPE = 95,
  anon_sym_AMP = 96,
  anon_sym_CARET = 97,
  anon_sym_LT_LT = 98,
  anon_sym_TILDE = 99,
  anon_sym_LT = 100,
  anon_sym_LT_EQ = 101,
  anon_sym_EQ_EQ = 102,
  anon_sym_BANG_EQ = 103,
  anon_sym_GT_EQ = 104,
  anon_sym_GT = 105,
  anon_sym_LT_GT = 106,
  anon_sym_is = 107,
  anon_sym_lambda = 108,
  anon_sym_DASH_EQ = 109,
  anon_sym_STAR_EQ = 110,
  anon_sym_SLASH_EQ = 111,
  anon_sym_AT_EQ = 112,
  anon_sym_SLASH_SLASH_EQ = 113,
  anon_sym_PERCENT_EQ = 114,
  anon_sym_STAR_STAR_EQ = 115,
  anon_sym_GT_GT_EQ = 116,
  anon_sym_LT_LT_EQ = 117,
  anon_sym_AMP_EQ = 118,
  anon_sym_CARET_EQ = 119,
  anon_sym_PIPE_EQ = 120,
  anon_sym_yield = 121,
  sym_ellipsis = 122,
  sym_escape_sequence = 123,
  sym__not_escape_sequence = 124,
  aux_sym_format_specifier_token1 = 125,
  sym_type_conversion = 126,
  anon_sym_await = 127,
  anon_sym_match = 128,
  anon_sym_type = 129,
  sym_integer = 130,
  sym_float = 131,
  sym_true = 132,
  sym_false = 133,
  sym_none = 134,
  sym_python_identifier = 135,
  sym_identifier = 136,
  aux_sym__dotted_identifier_token1 = 137,
  sym_comment = 138,
  sym__concat = 139,
  sym__newline = 140,
  sym__indent = 141,
  sym__dedent = 142,
  sym_string_start = 143,
  sym__string_content = 144,
  sym_escape_interpolation = 145,
  sym_string_end = 146,
  sym_shell_content = 147,
  sym_recipe = 148,
  sym_variable_assignment = 149,
  sym_variable_flag = 150,
  sym_override = 151,
  sym_unset_statement = 152,
  sym_inherit_directive = 153,
  sym_include_directive = 154,
  sym_require_directive = 155,
  sym_export_statement = 156,
  sym_overrides_statement = 157,
  sym_export_functions_statement = 158,
  sym_addtask_statement = 159,
  sym_deltask_statement = 160,
  sym_addhandler_statement = 161,
  sym_anonymous_python_function = 162,
  sym_function_definition = 163,
  sym_literal = 164,
  sym_string = 165,
  sym_inline_python = 166,
  sym_variable_expansion = 167,
  sym_python_function_definition = 168,
  sym__statement = 169,
  sym__simple_statements = 170,
  sym_import_statement = 171,
  sym_import_prefix = 172,
  sym_relative_import = 173,
  sym_future_import_statement = 174,
  sym_import_from_statement = 175,
  sym__import_list = 176,
  sym_aliased_import = 177,
  sym_wildcard_import = 178,
  sym_print_statement = 179,
  sym_chevron = 180,
  sym_assert_statement = 181,
  sym_expression_statement = 182,
  sym_named_expression = 183,
  sym__named_expression_lhs = 184,
  sym_return_statement = 185,
  sym_delete_statement = 186,
  sym_raise_statement = 187,
  sym_pass_statement = 188,
  sym_break_statement = 189,
  sym_continue_statement = 190,
  sym_global_statement = 191,
  sym_nonlocal_statement = 192,
  sym_exec_statement = 193,
  sym_type_parameter = 194,
  sym_parenthesized_list_splat = 195,
  sym_argument_list = 196,
  sym_if_statement = 197,
  sym_elif_clause = 198,
  sym_else_clause = 199,
  sym_for_statement = 200,
  sym_while_statement = 201,
  sym_try_statement = 202,
  sym_except_clause = 203,
  sym_except_group_clause = 204,
  sym_finally_clause = 205,
  sym_with_statement = 206,
  sym_with_clause = 207,
  sym_with_item = 208,
  sym_dotted_name = 209,
  sym_not_operator = 210,
  sym_boolean_operator = 211,
  sym_binary_operator = 212,
  sym_unary_operator = 213,
  sym_comparison_operator = 214,
  sym_lambda = 215,
  sym_lambda_within_for_in_clause = 216,
  sym_assignment = 217,
  sym_augmented_assignment = 218,
  sym_pattern_list = 219,
  sym__right_hand_side = 220,
  sym_yield = 221,
  sym_attribute = 222,
  sym_subscript = 223,
  sym_slice = 224,
  sym_call = 225,
  sym_generator_expression = 226,
  sym__comprehension_clauses = 227,
  sym_parenthesized_expression = 228,
  sym__collection_elements = 229,
  sym_for_in_clause = 230,
  sym_if_clause = 231,
  sym_block = 232,
  sym_expression_list = 233,
  sym_parameters = 234,
  sym_lambda_parameters = 235,
  sym_list_splat = 236,
  sym_dictionary_splat = 237,
  sym__parameters = 238,
  sym__patterns = 239,
  sym_parameter = 240,
  sym_pattern = 241,
  sym_tuple_pattern = 242,
  sym_list_pattern = 243,
  sym_default_parameter = 244,
  sym_typed_default_parameter = 245,
  sym_list_splat_pattern = 246,
  sym_dictionary_splat_pattern = 247,
  sym_as_pattern = 248,
  sym__expression_within_for_in_clause = 249,
  sym_expression = 250,
  sym_primary_expression = 251,
  sym_typed_parameter = 252,
  sym_type = 253,
  sym_splat_type = 254,
  sym_generic_type = 255,
  sym_union_type = 256,
  sym_constrained_type = 257,
  sym_member_type = 258,
  sym_keyword_argument = 259,
  sym_list = 260,
  sym_set = 261,
  sym_tuple = 262,
  sym_dictionary = 263,
  sym_pair = 264,
  sym_list_comprehension = 265,
  sym_dictionary_comprehension = 266,
  sym_set_comprehension = 267,
  sym_conditional_expression = 268,
  sym_concatenated_string = 269,
  sym_python_string = 270,
  sym_string_content = 271,
  sym_interpolation = 272,
  sym__f_expression = 273,
  sym_format_specifier = 274,
  sym_await = 275,
  sym_positional_separator = 276,
  sym_keyword_separator = 277,
  sym_concatenation = 278,
  aux_sym_recipe_repeat1 = 279,
  aux_sym_override_repeat1 = 280,
  aux_sym_inherit_directive_repeat1 = 281,
  aux_sym_overrides_statement_repeat1 = 282,
  aux_sym_export_functions_statement_repeat1 = 283,
  aux_sym_function_definition_repeat1 = 284,
  aux_sym_string_repeat1 = 285,
  aux_sym_string_repeat2 = 286,
  aux_sym__simple_statements_repeat1 = 287,
  aux_sym_import_prefix_repeat1 = 288,
  aux_sym__import_list_repeat1 = 289,
  aux_sym_print_statement_repeat1 = 290,
  aux_sym_assert_statement_repeat1 = 291,
  aux_sym_global_statement_repeat1 = 292,
  aux_sym_type_parameter_repeat1 = 293,
  aux_sym_argument_list_repeat1 = 294,
  aux_sym_if_statement_repeat1 = 295,
  aux_sym_try_statement_repeat1 = 296,
  aux_sym_try_statement_repeat2 = 297,
  aux_sym_with_clause_repeat1 = 298,
  aux_sym_dotted_name_repeat1 = 299,
  aux_sym_comparison_operator_repeat1 = 300,
  aux_sym_pattern_list_repeat1 = 301,
  aux_sym_subscript_repeat1 = 302,
  aux_sym__comprehension_clauses_repeat1 = 303,
  aux_sym__collection_elements_repeat1 = 304,
  aux_sym_for_in_clause_repeat1 = 305,
  aux_sym_block_repeat1 = 306,
  aux_sym__parameters_repeat1 = 307,
  aux_sym_dictionary_repeat1 = 308,
  aux_sym_concatenated_string_repeat1 = 309,
  aux_sym_python_string_repeat1 = 310,
  aux_sym_string_content_repeat1 = 311,
  aux_sym_format_specifier_repeat1 = 312,
  aux_sym_concatenation_repeat1 = 313,
  alias_sym_as_pattern_target = 314,
  alias_sym_format_expression = 315,
  anon_alias_sym_isnot = 316,
  anon_alias_sym_notin = 317,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [aux_sym_recipe_token1] = "recipe_token1",
  [anon_sym_NULL] = "\0",
  [anon_sym_EQ] = "=",
  [anon_sym_QMARK_EQ] = "\?=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_EQ_PLUS] = "=+",
  [anon_sym_DOT_EQ] = ".=",
  [anon_sym_EQ_DOT] = "=.",
  [anon_sym_LBRACK] = "[",
  [anon_sym_noexec] = "noexec",
  [aux_sym_variable_flag_token1] = "flag",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COLON] = ":",
  [anon_sym_append] = "append",
  [anon_sym_prepend] = "prepend",
  [anon_sym_remove] = "remove",
  [anon_sym_unset] = "unset",
  [anon_sym_inherit] = "inherit",
  [sym_inherit_path] = "inherit_path",
  [anon_sym_INHERIT] = "INHERIT",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_include] = "include",
  [aux_sym_include_directive_token1] = "include_path",
  [anon_sym_require] = "require",
  [anon_sym_export] = "export",
  [anon_sym_OVERRIDES] = "OVERRIDES",
  [anon_sym_EXPORT_FUNCTIONS] = "EXPORT_FUNCTIONS",
  [anon_sym_addtask] = "addtask",
  [anon_sym_after] = "after",
  [anon_sym_before] = "before",
  [anon_sym_deltask] = "deltask",
  [anon_sym_addhandler] = "addhandler",
  [anon_sym_fakeroot] = "fakeroot",
  [anon_sym_python] = "python",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [aux_sym_string_token1] = "string_content",
  [aux_sym_string_token2] = "string_token2",
  [anon_sym_DOLLARBB_ENV_PASSTHROUGH] = "$BB_ENV_PASSTHROUGH",
  [anon_sym_DOLLARBB_ENV_PASSTHROUGH_ADDITIONS] = "$BB_ENV_PASSTHROUGH_ADDITIONS",
  [anon_sym_DOLLAR] = "string_content",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token3] = "string_content",
  [aux_sym_string_token4] = "string_token4",
  [anon_sym_DOLLAR_LBRACE_AT] = "${@",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_def] = "def",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_SEMI] = ";",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_from] = "from",
  [anon_sym___future__] = "__future__",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_print] = "print",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_raise] = "raise",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_global] = "global",
  [anon_sym_nonlocal] = "nonlocal",
  [anon_sym_exec] = "exec",
  [anon_sym_in] = "in",
  [anon_sym_if] = "if",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_while] = "while",
  [anon_sym_try] = "try",
  [anon_sym_except] = "except",
  [anon_sym_except_STAR] = "except*",
  [anon_sym_finally] = "finally",
  [anon_sym_with] = "with",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_AT] = "@",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_is] = "is",
  [anon_sym_lambda] = "lambda",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_yield] = "yield",
  [sym_ellipsis] = "ellipsis",
  [sym_escape_sequence] = "escape_sequence",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [anon_sym_await] = "await",
  [anon_sym_match] = "python_identifier",
  [anon_sym_type] = "python_identifier",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [sym_python_identifier] = "python_identifier",
  [sym_identifier] = "identifier",
  [aux_sym__dotted_identifier_token1] = "identifier",
  [sym_comment] = "comment",
  [sym__concat] = "_concat",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym_string_start] = "string_start",
  [sym__string_content] = "_string_content",
  [sym_escape_interpolation] = "escape_interpolation",
  [sym_string_end] = "string_end",
  [sym_shell_content] = "shell_content",
  [sym_recipe] = "recipe",
  [sym_variable_assignment] = "variable_assignment",
  [sym_variable_flag] = "variable_flag",
  [sym_override] = "override",
  [sym_unset_statement] = "unset_statement",
  [sym_inherit_directive] = "inherit_directive",
  [sym_include_directive] = "include_directive",
  [sym_require_directive] = "require_directive",
  [sym_export_statement] = "export_statement",
  [sym_overrides_statement] = "overrides_statement",
  [sym_export_functions_statement] = "export_functions_statement",
  [sym_addtask_statement] = "addtask_statement",
  [sym_deltask_statement] = "deltask_statement",
  [sym_addhandler_statement] = "addhandler_statement",
  [sym_anonymous_python_function] = "anonymous_python_function",
  [sym_function_definition] = "function_definition",
  [sym_literal] = "literal",
  [sym_string] = "string",
  [sym_inline_python] = "inline_python",
  [sym_variable_expansion] = "variable_expansion",
  [sym_python_function_definition] = "python_function_definition",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_import_statement] = "import_statement",
  [sym_import_prefix] = "import_prefix",
  [sym_relative_import] = "relative_import",
  [sym_future_import_statement] = "future_import_statement",
  [sym_import_from_statement] = "import_from_statement",
  [sym__import_list] = "_import_list",
  [sym_aliased_import] = "aliased_import",
  [sym_wildcard_import] = "wildcard_import",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym__named_expression_lhs] = "_named_expression_lhs",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_global_statement] = "global_statement",
  [sym_nonlocal_statement] = "nonlocal_statement",
  [sym_exec_statement] = "exec_statement",
  [sym_type_parameter] = "type_parameter",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_try_statement] = "try_statement",
  [sym_except_clause] = "except_clause",
  [sym_except_group_clause] = "except_group_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_with_statement] = "with_statement",
  [sym_with_clause] = "with_clause",
  [sym_with_item] = "with_item",
  [sym_dotted_name] = "dotted_name",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pattern_list] = "pattern_list",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_yield] = "yield",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_generator_expression] = "generator_expression",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_block] = "block",
  [sym_expression_list] = "expression_list",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym__parameters] = "_parameters",
  [sym__patterns] = "_patterns",
  [sym_parameter] = "parameter",
  [sym_pattern] = "pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat_pattern] = "list_splat_pattern",
  [sym_dictionary_splat_pattern] = "dictionary_splat_pattern",
  [sym_as_pattern] = "as_pattern",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_splat_type] = "splat_type",
  [sym_generic_type] = "generic_type",
  [sym_union_type] = "union_type",
  [sym_constrained_type] = "constrained_type",
  [sym_member_type] = "member_type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym_set] = "set",
  [sym_tuple] = "tuple",
  [sym_dictionary] = "dictionary",
  [sym_pair] = "pair",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_set_comprehension] = "set_comprehension",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_python_string] = "python_string",
  [sym_string_content] = "string_content",
  [sym_interpolation] = "interpolation",
  [sym__f_expression] = "_f_expression",
  [sym_format_specifier] = "format_specifier",
  [sym_await] = "await",
  [sym_positional_separator] = "positional_separator",
  [sym_keyword_separator] = "keyword_separator",
  [sym_concatenation] = "concatenation",
  [aux_sym_recipe_repeat1] = "recipe_repeat1",
  [aux_sym_override_repeat1] = "override_repeat1",
  [aux_sym_inherit_directive_repeat1] = "inherit_directive_repeat1",
  [aux_sym_overrides_statement_repeat1] = "overrides_statement_repeat1",
  [aux_sym_export_functions_statement_repeat1] = "export_functions_statement_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_import_prefix_repeat1] = "import_prefix_repeat1",
  [aux_sym__import_list_repeat1] = "_import_list_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_global_statement_repeat1] = "global_statement_repeat1",
  [aux_sym_type_parameter_repeat1] = "type_parameter_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_try_statement_repeat2] = "try_statement_repeat2",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_pattern_list_repeat1] = "pattern_list_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_python_string_repeat1] = "python_string_repeat1",
  [aux_sym_string_content_repeat1] = "string_content_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [alias_sym_as_pattern_target] = "as_pattern_target",
  [alias_sym_format_expression] = "format_expression",
  [anon_alias_sym_isnot] = "is not",
  [anon_alias_sym_notin] = "not in",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [aux_sym_recipe_token1] = aux_sym_recipe_token1,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_QMARK_EQ] = anon_sym_QMARK_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_EQ_PLUS] = anon_sym_EQ_PLUS,
  [anon_sym_DOT_EQ] = anon_sym_DOT_EQ,
  [anon_sym_EQ_DOT] = anon_sym_EQ_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_noexec] = anon_sym_noexec,
  [aux_sym_variable_flag_token1] = aux_sym_variable_flag_token1,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_append] = anon_sym_append,
  [anon_sym_prepend] = anon_sym_prepend,
  [anon_sym_remove] = anon_sym_remove,
  [anon_sym_unset] = anon_sym_unset,
  [anon_sym_inherit] = anon_sym_inherit,
  [sym_inherit_path] = sym_inherit_path,
  [anon_sym_INHERIT] = anon_sym_INHERIT,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_include] = anon_sym_include,
  [aux_sym_include_directive_token1] = aux_sym_include_directive_token1,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_OVERRIDES] = anon_sym_OVERRIDES,
  [anon_sym_EXPORT_FUNCTIONS] = anon_sym_EXPORT_FUNCTIONS,
  [anon_sym_addtask] = anon_sym_addtask,
  [anon_sym_after] = anon_sym_after,
  [anon_sym_before] = anon_sym_before,
  [anon_sym_deltask] = anon_sym_deltask,
  [anon_sym_addhandler] = anon_sym_addhandler,
  [anon_sym_fakeroot] = anon_sym_fakeroot,
  [anon_sym_python] = anon_sym_python,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [aux_sym_string_token1] = sym_string_content,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [anon_sym_DOLLARBB_ENV_PASSTHROUGH] = anon_sym_DOLLARBB_ENV_PASSTHROUGH,
  [anon_sym_DOLLARBB_ENV_PASSTHROUGH_ADDITIONS] = anon_sym_DOLLARBB_ENV_PASSTHROUGH_ADDITIONS,
  [anon_sym_DOLLAR] = sym_string_content,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token3] = sym_string_content,
  [aux_sym_string_token4] = aux_sym_string_token4,
  [anon_sym_DOLLAR_LBRACE_AT] = anon_sym_DOLLAR_LBRACE_AT,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym___future__] = anon_sym___future__,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_raise] = anon_sym_raise,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_nonlocal] = anon_sym_nonlocal,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_except] = anon_sym_except,
  [anon_sym_except_STAR] = anon_sym_except_STAR,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_yield] = anon_sym_yield,
  [sym_ellipsis] = sym_ellipsis,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_match] = sym_python_identifier,
  [anon_sym_type] = sym_python_identifier,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [sym_python_identifier] = sym_python_identifier,
  [sym_identifier] = sym_identifier,
  [aux_sym__dotted_identifier_token1] = sym_identifier,
  [sym_comment] = sym_comment,
  [sym__concat] = sym__concat,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym_string_start] = sym_string_start,
  [sym__string_content] = sym__string_content,
  [sym_escape_interpolation] = sym_escape_interpolation,
  [sym_string_end] = sym_string_end,
  [sym_shell_content] = sym_shell_content,
  [sym_recipe] = sym_recipe,
  [sym_variable_assignment] = sym_variable_assignment,
  [sym_variable_flag] = sym_variable_flag,
  [sym_override] = sym_override,
  [sym_unset_statement] = sym_unset_statement,
  [sym_inherit_directive] = sym_inherit_directive,
  [sym_include_directive] = sym_include_directive,
  [sym_require_directive] = sym_require_directive,
  [sym_export_statement] = sym_export_statement,
  [sym_overrides_statement] = sym_overrides_statement,
  [sym_export_functions_statement] = sym_export_functions_statement,
  [sym_addtask_statement] = sym_addtask_statement,
  [sym_deltask_statement] = sym_deltask_statement,
  [sym_addhandler_statement] = sym_addhandler_statement,
  [sym_anonymous_python_function] = sym_anonymous_python_function,
  [sym_function_definition] = sym_function_definition,
  [sym_literal] = sym_literal,
  [sym_string] = sym_string,
  [sym_inline_python] = sym_inline_python,
  [sym_variable_expansion] = sym_variable_expansion,
  [sym_python_function_definition] = sym_python_function_definition,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_import_statement] = sym_import_statement,
  [sym_import_prefix] = sym_import_prefix,
  [sym_relative_import] = sym_relative_import,
  [sym_future_import_statement] = sym_future_import_statement,
  [sym_import_from_statement] = sym_import_from_statement,
  [sym__import_list] = sym__import_list,
  [sym_aliased_import] = sym_aliased_import,
  [sym_wildcard_import] = sym_wildcard_import,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym__named_expression_lhs] = sym__named_expression_lhs,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_global_statement] = sym_global_statement,
  [sym_nonlocal_statement] = sym_nonlocal_statement,
  [sym_exec_statement] = sym_exec_statement,
  [sym_type_parameter] = sym_type_parameter,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_except_clause] = sym_except_clause,
  [sym_except_group_clause] = sym_except_group_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_with_statement] = sym_with_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_with_item] = sym_with_item,
  [sym_dotted_name] = sym_dotted_name,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pattern_list] = sym_pattern_list,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_yield] = sym_yield,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_generator_expression] = sym_generator_expression,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_block] = sym_block,
  [sym_expression_list] = sym_expression_list,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym__parameters] = sym__parameters,
  [sym__patterns] = sym__patterns,
  [sym_parameter] = sym_parameter,
  [sym_pattern] = sym_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat_pattern] = sym_list_splat_pattern,
  [sym_dictionary_splat_pattern] = sym_dictionary_splat_pattern,
  [sym_as_pattern] = sym_as_pattern,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_splat_type] = sym_splat_type,
  [sym_generic_type] = sym_generic_type,
  [sym_union_type] = sym_union_type,
  [sym_constrained_type] = sym_constrained_type,
  [sym_member_type] = sym_member_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym_set] = sym_set,
  [sym_tuple] = sym_tuple,
  [sym_dictionary] = sym_dictionary,
  [sym_pair] = sym_pair,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_python_string] = sym_python_string,
  [sym_string_content] = sym_string_content,
  [sym_interpolation] = sym_interpolation,
  [sym__f_expression] = sym__f_expression,
  [sym_format_specifier] = sym_format_specifier,
  [sym_await] = sym_await,
  [sym_positional_separator] = sym_positional_separator,
  [sym_keyword_separator] = sym_keyword_separator,
  [sym_concatenation] = sym_concatenation,
  [aux_sym_recipe_repeat1] = aux_sym_recipe_repeat1,
  [aux_sym_override_repeat1] = aux_sym_override_repeat1,
  [aux_sym_inherit_directive_repeat1] = aux_sym_inherit_directive_repeat1,
  [aux_sym_overrides_statement_repeat1] = aux_sym_overrides_statement_repeat1,
  [aux_sym_export_functions_statement_repeat1] = aux_sym_export_functions_statement_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_import_prefix_repeat1] = aux_sym_import_prefix_repeat1,
  [aux_sym__import_list_repeat1] = aux_sym__import_list_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_global_statement_repeat1] = aux_sym_global_statement_repeat1,
  [aux_sym_type_parameter_repeat1] = aux_sym_type_parameter_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_try_statement_repeat2] = aux_sym_try_statement_repeat2,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_pattern_list_repeat1] = aux_sym_pattern_list_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_python_string_repeat1] = aux_sym_python_string_repeat1,
  [aux_sym_string_content_repeat1] = aux_sym_string_content_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
  [aux_sym_concatenation_repeat1] = aux_sym_concatenation_repeat1,
  [alias_sym_as_pattern_target] = alias_sym_as_pattern_target,
  [alias_sym_format_expression] = alias_sym_format_expression,
  [anon_alias_sym_isnot] = anon_alias_sym_isnot,
  [anon_alias_sym_notin] = anon_alias_sym_notin,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_recipe_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noexec] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_variable_flag_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_append] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_prepend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_remove] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inherit] = {
    .visible = true,
    .named = false,
  },
  [sym_inherit_path] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_INHERIT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_include_directive_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OVERRIDES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXPORT_FUNCTIONS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_addtask] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_after] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_before] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_deltask] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_addhandler] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fakeroot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_python] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLARBB_ENV_PASSTHROUGH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLARBB_ENV_PASSTHROUGH_ADDITIONS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token3] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_token4] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___future__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_python_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__dotted_identifier_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym_string_start] = {
    .visible = true,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_string_end] = {
    .visible = true,
    .named = true,
  },
  [sym_shell_content] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_flag] = {
    .visible = true,
    .named = true,
  },
  [sym_override] = {
    .visible = true,
    .named = true,
  },
  [sym_unset_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_inherit_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_include_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_require_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_overrides_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_functions_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_addtask_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_deltask_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_addhandler_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_python_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_python] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_python_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_import] = {
    .visible = true,
    .named = true,
  },
  [sym_future_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_from_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import_list] = {
    .visible = false,
    .named = true,
  },
  [sym_aliased_import] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_import] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__named_expression_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nonlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_except_group_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_list] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_yield] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__patterns] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_type] = {
    .visible = true,
    .named = true,
  },
  [sym_member_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_python_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__f_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_await] = {
    .visible = true,
    .named = true,
  },
  [sym_positional_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_recipe_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_override_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inherit_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_overrides_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_functions_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_python_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_as_pattern_target] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_format_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_isnot] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_notin] = {
    .visible = true,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_cause = 7,
  field_code = 8,
  field_condition = 9,
  field_consequence = 10,
  field_expression = 11,
  field_format_specifier = 12,
  field_function = 13,
  field_key = 14,
  field_left = 15,
  field_module_name = 16,
  field_name = 17,
  field_object = 18,
  field_operator = 19,
  field_operators = 20,
  field_parameters = 21,
  field_return_type = 22,
  field_right = 23,
  field_subscript = 24,
  field_type = 25,
  field_type_conversion = 26,
  field_value = 27,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_cause] = "cause",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_expression] = "expression",
  [field_format_specifier] = "format_specifier",
  [field_function] = "function",
  [field_key] = "key",
  [field_left] = "left",
  [field_module_name] = "module_name",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_operators] = "operators",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subscript] = "subscript",
  [field_type] = "type",
  [field_type_conversion] = "type_conversion",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [5] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 2},
  [7] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 1},
  [9] = {.index = 7, .length = 1},
  [10] = {.index = 8, .length = 1},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 1},
  [13] = {.index = 12, .length = 3},
  [14] = {.index = 15, .length = 2},
  [15] = {.index = 17, .length = 1},
  [16] = {.index = 18, .length = 2},
  [17] = {.index = 20, .length = 3},
  [18] = {.index = 23, .length = 1},
  [20] = {.index = 24, .length = 1},
  [21] = {.index = 25, .length = 2},
  [22] = {.index = 27, .length = 1},
  [23] = {.index = 28, .length = 2},
  [24] = {.index = 30, .length = 2},
  [25] = {.index = 32, .length = 2},
  [26] = {.index = 32, .length = 2},
  [28] = {.index = 34, .length = 1},
  [29] = {.index = 35, .length = 1},
  [30] = {.index = 36, .length = 1},
  [31] = {.index = 37, .length = 4},
  [33] = {.index = 41, .length = 2},
  [34] = {.index = 43, .length = 2},
  [35] = {.index = 45, .length = 1},
  [36] = {.index = 46, .length = 3},
  [37] = {.index = 49, .length = 2},
  [38] = {.index = 9, .length = 2},
  [40] = {.index = 51, .length = 1},
  [41] = {.index = 52, .length = 2},
  [42] = {.index = 54, .length = 1},
  [43] = {.index = 55, .length = 2},
  [44] = {.index = 57, .length = 1},
  [45] = {.index = 58, .length = 2},
  [46] = {.index = 60, .length = 2},
  [47] = {.index = 62, .length = 4},
  [48] = {.index = 66, .length = 2},
  [49] = {.index = 68, .length = 2},
  [50] = {.index = 70, .length = 3},
  [51] = {.index = 73, .length = 2},
  [52] = {.index = 75, .length = 3},
  [54] = {.index = 78, .length = 1},
  [55] = {.index = 79, .length = 2},
  [56] = {.index = 81, .length = 2},
  [57] = {.index = 83, .length = 1},
  [58] = {.index = 84, .length = 2},
  [59] = {.index = 86, .length = 1},
  [60] = {.index = 87, .length = 2},
  [61] = {.index = 89, .length = 1},
  [62] = {.index = 90, .length = 5},
  [63] = {.index = 95, .length = 3},
  [64] = {.index = 98, .length = 2},
  [65] = {.index = 100, .length = 3},
  [67] = {.index = 103, .length = 2},
  [68] = {.index = 105, .length = 2},
  [69] = {.index = 8, .length = 1},
  [70] = {.index = 107, .length = 1},
  [71] = {.index = 108, .length = 3},
  [72] = {.index = 111, .length = 3},
  [73] = {.index = 114, .length = 1},
  [74] = {.index = 115, .length = 3},
  [75] = {.index = 118, .length = 3},
  [76] = {.index = 121, .length = 3},
  [77] = {.index = 124, .length = 1},
  [78] = {.index = 125, .length = 3},
  [79] = {.index = 128, .length = 3},
  [80] = {.index = 131, .length = 2},
  [81] = {.index = 133, .length = 2},
  [82] = {.index = 135, .length = 1},
  [83] = {.index = 136, .length = 2},
  [84] = {.index = 138, .length = 4},
  [85] = {.index = 142, .length = 2},
  [86] = {.index = 144, .length = 4},
  [87] = {.index = 148, .length = 4},
  [88] = {.index = 152, .length = 2},
  [89] = {.index = 154, .length = 3},
  [90] = {.index = 157, .length = 4},
  [92] = {.index = 161, .length = 5},
  [93] = {.index = 166, .length = 3},
  [94] = {.index = 169, .length = 4},
  [95] = {.index = 173, .length = 4},
  [97] = {.index = 177, .length = 4},
  [98] = {.index = 181, .length = 4},
  [99] = {.index = 185, .length = 5},
  [100] = {.index = 190, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_operator, 1},
  [1] =
    {field_argument, 1},
  [2] =
    {field_argument, 1},
    {field_operator, 0},
  [4] =
    {field_arguments, 1},
    {field_function, 0},
  [6] =
    {field_operators, 1, .inherited = true},
  [7] =
    {field_operator, 2},
  [8] =
    {field_body, 2},
  [9] =
    {field_name, 0},
    {field_value, 2},
  [11] =
    {field_alias, 2},
  [12] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [15] =
    {field_attribute, 2},
    {field_object, 0},
  [17] =
    {field_operators, 0},
  [18] =
    {field_operators, 0, .inherited = true},
    {field_operators, 1, .inherited = true},
  [20] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [23] =
    {field_expression, 1},
  [24] =
    {field_body, 1},
  [25] =
    {field_key, 0},
    {field_value, 2},
  [27] =
    {field_type, 2},
  [28] =
    {field_body, 3},
    {field_parameters, 1},
  [30] =
    {field_subscript, 2},
    {field_value, 0},
  [32] =
    {field_operators, 0},
    {field_operators, 1},
  [34] =
    {field_name, 1, .inherited = true},
  [35] =
    {field_name, 0},
  [36] =
    {field_code, 1},
  [37] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [41] =
    {field_expression, 1},
    {field_type_conversion, 2},
  [43] =
    {field_expression, 1},
    {field_format_specifier, 2},
  [45] =
    {field_subscript, 1},
  [46] =
    {field_subscript, 2},
    {field_subscript, 3, .inherited = true},
    {field_value, 0},
  [49] =
    {field_subscript, 0, .inherited = true},
    {field_subscript, 1, .inherited = true},
  [51] =
    {field_value, 0},
  [52] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [54] =
    {field_argument, 2, .inherited = true},
  [55] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [57] =
    {field_cause, 2},
  [58] =
    {field_left, 0},
    {field_right, 2},
  [60] =
    {field_left, 0},
    {field_type, 2},
  [62] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [66] =
    {field_expression, 1},
    {field_type_conversion, 3},
  [68] =
    {field_expression, 1},
    {field_format_specifier, 3},
  [70] =
    {field_expression, 1},
    {field_format_specifier, 3},
    {field_type_conversion, 2},
  [73] =
    {field_left, 1},
    {field_right, 3},
  [75] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [78] =
    {field_name, 1},
  [79] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [81] =
    {field_alias, 2},
    {field_name, 0},
  [83] =
    {field_name, 3, .inherited = true},
  [84] =
    {field_module_name, 1},
    {field_name, 3, .inherited = true},
  [86] =
    {field_module_name, 1},
  [87] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [89] =
    {field_cause, 3},
  [90] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [95] =
    {field_expression, 1},
    {field_format_specifier, 4},
    {field_type_conversion, 3},
  [98] =
    {field_left, 2},
    {field_right, 4},
  [100] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [103] =
    {field_condition, 1},
    {field_consequence, 3},
  [105] =
    {field_body, 3},
    {field_condition, 1},
  [107] =
    {field_body, 3},
  [108] =
    {field_left, 0},
    {field_right, 4},
    {field_type, 2},
  [111] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [114] =
    {field_alternative, 0},
  [115] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [118] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [121] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [124] =
    {field_body, 4},
  [125] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [128] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [131] =
    {field_body, 2},
    {field_body, 3},
  [133] =
    {field_body, 3},
    {field_body, 4},
  [135] =
    {field_name, 4, .inherited = true},
  [136] =
    {field_module_name, 1},
    {field_name, 4, .inherited = true},
  [138] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [142] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [144] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [148] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [152] =
    {field_body, 4},
    {field_body, 5},
  [154] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [157] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [161] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [166] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [169] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [173] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [177] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [181] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [185] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [190] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_python_identifier,
  },
  [2] = {
    [0] = sym_list_splat,
  },
  [4] = {
    [1] = sym_python_identifier,
  },
  [12] = {
    [2] = alias_sym_as_pattern_target,
  },
  [17] = {
    [4] = sym_block,
  },
  [19] = {
    [1] = sym_parenthesized_expression,
  },
  [25] = {
    [0] = anon_alias_sym_notin,
    [1] = anon_alias_sym_notin,
  },
  [26] = {
    [0] = anon_alias_sym_isnot,
    [1] = anon_alias_sym_isnot,
  },
  [27] = {
    [4] = sym_block,
  },
  [32] = {
    [0] = alias_sym_format_expression,
  },
  [38] = {
    [0] = sym_python_identifier,
  },
  [39] = {
    [5] = sym_block,
  },
  [47] = {
    [6] = sym_block,
  },
  [53] = {
    [6] = sym_block,
  },
  [66] = {
    [7] = sym_block,
  },
  [67] = {
    [3] = sym_block,
  },
  [68] = {
    [3] = sym_block,
  },
  [69] = {
    [2] = sym_block,
  },
  [70] = {
    [3] = sym_block,
  },
  [74] = {
    [3] = sym_block,
  },
  [75] = {
    [3] = sym_block,
  },
  [77] = {
    [4] = sym_block,
  },
  [78] = {
    [3] = sym_block,
  },
  [84] = {
    [3] = sym_block,
  },
  [89] = {
    [5] = sym_block,
  },
  [91] = {
    [2] = sym_block,
  },
  [93] = {
    [6] = sym_block,
  },
  [94] = {
    [5] = sym_block,
  },
  [96] = {
    [3] = sym_block,
  },
  [97] = {
    [6] = sym_block,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_statements, 2,
    sym__simple_statements,
    sym_block,
  sym_parenthesized_list_splat, 2,
    sym_parenthesized_list_splat,
    sym_parenthesized_expression,
  sym_list_splat_pattern, 2,
    sym_list_splat_pattern,
    sym_list_splat,
  sym_expression, 2,
    sym_expression,
    alias_sym_as_pattern_target,
  sym_interpolation, 2,
    sym_interpolation,
    alias_sym_format_expression,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 5,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 7,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 4,
  [25] = 25,
  [26] = 26,
  [27] = 26,
  [28] = 28,
  [29] = 26,
  [30] = 26,
  [31] = 26,
  [32] = 26,
  [33] = 26,
  [34] = 26,
  [35] = 26,
  [36] = 36,
  [37] = 37,
  [38] = 37,
  [39] = 36,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 47,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 44,
  [61] = 61,
  [62] = 61,
  [63] = 63,
  [64] = 63,
  [65] = 61,
  [66] = 63,
  [67] = 61,
  [68] = 61,
  [69] = 63,
  [70] = 61,
  [71] = 61,
  [72] = 61,
  [73] = 63,
  [74] = 61,
  [75] = 63,
  [76] = 63,
  [77] = 63,
  [78] = 63,
  [79] = 79,
  [80] = 80,
  [81] = 80,
  [82] = 82,
  [83] = 80,
  [84] = 84,
  [85] = 84,
  [86] = 82,
  [87] = 82,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 84,
  [92] = 89,
  [93] = 84,
  [94] = 84,
  [95] = 88,
  [96] = 82,
  [97] = 80,
  [98] = 82,
  [99] = 89,
  [100] = 100,
  [101] = 89,
  [102] = 89,
  [103] = 90,
  [104] = 84,
  [105] = 82,
  [106] = 84,
  [107] = 88,
  [108] = 84,
  [109] = 82,
  [110] = 80,
  [111] = 84,
  [112] = 82,
  [113] = 82,
  [114] = 89,
  [115] = 88,
  [116] = 82,
  [117] = 82,
  [118] = 89,
  [119] = 89,
  [120] = 88,
  [121] = 88,
  [122] = 89,
  [123] = 84,
  [124] = 82,
  [125] = 100,
  [126] = 89,
  [127] = 82,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 130,
  [132] = 129,
  [133] = 133,
  [134] = 130,
  [135] = 135,
  [136] = 129,
  [137] = 129,
  [138] = 135,
  [139] = 139,
  [140] = 135,
  [141] = 130,
  [142] = 130,
  [143] = 129,
  [144] = 129,
  [145] = 135,
  [146] = 135,
  [147] = 130,
  [148] = 129,
  [149] = 135,
  [150] = 135,
  [151] = 129,
  [152] = 135,
  [153] = 130,
  [154] = 129,
  [155] = 129,
  [156] = 129,
  [157] = 139,
  [158] = 158,
  [159] = 130,
  [160] = 130,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 163,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 167,
  [169] = 169,
  [170] = 170,
  [171] = 165,
  [172] = 170,
  [173] = 161,
  [174] = 162,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 167,
  [179] = 175,
  [180] = 176,
  [181] = 167,
  [182] = 167,
  [183] = 167,
  [184] = 165,
  [185] = 165,
  [186] = 170,
  [187] = 187,
  [188] = 175,
  [189] = 167,
  [190] = 190,
  [191] = 175,
  [192] = 167,
  [193] = 170,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 196,
  [199] = 199,
  [200] = 197,
  [201] = 196,
  [202] = 202,
  [203] = 195,
  [204] = 196,
  [205] = 197,
  [206] = 206,
  [207] = 195,
  [208] = 196,
  [209] = 209,
  [210] = 202,
  [211] = 199,
  [212] = 206,
  [213] = 202,
  [214] = 199,
  [215] = 209,
  [216] = 202,
  [217] = 206,
  [218] = 195,
  [219] = 197,
  [220] = 196,
  [221] = 199,
  [222] = 197,
  [223] = 209,
  [224] = 206,
  [225] = 209,
  [226] = 199,
  [227] = 209,
  [228] = 195,
  [229] = 202,
  [230] = 197,
  [231] = 197,
  [232] = 199,
  [233] = 209,
  [234] = 196,
  [235] = 209,
  [236] = 199,
  [237] = 195,
  [238] = 206,
  [239] = 209,
  [240] = 199,
  [241] = 197,
  [242] = 196,
  [243] = 195,
  [244] = 206,
  [245] = 202,
  [246] = 206,
  [247] = 195,
  [248] = 206,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 82,
  [254] = 251,
  [255] = 249,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 251,
  [261] = 252,
  [262] = 250,
  [263] = 257,
  [264] = 258,
  [265] = 100,
  [266] = 252,
  [267] = 257,
  [268] = 268,
  [269] = 258,
  [270] = 250,
  [271] = 249,
  [272] = 272,
  [273] = 273,
  [274] = 273,
  [275] = 272,
  [276] = 272,
  [277] = 273,
  [278] = 278,
  [279] = 272,
  [280] = 273,
  [281] = 166,
  [282] = 272,
  [283] = 272,
  [284] = 278,
  [285] = 273,
  [286] = 272,
  [287] = 273,
  [288] = 273,
  [289] = 273,
  [290] = 278,
  [291] = 291,
  [292] = 272,
  [293] = 166,
  [294] = 166,
  [295] = 295,
  [296] = 259,
  [297] = 295,
  [298] = 298,
  [299] = 298,
  [300] = 300,
  [301] = 300,
  [302] = 302,
  [303] = 300,
  [304] = 304,
  [305] = 295,
  [306] = 295,
  [307] = 300,
  [308] = 298,
  [309] = 298,
  [310] = 295,
  [311] = 298,
  [312] = 312,
  [313] = 300,
  [314] = 300,
  [315] = 82,
  [316] = 316,
  [317] = 300,
  [318] = 298,
  [319] = 295,
  [320] = 300,
  [321] = 321,
  [322] = 300,
  [323] = 298,
  [324] = 295,
  [325] = 300,
  [326] = 298,
  [327] = 298,
  [328] = 295,
  [329] = 295,
  [330] = 256,
  [331] = 298,
  [332] = 295,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 100,
  [339] = 339,
  [340] = 100,
  [341] = 341,
  [342] = 100,
  [343] = 343,
  [344] = 337,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 337,
  [349] = 321,
  [350] = 337,
  [351] = 337,
  [352] = 352,
  [353] = 341,
  [354] = 259,
  [355] = 343,
  [356] = 356,
  [357] = 357,
  [358] = 352,
  [359] = 352,
  [360] = 360,
  [361] = 337,
  [362] = 362,
  [363] = 363,
  [364] = 334,
  [365] = 341,
  [366] = 337,
  [367] = 367,
  [368] = 256,
  [369] = 369,
  [370] = 334,
  [371] = 371,
  [372] = 343,
  [373] = 82,
  [374] = 259,
  [375] = 256,
  [376] = 337,
  [377] = 377,
  [378] = 82,
  [379] = 259,
  [380] = 256,
  [381] = 371,
  [382] = 82,
  [383] = 371,
  [384] = 82,
  [385] = 385,
  [386] = 337,
  [387] = 337,
  [388] = 388,
  [389] = 389,
  [390] = 389,
  [391] = 391,
  [392] = 259,
  [393] = 256,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 406,
  [408] = 406,
  [409] = 406,
  [410] = 406,
  [411] = 406,
  [412] = 406,
  [413] = 413,
  [414] = 406,
  [415] = 415,
  [416] = 413,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 406,
  [421] = 413,
  [422] = 405,
  [423] = 423,
  [424] = 398,
  [425] = 400,
  [426] = 401,
  [427] = 403,
  [428] = 417,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 413,
  [435] = 418,
  [436] = 436,
  [437] = 405,
  [438] = 398,
  [439] = 400,
  [440] = 433,
  [441] = 417,
  [442] = 401,
  [443] = 403,
  [444] = 444,
  [445] = 433,
  [446] = 418,
  [447] = 417,
  [448] = 433,
  [449] = 433,
  [450] = 405,
  [451] = 398,
  [452] = 452,
  [453] = 418,
  [454] = 431,
  [455] = 400,
  [456] = 401,
  [457] = 396,
  [458] = 403,
  [459] = 417,
  [460] = 418,
  [461] = 433,
  [462] = 403,
  [463] = 401,
  [464] = 464,
  [465] = 400,
  [466] = 431,
  [467] = 467,
  [468] = 398,
  [469] = 396,
  [470] = 397,
  [471] = 471,
  [472] = 418,
  [473] = 473,
  [474] = 405,
  [475] = 417,
  [476] = 476,
  [477] = 417,
  [478] = 89,
  [479] = 396,
  [480] = 405,
  [481] = 481,
  [482] = 467,
  [483] = 398,
  [484] = 82,
  [485] = 431,
  [486] = 400,
  [487] = 398,
  [488] = 400,
  [489] = 406,
  [490] = 401,
  [491] = 444,
  [492] = 401,
  [493] = 403,
  [494] = 397,
  [495] = 403,
  [496] = 418,
  [497] = 396,
  [498] = 433,
  [499] = 405,
  [500] = 500,
  [501] = 500,
  [502] = 405,
  [503] = 418,
  [504] = 398,
  [505] = 433,
  [506] = 418,
  [507] = 433,
  [508] = 433,
  [509] = 418,
  [510] = 403,
  [511] = 401,
  [512] = 400,
  [513] = 398,
  [514] = 400,
  [515] = 405,
  [516] = 401,
  [517] = 403,
  [518] = 417,
  [519] = 464,
  [520] = 417,
  [521] = 473,
  [522] = 397,
  [523] = 444,
  [524] = 471,
  [525] = 417,
  [526] = 405,
  [527] = 527,
  [528] = 398,
  [529] = 396,
  [530] = 400,
  [531] = 401,
  [532] = 431,
  [533] = 403,
  [534] = 431,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 544,
  [546] = 543,
  [547] = 547,
  [548] = 161,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 551,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 555,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 552,
  [572] = 162,
  [573] = 567,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 577,
  [582] = 580,
  [583] = 576,
  [584] = 584,
  [585] = 584,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 579,
  [593] = 593,
  [594] = 594,
  [595] = 578,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 584,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 580,
  [609] = 609,
  [610] = 610,
  [611] = 162,
  [612] = 600,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 579,
  [617] = 617,
  [618] = 603,
  [619] = 597,
  [620] = 161,
  [621] = 576,
  [622] = 603,
  [623] = 607,
  [624] = 600,
  [625] = 577,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 628,
  [630] = 584,
  [631] = 628,
  [632] = 579,
  [633] = 580,
  [634] = 580,
  [635] = 577,
  [636] = 628,
  [637] = 577,
  [638] = 584,
  [639] = 576,
  [640] = 579,
  [641] = 628,
  [642] = 642,
  [643] = 628,
  [644] = 576,
  [645] = 580,
  [646] = 646,
  [647] = 579,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 650,
  [657] = 657,
  [658] = 627,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 577,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 584,
  [673] = 642,
  [674] = 576,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 680,
  [682] = 680,
  [683] = 680,
  [684] = 680,
  [685] = 680,
  [686] = 680,
  [687] = 680,
  [688] = 680,
  [689] = 680,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 691,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 692,
  [701] = 692,
  [702] = 702,
  [703] = 699,
  [704] = 692,
  [705] = 692,
  [706] = 692,
  [707] = 691,
  [708] = 708,
  [709] = 695,
  [710] = 702,
  [711] = 694,
  [712] = 712,
  [713] = 692,
  [714] = 697,
  [715] = 693,
  [716] = 698,
  [717] = 690,
  [718] = 692,
  [719] = 690,
  [720] = 692,
  [721] = 690,
  [722] = 708,
  [723] = 702,
  [724] = 692,
  [725] = 690,
  [726] = 708,
  [727] = 699,
  [728] = 692,
  [729] = 692,
  [730] = 690,
  [731] = 690,
  [732] = 692,
  [733] = 697,
  [734] = 693,
  [735] = 690,
  [736] = 698,
  [737] = 691,
  [738] = 692,
  [739] = 691,
  [740] = 695,
  [741] = 694,
  [742] = 712,
  [743] = 697,
  [744] = 693,
  [745] = 745,
  [746] = 690,
  [747] = 698,
  [748] = 745,
  [749] = 692,
  [750] = 691,
  [751] = 695,
  [752] = 702,
  [753] = 694,
  [754] = 712,
  [755] = 697,
  [756] = 693,
  [757] = 698,
  [758] = 699,
  [759] = 745,
  [760] = 708,
  [761] = 708,
  [762] = 699,
  [763] = 692,
  [764] = 702,
  [765] = 745,
  [766] = 690,
  [767] = 708,
  [768] = 695,
  [769] = 695,
  [770] = 699,
  [771] = 694,
  [772] = 712,
  [773] = 708,
  [774] = 698,
  [775] = 693,
  [776] = 697,
  [777] = 712,
  [778] = 694,
  [779] = 695,
  [780] = 699,
  [781] = 708,
  [782] = 691,
  [783] = 697,
  [784] = 693,
  [785] = 698,
  [786] = 702,
  [787] = 787,
  [788] = 745,
  [789] = 691,
  [790] = 695,
  [791] = 691,
  [792] = 695,
  [793] = 694,
  [794] = 712,
  [795] = 697,
  [796] = 693,
  [797] = 698,
  [798] = 691,
  [799] = 695,
  [800] = 702,
  [801] = 702,
  [802] = 694,
  [803] = 712,
  [804] = 699,
  [805] = 697,
  [806] = 693,
  [807] = 698,
  [808] = 708,
  [809] = 690,
  [810] = 692,
  [811] = 694,
  [812] = 708,
  [813] = 698,
  [814] = 699,
  [815] = 712,
  [816] = 693,
  [817] = 699,
  [818] = 692,
  [819] = 712,
  [820] = 691,
  [821] = 695,
  [822] = 702,
  [823] = 694,
  [824] = 712,
  [825] = 697,
  [826] = 693,
  [827] = 698,
  [828] = 787,
  [829] = 697,
  [830] = 712,
  [831] = 694,
  [832] = 702,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 833,
  [838] = 835,
  [839] = 834,
  [840] = 835,
  [841] = 836,
  [842] = 834,
  [843] = 836,
  [844] = 833,
  [845] = 836,
  [846] = 846,
  [847] = 835,
  [848] = 836,
  [849] = 849,
  [850] = 836,
  [851] = 851,
  [852] = 836,
  [853] = 834,
  [854] = 854,
  [855] = 833,
  [856] = 856,
  [857] = 849,
  [858] = 858,
  [859] = 836,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 835,
  [864] = 835,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 833,
  [871] = 866,
  [872] = 846,
  [873] = 873,
  [874] = 874,
  [875] = 834,
  [876] = 854,
  [877] = 877,
  [878] = 833,
  [879] = 877,
  [880] = 834,
  [881] = 874,
  [882] = 834,
  [883] = 854,
  [884] = 856,
  [885] = 856,
  [886] = 849,
  [887] = 877,
  [888] = 865,
  [889] = 867,
  [890] = 868,
  [891] = 851,
  [892] = 866,
  [893] = 835,
  [894] = 851,
  [895] = 833,
  [896] = 846,
  [897] = 865,
  [898] = 867,
  [899] = 868,
  [900] = 874,
  [901] = 873,
  [902] = 873,
  [903] = 856,
  [904] = 904,
  [905] = 851,
  [906] = 866,
  [907] = 868,
  [908] = 867,
  [909] = 865,
  [910] = 849,
  [911] = 856,
  [912] = 846,
  [913] = 851,
  [914] = 868,
  [915] = 565,
  [916] = 916,
  [917] = 867,
  [918] = 564,
  [919] = 563,
  [920] = 561,
  [921] = 860,
  [922] = 559,
  [923] = 547,
  [924] = 543,
  [925] = 865,
  [926] = 550,
  [927] = 849,
  [928] = 544,
  [929] = 858,
  [930] = 542,
  [931] = 570,
  [932] = 877,
  [933] = 569,
  [934] = 858,
  [935] = 935,
  [936] = 936,
  [937] = 861,
  [938] = 938,
  [939] = 862,
  [940] = 940,
  [941] = 869,
  [942] = 873,
  [943] = 874,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 854,
  [948] = 846,
  [949] = 861,
  [950] = 851,
  [951] = 862,
  [952] = 874,
  [953] = 873,
  [954] = 954,
  [955] = 955,
  [956] = 874,
  [957] = 869,
  [958] = 846,
  [959] = 959,
  [960] = 916,
  [961] = 873,
  [962] = 962,
  [963] = 856,
  [964] = 849,
  [965] = 865,
  [966] = 867,
  [967] = 868,
  [968] = 968,
  [969] = 868,
  [970] = 866,
  [971] = 851,
  [972] = 846,
  [973] = 973,
  [974] = 974,
  [975] = 833,
  [976] = 976,
  [977] = 977,
  [978] = 854,
  [979] = 979,
  [980] = 980,
  [981] = 867,
  [982] = 865,
  [983] = 866,
  [984] = 984,
  [985] = 849,
  [986] = 986,
  [987] = 987,
  [988] = 835,
  [989] = 989,
  [990] = 990,
  [991] = 991,
  [992] = 856,
  [993] = 993,
  [994] = 994,
  [995] = 874,
  [996] = 873,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 877,
  [1001] = 1001,
  [1002] = 854,
  [1003] = 866,
  [1004] = 877,
  [1005] = 556,
  [1006] = 877,
  [1007] = 854,
  [1008] = 860,
  [1009] = 1009,
  [1010] = 836,
  [1011] = 836,
  [1012] = 834,
  [1013] = 869,
  [1014] = 977,
  [1015] = 1009,
  [1016] = 874,
  [1017] = 873,
  [1018] = 866,
  [1019] = 551,
  [1020] = 547,
  [1021] = 938,
  [1022] = 552,
  [1023] = 940,
  [1024] = 979,
  [1025] = 977,
  [1026] = 976,
  [1027] = 556,
  [1028] = 564,
  [1029] = 959,
  [1030] = 565,
  [1031] = 936,
  [1032] = 962,
  [1033] = 904,
  [1034] = 869,
  [1035] = 935,
  [1036] = 856,
  [1037] = 862,
  [1038] = 861,
  [1039] = 849,
  [1040] = 865,
  [1041] = 867,
  [1042] = 868,
  [1043] = 851,
  [1044] = 846,
  [1045] = 563,
  [1046] = 858,
  [1047] = 854,
  [1048] = 877,
  [1049] = 561,
  [1050] = 559,
  [1051] = 570,
  [1052] = 991,
  [1053] = 968,
  [1054] = 973,
  [1055] = 1001,
  [1056] = 954,
  [1057] = 974,
  [1058] = 556,
  [1059] = 569,
  [1060] = 569,
  [1061] = 570,
  [1062] = 946,
  [1063] = 999,
  [1064] = 998,
  [1065] = 997,
  [1066] = 567,
  [1067] = 555,
  [1068] = 990,
  [1069] = 916,
  [1070] = 869,
  [1071] = 860,
  [1072] = 862,
  [1073] = 861,
  [1074] = 858,
  [1075] = 987,
  [1076] = 858,
  [1077] = 861,
  [1078] = 862,
  [1079] = 869,
  [1080] = 543,
  [1081] = 986,
  [1082] = 544,
  [1083] = 542,
  [1084] = 856,
  [1085] = 849,
  [1086] = 865,
  [1087] = 860,
  [1088] = 867,
  [1089] = 868,
  [1090] = 851,
  [1091] = 846,
  [1092] = 989,
  [1093] = 994,
  [1094] = 860,
  [1095] = 979,
  [1096] = 877,
  [1097] = 854,
  [1098] = 976,
  [1099] = 836,
  [1100] = 861,
  [1101] = 862,
  [1102] = 993,
  [1103] = 874,
  [1104] = 873,
  [1105] = 866,
  [1106] = 980,
  [1107] = 860,
  [1108] = 858,
  [1109] = 836,
  [1110] = 935,
  [1111] = 936,
  [1112] = 565,
  [1113] = 550,
  [1114] = 564,
  [1115] = 938,
  [1116] = 940,
  [1117] = 563,
  [1118] = 561,
  [1119] = 559,
  [1120] = 946,
  [1121] = 954,
  [1122] = 904,
  [1123] = 547,
  [1124] = 959,
  [1125] = 962,
  [1126] = 968,
  [1127] = 973,
  [1128] = 974,
  [1129] = 916,
  [1130] = 550,
  [1131] = 984,
  [1132] = 986,
  [1133] = 987,
  [1134] = 989,
  [1135] = 990,
  [1136] = 991,
  [1137] = 542,
  [1138] = 544,
  [1139] = 543,
  [1140] = 1009,
  [1141] = 1001,
  [1142] = 556,
  [1143] = 999,
  [1144] = 998,
  [1145] = 984,
  [1146] = 997,
  [1147] = 994,
  [1148] = 836,
  [1149] = 993,
  [1150] = 980,
  [1151] = 547,
  [1152] = 565,
  [1153] = 564,
  [1154] = 563,
  [1155] = 561,
  [1156] = 559,
  [1157] = 550,
  [1158] = 987,
  [1159] = 565,
  [1160] = 560,
  [1161] = 550,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 860,
  [1165] = 1009,
  [1166] = 1001,
  [1167] = 940,
  [1168] = 547,
  [1169] = 991,
  [1170] = 984,
  [1171] = 556,
  [1172] = 569,
  [1173] = 946,
  [1174] = 569,
  [1175] = 570,
  [1176] = 858,
  [1177] = 570,
  [1178] = 990,
  [1179] = 940,
  [1180] = 938,
  [1181] = 1181,
  [1182] = 989,
  [1183] = 987,
  [1184] = 559,
  [1185] = 561,
  [1186] = 563,
  [1187] = 567,
  [1188] = 555,
  [1189] = 954,
  [1190] = 904,
  [1191] = 936,
  [1192] = 935,
  [1193] = 986,
  [1194] = 552,
  [1195] = 551,
  [1196] = 935,
  [1197] = 556,
  [1198] = 980,
  [1199] = 936,
  [1200] = 999,
  [1201] = 938,
  [1202] = 940,
  [1203] = 998,
  [1204] = 946,
  [1205] = 564,
  [1206] = 565,
  [1207] = 991,
  [1208] = 954,
  [1209] = 993,
  [1210] = 994,
  [1211] = 904,
  [1212] = 990,
  [1213] = 954,
  [1214] = 980,
  [1215] = 959,
  [1216] = 904,
  [1217] = 547,
  [1218] = 962,
  [1219] = 997,
  [1220] = 959,
  [1221] = 559,
  [1222] = 998,
  [1223] = 999,
  [1224] = 968,
  [1225] = 962,
  [1226] = 968,
  [1227] = 973,
  [1228] = 973,
  [1229] = 974,
  [1230] = 567,
  [1231] = 555,
  [1232] = 974,
  [1233] = 989,
  [1234] = 987,
  [1235] = 563,
  [1236] = 984,
  [1237] = 556,
  [1238] = 1001,
  [1239] = 993,
  [1240] = 994,
  [1241] = 836,
  [1242] = 997,
  [1243] = 959,
  [1244] = 962,
  [1245] = 556,
  [1246] = 968,
  [1247] = 973,
  [1248] = 1009,
  [1249] = 974,
  [1250] = 997,
  [1251] = 986,
  [1252] = 935,
  [1253] = 936,
  [1254] = 987,
  [1255] = 989,
  [1256] = 565,
  [1257] = 990,
  [1258] = 991,
  [1259] = 561,
  [1260] = 551,
  [1261] = 552,
  [1262] = 552,
  [1263] = 551,
  [1264] = 998,
  [1265] = 999,
  [1266] = 570,
  [1267] = 1009,
  [1268] = 569,
  [1269] = 1269,
  [1270] = 1001,
  [1271] = 994,
  [1272] = 993,
  [1273] = 984,
  [1274] = 944,
  [1275] = 1001,
  [1276] = 556,
  [1277] = 999,
  [1278] = 998,
  [1279] = 997,
  [1280] = 1009,
  [1281] = 945,
  [1282] = 994,
  [1283] = 993,
  [1284] = 861,
  [1285] = 862,
  [1286] = 564,
  [1287] = 980,
  [1288] = 955,
  [1289] = 869,
  [1290] = 986,
  [1291] = 991,
  [1292] = 990,
  [1293] = 989,
  [1294] = 569,
  [1295] = 570,
  [1296] = 560,
  [1297] = 556,
  [1298] = 986,
  [1299] = 980,
  [1300] = 935,
  [1301] = 555,
  [1302] = 567,
  [1303] = 936,
  [1304] = 938,
  [1305] = 564,
  [1306] = 984,
  [1307] = 938,
  [1308] = 940,
  [1309] = 550,
  [1310] = 550,
  [1311] = 946,
  [1312] = 563,
  [1313] = 561,
  [1314] = 559,
  [1315] = 946,
  [1316] = 974,
  [1317] = 973,
  [1318] = 968,
  [1319] = 954,
  [1320] = 904,
  [1321] = 962,
  [1322] = 959,
  [1323] = 547,
  [1324] = 976,
  [1325] = 940,
  [1326] = 877,
  [1327] = 873,
  [1328] = 984,
  [1329] = 854,
  [1330] = 874,
  [1331] = 547,
  [1332] = 935,
  [1333] = 936,
  [1334] = 550,
  [1335] = 986,
  [1336] = 866,
  [1337] = 559,
  [1338] = 987,
  [1339] = 989,
  [1340] = 990,
  [1341] = 561,
  [1342] = 563,
  [1343] = 991,
  [1344] = 976,
  [1345] = 977,
  [1346] = 979,
  [1347] = 938,
  [1348] = 564,
  [1349] = 565,
  [1350] = 1009,
  [1351] = 974,
  [1352] = 560,
  [1353] = 977,
  [1354] = 973,
  [1355] = 979,
  [1356] = 968,
  [1357] = 962,
  [1358] = 959,
  [1359] = 856,
  [1360] = 979,
  [1361] = 849,
  [1362] = 851,
  [1363] = 904,
  [1364] = 980,
  [1365] = 954,
  [1366] = 1001,
  [1367] = 977,
  [1368] = 976,
  [1369] = 999,
  [1370] = 865,
  [1371] = 998,
  [1372] = 569,
  [1373] = 867,
  [1374] = 997,
  [1375] = 846,
  [1376] = 993,
  [1377] = 560,
  [1378] = 570,
  [1379] = 556,
  [1380] = 946,
  [1381] = 868,
  [1382] = 994,
  [1383] = 1162,
  [1384] = 556,
  [1385] = 1163,
  [1386] = 556,
  [1387] = 556,
  [1388] = 547,
  [1389] = 559,
  [1390] = 561,
  [1391] = 563,
  [1392] = 556,
  [1393] = 570,
  [1394] = 567,
  [1395] = 564,
  [1396] = 552,
  [1397] = 565,
  [1398] = 550,
  [1399] = 569,
  [1400] = 555,
  [1401] = 551,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 1403,
  [1405] = 567,
  [1406] = 1402,
  [1407] = 1162,
  [1408] = 551,
  [1409] = 1163,
  [1410] = 555,
  [1411] = 552,
  [1412] = 1403,
  [1413] = 1403,
  [1414] = 1402,
  [1415] = 1402,
  [1416] = 1402,
  [1417] = 1403,
  [1418] = 1403,
  [1419] = 1402,
  [1420] = 1403,
  [1421] = 1421,
  [1422] = 1403,
  [1423] = 556,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1402,
  [1427] = 1403,
  [1428] = 1428,
  [1429] = 1402,
  [1430] = 1430,
  [1431] = 569,
  [1432] = 1402,
  [1433] = 570,
  [1434] = 854,
  [1435] = 1435,
  [1436] = 555,
  [1437] = 1162,
  [1438] = 1435,
  [1439] = 567,
  [1440] = 570,
  [1441] = 555,
  [1442] = 551,
  [1443] = 552,
  [1444] = 1444,
  [1445] = 569,
  [1446] = 552,
  [1447] = 551,
  [1448] = 1435,
  [1449] = 849,
  [1450] = 1450,
  [1451] = 567,
  [1452] = 1428,
  [1453] = 867,
  [1454] = 868,
  [1455] = 1455,
  [1456] = 1456,
  [1457] = 551,
  [1458] = 555,
  [1459] = 1163,
  [1460] = 567,
  [1461] = 851,
  [1462] = 846,
  [1463] = 552,
  [1464] = 1435,
  [1465] = 1435,
  [1466] = 1421,
  [1467] = 556,
  [1468] = 1435,
  [1469] = 1162,
  [1470] = 1163,
  [1471] = 1435,
  [1472] = 865,
  [1473] = 1425,
  [1474] = 1435,
  [1475] = 1435,
  [1476] = 877,
  [1477] = 1435,
  [1478] = 1478,
  [1479] = 1163,
  [1480] = 856,
  [1481] = 1162,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1484,
  [1485] = 1484,
  [1486] = 1482,
  [1487] = 1482,
  [1488] = 1482,
  [1489] = 1489,
  [1490] = 1482,
  [1491] = 1484,
  [1492] = 1482,
  [1493] = 1444,
  [1494] = 1482,
  [1495] = 1482,
  [1496] = 1478,
  [1497] = 1430,
  [1498] = 1482,
  [1499] = 1499,
  [1500] = 1456,
  [1501] = 1455,
  [1502] = 1483,
  [1503] = 1503,
  [1504] = 1424,
  [1505] = 1482,
  [1506] = 1402,
  [1507] = 1403,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 1510,
  [1511] = 1511,
  [1512] = 1510,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 1511,
  [1516] = 1516,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1519,
  [1520] = 1518,
  [1521] = 1521,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1528,
  [1530] = 1528,
  [1531] = 1528,
  [1532] = 1528,
  [1533] = 1533,
  [1534] = 1528,
  [1535] = 1528,
  [1536] = 1528,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 1539,
  [1540] = 1538,
  [1541] = 1541,
  [1542] = 1542,
  [1543] = 1539,
  [1544] = 1539,
  [1545] = 1539,
  [1546] = 1538,
  [1547] = 1541,
  [1548] = 1538,
  [1549] = 1541,
  [1550] = 1550,
  [1551] = 1539,
  [1552] = 1552,
  [1553] = 1541,
  [1554] = 1538,
  [1555] = 1538,
  [1556] = 1538,
  [1557] = 1557,
  [1558] = 1541,
  [1559] = 1539,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1539,
  [1565] = 1538,
  [1566] = 1566,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 1541,
  [1571] = 1571,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1541,
  [1575] = 1539,
  [1576] = 1576,
  [1577] = 1541,
  [1578] = 1578,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1533,
  [1582] = 1527,
  [1583] = 1550,
  [1584] = 1578,
  [1585] = 1537,
  [1586] = 1580,
  [1587] = 1578,
  [1588] = 1578,
  [1589] = 1589,
  [1590] = 1590,
  [1591] = 1580,
  [1592] = 1527,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1562,
  [1596] = 1580,
  [1597] = 1578,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1578,
  [1601] = 1598,
  [1602] = 1602,
  [1603] = 1580,
  [1604] = 1537,
  [1605] = 1580,
  [1606] = 1576,
  [1607] = 1569,
  [1608] = 1608,
  [1609] = 1578,
  [1610] = 1580,
  [1611] = 1571,
  [1612] = 1578,
  [1613] = 1613,
  [1614] = 1580,
  [1615] = 1580,
  [1616] = 1566,
  [1617] = 1533,
  [1618] = 1578,
  [1619] = 1537,
  [1620] = 1527,
  [1621] = 1569,
  [1622] = 1562,
  [1623] = 1566,
  [1624] = 1624,
  [1625] = 1533,
  [1626] = 1576,
  [1627] = 1571,
  [1628] = 1576,
  [1629] = 1537,
  [1630] = 1527,
  [1631] = 1537,
  [1632] = 1576,
  [1633] = 1571,
  [1634] = 1533,
  [1635] = 1527,
  [1636] = 1566,
  [1637] = 1569,
  [1638] = 1566,
  [1639] = 1550,
  [1640] = 1562,
  [1641] = 1641,
  [1642] = 1550,
  [1643] = 1569,
  [1644] = 1550,
  [1645] = 1562,
  [1646] = 1598,
  [1647] = 1647,
  [1648] = 1571,
  [1649] = 1550,
  [1650] = 1598,
  [1651] = 1533,
  [1652] = 1652,
  [1653] = 1576,
  [1654] = 1566,
  [1655] = 1571,
  [1656] = 1569,
  [1657] = 1562,
  [1658] = 1569,
  [1659] = 1569,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1576,
  [1663] = 1661,
  [1664] = 1664,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1525,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1666,
  [1671] = 1527,
  [1672] = 1571,
  [1673] = 1525,
  [1674] = 1550,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1562,
  [1678] = 1562,
  [1679] = 1679,
  [1680] = 1522,
  [1681] = 1576,
  [1682] = 1675,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1675,
  [1686] = 1566,
  [1687] = 1675,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1666,
  [1692] = 1576,
  [1693] = 1675,
  [1694] = 1522,
  [1695] = 1695,
  [1696] = 1661,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1675,
  [1700] = 1675,
  [1701] = 1571,
  [1702] = 1675,
  [1703] = 1695,
  [1704] = 1668,
  [1705] = 1705,
  [1706] = 1593,
  [1707] = 1647,
  [1708] = 1550,
  [1709] = 1537,
  [1710] = 1527,
  [1711] = 1562,
  [1712] = 1533,
  [1713] = 1550,
  [1714] = 1684,
  [1715] = 1537,
  [1716] = 1566,
  [1717] = 1717,
  [1718] = 1533,
  [1719] = 1675,
  [1720] = 1566,
  [1721] = 1668,
  [1722] = 1569,
  [1723] = 1571,
  [1724] = 1675,
  [1725] = 1725,
  [1726] = 1726,
  [1727] = 1593,
  [1728] = 1525,
  [1729] = 1726,
  [1730] = 1730,
  [1731] = 1731,
  [1732] = 1732,
  [1733] = 1733,
  [1734] = 1730,
  [1735] = 1735,
  [1736] = 1736,
  [1737] = 1737,
  [1738] = 1738,
  [1739] = 1726,
  [1740] = 1730,
  [1741] = 1726,
  [1742] = 1737,
  [1743] = 1726,
  [1744] = 1522,
  [1745] = 1745,
  [1746] = 1745,
  [1747] = 1726,
  [1748] = 1748,
  [1749] = 1593,
  [1750] = 1513,
  [1751] = 1735,
  [1752] = 1737,
  [1753] = 1753,
  [1754] = 1698,
  [1755] = 1755,
  [1756] = 1726,
  [1757] = 1757,
  [1758] = 1745,
  [1759] = 1726,
  [1760] = 1760,
  [1761] = 1647,
  [1762] = 1735,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1766,
  [1767] = 1767,
  [1768] = 1624,
  [1769] = 1769,
  [1770] = 1770,
  [1771] = 1647,
  [1772] = 1772,
  [1773] = 1772,
  [1774] = 1774,
  [1775] = 1775,
  [1776] = 1424,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1765,
  [1780] = 1780,
  [1781] = 1683,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1785,
  [1786] = 1766,
  [1787] = 1780,
  [1788] = 1647,
  [1789] = 1774,
  [1790] = 1790,
  [1791] = 1791,
  [1792] = 1792,
  [1793] = 1790,
  [1794] = 1794,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1797,
  [1798] = 1770,
  [1799] = 1799,
  [1800] = 1772,
  [1801] = 1801,
  [1802] = 1792,
  [1803] = 1766,
  [1804] = 1804,
  [1805] = 1509,
  [1806] = 1806,
  [1807] = 1430,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1811,
  [1812] = 1764,
  [1813] = 1813,
  [1814] = 1814,
  [1815] = 1647,
  [1816] = 1795,
  [1817] = 1817,
  [1818] = 1796,
  [1819] = 1624,
  [1820] = 1820,
  [1821] = 1799,
  [1822] = 1808,
  [1823] = 1823,
  [1824] = 1780,
  [1825] = 1825,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1766,
  [1829] = 1829,
  [1830] = 1830,
  [1831] = 1831,
  [1832] = 1767,
  [1833] = 1833,
  [1834] = 1826,
  [1835] = 1799,
  [1836] = 1774,
  [1837] = 1624,
  [1838] = 1838,
  [1839] = 1810,
  [1840] = 1521,
  [1841] = 1770,
  [1842] = 1775,
  [1843] = 1784,
  [1844] = 1826,
  [1845] = 1845,
  [1846] = 1838,
  [1847] = 1847,
  [1848] = 1823,
  [1849] = 1764,
  [1850] = 1850,
  [1851] = 1851,
  [1852] = 1852,
  [1853] = 1838,
  [1854] = 1854,
  [1855] = 1855,
  [1856] = 1562,
  [1857] = 1857,
  [1858] = 1858,
  [1859] = 1550,
  [1860] = 1767,
  [1861] = 1861,
  [1862] = 1765,
  [1863] = 1863,
  [1864] = 1857,
  [1865] = 1455,
  [1866] = 1866,
  [1867] = 1861,
  [1868] = 1858,
  [1869] = 1869,
  [1870] = 1767,
  [1871] = 1871,
  [1872] = 1813,
  [1873] = 1784,
  [1874] = 1874,
  [1875] = 1875,
  [1876] = 1861,
  [1877] = 1478,
  [1878] = 1845,
  [1879] = 1801,
  [1880] = 1869,
  [1881] = 1881,
  [1882] = 1882,
  [1883] = 1883,
  [1884] = 1863,
  [1885] = 1808,
  [1886] = 1886,
  [1887] = 1857,
  [1888] = 1857,
  [1889] = 1889,
  [1890] = 1456,
  [1891] = 1783,
  [1892] = 1892,
  [1893] = 1796,
  [1894] = 1525,
  [1895] = 1804,
  [1896] = 1795,
  [1897] = 1795,
  [1898] = 1898,
  [1899] = 1698,
  [1900] = 1900,
  [1901] = 1898,
  [1902] = 1796,
  [1903] = 1566,
  [1904] = 1904,
  [1905] = 1569,
  [1906] = 1806,
  [1907] = 1571,
  [1908] = 1808,
  [1909] = 1909,
  [1910] = 1576,
  [1911] = 1898,
  [1912] = 1857,
  [1913] = 1784,
  [1914] = 1914,
  [1915] = 1810,
  [1916] = 1916,
  [1917] = 1838,
  [1918] = 1918,
  [1919] = 1522,
  [1920] = 1523,
  [1921] = 1898,
  [1922] = 1857,
  [1923] = 1923,
  [1924] = 1857,
  [1925] = 1857,
  [1926] = 1869,
  [1927] = 1863,
  [1928] = 1928,
  [1929] = 1929,
  [1930] = 1930,
  [1931] = 1931,
  [1932] = 1810,
  [1933] = 1933,
  [1934] = 1904,
  [1935] = 1765,
  [1936] = 1936,
  [1937] = 1937,
  [1938] = 1938,
  [1939] = 1444,
  [1940] = 1940,
  [1941] = 1857,
  [1942] = 1857,
  [1943] = 1943,
  [1944] = 1517,
  [1945] = 1945,
  [1946] = 1519,
  [1947] = 1947,
  [1948] = 1948,
  [1949] = 1949,
  [1950] = 1950,
  [1951] = 1951,
  [1952] = 1952,
  [1953] = 1953,
  [1954] = 1954,
  [1955] = 1955,
  [1956] = 1956,
  [1957] = 1957,
  [1958] = 1958,
  [1959] = 1959,
  [1960] = 1923,
  [1961] = 1961,
  [1962] = 1947,
  [1963] = 1855,
  [1964] = 1964,
  [1965] = 1965,
  [1966] = 1965,
  [1967] = 1858,
  [1968] = 1968,
  [1969] = 1969,
  [1970] = 1970,
  [1971] = 1916,
  [1972] = 1972,
  [1973] = 1845,
  [1974] = 1892,
  [1975] = 1526,
  [1976] = 1852,
  [1977] = 1977,
  [1978] = 1978,
  [1979] = 1979,
  [1980] = 1980,
  [1981] = 1909,
  [1982] = 1982,
  [1983] = 1801,
  [1984] = 1984,
  [1985] = 1985,
  [1986] = 1986,
  [1987] = 1986,
  [1988] = 1988,
  [1989] = 1989,
  [1990] = 1778,
  [1991] = 1991,
  [1992] = 1992,
  [1993] = 1993,
  [1994] = 1986,
  [1995] = 1995,
  [1996] = 1996,
  [1997] = 1997,
  [1998] = 1956,
  [1999] = 1999,
  [2000] = 2000,
  [2001] = 1943,
  [2002] = 2002,
  [2003] = 2003,
  [2004] = 2004,
  [2005] = 1813,
  [2006] = 2006,
  [2007] = 1831,
  [2008] = 1830,
  [2009] = 2009,
  [2010] = 1827,
  [2011] = 2011,
  [2012] = 2012,
  [2013] = 1984,
  [2014] = 1950,
  [2015] = 1783,
  [2016] = 2016,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 1794,
  [2020] = 1777,
  [2021] = 1829,
  [2022] = 1845,
  [2023] = 2023,
  [2024] = 1424,
  [2025] = 2025,
  [2026] = 1801,
  [2027] = 1430,
  [2028] = 1424,
  [2029] = 2017,
  [2030] = 2018,
  [2031] = 2031,
  [2032] = 2032,
  [2033] = 2033,
  [2034] = 2034,
  [2035] = 576,
  [2036] = 2036,
  [2037] = 2037,
  [2038] = 2009,
  [2039] = 2003,
  [2040] = 2002,
  [2041] = 2004,
  [2042] = 2042,
  [2043] = 1845,
  [2044] = 2044,
  [2045] = 1995,
  [2046] = 1992,
  [2047] = 2047,
  [2048] = 577,
  [2049] = 1986,
  [2050] = 1979,
  [2051] = 1806,
  [2052] = 2009,
  [2053] = 2003,
  [2054] = 2002,
  [2055] = 2055,
  [2056] = 1996,
  [2057] = 1992,
  [2058] = 2036,
  [2059] = 1992,
  [2060] = 1698,
  [2061] = 2061,
  [2062] = 2062,
  [2063] = 1444,
  [2064] = 2009,
  [2065] = 2065,
  [2066] = 2055,
  [2067] = 2061,
  [2068] = 2006,
  [2069] = 2069,
  [2070] = 2004,
  [2071] = 2003,
  [2072] = 2002,
  [2073] = 1996,
  [2074] = 2047,
  [2075] = 2044,
  [2076] = 2002,
  [2077] = 1995,
  [2078] = 1986,
  [2079] = 1992,
  [2080] = 1988,
  [2081] = 2032,
  [2082] = 1988,
  [2083] = 1833,
  [2084] = 1801,
  [2085] = 1992,
  [2086] = 1568,
  [2087] = 1563,
  [2088] = 1986,
  [2089] = 1995,
  [2090] = 2055,
  [2091] = 1996,
  [2092] = 2092,
  [2093] = 2061,
  [2094] = 584,
  [2095] = 2003,
  [2096] = 2062,
  [2097] = 2097,
  [2098] = 2002,
  [2099] = 2003,
  [2100] = 1424,
  [2101] = 2004,
  [2102] = 2102,
  [2103] = 2006,
  [2104] = 580,
  [2105] = 579,
  [2106] = 2009,
  [2107] = 2097,
  [2108] = 2108,
  [2109] = 2009,
  [2110] = 2110,
  [2111] = 2111,
  [2112] = 2112,
  [2113] = 2006,
  [2114] = 2047,
  [2115] = 2004,
  [2116] = 2044,
  [2117] = 2003,
  [2118] = 1985,
  [2119] = 2025,
  [2120] = 2002,
  [2121] = 2110,
  [2122] = 1996,
  [2123] = 1801,
  [2124] = 1995,
  [2125] = 2125,
  [2126] = 1986,
  [2127] = 2016,
  [2128] = 1992,
  [2129] = 1845,
  [2130] = 1988,
  [2131] = 2131,
  [2132] = 1525,
  [2133] = 2016,
  [2134] = 2134,
  [2135] = 2112,
  [2136] = 2055,
  [2137] = 2137,
  [2138] = 1522,
  [2139] = 2139,
  [2140] = 2140,
  [2141] = 2141,
  [2142] = 2061,
  [2143] = 1567,
  [2144] = 2061,
  [2145] = 1560,
  [2146] = 2146,
  [2147] = 2108,
  [2148] = 2009,
  [2149] = 2055,
  [2150] = 2006,
  [2151] = 2004,
  [2152] = 860,
  [2153] = 2153,
  [2154] = 2003,
  [2155] = 2002,
  [2156] = 2156,
  [2157] = 1996,
  [2158] = 1995,
  [2159] = 1986,
  [2160] = 1988,
  [2161] = 1996,
  [2162] = 1992,
  [2163] = 2111,
  [2164] = 2018,
  [2165] = 1992,
  [2166] = 2025,
  [2167] = 1988,
  [2168] = 1999,
  [2169] = 1995,
  [2170] = 2055,
  [2171] = 1996,
  [2172] = 1572,
  [2173] = 2061,
  [2174] = 1524,
  [2175] = 1988,
  [2176] = 858,
  [2177] = 2002,
  [2178] = 2003,
  [2179] = 2031,
  [2180] = 2004,
  [2181] = 2055,
  [2182] = 2006,
  [2183] = 2012,
  [2184] = 2032,
  [2185] = 2009,
  [2186] = 2009,
  [2187] = 2006,
  [2188] = 2004,
  [2189] = 2003,
  [2190] = 2002,
  [2191] = 1995,
  [2192] = 2061,
  [2193] = 1991,
  [2194] = 1999,
  [2195] = 2025,
  [2196] = 2006,
  [2197] = 2017,
  [2198] = 1993,
  [2199] = 2061,
  [2200] = 2200,
  [2201] = 2000,
  [2202] = 1992,
  [2203] = 1996,
  [2204] = 2055,
  [2205] = 2205,
  [2206] = 1988,
  [2207] = 2207,
  [2208] = 2208,
  [2209] = 2209,
  [2210] = 2210,
  [2211] = 2211,
  [2212] = 2212,
  [2213] = 2213,
  [2214] = 2208,
  [2215] = 2215,
  [2216] = 2216,
  [2217] = 2217,
  [2218] = 2218,
  [2219] = 1455,
  [2220] = 2141,
  [2221] = 2221,
  [2222] = 2140,
  [2223] = 1892,
  [2224] = 2224,
  [2225] = 2225,
  [2226] = 580,
  [2227] = 1579,
  [2228] = 1478,
  [2229] = 2229,
  [2230] = 2211,
  [2231] = 577,
  [2232] = 2232,
  [2233] = 2233,
  [2234] = 2234,
  [2235] = 2235,
  [2236] = 2236,
  [2237] = 2237,
  [2238] = 2218,
  [2239] = 2216,
  [2240] = 2240,
  [2241] = 2208,
  [2242] = 2242,
  [2243] = 2213,
  [2244] = 2244,
  [2245] = 1456,
  [2246] = 2246,
  [2247] = 579,
  [2248] = 2248,
  [2249] = 2249,
  [2250] = 2216,
  [2251] = 2235,
  [2252] = 1599,
  [2253] = 1455,
  [2254] = 2254,
  [2255] = 2255,
  [2256] = 2256,
  [2257] = 2257,
  [2258] = 2258,
  [2259] = 2259,
  [2260] = 2260,
  [2261] = 2208,
  [2262] = 2262,
  [2263] = 2263,
  [2264] = 2208,
  [2265] = 2265,
  [2266] = 2266,
  [2267] = 584,
  [2268] = 2268,
  [2269] = 671,
  [2270] = 2270,
  [2271] = 2271,
  [2272] = 2249,
  [2273] = 2273,
  [2274] = 2274,
  [2275] = 576,
  [2276] = 2276,
  [2277] = 2237,
  [2278] = 1444,
  [2279] = 663,
  [2280] = 2280,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2212,
  [2285] = 2213,
  [2286] = 1914,
  [2287] = 2287,
  [2288] = 2235,
  [2289] = 1589,
  [2290] = 657,
  [2291] = 2291,
  [2292] = 2292,
  [2293] = 2293,
  [2294] = 1456,
  [2295] = 2254,
  [2296] = 2208,
  [2297] = 2297,
  [2298] = 2146,
  [2299] = 2299,
  [2300] = 2300,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2304,
  [2305] = 2305,
  [2306] = 2218,
  [2307] = 1914,
  [2308] = 2299,
  [2309] = 2309,
  [2310] = 2310,
  [2311] = 2311,
  [2312] = 2312,
  [2313] = 2313,
  [2314] = 2314,
  [2315] = 670,
  [2316] = 2303,
  [2317] = 2317,
  [2318] = 1579,
  [2319] = 2319,
  [2320] = 2320,
  [2321] = 1914,
  [2322] = 1478,
  [2323] = 2323,
  [2324] = 2324,
  [2325] = 2325,
  [2326] = 2326,
  [2327] = 2326,
  [2328] = 2328,
  [2329] = 2329,
  [2330] = 2329,
  [2331] = 2331,
  [2332] = 2332,
  [2333] = 2333,
  [2334] = 2326,
  [2335] = 2335,
  [2336] = 2336,
  [2337] = 2337,
  [2338] = 2338,
  [2339] = 2339,
  [2340] = 2340,
  [2341] = 2339,
  [2342] = 2342,
  [2343] = 2343,
  [2344] = 2344,
  [2345] = 2328,
  [2346] = 2346,
  [2347] = 2331,
  [2348] = 2326,
  [2349] = 2349,
  [2350] = 2332,
  [2351] = 2351,
  [2352] = 2352,
  [2353] = 2344,
  [2354] = 2354,
  [2355] = 2355,
  [2356] = 2333,
  [2357] = 2335,
  [2358] = 2358,
  [2359] = 2331,
  [2360] = 2360,
  [2361] = 2335,
  [2362] = 2362,
  [2363] = 2336,
  [2364] = 2364,
  [2365] = 2337,
  [2366] = 2340,
  [2367] = 2367,
  [2368] = 2339,
  [2369] = 579,
  [2370] = 2358,
  [2371] = 2344,
  [2372] = 2349,
  [2373] = 2373,
  [2374] = 2346,
  [2375] = 2375,
  [2376] = 2355,
  [2377] = 2326,
  [2378] = 2349,
  [2379] = 2329,
  [2380] = 2328,
  [2381] = 2331,
  [2382] = 2344,
  [2383] = 2332,
  [2384] = 2333,
  [2385] = 2385,
  [2386] = 2326,
  [2387] = 2335,
  [2388] = 2349,
  [2389] = 2336,
  [2390] = 2337,
  [2391] = 2391,
  [2392] = 2392,
  [2393] = 2340,
  [2394] = 2339,
  [2395] = 2339,
  [2396] = 2355,
  [2397] = 2344,
  [2398] = 2328,
  [2399] = 2328,
  [2400] = 2344,
  [2401] = 2340,
  [2402] = 2349,
  [2403] = 2329,
  [2404] = 2339,
  [2405] = 2405,
  [2406] = 2340,
  [2407] = 2385,
  [2408] = 2346,
  [2409] = 2336,
  [2410] = 2337,
  [2411] = 2411,
  [2412] = 2337,
  [2413] = 2336,
  [2414] = 2414,
  [2415] = 2415,
  [2416] = 2335,
  [2417] = 2333,
  [2418] = 2336,
  [2419] = 2335,
  [2420] = 2420,
  [2421] = 2421,
  [2422] = 2332,
  [2423] = 2344,
  [2424] = 576,
  [2425] = 2331,
  [2426] = 2333,
  [2427] = 2326,
  [2428] = 2329,
  [2429] = 2335,
  [2430] = 2336,
  [2431] = 2337,
  [2432] = 2432,
  [2433] = 2332,
  [2434] = 2434,
  [2435] = 2332,
  [2436] = 2349,
  [2437] = 2333,
  [2438] = 2385,
  [2439] = 2439,
  [2440] = 2440,
  [2441] = 2331,
  [2442] = 2325,
  [2443] = 2335,
  [2444] = 2336,
  [2445] = 2329,
  [2446] = 2446,
  [2447] = 2447,
  [2448] = 2326,
  [2449] = 2337,
  [2450] = 2326,
  [2451] = 2335,
  [2452] = 2336,
  [2453] = 2337,
  [2454] = 2340,
  [2455] = 2337,
  [2456] = 2333,
  [2457] = 2346,
  [2458] = 2458,
  [2459] = 2459,
  [2460] = 2460,
  [2461] = 2346,
  [2462] = 2462,
  [2463] = 2358,
  [2464] = 2340,
  [2465] = 2439,
  [2466] = 2466,
  [2467] = 584,
  [2468] = 2339,
  [2469] = 2469,
  [2470] = 2439,
  [2471] = 2471,
  [2472] = 2472,
  [2473] = 2332,
  [2474] = 2325,
  [2475] = 2475,
  [2476] = 2476,
  [2477] = 2477,
  [2478] = 2478,
  [2479] = 2331,
  [2480] = 2328,
  [2481] = 2481,
  [2482] = 2482,
  [2483] = 577,
  [2484] = 2392,
  [2485] = 2362,
  [2486] = 2325,
  [2487] = 2487,
  [2488] = 2488,
  [2489] = 2349,
  [2490] = 2476,
  [2491] = 2478,
  [2492] = 2492,
  [2493] = 2493,
  [2494] = 2355,
  [2495] = 2328,
  [2496] = 2496,
  [2497] = 2497,
  [2498] = 2375,
  [2499] = 580,
  [2500] = 2344,
  [2501] = 2488,
  [2502] = 2362,
  [2503] = 2503,
  [2504] = 2504,
  [2505] = 2339,
  [2506] = 2392,
  [2507] = 2507,
  [2508] = 2340,
  [2509] = 2487,
  [2510] = 2510,
  [2511] = 2511,
  [2512] = 2476,
  [2513] = 2337,
  [2514] = 2336,
  [2515] = 2335,
  [2516] = 2516,
  [2517] = 2517,
  [2518] = 2518,
  [2519] = 2519,
  [2520] = 2520,
  [2521] = 2333,
  [2522] = 2332,
  [2523] = 2481,
  [2524] = 2524,
  [2525] = 2358,
  [2526] = 2526,
  [2527] = 2331,
  [2528] = 2528,
  [2529] = 2329,
  [2530] = 2530,
  [2531] = 2531,
  [2532] = 2326,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 2535,
  [2536] = 2325,
  [2537] = 2535,
  [2538] = 2520,
  [2539] = 2539,
  [2540] = 2329,
  [2541] = 2541,
  [2542] = 2542,
  [2543] = 2385,
  [2544] = 2349,
  [2545] = 2545,
  [2546] = 2346,
  [2547] = 2487,
  [2548] = 2355,
  [2549] = 2549,
  [2550] = 2328,
  [2551] = 2551,
  [2552] = 2482,
  [2553] = 2460,
  [2554] = 2460,
};

static inline bool sym_escape_sequence_character_set_1(int32_t c) {
  return (c < 'f'
    ? (c < '\''
      ? (c < '"'
        ? c == '\n'
        : c <= '"')
      : (c <= '\'' || (c < 'a'
        ? c == '\\'
        : c <= 'b')))
    : (c <= 'f' || (c < 't'
      ? (c < 'r'
        ? c == 'n'
        : c <= 'r')
      : (c <= 't' || c == 'v'))));
}

static inline bool sym_python_identifier_character_set_1(int32_t c) {
  return (c < 43520
    ? (c < 4206
      ? (c < 2738
        ? (c < 2042
          ? (c < 1162
            ? (c < 880
              ? (c < 248
                ? (c < 186
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))
                : (c <= 705 || (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || c == 750))))
              : (c <= 884 || (c < 904
                ? (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || c == 902))
                : (c <= 906 || (c < 931
                  ? (c < 910
                    ? c == 908
                    : c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))))))
            : (c <= 1327 || (c < 1765
              ? (c < 1519
                ? (c < 1376
                  ? (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)
                  : (c <= 1416 || (c >= 1488 && c <= 1514)))
                : (c <= 1522 || (c < 1649
                  ? (c < 1646
                    ? (c >= 1568 && c <= 1610)
                    : c <= 1647)
                  : (c <= 1747 || c == 1749))))
              : (c <= 1766 || (c < 1810
                ? (c < 1791
                  ? (c < 1786
                    ? (c >= 1774 && c <= 1775)
                    : c <= 1788)
                  : (c <= 1791 || c == 1808))
                : (c <= 1839 || (c < 1994
                  ? (c < 1969
                    ? (c >= 1869 && c <= 1957)
                    : c <= 1969)
                  : (c <= 2026 || (c >= 2036 && c <= 2037)))))))))
          : (c <= 2042 || (c < 2493
            ? (c < 2365
              ? (c < 2144
                ? (c < 2084
                  ? (c < 2074
                    ? (c >= 2048 && c <= 2069)
                    : c <= 2074)
                  : (c <= 2084 || (c < 2112
                    ? c == 2088
                    : c <= 2136)))
                : (c <= 2154 || (c < 2208
                  ? (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)
                  : (c <= 2249 || (c >= 2308 && c <= 2361)))))
              : (c <= 2365 || (c < 2447
                ? (c < 2417
                  ? (c < 2392
                    ? c == 2384
                    : c <= 2401)
                  : (c <= 2432 || (c >= 2437 && c <= 2444)))
                : (c <= 2448 || (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))))))
            : (c <= 2493 || (c < 2610
              ? (c < 2556
                ? (c < 2527
                  ? (c < 2524
                    ? c == 2510
                    : c <= 2525)
                  : (c <= 2529 || (c >= 2544 && c <= 2545)))
                : (c <= 2556 || (c < 2579
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)
                  : (c <= 2600 || (c >= 2602 && c <= 2608)))))
              : (c <= 2611 || (c < 2674
                ? (c < 2649
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2652 || c == 2654))
                : (c <= 2676 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))))))))))
        : (c <= 2739 || (c < 3261
          ? (c < 2972
            ? (c < 2869
              ? (c < 2821
                ? (c < 2768
                  ? (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)
                  : (c <= 2768 || (c < 2809
                    ? (c >= 2784 && c <= 2785)
                    : c <= 2809)))
                : (c <= 2828 || (c < 2858
                  ? (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)
                  : (c <= 2864 || (c >= 2866 && c <= 2867)))))
              : (c <= 2873 || (c < 2947
                ? (c < 2911
                  ? (c < 2908
                    ? c == 2877
                    : c <= 2909)
                  : (c <= 2913 || c == 2929))
                : (c <= 2947 || (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c >= 2969 && c <= 2970)))))))
            : (c <= 2972 || (c < 3133
              ? (c < 3024
                ? (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))
                : (c <= 3024 || (c < 3090
                  ? (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))))
              : (c <= 3133 || (c < 3205
                ? (c < 3168
                  ? (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)
                  : (c <= 3169 || c == 3200))
                : (c <= 3212 || (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))))))))
          : (c <= 3261 || (c < 3716
            ? (c < 3450
              ? (c < 3346
                ? (c < 3313
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3297)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3332 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3386 || (c < 3412
                  ? (c < 3406
                    ? c == 3389
                    : c <= 3406)
                  : (c <= 3414 || (c >= 3423 && c <= 3425)))))
              : (c <= 3455 || (c < 3520
                ? (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || c == 3517))
                : (c <= 3526 || (c < 3648
                  ? (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))))))
            : (c <= 3716 || (c < 3840
              ? (c < 3762
                ? (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c >= 3751 && c <= 3760)))
                : (c <= 3762 || (c < 3782
                  ? (c < 3776
                    ? c == 3773
                    : c <= 3780)
                  : (c <= 3782 || (c >= 3804 && c <= 3807)))))
              : (c <= 3840 || (c < 4159
                ? (c < 3976
                  ? (c < 3913
                    ? (c >= 3904 && c <= 3911)
                    : c <= 3948)
                  : (c <= 3980 || (c >= 4096 && c <= 4138)))
                : (c <= 4159 || (c < 4193
                  ? (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))))))))))))
      : (c <= 4208 || (c < 8150
        ? (c < 6314
          ? (c < 4882
            ? (c < 4698
              ? (c < 4304
                ? (c < 4256
                  ? (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)
                  : (c <= 4293 || (c < 4301
                    ? c == 4295
                    : c <= 4301)))
                : (c <= 4346 || (c < 4688
                  ? (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)
                  : (c <= 4694 || c == 4696))))
              : (c <= 4701 || (c < 4792
                ? (c < 4752
                  ? (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)
                  : (c <= 4784 || (c >= 4786 && c <= 4789)))
                : (c <= 4798 || (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c >= 4824 && c <= 4880)))))))
            : (c <= 4885 || (c < 5888
              ? (c < 5121
                ? (c < 5024
                  ? (c < 4992
                    ? (c >= 4888 && c <= 4954)
                    : c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5792
                  ? (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)
                  : (c <= 5866 || (c >= 5870 && c <= 5880)))))
              : (c <= 5905 || (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5937)
                    : c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))
                : (c <= 6067 || (c < 6176
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6108)
                  : (c <= 6264 || (c >= 6272 && c <= 6312)))))))))
          : (c <= 6314 || (c < 7401
            ? (c < 6981
              ? (c < 6576
                ? (c < 6480
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))
                : (c <= 6601 || (c < 6823
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6678)
                    : c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))))
              : (c <= 6988 || (c < 7245
                ? (c < 7098
                  ? (c < 7086
                    ? (c >= 7043 && c <= 7072)
                    : c <= 7087)
                  : (c <= 7141 || (c >= 7168 && c <= 7203)))
                : (c <= 7247 || (c < 7312
                  ? (c < 7296
                    ? (c >= 7258 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c >= 7357 && c <= 7359)))))))
            : (c <= 7404 || (c < 8025
              ? (c < 7680
                ? (c < 7418
                  ? (c < 7413
                    ? (c >= 7406 && c <= 7411)
                    : c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))))
              : (c <= 8025 || (c < 8118
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c >= 8064 && c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c >= 8144 && c <= 8147)))))))))))
        : (c <= 8155 || (c < 12353
          ? (c < 11499
            ? (c < 8472
              ? (c < 8336
                ? (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8458
                  ? (c < 8455
                    ? c == 8450
                    : c <= 8455)
                  : (c <= 8467 || c == 8469))))
              : (c <= 8477 || (c < 8508
                ? (c < 8488
                  ? (c < 8486
                    ? c == 8484
                    : c <= 8486)
                  : (c <= 8488 || (c >= 8490 && c <= 8505)))
                : (c <= 8511 || (c < 8544
                  ? (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8584 || (c >= 11264 && c <= 11492)))))))
            : (c <= 11502 || (c < 11696
              ? (c < 11568
                ? (c < 11559
                  ? (c < 11520
                    ? (c >= 11506 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || c == 11565))
                : (c <= 11623 || (c < 11680
                  ? (c < 11648
                    ? c == 11631
                    : c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))))
              : (c <= 11702 || (c < 11736
                ? (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c >= 11728 && c <= 11734)))
                : (c <= 11742 || (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12329)
                  : (c <= 12341 || (c >= 12344 && c <= 12348)))))))))
          : (c <= 12438 || (c < 42960
            ? (c < 42192
              ? (c < 12593
                ? (c < 12540
                  ? (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)
                  : (c <= 12543 || (c >= 12549 && c <= 12591)))
                : (c <= 12686 || (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c >= 19968 && c <= 42124)))))
              : (c <= 42237 || (c < 42623
                ? (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42954)))))))
            : (c <= 42961 || (c < 43259
              ? (c < 43015
                ? (c < 42994
                  ? (c < 42965
                    ? c == 42963
                    : c <= 42969)
                  : (c <= 43009 || (c >= 43011 && c <= 43013)))
                : (c <= 43018 || (c < 43138
                  ? (c < 43072
                    ? (c >= 43020 && c <= 43042)
                    : c <= 43123)
                  : (c <= 43187 || (c >= 43250 && c <= 43255)))))
              : (c <= 43259 || (c < 43396
                ? (c < 43312
                  ? (c < 43274
                    ? (c >= 43261 && c <= 43262)
                    : c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43494
                  ? (c < 43488
                    ? c == 43471
                    : c <= 43492)
                  : (c <= 43503 || (c >= 43514 && c <= 43518)))))))))))))))
    : (c <= 43560 || (c < 70751
      ? (c < 66964
        ? (c < 65008
          ? (c < 43888
            ? (c < 43739
              ? (c < 43697
                ? (c < 43616
                  ? (c < 43588
                    ? (c >= 43584 && c <= 43586)
                    : c <= 43595)
                  : (c <= 43638 || (c < 43646
                    ? c == 43642
                    : c <= 43695)))
                : (c <= 43697 || (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))))
              : (c <= 43741 || (c < 43793
                ? (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))
                : (c <= 43798 || (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))))))
            : (c <= 44002 || (c < 64298
              ? (c < 64112
                ? (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))
                : (c <= 64217 || (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))))
              : (c <= 64310 || (c < 64326
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))
                : (c <= 64433 || (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))))))))
          : (c <= 65017 || (c < 65616
            ? (c < 65440
              ? (c < 65149
                ? (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65437)))))
              : (c <= 65470 || (c < 65536
                ? (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c >= 65498 && c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))))))
            : (c <= 65629 || (c < 66504
              ? (c < 66304
                ? (c < 66176
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66204 || (c >= 66208 && c <= 66256)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66421)
                  : (c <= 66461 || (c >= 66464 && c <= 66499)))))
              : (c <= 66511 || (c < 66816
                ? (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c >= 66776 && c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))))))))))
        : (c <= 66965 || (c < 69248
          ? (c < 67840
            ? (c < 67584
              ? (c < 67392
                ? (c < 66995
                  ? (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)
                  : (c <= 67001 || (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)))
                : (c <= 67413 || (c < 67463
                  ? (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)
                  : (c <= 67504 || (c >= 67506 && c <= 67514)))))
              : (c <= 67589 || (c < 67647
                ? (c < 67639
                  ? (c < 67594
                    ? c == 67592
                    : c <= 67637)
                  : (c <= 67640 || c == 67644))
                : (c <= 67669 || (c < 67808
                  ? (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)
                  : (c <= 67826 || (c >= 67828 && c <= 67829)))))))
            : (c <= 67861 || (c < 68288
              ? (c < 68112
                ? (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || c == 68096))
                : (c <= 68115 || (c < 68192
                  ? (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)
                  : (c <= 68220 || (c >= 68224 && c <= 68252)))))
              : (c <= 68295 || (c < 68480
                ? (c < 68416
                  ? (c < 68352
                    ? (c >= 68297 && c <= 68324)
                    : c <= 68405)
                  : (c <= 68437 || (c >= 68448 && c <= 68466)))
                : (c <= 68497 || (c < 68800
                  ? (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)
                  : (c <= 68850 || (c >= 68864 && c <= 68899)))))))))
          : (c <= 69289 || (c < 70108
            ? (c < 69763
              ? (c < 69552
                ? (c < 69415
                  ? (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)
                  : (c <= 69415 || (c < 69488
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69505)))
                : (c <= 69572 || (c < 69745
                  ? (c < 69635
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69687)
                  : (c <= 69746 || c == 69749))))
              : (c <= 69807 || (c < 69968
                ? (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))
                : (c <= 70002 || (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))))))
            : (c <= 70108 || (c < 70415
              ? (c < 70282
                ? (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))
                : (c <= 70285 || (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))))
              : (c <= 70416 || (c < 70461
                ? (c < 70450
                  ? (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)
                  : (c <= 70451 || (c >= 70453 && c <= 70457)))
                : (c <= 70461 || (c < 70656
                  ? (c < 70493
                    ? c == 70480
                    : c <= 70497)
                  : (c <= 70708 || (c >= 70727 && c <= 70730)))))))))))))
      : (c <= 70753 || (c < 119966
        ? (c < 73063
          ? (c < 72096
            ? (c < 71488
              ? (c < 71168
                ? (c < 70855
                  ? (c < 70852
                    ? (c >= 70784 && c <= 70831)
                    : c <= 70853)
                  : (c <= 70855 || (c < 71128
                    ? (c >= 71040 && c <= 71086)
                    : c <= 71131)))
                : (c <= 71215 || (c < 71352
                  ? (c < 71296
                    ? c == 71236
                    : c <= 71338)
                  : (c <= 71352 || (c >= 71424 && c <= 71450)))))
              : (c <= 71494 || (c < 71948
                ? (c < 71935
                  ? (c < 71840
                    ? (c >= 71680 && c <= 71723)
                    : c <= 71903)
                  : (c <= 71942 || c == 71945))
                : (c <= 71955 || (c < 71999
                  ? (c < 71960
                    ? (c >= 71957 && c <= 71958)
                    : c <= 71983)
                  : (c <= 71999 || c == 72001))))))
            : (c <= 72103 || (c < 72368
              ? (c < 72203
                ? (c < 72163
                  ? (c < 72161
                    ? (c >= 72106 && c <= 72144)
                    : c <= 72161)
                  : (c <= 72163 || c == 72192))
                : (c <= 72242 || (c < 72284
                  ? (c < 72272
                    ? c == 72250
                    : c <= 72272)
                  : (c <= 72329 || c == 72349))))
              : (c <= 72440 || (c < 72960
                ? (c < 72768
                  ? (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72750)
                  : (c <= 72768 || (c >= 72818 && c <= 72847)))
                : (c <= 72966 || (c < 73030
                  ? (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73008)
                  : (c <= 73030 || (c >= 73056 && c <= 73061)))))))))
          : (c <= 73064 || (c < 94032
            ? (c < 92160
              ? (c < 74752
                ? (c < 73440
                  ? (c < 73112
                    ? (c >= 73066 && c <= 73097)
                    : c <= 73112)
                  : (c <= 73458 || (c < 73728
                    ? c == 73648
                    : c <= 74649)))
                : (c <= 74862 || (c < 77824
                  ? (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)
                  : (c <= 78894 || (c >= 82944 && c <= 83526)))))
              : (c <= 92728 || (c < 92992
                ? (c < 92880
                  ? (c < 92784
                    ? (c >= 92736 && c <= 92766)
                    : c <= 92862)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))
                : (c <= 92995 || (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))))))
            : (c <= 94032 || (c < 110592
              ? (c < 100352
                ? (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))
                : (c <= 101589 || (c < 110581
                  ? (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)
                  : (c <= 110587 || (c >= 110589 && c <= 110590)))))
              : (c <= 110882 || (c < 113776
                ? (c < 110960
                  ? (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)
                  : (c <= 111355 || (c >= 113664 && c <= 113770)))
                : (c <= 113788 || (c < 119808
                  ? (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)
                  : (c <= 119892 || (c >= 119894 && c <= 119964)))))))))))
        : (c <= 119967 || (c < 126464
          ? (c < 120598
            ? (c < 120094
              ? (c < 119997
                ? (c < 119977
                  ? (c < 119973
                    ? c == 119970
                    : c <= 119974)
                  : (c <= 119980 || (c < 119995
                    ? (c >= 119982 && c <= 119993)
                    : c <= 119995)))
                : (c <= 120003 || (c < 120077
                  ? (c < 120071
                    ? (c >= 120005 && c <= 120069)
                    : c <= 120074)
                  : (c <= 120084 || (c >= 120086 && c <= 120092)))))
              : (c <= 120121 || (c < 120146
                ? (c < 120134
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)
                  : (c <= 120134 || (c >= 120138 && c <= 120144)))
                : (c <= 120485 || (c < 120540
                  ? (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)
                  : (c <= 120570 || (c >= 120572 && c <= 120596)))))))
            : (c <= 120628 || (c < 123214
              ? (c < 120746
                ? (c < 120688
                  ? (c < 120656
                    ? (c >= 120630 && c <= 120654)
                    : c <= 120686)
                  : (c <= 120712 || (c >= 120714 && c <= 120744)))
                : (c <= 120770 || (c < 123136
                  ? (c < 122624
                    ? (c >= 120772 && c <= 120779)
                    : c <= 122654)
                  : (c <= 123180 || (c >= 123191 && c <= 123197)))))
              : (c <= 123214 || (c < 124909
                ? (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123565)
                    : c <= 123627)
                  : (c <= 124902 || (c >= 124904 && c <= 124907)))
                : (c <= 124910 || (c < 125184
                  ? (c < 124928
                    ? (c >= 124912 && c <= 124926)
                    : c <= 125124)
                  : (c <= 125251 || c == 125259))))))))
          : (c <= 126467 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126500
                  ? (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)
                  : (c <= 126500 || c == 126503))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_python_identifier_character_set_2(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 'b'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1649
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_python_identifier_character_set_3(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1649
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_python_identifier_character_set_4(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'a'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_python_identifier_character_set_5(int32_t c) {
  return (c < 43739
    ? (c < 3804
      ? (c < 2768
        ? (c < 2160
          ? (c < 1369
            ? (c < 768
              ? (c < 216
                ? (c < 183
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 183 || (c < 192
                    ? c == 186
                    : c <= 214)))
                : (c <= 246 || (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))))
              : (c <= 884 || (c < 910
                ? (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)))
                : (c <= 929 || (c < 1155
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1159 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))))))
            : (c <= 1369 || (c < 1749
              ? (c < 1479
                ? (c < 1471
                  ? (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)
                  : (c <= 1471 || (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)))
                : (c <= 1479 || (c < 1552
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))))
              : (c <= 1756 || (c < 1984
                ? (c < 1791
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)))
                : (c <= 2037 || (c < 2048
                  ? (c < 2045
                    ? c == 2042
                    : c <= 2045)
                  : (c <= 2093 || (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)))))))))
          : (c <= 2183 || (c < 2579
            ? (c < 2492
              ? (c < 2437
                ? (c < 2275
                  ? (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)
                  : (c <= 2403 || (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)))
                : (c <= 2444 || (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))))
              : (c <= 2500 || (c < 2534
                ? (c < 2519
                  ? (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)
                  : (c <= 2519 || (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)))
                : (c <= 2545 || (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))))))
            : (c <= 2600 || (c < 2662
              ? (c < 2622
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))
                : (c <= 2626 || (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))))
              : (c <= 2677 || (c < 2738
                ? (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))
                : (c <= 2739 || (c < 2759
                  ? (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)
                  : (c <= 2761 || (c >= 2763 && c <= 2765)))))))))))
        : (c <= 2768 || (c < 3205
          ? (c < 2972
            ? (c < 2887
              ? (c < 2831
                ? (c < 2809
                  ? (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)
                  : (c <= 2815 || (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)))
                : (c <= 2832 || (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))))
              : (c <= 2888 || (c < 2929
                ? (c < 2908
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)
                  : (c <= 2909 || (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)))
                : (c <= 2929 || (c < 2958
                  ? (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)
                  : (c <= 2960 || (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)))))))
            : (c <= 2972 || (c < 3086
              ? (c < 3014
                ? (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)))
                : (c <= 3016 || (c < 3031
                  ? (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)
                  : (c <= 3031 || (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)))))
              : (c <= 3088 || (c < 3157
                ? (c < 3132
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3140 || (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)))
                : (c <= 3158 || (c < 3168
                  ? (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)
                  : (c <= 3171 || (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)))))))))
          : (c <= 3212 || (c < 3482
            ? (c < 3313
              ? (c < 3270
                ? (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)))
                : (c <= 3272 || (c < 3293
                  ? (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)
                  : (c <= 3294 || (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)))))
              : (c <= 3314 || (c < 3412
                ? (c < 3346
                  ? (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)
                  : (c <= 3396 || (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)))
                : (c <= 3415 || (c < 3450
                  ? (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)
                  : (c <= 3455 || (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)))))))
            : (c <= 3505 || (c < 3664
              ? (c < 3542
                ? (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c < 3535
                    ? c == 3530
                    : c <= 3540)))
                : (c <= 3542 || (c < 3570
                  ? (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)
                  : (c <= 3571 || (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)))))
              : (c <= 3673 || (c < 3751
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)))
                : (c <= 3773 || (c < 3784
                  ? (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)
                  : (c <= 3789 || (c >= 3792 && c <= 3801)))))))))))))
      : (c <= 3807 || (c < 8029
        ? (c < 5984
          ? (c < 4704
            ? (c < 4038
              ? (c < 3897
                ? (c < 3872
                  ? (c < 3864
                    ? c == 3840
                    : c <= 3865)
                  : (c <= 3881 || (c < 3895
                    ? c == 3893
                    : c <= 3895)))
                : (c <= 3897 || (c < 3953
                  ? (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)
                  : (c <= 3972 || (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)))))
              : (c <= 4038 || (c < 4304
                ? (c < 4256
                  ? (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)
                  : (c <= 4293 || (c < 4301
                    ? c == 4295
                    : c <= 4301)))
                : (c <= 4346 || (c < 4688
                  ? (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)
                  : (c <= 4694 || (c < 4698
                    ? c == 4696
                    : c <= 4701)))))))
            : (c <= 4744 || (c < 4969
              ? (c < 4802
                ? (c < 4786
                  ? (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)
                  : (c <= 4789 || (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)))
                : (c <= 4805 || (c < 4882
                  ? (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)
                  : (c <= 4885 || (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)))))
              : (c <= 4977 || (c < 5761
                ? (c < 5112
                  ? (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)
                  : (c <= 5117 || (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)))
                : (c <= 5786 || (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5909 || (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)))))))))
          : (c <= 5996 || (c < 6800
            ? (c < 6400
              ? (c < 6112
                ? (c < 6016
                  ? (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)
                  : (c <= 6099 || (c < 6108
                    ? c == 6103
                    : c <= 6109)))
                : (c <= 6121 || (c < 6176
                  ? (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)
                  : (c <= 6264 || (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)))))
              : (c <= 6430 || (c < 6576
                ? (c < 6470
                  ? (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))
                : (c <= 6601 || (c < 6688
                  ? (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)
                  : (c <= 6750 || (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)))))))
            : (c <= 6809 || (c < 7312
              ? (c < 7019
                ? (c < 6847
                  ? (c < 6832
                    ? c == 6823
                    : c <= 6845)
                  : (c <= 6862 || (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)))
                : (c <= 7027 || (c < 7232
                  ? (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)
                  : (c <= 7241 || (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)))))
              : (c <= 7354 || (c < 7968
                ? (c < 7380
                  ? (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)
                  : (c <= 7418 || (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)))
                : (c <= 8005 || (c < 8025
                  ? (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)
                  : (c <= 8025 || c == 8027))))))))))
        : (c <= 8029 || (c < 11736
          ? (c < 8472
            ? (c < 8255
              ? (c < 8134
                ? (c < 8118
                  ? (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)
                  : (c <= 8124 || (c < 8130
                    ? c == 8126
                    : c <= 8132)))
                : (c <= 8140 || (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))))
              : (c <= 8256 || (c < 8417
                ? (c < 8319
                  ? (c < 8305
                    ? c == 8276
                    : c <= 8305)
                  : (c <= 8319 || (c < 8400
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8412)))
                : (c <= 8417 || (c < 8455
                  ? (c < 8450
                    ? (c >= 8421 && c <= 8432)
                    : c <= 8450)
                  : (c <= 8455 || (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)))))))
            : (c <= 8477 || (c < 11559
              ? (c < 8517
                ? (c < 8488
                  ? (c < 8486
                    ? c == 8484
                    : c <= 8486)
                  : (c <= 8488 || (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)))
                : (c <= 8521 || (c < 11264
                  ? (c < 8544
                    ? c == 8526
                    : c <= 8584)
                  : (c <= 11492 || (c < 11520
                    ? (c >= 11499 && c <= 11507)
                    : c <= 11557)))))
              : (c <= 11559 || (c < 11688
                ? (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c < 11680
                    ? (c >= 11647 && c <= 11670)
                    : c <= 11686)))
                : (c <= 11694 || (c < 11712
                  ? (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)
                  : (c <= 11718 || (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)))))))))
          : (c <= 11742 || (c < 42786
            ? (c < 12593
              ? (c < 12353
                ? (c < 12321
                  ? (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : c <= 12295)
                  : (c <= 12335 || (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)))
                : (c <= 12438 || (c < 12449
                  ? (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)
                  : (c <= 12538 || (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)))))
              : (c <= 12686 || (c < 42240
                ? (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)))
                : (c <= 42508 || (c < 42612
                  ? (c < 42560
                    ? (c >= 42512 && c <= 42539)
                    : c <= 42607)
                  : (c <= 42621 || (c < 42775
                    ? (c >= 42623 && c <= 42737)
                    : c <= 42783)))))))
            : (c <= 42888 || (c < 43261
              ? (c < 43052
                ? (c < 42963
                  ? (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)
                  : (c <= 42963 || (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43047)))
                : (c <= 43052 || (c < 43216
                  ? (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)
                  : (c <= 43225 || (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)))))
              : (c <= 43309 || (c < 43520
                ? (c < 43392
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)
                  : (c <= 43456 || (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)))
                : (c <= 43574 || (c < 43616
                  ? (c < 43600
                    ? (c >= 43584 && c <= 43597)
                    : c <= 43609)
                  : (c <= 43638 || (c >= 43642 && c <= 43714)))))))))))))))
    : (c <= 43741 || (c < 71472
      ? (c < 67644
        ? (c < 65474
          ? (c < 64320
            ? (c < 44016
              ? (c < 43808
                ? (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)
                  : (c <= 43782 || (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)))
                : (c <= 43814 || (c < 43868
                  ? (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)
                  : (c <= 43881 || (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)))))
              : (c <= 44025 || (c < 64256
                ? (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)))
                : (c <= 64262 || (c < 64298
                  ? (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)
                  : (c <= 64310 || (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)))))))
            : (c <= 64321 || (c < 65137
              ? (c < 64914
                ? (c < 64467
                  ? (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))
                : (c <= 64967 || (c < 65056
                  ? (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)
                  : (c <= 65071 || (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)))))
              : (c <= 65137 || (c < 65151
                ? (c < 65145
                  ? (c < 65143
                    ? c == 65139
                    : c <= 65143)
                  : (c <= 65145 || (c < 65149
                    ? c == 65147
                    : c <= 65149)))
                : (c <= 65276 || (c < 65343
                  ? (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)
                  : (c <= 65343 || (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)))))))))
          : (c <= 65479 || (c < 66720
            ? (c < 66045
              ? (c < 65576
                ? (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)))
                : (c <= 65594 || (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)))))
              : (c <= 66045 || (c < 66384
                ? (c < 66272
                  ? (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)
                  : (c <= 66272 || (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)))
                : (c <= 66426 || (c < 66504
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)
                  : (c <= 66511 || (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)))))))
            : (c <= 66729 || (c < 67003
              ? (c < 66940
                ? (c < 66816
                  ? (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)
                  : (c <= 66855 || (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)))
                : (c <= 66954 || (c < 66967
                  ? (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)
                  : (c <= 66977 || (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)))))
              : (c <= 67004 || (c < 67506
                ? (c < 67424
                  ? (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)
                  : (c <= 67431 || (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)))
                : (c <= 67514 || (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))))))))))
        : (c <= 67644 || (c < 69968
          ? (c < 68480
            ? (c < 68108
              ? (c < 67840
                ? (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))
                : (c <= 67861 || (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68101
                    ? (c >= 68096 && c <= 68099)
                    : c <= 68102)))))
              : (c <= 68115 || (c < 68224
                ? (c < 68152
                  ? (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)
                  : (c <= 68154 || (c < 68192
                    ? c == 68159
                    : c <= 68220)))
                : (c <= 68252 || (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)
                  : (c <= 68405 || (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)))))))
            : (c <= 68497 || (c < 69488
              ? (c < 69248
                ? (c < 68800
                  ? (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)
                  : (c <= 68850 || (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)))
                : (c <= 69289 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69456)))))
              : (c <= 69509 || (c < 69826
                ? (c < 69632
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69702 || (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)))
                : (c <= 69826 || (c < 69888
                  ? (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69881)
                  : (c <= 69940 || (c < 69956
                    ? (c >= 69942 && c <= 69951)
                    : c <= 69959)))))))))
          : (c <= 70003 || (c < 70471
            ? (c < 70287
              ? (c < 70144
                ? (c < 70089
                  ? (c < 70016
                    ? c == 70006
                    : c <= 70084)
                  : (c <= 70092 || (c < 70108
                    ? (c >= 70094 && c <= 70106)
                    : c <= 70108)))
                : (c <= 70161 || (c < 70272
                  ? (c < 70206
                    ? (c >= 70163 && c <= 70199)
                    : c <= 70206)
                  : (c <= 70278 || (c < 70282
                    ? c == 70280
                    : c <= 70285)))))
              : (c <= 70301 || (c < 70415
                ? (c < 70384
                  ? (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)
                  : (c <= 70393 || (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)))
                : (c <= 70416 || (c < 70450
                  ? (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)
                  : (c <= 70451 || (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)))))))
            : (c <= 70472 || (c < 70864
              ? (c < 70512
                ? (c < 70487
                  ? (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)
                  : (c <= 70487 || (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)))
                : (c <= 70516 || (c < 70750
                  ? (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)
                  : (c <= 70753 || (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)))))
              : (c <= 70873 || (c < 71248
                ? (c < 71128
                  ? (c < 71096
                    ? (c >= 71040 && c <= 71093)
                    : c <= 71104)
                  : (c <= 71133 || (c < 71236
                    ? (c >= 71168 && c <= 71232)
                    : c <= 71236)))
                : (c <= 71257 || (c < 71424
                  ? (c < 71360
                    ? (c >= 71296 && c <= 71352)
                    : c <= 71369)
                  : (c <= 71450 || (c >= 71453 && c <= 71467)))))))))))))
      : (c <= 71481 || (c < 119973
        ? (c < 82944
          ? (c < 72784
            ? (c < 72096
              ? (c < 71948
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71738)
                  : (c <= 71913 || (c < 71945
                    ? (c >= 71935 && c <= 71942)
                    : c <= 71945)))
                : (c <= 71955 || (c < 71991
                  ? (c < 71960
                    ? (c >= 71957 && c <= 71958)
                    : c <= 71989)
                  : (c <= 71992 || (c < 72016
                    ? (c >= 71995 && c <= 72003)
                    : c <= 72025)))))
              : (c <= 72103 || (c < 72272
                ? (c < 72163
                  ? (c < 72154
                    ? (c >= 72106 && c <= 72151)
                    : c <= 72161)
                  : (c <= 72164 || (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)))
                : (c <= 72345 || (c < 72704
                  ? (c < 72368
                    ? c == 72349
                    : c <= 72440)
                  : (c <= 72712 || (c < 72760
                    ? (c >= 72714 && c <= 72758)
                    : c <= 72768)))))))
            : (c <= 72793 || (c < 73063
              ? (c < 72971
                ? (c < 72873
                  ? (c < 72850
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72871)
                  : (c <= 72886 || (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)))
                : (c <= 73014 || (c < 73023
                  ? (c < 73020
                    ? c == 73018
                    : c <= 73021)
                  : (c <= 73031 || (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : c <= 73061)))))
              : (c <= 73064 || (c < 73648
                ? (c < 73107
                  ? (c < 73104
                    ? (c >= 73066 && c <= 73102)
                    : c <= 73105)
                  : (c <= 73112 || (c < 73440
                    ? (c >= 73120 && c <= 73129)
                    : c <= 73462)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))))
          : (c <= 83526 || (c < 110581
            ? (c < 93053
              ? (c < 92880
                ? (c < 92768
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92777 || (c < 92864
                    ? (c >= 92784 && c <= 92862)
                    : c <= 92873)))
                : (c <= 92909 || (c < 92992
                  ? (c < 92928
                    ? (c >= 92912 && c <= 92916)
                    : c <= 92982)
                  : (c <= 92995 || (c < 93027
                    ? (c >= 93008 && c <= 93017)
                    : c <= 93047)))))
              : (c <= 93071 || (c < 94179
                ? (c < 94031
                  ? (c < 93952
                    ? (c >= 93760 && c <= 93823)
                    : c <= 94026)
                  : (c <= 94087 || (c < 94176
                    ? (c >= 94095 && c <= 94111)
                    : c <= 94177)))
                : (c <= 94180 || (c < 100352
                  ? (c < 94208
                    ? (c >= 94192 && c <= 94193)
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))))))
            : (c <= 110587 || (c < 118576
              ? (c < 113664
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c < 118528
                    ? (c >= 113821 && c <= 113822)
                    : c <= 118573)))))
              : (c <= 118598 || (c < 119362
                ? (c < 119163
                  ? (c < 119149
                    ? (c >= 119141 && c <= 119145)
                    : c <= 119154)
                  : (c <= 119170 || (c < 119210
                    ? (c >= 119173 && c <= 119179)
                    : c <= 119213)))
                : (c <= 119364 || (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_python_identifier_character_set_6(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_python_identifier_character_set_7(int32_t c) {
  return (c < 43642
    ? (c < 3784
      ? (c < 2759
        ? (c < 2048
          ? (c < 1155
            ? (c < 736
              ? (c < 183
                ? (c < 'a'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 183 || (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)))))
              : (c <= 740 || (c < 895
                ? (c < 768
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)))
                : (c <= 895 || (c < 910
                  ? (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)
                  : (c <= 929 || (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)))))))
            : (c <= 1159 || (c < 1552
              ? (c < 1471
                ? (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)))
                : (c <= 1471 || (c < 1479
                  ? (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)
                  : (c <= 1479 || (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)))))
              : (c <= 1562 || (c < 1791
                ? (c < 1749
                  ? (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)
                  : (c <= 1756 || (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)))
                : (c <= 1791 || (c < 1984
                  ? (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)
                  : (c <= 2037 || (c < 2045
                    ? c == 2042
                    : c <= 2045)))))))))
          : (c <= 2093 || (c < 2561
            ? (c < 2474
              ? (c < 2275
                ? (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)
                  : (c <= 2183 || (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)))
                : (c <= 2403 || (c < 2437
                  ? (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)
                  : (c <= 2444 || (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)))))
              : (c <= 2480 || (c < 2519
                ? (c < 2492
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2500 || (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)))
                : (c <= 2519 || (c < 2534
                  ? (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)
                  : (c <= 2545 || (c < 2558
                    ? c == 2556
                    : c <= 2558)))))))
            : (c <= 2563 || (c < 2641
              ? (c < 2613
                ? (c < 2579
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)
                  : (c <= 2600 || (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)))
                : (c <= 2614 || (c < 2622
                  ? (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)
                  : (c <= 2626 || (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)))))
              : (c <= 2641 || (c < 2703
                ? (c < 2662
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2677 || (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)))
                : (c <= 2705 || (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)))))))))))
        : (c <= 2761 || (c < 3174
          ? (c < 2962
            ? (c < 2869
              ? (c < 2817
                ? (c < 2784
                  ? (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)
                  : (c <= 2787 || (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)))
                : (c <= 2819 || (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)))))
              : (c <= 2873 || (c < 2911
                ? (c < 2891
                  ? (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)
                  : (c <= 2893 || (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)))
                : (c <= 2915 || (c < 2946
                  ? (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)
                  : (c <= 2947 || (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)))))))
            : (c <= 2965 || (c < 3046
              ? (c < 2990
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)))
                : (c <= 3001 || (c < 3018
                  ? (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)
                  : (c <= 3021 || (c < 3031
                    ? c == 3024
                    : c <= 3031)))))
              : (c <= 3055 || (c < 3142
                ? (c < 3090
                  ? (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)))
                : (c <= 3144 || (c < 3160
                  ? (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)
                  : (c <= 3162 || (c < 3168
                    ? c == 3165
                    : c <= 3171)))))))))
          : (c <= 3183 || (c < 3457
            ? (c < 3296
              ? (c < 3253
                ? (c < 3214
                  ? (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)
                  : (c <= 3216 || (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)))
                : (c <= 3257 || (c < 3274
                  ? (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)
                  : (c <= 3277 || (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)))))
              : (c <= 3299 || (c < 3398
                ? (c < 3328
                  ? (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)
                  : (c <= 3340 || (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)))
                : (c <= 3400 || (c < 3423
                  ? (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)
                  : (c <= 3427 || (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)))))))
            : (c <= 3459 || (c < 3585
              ? (c < 3530
                ? (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : c <= 3526)))
                : (c <= 3530 || (c < 3544
                  ? (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)
                  : (c <= 3551 || (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)))))
              : (c <= 3642 || (c < 3724
                ? (c < 3713
                  ? (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)
                  : (c <= 3714 || (c < 3718
                    ? c == 3716
                    : c <= 3722)))
                : (c <= 3747 || (c < 3776
                  ? (c < 3751
                    ? c == 3749
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))))))))))))
      : (c <= 3789 || (c < 8027
        ? (c < 5919
          ? (c < 4696
            ? (c < 3974
              ? (c < 3893
                ? (c < 3840
                  ? (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)
                  : (c <= 3840 || (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)))
                : (c <= 3893 || (c < 3902
                  ? (c < 3897
                    ? c == 3895
                    : c <= 3897)
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))))
              : (c <= 3991 || (c < 4295
                ? (c < 4096
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)
                  : (c <= 4169 || (c < 4256
                    ? (c >= 4176 && c <= 4253)
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c < 4688
                    ? (c >= 4682 && c <= 4685)
                    : c <= 4694)))))))
            : (c <= 4696 || (c < 4888
              ? (c < 4792
                ? (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)))
                : (c <= 4798 || (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)))))
              : (c <= 4954 || (c < 5121
                ? (c < 4992
                  ? (c < 4969
                    ? (c >= 4957 && c <= 4959)
                    : c <= 4977)
                  : (c <= 5007 || (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)))
                : (c <= 5740 || (c < 5792
                  ? (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)
                  : (c <= 5866 || (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5909)))))))))
          : (c <= 5940 || (c < 6752
            ? (c < 6272
              ? (c < 6103
                ? (c < 5998
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)
                  : (c <= 6000 || (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)))
                : (c <= 6103 || (c < 6155
                  ? (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)
                  : (c <= 6157 || (c < 6176
                    ? (c >= 6159 && c <= 6169)
                    : c <= 6264)))))
              : (c <= 6314 || (c < 6512
                ? (c < 6432
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6443 || (c < 6470
                    ? (c >= 6448 && c <= 6459)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6608
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6618 || (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : c <= 6750)))))))
            : (c <= 6780 || (c < 7245
              ? (c < 6912
                ? (c < 6823
                  ? (c < 6800
                    ? (c >= 6783 && c <= 6793)
                    : c <= 6809)
                  : (c <= 6823 || (c < 6847
                    ? (c >= 6832 && c <= 6845)
                    : c <= 6862)))
                : (c <= 6988 || (c < 7040
                  ? (c < 7019
                    ? (c >= 6992 && c <= 7001)
                    : c <= 7027)
                  : (c <= 7155 || (c < 7232
                    ? (c >= 7168 && c <= 7223)
                    : c <= 7241)))))
              : (c <= 7293 || (c < 7424
                ? (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c < 7380
                    ? (c >= 7376 && c <= 7378)
                    : c <= 7418)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)))))))))))
        : (c <= 8027 || (c < 11728
          ? (c < 8469
            ? (c < 8182
              ? (c < 8130
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)))
                : (c <= 8132 || (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))))
              : (c <= 8188 || (c < 8400
                ? (c < 8305
                  ? (c < 8276
                    ? (c >= 8255 && c <= 8256)
                    : c <= 8276)
                  : (c <= 8305 || (c < 8336
                    ? c == 8319
                    : c <= 8348)))
                : (c <= 8412 || (c < 8450
                  ? (c < 8421
                    ? c == 8417
                    : c <= 8432)
                  : (c <= 8450 || (c < 8458
                    ? c == 8455
                    : c <= 8467)))))))
            : (c <= 8469 || (c < 11520
              ? (c < 8508
                ? (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || (c < 8490
                    ? c == 8488
                    : c <= 8505)))
                : (c <= 8511 || (c < 8544
                  ? (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8584 || (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11507)))))
              : (c <= 11557 || (c < 11680
                ? (c < 11568
                  ? (c < 11565
                    ? c == 11559
                    : c <= 11565)
                  : (c <= 11623 || (c < 11647
                    ? c == 11631
                    : c <= 11670)))
                : (c <= 11686 || (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)))))))))
          : (c <= 11734 || (c < 42775
            ? (c < 12549
              ? (c < 12344
                ? (c < 12293
                  ? (c < 11744
                    ? (c >= 11736 && c <= 11742)
                    : c <= 11775)
                  : (c <= 12295 || (c < 12337
                    ? (c >= 12321 && c <= 12335)
                    : c <= 12341)))
                : (c <= 12348 || (c < 12445
                  ? (c < 12441
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12442)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))))
              : (c <= 12591 || (c < 42192
                ? (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 42124)))
                : (c <= 42237 || (c < 42560
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)
                  : (c <= 42607 || (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : c <= 42737)))))))
            : (c <= 42783 || (c < 43259
              ? (c < 42994
                ? (c < 42960
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)
                  : (c <= 42961 || (c < 42965
                    ? c == 42963
                    : c <= 42969)))
                : (c <= 43047 || (c < 43136
                  ? (c < 43072
                    ? c == 43052
                    : c <= 43123)
                  : (c <= 43205 || (c < 43232
                    ? (c >= 43216 && c <= 43225)
                    : c <= 43255)))))
              : (c <= 43259 || (c < 43488
                ? (c < 43360
                  ? (c < 43312
                    ? (c >= 43261 && c <= 43309)
                    : c <= 43347)
                  : (c <= 43388 || (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : c <= 43481)))
                : (c <= 43518 || (c < 43600
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43574)
                    : c <= 43597)
                  : (c <= 43609 || (c >= 43616 && c <= 43638)))))))))))))))
    : (c <= 43714 || (c < 71472
      ? (c < 67644
        ? (c < 65382
          ? (c < 64318
            ? (c < 44012
              ? (c < 43793
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43759)
                  : (c <= 43766 || (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : c <= 43790)))
                : (c <= 43798 || (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44010)))))
              : (c <= 44013 || (c < 64112
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 44016 && c <= 44025)
                    : c <= 55203)
                  : (c <= 55238 || (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)))
                : (c <= 64217 || (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64296 || (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)))))))
            : (c <= 64318 || (c < 65101
              ? (c < 64848
                ? (c < 64326
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)
                  : (c <= 64433 || (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)))
                : (c <= 64911 || (c < 65024
                  ? (c < 65008
                    ? (c >= 64914 && c <= 64967)
                    : c <= 65017)
                  : (c <= 65039 || (c < 65075
                    ? (c >= 65056 && c <= 65071)
                    : c <= 65076)))))
              : (c <= 65103 || (c < 65149
                ? (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65313
                  ? (c < 65296
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65305)
                  : (c <= 65338 || (c < 65345
                    ? c == 65343
                    : c <= 65370)))))))))
          : (c <= 65470 || (c < 66560
            ? (c < 65856
              ? (c < 65549
                ? (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c < 65536
                    ? (c >= 65498 && c <= 65500)
                    : c <= 65547)))
                : (c <= 65574 || (c < 65599
                  ? (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))))
              : (c <= 65908 || (c < 66349
                ? (c < 66208
                  ? (c < 66176
                    ? c == 66045
                    : c <= 66204)
                  : (c <= 66256 || (c < 66304
                    ? c == 66272
                    : c <= 66335)))
                : (c <= 66378 || (c < 66464
                  ? (c < 66432
                    ? (c >= 66384 && c <= 66426)
                    : c <= 66461)
                  : (c <= 66499 || (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)))))))
            : (c <= 66717 || (c < 66995
              ? (c < 66928
                ? (c < 66776
                  ? (c < 66736
                    ? (c >= 66720 && c <= 66729)
                    : c <= 66771)
                  : (c <= 66811 || (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)))
                : (c <= 66938 || (c < 66964
                  ? (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)
                  : (c <= 66965 || (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)))))
              : (c <= 67001 || (c < 67463
                ? (c < 67392
                  ? (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)
                  : (c <= 67413 || (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)))
                : (c <= 67504 || (c < 67592
                  ? (c < 67584
                    ? (c >= 67506 && c <= 67514)
                    : c <= 67589)
                  : (c <= 67592 || (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)))))))))))
        : (c <= 67644 || (c < 69968
          ? (c < 68480
            ? (c < 68108
              ? (c < 67840
                ? (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))
                : (c <= 67861 || (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68101
                    ? (c >= 68096 && c <= 68099)
                    : c <= 68102)))))
              : (c <= 68115 || (c < 68224
                ? (c < 68152
                  ? (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)
                  : (c <= 68154 || (c < 68192
                    ? c == 68159
                    : c <= 68220)))
                : (c <= 68252 || (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)
                  : (c <= 68405 || (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)))))))
            : (c <= 68497 || (c < 69488
              ? (c < 69248
                ? (c < 68800
                  ? (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)
                  : (c <= 68850 || (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)))
                : (c <= 69289 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69456)))))
              : (c <= 69509 || (c < 69826
                ? (c < 69632
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69702 || (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)))
                : (c <= 69826 || (c < 69888
                  ? (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69881)
                  : (c <= 69940 || (c < 69956
                    ? (c >= 69942 && c <= 69951)
                    : c <= 69959)))))))))
          : (c <= 70003 || (c < 70471
            ? (c < 70287
              ? (c < 70144
                ? (c < 70089
                  ? (c < 70016
                    ? c == 70006
                    : c <= 70084)
                  : (c <= 70092 || (c < 70108
                    ? (c >= 70094 && c <= 70106)
                    : c <= 70108)))
                : (c <= 70161 || (c < 70272
                  ? (c < 70206
                    ? (c >= 70163 && c <= 70199)
                    : c <= 70206)
                  : (c <= 70278 || (c < 70282
                    ? c == 70280
                    : c <= 70285)))))
              : (c <= 70301 || (c < 70415
                ? (c < 70384
                  ? (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)
                  : (c <= 70393 || (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)))
                : (c <= 70416 || (c < 70450
                  ? (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)
                  : (c <= 70451 || (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)))))))
            : (c <= 70472 || (c < 70864
              ? (c < 70512
                ? (c < 70487
                  ? (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)
                  : (c <= 70487 || (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)))
                : (c <= 70516 || (c < 70750
                  ? (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)
                  : (c <= 70753 || (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)))))
              : (c <= 70873 || (c < 71248
                ? (c < 71128
                  ? (c < 71096
                    ? (c >= 71040 && c <= 71093)
                    : c <= 71104)
                  : (c <= 71133 || (c < 71236
                    ? (c >= 71168 && c <= 71232)
                    : c <= 71236)))
                : (c <= 71257 || (c < 71424
                  ? (c < 71360
                    ? (c >= 71296 && c <= 71352)
                    : c <= 71369)
                  : (c <= 71450 || (c >= 71453 && c <= 71467)))))))))))))
      : (c <= 71481 || (c < 119973
        ? (c < 82944
          ? (c < 72784
            ? (c < 72096
              ? (c < 71948
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71738)
                  : (c <= 71913 || (c < 71945
                    ? (c >= 71935 && c <= 71942)
                    : c <= 71945)))
                : (c <= 71955 || (c < 71991
                  ? (c < 71960
                    ? (c >= 71957 && c <= 71958)
                    : c <= 71989)
                  : (c <= 71992 || (c < 72016
                    ? (c >= 71995 && c <= 72003)
                    : c <= 72025)))))
              : (c <= 72103 || (c < 72272
                ? (c < 72163
                  ? (c < 72154
                    ? (c >= 72106 && c <= 72151)
                    : c <= 72161)
                  : (c <= 72164 || (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)))
                : (c <= 72345 || (c < 72704
                  ? (c < 72368
                    ? c == 72349
                    : c <= 72440)
                  : (c <= 72712 || (c < 72760
                    ? (c >= 72714 && c <= 72758)
                    : c <= 72768)))))))
            : (c <= 72793 || (c < 73063
              ? (c < 72971
                ? (c < 72873
                  ? (c < 72850
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72871)
                  : (c <= 72886 || (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)))
                : (c <= 73014 || (c < 73023
                  ? (c < 73020
                    ? c == 73018
                    : c <= 73021)
                  : (c <= 73031 || (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : c <= 73061)))))
              : (c <= 73064 || (c < 73648
                ? (c < 73107
                  ? (c < 73104
                    ? (c >= 73066 && c <= 73102)
                    : c <= 73105)
                  : (c <= 73112 || (c < 73440
                    ? (c >= 73120 && c <= 73129)
                    : c <= 73462)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))))
          : (c <= 83526 || (c < 110581
            ? (c < 93053
              ? (c < 92880
                ? (c < 92768
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92777 || (c < 92864
                    ? (c >= 92784 && c <= 92862)
                    : c <= 92873)))
                : (c <= 92909 || (c < 92992
                  ? (c < 92928
                    ? (c >= 92912 && c <= 92916)
                    : c <= 92982)
                  : (c <= 92995 || (c < 93027
                    ? (c >= 93008 && c <= 93017)
                    : c <= 93047)))))
              : (c <= 93071 || (c < 94179
                ? (c < 94031
                  ? (c < 93952
                    ? (c >= 93760 && c <= 93823)
                    : c <= 94026)
                  : (c <= 94087 || (c < 94176
                    ? (c >= 94095 && c <= 94111)
                    : c <= 94177)))
                : (c <= 94180 || (c < 100352
                  ? (c < 94208
                    ? (c >= 94192 && c <= 94193)
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))))))
            : (c <= 110587 || (c < 118576
              ? (c < 113664
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c < 118528
                    ? (c >= 113821 && c <= 113822)
                    : c <= 118573)))))
              : (c <= 118598 || (c < 119362
                ? (c < 119163
                  ? (c < 119149
                    ? (c >= 119141 && c <= 119145)
                    : c <= 119154)
                  : (c <= 119170 || (c < 119210
                    ? (c >= 119173 && c <= 119179)
                    : c <= 119213)))
                : (c <= 119364 || (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (eof) ADVANCE(353);
      if (!eof && lookahead == 0) ADVANCE(359);
      if (lookahead == '!') ADVANCE(70);
      if (lookahead == '"') ADVANCE(402);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '$') ADVANCE(441);
      if (lookahead == '%') ADVANCE(547);
      if (lookahead == '&') ADVANCE(555);
      if (lookahead == '\'') ADVANCE(442);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(474);
      if (lookahead == '+') ADVANCE(535);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(538);
      if (lookahead == '.') ADVANCE(462);
      if (lookahead == '/') ADVANCE(544);
      if (lookahead == '0') ADVANCE(604);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(561);
      if (lookahead == '=') ADVANCE(363);
      if (lookahead == '>') ADVANCE(567);
      if (lookahead == '?') ADVANCE(77);
      if (lookahead == '@') ADVANCE(542);
      if (lookahead == 'E') ADVANCE(142);
      if (lookahead == 'F') ADVANCE(156);
      if (lookahead == 'I') ADVANCE(112);
      if (lookahead == 'N') ADVANCE(264);
      if (lookahead == 'O') ADVANCE(140);
      if (lookahead == 'T') ADVANCE(282);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == '\\') ADVANCE(591);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(557);
      if (lookahead == '_') ADVANCE(143);
      if (lookahead == 'a') ADVANCE(174);
      if (lookahead == 'b') ADVANCE(196);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(182);
      if (lookahead == 'e') ADVANCE(232);
      if (lookahead == 'f') ADVANCE(152);
      if (lookahead == 'g') ADVANCE(236);
      if (lookahead == 'i') ADVANCE(210);
      if (lookahead == 'l') ADVANCE(153);
      if (lookahead == 'm') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(261);
      if (lookahead == 'o') ADVANCE(283);
      if (lookahead == 'p') ADVANCE(154);
      if (lookahead == 'r') ADVANCE(157);
      if (lookahead == 't') ADVANCE(284);
      if (lookahead == 'u') ADVANCE(251);
      if (lookahead == 'w') ADVANCE(218);
      if (lookahead == 'y') ADVANCE(221);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(553);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(351);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(602);
      END_STATE();
    case 1:
      if (!eof && lookahead == 0) ADVANCE(359);
      if (lookahead == '\n') ADVANCE(354);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '$') ADVANCE(329);
      if (lookahead == '+') ADVANCE(73);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == '=') ADVANCE(362);
      if (lookahead == '?') ADVANCE(77);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(887);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 2:
      if (!eof && lookahead == 0) ADVANCE(359);
      if (lookahead == '\n') ADVANCE(356);
      if (lookahead == '\r') ADVANCE(2);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == 'b') ADVANCE(886);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(2);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 3:
      if (!eof && lookahead == 0) ADVANCE(359);
      if (lookahead == '\n') ADVANCE(357);
      if (lookahead == '\r') ADVANCE(3);
      if (lookahead == '#') ADVANCE(908);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(3);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 4:
      if (!eof && lookahead == 0) ADVANCE(359);
      if (lookahead == '\n') ADVANCE(358);
      if (lookahead == '\r') ADVANCE(4);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == 'a') ADVANCE(209);
      if (lookahead == 'b') ADVANCE(195);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(4);
      END_STATE();
    case 5:
      if (!eof && lookahead == 0) ADVANCE(360);
      if (lookahead == '\n') ADVANCE(355);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == ' ') SKIP(5);
      if (lookahead == '#') ADVANCE(907);
      if (lookahead == '$') ADVANCE(327);
      if (('\t' <= lookahead && lookahead <= '\f')) ADVANCE(6);
      if (lookahead != 0) ADVANCE(349);
      END_STATE();
    case 6:
      if (!eof && lookahead == 0) ADVANCE(360);
      if (lookahead == '\n') ADVANCE(355);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == ' ') SKIP(5);
      if (lookahead == '#') ADVANCE(398);
      if (lookahead == '$') ADVANCE(397);
      if (('\t' <= lookahead && lookahead <= '\f')) ADVANCE(395);
      if (lookahead != 0) ADVANCE(399);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(590);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(447);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(447);
      if (lookahead == '\r') ADVANCE(8);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(10);
      if (lookahead == '#') ADVANCE(593);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '}') ADVANCE(432);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(592);
      if (lookahead != 0) ADVANCE(593);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(70);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(547);
      if (lookahead == '&') ADVANCE(555);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(474);
      if (lookahead == '+') ADVANCE(535);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(537);
      if (lookahead == '.') ADVANCE(461);
      if (lookahead == '/') ADVANCE(544);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(561);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(567);
      if (lookahead == '@') ADVANCE(542);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(557);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == 'e') ADVANCE(243);
      if (lookahead == 'f') ADVANCE(288);
      if (lookahead == 'i') ADVANCE(211);
      if (lookahead == 'n') ADVANCE(275);
      if (lookahead == 'o') ADVANCE(283);
      if (lookahead == '|') ADVANCE(553);
      if (lookahead == '}') ADVANCE(432);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(70);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(562);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(568);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(705);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'i') ADVANCE(669);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'o') ADVANCE(729);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(70);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(562);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(568);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(705);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'i') ADVANCE(669);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'o') ADVANCE(729);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(70);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(536);
      if (lookahead == '.') ADVANCE(461);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(562);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(568);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == 'e') ADVANCE(243);
      if (lookahead == 'f') ADVANCE(288);
      if (lookahead == 'i') ADVANCE(211);
      if (lookahead == 'n') ADVANCE(275);
      if (lookahead == 'o') ADVANCE(283);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '}') ADVANCE(432);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14);
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(70);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(536);
      if (lookahead == '.') ADVANCE(461);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(562);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(568);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == 'e') ADVANCE(243);
      if (lookahead == 'f') ADVANCE(288);
      if (lookahead == 'i') ADVANCE(211);
      if (lookahead == 'n') ADVANCE(275);
      if (lookahead == 'o') ADVANCE(283);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '}') ADVANCE(432);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15);
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(348);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(361);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 17:
      if (lookahead == '!') ADVANCE(348);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '=') ADVANCE(361);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'f') ADVANCE(732);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(348);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '=') ADVANCE(361);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(18);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(348);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == '=') ADVANCE(361);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(547);
      if (lookahead == '&') ADVANCE(555);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(474);
      if (lookahead == '+') ADVANCE(535);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(537);
      if (lookahead == '.') ADVANCE(461);
      if (lookahead == '/') ADVANCE(544);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(561);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(567);
      if (lookahead == '@') ADVANCE(542);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(557);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == 'e') ADVANCE(243);
      if (lookahead == 'f') ADVANCE(267);
      if (lookahead == 'i') ADVANCE(210);
      if (lookahead == 'n') ADVANCE(275);
      if (lookahead == 'o') ADVANCE(283);
      if (lookahead == 'w') ADVANCE(224);
      if (lookahead == '|') ADVANCE(553);
      if (lookahead == '}') ADVANCE(432);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(547);
      if (lookahead == '&') ADVANCE(555);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(474);
      if (lookahead == '+') ADVANCE(535);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(539);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(544);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(561);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(567);
      if (lookahead == '@') ADVANCE(542);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == '^') ADVANCE(557);
      if (lookahead == 'a') ADVANCE(705);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'i') ADVANCE(669);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'o') ADVANCE(729);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(553);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(21);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(547);
      if (lookahead == '&') ADVANCE(555);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(474);
      if (lookahead == '+') ADVANCE(535);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(539);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(544);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(561);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(567);
      if (lookahead == '@') ADVANCE(542);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == '^') ADVANCE(557);
      if (lookahead == 'a') ADVANCE(705);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'i') ADVANCE(669);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'o') ADVANCE(729);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(553);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(547);
      if (lookahead == '&') ADVANCE(555);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(474);
      if (lookahead == '+') ADVANCE(535);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(539);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(544);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(561);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(567);
      if (lookahead == '@') ADVANCE(542);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == '^') ADVANCE(557);
      if (lookahead == 'a') ADVANCE(705);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'i') ADVANCE(669);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'o') ADVANCE(729);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(553);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(23);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(547);
      if (lookahead == '&') ADVANCE(555);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(474);
      if (lookahead == '+') ADVANCE(535);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(537);
      if (lookahead == '.') ADVANCE(461);
      if (lookahead == '/') ADVANCE(544);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(561);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(567);
      if (lookahead == '@') ADVANCE(542);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == '^') ADVANCE(557);
      if (lookahead == 'a') ADVANCE(772);
      if (lookahead == 'i') ADVANCE(769);
      if (lookahead == 'n') ADVANCE(773);
      if (lookahead == 'o') ADVANCE(776);
      if (lookahead == '|') ADVANCE(553);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(24);
      if (sym_python_identifier_character_set_2(lookahead)) ADVANCE(784);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == '<') ADVANCE(562);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(568);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(705);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'f') ADVANCE(718);
      if (lookahead == 'i') ADVANCE(669);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'o') ADVANCE(729);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(25);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 26:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(536);
      if (lookahead == '.') ADVANCE(461);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == '<') ADVANCE(562);
      if (lookahead == '=') ADVANCE(364);
      if (lookahead == '>') ADVANCE(568);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'f') ADVANCE(266);
      if (lookahead == 'i') ADVANCE(211);
      if (lookahead == 'n') ADVANCE(275);
      if (lookahead == 'o') ADVANCE(283);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '}') ADVANCE(432);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(26);
      END_STATE();
    case 27:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(536);
      if (lookahead == '.') ADVANCE(461);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == '<') ADVANCE(562);
      if (lookahead == '=') ADVANCE(76);
      if (lookahead == '>') ADVANCE(568);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'f') ADVANCE(266);
      if (lookahead == 'i') ADVANCE(211);
      if (lookahead == 'n') ADVANCE(275);
      if (lookahead == 'o') ADVANCE(283);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '}') ADVANCE(432);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(27);
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == '<') ADVANCE(562);
      if (lookahead == '=') ADVANCE(76);
      if (lookahead == '>') ADVANCE(568);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(705);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'f') ADVANCE(718);
      if (lookahead == 'i') ADVANCE(669);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'o') ADVANCE(729);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(28);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 29:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(75);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(562);
      if (lookahead == '=') ADVANCE(76);
      if (lookahead == '>') ADVANCE(568);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(705);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'f') ADVANCE(732);
      if (lookahead == 'i') ADVANCE(669);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'o') ADVANCE(729);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(29);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 30:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(75);
      if (lookahead == '<') ADVANCE(562);
      if (lookahead == '=') ADVANCE(76);
      if (lookahead == '>') ADVANCE(568);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(705);
      if (lookahead == 'e') ADVANCE(697);
      if (lookahead == 'i') ADVANCE(669);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'o') ADVANCE(729);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 31:
      if (lookahead == '"') ADVANCE(438);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(31);
      END_STATE();
    case 32:
      if (lookahead == '"') ADVANCE(401);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '\'') ADVANCE(442);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '}') ADVANCE(432);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 33:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '$') ADVANCE(329);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(535);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == '=') ADVANCE(362);
      if (lookahead == '?') ADVANCE(77);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(736);
      if (lookahead == 'b') ADVANCE(730);
      if (lookahead == 'c') ADVANCE(715);
      if (lookahead == 'd') ADVANCE(652);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'f') ADVANCE(717);
      if (lookahead == 'g') ADVANCE(691);
      if (lookahead == 'i') ADVANCE(668);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(713);
      if (lookahead == 'p') ADVANCE(632);
      if (lookahead == 'r') ADVANCE(636);
      if (lookahead == 't') ADVANCE(727);
      if (lookahead == 'w') ADVANCE(675);
      if (lookahead == 'y') ADVANCE(678);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(33);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 34:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '$') ADVANCE(329);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '+') ADVANCE(73);
      if (lookahead == '.') ADVANCE(903);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == '=') ADVANCE(362);
      if (lookahead == '?') ADVANCE(77);
      if (lookahead == '[') ADVANCE(372);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(34);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 35:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '$') ADVANCE(329);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == ':') ADVANCE(384);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(35);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 36:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '$') ADVANCE(329);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'a') ADVANCE(856);
      if (lookahead == 'p') ADVANCE(865);
      if (lookahead == 'r') ADVANCE(824);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(36);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 37:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(547);
      if (lookahead == '&') ADVANCE(555);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(474);
      if (lookahead == '+') ADVANCE(535);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(539);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(544);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(66);
      if (lookahead == '=') ADVANCE(361);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '@') ADVANCE(542);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == '^') ADVANCE(557);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(553);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(37);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 38:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(546);
      if (lookahead == '&') ADVANCE(554);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(463);
      if (lookahead == '/') ADVANCE(545);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '@') ADVANCE(541);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == '^') ADVANCE(556);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'i') ADVANCE(703);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(552);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(38);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 39:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(476);
      if (lookahead == '+') ADVANCE(535);
      if (lookahead == '-') ADVANCE(539);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(65);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(68);
      if (lookahead == '=') ADVANCE(361);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '@') ADVANCE(78);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == '^') ADVANCE(79);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(39);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 40:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'f') ADVANCE(718);
      if (lookahead == 'i') ADVANCE(670);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(40);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 41:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == 'y') ADVANCE(678);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(41);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 42:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(42);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 43:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '/') ADVANCE(543);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == ';') ADVANCE(457);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(43);
      if (sym_python_identifier_character_set_3(lookahead)) ADVANCE(784);
      END_STATE();
    case 44:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(736);
      if (lookahead == 'b') ADVANCE(730);
      if (lookahead == 'c') ADVANCE(715);
      if (lookahead == 'd') ADVANCE(652);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'f') ADVANCE(681);
      if (lookahead == 'g') ADVANCE(691);
      if (lookahead == 'i') ADVANCE(668);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(713);
      if (lookahead == 'p') ADVANCE(632);
      if (lookahead == 'r') ADVANCE(636);
      if (lookahead == 't') ADVANCE(727);
      if (lookahead == 'w') ADVANCE(675);
      if (lookahead == 'y') ADVANCE(678);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(44);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 45:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(736);
      if (lookahead == 'b') ADVANCE(730);
      if (lookahead == 'c') ADVANCE(715);
      if (lookahead == 'd') ADVANCE(652);
      if (lookahead == 'e') ADVANCE(697);
      if (lookahead == 'f') ADVANCE(717);
      if (lookahead == 'g') ADVANCE(691);
      if (lookahead == 'i') ADVANCE(668);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(713);
      if (lookahead == 'p') ADVANCE(632);
      if (lookahead == 'r') ADVANCE(636);
      if (lookahead == 't') ADVANCE(727);
      if (lookahead == 'w') ADVANCE(675);
      if (lookahead == 'y') ADVANCE(678);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(45);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 46:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(736);
      if (lookahead == 'b') ADVANCE(730);
      if (lookahead == 'c') ADVANCE(715);
      if (lookahead == 'd') ADVANCE(652);
      if (lookahead == 'e') ADVANCE(696);
      if (lookahead == 'f') ADVANCE(681);
      if (lookahead == 'g') ADVANCE(691);
      if (lookahead == 'i') ADVANCE(668);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(713);
      if (lookahead == 'p') ADVANCE(632);
      if (lookahead == 'r') ADVANCE(636);
      if (lookahead == 't') ADVANCE(727);
      if (lookahead == 'w') ADVANCE(675);
      if (lookahead == 'y') ADVANCE(678);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(46);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 47:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(736);
      if (lookahead == 'b') ADVANCE(730);
      if (lookahead == 'c') ADVANCE(715);
      if (lookahead == 'd') ADVANCE(652);
      if (lookahead == 'e') ADVANCE(688);
      if (lookahead == 'f') ADVANCE(717);
      if (lookahead == 'g') ADVANCE(691);
      if (lookahead == 'i') ADVANCE(668);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(713);
      if (lookahead == 'p') ADVANCE(632);
      if (lookahead == 'r') ADVANCE(636);
      if (lookahead == 't') ADVANCE(727);
      if (lookahead == 'w') ADVANCE(675);
      if (lookahead == 'y') ADVANCE(678);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 48:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(736);
      if (lookahead == 'b') ADVANCE(730);
      if (lookahead == 'c') ADVANCE(715);
      if (lookahead == 'd') ADVANCE(652);
      if (lookahead == 'e') ADVANCE(698);
      if (lookahead == 'f') ADVANCE(681);
      if (lookahead == 'g') ADVANCE(691);
      if (lookahead == 'i') ADVANCE(668);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(713);
      if (lookahead == 'p') ADVANCE(632);
      if (lookahead == 'r') ADVANCE(636);
      if (lookahead == 't') ADVANCE(727);
      if (lookahead == 'w') ADVANCE(675);
      if (lookahead == 'y') ADVANCE(678);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 49:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(736);
      if (lookahead == 'b') ADVANCE(730);
      if (lookahead == 'c') ADVANCE(715);
      if (lookahead == 'd') ADVANCE(666);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'f') ADVANCE(732);
      if (lookahead == 'g') ADVANCE(691);
      if (lookahead == 'i') ADVANCE(699);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(713);
      if (lookahead == 'p') ADVANCE(632);
      if (lookahead == 'r') ADVANCE(636);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == 'y') ADVANCE(678);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 50:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'i') ADVANCE(703);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(50);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 51:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(473);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(51);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 52:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(473);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(52);
      if (sym_python_identifier_character_set_3(lookahead)) ADVANCE(784);
      END_STATE();
    case 53:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(739);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == 'p') ADVANCE(731);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == 'y') ADVANCE(678);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 54:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == '*') ADVANCE(475);
      if (lookahead == '+') ADVANCE(534);
      if (lookahead == '-') ADVANCE(540);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '0') ADVANCE(605);
      if (lookahead == 'F') ADVANCE(635);
      if (lookahead == 'N') ADVANCE(712);
      if (lookahead == 'T') ADVANCE(726);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(736);
      if (lookahead == 'b') ADVANCE(730);
      if (lookahead == 'c') ADVANCE(715);
      if (lookahead == 'd') ADVANCE(666);
      if (lookahead == 'e') ADVANCE(758);
      if (lookahead == 'f') ADVANCE(732);
      if (lookahead == 'g') ADVANCE(691);
      if (lookahead == 'i') ADVANCE(699);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'n') ADVANCE(713);
      if (lookahead == 'p') ADVANCE(632);
      if (lookahead == 'r') ADVANCE(636);
      if (lookahead == 't') ADVANCE(761);
      if (lookahead == 'y') ADVANCE(678);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_1(lookahead)) ADVANCE(784);
      END_STATE();
    case 55:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '.') ADVANCE(461);
      if (lookahead == '_') ADVANCE(764);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55);
      if (sym_python_identifier_character_set_4(lookahead)) ADVANCE(784);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '.') ADVANCE(461);
      if (lookahead == 'i') ADVANCE(771);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56);
      if (sym_python_identifier_character_set_3(lookahead)) ADVANCE(784);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == 'p') ADVANCE(897);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 58:
      if (lookahead == '#') ADVANCE(907);
      if (lookahead == '$') ADVANCE(327);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f') ADVANCE(59);
      if (('\n' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(58);
      if (lookahead != 0) ADVANCE(349);
      END_STATE();
    case 59:
      if (lookahead == '#') ADVANCE(398);
      if (lookahead == '$') ADVANCE(397);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f') ADVANCE(396);
      if (('\n' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(58);
      if (lookahead != 0) ADVANCE(399);
      END_STATE();
    case 60:
      if (lookahead == '#') ADVANCE(381);
      if (lookahead == 'n') ADVANCE(379);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f') ADVANCE(375);
      if (('\n' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(60);
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(382);
      END_STATE();
    case 61:
      if (lookahead == '#') ADVANCE(405);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f') ADVANCE(404);
      if (('\n' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(61);
      if (lookahead != 0) ADVANCE(406);
      END_STATE();
    case 62:
      if (lookahead == '.') ADVANCE(64);
      if (lookahead == '=') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(616);
      END_STATE();
    case 63:
      if (lookahead == '.') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(616);
      END_STATE();
    case 64:
      if (lookahead == '.') ADVANCE(589);
      END_STATE();
    case 65:
      if (lookahead == '/') ADVANCE(82);
      if (lookahead == '=') ADVANCE(577);
      END_STATE();
    case 66:
      if (lookahead == '<') ADVANCE(559);
      END_STATE();
    case 67:
      if (lookahead == '<') ADVANCE(558);
      END_STATE();
    case 68:
      if (lookahead == '<') ADVANCE(83);
      END_STATE();
    case 69:
      if (lookahead == '=') ADVANCE(565);
      END_STATE();
    case 70:
      if (lookahead == '=') ADVANCE(565);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(594);
      END_STATE();
    case 71:
      if (lookahead == '=') ADVANCE(580);
      END_STATE();
    case 72:
      if (lookahead == '=') ADVANCE(584);
      END_STATE();
    case 73:
      if (lookahead == '=') ADVANCE(368);
      END_STATE();
    case 74:
      if (lookahead == '=') ADVANCE(370);
      END_STATE();
    case 75:
      if (lookahead == '=') ADVANCE(367);
      END_STATE();
    case 76:
      if (lookahead == '=') ADVANCE(564);
      END_STATE();
    case 77:
      if (lookahead == '=') ADVANCE(365);
      if (lookahead == '?') ADVANCE(85);
      END_STATE();
    case 78:
      if (lookahead == '=') ADVANCE(578);
      END_STATE();
    case 79:
      if (lookahead == '=') ADVANCE(585);
      END_STATE();
    case 80:
      if (lookahead == '=') ADVANCE(586);
      END_STATE();
    case 81:
      if (lookahead == '=') ADVANCE(581);
      END_STATE();
    case 82:
      if (lookahead == '=') ADVANCE(579);
      END_STATE();
    case 83:
      if (lookahead == '=') ADVANCE(583);
      END_STATE();
    case 84:
      if (lookahead == '=') ADVANCE(582);
      END_STATE();
    case 85:
      if (lookahead == '=') ADVANCE(366);
      END_STATE();
    case 86:
      if (lookahead == '>') ADVANCE(456);
      END_STATE();
    case 87:
      if (lookahead == '>') ADVANCE(480);
      END_STATE();
    case 88:
      if (lookahead == '>') ADVANCE(479);
      END_STATE();
    case 89:
      if (lookahead == '>') ADVANCE(84);
      END_STATE();
    case 90:
      if (lookahead == 'A') ADVANCE(96);
      END_STATE();
    case 91:
      if (lookahead == 'A') ADVANCE(131);
      END_STATE();
    case 92:
      if (lookahead == 'B') ADVANCE(93);
      if (lookahead == '{') ADVANCE(451);
      END_STATE();
    case 93:
      if (lookahead == 'B') ADVANCE(149);
      END_STATE();
    case 94:
      if (lookahead == 'C') ADVANCE(136);
      END_STATE();
    case 95:
      if (lookahead == 'D') ADVANCE(99);
      END_STATE();
    case 96:
      if (lookahead == 'D') ADVANCE(97);
      END_STATE();
    case 97:
      if (lookahead == 'D') ADVANCE(111);
      END_STATE();
    case 98:
      if (lookahead == 'E') ADVANCE(127);
      END_STATE();
    case 99:
      if (lookahead == 'E') ADVANCE(128);
      END_STATE();
    case 100:
      if (lookahead == 'E') ADVANCE(114);
      END_STATE();
    case 101:
      if (lookahead == 'E') ADVANCE(124);
      END_STATE();
    case 102:
      if (lookahead == 'F') ADVANCE(139);
      END_STATE();
    case 103:
      if (lookahead == 'G') ADVANCE(104);
      END_STATE();
    case 104:
      if (lookahead == 'H') ADVANCE(439);
      END_STATE();
    case 105:
      if (lookahead == 'H') ADVANCE(126);
      END_STATE();
    case 106:
      if (lookahead == 'H') ADVANCE(101);
      END_STATE();
    case 107:
      if (lookahead == 'I') ADVANCE(95);
      END_STATE();
    case 108:
      if (lookahead == 'I') ADVANCE(119);
      END_STATE();
    case 109:
      if (lookahead == 'I') ADVANCE(133);
      END_STATE();
    case 110:
      if (lookahead == 'I') ADVANCE(120);
      END_STATE();
    case 111:
      if (lookahead == 'I') ADVANCE(137);
      END_STATE();
    case 112:
      if (lookahead == 'N') ADVANCE(106);
      END_STATE();
    case 113:
      if (lookahead == 'N') ADVANCE(94);
      END_STATE();
    case 114:
      if (lookahead == 'N') ADVANCE(141);
      END_STATE();
    case 115:
      if (lookahead == 'N') ADVANCE(129);
      END_STATE();
    case 116:
      if (lookahead == 'N') ADVANCE(130);
      END_STATE();
    case 117:
      if (lookahead == 'O') ADVANCE(123);
      END_STATE();
    case 118:
      if (lookahead == 'O') ADVANCE(138);
      END_STATE();
    case 119:
      if (lookahead == 'O') ADVANCE(115);
      END_STATE();
    case 120:
      if (lookahead == 'O') ADVANCE(116);
      END_STATE();
    case 121:
      if (lookahead == 'P') ADVANCE(117);
      END_STATE();
    case 122:
      if (lookahead == 'P') ADVANCE(91);
      END_STATE();
    case 123:
      if (lookahead == 'R') ADVANCE(135);
      END_STATE();
    case 124:
      if (lookahead == 'R') ADVANCE(109);
      END_STATE();
    case 125:
      if (lookahead == 'R') ADVANCE(107);
      END_STATE();
    case 126:
      if (lookahead == 'R') ADVANCE(118);
      END_STATE();
    case 127:
      if (lookahead == 'R') ADVANCE(125);
      END_STATE();
    case 128:
      if (lookahead == 'S') ADVANCE(411);
      END_STATE();
    case 129:
      if (lookahead == 'S') ADVANCE(413);
      END_STATE();
    case 130:
      if (lookahead == 'S') ADVANCE(440);
      END_STATE();
    case 131:
      if (lookahead == 'S') ADVANCE(132);
      END_STATE();
    case 132:
      if (lookahead == 'S') ADVANCE(134);
      END_STATE();
    case 133:
      if (lookahead == 'T') ADVANCE(400);
      END_STATE();
    case 134:
      if (lookahead == 'T') ADVANCE(105);
      END_STATE();
    case 135:
      if (lookahead == 'T') ADVANCE(146);
      END_STATE();
    case 136:
      if (lookahead == 'T') ADVANCE(108);
      END_STATE();
    case 137:
      if (lookahead == 'T') ADVANCE(110);
      END_STATE();
    case 138:
      if (lookahead == 'U') ADVANCE(103);
      END_STATE();
    case 139:
      if (lookahead == 'U') ADVANCE(113);
      END_STATE();
    case 140:
      if (lookahead == 'V') ADVANCE(98);
      END_STATE();
    case 141:
      if (lookahead == 'V') ADVANCE(148);
      END_STATE();
    case 142:
      if (lookahead == 'X') ADVANCE(121);
      END_STATE();
    case 143:
      if (lookahead == '_') ADVANCE(214);
      END_STATE();
    case 144:
      if (lookahead == '_') ADVANCE(332);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(608);
      END_STATE();
    case 145:
      if (lookahead == '_') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(609);
      END_STATE();
    case 146:
      if (lookahead == '_') ADVANCE(102);
      END_STATE();
    case 147:
      if (lookahead == '_') ADVANCE(466);
      END_STATE();
    case 148:
      if (lookahead == '_') ADVANCE(122);
      END_STATE();
    case 149:
      if (lookahead == '_') ADVANCE(100);
      END_STATE();
    case 150:
      if (lookahead == '_') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(613);
      END_STATE();
    case 151:
      if (lookahead == '_') ADVANCE(147);
      END_STATE();
    case 152:
      if (lookahead == 'a') ADVANCE(231);
      if (lookahead == 'i') ADVANCE(259);
      if (lookahead == 'o') ADVANCE(285);
      if (lookahead == 'r') ADVANCE(265);
      END_STATE();
    case 153:
      if (lookahead == 'a') ADVANCE(245);
      END_STATE();
    case 154:
      if (lookahead == 'a') ADVANCE(298);
      if (lookahead == 'r') ADVANCE(208);
      if (lookahead == 'y') ADVANCE(304);
      END_STATE();
    case 155:
      if (lookahead == 'a') ADVANCE(573);
      END_STATE();
    case 156:
      if (lookahead == 'a') ADVANCE(242);
      END_STATE();
    case 157:
      if (lookahead == 'a') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 158:
      if (lookahead == 'a') ADVANCE(312);
      END_STATE();
    case 159:
      if (lookahead == 'a') ADVANCE(229);
      END_STATE();
    case 160:
      if (lookahead == 'a') ADVANCE(225);
      END_STATE();
    case 161:
      if (lookahead == 'a') ADVANCE(297);
      END_STATE();
    case 162:
      if (lookahead == 'a') ADVANCE(238);
      END_STATE();
    case 163:
      if (lookahead == 'a') ADVANCE(233);
      END_STATE();
    case 164:
      if (lookahead == 'a') ADVANCE(256);
      END_STATE();
    case 165:
      if (lookahead == 'a') ADVANCE(234);
      END_STATE();
    case 166:
      if (lookahead == 'b') ADVANCE(180);
      END_STATE();
    case 167:
      if (lookahead == 'b') ADVANCE(163);
      END_STATE();
    case 168:
      if (lookahead == 'c') ADVANCE(498);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(510);
      END_STATE();
    case 170:
      if (lookahead == 'c') ADVANCE(373);
      END_STATE();
    case 171:
      if (lookahead == 'c') ADVANCE(217);
      END_STATE();
    case 172:
      if (lookahead == 'c') ADVANCE(197);
      if (lookahead == 'e') ADVANCE(168);
      if (lookahead == 'p') ADVANCE(271);
      END_STATE();
    case 173:
      if (lookahead == 'c') ADVANCE(165);
      END_STATE();
    case 174:
      if (lookahead == 'd') ADVANCE(175);
      if (lookahead == 'f') ADVANCE(315);
      if (lookahead == 'n') ADVANCE(176);
      if (lookahead == 'p') ADVANCE(277);
      if (lookahead == 's') ADVANCE(471);
      if (lookahead == 'w') ADVANCE(160);
      END_STATE();
    case 175:
      if (lookahead == 'd') ADVANCE(219);
      END_STATE();
    case 176:
      if (lookahead == 'd') ADVANCE(528);
      END_STATE();
    case 177:
      if (lookahead == 'd') ADVANCE(587);
      END_STATE();
    case 178:
      if (lookahead == 'd') ADVANCE(386);
      END_STATE();
    case 179:
      if (lookahead == 'd') ADVANCE(388);
      END_STATE();
    case 180:
      if (lookahead == 'd') ADVANCE(155);
      END_STATE();
    case 181:
      if (lookahead == 'd') ADVANCE(241);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(212);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(324);
      if (lookahead == 'n') ADVANCE(239);
      if (lookahead == 't') ADVANCE(525);
      END_STATE();
    case 184:
      if (lookahead == 'e') ADVANCE(627);
      END_STATE();
    case 185:
      if (lookahead == 'e') ADVANCE(623);
      END_STATE();
    case 186:
      if (lookahead == 'e') ADVANCE(508);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(599);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(625);
      END_STATE();
    case 189:
      if (lookahead == 'e') ADVANCE(486);
      END_STATE();
    case 190:
      if (lookahead == 'e') ADVANCE(514);
      END_STATE();
    case 191:
      if (lookahead == 'e') ADVANCE(419);
      END_STATE();
    case 192:
      if (lookahead == 'e') ADVANCE(390);
      END_STATE();
    case 193:
      if (lookahead == 'e') ADVANCE(407);
      END_STATE();
    case 194:
      if (lookahead == 'e') ADVANCE(492);
      END_STATE();
    case 195:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(215);
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 197:
      if (lookahead == 'e') ADVANCE(278);
      END_STATE();
    case 198:
      if (lookahead == 'e') ADVANCE(286);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(237);
      END_STATE();
    case 200:
      if (lookahead == 'e') ADVANCE(170);
      END_STATE();
    case 201:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 202:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 203:
      if (lookahead == 'e') ADVANCE(254);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(289);
      END_STATE();
    case 205:
      if (lookahead == 'e') ADVANCE(287);
      END_STATE();
    case 206:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(307);
      END_STATE();
    case 208:
      if (lookahead == 'e') ADVANCE(280);
      if (lookahead == 'i') ADVANCE(258);
      END_STATE();
    case 209:
      if (lookahead == 'f') ADVANCE(315);
      END_STATE();
    case 210:
      if (lookahead == 'f') ADVANCE(503);
      if (lookahead == 'm') ADVANCE(281);
      if (lookahead == 'n') ADVANCE(500);
      if (lookahead == 's') ADVANCE(570);
      END_STATE();
    case 211:
      if (lookahead == 'f') ADVANCE(503);
      if (lookahead == 'n') ADVANCE(500);
      if (lookahead == 's') ADVANCE(570);
      END_STATE();
    case 212:
      if (lookahead == 'f') ADVANCE(453);
      if (lookahead == 'l') ADVANCE(484);
      END_STATE();
    case 213:
      if (lookahead == 'f') ADVANCE(506);
      END_STATE();
    case 214:
      if (lookahead == 'f') ADVANCE(319);
      END_STATE();
    case 215:
      if (lookahead == 'f') ADVANCE(269);
      END_STATE();
    case 216:
      if (lookahead == 'h') ADVANCE(523);
      END_STATE();
    case 217:
      if (lookahead == 'h') ADVANCE(597);
      END_STATE();
    case 218:
      if (lookahead == 'h') ADVANCE(222);
      if (lookahead == 'i') ADVANCE(313);
      END_STATE();
    case 219:
      if (lookahead == 'h') ADVANCE(164);
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 220:
      if (lookahead == 'h') ADVANCE(273);
      END_STATE();
    case 221:
      if (lookahead == 'i') ADVANCE(199);
      END_STATE();
    case 222:
      if (lookahead == 'i') ADVANCE(240);
      END_STATE();
    case 223:
      if (lookahead == 'i') ADVANCE(213);
      if (lookahead == 's') ADVANCE(186);
      END_STATE();
    case 224:
      if (lookahead == 'i') ADVANCE(313);
      END_STATE();
    case 225:
      if (lookahead == 'i') ADVANCE(305);
      END_STATE();
    case 226:
      if (lookahead == 'i') ADVANCE(260);
      END_STATE();
    case 227:
      if (lookahead == 'i') ADVANCE(294);
      END_STATE();
    case 228:
      if (lookahead == 'i') ADVANCE(302);
      END_STATE();
    case 229:
      if (lookahead == 'k') ADVANCE(490);
      END_STATE();
    case 230:
      if (lookahead == 'k') ADVANCE(415);
      END_STATE();
    case 231:
      if (lookahead == 'k') ADVANCE(204);
      END_STATE();
    case 232:
      if (lookahead == 'l') ADVANCE(223);
      if (lookahead == 'x') ADVANCE(172);
      END_STATE();
    case 233:
      if (lookahead == 'l') ADVANCE(494);
      END_STATE();
    case 234:
      if (lookahead == 'l') ADVANCE(496);
      END_STATE();
    case 235:
      if (lookahead == 'l') ADVANCE(326);
      END_STATE();
    case 236:
      if (lookahead == 'l') ADVANCE(262);
      END_STATE();
    case 237:
      if (lookahead == 'l') ADVANCE(177);
      END_STATE();
    case 238:
      if (lookahead == 'l') ADVANCE(235);
      END_STATE();
    case 239:
      if (lookahead == 'l') ADVANCE(270);
      END_STATE();
    case 240:
      if (lookahead == 'l') ADVANCE(190);
      END_STATE();
    case 241:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 242:
      if (lookahead == 'l') ADVANCE(301);
      END_STATE();
    case 243:
      if (lookahead == 'l') ADVANCE(299);
      END_STATE();
    case 244:
      if (lookahead == 'm') ADVANCE(464);
      END_STATE();
    case 245:
      if (lookahead == 'm') ADVANCE(166);
      END_STATE();
    case 246:
      if (lookahead == 'm') ADVANCE(263);
      if (lookahead == 'q') ADVANCE(318);
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 247:
      if (lookahead == 'n') ADVANCE(426);
      END_STATE();
    case 248:
      if (lookahead == 'n') ADVANCE(482);
      END_STATE();
    case 249:
      if (lookahead == 'n') ADVANCE(176);
      if (lookahead == 's') ADVANCE(471);
      END_STATE();
    case 250:
      if (lookahead == 'n') ADVANCE(176);
      if (lookahead == 's') ADVANCE(469);
      END_STATE();
    case 251:
      if (lookahead == 'n') ADVANCE(300);
      END_STATE();
    case 252:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 253:
      if (lookahead == 'n') ADVANCE(184);
      END_STATE();
    case 254:
      if (lookahead == 'n') ADVANCE(178);
      END_STATE();
    case 255:
      if (lookahead == 'n') ADVANCE(314);
      END_STATE();
    case 256:
      if (lookahead == 'n') ADVANCE(181);
      END_STATE();
    case 257:
      if (lookahead == 'n') ADVANCE(179);
      END_STATE();
    case 258:
      if (lookahead == 'n') ADVANCE(306);
      END_STATE();
    case 259:
      if (lookahead == 'n') ADVANCE(162);
      END_STATE();
    case 260:
      if (lookahead == 'n') ADVANCE(321);
      END_STATE();
    case 261:
      if (lookahead == 'o') ADVANCE(183);
      END_STATE();
    case 262:
      if (lookahead == 'o') ADVANCE(167);
      END_STATE();
    case 263:
      if (lookahead == 'o') ADVANCE(323);
      END_STATE();
    case 264:
      if (lookahead == 'o') ADVANCE(253);
      END_STATE();
    case 265:
      if (lookahead == 'o') ADVANCE(244);
      END_STATE();
    case 266:
      if (lookahead == 'o') ADVANCE(285);
      END_STATE();
    case 267:
      if (lookahead == 'o') ADVANCE(285);
      if (lookahead == 'r') ADVANCE(265);
      END_STATE();
    case 268:
      if (lookahead == 'o') ADVANCE(255);
      END_STATE();
    case 269:
      if (lookahead == 'o') ADVANCE(293);
      END_STATE();
    case 270:
      if (lookahead == 'o') ADVANCE(173);
      END_STATE();
    case 271:
      if (lookahead == 'o') ADVANCE(291);
      END_STATE();
    case 272:
      if (lookahead == 'o') ADVANCE(274);
      END_STATE();
    case 273:
      if (lookahead == 'o') ADVANCE(247);
      END_STATE();
    case 274:
      if (lookahead == 'o') ADVANCE(311);
      END_STATE();
    case 275:
      if (lookahead == 'o') ADVANCE(303);
      END_STATE();
    case 276:
      if (lookahead == 'o') ADVANCE(292);
      END_STATE();
    case 277:
      if (lookahead == 'p') ADVANCE(203);
      END_STATE();
    case 278:
      if (lookahead == 'p') ADVANCE(308);
      END_STATE();
    case 279:
      if (lookahead == 'p') ADVANCE(187);
      END_STATE();
    case 280:
      if (lookahead == 'p') ADVANCE(206);
      END_STATE();
    case 281:
      if (lookahead == 'p') ADVANCE(276);
      END_STATE();
    case 282:
      if (lookahead == 'r') ADVANCE(317);
      END_STATE();
    case 283:
      if (lookahead == 'r') ADVANCE(531);
      END_STATE();
    case 284:
      if (lookahead == 'r') ADVANCE(325);
      if (lookahead == 'y') ADVANCE(279);
      END_STATE();
    case 285:
      if (lookahead == 'r') ADVANCE(512);
      END_STATE();
    case 286:
      if (lookahead == 'r') ADVANCE(417);
      END_STATE();
    case 287:
      if (lookahead == 'r') ADVANCE(422);
      END_STATE();
    case 288:
      if (lookahead == 'r') ADVANCE(265);
      END_STATE();
    case 289:
      if (lookahead == 'r') ADVANCE(272);
      END_STATE();
    case 290:
      if (lookahead == 'r') ADVANCE(248);
      END_STATE();
    case 291:
      if (lookahead == 'r') ADVANCE(309);
      END_STATE();
    case 292:
      if (lookahead == 'r') ADVANCE(310);
      END_STATE();
    case 293:
      if (lookahead == 'r') ADVANCE(191);
      END_STATE();
    case 294:
      if (lookahead == 'r') ADVANCE(193);
      END_STATE();
    case 295:
      if (lookahead == 'r') ADVANCE(202);
      END_STATE();
    case 296:
      if (lookahead == 's') ADVANCE(488);
      END_STATE();
    case 297:
      if (lookahead == 's') ADVANCE(230);
      END_STATE();
    case 298:
      if (lookahead == 's') ADVANCE(296);
      END_STATE();
    case 299:
      if (lookahead == 's') ADVANCE(186);
      END_STATE();
    case 300:
      if (lookahead == 's') ADVANCE(207);
      END_STATE();
    case 301:
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 302:
      if (lookahead == 's') ADVANCE(189);
      END_STATE();
    case 303:
      if (lookahead == 't') ADVANCE(525);
      END_STATE();
    case 304:
      if (lookahead == 't') ADVANCE(220);
      END_STATE();
    case 305:
      if (lookahead == 't') ADVANCE(595);
      END_STATE();
    case 306:
      if (lookahead == 't') ADVANCE(477);
      END_STATE();
    case 307:
      if (lookahead == 't') ADVANCE(392);
      END_STATE();
    case 308:
      if (lookahead == 't') ADVANCE(518);
      END_STATE();
    case 309:
      if (lookahead == 't') ADVANCE(409);
      END_STATE();
    case 310:
      if (lookahead == 't') ADVANCE(458);
      END_STATE();
    case 311:
      if (lookahead == 't') ADVANCE(424);
      END_STATE();
    case 312:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 313:
      if (lookahead == 't') ADVANCE(216);
      END_STATE();
    case 314:
      if (lookahead == 't') ADVANCE(226);
      END_STATE();
    case 315:
      if (lookahead == 't') ADVANCE(198);
      END_STATE();
    case 316:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 317:
      if (lookahead == 'u') ADVANCE(185);
      END_STATE();
    case 318:
      if (lookahead == 'u') ADVANCE(227);
      END_STATE();
    case 319:
      if (lookahead == 'u') ADVANCE(316);
      END_STATE();
    case 320:
      if (lookahead == 'u') ADVANCE(290);
      END_STATE();
    case 321:
      if (lookahead == 'u') ADVANCE(194);
      END_STATE();
    case 322:
      if (lookahead == 'u') ADVANCE(295);
      END_STATE();
    case 323:
      if (lookahead == 'v') ADVANCE(192);
      END_STATE();
    case 324:
      if (lookahead == 'x') ADVANCE(200);
      END_STATE();
    case 325:
      if (lookahead == 'y') ADVANCE(516);
      END_STATE();
    case 326:
      if (lookahead == 'y') ADVANCE(521);
      END_STATE();
    case 327:
      if (lookahead == '{') ADVANCE(451);
      END_STATE();
    case 328:
      if (lookahead == '{') ADVANCE(350);
      END_STATE();
    case 329:
      if (lookahead == '{') ADVANCE(450);
      END_STATE();
    case 330:
      if (lookahead == '}') ADVANCE(590);
      if (lookahead != 0) ADVANCE(330);
      END_STATE();
    case 331:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(617);
      END_STATE();
    case 332:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(608);
      END_STATE();
    case 333:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(435);
      if (lookahead == '\r') ADVANCE(435);
      if (lookahead == '"') ADVANCE(402);
      if (lookahead == '#') ADVANCE(433);
      if (lookahead == '$') ADVANCE(441);
      if (lookahead == '\\') ADVANCE(437);
      if (lookahead != 0) ADVANCE(436);
      END_STATE();
    case 334:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(444);
      if (lookahead == '\r') ADVANCE(444);
      if (lookahead == '"') ADVANCE(446);
      if (lookahead == '#') ADVANCE(443);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '\'') ADVANCE(442);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead != 0) ADVANCE(447);
      END_STATE();
    case 335:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(609);
      END_STATE();
    case 336:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(590);
      END_STATE();
    case 337:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(617);
      END_STATE();
    case 338:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(336);
      END_STATE();
    case 339:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(590);
      END_STATE();
    case 340:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(613);
      END_STATE();
    case 341:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(339);
      END_STATE();
    case 342:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(341);
      END_STATE();
    case 343:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(342);
      END_STATE();
    case 344:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(343);
      END_STATE();
    case 345:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(344);
      END_STATE();
    case 346:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(345);
      END_STATE();
    case 347:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(346);
      END_STATE();
    case 348:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(594);
      END_STATE();
    case 349:
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(399);
      END_STATE();
    case 350:
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(330);
      END_STATE();
    case 351:
      if (eof) ADVANCE(353);
      if (!eof && lookahead == 0) ADVANCE(359);
      if (lookahead == '!') ADVANCE(70);
      if (lookahead == '"') ADVANCE(402);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '$') ADVANCE(441);
      if (lookahead == '%') ADVANCE(547);
      if (lookahead == '&') ADVANCE(555);
      if (lookahead == '\'') ADVANCE(442);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == '*') ADVANCE(474);
      if (lookahead == '+') ADVANCE(535);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '-') ADVANCE(538);
      if (lookahead == '.') ADVANCE(462);
      if (lookahead == '/') ADVANCE(544);
      if (lookahead == '0') ADVANCE(604);
      if (lookahead == ':') ADVANCE(385);
      if (lookahead == ';') ADVANCE(457);
      if (lookahead == '<') ADVANCE(561);
      if (lookahead == '=') ADVANCE(363);
      if (lookahead == '>') ADVANCE(567);
      if (lookahead == '?') ADVANCE(77);
      if (lookahead == '@') ADVANCE(542);
      if (lookahead == 'E') ADVANCE(142);
      if (lookahead == 'F') ADVANCE(156);
      if (lookahead == 'I') ADVANCE(112);
      if (lookahead == 'N') ADVANCE(264);
      if (lookahead == 'O') ADVANCE(140);
      if (lookahead == 'T') ADVANCE(282);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == ']') ADVANCE(383);
      if (lookahead == '^') ADVANCE(557);
      if (lookahead == '_') ADVANCE(143);
      if (lookahead == 'a') ADVANCE(174);
      if (lookahead == 'b') ADVANCE(196);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(182);
      if (lookahead == 'e') ADVANCE(232);
      if (lookahead == 'f') ADVANCE(152);
      if (lookahead == 'g') ADVANCE(236);
      if (lookahead == 'i') ADVANCE(210);
      if (lookahead == 'l') ADVANCE(153);
      if (lookahead == 'm') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(261);
      if (lookahead == 'o') ADVANCE(283);
      if (lookahead == 'p') ADVANCE(154);
      if (lookahead == 'r') ADVANCE(157);
      if (lookahead == 't') ADVANCE(284);
      if (lookahead == 'u') ADVANCE(251);
      if (lookahead == 'w') ADVANCE(218);
      if (lookahead == 'y') ADVANCE(221);
      if (lookahead == '{') ADVANCE(431);
      if (lookahead == '|') ADVANCE(553);
      if (lookahead == '}') ADVANCE(432);
      if (lookahead == '~') ADVANCE(560);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(351);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(602);
      END_STATE();
    case 352:
      if (eof) ADVANCE(353);
      if (lookahead == '!') ADVANCE(348);
      if (lookahead == '"') ADVANCE(401);
      if (lookahead == '#') ADVANCE(908);
      if (lookahead == '$') ADVANCE(329);
      if (lookahead == '(') ADVANCE(429);
      if (lookahead == ')') ADVANCE(430);
      if (lookahead == ',') ADVANCE(468);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == ':') ADVANCE(384);
      if (lookahead == '=') ADVANCE(361);
      if (lookahead == 'E') ADVANCE(807);
      if (lookahead == 'O') ADVANCE(806);
      if (lookahead == '[') ADVANCE(372);
      if (lookahead == 'a') ADVANCE(817);
      if (lookahead == 'd') ADVANCE(820);
      if (lookahead == 'e') ADVANCE(878);
      if (lookahead == 'f') ADVANCE(809);
      if (lookahead == 'i') ADVANCE(844);
      if (lookahead == 'p') ADVANCE(879);
      if (lookahead == 'r') ADVANCE(821);
      if (lookahead == 'u') ADVANCE(845);
      if (lookahead == '}') ADVANCE(432);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(352);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(aux_sym_recipe_token1);
      if (lookahead == '\n') ADVANCE(354);
      if (lookahead == '\r') ADVANCE(1);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(aux_sym_recipe_token1);
      if (lookahead == '\n') ADVANCE(355);
      if (lookahead == '\r') ADVANCE(5);
      if (('\t' <= lookahead && lookahead <= '\f')) ADVANCE(6);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(aux_sym_recipe_token1);
      if (lookahead == '\n') ADVANCE(356);
      if (lookahead == '\r') ADVANCE(2);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(aux_sym_recipe_token1);
      if (lookahead == '\n') ADVANCE(357);
      if (lookahead == '\r') ADVANCE(3);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(aux_sym_recipe_token1);
      if (lookahead == '\n') ADVANCE(358);
      if (lookahead == '\r') ADVANCE(4);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_NULL);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_NULL);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(399);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '+') ADVANCE(369);
      if (lookahead == '.') ADVANCE(371);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '+') ADVANCE(369);
      if (lookahead == '.') ADVANCE(371);
      if (lookahead == '=') ADVANCE(564);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(564);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_QMARK_EQ);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_EQ_PLUS);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_DOT_EQ);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_EQ_DOT);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_noexec);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_noexec);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ']') ADVANCE(382);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(aux_sym_variable_flag_token1);
      if (lookahead == '#') ADVANCE(381);
      if (lookahead == 'n') ADVANCE(379);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f') ADVANCE(375);
      if (lookahead != 0 &&
          (lookahead < '\n' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ']') ADVANCE(382);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(aux_sym_variable_flag_token1);
      if (lookahead == 'c') ADVANCE(374);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ']') ADVANCE(382);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(aux_sym_variable_flag_token1);
      if (lookahead == 'e') ADVANCE(380);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ']') ADVANCE(382);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(aux_sym_variable_flag_token1);
      if (lookahead == 'e') ADVANCE(376);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ']') ADVANCE(382);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(aux_sym_variable_flag_token1);
      if (lookahead == 'o') ADVANCE(377);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ']') ADVANCE(382);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(aux_sym_variable_flag_token1);
      if (lookahead == 'x') ADVANCE(378);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ']') ADVANCE(382);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(aux_sym_variable_flag_token1);
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == ']') ADVANCE(908);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(381);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(aux_sym_variable_flag_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ']') ADVANCE(382);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(367);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_append);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_append);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_prepend);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_prepend);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_remove);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_remove);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_unset);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_unset);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_inherit);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_inherit_path);
      if (!eof && lookahead == 0) ADVANCE(360);
      if (lookahead == '\n') ADVANCE(355);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == '#') ADVANCE(398);
      if (lookahead == '$') ADVANCE(397);
      if (('\t' <= lookahead && lookahead <= '\f')) ADVANCE(395);
      if (lookahead != 0 &&
          lookahead != ' ') ADVANCE(399);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_inherit_path);
      if (lookahead == '#') ADVANCE(398);
      if (lookahead == '$') ADVANCE(397);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f') ADVANCE(396);
      if (lookahead != 0 &&
          (lookahead < '\n' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(399);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_inherit_path);
      if (lookahead == '{') ADVANCE(452);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(399);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_inherit_path);
      if (lookahead == '\r' ||
          lookahead == ' ') ADVANCE(908);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(398);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_inherit_path);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(399);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_INHERIT);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(31);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_include);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(aux_sym_include_directive_token1);
      if (lookahead == '#') ADVANCE(405);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f') ADVANCE(404);
      if (lookahead != 0 &&
          (lookahead < '\n' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(406);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(aux_sym_include_directive_token1);
      if (lookahead == '\r' ||
          lookahead == ' ') ADVANCE(908);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(405);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(aux_sym_include_directive_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(406);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_require);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_export);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_OVERRIDES);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_OVERRIDES);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_EXPORT_FUNCTIONS);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_EXPORT_FUNCTIONS);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_addtask);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym_addtask);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_after);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_after);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_before);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_before);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_deltask);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_addhandler);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_addhandler);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_fakeroot);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_fakeroot);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_python);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_python);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_python);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(436);
      if (lookahead == '\r') ADVANCE(433);
      if (lookahead == '\\') ADVANCE(434);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$') ADVANCE(433);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(436);
      if (lookahead == '\r') ADVANCE(433);
      if (lookahead == '\\') ADVANCE(434);
      if (lookahead != 0) ADVANCE(433);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(435);
      if (lookahead == '\r') ADVANCE(435);
      if (lookahead == '#') ADVANCE(433);
      if (lookahead == '\\') ADVANCE(437);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead)) ADVANCE(436);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(436);
      if (lookahead == '\r') ADVANCE(436);
      if (lookahead == '\\') ADVANCE(437);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(436);
      if (lookahead == '\r') ADVANCE(436);
      if (lookahead == '\\') ADVANCE(437);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_DOLLARBB_ENV_PASSTHROUGH);
      if (lookahead == '_') ADVANCE(90);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_DOLLARBB_ENV_PASSTHROUGH_ADDITIONS);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == 'B') ADVANCE(93);
      if (lookahead == '{') ADVANCE(451);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (lookahead == '\n') ADVANCE(447);
      if (lookahead == '\r') ADVANCE(443);
      if (lookahead == '\\') ADVANCE(905);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(443);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(444);
      if (lookahead == '\r') ADVANCE(444);
      if (lookahead == '"') ADVANCE(446);
      if (lookahead == '#') ADVANCE(443);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(447);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(447);
      if (lookahead == '\r') ADVANCE(447);
      if (lookahead == '"') ADVANCE(447);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(445);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == '"') ADVANCE(447);
      if (lookahead == '\r') ADVANCE(447);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(445);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(447);
      if (lookahead == '\r') ADVANCE(447);
      if (lookahead == '\\') ADVANCE(9);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE_AT);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE_AT);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(399);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      if (lookahead == '@') ADVANCE(448);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      if (lookahead == '@') ADVANCE(449);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(399);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_def);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_def);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_import);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_import);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(64);
      if (lookahead == '=') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(616);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(616);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_from);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym___future__);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym___future__);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'y') ADVANCE(704);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(252);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_as);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(551);
      if (lookahead == '=') ADVANCE(576);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(550);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(81);
      if (lookahead == '=') ADVANCE(576);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_print);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(582);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_assert);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_del);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_raise);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_raise);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_pass);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_break);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_continue);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym_global);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_exec);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_in);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym_if);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym_elif);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym_async);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_try);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_except);
      if (lookahead == '*') ADVANCE(520);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_except);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_except_STAR);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_finally);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_with);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_not);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_not);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_and);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_or);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(368);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(575);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(575);
      if (lookahead == '>') ADVANCE(456);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(575);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(578);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(549);
      if (lookahead == '=') ADVANCE(577);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(548);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(580);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(579);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(581);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(586);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(584);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(585);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(583);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(559);
      if (lookahead == '=') ADVANCE(563);
      if (lookahead == '>') ADVANCE(569);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(558);
      if (lookahead == '=') ADVANCE(563);
      if (lookahead == '>') ADVANCE(569);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(566);
      if (lookahead == '>') ADVANCE(480);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(566);
      if (lookahead == '>') ADVANCE(479);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(anon_sym_is);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(anon_sym_is);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(anon_sym_lambda);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(anon_sym_yield);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym__not_escape_sequence);
      if (sym_escape_sequence_character_set_1(lookahead)) ADVANCE(590);
      if (lookahead == '\r') ADVANCE(7);
      if (lookahead == 'N') ADVANCE(328);
      if (lookahead == 'U') ADVANCE(347);
      if (lookahead == 'u') ADVANCE(343);
      if (lookahead == 'x') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(338);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '#') ADVANCE(593);
      if (lookahead == '\t' ||
          (11 <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(592);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(593);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(593);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(anon_sym_await);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(anon_sym_match);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(619);
      if (lookahead == '_') ADVANCE(606);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(331);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(601);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(602);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(619);
      if (lookahead == '_') ADVANCE(607);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(785);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(614);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(619);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(145);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(150);
      if (lookahead == '_') ADVANCE(606);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(331);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(601);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(602);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(619);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(881);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(882);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(883);
      if (lookahead == '_') ADVANCE(607);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(785);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(614);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(619);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(331);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(601);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(602);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(619);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(785);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(614);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(603);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(332);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(601);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(608);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(335);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(601);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(609);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(898);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(614);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(610);
      if (lookahead == '-' ||
          ('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(899);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(614);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(611);
      if (lookahead == '-' ||
          lookahead == '8' ||
          lookahead == '9' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(901);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(614);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(612);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(340);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(601);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(613);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(619);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(331);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(615);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(616);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(620);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(615);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(617);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(621);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(622);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(618);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(331);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(615);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(616);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(615);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(617);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(622);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(618);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym_true);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym_false);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym_none);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '*') ADVANCE(520);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'a') ADVANCE(701);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'a') ADVANCE(753);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'a') ADVANCE(738);
      if (lookahead == 'r') ADVANCE(682);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'a') ADVANCE(684);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'a') ADVANCE(574);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'a') ADVANCE(689);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'a') ADVANCE(683);
      if (lookahead == 'e') ADVANCE(752);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'a') ADVANCE(686);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'a') ADVANCE(680);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'a') ADVANCE(687);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'a') ADVANCE(694);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'b') ADVANCE(651);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'b') ADVANCE(637);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'c') ADVANCE(499);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'c') ADVANCE(511);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'c') ADVANCE(674);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'c') ADVANCE(662);
      if (lookahead == 'e') ADVANCE(643);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'c') ADVANCE(667);
      if (lookahead == 'e') ADVANCE(643);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'c') ADVANCE(639);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'd') ADVANCE(588);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'd') ADVANCE(529);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'd') ADVANCE(634);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(671);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(643);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(628);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(624);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(600);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(626);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(487);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(515);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(493);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(509);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(724);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(734);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(690);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(633);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(685);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'e') ADVANCE(725);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'f') ADVANCE(504);
      if (lookahead == 'm') ADVANCE(722);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'f') ADVANCE(504);
      if (lookahead == 'n') ADVANCE(501);
      if (lookahead == 's') ADVANCE(571);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'f') ADVANCE(504);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'f') ADVANCE(454);
      if (lookahead == 'l') ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'f') ADVANCE(507);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'h') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'h') ADVANCE(598);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'h') ADVANCE(677);
      if (lookahead == 'i') ADVANCE(745);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'i') ADVANCE(672);
      if (lookahead == 's') ADVANCE(661);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'i') ADVANCE(695);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'i') ADVANCE(664);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'i') ADVANCE(710);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'i') ADVANCE(746);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'i') ADVANCE(711);
      if (lookahead == 'o') ADVANCE(728);
      if (lookahead == 'r') ADVANCE(716);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'i') ADVANCE(708);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'i') ADVANCE(742);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'k') ADVANCE(491);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(495);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(497);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(676);
      if (lookahead == 'x') ADVANCE(653);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(741);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(649);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(714);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(760);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(719);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(692);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(659);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(743);
      if (lookahead == 'x') ADVANCE(646);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(743);
      if (lookahead == 'x') ADVANCE(653);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'l') ADVANCE(743);
      if (lookahead == 'x') ADVANCE(647);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'm') ADVANCE(722);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'm') ADVANCE(465);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'm') ADVANCE(641);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'n') ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'n') ADVANCE(501);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'n') ADVANCE(644);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'n') ADVANCE(650);
      if (lookahead == 's') ADVANCE(470);
      if (lookahead == 'w') ADVANCE(638);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'n') ADVANCE(754);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'n') ADVANCE(654);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'n') ADVANCE(747);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'n') ADVANCE(693);
      if (lookahead == 't') ADVANCE(526);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'n') ADVANCE(757);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'n') ADVANCE(640);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'o') ADVANCE(707);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'o') ADVANCE(709);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'o') ADVANCE(642);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'o') ADVANCE(706);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'o') ADVANCE(700);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'o') ADVANCE(728);
      if (lookahead == 'r') ADVANCE(716);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'o') ADVANCE(728);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'o') ADVANCE(648);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'o') ADVANCE(744);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'o') ADVANCE(735);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'p') ADVANCE(721);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'p') ADVANCE(656);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'p') ADVANCE(750);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'p') ADVANCE(751);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'r') ADVANCE(756);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'r') ADVANCE(759);
      if (lookahead == 'y') ADVANCE(723);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'r') ADVANCE(513);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'r') ADVANCE(532);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'r') ADVANCE(665);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'r') ADVANCE(682);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'r') ADVANCE(716);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'r') ADVANCE(702);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'r') ADVANCE(748);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'r') ADVANCE(749);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 's') ADVANCE(740);
      if (lookahead == 'w') ADVANCE(638);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 's') ADVANCE(489);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 's') ADVANCE(737);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 's') ADVANCE(762);
      if (lookahead == 'w') ADVANCE(638);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 's') ADVANCE(663);
      if (lookahead == 'y') ADVANCE(704);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 's') ADVANCE(657);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 's') ADVANCE(658);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 's') ADVANCE(661);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 't') ADVANCE(526);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 't') ADVANCE(673);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 't') ADVANCE(596);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 't') ADVANCE(478);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 't') ADVANCE(481);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 't') ADVANCE(459);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 't') ADVANCE(519);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 't') ADVANCE(629);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 't') ADVANCE(755);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 't') ADVANCE(645);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 't') ADVANCE(679);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'u') ADVANCE(733);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'u') ADVANCE(655);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'u') ADVANCE(660);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'x') ADVANCE(653);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'y') ADVANCE(517);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'y') ADVANCE(522);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'y') ADVANCE(723);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (lookahead == 'y') ADVANCE(704);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '-') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(763);
      if (sym_python_identifier_character_set_5(lookahead)) ADVANCE(784);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '_') ADVANCE(770);
      if (sym_python_identifier_character_set_7(lookahead)) ADVANCE(784);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '_') ADVANCE(467);
      if (sym_python_identifier_character_set_7(lookahead)) ADVANCE(784);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == '_') ADVANCE(765);
      if (sym_python_identifier_character_set_7(lookahead)) ADVANCE(784);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'd') ADVANCE(530);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'e') ADVANCE(766);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'f') ADVANCE(505);
      if (lookahead == 'n') ADVANCE(502);
      if (lookahead == 's') ADVANCE(572);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'f') ADVANCE(783);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'm') ADVANCE(775);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'n') ADVANCE(767);
      if (lookahead == 's') ADVANCE(472);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'o') ADVANCE(779);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'o') ADVANCE(778);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'p') ADVANCE(774);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'r') ADVANCE(533);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'r') ADVANCE(768);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'r') ADVANCE(780);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 't') ADVANCE(527);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 't') ADVANCE(460);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 't') ADVANCE(782);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'u') ADVANCE(777);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(sym_python_identifier);
      if (lookahead == 'u') ADVANCE(781);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(sym_python_identifier);
      if (sym_python_identifier_character_set_6(lookahead)) ADVANCE(784);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '+') ADVANCE(337);
      if (lookahead == '-') ADVANCE(900);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(618);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'C') ADVANCE(804);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'D') ADVANCE(789);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'E') ADVANCE(800);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'E') ADVANCE(801);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'F') ADVANCE(805);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'I') ADVANCE(787);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'I') ADVANCE(796);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'N') ADVANCE(786);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'N') ADVANCE(802);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'O') ADVANCE(798);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'O') ADVANCE(794);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'P') ADVANCE(795);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'R') ADVANCE(803);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'R') ADVANCE(791);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'R') ADVANCE(799);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'S') ADVANCE(412);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'S') ADVANCE(414);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'T') ADVANCE(808);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'T') ADVANCE(792);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'U') ADVANCE(793);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'V') ADVANCE(788);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'X') ADVANCE(797);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '_') ADVANCE(790);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'a') ADVANCE(840);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'a') ADVANCE(866);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'a') ADVANCE(847);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'a') ADVANCE(867);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'c') ADVANCE(841);
      if (lookahead == 'h') ADVANCE(828);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'd') ADVANCE(834);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'd') ADVANCE(387);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'd') ADVANCE(389);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'd') ADVANCE(814);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'd') ADVANCE(842);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'd') ADVANCE(822);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(833);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(859);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(403);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(408);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(843);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(391);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(862);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(870);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(861);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(860);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(848);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(849);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'e') ADVANCE(858);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'f') ADVANCE(455);
      if (lookahead == 'l') ADVANCE(874);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'h') ADVANCE(811);
      if (lookahead == 't') ADVANCE(810);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'h') ADVANCE(852);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'i') ADVANCE(864);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'i') ADVANCE(872);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'k') ADVANCE(416);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'k') ADVANCE(421);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'k') ADVANCE(826);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'l') ADVANCE(876);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'l') ADVANCE(829);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'm') ADVANCE(851);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'n') ADVANCE(813);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'n') ADVANCE(868);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'n') ADVANCE(427);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'n') ADVANCE(818);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'n') ADVANCE(815);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'n') ADVANCE(816);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'o') ADVANCE(863);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'o') ADVANCE(877);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'o') ADVANCE(846);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'o') ADVANCE(854);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'o') ADVANCE(873);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'p') ADVANCE(850);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'p') ADVANCE(857);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'p') ADVANCE(830);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'p') ADVANCE(831);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'q') ADVANCE(875);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'r') ADVANCE(423);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'r') ADVANCE(837);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'r') ADVANCE(853);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'r') ADVANCE(871);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'r') ADVANCE(823);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'r') ADVANCE(832);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 's') ADVANCE(838);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 's') ADVANCE(839);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 's') ADVANCE(827);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 't') ADVANCE(835);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 't') ADVANCE(393);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 't') ADVANCE(410);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 't') ADVANCE(394);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 't') ADVANCE(425);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 't') ADVANCE(812);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'u') ADVANCE(836);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'u') ADVANCE(819);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'v') ADVANCE(825);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'x') ADVANCE(855);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == 'y') ADVANCE(869);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(904);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(880);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(898);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(610);
      if (lookahead == '-' ||
          ('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(899);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(611);
      if (lookahead == '-' ||
          lookahead == '8' ||
          lookahead == '9' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(901);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(612);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(893);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(420);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(888);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(895);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(892);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(891);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(428);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(890);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(894);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(885);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(884);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(889);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(896);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(610);
      if (lookahead == '-' ||
          ('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(611);
      if (lookahead == '-' ||
          lookahead == '8' ||
          lookahead == '9' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(618);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(612);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(902);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(aux_sym__dotted_identifier_token1);
      if (lookahead == '=') ADVANCE(370);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(904);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(aux_sym__dotted_identifier_token1);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(904);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(447);
      if (lookahead == '\r') ADVANCE(906);
      if (lookahead != 0) ADVANCE(908);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(447);
      if (lookahead != 0) ADVANCE(908);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r' ||
          lookahead == ' ') ADVANCE(908);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(398);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(908);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 352, .external_lex_state = 2},
  [2] = {.lex_state = 33, .external_lex_state = 3},
  [3] = {.lex_state = 33, .external_lex_state = 3},
  [4] = {.lex_state = 33, .external_lex_state = 3},
  [5] = {.lex_state = 33, .external_lex_state = 3},
  [6] = {.lex_state = 33, .external_lex_state = 3},
  [7] = {.lex_state = 33, .external_lex_state = 3},
  [8] = {.lex_state = 33, .external_lex_state = 3},
  [9] = {.lex_state = 33, .external_lex_state = 3},
  [10] = {.lex_state = 33, .external_lex_state = 3},
  [11] = {.lex_state = 33, .external_lex_state = 3},
  [12] = {.lex_state = 33, .external_lex_state = 3},
  [13] = {.lex_state = 33, .external_lex_state = 3},
  [14] = {.lex_state = 33, .external_lex_state = 3},
  [15] = {.lex_state = 33, .external_lex_state = 3},
  [16] = {.lex_state = 33, .external_lex_state = 3},
  [17] = {.lex_state = 33, .external_lex_state = 3},
  [18] = {.lex_state = 33, .external_lex_state = 3},
  [19] = {.lex_state = 33, .external_lex_state = 3},
  [20] = {.lex_state = 33, .external_lex_state = 3},
  [21] = {.lex_state = 33, .external_lex_state = 3},
  [22] = {.lex_state = 33, .external_lex_state = 3},
  [23] = {.lex_state = 33, .external_lex_state = 3},
  [24] = {.lex_state = 33, .external_lex_state = 3},
  [25] = {.lex_state = 33, .external_lex_state = 3},
  [26] = {.lex_state = 33, .external_lex_state = 3},
  [27] = {.lex_state = 33, .external_lex_state = 3},
  [28] = {.lex_state = 33, .external_lex_state = 3},
  [29] = {.lex_state = 33, .external_lex_state = 3},
  [30] = {.lex_state = 33, .external_lex_state = 3},
  [31] = {.lex_state = 33, .external_lex_state = 3},
  [32] = {.lex_state = 33, .external_lex_state = 3},
  [33] = {.lex_state = 33, .external_lex_state = 3},
  [34] = {.lex_state = 33, .external_lex_state = 3},
  [35] = {.lex_state = 33, .external_lex_state = 3},
  [36] = {.lex_state = 54, .external_lex_state = 4},
  [37] = {.lex_state = 21, .external_lex_state = 5},
  [38] = {.lex_state = 21, .external_lex_state = 5},
  [39] = {.lex_state = 54, .external_lex_state = 4},
  [40] = {.lex_state = 49, .external_lex_state = 4},
  [41] = {.lex_state = 49, .external_lex_state = 4},
  [42] = {.lex_state = 49, .external_lex_state = 4},
  [43] = {.lex_state = 49, .external_lex_state = 4},
  [44] = {.lex_state = 49, .external_lex_state = 4},
  [45] = {.lex_state = 49, .external_lex_state = 4},
  [46] = {.lex_state = 49, .external_lex_state = 4},
  [47] = {.lex_state = 49, .external_lex_state = 4},
  [48] = {.lex_state = 49, .external_lex_state = 4},
  [49] = {.lex_state = 49, .external_lex_state = 4},
  [50] = {.lex_state = 49, .external_lex_state = 4},
  [51] = {.lex_state = 49, .external_lex_state = 4},
  [52] = {.lex_state = 49, .external_lex_state = 4},
  [53] = {.lex_state = 49, .external_lex_state = 4},
  [54] = {.lex_state = 49, .external_lex_state = 4},
  [55] = {.lex_state = 49, .external_lex_state = 4},
  [56] = {.lex_state = 49, .external_lex_state = 4},
  [57] = {.lex_state = 49, .external_lex_state = 4},
  [58] = {.lex_state = 49, .external_lex_state = 4},
  [59] = {.lex_state = 49, .external_lex_state = 4},
  [60] = {.lex_state = 49, .external_lex_state = 4},
  [61] = {.lex_state = 49, .external_lex_state = 5},
  [62] = {.lex_state = 49, .external_lex_state = 5},
  [63] = {.lex_state = 49, .external_lex_state = 5},
  [64] = {.lex_state = 49, .external_lex_state = 5},
  [65] = {.lex_state = 49, .external_lex_state = 5},
  [66] = {.lex_state = 49, .external_lex_state = 5},
  [67] = {.lex_state = 49, .external_lex_state = 5},
  [68] = {.lex_state = 49, .external_lex_state = 5},
  [69] = {.lex_state = 49, .external_lex_state = 5},
  [70] = {.lex_state = 49, .external_lex_state = 5},
  [71] = {.lex_state = 49, .external_lex_state = 5},
  [72] = {.lex_state = 49, .external_lex_state = 5},
  [73] = {.lex_state = 49, .external_lex_state = 5},
  [74] = {.lex_state = 49, .external_lex_state = 5},
  [75] = {.lex_state = 49, .external_lex_state = 5},
  [76] = {.lex_state = 49, .external_lex_state = 5},
  [77] = {.lex_state = 49, .external_lex_state = 5},
  [78] = {.lex_state = 49, .external_lex_state = 5},
  [79] = {.lex_state = 49, .external_lex_state = 6},
  [80] = {.lex_state = 22, .external_lex_state = 5},
  [81] = {.lex_state = 22, .external_lex_state = 5},
  [82] = {.lex_state = 23, .external_lex_state = 5},
  [83] = {.lex_state = 12, .external_lex_state = 7},
  [84] = {.lex_state = 12, .external_lex_state = 7},
  [85] = {.lex_state = 12, .external_lex_state = 5},
  [86] = {.lex_state = 13, .external_lex_state = 5},
  [87] = {.lex_state = 13, .external_lex_state = 7},
  [88] = {.lex_state = 25, .external_lex_state = 7},
  [89] = {.lex_state = 13, .external_lex_state = 5},
  [90] = {.lex_state = 25, .external_lex_state = 8},
  [91] = {.lex_state = 29, .external_lex_state = 5},
  [92] = {.lex_state = 13, .external_lex_state = 7},
  [93] = {.lex_state = 12, .external_lex_state = 8},
  [94] = {.lex_state = 25, .external_lex_state = 7},
  [95] = {.lex_state = 25, .external_lex_state = 8},
  [96] = {.lex_state = 29, .external_lex_state = 5},
  [97] = {.lex_state = 25, .external_lex_state = 8},
  [98] = {.lex_state = 37, .external_lex_state = 5},
  [99] = {.lex_state = 13, .external_lex_state = 8},
  [100] = {.lex_state = 37, .external_lex_state = 5},
  [101] = {.lex_state = 29, .external_lex_state = 5},
  [102] = {.lex_state = 28, .external_lex_state = 7},
  [103] = {.lex_state = 12, .external_lex_state = 8},
  [104] = {.lex_state = 12, .external_lex_state = 9},
  [105] = {.lex_state = 13, .external_lex_state = 8},
  [106] = {.lex_state = 25, .external_lex_state = 9},
  [107] = {.lex_state = 25, .external_lex_state = 9},
  [108] = {.lex_state = 25, .external_lex_state = 8},
  [109] = {.lex_state = 28, .external_lex_state = 7},
  [110] = {.lex_state = 25, .external_lex_state = 9},
  [111] = {.lex_state = 12, .external_lex_state = 6},
  [112] = {.lex_state = 25, .external_lex_state = 8},
  [113] = {.lex_state = 25, .external_lex_state = 9},
  [114] = {.lex_state = 25, .external_lex_state = 8},
  [115] = {.lex_state = 12, .external_lex_state = 8},
  [116] = {.lex_state = 13, .external_lex_state = 9},
  [117] = {.lex_state = 13, .external_lex_state = 6},
  [118] = {.lex_state = 13, .external_lex_state = 9},
  [119] = {.lex_state = 13, .external_lex_state = 6},
  [120] = {.lex_state = 12, .external_lex_state = 7},
  [121] = {.lex_state = 12, .external_lex_state = 9},
  [122] = {.lex_state = 25, .external_lex_state = 9},
  [123] = {.lex_state = 30, .external_lex_state = 6},
  [124] = {.lex_state = 37, .external_lex_state = 6},
  [125] = {.lex_state = 37, .external_lex_state = 6},
  [126] = {.lex_state = 30, .external_lex_state = 6},
  [127] = {.lex_state = 30, .external_lex_state = 6},
  [128] = {.lex_state = 41, .external_lex_state = 6},
  [129] = {.lex_state = 41, .external_lex_state = 9},
  [130] = {.lex_state = 41, .external_lex_state = 8},
  [131] = {.lex_state = 41, .external_lex_state = 8},
  [132] = {.lex_state = 41, .external_lex_state = 9},
  [133] = {.lex_state = 41, .external_lex_state = 6},
  [134] = {.lex_state = 41, .external_lex_state = 8},
  [135] = {.lex_state = 53, .external_lex_state = 7},
  [136] = {.lex_state = 41, .external_lex_state = 9},
  [137] = {.lex_state = 41, .external_lex_state = 9},
  [138] = {.lex_state = 53, .external_lex_state = 7},
  [139] = {.lex_state = 41, .external_lex_state = 8},
  [140] = {.lex_state = 53, .external_lex_state = 7},
  [141] = {.lex_state = 41, .external_lex_state = 8},
  [142] = {.lex_state = 41, .external_lex_state = 8},
  [143] = {.lex_state = 41, .external_lex_state = 9},
  [144] = {.lex_state = 41, .external_lex_state = 9},
  [145] = {.lex_state = 53, .external_lex_state = 7},
  [146] = {.lex_state = 53, .external_lex_state = 7},
  [147] = {.lex_state = 41, .external_lex_state = 8},
  [148] = {.lex_state = 41, .external_lex_state = 9},
  [149] = {.lex_state = 53, .external_lex_state = 7},
  [150] = {.lex_state = 53, .external_lex_state = 7},
  [151] = {.lex_state = 41, .external_lex_state = 9},
  [152] = {.lex_state = 53, .external_lex_state = 7},
  [153] = {.lex_state = 41, .external_lex_state = 8},
  [154] = {.lex_state = 41, .external_lex_state = 9},
  [155] = {.lex_state = 41, .external_lex_state = 9},
  [156] = {.lex_state = 41, .external_lex_state = 9},
  [157] = {.lex_state = 41, .external_lex_state = 8},
  [158] = {.lex_state = 41, .external_lex_state = 6},
  [159] = {.lex_state = 41, .external_lex_state = 8},
  [160] = {.lex_state = 41, .external_lex_state = 8},
  [161] = {.lex_state = 39, .external_lex_state = 5},
  [162] = {.lex_state = 39, .external_lex_state = 5},
  [163] = {.lex_state = 41, .external_lex_state = 6},
  [164] = {.lex_state = 41, .external_lex_state = 6},
  [165] = {.lex_state = 42, .external_lex_state = 6},
  [166] = {.lex_state = 17, .external_lex_state = 7},
  [167] = {.lex_state = 42, .external_lex_state = 8},
  [168] = {.lex_state = 42, .external_lex_state = 8},
  [169] = {.lex_state = 42, .external_lex_state = 6},
  [170] = {.lex_state = 42, .external_lex_state = 6},
  [171] = {.lex_state = 42, .external_lex_state = 6},
  [172] = {.lex_state = 42, .external_lex_state = 6},
  [173] = {.lex_state = 39, .external_lex_state = 6},
  [174] = {.lex_state = 39, .external_lex_state = 6},
  [175] = {.lex_state = 42, .external_lex_state = 6},
  [176] = {.lex_state = 42, .external_lex_state = 6},
  [177] = {.lex_state = 42, .external_lex_state = 6},
  [178] = {.lex_state = 42, .external_lex_state = 8},
  [179] = {.lex_state = 42, .external_lex_state = 6},
  [180] = {.lex_state = 42, .external_lex_state = 6},
  [181] = {.lex_state = 42, .external_lex_state = 8},
  [182] = {.lex_state = 42, .external_lex_state = 8},
  [183] = {.lex_state = 42, .external_lex_state = 8},
  [184] = {.lex_state = 42, .external_lex_state = 6},
  [185] = {.lex_state = 42, .external_lex_state = 6},
  [186] = {.lex_state = 42, .external_lex_state = 6},
  [187] = {.lex_state = 42, .external_lex_state = 6},
  [188] = {.lex_state = 42, .external_lex_state = 6},
  [189] = {.lex_state = 42, .external_lex_state = 8},
  [190] = {.lex_state = 41, .external_lex_state = 8},
  [191] = {.lex_state = 42, .external_lex_state = 6},
  [192] = {.lex_state = 42, .external_lex_state = 8},
  [193] = {.lex_state = 42, .external_lex_state = 6},
  [194] = {.lex_state = 42, .external_lex_state = 6},
  [195] = {.lex_state = 41, .external_lex_state = 9},
  [196] = {.lex_state = 42, .external_lex_state = 8},
  [197] = {.lex_state = 42, .external_lex_state = 8},
  [198] = {.lex_state = 42, .external_lex_state = 8},
  [199] = {.lex_state = 42, .external_lex_state = 8},
  [200] = {.lex_state = 42, .external_lex_state = 8},
  [201] = {.lex_state = 42, .external_lex_state = 8},
  [202] = {.lex_state = 41, .external_lex_state = 8},
  [203] = {.lex_state = 41, .external_lex_state = 9},
  [204] = {.lex_state = 42, .external_lex_state = 8},
  [205] = {.lex_state = 42, .external_lex_state = 8},
  [206] = {.lex_state = 41, .external_lex_state = 8},
  [207] = {.lex_state = 41, .external_lex_state = 9},
  [208] = {.lex_state = 42, .external_lex_state = 8},
  [209] = {.lex_state = 42, .external_lex_state = 8},
  [210] = {.lex_state = 41, .external_lex_state = 8},
  [211] = {.lex_state = 42, .external_lex_state = 8},
  [212] = {.lex_state = 41, .external_lex_state = 8},
  [213] = {.lex_state = 41, .external_lex_state = 8},
  [214] = {.lex_state = 42, .external_lex_state = 8},
  [215] = {.lex_state = 42, .external_lex_state = 8},
  [216] = {.lex_state = 41, .external_lex_state = 8},
  [217] = {.lex_state = 41, .external_lex_state = 8},
  [218] = {.lex_state = 41, .external_lex_state = 9},
  [219] = {.lex_state = 42, .external_lex_state = 8},
  [220] = {.lex_state = 42, .external_lex_state = 8},
  [221] = {.lex_state = 42, .external_lex_state = 8},
  [222] = {.lex_state = 42, .external_lex_state = 8},
  [223] = {.lex_state = 42, .external_lex_state = 8},
  [224] = {.lex_state = 41, .external_lex_state = 8},
  [225] = {.lex_state = 42, .external_lex_state = 8},
  [226] = {.lex_state = 42, .external_lex_state = 8},
  [227] = {.lex_state = 42, .external_lex_state = 8},
  [228] = {.lex_state = 41, .external_lex_state = 9},
  [229] = {.lex_state = 41, .external_lex_state = 8},
  [230] = {.lex_state = 42, .external_lex_state = 8},
  [231] = {.lex_state = 42, .external_lex_state = 8},
  [232] = {.lex_state = 42, .external_lex_state = 8},
  [233] = {.lex_state = 42, .external_lex_state = 8},
  [234] = {.lex_state = 42, .external_lex_state = 8},
  [235] = {.lex_state = 42, .external_lex_state = 8},
  [236] = {.lex_state = 42, .external_lex_state = 8},
  [237] = {.lex_state = 41, .external_lex_state = 9},
  [238] = {.lex_state = 41, .external_lex_state = 8},
  [239] = {.lex_state = 42, .external_lex_state = 8},
  [240] = {.lex_state = 42, .external_lex_state = 8},
  [241] = {.lex_state = 42, .external_lex_state = 8},
  [242] = {.lex_state = 42, .external_lex_state = 8},
  [243] = {.lex_state = 41, .external_lex_state = 9},
  [244] = {.lex_state = 41, .external_lex_state = 8},
  [245] = {.lex_state = 41, .external_lex_state = 8},
  [246] = {.lex_state = 41, .external_lex_state = 8},
  [247] = {.lex_state = 41, .external_lex_state = 9},
  [248] = {.lex_state = 41, .external_lex_state = 8},
  [249] = {.lex_state = 40, .external_lex_state = 9},
  [250] = {.lex_state = 40, .external_lex_state = 7},
  [251] = {.lex_state = 40, .external_lex_state = 9},
  [252] = {.lex_state = 41, .external_lex_state = 8},
  [253] = {.lex_state = 16, .external_lex_state = 7},
  [254] = {.lex_state = 40, .external_lex_state = 7},
  [255] = {.lex_state = 40, .external_lex_state = 7},
  [256] = {.lex_state = 18, .external_lex_state = 7},
  [257] = {.lex_state = 41, .external_lex_state = 8},
  [258] = {.lex_state = 40, .external_lex_state = 7},
  [259] = {.lex_state = 18, .external_lex_state = 7},
  [260] = {.lex_state = 40, .external_lex_state = 8},
  [261] = {.lex_state = 41, .external_lex_state = 9},
  [262] = {.lex_state = 40, .external_lex_state = 9},
  [263] = {.lex_state = 41, .external_lex_state = 7},
  [264] = {.lex_state = 40, .external_lex_state = 9},
  [265] = {.lex_state = 16, .external_lex_state = 7},
  [266] = {.lex_state = 41, .external_lex_state = 7},
  [267] = {.lex_state = 41, .external_lex_state = 9},
  [268] = {.lex_state = 42, .external_lex_state = 6},
  [269] = {.lex_state = 40, .external_lex_state = 8},
  [270] = {.lex_state = 40, .external_lex_state = 8},
  [271] = {.lex_state = 40, .external_lex_state = 8},
  [272] = {.lex_state = 42, .external_lex_state = 7},
  [273] = {.lex_state = 42, .external_lex_state = 7},
  [274] = {.lex_state = 42, .external_lex_state = 7},
  [275] = {.lex_state = 42, .external_lex_state = 7},
  [276] = {.lex_state = 42, .external_lex_state = 7},
  [277] = {.lex_state = 42, .external_lex_state = 7},
  [278] = {.lex_state = 41, .external_lex_state = 6},
  [279] = {.lex_state = 42, .external_lex_state = 7},
  [280] = {.lex_state = 42, .external_lex_state = 7},
  [281] = {.lex_state = 17, .external_lex_state = 9},
  [282] = {.lex_state = 42, .external_lex_state = 7},
  [283] = {.lex_state = 42, .external_lex_state = 7},
  [284] = {.lex_state = 41, .external_lex_state = 6},
  [285] = {.lex_state = 42, .external_lex_state = 7},
  [286] = {.lex_state = 42, .external_lex_state = 7},
  [287] = {.lex_state = 42, .external_lex_state = 7},
  [288] = {.lex_state = 42, .external_lex_state = 7},
  [289] = {.lex_state = 42, .external_lex_state = 7},
  [290] = {.lex_state = 41, .external_lex_state = 6},
  [291] = {.lex_state = 17, .external_lex_state = 5},
  [292] = {.lex_state = 42, .external_lex_state = 7},
  [293] = {.lex_state = 17, .external_lex_state = 5},
  [294] = {.lex_state = 17, .external_lex_state = 8},
  [295] = {.lex_state = 18, .external_lex_state = 9},
  [296] = {.lex_state = 17, .external_lex_state = 5},
  [297] = {.lex_state = 18, .external_lex_state = 9},
  [298] = {.lex_state = 18, .external_lex_state = 9},
  [299] = {.lex_state = 18, .external_lex_state = 9},
  [300] = {.lex_state = 18, .external_lex_state = 9},
  [301] = {.lex_state = 18, .external_lex_state = 9},
  [302] = {.lex_state = 18, .external_lex_state = 5},
  [303] = {.lex_state = 18, .external_lex_state = 9},
  [304] = {.lex_state = 42, .external_lex_state = 6},
  [305] = {.lex_state = 18, .external_lex_state = 9},
  [306] = {.lex_state = 18, .external_lex_state = 9},
  [307] = {.lex_state = 18, .external_lex_state = 9},
  [308] = {.lex_state = 18, .external_lex_state = 9},
  [309] = {.lex_state = 18, .external_lex_state = 9},
  [310] = {.lex_state = 18, .external_lex_state = 9},
  [311] = {.lex_state = 18, .external_lex_state = 9},
  [312] = {.lex_state = 18, .external_lex_state = 9},
  [313] = {.lex_state = 18, .external_lex_state = 9},
  [314] = {.lex_state = 18, .external_lex_state = 9},
  [315] = {.lex_state = 16, .external_lex_state = 8},
  [316] = {.lex_state = 18, .external_lex_state = 9},
  [317] = {.lex_state = 18, .external_lex_state = 9},
  [318] = {.lex_state = 18, .external_lex_state = 9},
  [319] = {.lex_state = 18, .external_lex_state = 9},
  [320] = {.lex_state = 18, .external_lex_state = 9},
  [321] = {.lex_state = 16, .external_lex_state = 8},
  [322] = {.lex_state = 18, .external_lex_state = 9},
  [323] = {.lex_state = 18, .external_lex_state = 9},
  [324] = {.lex_state = 18, .external_lex_state = 9},
  [325] = {.lex_state = 18, .external_lex_state = 9},
  [326] = {.lex_state = 18, .external_lex_state = 9},
  [327] = {.lex_state = 18, .external_lex_state = 9},
  [328] = {.lex_state = 18, .external_lex_state = 9},
  [329] = {.lex_state = 18, .external_lex_state = 9},
  [330] = {.lex_state = 17, .external_lex_state = 5},
  [331] = {.lex_state = 18, .external_lex_state = 9},
  [332] = {.lex_state = 18, .external_lex_state = 9},
  [333] = {.lex_state = 18, .external_lex_state = 8},
  [334] = {.lex_state = 18, .external_lex_state = 6},
  [335] = {.lex_state = 18, .external_lex_state = 6},
  [336] = {.lex_state = 18, .external_lex_state = 8},
  [337] = {.lex_state = 18, .external_lex_state = 6},
  [338] = {.lex_state = 16, .external_lex_state = 9},
  [339] = {.lex_state = 18, .external_lex_state = 5},
  [340] = {.lex_state = 16, .external_lex_state = 8},
  [341] = {.lex_state = 18, .external_lex_state = 6},
  [342] = {.lex_state = 38, .external_lex_state = 6},
  [343] = {.lex_state = 18, .external_lex_state = 6},
  [344] = {.lex_state = 18, .external_lex_state = 6},
  [345] = {.lex_state = 18, .external_lex_state = 5},
  [346] = {.lex_state = 18, .external_lex_state = 5},
  [347] = {.lex_state = 18, .external_lex_state = 6},
  [348] = {.lex_state = 18, .external_lex_state = 6},
  [349] = {.lex_state = 16, .external_lex_state = 6},
  [350] = {.lex_state = 18, .external_lex_state = 6},
  [351] = {.lex_state = 18, .external_lex_state = 6},
  [352] = {.lex_state = 18, .external_lex_state = 6},
  [353] = {.lex_state = 18, .external_lex_state = 6},
  [354] = {.lex_state = 18, .external_lex_state = 5},
  [355] = {.lex_state = 18, .external_lex_state = 6},
  [356] = {.lex_state = 18, .external_lex_state = 9},
  [357] = {.lex_state = 18, .external_lex_state = 6},
  [358] = {.lex_state = 18, .external_lex_state = 6},
  [359] = {.lex_state = 18, .external_lex_state = 6},
  [360] = {.lex_state = 18, .external_lex_state = 5},
  [361] = {.lex_state = 18, .external_lex_state = 6},
  [362] = {.lex_state = 18, .external_lex_state = 5},
  [363] = {.lex_state = 18, .external_lex_state = 5},
  [364] = {.lex_state = 18, .external_lex_state = 6},
  [365] = {.lex_state = 18, .external_lex_state = 6},
  [366] = {.lex_state = 18, .external_lex_state = 6},
  [367] = {.lex_state = 18, .external_lex_state = 6},
  [368] = {.lex_state = 18, .external_lex_state = 5},
  [369] = {.lex_state = 18, .external_lex_state = 9},
  [370] = {.lex_state = 18, .external_lex_state = 6},
  [371] = {.lex_state = 18, .external_lex_state = 6},
  [372] = {.lex_state = 18, .external_lex_state = 6},
  [373] = {.lex_state = 16, .external_lex_state = 8},
  [374] = {.lex_state = 18, .external_lex_state = 8},
  [375] = {.lex_state = 18, .external_lex_state = 8},
  [376] = {.lex_state = 18, .external_lex_state = 6},
  [377] = {.lex_state = 18, .external_lex_state = 9},
  [378] = {.lex_state = 16, .external_lex_state = 6},
  [379] = {.lex_state = 18, .external_lex_state = 9},
  [380] = {.lex_state = 18, .external_lex_state = 9},
  [381] = {.lex_state = 18, .external_lex_state = 6},
  [382] = {.lex_state = 38, .external_lex_state = 6},
  [383] = {.lex_state = 18, .external_lex_state = 6},
  [384] = {.lex_state = 16, .external_lex_state = 9},
  [385] = {.lex_state = 18, .external_lex_state = 6},
  [386] = {.lex_state = 18, .external_lex_state = 6},
  [387] = {.lex_state = 18, .external_lex_state = 6},
  [388] = {.lex_state = 18, .external_lex_state = 6},
  [389] = {.lex_state = 18, .external_lex_state = 6},
  [390] = {.lex_state = 18, .external_lex_state = 6},
  [391] = {.lex_state = 18, .external_lex_state = 6},
  [392] = {.lex_state = 18, .external_lex_state = 6},
  [393] = {.lex_state = 18, .external_lex_state = 6},
  [394] = {.lex_state = 18, .external_lex_state = 6},
  [395] = {.lex_state = 18, .external_lex_state = 6},
  [396] = {.lex_state = 18, .external_lex_state = 6},
  [397] = {.lex_state = 18, .external_lex_state = 6},
  [398] = {.lex_state = 18, .external_lex_state = 6},
  [399] = {.lex_state = 18, .external_lex_state = 6},
  [400] = {.lex_state = 18, .external_lex_state = 6},
  [401] = {.lex_state = 18, .external_lex_state = 6},
  [402] = {.lex_state = 18, .external_lex_state = 6},
  [403] = {.lex_state = 18, .external_lex_state = 6},
  [404] = {.lex_state = 18, .external_lex_state = 6},
  [405] = {.lex_state = 18, .external_lex_state = 6},
  [406] = {.lex_state = 18, .external_lex_state = 6},
  [407] = {.lex_state = 18, .external_lex_state = 6},
  [408] = {.lex_state = 18, .external_lex_state = 6},
  [409] = {.lex_state = 18, .external_lex_state = 6},
  [410] = {.lex_state = 18, .external_lex_state = 6},
  [411] = {.lex_state = 18, .external_lex_state = 6},
  [412] = {.lex_state = 18, .external_lex_state = 6},
  [413] = {.lex_state = 18, .external_lex_state = 6},
  [414] = {.lex_state = 18, .external_lex_state = 6},
  [415] = {.lex_state = 18, .external_lex_state = 6},
  [416] = {.lex_state = 18, .external_lex_state = 6},
  [417] = {.lex_state = 18, .external_lex_state = 6},
  [418] = {.lex_state = 18, .external_lex_state = 6},
  [419] = {.lex_state = 18, .external_lex_state = 6},
  [420] = {.lex_state = 18, .external_lex_state = 6},
  [421] = {.lex_state = 18, .external_lex_state = 6},
  [422] = {.lex_state = 18, .external_lex_state = 6},
  [423] = {.lex_state = 18, .external_lex_state = 6},
  [424] = {.lex_state = 18, .external_lex_state = 6},
  [425] = {.lex_state = 18, .external_lex_state = 6},
  [426] = {.lex_state = 18, .external_lex_state = 6},
  [427] = {.lex_state = 18, .external_lex_state = 6},
  [428] = {.lex_state = 18, .external_lex_state = 6},
  [429] = {.lex_state = 18, .external_lex_state = 6},
  [430] = {.lex_state = 18, .external_lex_state = 6},
  [431] = {.lex_state = 18, .external_lex_state = 6},
  [432] = {.lex_state = 18, .external_lex_state = 6},
  [433] = {.lex_state = 18, .external_lex_state = 6},
  [434] = {.lex_state = 18, .external_lex_state = 6},
  [435] = {.lex_state = 18, .external_lex_state = 6},
  [436] = {.lex_state = 18, .external_lex_state = 6},
  [437] = {.lex_state = 18, .external_lex_state = 6},
  [438] = {.lex_state = 18, .external_lex_state = 6},
  [439] = {.lex_state = 18, .external_lex_state = 6},
  [440] = {.lex_state = 18, .external_lex_state = 6},
  [441] = {.lex_state = 18, .external_lex_state = 6},
  [442] = {.lex_state = 18, .external_lex_state = 6},
  [443] = {.lex_state = 18, .external_lex_state = 6},
  [444] = {.lex_state = 18, .external_lex_state = 6},
  [445] = {.lex_state = 18, .external_lex_state = 6},
  [446] = {.lex_state = 18, .external_lex_state = 6},
  [447] = {.lex_state = 18, .external_lex_state = 6},
  [448] = {.lex_state = 18, .external_lex_state = 6},
  [449] = {.lex_state = 18, .external_lex_state = 6},
  [450] = {.lex_state = 18, .external_lex_state = 6},
  [451] = {.lex_state = 18, .external_lex_state = 6},
  [452] = {.lex_state = 18, .external_lex_state = 6},
  [453] = {.lex_state = 18, .external_lex_state = 6},
  [454] = {.lex_state = 18, .external_lex_state = 6},
  [455] = {.lex_state = 18, .external_lex_state = 6},
  [456] = {.lex_state = 18, .external_lex_state = 6},
  [457] = {.lex_state = 18, .external_lex_state = 6},
  [458] = {.lex_state = 18, .external_lex_state = 6},
  [459] = {.lex_state = 18, .external_lex_state = 6},
  [460] = {.lex_state = 18, .external_lex_state = 6},
  [461] = {.lex_state = 18, .external_lex_state = 6},
  [462] = {.lex_state = 18, .external_lex_state = 6},
  [463] = {.lex_state = 18, .external_lex_state = 6},
  [464] = {.lex_state = 24, .external_lex_state = 5},
  [465] = {.lex_state = 18, .external_lex_state = 6},
  [466] = {.lex_state = 18, .external_lex_state = 6},
  [467] = {.lex_state = 18, .external_lex_state = 6},
  [468] = {.lex_state = 18, .external_lex_state = 6},
  [469] = {.lex_state = 18, .external_lex_state = 6},
  [470] = {.lex_state = 18, .external_lex_state = 6},
  [471] = {.lex_state = 18, .external_lex_state = 6},
  [472] = {.lex_state = 18, .external_lex_state = 6},
  [473] = {.lex_state = 18, .external_lex_state = 6},
  [474] = {.lex_state = 18, .external_lex_state = 6},
  [475] = {.lex_state = 18, .external_lex_state = 6},
  [476] = {.lex_state = 18, .external_lex_state = 6},
  [477] = {.lex_state = 18, .external_lex_state = 6},
  [478] = {.lex_state = 16, .external_lex_state = 6},
  [479] = {.lex_state = 18, .external_lex_state = 6},
  [480] = {.lex_state = 18, .external_lex_state = 6},
  [481] = {.lex_state = 18, .external_lex_state = 6},
  [482] = {.lex_state = 18, .external_lex_state = 6},
  [483] = {.lex_state = 18, .external_lex_state = 6},
  [484] = {.lex_state = 16, .external_lex_state = 6},
  [485] = {.lex_state = 18, .external_lex_state = 6},
  [486] = {.lex_state = 18, .external_lex_state = 6},
  [487] = {.lex_state = 18, .external_lex_state = 6},
  [488] = {.lex_state = 18, .external_lex_state = 6},
  [489] = {.lex_state = 18, .external_lex_state = 6},
  [490] = {.lex_state = 18, .external_lex_state = 6},
  [491] = {.lex_state = 18, .external_lex_state = 6},
  [492] = {.lex_state = 18, .external_lex_state = 6},
  [493] = {.lex_state = 18, .external_lex_state = 6},
  [494] = {.lex_state = 18, .external_lex_state = 6},
  [495] = {.lex_state = 18, .external_lex_state = 6},
  [496] = {.lex_state = 18, .external_lex_state = 6},
  [497] = {.lex_state = 18, .external_lex_state = 6},
  [498] = {.lex_state = 18, .external_lex_state = 6},
  [499] = {.lex_state = 18, .external_lex_state = 6},
  [500] = {.lex_state = 18, .external_lex_state = 6},
  [501] = {.lex_state = 18, .external_lex_state = 6},
  [502] = {.lex_state = 18, .external_lex_state = 6},
  [503] = {.lex_state = 18, .external_lex_state = 6},
  [504] = {.lex_state = 18, .external_lex_state = 6},
  [505] = {.lex_state = 18, .external_lex_state = 6},
  [506] = {.lex_state = 18, .external_lex_state = 6},
  [507] = {.lex_state = 18, .external_lex_state = 6},
  [508] = {.lex_state = 18, .external_lex_state = 6},
  [509] = {.lex_state = 18, .external_lex_state = 6},
  [510] = {.lex_state = 18, .external_lex_state = 6},
  [511] = {.lex_state = 18, .external_lex_state = 6},
  [512] = {.lex_state = 18, .external_lex_state = 6},
  [513] = {.lex_state = 18, .external_lex_state = 6},
  [514] = {.lex_state = 18, .external_lex_state = 6},
  [515] = {.lex_state = 18, .external_lex_state = 6},
  [516] = {.lex_state = 18, .external_lex_state = 6},
  [517] = {.lex_state = 18, .external_lex_state = 6},
  [518] = {.lex_state = 18, .external_lex_state = 6},
  [519] = {.lex_state = 24, .external_lex_state = 5},
  [520] = {.lex_state = 18, .external_lex_state = 6},
  [521] = {.lex_state = 18, .external_lex_state = 6},
  [522] = {.lex_state = 18, .external_lex_state = 6},
  [523] = {.lex_state = 18, .external_lex_state = 6},
  [524] = {.lex_state = 18, .external_lex_state = 6},
  [525] = {.lex_state = 18, .external_lex_state = 6},
  [526] = {.lex_state = 18, .external_lex_state = 6},
  [527] = {.lex_state = 18, .external_lex_state = 6},
  [528] = {.lex_state = 18, .external_lex_state = 6},
  [529] = {.lex_state = 18, .external_lex_state = 6},
  [530] = {.lex_state = 18, .external_lex_state = 6},
  [531] = {.lex_state = 18, .external_lex_state = 6},
  [532] = {.lex_state = 18, .external_lex_state = 6},
  [533] = {.lex_state = 18, .external_lex_state = 6},
  [534] = {.lex_state = 18, .external_lex_state = 6},
  [535] = {.lex_state = 18, .external_lex_state = 6},
  [536] = {.lex_state = 20, .external_lex_state = 10},
  [537] = {.lex_state = 20, .external_lex_state = 10},
  [538] = {.lex_state = 46, .external_lex_state = 3},
  [539] = {.lex_state = 48, .external_lex_state = 3},
  [540] = {.lex_state = 46, .external_lex_state = 3},
  [541] = {.lex_state = 48, .external_lex_state = 3},
  [542] = {.lex_state = 20, .external_lex_state = 10},
  [543] = {.lex_state = 20, .external_lex_state = 10},
  [544] = {.lex_state = 20, .external_lex_state = 10},
  [545] = {.lex_state = 20, .external_lex_state = 10},
  [546] = {.lex_state = 20, .external_lex_state = 10},
  [547] = {.lex_state = 11, .external_lex_state = 10},
  [548] = {.lex_state = 19, .external_lex_state = 7},
  [549] = {.lex_state = 47, .external_lex_state = 3},
  [550] = {.lex_state = 11, .external_lex_state = 10},
  [551] = {.lex_state = 11, .external_lex_state = 10},
  [552] = {.lex_state = 11, .external_lex_state = 10},
  [553] = {.lex_state = 48, .external_lex_state = 3},
  [554] = {.lex_state = 11, .external_lex_state = 10},
  [555] = {.lex_state = 11, .external_lex_state = 10},
  [556] = {.lex_state = 11, .external_lex_state = 10},
  [557] = {.lex_state = 47, .external_lex_state = 3},
  [558] = {.lex_state = 47, .external_lex_state = 3},
  [559] = {.lex_state = 11, .external_lex_state = 10},
  [560] = {.lex_state = 11, .external_lex_state = 10},
  [561] = {.lex_state = 11, .external_lex_state = 10},
  [562] = {.lex_state = 47, .external_lex_state = 3},
  [563] = {.lex_state = 11, .external_lex_state = 10},
  [564] = {.lex_state = 11, .external_lex_state = 10},
  [565] = {.lex_state = 11, .external_lex_state = 10},
  [566] = {.lex_state = 11, .external_lex_state = 10},
  [567] = {.lex_state = 11, .external_lex_state = 10},
  [568] = {.lex_state = 46, .external_lex_state = 3},
  [569] = {.lex_state = 11, .external_lex_state = 10},
  [570] = {.lex_state = 11, .external_lex_state = 10},
  [571] = {.lex_state = 11, .external_lex_state = 10},
  [572] = {.lex_state = 19, .external_lex_state = 7},
  [573] = {.lex_state = 11, .external_lex_state = 10},
  [574] = {.lex_state = 47, .external_lex_state = 3},
  [575] = {.lex_state = 46, .external_lex_state = 3},
  [576] = {.lex_state = 48, .external_lex_state = 3},
  [577] = {.lex_state = 48, .external_lex_state = 3},
  [578] = {.lex_state = 19, .external_lex_state = 8},
  [579] = {.lex_state = 48, .external_lex_state = 3},
  [580] = {.lex_state = 48, .external_lex_state = 3},
  [581] = {.lex_state = 46, .external_lex_state = 3},
  [582] = {.lex_state = 46, .external_lex_state = 3},
  [583] = {.lex_state = 46, .external_lex_state = 3},
  [584] = {.lex_state = 48, .external_lex_state = 3},
  [585] = {.lex_state = 46, .external_lex_state = 3},
  [586] = {.lex_state = 46, .external_lex_state = 3},
  [587] = {.lex_state = 48, .external_lex_state = 3},
  [588] = {.lex_state = 46, .external_lex_state = 3},
  [589] = {.lex_state = 48, .external_lex_state = 3},
  [590] = {.lex_state = 48, .external_lex_state = 3},
  [591] = {.lex_state = 46, .external_lex_state = 3},
  [592] = {.lex_state = 46, .external_lex_state = 3},
  [593] = {.lex_state = 46, .external_lex_state = 3},
  [594] = {.lex_state = 46, .external_lex_state = 3},
  [595] = {.lex_state = 19, .external_lex_state = 8},
  [596] = {.lex_state = 48, .external_lex_state = 3},
  [597] = {.lex_state = 19, .external_lex_state = 9},
  [598] = {.lex_state = 47, .external_lex_state = 3},
  [599] = {.lex_state = 47, .external_lex_state = 3},
  [600] = {.lex_state = 19, .external_lex_state = 6},
  [601] = {.lex_state = 45, .external_lex_state = 3},
  [602] = {.lex_state = 45, .external_lex_state = 3},
  [603] = {.lex_state = 19, .external_lex_state = 6},
  [604] = {.lex_state = 19, .external_lex_state = 6},
  [605] = {.lex_state = 47, .external_lex_state = 3},
  [606] = {.lex_state = 47, .external_lex_state = 3},
  [607] = {.lex_state = 19, .external_lex_state = 9},
  [608] = {.lex_state = 47, .external_lex_state = 3},
  [609] = {.lex_state = 44, .external_lex_state = 3},
  [610] = {.lex_state = 45, .external_lex_state = 3},
  [611] = {.lex_state = 50, .external_lex_state = 6},
  [612] = {.lex_state = 19, .external_lex_state = 6},
  [613] = {.lex_state = 45, .external_lex_state = 3},
  [614] = {.lex_state = 45, .external_lex_state = 3},
  [615] = {.lex_state = 19, .external_lex_state = 6},
  [616] = {.lex_state = 47, .external_lex_state = 3},
  [617] = {.lex_state = 45, .external_lex_state = 3},
  [618] = {.lex_state = 19, .external_lex_state = 6},
  [619] = {.lex_state = 19, .external_lex_state = 8},
  [620] = {.lex_state = 50, .external_lex_state = 6},
  [621] = {.lex_state = 47, .external_lex_state = 3},
  [622] = {.lex_state = 19, .external_lex_state = 6},
  [623] = {.lex_state = 19, .external_lex_state = 8},
  [624] = {.lex_state = 19, .external_lex_state = 6},
  [625] = {.lex_state = 47, .external_lex_state = 3},
  [626] = {.lex_state = 44, .external_lex_state = 3},
  [627] = {.lex_state = 44, .external_lex_state = 3},
  [628] = {.lex_state = 19, .external_lex_state = 6},
  [629] = {.lex_state = 19, .external_lex_state = 6},
  [630] = {.lex_state = 45, .external_lex_state = 3},
  [631] = {.lex_state = 19, .external_lex_state = 6},
  [632] = {.lex_state = 44, .external_lex_state = 3},
  [633] = {.lex_state = 44, .external_lex_state = 3},
  [634] = {.lex_state = 45, .external_lex_state = 3},
  [635] = {.lex_state = 44, .external_lex_state = 3},
  [636] = {.lex_state = 19, .external_lex_state = 6},
  [637] = {.lex_state = 45, .external_lex_state = 3},
  [638] = {.lex_state = 44, .external_lex_state = 3},
  [639] = {.lex_state = 44, .external_lex_state = 3},
  [640] = {.lex_state = 45, .external_lex_state = 3},
  [641] = {.lex_state = 19, .external_lex_state = 6},
  [642] = {.lex_state = 44, .external_lex_state = 3},
  [643] = {.lex_state = 19, .external_lex_state = 6},
  [644] = {.lex_state = 45, .external_lex_state = 3},
  [645] = {.lex_state = 33, .external_lex_state = 3},
  [646] = {.lex_state = 33, .external_lex_state = 3},
  [647] = {.lex_state = 33, .external_lex_state = 3},
  [648] = {.lex_state = 33, .external_lex_state = 3},
  [649] = {.lex_state = 33, .external_lex_state = 3},
  [650] = {.lex_state = 19, .external_lex_state = 8},
  [651] = {.lex_state = 33, .external_lex_state = 3},
  [652] = {.lex_state = 33, .external_lex_state = 3},
  [653] = {.lex_state = 33, .external_lex_state = 3},
  [654] = {.lex_state = 33, .external_lex_state = 3},
  [655] = {.lex_state = 33, .external_lex_state = 3},
  [656] = {.lex_state = 19, .external_lex_state = 6},
  [657] = {.lex_state = 33, .external_lex_state = 3},
  [658] = {.lex_state = 33, .external_lex_state = 3},
  [659] = {.lex_state = 33, .external_lex_state = 3},
  [660] = {.lex_state = 33, .external_lex_state = 3},
  [661] = {.lex_state = 33, .external_lex_state = 3},
  [662] = {.lex_state = 33, .external_lex_state = 3},
  [663] = {.lex_state = 33, .external_lex_state = 3},
  [664] = {.lex_state = 33, .external_lex_state = 3},
  [665] = {.lex_state = 33, .external_lex_state = 3},
  [666] = {.lex_state = 33, .external_lex_state = 3},
  [667] = {.lex_state = 33, .external_lex_state = 3},
  [668] = {.lex_state = 33, .external_lex_state = 3},
  [669] = {.lex_state = 33, .external_lex_state = 3},
  [670] = {.lex_state = 33, .external_lex_state = 3},
  [671] = {.lex_state = 33, .external_lex_state = 3},
  [672] = {.lex_state = 33, .external_lex_state = 3},
  [673] = {.lex_state = 33, .external_lex_state = 3},
  [674] = {.lex_state = 33, .external_lex_state = 3},
  [675] = {.lex_state = 33, .external_lex_state = 3},
  [676] = {.lex_state = 33, .external_lex_state = 3},
  [677] = {.lex_state = 33, .external_lex_state = 3},
  [678] = {.lex_state = 33, .external_lex_state = 3},
  [679] = {.lex_state = 33, .external_lex_state = 3},
  [680] = {.lex_state = 51, .external_lex_state = 6},
  [681] = {.lex_state = 51, .external_lex_state = 6},
  [682] = {.lex_state = 51, .external_lex_state = 6},
  [683] = {.lex_state = 51, .external_lex_state = 6},
  [684] = {.lex_state = 51, .external_lex_state = 6},
  [685] = {.lex_state = 51, .external_lex_state = 6},
  [686] = {.lex_state = 51, .external_lex_state = 6},
  [687] = {.lex_state = 51, .external_lex_state = 6},
  [688] = {.lex_state = 51, .external_lex_state = 6},
  [689] = {.lex_state = 51, .external_lex_state = 6},
  [690] = {.lex_state = 19, .external_lex_state = 6},
  [691] = {.lex_state = 19, .external_lex_state = 6},
  [692] = {.lex_state = 19, .external_lex_state = 6},
  [693] = {.lex_state = 19, .external_lex_state = 6},
  [694] = {.lex_state = 19, .external_lex_state = 6},
  [695] = {.lex_state = 19, .external_lex_state = 6},
  [696] = {.lex_state = 19, .external_lex_state = 6},
  [697] = {.lex_state = 19, .external_lex_state = 6},
  [698] = {.lex_state = 19, .external_lex_state = 6},
  [699] = {.lex_state = 19, .external_lex_state = 6},
  [700] = {.lex_state = 19, .external_lex_state = 6},
  [701] = {.lex_state = 19, .external_lex_state = 6},
  [702] = {.lex_state = 19, .external_lex_state = 6},
  [703] = {.lex_state = 19, .external_lex_state = 6},
  [704] = {.lex_state = 19, .external_lex_state = 6},
  [705] = {.lex_state = 19, .external_lex_state = 6},
  [706] = {.lex_state = 19, .external_lex_state = 6},
  [707] = {.lex_state = 19, .external_lex_state = 6},
  [708] = {.lex_state = 19, .external_lex_state = 6},
  [709] = {.lex_state = 19, .external_lex_state = 6},
  [710] = {.lex_state = 19, .external_lex_state = 6},
  [711] = {.lex_state = 19, .external_lex_state = 6},
  [712] = {.lex_state = 19, .external_lex_state = 6},
  [713] = {.lex_state = 19, .external_lex_state = 6},
  [714] = {.lex_state = 19, .external_lex_state = 6},
  [715] = {.lex_state = 19, .external_lex_state = 6},
  [716] = {.lex_state = 19, .external_lex_state = 6},
  [717] = {.lex_state = 19, .external_lex_state = 6},
  [718] = {.lex_state = 19, .external_lex_state = 6},
  [719] = {.lex_state = 19, .external_lex_state = 6},
  [720] = {.lex_state = 19, .external_lex_state = 6},
  [721] = {.lex_state = 19, .external_lex_state = 6},
  [722] = {.lex_state = 19, .external_lex_state = 6},
  [723] = {.lex_state = 19, .external_lex_state = 6},
  [724] = {.lex_state = 19, .external_lex_state = 6},
  [725] = {.lex_state = 19, .external_lex_state = 6},
  [726] = {.lex_state = 19, .external_lex_state = 6},
  [727] = {.lex_state = 19, .external_lex_state = 6},
  [728] = {.lex_state = 19, .external_lex_state = 6},
  [729] = {.lex_state = 19, .external_lex_state = 6},
  [730] = {.lex_state = 19, .external_lex_state = 6},
  [731] = {.lex_state = 19, .external_lex_state = 6},
  [732] = {.lex_state = 19, .external_lex_state = 6},
  [733] = {.lex_state = 19, .external_lex_state = 6},
  [734] = {.lex_state = 19, .external_lex_state = 6},
  [735] = {.lex_state = 19, .external_lex_state = 6},
  [736] = {.lex_state = 19, .external_lex_state = 6},
  [737] = {.lex_state = 19, .external_lex_state = 6},
  [738] = {.lex_state = 19, .external_lex_state = 6},
  [739] = {.lex_state = 19, .external_lex_state = 6},
  [740] = {.lex_state = 19, .external_lex_state = 6},
  [741] = {.lex_state = 19, .external_lex_state = 6},
  [742] = {.lex_state = 19, .external_lex_state = 6},
  [743] = {.lex_state = 19, .external_lex_state = 6},
  [744] = {.lex_state = 19, .external_lex_state = 6},
  [745] = {.lex_state = 19, .external_lex_state = 6},
  [746] = {.lex_state = 19, .external_lex_state = 6},
  [747] = {.lex_state = 19, .external_lex_state = 6},
  [748] = {.lex_state = 19, .external_lex_state = 6},
  [749] = {.lex_state = 19, .external_lex_state = 6},
  [750] = {.lex_state = 19, .external_lex_state = 6},
  [751] = {.lex_state = 19, .external_lex_state = 6},
  [752] = {.lex_state = 19, .external_lex_state = 6},
  [753] = {.lex_state = 19, .external_lex_state = 6},
  [754] = {.lex_state = 19, .external_lex_state = 6},
  [755] = {.lex_state = 19, .external_lex_state = 6},
  [756] = {.lex_state = 19, .external_lex_state = 6},
  [757] = {.lex_state = 19, .external_lex_state = 6},
  [758] = {.lex_state = 19, .external_lex_state = 6},
  [759] = {.lex_state = 19, .external_lex_state = 6},
  [760] = {.lex_state = 19, .external_lex_state = 6},
  [761] = {.lex_state = 19, .external_lex_state = 6},
  [762] = {.lex_state = 19, .external_lex_state = 6},
  [763] = {.lex_state = 19, .external_lex_state = 6},
  [764] = {.lex_state = 19, .external_lex_state = 6},
  [765] = {.lex_state = 19, .external_lex_state = 6},
  [766] = {.lex_state = 19, .external_lex_state = 6},
  [767] = {.lex_state = 19, .external_lex_state = 6},
  [768] = {.lex_state = 19, .external_lex_state = 6},
  [769] = {.lex_state = 19, .external_lex_state = 6},
  [770] = {.lex_state = 19, .external_lex_state = 6},
  [771] = {.lex_state = 19, .external_lex_state = 6},
  [772] = {.lex_state = 19, .external_lex_state = 6},
  [773] = {.lex_state = 19, .external_lex_state = 6},
  [774] = {.lex_state = 19, .external_lex_state = 6},
  [775] = {.lex_state = 19, .external_lex_state = 6},
  [776] = {.lex_state = 19, .external_lex_state = 6},
  [777] = {.lex_state = 19, .external_lex_state = 6},
  [778] = {.lex_state = 19, .external_lex_state = 6},
  [779] = {.lex_state = 19, .external_lex_state = 6},
  [780] = {.lex_state = 19, .external_lex_state = 6},
  [781] = {.lex_state = 19, .external_lex_state = 6},
  [782] = {.lex_state = 19, .external_lex_state = 6},
  [783] = {.lex_state = 19, .external_lex_state = 6},
  [784] = {.lex_state = 19, .external_lex_state = 6},
  [785] = {.lex_state = 19, .external_lex_state = 6},
  [786] = {.lex_state = 19, .external_lex_state = 6},
  [787] = {.lex_state = 19, .external_lex_state = 6},
  [788] = {.lex_state = 19, .external_lex_state = 6},
  [789] = {.lex_state = 19, .external_lex_state = 6},
  [790] = {.lex_state = 19, .external_lex_state = 6},
  [791] = {.lex_state = 19, .external_lex_state = 6},
  [792] = {.lex_state = 19, .external_lex_state = 6},
  [793] = {.lex_state = 19, .external_lex_state = 6},
  [794] = {.lex_state = 19, .external_lex_state = 6},
  [795] = {.lex_state = 19, .external_lex_state = 6},
  [796] = {.lex_state = 19, .external_lex_state = 6},
  [797] = {.lex_state = 19, .external_lex_state = 6},
  [798] = {.lex_state = 19, .external_lex_state = 6},
  [799] = {.lex_state = 19, .external_lex_state = 6},
  [800] = {.lex_state = 19, .external_lex_state = 6},
  [801] = {.lex_state = 19, .external_lex_state = 6},
  [802] = {.lex_state = 19, .external_lex_state = 6},
  [803] = {.lex_state = 19, .external_lex_state = 6},
  [804] = {.lex_state = 19, .external_lex_state = 6},
  [805] = {.lex_state = 19, .external_lex_state = 6},
  [806] = {.lex_state = 19, .external_lex_state = 6},
  [807] = {.lex_state = 19, .external_lex_state = 6},
  [808] = {.lex_state = 19, .external_lex_state = 6},
  [809] = {.lex_state = 19, .external_lex_state = 6},
  [810] = {.lex_state = 19, .external_lex_state = 6},
  [811] = {.lex_state = 19, .external_lex_state = 6},
  [812] = {.lex_state = 19, .external_lex_state = 6},
  [813] = {.lex_state = 19, .external_lex_state = 6},
  [814] = {.lex_state = 19, .external_lex_state = 6},
  [815] = {.lex_state = 19, .external_lex_state = 6},
  [816] = {.lex_state = 19, .external_lex_state = 6},
  [817] = {.lex_state = 19, .external_lex_state = 6},
  [818] = {.lex_state = 19, .external_lex_state = 6},
  [819] = {.lex_state = 19, .external_lex_state = 6},
  [820] = {.lex_state = 19, .external_lex_state = 6},
  [821] = {.lex_state = 19, .external_lex_state = 6},
  [822] = {.lex_state = 19, .external_lex_state = 6},
  [823] = {.lex_state = 19, .external_lex_state = 6},
  [824] = {.lex_state = 19, .external_lex_state = 6},
  [825] = {.lex_state = 19, .external_lex_state = 6},
  [826] = {.lex_state = 19, .external_lex_state = 6},
  [827] = {.lex_state = 19, .external_lex_state = 6},
  [828] = {.lex_state = 19, .external_lex_state = 6},
  [829] = {.lex_state = 19, .external_lex_state = 6},
  [830] = {.lex_state = 19, .external_lex_state = 6},
  [831] = {.lex_state = 19, .external_lex_state = 6},
  [832] = {.lex_state = 19, .external_lex_state = 6},
  [833] = {.lex_state = 15, .external_lex_state = 5},
  [834] = {.lex_state = 15, .external_lex_state = 5},
  [835] = {.lex_state = 15, .external_lex_state = 5},
  [836] = {.lex_state = 15, .external_lex_state = 10},
  [837] = {.lex_state = 27, .external_lex_state = 7},
  [838] = {.lex_state = 27, .external_lex_state = 7},
  [839] = {.lex_state = 27, .external_lex_state = 7},
  [840] = {.lex_state = 15, .external_lex_state = 7},
  [841] = {.lex_state = 27, .external_lex_state = 11},
  [842] = {.lex_state = 15, .external_lex_state = 7},
  [843] = {.lex_state = 15, .external_lex_state = 11},
  [844] = {.lex_state = 15, .external_lex_state = 7},
  [845] = {.lex_state = 15, .external_lex_state = 10},
  [846] = {.lex_state = 15, .external_lex_state = 10},
  [847] = {.lex_state = 27, .external_lex_state = 9},
  [848] = {.lex_state = 15, .external_lex_state = 12},
  [849] = {.lex_state = 15, .external_lex_state = 10},
  [850] = {.lex_state = 27, .external_lex_state = 13},
  [851] = {.lex_state = 15, .external_lex_state = 11},
  [852] = {.lex_state = 27, .external_lex_state = 12},
  [853] = {.lex_state = 27, .external_lex_state = 8},
  [854] = {.lex_state = 15, .external_lex_state = 10},
  [855] = {.lex_state = 15, .external_lex_state = 6},
  [856] = {.lex_state = 15, .external_lex_state = 11},
  [857] = {.lex_state = 15, .external_lex_state = 11},
  [858] = {.lex_state = 15, .external_lex_state = 5},
  [859] = {.lex_state = 15, .external_lex_state = 10},
  [860] = {.lex_state = 15, .external_lex_state = 5},
  [861] = {.lex_state = 14, .external_lex_state = 10},
  [862] = {.lex_state = 14, .external_lex_state = 10},
  [863] = {.lex_state = 15, .external_lex_state = 6},
  [864] = {.lex_state = 27, .external_lex_state = 8},
  [865] = {.lex_state = 15, .external_lex_state = 11},
  [866] = {.lex_state = 15, .external_lex_state = 10},
  [867] = {.lex_state = 15, .external_lex_state = 11},
  [868] = {.lex_state = 15, .external_lex_state = 11},
  [869] = {.lex_state = 14, .external_lex_state = 10},
  [870] = {.lex_state = 27, .external_lex_state = 8},
  [871] = {.lex_state = 15, .external_lex_state = 11},
  [872] = {.lex_state = 15, .external_lex_state = 11},
  [873] = {.lex_state = 15, .external_lex_state = 10},
  [874] = {.lex_state = 15, .external_lex_state = 10},
  [875] = {.lex_state = 15, .external_lex_state = 8},
  [876] = {.lex_state = 27, .external_lex_state = 11},
  [877] = {.lex_state = 15, .external_lex_state = 11},
  [878] = {.lex_state = 15, .external_lex_state = 8},
  [879] = {.lex_state = 27, .external_lex_state = 11},
  [880] = {.lex_state = 15, .external_lex_state = 6},
  [881] = {.lex_state = 15, .external_lex_state = 11},
  [882] = {.lex_state = 27, .external_lex_state = 9},
  [883] = {.lex_state = 15, .external_lex_state = 11},
  [884] = {.lex_state = 15, .external_lex_state = 10},
  [885] = {.lex_state = 27, .external_lex_state = 11},
  [886] = {.lex_state = 27, .external_lex_state = 11},
  [887] = {.lex_state = 15, .external_lex_state = 10},
  [888] = {.lex_state = 27, .external_lex_state = 11},
  [889] = {.lex_state = 27, .external_lex_state = 11},
  [890] = {.lex_state = 27, .external_lex_state = 11},
  [891] = {.lex_state = 15, .external_lex_state = 10},
  [892] = {.lex_state = 27, .external_lex_state = 11},
  [893] = {.lex_state = 15, .external_lex_state = 8},
  [894] = {.lex_state = 27, .external_lex_state = 11},
  [895] = {.lex_state = 27, .external_lex_state = 9},
  [896] = {.lex_state = 27, .external_lex_state = 11},
  [897] = {.lex_state = 15, .external_lex_state = 10},
  [898] = {.lex_state = 15, .external_lex_state = 10},
  [899] = {.lex_state = 15, .external_lex_state = 10},
  [900] = {.lex_state = 27, .external_lex_state = 11},
  [901] = {.lex_state = 27, .external_lex_state = 11},
  [902] = {.lex_state = 15, .external_lex_state = 11},
  [903] = {.lex_state = 15, .external_lex_state = 12},
  [904] = {.lex_state = 15, .external_lex_state = 10},
  [905] = {.lex_state = 27, .external_lex_state = 13},
  [906] = {.lex_state = 27, .external_lex_state = 13},
  [907] = {.lex_state = 27, .external_lex_state = 13},
  [908] = {.lex_state = 27, .external_lex_state = 13},
  [909] = {.lex_state = 27, .external_lex_state = 13},
  [910] = {.lex_state = 27, .external_lex_state = 13},
  [911] = {.lex_state = 27, .external_lex_state = 13},
  [912] = {.lex_state = 15, .external_lex_state = 12},
  [913] = {.lex_state = 15, .external_lex_state = 12},
  [914] = {.lex_state = 15, .external_lex_state = 12},
  [915] = {.lex_state = 15, .external_lex_state = 10},
  [916] = {.lex_state = 14, .external_lex_state = 12},
  [917] = {.lex_state = 15, .external_lex_state = 12},
  [918] = {.lex_state = 15, .external_lex_state = 10},
  [919] = {.lex_state = 15, .external_lex_state = 10},
  [920] = {.lex_state = 15, .external_lex_state = 10},
  [921] = {.lex_state = 27, .external_lex_state = 7},
  [922] = {.lex_state = 15, .external_lex_state = 10},
  [923] = {.lex_state = 15, .external_lex_state = 10},
  [924] = {.lex_state = 14, .external_lex_state = 11},
  [925] = {.lex_state = 15, .external_lex_state = 12},
  [926] = {.lex_state = 15, .external_lex_state = 10},
  [927] = {.lex_state = 15, .external_lex_state = 12},
  [928] = {.lex_state = 14, .external_lex_state = 11},
  [929] = {.lex_state = 15, .external_lex_state = 7},
  [930] = {.lex_state = 14, .external_lex_state = 11},
  [931] = {.lex_state = 15, .external_lex_state = 10},
  [932] = {.lex_state = 15, .external_lex_state = 12},
  [933] = {.lex_state = 15, .external_lex_state = 10},
  [934] = {.lex_state = 27, .external_lex_state = 7},
  [935] = {.lex_state = 15, .external_lex_state = 10},
  [936] = {.lex_state = 15, .external_lex_state = 10},
  [937] = {.lex_state = 26, .external_lex_state = 11},
  [938] = {.lex_state = 15, .external_lex_state = 10},
  [939] = {.lex_state = 26, .external_lex_state = 11},
  [940] = {.lex_state = 15, .external_lex_state = 10},
  [941] = {.lex_state = 26, .external_lex_state = 11},
  [942] = {.lex_state = 27, .external_lex_state = 13},
  [943] = {.lex_state = 27, .external_lex_state = 13},
  [944] = {.lex_state = 26, .external_lex_state = 12},
  [945] = {.lex_state = 26, .external_lex_state = 12},
  [946] = {.lex_state = 15, .external_lex_state = 10},
  [947] = {.lex_state = 15, .external_lex_state = 12},
  [948] = {.lex_state = 15, .external_lex_state = 10},
  [949] = {.lex_state = 14, .external_lex_state = 11},
  [950] = {.lex_state = 15, .external_lex_state = 10},
  [951] = {.lex_state = 14, .external_lex_state = 11},
  [952] = {.lex_state = 27, .external_lex_state = 12},
  [953] = {.lex_state = 27, .external_lex_state = 12},
  [954] = {.lex_state = 15, .external_lex_state = 10},
  [955] = {.lex_state = 26, .external_lex_state = 12},
  [956] = {.lex_state = 15, .external_lex_state = 12},
  [957] = {.lex_state = 14, .external_lex_state = 11},
  [958] = {.lex_state = 27, .external_lex_state = 13},
  [959] = {.lex_state = 15, .external_lex_state = 10},
  [960] = {.lex_state = 14, .external_lex_state = 10},
  [961] = {.lex_state = 15, .external_lex_state = 12},
  [962] = {.lex_state = 15, .external_lex_state = 10},
  [963] = {.lex_state = 27, .external_lex_state = 12},
  [964] = {.lex_state = 27, .external_lex_state = 12},
  [965] = {.lex_state = 27, .external_lex_state = 12},
  [966] = {.lex_state = 27, .external_lex_state = 12},
  [967] = {.lex_state = 27, .external_lex_state = 12},
  [968] = {.lex_state = 15, .external_lex_state = 10},
  [969] = {.lex_state = 15, .external_lex_state = 10},
  [970] = {.lex_state = 27, .external_lex_state = 12},
  [971] = {.lex_state = 27, .external_lex_state = 12},
  [972] = {.lex_state = 27, .external_lex_state = 12},
  [973] = {.lex_state = 15, .external_lex_state = 10},
  [974] = {.lex_state = 15, .external_lex_state = 10},
  [975] = {.lex_state = 15, .external_lex_state = 9},
  [976] = {.lex_state = 26, .external_lex_state = 11},
  [977] = {.lex_state = 26, .external_lex_state = 11},
  [978] = {.lex_state = 27, .external_lex_state = 13},
  [979] = {.lex_state = 26, .external_lex_state = 11},
  [980] = {.lex_state = 15, .external_lex_state = 10},
  [981] = {.lex_state = 15, .external_lex_state = 10},
  [982] = {.lex_state = 15, .external_lex_state = 10},
  [983] = {.lex_state = 15, .external_lex_state = 12},
  [984] = {.lex_state = 15, .external_lex_state = 10},
  [985] = {.lex_state = 15, .external_lex_state = 10},
  [986] = {.lex_state = 15, .external_lex_state = 10},
  [987] = {.lex_state = 15, .external_lex_state = 10},
  [988] = {.lex_state = 15, .external_lex_state = 9},
  [989] = {.lex_state = 15, .external_lex_state = 10},
  [990] = {.lex_state = 15, .external_lex_state = 10},
  [991] = {.lex_state = 15, .external_lex_state = 10},
  [992] = {.lex_state = 15, .external_lex_state = 10},
  [993] = {.lex_state = 15, .external_lex_state = 10},
  [994] = {.lex_state = 15, .external_lex_state = 10},
  [995] = {.lex_state = 15, .external_lex_state = 10},
  [996] = {.lex_state = 15, .external_lex_state = 10},
  [997] = {.lex_state = 15, .external_lex_state = 10},
  [998] = {.lex_state = 15, .external_lex_state = 10},
  [999] = {.lex_state = 15, .external_lex_state = 10},
  [1000] = {.lex_state = 27, .external_lex_state = 12},
  [1001] = {.lex_state = 15, .external_lex_state = 10},
  [1002] = {.lex_state = 27, .external_lex_state = 12},
  [1003] = {.lex_state = 15, .external_lex_state = 10},
  [1004] = {.lex_state = 27, .external_lex_state = 13},
  [1005] = {.lex_state = 15, .external_lex_state = 10},
  [1006] = {.lex_state = 15, .external_lex_state = 10},
  [1007] = {.lex_state = 15, .external_lex_state = 10},
  [1008] = {.lex_state = 15, .external_lex_state = 7},
  [1009] = {.lex_state = 15, .external_lex_state = 10},
  [1010] = {.lex_state = 15, .external_lex_state = 2},
  [1011] = {.lex_state = 15, .external_lex_state = 13},
  [1012] = {.lex_state = 15, .external_lex_state = 9},
  [1013] = {.lex_state = 14, .external_lex_state = 12},
  [1014] = {.lex_state = 26, .external_lex_state = 12},
  [1015] = {.lex_state = 15, .external_lex_state = 11},
  [1016] = {.lex_state = 15, .external_lex_state = 2},
  [1017] = {.lex_state = 15, .external_lex_state = 2},
  [1018] = {.lex_state = 15, .external_lex_state = 2},
  [1019] = {.lex_state = 15, .external_lex_state = 11},
  [1020] = {.lex_state = 15, .external_lex_state = 11},
  [1021] = {.lex_state = 15, .external_lex_state = 11},
  [1022] = {.lex_state = 15, .external_lex_state = 11},
  [1023] = {.lex_state = 15, .external_lex_state = 11},
  [1024] = {.lex_state = 26, .external_lex_state = 13},
  [1025] = {.lex_state = 26, .external_lex_state = 13},
  [1026] = {.lex_state = 26, .external_lex_state = 13},
  [1027] = {.lex_state = 27, .external_lex_state = 11},
  [1028] = {.lex_state = 15, .external_lex_state = 11},
  [1029] = {.lex_state = 15, .external_lex_state = 11},
  [1030] = {.lex_state = 15, .external_lex_state = 11},
  [1031] = {.lex_state = 15, .external_lex_state = 11},
  [1032] = {.lex_state = 15, .external_lex_state = 11},
  [1033] = {.lex_state = 15, .external_lex_state = 11},
  [1034] = {.lex_state = 26, .external_lex_state = 12},
  [1035] = {.lex_state = 15, .external_lex_state = 11},
  [1036] = {.lex_state = 15, .external_lex_state = 2},
  [1037] = {.lex_state = 26, .external_lex_state = 12},
  [1038] = {.lex_state = 26, .external_lex_state = 12},
  [1039] = {.lex_state = 15, .external_lex_state = 2},
  [1040] = {.lex_state = 15, .external_lex_state = 2},
  [1041] = {.lex_state = 15, .external_lex_state = 2},
  [1042] = {.lex_state = 15, .external_lex_state = 2},
  [1043] = {.lex_state = 15, .external_lex_state = 2},
  [1044] = {.lex_state = 15, .external_lex_state = 2},
  [1045] = {.lex_state = 15, .external_lex_state = 11},
  [1046] = {.lex_state = 27, .external_lex_state = 8},
  [1047] = {.lex_state = 15, .external_lex_state = 2},
  [1048] = {.lex_state = 15, .external_lex_state = 2},
  [1049] = {.lex_state = 15, .external_lex_state = 11},
  [1050] = {.lex_state = 15, .external_lex_state = 11},
  [1051] = {.lex_state = 15, .external_lex_state = 11},
  [1052] = {.lex_state = 15, .external_lex_state = 11},
  [1053] = {.lex_state = 15, .external_lex_state = 11},
  [1054] = {.lex_state = 15, .external_lex_state = 11},
  [1055] = {.lex_state = 15, .external_lex_state = 11},
  [1056] = {.lex_state = 15, .external_lex_state = 11},
  [1057] = {.lex_state = 15, .external_lex_state = 11},
  [1058] = {.lex_state = 15, .external_lex_state = 11},
  [1059] = {.lex_state = 15, .external_lex_state = 11},
  [1060] = {.lex_state = 27, .external_lex_state = 11},
  [1061] = {.lex_state = 27, .external_lex_state = 11},
  [1062] = {.lex_state = 15, .external_lex_state = 11},
  [1063] = {.lex_state = 15, .external_lex_state = 11},
  [1064] = {.lex_state = 15, .external_lex_state = 11},
  [1065] = {.lex_state = 15, .external_lex_state = 11},
  [1066] = {.lex_state = 15, .external_lex_state = 11},
  [1067] = {.lex_state = 15, .external_lex_state = 11},
  [1068] = {.lex_state = 15, .external_lex_state = 11},
  [1069] = {.lex_state = 14, .external_lex_state = 2},
  [1070] = {.lex_state = 26, .external_lex_state = 13},
  [1071] = {.lex_state = 15, .external_lex_state = 8},
  [1072] = {.lex_state = 26, .external_lex_state = 13},
  [1073] = {.lex_state = 26, .external_lex_state = 13},
  [1074] = {.lex_state = 27, .external_lex_state = 9},
  [1075] = {.lex_state = 15, .external_lex_state = 11},
  [1076] = {.lex_state = 15, .external_lex_state = 8},
  [1077] = {.lex_state = 14, .external_lex_state = 2},
  [1078] = {.lex_state = 14, .external_lex_state = 2},
  [1079] = {.lex_state = 14, .external_lex_state = 2},
  [1080] = {.lex_state = 26, .external_lex_state = 13},
  [1081] = {.lex_state = 15, .external_lex_state = 11},
  [1082] = {.lex_state = 26, .external_lex_state = 13},
  [1083] = {.lex_state = 26, .external_lex_state = 13},
  [1084] = {.lex_state = 15, .external_lex_state = 13},
  [1085] = {.lex_state = 15, .external_lex_state = 13},
  [1086] = {.lex_state = 15, .external_lex_state = 13},
  [1087] = {.lex_state = 27, .external_lex_state = 8},
  [1088] = {.lex_state = 15, .external_lex_state = 13},
  [1089] = {.lex_state = 15, .external_lex_state = 13},
  [1090] = {.lex_state = 15, .external_lex_state = 13},
  [1091] = {.lex_state = 15, .external_lex_state = 13},
  [1092] = {.lex_state = 15, .external_lex_state = 11},
  [1093] = {.lex_state = 15, .external_lex_state = 11},
  [1094] = {.lex_state = 27, .external_lex_state = 9},
  [1095] = {.lex_state = 26, .external_lex_state = 12},
  [1096] = {.lex_state = 15, .external_lex_state = 13},
  [1097] = {.lex_state = 15, .external_lex_state = 13},
  [1098] = {.lex_state = 26, .external_lex_state = 12},
  [1099] = {.lex_state = 15, .external_lex_state = 12},
  [1100] = {.lex_state = 14, .external_lex_state = 12},
  [1101] = {.lex_state = 14, .external_lex_state = 12},
  [1102] = {.lex_state = 15, .external_lex_state = 11},
  [1103] = {.lex_state = 15, .external_lex_state = 13},
  [1104] = {.lex_state = 15, .external_lex_state = 13},
  [1105] = {.lex_state = 15, .external_lex_state = 13},
  [1106] = {.lex_state = 15, .external_lex_state = 11},
  [1107] = {.lex_state = 15, .external_lex_state = 6},
  [1108] = {.lex_state = 15, .external_lex_state = 6},
  [1109] = {.lex_state = 15, .external_lex_state = 13},
  [1110] = {.lex_state = 27, .external_lex_state = 11},
  [1111] = {.lex_state = 27, .external_lex_state = 11},
  [1112] = {.lex_state = 27, .external_lex_state = 11},
  [1113] = {.lex_state = 27, .external_lex_state = 12},
  [1114] = {.lex_state = 27, .external_lex_state = 11},
  [1115] = {.lex_state = 27, .external_lex_state = 11},
  [1116] = {.lex_state = 27, .external_lex_state = 11},
  [1117] = {.lex_state = 27, .external_lex_state = 11},
  [1118] = {.lex_state = 27, .external_lex_state = 11},
  [1119] = {.lex_state = 27, .external_lex_state = 11},
  [1120] = {.lex_state = 27, .external_lex_state = 11},
  [1121] = {.lex_state = 27, .external_lex_state = 11},
  [1122] = {.lex_state = 27, .external_lex_state = 11},
  [1123] = {.lex_state = 27, .external_lex_state = 11},
  [1124] = {.lex_state = 27, .external_lex_state = 11},
  [1125] = {.lex_state = 27, .external_lex_state = 11},
  [1126] = {.lex_state = 27, .external_lex_state = 11},
  [1127] = {.lex_state = 27, .external_lex_state = 11},
  [1128] = {.lex_state = 27, .external_lex_state = 11},
  [1129] = {.lex_state = 14, .external_lex_state = 13},
  [1130] = {.lex_state = 27, .external_lex_state = 11},
  [1131] = {.lex_state = 27, .external_lex_state = 11},
  [1132] = {.lex_state = 27, .external_lex_state = 11},
  [1133] = {.lex_state = 27, .external_lex_state = 11},
  [1134] = {.lex_state = 27, .external_lex_state = 11},
  [1135] = {.lex_state = 27, .external_lex_state = 11},
  [1136] = {.lex_state = 27, .external_lex_state = 11},
  [1137] = {.lex_state = 26, .external_lex_state = 12},
  [1138] = {.lex_state = 26, .external_lex_state = 12},
  [1139] = {.lex_state = 26, .external_lex_state = 12},
  [1140] = {.lex_state = 27, .external_lex_state = 11},
  [1141] = {.lex_state = 27, .external_lex_state = 11},
  [1142] = {.lex_state = 27, .external_lex_state = 11},
  [1143] = {.lex_state = 27, .external_lex_state = 11},
  [1144] = {.lex_state = 27, .external_lex_state = 11},
  [1145] = {.lex_state = 15, .external_lex_state = 11},
  [1146] = {.lex_state = 27, .external_lex_state = 11},
  [1147] = {.lex_state = 27, .external_lex_state = 11},
  [1148] = {.lex_state = 15, .external_lex_state = 11},
  [1149] = {.lex_state = 27, .external_lex_state = 11},
  [1150] = {.lex_state = 27, .external_lex_state = 11},
  [1151] = {.lex_state = 27, .external_lex_state = 12},
  [1152] = {.lex_state = 27, .external_lex_state = 12},
  [1153] = {.lex_state = 27, .external_lex_state = 12},
  [1154] = {.lex_state = 27, .external_lex_state = 12},
  [1155] = {.lex_state = 27, .external_lex_state = 12},
  [1156] = {.lex_state = 27, .external_lex_state = 12},
  [1157] = {.lex_state = 15, .external_lex_state = 11},
  [1158] = {.lex_state = 15, .external_lex_state = 12},
  [1159] = {.lex_state = 15, .external_lex_state = 2},
  [1160] = {.lex_state = 15, .external_lex_state = 12},
  [1161] = {.lex_state = 15, .external_lex_state = 12},
  [1162] = {.lex_state = 11, .external_lex_state = 10},
  [1163] = {.lex_state = 11, .external_lex_state = 10},
  [1164] = {.lex_state = 15, .external_lex_state = 9},
  [1165] = {.lex_state = 27, .external_lex_state = 13},
  [1166] = {.lex_state = 27, .external_lex_state = 13},
  [1167] = {.lex_state = 27, .external_lex_state = 13},
  [1168] = {.lex_state = 15, .external_lex_state = 12},
  [1169] = {.lex_state = 27, .external_lex_state = 12},
  [1170] = {.lex_state = 27, .external_lex_state = 12},
  [1171] = {.lex_state = 27, .external_lex_state = 13},
  [1172] = {.lex_state = 27, .external_lex_state = 13},
  [1173] = {.lex_state = 27, .external_lex_state = 12},
  [1174] = {.lex_state = 15, .external_lex_state = 2},
  [1175] = {.lex_state = 27, .external_lex_state = 13},
  [1176] = {.lex_state = 15, .external_lex_state = 9},
  [1177] = {.lex_state = 15, .external_lex_state = 2},
  [1178] = {.lex_state = 27, .external_lex_state = 12},
  [1179] = {.lex_state = 27, .external_lex_state = 12},
  [1180] = {.lex_state = 27, .external_lex_state = 12},
  [1181] = {.lex_state = 352, .external_lex_state = 2},
  [1182] = {.lex_state = 27, .external_lex_state = 12},
  [1183] = {.lex_state = 27, .external_lex_state = 12},
  [1184] = {.lex_state = 15, .external_lex_state = 12},
  [1185] = {.lex_state = 15, .external_lex_state = 12},
  [1186] = {.lex_state = 15, .external_lex_state = 12},
  [1187] = {.lex_state = 11, .external_lex_state = 10},
  [1188] = {.lex_state = 11, .external_lex_state = 10},
  [1189] = {.lex_state = 27, .external_lex_state = 12},
  [1190] = {.lex_state = 27, .external_lex_state = 12},
  [1191] = {.lex_state = 27, .external_lex_state = 12},
  [1192] = {.lex_state = 27, .external_lex_state = 12},
  [1193] = {.lex_state = 27, .external_lex_state = 12},
  [1194] = {.lex_state = 11, .external_lex_state = 10},
  [1195] = {.lex_state = 11, .external_lex_state = 10},
  [1196] = {.lex_state = 15, .external_lex_state = 2},
  [1197] = {.lex_state = 27, .external_lex_state = 12},
  [1198] = {.lex_state = 27, .external_lex_state = 12},
  [1199] = {.lex_state = 15, .external_lex_state = 2},
  [1200] = {.lex_state = 27, .external_lex_state = 13},
  [1201] = {.lex_state = 15, .external_lex_state = 2},
  [1202] = {.lex_state = 15, .external_lex_state = 2},
  [1203] = {.lex_state = 27, .external_lex_state = 13},
  [1204] = {.lex_state = 15, .external_lex_state = 2},
  [1205] = {.lex_state = 15, .external_lex_state = 12},
  [1206] = {.lex_state = 15, .external_lex_state = 12},
  [1207] = {.lex_state = 27, .external_lex_state = 13},
  [1208] = {.lex_state = 15, .external_lex_state = 2},
  [1209] = {.lex_state = 27, .external_lex_state = 12},
  [1210] = {.lex_state = 27, .external_lex_state = 12},
  [1211] = {.lex_state = 15, .external_lex_state = 2},
  [1212] = {.lex_state = 27, .external_lex_state = 13},
  [1213] = {.lex_state = 27, .external_lex_state = 13},
  [1214] = {.lex_state = 15, .external_lex_state = 12},
  [1215] = {.lex_state = 15, .external_lex_state = 2},
  [1216] = {.lex_state = 27, .external_lex_state = 13},
  [1217] = {.lex_state = 27, .external_lex_state = 13},
  [1218] = {.lex_state = 15, .external_lex_state = 2},
  [1219] = {.lex_state = 27, .external_lex_state = 12},
  [1220] = {.lex_state = 27, .external_lex_state = 12},
  [1221] = {.lex_state = 27, .external_lex_state = 13},
  [1222] = {.lex_state = 27, .external_lex_state = 12},
  [1223] = {.lex_state = 27, .external_lex_state = 12},
  [1224] = {.lex_state = 15, .external_lex_state = 2},
  [1225] = {.lex_state = 27, .external_lex_state = 12},
  [1226] = {.lex_state = 27, .external_lex_state = 12},
  [1227] = {.lex_state = 27, .external_lex_state = 12},
  [1228] = {.lex_state = 15, .external_lex_state = 2},
  [1229] = {.lex_state = 15, .external_lex_state = 2},
  [1230] = {.lex_state = 27, .external_lex_state = 12},
  [1231] = {.lex_state = 27, .external_lex_state = 12},
  [1232] = {.lex_state = 27, .external_lex_state = 12},
  [1233] = {.lex_state = 27, .external_lex_state = 13},
  [1234] = {.lex_state = 27, .external_lex_state = 13},
  [1235] = {.lex_state = 27, .external_lex_state = 13},
  [1236] = {.lex_state = 15, .external_lex_state = 2},
  [1237] = {.lex_state = 27, .external_lex_state = 12},
  [1238] = {.lex_state = 27, .external_lex_state = 12},
  [1239] = {.lex_state = 15, .external_lex_state = 12},
  [1240] = {.lex_state = 15, .external_lex_state = 12},
  [1241] = {.lex_state = 15, .external_lex_state = 2},
  [1242] = {.lex_state = 27, .external_lex_state = 13},
  [1243] = {.lex_state = 27, .external_lex_state = 13},
  [1244] = {.lex_state = 27, .external_lex_state = 13},
  [1245] = {.lex_state = 27, .external_lex_state = 13},
  [1246] = {.lex_state = 27, .external_lex_state = 13},
  [1247] = {.lex_state = 27, .external_lex_state = 13},
  [1248] = {.lex_state = 27, .external_lex_state = 12},
  [1249] = {.lex_state = 27, .external_lex_state = 13},
  [1250] = {.lex_state = 15, .external_lex_state = 12},
  [1251] = {.lex_state = 15, .external_lex_state = 2},
  [1252] = {.lex_state = 27, .external_lex_state = 13},
  [1253] = {.lex_state = 27, .external_lex_state = 13},
  [1254] = {.lex_state = 15, .external_lex_state = 2},
  [1255] = {.lex_state = 15, .external_lex_state = 2},
  [1256] = {.lex_state = 27, .external_lex_state = 13},
  [1257] = {.lex_state = 15, .external_lex_state = 2},
  [1258] = {.lex_state = 15, .external_lex_state = 2},
  [1259] = {.lex_state = 27, .external_lex_state = 13},
  [1260] = {.lex_state = 27, .external_lex_state = 13},
  [1261] = {.lex_state = 27, .external_lex_state = 12},
  [1262] = {.lex_state = 27, .external_lex_state = 13},
  [1263] = {.lex_state = 27, .external_lex_state = 12},
  [1264] = {.lex_state = 15, .external_lex_state = 12},
  [1265] = {.lex_state = 15, .external_lex_state = 12},
  [1266] = {.lex_state = 15, .external_lex_state = 12},
  [1267] = {.lex_state = 15, .external_lex_state = 2},
  [1268] = {.lex_state = 15, .external_lex_state = 12},
  [1269] = {.lex_state = 352, .external_lex_state = 2},
  [1270] = {.lex_state = 15, .external_lex_state = 12},
  [1271] = {.lex_state = 27, .external_lex_state = 13},
  [1272] = {.lex_state = 27, .external_lex_state = 13},
  [1273] = {.lex_state = 27, .external_lex_state = 13},
  [1274] = {.lex_state = 14, .external_lex_state = 12},
  [1275] = {.lex_state = 15, .external_lex_state = 2},
  [1276] = {.lex_state = 15, .external_lex_state = 2},
  [1277] = {.lex_state = 15, .external_lex_state = 2},
  [1278] = {.lex_state = 15, .external_lex_state = 2},
  [1279] = {.lex_state = 15, .external_lex_state = 2},
  [1280] = {.lex_state = 15, .external_lex_state = 12},
  [1281] = {.lex_state = 14, .external_lex_state = 12},
  [1282] = {.lex_state = 15, .external_lex_state = 2},
  [1283] = {.lex_state = 15, .external_lex_state = 2},
  [1284] = {.lex_state = 14, .external_lex_state = 13},
  [1285] = {.lex_state = 14, .external_lex_state = 13},
  [1286] = {.lex_state = 27, .external_lex_state = 13},
  [1287] = {.lex_state = 15, .external_lex_state = 2},
  [1288] = {.lex_state = 14, .external_lex_state = 12},
  [1289] = {.lex_state = 14, .external_lex_state = 13},
  [1290] = {.lex_state = 27, .external_lex_state = 13},
  [1291] = {.lex_state = 15, .external_lex_state = 12},
  [1292] = {.lex_state = 15, .external_lex_state = 12},
  [1293] = {.lex_state = 15, .external_lex_state = 12},
  [1294] = {.lex_state = 27, .external_lex_state = 12},
  [1295] = {.lex_state = 27, .external_lex_state = 12},
  [1296] = {.lex_state = 15, .external_lex_state = 10},
  [1297] = {.lex_state = 15, .external_lex_state = 12},
  [1298] = {.lex_state = 15, .external_lex_state = 12},
  [1299] = {.lex_state = 27, .external_lex_state = 13},
  [1300] = {.lex_state = 15, .external_lex_state = 12},
  [1301] = {.lex_state = 27, .external_lex_state = 13},
  [1302] = {.lex_state = 27, .external_lex_state = 13},
  [1303] = {.lex_state = 15, .external_lex_state = 12},
  [1304] = {.lex_state = 27, .external_lex_state = 13},
  [1305] = {.lex_state = 15, .external_lex_state = 2},
  [1306] = {.lex_state = 15, .external_lex_state = 12},
  [1307] = {.lex_state = 15, .external_lex_state = 12},
  [1308] = {.lex_state = 15, .external_lex_state = 12},
  [1309] = {.lex_state = 15, .external_lex_state = 2},
  [1310] = {.lex_state = 27, .external_lex_state = 13},
  [1311] = {.lex_state = 27, .external_lex_state = 13},
  [1312] = {.lex_state = 15, .external_lex_state = 2},
  [1313] = {.lex_state = 15, .external_lex_state = 2},
  [1314] = {.lex_state = 15, .external_lex_state = 2},
  [1315] = {.lex_state = 15, .external_lex_state = 12},
  [1316] = {.lex_state = 15, .external_lex_state = 12},
  [1317] = {.lex_state = 15, .external_lex_state = 12},
  [1318] = {.lex_state = 15, .external_lex_state = 12},
  [1319] = {.lex_state = 15, .external_lex_state = 12},
  [1320] = {.lex_state = 15, .external_lex_state = 12},
  [1321] = {.lex_state = 15, .external_lex_state = 12},
  [1322] = {.lex_state = 15, .external_lex_state = 12},
  [1323] = {.lex_state = 15, .external_lex_state = 2},
  [1324] = {.lex_state = 14, .external_lex_state = 12},
  [1325] = {.lex_state = 15, .external_lex_state = 13},
  [1326] = {.lex_state = 15, .external_lex_state = 2},
  [1327] = {.lex_state = 15, .external_lex_state = 2},
  [1328] = {.lex_state = 15, .external_lex_state = 13},
  [1329] = {.lex_state = 15, .external_lex_state = 2},
  [1330] = {.lex_state = 15, .external_lex_state = 2},
  [1331] = {.lex_state = 15, .external_lex_state = 13},
  [1332] = {.lex_state = 15, .external_lex_state = 13},
  [1333] = {.lex_state = 15, .external_lex_state = 13},
  [1334] = {.lex_state = 15, .external_lex_state = 13},
  [1335] = {.lex_state = 15, .external_lex_state = 13},
  [1336] = {.lex_state = 15, .external_lex_state = 2},
  [1337] = {.lex_state = 15, .external_lex_state = 13},
  [1338] = {.lex_state = 15, .external_lex_state = 13},
  [1339] = {.lex_state = 15, .external_lex_state = 13},
  [1340] = {.lex_state = 15, .external_lex_state = 13},
  [1341] = {.lex_state = 15, .external_lex_state = 13},
  [1342] = {.lex_state = 15, .external_lex_state = 13},
  [1343] = {.lex_state = 15, .external_lex_state = 13},
  [1344] = {.lex_state = 14, .external_lex_state = 11},
  [1345] = {.lex_state = 14, .external_lex_state = 11},
  [1346] = {.lex_state = 14, .external_lex_state = 11},
  [1347] = {.lex_state = 15, .external_lex_state = 13},
  [1348] = {.lex_state = 15, .external_lex_state = 13},
  [1349] = {.lex_state = 15, .external_lex_state = 13},
  [1350] = {.lex_state = 15, .external_lex_state = 13},
  [1351] = {.lex_state = 15, .external_lex_state = 13},
  [1352] = {.lex_state = 15, .external_lex_state = 2},
  [1353] = {.lex_state = 14, .external_lex_state = 12},
  [1354] = {.lex_state = 15, .external_lex_state = 13},
  [1355] = {.lex_state = 14, .external_lex_state = 12},
  [1356] = {.lex_state = 15, .external_lex_state = 13},
  [1357] = {.lex_state = 15, .external_lex_state = 13},
  [1358] = {.lex_state = 15, .external_lex_state = 13},
  [1359] = {.lex_state = 15, .external_lex_state = 2},
  [1360] = {.lex_state = 14, .external_lex_state = 13},
  [1361] = {.lex_state = 15, .external_lex_state = 2},
  [1362] = {.lex_state = 15, .external_lex_state = 2},
  [1363] = {.lex_state = 15, .external_lex_state = 13},
  [1364] = {.lex_state = 15, .external_lex_state = 13},
  [1365] = {.lex_state = 15, .external_lex_state = 13},
  [1366] = {.lex_state = 15, .external_lex_state = 13},
  [1367] = {.lex_state = 14, .external_lex_state = 13},
  [1368] = {.lex_state = 14, .external_lex_state = 13},
  [1369] = {.lex_state = 15, .external_lex_state = 13},
  [1370] = {.lex_state = 15, .external_lex_state = 2},
  [1371] = {.lex_state = 15, .external_lex_state = 13},
  [1372] = {.lex_state = 15, .external_lex_state = 13},
  [1373] = {.lex_state = 15, .external_lex_state = 2},
  [1374] = {.lex_state = 15, .external_lex_state = 13},
  [1375] = {.lex_state = 15, .external_lex_state = 2},
  [1376] = {.lex_state = 15, .external_lex_state = 13},
  [1377] = {.lex_state = 15, .external_lex_state = 13},
  [1378] = {.lex_state = 15, .external_lex_state = 13},
  [1379] = {.lex_state = 15, .external_lex_state = 13},
  [1380] = {.lex_state = 15, .external_lex_state = 13},
  [1381] = {.lex_state = 15, .external_lex_state = 2},
  [1382] = {.lex_state = 15, .external_lex_state = 13},
  [1383] = {.lex_state = 11, .external_lex_state = 2},
  [1384] = {.lex_state = 11, .external_lex_state = 2},
  [1385] = {.lex_state = 11, .external_lex_state = 2},
  [1386] = {.lex_state = 15, .external_lex_state = 12},
  [1387] = {.lex_state = 15, .external_lex_state = 11},
  [1388] = {.lex_state = 11, .external_lex_state = 2},
  [1389] = {.lex_state = 11, .external_lex_state = 2},
  [1390] = {.lex_state = 11, .external_lex_state = 2},
  [1391] = {.lex_state = 11, .external_lex_state = 2},
  [1392] = {.lex_state = 15, .external_lex_state = 13},
  [1393] = {.lex_state = 11, .external_lex_state = 2},
  [1394] = {.lex_state = 11, .external_lex_state = 2},
  [1395] = {.lex_state = 11, .external_lex_state = 2},
  [1396] = {.lex_state = 11, .external_lex_state = 2},
  [1397] = {.lex_state = 11, .external_lex_state = 2},
  [1398] = {.lex_state = 11, .external_lex_state = 2},
  [1399] = {.lex_state = 11, .external_lex_state = 2},
  [1400] = {.lex_state = 11, .external_lex_state = 2},
  [1401] = {.lex_state = 11, .external_lex_state = 2},
  [1402] = {.lex_state = 11, .external_lex_state = 10},
  [1403] = {.lex_state = 11, .external_lex_state = 10},
  [1404] = {.lex_state = 11, .external_lex_state = 12},
  [1405] = {.lex_state = 15, .external_lex_state = 11},
  [1406] = {.lex_state = 11, .external_lex_state = 12},
  [1407] = {.lex_state = 15, .external_lex_state = 11},
  [1408] = {.lex_state = 15, .external_lex_state = 11},
  [1409] = {.lex_state = 15, .external_lex_state = 11},
  [1410] = {.lex_state = 15, .external_lex_state = 11},
  [1411] = {.lex_state = 15, .external_lex_state = 11},
  [1412] = {.lex_state = 11, .external_lex_state = 11},
  [1413] = {.lex_state = 11, .external_lex_state = 13},
  [1414] = {.lex_state = 11, .external_lex_state = 13},
  [1415] = {.lex_state = 11, .external_lex_state = 11},
  [1416] = {.lex_state = 27, .external_lex_state = 11},
  [1417] = {.lex_state = 27, .external_lex_state = 11},
  [1418] = {.lex_state = 11, .external_lex_state = 2},
  [1419] = {.lex_state = 11, .external_lex_state = 2},
  [1420] = {.lex_state = 20, .external_lex_state = 10},
  [1421] = {.lex_state = 15, .external_lex_state = 12},
  [1422] = {.lex_state = 0, .external_lex_state = 13},
  [1423] = {.lex_state = 15, .external_lex_state = 12},
  [1424] = {.lex_state = 23, .external_lex_state = 10},
  [1425] = {.lex_state = 15, .external_lex_state = 12},
  [1426] = {.lex_state = 0, .external_lex_state = 12},
  [1427] = {.lex_state = 0, .external_lex_state = 12},
  [1428] = {.lex_state = 15, .external_lex_state = 12},
  [1429] = {.lex_state = 20, .external_lex_state = 10},
  [1430] = {.lex_state = 23, .external_lex_state = 10},
  [1431] = {.lex_state = 15, .external_lex_state = 12},
  [1432] = {.lex_state = 0, .external_lex_state = 13},
  [1433] = {.lex_state = 15, .external_lex_state = 12},
  [1434] = {.lex_state = 15, .external_lex_state = 2},
  [1435] = {.lex_state = 15, .external_lex_state = 2},
  [1436] = {.lex_state = 15, .external_lex_state = 2},
  [1437] = {.lex_state = 15, .external_lex_state = 12},
  [1438] = {.lex_state = 15, .external_lex_state = 2},
  [1439] = {.lex_state = 15, .external_lex_state = 2},
  [1440] = {.lex_state = 15, .external_lex_state = 2},
  [1441] = {.lex_state = 15, .external_lex_state = 12},
  [1442] = {.lex_state = 15, .external_lex_state = 13},
  [1443] = {.lex_state = 15, .external_lex_state = 13},
  [1444] = {.lex_state = 23, .external_lex_state = 10},
  [1445] = {.lex_state = 15, .external_lex_state = 2},
  [1446] = {.lex_state = 15, .external_lex_state = 2},
  [1447] = {.lex_state = 15, .external_lex_state = 2},
  [1448] = {.lex_state = 15, .external_lex_state = 2},
  [1449] = {.lex_state = 15, .external_lex_state = 2},
  [1450] = {.lex_state = 1, .external_lex_state = 14},
  [1451] = {.lex_state = 15, .external_lex_state = 12},
  [1452] = {.lex_state = 15, .external_lex_state = 2},
  [1453] = {.lex_state = 15, .external_lex_state = 2},
  [1454] = {.lex_state = 15, .external_lex_state = 2},
  [1455] = {.lex_state = 23, .external_lex_state = 10},
  [1456] = {.lex_state = 23, .external_lex_state = 10},
  [1457] = {.lex_state = 15, .external_lex_state = 12},
  [1458] = {.lex_state = 15, .external_lex_state = 13},
  [1459] = {.lex_state = 15, .external_lex_state = 12},
  [1460] = {.lex_state = 15, .external_lex_state = 13},
  [1461] = {.lex_state = 15, .external_lex_state = 2},
  [1462] = {.lex_state = 15, .external_lex_state = 2},
  [1463] = {.lex_state = 15, .external_lex_state = 12},
  [1464] = {.lex_state = 15, .external_lex_state = 2},
  [1465] = {.lex_state = 15, .external_lex_state = 2},
  [1466] = {.lex_state = 15, .external_lex_state = 2},
  [1467] = {.lex_state = 15, .external_lex_state = 2},
  [1468] = {.lex_state = 15, .external_lex_state = 2},
  [1469] = {.lex_state = 15, .external_lex_state = 13},
  [1470] = {.lex_state = 15, .external_lex_state = 13},
  [1471] = {.lex_state = 15, .external_lex_state = 2},
  [1472] = {.lex_state = 15, .external_lex_state = 2},
  [1473] = {.lex_state = 15, .external_lex_state = 2},
  [1474] = {.lex_state = 15, .external_lex_state = 2},
  [1475] = {.lex_state = 15, .external_lex_state = 2},
  [1476] = {.lex_state = 15, .external_lex_state = 2},
  [1477] = {.lex_state = 15, .external_lex_state = 2},
  [1478] = {.lex_state = 23, .external_lex_state = 10},
  [1479] = {.lex_state = 15, .external_lex_state = 2},
  [1480] = {.lex_state = 15, .external_lex_state = 2},
  [1481] = {.lex_state = 15, .external_lex_state = 2},
  [1482] = {.lex_state = 43, .external_lex_state = 2},
  [1483] = {.lex_state = 23, .external_lex_state = 2},
  [1484] = {.lex_state = 43, .external_lex_state = 2},
  [1485] = {.lex_state = 43, .external_lex_state = 2},
  [1486] = {.lex_state = 43, .external_lex_state = 2},
  [1487] = {.lex_state = 43, .external_lex_state = 2},
  [1488] = {.lex_state = 43, .external_lex_state = 2},
  [1489] = {.lex_state = 352, .external_lex_state = 2},
  [1490] = {.lex_state = 43, .external_lex_state = 2},
  [1491] = {.lex_state = 43, .external_lex_state = 2},
  [1492] = {.lex_state = 43, .external_lex_state = 2},
  [1493] = {.lex_state = 11, .external_lex_state = 2},
  [1494] = {.lex_state = 43, .external_lex_state = 2},
  [1495] = {.lex_state = 43, .external_lex_state = 2},
  [1496] = {.lex_state = 11, .external_lex_state = 2},
  [1497] = {.lex_state = 23, .external_lex_state = 2},
  [1498] = {.lex_state = 43, .external_lex_state = 2},
  [1499] = {.lex_state = 23, .external_lex_state = 10},
  [1500] = {.lex_state = 11, .external_lex_state = 2},
  [1501] = {.lex_state = 11, .external_lex_state = 2},
  [1502] = {.lex_state = 23, .external_lex_state = 2},
  [1503] = {.lex_state = 33, .external_lex_state = 14},
  [1504] = {.lex_state = 23, .external_lex_state = 2},
  [1505] = {.lex_state = 43, .external_lex_state = 2},
  [1506] = {.lex_state = 20, .external_lex_state = 2},
  [1507] = {.lex_state = 20, .external_lex_state = 2},
  [1508] = {.lex_state = 43, .external_lex_state = 12},
  [1509] = {.lex_state = 34, .external_lex_state = 2},
  [1510] = {.lex_state = 43, .external_lex_state = 12},
  [1511] = {.lex_state = 43, .external_lex_state = 2},
  [1512] = {.lex_state = 43, .external_lex_state = 2},
  [1513] = {.lex_state = 33, .external_lex_state = 14},
  [1514] = {.lex_state = 23, .external_lex_state = 2},
  [1515] = {.lex_state = 43, .external_lex_state = 12},
  [1516] = {.lex_state = 33, .external_lex_state = 2},
  [1517] = {.lex_state = 33, .external_lex_state = 14},
  [1518] = {.lex_state = 43, .external_lex_state = 2},
  [1519] = {.lex_state = 33, .external_lex_state = 14},
  [1520] = {.lex_state = 43, .external_lex_state = 2},
  [1521] = {.lex_state = 33, .external_lex_state = 14},
  [1522] = {.lex_state = 33, .external_lex_state = 14},
  [1523] = {.lex_state = 33, .external_lex_state = 14},
  [1524] = {.lex_state = 33, .external_lex_state = 14},
  [1525] = {.lex_state = 33, .external_lex_state = 14},
  [1526] = {.lex_state = 33, .external_lex_state = 14},
  [1527] = {.lex_state = 11, .external_lex_state = 10},
  [1528] = {.lex_state = 27, .external_lex_state = 11},
  [1529] = {.lex_state = 27, .external_lex_state = 11},
  [1530] = {.lex_state = 27, .external_lex_state = 11},
  [1531] = {.lex_state = 27, .external_lex_state = 11},
  [1532] = {.lex_state = 27, .external_lex_state = 11},
  [1533] = {.lex_state = 11, .external_lex_state = 10},
  [1534] = {.lex_state = 27, .external_lex_state = 11},
  [1535] = {.lex_state = 27, .external_lex_state = 11},
  [1536] = {.lex_state = 27, .external_lex_state = 11},
  [1537] = {.lex_state = 11, .external_lex_state = 10},
  [1538] = {.lex_state = 0, .external_lex_state = 13},
  [1539] = {.lex_state = 0, .external_lex_state = 12},
  [1540] = {.lex_state = 0, .external_lex_state = 13},
  [1541] = {.lex_state = 0, .external_lex_state = 12},
  [1542] = {.lex_state = 11, .external_lex_state = 10},
  [1543] = {.lex_state = 0, .external_lex_state = 12},
  [1544] = {.lex_state = 0, .external_lex_state = 12},
  [1545] = {.lex_state = 0, .external_lex_state = 12},
  [1546] = {.lex_state = 0, .external_lex_state = 13},
  [1547] = {.lex_state = 0, .external_lex_state = 12},
  [1548] = {.lex_state = 0, .external_lex_state = 13},
  [1549] = {.lex_state = 0, .external_lex_state = 12},
  [1550] = {.lex_state = 11, .external_lex_state = 10},
  [1551] = {.lex_state = 0, .external_lex_state = 12},
  [1552] = {.lex_state = 333, .external_lex_state = 2},
  [1553] = {.lex_state = 0, .external_lex_state = 12},
  [1554] = {.lex_state = 0, .external_lex_state = 13},
  [1555] = {.lex_state = 0, .external_lex_state = 13},
  [1556] = {.lex_state = 0, .external_lex_state = 13},
  [1557] = {.lex_state = 333, .external_lex_state = 2},
  [1558] = {.lex_state = 0, .external_lex_state = 12},
  [1559] = {.lex_state = 0, .external_lex_state = 12},
  [1560] = {.lex_state = 33, .external_lex_state = 2},
  [1561] = {.lex_state = 333, .external_lex_state = 2},
  [1562] = {.lex_state = 11, .external_lex_state = 10},
  [1563] = {.lex_state = 33, .external_lex_state = 2},
  [1564] = {.lex_state = 0, .external_lex_state = 12},
  [1565] = {.lex_state = 0, .external_lex_state = 13},
  [1566] = {.lex_state = 11, .external_lex_state = 10},
  [1567] = {.lex_state = 33, .external_lex_state = 2},
  [1568] = {.lex_state = 33, .external_lex_state = 2},
  [1569] = {.lex_state = 11, .external_lex_state = 10},
  [1570] = {.lex_state = 0, .external_lex_state = 12},
  [1571] = {.lex_state = 11, .external_lex_state = 10},
  [1572] = {.lex_state = 33, .external_lex_state = 2},
  [1573] = {.lex_state = 0, .external_lex_state = 12},
  [1574] = {.lex_state = 0, .external_lex_state = 12},
  [1575] = {.lex_state = 0, .external_lex_state = 12},
  [1576] = {.lex_state = 11, .external_lex_state = 10},
  [1577] = {.lex_state = 0, .external_lex_state = 12},
  [1578] = {.lex_state = 0, .external_lex_state = 15},
  [1579] = {.lex_state = 33, .external_lex_state = 2},
  [1580] = {.lex_state = 0, .external_lex_state = 15},
  [1581] = {.lex_state = 11, .external_lex_state = 12},
  [1582] = {.lex_state = 11, .external_lex_state = 12},
  [1583] = {.lex_state = 11, .external_lex_state = 12},
  [1584] = {.lex_state = 0, .external_lex_state = 15},
  [1585] = {.lex_state = 11, .external_lex_state = 12},
  [1586] = {.lex_state = 0, .external_lex_state = 15},
  [1587] = {.lex_state = 0, .external_lex_state = 15},
  [1588] = {.lex_state = 0, .external_lex_state = 15},
  [1589] = {.lex_state = 33, .external_lex_state = 2},
  [1590] = {.lex_state = 334, .external_lex_state = 2},
  [1591] = {.lex_state = 0, .external_lex_state = 15},
  [1592] = {.lex_state = 11, .external_lex_state = 2},
  [1593] = {.lex_state = 11, .external_lex_state = 11},
  [1594] = {.lex_state = 334, .external_lex_state = 2},
  [1595] = {.lex_state = 11, .external_lex_state = 12},
  [1596] = {.lex_state = 0, .external_lex_state = 15},
  [1597] = {.lex_state = 0, .external_lex_state = 15},
  [1598] = {.lex_state = 11, .external_lex_state = 10},
  [1599] = {.lex_state = 33, .external_lex_state = 2},
  [1600] = {.lex_state = 0, .external_lex_state = 15},
  [1601] = {.lex_state = 11, .external_lex_state = 12},
  [1602] = {.lex_state = 0, .external_lex_state = 15},
  [1603] = {.lex_state = 0, .external_lex_state = 15},
  [1604] = {.lex_state = 11, .external_lex_state = 2},
  [1605] = {.lex_state = 0, .external_lex_state = 15},
  [1606] = {.lex_state = 11, .external_lex_state = 12},
  [1607] = {.lex_state = 11, .external_lex_state = 12},
  [1608] = {.lex_state = 334, .external_lex_state = 2},
  [1609] = {.lex_state = 0, .external_lex_state = 15},
  [1610] = {.lex_state = 0, .external_lex_state = 15},
  [1611] = {.lex_state = 11, .external_lex_state = 12},
  [1612] = {.lex_state = 0, .external_lex_state = 15},
  [1613] = {.lex_state = 11, .external_lex_state = 11},
  [1614] = {.lex_state = 0, .external_lex_state = 15},
  [1615] = {.lex_state = 0, .external_lex_state = 15},
  [1616] = {.lex_state = 11, .external_lex_state = 12},
  [1617] = {.lex_state = 11, .external_lex_state = 2},
  [1618] = {.lex_state = 0, .external_lex_state = 15},
  [1619] = {.lex_state = 27, .external_lex_state = 11},
  [1620] = {.lex_state = 27, .external_lex_state = 11},
  [1621] = {.lex_state = 11, .external_lex_state = 13},
  [1622] = {.lex_state = 11, .external_lex_state = 11},
  [1623] = {.lex_state = 11, .external_lex_state = 11},
  [1624] = {.lex_state = 11, .external_lex_state = 11},
  [1625] = {.lex_state = 11, .external_lex_state = 11},
  [1626] = {.lex_state = 27, .external_lex_state = 11},
  [1627] = {.lex_state = 27, .external_lex_state = 11},
  [1628] = {.lex_state = 11, .external_lex_state = 11},
  [1629] = {.lex_state = 11, .external_lex_state = 11},
  [1630] = {.lex_state = 11, .external_lex_state = 11},
  [1631] = {.lex_state = 11, .external_lex_state = 13},
  [1632] = {.lex_state = 11, .external_lex_state = 2},
  [1633] = {.lex_state = 11, .external_lex_state = 2},
  [1634] = {.lex_state = 27, .external_lex_state = 11},
  [1635] = {.lex_state = 11, .external_lex_state = 13},
  [1636] = {.lex_state = 27, .external_lex_state = 11},
  [1637] = {.lex_state = 11, .external_lex_state = 2},
  [1638] = {.lex_state = 11, .external_lex_state = 2},
  [1639] = {.lex_state = 11, .external_lex_state = 13},
  [1640] = {.lex_state = 11, .external_lex_state = 2},
  [1641] = {.lex_state = 20, .external_lex_state = 10},
  [1642] = {.lex_state = 11, .external_lex_state = 2},
  [1643] = {.lex_state = 27, .external_lex_state = 11},
  [1644] = {.lex_state = 11, .external_lex_state = 11},
  [1645] = {.lex_state = 27, .external_lex_state = 11},
  [1646] = {.lex_state = 11, .external_lex_state = 13},
  [1647] = {.lex_state = 11, .external_lex_state = 11},
  [1648] = {.lex_state = 11, .external_lex_state = 13},
  [1649] = {.lex_state = 27, .external_lex_state = 11},
  [1650] = {.lex_state = 11, .external_lex_state = 2},
  [1651] = {.lex_state = 11, .external_lex_state = 13},
  [1652] = {.lex_state = 33, .external_lex_state = 2},
  [1653] = {.lex_state = 11, .external_lex_state = 13},
  [1654] = {.lex_state = 11, .external_lex_state = 13},
  [1655] = {.lex_state = 11, .external_lex_state = 11},
  [1656] = {.lex_state = 11, .external_lex_state = 11},
  [1657] = {.lex_state = 11, .external_lex_state = 13},
  [1658] = {.lex_state = 20, .external_lex_state = 10},
  [1659] = {.lex_state = 0, .external_lex_state = 13},
  [1660] = {.lex_state = 20, .external_lex_state = 10},
  [1661] = {.lex_state = 0, .external_lex_state = 11},
  [1662] = {.lex_state = 20, .external_lex_state = 10},
  [1663] = {.lex_state = 0, .external_lex_state = 13},
  [1664] = {.lex_state = 20, .external_lex_state = 10},
  [1665] = {.lex_state = 33, .external_lex_state = 2},
  [1666] = {.lex_state = 0, .external_lex_state = 12},
  [1667] = {.lex_state = 33, .external_lex_state = 2},
  [1668] = {.lex_state = 0, .external_lex_state = 11},
  [1669] = {.lex_state = 5, .external_lex_state = 2},
  [1670] = {.lex_state = 0, .external_lex_state = 11},
  [1671] = {.lex_state = 0, .external_lex_state = 12},
  [1672] = {.lex_state = 20, .external_lex_state = 10},
  [1673] = {.lex_state = 333, .external_lex_state = 2},
  [1674] = {.lex_state = 20, .external_lex_state = 10},
  [1675] = {.lex_state = 11, .external_lex_state = 13},
  [1676] = {.lex_state = 20, .external_lex_state = 10},
  [1677] = {.lex_state = 20, .external_lex_state = 10},
  [1678] = {.lex_state = 0, .external_lex_state = 12},
  [1679] = {.lex_state = 20, .external_lex_state = 10},
  [1680] = {.lex_state = 33, .external_lex_state = 2},
  [1681] = {.lex_state = 0, .external_lex_state = 13},
  [1682] = {.lex_state = 11, .external_lex_state = 13},
  [1683] = {.lex_state = 0, .external_lex_state = 11},
  [1684] = {.lex_state = 36, .external_lex_state = 2},
  [1685] = {.lex_state = 11, .external_lex_state = 13},
  [1686] = {.lex_state = 20, .external_lex_state = 10},
  [1687] = {.lex_state = 11, .external_lex_state = 13},
  [1688] = {.lex_state = 5, .external_lex_state = 2},
  [1689] = {.lex_state = 20, .external_lex_state = 10},
  [1690] = {.lex_state = 20, .external_lex_state = 10},
  [1691] = {.lex_state = 0, .external_lex_state = 13},
  [1692] = {.lex_state = 0, .external_lex_state = 12},
  [1693] = {.lex_state = 11, .external_lex_state = 13},
  [1694] = {.lex_state = 333, .external_lex_state = 2},
  [1695] = {.lex_state = 36, .external_lex_state = 2},
  [1696] = {.lex_state = 0, .external_lex_state = 12},
  [1697] = {.lex_state = 0, .external_lex_state = 2},
  [1698] = {.lex_state = 333, .external_lex_state = 2},
  [1699] = {.lex_state = 11, .external_lex_state = 13},
  [1700] = {.lex_state = 11, .external_lex_state = 13},
  [1701] = {.lex_state = 0, .external_lex_state = 13},
  [1702] = {.lex_state = 11, .external_lex_state = 13},
  [1703] = {.lex_state = 36, .external_lex_state = 2},
  [1704] = {.lex_state = 0, .external_lex_state = 12},
  [1705] = {.lex_state = 0, .external_lex_state = 2},
  [1706] = {.lex_state = 20, .external_lex_state = 10},
  [1707] = {.lex_state = 20, .external_lex_state = 10},
  [1708] = {.lex_state = 0, .external_lex_state = 13},
  [1709] = {.lex_state = 0, .external_lex_state = 13},
  [1710] = {.lex_state = 0, .external_lex_state = 13},
  [1711] = {.lex_state = 0, .external_lex_state = 13},
  [1712] = {.lex_state = 0, .external_lex_state = 13},
  [1713] = {.lex_state = 0, .external_lex_state = 12},
  [1714] = {.lex_state = 36, .external_lex_state = 2},
  [1715] = {.lex_state = 0, .external_lex_state = 12},
  [1716] = {.lex_state = 0, .external_lex_state = 12},
  [1717] = {.lex_state = 20, .external_lex_state = 10},
  [1718] = {.lex_state = 0, .external_lex_state = 12},
  [1719] = {.lex_state = 11, .external_lex_state = 13},
  [1720] = {.lex_state = 0, .external_lex_state = 13},
  [1721] = {.lex_state = 0, .external_lex_state = 13},
  [1722] = {.lex_state = 0, .external_lex_state = 12},
  [1723] = {.lex_state = 0, .external_lex_state = 12},
  [1724] = {.lex_state = 11, .external_lex_state = 13},
  [1725] = {.lex_state = 55, .external_lex_state = 2},
  [1726] = {.lex_state = 0, .external_lex_state = 11},
  [1727] = {.lex_state = 20, .external_lex_state = 12},
  [1728] = {.lex_state = 334, .external_lex_state = 2},
  [1729] = {.lex_state = 0, .external_lex_state = 11},
  [1730] = {.lex_state = 0, .external_lex_state = 11},
  [1731] = {.lex_state = 11, .external_lex_state = 13},
  [1732] = {.lex_state = 0, .external_lex_state = 15},
  [1733] = {.lex_state = 11, .external_lex_state = 2},
  [1734] = {.lex_state = 0, .external_lex_state = 12},
  [1735] = {.lex_state = 0, .external_lex_state = 11},
  [1736] = {.lex_state = 20, .external_lex_state = 10},
  [1737] = {.lex_state = 0, .external_lex_state = 12},
  [1738] = {.lex_state = 0, .external_lex_state = 15},
  [1739] = {.lex_state = 0, .external_lex_state = 11},
  [1740] = {.lex_state = 0, .external_lex_state = 13},
  [1741] = {.lex_state = 0, .external_lex_state = 11},
  [1742] = {.lex_state = 0, .external_lex_state = 11},
  [1743] = {.lex_state = 0, .external_lex_state = 11},
  [1744] = {.lex_state = 334, .external_lex_state = 2},
  [1745] = {.lex_state = 0, .external_lex_state = 13},
  [1746] = {.lex_state = 0, .external_lex_state = 11},
  [1747] = {.lex_state = 0, .external_lex_state = 11},
  [1748] = {.lex_state = 11, .external_lex_state = 2},
  [1749] = {.lex_state = 20, .external_lex_state = 13},
  [1750] = {.lex_state = 352, .external_lex_state = 14},
  [1751] = {.lex_state = 0, .external_lex_state = 13},
  [1752] = {.lex_state = 0, .external_lex_state = 13},
  [1753] = {.lex_state = 11, .external_lex_state = 13},
  [1754] = {.lex_state = 334, .external_lex_state = 2},
  [1755] = {.lex_state = 20, .external_lex_state = 10},
  [1756] = {.lex_state = 0, .external_lex_state = 11},
  [1757] = {.lex_state = 52, .external_lex_state = 2},
  [1758] = {.lex_state = 0, .external_lex_state = 12},
  [1759] = {.lex_state = 0, .external_lex_state = 11},
  [1760] = {.lex_state = 11, .external_lex_state = 13},
  [1761] = {.lex_state = 20, .external_lex_state = 10},
  [1762] = {.lex_state = 0, .external_lex_state = 12},
  [1763] = {.lex_state = 11, .external_lex_state = 2},
  [1764] = {.lex_state = 0, .external_lex_state = 12},
  [1765] = {.lex_state = 11, .external_lex_state = 10},
  [1766] = {.lex_state = 11, .external_lex_state = 13},
  [1767] = {.lex_state = 11, .external_lex_state = 12},
  [1768] = {.lex_state = 20, .external_lex_state = 12},
  [1769] = {.lex_state = 20, .external_lex_state = 13},
  [1770] = {.lex_state = 0, .external_lex_state = 13},
  [1771] = {.lex_state = 20, .external_lex_state = 12},
  [1772] = {.lex_state = 20, .external_lex_state = 11},
  [1773] = {.lex_state = 20, .external_lex_state = 12},
  [1774] = {.lex_state = 0, .external_lex_state = 13},
  [1775] = {.lex_state = 11, .external_lex_state = 2},
  [1776] = {.lex_state = 352, .external_lex_state = 11},
  [1777] = {.lex_state = 0, .external_lex_state = 15},
  [1778] = {.lex_state = 0, .external_lex_state = 15},
  [1779] = {.lex_state = 11, .external_lex_state = 12},
  [1780] = {.lex_state = 20, .external_lex_state = 11},
  [1781] = {.lex_state = 20, .external_lex_state = 11},
  [1782] = {.lex_state = 20, .external_lex_state = 10},
  [1783] = {.lex_state = 20, .external_lex_state = 10},
  [1784] = {.lex_state = 11, .external_lex_state = 12},
  [1785] = {.lex_state = 58, .external_lex_state = 2},
  [1786] = {.lex_state = 11, .external_lex_state = 13},
  [1787] = {.lex_state = 20, .external_lex_state = 12},
  [1788] = {.lex_state = 11, .external_lex_state = 2},
  [1789] = {.lex_state = 0, .external_lex_state = 12},
  [1790] = {.lex_state = 20, .external_lex_state = 11},
  [1791] = {.lex_state = 20, .external_lex_state = 10},
  [1792] = {.lex_state = 20, .external_lex_state = 12},
  [1793] = {.lex_state = 20, .external_lex_state = 12},
  [1794] = {.lex_state = 0, .external_lex_state = 15},
  [1795] = {.lex_state = 11, .external_lex_state = 12},
  [1796] = {.lex_state = 11, .external_lex_state = 12},
  [1797] = {.lex_state = 11, .external_lex_state = 10},
  [1798] = {.lex_state = 0, .external_lex_state = 12},
  [1799] = {.lex_state = 0, .external_lex_state = 13},
  [1800] = {.lex_state = 20, .external_lex_state = 13},
  [1801] = {.lex_state = 352, .external_lex_state = 11},
  [1802] = {.lex_state = 11, .external_lex_state = 2},
  [1803] = {.lex_state = 11, .external_lex_state = 13},
  [1804] = {.lex_state = 11, .external_lex_state = 12},
  [1805] = {.lex_state = 35, .external_lex_state = 2},
  [1806] = {.lex_state = 20, .external_lex_state = 10},
  [1807] = {.lex_state = 352, .external_lex_state = 11},
  [1808] = {.lex_state = 11, .external_lex_state = 12},
  [1809] = {.lex_state = 20, .external_lex_state = 12},
  [1810] = {.lex_state = 11, .external_lex_state = 12},
  [1811] = {.lex_state = 20, .external_lex_state = 12},
  [1812] = {.lex_state = 0, .external_lex_state = 13},
  [1813] = {.lex_state = 20, .external_lex_state = 10},
  [1814] = {.lex_state = 20, .external_lex_state = 12},
  [1815] = {.lex_state = 20, .external_lex_state = 13},
  [1816] = {.lex_state = 11, .external_lex_state = 10},
  [1817] = {.lex_state = 35, .external_lex_state = 2},
  [1818] = {.lex_state = 11, .external_lex_state = 10},
  [1819] = {.lex_state = 20, .external_lex_state = 13},
  [1820] = {.lex_state = 11, .external_lex_state = 2},
  [1821] = {.lex_state = 0, .external_lex_state = 12},
  [1822] = {.lex_state = 11, .external_lex_state = 10},
  [1823] = {.lex_state = 20, .external_lex_state = 12},
  [1824] = {.lex_state = 20, .external_lex_state = 13},
  [1825] = {.lex_state = 20, .external_lex_state = 13},
  [1826] = {.lex_state = 0, .external_lex_state = 11},
  [1827] = {.lex_state = 0, .external_lex_state = 15},
  [1828] = {.lex_state = 11, .external_lex_state = 13},
  [1829] = {.lex_state = 0, .external_lex_state = 15},
  [1830] = {.lex_state = 0, .external_lex_state = 15},
  [1831] = {.lex_state = 0, .external_lex_state = 15},
  [1832] = {.lex_state = 11, .external_lex_state = 10},
  [1833] = {.lex_state = 0, .external_lex_state = 15},
  [1834] = {.lex_state = 0, .external_lex_state = 13},
  [1835] = {.lex_state = 0, .external_lex_state = 11},
  [1836] = {.lex_state = 0, .external_lex_state = 11},
  [1837] = {.lex_state = 20, .external_lex_state = 10},
  [1838] = {.lex_state = 11, .external_lex_state = 10},
  [1839] = {.lex_state = 11, .external_lex_state = 10},
  [1840] = {.lex_state = 352, .external_lex_state = 14},
  [1841] = {.lex_state = 0, .external_lex_state = 11},
  [1842] = {.lex_state = 20, .external_lex_state = 12},
  [1843] = {.lex_state = 11, .external_lex_state = 10},
  [1844] = {.lex_state = 0, .external_lex_state = 12},
  [1845] = {.lex_state = 352, .external_lex_state = 11},
  [1846] = {.lex_state = 11, .external_lex_state = 12},
  [1847] = {.lex_state = 20, .external_lex_state = 13},
  [1848] = {.lex_state = 11, .external_lex_state = 2},
  [1849] = {.lex_state = 0, .external_lex_state = 11},
  [1850] = {.lex_state = 32, .external_lex_state = 2},
  [1851] = {.lex_state = 11, .external_lex_state = 2},
  [1852] = {.lex_state = 20, .external_lex_state = 10},
  [1853] = {.lex_state = 11, .external_lex_state = 2},
  [1854] = {.lex_state = 43, .external_lex_state = 2},
  [1855] = {.lex_state = 11, .external_lex_state = 12},
  [1856] = {.lex_state = 20, .external_lex_state = 2},
  [1857] = {.lex_state = 20, .external_lex_state = 2},
  [1858] = {.lex_state = 1, .external_lex_state = 2},
  [1859] = {.lex_state = 20, .external_lex_state = 2},
  [1860] = {.lex_state = 11, .external_lex_state = 13},
  [1861] = {.lex_state = 0, .external_lex_state = 11},
  [1862] = {.lex_state = 11, .external_lex_state = 13},
  [1863] = {.lex_state = 0, .external_lex_state = 11},
  [1864] = {.lex_state = 20, .external_lex_state = 2},
  [1865] = {.lex_state = 352, .external_lex_state = 11},
  [1866] = {.lex_state = 11, .external_lex_state = 2},
  [1867] = {.lex_state = 0, .external_lex_state = 12},
  [1868] = {.lex_state = 2, .external_lex_state = 2},
  [1869] = {.lex_state = 0, .external_lex_state = 12},
  [1870] = {.lex_state = 11, .external_lex_state = 2},
  [1871] = {.lex_state = 0, .external_lex_state = 16},
  [1872] = {.lex_state = 20, .external_lex_state = 12},
  [1873] = {.lex_state = 11, .external_lex_state = 2},
  [1874] = {.lex_state = 10, .external_lex_state = 11},
  [1875] = {.lex_state = 11, .external_lex_state = 2},
  [1876] = {.lex_state = 0, .external_lex_state = 13},
  [1877] = {.lex_state = 352, .external_lex_state = 11},
  [1878] = {.lex_state = 0, .external_lex_state = 10},
  [1879] = {.lex_state = 0, .external_lex_state = 10},
  [1880] = {.lex_state = 0, .external_lex_state = 11},
  [1881] = {.lex_state = 0, .external_lex_state = 16},
  [1882] = {.lex_state = 11, .external_lex_state = 2},
  [1883] = {.lex_state = 11, .external_lex_state = 2},
  [1884] = {.lex_state = 0, .external_lex_state = 12},
  [1885] = {.lex_state = 11, .external_lex_state = 2},
  [1886] = {.lex_state = 11, .external_lex_state = 2},
  [1887] = {.lex_state = 20, .external_lex_state = 2},
  [1888] = {.lex_state = 20, .external_lex_state = 2},
  [1889] = {.lex_state = 32, .external_lex_state = 2},
  [1890] = {.lex_state = 352, .external_lex_state = 11},
  [1891] = {.lex_state = 20, .external_lex_state = 12},
  [1892] = {.lex_state = 20, .external_lex_state = 10},
  [1893] = {.lex_state = 11, .external_lex_state = 2},
  [1894] = {.lex_state = 5, .external_lex_state = 2},
  [1895] = {.lex_state = 11, .external_lex_state = 2},
  [1896] = {.lex_state = 11, .external_lex_state = 13},
  [1897] = {.lex_state = 11, .external_lex_state = 2},
  [1898] = {.lex_state = 20, .external_lex_state = 11},
  [1899] = {.lex_state = 5, .external_lex_state = 2},
  [1900] = {.lex_state = 10, .external_lex_state = 11},
  [1901] = {.lex_state = 20, .external_lex_state = 11},
  [1902] = {.lex_state = 11, .external_lex_state = 13},
  [1903] = {.lex_state = 20, .external_lex_state = 2},
  [1904] = {.lex_state = 352, .external_lex_state = 11},
  [1905] = {.lex_state = 20, .external_lex_state = 2},
  [1906] = {.lex_state = 20, .external_lex_state = 12},
  [1907] = {.lex_state = 20, .external_lex_state = 2},
  [1908] = {.lex_state = 11, .external_lex_state = 13},
  [1909] = {.lex_state = 43, .external_lex_state = 10},
  [1910] = {.lex_state = 20, .external_lex_state = 2},
  [1911] = {.lex_state = 20, .external_lex_state = 11},
  [1912] = {.lex_state = 20, .external_lex_state = 2},
  [1913] = {.lex_state = 11, .external_lex_state = 13},
  [1914] = {.lex_state = 352, .external_lex_state = 11},
  [1915] = {.lex_state = 11, .external_lex_state = 13},
  [1916] = {.lex_state = 43, .external_lex_state = 10},
  [1917] = {.lex_state = 11, .external_lex_state = 13},
  [1918] = {.lex_state = 0, .external_lex_state = 16},
  [1919] = {.lex_state = 5, .external_lex_state = 2},
  [1920] = {.lex_state = 352, .external_lex_state = 14},
  [1921] = {.lex_state = 20, .external_lex_state = 11},
  [1922] = {.lex_state = 20, .external_lex_state = 2},
  [1923] = {.lex_state = 43, .external_lex_state = 10},
  [1924] = {.lex_state = 20, .external_lex_state = 2},
  [1925] = {.lex_state = 20, .external_lex_state = 2},
  [1926] = {.lex_state = 0, .external_lex_state = 13},
  [1927] = {.lex_state = 0, .external_lex_state = 13},
  [1928] = {.lex_state = 0, .external_lex_state = 16},
  [1929] = {.lex_state = 11, .external_lex_state = 2},
  [1930] = {.lex_state = 10, .external_lex_state = 11},
  [1931] = {.lex_state = 0, .external_lex_state = 16},
  [1932] = {.lex_state = 11, .external_lex_state = 2},
  [1933] = {.lex_state = 0, .external_lex_state = 16},
  [1934] = {.lex_state = 352, .external_lex_state = 11},
  [1935] = {.lex_state = 11, .external_lex_state = 2},
  [1936] = {.lex_state = 11, .external_lex_state = 13},
  [1937] = {.lex_state = 2, .external_lex_state = 2},
  [1938] = {.lex_state = 0, .external_lex_state = 16},
  [1939] = {.lex_state = 352, .external_lex_state = 11},
  [1940] = {.lex_state = 1, .external_lex_state = 2},
  [1941] = {.lex_state = 20, .external_lex_state = 2},
  [1942] = {.lex_state = 20, .external_lex_state = 2},
  [1943] = {.lex_state = 20, .external_lex_state = 10},
  [1944] = {.lex_state = 352, .external_lex_state = 14},
  [1945] = {.lex_state = 0, .external_lex_state = 10},
  [1946] = {.lex_state = 352, .external_lex_state = 14},
  [1947] = {.lex_state = 352, .external_lex_state = 11},
  [1948] = {.lex_state = 43, .external_lex_state = 2},
  [1949] = {.lex_state = 3, .external_lex_state = 2},
  [1950] = {.lex_state = 0, .external_lex_state = 10},
  [1951] = {.lex_state = 4, .external_lex_state = 2},
  [1952] = {.lex_state = 0, .external_lex_state = 10},
  [1953] = {.lex_state = 43, .external_lex_state = 2},
  [1954] = {.lex_state = 0, .external_lex_state = 10},
  [1955] = {.lex_state = 0, .external_lex_state = 10},
  [1956] = {.lex_state = 0, .external_lex_state = 10},
  [1957] = {.lex_state = 56, .external_lex_state = 2},
  [1958] = {.lex_state = 0, .external_lex_state = 10},
  [1959] = {.lex_state = 0, .external_lex_state = 10},
  [1960] = {.lex_state = 43, .external_lex_state = 12},
  [1961] = {.lex_state = 3, .external_lex_state = 2},
  [1962] = {.lex_state = 352, .external_lex_state = 11},
  [1963] = {.lex_state = 11, .external_lex_state = 2},
  [1964] = {.lex_state = 0, .external_lex_state = 10},
  [1965] = {.lex_state = 35, .external_lex_state = 2},
  [1966] = {.lex_state = 35, .external_lex_state = 2},
  [1967] = {.lex_state = 3, .external_lex_state = 2},
  [1968] = {.lex_state = 0, .external_lex_state = 10},
  [1969] = {.lex_state = 0, .external_lex_state = 10},
  [1970] = {.lex_state = 0, .external_lex_state = 10},
  [1971] = {.lex_state = 43, .external_lex_state = 12},
  [1972] = {.lex_state = 43, .external_lex_state = 2},
  [1973] = {.lex_state = 0, .external_lex_state = 10},
  [1974] = {.lex_state = 20, .external_lex_state = 12},
  [1975] = {.lex_state = 352, .external_lex_state = 14},
  [1976] = {.lex_state = 20, .external_lex_state = 12},
  [1977] = {.lex_state = 0, .external_lex_state = 10},
  [1978] = {.lex_state = 0, .external_lex_state = 10},
  [1979] = {.lex_state = 0, .external_lex_state = 10},
  [1980] = {.lex_state = 1, .external_lex_state = 2},
  [1981] = {.lex_state = 43, .external_lex_state = 12},
  [1982] = {.lex_state = 56, .external_lex_state = 2},
  [1983] = {.lex_state = 0, .external_lex_state = 10},
  [1984] = {.lex_state = 0, .external_lex_state = 10},
  [1985] = {.lex_state = 352, .external_lex_state = 12},
  [1986] = {.lex_state = 0, .external_lex_state = 12},
  [1987] = {.lex_state = 0, .external_lex_state = 12},
  [1988] = {.lex_state = 0, .external_lex_state = 11},
  [1989] = {.lex_state = 352, .external_lex_state = 2},
  [1990] = {.lex_state = 10, .external_lex_state = 11},
  [1991] = {.lex_state = 0, .external_lex_state = 12},
  [1992] = {.lex_state = 0, .external_lex_state = 13},
  [1993] = {.lex_state = 43, .external_lex_state = 2},
  [1994] = {.lex_state = 0, .external_lex_state = 12},
  [1995] = {.lex_state = 0, .external_lex_state = 12},
  [1996] = {.lex_state = 0, .external_lex_state = 10},
  [1997] = {.lex_state = 0, .external_lex_state = 10},
  [1998] = {.lex_state = 0, .external_lex_state = 12},
  [1999] = {.lex_state = 0, .external_lex_state = 11},
  [2000] = {.lex_state = 352, .external_lex_state = 11},
  [2001] = {.lex_state = 20, .external_lex_state = 12},
  [2002] = {.lex_state = 0, .external_lex_state = 13},
  [2003] = {.lex_state = 0, .external_lex_state = 13},
  [2004] = {.lex_state = 0, .external_lex_state = 12},
  [2005] = {.lex_state = 20, .external_lex_state = 2},
  [2006] = {.lex_state = 0, .external_lex_state = 12},
  [2007] = {.lex_state = 10, .external_lex_state = 11},
  [2008] = {.lex_state = 10, .external_lex_state = 11},
  [2009] = {.lex_state = 0, .external_lex_state = 10},
  [2010] = {.lex_state = 10, .external_lex_state = 11},
  [2011] = {.lex_state = 56, .external_lex_state = 2},
  [2012] = {.lex_state = 352, .external_lex_state = 11},
  [2013] = {.lex_state = 0, .external_lex_state = 12},
  [2014] = {.lex_state = 0, .external_lex_state = 12},
  [2015] = {.lex_state = 20, .external_lex_state = 2},
  [2016] = {.lex_state = 0, .external_lex_state = 11},
  [2017] = {.lex_state = 0, .external_lex_state = 2},
  [2018] = {.lex_state = 0, .external_lex_state = 2},
  [2019] = {.lex_state = 10, .external_lex_state = 11},
  [2020] = {.lex_state = 10, .external_lex_state = 11},
  [2021] = {.lex_state = 10, .external_lex_state = 11},
  [2022] = {.lex_state = 0, .external_lex_state = 13},
  [2023] = {.lex_state = 352, .external_lex_state = 2},
  [2024] = {.lex_state = 0, .external_lex_state = 12},
  [2025] = {.lex_state = 0, .external_lex_state = 13},
  [2026] = {.lex_state = 0, .external_lex_state = 12},
  [2027] = {.lex_state = 0, .external_lex_state = 2},
  [2028] = {.lex_state = 0, .external_lex_state = 2},
  [2029] = {.lex_state = 0, .external_lex_state = 2},
  [2030] = {.lex_state = 0, .external_lex_state = 2},
  [2031] = {.lex_state = 11, .external_lex_state = 2},
  [2032] = {.lex_state = 0, .external_lex_state = 11},
  [2033] = {.lex_state = 0, .external_lex_state = 10},
  [2034] = {.lex_state = 352, .external_lex_state = 2},
  [2035] = {.lex_state = 0, .external_lex_state = 2},
  [2036] = {.lex_state = 352, .external_lex_state = 2},
  [2037] = {.lex_state = 0, .external_lex_state = 10},
  [2038] = {.lex_state = 0, .external_lex_state = 10},
  [2039] = {.lex_state = 0, .external_lex_state = 13},
  [2040] = {.lex_state = 0, .external_lex_state = 13},
  [2041] = {.lex_state = 0, .external_lex_state = 12},
  [2042] = {.lex_state = 0, .external_lex_state = 2},
  [2043] = {.lex_state = 0, .external_lex_state = 12},
  [2044] = {.lex_state = 0, .external_lex_state = 12},
  [2045] = {.lex_state = 0, .external_lex_state = 12},
  [2046] = {.lex_state = 0, .external_lex_state = 13},
  [2047] = {.lex_state = 0, .external_lex_state = 12},
  [2048] = {.lex_state = 0, .external_lex_state = 2},
  [2049] = {.lex_state = 0, .external_lex_state = 12},
  [2050] = {.lex_state = 0, .external_lex_state = 12},
  [2051] = {.lex_state = 20, .external_lex_state = 2},
  [2052] = {.lex_state = 0, .external_lex_state = 10},
  [2053] = {.lex_state = 0, .external_lex_state = 13},
  [2054] = {.lex_state = 0, .external_lex_state = 13},
  [2055] = {.lex_state = 0, .external_lex_state = 11},
  [2056] = {.lex_state = 0, .external_lex_state = 10},
  [2057] = {.lex_state = 0, .external_lex_state = 13},
  [2058] = {.lex_state = 0, .external_lex_state = 12},
  [2059] = {.lex_state = 0, .external_lex_state = 13},
  [2060] = {.lex_state = 0, .external_lex_state = 16},
  [2061] = {.lex_state = 0, .external_lex_state = 12},
  [2062] = {.lex_state = 0, .external_lex_state = 13},
  [2063] = {.lex_state = 352, .external_lex_state = 12},
  [2064] = {.lex_state = 0, .external_lex_state = 10},
  [2065] = {.lex_state = 352, .external_lex_state = 2},
  [2066] = {.lex_state = 0, .external_lex_state = 11},
  [2067] = {.lex_state = 0, .external_lex_state = 12},
  [2068] = {.lex_state = 0, .external_lex_state = 12},
  [2069] = {.lex_state = 352, .external_lex_state = 2},
  [2070] = {.lex_state = 0, .external_lex_state = 12},
  [2071] = {.lex_state = 0, .external_lex_state = 13},
  [2072] = {.lex_state = 0, .external_lex_state = 13},
  [2073] = {.lex_state = 0, .external_lex_state = 10},
  [2074] = {.lex_state = 0, .external_lex_state = 12},
  [2075] = {.lex_state = 0, .external_lex_state = 12},
  [2076] = {.lex_state = 0, .external_lex_state = 13},
  [2077] = {.lex_state = 0, .external_lex_state = 12},
  [2078] = {.lex_state = 0, .external_lex_state = 12},
  [2079] = {.lex_state = 0, .external_lex_state = 13},
  [2080] = {.lex_state = 0, .external_lex_state = 11},
  [2081] = {.lex_state = 0, .external_lex_state = 12},
  [2082] = {.lex_state = 0, .external_lex_state = 11},
  [2083] = {.lex_state = 10, .external_lex_state = 11},
  [2084] = {.lex_state = 0, .external_lex_state = 13},
  [2085] = {.lex_state = 0, .external_lex_state = 13},
  [2086] = {.lex_state = 352, .external_lex_state = 2},
  [2087] = {.lex_state = 352, .external_lex_state = 2},
  [2088] = {.lex_state = 0, .external_lex_state = 12},
  [2089] = {.lex_state = 0, .external_lex_state = 12},
  [2090] = {.lex_state = 0, .external_lex_state = 11},
  [2091] = {.lex_state = 0, .external_lex_state = 10},
  [2092] = {.lex_state = 0, .external_lex_state = 12},
  [2093] = {.lex_state = 0, .external_lex_state = 12},
  [2094] = {.lex_state = 0, .external_lex_state = 2},
  [2095] = {.lex_state = 0, .external_lex_state = 13},
  [2096] = {.lex_state = 0, .external_lex_state = 12},
  [2097] = {.lex_state = 352, .external_lex_state = 2},
  [2098] = {.lex_state = 0, .external_lex_state = 13},
  [2099] = {.lex_state = 0, .external_lex_state = 13},
  [2100] = {.lex_state = 0, .external_lex_state = 13},
  [2101] = {.lex_state = 0, .external_lex_state = 12},
  [2102] = {.lex_state = 352, .external_lex_state = 2},
  [2103] = {.lex_state = 0, .external_lex_state = 12},
  [2104] = {.lex_state = 0, .external_lex_state = 2},
  [2105] = {.lex_state = 0, .external_lex_state = 2},
  [2106] = {.lex_state = 0, .external_lex_state = 10},
  [2107] = {.lex_state = 0, .external_lex_state = 12},
  [2108] = {.lex_state = 0, .external_lex_state = 13},
  [2109] = {.lex_state = 0, .external_lex_state = 10},
  [2110] = {.lex_state = 352, .external_lex_state = 2},
  [2111] = {.lex_state = 352, .external_lex_state = 2},
  [2112] = {.lex_state = 352, .external_lex_state = 12},
  [2113] = {.lex_state = 0, .external_lex_state = 12},
  [2114] = {.lex_state = 0, .external_lex_state = 12},
  [2115] = {.lex_state = 0, .external_lex_state = 12},
  [2116] = {.lex_state = 0, .external_lex_state = 12},
  [2117] = {.lex_state = 0, .external_lex_state = 13},
  [2118] = {.lex_state = 352, .external_lex_state = 2},
  [2119] = {.lex_state = 0, .external_lex_state = 13},
  [2120] = {.lex_state = 0, .external_lex_state = 13},
  [2121] = {.lex_state = 352, .external_lex_state = 12},
  [2122] = {.lex_state = 0, .external_lex_state = 10},
  [2123] = {.lex_state = 352, .external_lex_state = 2},
  [2124] = {.lex_state = 0, .external_lex_state = 12},
  [2125] = {.lex_state = 0, .external_lex_state = 13},
  [2126] = {.lex_state = 0, .external_lex_state = 12},
  [2127] = {.lex_state = 0, .external_lex_state = 12},
  [2128] = {.lex_state = 0, .external_lex_state = 13},
  [2129] = {.lex_state = 352, .external_lex_state = 2},
  [2130] = {.lex_state = 0, .external_lex_state = 11},
  [2131] = {.lex_state = 0, .external_lex_state = 11},
  [2132] = {.lex_state = 352, .external_lex_state = 14},
  [2133] = {.lex_state = 0, .external_lex_state = 13},
  [2134] = {.lex_state = 0, .external_lex_state = 2},
  [2135] = {.lex_state = 352, .external_lex_state = 2},
  [2136] = {.lex_state = 0, .external_lex_state = 11},
  [2137] = {.lex_state = 0, .external_lex_state = 12},
  [2138] = {.lex_state = 352, .external_lex_state = 14},
  [2139] = {.lex_state = 352, .external_lex_state = 2},
  [2140] = {.lex_state = 0, .external_lex_state = 10},
  [2141] = {.lex_state = 0, .external_lex_state = 10},
  [2142] = {.lex_state = 0, .external_lex_state = 12},
  [2143] = {.lex_state = 352, .external_lex_state = 2},
  [2144] = {.lex_state = 0, .external_lex_state = 12},
  [2145] = {.lex_state = 352, .external_lex_state = 2},
  [2146] = {.lex_state = 352, .external_lex_state = 12},
  [2147] = {.lex_state = 0, .external_lex_state = 12},
  [2148] = {.lex_state = 0, .external_lex_state = 10},
  [2149] = {.lex_state = 0, .external_lex_state = 11},
  [2150] = {.lex_state = 0, .external_lex_state = 12},
  [2151] = {.lex_state = 0, .external_lex_state = 12},
  [2152] = {.lex_state = 0, .external_lex_state = 10},
  [2153] = {.lex_state = 352, .external_lex_state = 2},
  [2154] = {.lex_state = 0, .external_lex_state = 13},
  [2155] = {.lex_state = 0, .external_lex_state = 13},
  [2156] = {.lex_state = 0, .external_lex_state = 10},
  [2157] = {.lex_state = 0, .external_lex_state = 10},
  [2158] = {.lex_state = 0, .external_lex_state = 12},
  [2159] = {.lex_state = 0, .external_lex_state = 12},
  [2160] = {.lex_state = 0, .external_lex_state = 11},
  [2161] = {.lex_state = 0, .external_lex_state = 10},
  [2162] = {.lex_state = 0, .external_lex_state = 13},
  [2163] = {.lex_state = 0, .external_lex_state = 12},
  [2164] = {.lex_state = 0, .external_lex_state = 2},
  [2165] = {.lex_state = 0, .external_lex_state = 13},
  [2166] = {.lex_state = 0, .external_lex_state = 13},
  [2167] = {.lex_state = 0, .external_lex_state = 11},
  [2168] = {.lex_state = 0, .external_lex_state = 12},
  [2169] = {.lex_state = 0, .external_lex_state = 12},
  [2170] = {.lex_state = 0, .external_lex_state = 11},
  [2171] = {.lex_state = 0, .external_lex_state = 10},
  [2172] = {.lex_state = 352, .external_lex_state = 2},
  [2173] = {.lex_state = 0, .external_lex_state = 12},
  [2174] = {.lex_state = 352, .external_lex_state = 14},
  [2175] = {.lex_state = 0, .external_lex_state = 11},
  [2176] = {.lex_state = 0, .external_lex_state = 10},
  [2177] = {.lex_state = 0, .external_lex_state = 13},
  [2178] = {.lex_state = 0, .external_lex_state = 13},
  [2179] = {.lex_state = 11, .external_lex_state = 2},
  [2180] = {.lex_state = 0, .external_lex_state = 12},
  [2181] = {.lex_state = 0, .external_lex_state = 11},
  [2182] = {.lex_state = 0, .external_lex_state = 12},
  [2183] = {.lex_state = 352, .external_lex_state = 11},
  [2184] = {.lex_state = 0, .external_lex_state = 13},
  [2185] = {.lex_state = 0, .external_lex_state = 10},
  [2186] = {.lex_state = 0, .external_lex_state = 10},
  [2187] = {.lex_state = 0, .external_lex_state = 12},
  [2188] = {.lex_state = 0, .external_lex_state = 12},
  [2189] = {.lex_state = 0, .external_lex_state = 13},
  [2190] = {.lex_state = 0, .external_lex_state = 13},
  [2191] = {.lex_state = 0, .external_lex_state = 12},
  [2192] = {.lex_state = 0, .external_lex_state = 12},
  [2193] = {.lex_state = 352, .external_lex_state = 2},
  [2194] = {.lex_state = 0, .external_lex_state = 13},
  [2195] = {.lex_state = 0, .external_lex_state = 13},
  [2196] = {.lex_state = 0, .external_lex_state = 12},
  [2197] = {.lex_state = 0, .external_lex_state = 2},
  [2198] = {.lex_state = 43, .external_lex_state = 2},
  [2199] = {.lex_state = 0, .external_lex_state = 12},
  [2200] = {.lex_state = 0, .external_lex_state = 13},
  [2201] = {.lex_state = 352, .external_lex_state = 11},
  [2202] = {.lex_state = 0, .external_lex_state = 13},
  [2203] = {.lex_state = 0, .external_lex_state = 10},
  [2204] = {.lex_state = 0, .external_lex_state = 11},
  [2205] = {.lex_state = 0, .external_lex_state = 12},
  [2206] = {.lex_state = 0, .external_lex_state = 11},
  [2207] = {.lex_state = 10, .external_lex_state = 11},
  [2208] = {.lex_state = 32, .external_lex_state = 11},
  [2209] = {.lex_state = 0, .external_lex_state = 11},
  [2210] = {.lex_state = 1, .external_lex_state = 2},
  [2211] = {.lex_state = 0, .external_lex_state = 12},
  [2212] = {.lex_state = 0, .external_lex_state = 2},
  [2213] = {.lex_state = 0, .external_lex_state = 13},
  [2214] = {.lex_state = 32, .external_lex_state = 11},
  [2215] = {.lex_state = 0, .external_lex_state = 10},
  [2216] = {.lex_state = 0, .external_lex_state = 13},
  [2217] = {.lex_state = 1, .external_lex_state = 2},
  [2218] = {.lex_state = 0, .external_lex_state = 13},
  [2219] = {.lex_state = 0, .external_lex_state = 12},
  [2220] = {.lex_state = 0, .external_lex_state = 12},
  [2221] = {.lex_state = 1, .external_lex_state = 2},
  [2222] = {.lex_state = 0, .external_lex_state = 12},
  [2223] = {.lex_state = 20, .external_lex_state = 2},
  [2224] = {.lex_state = 32, .external_lex_state = 2},
  [2225] = {.lex_state = 43, .external_lex_state = 2},
  [2226] = {.lex_state = 1, .external_lex_state = 2},
  [2227] = {.lex_state = 352, .external_lex_state = 2},
  [2228] = {.lex_state = 0, .external_lex_state = 13},
  [2229] = {.lex_state = 0, .external_lex_state = 10},
  [2230] = {.lex_state = 352, .external_lex_state = 2},
  [2231] = {.lex_state = 1, .external_lex_state = 2},
  [2232] = {.lex_state = 57, .external_lex_state = 2},
  [2233] = {.lex_state = 32, .external_lex_state = 2},
  [2234] = {.lex_state = 32, .external_lex_state = 2},
  [2235] = {.lex_state = 60, .external_lex_state = 2},
  [2236] = {.lex_state = 0, .external_lex_state = 10},
  [2237] = {.lex_state = 352, .external_lex_state = 2},
  [2238] = {.lex_state = 0, .external_lex_state = 11},
  [2239] = {.lex_state = 0, .external_lex_state = 11},
  [2240] = {.lex_state = 0, .external_lex_state = 10},
  [2241] = {.lex_state = 32, .external_lex_state = 11},
  [2242] = {.lex_state = 0, .external_lex_state = 10},
  [2243] = {.lex_state = 0, .external_lex_state = 11},
  [2244] = {.lex_state = 1, .external_lex_state = 2},
  [2245] = {.lex_state = 0, .external_lex_state = 12},
  [2246] = {.lex_state = 1, .external_lex_state = 2},
  [2247] = {.lex_state = 1, .external_lex_state = 2},
  [2248] = {.lex_state = 43, .external_lex_state = 2},
  [2249] = {.lex_state = 43, .external_lex_state = 2},
  [2250] = {.lex_state = 0, .external_lex_state = 12},
  [2251] = {.lex_state = 60, .external_lex_state = 2},
  [2252] = {.lex_state = 352, .external_lex_state = 2},
  [2253] = {.lex_state = 0, .external_lex_state = 13},
  [2254] = {.lex_state = 0, .external_lex_state = 14},
  [2255] = {.lex_state = 1, .external_lex_state = 2},
  [2256] = {.lex_state = 352, .external_lex_state = 2},
  [2257] = {.lex_state = 1, .external_lex_state = 2},
  [2258] = {.lex_state = 1, .external_lex_state = 2},
  [2259] = {.lex_state = 1, .external_lex_state = 2},
  [2260] = {.lex_state = 0, .external_lex_state = 10},
  [2261] = {.lex_state = 32, .external_lex_state = 11},
  [2262] = {.lex_state = 0, .external_lex_state = 10},
  [2263] = {.lex_state = 0, .external_lex_state = 10},
  [2264] = {.lex_state = 32, .external_lex_state = 11},
  [2265] = {.lex_state = 1, .external_lex_state = 2},
  [2266] = {.lex_state = 0, .external_lex_state = 10},
  [2267] = {.lex_state = 1, .external_lex_state = 2},
  [2268] = {.lex_state = 1, .external_lex_state = 2},
  [2269] = {.lex_state = 1, .external_lex_state = 2},
  [2270] = {.lex_state = 1, .external_lex_state = 2},
  [2271] = {.lex_state = 1, .external_lex_state = 2},
  [2272] = {.lex_state = 43, .external_lex_state = 2},
  [2273] = {.lex_state = 1, .external_lex_state = 2},
  [2274] = {.lex_state = 1, .external_lex_state = 2},
  [2275] = {.lex_state = 1, .external_lex_state = 2},
  [2276] = {.lex_state = 1, .external_lex_state = 2},
  [2277] = {.lex_state = 0, .external_lex_state = 12},
  [2278] = {.lex_state = 0, .external_lex_state = 13},
  [2279] = {.lex_state = 1, .external_lex_state = 2},
  [2280] = {.lex_state = 1, .external_lex_state = 2},
  [2281] = {.lex_state = 32, .external_lex_state = 2},
  [2282] = {.lex_state = 0, .external_lex_state = 10},
  [2283] = {.lex_state = 1, .external_lex_state = 2},
  [2284] = {.lex_state = 0, .external_lex_state = 2},
  [2285] = {.lex_state = 0, .external_lex_state = 12},
  [2286] = {.lex_state = 0, .external_lex_state = 10},
  [2287] = {.lex_state = 0, .external_lex_state = 2},
  [2288] = {.lex_state = 60, .external_lex_state = 2},
  [2289] = {.lex_state = 352, .external_lex_state = 2},
  [2290] = {.lex_state = 1, .external_lex_state = 2},
  [2291] = {.lex_state = 1, .external_lex_state = 2},
  [2292] = {.lex_state = 0, .external_lex_state = 12},
  [2293] = {.lex_state = 0, .external_lex_state = 12},
  [2294] = {.lex_state = 0, .external_lex_state = 13},
  [2295] = {.lex_state = 0, .external_lex_state = 14},
  [2296] = {.lex_state = 32, .external_lex_state = 11},
  [2297] = {.lex_state = 0, .external_lex_state = 10},
  [2298] = {.lex_state = 352, .external_lex_state = 2},
  [2299] = {.lex_state = 0, .external_lex_state = 12},
  [2300] = {.lex_state = 0, .external_lex_state = 10},
  [2301] = {.lex_state = 1, .external_lex_state = 2},
  [2302] = {.lex_state = 1, .external_lex_state = 2},
  [2303] = {.lex_state = 352, .external_lex_state = 2},
  [2304] = {.lex_state = 0, .external_lex_state = 10},
  [2305] = {.lex_state = 0, .external_lex_state = 10},
  [2306] = {.lex_state = 0, .external_lex_state = 12},
  [2307] = {.lex_state = 0, .external_lex_state = 13},
  [2308] = {.lex_state = 352, .external_lex_state = 2},
  [2309] = {.lex_state = 32, .external_lex_state = 2},
  [2310] = {.lex_state = 32, .external_lex_state = 2},
  [2311] = {.lex_state = 0, .external_lex_state = 10},
  [2312] = {.lex_state = 1, .external_lex_state = 2},
  [2313] = {.lex_state = 1, .external_lex_state = 2},
  [2314] = {.lex_state = 1, .external_lex_state = 2},
  [2315] = {.lex_state = 1, .external_lex_state = 2},
  [2316] = {.lex_state = 0, .external_lex_state = 12},
  [2317] = {.lex_state = 0, .external_lex_state = 13},
  [2318] = {.lex_state = 1, .external_lex_state = 2},
  [2319] = {.lex_state = 0, .external_lex_state = 10},
  [2320] = {.lex_state = 1, .external_lex_state = 2},
  [2321] = {.lex_state = 0, .external_lex_state = 12},
  [2322] = {.lex_state = 0, .external_lex_state = 12},
  [2323] = {.lex_state = 0, .external_lex_state = 10},
  [2324] = {.lex_state = 1, .external_lex_state = 2},
  [2325] = {.lex_state = 0, .external_lex_state = 13},
  [2326] = {.lex_state = 0, .external_lex_state = 2},
  [2327] = {.lex_state = 0, .external_lex_state = 2},
  [2328] = {.lex_state = 0, .external_lex_state = 11},
  [2329] = {.lex_state = 0, .external_lex_state = 13},
  [2330] = {.lex_state = 0, .external_lex_state = 13},
  [2331] = {.lex_state = 0, .external_lex_state = 12},
  [2332] = {.lex_state = 0, .external_lex_state = 11},
  [2333] = {.lex_state = 0, .external_lex_state = 11},
  [2334] = {.lex_state = 0, .external_lex_state = 2},
  [2335] = {.lex_state = 352, .external_lex_state = 2},
  [2336] = {.lex_state = 43, .external_lex_state = 2},
  [2337] = {.lex_state = 0, .external_lex_state = 2},
  [2338] = {.lex_state = 352, .external_lex_state = 2},
  [2339] = {.lex_state = 0, .external_lex_state = 12},
  [2340] = {.lex_state = 0, .external_lex_state = 13},
  [2341] = {.lex_state = 0, .external_lex_state = 12},
  [2342] = {.lex_state = 43, .external_lex_state = 2},
  [2343] = {.lex_state = 0, .external_lex_state = 2},
  [2344] = {.lex_state = 0, .external_lex_state = 11},
  [2345] = {.lex_state = 0, .external_lex_state = 11},
  [2346] = {.lex_state = 0, .external_lex_state = 11},
  [2347] = {.lex_state = 0, .external_lex_state = 12},
  [2348] = {.lex_state = 0, .external_lex_state = 2},
  [2349] = {.lex_state = 0, .external_lex_state = 12},
  [2350] = {.lex_state = 0, .external_lex_state = 11},
  [2351] = {.lex_state = 0, .external_lex_state = 11},
  [2352] = {.lex_state = 0, .external_lex_state = 11},
  [2353] = {.lex_state = 0, .external_lex_state = 11},
  [2354] = {.lex_state = 32, .external_lex_state = 2},
  [2355] = {.lex_state = 0, .external_lex_state = 12},
  [2356] = {.lex_state = 0, .external_lex_state = 11},
  [2357] = {.lex_state = 352, .external_lex_state = 2},
  [2358] = {.lex_state = 43, .external_lex_state = 2},
  [2359] = {.lex_state = 0, .external_lex_state = 12},
  [2360] = {.lex_state = 0, .external_lex_state = 12},
  [2361] = {.lex_state = 352, .external_lex_state = 2},
  [2362] = {.lex_state = 43, .external_lex_state = 2},
  [2363] = {.lex_state = 43, .external_lex_state = 2},
  [2364] = {.lex_state = 352, .external_lex_state = 2},
  [2365] = {.lex_state = 0, .external_lex_state = 2},
  [2366] = {.lex_state = 0, .external_lex_state = 13},
  [2367] = {.lex_state = 0, .external_lex_state = 12},
  [2368] = {.lex_state = 0, .external_lex_state = 12},
  [2369] = {.lex_state = 0, .external_lex_state = 11},
  [2370] = {.lex_state = 43, .external_lex_state = 2},
  [2371] = {.lex_state = 0, .external_lex_state = 11},
  [2372] = {.lex_state = 0, .external_lex_state = 12},
  [2373] = {.lex_state = 0, .external_lex_state = 12},
  [2374] = {.lex_state = 0, .external_lex_state = 11},
  [2375] = {.lex_state = 0, .external_lex_state = 11},
  [2376] = {.lex_state = 0, .external_lex_state = 12},
  [2377] = {.lex_state = 0, .external_lex_state = 2},
  [2378] = {.lex_state = 0, .external_lex_state = 12},
  [2379] = {.lex_state = 0, .external_lex_state = 13},
  [2380] = {.lex_state = 0, .external_lex_state = 11},
  [2381] = {.lex_state = 0, .external_lex_state = 12},
  [2382] = {.lex_state = 0, .external_lex_state = 11},
  [2383] = {.lex_state = 0, .external_lex_state = 11},
  [2384] = {.lex_state = 0, .external_lex_state = 11},
  [2385] = {.lex_state = 43, .external_lex_state = 2},
  [2386] = {.lex_state = 0, .external_lex_state = 2},
  [2387] = {.lex_state = 352, .external_lex_state = 2},
  [2388] = {.lex_state = 0, .external_lex_state = 12},
  [2389] = {.lex_state = 43, .external_lex_state = 2},
  [2390] = {.lex_state = 0, .external_lex_state = 2},
  [2391] = {.lex_state = 0, .external_lex_state = 2},
  [2392] = {.lex_state = 0, .external_lex_state = 2},
  [2393] = {.lex_state = 0, .external_lex_state = 13},
  [2394] = {.lex_state = 0, .external_lex_state = 12},
  [2395] = {.lex_state = 0, .external_lex_state = 12},
  [2396] = {.lex_state = 0, .external_lex_state = 12},
  [2397] = {.lex_state = 0, .external_lex_state = 11},
  [2398] = {.lex_state = 0, .external_lex_state = 11},
  [2399] = {.lex_state = 0, .external_lex_state = 11},
  [2400] = {.lex_state = 0, .external_lex_state = 11},
  [2401] = {.lex_state = 0, .external_lex_state = 13},
  [2402] = {.lex_state = 0, .external_lex_state = 12},
  [2403] = {.lex_state = 0, .external_lex_state = 13},
  [2404] = {.lex_state = 0, .external_lex_state = 12},
  [2405] = {.lex_state = 0, .external_lex_state = 2},
  [2406] = {.lex_state = 0, .external_lex_state = 13},
  [2407] = {.lex_state = 43, .external_lex_state = 2},
  [2408] = {.lex_state = 0, .external_lex_state = 11},
  [2409] = {.lex_state = 43, .external_lex_state = 2},
  [2410] = {.lex_state = 0, .external_lex_state = 2},
  [2411] = {.lex_state = 0, .external_lex_state = 11},
  [2412] = {.lex_state = 0, .external_lex_state = 2},
  [2413] = {.lex_state = 43, .external_lex_state = 2},
  [2414] = {.lex_state = 0, .external_lex_state = 11},
  [2415] = {.lex_state = 0, .external_lex_state = 12},
  [2416] = {.lex_state = 352, .external_lex_state = 2},
  [2417] = {.lex_state = 0, .external_lex_state = 11},
  [2418] = {.lex_state = 43, .external_lex_state = 2},
  [2419] = {.lex_state = 352, .external_lex_state = 2},
  [2420] = {.lex_state = 32, .external_lex_state = 2},
  [2421] = {.lex_state = 0, .external_lex_state = 11},
  [2422] = {.lex_state = 0, .external_lex_state = 11},
  [2423] = {.lex_state = 0, .external_lex_state = 11},
  [2424] = {.lex_state = 0, .external_lex_state = 11},
  [2425] = {.lex_state = 0, .external_lex_state = 12},
  [2426] = {.lex_state = 0, .external_lex_state = 11},
  [2427] = {.lex_state = 0, .external_lex_state = 2},
  [2428] = {.lex_state = 0, .external_lex_state = 13},
  [2429] = {.lex_state = 352, .external_lex_state = 2},
  [2430] = {.lex_state = 43, .external_lex_state = 2},
  [2431] = {.lex_state = 0, .external_lex_state = 2},
  [2432] = {.lex_state = 352, .external_lex_state = 2},
  [2433] = {.lex_state = 0, .external_lex_state = 11},
  [2434] = {.lex_state = 0, .external_lex_state = 11},
  [2435] = {.lex_state = 0, .external_lex_state = 11},
  [2436] = {.lex_state = 0, .external_lex_state = 12},
  [2437] = {.lex_state = 0, .external_lex_state = 11},
  [2438] = {.lex_state = 43, .external_lex_state = 2},
  [2439] = {.lex_state = 0, .external_lex_state = 13},
  [2440] = {.lex_state = 43, .external_lex_state = 2},
  [2441] = {.lex_state = 0, .external_lex_state = 12},
  [2442] = {.lex_state = 0, .external_lex_state = 13},
  [2443] = {.lex_state = 352, .external_lex_state = 2},
  [2444] = {.lex_state = 43, .external_lex_state = 2},
  [2445] = {.lex_state = 0, .external_lex_state = 13},
  [2446] = {.lex_state = 0, .external_lex_state = 2},
  [2447] = {.lex_state = 0, .external_lex_state = 2},
  [2448] = {.lex_state = 0, .external_lex_state = 2},
  [2449] = {.lex_state = 0, .external_lex_state = 2},
  [2450] = {.lex_state = 0, .external_lex_state = 2},
  [2451] = {.lex_state = 352, .external_lex_state = 2},
  [2452] = {.lex_state = 43, .external_lex_state = 2},
  [2453] = {.lex_state = 0, .external_lex_state = 2},
  [2454] = {.lex_state = 0, .external_lex_state = 13},
  [2455] = {.lex_state = 0, .external_lex_state = 2},
  [2456] = {.lex_state = 0, .external_lex_state = 11},
  [2457] = {.lex_state = 0, .external_lex_state = 11},
  [2458] = {.lex_state = 352, .external_lex_state = 2},
  [2459] = {.lex_state = 0, .external_lex_state = 2},
  [2460] = {.lex_state = 0, .external_lex_state = 2},
  [2461] = {.lex_state = 0, .external_lex_state = 11},
  [2462] = {.lex_state = 0, .external_lex_state = 2},
  [2463] = {.lex_state = 43, .external_lex_state = 2},
  [2464] = {.lex_state = 0, .external_lex_state = 13},
  [2465] = {.lex_state = 0, .external_lex_state = 13},
  [2466] = {.lex_state = 0, .external_lex_state = 11},
  [2467] = {.lex_state = 0, .external_lex_state = 11},
  [2468] = {.lex_state = 0, .external_lex_state = 12},
  [2469] = {.lex_state = 352, .external_lex_state = 2},
  [2470] = {.lex_state = 0, .external_lex_state = 13},
  [2471] = {.lex_state = 0, .external_lex_state = 2},
  [2472] = {.lex_state = 352, .external_lex_state = 2},
  [2473] = {.lex_state = 0, .external_lex_state = 11},
  [2474] = {.lex_state = 0, .external_lex_state = 13},
  [2475] = {.lex_state = 0, .external_lex_state = 2},
  [2476] = {.lex_state = 352, .external_lex_state = 2},
  [2477] = {.lex_state = 352, .external_lex_state = 2},
  [2478] = {.lex_state = 352, .external_lex_state = 2},
  [2479] = {.lex_state = 0, .external_lex_state = 12},
  [2480] = {.lex_state = 0, .external_lex_state = 11},
  [2481] = {.lex_state = 0, .external_lex_state = 11},
  [2482] = {.lex_state = 43, .external_lex_state = 2},
  [2483] = {.lex_state = 0, .external_lex_state = 11},
  [2484] = {.lex_state = 0, .external_lex_state = 2},
  [2485] = {.lex_state = 43, .external_lex_state = 2},
  [2486] = {.lex_state = 0, .external_lex_state = 13},
  [2487] = {.lex_state = 0, .external_lex_state = 2},
  [2488] = {.lex_state = 43, .external_lex_state = 2},
  [2489] = {.lex_state = 0, .external_lex_state = 12},
  [2490] = {.lex_state = 352, .external_lex_state = 2},
  [2491] = {.lex_state = 352, .external_lex_state = 2},
  [2492] = {.lex_state = 0, .external_lex_state = 2},
  [2493] = {.lex_state = 0, .external_lex_state = 12},
  [2494] = {.lex_state = 0, .external_lex_state = 12},
  [2495] = {.lex_state = 0, .external_lex_state = 11},
  [2496] = {.lex_state = 43, .external_lex_state = 2},
  [2497] = {.lex_state = 0, .external_lex_state = 12},
  [2498] = {.lex_state = 0, .external_lex_state = 11},
  [2499] = {.lex_state = 0, .external_lex_state = 11},
  [2500] = {.lex_state = 0, .external_lex_state = 11},
  [2501] = {.lex_state = 43, .external_lex_state = 2},
  [2502] = {.lex_state = 43, .external_lex_state = 2},
  [2503] = {.lex_state = 0, .external_lex_state = 2},
  [2504] = {.lex_state = 0, .external_lex_state = 12},
  [2505] = {.lex_state = 0, .external_lex_state = 12},
  [2506] = {.lex_state = 0, .external_lex_state = 2},
  [2507] = {.lex_state = 0, .external_lex_state = 2},
  [2508] = {.lex_state = 0, .external_lex_state = 13},
  [2509] = {.lex_state = 0, .external_lex_state = 2},
  [2510] = {.lex_state = 0, .external_lex_state = 12},
  [2511] = {.lex_state = 0, .external_lex_state = 2},
  [2512] = {.lex_state = 352, .external_lex_state = 2},
  [2513] = {.lex_state = 0, .external_lex_state = 2},
  [2514] = {.lex_state = 43, .external_lex_state = 2},
  [2515] = {.lex_state = 352, .external_lex_state = 2},
  [2516] = {.lex_state = 0, .external_lex_state = 2},
  [2517] = {.lex_state = 0, .external_lex_state = 2},
  [2518] = {.lex_state = 32, .external_lex_state = 2},
  [2519] = {.lex_state = 32, .external_lex_state = 2},
  [2520] = {.lex_state = 0, .external_lex_state = 11},
  [2521] = {.lex_state = 0, .external_lex_state = 11},
  [2522] = {.lex_state = 0, .external_lex_state = 11},
  [2523] = {.lex_state = 0, .external_lex_state = 11},
  [2524] = {.lex_state = 32, .external_lex_state = 2},
  [2525] = {.lex_state = 43, .external_lex_state = 2},
  [2526] = {.lex_state = 0, .external_lex_state = 12},
  [2527] = {.lex_state = 0, .external_lex_state = 12},
  [2528] = {.lex_state = 0, .external_lex_state = 2},
  [2529] = {.lex_state = 0, .external_lex_state = 13},
  [2530] = {.lex_state = 352, .external_lex_state = 2},
  [2531] = {.lex_state = 0, .external_lex_state = 12},
  [2532] = {.lex_state = 0, .external_lex_state = 2},
  [2533] = {.lex_state = 352, .external_lex_state = 2},
  [2534] = {.lex_state = 352, .external_lex_state = 2},
  [2535] = {.lex_state = 0, .external_lex_state = 11},
  [2536] = {.lex_state = 0, .external_lex_state = 13},
  [2537] = {.lex_state = 0, .external_lex_state = 11},
  [2538] = {.lex_state = 0, .external_lex_state = 11},
  [2539] = {.lex_state = 32, .external_lex_state = 2},
  [2540] = {.lex_state = 0, .external_lex_state = 13},
  [2541] = {.lex_state = 352, .external_lex_state = 2},
  [2542] = {.lex_state = 61, .external_lex_state = 2},
  [2543] = {.lex_state = 43, .external_lex_state = 2},
  [2544] = {.lex_state = 0, .external_lex_state = 12},
  [2545] = {.lex_state = 61, .external_lex_state = 2},
  [2546] = {.lex_state = 0, .external_lex_state = 11},
  [2547] = {.lex_state = 0, .external_lex_state = 2},
  [2548] = {.lex_state = 0, .external_lex_state = 12},
  [2549] = {.lex_state = 0, .external_lex_state = 11},
  [2550] = {.lex_state = 0, .external_lex_state = 11},
  [2551] = {.lex_state = 352, .external_lex_state = 2},
  [2552] = {.lex_state = 43, .external_lex_state = 2},
  [2553] = {.lex_state = 0, .external_lex_state = 2},
  [2554] = {.lex_state = 0, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_NULL] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_QMARK_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_EQ_PLUS] = ACTIONS(1),
    [anon_sym_DOT_EQ] = ACTIONS(1),
    [anon_sym_EQ_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_noexec] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_append] = ACTIONS(1),
    [anon_sym_prepend] = ACTIONS(1),
    [anon_sym_remove] = ACTIONS(1),
    [anon_sym_unset] = ACTIONS(1),
    [anon_sym_INHERIT] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_OVERRIDES] = ACTIONS(1),
    [anon_sym_EXPORT_FUNCTIONS] = ACTIONS(1),
    [anon_sym_addtask] = ACTIONS(1),
    [anon_sym_after] = ACTIONS(1),
    [anon_sym_before] = ACTIONS(1),
    [anon_sym_addhandler] = ACTIONS(1),
    [anon_sym_fakeroot] = ACTIONS(1),
    [anon_sym_python] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [aux_sym_string_token2] = ACTIONS(1),
    [anon_sym_DOLLARBB_ENV_PASSTHROUGH] = ACTIONS(1),
    [anon_sym_DOLLARBB_ENV_PASSTHROUGH_ADDITIONS] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [aux_sym_string_token4] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE_AT] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym___future__] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_raise] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_nonlocal] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_except] = ACTIONS(1),
    [anon_sym_except_STAR] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym__not_escape_sequence] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__concat] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym_string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym_escape_interpolation] = ACTIONS(1),
    [sym_string_end] = ACTIONS(1),
    [sym_shell_content] = ACTIONS(1),
  },
  [1] = {
    [sym_recipe] = STATE(2462),
    [sym_variable_assignment] = STATE(2258),
    [sym_unset_statement] = STATE(2258),
    [sym_inherit_directive] = STATE(2258),
    [sym_include_directive] = STATE(2258),
    [sym_require_directive] = STATE(2258),
    [sym_export_statement] = STATE(2258),
    [sym_overrides_statement] = STATE(2258),
    [sym_export_functions_statement] = STATE(2258),
    [sym_addtask_statement] = STATE(2258),
    [sym_deltask_statement] = STATE(2258),
    [sym_addhandler_statement] = STATE(2258),
    [sym_anonymous_python_function] = STATE(2258),
    [sym_function_definition] = STATE(2258),
    [sym_variable_expansion] = STATE(2254),
    [sym_python_function_definition] = STATE(2258),
    [sym_concatenation] = STATE(1516),
    [aux_sym_recipe_repeat1] = STATE(1181),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_unset] = ACTIONS(7),
    [anon_sym_inherit] = ACTIONS(9),
    [anon_sym_include] = ACTIONS(11),
    [anon_sym_require] = ACTIONS(13),
    [anon_sym_export] = ACTIONS(15),
    [anon_sym_OVERRIDES] = ACTIONS(17),
    [anon_sym_EXPORT_FUNCTIONS] = ACTIONS(19),
    [anon_sym_addtask] = ACTIONS(21),
    [anon_sym_deltask] = ACTIONS(23),
    [anon_sym_addhandler] = ACTIONS(25),
    [anon_sym_fakeroot] = ACTIONS(27),
    [anon_sym_python] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_def] = ACTIONS(33),
    [sym_identifier] = ACTIONS(35),
    [aux_sym__dotted_identifier_token1] = ACTIONS(37),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_python_function_definition] = STATE(34),
    [sym__statement] = STATE(34),
    [sym__simple_statements] = STATE(34),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_try_statement] = STATE(34),
    [sym_with_statement] = STATE(34),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(2414),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(34),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(113),
  },
  [3] = {
    [sym_python_function_definition] = STATE(32),
    [sym__statement] = STATE(32),
    [sym__simple_statements] = STATE(32),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_try_statement] = STATE(32),
    [sym_with_statement] = STATE(32),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(596),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(32),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(115),
    [sym_string_start] = ACTIONS(113),
  },
  [4] = {
    [sym_python_function_definition] = STATE(33),
    [sym__statement] = STATE(33),
    [sym__simple_statements] = STATE(33),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(33),
    [sym_for_statement] = STATE(33),
    [sym_while_statement] = STATE(33),
    [sym_try_statement] = STATE(33),
    [sym_with_statement] = STATE(33),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(670),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(33),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(113),
  },
  [5] = {
    [sym_python_function_definition] = STATE(33),
    [sym__statement] = STATE(33),
    [sym__simple_statements] = STATE(33),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(33),
    [sym_for_statement] = STATE(33),
    [sym_while_statement] = STATE(33),
    [sym_try_statement] = STATE(33),
    [sym_with_statement] = STATE(33),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(658),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(33),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(113),
  },
  [6] = {
    [sym_python_function_definition] = STATE(26),
    [sym__statement] = STATE(26),
    [sym__simple_statements] = STATE(26),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(26),
    [sym_for_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_try_statement] = STATE(26),
    [sym_with_statement] = STATE(26),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(1697),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(26),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(119),
    [sym_string_start] = ACTIONS(113),
  },
  [7] = {
    [sym_python_function_definition] = STATE(33),
    [sym__statement] = STATE(33),
    [sym__simple_statements] = STATE(33),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(33),
    [sym_for_statement] = STATE(33),
    [sym_while_statement] = STATE(33),
    [sym_try_statement] = STATE(33),
    [sym_with_statement] = STATE(33),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(663),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(33),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(113),
  },
  [8] = {
    [sym_python_function_definition] = STATE(34),
    [sym__statement] = STATE(34),
    [sym__simple_statements] = STATE(34),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_try_statement] = STATE(34),
    [sym_with_statement] = STATE(34),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(2549),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(34),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(113),
  },
  [9] = {
    [sym_python_function_definition] = STATE(27),
    [sym__statement] = STATE(27),
    [sym__simple_statements] = STATE(27),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_try_statement] = STATE(27),
    [sym_with_statement] = STATE(27),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(627),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(27),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(121),
    [sym_string_start] = ACTIONS(113),
  },
  [10] = {
    [sym_python_function_definition] = STATE(33),
    [sym__statement] = STATE(33),
    [sym__simple_statements] = STATE(33),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(33),
    [sym_for_statement] = STATE(33),
    [sym_while_statement] = STATE(33),
    [sym_try_statement] = STATE(33),
    [sym_with_statement] = STATE(33),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(664),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(33),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(113),
  },
  [11] = {
    [sym_python_function_definition] = STATE(33),
    [sym__statement] = STATE(33),
    [sym__simple_statements] = STATE(33),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(33),
    [sym_for_statement] = STATE(33),
    [sym_while_statement] = STATE(33),
    [sym_try_statement] = STATE(33),
    [sym_with_statement] = STATE(33),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(669),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(33),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(113),
  },
  [12] = {
    [sym_python_function_definition] = STATE(31),
    [sym__statement] = STATE(31),
    [sym__simple_statements] = STATE(31),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(31),
    [sym_for_statement] = STATE(31),
    [sym_while_statement] = STATE(31),
    [sym_try_statement] = STATE(31),
    [sym_with_statement] = STATE(31),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(598),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(31),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(123),
    [sym_string_start] = ACTIONS(113),
  },
  [13] = {
    [sym_python_function_definition] = STATE(30),
    [sym__statement] = STATE(30),
    [sym__simple_statements] = STATE(30),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(30),
    [sym_for_statement] = STATE(30),
    [sym_while_statement] = STATE(30),
    [sym_try_statement] = STATE(30),
    [sym_with_statement] = STATE(30),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(614),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(30),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(125),
    [sym_string_start] = ACTIONS(113),
  },
  [14] = {
    [sym_python_function_definition] = STATE(34),
    [sym__statement] = STATE(34),
    [sym__simple_statements] = STATE(34),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_try_statement] = STATE(34),
    [sym_with_statement] = STATE(34),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(2352),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(34),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(113),
  },
  [15] = {
    [sym_python_function_definition] = STATE(35),
    [sym__statement] = STATE(35),
    [sym__simple_statements] = STATE(35),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(35),
    [sym_for_statement] = STATE(35),
    [sym_while_statement] = STATE(35),
    [sym_try_statement] = STATE(35),
    [sym_with_statement] = STATE(35),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(2279),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(35),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(127),
    [sym_string_start] = ACTIONS(113),
  },
  [16] = {
    [sym_python_function_definition] = STATE(30),
    [sym__statement] = STATE(30),
    [sym__simple_statements] = STATE(30),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(30),
    [sym_for_statement] = STATE(30),
    [sym_while_statement] = STATE(30),
    [sym_try_statement] = STATE(30),
    [sym_with_statement] = STATE(30),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(613),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(30),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(125),
    [sym_string_start] = ACTIONS(113),
  },
  [17] = {
    [sym_python_function_definition] = STATE(32),
    [sym__statement] = STATE(32),
    [sym__simple_statements] = STATE(32),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_try_statement] = STATE(32),
    [sym_with_statement] = STATE(32),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(587),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(32),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(115),
    [sym_string_start] = ACTIONS(113),
  },
  [18] = {
    [sym_python_function_definition] = STATE(34),
    [sym__statement] = STATE(34),
    [sym__simple_statements] = STATE(34),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_try_statement] = STATE(34),
    [sym_with_statement] = STATE(34),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(2421),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(34),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(113),
  },
  [19] = {
    [sym_python_function_definition] = STATE(29),
    [sym__statement] = STATE(29),
    [sym__simple_statements] = STATE(29),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(29),
    [sym_for_statement] = STATE(29),
    [sym_while_statement] = STATE(29),
    [sym_try_statement] = STATE(29),
    [sym_with_statement] = STATE(29),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(588),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(29),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(129),
    [sym_string_start] = ACTIONS(113),
  },
  [20] = {
    [sym_python_function_definition] = STATE(33),
    [sym__statement] = STATE(33),
    [sym__simple_statements] = STATE(33),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(33),
    [sym_for_statement] = STATE(33),
    [sym_while_statement] = STATE(33),
    [sym_try_statement] = STATE(33),
    [sym_with_statement] = STATE(33),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(651),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(33),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(113),
  },
  [21] = {
    [sym_python_function_definition] = STATE(29),
    [sym__statement] = STATE(29),
    [sym__simple_statements] = STATE(29),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(29),
    [sym_for_statement] = STATE(29),
    [sym_while_statement] = STATE(29),
    [sym_try_statement] = STATE(29),
    [sym_with_statement] = STATE(29),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(575),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(29),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(129),
    [sym_string_start] = ACTIONS(113),
  },
  [22] = {
    [sym_python_function_definition] = STATE(30),
    [sym__statement] = STATE(30),
    [sym__simple_statements] = STATE(30),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(30),
    [sym_for_statement] = STATE(30),
    [sym_while_statement] = STATE(30),
    [sym_try_statement] = STATE(30),
    [sym_with_statement] = STATE(30),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(602),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(30),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(125),
    [sym_string_start] = ACTIONS(113),
  },
  [23] = {
    [sym_python_function_definition] = STATE(29),
    [sym__statement] = STATE(29),
    [sym__simple_statements] = STATE(29),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(29),
    [sym_for_statement] = STATE(29),
    [sym_while_statement] = STATE(29),
    [sym_try_statement] = STATE(29),
    [sym_with_statement] = STATE(29),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(594),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(29),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(129),
    [sym_string_start] = ACTIONS(113),
  },
  [24] = {
    [sym_python_function_definition] = STATE(35),
    [sym__statement] = STATE(35),
    [sym__simple_statements] = STATE(35),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(35),
    [sym_for_statement] = STATE(35),
    [sym_while_statement] = STATE(35),
    [sym_try_statement] = STATE(35),
    [sym_with_statement] = STATE(35),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(2315),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(35),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(127),
    [sym_string_start] = ACTIONS(113),
  },
  [25] = {
    [sym_python_function_definition] = STATE(31),
    [sym__statement] = STATE(31),
    [sym__simple_statements] = STATE(31),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(31),
    [sym_for_statement] = STATE(31),
    [sym_while_statement] = STATE(31),
    [sym_try_statement] = STATE(31),
    [sym_with_statement] = STATE(31),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_block] = STATE(558),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(31),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(123),
    [sym_string_start] = ACTIONS(113),
  },
  [26] = {
    [sym_python_function_definition] = STATE(28),
    [sym__statement] = STATE(28),
    [sym__simple_statements] = STATE(28),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(28),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(131),
    [sym_string_start] = ACTIONS(113),
  },
  [27] = {
    [sym_python_function_definition] = STATE(28),
    [sym__statement] = STATE(28),
    [sym__simple_statements] = STATE(28),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(28),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(133),
    [sym_string_start] = ACTIONS(113),
  },
  [28] = {
    [sym_python_function_definition] = STATE(28),
    [sym__statement] = STATE(28),
    [sym__simple_statements] = STATE(28),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(28),
    [anon_sym_LBRACK] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_LBRACE] = ACTIONS(141),
    [anon_sym_def] = ACTIONS(144),
    [anon_sym_import] = ACTIONS(147),
    [anon_sym_from] = ACTIONS(150),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_print] = ACTIONS(156),
    [anon_sym_assert] = ACTIONS(159),
    [anon_sym_return] = ACTIONS(162),
    [anon_sym_del] = ACTIONS(165),
    [anon_sym_raise] = ACTIONS(168),
    [anon_sym_pass] = ACTIONS(171),
    [anon_sym_break] = ACTIONS(174),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_global] = ACTIONS(180),
    [anon_sym_nonlocal] = ACTIONS(183),
    [anon_sym_exec] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(189),
    [anon_sym_async] = ACTIONS(192),
    [anon_sym_for] = ACTIONS(195),
    [anon_sym_while] = ACTIONS(198),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_with] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(207),
    [anon_sym_PLUS] = ACTIONS(210),
    [anon_sym_DASH] = ACTIONS(213),
    [anon_sym_TILDE] = ACTIONS(210),
    [anon_sym_lambda] = ACTIONS(216),
    [anon_sym_yield] = ACTIONS(219),
    [sym_ellipsis] = ACTIONS(222),
    [anon_sym_await] = ACTIONS(225),
    [anon_sym_match] = ACTIONS(228),
    [anon_sym_type] = ACTIONS(231),
    [sym_integer] = ACTIONS(234),
    [sym_float] = ACTIONS(234),
    [sym_true] = ACTIONS(234),
    [sym_false] = ACTIONS(234),
    [sym_none] = ACTIONS(234),
    [sym_python_identifier] = ACTIONS(237),
    [sym_identifier] = ACTIONS(240),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(243),
    [sym_string_start] = ACTIONS(245),
  },
  [29] = {
    [sym_python_function_definition] = STATE(28),
    [sym__statement] = STATE(28),
    [sym__simple_statements] = STATE(28),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(28),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(248),
    [sym_string_start] = ACTIONS(113),
  },
  [30] = {
    [sym_python_function_definition] = STATE(28),
    [sym__statement] = STATE(28),
    [sym__simple_statements] = STATE(28),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(28),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(250),
    [sym_string_start] = ACTIONS(113),
  },
  [31] = {
    [sym_python_function_definition] = STATE(28),
    [sym__statement] = STATE(28),
    [sym__simple_statements] = STATE(28),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(28),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(252),
    [sym_string_start] = ACTIONS(113),
  },
  [32] = {
    [sym_python_function_definition] = STATE(28),
    [sym__statement] = STATE(28),
    [sym__simple_statements] = STATE(28),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(28),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(254),
    [sym_string_start] = ACTIONS(113),
  },
  [33] = {
    [sym_python_function_definition] = STATE(28),
    [sym__statement] = STATE(28),
    [sym__simple_statements] = STATE(28),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(28),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(256),
    [sym_string_start] = ACTIONS(113),
  },
  [34] = {
    [sym_python_function_definition] = STATE(28),
    [sym__statement] = STATE(28),
    [sym__simple_statements] = STATE(28),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(28),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(258),
    [sym_string_start] = ACTIONS(113),
  },
  [35] = {
    [sym_python_function_definition] = STATE(28),
    [sym__statement] = STATE(28),
    [sym__simple_statements] = STATE(28),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_if_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [aux_sym_block_repeat1] = STATE(28),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(260),
    [sym_string_start] = ACTIONS(113),
  },
  [36] = {
    [sym__simple_statements] = STATE(2290),
    [sym_import_statement] = STATE(1996),
    [sym_future_import_statement] = STATE(1996),
    [sym_import_from_statement] = STATE(1996),
    [sym_print_statement] = STATE(1996),
    [sym_assert_statement] = STATE(1996),
    [sym_expression_statement] = STATE(1996),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(1996),
    [sym_delete_statement] = STATE(1996),
    [sym_raise_statement] = STATE(1996),
    [sym_pass_statement] = STATE(1996),
    [sym_break_statement] = STATE(1996),
    [sym_continue_statement] = STATE(1996),
    [sym_global_statement] = STATE(1996),
    [sym_nonlocal_statement] = STATE(1996),
    [sym_exec_statement] = STATE(1996),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(554),
    [sym_subscript] = STATE(554),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(571),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1542),
    [sym_primary_expression] = STATE(859),
    [sym_type] = STATE(1897),
    [sym_splat_type] = STATE(1853),
    [sym_generic_type] = STATE(1853),
    [sym_union_type] = STATE(1853),
    [sym_constrained_type] = STATE(1853),
    [sym_member_type] = STATE(1853),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(262),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(266),
    [anon_sym_print] = ACTIONS(268),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(270),
    [anon_sym_async] = ACTIONS(272),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_STAR_STAR] = ACTIONS(274),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(276),
    [anon_sym_match] = ACTIONS(272),
    [anon_sym_type] = ACTIONS(278),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(280),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(282),
    [sym__indent] = ACTIONS(284),
    [sym_string_start] = ACTIONS(113),
  },
  [37] = {
    [sym_chevron] = STATE(1954),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_attribute] = STATE(980),
    [sym_subscript] = STATE(980),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_list_splat_pattern] = STATE(994),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1679),
    [sym_primary_expression] = STATE(836),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_EQ] = ACTIONS(286),
    [anon_sym_COLON_EQ] = ACTIONS(288),
    [anon_sym_PLUS_EQ] = ACTIONS(290),
    [anon_sym_LBRACK] = ACTIONS(292),
    [anon_sym_COLON] = ACTIONS(286),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_SEMI] = ACTIONS(298),
    [anon_sym_DOT] = ACTIONS(300),
    [anon_sym_COMMA] = ACTIONS(302),
    [anon_sym_as] = ACTIONS(300),
    [anon_sym_STAR] = ACTIONS(305),
    [anon_sym_print] = ACTIONS(308),
    [anon_sym_GT_GT] = ACTIONS(310),
    [anon_sym_exec] = ACTIONS(308),
    [anon_sym_in] = ACTIONS(300),
    [anon_sym_if] = ACTIONS(300),
    [anon_sym_async] = ACTIONS(308),
    [anon_sym_not] = ACTIONS(312),
    [anon_sym_and] = ACTIONS(300),
    [anon_sym_or] = ACTIONS(300),
    [anon_sym_PLUS] = ACTIONS(315),
    [anon_sym_DASH] = ACTIONS(315),
    [anon_sym_AT] = ACTIONS(300),
    [anon_sym_SLASH] = ACTIONS(300),
    [anon_sym_PERCENT] = ACTIONS(300),
    [anon_sym_SLASH_SLASH] = ACTIONS(300),
    [anon_sym_STAR_STAR] = ACTIONS(300),
    [anon_sym_PIPE] = ACTIONS(300),
    [anon_sym_AMP] = ACTIONS(300),
    [anon_sym_CARET] = ACTIONS(300),
    [anon_sym_LT_LT] = ACTIONS(300),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_LT] = ACTIONS(300),
    [anon_sym_LT_EQ] = ACTIONS(298),
    [anon_sym_EQ_EQ] = ACTIONS(298),
    [anon_sym_BANG_EQ] = ACTIONS(298),
    [anon_sym_GT_EQ] = ACTIONS(298),
    [anon_sym_GT] = ACTIONS(300),
    [anon_sym_LT_GT] = ACTIONS(298),
    [anon_sym_is] = ACTIONS(300),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_DASH_EQ] = ACTIONS(290),
    [anon_sym_STAR_EQ] = ACTIONS(290),
    [anon_sym_SLASH_EQ] = ACTIONS(290),
    [anon_sym_AT_EQ] = ACTIONS(290),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(290),
    [anon_sym_PERCENT_EQ] = ACTIONS(290),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(290),
    [anon_sym_GT_GT_EQ] = ACTIONS(290),
    [anon_sym_LT_LT_EQ] = ACTIONS(290),
    [anon_sym_AMP_EQ] = ACTIONS(290),
    [anon_sym_CARET_EQ] = ACTIONS(290),
    [anon_sym_PIPE_EQ] = ACTIONS(290),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(318),
    [anon_sym_match] = ACTIONS(308),
    [anon_sym_type] = ACTIONS(320),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(322),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(298),
    [sym_string_start] = ACTIONS(113),
  },
  [38] = {
    [sym_chevron] = STATE(1954),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_attribute] = STATE(980),
    [sym_subscript] = STATE(980),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_list_splat_pattern] = STATE(994),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1679),
    [sym_primary_expression] = STATE(836),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_EQ] = ACTIONS(286),
    [anon_sym_COLON_EQ] = ACTIONS(288),
    [anon_sym_PLUS_EQ] = ACTIONS(290),
    [anon_sym_LBRACK] = ACTIONS(292),
    [anon_sym_COLON] = ACTIONS(324),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_SEMI] = ACTIONS(298),
    [anon_sym_DOT] = ACTIONS(300),
    [anon_sym_COMMA] = ACTIONS(302),
    [anon_sym_as] = ACTIONS(300),
    [anon_sym_STAR] = ACTIONS(305),
    [anon_sym_print] = ACTIONS(308),
    [anon_sym_GT_GT] = ACTIONS(310),
    [anon_sym_exec] = ACTIONS(308),
    [anon_sym_in] = ACTIONS(300),
    [anon_sym_if] = ACTIONS(300),
    [anon_sym_async] = ACTIONS(308),
    [anon_sym_not] = ACTIONS(312),
    [anon_sym_and] = ACTIONS(300),
    [anon_sym_or] = ACTIONS(300),
    [anon_sym_PLUS] = ACTIONS(315),
    [anon_sym_DASH] = ACTIONS(315),
    [anon_sym_AT] = ACTIONS(300),
    [anon_sym_SLASH] = ACTIONS(300),
    [anon_sym_PERCENT] = ACTIONS(300),
    [anon_sym_SLASH_SLASH] = ACTIONS(300),
    [anon_sym_STAR_STAR] = ACTIONS(300),
    [anon_sym_PIPE] = ACTIONS(300),
    [anon_sym_AMP] = ACTIONS(300),
    [anon_sym_CARET] = ACTIONS(300),
    [anon_sym_LT_LT] = ACTIONS(300),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_LT] = ACTIONS(300),
    [anon_sym_LT_EQ] = ACTIONS(298),
    [anon_sym_EQ_EQ] = ACTIONS(298),
    [anon_sym_BANG_EQ] = ACTIONS(298),
    [anon_sym_GT_EQ] = ACTIONS(298),
    [anon_sym_GT] = ACTIONS(300),
    [anon_sym_LT_GT] = ACTIONS(298),
    [anon_sym_is] = ACTIONS(300),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_DASH_EQ] = ACTIONS(290),
    [anon_sym_STAR_EQ] = ACTIONS(290),
    [anon_sym_SLASH_EQ] = ACTIONS(290),
    [anon_sym_AT_EQ] = ACTIONS(290),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(290),
    [anon_sym_PERCENT_EQ] = ACTIONS(290),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(290),
    [anon_sym_GT_GT_EQ] = ACTIONS(290),
    [anon_sym_LT_LT_EQ] = ACTIONS(290),
    [anon_sym_AMP_EQ] = ACTIONS(290),
    [anon_sym_CARET_EQ] = ACTIONS(290),
    [anon_sym_PIPE_EQ] = ACTIONS(290),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(318),
    [anon_sym_match] = ACTIONS(308),
    [anon_sym_type] = ACTIONS(320),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(322),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(298),
    [sym_string_start] = ACTIONS(113),
  },
  [39] = {
    [sym__simple_statements] = STATE(657),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(554),
    [sym_subscript] = STATE(554),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(571),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1542),
    [sym_primary_expression] = STATE(859),
    [sym_type] = STATE(1897),
    [sym_splat_type] = STATE(1853),
    [sym_generic_type] = STATE(1853),
    [sym_union_type] = STATE(1853),
    [sym_constrained_type] = STATE(1853),
    [sym_member_type] = STATE(1853),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(262),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(266),
    [anon_sym_print] = ACTIONS(268),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(270),
    [anon_sym_async] = ACTIONS(272),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_STAR_STAR] = ACTIONS(274),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(276),
    [anon_sym_match] = ACTIONS(272),
    [anon_sym_type] = ACTIONS(278),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(280),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(327),
    [sym__indent] = ACTIONS(329),
    [sym_string_start] = ACTIONS(113),
  },
  [40] = {
    [sym__simple_statements] = STATE(678),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(331),
    [sym__indent] = ACTIONS(333),
    [sym_string_start] = ACTIONS(113),
  },
  [41] = {
    [sym__simple_statements] = STATE(617),
    [sym_import_statement] = STATE(2157),
    [sym_future_import_statement] = STATE(2157),
    [sym_import_from_statement] = STATE(2157),
    [sym_print_statement] = STATE(2157),
    [sym_assert_statement] = STATE(2157),
    [sym_expression_statement] = STATE(2157),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2157),
    [sym_delete_statement] = STATE(2157),
    [sym_raise_statement] = STATE(2157),
    [sym_pass_statement] = STATE(2157),
    [sym_break_statement] = STATE(2157),
    [sym_continue_statement] = STATE(2157),
    [sym_global_statement] = STATE(2157),
    [sym_nonlocal_statement] = STATE(2157),
    [sym_exec_statement] = STATE(2157),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(335),
    [sym__indent] = ACTIONS(337),
    [sym_string_start] = ACTIONS(113),
  },
  [42] = {
    [sym__simple_statements] = STATE(2434),
    [sym_import_statement] = STATE(2161),
    [sym_future_import_statement] = STATE(2161),
    [sym_import_from_statement] = STATE(2161),
    [sym_print_statement] = STATE(2161),
    [sym_assert_statement] = STATE(2161),
    [sym_expression_statement] = STATE(2161),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2161),
    [sym_delete_statement] = STATE(2161),
    [sym_raise_statement] = STATE(2161),
    [sym_pass_statement] = STATE(2161),
    [sym_break_statement] = STATE(2161),
    [sym_continue_statement] = STATE(2161),
    [sym_global_statement] = STATE(2161),
    [sym_nonlocal_statement] = STATE(2161),
    [sym_exec_statement] = STATE(2161),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(339),
    [sym__indent] = ACTIONS(341),
    [sym_string_start] = ACTIONS(113),
  },
  [43] = {
    [sym__simple_statements] = STATE(1705),
    [sym_import_statement] = STATE(2171),
    [sym_future_import_statement] = STATE(2171),
    [sym_import_from_statement] = STATE(2171),
    [sym_print_statement] = STATE(2171),
    [sym_assert_statement] = STATE(2171),
    [sym_expression_statement] = STATE(2171),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2171),
    [sym_delete_statement] = STATE(2171),
    [sym_raise_statement] = STATE(2171),
    [sym_pass_statement] = STATE(2171),
    [sym_break_statement] = STATE(2171),
    [sym_continue_statement] = STATE(2171),
    [sym_global_statement] = STATE(2171),
    [sym_nonlocal_statement] = STATE(2171),
    [sym_exec_statement] = STATE(2171),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(343),
    [sym__indent] = ACTIONS(345),
    [sym_string_start] = ACTIONS(113),
  },
  [44] = {
    [sym__simple_statements] = STATE(642),
    [sym_import_statement] = STATE(2056),
    [sym_future_import_statement] = STATE(2056),
    [sym_import_from_statement] = STATE(2056),
    [sym_print_statement] = STATE(2056),
    [sym_assert_statement] = STATE(2056),
    [sym_expression_statement] = STATE(2056),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2056),
    [sym_delete_statement] = STATE(2056),
    [sym_raise_statement] = STATE(2056),
    [sym_pass_statement] = STATE(2056),
    [sym_break_statement] = STATE(2056),
    [sym_continue_statement] = STATE(2056),
    [sym_global_statement] = STATE(2056),
    [sym_nonlocal_statement] = STATE(2056),
    [sym_exec_statement] = STATE(2056),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(347),
    [sym__indent] = ACTIONS(349),
    [sym_string_start] = ACTIONS(113),
  },
  [45] = {
    [sym__simple_statements] = STATE(2466),
    [sym_import_statement] = STATE(2161),
    [sym_future_import_statement] = STATE(2161),
    [sym_import_from_statement] = STATE(2161),
    [sym_print_statement] = STATE(2161),
    [sym_assert_statement] = STATE(2161),
    [sym_expression_statement] = STATE(2161),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2161),
    [sym_delete_statement] = STATE(2161),
    [sym_raise_statement] = STATE(2161),
    [sym_pass_statement] = STATE(2161),
    [sym_break_statement] = STATE(2161),
    [sym_continue_statement] = STATE(2161),
    [sym_global_statement] = STATE(2161),
    [sym_nonlocal_statement] = STATE(2161),
    [sym_exec_statement] = STATE(2161),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(351),
    [sym__indent] = ACTIONS(353),
    [sym_string_start] = ACTIONS(113),
  },
  [46] = {
    [sym__simple_statements] = STATE(2411),
    [sym_import_statement] = STATE(2161),
    [sym_future_import_statement] = STATE(2161),
    [sym_import_from_statement] = STATE(2161),
    [sym_print_statement] = STATE(2161),
    [sym_assert_statement] = STATE(2161),
    [sym_expression_statement] = STATE(2161),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2161),
    [sym_delete_statement] = STATE(2161),
    [sym_raise_statement] = STATE(2161),
    [sym_pass_statement] = STATE(2161),
    [sym_break_statement] = STATE(2161),
    [sym_continue_statement] = STATE(2161),
    [sym_global_statement] = STATE(2161),
    [sym_nonlocal_statement] = STATE(2161),
    [sym_exec_statement] = STATE(2161),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(355),
    [sym__indent] = ACTIONS(357),
    [sym_string_start] = ACTIONS(113),
  },
  [47] = {
    [sym__simple_statements] = STATE(2269),
    [sym_import_statement] = STATE(1996),
    [sym_future_import_statement] = STATE(1996),
    [sym_import_from_statement] = STATE(1996),
    [sym_print_statement] = STATE(1996),
    [sym_assert_statement] = STATE(1996),
    [sym_expression_statement] = STATE(1996),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(1996),
    [sym_delete_statement] = STATE(1996),
    [sym_raise_statement] = STATE(1996),
    [sym_pass_statement] = STATE(1996),
    [sym_break_statement] = STATE(1996),
    [sym_continue_statement] = STATE(1996),
    [sym_global_statement] = STATE(1996),
    [sym_nonlocal_statement] = STATE(1996),
    [sym_exec_statement] = STATE(1996),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(359),
    [sym__indent] = ACTIONS(361),
    [sym_string_start] = ACTIONS(113),
  },
  [48] = {
    [sym__simple_statements] = STATE(671),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(363),
    [sym__indent] = ACTIONS(365),
    [sym_string_start] = ACTIONS(113),
  },
  [49] = {
    [sym__simple_statements] = STATE(2351),
    [sym_import_statement] = STATE(2161),
    [sym_future_import_statement] = STATE(2161),
    [sym_import_from_statement] = STATE(2161),
    [sym_print_statement] = STATE(2161),
    [sym_assert_statement] = STATE(2161),
    [sym_expression_statement] = STATE(2161),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2161),
    [sym_delete_statement] = STATE(2161),
    [sym_raise_statement] = STATE(2161),
    [sym_pass_statement] = STATE(2161),
    [sym_break_statement] = STATE(2161),
    [sym_continue_statement] = STATE(2161),
    [sym_global_statement] = STATE(2161),
    [sym_nonlocal_statement] = STATE(2161),
    [sym_exec_statement] = STATE(2161),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(367),
    [sym__indent] = ACTIONS(369),
    [sym_string_start] = ACTIONS(113),
  },
  [50] = {
    [sym__simple_statements] = STATE(562),
    [sym_import_statement] = STATE(2203),
    [sym_future_import_statement] = STATE(2203),
    [sym_import_from_statement] = STATE(2203),
    [sym_print_statement] = STATE(2203),
    [sym_assert_statement] = STATE(2203),
    [sym_expression_statement] = STATE(2203),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2203),
    [sym_delete_statement] = STATE(2203),
    [sym_raise_statement] = STATE(2203),
    [sym_pass_statement] = STATE(2203),
    [sym_break_statement] = STATE(2203),
    [sym_continue_statement] = STATE(2203),
    [sym_global_statement] = STATE(2203),
    [sym_nonlocal_statement] = STATE(2203),
    [sym_exec_statement] = STATE(2203),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__indent] = ACTIONS(373),
    [sym_string_start] = ACTIONS(113),
  },
  [51] = {
    [sym__simple_statements] = STATE(591),
    [sym_import_statement] = STATE(2122),
    [sym_future_import_statement] = STATE(2122),
    [sym_import_from_statement] = STATE(2122),
    [sym_print_statement] = STATE(2122),
    [sym_assert_statement] = STATE(2122),
    [sym_expression_statement] = STATE(2122),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2122),
    [sym_delete_statement] = STATE(2122),
    [sym_raise_statement] = STATE(2122),
    [sym_pass_statement] = STATE(2122),
    [sym_break_statement] = STATE(2122),
    [sym_continue_statement] = STATE(2122),
    [sym_global_statement] = STATE(2122),
    [sym_nonlocal_statement] = STATE(2122),
    [sym_exec_statement] = STATE(2122),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(375),
    [sym__indent] = ACTIONS(377),
    [sym_string_start] = ACTIONS(113),
  },
  [52] = {
    [sym__simple_statements] = STATE(610),
    [sym_import_statement] = STATE(2157),
    [sym_future_import_statement] = STATE(2157),
    [sym_import_from_statement] = STATE(2157),
    [sym_print_statement] = STATE(2157),
    [sym_assert_statement] = STATE(2157),
    [sym_expression_statement] = STATE(2157),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2157),
    [sym_delete_statement] = STATE(2157),
    [sym_raise_statement] = STATE(2157),
    [sym_pass_statement] = STATE(2157),
    [sym_break_statement] = STATE(2157),
    [sym_continue_statement] = STATE(2157),
    [sym_global_statement] = STATE(2157),
    [sym_nonlocal_statement] = STATE(2157),
    [sym_exec_statement] = STATE(2157),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__indent] = ACTIONS(381),
    [sym_string_start] = ACTIONS(113),
  },
  [53] = {
    [sym__simple_statements] = STATE(655),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__indent] = ACTIONS(385),
    [sym_string_start] = ACTIONS(113),
  },
  [54] = {
    [sym__simple_statements] = STATE(605),
    [sym_import_statement] = STATE(2203),
    [sym_future_import_statement] = STATE(2203),
    [sym_import_from_statement] = STATE(2203),
    [sym_print_statement] = STATE(2203),
    [sym_assert_statement] = STATE(2203),
    [sym_expression_statement] = STATE(2203),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2203),
    [sym_delete_statement] = STATE(2203),
    [sym_raise_statement] = STATE(2203),
    [sym_pass_statement] = STATE(2203),
    [sym_break_statement] = STATE(2203),
    [sym_continue_statement] = STATE(2203),
    [sym_global_statement] = STATE(2203),
    [sym_nonlocal_statement] = STATE(2203),
    [sym_exec_statement] = STATE(2203),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(387),
    [sym__indent] = ACTIONS(389),
    [sym_string_start] = ACTIONS(113),
  },
  [55] = {
    [sym__simple_statements] = STATE(590),
    [sym_import_statement] = STATE(2073),
    [sym_future_import_statement] = STATE(2073),
    [sym_import_from_statement] = STATE(2073),
    [sym_print_statement] = STATE(2073),
    [sym_assert_statement] = STATE(2073),
    [sym_expression_statement] = STATE(2073),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2073),
    [sym_delete_statement] = STATE(2073),
    [sym_raise_statement] = STATE(2073),
    [sym_pass_statement] = STATE(2073),
    [sym_break_statement] = STATE(2073),
    [sym_continue_statement] = STATE(2073),
    [sym_global_statement] = STATE(2073),
    [sym_nonlocal_statement] = STATE(2073),
    [sym_exec_statement] = STATE(2073),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(391),
    [sym__indent] = ACTIONS(393),
    [sym_string_start] = ACTIONS(113),
  },
  [56] = {
    [sym__simple_statements] = STATE(586),
    [sym_import_statement] = STATE(2122),
    [sym_future_import_statement] = STATE(2122),
    [sym_import_from_statement] = STATE(2122),
    [sym_print_statement] = STATE(2122),
    [sym_assert_statement] = STATE(2122),
    [sym_expression_statement] = STATE(2122),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2122),
    [sym_delete_statement] = STATE(2122),
    [sym_raise_statement] = STATE(2122),
    [sym_pass_statement] = STATE(2122),
    [sym_break_statement] = STATE(2122),
    [sym_continue_statement] = STATE(2122),
    [sym_global_statement] = STATE(2122),
    [sym_nonlocal_statement] = STATE(2122),
    [sym_exec_statement] = STATE(2122),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(395),
    [sym__indent] = ACTIONS(397),
    [sym_string_start] = ACTIONS(113),
  },
  [57] = {
    [sym__simple_statements] = STATE(593),
    [sym_import_statement] = STATE(2122),
    [sym_future_import_statement] = STATE(2122),
    [sym_import_from_statement] = STATE(2122),
    [sym_print_statement] = STATE(2122),
    [sym_assert_statement] = STATE(2122),
    [sym_expression_statement] = STATE(2122),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2122),
    [sym_delete_statement] = STATE(2122),
    [sym_raise_statement] = STATE(2122),
    [sym_pass_statement] = STATE(2122),
    [sym_break_statement] = STATE(2122),
    [sym_continue_statement] = STATE(2122),
    [sym_global_statement] = STATE(2122),
    [sym_nonlocal_statement] = STATE(2122),
    [sym_exec_statement] = STATE(2122),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(399),
    [sym__indent] = ACTIONS(401),
    [sym_string_start] = ACTIONS(113),
  },
  [58] = {
    [sym__simple_statements] = STATE(654),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(403),
    [sym__indent] = ACTIONS(405),
    [sym_string_start] = ACTIONS(113),
  },
  [59] = {
    [sym__simple_statements] = STATE(601),
    [sym_import_statement] = STATE(2157),
    [sym_future_import_statement] = STATE(2157),
    [sym_import_from_statement] = STATE(2157),
    [sym_print_statement] = STATE(2157),
    [sym_assert_statement] = STATE(2157),
    [sym_expression_statement] = STATE(2157),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2157),
    [sym_delete_statement] = STATE(2157),
    [sym_raise_statement] = STATE(2157),
    [sym_pass_statement] = STATE(2157),
    [sym_break_statement] = STATE(2157),
    [sym_continue_statement] = STATE(2157),
    [sym_global_statement] = STATE(2157),
    [sym_nonlocal_statement] = STATE(2157),
    [sym_exec_statement] = STATE(2157),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(407),
    [sym__indent] = ACTIONS(409),
    [sym_string_start] = ACTIONS(113),
  },
  [60] = {
    [sym__simple_statements] = STATE(673),
    [sym_import_statement] = STATE(2091),
    [sym_future_import_statement] = STATE(2091),
    [sym_import_from_statement] = STATE(2091),
    [sym_print_statement] = STATE(2091),
    [sym_assert_statement] = STATE(2091),
    [sym_expression_statement] = STATE(2091),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2091),
    [sym_delete_statement] = STATE(2091),
    [sym_raise_statement] = STATE(2091),
    [sym_pass_statement] = STATE(2091),
    [sym_break_statement] = STATE(2091),
    [sym_continue_statement] = STATE(2091),
    [sym_global_statement] = STATE(2091),
    [sym_nonlocal_statement] = STATE(2091),
    [sym_exec_statement] = STATE(2091),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(411),
    [sym__indent] = ACTIONS(413),
    [sym_string_start] = ACTIONS(113),
  },
  [61] = {
    [sym_import_statement] = STATE(2229),
    [sym_future_import_statement] = STATE(2229),
    [sym_import_from_statement] = STATE(2229),
    [sym_print_statement] = STATE(2229),
    [sym_assert_statement] = STATE(2229),
    [sym_expression_statement] = STATE(2229),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2229),
    [sym_delete_statement] = STATE(2229),
    [sym_raise_statement] = STATE(2229),
    [sym_pass_statement] = STATE(2229),
    [sym_break_statement] = STATE(2229),
    [sym_continue_statement] = STATE(2229),
    [sym_global_statement] = STATE(2229),
    [sym_nonlocal_statement] = STATE(2229),
    [sym_exec_statement] = STATE(2229),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(415),
    [sym_string_start] = ACTIONS(113),
  },
  [62] = {
    [sym_import_statement] = STATE(2229),
    [sym_future_import_statement] = STATE(2229),
    [sym_import_from_statement] = STATE(2229),
    [sym_print_statement] = STATE(2229),
    [sym_assert_statement] = STATE(2229),
    [sym_expression_statement] = STATE(2229),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2229),
    [sym_delete_statement] = STATE(2229),
    [sym_raise_statement] = STATE(2229),
    [sym_pass_statement] = STATE(2229),
    [sym_break_statement] = STATE(2229),
    [sym_continue_statement] = STATE(2229),
    [sym_global_statement] = STATE(2229),
    [sym_nonlocal_statement] = STATE(2229),
    [sym_exec_statement] = STATE(2229),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STATE(552),
    [sym_as_pattern] = STATE(1527),
    [sym_expression] = STATE(1660),
    [sym_primary_expression] = STATE(859),
    [sym_list] = STATE(980),
    [sym_set] = STATE(980),
    [sym_tuple] = STATE(980),
    [sym_dictionary] = STATE(980),
    [sym_list_comprehension] = STATE(980),
    [sym_dictionary_comprehension] = STATE(980),
    [sym_set_comprehension] = STATE(980),
    [sym_conditional_expression] = STATE(1527),
    [sym_concatenated_string] = STATE(980),
    [sym_python_string] = STATE(834),
    [sym_await] = STATE(980),
    [anon_sym_LBRACK] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_import] = ACTIONS(47),
    [anon_sym_from] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_print] = ACTIONS(53),
    [anon_sym_assert] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_del] = ACTIONS(59),
    [anon_sym_raise] = ACTIONS(61),
    [anon_sym_pass] = ACTIONS(63),
    [anon_sym_break] = ACTIONS(65),
    [anon_sym_continue] = ACTIONS(67),
    [anon_sym_global] = ACTIONS(69),
    [anon_sym_nonlocal] = ACTIONS(71),
    [anon_sym_exec] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(89),
    [anon_sym_lambda] = ACTIONS(93),
    [anon_sym_yield] = ACTIONS(95),
    [sym_ellipsis] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_match] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(103),
    [sym_integer] = ACTIONS(105),
    [sym_float] = ACTIONS(105),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_none] = ACTIONS(105),
    [sym_python_identifier] = ACTIONS(107),
    [sym_identifier] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(417),
    [sym_string_start] = ACTIONS(113),
  },
  [63] = {
    [sym_import_statement] = STATE(2229),
    [sym_future_import_statement] = STATE(2229),
    [sym_import_from_statement] = STATE(2229),
    [sym_print_statement] = STATE(2229),
    [sym_assert_statement] = STATE(2229),
    [sym_expression_statement] = STATE(2229),
    [sym_named_expression] = STATE(1527),
    [sym__named_expression_lhs] = STATE(2377),
    [sym_return_statement] = STATE(2229),
    [sym_delete_statement] = STATE(2229),
    [sym_raise_statement] = STATE(2229),
    [sym_pass_statement] = STATE(2229),
    [sym_break_statement] = STATE(2229),
    [sym_continue_statement] = STATE(2229),
    [sym_global_statement] = STATE(2229),
    [sym_nonlocal_statement] = STATE(2229),
    [sym_exec_statement] = STATE(2229),
    [sym_not_operator] = STATE(1527),
    [sym_boolean_operator] = STATE(1527),
    [sym_binary_operator] = STATE(980),
    [sym_unary_operator] = STATE(980),
    [sym_comparison_operator] = STATE(1527),
    [sym_lambda] = STATE(1527),
    [sym_assignment] = STATE(2282),
    [sym_augmented_assignment] = STATE(2282),
    [sym_pattern_list] = STATE(1514),
    [sym_yield] = STATE(2282),
    [sym_attribute] = STATE(551),
    [sym_subscript] = STATE(551),
    [sym_call] = STATE(980),
    [sym_generator_expression] = STATE(980),
    [sym_parenthesized_expression] = STATE(980),
    [sym_pattern] = STATE(1483),
    [sym_tuple_pattern] = STATE(1496),
    [sym_list_pattern] = STATE(1496),
    [sym_list_splat_pattern] = STAT