#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 74
#define LARGE_STATE_COUNT 7
#define SYMBOL_COUNT 35
#define ALIAS_COUNT 2
#define TOKEN_COUNT 17
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 5
#define PRODUCTION_ID_COUNT 5

enum ts_symbol_identifiers {
  anon_sym_EQ = 1,
  anon_sym_COLON = 2,
  anon_sym_DOT = 3,
  anon_sym_LBRACK = 4,
  anon_sym_RBRACK = 5,
  anon_sym_DOLLAR_LBRACE = 6,
  anon_sym_RBRACE = 7,
  anon_sym_COLON_COLON = 8,
  anon_sym_BSLASH = 9,
  aux_sym_escape_token1 = 10,
  aux_sym_escape_token2 = 11,
  sym_comment = 12,
  sym__space = 13,
  aux_sym__char_token1 = 14,
  sym__eol = 15,
  sym__eof = 16,
  sym_file = 17,
  sym_property = 18,
  sym_key = 19,
  sym__index = 20,
  sym_value = 21,
  sym_substitution = 22,
  sym__default = 23,
  sym__secret = 24,
  aux_sym__content = 25,
  sym__linebreak = 26,
  sym_escape = 27,
  sym__char = 28,
  aux_sym_file_repeat1 = 29,
  aux_sym_file_repeat2 = 30,
  aux_sym_key_repeat1 = 31,
  aux_sym__index_repeat1 = 32,
  aux_sym_value_repeat1 = 33,
  aux_sym_substitution_repeat1 = 34,
  alias_sym_index = 35,
  alias_sym_secret = 36,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_EQ] = "=",
  [anon_sym_COLON] = ":",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_escape_token1] = "escape_token1",
  [aux_sym_escape_token2] = "escape_token2",
  [sym_comment] = "comment",
  [sym__space] = "_space",
  [aux_sym__char_token1] = "_char_token1",
  [sym__eol] = "_eol",
  [sym__eof] = "_eof",
  [sym_file] = "file",
  [sym_property] = "property",
  [sym_key] = "key",
  [sym__index] = "_index",
  [sym_value] = "value",
  [sym_substitution] = "substitution",
  [sym__default] = "_default",
  [sym__secret] = "_secret",
  [aux_sym__content] = "_content",
  [sym__linebreak] = "_linebreak",
  [sym_escape] = "escape",
  [sym__char] = "_char",
  [aux_sym_file_repeat1] = "file_repeat1",
  [aux_sym_file_repeat2] = "file_repeat2",
  [aux_sym_key_repeat1] = "key_repeat1",
  [aux_sym__index_repeat1] = "_index_repeat1",
  [aux_sym_value_repeat1] = "value_repeat1",
  [aux_sym_substitution_repeat1] = "substitution_repeat1",
  [alias_sym_index] = "index",
  [alias_sym_secret] = "secret",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_escape_token1] = aux_sym_escape_token1,
  [aux_sym_escape_token2] = aux_sym_escape_token2,
  [sym_comment] = sym_comment,
  [sym__space] = sym__space,
  [aux_sym__char_token1] = aux_sym__char_token1,
  [sym__eol] = sym__eol,
  [sym__eof] = sym__eof,
  [sym_file] = sym_file,
  [sym_property] = sym_property,
  [sym_key] = sym_key,
  [sym__index] = sym__index,
  [sym_value] = sym_value,
  [sym_substitution] = sym_substitution,
  [sym__default] = sym__default,
  [sym__secret] = sym__secret,
  [aux_sym__content] = aux_sym__content,
  [sym__linebreak] = sym__linebreak,
  [sym_escape] = sym_escape,
  [sym__char] = sym__char,
  [aux_sym_file_repeat1] = aux_sym_file_repeat1,
  [aux_sym_file_repeat2] = aux_sym_file_repeat2,
  [aux_sym_key_repeat1] = aux_sym_key_repeat1,
  [aux_sym__index_repeat1] = aux_sym__index_repeat1,
  [aux_sym_value_repeat1] = aux_sym_value_repeat1,
  [aux_sym_substitution_repeat1] = aux_sym_substitution_repeat1,
  [alias_sym_index] = alias_sym_index,
  [alias_sym_secret] = alias_sym_secret,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_escape_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__space] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__char_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__eol] = {
    .visible = false,
    .named = true,
  },
  [sym__eof] = {
    .visible = false,
    .named = true,
  },
  [sym_file] = {
    .visible = true,
    .named = true,
  },
  [sym_property] = {
    .visible = true,
    .named = true,
  },
  [sym_key] = {
    .visible = true,
    .named = true,
  },
  [sym__index] = {
    .visible = false,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym__default] = {
    .visible = false,
    .named = true,
  },
  [sym__secret] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__content] = {
    .visible = false,
    .named = false,
  },
  [sym__linebreak] = {
    .visible = false,
    .named = true,
  },
  [sym_escape] = {
    .visible = true,
    .named = true,
  },
  [sym__char] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_file_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_key_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__index_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_substitution_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_index] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_secret] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_default = 1,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_default] = "default",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_default, 1},
  [1] =
    {field_default, 2, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [1] = alias_sym_index,
  },
  [3] = {
    [1] = alias_sym_secret,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__content, 2,
    aux_sym__content,
    alias_sym_secret,
  aux_sym__index_repeat1, 2,
    aux_sym__index_repeat1,
    alias_sym_index,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 4,
  [6] = 4,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 11,
  [20] = 12,
  [21] = 18,
  [22] = 18,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 28,
  [31] = 31,
  [32] = 32,
  [33] = 28,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 23,
  [38] = 38,
  [39] = 26,
  [40] = 40,
  [41] = 41,
  [42] = 24,
  [43] = 43,
  [44] = 40,
  [45] = 41,
  [46] = 38,
  [47] = 24,
  [48] = 48,
  [49] = 49,
  [50] = 40,
  [51] = 41,
  [52] = 38,
  [53] = 24,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 55,
  [58] = 56,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 67,
  [70] = 67,
  [71] = 66,
  [72] = 66,
  [73] = 73,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(15);
      ADVANCE_MAP(
        '\n', 35,
        '\r', 32,
        '$', 34,
        '.', 19,
        ':', 18,
        '=', 16,
        '[', 20,
        '\\', 25,
        ']', 21,
        '}', 23,
        '!', 29,
        '#', 29,
        '\t', 30,
        '\f', 30,
        ' ', 30,
      );
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '\n', 35,
        '\r', 32,
        '$', 34,
        '.', 19,
        ':', 17,
        '=', 16,
        '[', 20,
        '\\', 25,
        '\t', 30,
        '\f', 30,
        ' ', 30,
      );
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '\n', 35,
        '\r', 32,
        '$', 34,
        ':', 17,
        '=', 16,
        '\\', 25,
        '\t', 30,
        '\f', 30,
        ' ', 30,
      );
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '\r') ADVANCE(32);
      if (lookahead == '$') ADVANCE(34);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == '\t' ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(30);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '\r') ADVANCE(32);
      if (lookahead == '$') ADVANCE(34);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '\r') ADVANCE(36);
      END_STATE();
    case 6:
      if (lookahead == '$') ADVANCE(34);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == ':') ADVANCE(18);
      if (lookahead == '[') ADVANCE(20);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == '}') ADVANCE(23);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(31);
      END_STATE();
    case 7:
      if (lookahead == '$') ADVANCE(34);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '[') ADVANCE(20);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(31);
      END_STATE();
    case 8:
      if (lookahead == '$') ADVANCE(34);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == '}') ADVANCE(23);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(31);
      END_STATE();
    case 9:
      if (lookahead == '$') ADVANCE(34);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(31);
      END_STATE();
    case 10:
      if (lookahead == ']') ADVANCE(21);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(31);
      END_STATE();
    case 11:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(28);
      END_STATE();
    case 12:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(11);
      END_STATE();
    case 13:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(12);
      END_STATE();
    case 14:
      if (eof) ADVANCE(15);
      ADVANCE_MAP(
        '\n', 35,
        '\r', 32,
        '.', 19,
        '[', 20,
        '\\', 33,
        '!', 29,
        '#', 29,
        '\t', 30,
        '\f', 30,
        ' ', 30,
      );
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(24);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == 'u') ADVANCE(27);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(26);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(aux_sym_escape_token1);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(aux_sym_escape_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(13);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(aux_sym_escape_token2);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(29);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym__space);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(aux_sym__char_token1);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(aux_sym__char_token1);
      if (lookahead == '\n') ADVANCE(35);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(aux_sym__char_token1);
      if (lookahead == 'u') ADVANCE(27);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(26);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(aux_sym__char_token1);
      if (lookahead == '{') ADVANCE(22);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym__eol);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym__eol);
      if (lookahead == '\n') ADVANCE(35);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 14, .external_lex_state = 1},
  [2] = {.lex_state = 14, .external_lex_state = 1},
  [3] = {.lex_state = 14, .external_lex_state = 1},
  [4] = {.lex_state = 6},
  [5] = {.lex_state = 6},
  [6] = {.lex_state = 6},
  [7] = {.lex_state = 2, .external_lex_state = 1},
  [8] = {.lex_state = 2, .external_lex_state = 1},
  [9] = {.lex_state = 2, .external_lex_state = 1},
  [10] = {.lex_state = 14, .external_lex_state = 1},
  [11] = {.lex_state = 1, .external_lex_state = 1},
  [12] = {.lex_state = 1, .external_lex_state = 1},
  [13] = {.lex_state = 6},
  [14] = {.lex_state = 3, .external_lex_state = 1},
  [15] = {.lex_state = 3, .external_lex_state = 1},
  [16] = {.lex_state = 3, .external_lex_state = 1},
  [17] = {.lex_state = 3, .external_lex_state = 1},
  [18] = {.lex_state = 7},
  [19] = {.lex_state = 6},
  [20] = {.lex_state = 6},
  [21] = {.lex_state = 7},
  [22] = {.lex_state = 7},
  [23] = {.lex_state = 1, .external_lex_state = 1},
  [24] = {.lex_state = 1, .external_lex_state = 1},
  [25] = {.lex_state = 4, .external_lex_state = 1},
  [26] = {.lex_state = 1, .external_lex_state = 1},
  [27] = {.lex_state = 4, .external_lex_state = 1},
  [28] = {.lex_state = 2, .external_lex_state = 1},
  [29] = {.lex_state = 14, .external_lex_state = 1},
  [30] = {.lex_state = 14, .external_lex_state = 1},
  [31] = {.lex_state = 14, .external_lex_state = 1},
  [32] = {.lex_state = 8},
  [33] = {.lex_state = 3, .external_lex_state = 1},
  [34] = {.lex_state = 8},
  [35] = {.lex_state = 8},
  [36] = {.lex_state = 8},
  [37] = {.lex_state = 6},
  [38] = {.lex_state = 6},
  [39] = {.lex_state = 6},
  [40] = {.lex_state = 6},
  [41] = {.lex_state = 6},
  [42] = {.lex_state = 6},
  [43] = {.lex_state = 9},
  [44] = {.lex_state = 4, .external_lex_state = 1},
  [45] = {.lex_state = 4, .external_lex_state = 1},
  [46] = {.lex_state = 4, .external_lex_state = 1},
  [47] = {.lex_state = 4, .external_lex_state = 1},
  [48] = {.lex_state = 4, .external_lex_state = 1},
  [49] = {.lex_state = 8},
  [50] = {.lex_state = 8},
  [51] = {.lex_state = 8},
  [52] = {.lex_state = 8},
  [53] = {.lex_state = 8},
  [54] = {.lex_state = 10},
  [55] = {.lex_state = 10},
  [56] = {.lex_state = 10},
  [57] = {.lex_state = 10},
  [58] = {.lex_state = 10},
  [59] = {.lex_state = 5, .external_lex_state = 1},
  [60] = {.lex_state = 5, .external_lex_state = 1},
  [61] = {.lex_state = 10},
  [62] = {.lex_state = 5, .external_lex_state = 1},
  [63] = {.lex_state = 5, .external_lex_state = 1},
  [64] = {.lex_state = 5, .external_lex_state = 1},
  [65] = {.lex_state = 5, .external_lex_state = 1},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 5},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [aux_sym_escape_token1] = ACTIONS(1),
    [aux_sym_escape_token2] = ACTIONS(1),
    [sym_comment] = ACTIONS(1),
    [sym__space] = ACTIONS(1),
    [aux_sym__char_token1] = ACTIONS(1),
    [sym__eol] = ACTIONS(1),
    [sym__eof] = ACTIONS(1),
  },
  [1] = {
    [sym_file] = STATE(73),
    [sym_property] = STATE(62),
    [sym_key] = STATE(8),
    [sym__index] = STATE(11),
    [sym_escape] = STATE(11),
    [sym__char] = STATE(11),
    [aux_sym_file_repeat1] = STATE(10),
    [aux_sym_file_repeat2] = STATE(2),
    [aux_sym_key_repeat1] = STATE(11),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_DOT] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [aux_sym_escape_token1] = ACTIONS(9),
    [aux_sym_escape_token2] = ACTIONS(11),
    [sym_comment] = ACTIONS(13),
    [sym__space] = ACTIONS(15),
    [aux_sym__char_token1] = ACTIONS(17),
    [sym__eol] = ACTIONS(19),
    [sym__eof] = ACTIONS(21),
  },
  [2] = {
    [sym_property] = STATE(62),
    [sym_key] = STATE(8),
    [sym__index] = STATE(11),
    [sym_escape] = STATE(11),
    [sym__char] = STATE(11),
    [aux_sym_file_repeat1] = STATE(10),
    [aux_sym_file_repeat2] = STATE(3),
    [aux_sym_key_repeat1] = STATE(11),
    [ts_builtin_sym_end] = ACTIONS(23),
    [anon_sym_DOT] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [aux_sym_escape_token1] = ACTIONS(9),
    [aux_sym_escape_token2] = ACTIONS(11),
    [sym_comment] = ACTIONS(13),
    [sym__space] = ACTIONS(15),
    [aux_sym__char_token1] = ACTIONS(17),
    [sym__eol] = ACTIONS(25),
    [sym__eof] = ACTIONS(27),
  },
  [3] = {
    [sym_property] = STATE(62),
    [sym_key] = STATE(8),
    [sym__index] = STATE(11),
    [sym_escape] = STATE(11),
    [sym__char] = STATE(11),
    [aux_sym_file_repeat1] = STATE(10),
    [aux_sym_file_repeat2] = STATE(3),
    [aux_sym_key_repeat1] = STATE(11),
    [ts_builtin_sym_end] = ACTIONS(29),
    [anon_sym_DOT] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(34),
    [aux_sym_escape_token1] = ACTIONS(37),
    [aux_sym_escape_token2] = ACTIONS(40),
    [sym_comment] = ACTIONS(43),
    [sym__space] = ACTIONS(46),
    [aux_sym__char_token1] = ACTIONS(49),
    [sym__eol] = ACTIONS(52),
    [sym__eof] = ACTIONS(55),
  },
  [4] = {
    [sym_key] = STATE(13),
    [sym__index] = STATE(19),
    [sym_substitution] = STATE(13),
    [sym__default] = STATE(69),
    [sym__secret] = STATE(71),
    [sym_escape] = STATE(19),
    [sym__char] = STATE(19),
    [aux_sym_key_repeat1] = STATE(19),
    [aux_sym_substitution_repeat1] = STATE(13),
    [anon_sym_COLON] = ACTIONS(58),
    [anon_sym_DOT] = ACTIONS(60),
    [anon_sym_LBRACK] = ACTIONS(62),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(64),
    [anon_sym_RBRACE] = ACTIONS(66),
    [anon_sym_COLON_COLON] = ACTIONS(68),
    [aux_sym_escape_token1] = ACTIONS(70),
    [aux_sym_escape_token2] = ACTIONS(72),
    [aux_sym__char_token1] = ACTIONS(74),
  },
  [5] = {
    [sym_key] = STATE(13),
    [sym__index] = STATE(19),
    [sym_substitution] = STATE(13),
    [sym__default] = STATE(67),
    [sym__secret] = STATE(66),
    [sym_escape] = STATE(19),
    [sym__char] = STATE(19),
    [aux_sym_key_repeat1] = STATE(19),
    [aux_sym_substitution_repeat1] = STATE(13),
    [anon_sym_COLON] = ACTIONS(58),
    [anon_sym_DOT] = ACTIONS(60),
    [anon_sym_LBRACK] = ACTIONS(62),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(64),
    [anon_sym_RBRACE] = ACTIONS(76),
    [anon_sym_COLON_COLON] = ACTIONS(68),
    [aux_sym_escape_token1] = ACTIONS(70),
    [aux_sym_escape_token2] = ACTIONS(72),
    [aux_sym__char_token1] = ACTIONS(74),
  },
  [6] = {
    [sym_key] = STATE(13),
    [sym__index] = STATE(19),
    [sym_substitution] = STATE(13),
    [sym__default] = STATE(70),
    [sym__secret] = STATE(72),
    [sym_escape] = STATE(19),
    [sym__char] = STATE(19),
    [aux_sym_key_repeat1] = STATE(19),
    [aux_sym_substitution_repeat1] = STATE(13),
    [anon_sym_COLON] = ACTIONS(58),
    [anon_sym_DOT] = ACTIONS(60),
    [anon_sym_LBRACK] = ACTIONS(62),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(64),
    [anon_sym_RBRACE] = ACTIONS(78),
    [anon_sym_COLON_COLON] = ACTIONS(68),
    [aux_sym_escape_token1] = ACTIONS(70),
    [aux_sym_escape_token2] = ACTIONS(72),
    [aux_sym__char_token1] = ACTIONS(74),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 12,
    ACTIONS(82), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(84), 1,
      anon_sym_BSLASH,
    ACTIONS(86), 1,
      aux_sym_escape_token1,
    ACTIONS(88), 1,
      aux_sym_escape_token2,
    ACTIONS(90), 1,
      sym__space,
    ACTIONS(92), 1,
      aux_sym__char_token1,
    ACTIONS(94), 1,
      sym__eol,
    ACTIONS(96), 1,
      sym__eof,
    STATE(9), 1,
      aux_sym_file_repeat1,
    STATE(63), 1,
      sym_value,
    ACTIONS(80), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    STATE(25), 5,
      sym_substitution,
      sym__linebreak,
      sym_escape,
      sym__char,
      aux_sym_value_repeat1,
  [42] = 12,
    ACTIONS(82), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(84), 1,
      anon_sym_BSLASH,
    ACTIONS(86), 1,
      aux_sym_escape_token1,
    ACTIONS(88), 1,
      aux_sym_escape_token2,
    ACTIONS(92), 1,
      aux_sym__char_token1,
    ACTIONS(100), 1,
      sym__space,
    ACTIONS(102), 1,
      sym__eol,
    ACTIONS(104), 1,
      sym__eof,
    STATE(7), 1,
      aux_sym_file_repeat1,
    STATE(59), 1,
      sym_value,
    ACTIONS(98), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    STATE(25), 5,
      sym_substitution,
      sym__linebreak,
      sym_escape,
      sym__char,
      aux_sym_value_repeat1,
  [84] = 12,
    ACTIONS(82), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(84), 1,
      anon_sym_BSLASH,
    ACTIONS(86), 1,
      aux_sym_escape_token1,
    ACTIONS(88), 1,
      aux_sym_escape_token2,
    ACTIONS(92), 1,
      aux_sym__char_token1,
    ACTIONS(108), 1,
      sym__space,
    ACTIONS(111), 1,
      sym__eol,
    ACTIONS(113), 1,
      sym__eof,
    STATE(28), 1,
      aux_sym_file_repeat1,
    STATE(60), 1,
      sym_value,
    ACTIONS(106), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    STATE(25), 5,
      sym_substitution,
      sym__linebreak,
      sym_escape,
      sym__char,
      aux_sym_value_repeat1,
  [126] = 13,
    ACTIONS(5), 1,
      anon_sym_DOT,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      aux_sym_escape_token1,
    ACTIONS(11), 1,
      aux_sym_escape_token2,
    ACTIONS(17), 1,
      aux_sym__char_token1,
    ACTIONS(115), 1,
      sym_comment,
    ACTIONS(117), 1,
      sym__space,
    ACTIONS(119), 1,
      sym__eol,
    ACTIONS(121), 1,
      sym__eof,
    STATE(8), 1,
      sym_key,
    STATE(30), 1,
      aux_sym_file_repeat1,
    STATE(65), 1,
      sym_property,
    STATE(11), 4,
      sym__index,
      sym_escape,
      sym__char,
      aux_sym_key_repeat1,
  [169] = 8,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      aux_sym_escape_token1,
    ACTIONS(11), 1,
      aux_sym_escape_token2,
    ACTIONS(125), 1,
      anon_sym_DOT,
    ACTIONS(129), 1,
      aux_sym__char_token1,
    ACTIONS(127), 2,
      anon_sym_BSLASH,
      sym__eol,
    STATE(12), 4,
      sym__index,
      sym_escape,
      sym__char,
      aux_sym_key_repeat1,
    ACTIONS(123), 5,
      sym__eof,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_DOLLAR_LBRACE,
      sym__space,
  [202] = 8,
    ACTIONS(133), 1,
      anon_sym_DOT,
    ACTIONS(136), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      aux_sym_escape_token1,
    ACTIONS(144), 1,
      aux_sym_escape_token2,
    ACTIONS(147), 1,
      aux_sym__char_token1,
    ACTIONS(139), 2,
      anon_sym_BSLASH,
      sym__eol,
    STATE(12), 4,
      sym__index,
      sym_escape,
      sym__char,
      aux_sym_key_repeat1,
    ACTIONS(131), 5,
      sym__eof,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_DOLLAR_LBRACE,
      sym__space,
  [235] = 10,
    ACTIONS(150), 1,
      anon_sym_COLON,
    ACTIONS(152), 1,
      anon_sym_DOT,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(158), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(163), 1,
      aux_sym_escape_token1,
    ACTIONS(166), 1,
      aux_sym_escape_token2,
    ACTIONS(169), 1,
      aux_sym__char_token1,
    ACTIONS(161), 2,
      anon_sym_RBRACE,
      anon_sym_COLON_COLON,
    STATE(13), 3,
      sym_key,
      sym_substitution,
      aux_sym_substitution_repeat1,
    STATE(19), 4,
      sym__index,
      sym_escape,
      sym__char,
      aux_sym_key_repeat1,
  [272] = 11,
    ACTIONS(82), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(84), 1,
      anon_sym_BSLASH,
    ACTIONS(86), 1,
      aux_sym_escape_token1,
    ACTIONS(88), 1,
      aux_sym_escape_token2,
    ACTIONS(92), 1,
      aux_sym__char_token1,
    ACTIONS(94), 1,
      sym__eol,
    ACTIONS(96), 1,
      sym__eof,
    ACTIONS(172), 1,
      sym__space,
    STATE(15), 1,
      aux_sym_file_repeat1,
    STATE(63), 1,
      sym_value,
    STATE(25), 5,
      sym_substitution,
      sym__linebreak,
      sym_escape,
      sym__char,
      aux_sym_value_repeat1,
  [310] = 11,
    ACTIONS(82), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(84), 1,
      anon_sym_BSLASH,
    ACTIONS(86), 1,
      aux_sym_escape_token1,
    ACTIONS(88), 1,
      aux_sym_escape_token2,
    ACTIONS(92), 1,
      aux_sym__char_token1,
    ACTIONS(111), 1,
      sym__eol,
    ACTIONS(113), 1,
      sym__eof,
    ACTIONS(174), 1,
      sym__space,
    STATE(33), 1,
      aux_sym_file_repeat1,
    STATE(60), 1,
      sym_value,
    STATE(25), 5,
      sym_substitution,
      sym__linebreak,
      sym_escape,
      sym__char,
      aux_sym_value_repeat1,
  [348] = 11,
    ACTIONS(82), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(84), 1,
      anon_sym_BSLASH,
    ACTIONS(86), 1,
      aux_sym_escape_token1,
    ACTIONS(88), 1,
      aux_sym_escape_token2,
    ACTIONS(92), 1,
      aux_sym__char_token1,
    ACTIONS(174), 1,
      sym__space,
    ACTIONS(176), 1,
      sym__eol,
    ACTIONS(178), 1,
      sym__eof,
    STATE(33), 1,
      aux_sym_file_repeat1,
    STATE(64), 1,
      sym_value,
    STATE(25), 5,
      sym_substitution,
      sym__linebreak,
      sym_escape,
      sym__char,
      aux_sym_value_repeat1,
  [386] = 11,
    ACTIONS(82), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(84), 1,
      anon_sym_BSLASH,
    ACTIONS(86), 1,
      aux_sym_escape_token1,
    ACTIONS(88), 1,
      aux_sym_escape_token2,
    ACTIONS(92), 1,
      aux_sym__char_token1,
    ACTIONS(111), 1,
      sym__eol,
    ACTIONS(113), 1,
      sym__eof,
    ACTIONS(180), 1,
      sym__space,
    STATE(16), 1,
      aux_sym_file_repeat1,
    STATE(60), 1,
      sym_value,
    STATE(25), 5,
      sym_substitution,
      sym__linebreak,
      sym_escape,
      sym__char,
      aux_sym_value_repeat1,
  [424] = 8,
    ACTIONS(60), 1,
      anon_sym_DOT,
    ACTIONS(62), 1,
      anon_sym_LBRACK,
    ACTIONS(64), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(70), 1,
      aux_sym_escape_token1,
    ACTIONS(72), 1,
      aux_sym_escape_token2,
    ACTIONS(74), 1,
      aux_sym__char_token1,
    STATE(5), 3,
      sym_key,
      sym_substitution,
      aux_sym_substitution_repeat1,
    STATE(19), 4,
      sym__index,
      sym_escape,
      sym__char,
      aux_sym_key_repeat1,
  [454] = 8,
    ACTIONS(62), 1,
      anon_sym_LBRACK,
    ACTIONS(70), 1,
      aux_sym_escape_token1,
    ACTIONS(72), 1,
      aux_sym_escape_token2,
    ACTIONS(127), 1,
      anon_sym_COLON,
    ACTIONS(182), 1,
      anon_sym_DOT,
    ACTIONS(184), 1,
      aux_sym__char_token1,
    ACTIONS(123), 3,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_COLON,
    STATE(20), 4,
      sym__index,
      sym_escape,
      sym__char,
      aux_sym_key_repeat1,
  [484] = 8,
    ACTIONS(139), 1,
      anon_sym_COLON,
    ACTIONS(186), 1,
      anon_sym_DOT,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(192), 1,
      aux_sym_escape_token1,
    ACTIONS(195), 1,
      aux_sym_escape_token2,
    ACTIONS(198), 1,
      aux_sym__char_token1,
    ACTIONS(131), 3,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_COLON,
    STATE(20), 4,
      sym__index,
      sym_escape,
      sym__char,
      aux_sym_key_repeat1,
  [514] = 8,
    ACTIONS(60), 1,
      anon_sym_DOT,
    ACTIONS(62), 1,
      anon_sym_LBRACK,
    ACTIONS(64), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(70), 1,
      aux_sym_escape_token1,
    ACTIONS(72), 1,
      aux_sym_escape_token2,
    ACTIONS(74), 1,
      aux_sym__char_token1,
    STATE(4), 3,
      sym_key,
      sym_substitution,
      aux_sym_substitution_repeat1,
    STATE(19), 4,
      sym__index,
      sym_escape,
      sym__char,
      aux_sym_key_repeat1,
  [544] = 8,
    ACTIONS(60), 1,
      anon_sym_DOT,
    ACTIONS(62), 1,
      anon_sym_LBRACK,
    ACTIONS(64), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(70), 1,
      aux_sym_escape_token1,
    ACTIONS(72), 1,
      aux_sym_escape_token2,
    ACTIONS(74), 1,
      aux_sym__char_token1,
    STATE(6), 3,
      sym_key,
      sym_substitution,
      aux_sym_substitution_repeat1,
    STATE(19), 4,
      sym__index,
      sym_escape,
      sym__char,
      aux_sym_key_repeat1,
  [574] = 2,
    ACTIONS(203), 4,
      anon_sym_BSLASH,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
    ACTIONS(201), 8,
      sym__eof,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_DOLLAR_LBRACE,
      aux_sym_escape_token2,
      sym__space,
  [591] = 2,
    ACTIONS(207), 4,
      anon_sym_BSLASH,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
    ACTIONS(205), 8,
      sym__eof,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_DOLLAR_LBRACE,
      aux_sym_escape_token2,
      sym__space,
  [608] = 8,
    ACTIONS(82), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(84), 1,
      anon_sym_BSLASH,
    ACTIONS(86), 1,
      aux_sym_escape_token1,
    ACTIONS(88), 1,
      aux_sym_escape_token2,
    ACTIONS(209), 1,
      aux_sym__char_token1,
    ACTIONS(211), 1,
      sym__eol,
    ACTIONS(213), 1,
      sym__eof,
    STATE(27), 5,
      sym_substitution,
      sym__linebreak,
      sym_escape,
      sym__char,
      aux_sym_value_repeat1,
  [637] = 2,
    ACTIONS(217), 4,
      anon_sym_BSLASH,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
    ACTIONS(215), 8,
      sym__eof,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_DOLLAR_LBRACE,
      aux_sym_escape_token2,
      sym__space,
  [654] = 8,
    ACTIONS(219), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(222), 1,
      anon_sym_BSLASH,
    ACTIONS(225), 1,
      aux_sym_escape_token1,
    ACTIONS(228), 1,
      aux_sym_escape_token2,
    ACTIONS(231), 1,
      aux_sym__char_token1,
    ACTIONS(234), 1,
      sym__eol,
    ACTIONS(236), 1,
      sym__eof,
    STATE(27), 5,
      sym_substitution,
      sym__linebreak,
      sym_escape,
      sym__char,
      aux_sym_value_repeat1,
  [683] = 4,
    ACTIONS(108), 1,
      sym__space,
    STATE(28), 1,
      aux_sym_file_repeat1,
    ACTIONS(238), 4,
      anon_sym_BSLASH,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
    ACTIONS(106), 5,
      sym__eof,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_DOLLAR_LBRACE,
      aux_sym_escape_token2,
  [703] = 2,
    ACTIONS(240), 3,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
    ACTIONS(29), 7,
      sym__eof,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      aux_sym_escape_token2,
      sym_comment,
      sym__space,
  [718] = 4,
    ACTIONS(242), 1,
      sym__space,
    STATE(30), 1,
      aux_sym_file_repeat1,
    ACTIONS(238), 3,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
    ACTIONS(106), 5,
      sym__eof,
      anon_sym_DOT,
      anon_sym_LBRACK,
      aux_sym_escape_token2,
      sym_comment,
  [737] = 2,
    ACTIONS(247), 3,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
    ACTIONS(245), 7,
      sym__eof,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LBRACK,
      aux_sym_escape_token2,
      sym_comment,
      sym__space,
  [752] = 7,
    ACTIONS(249), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(251), 1,
      anon_sym_RBRACE,
    ACTIONS(253), 1,
      aux_sym_escape_token1,
    ACTIONS(255), 1,
      aux_sym_escape_token2,
    ACTIONS(257), 1,
      aux_sym__char_token1,
    STATE(35), 1,
      aux_sym__content,
    STATE(49), 3,
      sym_substitution,
      sym_escape,
      sym__char,
  [776] = 4,
    ACTIONS(259), 1,
      sym__space,
    STATE(33), 1,
      aux_sym_file_repeat1,
    ACTIONS(106), 3,
      sym__eof,
      anon_sym_DOLLAR_LBRACE,
      aux_sym_escape_token2,
    ACTIONS(238), 4,
      anon_sym_BSLASH,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
  [794] = 7,
    ACTIONS(249), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(253), 1,
      aux_sym_escape_token1,
    ACTIONS(255), 1,
      aux_sym_escape_token2,
    ACTIONS(257), 1,
      aux_sym__char_token1,
    ACTIONS(262), 1,
      anon_sym_RBRACE,
    STATE(32), 1,
      aux_sym__content,
    STATE(49), 3,
      sym_substitution,
      sym_escape,
      sym__char,
  [818] = 7,
    ACTIONS(264), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(267), 1,
      anon_sym_RBRACE,
    ACTIONS(269), 1,
      aux_sym_escape_token1,
    ACTIONS(272), 1,
      aux_sym_escape_token2,
    ACTIONS(275), 1,
      aux_sym__char_token1,
    STATE(35), 1,
      aux_sym__content,
    STATE(49), 3,
      sym_substitution,
      sym_escape,
      sym__char,
  [842] = 7,
    ACTIONS(249), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(253), 1,
      aux_sym_escape_token1,
    ACTIONS(255), 1,
      aux_sym_escape_token2,
    ACTIONS(257), 1,
      aux_sym__char_token1,
    ACTIONS(278), 1,
      anon_sym_RBRACE,
    STATE(35), 1,
      aux_sym__content,
    STATE(49), 3,
      sym_substitution,
      sym_escape,
      sym__char,
  [866] = 2,
    ACTIONS(203), 3,
      anon_sym_COLON,
      aux_sym_escape_token1,
      aux_sym__char_token1,
    ACTIONS(201), 6,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_COLON,
      aux_sym_escape_token2,
  [880] = 2,
    ACTIONS(280), 3,
      anon_sym_COLON,
      aux_sym_escape_token1,
      aux_sym__char_token1,
    ACTIONS(282), 6,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_COLON,
      aux_sym_escape_token2,
  [894] = 2,
    ACTIONS(217), 3,
      anon_sym_COLON,
      aux_sym_escape_token1,
      aux_sym__char_token1,
    ACTIONS(215), 6,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_COLON,
      aux_sym_escape_token2,
  [908] = 2,
    ACTIONS(284), 3,
      anon_sym_COLON,
      aux_sym_escape_token1,
      aux_sym__char_token1,
    ACTIONS(286), 6,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_COLON,
      aux_sym_escape_token2,
  [922] = 2,
    ACTIONS(288), 3,
      anon_sym_COLON,
      aux_sym_escape_token1,
      aux_sym__char_token1,
    ACTIONS(290), 6,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_COLON,
      aux_sym_escape_token2,
  [936] = 2,
    ACTIONS(207), 3,
      anon_sym_COLON,
      aux_sym_escape_token1,
      aux_sym__char_token1,
    ACTIONS(205), 6,
      anon_sym_DOT,
      anon_sym_LBRACK,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_COLON,
      aux_sym_escape_token2,
  [950] = 6,
    ACTIONS(249), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(253), 1,
      aux_sym_escape_token1,
    ACTIONS(255), 1,
      aux_sym_escape_token2,
    ACTIONS(257), 1,
      aux_sym__char_token1,
    STATE(36), 1,
      aux_sym__content,
    STATE(49), 3,
      sym_substitution,
      sym_escape,
      sym__char,
  [971] = 2,
    ACTIONS(286), 3,
      sym__eof,
      anon_sym_DOLLAR_LBRACE,
      aux_sym_escape_token2,
    ACTIONS(284), 4,
      anon_sym_BSLASH,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
  [983] = 2,
    ACTIONS(290), 3,
      sym__eof,
      anon_sym_DOLLAR_LBRACE,
      aux_sym_escape_token2,
    ACTIONS(288), 4,
      anon_sym_BSLASH,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
  [995] = 2,
    ACTIONS(282), 3,
      sym__eof,
      anon_sym_DOLLAR_LBRACE,
      aux_sym_escape_token2,
    ACTIONS(280), 4,
      anon_sym_BSLASH,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
  [1007] = 2,
    ACTIONS(205), 3,
      sym__eof,
      anon_sym_DOLLAR_LBRACE,
      aux_sym_escape_token2,
    ACTIONS(207), 4,
      anon_sym_BSLASH,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
  [1019] = 2,
    ACTIONS(292), 3,
      sym__eof,
      anon_sym_DOLLAR_LBRACE,
      aux_sym_escape_token2,
    ACTIONS(294), 4,
      anon_sym_BSLASH,
      aux_sym_escape_token1,
      aux_sym__char_token1,
      sym__eol,
  [1031] = 2,
    ACTIONS(298), 2,
      aux_sym_escape_token1,
      aux_sym__char_token1,
    ACTIONS(296), 3,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      aux_sym_escape_token2,
  [1041] = 2,
    ACTIONS(284), 2,
      aux_sym_escape_token1,
      aux_sym__char_token1,
    ACTIONS(286), 3,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      aux_sym_escape_token2,
  [1051] = 2,
    ACTIONS(288), 2,
      aux_sym_escape_token1,
      aux_sym__char_token1,
    ACTIONS(290), 3,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      aux_sym_escape_token2,
  [1061] = 2,
    ACTIONS(280), 2,
      aux_sym_escape_token1,
      aux_sym__char_token1,
    ACTIONS(282), 3,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      aux_sym_escape_token2,
  [1071] = 2,
    ACTIONS(207), 2,
      aux_sym_escape_token1,
      aux_sym__char_token1,
    ACTIONS(205), 3,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE,
      aux_sym_escape_token2,
  [1081] = 4,
    ACTIONS(300), 1,
      anon_sym_RBRACK,
    ACTIONS(302), 1,
      aux_sym__char_token1,
    STATE(54), 1,
      aux_sym__index_repeat1,
    STATE(61), 1,
      sym__char,
  [1094] = 4,
    ACTIONS(305), 1,
      anon_sym_RBRACK,
    ACTIONS(307), 1,
      aux_sym__char_token1,
    STATE(54), 1,
      aux_sym__index_repeat1,
    STATE(61), 1,
      sym__char,
  [1107] = 4,
    ACTIONS(307), 1,
      aux_sym__char_token1,
    ACTIONS(309), 1,
      anon_sym_RBRACK,
    STATE(57), 1,
      aux_sym__index_repeat1,
    STATE(61), 1,
      sym__char,
  [1120] = 4,
    ACTIONS(307), 1,
      aux_sym__char_token1,
    ACTIONS(311), 1,
      anon_sym_RBRACK,
    STATE(54), 1,
      aux_sym__index_repeat1,
    STATE(61), 1,
      sym__char,
  [1133] = 4,
    ACTIONS(307), 1,
      aux_sym__char_token1,
    ACTIONS(313), 1,
      anon_sym_RBRACK,
    STATE(55), 1,
      aux_sym__index_repeat1,
    STATE(61), 1,
      sym__char,
  [1146] = 1,
    ACTIONS(96), 2,
      sym__eof,
      sym__eol,
  [1151] = 1,
    ACTIONS(178), 2,
      sym__eof,
      sym__eol,
  [1156] = 2,
    ACTIONS(315), 1,
      anon_sym_RBRACK,
    ACTIONS(317), 1,
      aux_sym__char_token1,
  [1163] = 1,
    ACTIONS(121), 2,
      sym__eof,
      sym__eol,
  [1168] = 1,
    ACTIONS(113), 2,
      sym__eof,
      sym__eol,
  [1173] = 1,
    ACTIONS(319), 2,
      sym__eof,
      sym__eol,
  [1178] = 1,
    ACTIONS(321), 2,
      sym__eof,
      sym__eol,
  [1183] = 1,
    ACTIONS(323), 1,
      anon_sym_RBRACE,
  [1187] = 1,
    ACTIONS(325), 1,
      anon_sym_RBRACE,
  [1191] = 1,
    ACTIONS(327), 1,
      sym__eol,
  [1195] = 1,
    ACTIONS(329), 1,
      anon_sym_RBRACE,
  [1199] = 1,
    ACTIONS(331), 1,
      anon_sym_RBRACE,
  [1203] = 1,
    ACTIONS(333), 1,
      anon_sym_RBRACE,
  [1207] = 1,
    ACTIONS(335), 1,
      anon_sym_RBRACE,
  [1211] = 1,
    ACTIONS(337), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(7)] = 0,
  [SMALL_STATE(8)] = 42,
  [SMALL_STATE(9)] = 84,
  [SMALL_STATE(10)] = 126,
  [SMALL_STATE(11)] = 169,
  [SMALL_STATE(12)] = 202,
  [SMALL_STATE(13)] = 235,
  [SMALL_STATE(14)] = 272,
  [SMALL_STATE(15)] = 310,
  [SMALL_STATE(16)] = 348,
  [SMALL_STATE(17)] = 386,
  [SMALL_STATE(18)] = 424,
  [SMALL_STATE(19)] = 454,
  [SMALL_STATE(20)] = 484,
  [SMALL_STATE(21)] = 514,
  [SMALL_STATE(22)] = 544,
  [SMALL_STATE(23)] = 574,
  [SMALL_STATE(24)] = 591,
  [SMALL_STATE(25)] = 608,
  [SMALL_STATE(26)] = 637,
  [SMALL_STATE(27)] = 654,
  [SMALL_STATE(28)] = 683,
  [SMALL_STATE(29)] = 703,
  [SMALL_STATE(30)] = 718,
  [SMALL_STATE(31)] = 737,
  [SMALL_STATE(32)] = 752,
  [SMALL_STATE(33)] = 776,
  [SMALL_STATE(34)] = 794,
  [SMALL_STATE(35)] = 818,
  [SMALL_STATE(36)] = 842,
  [SMALL_STATE(37)] = 866,
  [SMALL_STATE(38)] = 880,
  [SMALL_STATE(39)] = 894,
  [SMALL_STATE(40)] = 908,
  [SMALL_STATE(41)] = 922,
  [SMALL_STATE(42)] = 936,
  [SMALL_STATE(43)] = 950,
  [SMALL_STATE(44)] = 971,
  [SMALL_STATE(45)] = 983,
  [SMALL_STATE(46)] = 995,
  [SMALL_STATE(47)] = 1007,
  [SMALL_STATE(48)] = 1019,
  [SMALL_STATE(49)] = 1031,
  [SMALL_STATE(50)] = 1041,
  [SMALL_STATE(51)] = 1051,
  [SMALL_STATE(52)] = 1061,
  [SMALL_STATE(53)] = 1071,
  [SMALL_STATE(54)] = 1081,
  [SMALL_STATE(55)] = 1094,
  [SMALL_STATE(56)] = 1107,
  [SMALL_STATE(57)] = 1120,
  [SMALL_STATE(58)] = 1133,
  [SMALL_STATE(59)] = 1146,
  [SMALL_STATE(60)] = 1151,
  [SMALL_STATE(61)] = 1156,
  [SMALL_STATE(62)] = 1163,
  [SMALL_STATE(63)] = 1168,
  [SMALL_STATE(64)] = 1173,
  [SMALL_STATE(65)] = 1178,
  [SMALL_STATE(66)] = 1183,
  [SMALL_STATE(67)] = 1187,
  [SMALL_STATE(68)] = 1191,
  [SMALL_STATE(69)] = 1195,
  [SMALL_STATE(70)] = 1199,
  [SMALL_STATE(71)] = 1203,
  [SMALL_STATE(72)] = 1207,
  [SMALL_STATE(73)] = 1211,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 0, 0, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(2),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [23] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 1, 0, 0),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [29] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_file_repeat2, 2, 0, 0),
  [31] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat2, 2, 0, 0), SHIFT_REPEAT(11),
  [34] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat2, 2, 0, 0), SHIFT_REPEAT(58),
  [37] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat2, 2, 0, 0), SHIFT_REPEAT(24),
  [40] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat2, 2, 0, 0), SHIFT_REPEAT(24),
  [43] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat2, 2, 0, 0), SHIFT_REPEAT(62),
  [46] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat2, 2, 0, 0), SHIFT_REPEAT(10),
  [49] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat2, 2, 0, 0), SHIFT_REPEAT(11),
  [52] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat2, 2, 0, 0), SHIFT_REPEAT(3),
  [55] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat2, 2, 0, 0), SHIFT_REPEAT(3),
  [58] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [60] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [62] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [64] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [66] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [68] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [70] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [72] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [74] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [76] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [78] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [80] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [82] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [84] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [86] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [88] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [90] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [92] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [94] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 2, 0, 0),
  [96] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 2, 0, 0),
  [98] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [102] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 1, 0, 0),
  [104] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 1, 0, 0),
  [106] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0),
  [108] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(28),
  [111] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 3, 0, 0),
  [113] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 3, 0, 0),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key, 1, 0, 0),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [127] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key, 1, 0, 0),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0),
  [133] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0), SHIFT_REPEAT(12),
  [136] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0), SHIFT_REPEAT(58),
  [139] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0),
  [141] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0), SHIFT_REPEAT(24),
  [144] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0), SHIFT_REPEAT(24),
  [147] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0), SHIFT_REPEAT(12),
  [150] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_substitution_repeat1, 2, 0, 0),
  [152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_substitution_repeat1, 2, 0, 0), SHIFT_REPEAT(19),
  [155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_substitution_repeat1, 2, 0, 0), SHIFT_REPEAT(56),
  [158] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_substitution_repeat1, 2, 0, 0), SHIFT_REPEAT(21),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_substitution_repeat1, 2, 0, 0),
  [163] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_substitution_repeat1, 2, 0, 0), SHIFT_REPEAT(42),
  [166] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_substitution_repeat1, 2, 0, 0), SHIFT_REPEAT(42),
  [169] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_substitution_repeat1, 2, 0, 0), SHIFT_REPEAT(19),
  [172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [176] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 4, 0, 0),
  [178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 4, 0, 0),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [184] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [186] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0), SHIFT_REPEAT(20),
  [189] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0), SHIFT_REPEAT(56),
  [192] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0), SHIFT_REPEAT(42),
  [195] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0), SHIFT_REPEAT(42),
  [198] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_key_repeat1, 2, 0, 0), SHIFT_REPEAT(20),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__index, 2, 0, 0),
  [203] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__index, 2, 0, 0),
  [205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_escape, 1, 0, 0),
  [207] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_escape, 1, 0, 0),
  [209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [211] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1, 0, 0),
  [213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1, 0, 0),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__index, 3, 0, 1),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__index, 3, 0, 1),
  [219] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(18),
  [222] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(68),
  [225] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(47),
  [228] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(47),
  [231] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(27),
  [234] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0),
  [236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0),
  [238] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0),
  [240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_file_repeat2, 2, 0, 0),
  [242] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(30),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_file_repeat2, 3, 0, 0),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_file_repeat2, 3, 0, 0),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__default, 2, 0, 2),
  [253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [259] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(33),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__default, 1, 0, 0),
  [264] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__content, 2, 0, 0), SHIFT_REPEAT(22),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__content, 2, 0, 0),
  [269] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__content, 2, 0, 0), SHIFT_REPEAT(53),
  [272] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__content, 2, 0, 0), SHIFT_REPEAT(53),
  [275] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__content, 2, 0, 0), SHIFT_REPEAT(49),
  [278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__secret, 2, 0, 3),
  [280] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_substitution, 4, 0, 0),
  [282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_substitution, 4, 0, 0),
  [284] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_substitution, 3, 0, 0),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_substitution, 3, 0, 0),
  [288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_substitution, 4, 0, 4),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_substitution, 4, 0, 4),
  [292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__linebreak, 2, 0, 0),
  [294] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__linebreak, 2, 0, 0),
  [296] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__content, 1, 0, 0),
  [298] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__content, 1, 0, 0),
  [300] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__index_repeat1, 2, 0, 0),
  [302] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__index_repeat1, 2, 0, 0), SHIFT_REPEAT(61),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [307] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__index_repeat1, 1, 0, 0),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__index_repeat1, 1, 0, 0),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 5, 0, 0),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [337] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token__eof = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__eof] = sym__eof,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__eof] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_properties_external_scanner_create(void);
void tree_sitter_properties_external_scanner_destroy(void *);
bool tree_sitter_properties_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_properties_external_scanner_serialize(void *, char *);
void tree_sitter_properties_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_properties(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_properties_external_scanner_create,
      tree_sitter_properties_external_scanner_destroy,
      tree_sitter_properties_external_scanner_scan,
      tree_sitter_properties_external_scanner_serialize,
      tree_sitter_properties_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
