#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 360
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 165
#define ALIAS_COUNT 5
#define TOKEN_COUNT 85
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 25
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 56

enum {
  sym_identifier = 1,
  anon_sym_primitive = 2,
  anon_sym_SEMI = 3,
  anon_sym_import = 4,
  anon_sym_const = 5,
  anon_sym_COLON = 6,
  anon_sym_EQ = 7,
  anon_sym_virtual = 8,
  anon_sym_override = 9,
  anon_sym_abstract = 10,
  anon_sym_ATname = 11,
  anon_sym_LPAREN = 12,
  anon_sym_RPAREN = 13,
  anon_sym_native = 14,
  anon_sym_fun = 15,
  anon_sym_get = 16,
  anon_sym_mutates = 17,
  anon_sym_extends = 18,
  anon_sym_inline = 19,
  anon_sym_COMMA = 20,
  anon_sym_struct = 21,
  anon_sym_message = 22,
  anon_sym_LBRACE = 23,
  anon_sym_RBRACE = 24,
  anon_sym_contract = 25,
  anon_sym_trait = 26,
  anon_sym_ATinterface = 27,
  anon_sym_with = 28,
  anon_sym_init = 29,
  anon_sym_receive = 30,
  anon_sym_bounced = 31,
  anon_sym_external = 32,
  anon_sym_let = 33,
  anon_sym_return = 34,
  anon_sym_PLUS_EQ = 35,
  anon_sym_DASH_EQ = 36,
  anon_sym_STAR_EQ = 37,
  anon_sym_SLASH_EQ = 38,
  anon_sym_PERCENT_EQ = 39,
  anon_sym_if = 40,
  anon_sym_else = 41,
  anon_sym_while = 42,
  anon_sym_repeat = 43,
  anon_sym_do = 44,
  anon_sym_until = 45,
  anon_sym_DOT = 46,
  anon_sym_PIPE_PIPE = 47,
  anon_sym_AMP_AMP = 48,
  anon_sym_BANG_EQ = 49,
  anon_sym_EQ_EQ = 50,
  anon_sym_GT = 51,
  anon_sym_GT_EQ = 52,
  anon_sym_LT = 53,
  anon_sym_LT_EQ = 54,
  anon_sym_GT_GT = 55,
  anon_sym_LT_LT = 56,
  anon_sym_AMP = 57,
  anon_sym_PIPE = 58,
  anon_sym_PLUS = 59,
  anon_sym_DASH = 60,
  anon_sym_STAR = 61,
  anon_sym_SLASH = 62,
  anon_sym_PERCENT = 63,
  anon_sym_BANG = 64,
  anon_sym_BANG_BANG = 65,
  anon_sym_initOf = 66,
  anon_sym_map = 67,
  anon_sym_QMARK = 68,
  sym__type_identifier = 69,
  anon_sym_as = 70,
  aux_sym__func_identifier_part_token1 = 71,
  aux_sym__func_identifier_letter_token1 = 72,
  aux_sym__func_identifier_letter_token2 = 73,
  sym_self = 74,
  anon_sym_DQUOTE = 75,
  aux_sym_string_token1 = 76,
  anon_sym_true = 77,
  anon_sym_false = 78,
  sym_null = 79,
  aux_sym_integer_token1 = 80,
  aux_sym_integer_token2 = 81,
  aux_sym_integer_token3 = 82,
  aux_sym_integer_token4 = 83,
  sym_comment = 84,
  sym_source_file = 85,
  sym__program_item = 86,
  sym_primitive_statement = 87,
  sym_import_statement = 88,
  sym_constant = 89,
  sym_constant_attributes = 90,
  sym_native_function = 91,
  sym__static_function = 92,
  sym_function = 93,
  sym_function_attributes = 94,
  sym_parameter_list = 95,
  sym_parameter = 96,
  sym_struct = 97,
  sym_message = 98,
  sym_message_value = 99,
  sym_struct_body = 100,
  sym_field = 101,
  sym_contract = 102,
  sym_trait = 103,
  sym_contract_attributes = 104,
  sym_trait_list = 105,
  sym_contract_body = 106,
  sym_trait_body = 107,
  sym_init_function = 108,
  sym__receiver_function = 109,
  sym_receive_function = 110,
  sym_bounced_function = 111,
  sym_external_function = 112,
  sym__statement = 113,
  sym_let_statement = 114,
  sym_block_statement = 115,
  sym_return_statement = 116,
  sym_expression_statement = 117,
  sym_assignment_statement = 118,
  sym_augmented_assignment_statement = 119,
  sym_if_statement = 120,
  sym_else_clause = 121,
  sym_while_statement = 122,
  sym_repeat_statement = 123,
  sym_do_until_statement = 124,
  sym__lvalue = 125,
  sym__expression = 126,
  sym_binary_expression = 127,
  sym_unary_expression = 128,
  sym_unary_suffix_expression = 129,
  sym_value_expression = 130,
  sym_method_call_expression = 131,
  sym_field_access_expression = 132,
  sym_static_call_expression = 133,
  sym_argument_list = 134,
  sym_argument = 135,
  sym_parenthesized_expression = 136,
  sym_instance_expression = 137,
  sym_instance_argument_list = 138,
  sym_instance_argument = 139,
  sym_initOf = 140,
  sym__type = 141,
  sym_map_type = 142,
  sym_bounced_type = 143,
  sym__simple_type = 144,
  sym_tlb_serialization = 145,
  sym_func_identifier = 146,
  sym__func_identifier_part = 147,
  sym__func_identifier_letter = 148,
  sym_string = 149,
  sym_boolean = 150,
  sym_integer = 151,
  aux_sym_source_file_repeat1 = 152,
  aux_sym_constant_attributes_repeat1 = 153,
  aux_sym_function_attributes_repeat1 = 154,
  aux_sym_parameter_list_repeat1 = 155,
  aux_sym_struct_body_repeat1 = 156,
  aux_sym_contract_attributes_repeat1 = 157,
  aux_sym_trait_list_repeat1 = 158,
  aux_sym_contract_body_repeat1 = 159,
  aux_sym_trait_body_repeat1 = 160,
  aux_sym_block_statement_repeat1 = 161,
  aux_sym_argument_list_repeat1 = 162,
  aux_sym_instance_argument_list_repeat1 = 163,
  aux_sym_func_identifier_repeat1 = 164,
  alias_sym_function_body = 165,
  alias_sym_lvalue = 166,
  alias_sym_message_body = 167,
  alias_sym_static_function = 168,
  alias_sym_trait_attributes = 169,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_primitive] = "primitive",
  [anon_sym_SEMI] = ";",
  [anon_sym_import] = "import",
  [anon_sym_const] = "const",
  [anon_sym_COLON] = ":",
  [anon_sym_EQ] = "=",
  [anon_sym_virtual] = "virtual",
  [anon_sym_override] = "override",
  [anon_sym_abstract] = "abstract",
  [anon_sym_ATname] = "@name",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_native] = "native",
  [anon_sym_fun] = "fun",
  [anon_sym_get] = "get",
  [anon_sym_mutates] = "mutates",
  [anon_sym_extends] = "extends",
  [anon_sym_inline] = "inline",
  [anon_sym_COMMA] = ",",
  [anon_sym_struct] = "struct",
  [anon_sym_message] = "message",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_contract] = "contract",
  [anon_sym_trait] = "trait",
  [anon_sym_ATinterface] = "@interface",
  [anon_sym_with] = "with",
  [anon_sym_init] = "init",
  [anon_sym_receive] = "receive",
  [anon_sym_bounced] = "bounced",
  [anon_sym_external] = "external",
  [anon_sym_let] = "let",
  [anon_sym_return] = "return",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_do] = "do",
  [anon_sym_until] = "until",
  [anon_sym_DOT] = ".",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_BANG] = "!",
  [anon_sym_BANG_BANG] = "!!",
  [anon_sym_initOf] = "initOf",
  [anon_sym_map] = "map",
  [anon_sym_QMARK] = "\?",
  [sym__type_identifier] = "type_identifier",
  [anon_sym_as] = "as",
  [aux_sym__func_identifier_part_token1] = "_func_identifier_part_token1",
  [aux_sym__func_identifier_letter_token1] = "_func_identifier_letter_token1",
  [aux_sym__func_identifier_letter_token2] = "_func_identifier_letter_token2",
  [sym_self] = "self",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_null] = "null",
  [aux_sym_integer_token1] = "integer_token1",
  [aux_sym_integer_token2] = "integer_token2",
  [aux_sym_integer_token3] = "integer_token3",
  [aux_sym_integer_token4] = "integer_token4",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym__program_item] = "_program_item",
  [sym_primitive_statement] = "primitive_statement",
  [sym_import_statement] = "import_statement",
  [sym_constant] = "constant",
  [sym_constant_attributes] = "constant_attributes",
  [sym_native_function] = "native_function",
  [sym__static_function] = "_static_function",
  [sym_function] = "function",
  [sym_function_attributes] = "function_attributes",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter] = "parameter",
  [sym_struct] = "struct",
  [sym_message] = "message",
  [sym_message_value] = "message_value",
  [sym_struct_body] = "struct_body",
  [sym_field] = "field",
  [sym_contract] = "contract",
  [sym_trait] = "trait",
  [sym_contract_attributes] = "contract_attributes",
  [sym_trait_list] = "trait_list",
  [sym_contract_body] = "contract_body",
  [sym_trait_body] = "trait_body",
  [sym_init_function] = "init_function",
  [sym__receiver_function] = "_receiver_function",
  [sym_receive_function] = "receive_function",
  [sym_bounced_function] = "bounced_function",
  [sym_external_function] = "external_function",
  [sym__statement] = "_statement",
  [sym_let_statement] = "let_statement",
  [sym_block_statement] = "block_statement",
  [sym_return_statement] = "return_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_augmented_assignment_statement] = "augmented_assignment_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_clause] = "else_clause",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_do_until_statement] = "do_until_statement",
  [sym__lvalue] = "_lvalue",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_unary_suffix_expression] = "unary_suffix_expression",
  [sym_value_expression] = "value_expression",
  [sym_method_call_expression] = "method_call_expression",
  [sym_field_access_expression] = "field_access_expression",
  [sym_static_call_expression] = "static_call_expression",
  [sym_argument_list] = "argument_list",
  [sym_argument] = "argument",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_instance_expression] = "instance_expression",
  [sym_instance_argument_list] = "instance_argument_list",
  [sym_instance_argument] = "instance_argument",
  [sym_initOf] = "initOf",
  [sym__type] = "_type",
  [sym_map_type] = "map_type",
  [sym_bounced_type] = "bounced_type",
  [sym__simple_type] = "_simple_type",
  [sym_tlb_serialization] = "tlb_serialization",
  [sym_func_identifier] = "func_identifier",
  [sym__func_identifier_part] = "_func_identifier_part",
  [sym__func_identifier_letter] = "_func_identifier_letter",
  [sym_string] = "string",
  [sym_boolean] = "boolean",
  [sym_integer] = "integer",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_constant_attributes_repeat1] = "constant_attributes_repeat1",
  [aux_sym_function_attributes_repeat1] = "function_attributes_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_struct_body_repeat1] = "struct_body_repeat1",
  [aux_sym_contract_attributes_repeat1] = "contract_attributes_repeat1",
  [aux_sym_trait_list_repeat1] = "trait_list_repeat1",
  [aux_sym_contract_body_repeat1] = "contract_body_repeat1",
  [aux_sym_trait_body_repeat1] = "trait_body_repeat1",
  [aux_sym_block_statement_repeat1] = "block_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_instance_argument_list_repeat1] = "instance_argument_list_repeat1",
  [aux_sym_func_identifier_repeat1] = "func_identifier_repeat1",
  [alias_sym_function_body] = "function_body",
  [alias_sym_lvalue] = "lvalue",
  [alias_sym_message_body] = "message_body",
  [alias_sym_static_function] = "static_function",
  [alias_sym_trait_attributes] = "trait_attributes",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_primitive] = anon_sym_primitive,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_virtual] = anon_sym_virtual,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_ATname] = anon_sym_ATname,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_fun] = anon_sym_fun,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_mutates] = anon_sym_mutates,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_message] = anon_sym_message,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_contract] = anon_sym_contract,
  [anon_sym_trait] = anon_sym_trait,
  [anon_sym_ATinterface] = anon_sym_ATinterface,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_init] = anon_sym_init,
  [anon_sym_receive] = anon_sym_receive,
  [anon_sym_bounced] = anon_sym_bounced,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_BANG_BANG] = anon_sym_BANG_BANG,
  [anon_sym_initOf] = anon_sym_initOf,
  [anon_sym_map] = anon_sym_map,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym__type_identifier] = sym__type_identifier,
  [anon_sym_as] = anon_sym_as,
  [aux_sym__func_identifier_part_token1] = aux_sym__func_identifier_part_token1,
  [aux_sym__func_identifier_letter_token1] = aux_sym__func_identifier_letter_token1,
  [aux_sym__func_identifier_letter_token2] = aux_sym__func_identifier_letter_token2,
  [sym_self] = sym_self,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_null] = sym_null,
  [aux_sym_integer_token1] = aux_sym_integer_token1,
  [aux_sym_integer_token2] = aux_sym_integer_token2,
  [aux_sym_integer_token3] = aux_sym_integer_token3,
  [aux_sym_integer_token4] = aux_sym_integer_token4,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym__program_item] = sym__program_item,
  [sym_primitive_statement] = sym_primitive_statement,
  [sym_import_statement] = sym_import_statement,
  [sym_constant] = sym_constant,
  [sym_constant_attributes] = sym_constant_attributes,
  [sym_native_function] = sym_native_function,
  [sym__static_function] = sym__static_function,
  [sym_function] = sym_function,
  [sym_function_attributes] = sym_function_attributes,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter] = sym_parameter,
  [sym_struct] = sym_struct,
  [sym_message] = sym_message,
  [sym_message_value] = sym_message_value,
  [sym_struct_body] = sym_struct_body,
  [sym_field] = sym_field,
  [sym_contract] = sym_contract,
  [sym_trait] = sym_trait,
  [sym_contract_attributes] = sym_contract_attributes,
  [sym_trait_list] = sym_trait_list,
  [sym_contract_body] = sym_contract_body,
  [sym_trait_body] = sym_trait_body,
  [sym_init_function] = sym_init_function,
  [sym__receiver_function] = sym__receiver_function,
  [sym_receive_function] = sym_receive_function,
  [sym_bounced_function] = sym_bounced_function,
  [sym_external_function] = sym_external_function,
  [sym__statement] = sym__statement,
  [sym_let_statement] = sym_let_statement,
  [sym_block_statement] = sym_block_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_augmented_assignment_statement] = sym_augmented_assignment_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_clause] = sym_else_clause,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_do_until_statement] = sym_do_until_statement,
  [sym__lvalue] = sym__lvalue,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_unary_suffix_expression] = sym_unary_suffix_expression,
  [sym_value_expression] = sym_value_expression,
  [sym_method_call_expression] = sym_method_call_expression,
  [sym_field_access_expression] = sym_field_access_expression,
  [sym_static_call_expression] = sym_static_call_expression,
  [sym_argument_list] = sym_argument_list,
  [sym_argument] = sym_argument,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_instance_expression] = sym_instance_expression,
  [sym_instance_argument_list] = sym_instance_argument_list,
  [sym_instance_argument] = sym_instance_argument,
  [sym_initOf] = sym_initOf,
  [sym__type] = sym__type,
  [sym_map_type] = sym_map_type,
  [sym_bounced_type] = sym_bounced_type,
  [sym__simple_type] = sym__simple_type,
  [sym_tlb_serialization] = sym_tlb_serialization,
  [sym_func_identifier] = sym_func_identifier,
  [sym__func_identifier_part] = sym__func_identifier_part,
  [sym__func_identifier_letter] = sym__func_identifier_letter,
  [sym_string] = sym_string,
  [sym_boolean] = sym_boolean,
  [sym_integer] = sym_integer,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_constant_attributes_repeat1] = aux_sym_constant_attributes_repeat1,
  [aux_sym_function_attributes_repeat1] = aux_sym_function_attributes_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_struct_body_repeat1] = aux_sym_struct_body_repeat1,
  [aux_sym_contract_attributes_repeat1] = aux_sym_contract_attributes_repeat1,
  [aux_sym_trait_list_repeat1] = aux_sym_trait_list_repeat1,
  [aux_sym_contract_body_repeat1] = aux_sym_contract_body_repeat1,
  [aux_sym_trait_body_repeat1] = aux_sym_trait_body_repeat1,
  [aux_sym_block_statement_repeat1] = aux_sym_block_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_instance_argument_list_repeat1] = aux_sym_instance_argument_list_repeat1,
  [aux_sym_func_identifier_repeat1] = aux_sym_func_identifier_repeat1,
  [alias_sym_function_body] = alias_sym_function_body,
  [alias_sym_lvalue] = alias_sym_lvalue,
  [alias_sym_message_body] = alias_sym_message_body,
  [alias_sym_static_function] = alias_sym_static_function,
  [alias_sym_trait_attributes] = alias_sym_trait_attributes,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_primitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_virtual] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mutates] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_message] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_contract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trait] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinterface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_init] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_receive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bounced] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_initOf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_map] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym__type_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__func_identifier_part_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__func_identifier_letter_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__func_identifier_letter_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_self] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_integer_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_token4] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__program_item] = {
    .visible = false,
    .named = true,
  },
  [sym_primitive_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_native_function] = {
    .visible = true,
    .named = true,
  },
  [sym__static_function] = {
    .visible = false,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_struct] = {
    .visible = true,
    .named = true,
  },
  [sym_message] = {
    .visible = true,
    .named = true,
  },
  [sym_message_value] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_body] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_contract] = {
    .visible = true,
    .named = true,
  },
  [sym_trait] = {
    .visible = true,
    .named = true,
  },
  [sym_contract_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_list] = {
    .visible = true,
    .named = true,
  },
  [sym_contract_body] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_body] = {
    .visible = true,
    .named = true,
  },
  [sym_init_function] = {
    .visible = true,
    .named = true,
  },
  [sym__receiver_function] = {
    .visible = false,
    .named = true,
  },
  [sym_receive_function] = {
    .visible = true,
    .named = true,
  },
  [sym_bounced_function] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_let_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_block_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_until_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__lvalue] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_suffix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_value_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_method_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_field_access_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_static_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instance_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instance_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_instance_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_initOf] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_map_type] = {
    .visible = true,
    .named = true,
  },
  [sym_bounced_type] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_type] = {
    .visible = false,
    .named = true,
  },
  [sym_tlb_serialization] = {
    .visible = true,
    .named = true,
  },
  [sym_func_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__func_identifier_part] = {
    .visible = false,
    .named = true,
  },
  [sym__func_identifier_letter] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_contract_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trait_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_contract_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trait_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instance_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_func_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_lvalue] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_message_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_static_function] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_trait_attributes] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_attributes = 4,
  field_body = 5,
  field_condition = 6,
  field_consequence = 7,
  field_func_name = 8,
  field_key = 9,
  field_left = 10,
  field_library = 11,
  field_message = 12,
  field_name = 13,
  field_object = 14,
  field_operator = 15,
  field_parameter = 16,
  field_parameters = 17,
  field_result = 18,
  field_right = 19,
  field_tlb = 20,
  field_tlb_key = 21,
  field_tlb_value = 22,
  field_traits = 23,
  field_type = 24,
  field_value = 25,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attributes] = "attributes",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_func_name] = "func_name",
  [field_key] = "key",
  [field_left] = "left",
  [field_library] = "library",
  [field_message] = "message",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_result] = "result",
  [field_right] = "right",
  [field_tlb] = "tlb",
  [field_tlb_key] = "tlb_key",
  [field_tlb_value] = "tlb_value",
  [field_traits] = "traits",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 2},
  [5] = {.index = 2, .length = 2},
  [6] = {.index = 4, .length = 2},
  [7] = {.index = 6, .length = 3},
  [8] = {.index = 9, .length = 3},
  [9] = {.index = 12, .length = 3},
  [10] = {.index = 15, .length = 3},
  [11] = {.index = 15, .length = 3},
  [12] = {.index = 18, .length = 1},
  [13] = {.index = 19, .length = 2},
  [14] = {.index = 21, .length = 3},
  [15] = {.index = 24, .length = 4},
  [16] = {.index = 28, .length = 4},
  [17] = {.index = 28, .length = 4},
  [18] = {.index = 32, .length = 2},
  [19] = {.index = 34, .length = 3},
  [20] = {.index = 37, .length = 4},
  [21] = {.index = 41, .length = 2},
  [22] = {.index = 43, .length = 2},
  [23] = {.index = 45, .length = 2},
  [24] = {.index = 47, .length = 2},
  [25] = {.index = 49, .length = 3},
  [26] = {.index = 52, .length = 2},
  [27] = {.index = 54, .length = 3},
  [28] = {.index = 57, .length = 2},
  [29] = {.index = 59, .length = 1},
  [30] = {.index = 60, .length = 3},
  [31] = {.index = 63, .length = 2},
  [32] = {.index = 65, .length = 1},
  [33] = {.index = 66, .length = 4},
  [34] = {.index = 70, .length = 5},
  [35] = {.index = 75, .length = 3},
  [36] = {.index = 78, .length = 3},
  [37] = {.index = 81, .length = 3},
  [38] = {.index = 84, .length = 2},
  [39] = {.index = 60, .length = 3},
  [40] = {.index = 86, .length = 3},
  [41] = {.index = 89, .length = 3},
  [42] = {.index = 92, .length = 2},
  [43] = {.index = 94, .length = 4},
  [44] = {.index = 98, .length = 4},
  [45] = {.index = 102, .length = 4},
  [46] = {.index = 106, .length = 2},
  [47] = {.index = 108, .length = 2},
  [48] = {.index = 110, .length = 2},
  [49] = {.index = 112, .length = 3},
  [50] = {.index = 115, .length = 4},
  [51] = {.index = 119, .length = 3},
  [52] = {.index = 122, .length = 4},
  [53] = {.index = 126, .length = 5},
  [54] = {.index = 131, .length = 2},
  [55] = {.index = 133, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_type, 1},
  [1] =
    {field_library, 1},
  [2] =
    {field_body, 2},
    {field_name, 1},
  [4] =
    {field_name, 1},
    {field_parameters, 2},
  [6] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [9] =
    {field_body, 3},
    {field_name, 2},
    {field_value, 1},
  [12] =
    {field_body, 3},
    {field_name, 1},
    {field_traits, 2},
  [15] =
    {field_attributes, 0},
    {field_body, 3},
    {field_name, 2},
  [18] =
    {field_message, 2},
  [19] =
    {field_name, 1},
    {field_type, 3},
  [21] =
    {field_attributes, 0},
    {field_name, 2},
    {field_parameters, 3},
  [24] =
    {field_attributes, 0},
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [28] =
    {field_attributes, 0},
    {field_body, 4},
    {field_name, 2},
    {field_traits, 3},
  [32] =
    {field_name, 0},
    {field_type, 2},
  [34] =
    {field_name, 1},
    {field_parameters, 2},
    {field_result, 4},
  [37] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
    {field_result, 4},
  [41] =
    {field_argument, 1},
    {field_operator, 0},
  [43] =
    {field_arguments, 1},
    {field_name, 0},
  [45] =
    {field_argument, 0},
    {field_operator, 1},
  [47] =
    {field_body, 2},
    {field_parameters, 1},
  [49] =
    {field_attributes, 0},
    {field_name, 2},
    {field_type, 4},
  [52] =
    {field_key, 2},
    {field_value, 4},
  [54] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 5},
  [57] =
    {field_arguments, 2},
    {field_name, 1},
  [59] =
    {field_value, 0},
  [60] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [63] =
    {field_name, 2},
    {field_object, 0},
  [65] =
    {field_body, 3},
  [66] =
    {field_attributes, 0},
    {field_name, 2},
    {field_parameters, 3},
    {field_result, 5},
  [70] =
    {field_attributes, 0},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
    {field_result, 5},
  [75] =
    {field_key, 2},
    {field_tlb_value, 5},
    {field_value, 4},
  [78] =
    {field_key, 2},
    {field_tlb_key, 3},
    {field_value, 5},
  [81] =
    {field_func_name, 2},
    {field_name, 5},
    {field_parameters, 6},
  [84] =
    {field_left, 0},
    {field_right, 2},
  [86] =
    {field_arguments, 3},
    {field_name, 2},
    {field_object, 0},
  [89] =
    {field_name, 0},
    {field_tlb, 3},
    {field_type, 2},
  [92] =
    {field_body, 4},
    {field_parameter, 2},
  [94] =
    {field_attributes, 0},
    {field_name, 2},
    {field_type, 4},
    {field_value, 6},
  [98] =
    {field_key, 2},
    {field_tlb_key, 3},
    {field_tlb_value, 6},
    {field_value, 5},
  [102] =
    {field_attributes, 4},
    {field_func_name, 2},
    {field_name, 6},
    {field_parameters, 7},
  [106] =
    {field_condition, 2},
    {field_consequence, 4},
  [108] =
    {field_body, 4},
    {field_condition, 2},
  [110] =
    {field_name, 0},
    {field_value, 2},
  [112] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [115] =
    {field_func_name, 2},
    {field_name, 5},
    {field_parameters, 6},
    {field_result, 8},
  [119] =
    {field_alternative, 5},
    {field_condition, 2},
    {field_consequence, 4},
  [122] =
    {field_name, 0},
    {field_tlb, 3},
    {field_type, 2},
    {field_value, 5},
  [126] =
    {field_attributes, 4},
    {field_func_name, 2},
    {field_name, 6},
    {field_parameters, 7},
    {field_result, 9},
  [131] =
    {field_body, 1},
    {field_condition, 4},
  [133] =
    {field_name, 1},
    {field_tlb, 4},
    {field_type, 3},
    {field_value, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_static_function,
  },
  [5] = {
    [2] = alias_sym_message_body,
  },
  [7] = {
    [3] = alias_sym_function_body,
  },
  [8] = {
    [3] = alias_sym_message_body,
  },
  [11] = {
    [0] = alias_sym_trait_attributes,
  },
  [15] = {
    [4] = alias_sym_function_body,
  },
  [17] = {
    [0] = alias_sym_trait_attributes,
  },
  [20] = {
    [5] = alias_sym_function_body,
  },
  [24] = {
    [2] = alias_sym_function_body,
  },
  [32] = {
    [3] = alias_sym_function_body,
  },
  [34] = {
    [6] = alias_sym_function_body,
  },
  [38] = {
    [0] = alias_sym_lvalue,
  },
  [39] = {
    [0] = alias_sym_lvalue,
  },
  [42] = {
    [4] = alias_sym_function_body,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_function, 2,
    sym_function,
    alias_sym_static_function,
  sym_struct_body, 2,
    sym_struct_body,
    alias_sym_message_body,
  sym_contract_attributes, 2,
    sym_contract_attributes,
    alias_sym_trait_attributes,
  sym_block_statement, 2,
    sym_block_statement,
    alias_sym_function_body,
  sym__lvalue, 2,
    sym__lvalue,
    alias_sym_lvalue,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 2,
  [6] = 3,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 18,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 17,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 93,
  [98] = 98,
  [99] = 98,
  [100] = 8,
  [101] = 101,
  [102] = 102,
  [103] = 7,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 139,
  [144] = 144,
  [145] = 145,
  [146] = 125,
  [147] = 126,
  [148] = 123,
  [149] = 108,
  [150] = 150,
  [151] = 151,
  [152] = 131,
  [153] = 122,
  [154] = 121,
  [155] = 111,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 115,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 129,
  [164] = 130,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 170,
  [174] = 169,
  [175] = 175,
  [176] = 176,
  [177] = 171,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 178,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 207,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 203,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 222,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 242,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 248,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 262,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 250,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 270,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 304,
  [353] = 302,
  [354] = 299,
  [355] = 345,
  [356] = 336,
  [357] = 343,
  [358] = 298,
  [359] = 306,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(24);
      if (lookahead == '!') ADVANCE(65);
      if (lookahead == '"') ADVANCE(73);
      if (lookahead == '%') ADVANCE(63);
      if (lookahead == '&') ADVANCE(54);
      if (lookahead == '\'') ADVANCE(69);
      if (lookahead == '(') ADVANCE(31);
      if (lookahead == ')') ADVANCE(32);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(58);
      if (lookahead == ',') ADVANCE(33);
      if (lookahead == '-') ADVANCE(60);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == ':') ADVANCE(27);
      if (lookahead == ';') ADVANCE(25);
      if (lookahead == '<') ADVANCE(50);
      if (lookahead == '=') ADVANCE(29);
      if (lookahead == '>') ADVANCE(48);
      if (lookahead == '?') ADVANCE(67);
      if (lookahead == '@') ADVANCE(15);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead == '|') ADVANCE(56);
      if (lookahead == '}') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(2);
      if (lookahead == '%') ADVANCE(63);
      if (lookahead == '&') ADVANCE(55);
      if (lookahead == '(') ADVANCE(31);
      if (lookahead == ')') ADVANCE(32);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(58);
      if (lookahead == ',') ADVANCE(33);
      if (lookahead == '-') ADVANCE(60);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == ';') ADVANCE(25);
      if (lookahead == '<') ADVANCE(50);
      if (lookahead == '=') ADVANCE(29);
      if (lookahead == '>') ADVANCE(48);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead == '|') ADVANCE(56);
      if (lookahead == '}') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(66);
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 3:
      if (lookahead == ')') ADVANCE(32);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == ':') ADVANCE(7);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (lookahead == '!' ||
          lookahead == '&' ||
          lookahead == '\'' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(69);
      END_STATE();
    case 4:
      if (lookahead == '*') ADVANCE(6);
      if (lookahead == '/') ADVANCE(86);
      END_STATE();
    case 5:
      if (lookahead == '*') ADVANCE(5);
      if (lookahead == '/') ADVANCE(85);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 6:
      if (lookahead == '*') ADVANCE(5);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == ':') ADVANCE(71);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(16);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == 'c') ADVANCE(13);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(18);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 14:
      if (lookahead == 'f') ADVANCE(9);
      END_STATE();
    case 15:
      if (lookahead == 'i') ADVANCE(17);
      if (lookahead == 'n') ADVANCE(8);
      END_STATE();
    case 16:
      if (lookahead == 'm') ADVANCE(12);
      END_STATE();
    case 17:
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 18:
      if (lookahead == 'r') ADVANCE(14);
      END_STATE();
    case 19:
      if (lookahead == 't') ADVANCE(11);
      END_STATE();
    case 20:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(82);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(81);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 23:
      if (eof) ADVANCE(24);
      if (lookahead == '!') ADVANCE(64);
      if (lookahead == '"') ADVANCE(73);
      if (lookahead == '(') ADVANCE(31);
      if (lookahead == ')') ADVANCE(32);
      if (lookahead == '+') ADVANCE(57);
      if (lookahead == ',') ADVANCE(33);
      if (lookahead == '-') ADVANCE(59);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(83);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == ';') ADVANCE(25);
      if (lookahead == '=') ADVANCE(28);
      if (lookahead == '>') ADVANCE(47);
      if (lookahead == '?') ADVANCE(67);
      if (lookahead == '@') ADVANCE(15);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead == '}') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(84);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(71);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(46);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_ATname);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_ATinterface);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(49);
      if (lookahead == '>') ADVANCE(52);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(53);
      if (lookahead == '=') ADVANCE(51);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(44);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(43);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(37);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(38);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(39);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(6);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == '=') ADVANCE(40);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(41);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_BANG_BANG);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym__func_identifier_part_token1);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym__func_identifier_letter_token1);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(aux_sym__func_identifier_letter_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(aux_sym__func_identifier_letter_token2);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(79);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(86);
      if (lookahead != 0) ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(77);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(79);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(6);
      if (lookahead != 0) ADVANCE(77);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(6);
      if (lookahead != 0) ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(79);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(79);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(aux_sym_integer_token2);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(81);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym_integer_token3);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(82);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(aux_sym_integer_token4);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(20);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(21);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(84);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym_integer_token4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(84);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(86);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'm') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      if (lookahead == 'o') ADVANCE(12);
      if (lookahead == 'p') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(14);
      if (lookahead == 's') ADVANCE(15);
      if (lookahead == 't') ADVANCE(16);
      if (lookahead == 'u') ADVANCE(17);
      if (lookahead == 'v') ADVANCE(18);
      if (lookahead == 'w') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(20);
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(21);
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(26);
      if (lookahead == 'x') ADVANCE(27);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'u') ADVANCE(29);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(31);
      if (lookahead == 'm') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(35);
      if (lookahead == 'e') ADVANCE(36);
      if (lookahead == 'u') ADVANCE(37);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(38);
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 12:
      if (lookahead == 'v') ADVANCE(40);
      END_STATE();
    case 13:
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 17:
      if (lookahead == 'n') ADVANCE(46);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(47);
      END_STATE();
    case 19:
      if (lookahead == 'h') ADVANCE(48);
      if (lookahead == 'i') ADVANCE(49);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(sym__type_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 23:
      if (lookahead == 'u') ADVANCE(51);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 26:
      if (lookahead == 's') ADVANCE(53);
      END_STATE();
    case 27:
      if (lookahead == 't') ADVANCE(54);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(55);
      END_STATE();
    case 29:
      if (lookahead == 'n') ADVANCE(56);
      END_STATE();
    case 30:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 32:
      if (lookahead == 'p') ADVANCE(58);
      END_STATE();
    case 33:
      if (lookahead == 'i') ADVANCE(59);
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 35:
      if (lookahead == 'p') ADVANCE(62);
      END_STATE();
    case 36:
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(64);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(65);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(66);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 41:
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 42:
      if (lookahead == 'c') ADVANCE(69);
      if (lookahead == 'p') ADVANCE(70);
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 43:
      if (lookahead == 'l') ADVANCE(72);
      END_STATE();
    case 44:
      if (lookahead == 'r') ADVANCE(73);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(74);
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 51:
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 52:
      if (lookahead == 's') ADVANCE(82);
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 55:
      if (lookahead == 's') ADVANCE(86);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_fun);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(87);
      END_STATE();
    case 59:
      if (lookahead == 't') ADVANCE(88);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_map);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(90);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(91);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(92);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(94);
      END_STATE();
    case 68:
      if (lookahead == 'm') ADVANCE(95);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 71:
      if (lookahead == 'u') ADVANCE(98);
      END_STATE();
    case 72:
      if (lookahead == 'f') ADVANCE(99);
      END_STATE();
    case 73:
      if (lookahead == 'u') ADVANCE(100);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(101);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(103);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 78:
      if (lookahead == 'l') ADVANCE(105);
      END_STATE();
    case 79:
      if (lookahead == 'h') ADVANCE(106);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 81:
      if (lookahead == 'c') ADVANCE(108);
      END_STATE();
    case 82:
      if (lookahead == 't') ADVANCE(109);
      END_STATE();
    case 83:
      if (lookahead == 'r') ADVANCE(110);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 85:
      if (lookahead == 'n') ADVANCE(111);
      if (lookahead == 'r') ADVANCE(112);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 87:
      if (lookahead == 'r') ADVANCE(114);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_init);
      if (lookahead == 'O') ADVANCE(115);
      END_STATE();
    case 89:
      if (lookahead == 'n') ADVANCE(116);
      END_STATE();
    case 90:
      if (lookahead == 'a') ADVANCE(117);
      END_STATE();
    case 91:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 92:
      if (lookahead == 'v') ADVANCE(119);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 94:
      if (lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 95:
      if (lookahead == 'i') ADVANCE(121);
      END_STATE();
    case 96:
      if (lookahead == 'i') ADVANCE(122);
      END_STATE();
    case 97:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 98:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_self);
      END_STATE();
    case 100:
      if (lookahead == 'c') ADVANCE(125);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 103:
      if (lookahead == 'l') ADVANCE(127);
      END_STATE();
    case 104:
      if (lookahead == 'u') ADVANCE(128);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(129);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 107:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 110:
      if (lookahead == 'a') ADVANCE(132);
      END_STATE();
    case 111:
      if (lookahead == 'd') ADVANCE(133);
      END_STATE();
    case 112:
      if (lookahead == 'n') ADVANCE(134);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(135);
      END_STATE();
    case 115:
      if (lookahead == 'f') ADVANCE(136);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 117:
      if (lookahead == 'g') ADVANCE(138);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(140);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(141);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 122:
      if (lookahead == 'v') ADVANCE(143);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 124:
      if (lookahead == 'n') ADVANCE(145);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_trait);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 128:
      if (lookahead == 'a') ADVANCE(147);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 130:
      if (lookahead == 'c') ADVANCE(148);
      END_STATE();
    case 131:
      if (lookahead == 'd') ADVANCE(149);
      END_STATE();
    case 132:
      if (lookahead == 'c') ADVANCE(150);
      END_STATE();
    case 133:
      if (lookahead == 's') ADVANCE(151);
      END_STATE();
    case 134:
      if (lookahead == 'a') ADVANCE(152);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_initOf);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_inline);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 139:
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 141:
      if (lookahead == 'd') ADVANCE(155);
      END_STATE();
    case 142:
      if (lookahead == 'i') ADVANCE(156);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(158);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_bounced);
      END_STATE();
    case 150:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 152:
      if (lookahead == 'l') ADVANCE(161);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_message);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_mutates);
      END_STATE();
    case 155:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 156:
      if (lookahead == 'v') ADVANCE(163);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_receive);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_virtual);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_contract);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 163:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_primitive);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 23},
  [2] = {.lex_state = 23},
  [3] = {.lex_state = 23},
  [4] = {.lex_state = 23},
  [5] = {.lex_state = 23},
  [6] = {.lex_state = 23},
  [7] = {.lex_state = 23},
  [8] = {.lex_state = 23},
  [9] = {.lex_state = 23},
  [10] = {.lex_state = 23},
  [11] = {.lex_state = 23},
  [12] = {.lex_state = 23},
  [13] = {.lex_state = 23},
  [14] = {.lex_state = 1},
  [15] = {.lex_state = 23},
  [16] = {.lex_state = 23},
  [17] = {.lex_state = 23},
  [18] = {.lex_state = 23},
  [19] = {.lex_state = 23},
  [20] = {.lex_state = 23},
  [21] = {.lex_state = 23},
  [22] = {.lex_state = 23},
  [23] = {.lex_state = 23},
  [24] = {.lex_state = 23},
  [25] = {.lex_state = 23},
  [26] = {.lex_state = 23},
  [27] = {.lex_state = 23},
  [28] = {.lex_state = 23},
  [29] = {.lex_state = 23},
  [30] = {.lex_state = 23},
  [31] = {.lex_state = 23},
  [32] = {.lex_state = 23},
  [33] = {.lex_state = 23},
  [34] = {.lex_state = 23},
  [35] = {.lex_state = 23},
  [36] = {.lex_state = 23},
  [37] = {.lex_state = 23},
  [38] = {.lex_state = 23},
  [39] = {.lex_state = 23},
  [40] = {.lex_state = 23},
  [41] = {.lex_state = 23},
  [42] = {.lex_state = 1},
  [43] = {.lex_state = 23},
  [44] = {.lex_state = 23},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 23},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 23},
  [49] = {.lex_state = 23},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 23},
  [59] = {.lex_state = 1},
  [60] = {.lex_state = 23},
  [61] = {.lex_state = 1},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 23},
  [65] = {.lex_state = 23},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 23},
  [68] = {.lex_state = 23},
  [69] = {.lex_state = 23},
  [70] = {.lex_state = 23},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 23},
  [73] = {.lex_state = 23},
  [74] = {.lex_state = 23},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 1},
  [79] = {.lex_state = 1},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 1},
  [82] = {.lex_state = 1},
  [83] = {.lex_state = 1},
  [84] = {.lex_state = 1},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 1},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 1},
  [99] = {.lex_state = 1},
  [100] = {.lex_state = 23},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 1},
  [103] = {.lex_state = 23},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 23},
  [108] = {.lex_state = 23},
  [109] = {.lex_state = 23},
  [110] = {.lex_state = 23},
  [111] = {.lex_state = 23},
  [112] = {.lex_state = 23},
  [113] = {.lex_state = 23},
  [114] = {.lex_state = 23},
  [115] = {.lex_state = 23},
  [116] = {.lex_state = 23},
  [117] = {.lex_state = 23},
  [118] = {.lex_state = 23},
  [119] = {.lex_state = 23},
  [120] = {.lex_state = 23},
  [121] = {.lex_state = 23},
  [122] = {.lex_state = 23},
  [123] = {.lex_state = 23},
  [124] = {.lex_state = 23},
  [125] = {.lex_state = 23},
  [126] = {.lex_state = 23},
  [127] = {.lex_state = 23},
  [128] = {.lex_state = 23},
  [129] = {.lex_state = 23},
  [130] = {.lex_state = 23},
  [131] = {.lex_state = 23},
  [132] = {.lex_state = 23},
  [133] = {.lex_state = 23},
  [134] = {.lex_state = 23},
  [135] = {.lex_state = 23},
  [136] = {.lex_state = 23},
  [137] = {.lex_state = 23},
  [138] = {.lex_state = 23},
  [139] = {.lex_state = 23},
  [140] = {.lex_state = 23},
  [141] = {.lex_state = 23},
  [142] = {.lex_state = 23},
  [143] = {.lex_state = 23},
  [144] = {.lex_state = 23},
  [145] = {.lex_state = 23},
  [146] = {.lex_state = 23},
  [147] = {.lex_state = 23},
  [148] = {.lex_state = 23},
  [149] = {.lex_state = 23},
  [150] = {.lex_state = 23},
  [151] = {.lex_state = 23},
  [152] = {.lex_state = 23},
  [153] = {.lex_state = 23},
  [154] = {.lex_state = 23},
  [155] = {.lex_state = 23},
  [156] = {.lex_state = 23},
  [157] = {.lex_state = 23},
  [158] = {.lex_state = 23},
  [159] = {.lex_state = 23},
  [160] = {.lex_state = 23},
  [161] = {.lex_state = 23},
  [162] = {.lex_state = 23},
  [163] = {.lex_state = 23},
  [164] = {.lex_state = 23},
  [165] = {.lex_state = 23},
  [166] = {.lex_state = 23},
  [167] = {.lex_state = 23},
  [168] = {.lex_state = 23},
  [169] = {.lex_state = 23},
  [170] = {.lex_state = 23},
  [171] = {.lex_state = 23},
  [172] = {.lex_state = 23},
  [173] = {.lex_state = 23},
  [174] = {.lex_state = 23},
  [175] = {.lex_state = 23},
  [176] = {.lex_state = 23},
  [177] = {.lex_state = 23},
  [178] = {.lex_state = 23},
  [179] = {.lex_state = 3},
  [180] = {.lex_state = 3},
  [181] = {.lex_state = 23},
  [182] = {.lex_state = 3},
  [183] = {.lex_state = 23},
  [184] = {.lex_state = 23},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 23},
  [187] = {.lex_state = 23},
  [188] = {.lex_state = 0},
  [189] = {.lex_state = 23},
  [190] = {.lex_state = 23},
  [191] = {.lex_state = 23},
  [192] = {.lex_state = 0},
  [193] = {.lex_state = 23},
  [194] = {.lex_state = 23},
  [195] = {.lex_state = 23},
  [196] = {.lex_state = 23},
  [197] = {.lex_state = 23},
  [198] = {.lex_state = 23},
  [199] = {.lex_state = 23},
  [200] = {.lex_state = 23},
  [201] = {.lex_state = 23},
  [202] = {.lex_state = 23},
  [203] = {.lex_state = 23},
  [204] = {.lex_state = 23},
  [205] = {.lex_state = 23},
  [206] = {.lex_state = 23},
  [207] = {.lex_state = 23},
  [208] = {.lex_state = 23},
  [209] = {.lex_state = 23},
  [210] = {.lex_state = 23},
  [211] = {.lex_state = 23},
  [212] = {.lex_state = 23},
  [213] = {.lex_state = 23},
  [214] = {.lex_state = 23},
  [215] = {.lex_state = 23},
  [216] = {.lex_state = 23},
  [217] = {.lex_state = 3},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 23},
  [220] = {.lex_state = 23},
  [221] = {.lex_state = 23},
  [222] = {.lex_state = 0},
  [223] = {.lex_state = 23},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 23},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 0},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 23},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 23},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 23},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 23},
  [240] = {.lex_state = 23},
  [241] = {.lex_state = 23},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 23},
  [246] = {.lex_state = 23},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 23},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 0},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 23},
  [259] = {.lex_state = 0},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 23},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 0},
  [264] = {.lex_state = 23},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 23},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 0},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 23},
  [291] = {.lex_state = 23},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 23},
  [294] = {.lex_state = 23},
  [295] = {.lex_state = 23},
  [296] = {.lex_state = 23},
  [297] = {.lex_state = 23},
  [298] = {.lex_state = 23},
  [299] = {.lex_state = 23},
  [300] = {.lex_state = 23},
  [301] = {.lex_state = 23},
  [302] = {.lex_state = 23},
  [303] = {.lex_state = 23},
  [304] = {.lex_state = 23},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 23},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 78},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 23},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 23},
  [314] = {.lex_state = 23},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 23},
  [318] = {.lex_state = 23},
  [319] = {.lex_state = 23},
  [320] = {.lex_state = 23},
  [321] = {.lex_state = 23},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 23},
  [327] = {.lex_state = 23},
  [328] = {.lex_state = 23},
  [329] = {.lex_state = 23},
  [330] = {.lex_state = 23},
  [331] = {.lex_state = 23},
  [332] = {.lex_state = 23},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 23},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 23},
  [337] = {.lex_state = 23},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 23},
  [344] = {.lex_state = 23},
  [345] = {.lex_state = 23},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 23},
  [353] = {.lex_state = 23},
  [354] = {.lex_state = 23},
  [355] = {.lex_state = 23},
  [356] = {.lex_state = 23},
  [357] = {.lex_state = 23},
  [358] = {.lex_state = 23},
  [359] = {.lex_state = 23},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_primitive] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_virtual] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_ATname] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_fun] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_mutates] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_inline] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_message] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_contract] = ACTIONS(1),
    [anon_sym_trait] = ACTIONS(1),
    [anon_sym_ATinterface] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_init] = ACTIONS(1),
    [anon_sym_receive] = ACTIONS(1),
    [anon_sym_bounced] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_initOf] = ACTIONS(1),
    [anon_sym_map] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym__type_identifier] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [aux_sym__func_identifier_part_token1] = ACTIONS(1),
    [aux_sym__func_identifier_letter_token1] = ACTIONS(1),
    [aux_sym__func_identifier_letter_token2] = ACTIONS(1),
    [sym_self] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(350),
    [sym__program_item] = STATE(10),
    [sym_primitive_statement] = STATE(10),
    [sym_import_statement] = STATE(10),
    [sym_constant] = STATE(10),
    [sym_constant_attributes] = STATE(306),
    [sym_native_function] = STATE(10),
    [sym__static_function] = STATE(10),
    [sym_function] = STATE(110),
    [sym_function_attributes] = STATE(343),
    [sym_struct] = STATE(10),
    [sym_message] = STATE(10),
    [sym_contract] = STATE(10),
    [sym_trait] = STATE(10),
    [sym_contract_attributes] = STATE(246),
    [aux_sym_source_file_repeat1] = STATE(10),
    [aux_sym_constant_attributes_repeat1] = STATE(200),
    [aux_sym_function_attributes_repeat1] = STATE(165),
    [aux_sym_contract_attributes_repeat1] = STATE(210),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_primitive] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_const] = ACTIONS(11),
    [anon_sym_virtual] = ACTIONS(13),
    [anon_sym_override] = ACTIONS(13),
    [anon_sym_abstract] = ACTIONS(13),
    [anon_sym_ATname] = ACTIONS(15),
    [anon_sym_fun] = ACTIONS(17),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_mutates] = ACTIONS(19),
    [anon_sym_extends] = ACTIONS(19),
    [anon_sym_inline] = ACTIONS(19),
    [anon_sym_struct] = ACTIONS(21),
    [anon_sym_message] = ACTIONS(23),
    [anon_sym_contract] = ACTIONS(25),
    [anon_sym_trait] = ACTIONS(27),
    [anon_sym_ATinterface] = ACTIONS(29),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_RBRACE,
    ACTIONS(39), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_return,
    ACTIONS(43), 1,
      anon_sym_if,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_repeat,
    ACTIONS(49), 1,
      anon_sym_do,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(55), 1,
      sym_self,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(61), 1,
      sym_null,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    STATE(54), 1,
      sym_value_expression,
    STATE(192), 1,
      sym__lvalue,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(102), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
    STATE(4), 12,
      sym__statement,
      sym_let_statement,
      sym_block_statement,
      sym_return_statement,
      sym_expression_statement,
      sym_assignment_statement,
      sym_augmented_assignment_statement,
      sym_if_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_until_statement,
      aux_sym_block_statement_repeat1,
  [100] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_return,
    ACTIONS(43), 1,
      anon_sym_if,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_repeat,
    ACTIONS(49), 1,
      anon_sym_do,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(55), 1,
      sym_self,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(61), 1,
      sym_null,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(67), 1,
      anon_sym_RBRACE,
    STATE(54), 1,
      sym_value_expression,
    STATE(192), 1,
      sym__lvalue,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(102), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
    STATE(2), 12,
      sym__statement,
      sym_let_statement,
      sym_block_statement,
      sym_return_statement,
      sym_expression_statement,
      sym_assignment_statement,
      sym_augmented_assignment_statement,
      sym_if_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_until_statement,
      aux_sym_block_statement_repeat1,
  [200] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(72), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(78), 1,
      anon_sym_RBRACE,
    ACTIONS(80), 1,
      anon_sym_let,
    ACTIONS(83), 1,
      anon_sym_return,
    ACTIONS(86), 1,
      anon_sym_if,
    ACTIONS(89), 1,
      anon_sym_while,
    ACTIONS(92), 1,
      anon_sym_repeat,
    ACTIONS(95), 1,
      anon_sym_do,
    ACTIONS(101), 1,
      anon_sym_initOf,
    ACTIONS(104), 1,
      sym_self,
    ACTIONS(107), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      sym_null,
    ACTIONS(119), 1,
      aux_sym_integer_token4,
    STATE(54), 1,
      sym_value_expression,
    STATE(192), 1,
      sym__lvalue,
    ACTIONS(110), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(98), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(116), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(102), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
    STATE(4), 12,
      sym__statement,
      sym_let_statement,
      sym_block_statement,
      sym_return_statement,
      sym_expression_statement,
      sym_assignment_statement,
      sym_augmented_assignment_statement,
      sym_if_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_until_statement,
      aux_sym_block_statement_repeat1,
  [300] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_return,
    ACTIONS(43), 1,
      anon_sym_if,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_repeat,
    ACTIONS(49), 1,
      anon_sym_do,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(55), 1,
      sym_self,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(61), 1,
      sym_null,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(122), 1,
      anon_sym_RBRACE,
    STATE(54), 1,
      sym_value_expression,
    STATE(192), 1,
      sym__lvalue,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(102), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
    STATE(4), 12,
      sym__statement,
      sym_let_statement,
      sym_block_statement,
      sym_return_statement,
      sym_expression_statement,
      sym_assignment_statement,
      sym_augmented_assignment_statement,
      sym_if_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_until_statement,
      aux_sym_block_statement_repeat1,
  [400] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      sym_identifier,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_return,
    ACTIONS(43), 1,
      anon_sym_if,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_repeat,
    ACTIONS(49), 1,
      anon_sym_do,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(55), 1,
      sym_self,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(61), 1,
      sym_null,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(124), 1,
      anon_sym_RBRACE,
    STATE(54), 1,
      sym_value_expression,
    STATE(192), 1,
      sym__lvalue,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(102), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
    STATE(5), 12,
      sym__statement,
      sym_let_statement,
      sym_block_statement,
      sym_return_statement,
      sym_expression_statement,
      sym_assignment_statement,
      sym_augmented_assignment_statement,
      sym_if_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_until_statement,
      aux_sym_block_statement_repeat1,
  [500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(128), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(126), 27,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [545] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(132), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(130), 27,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [590] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(134), 1,
      ts_builtin_sym_end,
    ACTIONS(136), 1,
      anon_sym_primitive,
    ACTIONS(139), 1,
      anon_sym_import,
    ACTIONS(142), 1,
      anon_sym_const,
    ACTIONS(148), 1,
      anon_sym_ATname,
    ACTIONS(151), 1,
      anon_sym_fun,
    ACTIONS(157), 1,
      anon_sym_struct,
    ACTIONS(160), 1,
      anon_sym_message,
    ACTIONS(163), 1,
      anon_sym_contract,
    ACTIONS(166), 1,
      anon_sym_trait,
    ACTIONS(169), 1,
      anon_sym_ATinterface,
    STATE(110), 1,
      sym_function,
    STATE(165), 1,
      aux_sym_function_attributes_repeat1,
    STATE(200), 1,
      aux_sym_constant_attributes_repeat1,
    STATE(210), 1,
      aux_sym_contract_attributes_repeat1,
    STATE(246), 1,
      sym_contract_attributes,
    STATE(306), 1,
      sym_constant_attributes,
    STATE(343), 1,
      sym_function_attributes,
    ACTIONS(145), 3,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
    ACTIONS(154), 4,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
    STATE(9), 11,
      sym__program_item,
      sym_primitive_statement,
      sym_import_statement,
      sym_constant,
      sym_native_function,
      sym__static_function,
      sym_struct,
      sym_message,
      sym_contract,
      sym_trait,
      aux_sym_source_file_repeat1,
  [672] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_primitive,
    ACTIONS(9), 1,
      anon_sym_import,
    ACTIONS(11), 1,
      anon_sym_const,
    ACTIONS(15), 1,
      anon_sym_ATname,
    ACTIONS(17), 1,
      anon_sym_fun,
    ACTIONS(21), 1,
      anon_sym_struct,
    ACTIONS(23), 1,
      anon_sym_message,
    ACTIONS(25), 1,
      anon_sym_contract,
    ACTIONS(27), 1,
      anon_sym_trait,
    ACTIONS(29), 1,
      anon_sym_ATinterface,
    ACTIONS(172), 1,
      ts_builtin_sym_end,
    STATE(110), 1,
      sym_function,
    STATE(165), 1,
      aux_sym_function_attributes_repeat1,
    STATE(200), 1,
      aux_sym_constant_attributes_repeat1,
    STATE(210), 1,
      aux_sym_contract_attributes_repeat1,
    STATE(246), 1,
      sym_contract_attributes,
    STATE(306), 1,
      sym_constant_attributes,
    STATE(343), 1,
      sym_function_attributes,
    ACTIONS(13), 3,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
    ACTIONS(19), 4,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
    STATE(9), 11,
      sym__program_item,
      sym_primitive_statement,
      sym_import_statement,
      sym_constant,
      sym_native_function,
      sym__static_function,
      sym_struct,
      sym_message,
      sym_contract,
      sym_trait,
      aux_sym_source_file_repeat1,
  [754] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(176), 1,
      anon_sym_RPAREN,
    STATE(54), 1,
      sym_value_expression,
    STATE(232), 1,
      sym_argument,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(86), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [817] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(178), 1,
      anon_sym_SEMI,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(91), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [877] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    STATE(279), 1,
      sym_argument,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(86), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [937] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(182), 1,
      anon_sym_EQ,
    ACTIONS(184), 1,
      anon_sym_LPAREN,
    ACTIONS(186), 1,
      anon_sym_LBRACE,
    ACTIONS(190), 1,
      anon_sym_DOT,
    STATE(56), 1,
      sym_argument_list,
    STATE(66), 1,
      sym_instance_argument_list,
    ACTIONS(188), 5,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(193), 9,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(180), 10,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_BANG_BANG,
  [989] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(104), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1046] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(77), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1103] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(98), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1160] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(97), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1217] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(92), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1274] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(93), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1331] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(101), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1388] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(89), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1445] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(90), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1502] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(94), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1559] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(95), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1616] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(84), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1673] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(88), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1730] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(85), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1787] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(83), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1844] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(81), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1901] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(80), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [1958] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(79), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [2015] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(78), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [2072] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(99), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [2129] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(96), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [2186] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(87), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [2243] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(105), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [2300] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_initOf,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    ACTIONS(174), 1,
      sym_identifier,
    STATE(54), 1,
      sym_value_expression,
    ACTIONS(59), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(61), 2,
      sym_self,
      sym_null,
    ACTIONS(51), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    STATE(106), 4,
      sym__expression,
      sym_binary_expression,
      sym_unary_expression,
      sym_unary_suffix_expression,
    STATE(51), 9,
      sym_method_call_expression,
      sym_field_access_expression,
      sym_static_call_expression,
      sym_parenthesized_expression,
      sym_instance_expression,
      sym_initOf,
      sym_string,
      sym_boolean,
      sym_integer,
  [2357] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_const,
    ACTIONS(201), 1,
      anon_sym_fun,
    ACTIONS(205), 1,
      anon_sym_RBRACE,
    ACTIONS(207), 1,
      anon_sym_init,
    ACTIONS(209), 1,
      anon_sym_receive,
    ACTIONS(211), 1,
      anon_sym_bounced,
    ACTIONS(213), 1,
      anon_sym_external,
    STATE(165), 1,
      aux_sym_function_attributes_repeat1,
    STATE(200), 1,
      aux_sym_constant_attributes_repeat1,
    STATE(357), 1,
      sym_function_attributes,
    STATE(359), 1,
      sym_constant_attributes,
    ACTIONS(199), 3,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
    ACTIONS(203), 4,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
    STATE(41), 9,
      sym_constant,
      sym_function,
      sym_field,
      sym_init_function,
      sym__receiver_function,
      sym_receive_function,
      sym_bounced_function,
      sym_external_function,
      aux_sym_contract_body_repeat1,
  [2419] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      sym_identifier,
    ACTIONS(218), 1,
      anon_sym_const,
    ACTIONS(224), 1,
      anon_sym_fun,
    ACTIONS(230), 1,
      anon_sym_RBRACE,
    ACTIONS(232), 1,
      anon_sym_init,
    ACTIONS(235), 1,
      anon_sym_receive,
    ACTIONS(238), 1,
      anon_sym_bounced,
    ACTIONS(241), 1,
      anon_sym_external,
    STATE(165), 1,
      aux_sym_function_attributes_repeat1,
    STATE(200), 1,
      aux_sym_constant_attributes_repeat1,
    STATE(357), 1,
      sym_function_attributes,
    STATE(359), 1,
      sym_constant_attributes,
    ACTIONS(221), 3,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
    ACTIONS(227), 4,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
    STATE(40), 9,
      sym_constant,
      sym_function,
      sym_field,
      sym_init_function,
      sym__receiver_function,
      sym_receive_function,
      sym_bounced_function,
      sym_external_function,
      aux_sym_contract_body_repeat1,
  [2481] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_const,
    ACTIONS(201), 1,
      anon_sym_fun,
    ACTIONS(207), 1,
      anon_sym_init,
    ACTIONS(209), 1,
      anon_sym_receive,
    ACTIONS(211), 1,
      anon_sym_bounced,
    ACTIONS(213), 1,
      anon_sym_external,
    ACTIONS(244), 1,
      anon_sym_RBRACE,
    STATE(165), 1,
      aux_sym_function_attributes_repeat1,
    STATE(200), 1,
      aux_sym_constant_attributes_repeat1,
    STATE(357), 1,
      sym_function_attributes,
    STATE(359), 1,
      sym_constant_attributes,
    ACTIONS(199), 3,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
    ACTIONS(203), 4,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
    STATE(40), 9,
      sym_constant,
      sym_function,
      sym_field,
      sym_init_function,
      sym__receiver_function,
      sym_receive_function,
      sym_bounced_function,
      sym_external_function,
      aux_sym_contract_body_repeat1,
  [2543] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 1,
      anon_sym_LPAREN,
    ACTIONS(186), 1,
      anon_sym_LBRACE,
    STATE(56), 1,
      sym_argument_list,
    STATE(66), 1,
      sym_instance_argument_list,
    ACTIONS(193), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(180), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [2586] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_const,
    ACTIONS(201), 1,
      anon_sym_fun,
    ACTIONS(209), 1,
      anon_sym_receive,
    ACTIONS(211), 1,
      anon_sym_bounced,
    ACTIONS(213), 1,
      anon_sym_external,
    ACTIONS(246), 1,
      anon_sym_RBRACE,
    STATE(165), 1,
      aux_sym_function_attributes_repeat1,
    STATE(200), 1,
      aux_sym_constant_attributes_repeat1,
    STATE(357), 1,
      sym_function_attributes,
    STATE(359), 1,
      sym_constant_attributes,
    ACTIONS(199), 3,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
    ACTIONS(203), 4,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
    STATE(46), 8,
      sym_constant,
      sym_function,
      sym_field,
      sym__receiver_function,
      sym_receive_function,
      sym_bounced_function,
      sym_external_function,
      aux_sym_trait_body_repeat1,
  [2644] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 1,
      sym_identifier,
    ACTIONS(251), 1,
      anon_sym_const,
    ACTIONS(257), 1,
      anon_sym_fun,
    ACTIONS(263), 1,
      anon_sym_RBRACE,
    ACTIONS(265), 1,
      anon_sym_receive,
    ACTIONS(268), 1,
      anon_sym_bounced,
    ACTIONS(271), 1,
      anon_sym_external,
    STATE(165), 1,
      aux_sym_function_attributes_repeat1,
    STATE(200), 1,
      aux_sym_constant_attributes_repeat1,
    STATE(357), 1,
      sym_function_attributes,
    STATE(359), 1,
      sym_constant_attributes,
    ACTIONS(254), 3,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
    ACTIONS(260), 4,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
    STATE(44), 8,
      sym_constant,
      sym_function,
      sym_field,
      sym__receiver_function,
      sym_receive_function,
      sym_bounced_function,
      sym_external_function,
      aux_sym_trait_body_repeat1,
  [2702] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(182), 1,
      anon_sym_EQ,
    ACTIONS(190), 1,
      anon_sym_DOT,
    ACTIONS(188), 5,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(193), 9,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(180), 10,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_BANG_BANG,
  [2742] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_const,
    ACTIONS(201), 1,
      anon_sym_fun,
    ACTIONS(209), 1,
      anon_sym_receive,
    ACTIONS(211), 1,
      anon_sym_bounced,
    ACTIONS(213), 1,
      anon_sym_external,
    ACTIONS(274), 1,
      anon_sym_RBRACE,
    STATE(165), 1,
      aux_sym_function_attributes_repeat1,
    STATE(200), 1,
      aux_sym_constant_attributes_repeat1,
    STATE(357), 1,
      sym_function_attributes,
    STATE(359), 1,
      sym_constant_attributes,
    ACTIONS(199), 3,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
    ACTIONS(203), 4,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
    STATE(44), 8,
      sym_constant,
      sym_function,
      sym_field,
      sym__receiver_function,
      sym_receive_function,
      sym_bounced_function,
      sym_external_function,
      aux_sym_trait_body_repeat1,
  [2800] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_argument_list,
    ACTIONS(278), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(276), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [2837] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_else,
    STATE(74), 1,
      sym_else_clause,
    ACTIONS(282), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(280), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [2874] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(286), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [2905] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(290), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [2936] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(180), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [2967] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(294), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [2998] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(298), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3029] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(304), 1,
      anon_sym_DOT,
    ACTIONS(306), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(302), 17,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3062] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(308), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3093] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(314), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(312), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3124] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(318), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(316), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3155] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(322), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(320), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [3186] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(324), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3217] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(330), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(328), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [3248] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(334), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(332), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(338), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(336), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3310] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(340), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3341] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(346), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(344), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [3372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(350), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(348), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [3403] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(352), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(356), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [3465] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(362), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(360), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [3496] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(366), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(364), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [3527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(368), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [3558] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(372), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3589] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(376), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [3620] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(380), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [3651] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
    ACTIONS(384), 13,
      anon_sym_let,
      anon_sym_return,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_initOf,
      sym_identifier,
      sym_self,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_integer_token4,
  [3682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(388), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3713] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(394), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(392), 18,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3744] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(396), 5,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
  [3792] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(418), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(396), 16,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [3824] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(418), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(396), 14,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
  [3860] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(418), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(396), 12,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
  [3898] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(418), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(396), 10,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [3940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(422), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(420), 17,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_BANG_BANG,
  [3970] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(396), 8,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
  [4014] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(426), 5,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_SLASH,
    ACTIONS(424), 16,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4046] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(396), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
  [4092] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(428), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [4140] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(432), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [4188] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(434), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4235] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(436), 1,
      anon_sym_RPAREN,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4282] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(438), 1,
      anon_sym_RPAREN,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4329] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(440), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4376] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(442), 1,
      anon_sym_RPAREN,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4423] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(444), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4470] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(446), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4517] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(448), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4564] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(450), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4611] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(452), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4658] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(454), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4705] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(456), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4752] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(132), 19,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
      anon_sym_until,
  [4777] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(458), 1,
      anon_sym_RPAREN,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4824] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(460), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4871] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(128), 19,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
      anon_sym_until,
  [4896] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(462), 1,
      anon_sym_RPAREN,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4943] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(464), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [4990] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_SLASH,
    ACTIONS(416), 1,
      anon_sym_BANG_BANG,
    ACTIONS(430), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(466), 1,
      anon_sym_SEMI,
    ACTIONS(400), 2,
      anon_sym_BANG_EQ,
      anon_sym_EQ_EQ,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(406), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(410), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(412), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [5037] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5061] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5085] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(472), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5109] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(474), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5133] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5157] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(478), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5181] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5205] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(482), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5229] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5253] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(486), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5277] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5301] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(490), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5325] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(492), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5349] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5373] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(496), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5397] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5421] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5445] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5469] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(504), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5493] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5517] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(508), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5541] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5565] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5589] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5613] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5637] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5661] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(520), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5685] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5709] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5733] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5757] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(528), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5781] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(530), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5805] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5829] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(534), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5853] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5877] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(538), 18,
      ts_builtin_sym_end,
      anon_sym_primitive,
      anon_sym_import,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_ATname,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_struct,
      anon_sym_message,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [5901] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 1,
      anon_sym_RBRACE,
    ACTIONS(540), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [5924] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(544), 1,
      anon_sym_RBRACE,
    ACTIONS(542), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [5947] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(548), 1,
      anon_sym_RBRACE,
    ACTIONS(546), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [5970] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(504), 1,
      anon_sym_RBRACE,
    ACTIONS(550), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [5993] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 1,
      anon_sym_RBRACE,
    ACTIONS(552), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6016] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_RBRACE,
    ACTIONS(554), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 1,
      anon_sym_RBRACE,
    ACTIONS(556), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6062] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_RBRACE,
    ACTIONS(558), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6085] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(564), 1,
      anon_sym_RBRACE,
    ACTIONS(562), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6108] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 1,
      anon_sym_RBRACE,
    ACTIONS(566), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      anon_sym_RBRACE,
    ACTIONS(568), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6154] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(496), 1,
      anon_sym_RBRACE,
    ACTIONS(570), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 1,
      anon_sym_RBRACE,
    ACTIONS(572), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6200] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(576), 1,
      anon_sym_RBRACE,
    ACTIONS(574), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(580), 1,
      anon_sym_RBRACE,
    ACTIONS(578), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6246] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(584), 1,
      anon_sym_RBRACE,
    ACTIONS(582), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 1,
      anon_sym_RBRACE,
    ACTIONS(586), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6292] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(590), 1,
      anon_sym_RBRACE,
    ACTIONS(588), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6315] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(594), 1,
      anon_sym_RBRACE,
    ACTIONS(592), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6338] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(598), 1,
      anon_sym_RBRACE,
    ACTIONS(596), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6361] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_RBRACE,
    ACTIONS(600), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6384] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 1,
      anon_sym_RBRACE,
    ACTIONS(602), 14,
      anon_sym_const,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
      anon_sym_init,
      anon_sym_receive,
      anon_sym_bounced,
      anon_sym_external,
      sym_identifier,
  [6407] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(167), 1,
      aux_sym_function_attributes_repeat1,
    ACTIONS(606), 2,
      anon_sym_native,
      anon_sym_fun,
    ACTIONS(604), 7,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
  [6427] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(608), 1,
      anon_sym_native,
    STATE(165), 1,
      aux_sym_function_attributes_repeat1,
    STATE(331), 1,
      sym_function_attributes,
    ACTIONS(19), 7,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
  [6449] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(167), 1,
      aux_sym_function_attributes_repeat1,
    ACTIONS(613), 2,
      anon_sym_native,
      anon_sym_fun,
    ACTIONS(610), 7,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
  [6469] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 1,
      anon_sym_const,
    ACTIONS(617), 3,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
    ACTIONS(620), 5,
      anon_sym_fun,
      anon_sym_get,
      anon_sym_mutates,
      anon_sym_extends,
      anon_sym_inline,
  [6488] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(243), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6507] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(234), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6526] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(262), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6545] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(307), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6564] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(222), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6583] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(242), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6602] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(269), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6621] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(630), 1,
      anon_sym_QMARK,
    ACTIONS(628), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_as,
  [6636] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(263), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6655] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(248), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6674] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 1,
      anon_sym_RPAREN,
    ACTIONS(634), 3,
      aux_sym__func_identifier_part_token1,
      aux_sym__func_identifier_letter_token1,
      aux_sym__func_identifier_letter_token2,
    STATE(180), 3,
      sym__func_identifier_part,
      sym__func_identifier_letter,
      aux_sym_func_identifier_repeat1,
  [6691] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 1,
      anon_sym_RPAREN,
    ACTIONS(638), 3,
      aux_sym__func_identifier_part_token1,
      aux_sym__func_identifier_letter_token1,
      aux_sym__func_identifier_letter_token2,
    STATE(180), 3,
      sym__func_identifier_part,
      sym__func_identifier_letter,
      aux_sym_func_identifier_repeat1,
  [6708] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(257), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6727] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      anon_sym_RPAREN,
    ACTIONS(643), 3,
      aux_sym__func_identifier_part_token1,
      aux_sym__func_identifier_letter_token1,
      aux_sym__func_identifier_letter_token2,
    STATE(179), 3,
      sym__func_identifier_part,
      sym__func_identifier_letter,
      aux_sym_func_identifier_repeat1,
  [6744] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(235), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6763] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(204), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6782] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_DOT,
    ACTIONS(188), 6,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [6797] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(309), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6816] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 1,
      anon_sym_bounced,
    ACTIONS(624), 1,
      anon_sym_map,
    ACTIONS(626), 1,
      sym__type_identifier,
    STATE(289), 4,
      sym__type,
      sym_map_type,
      sym_bounced_type,
      sym__simple_type,
  [6835] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(647), 6,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [6847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_as,
  [6859] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_as,
  [6871] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_as,
  [6883] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(655), 1,
      anon_sym_EQ,
    ACTIONS(657), 5,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [6897] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(659), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_as,
  [6909] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_as,
  [6921] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(663), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_as,
  [6933] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_const,
    STATE(196), 1,
      aux_sym_constant_attributes_repeat1,
    ACTIONS(667), 3,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
  [6948] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 1,
      sym_identifier,
    ACTIONS(672), 1,
      anon_sym_RPAREN,
    STATE(338), 2,
      sym_parameter,
      sym_string,
  [6965] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 1,
      sym_identifier,
    ACTIONS(674), 1,
      anon_sym_RPAREN,
    STATE(341), 2,
      sym_parameter,
      sym_string,
  [6982] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(65), 1,
      aux_sym_integer_token4,
    STATE(346), 1,
      sym_integer,
    ACTIONS(63), 3,
      aux_sym_integer_token1,
      aux_sym_integer_token2,
      aux_sym_integer_token3,
  [6997] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 1,
      anon_sym_const,
    STATE(196), 1,
      aux_sym_constant_attributes_repeat1,
    ACTIONS(678), 3,
      anon_sym_virtual,
      anon_sym_override,
      anon_sym_abstract,
  [7012] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LBRACE,
    ACTIONS(682), 1,
      anon_sym_with,
    STATE(141), 1,
      sym_trait_body,
    STATE(286), 1,
      sym_trait_list,
  [7028] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 1,
      anon_sym_with,
    ACTIONS(684), 1,
      anon_sym_LBRACE,
    STATE(118), 1,
      sym_contract_body,
    STATE(277), 1,
      sym_trait_list,
  [7044] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(686), 1,
      anon_sym_SEMI,
    ACTIONS(688), 1,
      anon_sym_COLON,
    STATE(149), 1,
      sym_block_statement,
  [7060] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_SEMI,
    ACTIONS(692), 1,
      anon_sym_EQ,
    ACTIONS(694), 1,
      anon_sym_as,
    STATE(252), 1,
      sym_tlb_serialization,
  [7076] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LBRACE,
    ACTIONS(682), 1,
      anon_sym_with,
    STATE(120), 1,
      sym_trait_body,
    STATE(271), 1,
      sym_trait_list,
  [7092] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 4,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_GT,
  [7102] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(698), 1,
      anon_sym_SEMI,
    ACTIONS(700), 1,
      anon_sym_COLON,
    STATE(147), 1,
      sym_block_statement,
  [7118] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 1,
      anon_sym_SEMI,
    ACTIONS(704), 1,
      anon_sym_COLON,
    ACTIONS(706), 1,
      anon_sym_LBRACE,
    STATE(126), 1,
      sym_block_statement,
  [7134] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 1,
      sym_identifier,
    ACTIONS(710), 1,
      anon_sym_RBRACE,
    STATE(214), 2,
      sym_field,
      aux_sym_struct_body_repeat1,
  [7148] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_ATinterface,
    STATE(212), 1,
      aux_sym_contract_attributes_repeat1,
    ACTIONS(712), 2,
      anon_sym_contract,
      anon_sym_trait,
  [7162] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(714), 1,
      sym_identifier,
    ACTIONS(717), 1,
      anon_sym_RBRACE,
    STATE(211), 2,
      sym_field,
      aux_sym_struct_body_repeat1,
  [7176] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_ATinterface,
    STATE(212), 1,
      aux_sym_contract_attributes_repeat1,
    ACTIONS(719), 2,
      anon_sym_contract,
      anon_sym_trait,
  [7190] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(706), 1,
      anon_sym_LBRACE,
    ACTIONS(724), 1,
      anon_sym_SEMI,
    ACTIONS(726), 1,
      anon_sym_COLON,
    STATE(108), 1,
      sym_block_statement,
  [7206] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 1,
      sym_identifier,
    ACTIONS(728), 1,
      anon_sym_RBRACE,
    STATE(211), 2,
      sym_field,
      aux_sym_struct_body_repeat1,
  [7220] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 1,
      anon_sym_with,
    ACTIONS(684), 1,
      anon_sym_LBRACE,
    STATE(109), 1,
      sym_contract_body,
    STATE(285), 1,
      sym_trait_list,
  [7236] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(730), 1,
      anon_sym_if,
    STATE(67), 2,
      sym_block_statement,
      sym_if_statement,
  [7250] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(182), 1,
      sym__func_identifier_letter,
    STATE(339), 1,
      sym_func_identifier,
    ACTIONS(732), 2,
      aux_sym__func_identifier_letter_token1,
      aux_sym__func_identifier_letter_token2,
  [7264] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 1,
      anon_sym_COMMA,
    ACTIONS(736), 1,
      anon_sym_RBRACE,
    STATE(228), 1,
      aux_sym_instance_argument_list_repeat1,
  [7277] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_LPAREN,
    ACTIONS(740), 1,
      sym__type_identifier,
    STATE(293), 1,
      sym_message_value,
  [7290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(188), 1,
      sym__lvalue,
    ACTIONS(742), 2,
      sym_identifier,
      sym_self,
  [7301] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      anon_sym_as,
    ACTIONS(744), 1,
      anon_sym_GT,
    STATE(317), 1,
      sym_tlb_serialization,
  [7314] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(706), 1,
      anon_sym_LBRACE,
    ACTIONS(746), 1,
      anon_sym_SEMI,
    STATE(122), 1,
      sym_block_statement,
  [7327] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 3,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LBRACE,
  [7336] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_COMMA,
    ACTIONS(752), 1,
      anon_sym_LBRACE,
    STATE(237), 1,
      aux_sym_trait_list_repeat1,
  [7349] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 3,
      anon_sym_contract,
      anon_sym_trait,
      anon_sym_ATinterface,
  [7358] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      anon_sym_RPAREN,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    STATE(226), 1,
      aux_sym_parameter_list_repeat1,
  [7371] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      anon_sym_RPAREN,
    ACTIONS(763), 1,
      anon_sym_COMMA,
    STATE(227), 1,
      aux_sym_argument_list_repeat1,
  [7384] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 1,
      anon_sym_COMMA,
    ACTIONS(766), 1,
      anon_sym_RBRACE,
    STATE(230), 1,
      aux_sym_instance_argument_list_repeat1,
  [7397] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 1,
      anon_sym_RPAREN,
    ACTIONS(770), 1,
      anon_sym_COMMA,
    STATE(227), 1,
      aux_sym_argument_list_repeat1,
  [7410] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_COMMA,
    ACTIONS(775), 1,
      anon_sym_RBRACE,
    STATE(230), 1,
      aux_sym_instance_argument_list_repeat1,
  [7423] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(777), 1,
      sym_identifier,
    ACTIONS(779), 1,
      anon_sym_RBRACE,
    STATE(218), 1,
      sym_instance_argument,
  [7436] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_COMMA,
    ACTIONS(781), 1,
      anon_sym_RPAREN,
    STATE(229), 1,
      aux_sym_argument_list_repeat1,
  [7449] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      anon_sym_as,
    ACTIONS(783), 1,
      anon_sym_GT,
    STATE(291), 1,
      sym_tlb_serialization,
  [7462] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(785), 1,
      anon_sym_SEMI,
    STATE(153), 1,
      sym_block_statement,
  [7475] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      anon_sym_as,
    ACTIONS(787), 1,
      anon_sym_EQ,
    STATE(292), 1,
      sym_tlb_serialization,
  [7488] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(789), 1,
      anon_sym_COMMA,
    ACTIONS(792), 1,
      anon_sym_LBRACE,
    STATE(236), 1,
      aux_sym_trait_list_repeat1,
  [7501] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_COMMA,
    ACTIONS(794), 1,
      anon_sym_LBRACE,
    STATE(236), 1,
      aux_sym_trait_list_repeat1,
  [7514] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(796), 1,
      anon_sym_RPAREN,
    ACTIONS(798), 1,
      anon_sym_COMMA,
    STATE(244), 1,
      aux_sym_parameter_list_repeat1,
  [7527] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 3,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LBRACE,
  [7536] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_RPAREN,
    STATE(238), 1,
      sym_parameter,
  [7549] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      anon_sym_as,
    ACTIONS(804), 1,
      anon_sym_COMMA,
    STATE(333), 1,
      sym_tlb_serialization,
  [7562] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(806), 1,
      anon_sym_SEMI,
    STATE(163), 1,
      sym_block_statement,
  [7575] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(706), 1,
      anon_sym_LBRACE,
    ACTIONS(808), 1,
      anon_sym_SEMI,
    STATE(129), 1,
      sym_block_statement,
  [7588] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 1,
      anon_sym_COMMA,
    ACTIONS(810), 1,
      anon_sym_RPAREN,
    STATE(226), 1,
      aux_sym_parameter_list_repeat1,
  [7601] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 3,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LBRACE,
  [7610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 1,
      anon_sym_contract,
    ACTIONS(816), 1,
      anon_sym_trait,
  [7620] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(49), 1,
      sym_block_statement,
  [7630] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_SEMI,
    ACTIONS(820), 1,
      anon_sym_EQ,
  [7640] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(150), 1,
      sym_block_statement,
  [7650] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 1,
      anon_sym_LPAREN,
    STATE(213), 1,
      sym_parameter_list,
  [7660] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      sym_identifier,
    STATE(287), 1,
      sym_parameter,
  [7670] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(824), 1,
      anon_sym_SEMI,
    ACTIONS(826), 1,
      anon_sym_EQ,
  [7680] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(158), 1,
      sym_block_statement,
  [7690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(161), 1,
      sym_block_statement,
  [7700] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(162), 1,
      sym_block_statement,
  [7710] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(706), 1,
      anon_sym_LBRACE,
    STATE(297), 1,
      sym_block_statement,
  [7720] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(828), 1,
      anon_sym_SEMI,
    ACTIONS(830), 1,
      anon_sym_EQ,
  [7730] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_SEMI,
    ACTIONS(834), 1,
      anon_sym_COLON,
  [7740] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(145), 1,
      sym_block_statement,
  [7750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_block_statement,
  [7760] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      sym_identifier,
    STATE(340), 1,
      sym_parameter,
  [7770] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(836), 1,
      anon_sym_SEMI,
    ACTIONS(838), 1,
      anon_sym_EQ,
  [7780] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 1,
      anon_sym_SEMI,
    ACTIONS(842), 1,
      anon_sym_EQ,
  [7790] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(844), 1,
      anon_sym_SEMI,
    ACTIONS(846), 1,
      anon_sym_COLON,
  [7800] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 2,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [7808] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(48), 1,
      sym_block_statement,
  [7818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    STATE(305), 1,
      sym_string,
  [7828] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(72), 1,
      sym_block_statement,
  [7838] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [7846] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 1,
      anon_sym_LPAREN,
    STATE(207), 1,
      sym_parameter_list,
  [7856] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LBRACE,
    STATE(142), 1,
      sym_trait_body,
  [7866] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 1,
      anon_sym_LPAREN,
    STATE(203), 1,
      sym_parameter_list,
  [7876] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(775), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [7884] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(777), 1,
      sym_identifier,
    STATE(273), 1,
      sym_instance_argument,
  [7894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 1,
      anon_sym_LPAREN,
    STATE(63), 1,
      sym_argument_list,
  [7904] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 1,
      anon_sym_LBRACE,
    STATE(128), 1,
      sym_struct_body,
  [7914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 1,
      anon_sym_LBRACE,
    STATE(138), 1,
      sym_contract_body,
  [7924] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 1,
      anon_sym_LPAREN,
    STATE(208), 1,
      sym_parameter_list,
  [7934] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [7942] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    STATE(351), 1,
      sym_string,
  [7952] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 1,
      anon_sym_LBRACE,
    STATE(116), 1,
      sym_struct_body,
  [7962] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 1,
      anon_sym_LPAREN,
    STATE(259), 1,
      sym_parameter_list,
  [7972] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 1,
      anon_sym_LBRACE,
    STATE(114), 1,
      sym_struct_body,
  [7982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 1,
      anon_sym_LPAREN,
    STATE(258), 1,
      sym_parameter_list,
  [7992] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 1,
      anon_sym_LBRACE,
    STATE(107), 1,
      sym_contract_body,
  [8002] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LBRACE,
    STATE(113), 1,
      sym_trait_body,
  [8012] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [8020] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 1,
      anon_sym_LPAREN,
    STATE(264), 1,
      sym_parameter_list,
  [8030] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 1,
      anon_sym_SEMI,
  [8037] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 1,
      sym_identifier,
  [8044] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(856), 1,
      anon_sym_GT,
  [8051] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 1,
      anon_sym_EQ,
  [8058] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 1,
      sym__type_identifier,
  [8065] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_COLON,
  [8072] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 1,
      sym__type_identifier,
  [8079] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 1,
      anon_sym_COLON,
  [8086] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(868), 1,
      anon_sym_until,
  [8093] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
  [8100] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 1,
      sym_identifier,
  [8107] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 1,
      sym__type_identifier,
  [8114] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 1,
      sym_identifier,
  [8121] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 1,
      anon_sym_COLON,
  [8128] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 1,
      sym_identifier,
  [8135] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 1,
      sym_identifier,
  [8142] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 1,
      anon_sym_SEMI,
  [8149] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(886), 1,
      anon_sym_const,
  [8156] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      anon_sym_SEMI,
  [8163] = 2,
    ACTIONS(890), 1,
      aux_sym_string_token1,
    ACTIONS(892), 1,
      sym_comment,
  [8170] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(894), 1,
      anon_sym_SEMI,
  [8177] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 1,
      anon_sym_LPAREN,
  [8184] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 1,
      sym_identifier,
  [8191] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 1,
      anon_sym_SEMI,
  [8198] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      sym_identifier,
  [8205] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      sym_identifier,
  [8212] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 1,
      anon_sym_LT,
  [8219] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_LT,
  [8226] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(910), 1,
      anon_sym_GT,
  [8233] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 1,
      sym_identifier,
  [8240] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(914), 1,
      sym__type_identifier,
  [8247] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(916), 1,
      sym_identifier,
  [8254] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_COLON,
  [8261] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 1,
      anon_sym_LPAREN,
  [8268] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_LPAREN,
  [8275] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
  [8282] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
  [8289] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      sym_identifier,
  [8296] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 1,
      sym__type_identifier,
  [8303] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_GT,
  [8310] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 1,
      sym__type_identifier,
  [8317] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 1,
      sym_identifier,
  [8324] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 1,
      anon_sym_native,
  [8331] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 1,
      sym_identifier,
  [8338] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(942), 1,
      anon_sym_COMMA,
  [8345] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_identifier,
  [8352] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(946), 1,
      anon_sym_DQUOTE,
  [8359] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 1,
      sym_identifier,
  [8366] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(950), 1,
      sym__type_identifier,
  [8373] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 1,
      anon_sym_RPAREN,
  [8380] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 1,
      anon_sym_RPAREN,
  [8387] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      anon_sym_RPAREN,
  [8394] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(958), 1,
      anon_sym_RPAREN,
  [8401] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 1,
      anon_sym_LPAREN,
  [8408] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      anon_sym_fun,
  [8415] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(964), 1,
      anon_sym_COLON,
  [8422] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 1,
      anon_sym_COLON,
  [8429] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 1,
      anon_sym_RPAREN,
  [8436] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(970), 1,
      anon_sym_LPAREN,
  [8443] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 1,
      anon_sym_LPAREN,
  [8450] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
  [8457] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 1,
      ts_builtin_sym_end,
  [8464] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(978), 1,
      anon_sym_RPAREN,
  [8471] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 1,
      sym_identifier,
  [8478] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 1,
      anon_sym_COLON,
  [8485] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 1,
      sym_identifier,
  [8492] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(986), 1,
      anon_sym_COLON,
  [8499] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 1,
      sym_identifier,
  [8506] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 1,
      anon_sym_fun,
  [8513] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      sym_identifier,
  [8520] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(994), 1,
      anon_sym_const,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 100,
  [SMALL_STATE(4)] = 200,
  [SMALL_STATE(5)] = 300,
  [SMALL_STATE(6)] = 400,
  [SMALL_STATE(7)] = 500,
  [SMALL_STATE(8)] = 545,
  [SMALL_STATE(9)] = 590,
  [SMALL_STATE(10)] = 672,
  [SMALL_STATE(11)] = 754,
  [SMALL_STATE(12)] = 817,
  [SMALL_STATE(13)] = 877,
  [SMALL_STATE(14)] = 937,
  [SMALL_STATE(15)] = 989,
  [SMALL_STATE(16)] = 1046,
  [SMALL_STATE(17)] = 1103,
  [SMALL_STATE(18)] = 1160,
  [SMALL_STATE(19)] = 1217,
  [SMALL_STATE(20)] = 1274,
  [SMALL_STATE(21)] = 1331,
  [SMALL_STATE(22)] = 1388,
  [SMALL_STATE(23)] = 1445,
  [SMALL_STATE(24)] = 1502,
  [SMALL_STATE(25)] = 1559,
  [SMALL_STATE(26)] = 1616,
  [SMALL_STATE(27)] = 1673,
  [SMALL_STATE(28)] = 1730,
  [SMALL_STATE(29)] = 1787,
  [SMALL_STATE(30)] = 1844,
  [SMALL_STATE(31)] = 1901,
  [SMALL_STATE(32)] = 1958,
  [SMALL_STATE(33)] = 2015,
  [SMALL_STATE(34)] = 2072,
  [SMALL_STATE(35)] = 2129,
  [SMALL_STATE(36)] = 2186,
  [SMALL_STATE(37)] = 2243,
  [SMALL_STATE(38)] = 2300,
  [SMALL_STATE(39)] = 2357,
  [SMALL_STATE(40)] = 2419,
  [SMALL_STATE(41)] = 2481,
  [SMALL_STATE(42)] = 2543,
  [SMALL_STATE(43)] = 2586,
  [SMALL_STATE(44)] = 2644,
  [SMALL_STATE(45)] = 2702,
  [SMALL_STATE(46)] = 2742,
  [SMALL_STATE(47)] = 2800,
  [SMALL_STATE(48)] = 2837,
  [SMALL_STATE(49)] = 2874,
  [SMALL_STATE(50)] = 2905,
  [SMALL_STATE(51)] = 2936,
  [SMALL_STATE(52)] = 2967,
  [SMALL_STATE(53)] = 2998,
  [SMALL_STATE(54)] = 3029,
  [SMALL_STATE(55)] = 3062,
  [SMALL_STATE(56)] = 3093,
  [SMALL_STATE(57)] = 3124,
  [SMALL_STATE(58)] = 3155,
  [SMALL_STATE(59)] = 3186,
  [SMALL_STATE(60)] = 3217,
  [SMALL_STATE(61)] = 3248,
  [SMALL_STATE(62)] = 3279,
  [SMALL_STATE(63)] = 3310,
  [SMALL_STATE(64)] = 3341,
  [SMALL_STATE(65)] = 3372,
  [SMALL_STATE(66)] = 3403,
  [SMALL_STATE(67)] = 3434,
  [SMALL_STATE(68)] = 3465,
  [SMALL_STATE(69)] = 3496,
  [SMALL_STATE(70)] = 3527,
  [SMALL_STATE(71)] = 3558,
  [SMALL_STATE(72)] = 3589,
  [SMALL_STATE(73)] = 3620,
  [SMALL_STATE(74)] = 3651,
  [SMALL_STATE(75)] = 3682,
  [SMALL_STATE(76)] = 3713,
  [SMALL_STATE(77)] = 3744,
  [SMALL_STATE(78)] = 3792,
  [SMALL_STATE(79)] = 3824,
  [SMALL_STATE(80)] = 3860,
  [SMALL_STATE(81)] = 3898,
  [SMALL_STATE(82)] = 3940,
  [SMALL_STATE(83)] = 3970,
  [SMALL_STATE(84)] = 4014,
  [SMALL_STATE(85)] = 4046,
  [SMALL_STATE(86)] = 4092,
  [SMALL_STATE(87)] = 4140,
  [SMALL_STATE(88)] = 4188,
  [SMALL_STATE(89)] = 4235,
  [SMALL_STATE(90)] = 4282,
  [SMALL_STATE(91)] = 4329,
  [SMALL_STATE(92)] = 4376,
  [SMALL_STATE(93)] = 4423,
  [SMALL_STATE(94)] = 4470,
  [SMALL_STATE(95)] = 4517,
  [SMALL_STATE(96)] = 4564,
  [SMALL_STATE(97)] = 4611,
  [SMALL_STATE(98)] = 4658,
  [SMALL_STATE(99)] = 4705,
  [SMALL_STATE(100)] = 4752,
  [SMALL_STATE(101)] = 4777,
  [SMALL_STATE(102)] = 4824,
  [SMALL_STATE(103)] = 4871,
  [SMALL_STATE(104)] = 4896,
  [SMALL_STATE(105)] = 4943,
  [SMALL_STATE(106)] = 4990,
  [SMALL_STATE(107)] = 5037,
  [SMALL_STATE(108)] = 5061,
  [SMALL_STATE(109)] = 5085,
  [SMALL_STATE(110)] = 5109,
  [SMALL_STATE(111)] = 5133,
  [SMALL_STATE(112)] = 5157,
  [SMALL_STATE(113)] = 5181,
  [SMALL_STATE(114)] = 5205,
  [SMALL_STATE(115)] = 5229,
  [SMALL_STATE(116)] = 5253,
  [SMALL_STATE(117)] = 5277,
  [SMALL_STATE(118)] = 5301,
  [SMALL_STATE(119)] = 5325,
  [SMALL_STATE(120)] = 5349,
  [SMALL_STATE(121)] = 5373,
  [SMALL_STATE(122)] = 5397,
  [SMALL_STATE(123)] = 5421,
  [SMALL_STATE(124)] = 5445,
  [SMALL_STATE(125)] = 5469,
  [SMALL_STATE(126)] = 5493,
  [SMALL_STATE(127)] = 5517,
  [SMALL_STATE(128)] = 5541,
  [SMALL_STATE(129)] = 5565,
  [SMALL_STATE(130)] = 5589,
  [SMALL_STATE(131)] = 5613,
  [SMALL_STATE(132)] = 5637,
  [SMALL_STATE(133)] = 5661,
  [SMALL_STATE(134)] = 5685,
  [SMALL_STATE(135)] = 5709,
  [SMALL_STATE(136)] = 5733,
  [SMALL_STATE(137)] = 5757,
  [SMALL_STATE(138)] = 5781,
  [SMALL_STATE(139)] = 5805,
  [SMALL_STATE(140)] = 5829,
  [SMALL_STATE(141)] = 5853,
  [SMALL_STATE(142)] = 5877,
  [SMALL_STATE(143)] = 5901,
  [SMALL_STATE(144)] = 5924,
  [SMALL_STATE(145)] = 5947,
  [SMALL_STATE(146)] = 5970,
  [SMALL_STATE(147)] = 5993,
  [SMALL_STATE(148)] = 6016,
  [SMALL_STATE(149)] = 6039,
  [SMALL_STATE(150)] = 6062,
  [SMALL_STATE(151)] = 6085,
  [SMALL_STATE(152)] = 6108,
  [SMALL_STATE(153)] = 6131,
  [SMALL_STATE(154)] = 6154,
  [SMALL_STATE(155)] = 6177,
  [SMALL_STATE(156)] = 6200,
  [SMALL_STATE(157)] = 6223,
  [SMALL_STATE(158)] = 6246,
  [SMALL_STATE(159)] = 6269,
  [SMALL_STATE(160)] = 6292,
  [SMALL_STATE(161)] = 6315,
  [SMALL_STATE(162)] = 6338,
  [SMALL_STATE(163)] = 6361,
  [SMALL_STATE(164)] = 6384,
  [SMALL_STATE(165)] = 6407,
  [SMALL_STATE(166)] = 6427,
  [SMALL_STATE(167)] = 6449,
  [SMALL_STATE(168)] = 6469,
  [SMALL_STATE(169)] = 6488,
  [SMALL_STATE(170)] = 6507,
  [SMALL_STATE(171)] = 6526,
  [SMALL_STATE(172)] = 6545,
  [SMALL_STATE(173)] = 6564,
  [SMALL_STATE(174)] = 6583,
  [SMALL_STATE(175)] = 6602,
  [SMALL_STATE(176)] = 6621,
  [SMALL_STATE(177)] = 6636,
  [SMALL_STATE(178)] = 6655,
  [SMALL_STATE(179)] = 6674,
  [SMALL_STATE(180)] = 6691,
  [SMALL_STATE(181)] = 6708,
  [SMALL_STATE(182)] = 6727,
  [SMALL_STATE(183)] = 6744,
  [SMALL_STATE(184)] = 6763,
  [SMALL_STATE(185)] = 6782,
  [SMALL_STATE(186)] = 6797,
  [SMALL_STATE(187)] = 6816,
  [SMALL_STATE(188)] = 6835,
  [SMALL_STATE(189)] = 6847,
  [SMALL_STATE(190)] = 6859,
  [SMALL_STATE(191)] = 6871,
  [SMALL_STATE(192)] = 6883,
  [SMALL_STATE(193)] = 6897,
  [SMALL_STATE(194)] = 6909,
  [SMALL_STATE(195)] = 6921,
  [SMALL_STATE(196)] = 6933,
  [SMALL_STATE(197)] = 6948,
  [SMALL_STATE(198)] = 6965,
  [SMALL_STATE(199)] = 6982,
  [SMALL_STATE(200)] = 6997,
  [SMALL_STATE(201)] = 7012,
  [SMALL_STATE(202)] = 7028,
  [SMALL_STATE(203)] = 7044,
  [SMALL_STATE(204)] = 7060,
  [SMALL_STATE(205)] = 7076,
  [SMALL_STATE(206)] = 7092,
  [SMALL_STATE(207)] = 7102,
  [SMALL_STATE(208)] = 7118,
  [SMALL_STATE(209)] = 7134,
  [SMALL_STATE(210)] = 7148,
  [SMALL_STATE(211)] = 7162,
  [SMALL_STATE(212)] = 7176,
  [SMALL_STATE(213)] = 7190,
  [SMALL_STATE(214)] = 7206,
  [SMALL_STATE(215)] = 7220,
  [SMALL_STATE(216)] = 7236,
  [SMALL_STATE(217)] = 7250,
  [SMALL_STATE(218)] = 7264,
  [SMALL_STATE(219)] = 7277,
  [SMALL_STATE(220)] = 7290,
  [SMALL_STATE(221)] = 7301,
  [SMALL_STATE(222)] = 7314,
  [SMALL_STATE(223)] = 7327,
  [SMALL_STATE(224)] = 7336,
  [SMALL_STATE(225)] = 7349,
  [SMALL_STATE(226)] = 7358,
  [SMALL_STATE(227)] = 7371,
  [SMALL_STATE(228)] = 7384,
  [SMALL_STATE(229)] = 7397,
  [SMALL_STATE(230)] = 7410,
  [SMALL_STATE(231)] = 7423,
  [SMALL_STATE(232)] = 7436,
  [SMALL_STATE(233)] = 7449,
  [SMALL_STATE(234)] = 7462,
  [SMALL_STATE(235)] = 7475,
  [SMALL_STATE(236)] = 7488,
  [SMALL_STATE(237)] = 7501,
  [SMALL_STATE(238)] = 7514,
  [SMALL_STATE(239)] = 7527,
  [SMALL_STATE(240)] = 7536,
  [SMALL_STATE(241)] = 7549,
  [SMALL_STATE(242)] = 7562,
  [SMALL_STATE(243)] = 7575,
  [SMALL_STATE(244)] = 7588,
  [SMALL_STATE(245)] = 7601,
  [SMALL_STATE(246)] = 7610,
  [SMALL_STATE(247)] = 7620,
  [SMALL_STATE(248)] = 7630,
  [SMALL_STATE(249)] = 7640,
  [SMALL_STATE(250)] = 7650,
  [SMALL_STATE(251)] = 7660,
  [SMALL_STATE(252)] = 7670,
  [SMALL_STATE(253)] = 7680,
  [SMALL_STATE(254)] = 7690,
  [SMALL_STATE(255)] = 7700,
  [SMALL_STATE(256)] = 7710,
  [SMALL_STATE(257)] = 7720,
  [SMALL_STATE(258)] = 7730,
  [SMALL_STATE(259)] = 7740,
  [SMALL_STATE(260)] = 7750,
  [SMALL_STATE(261)] = 7760,
  [SMALL_STATE(262)] = 7770,
  [SMALL_STATE(263)] = 7780,
  [SMALL_STATE(264)] = 7790,
  [SMALL_STATE(265)] = 7800,
  [SMALL_STATE(266)] = 7808,
  [SMALL_STATE(267)] = 7818,
  [SMALL_STATE(268)] = 7828,
  [SMALL_STATE(269)] = 7838,
  [SMALL_STATE(270)] = 7846,
  [SMALL_STATE(271)] = 7856,
  [SMALL_STATE(272)] = 7866,
  [SMALL_STATE(273)] = 7876,
  [SMALL_STATE(274)] = 7884,
  [SMALL_STATE(275)] = 7894,
  [SMALL_STATE(276)] = 7904,
  [SMALL_STATE(277)] = 7914,
  [SMALL_STATE(278)] = 7924,
  [SMALL_STATE(279)] = 7934,
  [SMALL_STATE(280)] = 7942,
  [SMALL_STATE(281)] = 7952,
  [SMALL_STATE(282)] = 7962,
  [SMALL_STATE(283)] = 7972,
  [SMALL_STATE(284)] = 7982,
  [SMALL_STATE(285)] = 7992,
  [SMALL_STATE(286)] = 8002,
  [SMALL_STATE(287)] = 8012,
  [SMALL_STATE(288)] = 8020,
  [SMALL_STATE(289)] = 8030,
  [SMALL_STATE(290)] = 8037,
  [SMALL_STATE(291)] = 8044,
  [SMALL_STATE(292)] = 8051,
  [SMALL_STATE(293)] = 8058,
  [SMALL_STATE(294)] = 8065,
  [SMALL_STATE(295)] = 8072,
  [SMALL_STATE(296)] = 8079,
  [SMALL_STATE(297)] = 8086,
  [SMALL_STATE(298)] = 8093,
  [SMALL_STATE(299)] = 8100,
  [SMALL_STATE(300)] = 8107,
  [SMALL_STATE(301)] = 8114,
  [SMALL_STATE(302)] = 8121,
  [SMALL_STATE(303)] = 8128,
  [SMALL_STATE(304)] = 8135,
  [SMALL_STATE(305)] = 8142,
  [SMALL_STATE(306)] = 8149,
  [SMALL_STATE(307)] = 8156,
  [SMALL_STATE(308)] = 8163,
  [SMALL_STATE(309)] = 8170,
  [SMALL_STATE(310)] = 8177,
  [SMALL_STATE(311)] = 8184,
  [SMALL_STATE(312)] = 8191,
  [SMALL_STATE(313)] = 8198,
  [SMALL_STATE(314)] = 8205,
  [SMALL_STATE(315)] = 8212,
  [SMALL_STATE(316)] = 8219,
  [SMALL_STATE(317)] = 8226,
  [SMALL_STATE(318)] = 8233,
  [SMALL_STATE(319)] = 8240,
  [SMALL_STATE(320)] = 8247,
  [SMALL_STATE(321)] = 8254,
  [SMALL_STATE(322)] = 8261,
  [SMALL_STATE(323)] = 8268,
  [SMALL_STATE(324)] = 8275,
  [SMALL_STATE(325)] = 8282,
  [SMALL_STATE(326)] = 8289,
  [SMALL_STATE(327)] = 8296,
  [SMALL_STATE(328)] = 8303,
  [SMALL_STATE(329)] = 8310,
  [SMALL_STATE(330)] = 8317,
  [SMALL_STATE(331)] = 8324,
  [SMALL_STATE(332)] = 8331,
  [SMALL_STATE(333)] = 8338,
  [SMALL_STATE(334)] = 8345,
  [SMALL_STATE(335)] = 8352,
  [SMALL_STATE(336)] = 8359,
  [SMALL_STATE(337)] = 8366,
  [SMALL_STATE(338)] = 8373,
  [SMALL_STATE(339)] = 8380,
  [SMALL_STATE(340)] = 8387,
  [SMALL_STATE(341)] = 8394,
  [SMALL_STATE(342)] = 8401,
  [SMALL_STATE(343)] = 8408,
  [SMALL_STATE(344)] = 8415,
  [SMALL_STATE(345)] = 8422,
  [SMALL_STATE(346)] = 8429,
  [SMALL_STATE(347)] = 8436,
  [SMALL_STATE(348)] = 8443,
  [SMALL_STATE(349)] = 8450,
  [SMALL_STATE(350)] = 8457,
  [SMALL_STATE(351)] = 8464,
  [SMALL_STATE(352)] = 8471,
  [SMALL_STATE(353)] = 8478,
  [SMALL_STATE(354)] = 8485,
  [SMALL_STATE(355)] = 8492,
  [SMALL_STATE(356)] = 8499,
  [SMALL_STATE(357)] = 8506,
  [SMALL_STATE(358)] = 8513,
  [SMALL_STATE(359)] = 8520,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(326),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(256),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(320),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [69] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(14),
  [72] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(19),
  [75] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(3),
  [78] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_statement_repeat1, 2),
  [80] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(326),
  [83] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(12),
  [86] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(325),
  [89] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(324),
  [92] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(322),
  [95] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(256),
  [98] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(26),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(320),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(45),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(308),
  [110] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(53),
  [113] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(51),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(61),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_statement_repeat1, 2), SHIFT_REPEAT(61),
  [122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [126] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_statement, 3),
  [128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_statement, 3),
  [130] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_statement, 2),
  [132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_statement, 2),
  [134] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [136] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(186),
  [139] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(267),
  [142] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(336),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(168),
  [148] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(323),
  [151] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(304),
  [154] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(165),
  [157] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(319),
  [160] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(219),
  [163] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(303),
  [166] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(318),
  [169] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(349),
  [172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [174] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_expression, 1),
  [182] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__lvalue, 1),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__lvalue, 1),
  [190] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value_expression, 1), SHIFT(220),
  [193] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_expression, 1),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [207] = {.entry = {.count = 1, .reusable = false}}, SHIFT(282),
  [209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [215] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(296),
  [218] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(356),
  [221] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(168),
  [224] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(352),
  [227] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(165),
  [230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2),
  [232] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(282),
  [235] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(310),
  [238] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(342),
  [241] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(347),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [248] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_trait_body_repeat1, 2), SHIFT_REPEAT(296),
  [251] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_trait_body_repeat1, 2), SHIFT_REPEAT(356),
  [254] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_trait_body_repeat1, 2), SHIFT_REPEAT(168),
  [257] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_trait_body_repeat1, 2), SHIFT_REPEAT(352),
  [260] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_trait_body_repeat1, 2), SHIFT_REPEAT(165),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_trait_body_repeat1, 2),
  [265] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_trait_body_repeat1, 2), SHIFT_REPEAT(310),
  [268] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_trait_body_repeat1, 2), SHIFT_REPEAT(342),
  [271] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_trait_body_repeat1, 2), SHIFT_REPEAT(347),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_access_expression, 3, .production_id = 31),
  [278] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_access_expression, 3, .production_id = 31),
  [280] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 46),
  [282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 46),
  [284] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [286] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 5, .production_id = 47),
  [288] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 5, .production_id = 47),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2),
  [292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 2),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_argument_list, 4),
  [296] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_argument_list, 4),
  [298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [300] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [306] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call_expression, 4, .production_id = 40),
  [310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call_expression, 4, .production_id = 40),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_static_call_expression, 2, .production_id = 22),
  [314] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_static_call_expression, 2, .production_id = 22),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_argument_list, 3),
  [318] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_argument_list, 3),
  [320] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 2),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_argument_list, 2),
  [326] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_argument_list, 2),
  [328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_statement, 8, .production_id = 55),
  [330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_statement, 8, .production_id = 55),
  [332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_integer, 1),
  [334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_integer, 1),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 3),
  [338] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 3),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_initOf, 3, .production_id = 28),
  [342] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_initOf, 3, .production_id = 28),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_until_statement, 7, .production_id = 54),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_until_statement, 7, .production_id = 54),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_statement, 4, .production_id = 38),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 4, .production_id = 38),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_expression, 2, .production_id = 22),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_expression, 2, .production_id = 22),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 2),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_clause, 2),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_statement, 7, .production_id = 27),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_statement, 7, .production_id = 27),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_augmented_assignment_statement, 4, .production_id = 39),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_augmented_assignment_statement, 4, .production_id = 39),
  [368] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 3),
  [370] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 3),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [376] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 5, .production_id = 47),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 5, .production_id = 47),
  [380] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression_statement, 2),
  [382] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression_statement, 2),
  [384] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 51),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 51),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [390] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 4),
  [394] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 4),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 30),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [402] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [414] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 30),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_suffix_expression, 2, .production_id = 23),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_suffix_expression, 2, .production_id = 23),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 21),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 21),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 1, .production_id = 29),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [432] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_argument, 3, .production_id = 48),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract, 4, .production_id = 9),
  [470] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 5, .production_id = 15),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract, 3, .production_id = 4),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__static_function, 1, .production_id = 1),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constant, 7, .production_id = 27),
  [478] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait_body, 2),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait, 4, .production_id = 9),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message, 3, .production_id = 5),
  [484] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constant, 6, .production_id = 25),
  [486] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 3, .production_id = 4),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 3, .production_id = 3),
  [490] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract, 4, .production_id = 10),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primitive_statement, 3, .production_id = 2),
  [494] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait, 4, .production_id = 11),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 7, .production_id = 33),
  [498] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 7, .production_id = 34),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 4, .production_id = 6),
  [502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_native_function, 8, .production_id = 37),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constant, 5, .production_id = 13),
  [506] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 4, .production_id = 7),
  [508] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body, 2),
  [510] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message, 4, .production_id = 8),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 6, .production_id = 20),
  [514] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 6, .production_id = 19),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constant, 8, .production_id = 43),
  [518] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_native_function, 9, .production_id = 45),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_body, 2),
  [522] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body, 3),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait_body, 3),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_native_function, 11, .production_id = 53),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_native_function, 10, .production_id = 50),
  [530] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract, 5, .production_id = 16),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 5, .production_id = 14),
  [534] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_body, 3),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait, 3, .production_id = 4),
  [538] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait, 5, .production_id = 17),
  [540] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 5, .production_id = 14),
  [542] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 4, .production_id = 18),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 4, .production_id = 18),
  [546] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_init_function, 3, .production_id = 24),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_init_function, 3, .production_id = 24),
  [550] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constant, 5, .production_id = 13),
  [552] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 4, .production_id = 7),
  [554] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 4, .production_id = 6),
  [556] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 5, .production_id = 15),
  [558] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_receive_function, 4, .production_id = 32),
  [560] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_receive_function, 4, .production_id = 32),
  [562] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_external_function, 4, .production_id = 32),
  [564] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_external_function, 4, .production_id = 32),
  [566] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constant, 8, .production_id = 43),
  [568] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 7, .production_id = 34),
  [570] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 7, .production_id = 33),
  [572] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constant, 7, .production_id = 27),
  [574] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 7, .production_id = 52),
  [576] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 7, .production_id = 52),
  [578] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 5, .production_id = 41),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 5, .production_id = 41),
  [582] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_receive_function, 5, .production_id = 42),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_receive_function, 5, .production_id = 42),
  [586] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constant, 6, .production_id = 25),
  [588] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 6, .production_id = 49),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 6, .production_id = 49),
  [592] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bounced_function, 5, .production_id = 42),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bounced_function, 5, .production_id = 42),
  [596] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_external_function, 5, .production_id = 42),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_external_function, 5, .production_id = 42),
  [600] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 6, .production_id = 20),
  [602] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 6, .production_id = 19),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_attributes, 1),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [610] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_attributes_repeat1, 2), SHIFT_REPEAT(167),
  [613] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_attributes_repeat1, 2),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_constant_attributes_repeat1, 1),
  [617] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_constant_attributes_repeat1, 1), REDUCE(aux_sym_function_attributes_repeat1, 1),
  [620] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_attributes_repeat1, 1),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [628] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_type, 1),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_identifier, 2),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_func_identifier_repeat1, 2),
  [638] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_func_identifier_repeat1, 2), SHIFT_REPEAT(180),
  [641] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_identifier, 1),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [647] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__lvalue, 3),
  [649] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_type, 7, .production_id = 36),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_type, 8, .production_id = 44),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_type, 7, .production_id = 35),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_type, 6, .production_id = 26),
  [661] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_type, 2),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bounced_type, 4, .production_id = 12),
  [665] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_constant_attributes_repeat1, 2),
  [667] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_constant_attributes_repeat1, 2), SHIFT_REPEAT(196),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constant_attributes, 1),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [696] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tlb_serialization, 2, .production_id = 2),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [712] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_attributes, 1),
  [714] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_body_repeat1, 2), SHIFT_REPEAT(296),
  [717] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_body_repeat1, 2),
  [719] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_contract_attributes_repeat1, 2),
  [721] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_attributes_repeat1, 2), SHIFT_REPEAT(349),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [742] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 4),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait_list, 2),
  [754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_contract_attributes_repeat1, 4),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2),
  [758] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2), SHIFT_REPEAT(251),
  [761] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2),
  [763] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2), SHIFT_REPEAT(13),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [772] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instance_argument_list_repeat1, 2), SHIFT_REPEAT(274),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_instance_argument_list_repeat1, 2),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [789] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trait_list_repeat1, 2), SHIFT_REPEAT(313),
  [792] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_trait_list_repeat1, 2),
  [794] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait_list, 3),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 3),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [848] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 3, .production_id = 18),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [864] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message_value, 3),
  [866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [874] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [888] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [890] = {.entry = {.count = 1, .reusable = false}}, SHIFT(335),
  [892] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [896] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [902] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [906] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [908] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [912] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [926] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [934] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [976] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_tact(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
