#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 169
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 92
#define ALIAS_COUNT 0
#define TOKEN_COUNT 48
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 5
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 9

enum {
  sym_ident = 1,
  sym__whitespace = 2,
  sym_line_comment = 3,
  sym_block_comment = 4,
  sym_unit = 5,
  sym_star = 6,
  anon_sym_u8 = 7,
  anon_sym_u16 = 8,
  anon_sym_u32 = 9,
  anon_sym_u64 = 10,
  anon_sym_s8 = 11,
  anon_sym_s16 = 12,
  anon_sym_s32 = 13,
  anon_sym_s64 = 14,
  anon_sym_float32 = 15,
  anon_sym_float64 = 16,
  anon_sym_char = 17,
  anon_sym_bool = 18,
  anon_sym_string = 19,
  anon_sym_COLON = 20,
  anon_sym_LBRACE = 21,
  anon_sym_COMMA = 22,
  anon_sym_RBRACE = 23,
  anon_sym_LPAREN = 24,
  anon_sym_RPAREN = 25,
  anon_sym_LT = 26,
  anon_sym_GT = 27,
  anon_sym_option = 28,
  anon_sym_list = 29,
  anon_sym_result = 30,
  anon_sym_tuple = 31,
  anon_sym_future = 32,
  anon_sym_stream = 33,
  anon_sym_as = 34,
  anon_sym_use = 35,
  anon_sym_from = 36,
  anon_sym_type = 37,
  anon_sym_EQ = 38,
  anon_sym_record = 39,
  anon_sym_flags = 40,
  anon_sym_variant = 41,
  anon_sym_enum = 42,
  anon_sym_union = 43,
  anon_sym_func = 44,
  anon_sym_DASH_GT = 45,
  anon_sym_static = 46,
  anon_sym_resource = 47,
  sym_file = 48,
  sym_ty = 49,
  sym_item = 50,
  sym_named_ty = 51,
  sym_fields = 52,
  sym_args = 53,
  sym_tp1 = 54,
  sym_tp2 = 55,
  sym_tps = 56,
  sym_option = 57,
  sym_list = 58,
  sym_result = 59,
  sym_tuple = 60,
  sym_future = 61,
  sym_stream = 62,
  sym_use_item = 63,
  sym_use_items = 64,
  sym_item_use = 65,
  sym_item_type = 66,
  sym_item_record = 67,
  sym_flags = 68,
  sym_item_flags = 69,
  sym_variant_payload = 70,
  sym_variant_item = 71,
  sym_variant_items = 72,
  sym_item_variant = 73,
  sym_enum_items = 74,
  sym_item_enum = 75,
  sym_union_items = 76,
  sym_item_union = 77,
  sym__func = 78,
  sym_input = 79,
  sym_output = 80,
  sym_item_func = 81,
  sym_method = 82,
  sym_resource_items = 83,
  sym_item_resource = 84,
  aux_sym_file_repeat1 = 85,
  aux_sym_fields_repeat1 = 86,
  aux_sym_tps_repeat1 = 87,
  aux_sym_use_items_repeat1 = 88,
  aux_sym_flags_repeat1 = 89,
  aux_sym_variant_items_repeat1 = 90,
  aux_sym_resource_items_repeat1 = 91,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_ident] = "ident",
  [sym__whitespace] = "_whitespace",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_unit] = "unit",
  [sym_star] = "star",
  [anon_sym_u8] = "u8",
  [anon_sym_u16] = "u16",
  [anon_sym_u32] = "u32",
  [anon_sym_u64] = "u64",
  [anon_sym_s8] = "s8",
  [anon_sym_s16] = "s16",
  [anon_sym_s32] = "s32",
  [anon_sym_s64] = "s64",
  [anon_sym_float32] = "float32",
  [anon_sym_float64] = "float64",
  [anon_sym_char] = "char",
  [anon_sym_bool] = "bool",
  [anon_sym_string] = "string",
  [anon_sym_COLON] = ":",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_option] = "option",
  [anon_sym_list] = "list",
  [anon_sym_result] = "result",
  [anon_sym_tuple] = "tuple",
  [anon_sym_future] = "future",
  [anon_sym_stream] = "stream",
  [anon_sym_as] = "as",
  [anon_sym_use] = "use",
  [anon_sym_from] = "from",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_record] = "record",
  [anon_sym_flags] = "flags",
  [anon_sym_variant] = "variant",
  [anon_sym_enum] = "enum",
  [anon_sym_union] = "union",
  [anon_sym_func] = "func",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_static] = "static",
  [anon_sym_resource] = "resource",
  [sym_file] = "file",
  [sym_ty] = "ty",
  [sym_item] = "item",
  [sym_named_ty] = "named_ty",
  [sym_fields] = "fields",
  [sym_args] = "args",
  [sym_tp1] = "tp1",
  [sym_tp2] = "tp2",
  [sym_tps] = "tps",
  [sym_option] = "option",
  [sym_list] = "list",
  [sym_result] = "result",
  [sym_tuple] = "tuple",
  [sym_future] = "future",
  [sym_stream] = "stream",
  [sym_use_item] = "use_item",
  [sym_use_items] = "use_items",
  [sym_item_use] = "item_use",
  [sym_item_type] = "item_type",
  [sym_item_record] = "item_record",
  [sym_flags] = "flags",
  [sym_item_flags] = "item_flags",
  [sym_variant_payload] = "variant_payload",
  [sym_variant_item] = "variant_item",
  [sym_variant_items] = "variant_items",
  [sym_item_variant] = "item_variant",
  [sym_enum_items] = "enum_items",
  [sym_item_enum] = "item_enum",
  [sym_union_items] = "union_items",
  [sym_item_union] = "item_union",
  [sym__func] = "_func",
  [sym_input] = "input",
  [sym_output] = "output",
  [sym_item_func] = "item_func",
  [sym_method] = "method",
  [sym_resource_items] = "resource_items",
  [sym_item_resource] = "item_resource",
  [aux_sym_file_repeat1] = "file_repeat1",
  [aux_sym_fields_repeat1] = "fields_repeat1",
  [aux_sym_tps_repeat1] = "tps_repeat1",
  [aux_sym_use_items_repeat1] = "use_items_repeat1",
  [aux_sym_flags_repeat1] = "flags_repeat1",
  [aux_sym_variant_items_repeat1] = "variant_items_repeat1",
  [aux_sym_resource_items_repeat1] = "resource_items_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_ident] = sym_ident,
  [sym__whitespace] = sym__whitespace,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_unit] = sym_unit,
  [sym_star] = sym_star,
  [anon_sym_u8] = anon_sym_u8,
  [anon_sym_u16] = anon_sym_u16,
  [anon_sym_u32] = anon_sym_u32,
  [anon_sym_u64] = anon_sym_u64,
  [anon_sym_s8] = anon_sym_s8,
  [anon_sym_s16] = anon_sym_s16,
  [anon_sym_s32] = anon_sym_s32,
  [anon_sym_s64] = anon_sym_s64,
  [anon_sym_float32] = anon_sym_float32,
  [anon_sym_float64] = anon_sym_float64,
  [anon_sym_char] = anon_sym_char,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_option] = anon_sym_option,
  [anon_sym_list] = anon_sym_list,
  [anon_sym_result] = anon_sym_result,
  [anon_sym_tuple] = anon_sym_tuple,
  [anon_sym_future] = anon_sym_future,
  [anon_sym_stream] = anon_sym_stream,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_record] = anon_sym_record,
  [anon_sym_flags] = anon_sym_flags,
  [anon_sym_variant] = anon_sym_variant,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_func] = anon_sym_func,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_resource] = anon_sym_resource,
  [sym_file] = sym_file,
  [sym_ty] = sym_ty,
  [sym_item] = sym_item,
  [sym_named_ty] = sym_named_ty,
  [sym_fields] = sym_fields,
  [sym_args] = sym_args,
  [sym_tp1] = sym_tp1,
  [sym_tp2] = sym_tp2,
  [sym_tps] = sym_tps,
  [sym_option] = sym_option,
  [sym_list] = sym_list,
  [sym_result] = sym_result,
  [sym_tuple] = sym_tuple,
  [sym_future] = sym_future,
  [sym_stream] = sym_stream,
  [sym_use_item] = sym_use_item,
  [sym_use_items] = sym_use_items,
  [sym_item_use] = sym_item_use,
  [sym_item_type] = sym_item_type,
  [sym_item_record] = sym_item_record,
  [sym_flags] = sym_flags,
  [sym_item_flags] = sym_item_flags,
  [sym_variant_payload] = sym_variant_payload,
  [sym_variant_item] = sym_variant_item,
  [sym_variant_items] = sym_variant_items,
  [sym_item_variant] = sym_item_variant,
  [sym_enum_items] = sym_enum_items,
  [sym_item_enum] = sym_item_enum,
  [sym_union_items] = sym_union_items,
  [sym_item_union] = sym_item_union,
  [sym__func] = sym__func,
  [sym_input] = sym_input,
  [sym_output] = sym_output,
  [sym_item_func] = sym_item_func,
  [sym_method] = sym_method,
  [sym_resource_items] = sym_resource_items,
  [sym_item_resource] = sym_item_resource,
  [aux_sym_file_repeat1] = aux_sym_file_repeat1,
  [aux_sym_fields_repeat1] = aux_sym_fields_repeat1,
  [aux_sym_tps_repeat1] = aux_sym_tps_repeat1,
  [aux_sym_use_items_repeat1] = aux_sym_use_items_repeat1,
  [aux_sym_flags_repeat1] = aux_sym_flags_repeat1,
  [aux_sym_variant_items_repeat1] = aux_sym_variant_items_repeat1,
  [aux_sym_resource_items_repeat1] = aux_sym_resource_items_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_ident] = {
    .visible = true,
    .named = true,
  },
  [sym__whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_s8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_s16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_s32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_s64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_char] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_option] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_list] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_result] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tuple] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_future] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_stream] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_record] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_flags] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_variant] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_resource] = {
    .visible = true,
    .named = false,
  },
  [sym_file] = {
    .visible = true,
    .named = true,
  },
  [sym_ty] = {
    .visible = true,
    .named = true,
  },
  [sym_item] = {
    .visible = true,
    .named = true,
  },
  [sym_named_ty] = {
    .visible = true,
    .named = true,
  },
  [sym_fields] = {
    .visible = true,
    .named = true,
  },
  [sym_args] = {
    .visible = true,
    .named = true,
  },
  [sym_tp1] = {
    .visible = true,
    .named = true,
  },
  [sym_tp2] = {
    .visible = true,
    .named = true,
  },
  [sym_tps] = {
    .visible = true,
    .named = true,
  },
  [sym_option] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_result] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_future] = {
    .visible = true,
    .named = true,
  },
  [sym_stream] = {
    .visible = true,
    .named = true,
  },
  [sym_use_item] = {
    .visible = true,
    .named = true,
  },
  [sym_use_items] = {
    .visible = true,
    .named = true,
  },
  [sym_item_use] = {
    .visible = true,
    .named = true,
  },
  [sym_item_type] = {
    .visible = true,
    .named = true,
  },
  [sym_item_record] = {
    .visible = true,
    .named = true,
  },
  [sym_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_item_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_variant_payload] = {
    .visible = true,
    .named = true,
  },
  [sym_variant_item] = {
    .visible = true,
    .named = true,
  },
  [sym_variant_items] = {
    .visible = true,
    .named = true,
  },
  [sym_item_variant] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_items] = {
    .visible = true,
    .named = true,
  },
  [sym_item_enum] = {
    .visible = true,
    .named = true,
  },
  [sym_union_items] = {
    .visible = true,
    .named = true,
  },
  [sym_item_union] = {
    .visible = true,
    .named = true,
  },
  [sym__func] = {
    .visible = false,
    .named = true,
  },
  [sym_input] = {
    .visible = true,
    .named = true,
  },
  [sym_output] = {
    .visible = true,
    .named = true,
  },
  [sym_item_func] = {
    .visible = true,
    .named = true,
  },
  [sym_method] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_items] = {
    .visible = true,
    .named = true,
  },
  [sym_item_resource] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fields_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tps_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_items_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_flags_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variant_items_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_resource_items_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_from = 1,
  field_name = 2,
  field_origin = 3,
  field_tag = 4,
  field_ty = 5,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_from] = "from",
  [field_name] = "name",
  [field_origin] = "origin",
  [field_tag] = "tag",
  [field_ty] = "ty",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 2},
  [7] = {.index = 7, .length = 1},
  [8] = {.index = 8, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0, .inherited = true},
  [1] =
    {field_name, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_from, 3},
  [4] =
    {field_tag, 0},
  [5] =
    {field_name, 2},
    {field_origin, 0},
  [7] =
    {field_name, 1, .inherited = true},
  [8] =
    {field_name, 0},
    {field_ty, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(7);
      if (lookahead == '%') ADVANCE(6);
      if (lookahead == '(') ADVANCE(18);
      if (lookahead == ')') ADVANCE(19);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == ',') ADVANCE(16);
      if (lookahead == '-') ADVANCE(5);
      if (lookahead == '/') ADVANCE(2);
      if (lookahead == ':') ADVANCE(14);
      if (lookahead == '<') ADVANCE(20);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(21);
      if (lookahead == '_') ADVANCE(12);
      if (lookahead == '{') ADVANCE(15);
      if (lookahead == '}') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(8);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(11);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(9);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '*') ADVANCE(3);
      if (lookahead == '/') ADVANCE(1);
      END_STATE();
    case 3:
      if (lookahead == '*') ADVANCE(4);
      if (lookahead != 0) ADVANCE(3);
      END_STATE();
    case 4:
      if (lookahead == '/') ADVANCE(10);
      if (lookahead != 0) ADVANCE(3);
      END_STATE();
    case 5:
      if (lookahead == '>') ADVANCE(23);
      END_STATE();
    case 6:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(11);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(sym__whitespace);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(sym_line_comment);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(6);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(11);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(sym_unit);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(sym_star);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'o') ADVANCE(7);
      if (lookahead == 'r') ADVANCE(8);
      if (lookahead == 's') ADVANCE(9);
      if (lookahead == 't') ADVANCE(10);
      if (lookahead == 'u') ADVANCE(11);
      if (lookahead == 'v') ADVANCE(12);
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(13);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(14);
      END_STATE();
    case 3:
      if (lookahead == 'h') ADVANCE(15);
      END_STATE();
    case 4:
      if (lookahead == 'n') ADVANCE(16);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 'u') ADVANCE(19);
      END_STATE();
    case 6:
      if (lookahead == 'i') ADVANCE(20);
      END_STATE();
    case 7:
      if (lookahead == 'p') ADVANCE(21);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(22);
      END_STATE();
    case 9:
      if (lookahead == '1') ADVANCE(23);
      if (lookahead == '3') ADVANCE(24);
      if (lookahead == '6') ADVANCE(25);
      if (lookahead == '8') ADVANCE(26);
      if (lookahead == 't') ADVANCE(27);
      END_STATE();
    case 10:
      if (lookahead == 'u') ADVANCE(28);
      if (lookahead == 'y') ADVANCE(29);
      END_STATE();
    case 11:
      if (lookahead == '1') ADVANCE(30);
      if (lookahead == '3') ADVANCE(31);
      if (lookahead == '6') ADVANCE(32);
      if (lookahead == '8') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 's') ADVANCE(35);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(36);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 14:
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(38);
      END_STATE();
    case 16:
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(40);
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 18:
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 21:
      if (lookahead == 't') ADVANCE(46);
      END_STATE();
    case 22:
      if (lookahead == 'c') ADVANCE(47);
      if (lookahead == 's') ADVANCE(48);
      END_STATE();
    case 23:
      if (lookahead == '6') ADVANCE(49);
      END_STATE();
    case 24:
      if (lookahead == '2') ADVANCE(50);
      END_STATE();
    case 25:
      if (lookahead == '4') ADVANCE(51);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_s8);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'r') ADVANCE(53);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(54);
      END_STATE();
    case 29:
      if (lookahead == 'p') ADVANCE(55);
      END_STATE();
    case 30:
      if (lookahead == '6') ADVANCE(56);
      END_STATE();
    case 31:
      if (lookahead == '2') ADVANCE(57);
      END_STATE();
    case 32:
      if (lookahead == '4') ADVANCE(58);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_u8);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(59);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 36:
      if (lookahead == 'r') ADVANCE(61);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(62);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(63);
      END_STATE();
    case 39:
      if (lookahead == 'm') ADVANCE(64);
      END_STATE();
    case 40:
      if (lookahead == 'g') ADVANCE(65);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(66);
      END_STATE();
    case 42:
      if (lookahead == 'm') ADVANCE(67);
      END_STATE();
    case 43:
      if (lookahead == 'c') ADVANCE(68);
      END_STATE();
    case 44:
      if (lookahead == 'u') ADVANCE(69);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(71);
      END_STATE();
    case 47:
      if (lookahead == 'o') ADVANCE(72);
      END_STATE();
    case 48:
      if (lookahead == 'o') ADVANCE(73);
      if (lookahead == 'u') ADVANCE(74);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_s16);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_s32);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_s64);
      END_STATE();
    case 52:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(76);
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(78);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_u16);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_u32);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_u64);
      END_STATE();
    case 59:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(81);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_char);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 65:
      if (lookahead == 's') ADVANCE(82);
      END_STATE();
    case 66:
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_func);
      END_STATE();
    case 69:
      if (lookahead == 'r') ADVANCE(84);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_list);
      END_STATE();
    case 71:
      if (lookahead == 'o') ADVANCE(85);
      END_STATE();
    case 72:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 73:
      if (lookahead == 'u') ADVANCE(87);
      END_STATE();
    case 74:
      if (lookahead == 'l') ADVANCE(88);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 76:
      if (lookahead == 'a') ADVANCE(90);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(91);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(94);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_flags);
      END_STATE();
    case 83:
      if (lookahead == '3') ADVANCE(95);
      if (lookahead == '6') ADVANCE(96);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 85:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 86:
      if (lookahead == 'd') ADVANCE(99);
      END_STATE();
    case 87:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 90:
      if (lookahead == 'm') ADVANCE(103);
      END_STATE();
    case 91:
      if (lookahead == 'g') ADVANCE(104);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_tuple);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 94:
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 95:
      if (lookahead == '2') ADVANCE(106);
      END_STATE();
    case 96:
      if (lookahead == '4') ADVANCE(107);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_future);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_option);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_record);
      END_STATE();
    case 100:
      if (lookahead == 'c') ADVANCE(108);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_result);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_stream);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(109);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_float32);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_float64);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_variant);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_resource);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
  [74] = {.lex_state = 0},
  [75] = {.lex_state = 0},
  [76] = {.lex_state = 0},
  [77] = {.lex_state = 0},
  [78] = {.lex_state = 0},
  [79] = {.lex_state = 0},
  [80] = {.lex_state = 0},
  [81] = {.lex_state = 0},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 0},
  [85] = {.lex_state = 0},
  [86] = {.lex_state = 0},
  [87] = {.lex_state = 0},
  [88] = {.lex_state = 0},
  [89] = {.lex_state = 0},
  [90] = {.lex_state = 0},
  [91] = {.lex_state = 0},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 0},
  [95] = {.lex_state = 0},
  [96] = {.lex_state = 0},
  [97] = {.lex_state = 0},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 0},
  [100] = {.lex_state = 0},
  [101] = {.lex_state = 0},
  [102] = {.lex_state = 0},
  [103] = {.lex_state = 0},
  [104] = {.lex_state = 0},
  [105] = {.lex_state = 0},
  [106] = {.lex_state = 0},
  [107] = {.lex_state = 0},
  [108] = {.lex_state = 0},
  [109] = {.lex_state = 0},
  [110] = {.lex_state = 0},
  [111] = {.lex_state = 0},
  [112] = {.lex_state = 0},
  [113] = {.lex_state = 0},
  [114] = {.lex_state = 0},
  [115] = {.lex_state = 0},
  [116] = {.lex_state = 0},
  [117] = {.lex_state = 0},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 0},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 0},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 0},
  [124] = {.lex_state = 0},
  [125] = {.lex_state = 0},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 0},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 0},
  [133] = {.lex_state = 0},
  [134] = {.lex_state = 0},
  [135] = {.lex_state = 0},
  [136] = {.lex_state = 0},
  [137] = {.lex_state = 0},
  [138] = {.lex_state = 0},
  [139] = {.lex_state = 0},
  [140] = {.lex_state = 0},
  [141] = {.lex_state = 0},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 0},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 0},
  [150] = {.lex_state = 0},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 0},
  [154] = {.lex_state = 0},
  [155] = {.lex_state = 0},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 0},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_ident] = ACTIONS(1),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_unit] = ACTIONS(1),
    [sym_star] = ACTIONS(1),
    [anon_sym_u8] = ACTIONS(1),
    [anon_sym_u16] = ACTIONS(1),
    [anon_sym_u32] = ACTIONS(1),
    [anon_sym_u64] = ACTIONS(1),
    [anon_sym_s8] = ACTIONS(1),
    [anon_sym_s16] = ACTIONS(1),
    [anon_sym_s32] = ACTIONS(1),
    [anon_sym_s64] = ACTIONS(1),
    [anon_sym_float32] = ACTIONS(1),
    [anon_sym_float64] = ACTIONS(1),
    [anon_sym_char] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_option] = ACTIONS(1),
    [anon_sym_list] = ACTIONS(1),
    [anon_sym_result] = ACTIONS(1),
    [anon_sym_tuple] = ACTIONS(1),
    [anon_sym_future] = ACTIONS(1),
    [anon_sym_stream] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_record] = ACTIONS(1),
    [anon_sym_flags] = ACTIONS(1),
    [anon_sym_variant] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_func] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_resource] = ACTIONS(1),
  },
  [1] = {
    [sym_file] = STATE(143),
    [sym_item] = STATE(16),
    [sym_item_use] = STATE(53),
    [sym_item_type] = STATE(53),
    [sym_item_record] = STATE(53),
    [sym_item_flags] = STATE(53),
    [sym_item_variant] = STATE(53),
    [sym_item_enum] = STATE(53),
    [sym_item_union] = STATE(53),
    [sym__func] = STATE(55),
    [sym_item_func] = STATE(53),
    [sym_item_resource] = STATE(53),
    [aux_sym_file_repeat1] = STATE(16),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_ident] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_use] = ACTIONS(9),
    [anon_sym_type] = ACTIONS(11),
    [anon_sym_record] = ACTIONS(13),
    [anon_sym_flags] = ACTIONS(15),
    [anon_sym_variant] = ACTIONS(17),
    [anon_sym_enum] = ACTIONS(19),
    [anon_sym_union] = ACTIONS(21),
    [anon_sym_resource] = ACTIONS(23),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 12,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    STATE(40), 1,
      sym_output,
    STATE(39), 2,
      sym_ty,
      sym_args,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [58] = 11,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    ACTIONS(41), 1,
      anon_sym_GT,
    STATE(94), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [112] = 11,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    ACTIONS(43), 1,
      anon_sym_GT,
    STATE(94), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [166] = 11,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    ACTIONS(45), 1,
      anon_sym_RBRACE,
    STATE(106), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [220] = 11,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    ACTIONS(47), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [274] = 11,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    ACTIONS(49), 1,
      sym_unit,
    STATE(123), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [328] = 11,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    ACTIONS(51), 1,
      anon_sym_RBRACE,
    STATE(94), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [382] = 10,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    STATE(108), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [433] = 10,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    STATE(159), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [484] = 10,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    STATE(94), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [535] = 10,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    STATE(164), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [586] = 10,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    STATE(62), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [637] = 10,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    STATE(115), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [688] = 10,
    ACTIONS(29), 1,
      anon_sym_option,
    ACTIONS(31), 1,
      anon_sym_list,
    ACTIONS(33), 1,
      anon_sym_result,
    ACTIONS(35), 1,
      anon_sym_tuple,
    ACTIONS(37), 1,
      anon_sym_future,
    ACTIONS(39), 1,
      anon_sym_stream,
    STATE(157), 1,
      sym_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(30), 6,
      sym_option,
      sym_list,
      sym_result,
      sym_tuple,
      sym_future,
      sym_stream,
    ACTIONS(25), 14,
      sym_ident,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_s8,
      anon_sym_s16,
      anon_sym_s32,
      anon_sym_s64,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_char,
      anon_sym_bool,
      anon_sym_string,
  [739] = 14,
    ACTIONS(7), 1,
      sym_ident,
    ACTIONS(9), 1,
      anon_sym_use,
    ACTIONS(11), 1,
      anon_sym_type,
    ACTIONS(13), 1,
      anon_sym_record,
    ACTIONS(15), 1,
      anon_sym_flags,
    ACTIONS(17), 1,
      anon_sym_variant,
    ACTIONS(19), 1,
      anon_sym_enum,
    ACTIONS(21), 1,
      anon_sym_union,
    ACTIONS(23), 1,
      anon_sym_resource,
    ACTIONS(53), 1,
      ts_builtin_sym_end,
    STATE(55), 1,
      sym__func,
    STATE(17), 2,
      sym_item,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(53), 9,
      sym_item_use,
      sym_item_type,
      sym_item_record,
      sym_item_flags,
      sym_item_variant,
      sym_item_enum,
      sym_item_union,
      sym_item_func,
      sym_item_resource,
  [793] = 14,
    ACTIONS(55), 1,
      ts_builtin_sym_end,
    ACTIONS(57), 1,
      sym_ident,
    ACTIONS(60), 1,
      anon_sym_use,
    ACTIONS(63), 1,
      anon_sym_type,
    ACTIONS(66), 1,
      anon_sym_record,
    ACTIONS(69), 1,
      anon_sym_flags,
    ACTIONS(72), 1,
      anon_sym_variant,
    ACTIONS(75), 1,
      anon_sym_enum,
    ACTIONS(78), 1,
      anon_sym_union,
    ACTIONS(81), 1,
      anon_sym_resource,
    STATE(55), 1,
      sym__func,
    STATE(17), 2,
      sym_item,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    STATE(53), 9,
      sym_item_use,
      sym_item_type,
      sym_item_record,
      sym_item_flags,
      sym_item_variant,
      sym_item_enum,
      sym_item_union,
      sym_item_func,
      sym_item_resource,
  [847] = 5,
    ACTIONS(88), 1,
      anon_sym_LT,
    STATE(26), 1,
      sym_tp2,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(84), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(86), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [878] = 5,
    ACTIONS(88), 1,
      anon_sym_LT,
    STATE(22), 1,
      sym_tp2,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(90), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(92), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [909] = 5,
    ACTIONS(98), 1,
      anon_sym_LT,
    STATE(23), 1,
      sym_tp1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(94), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(96), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [940] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(100), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(102), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [965] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(104), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(106), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [990] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(108), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(110), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1015] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(112), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(114), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1040] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(116), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(118), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1065] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(120), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(122), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1090] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(124), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(126), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1115] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(128), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(130), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1140] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(132), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(134), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1165] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(136), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(138), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1190] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(140), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(142), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1215] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(144), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(146), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1240] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(148), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_GT,
    ACTIONS(150), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1265] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(152), 3,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
    ACTIONS(154), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1288] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(156), 3,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
    ACTIONS(158), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1311] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(160), 3,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
    ACTIONS(162), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1334] = 3,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(164), 3,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
    ACTIONS(166), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1357] = 5,
    ACTIONS(168), 1,
      ts_builtin_sym_end,
    ACTIONS(172), 1,
      anon_sym_LBRACE,
    STATE(41), 1,
      sym_resource_items,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(170), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1383] = 3,
    ACTIONS(174), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(176), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1405] = 3,
    ACTIONS(178), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(180), 10,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_static,
      anon_sym_resource,
  [1427] = 3,
    ACTIONS(182), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(184), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1447] = 3,
    ACTIONS(186), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(188), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1467] = 3,
    ACTIONS(190), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(192), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1487] = 3,
    ACTIONS(194), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(196), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1507] = 3,
    ACTIONS(198), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(200), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1527] = 3,
    ACTIONS(202), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(204), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1547] = 3,
    ACTIONS(206), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(208), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1567] = 3,
    ACTIONS(210), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(212), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1587] = 3,
    ACTIONS(214), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(216), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1607] = 3,
    ACTIONS(218), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(220), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1627] = 3,
    ACTIONS(222), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(224), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1647] = 3,
    ACTIONS(226), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(228), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1667] = 3,
    ACTIONS(230), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(232), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1687] = 3,
    ACTIONS(234), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(236), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1707] = 3,
    ACTIONS(238), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(240), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1727] = 3,
    ACTIONS(242), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(244), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1747] = 3,
    ACTIONS(246), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(248), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1767] = 3,
    ACTIONS(250), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(252), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1787] = 3,
    ACTIONS(254), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(256), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1807] = 3,
    ACTIONS(258), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(260), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1827] = 3,
    ACTIONS(262), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(264), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1847] = 3,
    ACTIONS(266), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(268), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1867] = 3,
    ACTIONS(270), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(272), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1887] = 3,
    ACTIONS(274), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(276), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1907] = 3,
    ACTIONS(278), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(280), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1927] = 3,
    ACTIONS(282), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(284), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1947] = 3,
    ACTIONS(286), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(288), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1967] = 3,
    ACTIONS(290), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(292), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [1987] = 3,
    ACTIONS(294), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(296), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [2007] = 3,
    ACTIONS(298), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(300), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [2027] = 3,
    ACTIONS(302), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(304), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [2047] = 3,
    ACTIONS(306), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(308), 9,
      sym_ident,
      anon_sym_use,
      anon_sym_type,
      anon_sym_record,
      anon_sym_flags,
      anon_sym_variant,
      anon_sym_enum,
      anon_sym_union,
      anon_sym_resource,
  [2067] = 6,
    ACTIONS(310), 1,
      sym_ident,
    ACTIONS(313), 1,
      anon_sym_RBRACE,
    ACTIONS(315), 1,
      anon_sym_static,
    STATE(90), 1,
      sym__func,
    STATE(73), 2,
      sym_method,
      aux_sym_resource_items_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2089] = 6,
    ACTIONS(7), 1,
      sym_ident,
    ACTIONS(318), 1,
      anon_sym_RBRACE,
    ACTIONS(320), 1,
      anon_sym_static,
    STATE(90), 1,
      sym__func,
    STATE(75), 2,
      sym_method,
      aux_sym_resource_items_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2111] = 6,
    ACTIONS(7), 1,
      sym_ident,
    ACTIONS(320), 1,
      anon_sym_static,
    ACTIONS(322), 1,
      anon_sym_RBRACE,
    STATE(90), 1,
      sym__func,
    STATE(73), 2,
      sym_method,
      aux_sym_resource_items_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2133] = 4,
    ACTIONS(326), 1,
      anon_sym_LPAREN,
    STATE(133), 1,
      sym_variant_payload,
    ACTIONS(324), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2149] = 4,
    ACTIONS(328), 1,
      anon_sym_COMMA,
    STATE(77), 1,
      aux_sym_fields_repeat1,
    ACTIONS(331), 2,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2165] = 4,
    ACTIONS(333), 1,
      anon_sym_COMMA,
    STATE(78), 1,
      aux_sym_tps_repeat1,
    ACTIONS(336), 2,
      anon_sym_RBRACE,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2181] = 4,
    ACTIONS(338), 1,
      anon_sym_COMMA,
    ACTIONS(340), 1,
      anon_sym_RBRACE,
    STATE(98), 1,
      aux_sym_variant_items_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2196] = 4,
    ACTIONS(342), 1,
      sym_ident,
    ACTIONS(344), 1,
      anon_sym_RBRACE,
    STATE(129), 1,
      sym_use_item,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2211] = 4,
    ACTIONS(346), 1,
      anon_sym_COMMA,
    ACTIONS(348), 1,
      anon_sym_RPAREN,
    STATE(116), 1,
      aux_sym_fields_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2226] = 4,
    ACTIONS(350), 1,
      sym_star,
    ACTIONS(352), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_use_items,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2241] = 4,
    ACTIONS(354), 1,
      sym_ident,
    ACTIONS(356), 1,
      anon_sym_RBRACE,
    STATE(112), 1,
      sym_variant_item,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2256] = 4,
    ACTIONS(358), 1,
      sym_ident,
    ACTIONS(360), 1,
      anon_sym_RPAREN,
    STATE(81), 1,
      sym_named_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2271] = 4,
    ACTIONS(342), 1,
      sym_ident,
    ACTIONS(362), 1,
      anon_sym_RBRACE,
    STATE(129), 1,
      sym_use_item,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2286] = 4,
    ACTIONS(364), 1,
      anon_sym_COMMA,
    ACTIONS(367), 1,
      anon_sym_RBRACE,
    STATE(86), 1,
      aux_sym_use_items_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2301] = 4,
    ACTIONS(43), 1,
      anon_sym_GT,
    ACTIONS(369), 1,
      anon_sym_COMMA,
    STATE(78), 1,
      aux_sym_tps_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2316] = 4,
    ACTIONS(358), 1,
      sym_ident,
    ACTIONS(371), 1,
      anon_sym_RBRACE,
    STATE(105), 1,
      sym_named_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2331] = 4,
    ACTIONS(373), 1,
      anon_sym_COMMA,
    ACTIONS(375), 1,
      anon_sym_RBRACE,
    STATE(95), 1,
      aux_sym_use_items_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2346] = 3,
    ACTIONS(379), 1,
      anon_sym_RBRACE,
    ACTIONS(377), 2,
      sym_ident,
      anon_sym_static,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2359] = 3,
    ACTIONS(383), 1,
      anon_sym_as,
    ACTIONS(381), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2372] = 4,
    ACTIONS(358), 1,
      sym_ident,
    ACTIONS(385), 1,
      anon_sym_RPAREN,
    STATE(104), 1,
      sym_named_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2387] = 4,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    STATE(149), 1,
      sym_args,
    STATE(153), 1,
      sym_input,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2402] = 2,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(336), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_GT,
  [2413] = 4,
    ACTIONS(344), 1,
      anon_sym_RBRACE,
    ACTIONS(387), 1,
      anon_sym_COMMA,
    STATE(86), 1,
      aux_sym_use_items_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2428] = 4,
    ACTIONS(358), 1,
      sym_ident,
    ACTIONS(389), 1,
      anon_sym_RBRACE,
    STATE(104), 1,
      sym_named_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2443] = 4,
    ACTIONS(389), 1,
      anon_sym_RBRACE,
    ACTIONS(391), 1,
      anon_sym_COMMA,
    STATE(77), 1,
      aux_sym_fields_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2458] = 4,
    ACTIONS(393), 1,
      anon_sym_COMMA,
    ACTIONS(396), 1,
      anon_sym_RBRACE,
    STATE(98), 1,
      aux_sym_variant_items_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2473] = 4,
    ACTIONS(398), 1,
      anon_sym_COMMA,
    ACTIONS(400), 1,
      anon_sym_RBRACE,
    STATE(101), 1,
      aux_sym_flags_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2488] = 4,
    ACTIONS(354), 1,
      sym_ident,
    ACTIONS(402), 1,
      anon_sym_RBRACE,
    STATE(136), 1,
      sym_variant_item,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2503] = 4,
    ACTIONS(404), 1,
      anon_sym_COMMA,
    ACTIONS(407), 1,
      anon_sym_RBRACE,
    STATE(101), 1,
      aux_sym_flags_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2518] = 4,
    ACTIONS(340), 1,
      anon_sym_RBRACE,
    ACTIONS(354), 1,
      sym_ident,
    STATE(136), 1,
      sym_variant_item,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2533] = 4,
    ACTIONS(358), 1,
      sym_ident,
    ACTIONS(409), 1,
      anon_sym_RBRACE,
    STATE(104), 1,
      sym_named_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2548] = 2,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(331), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
  [2559] = 4,
    ACTIONS(411), 1,
      anon_sym_COMMA,
    ACTIONS(413), 1,
      anon_sym_RBRACE,
    STATE(97), 1,
      aux_sym_fields_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2574] = 4,
    ACTIONS(415), 1,
      anon_sym_COMMA,
    ACTIONS(417), 1,
      anon_sym_RBRACE,
    STATE(110), 1,
      aux_sym_tps_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2589] = 4,
    ACTIONS(419), 1,
      anon_sym_COMMA,
    ACTIONS(421), 1,
      anon_sym_RBRACE,
    STATE(101), 1,
      aux_sym_flags_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2604] = 2,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(423), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
  [2615] = 4,
    ACTIONS(425), 1,
      anon_sym_COMMA,
    ACTIONS(427), 1,
      anon_sym_RBRACE,
    STATE(107), 1,
      aux_sym_flags_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2630] = 4,
    ACTIONS(51), 1,
      anon_sym_RBRACE,
    ACTIONS(429), 1,
      anon_sym_COMMA,
    STATE(78), 1,
      aux_sym_tps_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2645] = 3,
    ACTIONS(433), 1,
      anon_sym_RBRACE,
    ACTIONS(431), 2,
      sym_ident,
      anon_sym_static,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2658] = 4,
    ACTIONS(435), 1,
      anon_sym_COMMA,
    ACTIONS(437), 1,
      anon_sym_RBRACE,
    STATE(79), 1,
      aux_sym_variant_items_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2673] = 4,
    ACTIONS(439), 1,
      anon_sym_COMMA,
    ACTIONS(441), 1,
      anon_sym_RBRACE,
    STATE(99), 1,
      aux_sym_flags_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2688] = 4,
    ACTIONS(358), 1,
      sym_ident,
    ACTIONS(443), 1,
      anon_sym_RPAREN,
    STATE(104), 1,
      sym_named_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2703] = 4,
    ACTIONS(445), 1,
      anon_sym_COMMA,
    ACTIONS(447), 1,
      anon_sym_GT,
    STATE(87), 1,
      aux_sym_tps_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2718] = 4,
    ACTIONS(443), 1,
      anon_sym_RPAREN,
    ACTIONS(449), 1,
      anon_sym_COMMA,
    STATE(77), 1,
      aux_sym_fields_repeat1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2733] = 4,
    ACTIONS(342), 1,
      sym_ident,
    ACTIONS(451), 1,
      anon_sym_RBRACE,
    STATE(89), 1,
      sym_use_item,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2748] = 3,
    ACTIONS(453), 1,
      anon_sym_LBRACE,
    STATE(49), 1,
      sym_union_items,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2760] = 3,
    ACTIONS(455), 1,
      anon_sym_LT,
    STATE(25), 1,
      sym_tps,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2772] = 3,
    ACTIONS(342), 1,
      sym_ident,
    STATE(129), 1,
      sym_use_item,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2784] = 2,
    ACTIONS(457), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2794] = 3,
    ACTIONS(459), 1,
      sym_ident,
    ACTIONS(461), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2806] = 3,
    ACTIONS(463), 1,
      anon_sym_COMMA,
    ACTIONS(465), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2818] = 3,
    ACTIONS(354), 1,
      sym_ident,
    STATE(136), 1,
      sym_variant_item,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2830] = 3,
    ACTIONS(467), 1,
      anon_sym_LBRACE,
    STATE(44), 1,
      sym_flags,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2842] = 3,
    ACTIONS(421), 1,
      anon_sym_RBRACE,
    ACTIONS(469), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2854] = 3,
    ACTIONS(471), 1,
      sym_ident,
    STATE(111), 1,
      sym__func,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2866] = 3,
    ACTIONS(473), 1,
      sym_ident,
    ACTIONS(475), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2878] = 2,
    ACTIONS(367), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2888] = 2,
    ACTIONS(407), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2898] = 2,
    ACTIONS(477), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2908] = 3,
    ACTIONS(469), 1,
      sym_ident,
    ACTIONS(479), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2920] = 2,
    ACTIONS(481), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2930] = 3,
    ACTIONS(358), 1,
      sym_ident,
    STATE(104), 1,
      sym_named_ty,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2942] = 3,
    ACTIONS(98), 1,
      anon_sym_LT,
    STATE(27), 1,
      sym_tp1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2954] = 2,
    ACTIONS(396), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2964] = 3,
    ACTIONS(483), 1,
      anon_sym_LBRACE,
    STATE(46), 1,
      sym_variant_items,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2976] = 3,
    ACTIONS(400), 1,
      anon_sym_RBRACE,
    ACTIONS(469), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [2988] = 3,
    ACTIONS(98), 1,
      anon_sym_LT,
    STATE(28), 1,
      sym_tp1,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3000] = 3,
    ACTIONS(469), 1,
      sym_ident,
    ACTIONS(485), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3012] = 3,
    ACTIONS(487), 1,
      anon_sym_LBRACE,
    STATE(48), 1,
      sym_enum_items,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3024] = 3,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    STATE(65), 1,
      sym_fields,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3036] = 2,
    ACTIONS(491), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3045] = 2,
    ACTIONS(493), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3054] = 2,
    ACTIONS(495), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3063] = 2,
    ACTIONS(497), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3072] = 2,
    ACTIONS(499), 1,
      anon_sym_from,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3081] = 2,
    ACTIONS(501), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3090] = 2,
    ACTIONS(503), 1,
      anon_sym_DASH_GT,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3099] = 2,
    ACTIONS(505), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3108] = 2,
    ACTIONS(507), 1,
      anon_sym_from,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3117] = 2,
    ACTIONS(509), 1,
      anon_sym_COLON,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3126] = 2,
    ACTIONS(511), 1,
      anon_sym_DASH_GT,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3135] = 2,
    ACTIONS(469), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3144] = 2,
    ACTIONS(513), 1,
      anon_sym_func,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3153] = 2,
    ACTIONS(515), 1,
      anon_sym_from,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3162] = 2,
    ACTIONS(517), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3171] = 2,
    ACTIONS(519), 1,
      anon_sym_COLON,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3180] = 2,
    ACTIONS(521), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3189] = 2,
    ACTIONS(463), 1,
      anon_sym_COMMA,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3198] = 2,
    ACTIONS(523), 1,
      anon_sym_from,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3207] = 2,
    ACTIONS(525), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3216] = 2,
    ACTIONS(527), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3225] = 2,
    ACTIONS(529), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3234] = 2,
    ACTIONS(531), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3243] = 2,
    ACTIONS(533), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3252] = 2,
    ACTIONS(535), 1,
      sym_ident,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
  [3261] = 2,
    ACTIONS(537), 1,
      anon_sym_from,
    ACTIONS(3), 3,
      sym__whitespace,
      sym_line_comment,
      sym_block_comment,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 58,
  [SMALL_STATE(4)] = 112,
  [SMALL_STATE(5)] = 166,
  [SMALL_STATE(6)] = 220,
  [SMALL_STATE(7)] = 274,
  [SMALL_STATE(8)] = 328,
  [SMALL_STATE(9)] = 382,
  [SMALL_STATE(10)] = 433,
  [SMALL_STATE(11)] = 484,
  [SMALL_STATE(12)] = 535,
  [SMALL_STATE(13)] = 586,
  [SMALL_STATE(14)] = 637,
  [SMALL_STATE(15)] = 688,
  [SMALL_STATE(16)] = 739,
  [SMALL_STATE(17)] = 793,
  [SMALL_STATE(18)] = 847,
  [SMALL_STATE(19)] = 878,
  [SMALL_STATE(20)] = 909,
  [SMALL_STATE(21)] = 940,
  [SMALL_STATE(22)] = 965,
  [SMALL_STATE(23)] = 990,
  [SMALL_STATE(24)] = 1015,
  [SMALL_STATE(25)] = 1040,
  [SMALL_STATE(26)] = 1065,
  [SMALL_STATE(27)] = 1090,
  [SMALL_STATE(28)] = 1115,
  [SMALL_STATE(29)] = 1140,
  [SMALL_STATE(30)] = 1165,
  [SMALL_STATE(31)] = 1190,
  [SMALL_STATE(32)] = 1215,
  [SMALL_STATE(33)] = 1240,
  [SMALL_STATE(34)] = 1265,
  [SMALL_STATE(35)] = 1288,
  [SMALL_STATE(36)] = 1311,
  [SMALL_STATE(37)] = 1334,
  [SMALL_STATE(38)] = 1357,
  [SMALL_STATE(39)] = 1383,
  [SMALL_STATE(40)] = 1405,
  [SMALL_STATE(41)] = 1427,
  [SMALL_STATE(42)] = 1447,
  [SMALL_STATE(43)] = 1467,
  [SMALL_STATE(44)] = 1487,
  [SMALL_STATE(45)] = 1507,
  [SMALL_STATE(46)] = 1527,
  [SMALL_STATE(47)] = 1547,
  [SMALL_STATE(48)] = 1567,
  [SMALL_STATE(49)] = 1587,
  [SMALL_STATE(50)] = 1607,
  [SMALL_STATE(51)] = 1627,
  [SMALL_STATE(52)] = 1647,
  [SMALL_STATE(53)] = 1667,
  [SMALL_STATE(54)] = 1687,
  [SMALL_STATE(55)] = 1707,
  [SMALL_STATE(56)] = 1727,
  [SMALL_STATE(57)] = 1747,
  [SMALL_STATE(58)] = 1767,
  [SMALL_STATE(59)] = 1787,
  [SMALL_STATE(60)] = 1807,
  [SMALL_STATE(61)] = 1827,
  [SMALL_STATE(62)] = 1847,
  [SMALL_STATE(63)] = 1867,
  [SMALL_STATE(64)] = 1887,
  [SMALL_STATE(65)] = 1907,
  [SMALL_STATE(66)] = 1927,
  [SMALL_STATE(67)] = 1947,
  [SMALL_STATE(68)] = 1967,
  [SMALL_STATE(69)] = 1987,
  [SMALL_STATE(70)] = 2007,
  [SMALL_STATE(71)] = 2027,
  [SMALL_STATE(72)] = 2047,
  [SMALL_STATE(73)] = 2067,
  [SMALL_STATE(74)] = 2089,
  [SMALL_STATE(75)] = 2111,
  [SMALL_STATE(76)] = 2133,
  [SMALL_STATE(77)] = 2149,
  [SMALL_STATE(78)] = 2165,
  [SMALL_STATE(79)] = 2181,
  [SMALL_STATE(80)] = 2196,
  [SMALL_STATE(81)] = 2211,
  [SMALL_STATE(82)] = 2226,
  [SMALL_STATE(83)] = 2241,
  [SMALL_STATE(84)] = 2256,
  [SMALL_STATE(85)] = 2271,
  [SMALL_STATE(86)] = 2286,
  [SMALL_STATE(87)] = 2301,
  [SMALL_STATE(88)] = 2316,
  [SMALL_STATE(89)] = 2331,
  [SMALL_STATE(90)] = 2346,
  [SMALL_STATE(91)] = 2359,
  [SMALL_STATE(92)] = 2372,
  [SMALL_STATE(93)] = 2387,
  [SMALL_STATE(94)] = 2402,
  [SMALL_STATE(95)] = 2413,
  [SMALL_STATE(96)] = 2428,
  [SMALL_STATE(97)] = 2443,
  [SMALL_STATE(98)] = 2458,
  [SMALL_STATE(99)] = 2473,
  [SMALL_STATE(100)] = 2488,
  [SMALL_STATE(101)] = 2503,
  [SMALL_STATE(102)] = 2518,
  [SMALL_STATE(103)] = 2533,
  [SMALL_STATE(104)] = 2548,
  [SMALL_STATE(105)] = 2559,
  [SMALL_STATE(106)] = 2574,
  [SMALL_STATE(107)] = 2589,
  [SMALL_STATE(108)] = 2604,
  [SMALL_STATE(109)] = 2615,
  [SMALL_STATE(110)] = 2630,
  [SMALL_STATE(111)] = 2645,
  [SMALL_STATE(112)] = 2658,
  [SMALL_STATE(113)] = 2673,
  [SMALL_STATE(114)] = 2688,
  [SMALL_STATE(115)] = 2703,
  [SMALL_STATE(116)] = 2718,
  [SMALL_STATE(117)] = 2733,
  [SMALL_STATE(118)] = 2748,
  [SMALL_STATE(119)] = 2760,
  [SMALL_STATE(120)] = 2772,
  [SMALL_STATE(121)] = 2784,
  [SMALL_STATE(122)] = 2794,
  [SMALL_STATE(123)] = 2806,
  [SMALL_STATE(124)] = 2818,
  [SMALL_STATE(125)] = 2830,
  [SMALL_STATE(126)] = 2842,
  [SMALL_STATE(127)] = 2854,
  [SMALL_STATE(128)] = 2866,
  [SMALL_STATE(129)] = 2878,
  [SMALL_STATE(130)] = 2888,
  [SMALL_STATE(131)] = 2898,
  [SMALL_STATE(132)] = 2908,
  [SMALL_STATE(133)] = 2920,
  [SMALL_STATE(134)] = 2930,
  [SMALL_STATE(135)] = 2942,
  [SMALL_STATE(136)] = 2954,
  [SMALL_STATE(137)] = 2964,
  [SMALL_STATE(138)] = 2976,
  [SMALL_STATE(139)] = 2988,
  [SMALL_STATE(140)] = 3000,
  [SMALL_STATE(141)] = 3012,
  [SMALL_STATE(142)] = 3024,
  [SMALL_STATE(143)] = 3036,
  [SMALL_STATE(144)] = 3045,
  [SMALL_STATE(145)] = 3054,
  [SMALL_STATE(146)] = 3063,
  [SMALL_STATE(147)] = 3072,
  [SMALL_STATE(148)] = 3081,
  [SMALL_STATE(149)] = 3090,
  [SMALL_STATE(150)] = 3099,
  [SMALL_STATE(151)] = 3108,
  [SMALL_STATE(152)] = 3117,
  [SMALL_STATE(153)] = 3126,
  [SMALL_STATE(154)] = 3135,
  [SMALL_STATE(155)] = 3144,
  [SMALL_STATE(156)] = 3153,
  [SMALL_STATE(157)] = 3162,
  [SMALL_STATE(158)] = 3171,
  [SMALL_STATE(159)] = 3180,
  [SMALL_STATE(160)] = 3189,
  [SMALL_STATE(161)] = 3198,
  [SMALL_STATE(162)] = 3207,
  [SMALL_STATE(163)] = 3216,
  [SMALL_STATE(164)] = 3225,
  [SMALL_STATE(165)] = 3234,
  [SMALL_STATE(166)] = 3243,
  [SMALL_STATE(167)] = 3252,
  [SMALL_STATE(168)] = 3261,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [53] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 1),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2),
  [57] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(152),
  [60] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(82),
  [63] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(167),
  [66] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(166),
  [69] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(165),
  [72] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(163),
  [75] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(162),
  [78] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(145),
  [81] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(150),
  [84] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_result, 1),
  [86] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_result, 1),
  [88] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [90] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stream, 1),
  [92] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_stream, 1),
  [94] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_future, 1),
  [96] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_future, 1),
  [98] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [100] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tp2, 3),
  [102] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tp2, 3),
  [104] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stream, 2),
  [106] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_stream, 2),
  [108] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_future, 2),
  [110] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_future, 2),
  [112] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tps, 5),
  [114] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tps, 5),
  [116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple, 2),
  [118] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple, 2),
  [120] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_result, 2),
  [122] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_result, 2),
  [124] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2),
  [126] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2),
  [128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_option, 2),
  [130] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_option, 2),
  [132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tp1, 3),
  [134] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tp1, 3),
  [136] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ty, 1),
  [138] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ty, 1),
  [140] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tps, 3),
  [142] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tps, 3),
  [144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tps, 4),
  [146] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tps, 4),
  [148] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tp2, 5),
  [150] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tp2, 5),
  [152] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 3),
  [154] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_args, 3),
  [156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 4),
  [158] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_args, 4),
  [160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 2),
  [162] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_args, 2),
  [164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 5),
  [166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_args, 5),
  [168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item_resource, 2, .production_id = 2),
  [170] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item_resource, 2, .production_id = 2),
  [172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_output, 1),
  [176] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_output, 1),
  [178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__func, 6, .production_id = 3),
  [180] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__func, 6, .production_id = 3),
  [182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item_resource, 3, .production_id = 2),
  [184] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item_resource, 3, .production_id = 2),
  [186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_flags, 4),
  [188] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_flags, 4),
  [190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_items, 5),
  [192] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_items, 5),
  [194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item_flags, 3, .production_id = 2),
  [196] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item_flags, 3, .production_id = 2),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_items, 5),
  [200] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_items, 5),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item_variant, 3, .production_id = 2),
  [204] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item_variant, 3, .production_id = 2),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variant_items, 5),
  [208] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variant_items, 5),
  [210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item_enum, 3, .production_id = 2),
  [212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item_enum, 3, .production_id = 2),
  [214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item_union, 3, .production_id = 2),
  [216] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item_union, 3, .production_id = 2),
  [218] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_flags, 3),
  [220] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_flags, 3),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_flags, 5),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_flags, 5),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fields, 5),
  [228] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fields, 5),
  [230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item, 1),
  [232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item, 1),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item_use, 4, .production_id = 4),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item_use, 4, .production_id = 4),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item_func, 1, .production_id = 1),
  [240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item_func, 1, .production_id = 1),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variant_items, 3),
  [244] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variant_items, 3),
  [246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_items, 4),
  [248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_items, 4),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_items, 4),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_items, 4),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variant_items, 4),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variant_items, 4),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fields, 3),
  [260] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fields, 3),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_resource_items, 2),
  [264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_resource_items, 2),
  [266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item_type, 4, .production_id = 2),
  [268] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item_type, 4, .production_id = 2),
  [270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fields, 4),
  [272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fields, 4),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fields, 2),
  [276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fields, 2),
  [278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item_record, 3, .production_id = 2),
  [280] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item_record, 3, .production_id = 2),
  [282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_resource_items, 3),
  [284] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_resource_items, 3),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_flags, 2),
  [288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_flags, 2),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_items, 2),
  [292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_items, 2),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variant_items, 2),
  [296] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variant_items, 2),
  [298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_items, 3),
  [300] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_items, 3),
  [302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_items, 3),
  [304] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_items, 3),
  [306] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_items, 2),
  [308] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_items, 2),
  [310] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_resource_items_repeat1, 2), SHIFT_REPEAT(152),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_resource_items_repeat1, 2),
  [315] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_resource_items_repeat1, 2), SHIFT_REPEAT(127),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [320] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variant_item, 1, .production_id = 5),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [328] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fields_repeat1, 2), SHIFT_REPEAT(134),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fields_repeat1, 2),
  [333] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_tps_repeat1, 2), SHIFT_REPEAT(11),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tps_repeat1, 2),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [364] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_use_items_repeat1, 2), SHIFT_REPEAT(120),
  [367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_use_items_repeat1, 2),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [377] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 1, .production_id = 1),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 1, .production_id = 1),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_item, 1, .production_id = 3),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [393] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variant_items_repeat1, 2), SHIFT_REPEAT(124),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variant_items_repeat1, 2),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [404] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_flags_repeat1, 2), SHIFT_REPEAT(154),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_flags_repeat1, 2),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_ty, 3, .production_id = 8),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [431] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 2, .production_id = 7),
  [433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 2, .production_id = 7),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_item, 3, .production_id = 6),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variant_payload, 3),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [481] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variant_item, 2, .production_id = 5),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [491] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [499] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_items, 2),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [503] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input, 1),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [515] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_items, 5),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [523] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_items, 4),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_items, 3),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_wit(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_ident,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
