// Generated with hyprwire-scanner 0.2.1. Made with vaxry's keyboard and ❤️.
// hyprpaper_core

/*
 This protocol's authors' copyright notice is:


    BSD 3-Clause License

    Copyright (c) 2025, Hypr Development

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
        list of conditions and the following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.

    3. Neither the name of the copyright holder nor the names of its
        contributors may be used to endorse or promote products derived from
        this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
    DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  
*/


#pragma once

#include <functional>
#include "hyprpaper_core-spec.hpp"
    
class CHyprpaperCoreManagerObject {
  public:
    CHyprpaperCoreManagerObject(Hyprutils::Memory::CSharedPointer<Hyprwire::IObject>&& object);
    ~CHyprpaperCoreManagerObject();

    Hyprutils::Memory::CSharedPointer<Hyprwire::IObject> getObject() {
        return m_object.lock();
    }

    void setOnDestroy(std::function<void()>&& fn) {
        m_object->setOnDestroy(std::move(fn));
    }

    void error(uint32_t code, const std::string_view& sv) {
        m_object->error(code, sv);
    }


    void sendAddMonitor(const char* monitor_name);
            
    void sendRemoveMonitor(const char* monitor_name);
            
    void setGetWallpaperObject(std::function<void(uint32_t)>&& fn);
            
    void setDestroy(std::function<void()>&& fn);
            
  private:
	struct {
 std::function<void(uint32_t)> get_wallpaper_object;
 std::function<void()> destroy;
 } m_listeners;
        
    Hyprutils::Memory::CWeakPointer<Hyprwire::IObject> m_object;
};

class CHyprpaperWallpaperObject {
  public:
    CHyprpaperWallpaperObject(Hyprutils::Memory::CSharedPointer<Hyprwire::IObject>&& object);
    ~CHyprpaperWallpaperObject();

    Hyprutils::Memory::CSharedPointer<Hyprwire::IObject> getObject() {
        return m_object.lock();
    }

    void setOnDestroy(std::function<void()>&& fn) {
        m_object->setOnDestroy(std::move(fn));
    }

    void error(uint32_t code, const std::string_view& sv) {
        m_object->error(code, sv);
    }


    void sendSuccess();
            
    void sendFailed(uint32_t error);
            
    void setPath(std::function<void(const char*)>&& fn);
            
    void setFitMode(std::function<void(hyprpaperCoreWallpaperFitMode)>&& fn);
            
    void setMonitorName(std::function<void(const char*)>&& fn);
            
    void setApply(std::function<void()>&& fn);
            
    void setDestroy(std::function<void()>&& fn);
            
  private:
	struct {
 std::function<void(const char*)> path;
 std::function<void(hyprpaperCoreWallpaperFitMode)> fit_mode;
 std::function<void(const char*)> monitor_name;
 std::function<void()> apply;
 std::function<void()> destroy;
 } m_listeners;
        
    Hyprutils::Memory::CWeakPointer<Hyprwire::IObject> m_object;
};

class CHyprpaperCoreImpl : public Hyprwire::IProtocolServerImplementation {
  public:
    CHyprpaperCoreImpl(uint32_t version, std::function<void(Hyprutils::Memory::CSharedPointer<Hyprwire::IObject>)>&& bindFn);
    virtual ~CHyprpaperCoreImpl() = default;

    virtual Hyprutils::Memory::CSharedPointer<Hyprwire::IProtocolSpec> protocol();

    virtual std::vector<Hyprutils::Memory::CSharedPointer<Hyprwire::SServerObjectImplementation>> implementation();

  private:
    uint32_t m_version = 0;
    std::function<void(Hyprutils::Memory::CSharedPointer<Hyprwire::IObject>)> m_bindFn;
};
