/*
 * Variable code for the AxCrypt format.
 */

#include "arch.h"
#include "misc.h"
#include "common.h"

static struct fmt_tests axcrypt_tests[] = {
#ifdef VERSION_1_SUPPORT
	/*
	 * Formats can be,
	 *   $axcrypt$*version*iterations*salt*wrappedkey
	 *   $axcrypt$*version*iterations*salt*wrappedkey*key-file
	*/
	{"$axcrypt$*1*1337*0fd9e7e2f907f480f8af162564f8f94b*af10c88878ba4e2c89b12586f93b7802453121ee702bc362", "Bab00nmoNCo|\\|2$inge"},
	{"$axcrypt$*1*60000*7522aa07694d441e47f8faad8a8cb984*95e02b7ccbdc27c227a80d1307505d8b769e87b32f312aa1", "nuNuche<3rewshauv"},
	{"$axcrypt$*1*31014*3408ae91dddc0b1750ed4223fd843364*1cc0f8fa8d89f44d284d0562ac7e93848c86ce9605907129", "tr0pO$phere5apointzero"},
	// AxCrypt 1.7.3156.0 (AxCrypt2Go.exe)
	{"$axcrypt$*1*20000*f00875d0a137f83f2100fc8c9687ab25*2f73f1211af567b3fc2a6aebae7e1a508a34a31e6cca2ab0", "openwall"},
	{"$axcrypt$*1*20000*efd759ae68ae7edd709b9e1c2166d0f7*dcf4c1279b8e4d39475925b17f698c3ce39e9e7d82917272*68656c6c6f0a", "openwall123"},
	/* axcrypt created key-file */
	{"$axcrypt$*1*38574*ce4f58c1e85df1ea921df6d6c05439b4*3278c3c730f7887b1008e852e59997e2196710a5c6bc1813*66664a6b2074434a4520374d73592055626979204a6b755520736d6b4b20394e694a205548444320524578562065674b33202f42593d", "0v3rgo2|<fc!"},
	/* custom key-file */
	{"$axcrypt$*1*130885*8eb4d745f7ac3f7505bcf14e8ce7e3b4*5221a6e8277e90b0b4f16f7871fca02986fca55c0dec5e59*22486520646f65736e2774206c696b652047656f726765204d69636861656c3a20426f6f6f6f6f6f220d0a0d0a49206665656c20736f20756e737572650d0a417320492074616b6520796f75722068616e6420616e64206c65616420796f7520746f207468652062616e6365666c6f6f720d0a417320746865206d75736963207374617274732c20736f6d657468696e6720696e20796f757220657965730d0a43616c6c7320746f206d696e642074686520676f6c64656e2073637265656e0d0a416e6420616c6c206974277320736169642069732068690d0a0d0a49276d206e6576657220676f6e6e612064616e636520616761696e0d0a4775696c74792066656574206861766520676f74206e6f2072687974686d0d0a54686f7567682069742773206561737920746f2070726574656e640d0a49206b6e6f7720796f277265206e6f74206120666f6f6c0d0a0d0a53686f756c64277665206b6e6f776e20626574746572207468616e20746f206368656174206120667269656e640d0a416e6420776173746520746865206368616e636520746861742049277665206265656e20676976656e0d0a536f2049276d206e6576657220676f6e6e612064616e636520616761696e0d0a5468652077617920492064616e636564207769746820796f750d0a0d0a54696d652063616e206e65766572206d656e640d0a54686520636172656c657373207768697370657273206f66206120676f6f6420667269656e640d0a546f2074686520686561727420616e64206d696e640d0a49676e6f72616e6365206973206b696e640d0a54686572652773206e6f20636f6d666f727420696e207468652074727574680d0a5061696e20697320616c6c20796f75276c6c2066696e640d0a0d0a49276d206e6576657220676f6e6e612064616e636520616761696e0d0a4775696c74792066656574206861766520676f74206e6f2072687974686d0d0a54686f7567682069742773206561737920746f2070726574656e640d0a49206b6e6f7720796f75277265206e6f74206120666f6f6c0d0a0d0a492073686f756c64277665206b6e6f776e20626574746572207468616e20746f206368656174206120667269656e640d0a416e6420776173746520746865206368616e636520746861742049277665206265656e20676976656e0d0a536f2049276d206e6576657220676f6e6e612064616e636520616761696e0d0a5468652077617920492064616e636564207769746820796f750d0a0d0a4e6576657220776974686f757420796f7572206c6f76650d0a0d0a546f6e6967687420746865206d75736963207365656d7320736f206c6f75640d0a492077697368207468617420776520636f756c64206c6f736520746869732063726f77640d0a4d617962652069742773206265747465722074686973207761790d0a5765276420687572742065616368206f74686572207769746820746865207468696e677320776527642077616e7420746f207361790d0a0d0a576520636f756c642068617665206265656e20736f20676f6f6420746f6765746865720d0a576520636f756c642068617665206c6976656420746869732064616e636520666f72657665720d0a427574206e6f772077686f277320676f6e6e612064616e63652077697468206d650d0a506c6561736520737461790d0a0d0a416e642049276d206e6576657220676f6e6e612064616e636520616761696e0d0a4775696c74792066656574206861766520676f74206e6f2072687974686d0d0a54686f7567682069742773206561737920746f2070726574656e640d0a49206b6e6f7720796f75277265206e6f74206120666f6f6c0d0a0d0a53686f756c64277665206b6e6f776e20626574746572207468616e20746f206368656174206120667269656e640d0a416e6420776173746520746865206368616e636520746861742049277665206265656e20676976656e0d0a536f2049276d206e6576657220676f6e6e612064616e636520616761696e0d0a5468652077617920492064616e636564207769746820796f750d0a0d0a284e6f77207468617420796f7527726520676f6e6529204e6f77207468617420796f7527726520676f6e650d0a284e6f77207468617420796f7527726520676f6e65292057686174204920646964277320736f2077726f6e672c20736f2077726f6e670d0a5468617420796f752068616420746f206c65617665206d6520616c6f6e65", "careless whisper"},
#endif
#ifdef VERSION_2_SUPPORT
	{"$axcrypt$*2*28200*96fca6b5aff19cb540125e6452f1ab6e1cbf7097ad75326e7aa1726f687ed18e66a63295d735f458a138901be41d95d29ff760c7c4b4178320251f2ab0ecabd8*d1d90c425fd8e2d20b2aa7ef6f3ab9dcefad84917f9e07f65f8da61e7e84f490ba8007179718ce0033cbc887177c2b51ed00e88155741960ab667a5328f305969518bc436ee1ba28126a5be79b0b90f8a9c8a438cba9d0e59c0b6573cde124a8300a6fb01ff857485d302285f1eacd7f08d9cc70ec9fdf412b60bc5a728b5108ef8bda24caee5ab7cc4376951c080c6d*1000*fead8792ea352979ab19e7b287bf709f39df0706a7e460b5271d1ebc71014b3b", "openwall"},
	{"$axcrypt$*2*23652*8817291e0611409390c50a8bdc99a98bf56d393174d7c177082391f7919ed392a701783790ad2eed49139ede2b1546dc4a9aaa142e2b2530b4c82cff03df18b1*2561a0c3f5e166c7273ea6fb59592a58b8d8235a379c82de39fc6d674291b6a25a268732c34eab1b092166ca4f9ef9e383325b90633896890f7dca4d29876ec5bb232ff89c8130aad917f93d9228a091a9996e1f14d4b130b5aad7516c11aa9143730d7b0ec8168b4d83bdd0ca1a9a36784572b9db992bd13289ecd577a421ded0576801e88c7275b2d5fa8eb7e540cb*1000*3dc38e68204a7060c3cd616ffcf6df17dbbb3c199e67ea85c7e29751b9ea2fc2", "openwall123"},
#endif
	{NULL}
};
